// $Id: status_test.cc,v 1.1.1.1.2.1 2001/10/29 04:32:59 bbarrett Exp $
//
// Copyright 1997-2001, University of Notre Dame.
// Authors: Jeffrey M. Squyres, Jeremy G. Siek, Michael P. McNally, and
//          Andrew Lumsdaine
// 
// This file is part of the Notre Dame C++ bindings for MPI.
// 
// You should have received a copy of the License Agreement for the Notre
// Dame C++ bindings for MPI along with the software; see the file
// LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN 46556.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted subject to the conditions specified in the
// LICENSE file.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
// IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
// 
// Additional copyrights may follow.
//

#include "mpi2c++_test.h"

void
status_test()
{
  char msg[150];
  int get_err;
  int get_src;
  int get_tag;
  int set_err;
  int set_src;
  int set_tag;
  MPI::Status status;

  get_err = 0;
  get_src = 0;
  get_tag = 0;
  set_err = 1;
  set_src = 2;
  set_tag = 3;

  Testing("Set_source / Get_source");

  status.Set_source(set_src);
  get_src = status.Get_source();
  if(get_src != set_src) {
    sprintf(msg, "NODE %d - 1) ERROR in MPI::Status, source = %d, should be %d",
	    my_rank, get_src, set_src);
    Fail(msg);
  }

  Pass(); // Set_source / Get_source

  Testing("Set_tag / Get_tag");

  status.Set_tag(set_tag);
  get_tag = status.Get_tag();
  if(get_tag != set_tag) {
    sprintf(msg, "NODE %d - 1) ERROR in MPI::Status, tag = %d, should be %d",
	    my_rank, get_tag, set_tag);
    Fail(msg);
  }

  Pass(); // Set_tag / Get_tag

  Testing("Set_error / Get_error");

  status.Set_error(set_err);
  get_err = status.Get_error();
  if(get_err != set_err) {
    sprintf(msg, "NODE %d - 1) ERROR in MPI::Status, error = %d, should be %d",
	    my_rank, get_err, set_err);
    Fail(msg);
  }

  Pass(); // Set_error / Get_error
}
