/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Id: boot.h,v 1.4.2.1 2002/10/09 19:48:58 brbarret Exp $
 * 
 *	Function:	- constants associated with booting
 */

#ifndef _BOOT
#define _BOOT

#include <stdio.h>

#include <lamnet.h>
#include <all_list.h>


/*
 * default configuration files
 */
#define DEFFCONFIGH	"lam-conf.otb"

/*
 * default tools
 */
#define DEFTRESETH	"tkill"

/*
 * share/boot/inetexec.c
 */
int inetexec(char *host, char *username, char **argv, char *prefix,
	     int fl_fast);

/*
 * share/boot/bhostparse.c 
 */
int bhostparse(FILE *fp, struct lamnode **plamnet, int *pnlamnet);

/*
 * share/boot/lambootagent.c
 */
int lambootagent(struct lamnode *lamnet, int nlamnet, int *nboot, int *nrun);

/*
 * share/boot/psc_parse.c
 */
int psc_parse(FILE *fp, LIST **list_psc, char **argv_var);

#endif
