/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *
 *	$Id: tcp_low.h,v 1.1.2.1 2002/10/09 19:49:52 brbarret Exp $
 *
 *	Function:	- TCP client-to-client interface header
 */

#ifndef _TCP_LOW_H
#define _TCP_LOW_H

/*
 * public functions
 */
int			_tcp_advmultiple(void);
int			_tcp_adv1(void);
int			_tcp_proc_read_env(struct c2c_proc *ps);
int			_tcp_req_send_long(struct c2c_proc *ps,
					   MPI_Request req);
int			_tcp_req_send_short(struct c2c_proc *ps,
					    MPI_Request req);
int			_tcp_req_send_synch(struct c2c_proc *ps,
					    MPI_Request req);
int			_tcp_req_recv(struct c2c_proc *ps,
				      MPI_Request req);
int			_tcp_req_probe(struct c2c_proc *ps,
				       MPI_Request req);
int			_tcp_buffered_adv(MPI_Request req,
					  struct cbuf_msg *msg);
int			_tcp_fastsend(char *buf,
				      int  size,
				      struct c2c_proc *ps,
				      int dest,
				      int tag,
				      MPI_Comm comm);
int			_tcp_fastrecv(char *buf,
				      int *size,
				      struct c2c_proc *ps,
				      int src,
				      int *tag,
				      MPI_Comm comm,
				      int *seqnum);

/*
 * public variables
 */
extern int			_tcp_nio;	/* # processes doing tcp io */
extern int			_tcp_sockmax;	/* max. tcp io socket num. */
extern fd_set			_tcp_read;	/* read sockets */
extern fd_set			_tcp_write;	/* write sockets */
extern fd_set			_tcp_except;	/* exception sockets */
extern fd_set			_tcp_block;	/* blocked mode socket? */
extern fd_set			_tcp_eoferr;	/* eof on socket is error? */
extern MPI_Request		_tcp_lastreq;	/* last tcp request */
extern struct c2c_proc		*_tcp_smap[FD_SETSIZE];	/* maps socket fd to process */

#endif /* _TCP_LOW_H */
