#!/usr/bin/python
# -*- coding: utf-8 -*-
#################################################################################
# LAYMAN GIT OVERLAY HANDLER
#################################################################################
# File:       git.py
#
#             Handles git overlays
#
# Copyright:
#             (c) 2005 - 2006 Gunnar Wrobel, Stefan Schweizer
#             Distributed under the terms of the GNU General Public License v2
#
# Author(s):
#             Gunnar Wrobel <wrobel@gentoo.org>
#             Stefan Schweizer <genstef@gentoo.org>

__version__ = "$Id: git.py 146 2006-05-27 09:52:36Z wrobel $"

#===============================================================================
#
# Dependencies
#
#-------------------------------------------------------------------------------

from   layman.utils             import path
from   layman.overlays.overlay  import Overlay

from   layman.debug             import OUT

#===============================================================================
#
# Class GitOverlay
#
#-------------------------------------------------------------------------------

class GitOverlay(Overlay):
    ''' Handles git overlays.'''

    type = 'Git'

    binary_command  = '/usr/bin/git' 
    
    def add(self, base):

        self.supported()

        return self.cmd(self.binary_command + ' clone ' + self.src + '/ ' + 
                        path([base, self.name]))

    def sync(self, base):

        self.supported()

        return self.cmd('cd ' + path([base, self.name]) + ' && ' 
                        + self.binary_command + ' pull')

    def supported(self):

        return Overlay.supported(self, [(self.binary_command,  'git', 'dev-util/git'),])
