#!/usr/bin/python
# -*- coding: utf-8 -*-
#################################################################################
# LAYMAN SVN OVERLAY HANDLER
#################################################################################
# File:       svn.py
#
#             Handles subversion overlays
#
# Copyright:
#             (c) 2005 - 2006 Gunnar Wrobel
#             Distributed under the terms of the GNU General Public License v2
#
# Author(s):
#             Gunnar Wrobel <wrobel@gentoo.org>
#

__version__ = "$Id: svn.py 168 2006-06-26 22:37:29Z wrobel $"

#===============================================================================
#
# Dependencies
#
#-------------------------------------------------------------------------------

from   layman.utils             import path
from   layman.overlays.overlay  import Overlay

from   layman.debug             import OUT

#===============================================================================
#
# Class SvnOverlay
#
#-------------------------------------------------------------------------------

class SvnOverlay(Overlay):
    ''' Handles subversion overlays.'''

    type = 'Subversion'

    binary = '/usr/bin/svn' 
    
    def add(self, base):

        self.supported()

        Overlay.add(self, base)

        return self.cmd(self.binary + ' co ' + self.src + '/ ' + 
                        path([base, self.name]))

    def sync(self, base):

        self.supported()

        return self.cmd(self.binary + ' update ' + path([base, self.name]))

    def supported(self):
        
        return Overlay.supported(self, [(self.binary,  'svn', 'dev-util/subversion'),])
        
