#!/usr/bin/python
# -*- coding: utf-8 -*-
#################################################################################
# LAYMAN DOCTEST AGGREGATOR
#################################################################################
# File:       dtest.py
#
#             Combines the doctests that are available for the different modules
#
# Copyright:
#             (c) 2005 Pardus
#             Distributed under the terms of the GNU General Public License v2
#
# Author(s):
#             Gunnar Wrobel <wrobel@pardus.de>
#
# $Id$
'''Aggregates doctests from all modules that provide such tests.'''

__version__ = '$Id$'

import unittest, doctest, sys

import layman.db
import layman.overlay
import layman.utils
import layman.overlays.tar

def test_suite():
    return unittest.TestSuite((
#        doctest.DocTestSuite(layman.db),
        doctest.DocTestSuite(layman.overlay),
        doctest.DocTestSuite(layman.utils),
        doctest.DocTestSuite(layman.overlays.tar),
        ))

if __name__ == '__main__':
    # Ignore warnings here. We are just testing
    from warnings     import filterwarnings, resetwarnings
    filterwarnings('ignore')

    unittest.main(defaultTest='test_suite')

    resetwarnings()
