# Copyright 1999-2006 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: $

inherit eutils distutils

DESCRIPTION="A python script for retrieving gentoo overlays "
HOMEPAGE="http://projects.gunnarwrobel.de/scripts"
SRC_URI="http://dev.gentoo.org/~wrobel/layman/${PF}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~x86"
IUSE=""
S=${WORKDIR}/${PF}

DEPEND="dev-util/subversion"

src_install() {

	distutils_src_install

	dodir /etc/layman
	cp etc/* ${D}/etc/layman/

	doman doc/layman.8
	dohtml doc/layman.8.html
}

src_test() {
	cd ${S}
	einfo "Running layman doctests..."
	if ! PYTHONPATH="." ${python} layman/tests/dtest.py; then
		eerror "DocTests failed - please submit a bug report"
		die "DocTesting failed!"
	fi
}

#FIXME: Add source /usr/portage/local/layman/make.conf in make.conf as postinstall instruction
