#!/usr/bin/python
# -*- coding: utf-8 -*-
#################################################################################
# LAYMAN G-SORCERY OVERLAY HANDLER
#################################################################################
# File:       g_sorcery.py
#
#             Handles repositories generated by g-sorcery backends
#
# Copyright:
#             (c) 2013 Gentoo Foundation
#             Distributed under the terms of the GNU General Public License v2
#
# Author(s):
#             Jauhien Piatlicki <piatlicki@gmail.com>
#             Auke Booij <auke@tulcod.com>
#
''' g-sorcery repository support.'''

from __future__ import unicode_literals

#===============================================================================
#
# Dependencies
#
#-------------------------------------------------------------------------------

import os
from   layman.utils             import path, run_command
from   layman.overlays.source   import OverlaySource, require_supported

#===============================================================================
#
# Class GSorceryOverlay
#
#-------------------------------------------------------------------------------

class GSorceryOverlay(OverlaySource):
    ''' Handles g-sorcery repositories.'''

    type = 'g-sorcery'
    type_key = 'g-sorcery'

    def __init__(self, parent, config, _location, ignore = 0):
        super(GSorceryOverlay, self).__init__(parent, config,
            _location, ignore)
        #split source into backend and repository.
        self.backend=self.src[:self.src.find(' ')]
        self.repository=self.src[self.src.find(' ')+1:]
        self.branch = None

    def add(self, base):
        '''Add overlay.'''

        if not self.supported():
            return 1

        target = path([base, self.parent.name])

        os.makedirs(target)

        return self.sync(base)

    def sync(self, base):
        '''Sync overlay.'''

        if not self.supported():
            return 1

        target = path([base, self.parent.name])

        args = [self.backend, '-o', target, '-r', self.repository, 'sync']
        returncode = run_command(self.config, self.command(), args,
                                 cwd=target)
        if returncode:
            return returncode
        args = [self.backend, '-o', target, 'generate-tree']
        return self.postsync(
            run_command(self.config, self.command(), args, cwd=target,
                        cmd=self.type),
            cwd=target)

    def supported(self):
        '''Overlay type supported?'''

        return require_supported(
            [(self.command(),
             'g-sorcery',
             'app-portage/g-sorcery'),

             ('/usr/bin/' + self.backend,
              self.backend,
              'app-portage/' + self.backend),],

              self.output.warn)
