'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbChangeMap __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbChangeMap \- Update only partial components of a keyboard description, modify 
the appropriate fields in the server and map components of a local copy of the 
keyboard description
.SH SYNOPSIS
.B Bool XkbChangeMap
(
.I dpy,
.I xkb,
.I changes
)
.br
      Display * \fIdpy\fP\^;
.br
      XkbDescPtr \fIxkb\fP\^;
.br
      XkbMapChangesPtr \fIchanges\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- dpy
connection to X server
.TP
.I \- xkb
description from which new values are taken
.TP
.I \- changes
identifies component parts to update
.SH DESCRIPTION
.LP
To update only partial components of a keyboard description, modify the 
appropriate fields in the server and map components of a local copy of the 
keyboard description, then call 
.I XkbChangeMap 
with an XkbMapChangesRec structure indicating which components have changed.

.I XkbChangeMap 
copies any components specified by the 
.I changes 
structure from the keyboard description, 
.I xkb, 
to the X server specified by 
.I dpy.

If any components specified by 
.I changes 
are not present in the 
.I xkb 
parameter, 
.I XkbChangeMap 
returns False. Otherwise, it sends a request to the server and returns True. 

.I XkbChangeMap 
can generate BadAlloc, BadLength, and BadValue protocol errors. 
.SH "RETURN VALUES"
.TP 15
True
The XkbChangeMap function returns True if the components specified by 
.I changes 
are present in the 
.I xkb 
parameter.
.TP 15
False
The XkbChangeMap function returns False if the components specified by 
.I changes 
are not present in the 
.I xkb 
parameter.
.SH STRUCTURES
.LP
Use the XkbMapChangesRec structure to identify and track partial modifications 
to the mapping components and to reduce the amount of traffic between the server 
and clients.
.nf

typedef struct _XkbMapChanges {
    unsigned short   changed;            /\(** identifies valid components in 
structure */
    KeyCode          min_key_code;       /\(** lowest numbered keycode for device 
*/
    KeyCode          max_key_code;       /\(** highest numbered keycode for device 
*/
    unsigned char    first_type;         /\(** index of first key type modified */
    unsigned char    num_types;          /\(** # types modified */
    KeyCode          first_key_sym;      /\(** first key whose key_sym_map changed 
*/
    unsigned char    num_key_syms;       /\(** # key_sym_map entries changed */
    KeyCode          first_key_act;      /\(** first key whose key_acts entry 
changed */
    unsigned char    num_key_acts;       /\(** # key_acts entries changed */
    KeyCode          first_key_behavior; /\(** first key whose behaviors changed */
    unsigned char    num_key_behaviors;  /\(** # behaviors entries changed */
    KeyCode          first_key_explicit; /\(** first key whose explicit entry 
changed */
    unsigned char    num_key_explicit;   /\(** # explicit entries changed */
    KeyCode          first_modmap_key;   /\(** first key whose modmap entry changed 
*/
    unsigned char    num_modmap_keys;    /\(** # modmap entries changed */
    KeyCode          first_vmodmap_key;  /\(** first key whose vmodmap changed */
    unsigned char    num_vmodmap_keys;   /\(** # vmodmap entries changed */
    unsigned char    pad1;               /\(** reserved */
    unsigned short   vmods;              /\(** mask indicating which vmods changed 
*/
} XkbMapChangesRec,*XkbMapChangesPtr;

.fi
.SH DIAGNOSTICS
.TP 15
.B BadAlloc
Unable to allocate storage
.TP 15
.B BadLength
The length of a request is shorter or longer than that required to minimally 
contain the arguments
.TP 15
.B BadValue
An argument is out of range
