'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbKeyNumSyms __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbKeyNumSyms \- Returns the total number of keysyms for the key corresponding 
to 
.I keycode
.SH SYNOPSIS
.B int XkbKeyNumSyms macro
(
.I xkb,
.I keycode
)
.br
      XkbDescPtr \fIxkb\fP\^;
.br
      KeyCode \fIkeycode\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- xkb
Xkb description of interest
.TP
.I \- keycode
keycode of interest
.SH DESCRIPTION
.LP
The key width and number of groups associated with a key are used to form a 
small two-dimensional array of KeySyms for a key. This array may be different 
sizes for different keys. The array for a single key is stored as a linear list, 
in row-major order. The arrays for all of the keys are stored in the 
.I syms 
field of the client map. There is one row for each group associated with a key 
and one column for each level. The index corresponding to a given group and 
shift level is computed as:
.nf

     idx = group_index * key_width + shift_level
     
.fi
The 
.I offset 
field of the 
.I key_sym_map 
entry for a key is used to access the beginning of the array.

.I XkbKeyNumSyms 
returns the total number of keysyms for the key corresponding to 
.I keycode.
