'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbChangeControls __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbChangeControls \- Provides a flexible method for updating the controls in a 
server to match those in 
the changed keyboard description
.SH SYNOPSIS
.HP
.B Bool XkbChangeControls
.BI "(\^Display *" "dpy" "\^,"
.BI "XkbDescPtr " "xkb" "\^,"
.BI "XkbControlsChangesPtr " "changes" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- dpy
connection to X server
.TP
.I \- xkb
keyboard description with changed xkb->ctrls
.TP
.I \- changes
which parts of xkb->ctrls have changed
.SH DESCRIPTION
.LP
The XkbControlsChangesRec structure allows applications to track modifications 
to an XkbControlsRec 
structure and thereby reduce the amount of traffic sent to the server. The same 
XkbControlsChangesRec 
structure may be used in several successive modifications to the same 
XkbControlsRec structure, then 
subsequently used to cause all of the changes, and only the changes, to be 
propagated to the server. 

The 
.I changed_ctrls 
field is a mask specifying which logical sets of data in the controls structure 
have been modified. In 
this context, modified means 
.I set, 
that is, if a value is set to the same value it previously contained, it has 
still been modified, and is 
noted as changed. Valid values for 
.I changed_ctrls 
are any combination of the masks listed in Table 1 that have "ok" in the 
.I changed_ctrls 
column. Setting a bit implies the corresponding data fields from the "Relevant 
XkbControlsRec Data 
Fields" column in Table 1 have been modified. The 
.I enabled_ctrls_changes 
field specifies which bits in the 
.I enabled_ctrls 
field have changed. If the number of keyboard groups has changed, the 
.I num_groups_changed 
field is set to True.

Table 1 shows the actual values for the individual mask bits used to select 
controls for 
modification and to enable and disable the control. Note that the same mask bit 
is used to 
specify general modifications to the parameters used to configure the control 
(which), and to 
enable and disable the control (enabled_ctrls). The anomalies in the table (no 
"ok" in column) 
are for controls that have no configurable attributes; and for controls that are 
not boolean 
controls and therefore cannot be enabled or disabled.

.TS
c s s s s
l l l l l
l l l l l
l l l l l
l l l l l
lw(1.5i) lw(1.5i) l lw(1.5i) l.
Table 1 Xkb Controls
_
Control	Control
	Selection	Relevant
	Mask	XkbControlsRec	Boolean Control
	(which parameter)	DataFields	enabled_ctrls bit	Section
_	 
T{
AccessXFeedback
T}	T{
XkbAccessXFeedbackMask
T}	ax_options:	T{
XkbAccessXFeedbackMask
T}	10.6.3
		  XkbAX_*FBMask
T{
AccessXKeys
T}			T{
XkbAccessXKeysMask
T}	10.6.1
T{
AccessXTimeout
T}	T{
XkbAccessXTimeoutMask
T}	ax_timeout	T{
XkbAccessXTimeoutMask
T}	10.6.2
		axt_opts_mask
		axt_opts_values
		axt_ctrls_mask
		axt_ctrls_values
T{
AudibleBell
T}			T{
XkbAudibleBellMask
T}	9.2
T{
AutoReset
T}				10.1.2
T{
BounceKeys
T}	T{
XkbBounceKeysMask
T}	debounce_delay	T{
XkbBounceKeysMask
T}	10.6.7
T{
Detectable-
T}				10.3.3
T{
Autorepeat
T}
T{
EnabledControls
T}	T{
XkbControlsEnabledMask
T}	enabled_ctrls	T{
Non-Boolean Control
T}	10.1.1
T{
GroupsWrap
T}	T{
XkbGroupsWrapMask
T}	groups_wrap	T{
Non-Boolean Control
T}	10.7.1
T{
IgnoreGroupLock
T}			T{
XkbIgnoreGroupLockMask
T}	10.7.3
T{
IgnoreLockMods
T}	T{
XkbIgnoreLockModsMask
T}	ignore_lock	T{
Non-Boolean Control
T}	5.1
T{
InternalMods
T}	T{
XkbInternalModsMask
T}	internal	T{
Non-Boolean Control
T}	5.1
T{
MouseKeys
T}	T{
XkbMouseKeysMask
T}	mk_dflt_btn	T{
XkbMouseKeysMask
T}	10.5.1
T{
MouseKeysAccel
T}	T{
XkbMouseKeysAccelMask
T}	mk_delay	T{
XkbMouseKeysAccelMask
T}	10.5.2
		mk_interval
		mk_time_to_max
		mk_max_speed
		mk_curve
T{
Overlay1
T}			T{
XkbOverlay1Mask
T}	10.4
T{
Overlay2
T}			T{
XkbOverlay2Mask
T}	10.4
T{
PerKeyRepeat
T}	T{
XkbPerKeyRepeatMask
T}	per_key_repeat	T{
Non-Boolean Control
T}	10.3.1
T{
RepeatKeys
T}	T{
XkbRepeatKeysMask
T}	repeat_delay	T{
XkbRepeatKeysMask
T}	10.3
			repeat_interval
T{
SlowKeys
T}	T{
XkbSlowKeysMask
T}	slow_keys_delay	T{
XkbSlowKeysMask
T}	10.6.6
T{
StickyKeys
T}	T{
XkbStickyKeysMask
T}	ax_options:	T{
XkbStickyKeysMask
T}	10.6.8
		  XkbAX_TwoKeysMask
		  XkbAX_LatchToLockMask
.TE			  

Table 2 shows the actual values for the individual mask bits used to select 
controls for 
modification and to enable and disable the control. Note that the same mask bit 
is used to 
specify general modifications to the parameters used to configure the control 
(which), and to 
enable and disable the control (enabled_ctrls). The anomalies in the table (no 
"ok" in column) 
are for controls that have no configurable attributes; and for controls that are 
not boolean 
controls and therefore cannot be enabled or disabled.

.TS
c s s s
l l l l
l l l l
l l l l. 
Table 2 Controls Mask Bits
_
Mask Bit	which or	enabled	Value
	changed_ctrls	_ctrls
_
XkbRepeatKeysMask	ok	ok	(1L<<0)
XkbSlowKeysMask	ok	ok	(1L<<1)
XkbBounceKeysMask	ok	ok	(1L<<2)
XkbStickyKeysMask	ok	ok	(1L<<3)
XkbMouseKeysMask	ok	ok	(1L<<4)
XkbMouseKeysAccelMask	ok	ok	(1L<<5)
XkbAccessXKeysMask	ok	ok	(1L<<6)
XkbAccessXTimeoutMask	ok	ok	(1L<<7)
XkbAccessXFeedbackMask	ok	ok	(1L<<8)
XkbAudibleBellMask		ok	(1L<<9)
XkbOverlay1Mask		ok	(1L<<10)
XkbOverlay2Mask		ok	(1L<<11)
XkbIgnoreGroupLockMask		ok	(1L<<12)
XkbGroupsWrapMask	ok		(1L<<27)
XkbInternalModsMask	ok		(1L<<28)
XkbIgnoreLockModsMask	ok		(1L<<29)
XkbPerKeyRepeatMask	ok		(1L<<30)
XkbControlsEnabledMask	ok		(1L<<31)
XkbAccessXOptionsMask	ok	ok	(XkbStickyKeysMask | 
			XkbAccessXFeedbackMask)
XkbAllBooleanCtrlsMask		ok	(0x00001FFF) 
XkbAllControlsMask	ok		(0xF8001FFF)
.TE




If you have an Xkb description with controls that have been modified and an 
XkbControlsChangesRec that 
describes the changes that have been made, the 
.I XkbChangeControls 
function provides a flexible method for updating the controls in a server to 
match those in the changed 
keyboard description.

.I XkbChangeControls 
copies any controls fields specified by 
.I changes 
from the keyboard description controls structure, 
.I xkb->ctrls, 
to the server specified by 
.I dpy.
.SH STRUCTURES
.LP
The XkbControlsChangesRec structure is defined as follows:
.nf

typedef struct _XkbControlsChanges {
    unsigned int  changed_ctrls;         /\(** bits indicating changed control data 
*/
    unsigned int  enabled_ctrls_changes; /\(** bits indicating enabled/disabled 
controls */
    Bool          num_groups_changed;    /\(** True if number of keyboard groups 
changed */
} XkbControlsChangesRec,*XkbControlsChangesPtr;

.fi
