.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbGetStickyKeysOptions __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetStickyKeysOptions \- Queries the current StickyKeys attributes for a keyboard device
.SH SYNOPSIS
.HP
.B Bool XkbGetStickyKeysOptions
.BI "(\^Display *" "display" "\^,"
.BI "unsigned int " "device_spec" "\^,"
.BI "unsigned int *" "options_rtrn" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- display
connection to X server
.TP
.I \- device_spec
device ID, or XkbUseCoreKbd
.TP
.I \- options_rtrn
backfilled with StickyKeys option mask
.SH DESCRIPTION
.LP
The StickyKeys control has two options that can be accessed via the 
.I ax_options 
of an XkbControlsRec structure. The first option, TwoKeys, specifies whether StickyKeys should 
automatically turn off when two keys are pressed at the same time. This feature is useful for 
shared computers so people who do not want them do not need to turn StickyKeys off if a previous 
user left StickyKeys on. The second option, LatchToLock, specifies whether or not StickyKeys 
locks a modifier when pressed twice in a row.

.I XkbGetStickyKeysOptions 
requests the attributes of the StickyKeys control from the server, waits for a reply, and 
backfills 
.I options_rtrn 
with a mask indicating whether the individual StickyKeys options are on or off. Valid bits in 
.I options_rtrn 
are:
.nf

     XkbAX_TwoKeysMask
     XkbAX_LatchToLockMask
     
.fi     
.I XkbGetStickyKeysOptions 
returns True if successful; if a compatible version of the Xkb extension is not available in the 
server 
.I XkbGetStickyKeysOptions 
returns False.
.SH "RETURN VALUES"
.TP 15
True
The 
.I XkbGetStickyKeysOptions 
function returns True if the request for the attributes of the StickyKeys control from the 
server was successful.
.TP 15
False
The 
.I XkbGetStickyKeysOptions 
function returns False if a compatible version of the Xkb extension is not available in the 
server. 
.SH STRUCTURES
.nf
The XkbControlsRec structure is defined as follows:

    #define XkbMaxLegalKeyCode     255
    #define XkbPerKeyBitArraySize  ((XkbMaxLegalKeyCode+1)/8)
    
    typedef struct {
        unsigned char   mk_dflt_btn;      /\&* default button for keyboard driven mouse */
        unsigned char   num_groups;       /\&* number of keyboard groups */
        unsigned char   groups_wrap;      /\&* how to wrap out-of-bounds groups */
        XkbModsRec      internal;         /\&* defines server internal modifiers */
        XkbModsRec      ignore_lock;      /\&* modifiers to ignore when checking for grab */
        unsigned int    enabled_ctrls;    /\&* 1 bit => corresponding boolean control enabled */
        unsigned short  repeat_delay;     /\&* ms delay until first repeat */
        unsigned short  repeat_interval;  /\&* ms delay between repeats */
        unsigned short  slow_keys_delay;  /\&* ms minimum time key must be down to be ok */
        unsigned short  debounce_delay;   /\&* ms delay before key reactivated */
        unsigned short  mk_delay;         /\&* ms delay to second mouse motion event */
        unsigned short  mk_interval;      /\&* ms delay between repeat mouse events */
        unsigned short  mk_time_to_max;   /\&* # intervals until constant mouse move */
        unsigned short  mk_max_speed;     /\&* multiplier for maximum mouse speed */
        short           mk_curve;         /\&* determines mouse move curve type */
        unsigned short  ax_options;       /\&* 1 bit => Access X option enabled */
        unsigned short  ax_timeout;       /\&* seconds until Access X disabled */
        unsigned short  axt_opts_mask;    /\&* 1 bit => options to reset on Access X timeout */
        unsigned short  axt_opts_values;  /\&* 1 bit => turn option on, 0=> off */
        unsigned int    axt_ctrls_mask;   /\&* which bits in enabled_ctrls to modify */
        unsigned int    axt_ctrls_values; /\&* values for new bits in enabled_ctrls */
        unsigned char   per_key_repeat[XkbPerKeyBitArraySize];  /\&* per key auto repeat */
     } XkbControlsRec, *XkbControlsPtr;
.fi
