/*
 *  text          canvas text import/export
 *  Copyright (c) 2006 Sam Hocevar <sam@zoy.org>
 *                All Rights Reserved
 *
 *  $Id: text.c 829 2006-09-17 12:44:18Z jylam $
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the Do What The Fuck You Want To
 *  Public License, Version 2, as published by Sam Hocevar. See
 *  http://sam.zoy.org/wtfpl/COPYING for more details.
 */

#include "config.h"
#include "common.h"
#if !defined(__KERNEL__)
#   if defined(HAVE_INTTYPES_H)
#      include <inttypes.h>
#   endif
#   include <stdio.h>
#   include <string.h>
#endif
#include "cucul.h"

#define STRING \
  "Hello world!\n" \
  "  _,----._  \n" \
  " (/ @  @ \\) \n" \
  "  |  OO  |  \n" \
  "  \\ `--' /  \n" \
  "   `----'   \n"

int main(int argc, char *argv[])
{
    cucul_canvas_t *cv;
    cucul_buffer_t *buffer;

    buffer = cucul_load_memory(STRING, strlen(STRING));
    cv = cucul_import_canvas(buffer, "text");
    cucul_free_buffer(buffer);

    buffer = cucul_export_canvas(cv, "utf8");
    fwrite(cucul_get_buffer_data(buffer),
           cucul_get_buffer_size(buffer), 1, stdout);
    cucul_free_buffer(buffer);

    cucul_rotate(cv);

    buffer = cucul_export_canvas(cv, "utf8");
    fwrite(cucul_get_buffer_data(buffer),
           cucul_get_buffer_size(buffer), 1, stdout);
    cucul_free_buffer(buffer);

    cucul_free_canvas(cv);

    return 0;
}

