/*
    $Id: cd_types.h,v 1.1 2003/08/16 15:34:58 rocky Exp $

    Copyright (C) 2003 Rocky Bernstein <rocky@panix.com>
    Copyright (C) 1996,1997,1998  Gerd Knorr <kraxel@bytesex.org>
         and       Heiko Eifeldt <heiko@hexco.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
   Filesystem types we understand. The highest-numbered fs type should
   be less than CDIO_FS_MASK defined below.
*/

#ifndef __CDIO_CD_TYPES_H__
#define __CDIO_CD_TYPES_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define CDIO_FS_NO_DATA              0   /* audio only */
#define CDIO_FS_HIGH_SIERRA	     1
#define CDIO_FS_ISO_9660	     2
#define CDIO_FS_INTERACTIVE	     3
#define CDIO_FS_HFS		     4
#define CDIO_FS_UFS		     5
#define CDIO_FS_EXT2		     6
#define CDIO_FS_ISO_HFS              7  /* both hfs & isofs filesystem */
#define CDIO_FS_ISO_9660_INTERACTIVE 8  /* both CD-RTOS and isofs filesystem */
#define CDIO_FS_3DO		     9

#define CDIO_FS_MASK		    15  /* Should be 2*n-1 and > above */
#define CDIO_FS_UNKNOWN	            CDIO_FS_MASK

/* Macro to extract just the FS type portion defined above */
#define CDIO_FSTYPE(fs) (fs & CDIO_FS_MASK)

/* 
   Bit masks for the classes of CD-images. These are generally
   higher-level than the fs-type information above and may be determined
   based of the fs type information.
 */
#define CDIO_FS_ANAL_XA		        16
#define CDIO_FS_ANAL_MULTISESSION	32
#define CDIO_FS_ANAL_PHOTO_CD	        64
#define CDIO_FS_ANAL_HIDDEN_TRACK      128
#define CDIO_FS_ANAL_CDTV	       256
#define CDIO_FS_ANAL_BOOTABLE          512
#define CDIO_FS_ANAL_VIDEOCDI         1024
#define CDIO_FS_ANAL_ROCKRIDGE        2048
#define CDIO_FS_ANAL_JOLIET           4096
#define CDIO_FS_ANAL_SVCD             8192   /* Super VCD or Choiji Video CD */
#define CDIO_FS_ANAL_CVD       	     16384   /* Choiji Video CD */


typedef int cdio_fs_anal_t;

typedef struct 
{
  unsigned int  joliet_level;
  char          iso_label[33]; /* 32 + 1 for null byte at the end in 
				  formatting the string */
  unsigned int  isofs_size;
} cdio_analysis_t;

/* 
   Try to determine what kind of CD-image and/or filesystem we
   have at track track_num. Return information about the CD image
   is returned in cdio_analysis and the return value.
*/
cdio_fs_anal_t cdio_guess_cd_type(/*in*/ CdIo *cdio, int start_session, 
				  track_t track_num, 
				  /*out*/ cdio_analysis_t *cdio_analysis);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __CDIO_CD_TYPES_H__ */

/* 
 * Local variables:
 *  c-file-style: "gnu"
 *  tab-width: 8
 *  indent-tabs-mode: nil
 * End:
 */
