#!/bin/sh
#$Id: check_cue.sh.in,v 1.8 2003/09/01 02:02:59 rocky Exp $
if test -z "-L/usr/local/lib -lcddb  " ; then
  cddb_opt='--no-cddb'
fi

if test -z "-L/usr/local/lib -lvcdinfo -lvcd -liso9660 -lcdio  " ; then
  vcd_opt='--no-vcd'
fi

if test -z $srcdir ; then
  srcdir=`pwd`
fi

. ${srcdir}/check_common_fn

if ! test -x ../src/cd-info ; then
  exit 77
fi

BASE=`basename $0 .sh`

fname=cdda
testnum=CD-DA
test_cdinfo "--cue-file ${srcdir}/${fname}.cue $cddb_opt" \
  ${fname}.dump ${srcdir}/${fname}.right
RC=$?
check_result $RC "cdinfo CUE test $testnum"

test_cdinfo "--bin-file ${srcdir}/${fname}.bin $cddb_opt" \
  ${fname}.dump ${srcdir}/${fname}.right
RC=$?
check_result $RC "cdinfo BIN test $testnum"

fname=isofs-m1
testnum='ISO 9660 mode1'
if test -f  ${srcdir}/${fname}.bin ; then
  test_cdinfo "--cue-file ${srcdir}/${fname}.cue --iso9660 " \
    ${fname}.dump ${srcdir}/${fname}.right
  RC=$?
  check_result $RC "cdinfo CUE test $testnum"
else 
  echo "Don't see CUE file ${srcdir}/${fname}.bin. Test $testum skipped."
fi

fname=vcd_demo
testnum='Video CD'
if test -f ${srcdir}/${fname}.cue ; then
  test_cdinfo "-c ${srcdir}/vcd_demo.cue $vcd_opt --iso9660" \
      ${fname}.dump ${srcdir}/${fname}.right
  RC=$?
  check_result $RC "cdinfo CUE test $testnum"
else 
  echo "Don't see CUE file ${srcdir}/${fname}.cue. Test $testum skipped."
fi

fname=svcd_ogt_test_ntsc
testnum='Super Video CD'
if test -f ${srcdir}/${fname}.bin ; then
  test_cdinfo "--cue-file ${srcdir}/${fname}.cue $vcd_opt --iso9660 " \
    ${fname}.dump ${srcdir}/${fname}.right
  RC=$?
  check_result $RC "cdinfo CUE test $testnum"
else 
  echo "Don't see CUE file ${srcdir}/${fname}.bin. Test $testnum skipped."
fi

exit $RC

#;;; Local Variables: ***
#;;; mode:shell-script ***
#;;; eval: (sh-set-shell "bash") ***
#;;; End: ***
