/*
 * Decompiled with CFR 0.152.
 */
package com.dogecoin.dogecoinj.protocols.payments;

import com.dogecoin.dogecoinj.protocols.payments.PaymentProtocolException;
import com.dogecoin.dogecoinj.protocols.payments.PaymentSession;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bitcoin.protocols.payments.Protos;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.Utils;
import org.bitcoinj.crypto.X509Utils;
import org.bitcoinj.script.ScriptBuilder;

public class PaymentProtocol {
    public static final String MIMETYPE_PAYMENTREQUEST = "application/vnd.doge.payment.request";
    public static final String MIMETYPE_PAYMENT = "application/vnd.doge.payment.payment";
    public static final String MIMETYPE_PAYMENTACK = "application/vnd.doge.payment.ack";

    public static Protos.PaymentRequest.Builder createPaymentRequest(NetworkParameters params, @Nullable Coin amount, Address toAddress, @Nullable String memo, @Nullable String paymentUrl, @Nullable byte[] merchantData) {
        return PaymentProtocol.createPaymentRequest(params, (List<Protos.Output>)ImmutableList.of((Object)PaymentProtocol.createPayToAddressOutput(amount, toAddress)), memo, paymentUrl, merchantData);
    }

    public static Protos.PaymentRequest.Builder createPaymentRequest(NetworkParameters params, List<Protos.Output> outputs, @Nullable String memo, @Nullable String paymentUrl, @Nullable byte[] merchantData) {
        Protos.PaymentDetails.Builder paymentDetails = Protos.PaymentDetails.newBuilder();
        paymentDetails.setNetwork(params.getPaymentProtocolId());
        for (Protos.Output output : outputs) {
            paymentDetails.addOutputs(output);
        }
        if (memo != null) {
            paymentDetails.setMemo(memo);
        }
        if (paymentUrl != null) {
            paymentDetails.setPaymentUrl(paymentUrl);
        }
        if (merchantData != null) {
            paymentDetails.setMerchantData(ByteString.copyFrom((byte[])merchantData));
        }
        paymentDetails.setTime(Utils.currentTimeSeconds());
        Protos.PaymentRequest.Builder paymentRequest = Protos.PaymentRequest.newBuilder();
        paymentRequest.setSerializedPaymentDetails(paymentDetails.build().toByteString());
        return paymentRequest;
    }

    public static PaymentSession parsePaymentRequest(Protos.PaymentRequest paymentRequest) throws PaymentProtocolException {
        return new PaymentSession(paymentRequest, false, null);
    }

    public static void signPaymentRequest(Protos.PaymentRequest.Builder paymentRequest, X509Certificate[] certificateChain, PrivateKey privateKey) {
        try {
            Protos.X509Certificates.Builder certificates = Protos.X509Certificates.newBuilder();
            for (X509Certificate certificate : certificateChain) {
                certificates.addCertificate(ByteString.copyFrom((byte[])certificate.getEncoded()));
            }
            paymentRequest.setPkiType("x509+sha256");
            paymentRequest.setPkiData(certificates.build().toByteString());
            paymentRequest.setSignature(ByteString.EMPTY);
            Protos.PaymentRequest paymentRequestToSign = paymentRequest.build();
            if (!privateKey.getAlgorithm().equalsIgnoreCase("RSA")) {
                throw new IllegalStateException(privateKey.getAlgorithm());
            }
            String algorithm = "SHA256withRSA";
            Signature signature = Signature.getInstance(algorithm);
            signature.initSign(privateKey);
            signature.update(paymentRequestToSign.toByteArray());
            paymentRequest.setSignature(ByteString.copyFrom((byte[])signature.sign()));
        }
        catch (GeneralSecurityException x) {
            throw new RuntimeException(x);
        }
    }

    @Nullable
    public static PkiVerificationData verifyPaymentRequestPki(Protos.PaymentRequest paymentRequest, KeyStore trustStore) throws PaymentProtocolException {
        ArrayList certs = null;
        try {
            String algorithm;
            String pkiType = paymentRequest.getPkiType();
            if (pkiType.equals("none")) {
                return null;
            }
            if (pkiType.equals("x509+sha256")) {
                algorithm = "SHA256withRSA";
            } else if (pkiType.equals("x509+sha1")) {
                algorithm = "SHA1withRSA";
            } else {
                throw new PaymentProtocolException.InvalidPkiType("Unsupported PKI type: " + pkiType);
            }
            Protos.X509Certificates protoCerts = Protos.X509Certificates.parseFrom((ByteString)paymentRequest.getPkiData());
            if (protoCerts.getCertificateCount() == 0) {
                throw new PaymentProtocolException.InvalidPkiData("No certificates provided in message: server config error");
            }
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            certs = Lists.newArrayList();
            for (ByteString bytes : protoCerts.getCertificateList()) {
                certs.add((X509Certificate)certificateFactory.generateCertificate(bytes.newInput()));
            }
            CertPath path = certificateFactory.generateCertPath(certs);
            PKIXParameters params = new PKIXParameters(trustStore);
            params.setRevocationEnabled(false);
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)validator.validate(path, params);
            PublicKey publicKey = result.getPublicKey();
            Signature signature = Signature.getInstance(algorithm);
            signature.initVerify(publicKey);
            Protos.PaymentRequest.Builder reqToCheck = paymentRequest.toBuilder();
            reqToCheck.setSignature(ByteString.EMPTY);
            signature.update(reqToCheck.build().toByteArray());
            if (!signature.verify(paymentRequest.getSignature().toByteArray())) {
                throw new PaymentProtocolException.PkiVerificationException("Invalid signature, this payment request is not valid.");
            }
            X509Certificate cert = (X509Certificate)certs.get(0);
            String displayName = X509Utils.getDisplayNameFromCertificate((X509Certificate)cert, (boolean)true);
            if (displayName == null) {
                throw new PaymentProtocolException.PkiVerificationException("Could not extract name from certificate");
            }
            return new PkiVerificationData(displayName, publicKey, result.getTrustAnchor());
        }
        catch (InvalidProtocolBufferException e) {
            throw new PaymentProtocolException.InvalidPkiData((Exception)((Object)e));
        }
        catch (CertificateException e) {
            throw new PaymentProtocolException.PkiVerificationException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
        catch (CertPathValidatorException e) {
            throw new PaymentProtocolException.PkiVerificationException(e, certs);
        }
        catch (InvalidKeyException e) {
            throw new PaymentProtocolException.PkiVerificationException(e);
        }
        catch (SignatureException e) {
            throw new PaymentProtocolException.PkiVerificationException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static Protos.Payment createPaymentMessage(List<Transaction> transactions, @Nullable Coin refundAmount, @Nullable Address refundAddress, @Nullable String memo, @Nullable byte[] merchantData) {
        if (refundAddress != null) {
            if (refundAmount == null) {
                throw new IllegalArgumentException("Specify refund amount if refund address is specified.");
            }
            return PaymentProtocol.createPaymentMessage(transactions, (List<Protos.Output>)ImmutableList.of((Object)PaymentProtocol.createPayToAddressOutput(refundAmount, refundAddress)), memo, merchantData);
        }
        return PaymentProtocol.createPaymentMessage(transactions, null, memo, merchantData);
    }

    public static Protos.Payment createPaymentMessage(List<Transaction> transactions, @Nullable List<Protos.Output> refundOutputs, @Nullable String memo, @Nullable byte[] merchantData) {
        Protos.Payment.Builder builder = Protos.Payment.newBuilder();
        for (Transaction transaction : transactions) {
            transaction.verify();
            builder.addTransactions(ByteString.copyFrom((byte[])transaction.unsafeBitcoinSerialize()));
        }
        if (refundOutputs != null) {
            for (Protos.Output output : refundOutputs) {
                builder.addRefundTo(output);
            }
        }
        if (memo != null) {
            builder.setMemo(memo);
        }
        if (merchantData != null) {
            builder.setMerchantData(ByteString.copyFrom((byte[])merchantData));
        }
        return builder.build();
    }

    public static List<Transaction> parseTransactionsFromPaymentMessage(NetworkParameters params, Protos.Payment paymentMessage) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>(paymentMessage.getTransactionsCount());
        for (ByteString transaction : paymentMessage.getTransactionsList()) {
            transactions.add(new Transaction(params, transaction.toByteArray()));
        }
        return transactions;
    }

    public static Protos.PaymentACK createPaymentAck(Protos.Payment paymentMessage, @Nullable String memo) {
        Protos.PaymentACK.Builder builder = Protos.PaymentACK.newBuilder();
        builder.setPayment(paymentMessage);
        if (memo != null) {
            builder.setMemo(memo);
        }
        return builder.build();
    }

    public static Ack parsePaymentAck(Protos.PaymentACK paymentAck) {
        String memo = paymentAck.hasMemo() ? paymentAck.getMemo() : null;
        return new Ack(memo);
    }

    public static Protos.Output createPayToAddressOutput(@Nullable Coin amount, Address address) {
        Protos.Output.Builder output = Protos.Output.newBuilder();
        if (amount != null) {
            if (amount.compareTo(NetworkParameters.MAX_MONEY) > 0) {
                throw new IllegalArgumentException("Amount too big: " + amount);
            }
            output.setAmount(amount.value);
        } else {
            output.setAmount(0L);
        }
        output.setScript(ByteString.copyFrom((byte[])ScriptBuilder.createOutputScript((Address)address).getProgram()));
        return output.build();
    }

    public static class Output
    implements Serializable {
        @Nullable
        public final Coin amount;
        public final byte[] scriptData;

        public Output(@Nullable Coin amount, byte[] scriptData) {
            this.amount = amount;
            this.scriptData = scriptData;
        }
    }

    public static class Ack {
        @Nullable
        private final String memo;

        Ack(@Nullable String memo) {
            this.memo = memo;
        }

        @Nullable
        public String getMemo() {
            return this.memo;
        }
    }

    public static class PkiVerificationData {
        public final String displayName;
        public final PublicKey merchantSigningKey;
        public final TrustAnchor rootAuthority;
        public final String rootAuthorityName;

        private PkiVerificationData(@Nullable String displayName, PublicKey merchantSigningKey, TrustAnchor rootAuthority) throws PaymentProtocolException.PkiVerificationException {
            try {
                this.displayName = displayName;
                this.merchantSigningKey = merchantSigningKey;
                this.rootAuthority = rootAuthority;
                this.rootAuthorityName = X509Utils.getDisplayNameFromCertificate((X509Certificate)rootAuthority.getTrustedCert(), (boolean)true);
            }
            catch (CertificateParsingException x) {
                throw new PaymentProtocolException.PkiVerificationException(x);
            }
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("displayName", (Object)this.displayName).add("rootAuthorityName", (Object)this.rootAuthorityName).add("merchantSigningKey", (Object)this.merchantSigningKey).add("rootAuthority", (Object)this.rootAuthority).toString();
        }
    }
}

