/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.DigestEngine;

abstract class BMWBigCore
extends DigestEngine {
    private long[] M;
    private long[] H;
    private long[] H2;
    private long[] Q;
    private long[] W;
    private static final long[] FINAL = new long[]{-6148914691236517216L, -6148914691236517215L, -6148914691236517214L, -6148914691236517213L, -6148914691236517212L, -6148914691236517211L, -6148914691236517210L, -6148914691236517209L, -6148914691236517208L, -6148914691236517207L, -6148914691236517206L, -6148914691236517205L, -6148914691236517204L, -6148914691236517203L, -6148914691236517202L, -6148914691236517201L};
    private static final long[] K = new long[]{0x5555555555555550L, 0x5AAAAAAAAAAAAAA5L, 0x5FFFFFFFFFFFFFFAL, 7301836195843364175L, 0x6AAAAAAAAAAAAAA4L, 0x6FFFFFFFFFFFFFF9L, 8454757700450211150L, 0x7AAAAAAAAAAAAAA3L, 0x7FFFFFFFFFFFFFF8L, -8839064868652493491L, -8454757700450211166L, -8070450532247928841L, -7686143364045646516L, -7301836195843364191L, -6917529027641081866L, -6533221859438799541L};

    BMWBigCore() {
    }

    @Override
    public int getBlockLength() {
        return 128;
    }

    protected Digest copyState(BMWBigCore dst) {
        System.arraycopy(this.H, 0, dst.H, 0, this.H.length);
        return super.copyState(dst);
    }

    @Override
    protected void engineReset() {
        long[] iv = this.getInitVal();
        System.arraycopy(iv, 0, this.H, 0, iv.length);
    }

    abstract long[] getInitVal();

    private void compress(long[] m) {
        int u;
        long[] h = this.H;
        long[] q = this.Q;
        long[] w = this.W;
        w[0] = (m[5] ^ h[5]) - (m[7] ^ h[7]) + (m[10] ^ h[10]) + (m[13] ^ h[13]) + (m[14] ^ h[14]);
        w[1] = (m[6] ^ h[6]) - (m[8] ^ h[8]) + (m[11] ^ h[11]) + (m[14] ^ h[14]) - (m[15] ^ h[15]);
        w[2] = (m[0] ^ h[0]) + (m[7] ^ h[7]) + (m[9] ^ h[9]) - (m[12] ^ h[12]) + (m[15] ^ h[15]);
        w[3] = (m[0] ^ h[0]) - (m[1] ^ h[1]) + (m[8] ^ h[8]) - (m[10] ^ h[10]) + (m[13] ^ h[13]);
        w[4] = (m[1] ^ h[1]) + (m[2] ^ h[2]) + (m[9] ^ h[9]) - (m[11] ^ h[11]) - (m[14] ^ h[14]);
        w[5] = (m[3] ^ h[3]) - (m[2] ^ h[2]) + (m[10] ^ h[10]) - (m[12] ^ h[12]) + (m[15] ^ h[15]);
        w[6] = (m[4] ^ h[4]) - (m[0] ^ h[0]) - (m[3] ^ h[3]) - (m[11] ^ h[11]) + (m[13] ^ h[13]);
        w[7] = (m[1] ^ h[1]) - (m[4] ^ h[4]) - (m[5] ^ h[5]) - (m[12] ^ h[12]) - (m[14] ^ h[14]);
        w[8] = (m[2] ^ h[2]) - (m[5] ^ h[5]) - (m[6] ^ h[6]) + (m[13] ^ h[13]) - (m[15] ^ h[15]);
        w[9] = (m[0] ^ h[0]) - (m[3] ^ h[3]) + (m[6] ^ h[6]) - (m[7] ^ h[7]) + (m[14] ^ h[14]);
        w[10] = (m[8] ^ h[8]) - (m[1] ^ h[1]) - (m[4] ^ h[4]) - (m[7] ^ h[7]) + (m[15] ^ h[15]);
        w[11] = (m[8] ^ h[8]) - (m[0] ^ h[0]) - (m[2] ^ h[2]) - (m[5] ^ h[5]) + (m[9] ^ h[9]);
        w[12] = (m[1] ^ h[1]) + (m[3] ^ h[3]) - (m[6] ^ h[6]) - (m[9] ^ h[9]) + (m[10] ^ h[10]);
        w[13] = (m[2] ^ h[2]) + (m[4] ^ h[4]) + (m[7] ^ h[7]) + (m[10] ^ h[10]) + (m[11] ^ h[11]);
        w[14] = (m[3] ^ h[3]) - (m[5] ^ h[5]) + (m[8] ^ h[8]) - (m[11] ^ h[11]) - (m[12] ^ h[12]);
        w[15] = (m[12] ^ h[12]) - (m[4] ^ h[4]) - (m[6] ^ h[6]) - (m[9] ^ h[9]) + (m[13] ^ h[13]);
        for (u = 0; u < 15; u += 5) {
            q[u + 0] = (w[u + 0] >>> 1 ^ w[u + 0] << 3 ^ BMWBigCore.circularLeft(w[u + 0], 4) ^ BMWBigCore.circularLeft(w[u + 0], 37)) + h[u + 1];
            q[u + 1] = (w[u + 1] >>> 1 ^ w[u + 1] << 2 ^ BMWBigCore.circularLeft(w[u + 1], 13) ^ BMWBigCore.circularLeft(w[u + 1], 43)) + h[u + 2];
            q[u + 2] = (w[u + 2] >>> 2 ^ w[u + 2] << 1 ^ BMWBigCore.circularLeft(w[u + 2], 19) ^ BMWBigCore.circularLeft(w[u + 2], 53)) + h[u + 3];
            q[u + 3] = (w[u + 3] >>> 2 ^ w[u + 3] << 2 ^ BMWBigCore.circularLeft(w[u + 3], 28) ^ BMWBigCore.circularLeft(w[u + 3], 59)) + h[u + 4];
            q[u + 4] = (w[u + 4] >>> 1 ^ w[u + 4]) + h[u + 5];
        }
        q[15] = (w[15] >>> 1 ^ w[15] << 3 ^ BMWBigCore.circularLeft(w[15], 4) ^ BMWBigCore.circularLeft(w[15], 37)) + h[0];
        for (u = 16; u < 18; ++u) {
            q[u] = (q[u - 16] >>> 1 ^ q[u - 16] << 2 ^ BMWBigCore.circularLeft(q[u - 16], 13) ^ BMWBigCore.circularLeft(q[u - 16], 43)) + (q[u - 15] >>> 2 ^ q[u - 15] << 1 ^ BMWBigCore.circularLeft(q[u - 15], 19) ^ BMWBigCore.circularLeft(q[u - 15], 53)) + (q[u - 14] >>> 2 ^ q[u - 14] << 2 ^ BMWBigCore.circularLeft(q[u - 14], 28) ^ BMWBigCore.circularLeft(q[u - 14], 59)) + (q[u - 13] >>> 1 ^ q[u - 13] << 3 ^ BMWBigCore.circularLeft(q[u - 13], 4) ^ BMWBigCore.circularLeft(q[u - 13], 37)) + (q[u - 12] >>> 1 ^ q[u - 12] << 2 ^ BMWBigCore.circularLeft(q[u - 12], 13) ^ BMWBigCore.circularLeft(q[u - 12], 43)) + (q[u - 11] >>> 2 ^ q[u - 11] << 1 ^ BMWBigCore.circularLeft(q[u - 11], 19) ^ BMWBigCore.circularLeft(q[u - 11], 53)) + (q[u - 10] >>> 2 ^ q[u - 10] << 2 ^ BMWBigCore.circularLeft(q[u - 10], 28) ^ BMWBigCore.circularLeft(q[u - 10], 59)) + (q[u - 9] >>> 1 ^ q[u - 9] << 3 ^ BMWBigCore.circularLeft(q[u - 9], 4) ^ BMWBigCore.circularLeft(q[u - 9], 37)) + (q[u - 8] >>> 1 ^ q[u - 8] << 2 ^ BMWBigCore.circularLeft(q[u - 8], 13) ^ BMWBigCore.circularLeft(q[u - 8], 43)) + (q[u - 7] >>> 2 ^ q[u - 7] << 1 ^ BMWBigCore.circularLeft(q[u - 7], 19) ^ BMWBigCore.circularLeft(q[u - 7], 53)) + (q[u - 6] >>> 2 ^ q[u - 6] << 2 ^ BMWBigCore.circularLeft(q[u - 6], 28) ^ BMWBigCore.circularLeft(q[u - 6], 59)) + (q[u - 5] >>> 1 ^ q[u - 5] << 3 ^ BMWBigCore.circularLeft(q[u - 5], 4) ^ BMWBigCore.circularLeft(q[u - 5], 37)) + (q[u - 4] >>> 1 ^ q[u - 4] << 2 ^ BMWBigCore.circularLeft(q[u - 4], 13) ^ BMWBigCore.circularLeft(q[u - 4], 43)) + (q[u - 3] >>> 2 ^ q[u - 3] << 1 ^ BMWBigCore.circularLeft(q[u - 3], 19) ^ BMWBigCore.circularLeft(q[u - 3], 53)) + (q[u - 2] >>> 2 ^ q[u - 2] << 2 ^ BMWBigCore.circularLeft(q[u - 2], 28) ^ BMWBigCore.circularLeft(q[u - 2], 59)) + (q[u - 1] >>> 1 ^ q[u - 1] << 3 ^ BMWBigCore.circularLeft(q[u - 1], 4) ^ BMWBigCore.circularLeft(q[u - 1], 37)) + (BMWBigCore.circularLeft(m[u - 16 + 0 & 0xF], (u - 16 + 0 & 0xF) + 1) + BMWBigCore.circularLeft(m[u - 16 + 3 & 0xF], (u - 16 + 3 & 0xF) + 1) - BMWBigCore.circularLeft(m[u - 16 + 10 & 0xF], (u - 16 + 10 & 0xF) + 1) + K[u - 16] ^ h[u - 16 + 7 & 0xF]);
        }
        for (u = 18; u < 32; ++u) {
            q[u] = q[u - 16] + BMWBigCore.circularLeft(q[u - 15], 5) + q[u - 14] + BMWBigCore.circularLeft(q[u - 13], 11) + q[u - 12] + BMWBigCore.circularLeft(q[u - 11], 27) + q[u - 10] + BMWBigCore.circularLeft(q[u - 9], 32) + q[u - 8] + BMWBigCore.circularLeft(q[u - 7], 37) + q[u - 6] + BMWBigCore.circularLeft(q[u - 5], 43) + q[u - 4] + BMWBigCore.circularLeft(q[u - 3], 53) + (q[u - 2] >>> 1 ^ q[u - 2]) + (q[u - 1] >>> 2 ^ q[u - 1]) + (BMWBigCore.circularLeft(m[u - 16 + 0 & 0xF], (u - 16 + 0 & 0xF) + 1) + BMWBigCore.circularLeft(m[u - 16 + 3 & 0xF], (u - 16 + 3 & 0xF) + 1) - BMWBigCore.circularLeft(m[u - 16 + 10 & 0xF], (u - 16 + 10 & 0xF) + 1) + K[u - 16] ^ h[u - 16 + 7 & 0xF]);
        }
        long xl = q[16] ^ q[17] ^ q[18] ^ q[19] ^ q[20] ^ q[21] ^ q[22] ^ q[23];
        long xh = xl ^ q[24] ^ q[25] ^ q[26] ^ q[27] ^ q[28] ^ q[29] ^ q[30] ^ q[31];
        h[0] = (xh << 5 ^ q[16] >>> 5 ^ m[0]) + (xl ^ q[24] ^ q[0]);
        h[1] = (xh >>> 7 ^ q[17] << 8 ^ m[1]) + (xl ^ q[25] ^ q[1]);
        h[2] = (xh >>> 5 ^ q[18] << 5 ^ m[2]) + (xl ^ q[26] ^ q[2]);
        h[3] = (xh >>> 1 ^ q[19] << 5 ^ m[3]) + (xl ^ q[27] ^ q[3]);
        h[4] = (xh >>> 3 ^ q[20] << 0 ^ m[4]) + (xl ^ q[28] ^ q[4]);
        h[5] = (xh << 6 ^ q[21] >>> 6 ^ m[5]) + (xl ^ q[29] ^ q[5]);
        h[6] = (xh >>> 4 ^ q[22] << 6 ^ m[6]) + (xl ^ q[30] ^ q[6]);
        h[7] = (xh >>> 11 ^ q[23] << 2 ^ m[7]) + (xl ^ q[31] ^ q[7]);
        h[8] = BMWBigCore.circularLeft(h[4], 9) + (xh ^ q[24] ^ m[8]) + (xl << 8 ^ q[23] ^ q[8]);
        h[9] = BMWBigCore.circularLeft(h[5], 10) + (xh ^ q[25] ^ m[9]) + (xl >>> 6 ^ q[16] ^ q[9]);
        h[10] = BMWBigCore.circularLeft(h[6], 11) + (xh ^ q[26] ^ m[10]) + (xl << 6 ^ q[17] ^ q[10]);
        h[11] = BMWBigCore.circularLeft(h[7], 12) + (xh ^ q[27] ^ m[11]) + (xl << 4 ^ q[18] ^ q[11]);
        h[12] = BMWBigCore.circularLeft(h[0], 13) + (xh ^ q[28] ^ m[12]) + (xl >>> 3 ^ q[19] ^ q[12]);
        h[13] = BMWBigCore.circularLeft(h[1], 14) + (xh ^ q[29] ^ m[13]) + (xl >>> 4 ^ q[20] ^ q[13]);
        h[14] = BMWBigCore.circularLeft(h[2], 15) + (xh ^ q[30] ^ m[14]) + (xl >>> 7 ^ q[21] ^ q[14]);
        h[15] = BMWBigCore.circularLeft(h[3], 16) + (xh ^ q[31] ^ m[15]) + (xl >>> 2 ^ q[22] ^ q[15]);
    }

    @Override
    protected void doPadding(byte[] output, int outputOffset) {
        int i;
        byte[] buf = this.getBlockBuffer();
        int ptr = this.flush();
        long bitLen = (this.getBlockCount() << 10) + (long)(ptr << 3);
        buf[ptr++] = -128;
        if (ptr > 120) {
            for (i = ptr; i < 128; ++i) {
                buf[i] = 0;
            }
            this.processBlock(buf);
            ptr = 0;
        }
        for (i = ptr; i < 120; ++i) {
            buf[i] = 0;
        }
        BMWBigCore.encodeLELong(bitLen, buf, 120);
        this.processBlock(buf);
        long[] tmp = this.H;
        this.H = this.H2;
        this.H2 = tmp;
        System.arraycopy(FINAL, 0, this.H, 0, 16);
        this.compress(this.H2);
        int outLen = this.getDigestLength() >>> 3;
        int i2 = 0;
        int j = 16 - outLen;
        while (i2 < outLen) {
            BMWBigCore.encodeLELong(this.H[j], output, outputOffset + 8 * i2);
            ++i2;
            ++j;
        }
    }

    @Override
    protected void doInit() {
        this.M = new long[16];
        this.H = new long[16];
        this.H2 = new long[16];
        this.W = new long[16];
        this.Q = new long[32];
        this.engineReset();
    }

    private static final void encodeLELong(long val, byte[] buf, int off) {
        buf[off + 0] = (byte)val;
        buf[off + 1] = (byte)(val >>> 8);
        buf[off + 2] = (byte)(val >>> 16);
        buf[off + 3] = (byte)(val >>> 24);
        buf[off + 4] = (byte)(val >>> 32);
        buf[off + 5] = (byte)(val >>> 40);
        buf[off + 6] = (byte)(val >>> 48);
        buf[off + 7] = (byte)(val >>> 56);
    }

    private static final long decodeLELong(byte[] buf, int off) {
        return (long)buf[off + 0] & 0xFFL | ((long)buf[off + 1] & 0xFFL) << 8 | ((long)buf[off + 2] & 0xFFL) << 16 | ((long)buf[off + 3] & 0xFFL) << 24 | ((long)buf[off + 4] & 0xFFL) << 32 | ((long)buf[off + 5] & 0xFFL) << 40 | ((long)buf[off + 6] & 0xFFL) << 48 | ((long)buf[off + 7] & 0xFFL) << 56;
    }

    private static final long circularLeft(long x, int n) {
        return x << n | x >>> 64 - n;
    }

    @Override
    protected void processBlock(byte[] data) {
        for (int i = 0; i < 16; ++i) {
            this.M[i] = BMWBigCore.decodeLELong(data, i * 8);
        }
        this.compress(this.M);
    }

    @Override
    public String toString() {
        return "BMW-" + (this.getDigestLength() << 3);
    }
}

