/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.DigestEngine;

abstract class BMWSmallCore
extends DigestEngine {
    private int[] M;
    private int[] H;
    private int[] H2;
    private int[] Q;
    private static final int[] FINAL = new int[]{-1431655776, -1431655775, -1431655774, -1431655773, -1431655772, -1431655771, -1431655770, -1431655769, -1431655768, -1431655767, -1431655766, -1431655765, -1431655764, -1431655763, -1431655762, -1431655761};

    BMWSmallCore() {
    }

    @Override
    public int getBlockLength() {
        return 64;
    }

    protected Digest copyState(BMWSmallCore dst) {
        System.arraycopy(this.H, 0, dst.H, 0, this.H.length);
        return super.copyState(dst);
    }

    @Override
    protected void engineReset() {
        int[] iv = this.getInitVal();
        System.arraycopy(iv, 0, this.H, 0, iv.length);
    }

    abstract int[] getInitVal();

    private void compress(int[] m) {
        int[] h = this.H;
        int[] q = this.Q;
        q[0] = ((m[5] ^ h[5]) - (m[7] ^ h[7]) + (m[10] ^ h[10]) + (m[13] ^ h[13]) + (m[14] ^ h[14]) >>> 1 ^ (m[5] ^ h[5]) - (m[7] ^ h[7]) + (m[10] ^ h[10]) + (m[13] ^ h[13]) + (m[14] ^ h[14]) << 3 ^ BMWSmallCore.circularLeft((m[5] ^ h[5]) - (m[7] ^ h[7]) + (m[10] ^ h[10]) + (m[13] ^ h[13]) + (m[14] ^ h[14]), 4) ^ BMWSmallCore.circularLeft((m[5] ^ h[5]) - (m[7] ^ h[7]) + (m[10] ^ h[10]) + (m[13] ^ h[13]) + (m[14] ^ h[14]), 19)) + h[1];
        q[1] = ((m[6] ^ h[6]) - (m[8] ^ h[8]) + (m[11] ^ h[11]) + (m[14] ^ h[14]) - (m[15] ^ h[15]) >>> 1 ^ (m[6] ^ h[6]) - (m[8] ^ h[8]) + (m[11] ^ h[11]) + (m[14] ^ h[14]) - (m[15] ^ h[15]) << 2 ^ BMWSmallCore.circularLeft((m[6] ^ h[6]) - (m[8] ^ h[8]) + (m[11] ^ h[11]) + (m[14] ^ h[14]) - (m[15] ^ h[15]), 8) ^ BMWSmallCore.circularLeft((m[6] ^ h[6]) - (m[8] ^ h[8]) + (m[11] ^ h[11]) + (m[14] ^ h[14]) - (m[15] ^ h[15]), 23)) + h[2];
        q[2] = ((m[0] ^ h[0]) + (m[7] ^ h[7]) + (m[9] ^ h[9]) - (m[12] ^ h[12]) + (m[15] ^ h[15]) >>> 2 ^ (m[0] ^ h[0]) + (m[7] ^ h[7]) + (m[9] ^ h[9]) - (m[12] ^ h[12]) + (m[15] ^ h[15]) << 1 ^ BMWSmallCore.circularLeft((m[0] ^ h[0]) + (m[7] ^ h[7]) + (m[9] ^ h[9]) - (m[12] ^ h[12]) + (m[15] ^ h[15]), 12) ^ BMWSmallCore.circularLeft((m[0] ^ h[0]) + (m[7] ^ h[7]) + (m[9] ^ h[9]) - (m[12] ^ h[12]) + (m[15] ^ h[15]), 25)) + h[3];
        q[3] = ((m[0] ^ h[0]) - (m[1] ^ h[1]) + (m[8] ^ h[8]) - (m[10] ^ h[10]) + (m[13] ^ h[13]) >>> 2 ^ (m[0] ^ h[0]) - (m[1] ^ h[1]) + (m[8] ^ h[8]) - (m[10] ^ h[10]) + (m[13] ^ h[13]) << 2 ^ BMWSmallCore.circularLeft((m[0] ^ h[0]) - (m[1] ^ h[1]) + (m[8] ^ h[8]) - (m[10] ^ h[10]) + (m[13] ^ h[13]), 15) ^ BMWSmallCore.circularLeft((m[0] ^ h[0]) - (m[1] ^ h[1]) + (m[8] ^ h[8]) - (m[10] ^ h[10]) + (m[13] ^ h[13]), 29)) + h[4];
        q[4] = ((m[1] ^ h[1]) + (m[2] ^ h[2]) + (m[9] ^ h[9]) - (m[11] ^ h[11]) - (m[14] ^ h[14]) >>> 1 ^ (m[1] ^ h[1]) + (m[2] ^ h[2]) + (m[9] ^ h[9]) - (m[11] ^ h[11]) - (m[14] ^ h[14])) + h[5];
        q[5] = ((m[3] ^ h[3]) - (m[2] ^ h[2]) + (m[10] ^ h[10]) - (m[12] ^ h[12]) + (m[15] ^ h[15]) >>> 1 ^ (m[3] ^ h[3]) - (m[2] ^ h[2]) + (m[10] ^ h[10]) - (m[12] ^ h[12]) + (m[15] ^ h[15]) << 3 ^ BMWSmallCore.circularLeft((m[3] ^ h[3]) - (m[2] ^ h[2]) + (m[10] ^ h[10]) - (m[12] ^ h[12]) + (m[15] ^ h[15]), 4) ^ BMWSmallCore.circularLeft((m[3] ^ h[3]) - (m[2] ^ h[2]) + (m[10] ^ h[10]) - (m[12] ^ h[12]) + (m[15] ^ h[15]), 19)) + h[6];
        q[6] = ((m[4] ^ h[4]) - (m[0] ^ h[0]) - (m[3] ^ h[3]) - (m[11] ^ h[11]) + (m[13] ^ h[13]) >>> 1 ^ (m[4] ^ h[4]) - (m[0] ^ h[0]) - (m[3] ^ h[3]) - (m[11] ^ h[11]) + (m[13] ^ h[13]) << 2 ^ BMWSmallCore.circularLeft((m[4] ^ h[4]) - (m[0] ^ h[0]) - (m[3] ^ h[3]) - (m[11] ^ h[11]) + (m[13] ^ h[13]), 8) ^ BMWSmallCore.circularLeft((m[4] ^ h[4]) - (m[0] ^ h[0]) - (m[3] ^ h[3]) - (m[11] ^ h[11]) + (m[13] ^ h[13]), 23)) + h[7];
        q[7] = ((m[1] ^ h[1]) - (m[4] ^ h[4]) - (m[5] ^ h[5]) - (m[12] ^ h[12]) - (m[14] ^ h[14]) >>> 2 ^ (m[1] ^ h[1]) - (m[4] ^ h[4]) - (m[5] ^ h[5]) - (m[12] ^ h[12]) - (m[14] ^ h[14]) << 1 ^ BMWSmallCore.circularLeft((m[1] ^ h[1]) - (m[4] ^ h[4]) - (m[5] ^ h[5]) - (m[12] ^ h[12]) - (m[14] ^ h[14]), 12) ^ BMWSmallCore.circularLeft((m[1] ^ h[1]) - (m[4] ^ h[4]) - (m[5] ^ h[5]) - (m[12] ^ h[12]) - (m[14] ^ h[14]), 25)) + h[8];
        q[8] = ((m[2] ^ h[2]) - (m[5] ^ h[5]) - (m[6] ^ h[6]) + (m[13] ^ h[13]) - (m[15] ^ h[15]) >>> 2 ^ (m[2] ^ h[2]) - (m[5] ^ h[5]) - (m[6] ^ h[6]) + (m[13] ^ h[13]) - (m[15] ^ h[15]) << 2 ^ BMWSmallCore.circularLeft((m[2] ^ h[2]) - (m[5] ^ h[5]) - (m[6] ^ h[6]) + (m[13] ^ h[13]) - (m[15] ^ h[15]), 15) ^ BMWSmallCore.circularLeft((m[2] ^ h[2]) - (m[5] ^ h[5]) - (m[6] ^ h[6]) + (m[13] ^ h[13]) - (m[15] ^ h[15]), 29)) + h[9];
        q[9] = ((m[0] ^ h[0]) - (m[3] ^ h[3]) + (m[6] ^ h[6]) - (m[7] ^ h[7]) + (m[14] ^ h[14]) >>> 1 ^ (m[0] ^ h[0]) - (m[3] ^ h[3]) + (m[6] ^ h[6]) - (m[7] ^ h[7]) + (m[14] ^ h[14])) + h[10];
        q[10] = ((m[8] ^ h[8]) - (m[1] ^ h[1]) - (m[4] ^ h[4]) - (m[7] ^ h[7]) + (m[15] ^ h[15]) >>> 1 ^ (m[8] ^ h[8]) - (m[1] ^ h[1]) - (m[4] ^ h[4]) - (m[7] ^ h[7]) + (m[15] ^ h[15]) << 3 ^ BMWSmallCore.circularLeft((m[8] ^ h[8]) - (m[1] ^ h[1]) - (m[4] ^ h[4]) - (m[7] ^ h[7]) + (m[15] ^ h[15]), 4) ^ BMWSmallCore.circularLeft((m[8] ^ h[8]) - (m[1] ^ h[1]) - (m[4] ^ h[4]) - (m[7] ^ h[7]) + (m[15] ^ h[15]), 19)) + h[11];
        q[11] = ((m[8] ^ h[8]) - (m[0] ^ h[0]) - (m[2] ^ h[2]) - (m[5] ^ h[5]) + (m[9] ^ h[9]) >>> 1 ^ (m[8] ^ h[8]) - (m[0] ^ h[0]) - (m[2] ^ h[2]) - (m[5] ^ h[5]) + (m[9] ^ h[9]) << 2 ^ BMWSmallCore.circularLeft((m[8] ^ h[8]) - (m[0] ^ h[0]) - (m[2] ^ h[2]) - (m[5] ^ h[5]) + (m[9] ^ h[9]), 8) ^ BMWSmallCore.circularLeft((m[8] ^ h[8]) - (m[0] ^ h[0]) - (m[2] ^ h[2]) - (m[5] ^ h[5]) + (m[9] ^ h[9]), 23)) + h[12];
        q[12] = ((m[1] ^ h[1]) + (m[3] ^ h[3]) - (m[6] ^ h[6]) - (m[9] ^ h[9]) + (m[10] ^ h[10]) >>> 2 ^ (m[1] ^ h[1]) + (m[3] ^ h[3]) - (m[6] ^ h[6]) - (m[9] ^ h[9]) + (m[10] ^ h[10]) << 1 ^ BMWSmallCore.circularLeft((m[1] ^ h[1]) + (m[3] ^ h[3]) - (m[6] ^ h[6]) - (m[9] ^ h[9]) + (m[10] ^ h[10]), 12) ^ BMWSmallCore.circularLeft((m[1] ^ h[1]) + (m[3] ^ h[3]) - (m[6] ^ h[6]) - (m[9] ^ h[9]) + (m[10] ^ h[10]), 25)) + h[13];
        q[13] = ((m[2] ^ h[2]) + (m[4] ^ h[4]) + (m[7] ^ h[7]) + (m[10] ^ h[10]) + (m[11] ^ h[11]) >>> 2 ^ (m[2] ^ h[2]) + (m[4] ^ h[4]) + (m[7] ^ h[7]) + (m[10] ^ h[10]) + (m[11] ^ h[11]) << 2 ^ BMWSmallCore.circularLeft((m[2] ^ h[2]) + (m[4] ^ h[4]) + (m[7] ^ h[7]) + (m[10] ^ h[10]) + (m[11] ^ h[11]), 15) ^ BMWSmallCore.circularLeft((m[2] ^ h[2]) + (m[4] ^ h[4]) + (m[7] ^ h[7]) + (m[10] ^ h[10]) + (m[11] ^ h[11]), 29)) + h[14];
        q[14] = ((m[3] ^ h[3]) - (m[5] ^ h[5]) + (m[8] ^ h[8]) - (m[11] ^ h[11]) - (m[12] ^ h[12]) >>> 1 ^ (m[3] ^ h[3]) - (m[5] ^ h[5]) + (m[8] ^ h[8]) - (m[11] ^ h[11]) - (m[12] ^ h[12])) + h[15];
        q[15] = ((m[12] ^ h[12]) - (m[4] ^ h[4]) - (m[6] ^ h[6]) - (m[9] ^ h[9]) + (m[13] ^ h[13]) >>> 1 ^ (m[12] ^ h[12]) - (m[4] ^ h[4]) - (m[6] ^ h[6]) - (m[9] ^ h[9]) + (m[13] ^ h[13]) << 3 ^ BMWSmallCore.circularLeft((m[12] ^ h[12]) - (m[4] ^ h[4]) - (m[6] ^ h[6]) - (m[9] ^ h[9]) + (m[13] ^ h[13]), 4) ^ BMWSmallCore.circularLeft((m[12] ^ h[12]) - (m[4] ^ h[4]) - (m[6] ^ h[6]) - (m[9] ^ h[9]) + (m[13] ^ h[13]), 19)) + h[0];
        q[16] = (q[0] >>> 1 ^ q[0] << 2 ^ BMWSmallCore.circularLeft(q[0], 8) ^ BMWSmallCore.circularLeft(q[0], 23)) + (q[1] >>> 2 ^ q[1] << 1 ^ BMWSmallCore.circularLeft(q[1], 12) ^ BMWSmallCore.circularLeft(q[1], 25)) + (q[2] >>> 2 ^ q[2] << 2 ^ BMWSmallCore.circularLeft(q[2], 15) ^ BMWSmallCore.circularLeft(q[2], 29)) + (q[3] >>> 1 ^ q[3] << 3 ^ BMWSmallCore.circularLeft(q[3], 4) ^ BMWSmallCore.circularLeft(q[3], 19)) + (q[4] >>> 1 ^ q[4] << 2 ^ BMWSmallCore.circularLeft(q[4], 8) ^ BMWSmallCore.circularLeft(q[4], 23)) + (q[5] >>> 2 ^ q[5] << 1 ^ BMWSmallCore.circularLeft(q[5], 12) ^ BMWSmallCore.circularLeft(q[5], 25)) + (q[6] >>> 2 ^ q[6] << 2 ^ BMWSmallCore.circularLeft(q[6], 15) ^ BMWSmallCore.circularLeft(q[6], 29)) + (q[7] >>> 1 ^ q[7] << 3 ^ BMWSmallCore.circularLeft(q[7], 4) ^ BMWSmallCore.circularLeft(q[7], 19)) + (q[8] >>> 1 ^ q[8] << 2 ^ BMWSmallCore.circularLeft(q[8], 8) ^ BMWSmallCore.circularLeft(q[8], 23)) + (q[9] >>> 2 ^ q[9] << 1 ^ BMWSmallCore.circularLeft(q[9], 12) ^ BMWSmallCore.circularLeft(q[9], 25)) + (q[10] >>> 2 ^ q[10] << 2 ^ BMWSmallCore.circularLeft(q[10], 15) ^ BMWSmallCore.circularLeft(q[10], 29)) + (q[11] >>> 1 ^ q[11] << 3 ^ BMWSmallCore.circularLeft(q[11], 4) ^ BMWSmallCore.circularLeft(q[11], 19)) + (q[12] >>> 1 ^ q[12] << 2 ^ BMWSmallCore.circularLeft(q[12], 8) ^ BMWSmallCore.circularLeft(q[12], 23)) + (q[13] >>> 2 ^ q[13] << 1 ^ BMWSmallCore.circularLeft(q[13], 12) ^ BMWSmallCore.circularLeft(q[13], 25)) + (q[14] >>> 2 ^ q[14] << 2 ^ BMWSmallCore.circularLeft(q[14], 15) ^ BMWSmallCore.circularLeft(q[14], 29)) + (q[15] >>> 1 ^ q[15] << 3 ^ BMWSmallCore.circularLeft(q[15], 4) ^ BMWSmallCore.circularLeft(q[15], 19)) + (BMWSmallCore.circularLeft(m[0], 1) + BMWSmallCore.circularLeft(m[3], 4) - BMWSmallCore.circularLeft(m[10], 11) + 0x55555550 ^ h[7]);
        q[17] = (q[1] >>> 1 ^ q[1] << 2 ^ BMWSmallCore.circularLeft(q[1], 8) ^ BMWSmallCore.circularLeft(q[1], 23)) + (q[2] >>> 2 ^ q[2] << 1 ^ BMWSmallCore.circularLeft(q[2], 12) ^ BMWSmallCore.circularLeft(q[2], 25)) + (q[3] >>> 2 ^ q[3] << 2 ^ BMWSmallCore.circularLeft(q[3], 15) ^ BMWSmallCore.circularLeft(q[3], 29)) + (q[4] >>> 1 ^ q[4] << 3 ^ BMWSmallCore.circularLeft(q[4], 4) ^ BMWSmallCore.circularLeft(q[4], 19)) + (q[5] >>> 1 ^ q[5] << 2 ^ BMWSmallCore.circularLeft(q[5], 8) ^ BMWSmallCore.circularLeft(q[5], 23)) + (q[6] >>> 2 ^ q[6] << 1 ^ BMWSmallCore.circularLeft(q[6], 12) ^ BMWSmallCore.circularLeft(q[6], 25)) + (q[7] >>> 2 ^ q[7] << 2 ^ BMWSmallCore.circularLeft(q[7], 15) ^ BMWSmallCore.circularLeft(q[7], 29)) + (q[8] >>> 1 ^ q[8] << 3 ^ BMWSmallCore.circularLeft(q[8], 4) ^ BMWSmallCore.circularLeft(q[8], 19)) + (q[9] >>> 1 ^ q[9] << 2 ^ BMWSmallCore.circularLeft(q[9], 8) ^ BMWSmallCore.circularLeft(q[9], 23)) + (q[10] >>> 2 ^ q[10] << 1 ^ BMWSmallCore.circularLeft(q[10], 12) ^ BMWSmallCore.circularLeft(q[10], 25)) + (q[11] >>> 2 ^ q[11] << 2 ^ BMWSmallCore.circularLeft(q[11], 15) ^ BMWSmallCore.circularLeft(q[11], 29)) + (q[12] >>> 1 ^ q[12] << 3 ^ BMWSmallCore.circularLeft(q[12], 4) ^ BMWSmallCore.circularLeft(q[12], 19)) + (q[13] >>> 1 ^ q[13] << 2 ^ BMWSmallCore.circularLeft(q[13], 8) ^ BMWSmallCore.circularLeft(q[13], 23)) + (q[14] >>> 2 ^ q[14] << 1 ^ BMWSmallCore.circularLeft(q[14], 12) ^ BMWSmallCore.circularLeft(q[14], 25)) + (q[15] >>> 2 ^ q[15] << 2 ^ BMWSmallCore.circularLeft(q[15], 15) ^ BMWSmallCore.circularLeft(q[15], 29)) + (q[16] >>> 1 ^ q[16] << 3 ^ BMWSmallCore.circularLeft(q[16], 4) ^ BMWSmallCore.circularLeft(q[16], 19)) + (BMWSmallCore.circularLeft(m[1], 2) + BMWSmallCore.circularLeft(m[4], 5) - BMWSmallCore.circularLeft(m[11], 12) + 0x5AAAAAA5 ^ h[8]);
        q[18] = q[2] + BMWSmallCore.circularLeft(q[3], 3) + q[4] + BMWSmallCore.circularLeft(q[5], 7) + q[6] + BMWSmallCore.circularLeft(q[7], 13) + q[8] + BMWSmallCore.circularLeft(q[9], 16) + q[10] + BMWSmallCore.circularLeft(q[11], 19) + q[12] + BMWSmallCore.circularLeft(q[13], 23) + q[14] + BMWSmallCore.circularLeft(q[15], 27) + (q[16] >>> 1 ^ q[16]) + (q[17] >>> 2 ^ q[17]) + (BMWSmallCore.circularLeft(m[2], 3) + BMWSmallCore.circularLeft(m[5], 6) - BMWSmallCore.circularLeft(m[12], 13) + 0x5FFFFFFA ^ h[9]);
        q[19] = q[3] + BMWSmallCore.circularLeft(q[4], 3) + q[5] + BMWSmallCore.circularLeft(q[6], 7) + q[7] + BMWSmallCore.circularLeft(q[8], 13) + q[9] + BMWSmallCore.circularLeft(q[10], 16) + q[11] + BMWSmallCore.circularLeft(q[12], 19) + q[13] + BMWSmallCore.circularLeft(q[14], 23) + q[15] + BMWSmallCore.circularLeft(q[16], 27) + (q[17] >>> 1 ^ q[17]) + (q[18] >>> 2 ^ q[18]) + (BMWSmallCore.circularLeft(m[3], 4) + BMWSmallCore.circularLeft(m[6], 7) - BMWSmallCore.circularLeft(m[13], 14) + 1700091215 ^ h[10]);
        q[20] = q[4] + BMWSmallCore.circularLeft(q[5], 3) + q[6] + BMWSmallCore.circularLeft(q[7], 7) + q[8] + BMWSmallCore.circularLeft(q[9], 13) + q[10] + BMWSmallCore.circularLeft(q[11], 16) + q[12] + BMWSmallCore.circularLeft(q[13], 19) + q[14] + BMWSmallCore.circularLeft(q[15], 23) + q[16] + BMWSmallCore.circularLeft(q[17], 27) + (q[18] >>> 1 ^ q[18]) + (q[19] >>> 2 ^ q[19]) + (BMWSmallCore.circularLeft(m[4], 5) + BMWSmallCore.circularLeft(m[7], 8) - BMWSmallCore.circularLeft(m[14], 15) + 0x6AAAAAA4 ^ h[11]);
        q[21] = q[5] + BMWSmallCore.circularLeft(q[6], 3) + q[7] + BMWSmallCore.circularLeft(q[8], 7) + q[9] + BMWSmallCore.circularLeft(q[10], 13) + q[11] + BMWSmallCore.circularLeft(q[12], 16) + q[13] + BMWSmallCore.circularLeft(q[14], 19) + q[15] + BMWSmallCore.circularLeft(q[16], 23) + q[17] + BMWSmallCore.circularLeft(q[18], 27) + (q[19] >>> 1 ^ q[19]) + (q[20] >>> 2 ^ q[20]) + (BMWSmallCore.circularLeft(m[5], 6) + BMWSmallCore.circularLeft(m[8], 9) - BMWSmallCore.circularLeft(m[15], 16) + 0x6FFFFFF9 ^ h[12]);
        q[22] = q[6] + BMWSmallCore.circularLeft(q[7], 3) + q[8] + BMWSmallCore.circularLeft(q[9], 7) + q[10] + BMWSmallCore.circularLeft(q[11], 13) + q[12] + BMWSmallCore.circularLeft(q[13], 16) + q[14] + BMWSmallCore.circularLeft(q[15], 19) + q[16] + BMWSmallCore.circularLeft(q[17], 23) + q[18] + BMWSmallCore.circularLeft(q[19], 27) + (q[20] >>> 1 ^ q[20]) + (q[21] >>> 2 ^ q[21]) + (BMWSmallCore.circularLeft(m[6], 7) + BMWSmallCore.circularLeft(m[9], 10) - BMWSmallCore.circularLeft(m[0], 1) + 1968526670 ^ h[13]);
        q[23] = q[7] + BMWSmallCore.circularLeft(q[8], 3) + q[9] + BMWSmallCore.circularLeft(q[10], 7) + q[11] + BMWSmallCore.circularLeft(q[12], 13) + q[13] + BMWSmallCore.circularLeft(q[14], 16) + q[15] + BMWSmallCore.circularLeft(q[16], 19) + q[17] + BMWSmallCore.circularLeft(q[18], 23) + q[19] + BMWSmallCore.circularLeft(q[20], 27) + (q[21] >>> 1 ^ q[21]) + (q[22] >>> 2 ^ q[22]) + (BMWSmallCore.circularLeft(m[7], 8) + BMWSmallCore.circularLeft(m[10], 11) - BMWSmallCore.circularLeft(m[1], 2) + 0x7AAAAAA3 ^ h[14]);
        q[24] = q[8] + BMWSmallCore.circularLeft(q[9], 3) + q[10] + BMWSmallCore.circularLeft(q[11], 7) + q[12] + BMWSmallCore.circularLeft(q[13], 13) + q[14] + BMWSmallCore.circularLeft(q[15], 16) + q[16] + BMWSmallCore.circularLeft(q[17], 19) + q[18] + BMWSmallCore.circularLeft(q[19], 23) + q[20] + BMWSmallCore.circularLeft(q[21], 27) + (q[22] >>> 1 ^ q[22]) + (q[23] >>> 2 ^ q[23]) + (BMWSmallCore.circularLeft(m[8], 9) + BMWSmallCore.circularLeft(m[11], 12) - BMWSmallCore.circularLeft(m[2], 3) + 0x7FFFFFF8 ^ h[15]);
        q[25] = q[9] + BMWSmallCore.circularLeft(q[10], 3) + q[11] + BMWSmallCore.circularLeft(q[12], 7) + q[13] + BMWSmallCore.circularLeft(q[14], 13) + q[15] + BMWSmallCore.circularLeft(q[16], 16) + q[17] + BMWSmallCore.circularLeft(q[18], 19) + q[19] + BMWSmallCore.circularLeft(q[20], 23) + q[21] + BMWSmallCore.circularLeft(q[22], 27) + (q[23] >>> 1 ^ q[23]) + (q[24] >>> 2 ^ q[24]) + (BMWSmallCore.circularLeft(m[9], 10) + BMWSmallCore.circularLeft(m[12], 13) - BMWSmallCore.circularLeft(m[3], 4) + -2058005171 ^ h[0]);
        q[26] = q[10] + BMWSmallCore.circularLeft(q[11], 3) + q[12] + BMWSmallCore.circularLeft(q[13], 7) + q[14] + BMWSmallCore.circularLeft(q[15], 13) + q[16] + BMWSmallCore.circularLeft(q[17], 16) + q[18] + BMWSmallCore.circularLeft(q[19], 19) + q[20] + BMWSmallCore.circularLeft(q[21], 23) + q[22] + BMWSmallCore.circularLeft(q[23], 27) + (q[24] >>> 1 ^ q[24]) + (q[25] >>> 2 ^ q[25]) + (BMWSmallCore.circularLeft(m[10], 11) + BMWSmallCore.circularLeft(m[13], 14) - BMWSmallCore.circularLeft(m[4], 5) + -1968526686 ^ h[1]);
        q[27] = q[11] + BMWSmallCore.circularLeft(q[12], 3) + q[13] + BMWSmallCore.circularLeft(q[14], 7) + q[15] + BMWSmallCore.circularLeft(q[16], 13) + q[17] + BMWSmallCore.circularLeft(q[18], 16) + q[19] + BMWSmallCore.circularLeft(q[20], 19) + q[21] + BMWSmallCore.circularLeft(q[22], 23) + q[23] + BMWSmallCore.circularLeft(q[24], 27) + (q[25] >>> 1 ^ q[25]) + (q[26] >>> 2 ^ q[26]) + (BMWSmallCore.circularLeft(m[11], 12) + BMWSmallCore.circularLeft(m[14], 15) - BMWSmallCore.circularLeft(m[5], 6) + -1879048201 ^ h[2]);
        q[28] = q[12] + BMWSmallCore.circularLeft(q[13], 3) + q[14] + BMWSmallCore.circularLeft(q[15], 7) + q[16] + BMWSmallCore.circularLeft(q[17], 13) + q[18] + BMWSmallCore.circularLeft(q[19], 16) + q[20] + BMWSmallCore.circularLeft(q[21], 19) + q[22] + BMWSmallCore.circularLeft(q[23], 23) + q[24] + BMWSmallCore.circularLeft(q[25], 27) + (q[26] >>> 1 ^ q[26]) + (q[27] >>> 2 ^ q[27]) + (BMWSmallCore.circularLeft(m[12], 13) + BMWSmallCore.circularLeft(m[15], 16) - BMWSmallCore.circularLeft(m[6], 7) + -1789569716 ^ h[3]);
        q[29] = q[13] + BMWSmallCore.circularLeft(q[14], 3) + q[15] + BMWSmallCore.circularLeft(q[16], 7) + q[17] + BMWSmallCore.circularLeft(q[18], 13) + q[19] + BMWSmallCore.circularLeft(q[20], 16) + q[21] + BMWSmallCore.circularLeft(q[22], 19) + q[23] + BMWSmallCore.circularLeft(q[24], 23) + q[25] + BMWSmallCore.circularLeft(q[26], 27) + (q[27] >>> 1 ^ q[27]) + (q[28] >>> 2 ^ q[28]) + (BMWSmallCore.circularLeft(m[13], 14) + BMWSmallCore.circularLeft(m[0], 1) - BMWSmallCore.circularLeft(m[7], 8) + -1700091231 ^ h[4]);
        q[30] = q[14] + BMWSmallCore.circularLeft(q[15], 3) + q[16] + BMWSmallCore.circularLeft(q[17], 7) + q[18] + BMWSmallCore.circularLeft(q[19], 13) + q[20] + BMWSmallCore.circularLeft(q[21], 16) + q[22] + BMWSmallCore.circularLeft(q[23], 19) + q[24] + BMWSmallCore.circularLeft(q[25], 23) + q[26] + BMWSmallCore.circularLeft(q[27], 27) + (q[28] >>> 1 ^ q[28]) + (q[29] >>> 2 ^ q[29]) + (BMWSmallCore.circularLeft(m[14], 15) + BMWSmallCore.circularLeft(m[1], 2) - BMWSmallCore.circularLeft(m[8], 9) + -1610612746 ^ h[5]);
        q[31] = q[15] + BMWSmallCore.circularLeft(q[16], 3) + q[17] + BMWSmallCore.circularLeft(q[18], 7) + q[19] + BMWSmallCore.circularLeft(q[20], 13) + q[21] + BMWSmallCore.circularLeft(q[22], 16) + q[23] + BMWSmallCore.circularLeft(q[24], 19) + q[25] + BMWSmallCore.circularLeft(q[26], 23) + q[27] + BMWSmallCore.circularLeft(q[28], 27) + (q[29] >>> 1 ^ q[29]) + (q[30] >>> 2 ^ q[30]) + (BMWSmallCore.circularLeft(m[15], 16) + BMWSmallCore.circularLeft(m[2], 3) - BMWSmallCore.circularLeft(m[9], 10) + -1521134261 ^ h[6]);
        int xl = q[16] ^ q[17] ^ q[18] ^ q[19] ^ q[20] ^ q[21] ^ q[22] ^ q[23];
        int xh = xl ^ q[24] ^ q[25] ^ q[26] ^ q[27] ^ q[28] ^ q[29] ^ q[30] ^ q[31];
        h[0] = (xh << 5 ^ q[16] >>> 5 ^ m[0]) + (xl ^ q[24] ^ q[0]);
        h[1] = (xh >>> 7 ^ q[17] << 8 ^ m[1]) + (xl ^ q[25] ^ q[1]);
        h[2] = (xh >>> 5 ^ q[18] << 5 ^ m[2]) + (xl ^ q[26] ^ q[2]);
        h[3] = (xh >>> 1 ^ q[19] << 5 ^ m[3]) + (xl ^ q[27] ^ q[3]);
        h[4] = (xh >>> 3 ^ q[20] << 0 ^ m[4]) + (xl ^ q[28] ^ q[4]);
        h[5] = (xh << 6 ^ q[21] >>> 6 ^ m[5]) + (xl ^ q[29] ^ q[5]);
        h[6] = (xh >>> 4 ^ q[22] << 6 ^ m[6]) + (xl ^ q[30] ^ q[6]);
        h[7] = (xh >>> 11 ^ q[23] << 2 ^ m[7]) + (xl ^ q[31] ^ q[7]);
        h[8] = BMWSmallCore.circularLeft(h[4], 9) + (xh ^ q[24] ^ m[8]) + (xl << 8 ^ q[23] ^ q[8]);
        h[9] = BMWSmallCore.circularLeft(h[5], 10) + (xh ^ q[25] ^ m[9]) + (xl >>> 6 ^ q[16] ^ q[9]);
        h[10] = BMWSmallCore.circularLeft(h[6], 11) + (xh ^ q[26] ^ m[10]) + (xl << 6 ^ q[17] ^ q[10]);
        h[11] = BMWSmallCore.circularLeft(h[7], 12) + (xh ^ q[27] ^ m[11]) + (xl << 4 ^ q[18] ^ q[11]);
        h[12] = BMWSmallCore.circularLeft(h[0], 13) + (xh ^ q[28] ^ m[12]) + (xl >>> 3 ^ q[19] ^ q[12]);
        h[13] = BMWSmallCore.circularLeft(h[1], 14) + (xh ^ q[29] ^ m[13]) + (xl >>> 4 ^ q[20] ^ q[13]);
        h[14] = BMWSmallCore.circularLeft(h[2], 15) + (xh ^ q[30] ^ m[14]) + (xl >>> 7 ^ q[21] ^ q[14]);
        h[15] = BMWSmallCore.circularLeft(h[3], 16) + (xh ^ q[31] ^ m[15]) + (xl >>> 2 ^ q[22] ^ q[15]);
    }

    @Override
    protected void doPadding(byte[] output, int outputOffset) {
        int i;
        byte[] buf = this.getBlockBuffer();
        int ptr = this.flush();
        long bitLen = (this.getBlockCount() << 9) + (long)(ptr << 3);
        buf[ptr++] = -128;
        if (ptr > 56) {
            for (i = ptr; i < 64; ++i) {
                buf[i] = 0;
            }
            this.processBlock(buf);
            ptr = 0;
        }
        for (i = ptr; i < 56; ++i) {
            buf[i] = 0;
        }
        BMWSmallCore.encodeLEInt((int)bitLen, buf, 56);
        BMWSmallCore.encodeLEInt((int)(bitLen >>> 32), buf, 60);
        this.processBlock(buf);
        int[] tmp = this.H;
        this.H = this.H2;
        this.H2 = tmp;
        System.arraycopy(FINAL, 0, this.H, 0, 16);
        this.compress(this.H2);
        int outLen = this.getDigestLength() >>> 2;
        int i2 = 0;
        int j = 16 - outLen;
        while (i2 < outLen) {
            BMWSmallCore.encodeLEInt(this.H[j], output, outputOffset + 4 * i2);
            ++i2;
            ++j;
        }
    }

    @Override
    protected void doInit() {
        this.M = new int[16];
        this.H = new int[16];
        this.H2 = new int[16];
        this.Q = new int[32];
        this.engineReset();
    }

    private static final void encodeLEInt(int val, byte[] buf, int off) {
        buf[off + 0] = (byte)val;
        buf[off + 1] = (byte)(val >>> 8);
        buf[off + 2] = (byte)(val >>> 16);
        buf[off + 3] = (byte)(val >>> 24);
    }

    private static final int decodeLEInt(byte[] buf, int off) {
        return (buf[off + 3] & 0xFF) << 24 | (buf[off + 2] & 0xFF) << 16 | (buf[off + 1] & 0xFF) << 8 | buf[off + 0] & 0xFF;
    }

    private static final int circularLeft(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    @Override
    protected void processBlock(byte[] data) {
        for (int i = 0; i < 16; ++i) {
            this.M[i] = BMWSmallCore.decodeLEInt(data, i * 4);
        }
        this.compress(this.M);
    }

    @Override
    public String toString() {
        return "BMW-" + (this.getDigestLength() << 3);
    }
}

