/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.DigestEngine;

abstract class HAVALCore
extends DigestEngine {
    private int olen;
    private int passes;
    private byte[] padBuf;
    private int s0;
    private int s1;
    private int s2;
    private int s3;
    private int s4;
    private int s5;
    private int s6;
    private int s7;
    private int[] inw;
    private static final int[] K2 = new int[]{1160258022, 953160567, -1101764913, 887688300, -1062458953, -914599715, 1065670069, -1253635817, -1843997223, -1988494565, -785314906, -1730169428, 805139163, -803545161, -1193168915, 1780907670, -1166241723, -248741991, 614570311, -1282315017, 134345442, -2054226922, 1667834072, 1901547113, -1537671517, -191677058, 227898511, 1921955416, 1904987480, -2112533778, 2069144605, -1034266187};
    private static final int[] K3 = new int[]{-1674521287, 720527379, -976113629, 677414384, -901678824, -1193592593, -1904616272, 1614419982, 1822297739, -1340175810, -686458943, -1120842969, 2024746970, 1432378464, -430627341, -1437226092, 1464375394, 1676153920, 1439316330, 715854006, -1261675468, 289532110, -1588296017, 2087905683, -1276242927, 1668267050, 732546397, 1947742710, -832815594, -1685613794, -1344882125, 1814351708};
    private static final int[] K4 = new int[]{2050118529, 680887927, 999245976, 1800124847, -994056165, 1713906067, 1641548236, -81679983, 1216130144, 1575780402, -276538019, -377129551, -601480446, -345695352, 596196993, -745100091, 258830323, -2081144263, 772490370, -1534844924, 1774776394, -1642095778, 566650946, -152474470, 1728879713, -1412200208, 1783734482, -665571480, -1777359064, -1420741725, 1861159788, 326777828};
    private static final int[] K5 = new int[]{-1170476976, 2130389656, -1578015459, 967770486, 1724537150, -2109534584, -1930525159, 1164943284, 2105845187, 998989502, -529566248, -2050940813, 1075463327, 1455516326, 1322494562, 910128902, 469688178, 1117454909, 936433444, -804646328, -619713837, 1240580251, 122909385, -2137449605, 634681816, -152510729, -469872614, -1233564613, -1754472259, 79693498, -1045868618, 1084186820};
    private static final int[] wp2 = new int[]{5, 14, 26, 18, 11, 28, 7, 16, 0, 23, 20, 22, 1, 10, 4, 8, 30, 3, 21, 9, 17, 24, 29, 6, 19, 12, 15, 13, 2, 25, 31, 27};
    private static final int[] wp3 = new int[]{19, 9, 4, 20, 28, 17, 8, 22, 29, 14, 25, 12, 24, 30, 16, 26, 31, 15, 7, 3, 1, 0, 18, 27, 13, 6, 21, 10, 23, 11, 5, 2};
    private static final int[] wp4 = new int[]{24, 4, 0, 14, 2, 7, 28, 23, 26, 6, 30, 20, 18, 25, 19, 3, 22, 11, 31, 21, 8, 27, 12, 9, 1, 29, 5, 15, 17, 10, 16, 13};
    private static final int[] wp5 = new int[]{27, 3, 21, 26, 17, 11, 20, 29, 19, 0, 12, 7, 13, 8, 31, 10, 5, 9, 14, 30, 18, 6, 28, 24, 2, 23, 16, 22, 4, 1, 25, 15};

    HAVALCore(int outputLength, int passes) {
        this.olen = outputLength >> 5;
        this.passes = passes;
    }

    protected Digest copyState(HAVALCore dst) {
        dst.olen = this.olen;
        dst.passes = this.passes;
        dst.s0 = this.s0;
        dst.s1 = this.s1;
        dst.s2 = this.s2;
        dst.s3 = this.s3;
        dst.s4 = this.s4;
        dst.s5 = this.s5;
        dst.s6 = this.s6;
        dst.s7 = this.s7;
        return super.copyState(dst);
    }

    @Override
    public int getBlockLength() {
        return 128;
    }

    @Override
    protected void engineReset() {
        this.s0 = 608135816;
        this.s1 = -2052912941;
        this.s2 = 320440878;
        this.s3 = 57701188;
        this.s4 = -1542899678;
        this.s5 = 698298832;
        this.s6 = 137296536;
        this.s7 = -330404727;
    }

    @Override
    protected void doPadding(byte[] output, int outputOffset) {
        int dataLen = this.flush();
        long currentLength = (this.getBlockCount() << 7) + (long)dataLen << 3;
        this.padBuf[0] = (byte)(1 | this.passes << 3);
        this.padBuf[1] = (byte)(this.olen << 3);
        HAVALCore.encodeLEInt((int)currentLength, this.padBuf, 2);
        HAVALCore.encodeLEInt((int)(currentLength >>> 32), this.padBuf, 6);
        int endLen = dataLen + 138 & 0xFFFFFF80;
        this.update((byte)1);
        for (int i = dataLen + 1; i < endLen - 10; ++i) {
            this.update((byte)0);
        }
        this.update(this.padBuf);
        this.writeOutput(output, outputOffset);
    }

    @Override
    protected void doInit() {
        this.padBuf = new byte[10];
        this.inw = new int[32];
        this.engineReset();
    }

    private static final void encodeLEInt(int val, byte[] buf, int off) {
        buf[off + 3] = (byte)(val >> 24 & 0xFF);
        buf[off + 2] = (byte)(val >> 16 & 0xFF);
        buf[off + 1] = (byte)(val >> 8 & 0xFF);
        buf[off + 0] = (byte)(val & 0xFF);
    }

    private static final int decodeLEInt(byte[] buf, int off) {
        return buf[off] & 0xFF | (buf[off + 1] & 0xFF) << 8 | (buf[off + 2] & 0xFF) << 16 | (buf[off + 3] & 0xFF) << 24;
    }

    private static final int circularLeft(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    @Override
    protected void processBlock(byte[] data) {
        for (int i = 0; i < 32; ++i) {
            this.inw[i] = HAVALCore.decodeLEInt(data, 4 * i);
        }
        int save0 = this.s0;
        int save1 = this.s1;
        int save2 = this.s2;
        int save3 = this.s3;
        int save4 = this.s4;
        int save5 = this.s5;
        int save6 = this.s6;
        int save7 = this.s7;
        switch (this.passes) {
            case 3: {
                this.pass31(this.inw);
                this.pass32(this.inw);
                this.pass33(this.inw);
                break;
            }
            case 4: {
                this.pass41(this.inw);
                this.pass42(this.inw);
                this.pass43(this.inw);
                this.pass44(this.inw);
                break;
            }
            case 5: {
                this.pass51(this.inw);
                this.pass52(this.inw);
                this.pass53(this.inw);
                this.pass54(this.inw);
                this.pass55(this.inw);
            }
        }
        this.s0 += save0;
        this.s1 += save1;
        this.s2 += save2;
        this.s3 += save3;
        this.s4 += save4;
        this.s5 += save5;
        this.s6 += save6;
        this.s7 += save7;
    }

    private static final int F1(int x6, int x5, int x4, int x3, int x2, int x1, int x0) {
        return x1 & x4 ^ x2 & x5 ^ x3 & x6 ^ x0 & x1 ^ x0;
    }

    private static final int F2(int x6, int x5, int x4, int x3, int x2, int x1, int x0) {
        return x2 & (x1 & ~x3 ^ x4 & x5 ^ x6 ^ x0) ^ x4 & (x1 ^ x5) ^ (x3 & x5 ^ x0);
    }

    private static final int F3(int x6, int x5, int x4, int x3, int x2, int x1, int x0) {
        return x3 & (x1 & x2 ^ x6 ^ x0) ^ x1 & x4 ^ x2 & x5 ^ x0;
    }

    private static final int F4(int x6, int x5, int x4, int x3, int x2, int x1, int x0) {
        return x3 & (x1 & x2 ^ (x4 | x6) ^ x5) ^ x4 & (~x2 & x5 ^ x1 ^ x6 ^ x0) ^ x2 & x6 ^ x0;
    }

    private static final int F5(int x6, int x5, int x4, int x3, int x2, int x1, int x0) {
        return x0 & ~(x1 & x2 & x3 ^ x5) ^ x1 & x4 ^ x2 & x5 ^ x3 & x6;
    }

    private final void pass31(int[] inw) {
        int x0 = this.s0;
        int x1 = this.s1;
        int x2 = this.s2;
        int x3 = this.s3;
        int x4 = this.s4;
        int x5 = this.s5;
        int x6 = this.s6;
        int x7 = this.s7;
        for (int i = 0; i < 32; i += 8) {
            x7 = HAVALCore.circularLeft(HAVALCore.F1(x1, x0, x3, x5, x6, x2, x4), 25) + HAVALCore.circularLeft(x7, 21) + inw[i + 0];
            x6 = HAVALCore.circularLeft(HAVALCore.F1(x0, x7, x2, x4, x5, x1, x3), 25) + HAVALCore.circularLeft(x6, 21) + inw[i + 1];
            x5 = HAVALCore.circularLeft(HAVALCore.F1(x7, x6, x1, x3, x4, x0, x2), 25) + HAVALCore.circularLeft(x5, 21) + inw[i + 2];
            x4 = HAVALCore.circularLeft(HAVALCore.F1(x6, x5, x0, x2, x3, x7, x1), 25) + HAVALCore.circularLeft(x4, 21) + inw[i + 3];
            x3 = HAVALCore.circularLeft(HAVALCore.F1(x5, x4, x7, x1, x2, x6, x0), 25) + HAVALCore.circularLeft(x3, 21) + inw[i + 4];
            x2 = HAVALCore.circularLeft(HAVALCore.F1(x4, x3, x6, x0, x1, x5, x7), 25) + HAVALCore.circularLeft(x2, 21) + inw[i + 5];
            x1 = HAVALCore.circularLeft(HAVALCore.F1(x3, x2, x5, x7, x0, x4, x6), 25) + HAVALCore.circularLeft(x1, 21) + inw[i + 6];
            x0 = HAVALCore.circularLeft(HAVALCore.F1(x2, x1, x4, x6, x7, x3, x5), 25) + HAVALCore.circularLeft(x0, 21) + inw[i + 7];
        }
        this.s0 = x0;
        this.s1 = x1;
        this.s2 = x2;
        this.s3 = x3;
        this.s4 = x4;
        this.s5 = x5;
        this.s6 = x6;
        this.s7 = x7;
    }

    private final void pass32(int[] inw) {
        int x0 = this.s0;
        int x1 = this.s1;
        int x2 = this.s2;
        int x3 = this.s3;
        int x4 = this.s4;
        int x5 = this.s5;
        int x6 = this.s6;
        int x7 = this.s7;
        for (int i = 0; i < 32; i += 8) {
            x7 = HAVALCore.circularLeft(HAVALCore.F2(x4, x2, x1, x0, x5, x3, x6), 25) + HAVALCore.circularLeft(x7, 21) + inw[wp2[i + 0]] + K2[i + 0];
            x6 = HAVALCore.circularLeft(HAVALCore.F2(x3, x1, x0, x7, x4, x2, x5), 25) + HAVALCore.circularLeft(x6, 21) + inw[wp2[i + 1]] + K2[i + 1];
            x5 = HAVALCore.circularLeft(HAVALCore.F2(x2, x0, x7, x6, x3, x1, x4), 25) + HAVALCore.circularLeft(x5, 21) + inw[wp2[i + 2]] + K2[i + 2];
            x4 = HAVALCore.circularLeft(HAVALCore.F2(x1, x7, x6, x5, x2, x0, x3), 25) + HAVALCore.circularLeft(x4, 21) + inw[wp2[i + 3]] + K2[i + 3];
            x3 = HAVALCore.circularLeft(HAVALCore.F2(x0, x6, x5, x4, x1, x7, x2), 25) + HAVALCore.circularLeft(x3, 21) + inw[wp2[i + 4]] + K2[i + 4];
            x2 = HAVALCore.circularLeft(HAVALCore.F2(x7, x5, x4, x3, x0, x6, x1), 25) + HAVALCore.circularLeft(x2, 21) + inw[wp2[i + 5]] + K2[i + 5];
            x1 = HAVALCore.circularLeft(HAVALCore.F2(x6, x4, x3, x2, x7, x5, x0), 25) + HAVALCore.circularLeft(x1, 21) + inw[wp2[i + 6]] + K2[i + 6];
            x0 = HAVALCore.circularLeft(HAVALCore.F2(x5, x3, x2, x1, x6, x4, x7), 25) + HAVALCore.circularLeft(x0, 21) + inw[wp2[i + 7]] + K2[i + 7];
        }
        this.s0 = x0;
        this.s1 = x1;
        this.s2 = x2;
        this.s3 = x3;
        this.s4 = x4;
        this.s5 = x5;
        this.s6 = x6;
        this.s7 = x7;
    }

    private final void pass33(int[] inw) {
        int x0 = this.s0;
        int x1 = this.s1;
        int x2 = this.s2;
        int x3 = this.s3;
        int x4 = this.s4;
        int x5 = this.s5;
        int x6 = this.s6;
        int x7 = this.s7;
        for (int i = 0; i < 32; i += 8) {
            x7 = HAVALCore.circularLeft(HAVALCore.F3(x6, x1, x2, x3, x4, x5, x0), 25) + HAVALCore.circularLeft(x7, 21) + inw[wp3[i + 0]] + K3[i + 0];
            x6 = HAVALCore.circularLeft(HAVALCore.F3(x5, x0, x1, x2, x3, x4, x7), 25) + HAVALCore.circularLeft(x6, 21) + inw[wp3[i + 1]] + K3[i + 1];
            x5 = HAVALCore.circularLeft(HAVALCore.F3(x4, x7, x0, x1, x2, x3, x6), 25) + HAVALCore.circularLeft(x5, 21) + inw[wp3[i + 2]] + K3[i + 2];
            x4 = HAVALCore.circularLeft(HAVALCore.F3(x3, x6, x7, x0, x1, x2, x5), 25) + HAVALCore.circularLeft(x4, 21) + inw[wp3[i + 3]] + K3[i + 3];
            x3 = HAVALCore.circularLeft(HAVALCore.F3(x2, x5, x6, x7, x0, x1, x4), 25) + HAVALCore.circularLeft(x3, 21) + inw[wp3[i + 4]] + K3[i + 4];
            x2 = HAVALCore.circularLeft(HAVALCore.F3(x1, x4, x5, x6, x7, x0, x3), 25) + HAVALCore.circularLeft(x2, 21) + inw[wp3[i + 5]] + K3[i + 5];
            x1 = HAVALCore.circularLeft(HAVALCore.F3(x0, x3, x4, x5, x6, x7, x2), 25) + HAVALCore.circularLeft(x1, 21) + inw[wp3[i + 6]] + K3[i + 6];
            x0 = HAVALCore.circularLeft(HAVALCore.F3(x7, x2, x3, x4, x5, x6, x1), 25) + HAVALCore.circularLeft(x0, 21) + inw[wp3[i + 7]] + K3[i + 7];
        }
        this.s0 = x0;
        this.s1 = x1;
        this.s2 = x2;
        this.s3 = x3;
        this.s4 = x4;
        this.s5 = x5;
        this.s6 = x6;
        this.s7 = x7;
    }

    private final void pass41(int[] inw) {
        int x0 = this.s0;
        int x1 = this.s1;
        int x2 = this.s2;
        int x3 = this.s3;
        int x4 = this.s4;
        int x5 = this.s5;
        int x6 = this.s6;
        int x7 = this.s7;
        for (int i = 0; i < 32; i += 8) {
            x7 = HAVALCore.circularLeft(HAVALCore.F1(x2, x6, x1, x4, x5, x3, x0), 25) + HAVALCore.circularLeft(x7, 21) + inw[i + 0];
            x6 = HAVALCore.circularLeft(HAVALCore.F1(x1, x5, x0, x3, x4, x2, x7), 25) + HAVALCore.circularLeft(x6, 21) + inw[i + 1];
            x5 = HAVALCore.circularLeft(HAVALCore.F1(x0, x4, x7, x2, x3, x1, x6), 25) + HAVALCore.circularLeft(x5, 21) + inw[i + 2];
            x4 = HAVALCore.circularLeft(HAVALCore.F1(x7, x3, x6, x1, x2, x0, x5), 25) + HAVALCore.circularLeft(x4, 21) + inw[i + 3];
            x3 = HAVALCore.circularLeft(HAVALCore.F1(x6, x2, x5, x0, x1, x7, x4), 25) + HAVALCore.circularLeft(x3, 21) + inw[i + 4];
            x2 = HAVALCore.circularLeft(HAVALCore.F1(x5, x1, x4, x7, x0, x6, x3), 25) + HAVALCore.circularLeft(x2, 21) + inw[i + 5];
            x1 = HAVALCore.circularLeft(HAVALCore.F1(x4, x0, x3, x6, x7, x5, x2), 25) + HAVALCore.circularLeft(x1, 21) + inw[i + 6];
            x0 = HAVALCore.circularLeft(HAVALCore.F1(x3, x7, x2, x5, x6, x4, x1), 25) + HAVALCore.circularLeft(x0, 21) + inw[i + 7];
        }
        this.s0 = x0;
        this.s1 = x1;
        this.s2 = x2;
        this.s3 = x3;
        this.s4 = x4;
        this.s5 = x5;
        this.s6 = x6;
        this.s7 = x7;
    }

    private final void pass42(int[] inw) {
        int x0 = this.s0;
        int x1 = this.s1;
        int x2 = this.s2;
        int x3 = this.s3;
        int x4 = this.s4;
        int x5 = this.s5;
        int x6 = this.s6;
        int x7 = this.s7;
        for (int i = 0; i < 32; i += 8) {
            x7 = HAVALCore.circularLeft(HAVALCore.F2(x3, x5, x2, x0, x1, x6, x4), 25) + HAVALCore.circularLeft(x7, 21) + inw[wp2[i + 0]] + K2[i + 0];
            x6 = HAVALCore.circularLeft(HAVALCore.F2(x2, x4, x1, x7, x0, x5, x3), 25) + HAVALCore.circularLeft(x6, 21) + inw[wp2[i + 1]] + K2[i + 1];
            x5 = HAVALCore.circularLeft(HAVALCore.F2(x1, x3, x0, x6, x7, x4, x2), 25) + HAVALCore.circularLeft(x5, 21) + inw[wp2[i + 2]] + K2[i + 2];
            x4 = HAVALCore.circularLeft(HAVALCore.F2(x0, x2, x7, x5, x6, x3, x1), 25) + HAVALCore.circularLeft(x4, 21) + inw[wp2[i + 3]] + K2[i + 3];
            x3 = HAVALCore.circularLeft(HAVALCore.F2(x7, x1, x6, x4, x5, x2, x0), 25) + HAVALCore.circularLeft(x3, 21) + inw[wp2[i + 4]] + K2[i + 4];
            x2 = HAVALCore.circularLeft(HAVALCore.F2(x6, x0, x5, x3, x4, x1, x7), 25) + HAVALCore.circularLeft(x2, 21) + inw[wp2[i + 5]] + K2[i + 5];
            x1 = HAVALCore.circularLeft(HAVALCore.F2(x5, x7, x4, x2, x3, x0, x6), 25) + HAVALCore.circularLeft(x1, 21) + inw[wp2[i + 6]] + K2[i + 6];
            x0 = HAVALCore.circularLeft(HAVALCore.F2(x4, x6, x3, x1, x2, x7, x5), 25) + HAVALCore.circularLeft(x0, 21) + inw[wp2[i + 7]] + K2[i + 7];
        }
        this.s0 = x0;
        this.s1 = x1;
        this.s2 = x2;
        this.s3 = x3;
        this.s4 = x4;
        this.s5 = x5;
        this.s6 = x6;
        this.s7 = x7;
    }

    private final void pass43(int[] inw) {
        int x0 = this.s0;
        int x1 = this.s1;
        int x2 = this.s2;
        int x3 = this.s3;
        int x4 = this.s4;
        int x5 = this.s5;
        int x6 = this.s6;
        int x7 = this.s7;
        for (int i = 0; i < 32; i += 8) {
            x7 = HAVALCore.circularLeft(HAVALCore.F3(x1, x4, x3, x6, x0, x2, x5), 25) + HAVALCore.circularLeft(x7, 21) + inw[wp3[i + 0]] + K3[i + 0];
            x6 = HAVALCore.circularLeft(HAVALCore.F3(x0, x3, x2, x5, x7, x1, x4), 25) + HAVALCore.circularLeft(x6, 21) + inw[wp3[i + 1]] + K3[i + 1];
            x5 = HAVALCore.circularLeft(HAVALCore.F3(x7, x2, x1, x4, x6, x0, x3), 25) + HAVALCore.circularLeft(x5, 21) + inw[wp3[i + 2]] + K3[i + 2];
            x4 = HAVALCore.circularLeft(HAVALCore.F3(x6, x1, x0, x3, x5, x7, x2), 25) + HAVALCore.circularLeft(x4, 21) + inw[wp3[i + 3]] + K3[i + 3];
            x3 = HAVALCore.circularLeft(HAVALCore.F3(x5, x0, x7, x2, x4, x6, x1), 25) + HAVALCore.circularLeft(x3, 21) + inw[wp3[i + 4]] + K3[i + 4];
            x2 = HAVALCore.circularLeft(HAVALCore.F3(x4, x7, x6, x1, x3, x5, x0), 25) + HAVALCore.circularLeft(x2, 21) + inw[wp3[i + 5]] + K3[i + 5];
            x1 = HAVALCore.circularLeft(HAVALCore.F3(x3, x6, x5, x0, x2, x4, x7), 25) + HAVALCore.circularLeft(x1, 21) + inw[wp3[i + 6]] + K3[i + 6];
            x0 = HAVALCore.circularLeft(HAVALCore.F3(x2, x5, x4, x7, x1, x3, x6), 25) + HAVALCore.circularLeft(x0, 21) + inw[wp3[i + 7]] + K3[i + 7];
        }
        this.s0 = x0;
        this.s1 = x1;
        this.s2 = x2;
        this.s3 = x3;
        this.s4 = x4;
        this.s5 = x5;
        this.s6 = x6;
        this.s7 = x7;
    }

    private final void pass44(int[] inw) {
        int x0 = this.s0;
        int x1 = this.s1;
        int x2 = this.s2;
        int x3 = this.s3;
        int x4 = this.s4;
        int x5 = this.s5;
        int x6 = this.s6;
        int x7 = this.s7;
        for (int i = 0; i < 32; i += 8) {
            x7 = HAVALCore.circularLeft(HAVALCore.F4(x6, x4, x0, x5, x2, x1, x3), 25) + HAVALCore.circularLeft(x7, 21) + inw[wp4[i + 0]] + K4[i + 0];
            x6 = HAVALCore.circularLeft(HAVALCore.F4(x5, x3, x7, x4, x1, x0, x2), 25) + HAVALCore.circularLeft(x6, 21) + inw[wp4[i + 1]] + K4[i + 1];
            x5 = HAVALCore.circularLeft(HAVALCore.F4(x4, x2, x6, x3, x0, x7, x1), 25) + HAVALCore.circularLeft(x5, 21) + inw[wp4[i + 2]] + K4[i + 2];
            x4 = HAVALCore.circularLeft(HAVALCore.F4(x3, x1, x5, x2, x7, x6, x0), 25) + HAVALCore.circularLeft(x4, 21) + inw[wp4[i + 3]] + K4[i + 3];
            x3 = HAVALCore.circularLeft(HAVALCore.F4(x2, x0, x4, x1, x6, x5, x7), 25) + HAVALCore.circularLeft(x3, 21) + inw[wp4[i + 4]] + K4[i + 4];
            x2 = HAVALCore.circularLeft(HAVALCore.F4(x1, x7, x3, x0, x5, x4, x6), 25) + HAVALCore.circularLeft(x2, 21) + inw[wp4[i + 5]] + K4[i + 5];
            x1 = HAVALCore.circularLeft(HAVALCore.F4(x0, x6, x2, x7, x4, x3, x5), 25) + HAVALCore.circularLeft(x1, 21) + inw[wp4[i + 6]] + K4[i + 6];
            x0 = HAVALCore.circularLeft(HAVALCore.F4(x7, x5, x1, x6, x3, x2, x4), 25) + HAVALCore.circularLeft(x0, 21) + inw[wp4[i + 7]] + K4[i + 7];
        }
        this.s0 = x0;
        this.s1 = x1;
        this.s2 = x2;
        this.s3 = x3;
        this.s4 = x4;
        this.s5 = x5;
        this.s6 = x6;
        this.s7 = x7;
    }

    private final void pass51(int[] inw) {
        int x0 = this.s0;
        int x1 = this.s1;
        int x2 = this.s2;
        int x3 = this.s3;
        int x4 = this.s4;
        int x5 = this.s5;
        int x6 = this.s6;
        int x7 = this.s7;
        for (int i = 0; i < 32; i += 8) {
            x7 = HAVALCore.circularLeft(HAVALCore.F1(x3, x4, x1, x0, x5, x2, x6), 25) + HAVALCore.circularLeft(x7, 21) + inw[i + 0];
            x6 = HAVALCore.circularLeft(HAVALCore.F1(x2, x3, x0, x7, x4, x1, x5), 25) + HAVALCore.circularLeft(x6, 21) + inw[i + 1];
            x5 = HAVALCore.circularLeft(HAVALCore.F1(x1, x2, x7, x6, x3, x0, x4), 25) + HAVALCore.circularLeft(x5, 21) + inw[i + 2];
            x4 = HAVALCore.circularLeft(HAVALCore.F1(x0, x1, x6, x5, x2, x7, x3), 25) + HAVALCore.circularLeft(x4, 21) + inw[i + 3];
            x3 = HAVALCore.circularLeft(HAVALCore.F1(x7, x0, x5, x4, x1, x6, x2), 25) + HAVALCore.circularLeft(x3, 21) + inw[i + 4];
            x2 = HAVALCore.circularLeft(HAVALCore.F1(x6, x7, x4, x3, x0, x5, x1), 25) + HAVALCore.circularLeft(x2, 21) + inw[i + 5];
            x1 = HAVALCore.circularLeft(HAVALCore.F1(x5, x6, x3, x2, x7, x4, x0), 25) + HAVALCore.circularLeft(x1, 21) + inw[i + 6];
            x0 = HAVALCore.circularLeft(HAVALCore.F1(x4, x5, x2, x1, x6, x3, x7), 25) + HAVALCore.circularLeft(x0, 21) + inw[i + 7];
        }
        this.s0 = x0;
        this.s1 = x1;
        this.s2 = x2;
        this.s3 = x3;
        this.s4 = x4;
        this.s5 = x5;
        this.s6 = x6;
        this.s7 = x7;
    }

    private final void pass52(int[] inw) {
        int x0 = this.s0;
        int x1 = this.s1;
        int x2 = this.s2;
        int x3 = this.s3;
        int x4 = this.s4;
        int x5 = this.s5;
        int x6 = this.s6;
        int x7 = this.s7;
        for (int i = 0; i < 32; i += 8) {
            x7 = HAVALCore.circularLeft(HAVALCore.F2(x6, x2, x1, x0, x3, x4, x5), 25) + HAVALCore.circularLeft(x7, 21) + inw[wp2[i + 0]] + K2[i + 0];
            x6 = HAVALCore.circularLeft(HAVALCore.F2(x5, x1, x0, x7, x2, x3, x4), 25) + HAVALCore.circularLeft(x6, 21) + inw[wp2[i + 1]] + K2[i + 1];
            x5 = HAVALCore.circularLeft(HAVALCore.F2(x4, x0, x7, x6, x1, x2, x3), 25) + HAVALCore.circularLeft(x5, 21) + inw[wp2[i + 2]] + K2[i + 2];
            x4 = HAVALCore.circularLeft(HAVALCore.F2(x3, x7, x6, x5, x0, x1, x2), 25) + HAVALCore.circularLeft(x4, 21) + inw[wp2[i + 3]] + K2[i + 3];
            x3 = HAVALCore.circularLeft(HAVALCore.F2(x2, x6, x5, x4, x7, x0, x1), 25) + HAVALCore.circularLeft(x3, 21) + inw[wp2[i + 4]] + K2[i + 4];
            x2 = HAVALCore.circularLeft(HAVALCore.F2(x1, x5, x4, x3, x6, x7, x0), 25) + HAVALCore.circularLeft(x2, 21) + inw[wp2[i + 5]] + K2[i + 5];
            x1 = HAVALCore.circularLeft(HAVALCore.F2(x0, x4, x3, x2, x5, x6, x7), 25) + HAVALCore.circularLeft(x1, 21) + inw[wp2[i + 6]] + K2[i + 6];
            x0 = HAVALCore.circularLeft(HAVALCore.F2(x7, x3, x2, x1, x4, x5, x6), 25) + HAVALCore.circularLeft(x0, 21) + inw[wp2[i + 7]] + K2[i + 7];
        }
        this.s0 = x0;
        this.s1 = x1;
        this.s2 = x2;
        this.s3 = x3;
        this.s4 = x4;
        this.s5 = x5;
        this.s6 = x6;
        this.s7 = x7;
    }

    private final void pass53(int[] inw) {
        int x0 = this.s0;
        int x1 = this.s1;
        int x2 = this.s2;
        int x3 = this.s3;
        int x4 = this.s4;
        int x5 = this.s5;
        int x6 = this.s6;
        int x7 = this.s7;
        for (int i = 0; i < 32; i += 8) {
            x7 = HAVALCore.circularLeft(HAVALCore.F3(x2, x6, x0, x4, x3, x1, x5), 25) + HAVALCore.circularLeft(x7, 21) + inw[wp3[i + 0]] + K3[i + 0];
            x6 = HAVALCore.circularLeft(HAVALCore.F3(x1, x5, x7, x3, x2, x0, x4), 25) + HAVALCore.circularLeft(x6, 21) + inw[wp3[i + 1]] + K3[i + 1];
            x5 = HAVALCore.circularLeft(HAVALCore.F3(x0, x4, x6, x2, x1, x7, x3), 25) + HAVALCore.circularLeft(x5, 21) + inw[wp3[i + 2]] + K3[i + 2];
            x4 = HAVALCore.circularLeft(HAVALCore.F3(x7, x3, x5, x1, x0, x6, x2), 25) + HAVALCore.circularLeft(x4, 21) + inw[wp3[i + 3]] + K3[i + 3];
            x3 = HAVALCore.circularLeft(HAVALCore.F3(x6, x2, x4, x0, x7, x5, x1), 25) + HAVALCore.circularLeft(x3, 21) + inw[wp3[i + 4]] + K3[i + 4];
            x2 = HAVALCore.circularLeft(HAVALCore.F3(x5, x1, x3, x7, x6, x4, x0), 25) + HAVALCore.circularLeft(x2, 21) + inw[wp3[i + 5]] + K3[i + 5];
            x1 = HAVALCore.circularLeft(HAVALCore.F3(x4, x0, x2, x6, x5, x3, x7), 25) + HAVALCore.circularLeft(x1, 21) + inw[wp3[i + 6]] + K3[i + 6];
            x0 = HAVALCore.circularLeft(HAVALCore.F3(x3, x7, x1, x5, x4, x2, x6), 25) + HAVALCore.circularLeft(x0, 21) + inw[wp3[i + 7]] + K3[i + 7];
        }
        this.s0 = x0;
        this.s1 = x1;
        this.s2 = x2;
        this.s3 = x3;
        this.s4 = x4;
        this.s5 = x5;
        this.s6 = x6;
        this.s7 = x7;
    }

    private final void pass54(int[] inw) {
        int x0 = this.s0;
        int x1 = this.s1;
        int x2 = this.s2;
        int x3 = this.s3;
        int x4 = this.s4;
        int x5 = this.s5;
        int x6 = this.s6;
        int x7 = this.s7;
        for (int i = 0; i < 32; i += 8) {
            x7 = HAVALCore.circularLeft(HAVALCore.F4(x1, x5, x3, x2, x0, x4, x6), 25) + HAVALCore.circularLeft(x7, 21) + inw[wp4[i + 0]] + K4[i + 0];
            x6 = HAVALCore.circularLeft(HAVALCore.F4(x0, x4, x2, x1, x7, x3, x5), 25) + HAVALCore.circularLeft(x6, 21) + inw[wp4[i + 1]] + K4[i + 1];
            x5 = HAVALCore.circularLeft(HAVALCore.F4(x7, x3, x1, x0, x6, x2, x4), 25) + HAVALCore.circularLeft(x5, 21) + inw[wp4[i + 2]] + K4[i + 2];
            x4 = HAVALCore.circularLeft(HAVALCore.F4(x6, x2, x0, x7, x5, x1, x3), 25) + HAVALCore.circularLeft(x4, 21) + inw[wp4[i + 3]] + K4[i + 3];
            x3 = HAVALCore.circularLeft(HAVALCore.F4(x5, x1, x7, x6, x4, x0, x2), 25) + HAVALCore.circularLeft(x3, 21) + inw[wp4[i + 4]] + K4[i + 4];
            x2 = HAVALCore.circularLeft(HAVALCore.F4(x4, x0, x6, x5, x3, x7, x1), 25) + HAVALCore.circularLeft(x2, 21) + inw[wp4[i + 5]] + K4[i + 5];
            x1 = HAVALCore.circularLeft(HAVALCore.F4(x3, x7, x5, x4, x2, x6, x0), 25) + HAVALCore.circularLeft(x1, 21) + inw[wp4[i + 6]] + K4[i + 6];
            x0 = HAVALCore.circularLeft(HAVALCore.F4(x2, x6, x4, x3, x1, x5, x7), 25) + HAVALCore.circularLeft(x0, 21) + inw[wp4[i + 7]] + K4[i + 7];
        }
        this.s0 = x0;
        this.s1 = x1;
        this.s2 = x2;
        this.s3 = x3;
        this.s4 = x4;
        this.s5 = x5;
        this.s6 = x6;
        this.s7 = x7;
    }

    private final void pass55(int[] inw) {
        int x0 = this.s0;
        int x1 = this.s1;
        int x2 = this.s2;
        int x3 = this.s3;
        int x4 = this.s4;
        int x5 = this.s5;
        int x6 = this.s6;
        int x7 = this.s7;
        for (int i = 0; i < 32; i += 8) {
            x7 = HAVALCore.circularLeft(HAVALCore.F5(x2, x5, x0, x6, x4, x3, x1), 25) + HAVALCore.circularLeft(x7, 21) + inw[wp5[i + 0]] + K5[i + 0];
            x6 = HAVALCore.circularLeft(HAVALCore.F5(x1, x4, x7, x5, x3, x2, x0), 25) + HAVALCore.circularLeft(x6, 21) + inw[wp5[i + 1]] + K5[i + 1];
            x5 = HAVALCore.circularLeft(HAVALCore.F5(x0, x3, x6, x4, x2, x1, x7), 25) + HAVALCore.circularLeft(x5, 21) + inw[wp5[i + 2]] + K5[i + 2];
            x4 = HAVALCore.circularLeft(HAVALCore.F5(x7, x2, x5, x3, x1, x0, x6), 25) + HAVALCore.circularLeft(x4, 21) + inw[wp5[i + 3]] + K5[i + 3];
            x3 = HAVALCore.circularLeft(HAVALCore.F5(x6, x1, x4, x2, x0, x7, x5), 25) + HAVALCore.circularLeft(x3, 21) + inw[wp5[i + 4]] + K5[i + 4];
            x2 = HAVALCore.circularLeft(HAVALCore.F5(x5, x0, x3, x1, x7, x6, x4), 25) + HAVALCore.circularLeft(x2, 21) + inw[wp5[i + 5]] + K5[i + 5];
            x1 = HAVALCore.circularLeft(HAVALCore.F5(x4, x7, x2, x0, x6, x5, x3), 25) + HAVALCore.circularLeft(x1, 21) + inw[wp5[i + 6]] + K5[i + 6];
            x0 = HAVALCore.circularLeft(HAVALCore.F5(x3, x6, x1, x7, x5, x4, x2), 25) + HAVALCore.circularLeft(x0, 21) + inw[wp5[i + 7]] + K5[i + 7];
        }
        this.s0 = x0;
        this.s1 = x1;
        this.s2 = x2;
        this.s3 = x3;
        this.s4 = x4;
        this.s5 = x5;
        this.s6 = x6;
        this.s7 = x7;
    }

    private static final int mix128(int a0, int a1, int a2, int a3, int n) {
        int tmp = a0 & 0xFF | a1 & 0xFF00 | a2 & 0xFF0000 | a3 & 0xFF000000;
        if (n > 0) {
            tmp = HAVALCore.circularLeft(tmp, n);
        }
        return tmp;
    }

    private static final int mix160_0(int x5, int x6, int x7) {
        return HAVALCore.circularLeft(x5 & 0x1F80000 | x6 & 0xFE000000 | x7 & 0x3F, 13);
    }

    private static final int mix160_1(int x5, int x6, int x7) {
        return HAVALCore.circularLeft(x5 & 0xFE000000 | x6 & 0x3F | x7 & 0xFC0, 7);
    }

    private static final int mix160_2(int x5, int x6, int x7) {
        return x5 & 0x3F | x6 & 0xFC0 | x7 & 0x7F000;
    }

    private static final int mix160_3(int x5, int x6, int x7) {
        return (x5 & 0xFC0 | x6 & 0x7F000 | x7 & 0x1F80000) >>> 6;
    }

    private static final int mix160_4(int x5, int x6, int x7) {
        return (x5 & 0x7F000 | x6 & 0x1F80000 | x7 & 0xFE000000) >>> 12;
    }

    private static final int mix192_0(int x6, int x7) {
        return HAVALCore.circularLeft(x6 & 0xFC000000 | x7 & 0x1F, 6);
    }

    private static final int mix192_1(int x6, int x7) {
        return x6 & 0x1F | x7 & 0x3E0;
    }

    private static final int mix192_2(int x6, int x7) {
        return (x6 & 0x3E0 | x7 & 0xFC00) >>> 5;
    }

    private static final int mix192_3(int x6, int x7) {
        return (x6 & 0xFC00 | x7 & 0x1F0000) >>> 10;
    }

    private static final int mix192_4(int x6, int x7) {
        return (x6 & 0x1F0000 | x7 & 0x3E00000) >>> 16;
    }

    private static final int mix192_5(int x6, int x7) {
        return (x6 & 0x3E00000 | x7 & 0xFC000000) >>> 21;
    }

    private final void write128(byte[] out, int off) {
        HAVALCore.encodeLEInt(this.s0 + HAVALCore.mix128(this.s7, this.s4, this.s5, this.s6, 24), out, off);
        HAVALCore.encodeLEInt(this.s1 + HAVALCore.mix128(this.s6, this.s7, this.s4, this.s5, 16), out, off + 4);
        HAVALCore.encodeLEInt(this.s2 + HAVALCore.mix128(this.s5, this.s6, this.s7, this.s4, 8), out, off + 8);
        HAVALCore.encodeLEInt(this.s3 + HAVALCore.mix128(this.s4, this.s5, this.s6, this.s7, 0), out, off + 12);
    }

    private final void write160(byte[] out, int off) {
        HAVALCore.encodeLEInt(this.s0 + HAVALCore.mix160_0(this.s5, this.s6, this.s7), out, off);
        HAVALCore.encodeLEInt(this.s1 + HAVALCore.mix160_1(this.s5, this.s6, this.s7), out, off + 4);
        HAVALCore.encodeLEInt(this.s2 + HAVALCore.mix160_2(this.s5, this.s6, this.s7), out, off + 8);
        HAVALCore.encodeLEInt(this.s3 + HAVALCore.mix160_3(this.s5, this.s6, this.s7), out, off + 12);
        HAVALCore.encodeLEInt(this.s4 + HAVALCore.mix160_4(this.s5, this.s6, this.s7), out, off + 16);
    }

    private final void write192(byte[] out, int off) {
        HAVALCore.encodeLEInt(this.s0 + HAVALCore.mix192_0(this.s6, this.s7), out, off);
        HAVALCore.encodeLEInt(this.s1 + HAVALCore.mix192_1(this.s6, this.s7), out, off + 4);
        HAVALCore.encodeLEInt(this.s2 + HAVALCore.mix192_2(this.s6, this.s7), out, off + 8);
        HAVALCore.encodeLEInt(this.s3 + HAVALCore.mix192_3(this.s6, this.s7), out, off + 12);
        HAVALCore.encodeLEInt(this.s4 + HAVALCore.mix192_4(this.s6, this.s7), out, off + 16);
        HAVALCore.encodeLEInt(this.s5 + HAVALCore.mix192_5(this.s6, this.s7), out, off + 20);
    }

    private final void write224(byte[] out, int off) {
        HAVALCore.encodeLEInt(this.s0 + (this.s7 >>> 27 & 0x1F), out, off);
        HAVALCore.encodeLEInt(this.s1 + (this.s7 >>> 22 & 0x1F), out, off + 4);
        HAVALCore.encodeLEInt(this.s2 + (this.s7 >>> 18 & 0xF), out, off + 8);
        HAVALCore.encodeLEInt(this.s3 + (this.s7 >>> 13 & 0x1F), out, off + 12);
        HAVALCore.encodeLEInt(this.s4 + (this.s7 >>> 9 & 0xF), out, off + 16);
        HAVALCore.encodeLEInt(this.s5 + (this.s7 >>> 4 & 0x1F), out, off + 20);
        HAVALCore.encodeLEInt(this.s6 + (this.s7 & 0xF), out, off + 24);
    }

    private final void write256(byte[] out, int off) {
        HAVALCore.encodeLEInt(this.s0, out, off);
        HAVALCore.encodeLEInt(this.s1, out, off + 4);
        HAVALCore.encodeLEInt(this.s2, out, off + 8);
        HAVALCore.encodeLEInt(this.s3, out, off + 12);
        HAVALCore.encodeLEInt(this.s4, out, off + 16);
        HAVALCore.encodeLEInt(this.s5, out, off + 20);
        HAVALCore.encodeLEInt(this.s6, out, off + 24);
        HAVALCore.encodeLEInt(this.s7, out, off + 28);
    }

    private final void writeOutput(byte[] out, int off) {
        switch (this.olen) {
            case 4: {
                this.write128(out, off);
                break;
            }
            case 5: {
                this.write160(out, off);
                break;
            }
            case 6: {
                this.write192(out, off);
                break;
            }
            case 7: {
                this.write224(out, off);
                break;
            }
            case 8: {
                this.write256(out, off);
            }
        }
    }

    @Override
    public String toString() {
        return "HAVAL-" + this.passes + "-" + (this.olen << 5);
    }
}

