/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.DigestEngine;

abstract class JHCore
extends DigestEngine {
    private long[] h;
    private byte[] tmpBuf;
    private static final long[] C = new long[]{8274764681471981671L, 8900261899357328727L, -9102946306537912330L, 5665334567067790144L, -1542418137079219556L, 271854908820593050L, 7350603245732713354L, -5380090600649678287L, 262152557086445275L, 4629614700257166352L, 2019048047717029149L, 8013007291876363740L, 1205297368107281217L, -2560185243135170608L, 733102922101586000L, 4547157683538530771L, 4768566596476894864L, -2494255748784023602L, 1755461623795631276L, -3323826028504744925L, -7534966363738032102L, 2379384386751360168L, -1229197120032054790L, -173784742355566185L, 5372377880443695151L, 3055566100828744341L, -8431174450330179220L, -8446656927907233260L, -4182694446811881788L, 8450001566304418688L, 5971339587713534140L, -9027465321654082572L, -8145728373954223339L, -6170118248269874807L, -5264165765638332163L, 3948224596204989494L, -3591280664646870979L, 5997380132348251047L, -3389768675546463866L, 1053188660387142303L, -6411711451044224406L, -8427597479327230169L, 5148748137111752767L, -2260667994403354501L, 960685800557159616L, -7934243445868138082L, -8757686525650498092L, 9123829134410494050L, -243440755302719366L, -2025465341635409532L, 5753230831627441624L, 6137981954248889509L, 6620135496569744936L, 8716013262747321522L, 398987411935843118L, 4935544445029865855L, 8097306342985052490L, 6811176502497305701L, -4099552175356043033L, 8430250216796751754L, 9018995518020687090L, -2464742189378250303L, 2097323907607174112L, -2727974866558090561L, -6564073209225756673L, 950897263334964296L, 4300651987268784953L, 5016943747370945440L, -1888971980364969713L, -7750637705673772748L, -6741405948461126251L, -1640561275338516406L, -8628864572311407083L, 5170488938381619199L, 9131975072163743280L, 5075757740701158630L, -6569163788999734784L, -2693851541080762194L, 8311338433895518637L, -1682430464362797721L, -6639839726187650794L, 3740527943128226202L, 2261002866710774907L, -3328533410421308136L, 3628031724251584979L, 5807986283269960774L, -6972307350241383494L, -663689772663378306L, 2283740534820839796L, -1603854084275285522L, 2114348054589002614L, 4199258101489954817L, -633387212651308990L, 8713880478872725369L, 4720725780189600680L, -377392741023011709L, -6395046466063742989L, 6431404377087243930L, -1783902173103304707L, -5116778321973650961L, -8242981184573150246L, 6603076713971937293L, 9023998488799434116L, -745932942417031579L, -6865558462163567789L, 911987301695810650L, -7968956184387876785L, 6606882177667480652L, -2036968874053233541L, 8492369249240292445L, 7254925341233558381L, 7797038620990823281L, -548908150274830038L, -2027917035486480900L, 2066234073466945442L, 7474798062228489136L, 3677852971127382389L, 9165978963130340188L, -7909564755063780066L, 8751749545235230527L, -1537745112235624159L, 6698117124203947857L, 2784108936669838546L, 4945822424217605549L, -5396087892882568952L, -8982080256329696170L, 5546319973959753805L, 5107713973427292150L, 3429547963116713566L, 3158825051525277226L, 501226569294009398L, 8425814982732489059L, -161762289767954071L, -6377841699320211418L, 9133603604121319958L, 9119981922630737215L, -3257805798644133364L, 6893548888281844784L, 8370592016427397784L, 1002949050113128602L, 5459944377427261842L, -49004760727656237L, -7267880333719738575L, -3682072082334976763L, -5659193112414491442L, 4330020297790300770L, -852363732779068089L, -52261427748836792L, 4098090974333265253L, -937737690310881138L, 3562398178333149830L, -1134896513894824114L, 7323114926207613059L, -621803272269972803L, 2420599201031518319L, -6681954461186793753L, -8385457222894382375L, 4361164450428633790L, -2835037420214833026L, 6020606654976796894L, -6186311379196941864L, 6554501062033869049L, -4584682175667234395L, -7544261430254689942L, 3869885319717393776L, -1576805519710137189L, -7291218252203081614L, -687469922002440222L};

    JHCore() {
    }

    private static final void encodeBELong(long val, byte[] buf, int off) {
        buf[off + 0] = (byte)(val >>> 56);
        buf[off + 1] = (byte)(val >>> 48);
        buf[off + 2] = (byte)(val >>> 40);
        buf[off + 3] = (byte)(val >>> 32);
        buf[off + 4] = (byte)(val >>> 24);
        buf[off + 5] = (byte)(val >>> 16);
        buf[off + 6] = (byte)(val >>> 8);
        buf[off + 7] = (byte)val;
    }

    private static final long decodeBELong(byte[] buf, int off) {
        return ((long)buf[off + 0] & 0xFFL) << 56 | ((long)buf[off + 1] & 0xFFL) << 48 | ((long)buf[off + 2] & 0xFFL) << 40 | ((long)buf[off + 3] & 0xFFL) << 32 | ((long)buf[off + 4] & 0xFFL) << 24 | ((long)buf[off + 5] & 0xFFL) << 16 | ((long)buf[off + 6] & 0xFFL) << 8 | (long)buf[off + 7] & 0xFFL;
    }

    @Override
    protected void engineReset() {
        this.doReset();
    }

    private final void doS(int r) {
        long cc = C[(r << 2) + 0];
        long x0 = this.h[0];
        long x1 = this.h[4];
        long x2 = this.h[8];
        long x3 = this.h[12];
        long tmp = cc ^ (x0 ^= cc & (x2 ^ 0xFFFFFFFFFFFFFFFFL)) & x1;
        x3 ^= (x1 ^ 0xFFFFFFFFFFFFFFFFL) & x2;
        x1 ^= (x0 ^= x2 & (x3 ^= 0xFFFFFFFFFFFFFFFFL)) & x2;
        x2 ^= x0 & (x3 ^ 0xFFFFFFFFFFFFFFFFL);
        x0 ^= x1 | x3;
        x3 ^= x1 & x2;
        this.h[0] = x0;
        this.h[4] = x1 ^= tmp & x0;
        this.h[8] = x2 ^= tmp;
        this.h[12] = x3;
        cc = C[(r << 2) + 1];
        x0 = this.h[1];
        x1 = this.h[5];
        x2 = this.h[9];
        x3 = this.h[13];
        tmp = cc ^ (x0 ^= cc & (x2 ^ 0xFFFFFFFFFFFFFFFFL)) & x1;
        x3 ^= (x1 ^ 0xFFFFFFFFFFFFFFFFL) & x2;
        x1 ^= (x0 ^= x2 & (x3 ^= 0xFFFFFFFFFFFFFFFFL)) & x2;
        x2 ^= x0 & (x3 ^ 0xFFFFFFFFFFFFFFFFL);
        x0 ^= x1 | x3;
        x3 ^= x1 & x2;
        this.h[1] = x0;
        this.h[5] = x1 ^= tmp & x0;
        this.h[9] = x2 ^= tmp;
        this.h[13] = x3;
        cc = C[(r << 2) + 2];
        x0 = this.h[2];
        x1 = this.h[6];
        x2 = this.h[10];
        x3 = this.h[14];
        tmp = cc ^ (x0 ^= cc & (x2 ^ 0xFFFFFFFFFFFFFFFFL)) & x1;
        x3 ^= (x1 ^ 0xFFFFFFFFFFFFFFFFL) & x2;
        x1 ^= (x0 ^= x2 & (x3 ^= 0xFFFFFFFFFFFFFFFFL)) & x2;
        x2 ^= x0 & (x3 ^ 0xFFFFFFFFFFFFFFFFL);
        x0 ^= x1 | x3;
        x3 ^= x1 & x2;
        this.h[2] = x0;
        this.h[6] = x1 ^= tmp & x0;
        this.h[10] = x2 ^= tmp;
        this.h[14] = x3;
        cc = C[(r << 2) + 3];
        x0 = this.h[3];
        x1 = this.h[7];
        x2 = this.h[11];
        x3 = this.h[15];
        tmp = cc ^ (x0 ^= cc & (x2 ^ 0xFFFFFFFFFFFFFFFFL)) & x1;
        x3 ^= (x1 ^ 0xFFFFFFFFFFFFFFFFL) & x2;
        x1 ^= (x0 ^= x2 & (x3 ^= 0xFFFFFFFFFFFFFFFFL)) & x2;
        x2 ^= x0 & (x3 ^ 0xFFFFFFFFFFFFFFFFL);
        x0 ^= x1 | x3;
        x3 ^= x1 & x2;
        this.h[3] = x0;
        this.h[7] = x1 ^= tmp & x0;
        this.h[11] = x2 ^= tmp;
        this.h[15] = x3;
    }

    private final void doL() {
        long x0 = this.h[0];
        long x1 = this.h[4];
        long x2 = this.h[8];
        long x3 = this.h[12];
        long x4 = this.h[2];
        long x5 = this.h[6];
        long x6 = this.h[10];
        long x7 = this.h[14];
        x4 ^= x1;
        x6 ^= x3 ^ x0;
        x7 ^= x0;
        x0 ^= (x5 ^= x2);
        this.h[0] = x0;
        this.h[4] = x1 ^= x6;
        this.h[8] = x2 ^= x7 ^ x4;
        this.h[12] = x3 ^= x4;
        this.h[2] = x4;
        this.h[6] = x5;
        this.h[10] = x6;
        this.h[14] = x7;
        x0 = this.h[1];
        x1 = this.h[5];
        x2 = this.h[9];
        x3 = this.h[13];
        x4 = this.h[3];
        x5 = this.h[7];
        x6 = this.h[11];
        x7 = this.h[15];
        x4 ^= x1;
        x6 ^= x3 ^ x0;
        x7 ^= x0;
        x0 ^= (x5 ^= x2);
        this.h[1] = x0;
        this.h[5] = x1 ^= x6;
        this.h[9] = x2 ^= x7 ^ x4;
        this.h[13] = x3 ^= x4;
        this.h[3] = x4;
        this.h[7] = x5;
        this.h[11] = x6;
        this.h[15] = x7;
    }

    private final void doWgen(long c, int n) {
        this.h[2] = (this.h[2] & c) << n | this.h[2] >>> n & c;
        this.h[3] = (this.h[3] & c) << n | this.h[3] >>> n & c;
        this.h[6] = (this.h[6] & c) << n | this.h[6] >>> n & c;
        this.h[7] = (this.h[7] & c) << n | this.h[7] >>> n & c;
        this.h[10] = (this.h[10] & c) << n | this.h[10] >>> n & c;
        this.h[11] = (this.h[11] & c) << n | this.h[11] >>> n & c;
        this.h[14] = (this.h[14] & c) << n | this.h[14] >>> n & c;
        this.h[15] = (this.h[15] & c) << n | this.h[15] >>> n & c;
    }

    private final void doW6() {
        long t = this.h[2];
        this.h[2] = this.h[3];
        this.h[3] = t;
        t = this.h[6];
        this.h[6] = this.h[7];
        this.h[7] = t;
        t = this.h[10];
        this.h[10] = this.h[11];
        this.h[11] = t;
        t = this.h[14];
        this.h[14] = this.h[15];
        this.h[15] = t;
    }

    @Override
    protected void processBlock(byte[] data) {
        long m0h = JHCore.decodeBELong(data, 0);
        long m0l = JHCore.decodeBELong(data, 8);
        long m1h = JHCore.decodeBELong(data, 16);
        long m1l = JHCore.decodeBELong(data, 24);
        long m2h = JHCore.decodeBELong(data, 32);
        long m2l = JHCore.decodeBELong(data, 40);
        long m3h = JHCore.decodeBELong(data, 48);
        long m3l = JHCore.decodeBELong(data, 56);
        this.h[0] = this.h[0] ^ m0h;
        this.h[1] = this.h[1] ^ m0l;
        this.h[2] = this.h[2] ^ m1h;
        this.h[3] = this.h[3] ^ m1l;
        this.h[4] = this.h[4] ^ m2h;
        this.h[5] = this.h[5] ^ m2l;
        this.h[6] = this.h[6] ^ m3h;
        this.h[7] = this.h[7] ^ m3l;
        for (int r = 0; r < 42; r += 7) {
            this.doS(r + 0);
            this.doL();
            this.doWgen(0x5555555555555555L, 1);
            this.doS(r + 1);
            this.doL();
            this.doWgen(0x3333333333333333L, 2);
            this.doS(r + 2);
            this.doL();
            this.doWgen(0xF0F0F0F0F0F0F0FL, 4);
            this.doS(r + 3);
            this.doL();
            this.doWgen(0xFF00FF00FF00FFL, 8);
            this.doS(r + 4);
            this.doL();
            this.doWgen(0xFFFF0000FFFFL, 16);
            this.doS(r + 5);
            this.doL();
            this.doWgen(0xFFFFFFFFL, 32);
            this.doS(r + 6);
            this.doL();
            this.doW6();
        }
        this.h[8] = this.h[8] ^ m0h;
        this.h[9] = this.h[9] ^ m0l;
        this.h[10] = this.h[10] ^ m1h;
        this.h[11] = this.h[11] ^ m1l;
        this.h[12] = this.h[12] ^ m2h;
        this.h[13] = this.h[13] ^ m2l;
        this.h[14] = this.h[14] ^ m3h;
        this.h[15] = this.h[15] ^ m3l;
    }

    @Override
    protected void doPadding(byte[] buf, int off) {
        int i;
        int rem = this.flush();
        long bc = this.getBlockCount();
        int numz = rem == 0 ? 47 : 111 - rem;
        this.tmpBuf[0] = -128;
        for (i = 1; i <= numz; ++i) {
            this.tmpBuf[i] = 0;
        }
        JHCore.encodeBELong(bc >>> 55, this.tmpBuf, numz + 1);
        JHCore.encodeBELong((bc << 9) + (long)(rem << 3), this.tmpBuf, numz + 9);
        this.update(this.tmpBuf, 0, numz + 17);
        for (i = 0; i < 8; ++i) {
            JHCore.encodeBELong(this.h[i + 8], this.tmpBuf, i << 3);
        }
        int dlen = this.getDigestLength();
        System.arraycopy(this.tmpBuf, 64 - dlen, buf, off, dlen);
    }

    @Override
    protected void doInit() {
        this.h = new long[16];
        this.tmpBuf = new byte[128];
        this.doReset();
    }

    abstract long[] getIV();

    @Override
    public int getBlockLength() {
        return 64;
    }

    private final void doReset() {
        System.arraycopy(this.getIV(), 0, this.h, 0, 16);
    }

    protected Digest copyState(JHCore dst) {
        System.arraycopy(this.h, 0, dst.h, 0, 16);
        return super.copyState(dst);
    }

    @Override
    public String toString() {
        return "JH-" + (this.getDigestLength() << 3);
    }
}

