/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.DigestEngine;

public class Luffa512
extends DigestEngine {
    private static final int[] IV = new int[]{1831149161, 1152405984, 1319792564, -604535707, 1848188945, -1877660172, -301629127, -554299205, -1011594347, -640486826, 1894705568, -569794653, 1570440535, -1882635085, -820195570, 1953289601, -135280483, 1572493185, 67202277, -1385849851, 50731343, 1718425654, 615129866, -1960424729, -2055178795, 920100046, -445515817, 541794151, 898042986, 1474947363, 347912200, 2094953166, 1818814910, 1589911074, -937052217, -1342487709, -169920103, 264669425, -1334696756, 65563882};
    private static final int[] RC00 = new int[]{809079974, -1058647399, 1824733714, -598304706, 503320719, 2013282877, -1889830782, -1763583214};
    private static final int[] RC04 = new int[]{-533497832, 1142663437, 2134168642, -1819729537, -441926426, 1383381748, 646486951, -1709019491};
    private static final int[] RC10 = new int[]{-1226960659, 1895070382, 117941204, 471764817, 1887059269, -1364032158, -1161161335, 1084518206};
    private static final int[] RC14 = new int[]{23617341, 94469364, -1123431734, -198759640, 340452812, -89674197, 776532417, -1188837628};
    private static final int[] RC20 = new int[]{-64955950, 877997605, 2061009295, -2076674486, -1150427086, -306741048, -645631146, -1563982796};
    private static final int[] RC24 = new int[]{-497126719, -433865870, 1549313188, 507044583, 2028178333, 660104985, 921544063, 1882893543};
    private static final int[] RC30 = new int[]{-1307332699, -934363499, 1314949666, 1457019134, 876286863, -789819843, 753617026, -1280499192};
    private static final int[] RC34 = new int[]{-534197825, 1148546961, 2123353650, -1788524354, -31908894, 1018308325, 1497670286, -1580940459};
    private static final int[] RC40 = new int[]{-254613021, -1408116742, 466314994, 1865259977, 2019567177, -1898256046, 996910408, -307325664};
    private static final int[] RC44 = new int[]{1351669111, 756622763, -1268476244, -778937680, 689117878, 264262595, 1057050380, -66765775};
    private int V00;
    private int V01;
    private int V02;
    private int V03;
    private int V04;
    private int V05;
    private int V06;
    private int V07;
    private int V10;
    private int V11;
    private int V12;
    private int V13;
    private int V14;
    private int V15;
    private int V16;
    private int V17;
    private int V20;
    private int V21;
    private int V22;
    private int V23;
    private int V24;
    private int V25;
    private int V26;
    private int V27;
    private int V30;
    private int V31;
    private int V32;
    private int V33;
    private int V34;
    private int V35;
    private int V36;
    private int V37;
    private int V40;
    private int V41;
    private int V42;
    private int V43;
    private int V44;
    private int V45;
    private int V46;
    private int V47;
    private byte[] tmpBuf;

    @Override
    public int getInternalBlockLength() {
        return 32;
    }

    @Override
    public int getBlockLength() {
        return -32;
    }

    @Override
    public int getDigestLength() {
        return 64;
    }

    @Override
    public Digest copy() {
        return this.copyState(new Luffa512());
    }

    protected Digest copyState(Luffa512 dst) {
        dst.V00 = this.V00;
        dst.V01 = this.V01;
        dst.V02 = this.V02;
        dst.V03 = this.V03;
        dst.V04 = this.V04;
        dst.V05 = this.V05;
        dst.V06 = this.V06;
        dst.V07 = this.V07;
        dst.V10 = this.V10;
        dst.V11 = this.V11;
        dst.V12 = this.V12;
        dst.V13 = this.V13;
        dst.V14 = this.V14;
        dst.V15 = this.V15;
        dst.V16 = this.V16;
        dst.V17 = this.V17;
        dst.V20 = this.V20;
        dst.V21 = this.V21;
        dst.V22 = this.V22;
        dst.V23 = this.V23;
        dst.V24 = this.V24;
        dst.V25 = this.V25;
        dst.V26 = this.V26;
        dst.V27 = this.V27;
        dst.V30 = this.V30;
        dst.V31 = this.V31;
        dst.V32 = this.V32;
        dst.V33 = this.V33;
        dst.V34 = this.V34;
        dst.V35 = this.V35;
        dst.V36 = this.V36;
        dst.V37 = this.V37;
        dst.V40 = this.V40;
        dst.V41 = this.V41;
        dst.V42 = this.V42;
        dst.V43 = this.V43;
        dst.V44 = this.V44;
        dst.V45 = this.V45;
        dst.V46 = this.V46;
        dst.V47 = this.V47;
        return super.copyState(dst);
    }

    @Override
    protected void engineReset() {
        this.V00 = IV[0];
        this.V01 = IV[1];
        this.V02 = IV[2];
        this.V03 = IV[3];
        this.V04 = IV[4];
        this.V05 = IV[5];
        this.V06 = IV[6];
        this.V07 = IV[7];
        this.V10 = IV[8];
        this.V11 = IV[9];
        this.V12 = IV[10];
        this.V13 = IV[11];
        this.V14 = IV[12];
        this.V15 = IV[13];
        this.V16 = IV[14];
        this.V17 = IV[15];
        this.V20 = IV[16];
        this.V21 = IV[17];
        this.V22 = IV[18];
        this.V23 = IV[19];
        this.V24 = IV[20];
        this.V25 = IV[21];
        this.V26 = IV[22];
        this.V27 = IV[23];
        this.V30 = IV[24];
        this.V31 = IV[25];
        this.V32 = IV[26];
        this.V33 = IV[27];
        this.V34 = IV[28];
        this.V35 = IV[29];
        this.V36 = IV[30];
        this.V37 = IV[31];
        this.V40 = IV[32];
        this.V41 = IV[33];
        this.V42 = IV[34];
        this.V43 = IV[35];
        this.V44 = IV[36];
        this.V45 = IV[37];
        this.V46 = IV[38];
        this.V47 = IV[39];
    }

    @Override
    protected void doPadding(byte[] out, int off) {
        int i;
        int ptr = this.flush();
        this.tmpBuf[ptr] = -128;
        for (i = ptr + 1; i < 32; ++i) {
            this.tmpBuf[i] = 0;
        }
        this.update(this.tmpBuf, ptr, 32 - ptr);
        for (i = 0; i < ptr + 1; ++i) {
            this.tmpBuf[i] = 0;
        }
        this.update(this.tmpBuf, 0, 32);
        Luffa512.encodeBEInt(this.V00 ^ this.V10 ^ this.V20 ^ this.V30 ^ this.V40, out, off + 0);
        Luffa512.encodeBEInt(this.V01 ^ this.V11 ^ this.V21 ^ this.V31 ^ this.V41, out, off + 4);
        Luffa512.encodeBEInt(this.V02 ^ this.V12 ^ this.V22 ^ this.V32 ^ this.V42, out, off + 8);
        Luffa512.encodeBEInt(this.V03 ^ this.V13 ^ this.V23 ^ this.V33 ^ this.V43, out, off + 12);
        Luffa512.encodeBEInt(this.V04 ^ this.V14 ^ this.V24 ^ this.V34 ^ this.V44, out, off + 16);
        Luffa512.encodeBEInt(this.V05 ^ this.V15 ^ this.V25 ^ this.V35 ^ this.V45, out, off + 20);
        Luffa512.encodeBEInt(this.V06 ^ this.V16 ^ this.V26 ^ this.V36 ^ this.V46, out, off + 24);
        Luffa512.encodeBEInt(this.V07 ^ this.V17 ^ this.V27 ^ this.V37 ^ this.V47, out, off + 28);
        this.update(this.tmpBuf, 0, 32);
        Luffa512.encodeBEInt(this.V00 ^ this.V10 ^ this.V20 ^ this.V30 ^ this.V40, out, off + 32);
        Luffa512.encodeBEInt(this.V01 ^ this.V11 ^ this.V21 ^ this.V31 ^ this.V41, out, off + 36);
        Luffa512.encodeBEInt(this.V02 ^ this.V12 ^ this.V22 ^ this.V32 ^ this.V42, out, off + 40);
        Luffa512.encodeBEInt(this.V03 ^ this.V13 ^ this.V23 ^ this.V33 ^ this.V43, out, off + 44);
        Luffa512.encodeBEInt(this.V04 ^ this.V14 ^ this.V24 ^ this.V34 ^ this.V44, out, off + 48);
        Luffa512.encodeBEInt(this.V05 ^ this.V15 ^ this.V25 ^ this.V35 ^ this.V45, out, off + 52);
        Luffa512.encodeBEInt(this.V06 ^ this.V16 ^ this.V26 ^ this.V36 ^ this.V46, out, off + 56);
        Luffa512.encodeBEInt(this.V07 ^ this.V17 ^ this.V27 ^ this.V37 ^ this.V47, out, off + 60);
    }

    @Override
    protected void doInit() {
        this.tmpBuf = new byte[32];
        this.engineReset();
    }

    private static final void encodeBEInt(int val, byte[] buf, int off) {
        buf[off + 0] = (byte)(val >>> 24);
        buf[off + 1] = (byte)(val >>> 16);
        buf[off + 2] = (byte)(val >>> 8);
        buf[off + 3] = (byte)val;
    }

    private static final int decodeBEInt(byte[] buf, int off) {
        return (buf[off] & 0xFF) << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
    }

    @Override
    protected void processBlock(byte[] data) {
        int r;
        int M0 = Luffa512.decodeBEInt(data, 0);
        int M1 = Luffa512.decodeBEInt(data, 4);
        int M2 = Luffa512.decodeBEInt(data, 8);
        int M3 = Luffa512.decodeBEInt(data, 12);
        int M4 = Luffa512.decodeBEInt(data, 16);
        int M5 = Luffa512.decodeBEInt(data, 20);
        int M6 = Luffa512.decodeBEInt(data, 24);
        int M7 = Luffa512.decodeBEInt(data, 28);
        int a0 = this.V00 ^ this.V10;
        int a1 = this.V01 ^ this.V11;
        int a2 = this.V02 ^ this.V12;
        int a3 = this.V03 ^ this.V13;
        int a4 = this.V04 ^ this.V14;
        int a5 = this.V05 ^ this.V15;
        int a6 = this.V06 ^ this.V16;
        int a7 = this.V07 ^ this.V17;
        int b0 = this.V20 ^ this.V30;
        int b1 = this.V21 ^ this.V31;
        int b2 = this.V22 ^ this.V32;
        int b3 = this.V23 ^ this.V33;
        int b4 = this.V24 ^ this.V34;
        int b5 = this.V25 ^ this.V35;
        int b6 = this.V26 ^ this.V36;
        int b7 = this.V27 ^ this.V37;
        a0 ^= b0;
        a1 ^= b1;
        a2 ^= b2;
        a3 ^= b3;
        a4 ^= b4;
        a5 ^= b5;
        a6 ^= b6;
        a7 ^= b7;
        a0 ^= this.V40;
        a1 ^= this.V41;
        a2 ^= this.V42;
        int tmp = a7 ^= this.V47;
        a7 = a6 ^= this.V46;
        a6 = a5 ^= this.V45;
        a5 = a4 ^= this.V44;
        a4 = (a3 ^= this.V43) ^ tmp;
        a3 = a2 ^ tmp;
        a2 = a1;
        a1 = a0 ^ tmp;
        a0 = tmp;
        this.V00 = a0 ^ this.V00;
        this.V01 = a1 ^ this.V01;
        this.V02 = a2 ^ this.V02;
        this.V03 = a3 ^ this.V03;
        this.V04 = a4 ^ this.V04;
        this.V05 = a5 ^ this.V05;
        this.V06 = a6 ^ this.V06;
        this.V07 = a7 ^ this.V07;
        this.V10 = a0 ^ this.V10;
        this.V11 = a1 ^ this.V11;
        this.V12 = a2 ^ this.V12;
        this.V13 = a3 ^ this.V13;
        this.V14 = a4 ^ this.V14;
        this.V15 = a5 ^ this.V15;
        this.V16 = a6 ^ this.V16;
        this.V17 = a7 ^ this.V17;
        this.V20 = a0 ^ this.V20;
        this.V21 = a1 ^ this.V21;
        this.V22 = a2 ^ this.V22;
        this.V23 = a3 ^ this.V23;
        this.V24 = a4 ^ this.V24;
        this.V25 = a5 ^ this.V25;
        this.V26 = a6 ^ this.V26;
        this.V27 = a7 ^ this.V27;
        this.V30 = a0 ^ this.V30;
        this.V31 = a1 ^ this.V31;
        this.V32 = a2 ^ this.V32;
        this.V33 = a3 ^ this.V33;
        this.V34 = a4 ^ this.V34;
        this.V35 = a5 ^ this.V35;
        this.V36 = a6 ^ this.V36;
        this.V37 = a7 ^ this.V37;
        this.V40 = a0 ^ this.V40;
        this.V41 = a1 ^ this.V41;
        this.V42 = a2 ^ this.V42;
        this.V43 = a3 ^ this.V43;
        this.V44 = a4 ^ this.V44;
        this.V45 = a5 ^ this.V45;
        this.V46 = a6 ^ this.V46;
        this.V47 = a7 ^ this.V47;
        tmp = this.V07;
        b7 = this.V06;
        b6 = this.V05;
        b5 = this.V04;
        b4 = this.V03 ^ tmp;
        b3 = this.V02 ^ tmp;
        b2 = this.V01;
        b1 = this.V00 ^ tmp;
        b0 = tmp;
        b0 ^= this.V10;
        b1 ^= this.V11;
        b2 ^= this.V12;
        b3 ^= this.V13;
        b4 ^= this.V14;
        b5 ^= this.V15;
        b6 ^= this.V16;
        b7 ^= this.V17;
        tmp = this.V17;
        this.V17 = this.V16;
        this.V16 = this.V15;
        this.V15 = this.V14;
        this.V14 = this.V13 ^ tmp;
        this.V13 = this.V12 ^ tmp;
        this.V12 = this.V11;
        this.V11 = this.V10 ^ tmp;
        this.V10 = tmp;
        this.V10 ^= this.V20;
        this.V11 ^= this.V21;
        this.V12 ^= this.V22;
        this.V13 ^= this.V23;
        this.V14 ^= this.V24;
        this.V15 ^= this.V25;
        this.V16 ^= this.V26;
        this.V17 ^= this.V27;
        tmp = this.V27;
        this.V27 = this.V26;
        this.V26 = this.V25;
        this.V25 = this.V24;
        this.V24 = this.V23 ^ tmp;
        this.V23 = this.V22 ^ tmp;
        this.V22 = this.V21;
        this.V21 = this.V20 ^ tmp;
        this.V20 = tmp;
        this.V20 ^= this.V30;
        this.V21 ^= this.V31;
        this.V22 ^= this.V32;
        this.V23 ^= this.V33;
        this.V24 ^= this.V34;
        this.V25 ^= this.V35;
        this.V26 ^= this.V36;
        this.V27 ^= this.V37;
        tmp = this.V37;
        this.V37 = this.V36;
        this.V36 = this.V35;
        this.V35 = this.V34;
        this.V34 = this.V33 ^ tmp;
        this.V33 = this.V32 ^ tmp;
        this.V32 = this.V31;
        this.V31 = this.V30 ^ tmp;
        this.V30 = tmp;
        this.V30 ^= this.V40;
        this.V31 ^= this.V41;
        this.V32 ^= this.V42;
        this.V33 ^= this.V43;
        this.V34 ^= this.V44;
        this.V35 ^= this.V45;
        this.V36 ^= this.V46;
        this.V37 ^= this.V47;
        tmp = this.V47;
        this.V47 = this.V46;
        this.V46 = this.V45;
        this.V45 = this.V44;
        this.V44 = this.V43 ^ tmp;
        this.V43 = this.V42 ^ tmp;
        this.V42 = this.V41;
        this.V41 = this.V40 ^ tmp;
        this.V40 = tmp;
        this.V40 ^= this.V00;
        this.V41 ^= this.V01;
        this.V42 ^= this.V02;
        this.V43 ^= this.V03;
        this.V44 ^= this.V04;
        this.V45 ^= this.V05;
        this.V46 ^= this.V06;
        this.V47 ^= this.V07;
        tmp = b7;
        this.V07 = b6;
        this.V06 = b5;
        this.V05 = b4;
        this.V04 = b3 ^ tmp;
        this.V03 = b2 ^ tmp;
        this.V02 = b1;
        this.V01 = b0 ^ tmp;
        this.V00 = tmp;
        this.V00 ^= this.V40;
        this.V01 ^= this.V41;
        this.V02 ^= this.V42;
        this.V03 ^= this.V43;
        this.V04 ^= this.V44;
        this.V05 ^= this.V45;
        this.V06 ^= this.V46;
        this.V07 ^= this.V47;
        tmp = this.V47;
        this.V47 = this.V46;
        this.V46 = this.V45;
        this.V45 = this.V44;
        this.V44 = this.V43 ^ tmp;
        this.V43 = this.V42 ^ tmp;
        this.V42 = this.V41;
        this.V41 = this.V40 ^ tmp;
        this.V40 = tmp;
        this.V40 ^= this.V30;
        this.V41 ^= this.V31;
        this.V42 ^= this.V32;
        this.V43 ^= this.V33;
        this.V44 ^= this.V34;
        this.V45 ^= this.V35;
        this.V46 ^= this.V36;
        this.V47 ^= this.V37;
        tmp = this.V37;
        this.V37 = this.V36;
        this.V36 = this.V35;
        this.V35 = this.V34;
        this.V34 = this.V33 ^ tmp;
        this.V33 = this.V32 ^ tmp;
        this.V32 = this.V31;
        this.V31 = this.V30 ^ tmp;
        this.V30 = tmp;
        this.V30 ^= this.V20;
        this.V31 ^= this.V21;
        this.V32 ^= this.V22;
        this.V33 ^= this.V23;
        this.V34 ^= this.V24;
        this.V35 ^= this.V25;
        this.V36 ^= this.V26;
        this.V37 ^= this.V27;
        tmp = this.V27;
        this.V27 = this.V26;
        this.V26 = this.V25;
        this.V25 = this.V24;
        this.V24 = this.V23 ^ tmp;
        this.V23 = this.V22 ^ tmp;
        this.V22 = this.V21;
        this.V21 = this.V20 ^ tmp;
        this.V20 = tmp;
        this.V20 ^= this.V10;
        this.V21 ^= this.V11;
        this.V22 ^= this.V12;
        this.V23 ^= this.V13;
        this.V24 ^= this.V14;
        this.V25 ^= this.V15;
        this.V26 ^= this.V16;
        this.V27 ^= this.V17;
        tmp = this.V17;
        this.V17 = this.V16;
        this.V16 = this.V15;
        this.V15 = this.V14;
        this.V14 = this.V13 ^ tmp;
        this.V13 = this.V12 ^ tmp;
        this.V12 = this.V11;
        this.V11 = this.V10 ^ tmp;
        this.V10 = tmp;
        this.V10 ^= b0;
        this.V11 ^= b1;
        this.V12 ^= b2;
        this.V13 ^= b3;
        this.V14 ^= b4;
        this.V15 ^= b5;
        this.V16 ^= b6;
        this.V17 ^= b7;
        this.V00 ^= M0;
        this.V01 ^= M1;
        this.V02 ^= M2;
        this.V03 ^= M3;
        this.V04 ^= M4;
        this.V05 ^= M5;
        this.V06 ^= M6;
        this.V07 ^= M7;
        tmp = M7;
        M7 = M6;
        M6 = M5;
        M5 = M4;
        M4 = M3 ^ tmp;
        M3 = M2 ^ tmp;
        M2 = M1;
        M1 = M0 ^ tmp;
        M0 = tmp;
        this.V10 ^= M0;
        this.V11 ^= M1;
        this.V12 ^= M2;
        this.V13 ^= M3;
        this.V14 ^= M4;
        this.V15 ^= M5;
        this.V16 ^= M6;
        this.V17 ^= M7;
        tmp = M7;
        M7 = M6;
        M6 = M5;
        M5 = M4;
        M4 = M3 ^ tmp;
        M3 = M2 ^ tmp;
        M2 = M1;
        M1 = M0 ^ tmp;
        M0 = tmp;
        this.V20 ^= M0;
        this.V21 ^= M1;
        this.V22 ^= M2;
        this.V23 ^= M3;
        this.V24 ^= M4;
        this.V25 ^= M5;
        this.V26 ^= M6;
        this.V27 ^= M7;
        tmp = M7;
        M7 = M6;
        M6 = M5;
        M5 = M4;
        M4 = M3 ^ tmp;
        M3 = M2 ^ tmp;
        M2 = M1;
        M1 = M0 ^ tmp;
        M0 = tmp;
        this.V30 ^= M0;
        this.V31 ^= M1;
        this.V32 ^= M2;
        this.V33 ^= M3;
        this.V34 ^= M4;
        this.V35 ^= M5;
        this.V36 ^= M6;
        this.V37 ^= M7;
        tmp = M7;
        M7 = M6;
        M6 = M5;
        M5 = M4;
        M4 = M3 ^ tmp;
        M3 = M2 ^ tmp;
        M2 = M1;
        M1 = M0 ^ tmp;
        M0 = tmp;
        this.V40 ^= M0;
        this.V41 ^= M1;
        this.V42 ^= M2;
        this.V43 ^= M3;
        this.V44 ^= M4;
        this.V45 ^= M5;
        this.V46 ^= M6;
        this.V47 ^= M7;
        this.V14 = this.V14 << 1 | this.V14 >>> 31;
        this.V15 = this.V15 << 1 | this.V15 >>> 31;
        this.V16 = this.V16 << 1 | this.V16 >>> 31;
        this.V17 = this.V17 << 1 | this.V17 >>> 31;
        this.V24 = this.V24 << 2 | this.V24 >>> 30;
        this.V25 = this.V25 << 2 | this.V25 >>> 30;
        this.V26 = this.V26 << 2 | this.V26 >>> 30;
        this.V27 = this.V27 << 2 | this.V27 >>> 30;
        this.V34 = this.V34 << 3 | this.V34 >>> 29;
        this.V35 = this.V35 << 3 | this.V35 >>> 29;
        this.V36 = this.V36 << 3 | this.V36 >>> 29;
        this.V37 = this.V37 << 3 | this.V37 >>> 29;
        this.V44 = this.V44 << 4 | this.V44 >>> 28;
        this.V45 = this.V45 << 4 | this.V45 >>> 28;
        this.V46 = this.V46 << 4 | this.V46 >>> 28;
        this.V47 = this.V47 << 4 | this.V47 >>> 28;
        for (r = 0; r < 8; ++r) {
            tmp = this.V00;
            this.V00 |= this.V01;
            this.V02 ^= this.V03;
            this.V01 ^= 0xFFFFFFFF;
            this.V00 ^= this.V03;
            this.V03 &= tmp;
            this.V01 ^= this.V03;
            this.V03 ^= this.V02;
            this.V02 &= this.V00;
            this.V00 ^= 0xFFFFFFFF;
            this.V02 ^= this.V01;
            this.V01 |= this.V03;
            this.V03 ^= this.V02;
            this.V02 &= this.V01;
            this.V01 ^= this.V00;
            this.V00 = tmp ^= this.V01;
            tmp = this.V05;
            this.V05 |= this.V06;
            this.V07 ^= this.V04;
            this.V06 ^= 0xFFFFFFFF;
            this.V05 ^= this.V04;
            this.V04 &= tmp;
            this.V06 ^= this.V04;
            this.V04 ^= this.V07;
            this.V07 &= this.V05;
            this.V05 ^= 0xFFFFFFFF;
            this.V07 ^= this.V06;
            this.V06 |= this.V04;
            this.V04 ^= this.V07;
            this.V07 &= this.V06;
            this.V06 ^= this.V05;
            this.V05 = tmp ^= this.V06;
            this.V04 ^= this.V00;
            this.V00 = (this.V00 << 2 | this.V00 >>> 30) ^ this.V04;
            this.V04 = (this.V04 << 14 | this.V04 >>> 18) ^ this.V00;
            this.V00 = (this.V00 << 10 | this.V00 >>> 22) ^ this.V04;
            this.V04 = this.V04 << 1 | this.V04 >>> 31;
            this.V05 ^= this.V01;
            this.V01 = (this.V01 << 2 | this.V01 >>> 30) ^ this.V05;
            this.V05 = (this.V05 << 14 | this.V05 >>> 18) ^ this.V01;
            this.V01 = (this.V01 << 10 | this.V01 >>> 22) ^ this.V05;
            this.V05 = this.V05 << 1 | this.V05 >>> 31;
            this.V06 ^= this.V02;
            this.V02 = (this.V02 << 2 | this.V02 >>> 30) ^ this.V06;
            this.V06 = (this.V06 << 14 | this.V06 >>> 18) ^ this.V02;
            this.V02 = (this.V02 << 10 | this.V02 >>> 22) ^ this.V06;
            this.V06 = this.V06 << 1 | this.V06 >>> 31;
            this.V07 ^= this.V03;
            this.V03 = (this.V03 << 2 | this.V03 >>> 30) ^ this.V07;
            this.V07 = (this.V07 << 14 | this.V07 >>> 18) ^ this.V03;
            this.V03 = (this.V03 << 10 | this.V03 >>> 22) ^ this.V07;
            this.V07 = this.V07 << 1 | this.V07 >>> 31;
            this.V00 ^= RC00[r];
            this.V04 ^= RC04[r];
        }
        for (r = 0; r < 8; ++r) {
            tmp = this.V10;
            this.V10 |= this.V11;
            this.V12 ^= this.V13;
            this.V11 ^= 0xFFFFFFFF;
            this.V10 ^= this.V13;
            this.V13 &= tmp;
            this.V11 ^= this.V13;
            this.V13 ^= this.V12;
            this.V12 &= this.V10;
            this.V10 ^= 0xFFFFFFFF;
            this.V12 ^= this.V11;
            this.V11 |= this.V13;
            this.V13 ^= this.V12;
            this.V12 &= this.V11;
            this.V11 ^= this.V10;
            this.V10 = tmp ^= this.V11;
            tmp = this.V15;
            this.V15 |= this.V16;
            this.V17 ^= this.V14;
            this.V16 ^= 0xFFFFFFFF;
            this.V15 ^= this.V14;
            this.V14 &= tmp;
            this.V16 ^= this.V14;
            this.V14 ^= this.V17;
            this.V17 &= this.V15;
            this.V15 ^= 0xFFFFFFFF;
            this.V17 ^= this.V16;
            this.V16 |= this.V14;
            this.V14 ^= this.V17;
            this.V17 &= this.V16;
            this.V16 ^= this.V15;
            this.V15 = tmp ^= this.V16;
            this.V14 ^= this.V10;
            this.V10 = (this.V10 << 2 | this.V10 >>> 30) ^ this.V14;
            this.V14 = (this.V14 << 14 | this.V14 >>> 18) ^ this.V10;
            this.V10 = (this.V10 << 10 | this.V10 >>> 22) ^ this.V14;
            this.V14 = this.V14 << 1 | this.V14 >>> 31;
            this.V15 ^= this.V11;
            this.V11 = (this.V11 << 2 | this.V11 >>> 30) ^ this.V15;
            this.V15 = (this.V15 << 14 | this.V15 >>> 18) ^ this.V11;
            this.V11 = (this.V11 << 10 | this.V11 >>> 22) ^ this.V15;
            this.V15 = this.V15 << 1 | this.V15 >>> 31;
            this.V16 ^= this.V12;
            this.V12 = (this.V12 << 2 | this.V12 >>> 30) ^ this.V16;
            this.V16 = (this.V16 << 14 | this.V16 >>> 18) ^ this.V12;
            this.V12 = (this.V12 << 10 | this.V12 >>> 22) ^ this.V16;
            this.V16 = this.V16 << 1 | this.V16 >>> 31;
            this.V17 ^= this.V13;
            this.V13 = (this.V13 << 2 | this.V13 >>> 30) ^ this.V17;
            this.V17 = (this.V17 << 14 | this.V17 >>> 18) ^ this.V13;
            this.V13 = (this.V13 << 10 | this.V13 >>> 22) ^ this.V17;
            this.V17 = this.V17 << 1 | this.V17 >>> 31;
            this.V10 ^= RC10[r];
            this.V14 ^= RC14[r];
        }
        for (r = 0; r < 8; ++r) {
            tmp = this.V20;
            this.V20 |= this.V21;
            this.V22 ^= this.V23;
            this.V21 ^= 0xFFFFFFFF;
            this.V20 ^= this.V23;
            this.V23 &= tmp;
            this.V21 ^= this.V23;
            this.V23 ^= this.V22;
            this.V22 &= this.V20;
            this.V20 ^= 0xFFFFFFFF;
            this.V22 ^= this.V21;
            this.V21 |= this.V23;
            this.V23 ^= this.V22;
            this.V22 &= this.V21;
            this.V21 ^= this.V20;
            this.V20 = tmp ^= this.V21;
            tmp = this.V25;
            this.V25 |= this.V26;
            this.V27 ^= this.V24;
            this.V26 ^= 0xFFFFFFFF;
            this.V25 ^= this.V24;
            this.V24 &= tmp;
            this.V26 ^= this.V24;
            this.V24 ^= this.V27;
            this.V27 &= this.V25;
            this.V25 ^= 0xFFFFFFFF;
            this.V27 ^= this.V26;
            this.V26 |= this.V24;
            this.V24 ^= this.V27;
            this.V27 &= this.V26;
            this.V26 ^= this.V25;
            this.V25 = tmp ^= this.V26;
            this.V24 ^= this.V20;
            this.V20 = (this.V20 << 2 | this.V20 >>> 30) ^ this.V24;
            this.V24 = (this.V24 << 14 | this.V24 >>> 18) ^ this.V20;
            this.V20 = (this.V20 << 10 | this.V20 >>> 22) ^ this.V24;
            this.V24 = this.V24 << 1 | this.V24 >>> 31;
            this.V25 ^= this.V21;
            this.V21 = (this.V21 << 2 | this.V21 >>> 30) ^ this.V25;
            this.V25 = (this.V25 << 14 | this.V25 >>> 18) ^ this.V21;
            this.V21 = (this.V21 << 10 | this.V21 >>> 22) ^ this.V25;
            this.V25 = this.V25 << 1 | this.V25 >>> 31;
            this.V26 ^= this.V22;
            this.V22 = (this.V22 << 2 | this.V22 >>> 30) ^ this.V26;
            this.V26 = (this.V26 << 14 | this.V26 >>> 18) ^ this.V22;
            this.V22 = (this.V22 << 10 | this.V22 >>> 22) ^ this.V26;
            this.V26 = this.V26 << 1 | this.V26 >>> 31;
            this.V27 ^= this.V23;
            this.V23 = (this.V23 << 2 | this.V23 >>> 30) ^ this.V27;
            this.V27 = (this.V27 << 14 | this.V27 >>> 18) ^ this.V23;
            this.V23 = (this.V23 << 10 | this.V23 >>> 22) ^ this.V27;
            this.V27 = this.V27 << 1 | this.V27 >>> 31;
            this.V20 ^= RC20[r];
            this.V24 ^= RC24[r];
        }
        for (r = 0; r < 8; ++r) {
            tmp = this.V30;
            this.V30 |= this.V31;
            this.V32 ^= this.V33;
            this.V31 ^= 0xFFFFFFFF;
            this.V30 ^= this.V33;
            this.V33 &= tmp;
            this.V31 ^= this.V33;
            this.V33 ^= this.V32;
            this.V32 &= this.V30;
            this.V30 ^= 0xFFFFFFFF;
            this.V32 ^= this.V31;
            this.V31 |= this.V33;
            this.V33 ^= this.V32;
            this.V32 &= this.V31;
            this.V31 ^= this.V30;
            this.V30 = tmp ^= this.V31;
            tmp = this.V35;
            this.V35 |= this.V36;
            this.V37 ^= this.V34;
            this.V36 ^= 0xFFFFFFFF;
            this.V35 ^= this.V34;
            this.V34 &= tmp;
            this.V36 ^= this.V34;
            this.V34 ^= this.V37;
            this.V37 &= this.V35;
            this.V35 ^= 0xFFFFFFFF;
            this.V37 ^= this.V36;
            this.V36 |= this.V34;
            this.V34 ^= this.V37;
            this.V37 &= this.V36;
            this.V36 ^= this.V35;
            this.V35 = tmp ^= this.V36;
            this.V34 ^= this.V30;
            this.V30 = (this.V30 << 2 | this.V30 >>> 30) ^ this.V34;
            this.V34 = (this.V34 << 14 | this.V34 >>> 18) ^ this.V30;
            this.V30 = (this.V30 << 10 | this.V30 >>> 22) ^ this.V34;
            this.V34 = this.V34 << 1 | this.V34 >>> 31;
            this.V35 ^= this.V31;
            this.V31 = (this.V31 << 2 | this.V31 >>> 30) ^ this.V35;
            this.V35 = (this.V35 << 14 | this.V35 >>> 18) ^ this.V31;
            this.V31 = (this.V31 << 10 | this.V31 >>> 22) ^ this.V35;
            this.V35 = this.V35 << 1 | this.V35 >>> 31;
            this.V36 ^= this.V32;
            this.V32 = (this.V32 << 2 | this.V32 >>> 30) ^ this.V36;
            this.V36 = (this.V36 << 14 | this.V36 >>> 18) ^ this.V32;
            this.V32 = (this.V32 << 10 | this.V32 >>> 22) ^ this.V36;
            this.V36 = this.V36 << 1 | this.V36 >>> 31;
            this.V37 ^= this.V33;
            this.V33 = (this.V33 << 2 | this.V33 >>> 30) ^ this.V37;
            this.V37 = (this.V37 << 14 | this.V37 >>> 18) ^ this.V33;
            this.V33 = (this.V33 << 10 | this.V33 >>> 22) ^ this.V37;
            this.V37 = this.V37 << 1 | this.V37 >>> 31;
            this.V30 ^= RC30[r];
            this.V34 ^= RC34[r];
        }
        for (r = 0; r < 8; ++r) {
            tmp = this.V40;
            this.V40 |= this.V41;
            this.V42 ^= this.V43;
            this.V41 ^= 0xFFFFFFFF;
            this.V40 ^= this.V43;
            this.V43 &= tmp;
            this.V41 ^= this.V43;
            this.V43 ^= this.V42;
            this.V42 &= this.V40;
            this.V40 ^= 0xFFFFFFFF;
            this.V42 ^= this.V41;
            this.V41 |= this.V43;
            this.V43 ^= this.V42;
            this.V42 &= this.V41;
            this.V41 ^= this.V40;
            this.V40 = tmp ^= this.V41;
            tmp = this.V45;
            this.V45 |= this.V46;
            this.V47 ^= this.V44;
            this.V46 ^= 0xFFFFFFFF;
            this.V45 ^= this.V44;
            this.V44 &= tmp;
            this.V46 ^= this.V44;
            this.V44 ^= this.V47;
            this.V47 &= this.V45;
            this.V45 ^= 0xFFFFFFFF;
            this.V47 ^= this.V46;
            this.V46 |= this.V44;
            this.V44 ^= this.V47;
            this.V47 &= this.V46;
            this.V46 ^= this.V45;
            this.V45 = tmp ^= this.V46;
            this.V44 ^= this.V40;
            this.V40 = (this.V40 << 2 | this.V40 >>> 30) ^ this.V44;
            this.V44 = (this.V44 << 14 | this.V44 >>> 18) ^ this.V40;
            this.V40 = (this.V40 << 10 | this.V40 >>> 22) ^ this.V44;
            this.V44 = this.V44 << 1 | this.V44 >>> 31;
            this.V45 ^= this.V41;
            this.V41 = (this.V41 << 2 | this.V41 >>> 30) ^ this.V45;
            this.V45 = (this.V45 << 14 | this.V45 >>> 18) ^ this.V41;
            this.V41 = (this.V41 << 10 | this.V41 >>> 22) ^ this.V45;
            this.V45 = this.V45 << 1 | this.V45 >>> 31;
            this.V46 ^= this.V42;
            this.V42 = (this.V42 << 2 | this.V42 >>> 30) ^ this.V46;
            this.V46 = (this.V46 << 14 | this.V46 >>> 18) ^ this.V42;
            this.V42 = (this.V42 << 10 | this.V42 >>> 22) ^ this.V46;
            this.V46 = this.V46 << 1 | this.V46 >>> 31;
            this.V47 ^= this.V43;
            this.V43 = (this.V43 << 2 | this.V43 >>> 30) ^ this.V47;
            this.V47 = (this.V47 << 14 | this.V47 >>> 18) ^ this.V43;
            this.V43 = (this.V43 << 10 | this.V43 >>> 22) ^ this.V47;
            this.V47 = this.V47 << 1 | this.V47 >>> 31;
            this.V40 ^= RC40[r];
            this.V44 ^= RC44[r];
        }
    }

    @Override
    public String toString() {
        return "Luffa-512";
    }
}

