/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.MDHelper;

public class MD4
extends MDHelper {
    private int[] currentVal;

    public MD4() {
        super(true, 8);
    }

    @Override
    public Digest copy() {
        MD4 d = new MD4();
        System.arraycopy(this.currentVal, 0, d.currentVal, 0, this.currentVal.length);
        return this.copyState(d);
    }

    @Override
    public int getDigestLength() {
        return 16;
    }

    @Override
    public int getBlockLength() {
        return 64;
    }

    @Override
    protected void engineReset() {
        this.currentVal[0] = 1732584193;
        this.currentVal[1] = -271733879;
        this.currentVal[2] = -1732584194;
        this.currentVal[3] = 271733878;
    }

    @Override
    protected void doPadding(byte[] output, int outputOffset) {
        this.makeMDPadding();
        for (int i = 0; i < 4; ++i) {
            MD4.encodeLEInt(this.currentVal[i], output, outputOffset + 4 * i);
        }
    }

    @Override
    protected void doInit() {
        this.currentVal = new int[4];
        this.engineReset();
    }

    private static final void encodeLEInt(int val, byte[] buf, int off) {
        buf[off + 3] = (byte)(val >> 24 & 0xFF);
        buf[off + 2] = (byte)(val >> 16 & 0xFF);
        buf[off + 1] = (byte)(val >> 8 & 0xFF);
        buf[off + 0] = (byte)(val & 0xFF);
    }

    @Override
    protected void processBlock(byte[] data) {
        int A = this.currentVal[0];
        int B = this.currentVal[1];
        int C = this.currentVal[2];
        int D = this.currentVal[3];
        int X00 = data[0] & 0xFF | (data[1] & 0xFF) << 8 | (data[2] & 0xFF) << 16 | (data[3] & 0xFF) << 24;
        int X01 = data[4] & 0xFF | (data[5] & 0xFF) << 8 | (data[6] & 0xFF) << 16 | (data[7] & 0xFF) << 24;
        int X02 = data[8] & 0xFF | (data[9] & 0xFF) << 8 | (data[10] & 0xFF) << 16 | (data[11] & 0xFF) << 24;
        int X03 = data[12] & 0xFF | (data[13] & 0xFF) << 8 | (data[14] & 0xFF) << 16 | (data[15] & 0xFF) << 24;
        int X04 = data[16] & 0xFF | (data[17] & 0xFF) << 8 | (data[18] & 0xFF) << 16 | (data[19] & 0xFF) << 24;
        int X05 = data[20] & 0xFF | (data[21] & 0xFF) << 8 | (data[22] & 0xFF) << 16 | (data[23] & 0xFF) << 24;
        int X06 = data[24] & 0xFF | (data[25] & 0xFF) << 8 | (data[26] & 0xFF) << 16 | (data[27] & 0xFF) << 24;
        int X07 = data[28] & 0xFF | (data[29] & 0xFF) << 8 | (data[30] & 0xFF) << 16 | (data[31] & 0xFF) << 24;
        int X08 = data[32] & 0xFF | (data[33] & 0xFF) << 8 | (data[34] & 0xFF) << 16 | (data[35] & 0xFF) << 24;
        int X09 = data[36] & 0xFF | (data[37] & 0xFF) << 8 | (data[38] & 0xFF) << 16 | (data[39] & 0xFF) << 24;
        int X10 = data[40] & 0xFF | (data[41] & 0xFF) << 8 | (data[42] & 0xFF) << 16 | (data[43] & 0xFF) << 24;
        int X112 = data[44] & 0xFF | (data[45] & 0xFF) << 8 | (data[46] & 0xFF) << 16 | (data[47] & 0xFF) << 24;
        int X12 = data[48] & 0xFF | (data[49] & 0xFF) << 8 | (data[50] & 0xFF) << 16 | (data[51] & 0xFF) << 24;
        int X13 = data[52] & 0xFF | (data[53] & 0xFF) << 8 | (data[54] & 0xFF) << 16 | (data[55] & 0xFF) << 24;
        int X14 = data[56] & 0xFF | (data[57] & 0xFF) << 8 | (data[58] & 0xFF) << 16 | (data[59] & 0xFF) << 24;
        int X15 = data[60] & 0xFF | (data[61] & 0xFF) << 8 | (data[62] & 0xFF) << 16 | (data[63] & 0xFF) << 24;
        int T = A + ((C ^ D) & B ^ D) + X00;
        A = T << 3 | T >>> 29;
        T = D + ((B ^ C) & A ^ C) + X01;
        D = T << 7 | T >>> 25;
        T = C + ((A ^ B) & D ^ B) + X02;
        C = T << 11 | T >>> 21;
        T = B + ((D ^ A) & C ^ A) + X03;
        B = T << 19 | T >>> 13;
        T = A + ((C ^ D) & B ^ D) + X04;
        A = T << 3 | T >>> 29;
        T = D + ((B ^ C) & A ^ C) + X05;
        D = T << 7 | T >>> 25;
        T = C + ((A ^ B) & D ^ B) + X06;
        C = T << 11 | T >>> 21;
        T = B + ((D ^ A) & C ^ A) + X07;
        B = T << 19 | T >>> 13;
        T = A + ((C ^ D) & B ^ D) + X08;
        A = T << 3 | T >>> 29;
        T = D + ((B ^ C) & A ^ C) + X09;
        D = T << 7 | T >>> 25;
        T = C + ((A ^ B) & D ^ B) + X10;
        C = T << 11 | T >>> 21;
        T = B + ((D ^ A) & C ^ A) + X112;
        B = T << 19 | T >>> 13;
        T = A + ((C ^ D) & B ^ D) + X12;
        A = T << 3 | T >>> 29;
        T = D + ((B ^ C) & A ^ C) + X13;
        D = T << 7 | T >>> 25;
        T = C + ((A ^ B) & D ^ B) + X14;
        C = T << 11 | T >>> 21;
        T = B + ((D ^ A) & C ^ A) + X15;
        B = T << 19 | T >>> 13;
        T = A + (D & C | (D | C) & B) + X00 + 1518500249;
        A = T << 3 | T >>> 29;
        T = D + (C & B | (C | B) & A) + X04 + 1518500249;
        D = T << 5 | T >>> 27;
        T = C + (B & A | (B | A) & D) + X08 + 1518500249;
        C = T << 9 | T >>> 23;
        T = B + (A & D | (A | D) & C) + X12 + 1518500249;
        B = T << 13 | T >>> 19;
        T = A + (D & C | (D | C) & B) + X01 + 1518500249;
        A = T << 3 | T >>> 29;
        T = D + (C & B | (C | B) & A) + X05 + 1518500249;
        D = T << 5 | T >>> 27;
        T = C + (B & A | (B | A) & D) + X09 + 1518500249;
        C = T << 9 | T >>> 23;
        T = B + (A & D | (A | D) & C) + X13 + 1518500249;
        B = T << 13 | T >>> 19;
        T = A + (D & C | (D | C) & B) + X02 + 1518500249;
        A = T << 3 | T >>> 29;
        T = D + (C & B | (C | B) & A) + X06 + 1518500249;
        D = T << 5 | T >>> 27;
        T = C + (B & A | (B | A) & D) + X10 + 1518500249;
        C = T << 9 | T >>> 23;
        T = B + (A & D | (A | D) & C) + X14 + 1518500249;
        B = T << 13 | T >>> 19;
        T = A + (D & C | (D | C) & B) + X03 + 1518500249;
        A = T << 3 | T >>> 29;
        T = D + (C & B | (C | B) & A) + X07 + 1518500249;
        D = T << 5 | T >>> 27;
        T = C + (B & A | (B | A) & D) + X112 + 1518500249;
        C = T << 9 | T >>> 23;
        T = B + (A & D | (A | D) & C) + X15 + 1518500249;
        B = T << 13 | T >>> 19;
        T = A + (B ^ C ^ D) + X00 + 1859775393;
        A = T << 3 | T >>> 29;
        T = D + (A ^ B ^ C) + X08 + 1859775393;
        D = T << 9 | T >>> 23;
        T = C + (D ^ A ^ B) + X04 + 1859775393;
        C = T << 11 | T >>> 21;
        T = B + (C ^ D ^ A) + X12 + 1859775393;
        B = T << 15 | T >>> 17;
        T = A + (B ^ C ^ D) + X02 + 1859775393;
        A = T << 3 | T >>> 29;
        T = D + (A ^ B ^ C) + X10 + 1859775393;
        D = T << 9 | T >>> 23;
        T = C + (D ^ A ^ B) + X06 + 1859775393;
        C = T << 11 | T >>> 21;
        T = B + (C ^ D ^ A) + X14 + 1859775393;
        B = T << 15 | T >>> 17;
        T = A + (B ^ C ^ D) + X01 + 1859775393;
        A = T << 3 | T >>> 29;
        T = D + (A ^ B ^ C) + X09 + 1859775393;
        D = T << 9 | T >>> 23;
        T = C + (D ^ A ^ B) + X05 + 1859775393;
        C = T << 11 | T >>> 21;
        T = B + (C ^ D ^ A) + X13 + 1859775393;
        B = T << 15 | T >>> 17;
        T = A + (B ^ C ^ D) + X03 + 1859775393;
        A = T << 3 | T >>> 29;
        T = D + (A ^ B ^ C) + X112 + 1859775393;
        D = T << 9 | T >>> 23;
        T = C + (D ^ A ^ B) + X07 + 1859775393;
        C = T << 11 | T >>> 21;
        T = B + (C ^ D ^ A) + X15 + 1859775393;
        B = T << 15 | T >>> 17;
        this.currentVal[0] = this.currentVal[0] + A;
        this.currentVal[1] = this.currentVal[1] + B;
        this.currentVal[2] = this.currentVal[2] + C;
        this.currentVal[3] = this.currentVal[3] + D;
    }

    @Override
    public String toString() {
        return "MD4";
    }
}

