/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.MDHelper;

public class RIPEMD160
extends MDHelper {
    private int[] currentVal;
    private int[] X;
    private static final int[] r1 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 7, 4, 13, 1, 10, 6, 15, 3, 12, 0, 9, 5, 2, 14, 11, 8, 3, 10, 14, 4, 9, 15, 8, 1, 2, 7, 0, 6, 13, 11, 5, 12, 1, 9, 11, 10, 0, 8, 12, 4, 13, 3, 7, 15, 14, 5, 6, 2, 4, 0, 5, 9, 7, 12, 2, 10, 14, 1, 3, 8, 11, 6, 15, 13};
    private static final int[] r2 = new int[]{5, 14, 7, 0, 9, 2, 11, 4, 13, 6, 15, 8, 1, 10, 3, 12, 6, 11, 3, 7, 0, 13, 5, 10, 14, 15, 8, 12, 4, 9, 1, 2, 15, 5, 1, 3, 7, 14, 6, 9, 11, 8, 12, 2, 10, 0, 4, 13, 8, 6, 4, 1, 3, 11, 15, 0, 5, 12, 2, 13, 9, 7, 10, 14, 12, 15, 10, 4, 1, 5, 8, 7, 6, 2, 13, 14, 0, 3, 9, 11};
    private static final int[] s1 = new int[]{11, 14, 15, 12, 5, 8, 7, 9, 11, 13, 14, 15, 6, 7, 9, 8, 7, 6, 8, 13, 11, 9, 7, 15, 7, 12, 15, 9, 11, 7, 13, 12, 11, 13, 6, 7, 14, 9, 13, 15, 14, 8, 13, 6, 5, 12, 7, 5, 11, 12, 14, 15, 14, 15, 9, 8, 9, 14, 5, 6, 8, 6, 5, 12, 9, 15, 5, 11, 6, 8, 13, 12, 5, 12, 13, 14, 11, 8, 5, 6};
    private static final int[] s2 = new int[]{8, 9, 9, 11, 13, 15, 15, 5, 7, 7, 8, 11, 14, 14, 12, 6, 9, 13, 15, 7, 12, 8, 9, 11, 7, 7, 12, 7, 6, 15, 13, 11, 9, 7, 15, 11, 8, 6, 6, 14, 12, 13, 5, 14, 13, 13, 7, 5, 15, 5, 8, 11, 14, 14, 6, 14, 6, 9, 12, 9, 12, 5, 15, 8, 8, 5, 12, 9, 12, 5, 14, 6, 8, 13, 6, 5, 15, 13, 11, 11};

    public RIPEMD160() {
        super(true, 8);
    }

    @Override
    public Digest copy() {
        RIPEMD160 d = new RIPEMD160();
        System.arraycopy(this.currentVal, 0, d.currentVal, 0, this.currentVal.length);
        return this.copyState(d);
    }

    @Override
    public int getDigestLength() {
        return 20;
    }

    @Override
    public int getBlockLength() {
        return 64;
    }

    @Override
    protected void engineReset() {
        this.currentVal[0] = 1732584193;
        this.currentVal[1] = -271733879;
        this.currentVal[2] = -1732584194;
        this.currentVal[3] = 271733878;
        this.currentVal[4] = -1009589776;
    }

    @Override
    protected void doPadding(byte[] output, int outputOffset) {
        this.makeMDPadding();
        for (int i = 0; i < 5; ++i) {
            RIPEMD160.encodeLEInt(this.currentVal[i], output, outputOffset + 4 * i);
        }
    }

    @Override
    protected void doInit() {
        this.currentVal = new int[5];
        this.X = new int[16];
        this.engineReset();
    }

    private static final void encodeLEInt(int val, byte[] buf, int off) {
        buf[off + 0] = (byte)val;
        buf[off + 1] = (byte)(val >>> 8);
        buf[off + 2] = (byte)(val >>> 16);
        buf[off + 3] = (byte)(val >>> 24);
    }

    private static final int decodeLEInt(byte[] buf, int off) {
        return buf[off + 0] & 0xFF | (buf[off + 1] & 0xFF) << 8 | (buf[off + 2] & 0xFF) << 16 | (buf[off + 3] & 0xFF) << 24;
    }

    private static final int circularLeft(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    @Override
    protected void processBlock(byte[] data) {
        int T2;
        int T1;
        int E2;
        int D2;
        int C2;
        int B2;
        int A2;
        int A1 = A2 = this.currentVal[0];
        int H0 = A2;
        int B1 = B2 = this.currentVal[1];
        int H1 = B2;
        int C1 = C2 = this.currentVal[2];
        int H2 = C2;
        int D1 = D2 = this.currentVal[3];
        int H3 = D2;
        int E1 = E2 = this.currentVal[4];
        int H4 = E2;
        int i = 0;
        int j = 0;
        while (i < 16) {
            this.X[i] = RIPEMD160.decodeLEInt(data, j);
            ++i;
            j += 4;
        }
        for (i = 0; i < 16; ++i) {
            T1 = A1 + (B1 ^ C1 ^ D1) + this.X[i];
            T1 = (T1 << s1[i] | T1 >>> 32 - s1[i]) + E1;
            A1 = E1;
            E1 = D1;
            D1 = C1 << 10 | C1 >>> 22;
            C1 = B1;
            B1 = T1;
        }
        for (i = 16; i < 32; ++i) {
            T1 = A1 + ((C1 ^ D1) & B1 ^ D1) + this.X[r1[i]] + 1518500249;
            T1 = (T1 << s1[i] | T1 >>> 32 - s1[i]) + E1;
            A1 = E1;
            E1 = D1;
            D1 = C1 << 10 | C1 >>> 22;
            C1 = B1;
            B1 = T1;
        }
        for (i = 32; i < 48; ++i) {
            T1 = A1 + ((B1 | ~C1) ^ D1) + this.X[r1[i]] + 1859775393;
            T1 = (T1 << s1[i] | T1 >>> 32 - s1[i]) + E1;
            A1 = E1;
            E1 = D1;
            D1 = C1 << 10 | C1 >>> 22;
            C1 = B1;
            B1 = T1;
        }
        for (i = 48; i < 64; ++i) {
            T1 = A1 + ((B1 ^ C1) & D1 ^ C1) + this.X[r1[i]] + -1894007588;
            T1 = (T1 << s1[i] | T1 >>> 32 - s1[i]) + E1;
            A1 = E1;
            E1 = D1;
            D1 = C1 << 10 | C1 >>> 22;
            C1 = B1;
            B1 = T1;
        }
        for (i = 64; i < 80; ++i) {
            T1 = A1 + (B1 ^ (C1 | ~D1)) + this.X[r1[i]] + -1454113458;
            T1 = (T1 << s1[i] | T1 >>> 32 - s1[i]) + E1;
            A1 = E1;
            E1 = D1;
            D1 = C1 << 10 | C1 >>> 22;
            C1 = B1;
            B1 = T1;
        }
        for (i = 0; i < 16; ++i) {
            T2 = A2 + (B2 ^ (C2 | ~D2)) + this.X[r2[i]] + 1352829926;
            T2 = (T2 << s2[i] | T2 >>> 32 - s2[i]) + E2;
            A2 = E2;
            E2 = D2;
            D2 = C2 << 10 | C2 >>> 22;
            C2 = B2;
            B2 = T2;
        }
        for (i = 16; i < 32; ++i) {
            T2 = A2 + ((B2 ^ C2) & D2 ^ C2) + this.X[r2[i]] + 1548603684;
            T2 = (T2 << s2[i] | T2 >>> 32 - s2[i]) + E2;
            A2 = E2;
            E2 = D2;
            D2 = C2 << 10 | C2 >>> 22;
            C2 = B2;
            B2 = T2;
        }
        for (i = 32; i < 48; ++i) {
            T2 = A2 + ((B2 | ~C2) ^ D2) + this.X[r2[i]] + 1836072691;
            T2 = (T2 << s2[i] | T2 >>> 32 - s2[i]) + E2;
            A2 = E2;
            E2 = D2;
            D2 = C2 << 10 | C2 >>> 22;
            C2 = B2;
            B2 = T2;
        }
        for (i = 48; i < 64; ++i) {
            T2 = A2 + ((C2 ^ D2) & B2 ^ D2) + this.X[r2[i]] + 2053994217;
            T2 = (T2 << s2[i] | T2 >>> 32 - s2[i]) + E2;
            A2 = E2;
            E2 = D2;
            D2 = C2 << 10 | C2 >>> 22;
            C2 = B2;
            B2 = T2;
        }
        for (i = 64; i < 80; ++i) {
            T2 = A2 + (B2 ^ C2 ^ D2) + this.X[r2[i]];
            T2 = (T2 << s2[i] | T2 >>> 32 - s2[i]) + E2;
            A2 = E2;
            E2 = D2;
            D2 = C2 << 10 | C2 >>> 22;
            C2 = B2;
            B2 = T2;
        }
        int T = H1 + C1 + D2;
        this.currentVal[1] = H2 + D1 + E2;
        this.currentVal[2] = H3 + E1 + A2;
        this.currentVal[3] = H4 + A1 + B2;
        this.currentVal[4] = H0 + B1 + C2;
        this.currentVal[0] = T;
    }

    @Override
    public String toString() {
        return "RIPEMD-160";
    }
}

