/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.DigestEngine;

public class RadioGatun32
extends DigestEngine {
    private int[] a;
    private int[] b;

    @Override
    public Digest copy() {
        RadioGatun32 d = new RadioGatun32();
        System.arraycopy(this.a, 0, d.a, 0, this.a.length);
        System.arraycopy(this.b, 0, d.b, 0, this.b.length);
        return this.copyState(d);
    }

    @Override
    public int getDigestLength() {
        return 32;
    }

    @Override
    protected int getInternalBlockLength() {
        return 156;
    }

    @Override
    public int getBlockLength() {
        return -12;
    }

    @Override
    protected void engineReset() {
        int i;
        for (i = 0; i < this.a.length; ++i) {
            this.a[i] = 0;
        }
        for (i = 0; i < this.b.length; ++i) {
            this.b[i] = 0;
        }
    }

    @Override
    protected void doPadding(byte[] output, int outputOffset) {
        int ptr = this.flush();
        byte[] buf = this.getBlockBuffer();
        buf[ptr++] = 1;
        for (int i = ptr; i < 156; ++i) {
            buf[i] = 0;
        }
        this.processBlock(buf);
        int num = 20;
        while ((ptr += 12) <= 156) {
            --num;
        }
        this.blank(num, output, outputOffset);
    }

    @Override
    protected void doInit() {
        this.a = new int[19];
        this.b = new int[39];
        this.engineReset();
    }

    private static final void encodeLEInt(int val, byte[] buf, int off) {
        buf[off + 0] = (byte)val;
        buf[off + 1] = (byte)(val >>> 8);
        buf[off + 2] = (byte)(val >>> 16);
        buf[off + 3] = (byte)(val >>> 24);
    }

    private static final int decodeLEInt(byte[] buf, int off) {
        return (buf[off + 3] & 0xFF) << 24 | (buf[off + 2] & 0xFF) << 16 | (buf[off + 1] & 0xFF) << 8 | buf[off] & 0xFF;
    }

    @Override
    protected void processBlock(byte[] data) {
        int a00 = this.a[0];
        int a01 = this.a[1];
        int a02 = this.a[2];
        int a03 = this.a[3];
        int a04 = this.a[4];
        int a05 = this.a[5];
        int a06 = this.a[6];
        int a07 = this.a[7];
        int a08 = this.a[8];
        int a09 = this.a[9];
        int a10 = this.a[10];
        int a11 = this.a[11];
        int a12 = this.a[12];
        int a13 = this.a[13];
        int a14 = this.a[14];
        int a15 = this.a[15];
        int a16 = this.a[16];
        int a17 = this.a[17];
        int a18 = this.a[18];
        int dp = 0;
        for (int mk = 12; mk >= 0; --mk) {
            int p0 = RadioGatun32.decodeLEInt(data, dp + 0);
            int p1 = RadioGatun32.decodeLEInt(data, dp + 4);
            int p2 = RadioGatun32.decodeLEInt(data, dp + 8);
            dp += 12;
            int bj = mk == 12 ? 0 : 3 * (mk + 1);
            int n = bj + 0;
            this.b[n] = this.b[n] ^ p0;
            int n2 = bj + 1;
            this.b[n2] = this.b[n2] ^ p1;
            int n3 = bj + 2;
            this.b[n3] = this.b[n3] ^ p2;
            a16 ^= p0;
            a17 ^= p1;
            a18 ^= p2;
            bj = mk * 3;
            if ((bj += 3) == 39) {
                bj = 0;
            }
            int n4 = bj + 0;
            this.b[n4] = this.b[n4] ^ a01;
            if ((bj += 3) == 39) {
                bj = 0;
            }
            int n5 = bj + 1;
            this.b[n5] = this.b[n5] ^ a02;
            if ((bj += 3) == 39) {
                bj = 0;
            }
            int n6 = bj + 2;
            this.b[n6] = this.b[n6] ^ a03;
            if ((bj += 3) == 39) {
                bj = 0;
            }
            int n7 = bj + 0;
            this.b[n7] = this.b[n7] ^ a04;
            if ((bj += 3) == 39) {
                bj = 0;
            }
            int n8 = bj + 1;
            this.b[n8] = this.b[n8] ^ a05;
            if ((bj += 3) == 39) {
                bj = 0;
            }
            int n9 = bj + 2;
            this.b[n9] = this.b[n9] ^ a06;
            if ((bj += 3) == 39) {
                bj = 0;
            }
            int n10 = bj + 0;
            this.b[n10] = this.b[n10] ^ a07;
            if ((bj += 3) == 39) {
                bj = 0;
            }
            int n11 = bj + 1;
            this.b[n11] = this.b[n11] ^ a08;
            if ((bj += 3) == 39) {
                bj = 0;
            }
            int n12 = bj + 2;
            this.b[n12] = this.b[n12] ^ a09;
            if ((bj += 3) == 39) {
                bj = 0;
            }
            int n13 = bj + 0;
            this.b[n13] = this.b[n13] ^ a10;
            if ((bj += 3) == 39) {
                bj = 0;
            }
            int n14 = bj + 1;
            this.b[n14] = this.b[n14] ^ a11;
            if ((bj += 3) == 39) {
                bj = 0;
            }
            int n15 = bj + 2;
            this.b[n15] = this.b[n15] ^ a12;
            int t00 = a00 ^ (a01 | ~a02);
            int t01 = a01 ^ (a02 | ~a03);
            int t02 = a02 ^ (a03 | ~a04);
            int t03 = a03 ^ (a04 | ~a05);
            int t04 = a04 ^ (a05 | ~a06);
            int t05 = a05 ^ (a06 | ~a07);
            int t06 = a06 ^ (a07 | ~a08);
            int t07 = a07 ^ (a08 | ~a09);
            int t08 = a08 ^ (a09 | ~a10);
            int t09 = a09 ^ (a10 | ~a11);
            int t10 = a10 ^ (a11 | ~a12);
            int t11 = a11 ^ (a12 | ~a13);
            int t12 = a12 ^ (a13 | ~a14);
            int t13 = a13 ^ (a14 | ~a15);
            int t14 = a14 ^ (a15 | ~a16);
            int t15 = a15 ^ (a16 | ~a17);
            int t16 = a16 ^ (a17 | ~a18);
            int t17 = a17 ^ (a18 | ~a00);
            int t18 = a18 ^ (a00 | ~a01);
            a00 = t00;
            a01 = t07 << 31 | t07 >>> 1;
            a02 = t14 << 29 | t14 >>> 3;
            a03 = t02 << 26 | t02 >>> 6;
            a04 = t09 << 22 | t09 >>> 10;
            a05 = t16 << 17 | t16 >>> 15;
            a06 = t04 << 11 | t04 >>> 21;
            a07 = t11 << 4 | t11 >>> 28;
            a08 = t18 << 28 | t18 >>> 4;
            a09 = t06 << 19 | t06 >>> 13;
            a10 = t13 << 9 | t13 >>> 23;
            a11 = t01 << 30 | t01 >>> 2;
            a12 = t08 << 18 | t08 >>> 14;
            a13 = t15 << 5 | t15 >>> 27;
            a14 = t03 << 23 | t03 >>> 9;
            a15 = t10 << 8 | t10 >>> 24;
            a16 = t17 << 24 | t17 >>> 8;
            a17 = t05 << 7 | t05 >>> 25;
            a18 = t12 << 21 | t12 >>> 11;
            t00 = a00 ^ a01 ^ a04;
            t01 = a01 ^ a02 ^ a05;
            t02 = a02 ^ a03 ^ a06;
            t03 = a03 ^ a04 ^ a07;
            t04 = a04 ^ a05 ^ a08;
            t05 = a05 ^ a06 ^ a09;
            t06 = a06 ^ a07 ^ a10;
            t07 = a07 ^ a08 ^ a11;
            t08 = a08 ^ a09 ^ a12;
            t09 = a09 ^ a10 ^ a13;
            t10 = a10 ^ a11 ^ a14;
            t11 = a11 ^ a12 ^ a15;
            t12 = a12 ^ a13 ^ a16;
            t13 = a13 ^ a14 ^ a17;
            t14 = a14 ^ a15 ^ a18;
            t15 = a15 ^ a16 ^ a00;
            t16 = a16 ^ a17 ^ a01;
            t17 = a17 ^ a18 ^ a02;
            t18 = a18 ^ a00 ^ a03;
            a00 = t00 ^ 1;
            a01 = t01;
            a02 = t02;
            a03 = t03;
            a04 = t04;
            a05 = t05;
            a06 = t06;
            a07 = t07;
            a08 = t08;
            a09 = t09;
            a10 = t10;
            a11 = t11;
            a12 = t12;
            a13 = t13;
            a14 = t14;
            a15 = t15;
            a16 = t16;
            a17 = t17;
            a18 = t18;
            bj = mk * 3;
            a13 ^= this.b[bj + 0];
            a14 ^= this.b[bj + 1];
            a15 ^= this.b[bj + 2];
        }
        this.a[0] = a00;
        this.a[1] = a01;
        this.a[2] = a02;
        this.a[3] = a03;
        this.a[4] = a04;
        this.a[5] = a05;
        this.a[6] = a06;
        this.a[7] = a07;
        this.a[8] = a08;
        this.a[9] = a09;
        this.a[10] = a10;
        this.a[11] = a11;
        this.a[12] = a12;
        this.a[13] = a13;
        this.a[14] = a14;
        this.a[15] = a15;
        this.a[16] = a16;
        this.a[17] = a17;
        this.a[18] = a18;
    }

    private void blank(int num, byte[] out, int off) {
        int a00 = this.a[0];
        int a01 = this.a[1];
        int a02 = this.a[2];
        int a03 = this.a[3];
        int a04 = this.a[4];
        int a05 = this.a[5];
        int a06 = this.a[6];
        int a07 = this.a[7];
        int a08 = this.a[8];
        int a09 = this.a[9];
        int a10 = this.a[10];
        int a11 = this.a[11];
        int a12 = this.a[12];
        int a13 = this.a[13];
        int a14 = this.a[14];
        int a15 = this.a[15];
        int a16 = this.a[16];
        int a17 = this.a[17];
        int a18 = this.a[18];
        while (num-- > 0) {
            this.b[0] = this.b[0] ^ a01;
            this.b[4] = this.b[4] ^ a02;
            this.b[8] = this.b[8] ^ a03;
            this.b[9] = this.b[9] ^ a04;
            this.b[13] = this.b[13] ^ a05;
            this.b[17] = this.b[17] ^ a06;
            this.b[18] = this.b[18] ^ a07;
            this.b[22] = this.b[22] ^ a08;
            this.b[26] = this.b[26] ^ a09;
            this.b[27] = this.b[27] ^ a10;
            this.b[31] = this.b[31] ^ a11;
            this.b[35] = this.b[35] ^ a12;
            int t00 = a00 ^ (a01 | ~a02);
            int t01 = a01 ^ (a02 | ~a03);
            int t02 = a02 ^ (a03 | ~a04);
            int t03 = a03 ^ (a04 | ~a05);
            int t04 = a04 ^ (a05 | ~a06);
            int t05 = a05 ^ (a06 | ~a07);
            int t06 = a06 ^ (a07 | ~a08);
            int t07 = a07 ^ (a08 | ~a09);
            int t08 = a08 ^ (a09 | ~a10);
            int t09 = a09 ^ (a10 | ~a11);
            int t10 = a10 ^ (a11 | ~a12);
            int t11 = a11 ^ (a12 | ~a13);
            int t12 = a12 ^ (a13 | ~a14);
            int t13 = a13 ^ (a14 | ~a15);
            int t14 = a14 ^ (a15 | ~a16);
            int t15 = a15 ^ (a16 | ~a17);
            int t16 = a16 ^ (a17 | ~a18);
            int t17 = a17 ^ (a18 | ~a00);
            int t18 = a18 ^ (a00 | ~a01);
            a00 = t00;
            a01 = t07 << 31 | t07 >>> 1;
            a02 = t14 << 29 | t14 >>> 3;
            a03 = t02 << 26 | t02 >>> 6;
            a04 = t09 << 22 | t09 >>> 10;
            a05 = t16 << 17 | t16 >>> 15;
            a06 = t04 << 11 | t04 >>> 21;
            a07 = t11 << 4 | t11 >>> 28;
            a08 = t18 << 28 | t18 >>> 4;
            a09 = t06 << 19 | t06 >>> 13;
            a10 = t13 << 9 | t13 >>> 23;
            a11 = t01 << 30 | t01 >>> 2;
            a12 = t08 << 18 | t08 >>> 14;
            a13 = t15 << 5 | t15 >>> 27;
            a14 = t03 << 23 | t03 >>> 9;
            a15 = t10 << 8 | t10 >>> 24;
            a16 = t17 << 24 | t17 >>> 8;
            a17 = t05 << 7 | t05 >>> 25;
            a18 = t12 << 21 | t12 >>> 11;
            t00 = a00 ^ a01 ^ a04;
            t01 = a01 ^ a02 ^ a05;
            t02 = a02 ^ a03 ^ a06;
            t03 = a03 ^ a04 ^ a07;
            t04 = a04 ^ a05 ^ a08;
            t05 = a05 ^ a06 ^ a09;
            t06 = a06 ^ a07 ^ a10;
            t07 = a07 ^ a08 ^ a11;
            t08 = a08 ^ a09 ^ a12;
            t09 = a09 ^ a10 ^ a13;
            t10 = a10 ^ a11 ^ a14;
            t11 = a11 ^ a12 ^ a15;
            t12 = a12 ^ a13 ^ a16;
            t13 = a13 ^ a14 ^ a17;
            t14 = a14 ^ a15 ^ a18;
            t15 = a15 ^ a16 ^ a00;
            t16 = a16 ^ a17 ^ a01;
            t17 = a17 ^ a18 ^ a02;
            t18 = a18 ^ a00 ^ a03;
            a00 = t00 ^ 1;
            a01 = t01;
            a02 = t02;
            a03 = t03;
            a04 = t04;
            a05 = t05;
            a06 = t06;
            a07 = t07;
            a08 = t08;
            a09 = t09;
            a10 = t10;
            a11 = t11;
            a12 = t12;
            a13 = t13;
            a14 = t14;
            a15 = t15;
            a16 = t16;
            a17 = t17;
            a18 = t18;
            int bt0 = this.b[36];
            int bt1 = this.b[37];
            int bt2 = this.b[38];
            a13 ^= bt0;
            a14 ^= bt1;
            a15 ^= bt2;
            System.arraycopy(this.b, 0, this.b, 3, 36);
            this.b[0] = bt0;
            this.b[1] = bt1;
            this.b[2] = bt2;
            if (num >= 4) continue;
            RadioGatun32.encodeLEInt(a01, out, off + 0);
            RadioGatun32.encodeLEInt(a02, out, off + 4);
            off += 8;
        }
    }

    @Override
    public String toString() {
        return "RadioGatun[32]";
    }
}

