/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.DigestEngine;

abstract class SHAviteSmallCore
extends DigestEngine {
    private int[] h;
    private int[] rk;
    private static final int[] AES0 = new int[]{-1520213050, -2072216328, -1720223762, -1921287178, 0xDF2F2FF, -1117033514, -1318096930, 1422247313, 1345335392, 50397442, -1452841010, 2099981142, 436141799, 1658312629, -424957107, -1703512340, 1170918031, -1652391393, 1086966153, -2021818886, 368769775, -346465870, -918075506, 0xBF0F0FB, -324162239, 1742001331, -39673249, -357585083, -1080255453, -140204973, -1770884380, 1539358875, -1028147339, 486407649, -1366060227, 1780885068, 1513502316, 1094664062, 49805301, 1338821763, 1546925160, -190470831, 887481809, 150073849, -1821281822, 1943591083, 1395732834, 1058346282, 201589768, 1388824469, 1696801606, 1589887901, 672667696, -1583966665, 251987210, -1248159185, 151455502, 907153956, -1686077413, 1038279391, 652995533, 1764173646, -843926913, -1619692054, 453576978, -1635548387, 1949051992, 773462580, 756751158, -1301385508, -296068428, -73359269, -162377052, 1295727478, 1641469623, -827083907, 2066295122, 0x3EE3E3DD, 1898917726, -1752923117, -179088474, 1758581177, 0, 753790401, 1612718144, 536673507, -927878791, -312779850, -1100322092, 1187761037, -641810841, 1262041458, -565556588, -733197160, -396863312, 1255133061, 1808847035, 720367557, -441800113, 385612781, -985447546, -682799718, 0x55333366, -1803188975, -817543798, 284817897, 100794884, -2122350594, -263171936, 1144798328, -1163944155, -475486133, -212774494, -22830243, -1069531008, -1970303227, -1382903233, -1130521311, 1211644016, 83228145, -541279133, -1044990345, 1977277103, 1663115586, 806359072, 452984805, 250868733, 1842533055, 1288555905, 336333848, 890442534, 804056259, -513843266, -1567123659, -867941240, 957814574, 1472513171, -223893675, -2105639172, 1195195770, -1402706744, -413311558, 723065138, -1787595802, -1604296512, -1736343271, -783331426, 2145180835, 0x66222244, 2116692564, -1416589253, -2088204277, -901364084, 703524551, -742868885, 1007948840, 2044649127, -497131844, 487262998, 1994120109, 1004593371, 1446130276, 1312438900, 503974420, -615954030, 168166924, 1814307912, -463709000, 1573044895, 1859376061, -273896381, -1503501628, -1466855111, -1533700815, 937747667, -1954973198, 854058965, 1137232011, 1496790894, -1217565222, -1936880383, 1691735473, -766620004, -525751991, -1267962664, -95005012, 133494003, 636152527, -1352309302, -1904575756, -374428089, 0x18080810, -709182865, -2005370640, 1864705354, 1915629148, 605822008, -240736681, -944458637, 1371981463, 602466507, 2094914977, -1670089496, 555687742, -582268010, -591544991, -2037675251, -2054518257, -1871679264, 1111375484, -994724495, -1436129588, -666351472, 84083462, 32962295, 302911004, -1553899070, 1597322602, -111716434, -793134743, -1853454825, 1489093017, 656219450, -1180787161, 954327513, 335083755, -1281845205, 0x33111122, -1150719534, 1893325225, -1987146233, -1483434957, -1231316179, 572399164, -1836611819, 552200649, 1238290055, -11184726, 2015897680, 2061492133, -1886614525, -123625127, -2138470135, 386731290, -624967835, 837215959, -968736124, -1201116976, -1019133566, -1332111063, 1999449434, 286199582, -877612933, -61582168, -692339859, 974525996};
    private static final int[] AES1 = new int[]{1667483301, 2088564868, 0x7777EE99, 2071721613, -218956019, 0x6B6BD6BD, 1869602481, -976907948, 808476752, 16843267, 1734856361, 724260477, -16849127, -673729182, -1414836762, 1987505306, -892694715, -2105401443, -909539008, 2105408135, -84218091, 1499050731, 1195871945, -252642549, -1381154324, -724257945, -1566416899, -1347467798, -1667488833, -1532734473, 1920132246, -1061119141, -1212713534, -33693412, -1819066962, 640044138, 909536346, 1061125697, -134744830, -859012273, 875849820, -1515892236, -437923532, -235800312, 1903288979, -656888973, 825320019, 353708607, 67373068, -943221422, 589514341, -1010590370, 404238376, -1768540255, 84216335, -1701171275, 117902857, 303178806, -2139087973, -488448195, -336868058, 656887401, -1296924723, 1970662047, 151589403, -2088559202, 741103732, 437924910, 454768173, 1852759218, 1515893998, -1600103429, 1381147894, 993752653, -690571423, -1280082482, 690573947, -471605954, 791633521, -2071719017, 1397991157, -774784664, 0, -303185620, 538984544, -50535649, -1313769016, 1532737261, 1785386174, -875852474, -1094817831, 960066123, 1246401758, 1280088276, 1482207464, -808483510, -791626901, -269499094, -1431679003, -67375850, 1128498885, 1296931543, 0x33336655, -2054876780, 1162185423, -101062384, 33686534, 2139094657, 1347461360, 1010595908, -1616960070, -1465365533, 1364304627, -1549574658, 1077969088, -1886452342, -1835909203, -1650646596, 943222856, -168431356, -1128504353, -1229555775, -623202443, 555827811, 269492272, -6886, -202113778, -757940371, -842170036, 202119188, 320022069, -320027857, 1600110305, -1751698014, 0x444488CC, 387395129, -993750185, -1482205710, 2122251394, 1027439175, 1684326572, 1566423783, 421081643, 1936975509, 1616953504, -2122245736, 1330618065, -589520001, 0x22224466, 707417214, -1869595733, -2004350077, 1179028682, -286341335, -1195873325, 336865340, -555833479, 1583267042, 185275933, -606360202, -522134725, 842163286, 976909390, 168432670, 1229558491, 101059594, 606357612, 1549580516, -1027432611, -741098130, -1397996561, 1650640038, -1852753496, -1785384540, -454765769, 2038035083, -404237006, -926381245, 926379609, 1835915959, -1920138868, -707415708, 1313774802, -1448523296, 1819072692, 1448520954, -185273593, -353710299, 1701169839, 2054878350, -1364310039, 0x8081018, -1162186795, 2021191816, 623200879, 774790258, 471611428, -1499047951, -1263242297, -960063663, -387396829, -572677764, 1953818780, 522141217, 1263245021, -1111662116, -1953821306, -1970663547, 1886445712, 1044282434, -1246400060, 0x6666CCAA, 1212715224, 50529797, -151587071, 235805714, 1633796771, 892693087, 1465364217, -1179031088, -2038032495, -1044276904, 488454695, -1633802311, -505292488, -117904621, -1734857805, 0x11112233, 1768542907, -640046736, -1903294583, -1802226777, -1684329034, 505297954, -2021190254, -370554592, -825325751, 0x5555AAFF, 673730680, -538991238, -1936981105, -1583261192, -1987507840, 218962455, -1077975590, -421079247, 1111655622, 1751699640, 1094812355, -1718015568, 757946999, 252648977, -1330611253, 1414834428, -1145344554, 370551866};
    private static final int[] AES2 = new int[]{1673962851, 2096661628, 0x77EE9977, 2079755643, -218165774, 0x6BD6BD6B, 1876865391, -980331323, 811618352, 16909057, 1741597031, 727088427, -18408962, -675978537, -1420958037, 1995217526, -896580150, -2111857278, -913751863, 2113570685, -84994566, 1504897881, 1200539975, -251982864, -1388188499, -726439980, -1570767454, -1354372433, -1675378788, -1538000988, 1927583346, -1063560256, -1217019209, -35578627, -1824674157, 642542118, 913070646, 1065238847, -134937865, -863809588, 879254580, -1521355611, -439274267, -235337487, 1910674289, -659852328, 828527409, 355090197, 67636228, -946515257, 591815971, -1013096765, 405809176, -1774739050, 84545285, -1708149350, 118360327, 304363026, -2145674368, -488686110, -338876693, 659450151, -1300247118, 1978310517, 152181513, -2095210877, 743994412, 439627290, 456535323, 1859957358, 1521806938, -1604584544, 1386542674, 997608763, -692624938, -1283600717, 693271337, -472039709, 794718511, -2079090812, 1403450707, -776378159, 0, -306107155, 541089824, -52224004, -1317418831, 1538714971, 1792327274, -879933749, -1100490306, 963791673, 1251270218, 1285084236, 1487988824, -813348145, -793023536, -272291089, -1437604438, -68348165, 1132905795, 1301993293, 0x33665533, -2062445435, 1166724933, -102166279, 33818114, 2147385727, 1352724560, 1014514748, -1624917345, -1471421528, 1369633617, -1554121053, 1082179648, -1895462257, -1841320558, -1658733411, 946882616, -168753931, -1134305348, -1233665610, -626035238, 557998881, 270544912, -1762561, -201519373, -759206446, -847164211, 202904588, 321271059, -322752532, 1606345055, -1758092649, 0x4488CC44, 388905239, -996976700, -1487539545, 2130477694, 1031423805, 1690872932, 1572530013, 422718233, 1944491379, 1623236704, -2129028991, 1335808335, -593264676, 0x22446622, 710180394, -1875137648, -2012511352, 1183631942, -288937490, -1200893000, 338181140, -559449634, 1589437022, 185998603, -609388837, -522503200, 845436466, 980700730, 169090570, 1234361161, 101452294, 608726052, 1555620956, -1029743166, -742560045, -1404833876, 1657054818, -1858492271, -1791908715, -455919644, 2045938553, -405458201, -930397240, 929978679, 1843050349, -1929278323, -709794603, 1318900302, -1454776151, 1826141292, 1454176854, -185399308, -355523094, 1707781989, 2062847610, -1371018834, 0x8101808, -1167075910, 2029029496, 625635109, 777810478, 473441308, -1504185946, -1267480652, -963161658, -389340184, -576619299, 1961401460, 524165407, 1268178251, -1117659971, -1962047861, -1978694262, 1893765232, 1048330814, -1250835275, 0x66CCAA66, 1217452104, 50726147, -151584266, 236720654, 1640145761, 896163637, 1471084887, -1184247623, -2045275770, -1046914879, 490350365, -1641563746, -505857823, -118811656, -1741966440, 0x11223311, 1775418217, -643206951, -1912108658, -1808554092, -1691502949, 507257374, -2028629369, -372694807, -829994546, 0x55AAFF55, 676362280, -542803233, -1945923700, -1587939167, -1995865975, 219813645, -1083843905, -422104602, 1115997762, 1758509160, 1099088705, -1725321063, 760903469, 253628687, -1334064208, 1420360788, -1150429509, 371997206};
    private static final int[] AES3 = new int[]{-962239645, -125535108, -291932297, -158499973, -15863054, -692229269, -558796945, -1856715323, 1615867952, 33751297, -827758745, 1451043627, -417726722, -1251813417, 1306962859, -325421450, -1891251510, 530416258, -1992242743, -91783811, -283772166, -1293199015, -1899411641, -83103504, 1106029997, -1285040940, 1610457762, 1173008303, 599760028, 1408738468, -459902350, -1688485696, 1975695287, -518193667, 1034851219, 1282024998, 1817851446, 2118205247, -184354825, -2091922228, 1750873140, 1374987685, -785062427, -116854287, -493653647, -1418471208, 1649619249, 708777237, 135005188, -1789737017, 1181033251, -1654733885, 807933976, 933336726, 168756485, 800430746, 235472647, 607523346, 463175808, -549592350, -853087253, 1315514151, 2144187058, -358648459, 303761673, 496927619, 1484008492, 875436570, 908925723, -592286098, -1259447718, 1543217312, -1527360942, 1984772923, -1218324778, 2110698419, 1383803177, -583080989, 1584475951, 328696964, -1493871789, -1184312879, 0, -1054020115, 1080041504, -484442884, 2043195825, -1225958565, -725718422, -1924740149, 1742323390, 1917532473, -1797371318, -1730917300, -1326950312, -2058694705, -1150562096, -987041809, 1340451498, -317260805, -2033892541, -1697166003, 0x66553333, 294946181, -1966127803, -384763399, 67502594, -25067649, -1594863536, 2017737788, 632987551, 1273211048, -1561112239, 1576969123, -2134884288, 92966799, 1068339858, 566009245, 1883781176, -251333131, 1675607228, 2009183926, -1351230758, 1113792801, 540020752, -451215361, -49351693, -1083321646, -2125673011, 403966988, 641012499, -1020269332, -1092526241, 899848087, -1999879100, 775493399, -1822964540, 1441965991, -58556802, 2051489085, -928226204, -1159242403, 841685273, -426413197, -1063231392, 0x19988181, -1630449841, -1551901476, 0x44662222, 1417554474, 1001099408, 0xB838888, -1932900794, -953553170, 1809037496, 675025940, -1485185314, -1126015394, 371002123, -1384719397, -616832800, 1683370546, 1951283770, 337512970, -1831122615, 201983494, 1215046692, -1192993700, -1621245246, -1116810285, 1139780780, -995728798, 967348625, 832869781, -751311644, -225740423, -718084121, -1958491960, 1851340599, -625513107, 25988493, -1318791723, -1663938994, 1239460265, -659264404, -1392880042, -217582348, -819598614, -894474907, -191989126, 1206496942, 0x10180808, 1876277946, -259491720, 1248797989, 1550986798, 941890588, 1475454630, 1942467764, -1756248378, -886839064, -1585652259, -392399756, 1042358047, -1763882165, 1641856445, 226921355, 260409994, -527404944, 2084716094, 1908716981, -861247898, -1864873912, 100991747, -150866186, 470945294, -1029480095, 1784624437, -1359390889, 1775286713, 395413126, -1722236479, 975641885, 666476190, -650583583, -351012616, 733190296, 0x22331111, -759469719, -1452221991, 126455438, 866620564, 766942107, 1008868894, 361924487, -920589847, -2025206066, -1426107051, 1350051880, -1518673953, 59739276, 1509466529, 0x9808989, 437718285, 1708834751, -684595482, -2067381694, -793221016, -2101132991, 699439513, 1517759789, 504434447, 2076946608, -1459858348, 0x6DD6BBBB, 742004246};

    SHAviteSmallCore() {
    }

    @Override
    public int getBlockLength() {
        return 64;
    }

    protected Digest copyState(SHAviteSmallCore dst) {
        System.arraycopy(this.h, 0, dst.h, 0, this.h.length);
        return super.copyState(dst);
    }

    @Override
    protected void engineReset() {
        System.arraycopy(this.getInitVal(), 0, this.h, 0, this.h.length);
    }

    abstract int[] getInitVal();

    @Override
    protected void doPadding(byte[] output, int outputOffset) {
        int i;
        int ptr = this.flush();
        long bc = this.getBlockCount();
        long bitLen = (bc << 9) + (long)(ptr << 3);
        int cnt0 = (int)bitLen;
        int cnt1 = (int)(bitLen >>> 32);
        byte[] buf = this.getBlockBuffer();
        if (ptr == 0) {
            buf[0] = -128;
            for (i = 1; i < 54; ++i) {
                buf[i] = 0;
            }
            cnt1 = 0;
            cnt0 = 0;
        } else if (ptr < 54) {
            buf[ptr++] = -128;
            while (ptr < 54) {
                buf[ptr++] = 0;
            }
        } else {
            buf[ptr++] = -128;
            while (ptr < 64) {
                buf[ptr++] = 0;
            }
            this.process(buf, cnt0, cnt1);
            for (i = 0; i < 54; ++i) {
                buf[i] = 0;
            }
            cnt1 = 0;
            cnt0 = 0;
        }
        SHAviteSmallCore.encodeLEInt((int)bitLen, buf, 54);
        SHAviteSmallCore.encodeLEInt((int)(bitLen >>> 32), buf, 58);
        int dlen = this.getDigestLength();
        buf[62] = (byte)(dlen << 3);
        buf[63] = (byte)(dlen >>> 5);
        this.process(buf, cnt0, cnt1);
        for (int i2 = 0; i2 < dlen; i2 += 4) {
            SHAviteSmallCore.encodeLEInt(this.h[i2 >>> 2], output, outputOffset + i2);
        }
    }

    @Override
    protected void doInit() {
        this.h = new int[8];
        this.rk = new int[144];
        this.engineReset();
    }

    private static final void encodeLEInt(int val, byte[] buf, int off) {
        buf[off + 0] = (byte)val;
        buf[off + 1] = (byte)(val >>> 8);
        buf[off + 2] = (byte)(val >>> 16);
        buf[off + 3] = (byte)(val >>> 24);
    }

    private static final int decodeLEInt(byte[] buf, int off) {
        return buf[off] & 0xFF | (buf[off + 1] & 0xFF) << 8 | (buf[off + 2] & 0xFF) << 16 | (buf[off + 3] & 0xFF) << 24;
    }

    @Override
    protected void processBlock(byte[] data) {
        long bitLen = this.getBlockCount() + 1L << 9;
        this.process(data, (int)bitLen, (int)(bitLen >>> 32));
    }

    private void process(byte[] data, int cnt0, int cnt1) {
        int r;
        int u;
        for (u = 0; u < 16; u += 4) {
            this.rk[u + 0] = SHAviteSmallCore.decodeLEInt(data, (u << 2) + 0);
            this.rk[u + 1] = SHAviteSmallCore.decodeLEInt(data, (u << 2) + 4);
            this.rk[u + 2] = SHAviteSmallCore.decodeLEInt(data, (u << 2) + 8);
            this.rk[u + 3] = SHAviteSmallCore.decodeLEInt(data, (u << 2) + 12);
        }
        for (r = 0; r < 4; ++r) {
            int s;
            for (s = 0; s < 2; ++s) {
                int x0 = this.rk[u - 15];
                int x1 = this.rk[u - 14];
                int x2 = this.rk[u - 13];
                int x3 = this.rk[u - 16];
                int t0 = AES0[x0 & 0xFF] ^ AES1[x1 >>> 8 & 0xFF] ^ AES2[x2 >>> 16 & 0xFF] ^ AES3[x3 >>> 24];
                int t1 = AES0[x1 & 0xFF] ^ AES1[x2 >>> 8 & 0xFF] ^ AES2[x3 >>> 16 & 0xFF] ^ AES3[x0 >>> 24];
                int t2 = AES0[x2 & 0xFF] ^ AES1[x3 >>> 8 & 0xFF] ^ AES2[x0 >>> 16 & 0xFF] ^ AES3[x1 >>> 24];
                int t3 = AES0[x3 & 0xFF] ^ AES1[x0 >>> 8 & 0xFF] ^ AES2[x1 >>> 16 & 0xFF] ^ AES3[x2 >>> 24];
                this.rk[u + 0] = t0 ^ this.rk[u - 4];
                this.rk[u + 1] = t1 ^ this.rk[u - 3];
                this.rk[u + 2] = t2 ^ this.rk[u - 2];
                this.rk[u + 3] = t3 ^ this.rk[u - 1];
                if (u == 16) {
                    this.rk[16] = this.rk[16] ^ cnt0;
                    this.rk[17] = this.rk[17] ^ ~cnt1;
                } else if (u == 56) {
                    this.rk[57] = this.rk[57] ^ cnt1;
                    this.rk[58] = this.rk[58] ^ ~cnt0;
                }
                x0 = this.rk[(u += 4) - 15];
                x1 = this.rk[u - 14];
                x2 = this.rk[u - 13];
                x3 = this.rk[u - 16];
                t0 = AES0[x0 & 0xFF] ^ AES1[x1 >>> 8 & 0xFF] ^ AES2[x2 >>> 16 & 0xFF] ^ AES3[x3 >>> 24];
                t1 = AES0[x1 & 0xFF] ^ AES1[x2 >>> 8 & 0xFF] ^ AES2[x3 >>> 16 & 0xFF] ^ AES3[x0 >>> 24];
                t2 = AES0[x2 & 0xFF] ^ AES1[x3 >>> 8 & 0xFF] ^ AES2[x0 >>> 16 & 0xFF] ^ AES3[x1 >>> 24];
                t3 = AES0[x3 & 0xFF] ^ AES1[x0 >>> 8 & 0xFF] ^ AES2[x1 >>> 16 & 0xFF] ^ AES3[x2 >>> 24];
                this.rk[u + 0] = t0 ^ this.rk[u - 4];
                this.rk[u + 1] = t1 ^ this.rk[u - 3];
                this.rk[u + 2] = t2 ^ this.rk[u - 2];
                this.rk[u + 3] = t3 ^ this.rk[u - 1];
                if (u == 84) {
                    this.rk[86] = this.rk[86] ^ cnt1;
                    this.rk[87] = this.rk[87] ^ ~cnt0;
                } else if (u == 124) {
                    this.rk[124] = this.rk[124] ^ cnt0;
                    this.rk[127] = this.rk[127] ^ ~cnt1;
                }
                u += 4;
            }
            for (s = 0; s < 4; ++s) {
                this.rk[u + 0] = this.rk[u - 16] ^ this.rk[u - 3];
                this.rk[u + 1] = this.rk[u - 15] ^ this.rk[u - 2];
                this.rk[u + 2] = this.rk[u - 14] ^ this.rk[u - 1];
                this.rk[u + 3] = this.rk[u - 13] ^ this.rk[u - 0];
                u += 4;
            }
        }
        int p0 = this.h[0];
        int p1 = this.h[1];
        int p2 = this.h[2];
        int p3 = this.h[3];
        int p4 = this.h[4];
        int p5 = this.h[5];
        int p6 = this.h[6];
        int p7 = this.h[7];
        u = 0;
        for (r = 0; r < 6; ++r) {
            int x0 = p4 ^ this.rk[u++];
            int x1 = p5 ^ this.rk[u++];
            int x2 = p6 ^ this.rk[u++];
            int x3 = p7 ^ this.rk[u++];
            int t0 = AES0[x0 & 0xFF] ^ AES1[x1 >>> 8 & 0xFF] ^ AES2[x2 >>> 16 & 0xFF] ^ AES3[x3 >>> 24];
            int t1 = AES0[x1 & 0xFF] ^ AES1[x2 >>> 8 & 0xFF] ^ AES2[x3 >>> 16 & 0xFF] ^ AES3[x0 >>> 24];
            int t2 = AES0[x2 & 0xFF] ^ AES1[x3 >>> 8 & 0xFF] ^ AES2[x0 >>> 16 & 0xFF] ^ AES3[x1 >>> 24];
            int t3 = AES0[x3 & 0xFF] ^ AES1[x0 >>> 8 & 0xFF] ^ AES2[x1 >>> 16 & 0xFF] ^ AES3[x2 >>> 24];
            x0 = t0 ^ this.rk[u++];
            x1 = t1 ^ this.rk[u++];
            x2 = t2 ^ this.rk[u++];
            x3 = t3 ^ this.rk[u++];
            t0 = AES0[x0 & 0xFF] ^ AES1[x1 >>> 8 & 0xFF] ^ AES2[x2 >>> 16 & 0xFF] ^ AES3[x3 >>> 24];
            t1 = AES0[x1 & 0xFF] ^ AES1[x2 >>> 8 & 0xFF] ^ AES2[x3 >>> 16 & 0xFF] ^ AES3[x0 >>> 24];
            t2 = AES0[x2 & 0xFF] ^ AES1[x3 >>> 8 & 0xFF] ^ AES2[x0 >>> 16 & 0xFF] ^ AES3[x1 >>> 24];
            t3 = AES0[x3 & 0xFF] ^ AES1[x0 >>> 8 & 0xFF] ^ AES2[x1 >>> 16 & 0xFF] ^ AES3[x2 >>> 24];
            x0 = t0 ^ this.rk[u++];
            x1 = t1 ^ this.rk[u++];
            x2 = t2 ^ this.rk[u++];
            x3 = t3 ^ this.rk[u++];
            t0 = AES0[x0 & 0xFF] ^ AES1[x1 >>> 8 & 0xFF] ^ AES2[x2 >>> 16 & 0xFF] ^ AES3[x3 >>> 24];
            t1 = AES0[x1 & 0xFF] ^ AES1[x2 >>> 8 & 0xFF] ^ AES2[x3 >>> 16 & 0xFF] ^ AES3[x0 >>> 24];
            t2 = AES0[x2 & 0xFF] ^ AES1[x3 >>> 8 & 0xFF] ^ AES2[x0 >>> 16 & 0xFF] ^ AES3[x1 >>> 24];
            t3 = AES0[x3 & 0xFF] ^ AES1[x0 >>> 8 & 0xFF] ^ AES2[x1 >>> 16 & 0xFF] ^ AES3[x2 >>> 24];
            x0 = (p0 ^= t0) ^ this.rk[u++];
            x1 = (p1 ^= t1) ^ this.rk[u++];
            x2 = (p2 ^= t2) ^ this.rk[u++];
            x3 = (p3 ^= t3) ^ this.rk[u++];
            t0 = AES0[x0 & 0xFF] ^ AES1[x1 >>> 8 & 0xFF] ^ AES2[x2 >>> 16 & 0xFF] ^ AES3[x3 >>> 24];
            t1 = AES0[x1 & 0xFF] ^ AES1[x2 >>> 8 & 0xFF] ^ AES2[x3 >>> 16 & 0xFF] ^ AES3[x0 >>> 24];
            t2 = AES0[x2 & 0xFF] ^ AES1[x3 >>> 8 & 0xFF] ^ AES2[x0 >>> 16 & 0xFF] ^ AES3[x1 >>> 24];
            t3 = AES0[x3 & 0xFF] ^ AES1[x0 >>> 8 & 0xFF] ^ AES2[x1 >>> 16 & 0xFF] ^ AES3[x2 >>> 24];
            x0 = t0 ^ this.rk[u++];
            x1 = t1 ^ this.rk[u++];
            x2 = t2 ^ this.rk[u++];
            x3 = t3 ^ this.rk[u++];
            t0 = AES0[x0 & 0xFF] ^ AES1[x1 >>> 8 & 0xFF] ^ AES2[x2 >>> 16 & 0xFF] ^ AES3[x3 >>> 24];
            t1 = AES0[x1 & 0xFF] ^ AES1[x2 >>> 8 & 0xFF] ^ AES2[x3 >>> 16 & 0xFF] ^ AES3[x0 >>> 24];
            t2 = AES0[x2 & 0xFF] ^ AES1[x3 >>> 8 & 0xFF] ^ AES2[x0 >>> 16 & 0xFF] ^ AES3[x1 >>> 24];
            t3 = AES0[x3 & 0xFF] ^ AES1[x0 >>> 8 & 0xFF] ^ AES2[x1 >>> 16 & 0xFF] ^ AES3[x2 >>> 24];
            x0 = t0 ^ this.rk[u++];
            x1 = t1 ^ this.rk[u++];
            x2 = t2 ^ this.rk[u++];
            x3 = t3 ^ this.rk[u++];
            t0 = AES0[x0 & 0xFF] ^ AES1[x1 >>> 8 & 0xFF] ^ AES2[x2 >>> 16 & 0xFF] ^ AES3[x3 >>> 24];
            t1 = AES0[x1 & 0xFF] ^ AES1[x2 >>> 8 & 0xFF] ^ AES2[x3 >>> 16 & 0xFF] ^ AES3[x0 >>> 24];
            t2 = AES0[x2 & 0xFF] ^ AES1[x3 >>> 8 & 0xFF] ^ AES2[x0 >>> 16 & 0xFF] ^ AES3[x1 >>> 24];
            t3 = AES0[x3 & 0xFF] ^ AES1[x0 >>> 8 & 0xFF] ^ AES2[x1 >>> 16 & 0xFF] ^ AES3[x2 >>> 24];
            p4 ^= t0;
            p5 ^= t1;
            p6 ^= t2;
            p7 ^= t3;
        }
        this.h[0] = this.h[0] ^ p0;
        this.h[1] = this.h[1] ^ p1;
        this.h[2] = this.h[2] ^ p2;
        this.h[3] = this.h[3] ^ p3;
        this.h[4] = this.h[4] ^ p4;
        this.h[5] = this.h[5] ^ p5;
        this.h[6] = this.h[6] ^ p6;
        this.h[7] = this.h[7] ^ p7;
    }

    @Override
    public String toString() {
        return "SHAvite-" + (this.getDigestLength() << 3);
    }
}

