/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.DigestEngine;

abstract class SIMDBigCore
extends DigestEngine {
    private int[] state;
    private int[] q;
    private int[] w;
    private int[] tmpState;
    private int[] tA;
    private static final int[] alphaTab = new int[]{1, 41, 139, 45, 46, 87, 226, 14, 60, 147, 116, 130, 190, 80, 196, 69, 2, 82, 21, 90, 92, 174, 195, 28, 120, 37, 232, 3, 123, 160, 135, 138, 4, 164, 42, 180, 184, 91, 133, 56, 240, 74, 207, 6, 246, 63, 13, 19, 8, 71, 84, 103, 111, 182, 9, 112, 223, 148, 157, 12, 235, 126, 26, 38, 16, 142, 168, 206, 222, 107, 18, 224, 189, 39, 57, 24, 213, 252, 52, 76, 32, 27, 79, 155, 187, 214, 36, 191, 121, 78, 114, 48, 169, 247, 104, 152, 64, 54, 158, 53, 117, 171, 72, 125, 242, 156, 228, 96, 81, 237, 208, 47, 128, 108, 59, 106, 234, 85, 144, 250, 227, 55, 199, 192, 162, 217, 159, 94, 256, 216, 118, 212, 211, 170, 31, 243, 197, 110, 141, 127, 67, 177, 61, 188, 255, 175, 236, 167, 165, 83, 62, 229, 137, 220, 25, 254, 134, 97, 122, 119, 253, 93, 215, 77, 73, 166, 124, 201, 17, 183, 50, 251, 11, 194, 244, 238, 249, 186, 173, 154, 146, 75, 248, 145, 34, 109, 100, 245, 22, 131, 231, 219, 241, 115, 89, 51, 35, 150, 239, 33, 68, 218, 200, 233, 44, 5, 205, 181, 225, 230, 178, 102, 70, 43, 221, 66, 136, 179, 143, 209, 88, 10, 153, 105, 193, 203, 99, 204, 140, 86, 185, 132, 15, 101, 29, 161, 176, 20, 49, 210, 129, 149, 198, 151, 23, 172, 113, 7, 30, 202, 58, 65, 95, 40, 98, 163};
    private static final int[] yoffN = new int[]{1, 163, 98, 40, 95, 65, 58, 202, 30, 7, 113, 172, 23, 151, 198, 149, 129, 210, 49, 20, 176, 161, 29, 101, 15, 132, 185, 86, 140, 204, 99, 203, 193, 105, 153, 10, 88, 209, 143, 179, 136, 66, 221, 43, 70, 102, 178, 230, 225, 181, 205, 5, 44, 233, 200, 218, 68, 33, 239, 150, 35, 51, 89, 115, 241, 219, 231, 131, 22, 245, 100, 109, 34, 145, 248, 75, 146, 154, 173, 186, 249, 238, 244, 194, 11, 251, 50, 183, 17, 201, 124, 166, 73, 77, 215, 93, 253, 119, 122, 97, 134, 254, 25, 220, 137, 229, 62, 83, 165, 167, 236, 175, 255, 188, 61, 177, 67, 127, 141, 110, 197, 243, 31, 170, 211, 212, 118, 216, 256, 94, 159, 217, 162, 192, 199, 55, 227, 250, 144, 85, 234, 106, 59, 108, 128, 47, 208, 237, 81, 96, 228, 156, 242, 125, 72, 171, 117, 53, 158, 54, 64, 152, 104, 247, 169, 48, 114, 78, 121, 191, 36, 214, 187, 155, 79, 27, 32, 76, 52, 252, 213, 24, 57, 39, 189, 224, 18, 107, 222, 206, 168, 142, 16, 38, 26, 126, 235, 12, 157, 148, 223, 112, 9, 182, 111, 103, 84, 71, 8, 19, 13, 63, 246, 6, 207, 74, 240, 56, 133, 91, 184, 180, 42, 164, 4, 138, 135, 160, 123, 3, 232, 37, 120, 28, 195, 174, 92, 90, 21, 82, 2, 69, 196, 80, 190, 130, 116, 147, 60, 14, 226, 87, 46, 45, 139, 41};
    private static final int[] yoffF = new int[]{2, 203, 156, 47, 118, 214, 107, 106, 45, 93, 212, 20, 111, 73, 162, 251, 97, 215, 249, 53, 211, 19, 3, 89, 49, 207, 101, 67, 151, 130, 223, 23, 189, 202, 178, 239, 253, 127, 204, 49, 76, 236, 82, 137, 232, 157, 65, 79, 96, 161, 176, 130, 161, 30, 47, 9, 189, 247, 61, 226, 248, 90, 107, 64, 0, 88, 131, 243, 133, 59, 113, 115, 17, 236, 33, 213, 12, 191, 111, 19, 251, 61, 103, 208, 57, 35, 148, 248, 47, 116, 65, 119, 249, 178, 143, 40, 189, 129, 8, 163, 204, 227, 230, 196, 205, 122, 151, 45, 187, 19, 227, 72, 247, 125, 111, 121, 140, 220, 6, 107, 77, 69, 10, 101, 21, 65, 149, 171, 255, 54, 101, 210, 139, 43, 150, 151, 212, 164, 45, 237, 146, 184, 95, 6, 160, 42, 8, 204, 46, 238, 254, 168, 208, 50, 156, 190, 106, 127, 34, 234, 68, 55, 79, 18, 4, 130, 53, 208, 181, 21, 175, 120, 25, 100, 192, 178, 161, 96, 81, 127, 96, 227, 210, 248, 68, 10, 196, 31, 9, 167, 150, 193, 0, 169, 126, 14, 124, 198, 144, 142, 240, 21, 224, 44, 245, 66, 146, 238, 6, 196, 154, 49, 200, 222, 109, 9, 210, 141, 192, 138, 8, 79, 114, 217, 68, 128, 249, 94, 53, 30, 27, 61, 52, 135, 106, 212, 70, 238, 30, 185, 10, 132, 146, 136, 117, 37, 251, 150, 180, 188, 247, 156, 236, 192, 108, 86};
    private static final int[] pp8k = new int[]{1, 6, 2, 3, 5, 7, 4, 1, 6, 2, 3};
    private static final int[] wbp = new int[]{64, 96, 0, 32, 112, 80, 48, 16, 240, 176, 192, 128, 144, 208, 160, 224, 272, 288, 368, 320, 352, 336, 256, 304, 480, 384, 400, 496, 432, 464, 448, 416};

    SIMDBigCore() {
    }

    @Override
    public int getBlockLength() {
        return 128;
    }

    protected Digest copyState(SIMDBigCore dst) {
        System.arraycopy(this.state, 0, dst.state, 0, 32);
        return super.copyState(dst);
    }

    @Override
    protected void engineReset() {
        int[] iv = this.getInitVal();
        System.arraycopy(iv, 0, this.state, 0, 32);
    }

    abstract int[] getInitVal();

    @Override
    protected void doPadding(byte[] output, int outputOffset) {
        int ptr = this.flush();
        byte[] buf = this.getBlockBuffer();
        if (ptr != 0) {
            for (int i = ptr; i < 128; ++i) {
                buf[i] = 0;
            }
            this.compress(buf, false);
        }
        long count = (this.getBlockCount() << 10) + (long)(ptr << 3);
        SIMDBigCore.encodeLEInt((int)count, buf, 0);
        SIMDBigCore.encodeLEInt((int)(count >> 32), buf, 4);
        for (int i = 8; i < 128; ++i) {
            buf[i] = 0;
        }
        this.compress(buf, true);
        int n = this.getDigestLength() >>> 2;
        for (int i = 0; i < n; ++i) {
            SIMDBigCore.encodeLEInt(this.state[i], output, outputOffset + (i << 2));
        }
    }

    @Override
    protected void doInit() {
        this.state = new int[32];
        this.q = new int[256];
        this.w = new int[64];
        this.tmpState = new int[32];
        this.tA = new int[8];
        this.engineReset();
    }

    private static final void encodeLEInt(int val, byte[] buf, int off) {
        buf[off + 0] = (byte)val;
        buf[off + 1] = (byte)(val >>> 8);
        buf[off + 2] = (byte)(val >>> 16);
        buf[off + 3] = (byte)(val >>> 24);
    }

    private static final int decodeLEInt(byte[] buf, int off) {
        return (buf[off + 3] & 0xFF) << 24 | (buf[off + 2] & 0xFF) << 16 | (buf[off + 1] & 0xFF) << 8 | buf[off] & 0xFF;
    }

    private static int circularLeft(int x, int n) {
        return x >>> 32 - n | x << n;
    }

    @Override
    protected void processBlock(byte[] data) {
        this.compress(data, false);
    }

    private final void fft64(byte[] x, int xb, int xs, int qoff) {
        int t;
        int xd = xs << 1;
        int x0 = x[xb + 0 * xd] & 0xFF;
        int x1 = x[xb + 4 * xd] & 0xFF;
        int x2 = x[xb + 8 * xd] & 0xFF;
        int x3 = x[xb + 12 * xd] & 0xFF;
        int a0 = x0 + x2;
        int a1 = x0 + (x2 << 4);
        int a2 = x0 - x2;
        int a3 = x0 - (x2 << 4);
        int b0 = x1 + x3;
        int b1 = ((x1 << 2) + (x3 << 6) & 0xFF) - ((x1 << 2) + (x3 << 6) >> 8);
        int b2 = (x1 << 4) - (x3 << 4);
        int b3 = ((x1 << 6) + (x3 << 2) & 0xFF) - ((x1 << 6) + (x3 << 2) >> 8);
        int d1_0 = a0 + b0;
        int d1_1 = a1 + b1;
        int d1_2 = a2 + b2;
        int d1_3 = a3 + b3;
        int d1_4 = a0 - b0;
        int d1_5 = a1 - b1;
        int d1_6 = a2 - b2;
        int d1_7 = a3 - b3;
        x0 = x[xb + 2 * xd] & 0xFF;
        x1 = x[xb + 6 * xd] & 0xFF;
        x2 = x[xb + 10 * xd] & 0xFF;
        x3 = x[xb + 14 * xd] & 0xFF;
        a0 = x0 + x2;
        a1 = x0 + (x2 << 4);
        a2 = x0 - x2;
        a3 = x0 - (x2 << 4);
        b0 = x1 + x3;
        b1 = ((x1 << 2) + (x3 << 6) & 0xFF) - ((x1 << 2) + (x3 << 6) >> 8);
        b2 = (x1 << 4) - (x3 << 4);
        b3 = ((x1 << 6) + (x3 << 2) & 0xFF) - ((x1 << 6) + (x3 << 2) >> 8);
        int d2_0 = a0 + b0;
        int d2_1 = a1 + b1;
        int d2_2 = a2 + b2;
        int d2_3 = a3 + b3;
        int d2_4 = a0 - b0;
        int d2_5 = a1 - b1;
        int d2_6 = a2 - b2;
        int d2_7 = a3 - b3;
        this.q[qoff + 0] = d1_0 + d2_0;
        this.q[qoff + 1] = d1_1 + (d2_1 << 1);
        this.q[qoff + 2] = d1_2 + (d2_2 << 2);
        this.q[qoff + 3] = d1_3 + (d2_3 << 3);
        this.q[qoff + 4] = d1_4 + (d2_4 << 4);
        this.q[qoff + 5] = d1_5 + (d2_5 << 5);
        this.q[qoff + 6] = d1_6 + (d2_6 << 6);
        this.q[qoff + 7] = d1_7 + (d2_7 << 7);
        this.q[qoff + 8] = d1_0 - d2_0;
        this.q[qoff + 9] = d1_1 - (d2_1 << 1);
        this.q[qoff + 10] = d1_2 - (d2_2 << 2);
        this.q[qoff + 11] = d1_3 - (d2_3 << 3);
        this.q[qoff + 12] = d1_4 - (d2_4 << 4);
        this.q[qoff + 13] = d1_5 - (d2_5 << 5);
        this.q[qoff + 14] = d1_6 - (d2_6 << 6);
        this.q[qoff + 15] = d1_7 - (d2_7 << 7);
        x0 = x[xb + 1 * xd] & 0xFF;
        x1 = x[xb + 5 * xd] & 0xFF;
        x2 = x[xb + 9 * xd] & 0xFF;
        x3 = x[xb + 13 * xd] & 0xFF;
        a0 = x0 + x2;
        a1 = x0 + (x2 << 4);
        a2 = x0 - x2;
        a3 = x0 - (x2 << 4);
        b0 = x1 + x3;
        b1 = ((x1 << 2) + (x3 << 6) & 0xFF) - ((x1 << 2) + (x3 << 6) >> 8);
        b2 = (x1 << 4) - (x3 << 4);
        b3 = ((x1 << 6) + (x3 << 2) & 0xFF) - ((x1 << 6) + (x3 << 2) >> 8);
        d1_0 = a0 + b0;
        d1_1 = a1 + b1;
        d1_2 = a2 + b2;
        d1_3 = a3 + b3;
        d1_4 = a0 - b0;
        d1_5 = a1 - b1;
        d1_6 = a2 - b2;
        d1_7 = a3 - b3;
        x0 = x[xb + 3 * xd] & 0xFF;
        x1 = x[xb + 7 * xd] & 0xFF;
        x2 = x[xb + 11 * xd] & 0xFF;
        x3 = x[xb + 15 * xd] & 0xFF;
        a0 = x0 + x2;
        a1 = x0 + (x2 << 4);
        a2 = x0 - x2;
        a3 = x0 - (x2 << 4);
        b0 = x1 + x3;
        b1 = ((x1 << 2) + (x3 << 6) & 0xFF) - ((x1 << 2) + (x3 << 6) >> 8);
        b2 = (x1 << 4) - (x3 << 4);
        b3 = ((x1 << 6) + (x3 << 2) & 0xFF) - ((x1 << 6) + (x3 << 2) >> 8);
        d2_0 = a0 + b0;
        d2_1 = a1 + b1;
        d2_2 = a2 + b2;
        d2_3 = a3 + b3;
        d2_4 = a0 - b0;
        d2_5 = a1 - b1;
        d2_6 = a2 - b2;
        d2_7 = a3 - b3;
        this.q[qoff + 16 + 0] = d1_0 + d2_0;
        this.q[qoff + 16 + 1] = d1_1 + (d2_1 << 1);
        this.q[qoff + 16 + 2] = d1_2 + (d2_2 << 2);
        this.q[qoff + 16 + 3] = d1_3 + (d2_3 << 3);
        this.q[qoff + 16 + 4] = d1_4 + (d2_4 << 4);
        this.q[qoff + 16 + 5] = d1_5 + (d2_5 << 5);
        this.q[qoff + 16 + 6] = d1_6 + (d2_6 << 6);
        this.q[qoff + 16 + 7] = d1_7 + (d2_7 << 7);
        this.q[qoff + 16 + 8] = d1_0 - d2_0;
        this.q[qoff + 16 + 9] = d1_1 - (d2_1 << 1);
        this.q[qoff + 16 + 10] = d1_2 - (d2_2 << 2);
        this.q[qoff + 16 + 11] = d1_3 - (d2_3 << 3);
        this.q[qoff + 16 + 12] = d1_4 - (d2_4 << 4);
        this.q[qoff + 16 + 13] = d1_5 - (d2_5 << 5);
        this.q[qoff + 16 + 14] = d1_6 - (d2_6 << 6);
        this.q[qoff + 16 + 15] = d1_7 - (d2_7 << 7);
        int m = this.q[qoff];
        int n = this.q[qoff + 16];
        this.q[qoff] = m + n;
        this.q[qoff + 16] = m - n;
        int u = 0;
        int v = 0;
        while (u < 16) {
            if (u != 0) {
                m = this.q[qoff + u + 0];
                n = this.q[qoff + u + 0 + 16];
                t = (n * alphaTab[v + 0] & 0xFFFF) + (n * alphaTab[v + 0] >> 16);
                this.q[qoff + u + 0] = m + t;
                this.q[qoff + u + 0 + 16] = m - t;
            }
            m = this.q[qoff + u + 1];
            n = this.q[qoff + u + 1 + 16];
            t = (n * alphaTab[v + 8] & 0xFFFF) + (n * alphaTab[v + 8] >> 16);
            this.q[qoff + u + 1] = m + t;
            this.q[qoff + u + 1 + 16] = m - t;
            m = this.q[qoff + u + 2];
            n = this.q[qoff + u + 2 + 16];
            t = (n * alphaTab[v + 16] & 0xFFFF) + (n * alphaTab[v + 16] >> 16);
            this.q[qoff + u + 2] = m + t;
            this.q[qoff + u + 2 + 16] = m - t;
            m = this.q[qoff + u + 3];
            n = this.q[qoff + u + 3 + 16];
            t = (n * alphaTab[v + 24] & 0xFFFF) + (n * alphaTab[v + 24] >> 16);
            this.q[qoff + u + 3] = m + t;
            this.q[qoff + u + 3 + 16] = m - t;
            u += 4;
            v += 32;
        }
        int x02 = x[xb + xs + 0 * xd] & 0xFF;
        int x12 = x[xb + xs + 4 * xd] & 0xFF;
        int x22 = x[xb + xs + 8 * xd] & 0xFF;
        int x32 = x[xb + xs + 12 * xd] & 0xFF;
        int a02 = x02 + x22;
        int a12 = x02 + (x22 << 4);
        int a22 = x02 - x22;
        int a32 = x02 - (x22 << 4);
        int b02 = x12 + x32;
        int b12 = ((x12 << 2) + (x32 << 6) & 0xFF) - ((x12 << 2) + (x32 << 6) >> 8);
        int b22 = (x12 << 4) - (x32 << 4);
        int b32 = ((x12 << 6) + (x32 << 2) & 0xFF) - ((x12 << 6) + (x32 << 2) >> 8);
        int d1_02 = a02 + b02;
        int d1_12 = a12 + b12;
        int d1_22 = a22 + b22;
        int d1_32 = a32 + b32;
        int d1_42 = a02 - b02;
        int d1_52 = a12 - b12;
        int d1_62 = a22 - b22;
        int d1_72 = a32 - b32;
        x02 = x[xb + xs + 2 * xd] & 0xFF;
        x12 = x[xb + xs + 6 * xd] & 0xFF;
        x22 = x[xb + xs + 10 * xd] & 0xFF;
        x32 = x[xb + xs + 14 * xd] & 0xFF;
        a02 = x02 + x22;
        a12 = x02 + (x22 << 4);
        a22 = x02 - x22;
        a32 = x02 - (x22 << 4);
        b02 = x12 + x32;
        b12 = ((x12 << 2) + (x32 << 6) & 0xFF) - ((x12 << 2) + (x32 << 6) >> 8);
        b22 = (x12 << 4) - (x32 << 4);
        b32 = ((x12 << 6) + (x32 << 2) & 0xFF) - ((x12 << 6) + (x32 << 2) >> 8);
        int d2_02 = a02 + b02;
        int d2_12 = a12 + b12;
        int d2_22 = a22 + b22;
        int d2_32 = a32 + b32;
        int d2_42 = a02 - b02;
        int d2_52 = a12 - b12;
        int d2_62 = a22 - b22;
        int d2_72 = a32 - b32;
        this.q[qoff + 32 + 0] = d1_02 + d2_02;
        this.q[qoff + 32 + 1] = d1_12 + (d2_12 << 1);
        this.q[qoff + 32 + 2] = d1_22 + (d2_22 << 2);
        this.q[qoff + 32 + 3] = d1_32 + (d2_32 << 3);
        this.q[qoff + 32 + 4] = d1_42 + (d2_42 << 4);
        this.q[qoff + 32 + 5] = d1_52 + (d2_52 << 5);
        this.q[qoff + 32 + 6] = d1_62 + (d2_62 << 6);
        this.q[qoff + 32 + 7] = d1_72 + (d2_72 << 7);
        this.q[qoff + 32 + 8] = d1_02 - d2_02;
        this.q[qoff + 32 + 9] = d1_12 - (d2_12 << 1);
        this.q[qoff + 32 + 10] = d1_22 - (d2_22 << 2);
        this.q[qoff + 32 + 11] = d1_32 - (d2_32 << 3);
        this.q[qoff + 32 + 12] = d1_42 - (d2_42 << 4);
        this.q[qoff + 32 + 13] = d1_52 - (d2_52 << 5);
        this.q[qoff + 32 + 14] = d1_62 - (d2_62 << 6);
        this.q[qoff + 32 + 15] = d1_72 - (d2_72 << 7);
        x02 = x[xb + xs + 1 * xd] & 0xFF;
        x12 = x[xb + xs + 5 * xd] & 0xFF;
        x22 = x[xb + xs + 9 * xd] & 0xFF;
        x32 = x[xb + xs + 13 * xd] & 0xFF;
        a02 = x02 + x22;
        a12 = x02 + (x22 << 4);
        a22 = x02 - x22;
        a32 = x02 - (x22 << 4);
        b02 = x12 + x32;
        b12 = ((x12 << 2) + (x32 << 6) & 0xFF) - ((x12 << 2) + (x32 << 6) >> 8);
        b22 = (x12 << 4) - (x32 << 4);
        b32 = ((x12 << 6) + (x32 << 2) & 0xFF) - ((x12 << 6) + (x32 << 2) >> 8);
        d1_02 = a02 + b02;
        d1_12 = a12 + b12;
        d1_22 = a22 + b22;
        d1_32 = a32 + b32;
        d1_42 = a02 - b02;
        d1_52 = a12 - b12;
        d1_62 = a22 - b22;
        d1_72 = a32 - b32;
        x02 = x[xb + xs + 3 * xd] & 0xFF;
        x12 = x[xb + xs + 7 * xd] & 0xFF;
        x22 = x[xb + xs + 11 * xd] & 0xFF;
        x32 = x[xb + xs + 15 * xd] & 0xFF;
        a02 = x02 + x22;
        a12 = x02 + (x22 << 4);
        a22 = x02 - x22;
        a32 = x02 - (x22 << 4);
        b02 = x12 + x32;
        b12 = ((x12 << 2) + (x32 << 6) & 0xFF) - ((x12 << 2) + (x32 << 6) >> 8);
        b22 = (x12 << 4) - (x32 << 4);
        b32 = ((x12 << 6) + (x32 << 2) & 0xFF) - ((x12 << 6) + (x32 << 2) >> 8);
        d2_02 = a02 + b02;
        d2_12 = a12 + b12;
        d2_22 = a22 + b22;
        d2_32 = a32 + b32;
        d2_42 = a02 - b02;
        d2_52 = a12 - b12;
        d2_62 = a22 - b22;
        d2_72 = a32 - b32;
        this.q[qoff + 32 + 16 + 0] = d1_02 + d2_02;
        this.q[qoff + 32 + 16 + 1] = d1_12 + (d2_12 << 1);
        this.q[qoff + 32 + 16 + 2] = d1_22 + (d2_22 << 2);
        this.q[qoff + 32 + 16 + 3] = d1_32 + (d2_32 << 3);
        this.q[qoff + 32 + 16 + 4] = d1_42 + (d2_42 << 4);
        this.q[qoff + 32 + 16 + 5] = d1_52 + (d2_52 << 5);
        this.q[qoff + 32 + 16 + 6] = d1_62 + (d2_62 << 6);
        this.q[qoff + 32 + 16 + 7] = d1_72 + (d2_72 << 7);
        this.q[qoff + 32 + 16 + 8] = d1_02 - d2_02;
        this.q[qoff + 32 + 16 + 9] = d1_12 - (d2_12 << 1);
        this.q[qoff + 32 + 16 + 10] = d1_22 - (d2_22 << 2);
        this.q[qoff + 32 + 16 + 11] = d1_32 - (d2_32 << 3);
        this.q[qoff + 32 + 16 + 12] = d1_42 - (d2_42 << 4);
        this.q[qoff + 32 + 16 + 13] = d1_52 - (d2_52 << 5);
        this.q[qoff + 32 + 16 + 14] = d1_62 - (d2_62 << 6);
        this.q[qoff + 32 + 16 + 15] = d1_72 - (d2_72 << 7);
        m = this.q[qoff + 32];
        n = this.q[qoff + 32 + 16];
        this.q[qoff + 32] = m + n;
        this.q[qoff + 32 + 16] = m - n;
        u = 0;
        v = 0;
        while (u < 16) {
            if (u != 0) {
                m = this.q[qoff + 32 + u + 0];
                n = this.q[qoff + 32 + u + 0 + 16];
                t = (n * alphaTab[v + 0] & 0xFFFF) + (n * alphaTab[v + 0] >> 16);
                this.q[qoff + 32 + u + 0] = m + t;
                this.q[qoff + 32 + u + 0 + 16] = m - t;
            }
            m = this.q[qoff + 32 + u + 1];
            n = this.q[qoff + 32 + u + 1 + 16];
            t = (n * alphaTab[v + 8] & 0xFFFF) + (n * alphaTab[v + 8] >> 16);
            this.q[qoff + 32 + u + 1] = m + t;
            this.q[qoff + 32 + u + 1 + 16] = m - t;
            m = this.q[qoff + 32 + u + 2];
            n = this.q[qoff + 32 + u + 2 + 16];
            t = (n * alphaTab[v + 16] & 0xFFFF) + (n * alphaTab[v + 16] >> 16);
            this.q[qoff + 32 + u + 2] = m + t;
            this.q[qoff + 32 + u + 2 + 16] = m - t;
            m = this.q[qoff + 32 + u + 3];
            n = this.q[qoff + 32 + u + 3 + 16];
            t = (n * alphaTab[v + 24] & 0xFFFF) + (n * alphaTab[v + 24] >> 16);
            this.q[qoff + 32 + u + 3] = m + t;
            this.q[qoff + 32 + u + 3 + 16] = m - t;
            u += 4;
            v += 32;
        }
        m = this.q[qoff];
        n = this.q[qoff + 32];
        this.q[qoff] = m + n;
        this.q[qoff + 32] = m - n;
        u = 0;
        v = 0;
        while (u < 32) {
            if (u != 0) {
                m = this.q[qoff + u + 0];
                n = this.q[qoff + u + 0 + 32];
                t = (n * alphaTab[v + 0] & 0xFFFF) + (n * alphaTab[v + 0] >> 16);
                this.q[qoff + u + 0] = m + t;
                this.q[qoff + u + 0 + 32] = m - t;
            }
            m = this.q[qoff + u + 1];
            n = this.q[qoff + u + 1 + 32];
            t = (n * alphaTab[v + 4] & 0xFFFF) + (n * alphaTab[v + 4] >> 16);
            this.q[qoff + u + 1] = m + t;
            this.q[qoff + u + 1 + 32] = m - t;
            m = this.q[qoff + u + 2];
            n = this.q[qoff + u + 2 + 32];
            t = (n * alphaTab[v + 8] & 0xFFFF) + (n * alphaTab[v + 8] >> 16);
            this.q[qoff + u + 2] = m + t;
            this.q[qoff + u + 2 + 32] = m - t;
            m = this.q[qoff + u + 3];
            n = this.q[qoff + u + 3 + 32];
            t = (n * alphaTab[v + 12] & 0xFFFF) + (n * alphaTab[v + 12] >> 16);
            this.q[qoff + u + 3] = m + t;
            this.q[qoff + u + 3 + 32] = m - t;
            u += 4;
            v += 16;
        }
    }

    private final void oneRound(int isp, int p0, int p1, int p2, int p3) {
        this.tA[0] = SIMDBigCore.circularLeft(this.state[0], p0);
        this.tA[1] = SIMDBigCore.circularLeft(this.state[1], p0);
        this.tA[2] = SIMDBigCore.circularLeft(this.state[2], p0);
        this.tA[3] = SIMDBigCore.circularLeft(this.state[3], p0);
        this.tA[4] = SIMDBigCore.circularLeft(this.state[4], p0);
        this.tA[5] = SIMDBigCore.circularLeft(this.state[5], p0);
        this.tA[6] = SIMDBigCore.circularLeft(this.state[6], p0);
        this.tA[7] = SIMDBigCore.circularLeft(this.state[7], p0);
        int tmp = this.state[24] + this.w[0] + ((this.state[8] ^ this.state[16]) & this.state[0] ^ this.state[16]);
        this.state[0] = SIMDBigCore.circularLeft(tmp, p1) + this.tA[pp8k[isp + 0] ^ 0];
        this.state[24] = this.state[16];
        this.state[16] = this.state[8];
        this.state[8] = this.tA[0];
        tmp = this.state[25] + this.w[1] + ((this.state[9] ^ this.state[17]) & this.state[1] ^ this.state[17]);
        this.state[1] = SIMDBigCore.circularLeft(tmp, p1) + this.tA[pp8k[isp + 0] ^ 1];
        this.state[25] = this.state[17];
        this.state[17] = this.state[9];
        this.state[9] = this.tA[1];
        tmp = this.state[26] + this.w[2] + ((this.state[10] ^ this.state[18]) & this.state[2] ^ this.state[18]);
        this.state[2] = SIMDBigCore.circularLeft(tmp, p1) + this.tA[pp8k[isp + 0] ^ 2];
        this.state[26] = this.state[18];
        this.state[18] = this.state[10];
        this.state[10] = this.tA[2];
        tmp = this.state[27] + this.w[3] + ((this.state[11] ^ this.state[19]) & this.state[3] ^ this.state[19]);
        this.state[3] = SIMDBigCore.circularLeft(tmp, p1) + this.tA[pp8k[isp + 0] ^ 3];
        this.state[27] = this.state[19];
        this.state[19] = this.state[11];
        this.state[11] = this.tA[3];
        tmp = this.state[28] + this.w[4] + ((this.state[12] ^ this.state[20]) & this.state[4] ^ this.state[20]);
        this.state[4] = SIMDBigCore.circularLeft(tmp, p1) + this.tA[pp8k[isp + 0] ^ 4];
        this.state[28] = this.state[20];
        this.state[20] = this.state[12];
        this.state[12] = this.tA[4];
        tmp = this.state[29] + this.w[5] + ((this.state[13] ^ this.state[21]) & this.state[5] ^ this.state[21]);
        this.state[5] = SIMDBigCore.circularLeft(tmp, p1) + this.tA[pp8k[isp + 0] ^ 5];
        this.state[29] = this.state[21];
        this.state[21] = this.state[13];
        this.state[13] = this.tA[5];
        tmp = this.state[30] + this.w[6] + ((this.state[14] ^ this.state[22]) & this.state[6] ^ this.state[22]);
        this.state[6] = SIMDBigCore.circularLeft(tmp, p1) + this.tA[pp8k[isp + 0] ^ 6];
        this.state[30] = this.state[22];
        this.state[22] = this.state[14];
        this.state[14] = this.tA[6];
        tmp = this.state[31] + this.w[7] + ((this.state[15] ^ this.state[23]) & this.state[7] ^ this.state[23]);
        this.state[7] = SIMDBigCore.circularLeft(tmp, p1) + this.tA[pp8k[isp + 0] ^ 7];
        this.state[31] = this.state[23];
        this.state[23] = this.state[15];
        this.state[15] = this.tA[7];
        this.tA[0] = SIMDBigCore.circularLeft(this.state[0], p1);
        this.tA[1] = SIMDBigCore.circularLeft(this.state[1], p1);
        this.tA[2] = SIMDBigCore.circularLeft(this.state[2], p1);
        this.tA[3] = SIMDBigCore.circularLeft(this.state[3], p1);
        this.tA[4] = SIMDBigCore.circularLeft(this.state[4], p1);
        this.tA[5] = SIMDBigCore.circularLeft(this.state[5], p1);
        this.tA[6] = SIMDBigCore.circularLeft(this.state[6], p1);
        this.tA[7] = SIMDBigCore.circularLeft(this.state[7], p1);
        tmp = this.state[24] + this.w[8] + ((this.state[8] ^ this.state[16]) & this.state[0] ^ this.state[16]);
        this.state[0] = SIMDBigCore.circularLeft(tmp, p2) + this.tA[pp8k[isp + 1] ^ 0];
        this.state[24] = this.state[16];
        this.state[16] = this.state[8];
        this.state[8] = this.tA[0];
        tmp = this.state[25] + this.w[9] + ((this.state[9] ^ this.state[17]) & this.state[1] ^ this.state[17]);
        this.state[1] = SIMDBigCore.circularLeft(tmp, p2) + this.tA[pp8k[isp + 1] ^ 1];
        this.state[25] = this.state[17];
        this.state[17] = this.state[9];
        this.state[9] = this.tA[1];
        tmp = this.state[26] + this.w[10] + ((this.state[10] ^ this.state[18]) & this.state[2] ^ this.state[18]);
        this.state[2] = SIMDBigCore.circularLeft(tmp, p2) + this.tA[pp8k[isp + 1] ^ 2];
        this.state[26] = this.state[18];
        this.state[18] = this.state[10];
        this.state[10] = this.tA[2];
        tmp = this.state[27] + this.w[11] + ((this.state[11] ^ this.state[19]) & this.state[3] ^ this.state[19]);
        this.state[3] = SIMDBigCore.circularLeft(tmp, p2) + this.tA[pp8k[isp + 1] ^ 3];
        this.state[27] = this.state[19];
        this.state[19] = this.state[11];
        this.state[11] = this.tA[3];
        tmp = this.state[28] + this.w[12] + ((this.state[12] ^ this.state[20]) & this.state[4] ^ this.state[20]);
        this.state[4] = SIMDBigCore.circularLeft(tmp, p2) + this.tA[pp8k[isp + 1] ^ 4];
        this.state[28] = this.state[20];
        this.state[20] = this.state[12];
        this.state[12] = this.tA[4];
        tmp = this.state[29] + this.w[13] + ((this.state[13] ^ this.state[21]) & this.state[5] ^ this.state[21]);
        this.state[5] = SIMDBigCore.circularLeft(tmp, p2) + this.tA[pp8k[isp + 1] ^ 5];
        this.state[29] = this.state[21];
        this.state[21] = this.state[13];
        this.state[13] = this.tA[5];
        tmp = this.state[30] + this.w[14] + ((this.state[14] ^ this.state[22]) & this.state[6] ^ this.state[22]);
        this.state[6] = SIMDBigCore.circularLeft(tmp, p2) + this.tA[pp8k[isp + 1] ^ 6];
        this.state[30] = this.state[22];
        this.state[22] = this.state[14];
        this.state[14] = this.tA[6];
        tmp = this.state[31] + this.w[15] + ((this.state[15] ^ this.state[23]) & this.state[7] ^ this.state[23]);
        this.state[7] = SIMDBigCore.circularLeft(tmp, p2) + this.tA[pp8k[isp + 1] ^ 7];
        this.state[31] = this.state[23];
        this.state[23] = this.state[15];
        this.state[15] = this.tA[7];
        this.tA[0] = SIMDBigCore.circularLeft(this.state[0], p2);
        this.tA[1] = SIMDBigCore.circularLeft(this.state[1], p2);
        this.tA[2] = SIMDBigCore.circularLeft(this.state[2], p2);
        this.tA[3] = SIMDBigCore.circularLeft(this.state[3], p2);
        this.tA[4] = SIMDBigCore.circularLeft(this.state[4], p2);
        this.tA[5] = SIMDBigCore.circularLeft(this.state[5], p2);
        this.tA[6] = SIMDBigCore.circularLeft(this.state[6], p2);
        this.tA[7] = SIMDBigCore.circularLeft(this.state[7], p2);
        tmp = this.state[24] + this.w[16] + ((this.state[8] ^ this.state[16]) & this.state[0] ^ this.state[16]);
        this.state[0] = SIMDBigCore.circularLeft(tmp, p3) + this.tA[pp8k[isp + 2] ^ 0];
        this.state[24] = this.state[16];
        this.state[16] = this.state[8];
        this.state[8] = this.tA[0];
        tmp = this.state[25] + this.w[17] + ((this.state[9] ^ this.state[17]) & this.state[1] ^ this.state[17]);
        this.state[1] = SIMDBigCore.circularLeft(tmp, p3) + this.tA[pp8k[isp + 2] ^ 1];
        this.state[25] = this.state[17];
        this.state[17] = this.state[9];
        this.state[9] = this.tA[1];
        tmp = this.state[26] + this.w[18] + ((this.state[10] ^ this.state[18]) & this.state[2] ^ this.state[18]);
        this.state[2] = SIMDBigCore.circularLeft(tmp, p3) + this.tA[pp8k[isp + 2] ^ 2];
        this.state[26] = this.state[18];
        this.state[18] = this.state[10];
        this.state[10] = this.tA[2];
        tmp = this.state[27] + this.w[19] + ((this.state[11] ^ this.state[19]) & this.state[3] ^ this.state[19]);
        this.state[3] = SIMDBigCore.circularLeft(tmp, p3) + this.tA[pp8k[isp + 2] ^ 3];
        this.state[27] = this.state[19];
        this.state[19] = this.state[11];
        this.state[11] = this.tA[3];
        tmp = this.state[28] + this.w[20] + ((this.state[12] ^ this.state[20]) & this.state[4] ^ this.state[20]);
        this.state[4] = SIMDBigCore.circularLeft(tmp, p3) + this.tA[pp8k[isp + 2] ^ 4];
        this.state[28] = this.state[20];
        this.state[20] = this.state[12];
        this.state[12] = this.tA[4];
        tmp = this.state[29] + this.w[21] + ((this.state[13] ^ this.state[21]) & this.state[5] ^ this.state[21]);
        this.state[5] = SIMDBigCore.circularLeft(tmp, p3) + this.tA[pp8k[isp + 2] ^ 5];
        this.state[29] = this.state[21];
        this.state[21] = this.state[13];
        this.state[13] = this.tA[5];
        tmp = this.state[30] + this.w[22] + ((this.state[14] ^ this.state[22]) & this.state[6] ^ this.state[22]);
        this.state[6] = SIMDBigCore.circularLeft(tmp, p3) + this.tA[pp8k[isp + 2] ^ 6];
        this.state[30] = this.state[22];
        this.state[22] = this.state[14];
        this.state[14] = this.tA[6];
        tmp = this.state[31] + this.w[23] + ((this.state[15] ^ this.state[23]) & this.state[7] ^ this.state[23]);
        this.state[7] = SIMDBigCore.circularLeft(tmp, p3) + this.tA[pp8k[isp + 2] ^ 7];
        this.state[31] = this.state[23];
        this.state[23] = this.state[15];
        this.state[15] = this.tA[7];
        this.tA[0] = SIMDBigCore.circularLeft(this.state[0], p3);
        this.tA[1] = SIMDBigCore.circularLeft(this.state[1], p3);
        this.tA[2] = SIMDBigCore.circularLeft(this.state[2], p3);
        this.tA[3] = SIMDBigCore.circularLeft(this.state[3], p3);
        this.tA[4] = SIMDBigCore.circularLeft(this.state[4], p3);
        this.tA[5] = SIMDBigCore.circularLeft(this.state[5], p3);
        this.tA[6] = SIMDBigCore.circularLeft(this.state[6], p3);
        this.tA[7] = SIMDBigCore.circularLeft(this.state[7], p3);
        tmp = this.state[24] + this.w[24] + ((this.state[8] ^ this.state[16]) & this.state[0] ^ this.state[16]);
        this.state[0] = SIMDBigCore.circularLeft(tmp, p0) + this.tA[pp8k[isp + 3] ^ 0];
        this.state[24] = this.state[16];
        this.state[16] = this.state[8];
        this.state[8] = this.tA[0];
        tmp = this.state[25] + this.w[25] + ((this.state[9] ^ this.state[17]) & this.state[1] ^ this.state[17]);
        this.state[1] = SIMDBigCore.circularLeft(tmp, p0) + this.tA[pp8k[isp + 3] ^ 1];
        this.state[25] = this.state[17];
        this.state[17] = this.state[9];
        this.state[9] = this.tA[1];
        tmp = this.state[26] + this.w[26] + ((this.state[10] ^ this.state[18]) & this.state[2] ^ this.state[18]);
        this.state[2] = SIMDBigCore.circularLeft(tmp, p0) + this.tA[pp8k[isp + 3] ^ 2];
        this.state[26] = this.state[18];
        this.state[18] = this.state[10];
        this.state[10] = this.tA[2];
        tmp = this.state[27] + this.w[27] + ((this.state[11] ^ this.state[19]) & this.state[3] ^ this.state[19]);
        this.state[3] = SIMDBigCore.circularLeft(tmp, p0) + this.tA[pp8k[isp + 3] ^ 3];
        this.state[27] = this.state[19];
        this.state[19] = this.state[11];
        this.state[11] = this.tA[3];
        tmp = this.state[28] + this.w[28] + ((this.state[12] ^ this.state[20]) & this.state[4] ^ this.state[20]);
        this.state[4] = SIMDBigCore.circularLeft(tmp, p0) + this.tA[pp8k[isp + 3] ^ 4];
        this.state[28] = this.state[20];
        this.state[20] = this.state[12];
        this.state[12] = this.tA[4];
        tmp = this.state[29] + this.w[29] + ((this.state[13] ^ this.state[21]) & this.state[5] ^ this.state[21]);
        this.state[5] = SIMDBigCore.circularLeft(tmp, p0) + this.tA[pp8k[isp + 3] ^ 5];
        this.state[29] = this.state[21];
        this.state[21] = this.state[13];
        this.state[13] = this.tA[5];
        tmp = this.state[30] + this.w[30] + ((this.state[14] ^ this.state[22]) & this.state[6] ^ this.state[22]);
        this.state[6] = SIMDBigCore.circularLeft(tmp, p0) + this.tA[pp8k[isp + 3] ^ 6];
        this.state[30] = this.state[22];
        this.state[22] = this.state[14];
        this.state[14] = this.tA[6];
        tmp = this.state[31] + this.w[31] + ((this.state[15] ^ this.state[23]) & this.state[7] ^ this.state[23]);
        this.state[7] = SIMDBigCore.circularLeft(tmp, p0) + this.tA[pp8k[isp + 3] ^ 7];
        this.state[31] = this.state[23];
        this.state[23] = this.state[15];
        this.state[15] = this.tA[7];
        this.tA[0] = SIMDBigCore.circularLeft(this.state[0], p0);
        this.tA[1] = SIMDBigCore.circularLeft(this.state[1], p0);
        this.tA[2] = SIMDBigCore.circularLeft(this.state[2], p0);
        this.tA[3] = SIMDBigCore.circularLeft(this.state[3], p0);
        this.tA[4] = SIMDBigCore.circularLeft(this.state[4], p0);
        this.tA[5] = SIMDBigCore.circularLeft(this.state[5], p0);
        this.tA[6] = SIMDBigCore.circularLeft(this.state[6], p0);
        this.tA[7] = SIMDBigCore.circularLeft(this.state[7], p0);
        tmp = this.state[24] + this.w[32] + (this.state[0] & this.state[8] | (this.state[0] | this.state[8]) & this.state[16]);
        this.state[0] = SIMDBigCore.circularLeft(tmp, p1) + this.tA[pp8k[isp + 4] ^ 0];
        this.state[24] = this.state[16];
        this.state[16] = this.state[8];
        this.state[8] = this.tA[0];
        tmp = this.state[25] + this.w[33] + (this.state[1] & this.state[9] | (this.state[1] | this.state[9]) & this.state[17]);
        this.state[1] = SIMDBigCore.circularLeft(tmp, p1) + this.tA[pp8k[isp + 4] ^ 1];
        this.state[25] = this.state[17];
        this.state[17] = this.state[9];
        this.state[9] = this.tA[1];
        tmp = this.state[26] + this.w[34] + (this.state[2] & this.state[10] | (this.state[2] | this.state[10]) & this.state[18]);
        this.state[2] = SIMDBigCore.circularLeft(tmp, p1) + this.tA[pp8k[isp + 4] ^ 2];
        this.state[26] = this.state[18];
        this.state[18] = this.state[10];
        this.state[10] = this.tA[2];
        tmp = this.state[27] + this.w[35] + (this.state[3] & this.state[11] | (this.state[3] | this.state[11]) & this.state[19]);
        this.state[3] = SIMDBigCore.circularLeft(tmp, p1) + this.tA[pp8k[isp + 4] ^ 3];
        this.state[27] = this.state[19];
        this.state[19] = this.state[11];
        this.state[11] = this.tA[3];
        tmp = this.state[28] + this.w[36] + (this.state[4] & this.state[12] | (this.state[4] | this.state[12]) & this.state[20]);
        this.state[4] = SIMDBigCore.circularLeft(tmp, p1) + this.tA[pp8k[isp + 4] ^ 4];
        this.state[28] = this.state[20];
        this.state[20] = this.state[12];
        this.state[12] = this.tA[4];
        tmp = this.state[29] + this.w[37] + (this.state[5] & this.state[13] | (this.state[5] | this.state[13]) & this.state[21]);
        this.state[5] = SIMDBigCore.circularLeft(tmp, p1) + this.tA[pp8k[isp + 4] ^ 5];
        this.state[29] = this.state[21];
        this.state[21] = this.state[13];
        this.state[13] = this.tA[5];
        tmp = this.state[30] + this.w[38] + (this.state[6] & this.state[14] | (this.state[6] | this.state[14]) & this.state[22]);
        this.state[6] = SIMDBigCore.circularLeft(tmp, p1) + this.tA[pp8k[isp + 4] ^ 6];
        this.state[30] = this.state[22];
        this.state[22] = this.state[14];
        this.state[14] = this.tA[6];
        tmp = this.state[31] + this.w[39] + (this.state[7] & this.state[15] | (this.state[7] | this.state[15]) & this.state[23]);
        this.state[7] = SIMDBigCore.circularLeft(tmp, p1) + this.tA[pp8k[isp + 4] ^ 7];
        this.state[31] = this.state[23];
        this.state[23] = this.state[15];
        this.state[15] = this.tA[7];
        this.tA[0] = SIMDBigCore.circularLeft(this.state[0], p1);
        this.tA[1] = SIMDBigCore.circularLeft(this.state[1], p1);
        this.tA[2] = SIMDBigCore.circularLeft(this.state[2], p1);
        this.tA[3] = SIMDBigCore.circularLeft(this.state[3], p1);
        this.tA[4] = SIMDBigCore.circularLeft(this.state[4], p1);
        this.tA[5] = SIMDBigCore.circularLeft(this.state[5], p1);
        this.tA[6] = SIMDBigCore.circularLeft(this.state[6], p1);
        this.tA[7] = SIMDBigCore.circularLeft(this.state[7], p1);
        tmp = this.state[24] + this.w[40] + (this.state[0] & this.state[8] | (this.state[0] | this.state[8]) & this.state[16]);
        this.state[0] = SIMDBigCore.circularLeft(tmp, p2) + this.tA[pp8k[isp + 5] ^ 0];
        this.state[24] = this.state[16];
        this.state[16] = this.state[8];
        this.state[8] = this.tA[0];
        tmp = this.state[25] + this.w[41] + (this.state[1] & this.state[9] | (this.state[1] | this.state[9]) & this.state[17]);
        this.state[1] = SIMDBigCore.circularLeft(tmp, p2) + this.tA[pp8k[isp + 5] ^ 1];
        this.state[25] = this.state[17];
        this.state[17] = this.state[9];
        this.state[9] = this.tA[1];
        tmp = this.state[26] + this.w[42] + (this.state[2] & this.state[10] | (this.state[2] | this.state[10]) & this.state[18]);
        this.state[2] = SIMDBigCore.circularLeft(tmp, p2) + this.tA[pp8k[isp + 5] ^ 2];
        this.state[26] = this.state[18];
        this.state[18] = this.state[10];
        this.state[10] = this.tA[2];
        tmp = this.state[27] + this.w[43] + (this.state[3] & this.state[11] | (this.state[3] | this.state[11]) & this.state[19]);
        this.state[3] = SIMDBigCore.circularLeft(tmp, p2) + this.tA[pp8k[isp + 5] ^ 3];
        this.state[27] = this.state[19];
        this.state[19] = this.state[11];
        this.state[11] = this.tA[3];
        tmp = this.state[28] + this.w[44] + (this.state[4] & this.state[12] | (this.state[4] | this.state[12]) & this.state[20]);
        this.state[4] = SIMDBigCore.circularLeft(tmp, p2) + this.tA[pp8k[isp + 5] ^ 4];
        this.state[28] = this.state[20];
        this.state[20] = this.state[12];
        this.state[12] = this.tA[4];
        tmp = this.state[29] + this.w[45] + (this.state[5] & this.state[13] | (this.state[5] | this.state[13]) & this.state[21]);
        this.state[5] = SIMDBigCore.circularLeft(tmp, p2) + this.tA[pp8k[isp + 5] ^ 5];
        this.state[29] = this.state[21];
        this.state[21] = this.state[13];
        this.state[13] = this.tA[5];
        tmp = this.state[30] + this.w[46] + (this.state[6] & this.state[14] | (this.state[6] | this.state[14]) & this.state[22]);
        this.state[6] = SIMDBigCore.circularLeft(tmp, p2) + this.tA[pp8k[isp + 5] ^ 6];
        this.state[30] = this.state[22];
        this.state[22] = this.state[14];
        this.state[14] = this.tA[6];
        tmp = this.state[31] + this.w[47] + (this.state[7] & this.state[15] | (this.state[7] | this.state[15]) & this.state[23]);
        this.state[7] = SIMDBigCore.circularLeft(tmp, p2) + this.tA[pp8k[isp + 5] ^ 7];
        this.state[31] = this.state[23];
        this.state[23] = this.state[15];
        this.state[15] = this.tA[7];
        this.tA[0] = SIMDBigCore.circularLeft(this.state[0], p2);
        this.tA[1] = SIMDBigCore.circularLeft(this.state[1], p2);
        this.tA[2] = SIMDBigCore.circularLeft(this.state[2], p2);
        this.tA[3] = SIMDBigCore.circularLeft(this.state[3], p2);
        this.tA[4] = SIMDBigCore.circularLeft(this.state[4], p2);
        this.tA[5] = SIMDBigCore.circularLeft(this.state[5], p2);
        this.tA[6] = SIMDBigCore.circularLeft(this.state[6], p2);
        this.tA[7] = SIMDBigCore.circularLeft(this.state[7], p2);
        tmp = this.state[24] + this.w[48] + (this.state[0] & this.state[8] | (this.state[0] | this.state[8]) & this.state[16]);
        this.state[0] = SIMDBigCore.circularLeft(tmp, p3) + this.tA[pp8k[isp + 6] ^ 0];
        this.state[24] = this.state[16];
        this.state[16] = this.state[8];
        this.state[8] = this.tA[0];
        tmp = this.state[25] + this.w[49] + (this.state[1] & this.state[9] | (this.state[1] | this.state[9]) & this.state[17]);
        this.state[1] = SIMDBigCore.circularLeft(tmp, p3) + this.tA[pp8k[isp + 6] ^ 1];
        this.state[25] = this.state[17];
        this.state[17] = this.state[9];
        this.state[9] = this.tA[1];
        tmp = this.state[26] + this.w[50] + (this.state[2] & this.state[10] | (this.state[2] | this.state[10]) & this.state[18]);
        this.state[2] = SIMDBigCore.circularLeft(tmp, p3) + this.tA[pp8k[isp + 6] ^ 2];
        this.state[26] = this.state[18];
        this.state[18] = this.state[10];
        this.state[10] = this.tA[2];
        tmp = this.state[27] + this.w[51] + (this.state[3] & this.state[11] | (this.state[3] | this.state[11]) & this.state[19]);
        this.state[3] = SIMDBigCore.circularLeft(tmp, p3) + this.tA[pp8k[isp + 6] ^ 3];
        this.state[27] = this.state[19];
        this.state[19] = this.state[11];
        this.state[11] = this.tA[3];
        tmp = this.state[28] + this.w[52] + (this.state[4] & this.state[12] | (this.state[4] | this.state[12]) & this.state[20]);
        this.state[4] = SIMDBigCore.circularLeft(tmp, p3) + this.tA[pp8k[isp + 6] ^ 4];
        this.state[28] = this.state[20];
        this.state[20] = this.state[12];
        this.state[12] = this.tA[4];
        tmp = this.state[29] + this.w[53] + (this.state[5] & this.state[13] | (this.state[5] | this.state[13]) & this.state[21]);
        this.state[5] = SIMDBigCore.circularLeft(tmp, p3) + this.tA[pp8k[isp + 6] ^ 5];
        this.state[29] = this.state[21];
        this.state[21] = this.state[13];
        this.state[13] = this.tA[5];
        tmp = this.state[30] + this.w[54] + (this.state[6] & this.state[14] | (this.state[6] | this.state[14]) & this.state[22]);
        this.state[6] = SIMDBigCore.circularLeft(tmp, p3) + this.tA[pp8k[isp + 6] ^ 6];
        this.state[30] = this.state[22];
        this.state[22] = this.state[14];
        this.state[14] = this.tA[6];
        tmp = this.state[31] + this.w[55] + (this.state[7] & this.state[15] | (this.state[7] | this.state[15]) & this.state[23]);
        this.state[7] = SIMDBigCore.circularLeft(tmp, p3) + this.tA[pp8k[isp + 6] ^ 7];
        this.state[31] = this.state[23];
        this.state[23] = this.state[15];
        this.state[15] = this.tA[7];
        this.tA[0] = SIMDBigCore.circularLeft(this.state[0], p3);
        this.tA[1] = SIMDBigCore.circularLeft(this.state[1], p3);
        this.tA[2] = SIMDBigCore.circularLeft(this.state[2], p3);
        this.tA[3] = SIMDBigCore.circularLeft(this.state[3], p3);
        this.tA[4] = SIMDBigCore.circularLeft(this.state[4], p3);
        this.tA[5] = SIMDBigCore.circularLeft(this.state[5], p3);
        this.tA[6] = SIMDBigCore.circularLeft(this.state[6], p3);
        this.tA[7] = SIMDBigCore.circularLeft(this.state[7], p3);
        tmp = this.state[24] + this.w[56] + (this.state[0] & this.state[8] | (this.state[0] | this.state[8]) & this.state[16]);
        this.state[0] = SIMDBigCore.circularLeft(tmp, p0) + this.tA[pp8k[isp + 7] ^ 0];
        this.state[24] = this.state[16];
        this.state[16] = this.state[8];
        this.state[8] = this.tA[0];
        tmp = this.state[25] + this.w[57] + (this.state[1] & this.state[9] | (this.state[1] | this.state[9]) & this.state[17]);
        this.state[1] = SIMDBigCore.circularLeft(tmp, p0) + this.tA[pp8k[isp + 7] ^ 1];
        this.state[25] = this.state[17];
        this.state[17] = this.state[9];
        this.state[9] = this.tA[1];
        tmp = this.state[26] + this.w[58] + (this.state[2] & this.state[10] | (this.state[2] | this.state[10]) & this.state[18]);
        this.state[2] = SIMDBigCore.circularLeft(tmp, p0) + this.tA[pp8k[isp + 7] ^ 2];
        this.state[26] = this.state[18];
        this.state[18] = this.state[10];
        this.state[10] = this.tA[2];
        tmp = this.state[27] + this.w[59] + (this.state[3] & this.state[11] | (this.state[3] | this.state[11]) & this.state[19]);
        this.state[3] = SIMDBigCore.circularLeft(tmp, p0) + this.tA[pp8k[isp + 7] ^ 3];
        this.state[27] = this.state[19];
        this.state[19] = this.state[11];
        this.state[11] = this.tA[3];
        tmp = this.state[28] + this.w[60] + (this.state[4] & this.state[12] | (this.state[4] | this.state[12]) & this.state[20]);
        this.state[4] = SIMDBigCore.circularLeft(tmp, p0) + this.tA[pp8k[isp + 7] ^ 4];
        this.state[28] = this.state[20];
        this.state[20] = this.state[12];
        this.state[12] = this.tA[4];
        tmp = this.state[29] + this.w[61] + (this.state[5] & this.state[13] | (this.state[5] | this.state[13]) & this.state[21]);
        this.state[5] = SIMDBigCore.circularLeft(tmp, p0) + this.tA[pp8k[isp + 7] ^ 5];
        this.state[29] = this.state[21];
        this.state[21] = this.state[13];
        this.state[13] = this.tA[5];
        tmp = this.state[30] + this.w[62] + (this.state[6] & this.state[14] | (this.state[6] | this.state[14]) & this.state[22]);
        this.state[6] = SIMDBigCore.circularLeft(tmp, p0) + this.tA[pp8k[isp + 7] ^ 6];
        this.state[30] = this.state[22];
        this.state[22] = this.state[14];
        this.state[14] = this.tA[6];
        tmp = this.state[31] + this.w[63] + (this.state[7] & this.state[15] | (this.state[7] | this.state[15]) & this.state[23]);
        this.state[7] = SIMDBigCore.circularLeft(tmp, p0) + this.tA[pp8k[isp + 7] ^ 7];
        this.state[31] = this.state[23];
        this.state[23] = this.state[15];
        this.state[15] = this.tA[7];
    }

    private final void compress(byte[] x, boolean last) {
        int tq;
        int i;
        int t;
        this.fft64(x, 0, 4, 0);
        this.fft64(x, 2, 4, 64);
        int m = this.q[0];
        int n = this.q[64];
        this.q[0] = m + n;
        this.q[64] = m - n;
        int u = 0;
        int v = 0;
        while (u < 64) {
            if (u != 0) {
                m = this.q[0 + u + 0];
                n = this.q[0 + u + 0 + 64];
                t = (n * alphaTab[v + 0] & 0xFFFF) + (n * alphaTab[v + 0] >> 16);
                this.q[0 + u + 0] = m + t;
                this.q[0 + u + 0 + 64] = m - t;
            }
            m = this.q[0 + u + 1];
            n = this.q[0 + u + 1 + 64];
            t = (n * alphaTab[v + 2] & 0xFFFF) + (n * alphaTab[v + 2] >> 16);
            this.q[0 + u + 1] = m + t;
            this.q[0 + u + 1 + 64] = m - t;
            m = this.q[0 + u + 2];
            n = this.q[0 + u + 2 + 64];
            t = (n * alphaTab[v + 4] & 0xFFFF) + (n * alphaTab[v + 4] >> 16);
            this.q[0 + u + 2] = m + t;
            this.q[0 + u + 2 + 64] = m - t;
            m = this.q[0 + u + 3];
            n = this.q[0 + u + 3 + 64];
            t = (n * alphaTab[v + 6] & 0xFFFF) + (n * alphaTab[v + 6] >> 16);
            this.q[0 + u + 3] = m + t;
            this.q[0 + u + 3 + 64] = m - t;
            u += 4;
            v += 8;
        }
        this.fft64(x, 1, 4, 128);
        this.fft64(x, 3, 4, 192);
        m = this.q[128];
        n = this.q[192];
        this.q[128] = m + n;
        this.q[192] = m - n;
        u = 0;
        v = 0;
        while (u < 64) {
            if (u != 0) {
                m = this.q[128 + u + 0];
                n = this.q[128 + u + 0 + 64];
                t = (n * alphaTab[v + 0] & 0xFFFF) + (n * alphaTab[v + 0] >> 16);
                this.q[128 + u + 0] = m + t;
                this.q[128 + u + 0 + 64] = m - t;
            }
            m = this.q[128 + u + 1];
            n = this.q[128 + u + 1 + 64];
            t = (n * alphaTab[v + 2] & 0xFFFF) + (n * alphaTab[v + 2] >> 16);
            this.q[128 + u + 1] = m + t;
            this.q[128 + u + 1 + 64] = m - t;
            m = this.q[128 + u + 2];
            n = this.q[128 + u + 2 + 64];
            t = (n * alphaTab[v + 4] & 0xFFFF) + (n * alphaTab[v + 4] >> 16);
            this.q[128 + u + 2] = m + t;
            this.q[128 + u + 2 + 64] = m - t;
            m = this.q[128 + u + 3];
            n = this.q[128 + u + 3 + 64];
            t = (n * alphaTab[v + 6] & 0xFFFF) + (n * alphaTab[v + 6] >> 16);
            this.q[128 + u + 3] = m + t;
            this.q[128 + u + 3 + 64] = m - t;
            u += 4;
            v += 8;
        }
        m = this.q[0];
        n = this.q[128];
        this.q[0] = m + n;
        this.q[128] = m - n;
        u = 0;
        v = 0;
        while (u < 128) {
            if (u != 0) {
                m = this.q[0 + u + 0];
                n = this.q[0 + u + 0 + 128];
                t = (n * alphaTab[v + 0] & 0xFFFF) + (n * alphaTab[v + 0] >> 16);
                this.q[0 + u + 0] = m + t;
                this.q[0 + u + 0 + 128] = m - t;
            }
            m = this.q[0 + u + 1];
            n = this.q[0 + u + 1 + 128];
            t = (n * alphaTab[v + 1] & 0xFFFF) + (n * alphaTab[v + 1] >> 16);
            this.q[0 + u + 1] = m + t;
            this.q[0 + u + 1 + 128] = m - t;
            m = this.q[0 + u + 2];
            n = this.q[0 + u + 2 + 128];
            t = (n * alphaTab[v + 2] & 0xFFFF) + (n * alphaTab[v + 2] >> 16);
            this.q[0 + u + 2] = m + t;
            this.q[0 + u + 2 + 128] = m - t;
            m = this.q[0 + u + 3];
            n = this.q[0 + u + 3 + 128];
            t = (n * alphaTab[v + 3] & 0xFFFF) + (n * alphaTab[v + 3] >> 16);
            this.q[0 + u + 3] = m + t;
            this.q[0 + u + 3 + 128] = m - t;
            u += 4;
            v += 4;
        }
        if (last) {
            for (i = 0; i < 256; ++i) {
                tq = this.q[i] + yoffF[i];
                tq = (tq & 0xFFFF) + (tq >> 16);
                tq = (tq & 0xFF) - (tq >> 8);
                this.q[i] = (tq = (tq & 0xFF) - (tq >> 8)) <= 128 ? tq : tq - 257;
            }
        } else {
            for (i = 0; i < 256; ++i) {
                tq = this.q[i] + yoffN[i];
                tq = (tq & 0xFFFF) + (tq >> 16);
                tq = (tq & 0xFF) - (tq >> 8);
                this.q[i] = (tq = (tq & 0xFF) - (tq >> 8)) <= 128 ? tq : tq - 257;
            }
        }
        System.arraycopy(this.state, 0, this.tmpState, 0, 32);
        for (i = 0; i < 32; i += 8) {
            int n2 = i + 0;
            this.state[n2] = this.state[n2] ^ SIMDBigCore.decodeLEInt(x, 4 * (i + 0));
            int n3 = i + 1;
            this.state[n3] = this.state[n3] ^ SIMDBigCore.decodeLEInt(x, 4 * (i + 1));
            int n4 = i + 2;
            this.state[n4] = this.state[n4] ^ SIMDBigCore.decodeLEInt(x, 4 * (i + 2));
            int n5 = i + 3;
            this.state[n5] = this.state[n5] ^ SIMDBigCore.decodeLEInt(x, 4 * (i + 3));
            int n6 = i + 4;
            this.state[n6] = this.state[n6] ^ SIMDBigCore.decodeLEInt(x, 4 * (i + 4));
            int n7 = i + 5;
            this.state[n7] = this.state[n7] ^ SIMDBigCore.decodeLEInt(x, 4 * (i + 5));
            int n8 = i + 6;
            this.state[n8] = this.state[n8] ^ SIMDBigCore.decodeLEInt(x, 4 * (i + 6));
            int n9 = i + 7;
            this.state[n9] = this.state[n9] ^ SIMDBigCore.decodeLEInt(x, 4 * (i + 7));
        }
        for (u = 0; u < 64; u += 8) {
            v = wbp[(u >> 3) + 0];
            this.w[u + 0] = (this.q[v + 0 + 0] * 185 & 0xFFFF) + (this.q[v + 0 + 1] * 185 << 16);
            this.w[u + 1] = (this.q[v + 2 + 0] * 185 & 0xFFFF) + (this.q[v + 2 + 1] * 185 << 16);
            this.w[u + 2] = (this.q[v + 4 + 0] * 185 & 0xFFFF) + (this.q[v + 4 + 1] * 185 << 16);
            this.w[u + 3] = (this.q[v + 6 + 0] * 185 & 0xFFFF) + (this.q[v + 6 + 1] * 185 << 16);
            this.w[u + 4] = (this.q[v + 8 + 0] * 185 & 0xFFFF) + (this.q[v + 8 + 1] * 185 << 16);
            this.w[u + 5] = (this.q[v + 10 + 0] * 185 & 0xFFFF) + (this.q[v + 10 + 1] * 185 << 16);
            this.w[u + 6] = (this.q[v + 12 + 0] * 185 & 0xFFFF) + (this.q[v + 12 + 1] * 185 << 16);
            this.w[u + 7] = (this.q[v + 14 + 0] * 185 & 0xFFFF) + (this.q[v + 14 + 1] * 185 << 16);
        }
        this.oneRound(0, 3, 23, 17, 27);
        for (u = 0; u < 64; u += 8) {
            v = wbp[(u >> 3) + 8];
            this.w[u + 0] = (this.q[v + 0 + 0] * 185 & 0xFFFF) + (this.q[v + 0 + 1] * 185 << 16);
            this.w[u + 1] = (this.q[v + 2 + 0] * 185 & 0xFFFF) + (this.q[v + 2 + 1] * 185 << 16);
            this.w[u + 2] = (this.q[v + 4 + 0] * 185 & 0xFFFF) + (this.q[v + 4 + 1] * 185 << 16);
            this.w[u + 3] = (this.q[v + 6 + 0] * 185 & 0xFFFF) + (this.q[v + 6 + 1] * 185 << 16);
            this.w[u + 4] = (this.q[v + 8 + 0] * 185 & 0xFFFF) + (this.q[v + 8 + 1] * 185 << 16);
            this.w[u + 5] = (this.q[v + 10 + 0] * 185 & 0xFFFF) + (this.q[v + 10 + 1] * 185 << 16);
            this.w[u + 6] = (this.q[v + 12 + 0] * 185 & 0xFFFF) + (this.q[v + 12 + 1] * 185 << 16);
            this.w[u + 7] = (this.q[v + 14 + 0] * 185 & 0xFFFF) + (this.q[v + 14 + 1] * 185 << 16);
        }
        this.oneRound(1, 28, 19, 22, 7);
        for (u = 0; u < 64; u += 8) {
            v = wbp[(u >> 3) + 16];
            this.w[u + 0] = (this.q[v + 0 + -256] * 233 & 0xFFFF) + (this.q[v + 0 + -128] * 233 << 16);
            this.w[u + 1] = (this.q[v + 2 + -256] * 233 & 0xFFFF) + (this.q[v + 2 + -128] * 233 << 16);
            this.w[u + 2] = (this.q[v + 4 + -256] * 233 & 0xFFFF) + (this.q[v + 4 + -128] * 233 << 16);
            this.w[u + 3] = (this.q[v + 6 + -256] * 233 & 0xFFFF) + (this.q[v + 6 + -128] * 233 << 16);
            this.w[u + 4] = (this.q[v + 8 + -256] * 233 & 0xFFFF) + (this.q[v + 8 + -128] * 233 << 16);
            this.w[u + 5] = (this.q[v + 10 + -256] * 233 & 0xFFFF) + (this.q[v + 10 + -128] * 233 << 16);
            this.w[u + 6] = (this.q[v + 12 + -256] * 233 & 0xFFFF) + (this.q[v + 12 + -128] * 233 << 16);
            this.w[u + 7] = (this.q[v + 14 + -256] * 233 & 0xFFFF) + (this.q[v + 14 + -128] * 233 << 16);
        }
        this.oneRound(2, 29, 9, 15, 5);
        for (u = 0; u < 64; u += 8) {
            v = wbp[(u >> 3) + 24];
            this.w[u + 0] = (this.q[v + 0 + -383] * 233 & 0xFFFF) + (this.q[v + 0 + -255] * 233 << 16);
            this.w[u + 1] = (this.q[v + 2 + -383] * 233 & 0xFFFF) + (this.q[v + 2 + -255] * 233 << 16);
            this.w[u + 2] = (this.q[v + 4 + -383] * 233 & 0xFFFF) + (this.q[v + 4 + -255] * 233 << 16);
            this.w[u + 3] = (this.q[v + 6 + -383] * 233 & 0xFFFF) + (this.q[v + 6 + -255] * 233 << 16);
            this.w[u + 4] = (this.q[v + 8 + -383] * 233 & 0xFFFF) + (this.q[v + 8 + -255] * 233 << 16);
            this.w[u + 5] = (this.q[v + 10 + -383] * 233 & 0xFFFF) + (this.q[v + 10 + -255] * 233 << 16);
            this.w[u + 6] = (this.q[v + 12 + -383] * 233 & 0xFFFF) + (this.q[v + 12 + -255] * 233 << 16);
            this.w[u + 7] = (this.q[v + 14 + -383] * 233 & 0xFFFF) + (this.q[v + 14 + -255] * 233 << 16);
        }
        this.oneRound(3, 4, 13, 10, 25);
        int tA0 = SIMDBigCore.circularLeft(this.state[0], 4);
        int tA1 = SIMDBigCore.circularLeft(this.state[1], 4);
        int tA2 = SIMDBigCore.circularLeft(this.state[2], 4);
        int tA3 = SIMDBigCore.circularLeft(this.state[3], 4);
        int tA4 = SIMDBigCore.circularLeft(this.state[4], 4);
        int tA5 = SIMDBigCore.circularLeft(this.state[5], 4);
        int tA6 = SIMDBigCore.circularLeft(this.state[6], 4);
        int tA7 = SIMDBigCore.circularLeft(this.state[7], 4);
        int tmp = this.state[24] + this.tmpState[0] + ((this.state[8] ^ this.state[16]) & this.state[0] ^ this.state[16]);
        this.state[0] = SIMDBigCore.circularLeft(tmp, 13) + tA5;
        this.state[24] = this.state[16];
        this.state[16] = this.state[8];
        this.state[8] = tA0;
        tmp = this.state[25] + this.tmpState[1] + ((this.state[9] ^ this.state[17]) & this.state[1] ^ this.state[17]);
        this.state[1] = SIMDBigCore.circularLeft(tmp, 13) + tA4;
        this.state[25] = this.state[17];
        this.state[17] = this.state[9];
        this.state[9] = tA1;
        tmp = this.state[26] + this.tmpState[2] + ((this.state[10] ^ this.state[18]) & this.state[2] ^ this.state[18]);
        this.state[2] = SIMDBigCore.circularLeft(tmp, 13) + tA7;
        this.state[26] = this.state[18];
        this.state[18] = this.state[10];
        this.state[10] = tA2;
        tmp = this.state[27] + this.tmpState[3] + ((this.state[11] ^ this.state[19]) & this.state[3] ^ this.state[19]);
        this.state[3] = SIMDBigCore.circularLeft(tmp, 13) + tA6;
        this.state[27] = this.state[19];
        this.state[19] = this.state[11];
        this.state[11] = tA3;
        tmp = this.state[28] + this.tmpState[4] + ((this.state[12] ^ this.state[20]) & this.state[4] ^ this.state[20]);
        this.state[4] = SIMDBigCore.circularLeft(tmp, 13) + tA1;
        this.state[28] = this.state[20];
        this.state[20] = this.state[12];
        this.state[12] = tA4;
        tmp = this.state[29] + this.tmpState[5] + ((this.state[13] ^ this.state[21]) & this.state[5] ^ this.state[21]);
        this.state[5] = SIMDBigCore.circularLeft(tmp, 13) + tA0;
        this.state[29] = this.state[21];
        this.state[21] = this.state[13];
        this.state[13] = tA5;
        tmp = this.state[30] + this.tmpState[6] + ((this.state[14] ^ this.state[22]) & this.state[6] ^ this.state[22]);
        this.state[6] = SIMDBigCore.circularLeft(tmp, 13) + tA3;
        this.state[30] = this.state[22];
        this.state[22] = this.state[14];
        this.state[14] = tA6;
        tmp = this.state[31] + this.tmpState[7] + ((this.state[15] ^ this.state[23]) & this.state[7] ^ this.state[23]);
        this.state[7] = SIMDBigCore.circularLeft(tmp, 13) + tA2;
        this.state[31] = this.state[23];
        this.state[23] = this.state[15];
        this.state[15] = tA7;
        tA0 = SIMDBigCore.circularLeft(this.state[0], 13);
        tA1 = SIMDBigCore.circularLeft(this.state[1], 13);
        tA2 = SIMDBigCore.circularLeft(this.state[2], 13);
        tA3 = SIMDBigCore.circularLeft(this.state[3], 13);
        tA4 = SIMDBigCore.circularLeft(this.state[4], 13);
        tA5 = SIMDBigCore.circularLeft(this.state[5], 13);
        tA6 = SIMDBigCore.circularLeft(this.state[6], 13);
        tA7 = SIMDBigCore.circularLeft(this.state[7], 13);
        tmp = this.state[24] + this.tmpState[8] + ((this.state[8] ^ this.state[16]) & this.state[0] ^ this.state[16]);
        this.state[0] = SIMDBigCore.circularLeft(tmp, 10) + tA7;
        this.state[24] = this.state[16];
        this.state[16] = this.state[8];
        this.state[8] = tA0;
        tmp = this.state[25] + this.tmpState[9] + ((this.state[9] ^ this.state[17]) & this.state[1] ^ this.state[17]);
        this.state[1] = SIMDBigCore.circularLeft(tmp, 10) + tA6;
        this.state[25] = this.state[17];
        this.state[17] = this.state[9];
        this.state[9] = tA1;
        tmp = this.state[26] + this.tmpState[10] + ((this.state[10] ^ this.state[18]) & this.state[2] ^ this.state[18]);
        this.state[2] = SIMDBigCore.circularLeft(tmp, 10) + tA5;
        this.state[26] = this.state[18];
        this.state[18] = this.state[10];
        this.state[10] = tA2;
        tmp = this.state[27] + this.tmpState[11] + ((this.state[11] ^ this.state[19]) & this.state[3] ^ this.state[19]);
        this.state[3] = SIMDBigCore.circularLeft(tmp, 10) + tA4;
        this.state[27] = this.state[19];
        this.state[19] = this.state[11];
        this.state[11] = tA3;
        tmp = this.state[28] + this.tmpState[12] + ((this.state[12] ^ this.state[20]) & this.state[4] ^ this.state[20]);
        this.state[4] = SIMDBigCore.circularLeft(tmp, 10) + tA3;
        this.state[28] = this.state[20];
        this.state[20] = this.state[12];
        this.state[12] = tA4;
        tmp = this.state[29] + this.tmpState[13] + ((this.state[13] ^ this.state[21]) & this.state[5] ^ this.state[21]);
        this.state[5] = SIMDBigCore.circularLeft(tmp, 10) + tA2;
        this.state[29] = this.state[21];
        this.state[21] = this.state[13];
        this.state[13] = tA5;
        tmp = this.state[30] + this.tmpState[14] + ((this.state[14] ^ this.state[22]) & this.state[6] ^ this.state[22]);
        this.state[6] = SIMDBigCore.circularLeft(tmp, 10) + tA1;
        this.state[30] = this.state[22];
        this.state[22] = this.state[14];
        this.state[14] = tA6;
        tmp = this.state[31] + this.tmpState[15] + ((this.state[15] ^ this.state[23]) & this.state[7] ^ this.state[23]);
        this.state[7] = SIMDBigCore.circularLeft(tmp, 10) + tA0;
        this.state[31] = this.state[23];
        this.state[23] = this.state[15];
        this.state[15] = tA7;
        tA0 = SIMDBigCore.circularLeft(this.state[0], 10);
        tA1 = SIMDBigCore.circularLeft(this.state[1], 10);
        tA2 = SIMDBigCore.circularLeft(this.state[2], 10);
        tA3 = SIMDBigCore.circularLeft(this.state[3], 10);
        tA4 = SIMDBigCore.circularLeft(this.state[4], 10);
        tA5 = SIMDBigCore.circularLeft(this.state[5], 10);
        tA6 = SIMDBigCore.circularLeft(this.state[6], 10);
        tA7 = SIMDBigCore.circularLeft(this.state[7], 10);
        tmp = this.state[24] + this.tmpState[16] + ((this.state[8] ^ this.state[16]) & this.state[0] ^ this.state[16]);
        this.state[0] = SIMDBigCore.circularLeft(tmp, 25) + tA4;
        this.state[24] = this.state[16];
        this.state[16] = this.state[8];
        this.state[8] = tA0;
        tmp = this.state[25] + this.tmpState[17] + ((this.state[9] ^ this.state[17]) & this.state[1] ^ this.state[17]);
        this.state[1] = SIMDBigCore.circularLeft(tmp, 25) + tA5;
        this.state[25] = this.state[17];
        this.state[17] = this.state[9];
        this.state[9] = tA1;
        tmp = this.state[26] + this.tmpState[18] + ((this.state[10] ^ this.state[18]) & this.state[2] ^ this.state[18]);
        this.state[2] = SIMDBigCore.circularLeft(tmp, 25) + tA6;
        this.state[26] = this.state[18];
        this.state[18] = this.state[10];
        this.state[10] = tA2;
        tmp = this.state[27] + this.tmpState[19] + ((this.state[11] ^ this.state[19]) & this.state[3] ^ this.state[19]);
        this.state[3] = SIMDBigCore.circularLeft(tmp, 25) + tA7;
        this.state[27] = this.state[19];
        this.state[19] = this.state[11];
        this.state[11] = tA3;
        tmp = this.state[28] + this.tmpState[20] + ((this.state[12] ^ this.state[20]) & this.state[4] ^ this.state[20]);
        this.state[4] = SIMDBigCore.circularLeft(tmp, 25) + tA0;
        this.state[28] = this.state[20];
        this.state[20] = this.state[12];
        this.state[12] = tA4;
        tmp = this.state[29] + this.tmpState[21] + ((this.state[13] ^ this.state[21]) & this.state[5] ^ this.state[21]);
        this.state[5] = SIMDBigCore.circularLeft(tmp, 25) + tA1;
        this.state[29] = this.state[21];
        this.state[21] = this.state[13];
        this.state[13] = tA5;
        tmp = this.state[30] + this.tmpState[22] + ((this.state[14] ^ this.state[22]) & this.state[6] ^ this.state[22]);
        this.state[6] = SIMDBigCore.circularLeft(tmp, 25) + tA2;
        this.state[30] = this.state[22];
        this.state[22] = this.state[14];
        this.state[14] = tA6;
        tmp = this.state[31] + this.tmpState[23] + ((this.state[15] ^ this.state[23]) & this.state[7] ^ this.state[23]);
        this.state[7] = SIMDBigCore.circularLeft(tmp, 25) + tA3;
        this.state[31] = this.state[23];
        this.state[23] = this.state[15];
        this.state[15] = tA7;
        tA0 = SIMDBigCore.circularLeft(this.state[0], 25);
        tA1 = SIMDBigCore.circularLeft(this.state[1], 25);
        tA2 = SIMDBigCore.circularLeft(this.state[2], 25);
        tA3 = SIMDBigCore.circularLeft(this.state[3], 25);
        tA4 = SIMDBigCore.circularLeft(this.state[4], 25);
        tA5 = SIMDBigCore.circularLeft(this.state[5], 25);
        tA6 = SIMDBigCore.circularLeft(this.state[6], 25);
        tA7 = SIMDBigCore.circularLeft(this.state[7], 25);
        tmp = this.state[24] + this.tmpState[24] + ((this.state[8] ^ this.state[16]) & this.state[0] ^ this.state[16]);
        this.state[0] = SIMDBigCore.circularLeft(tmp, 4) + tA1;
        this.state[24] = this.state[16];
        this.state[16] = this.state[8];
        this.state[8] = tA0;
        tmp = this.state[25] + this.tmpState[25] + ((this.state[9] ^ this.state[17]) & this.state[1] ^ this.state[17]);
        this.state[1] = SIMDBigCore.circularLeft(tmp, 4) + tA0;
        this.state[25] = this.state[17];
        this.state[17] = this.state[9];
        this.state[9] = tA1;
        tmp = this.state[26] + this.tmpState[26] + ((this.state[10] ^ this.state[18]) & this.state[2] ^ this.state[18]);
        this.state[2] = SIMDBigCore.circularLeft(tmp, 4) + tA3;
        this.state[26] = this.state[18];
        this.state[18] = this.state[10];
        this.state[10] = tA2;
        tmp = this.state[27] + this.tmpState[27] + ((this.state[11] ^ this.state[19]) & this.state[3] ^ this.state[19]);
        this.state[3] = SIMDBigCore.circularLeft(tmp, 4) + tA2;
        this.state[27] = this.state[19];
        this.state[19] = this.state[11];
        this.state[11] = tA3;
        tmp = this.state[28] + this.tmpState[28] + ((this.state[12] ^ this.state[20]) & this.state[4] ^ this.state[20]);
        this.state[4] = SIMDBigCore.circularLeft(tmp, 4) + tA5;
        this.state[28] = this.state[20];
        this.state[20] = this.state[12];
        this.state[12] = tA4;
        tmp = this.state[29] + this.tmpState[29] + ((this.state[13] ^ this.state[21]) & this.state[5] ^ this.state[21]);
        this.state[5] = SIMDBigCore.circularLeft(tmp, 4) + tA4;
        this.state[29] = this.state[21];
        this.state[21] = this.state[13];
        this.state[13] = tA5;
        tmp = this.state[30] + this.tmpState[30] + ((this.state[14] ^ this.state[22]) & this.state[6] ^ this.state[22]);
        this.state[6] = SIMDBigCore.circularLeft(tmp, 4) + tA7;
        this.state[30] = this.state[22];
        this.state[22] = this.state[14];
        this.state[14] = tA6;
        tmp = this.state[31] + this.tmpState[31] + ((this.state[15] ^ this.state[23]) & this.state[7] ^ this.state[23]);
        this.state[7] = SIMDBigCore.circularLeft(tmp, 4) + tA6;
        this.state[31] = this.state[23];
        this.state[23] = this.state[15];
        this.state[15] = tA7;
    }

    @Override
    public String toString() {
        return "SIMD-" + (this.getDigestLength() << 3);
    }
}

