/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;

abstract class SkeinSmallCore
implements Digest {
    private static final int BLOCK_LEN = 32;
    private byte[] buf = new byte[32];
    private byte[] tmpOut = new byte[32];
    private int ptr;
    private long h0;
    private long h1;
    private long h2;
    private long h3;
    private long bcount;

    SkeinSmallCore() {
        this.reset();
    }

    @Override
    public void update(byte in) {
        if (this.ptr == 32) {
            int etype = this.bcount == 0L ? 224 : 96;
            ++this.bcount;
            this.ubi(etype, 0);
            this.buf[0] = in;
            this.ptr = 1;
        } else {
            this.buf[this.ptr++] = in;
        }
    }

    @Override
    public void update(byte[] inbuf) {
        this.update(inbuf, 0, inbuf.length);
    }

    @Override
    public void update(byte[] inbuf, int off, int len) {
        if (len <= 0) {
            return;
        }
        int clen = 32 - this.ptr;
        if (len <= clen) {
            System.arraycopy(inbuf, off, this.buf, this.ptr, len);
            this.ptr += len;
            return;
        }
        if (clen != 0) {
            System.arraycopy(inbuf, off, this.buf, this.ptr, clen);
            off += clen;
            len -= clen;
        }
        while (true) {
            int etype = this.bcount == 0L ? 224 : 96;
            ++this.bcount;
            this.ubi(etype, 0);
            if (len <= 32) break;
            System.arraycopy(inbuf, off, this.buf, 0, 32);
            off += 32;
            len -= 32;
        }
        System.arraycopy(inbuf, off, this.buf, 0, len);
        this.ptr = len;
    }

    @Override
    public byte[] digest() {
        int len = this.getDigestLength();
        byte[] out = new byte[len];
        this.digest(out, 0, len);
        return out;
    }

    @Override
    public byte[] digest(byte[] inbuf) {
        this.update(inbuf, 0, inbuf.length);
        return this.digest();
    }

    @Override
    public int digest(byte[] outbuf, int off, int len) {
        int i;
        for (i = this.ptr; i < 32; ++i) {
            this.buf[i] = 0;
        }
        this.ubi(this.bcount == 0L ? 480 : 352, this.ptr);
        for (i = 0; i < 32; ++i) {
            this.buf[i] = 0;
        }
        this.bcount = 0L;
        this.ubi(510, 8);
        SkeinSmallCore.encodeLELong(this.h0, this.tmpOut, 0);
        SkeinSmallCore.encodeLELong(this.h1, this.tmpOut, 8);
        SkeinSmallCore.encodeLELong(this.h2, this.tmpOut, 16);
        SkeinSmallCore.encodeLELong(this.h3, this.tmpOut, 24);
        int dlen = this.getDigestLength();
        if (len > dlen) {
            len = dlen;
        }
        System.arraycopy(this.tmpOut, 0, outbuf, off, len);
        this.reset();
        return len;
    }

    @Override
    public void reset() {
        this.ptr = 0;
        long[] iv = this.getInitVal();
        this.h0 = iv[0];
        this.h1 = iv[1];
        this.h2 = iv[2];
        this.h3 = iv[3];
        this.bcount = 0L;
    }

    @Override
    public Digest copy() {
        SkeinSmallCore dst = this.dup();
        System.arraycopy(this.buf, 0, dst.buf, 0, this.ptr);
        dst.ptr = this.ptr;
        dst.h0 = this.h0;
        dst.h1 = this.h1;
        dst.h2 = this.h2;
        dst.h3 = this.h3;
        dst.bcount = this.bcount;
        return dst;
    }

    @Override
    public int getBlockLength() {
        return 32;
    }

    abstract SkeinSmallCore dup();

    abstract long[] getInitVal();

    private static final void encodeLELong(long val, byte[] buf, int off) {
        buf[off + 0] = (byte)val;
        buf[off + 1] = (byte)(val >>> 8);
        buf[off + 2] = (byte)(val >>> 16);
        buf[off + 3] = (byte)(val >>> 24);
        buf[off + 4] = (byte)(val >>> 32);
        buf[off + 5] = (byte)(val >>> 40);
        buf[off + 6] = (byte)(val >>> 48);
        buf[off + 7] = (byte)(val >>> 56);
    }

    private static final long decodeLELong(byte[] buf, int off) {
        return (long)(buf[off] & 0xFF) | (long)(buf[off + 1] & 0xFF) << 8 | (long)(buf[off + 2] & 0xFF) << 16 | (long)(buf[off + 3] & 0xFF) << 24 | (long)(buf[off + 4] & 0xFF) << 32 | (long)(buf[off + 5] & 0xFF) << 40 | (long)(buf[off + 6] & 0xFF) << 48 | (long)(buf[off + 7] & 0xFF) << 56;
    }

    private final void ubi(int etype, int extra) {
        long m0 = SkeinSmallCore.decodeLELong(this.buf, 0);
        long m1 = SkeinSmallCore.decodeLELong(this.buf, 8);
        long m2 = SkeinSmallCore.decodeLELong(this.buf, 16);
        long m3 = SkeinSmallCore.decodeLELong(this.buf, 24);
        long p0 = m0;
        long p1 = m1;
        long p2 = m2;
        long p3 = m3;
        long h4 = this.h0 ^ this.h1 ^ (this.h2 ^ this.h3) ^ 0x1BD11BDAA9FC1A22L;
        long t0 = (this.bcount << 5) + (long)extra;
        long t1 = (this.bcount >>> 59) + ((long)etype << 55);
        long t2 = t0 ^ t1;
        p0 += this.h0;
        p2 += this.h2 + t1;
        p1 = p1 << 14 ^ p1 >>> 50 ^ (p0 += (p1 += this.h1 + t0));
        p3 = p3 << 16 ^ p3 >>> 48 ^ (p2 += (p3 += this.h3 + 0L));
        p0 += p3;
        p3 = p3 << 52 ^ p3 >>> 12 ^ p0;
        p2 += p1;
        p1 = p1 << 57 ^ p1 >>> 7 ^ p2;
        p0 += p1;
        p1 = p1 << 23 ^ p1 >>> 41 ^ p0;
        p2 += p3;
        p3 = p3 << 40 ^ p3 >>> 24 ^ p2;
        p0 += p3;
        p3 = p3 << 5 ^ p3 >>> 59 ^ p0;
        p2 += p1;
        p1 = p1 << 37 ^ p1 >>> 27 ^ p2;
        p0 += this.h1;
        p2 += this.h3 + t2;
        p1 = p1 << 25 ^ p1 >>> 39 ^ (p0 += (p1 += this.h2 + t1));
        p3 = p3 << 33 ^ p3 >>> 31 ^ (p2 += (p3 += h4 + 1L));
        p0 += p3;
        p3 = p3 << 46 ^ p3 >>> 18 ^ p0;
        p2 += p1;
        p1 = p1 << 12 ^ p1 >>> 52 ^ p2;
        p0 += p1;
        p1 = p1 << 58 ^ p1 >>> 6 ^ p0;
        p2 += p3;
        p3 = p3 << 22 ^ p3 >>> 42 ^ p2;
        p0 += p3;
        p3 = p3 << 32 ^ p3 >>> 32 ^ p0;
        p2 += p1;
        p1 = p1 << 32 ^ p1 >>> 32 ^ p2;
        p0 += this.h2;
        p2 += h4 + t0;
        p1 = p1 << 14 ^ p1 >>> 50 ^ (p0 += (p1 += this.h3 + t2));
        p3 = p3 << 16 ^ p3 >>> 48 ^ (p2 += (p3 += this.h0 + 2L));
        p0 += p3;
        p3 = p3 << 52 ^ p3 >>> 12 ^ p0;
        p2 += p1;
        p1 = p1 << 57 ^ p1 >>> 7 ^ p2;
        p0 += p1;
        p1 = p1 << 23 ^ p1 >>> 41 ^ p0;
        p2 += p3;
        p3 = p3 << 40 ^ p3 >>> 24 ^ p2;
        p0 += p3;
        p3 = p3 << 5 ^ p3 >>> 59 ^ p0;
        p2 += p1;
        p1 = p1 << 37 ^ p1 >>> 27 ^ p2;
        p0 += this.h3;
        p2 += this.h0 + t1;
        p1 = p1 << 25 ^ p1 >>> 39 ^ (p0 += (p1 += h4 + t0));
        p3 = p3 << 33 ^ p3 >>> 31 ^ (p2 += (p3 += this.h1 + 3L));
        p0 += p3;
        p3 = p3 << 46 ^ p3 >>> 18 ^ p0;
        p2 += p1;
        p1 = p1 << 12 ^ p1 >>> 52 ^ p2;
        p0 += p1;
        p1 = p1 << 58 ^ p1 >>> 6 ^ p0;
        p2 += p3;
        p3 = p3 << 22 ^ p3 >>> 42 ^ p2;
        p0 += p3;
        p3 = p3 << 32 ^ p3 >>> 32 ^ p0;
        p2 += p1;
        p1 = p1 << 32 ^ p1 >>> 32 ^ p2;
        p0 += h4;
        p2 += this.h1 + t2;
        p1 = p1 << 14 ^ p1 >>> 50 ^ (p0 += (p1 += this.h0 + t1));
        p3 = p3 << 16 ^ p3 >>> 48 ^ (p2 += (p3 += this.h2 + 4L));
        p0 += p3;
        p3 = p3 << 52 ^ p3 >>> 12 ^ p0;
        p2 += p1;
        p1 = p1 << 57 ^ p1 >>> 7 ^ p2;
        p0 += p1;
        p1 = p1 << 23 ^ p1 >>> 41 ^ p0;
        p2 += p3;
        p3 = p3 << 40 ^ p3 >>> 24 ^ p2;
        p0 += p3;
        p3 = p3 << 5 ^ p3 >>> 59 ^ p0;
        p2 += p1;
        p1 = p1 << 37 ^ p1 >>> 27 ^ p2;
        p0 += this.h0;
        p2 += this.h2 + t0;
        p1 = p1 << 25 ^ p1 >>> 39 ^ (p0 += (p1 += this.h1 + t2));
        p3 = p3 << 33 ^ p3 >>> 31 ^ (p2 += (p3 += this.h3 + 5L));
        p0 += p3;
        p3 = p3 << 46 ^ p3 >>> 18 ^ p0;
        p2 += p1;
        p1 = p1 << 12 ^ p1 >>> 52 ^ p2;
        p0 += p1;
        p1 = p1 << 58 ^ p1 >>> 6 ^ p0;
        p2 += p3;
        p3 = p3 << 22 ^ p3 >>> 42 ^ p2;
        p0 += p3;
        p3 = p3 << 32 ^ p3 >>> 32 ^ p0;
        p2 += p1;
        p1 = p1 << 32 ^ p1 >>> 32 ^ p2;
        p0 += this.h1;
        p2 += this.h3 + t1;
        p1 = p1 << 14 ^ p1 >>> 50 ^ (p0 += (p1 += this.h2 + t0));
        p3 = p3 << 16 ^ p3 >>> 48 ^ (p2 += (p3 += h4 + 6L));
        p0 += p3;
        p3 = p3 << 52 ^ p3 >>> 12 ^ p0;
        p2 += p1;
        p1 = p1 << 57 ^ p1 >>> 7 ^ p2;
        p0 += p1;
        p1 = p1 << 23 ^ p1 >>> 41 ^ p0;
        p2 += p3;
        p3 = p3 << 40 ^ p3 >>> 24 ^ p2;
        p0 += p3;
        p3 = p3 << 5 ^ p3 >>> 59 ^ p0;
        p2 += p1;
        p1 = p1 << 37 ^ p1 >>> 27 ^ p2;
        p0 += this.h2;
        p2 += h4 + t2;
        p1 = p1 << 25 ^ p1 >>> 39 ^ (p0 += (p1 += this.h3 + t1));
        p3 = p3 << 33 ^ p3 >>> 31 ^ (p2 += (p3 += this.h0 + 7L));
        p0 += p3;
        p3 = p3 << 46 ^ p3 >>> 18 ^ p0;
        p2 += p1;
        p1 = p1 << 12 ^ p1 >>> 52 ^ p2;
        p0 += p1;
        p1 = p1 << 58 ^ p1 >>> 6 ^ p0;
        p2 += p3;
        p3 = p3 << 22 ^ p3 >>> 42 ^ p2;
        p0 += p3;
        p3 = p3 << 32 ^ p3 >>> 32 ^ p0;
        p2 += p1;
        p1 = p1 << 32 ^ p1 >>> 32 ^ p2;
        p0 += this.h3;
        p2 += this.h0 + t0;
        p1 = p1 << 14 ^ p1 >>> 50 ^ (p0 += (p1 += h4 + t2));
        p3 = p3 << 16 ^ p3 >>> 48 ^ (p2 += (p3 += this.h1 + 8L));
        p0 += p3;
        p3 = p3 << 52 ^ p3 >>> 12 ^ p0;
        p2 += p1;
        p1 = p1 << 57 ^ p1 >>> 7 ^ p2;
        p0 += p1;
        p1 = p1 << 23 ^ p1 >>> 41 ^ p0;
        p2 += p3;
        p3 = p3 << 40 ^ p3 >>> 24 ^ p2;
        p0 += p3;
        p3 = p3 << 5 ^ p3 >>> 59 ^ p0;
        p2 += p1;
        p1 = p1 << 37 ^ p1 >>> 27 ^ p2;
        p0 += h4;
        p2 += this.h1 + t1;
        p1 = p1 << 25 ^ p1 >>> 39 ^ (p0 += (p1 += this.h0 + t0));
        p3 = p3 << 33 ^ p3 >>> 31 ^ (p2 += (p3 += this.h2 + 9L));
        p0 += p3;
        p3 = p3 << 46 ^ p3 >>> 18 ^ p0;
        p2 += p1;
        p1 = p1 << 12 ^ p1 >>> 52 ^ p2;
        p0 += p1;
        p1 = p1 << 58 ^ p1 >>> 6 ^ p0;
        p2 += p3;
        p3 = p3 << 22 ^ p3 >>> 42 ^ p2;
        p0 += p3;
        p3 = p3 << 32 ^ p3 >>> 32 ^ p0;
        p2 += p1;
        p1 = p1 << 32 ^ p1 >>> 32 ^ p2;
        p0 += this.h0;
        p2 += this.h2 + t2;
        p1 = p1 << 14 ^ p1 >>> 50 ^ (p0 += (p1 += this.h1 + t1));
        p3 = p3 << 16 ^ p3 >>> 48 ^ (p2 += (p3 += this.h3 + 10L));
        p0 += p3;
        p3 = p3 << 52 ^ p3 >>> 12 ^ p0;
        p2 += p1;
        p1 = p1 << 57 ^ p1 >>> 7 ^ p2;
        p0 += p1;
        p1 = p1 << 23 ^ p1 >>> 41 ^ p0;
        p2 += p3;
        p3 = p3 << 40 ^ p3 >>> 24 ^ p2;
        p0 += p3;
        p3 = p3 << 5 ^ p3 >>> 59 ^ p0;
        p2 += p1;
        p1 = p1 << 37 ^ p1 >>> 27 ^ p2;
        p0 += this.h1;
        p2 += this.h3 + t0;
        p1 = p1 << 25 ^ p1 >>> 39 ^ (p0 += (p1 += this.h2 + t2));
        p3 = p3 << 33 ^ p3 >>> 31 ^ (p2 += (p3 += h4 + 11L));
        p0 += p3;
        p3 = p3 << 46 ^ p3 >>> 18 ^ p0;
        p2 += p1;
        p1 = p1 << 12 ^ p1 >>> 52 ^ p2;
        p0 += p1;
        p1 = p1 << 58 ^ p1 >>> 6 ^ p0;
        p2 += p3;
        p3 = p3 << 22 ^ p3 >>> 42 ^ p2;
        p0 += p3;
        p3 = p3 << 32 ^ p3 >>> 32 ^ p0;
        p2 += p1;
        p1 = p1 << 32 ^ p1 >>> 32 ^ p2;
        p0 += this.h2;
        p2 += h4 + t1;
        p1 = p1 << 14 ^ p1 >>> 50 ^ (p0 += (p1 += this.h3 + t0));
        p3 = p3 << 16 ^ p3 >>> 48 ^ (p2 += (p3 += this.h0 + 12L));
        p0 += p3;
        p3 = p3 << 52 ^ p3 >>> 12 ^ p0;
        p2 += p1;
        p1 = p1 << 57 ^ p1 >>> 7 ^ p2;
        p0 += p1;
        p1 = p1 << 23 ^ p1 >>> 41 ^ p0;
        p2 += p3;
        p3 = p3 << 40 ^ p3 >>> 24 ^ p2;
        p0 += p3;
        p3 = p3 << 5 ^ p3 >>> 59 ^ p0;
        p2 += p1;
        p1 = p1 << 37 ^ p1 >>> 27 ^ p2;
        p0 += this.h3;
        p2 += this.h0 + t2;
        p1 = p1 << 25 ^ p1 >>> 39 ^ (p0 += (p1 += h4 + t1));
        p3 = p3 << 33 ^ p3 >>> 31 ^ (p2 += (p3 += this.h1 + 13L));
        p0 += p3;
        p3 = p3 << 46 ^ p3 >>> 18 ^ p0;
        p2 += p1;
        p1 = p1 << 12 ^ p1 >>> 52 ^ p2;
        p0 += p1;
        p1 = p1 << 58 ^ p1 >>> 6 ^ p0;
        p2 += p3;
        p3 = p3 << 22 ^ p3 >>> 42 ^ p2;
        p0 += p3;
        p3 = p3 << 32 ^ p3 >>> 32 ^ p0;
        p2 += p1;
        p1 = p1 << 32 ^ p1 >>> 32 ^ p2;
        p0 += h4;
        p2 += this.h1 + t0;
        p1 = p1 << 14 ^ p1 >>> 50 ^ (p0 += (p1 += this.h0 + t2));
        p3 = p3 << 16 ^ p3 >>> 48 ^ (p2 += (p3 += this.h2 + 14L));
        p0 += p3;
        p3 = p3 << 52 ^ p3 >>> 12 ^ p0;
        p2 += p1;
        p1 = p1 << 57 ^ p1 >>> 7 ^ p2;
        p0 += p1;
        p1 = p1 << 23 ^ p1 >>> 41 ^ p0;
        p2 += p3;
        p3 = p3 << 40 ^ p3 >>> 24 ^ p2;
        p0 += p3;
        p3 = p3 << 5 ^ p3 >>> 59 ^ p0;
        p2 += p1;
        p1 = p1 << 37 ^ p1 >>> 27 ^ p2;
        p0 += this.h0;
        p2 += this.h2 + t1;
        p1 = p1 << 25 ^ p1 >>> 39 ^ (p0 += (p1 += this.h1 + t0));
        p3 = p3 << 33 ^ p3 >>> 31 ^ (p2 += (p3 += this.h3 + 15L));
        p0 += p3;
        p3 = p3 << 46 ^ p3 >>> 18 ^ p0;
        p2 += p1;
        p1 = p1 << 12 ^ p1 >>> 52 ^ p2;
        p0 += p1;
        p1 = p1 << 58 ^ p1 >>> 6 ^ p0;
        p2 += p3;
        p3 = p3 << 22 ^ p3 >>> 42 ^ p2;
        p0 += p3;
        p3 = p3 << 32 ^ p3 >>> 32 ^ p0;
        p2 += p1;
        p1 = p1 << 32 ^ p1 >>> 32 ^ p2;
        p0 += this.h1;
        p2 += this.h3 + t2;
        p1 = p1 << 14 ^ p1 >>> 50 ^ (p0 += (p1 += this.h2 + t1));
        p3 = p3 << 16 ^ p3 >>> 48 ^ (p2 += (p3 += h4 + 16L));
        p0 += p3;
        p3 = p3 << 52 ^ p3 >>> 12 ^ p0;
        p2 += p1;
        p1 = p1 << 57 ^ p1 >>> 7 ^ p2;
        p0 += p1;
        p1 = p1 << 23 ^ p1 >>> 41 ^ p0;
        p2 += p3;
        p3 = p3 << 40 ^ p3 >>> 24 ^ p2;
        p0 += p3;
        p3 = p3 << 5 ^ p3 >>> 59 ^ p0;
        p2 += p1;
        p1 = p1 << 37 ^ p1 >>> 27 ^ p2;
        p0 += this.h2;
        p2 += h4 + t0;
        p1 = p1 << 25 ^ p1 >>> 39 ^ (p0 += (p1 += this.h3 + t2));
        p3 = p3 << 33 ^ p3 >>> 31 ^ (p2 += (p3 += this.h0 + 17L));
        p0 += p3;
        p3 = p3 << 46 ^ p3 >>> 18 ^ p0;
        p2 += p1;
        p1 = p1 << 12 ^ p1 >>> 52 ^ p2;
        p0 += p1;
        p1 = p1 << 58 ^ p1 >>> 6 ^ p0;
        p2 += p3;
        p3 = p3 << 22 ^ p3 >>> 42 ^ p2;
        p0 += p3;
        p3 = p3 << 32 ^ p3 >>> 32 ^ p0;
        p2 += p1;
        p1 = p1 << 32 ^ p1 >>> 32 ^ p2;
        this.h0 = m0 ^ (p0 += this.h3);
        this.h1 = m1 ^ (p1 += h4 + t0);
        this.h2 = m2 ^ (p2 += this.h0 + t1);
        this.h3 = m3 ^ (p3 += this.h1 + 18L);
    }

    @Override
    public String toString() {
        return "Skein-" + (this.getDigestLength() << 3);
    }
}

