/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.MDHelper;

abstract class WhirlpoolCore
extends MDHelper {
    private final long[] T0;
    private final long[] T1;
    private final long[] T2;
    private final long[] T3;
    private final long[] T4;
    private final long[] T5;
    private final long[] T6;
    private final long[] T7;
    private final long[] RC;
    private long state0;
    private long state1;
    private long state2;
    private long state3;
    private long state4;
    private long state5;
    private long state6;
    private long state7;

    WhirlpoolCore(long[] T0, long[] T1, long[] T2, long[] T3, long[] T4, long[] T5, long[] T6, long[] T7, long[] RC) {
        super(false, 32);
        this.T0 = T0;
        this.T1 = T1;
        this.T2 = T2;
        this.T3 = T3;
        this.T4 = T4;
        this.T5 = T5;
        this.T6 = T6;
        this.T7 = T7;
        this.RC = RC;
    }

    protected Digest copyState(WhirlpoolCore d) {
        d.state0 = this.state0;
        d.state1 = this.state1;
        d.state2 = this.state2;
        d.state3 = this.state3;
        d.state4 = this.state4;
        d.state5 = this.state5;
        d.state6 = this.state6;
        d.state7 = this.state7;
        return super.copyState(d);
    }

    @Override
    public int getDigestLength() {
        return 64;
    }

    @Override
    public int getBlockLength() {
        return 64;
    }

    @Override
    protected void engineReset() {
        this.state0 = 0L;
        this.state1 = 0L;
        this.state2 = 0L;
        this.state3 = 0L;
        this.state4 = 0L;
        this.state5 = 0L;
        this.state6 = 0L;
        this.state7 = 0L;
    }

    @Override
    protected void doPadding(byte[] output, int outputOffset) {
        this.makeMDPadding();
        WhirlpoolCore.encodeLELong(this.state0, output, outputOffset);
        WhirlpoolCore.encodeLELong(this.state1, output, outputOffset + 8);
        WhirlpoolCore.encodeLELong(this.state2, output, outputOffset + 16);
        WhirlpoolCore.encodeLELong(this.state3, output, outputOffset + 24);
        WhirlpoolCore.encodeLELong(this.state4, output, outputOffset + 32);
        WhirlpoolCore.encodeLELong(this.state5, output, outputOffset + 40);
        WhirlpoolCore.encodeLELong(this.state6, output, outputOffset + 48);
        WhirlpoolCore.encodeLELong(this.state7, output, outputOffset + 56);
    }

    @Override
    protected void doInit() {
        this.engineReset();
    }

    private static final long decodeLELong(byte[] buf, int off) {
        return (long)(buf[off + 0] & 0xFF) | (long)(buf[off + 1] & 0xFF) << 8 | (long)(buf[off + 2] & 0xFF) << 16 | (long)(buf[off + 3] & 0xFF) << 24 | (long)(buf[off + 4] & 0xFF) << 32 | (long)(buf[off + 5] & 0xFF) << 40 | (long)(buf[off + 6] & 0xFF) << 48 | (long)(buf[off + 7] & 0xFF) << 56;
    }

    private static final void encodeLELong(long val, byte[] dst, int off) {
        dst[off + 0] = (byte)val;
        dst[off + 1] = (byte)((int)val >>> 8);
        dst[off + 2] = (byte)((int)val >>> 16);
        dst[off + 3] = (byte)((int)val >>> 24);
        dst[off + 4] = (byte)(val >>> 32);
        dst[off + 5] = (byte)(val >>> 40);
        dst[off + 6] = (byte)(val >>> 48);
        dst[off + 7] = (byte)(val >>> 56);
    }

    @Override
    protected void processBlock(byte[] data) {
        long n7;
        long n6;
        long n5;
        long n4;
        long n3;
        long n2;
        long n1;
        long n0;
        long sn0 = n0 = WhirlpoolCore.decodeLELong(data, 0);
        long sn1 = n1 = WhirlpoolCore.decodeLELong(data, 8);
        long sn2 = n2 = WhirlpoolCore.decodeLELong(data, 16);
        long sn3 = n3 = WhirlpoolCore.decodeLELong(data, 24);
        long sn4 = n4 = WhirlpoolCore.decodeLELong(data, 32);
        long sn5 = n5 = WhirlpoolCore.decodeLELong(data, 40);
        long sn6 = n6 = WhirlpoolCore.decodeLELong(data, 48);
        long sn7 = n7 = WhirlpoolCore.decodeLELong(data, 56);
        long h0 = this.state0;
        long h1 = this.state1;
        long h2 = this.state2;
        long h3 = this.state3;
        long h4 = this.state4;
        long h5 = this.state5;
        long h6 = this.state6;
        long h7 = this.state7;
        n0 ^= h0;
        n1 ^= h1;
        n2 ^= h2;
        n3 ^= h3;
        n4 ^= h4;
        n5 ^= h5;
        n6 ^= h6;
        n7 ^= h7;
        for (int r = 0; r < 10; ++r) {
            long t0 = this.T0[(int)h0 & 0xFF] ^ this.T1[(int)h7 >> 8 & 0xFF] ^ this.T2[(int)h6 >> 16 & 0xFF] ^ this.T3[(int)h5 >> 24 & 0xFF] ^ this.T4[(int)(h4 >> 32) & 0xFF] ^ this.T5[(int)(h3 >> 40) & 0xFF] ^ this.T6[(int)(h2 >> 48) & 0xFF] ^ this.T7[(int)(h1 >> 56) & 0xFF] ^ this.RC[r];
            long t1 = this.T0[(int)h1 & 0xFF] ^ this.T1[(int)h0 >> 8 & 0xFF] ^ this.T2[(int)h7 >> 16 & 0xFF] ^ this.T3[(int)h6 >> 24 & 0xFF] ^ this.T4[(int)(h5 >> 32) & 0xFF] ^ this.T5[(int)(h4 >> 40) & 0xFF] ^ this.T6[(int)(h3 >> 48) & 0xFF] ^ this.T7[(int)(h2 >> 56) & 0xFF];
            long t2 = this.T0[(int)h2 & 0xFF] ^ this.T1[(int)h1 >> 8 & 0xFF] ^ this.T2[(int)h0 >> 16 & 0xFF] ^ this.T3[(int)h7 >> 24 & 0xFF] ^ this.T4[(int)(h6 >> 32) & 0xFF] ^ this.T5[(int)(h5 >> 40) & 0xFF] ^ this.T6[(int)(h4 >> 48) & 0xFF] ^ this.T7[(int)(h3 >> 56) & 0xFF];
            long t3 = this.T0[(int)h3 & 0xFF] ^ this.T1[(int)h2 >> 8 & 0xFF] ^ this.T2[(int)h1 >> 16 & 0xFF] ^ this.T3[(int)h0 >> 24 & 0xFF] ^ this.T4[(int)(h7 >> 32) & 0xFF] ^ this.T5[(int)(h6 >> 40) & 0xFF] ^ this.T6[(int)(h5 >> 48) & 0xFF] ^ this.T7[(int)(h4 >> 56) & 0xFF];
            long t4 = this.T0[(int)h4 & 0xFF] ^ this.T1[(int)h3 >> 8 & 0xFF] ^ this.T2[(int)h2 >> 16 & 0xFF] ^ this.T3[(int)h1 >> 24 & 0xFF] ^ this.T4[(int)(h0 >> 32) & 0xFF] ^ this.T5[(int)(h7 >> 40) & 0xFF] ^ this.T6[(int)(h6 >> 48) & 0xFF] ^ this.T7[(int)(h5 >> 56) & 0xFF];
            long t5 = this.T0[(int)h5 & 0xFF] ^ this.T1[(int)h4 >> 8 & 0xFF] ^ this.T2[(int)h3 >> 16 & 0xFF] ^ this.T3[(int)h2 >> 24 & 0xFF] ^ this.T4[(int)(h1 >> 32) & 0xFF] ^ this.T5[(int)(h0 >> 40) & 0xFF] ^ this.T6[(int)(h7 >> 48) & 0xFF] ^ this.T7[(int)(h6 >> 56) & 0xFF];
            long t6 = this.T0[(int)h6 & 0xFF] ^ this.T1[(int)h5 >> 8 & 0xFF] ^ this.T2[(int)h4 >> 16 & 0xFF] ^ this.T3[(int)h3 >> 24 & 0xFF] ^ this.T4[(int)(h2 >> 32) & 0xFF] ^ this.T5[(int)(h1 >> 40) & 0xFF] ^ this.T6[(int)(h0 >> 48) & 0xFF] ^ this.T7[(int)(h7 >> 56) & 0xFF];
            long t7 = this.T0[(int)h7 & 0xFF] ^ this.T1[(int)h6 >> 8 & 0xFF] ^ this.T2[(int)h5 >> 16 & 0xFF] ^ this.T3[(int)h4 >> 24 & 0xFF] ^ this.T4[(int)(h3 >> 32) & 0xFF] ^ this.T5[(int)(h2 >> 40) & 0xFF] ^ this.T6[(int)(h1 >> 48) & 0xFF] ^ this.T7[(int)(h0 >> 56) & 0xFF];
            h0 = t0;
            h1 = t1;
            h2 = t2;
            h3 = t3;
            h4 = t4;
            h5 = t5;
            h6 = t6;
            h7 = t7;
            t0 = this.T0[(int)n0 & 0xFF] ^ this.T1[(int)n7 >> 8 & 0xFF] ^ this.T2[(int)n6 >> 16 & 0xFF] ^ this.T3[(int)n5 >> 24 & 0xFF] ^ this.T4[(int)(n4 >> 32) & 0xFF] ^ this.T5[(int)(n3 >> 40) & 0xFF] ^ this.T6[(int)(n2 >> 48) & 0xFF] ^ this.T7[(int)(n1 >> 56) & 0xFF] ^ h0;
            t1 = this.T0[(int)n1 & 0xFF] ^ this.T1[(int)n0 >> 8 & 0xFF] ^ this.T2[(int)n7 >> 16 & 0xFF] ^ this.T3[(int)n6 >> 24 & 0xFF] ^ this.T4[(int)(n5 >> 32) & 0xFF] ^ this.T5[(int)(n4 >> 40) & 0xFF] ^ this.T6[(int)(n3 >> 48) & 0xFF] ^ this.T7[(int)(n2 >> 56) & 0xFF] ^ h1;
            t2 = this.T0[(int)n2 & 0xFF] ^ this.T1[(int)n1 >> 8 & 0xFF] ^ this.T2[(int)n0 >> 16 & 0xFF] ^ this.T3[(int)n7 >> 24 & 0xFF] ^ this.T4[(int)(n6 >> 32) & 0xFF] ^ this.T5[(int)(n5 >> 40) & 0xFF] ^ this.T6[(int)(n4 >> 48) & 0xFF] ^ this.T7[(int)(n3 >> 56) & 0xFF] ^ h2;
            t3 = this.T0[(int)n3 & 0xFF] ^ this.T1[(int)n2 >> 8 & 0xFF] ^ this.T2[(int)n1 >> 16 & 0xFF] ^ this.T3[(int)n0 >> 24 & 0xFF] ^ this.T4[(int)(n7 >> 32) & 0xFF] ^ this.T5[(int)(n6 >> 40) & 0xFF] ^ this.T6[(int)(n5 >> 48) & 0xFF] ^ this.T7[(int)(n4 >> 56) & 0xFF] ^ h3;
            t4 = this.T0[(int)n4 & 0xFF] ^ this.T1[(int)n3 >> 8 & 0xFF] ^ this.T2[(int)n2 >> 16 & 0xFF] ^ this.T3[(int)n1 >> 24 & 0xFF] ^ this.T4[(int)(n0 >> 32) & 0xFF] ^ this.T5[(int)(n7 >> 40) & 0xFF] ^ this.T6[(int)(n6 >> 48) & 0xFF] ^ this.T7[(int)(n5 >> 56) & 0xFF] ^ h4;
            t5 = this.T0[(int)n5 & 0xFF] ^ this.T1[(int)n4 >> 8 & 0xFF] ^ this.T2[(int)n3 >> 16 & 0xFF] ^ this.T3[(int)n2 >> 24 & 0xFF] ^ this.T4[(int)(n1 >> 32) & 0xFF] ^ this.T5[(int)(n0 >> 40) & 0xFF] ^ this.T6[(int)(n7 >> 48) & 0xFF] ^ this.T7[(int)(n6 >> 56) & 0xFF] ^ h5;
            t6 = this.T0[(int)n6 & 0xFF] ^ this.T1[(int)n5 >> 8 & 0xFF] ^ this.T2[(int)n4 >> 16 & 0xFF] ^ this.T3[(int)n3 >> 24 & 0xFF] ^ this.T4[(int)(n2 >> 32) & 0xFF] ^ this.T5[(int)(n1 >> 40) & 0xFF] ^ this.T6[(int)(n0 >> 48) & 0xFF] ^ this.T7[(int)(n7 >> 56) & 0xFF] ^ h6;
            t7 = this.T0[(int)n7 & 0xFF] ^ this.T1[(int)n6 >> 8 & 0xFF] ^ this.T2[(int)n5 >> 16 & 0xFF] ^ this.T3[(int)n4 >> 24 & 0xFF] ^ this.T4[(int)(n3 >> 32) & 0xFF] ^ this.T5[(int)(n2 >> 40) & 0xFF] ^ this.T6[(int)(n1 >> 48) & 0xFF] ^ this.T7[(int)(n0 >> 56) & 0xFF] ^ h7;
            n0 = t0;
            n1 = t1;
            n2 = t2;
            n3 = t3;
            n4 = t4;
            n5 = t5;
            n6 = t6;
            n7 = t7;
        }
        this.state0 ^= n0 ^ sn0;
        this.state1 ^= n1 ^ sn1;
        this.state2 ^= n2 ^ sn2;
        this.state3 ^= n3 ^ sn3;
        this.state4 ^= n4 ^ sn4;
        this.state5 ^= n5 ^ sn5;
        this.state6 ^= n6 ^ sn6;
        this.state7 ^= n7 ^ sn7;
    }
}

