/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash.test;

import fr.cryptohash.Digest;
import java.util.Hashtable;
import java.util.Vector;

public class Speed {
    private static final String[] FUNS;
    private static final String[] FUNS_SHA3;
    private static final Hashtable NAME_TO_CLASSNAMES;
    private static final Vector ORDERED_CLASSNAMES;
    private static final Vector SHA3_CLASSES;
    private static final String[] FUNS_ALIAS;
    private static final Hashtable ALIASES;

    private static void addFun(String name, String cspec, Vector sha3classes) {
        int n = cspec.indexOf(44);
        if (n < 0) {
            NAME_TO_CLASSNAMES.put(name, cspec);
            ORDERED_CLASSNAMES.addElement(cspec);
        } else {
            String base = cspec.substring(0, n);
            NAME_TO_CLASSNAMES.put(name + "224", base + "224");
            ORDERED_CLASSNAMES.addElement(base + "224");
            NAME_TO_CLASSNAMES.put(name + "256", base + "256");
            ORDERED_CLASSNAMES.addElement(base + "256");
            NAME_TO_CLASSNAMES.put(name + "384", base + "384");
            ORDERED_CLASSNAMES.addElement(base + "384");
            NAME_TO_CLASSNAMES.put(name + "512", base + "512");
            ORDERED_CLASSNAMES.addElement(base + "512");
            int len = cspec.length();
            StringBuffer sb = new StringBuffer();
            ++n;
            while (n < len) {
                int p = cspec.indexOf(44, n);
                if (p < 0) {
                    p = len;
                }
                String suffix = cspec.substring(n, p);
                if (sb.length() > 0) {
                    sb.append(',');
                }
                String cname = base + suffix;
                sb.append(cname);
                if (sha3classes != null) {
                    sha3classes.addElement(cname);
                }
                n = p + 1;
            }
            String ac = sb.toString();
            NAME_TO_CLASSNAMES.put(name, ac);
        }
    }

    public static void main(String[] args) throws Exception {
        Hashtable<Object, String> todo = new Hashtable<Object, String>();
        block0: for (int i = 0; i < args.length; ++i) {
            String s = Speed.normalize(args[i]);
            String t = (String)ALIASES.get(s);
            if (t != null) {
                s = t;
            }
            if (s.equals("sha3")) {
                int n = SHA3_CLASSES.size();
                for (int j = 0; j < n; ++j) {
                    todo.put(SHA3_CLASSES.elementAt(j), "");
                }
                continue;
            }
            String cns = (String)NAME_TO_CLASSNAMES.get(s);
            if (cns == null) {
                Speed.usage(args[i]);
            }
            int n = 0;
            while (true) {
                int p;
                String cn = cns.substring(n, (p = cns.indexOf(44, n)) < 0 ? cns.length() : p);
                todo.put(cn, "");
                if (p < 0) continue block0;
                n = p + 1;
            }
        }
        boolean all = todo.size() == 0;
        int n = ORDERED_CLASSNAMES.size();
        for (int i = 0; i < n; ++i) {
            String cn = (String)ORDERED_CLASSNAMES.elementAt(i);
            if (!all && !todo.containsKey(cn)) continue;
            Digest d = (Digest)Class.forName("fr.cryptohash." + cn).newInstance();
            Speed.speed(d.toString(), d);
        }
    }

    private static String normalize(String name) {
        name = name.toLowerCase();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '-' || c == '/') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static void usage(String name) {
        System.err.println("unknown hash function name: '" + name + "'");
        System.exit(1);
    }

    private static void speed(String name, Digest dig) {
        long rate;
        long div;
        long tlen;
        long tt;
        System.out.println("Speed test: " + name);
        byte[] buf = new byte[8192];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = 97;
        }
        int dlen = dig.getDigestLength();
        int j = 0;
        long num = 2L;
        int clen = 16;
        while (true) {
            if (clen == 4096) {
                clen = 8192;
                if (num > 1L) {
                    num >>= 1;
                }
            }
            while (true) {
                tt = Speed.speedUnit(dig, j, buf, clen, num);
                if ((j += dlen) > buf.length - dlen) {
                    j = 0;
                }
                if (tt > 6000L) {
                    if (num <= 1L) break;
                    num >>= 1;
                    continue;
                }
                if (tt >= 2000L) break;
                num += num;
            }
            tlen = (long)clen * num;
            div = 10L * tt;
            rate = (tlen + (div - 1L) / 2L) / div;
            System.out.println("message length = " + Speed.formatLong(clen, 5) + " -> " + Speed.prependSpaces(Long.toString(rate / 100L), 4) + "." + Speed.prependZeroes(Long.toString(rate % 100L), 2) + " MBytes/s");
            if (clen == 8192) break;
            if (num > 4L) {
                num >>= 2;
            }
            clen <<= 2;
        }
        tt = Speed.speedLong(dig, buf, clen, num);
        tlen = (long)clen * num;
        div = 10L * tt;
        rate = (tlen + (div - 1L) / 2L) / div;
        System.out.println("long messages          -> " + Speed.prependSpaces(Long.toString(rate / 100L), 4) + "." + Speed.prependZeroes(Long.toString(rate % 100L), 2) + " MBytes/s");
    }

    private static long speedUnit(Digest dig, int j, byte[] buf, int len, long num) {
        int dlen = dig.getDigestLength();
        long orig = System.currentTimeMillis();
        while (num-- > 0L) {
            dig.update(buf, 0, len);
            dig.digest(buf, j, dlen);
            if ((j += dlen) <= buf.length - dlen) continue;
            j = 0;
        }
        long end = System.currentTimeMillis();
        return end - orig;
    }

    private static long speedLong(Digest dig, byte[] buf, int len, long num) {
        byte[] out = new byte[dig.getDigestLength()];
        long orig = System.currentTimeMillis();
        while (num-- > 0L) {
            dig.update(buf, 0, len);
        }
        long end = System.currentTimeMillis();
        dig.digest(out, 0, out.length);
        return end - orig;
    }

    private static String formatLong(long num, int len) {
        return Speed.prependSpaces(Long.toString(num), len);
    }

    private static String prependSpaces(String s, int len) {
        return Speed.prependChar(s, ' ', len);
    }

    private static String prependZeroes(String s, int len) {
        return Speed.prependChar(s, '0', len);
    }

    private static String prependChar(String s, char c, int len) {
        int slen = s.length();
        if (slen >= len) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        while (len-- > slen) {
            sb.append(c);
        }
        sb.append(s);
        return sb.toString();
    }

    static {
        int i;
        FUNS = new String[]{"haval3", "HAVAL256_3", "haval4", "HAVAL256_4", "haval5", "HAVAL256_5", "md2", "MD2", "md4", "MD4", "md5", "MD5", "panama", "PANAMA", "radiogatun32", "RadioGatun32", "radiogatun64", "RadioGatun64", "ripemd", "RIPEMD", "ripemd128", "RIPEMD128", "ripemd160", "RIPEMD160", "sha0", "SHA0", "sha1", "SHA1", "sha", "SHA,256,512", "tiger", "Tiger", "whirlpool", "Whirlpool"};
        FUNS_SHA3 = new String[]{"blake", "BLAKE,256,512", "bmw", "BMW,256,512", "cubehash", "CubeHash,512", "echo", "ECHO,256,512", "fugue", "Fugue,256,384,512", "groestl", "Groestl,256,512", "hamsi", "Hamsi,256,512", "jh", "JH,512", "keccak", "Keccak,224,256,384,512", "luffa", "Luffa,256,384,512", "shabal", "Shabal,512", "shavite", "SHAvite,256,512", "simd", "SIMD,256,512", "skein", "Skein,256,512"};
        NAME_TO_CLASSNAMES = new Hashtable();
        ORDERED_CLASSNAMES = new Vector();
        SHA3_CLASSES = new Vector();
        for (i = 0; i < FUNS.length; i += 2) {
            Speed.addFun(FUNS[i], FUNS[i + 1], null);
        }
        for (i = 0; i < FUNS_SHA3.length; i += 2) {
            Speed.addFun(FUNS_SHA3[i], FUNS_SHA3[i + 1], SHA3_CLASSES);
        }
        FUNS_ALIAS = new String[]{"rmd", "ripemd", "rmd128", "ripemd128", "rmd160", "ripemd160", "sha2", "sha", "shavite3", "shavite"};
        ALIASES = new Hashtable();
        for (i = 0; i < FUNS_ALIAS.length; i += 2) {
            ALIASES.put(FUNS_ALIAS[i], FUNS_ALIAS[i + 1]);
        }
    }
}

