/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash.test;

import fr.cryptohash.BLAKE224;
import fr.cryptohash.BLAKE256;
import fr.cryptohash.BLAKE384;
import fr.cryptohash.BLAKE512;
import fr.cryptohash.BMW224;
import fr.cryptohash.BMW256;
import fr.cryptohash.BMW384;
import fr.cryptohash.BMW512;
import fr.cryptohash.CubeHash224;
import fr.cryptohash.CubeHash256;
import fr.cryptohash.CubeHash384;
import fr.cryptohash.CubeHash512;
import fr.cryptohash.Digest;
import fr.cryptohash.ECHO224;
import fr.cryptohash.ECHO256;
import fr.cryptohash.ECHO384;
import fr.cryptohash.ECHO512;
import fr.cryptohash.Fugue224;
import fr.cryptohash.Fugue256;
import fr.cryptohash.Fugue384;
import fr.cryptohash.Fugue512;
import fr.cryptohash.Groestl224;
import fr.cryptohash.Groestl256;
import fr.cryptohash.Groestl384;
import fr.cryptohash.Groestl512;
import fr.cryptohash.HAVAL128_3;
import fr.cryptohash.HAVAL128_4;
import fr.cryptohash.HAVAL128_5;
import fr.cryptohash.HAVAL160_3;
import fr.cryptohash.HAVAL160_4;
import fr.cryptohash.HAVAL160_5;
import fr.cryptohash.HAVAL192_3;
import fr.cryptohash.HAVAL192_4;
import fr.cryptohash.HAVAL192_5;
import fr.cryptohash.HAVAL224_3;
import fr.cryptohash.HAVAL224_4;
import fr.cryptohash.HAVAL224_5;
import fr.cryptohash.HAVAL256_3;
import fr.cryptohash.HAVAL256_4;
import fr.cryptohash.HAVAL256_5;
import fr.cryptohash.HMAC;
import fr.cryptohash.Hamsi224;
import fr.cryptohash.Hamsi256;
import fr.cryptohash.Hamsi384;
import fr.cryptohash.Hamsi512;
import fr.cryptohash.JH224;
import fr.cryptohash.JH256;
import fr.cryptohash.JH384;
import fr.cryptohash.JH512;
import fr.cryptohash.Keccak224;
import fr.cryptohash.Keccak256;
import fr.cryptohash.Keccak384;
import fr.cryptohash.Keccak512;
import fr.cryptohash.Luffa224;
import fr.cryptohash.Luffa256;
import fr.cryptohash.Luffa384;
import fr.cryptohash.Luffa512;
import fr.cryptohash.MD2;
import fr.cryptohash.MD4;
import fr.cryptohash.MD5;
import fr.cryptohash.PANAMA;
import fr.cryptohash.RIPEMD;
import fr.cryptohash.RIPEMD128;
import fr.cryptohash.RIPEMD160;
import fr.cryptohash.RadioGatun32;
import fr.cryptohash.RadioGatun64;
import fr.cryptohash.SHA0;
import fr.cryptohash.SHA1;
import fr.cryptohash.SHA224;
import fr.cryptohash.SHA256;
import fr.cryptohash.SHA384;
import fr.cryptohash.SHA512;
import fr.cryptohash.SHAvite224;
import fr.cryptohash.SHAvite256;
import fr.cryptohash.SHAvite384;
import fr.cryptohash.SHAvite512;
import fr.cryptohash.SIMD224;
import fr.cryptohash.SIMD256;
import fr.cryptohash.SIMD384;
import fr.cryptohash.SIMD512;
import fr.cryptohash.Shabal192;
import fr.cryptohash.Shabal224;
import fr.cryptohash.Shabal256;
import fr.cryptohash.Shabal384;
import fr.cryptohash.Shabal512;
import fr.cryptohash.Skein224;
import fr.cryptohash.Skein256;
import fr.cryptohash.Skein384;
import fr.cryptohash.Skein512;
import fr.cryptohash.Tiger;
import fr.cryptohash.Tiger2;
import fr.cryptohash.Whirlpool;
import fr.cryptohash.Whirlpool0;
import fr.cryptohash.Whirlpool1;

public class TestDigest {
    public static void main(String[] args) {
        TestDigest.testMD2();
        TestDigest.testMD4();
        TestDigest.testMD5();
        TestDigest.testSHA0();
        TestDigest.testSHA1();
        TestDigest.testSHA224();
        TestDigest.testSHA256();
        TestDigest.testSHA384();
        TestDigest.testSHA512();
        TestDigest.testRIPEMD();
        TestDigest.testRIPEMD128();
        TestDigest.testRIPEMD160();
        TestDigest.testTiger();
        TestDigest.testTiger2();
        TestDigest.testPANAMA();
        TestDigest.testHAVAL();
        TestDigest.testWhirlpool();
        TestDigest.testRadioGatun();
        TestDigest.testBLAKE224();
        TestDigest.testBLAKE256();
        TestDigest.testBLAKE384();
        TestDigest.testBLAKE512();
        TestDigest.testBMW224();
        TestDigest.testBMW256();
        TestDigest.testBMW384();
        TestDigest.testBMW512();
        TestDigest.testCubeHash224();
        TestDigest.testCubeHash256();
        TestDigest.testCubeHash384();
        TestDigest.testCubeHash512();
        TestDigest.testECHO224();
        TestDigest.testECHO256();
        TestDigest.testECHO384();
        TestDigest.testECHO512();
        TestDigest.testFugue224();
        TestDigest.testFugue256();
        TestDigest.testFugue384();
        TestDigest.testFugue512();
        TestDigest.testGroestl224();
        TestDigest.testGroestl256();
        TestDigest.testGroestl384();
        TestDigest.testGroestl512();
        TestDigest.testHamsi224();
        TestDigest.testHamsi256();
        TestDigest.testHamsi384();
        TestDigest.testHamsi512();
        TestDigest.testJH224();
        TestDigest.testJH256();
        TestDigest.testJH384();
        TestDigest.testJH512();
        TestDigest.testKeccak224();
        TestDigest.testKeccak256();
        TestDigest.testKeccak384();
        TestDigest.testKeccak512();
        TestDigest.testLuffa224();
        TestDigest.testLuffa256();
        TestDigest.testLuffa384();
        TestDigest.testLuffa512();
        TestDigest.testShabal192();
        TestDigest.testShabal224();
        TestDigest.testShabal256();
        TestDigest.testShabal384();
        TestDigest.testShabal512();
        TestDigest.testSHAvite224();
        TestDigest.testSHAvite256();
        TestDigest.testSHAvite384();
        TestDigest.testSHAvite512();
        TestDigest.testSIMD224();
        TestDigest.testSIMD256();
        TestDigest.testSIMD384();
        TestDigest.testSIMD512();
        TestDigest.testSkein224();
        TestDigest.testSkein256();
        TestDigest.testSkein384();
        TestDigest.testSkein512();
        TestDigest.testHMAC();
    }

    private static final void fail(String message) {
        throw new RuntimeException("test failed: " + message);
    }

    private static final byte[] strtobin(String str) {
        int blen = str.length() / 2;
        byte[] buf = new byte[blen];
        for (int i = 0; i < blen; ++i) {
            String bs = str.substring(i * 2, i * 2 + 2);
            buf[i] = (byte)Integer.parseInt(bs, 16);
        }
        return buf;
    }

    private static final byte[] encodeLatin1(String str) {
        int blen = str.length();
        byte[] buf = new byte[blen];
        for (int i = 0; i < blen; ++i) {
            buf[i] = (byte)str.charAt(i);
        }
        return buf;
    }

    private static final boolean equals(byte[] b1, byte[] b2) {
        if (b1 == b2) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private static final void assertTrue(boolean expr) {
        if (!expr) {
            TestDigest.fail("assertion failed");
        }
    }

    private static final void assertEquals(byte[] b1, byte[] b2) {
        if (!TestDigest.equals(b1, b2)) {
            TestDigest.fail("byte streams are not equal");
        }
    }

    private static final void assertNotEquals(byte[] b1, byte[] b2) {
        if (TestDigest.equals(b1, b2)) {
            TestDigest.fail("byte streams are equal");
        }
    }

    private static final void reportSuccess(String name) {
        System.out.println("===== test " + name + " passed");
    }

    private static void testKat(Digest dig, byte[] buf, byte[] exp) {
        byte[] out = dig.digest(buf);
        TestDigest.assertEquals(out, exp);
        for (int i = 0; i < buf.length; ++i) {
            dig.update(buf[i]);
        }
        TestDigest.assertEquals(dig.digest(), exp);
        int blen = buf.length;
        dig.update(buf, 0, blen / 2);
        Digest dig2 = dig.copy();
        dig.update(buf, blen / 2, blen - blen / 2);
        TestDigest.assertEquals(dig.digest(), exp);
        dig2.update(buf, blen / 2, blen - blen / 2);
        TestDigest.assertEquals(dig2.digest(), exp);
    }

    private static void testKat(Digest dig, String data, String ref) {
        TestDigest.testKat(dig, TestDigest.encodeLatin1(data), TestDigest.strtobin(ref));
    }

    private static void testKatHex(Digest dig, String data, String ref) {
        TestDigest.testKat(dig, TestDigest.strtobin(data), TestDigest.strtobin(ref));
    }

    private static void testKatMillionA(Digest dig, String ref) {
        int i;
        byte[] buf = new byte[1000];
        for (i = 0; i < 1000; ++i) {
            buf[i] = 97;
        }
        for (i = 0; i < 1000; ++i) {
            dig.update(buf);
        }
        TestDigest.assertEquals(dig.digest(), TestDigest.strtobin(ref));
    }

    private static void testCollision(Digest dig, String s1, String s2) {
        byte[] msg1 = TestDigest.strtobin(s1);
        byte[] msg2 = TestDigest.strtobin(s2);
        TestDigest.assertNotEquals(msg1, msg2);
        TestDigest.assertEquals(dig.digest(msg1), dig.digest(msg2));
    }

    private static void testMD2() {
        MD2 dig = new MD2();
        TestDigest.testKat((Digest)dig, "", "8350e5a3e24c153df2275c9f80692773");
        TestDigest.testKat((Digest)dig, "a", "32ec01ec4a6dac72c0ab96fb34c0b5d1");
        TestDigest.testKat((Digest)dig, "abc", "da853b0d3f88d99b30283a69e6ded6bb");
        TestDigest.testKat((Digest)dig, "message digest", "ab4f496bfb2a530b219ff33031fe06b0");
        TestDigest.testKat((Digest)dig, "abcdefghijklmnopqrstuvwxyz", "4e8ddff3650292ab5a4108c3aa47940b");
        TestDigest.testKat((Digest)dig, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "da33def2a42df13975352846c30338cd");
        TestDigest.testKat((Digest)dig, "12345678901234567890123456789012345678901234567890123456789012345678901234567890", "d5976f79d83d3a0dc9806c3c66f3efd8");
        TestDigest.testKatMillionA(dig, "8c0a09ff1216ecaf95c8130953c62efd");
        TestDigest.reportSuccess("MD2");
    }

    private static void testMD4() {
        MD4 dig = new MD4();
        TestDigest.testKat((Digest)dig, "", "31d6cfe0d16ae931b73c59d7e0c089c0");
        TestDigest.testKat((Digest)dig, "a", "bde52cb31de33e46245e05fbdbd6fb24");
        TestDigest.testKat((Digest)dig, "abc", "a448017aaf21d8525fc10ae87aa6729d");
        TestDigest.testKat((Digest)dig, "message digest", "d9130a8164549fe818874806e1c7014b");
        TestDigest.testKat((Digest)dig, "abcdefghijklmnopqrstuvwxyz", "d79e1c308aa5bbcdeea8ed63df412da9");
        TestDigest.testKat((Digest)dig, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "043f8582f241db351ce627e153e7f0e4");
        TestDigest.testKat((Digest)dig, "12345678901234567890123456789012345678901234567890123456789012345678901234567890", "e33b4ddc9c38f2199c3e7b164fcc0536");
        TestDigest.testKatMillionA(dig, "bbce80cc6bb65e5c6745e30d4eeca9a4");
        TestDigest.testCollision(dig, "839c7a4d7a92cb5678a5d5b9eea5a7573c8a74deb366c3dc20a083b69f5d2a3bb3719dc69891e9f95e809fd7e8b23ba6318edd45e51fe39708bf9427e9c3e8b9", "839c7a4d7a92cbd678a5d529eea5a7573c8a74deb366c3dc20a083b69f5d2a3bb3719dc69891e9f95e809fd7e8b23ba6318edc45e51fe39708bf9427e9c3e8b9");
        TestDigest.testCollision(dig, "839c7a4d7a92cb5678a5d5b9eea5a7573c8a74deb366c3dc20a083b69f5d2a3bb3719dc69891e9f95e809fd7e8b23ba6318edd45e51fe39740c213f769cfb8a7", "839c7a4d7a92cbd678a5d529eea5a7573c8a74deb366c3dc20a083b69f5d2a3bb3719dc69891e9f95e809fd7e8b23ba6318edc45e51fe39740c213f769cfb8a7");
        TestDigest.reportSuccess("MD4");
    }

    private static void testMD5() {
        MD5 dig = new MD5();
        TestDigest.testKat((Digest)dig, "", "d41d8cd98f00b204e9800998ecf8427e");
        TestDigest.testKat((Digest)dig, "a", "0cc175b9c0f1b6a831c399e269772661");
        TestDigest.testKat((Digest)dig, "abc", "900150983cd24fb0d6963f7d28e17f72");
        TestDigest.testKat((Digest)dig, "message digest", "f96b697d7cb7938d525a2f31aaf161d0");
        TestDigest.testKat((Digest)dig, "abcdefghijklmnopqrstuvwxyz", "c3fcd3d76192e4007dfb496cca67e13b");
        TestDigest.testKat((Digest)dig, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "d174ab98d277d9f5a5611c2c9f419d9f");
        TestDigest.testKat((Digest)dig, "12345678901234567890123456789012345678901234567890123456789012345678901234567890", "57edf4a22be3c955ac49da2e2107b67a");
        TestDigest.testKatMillionA(dig, "7707d6ae4e027c70eea2a935c2296f21");
        TestDigest.testCollision(dig, "d131dd02c5e6eec4693d9a0698aff95c2fcab58712467eab4004583eb8fb7f8955ad340609f4b30283e488832571415a085125e8f7cdc99fd91dbdf280373c5b960b1dd1dc417b9ce4d897f45a6555d535739ac7f0ebfd0c3029f166d109b18f75277f7930d55ceb22e8adba79cc155ced74cbdd5fc5d36db19b0ad835cca7e3", "d131dd02c5e6eec4693d9a0698aff95c2fcab50712467eab4004583eb8fb7f8955ad340609f4b30283e4888325f1415a085125e8f7cdc99fd91dbd7280373c5b960b1dd1dc417b9ce4d897f45a6555d535739a47f0ebfd0c3029f166d109b18f75277f7930d55ceb22e8adba794c155ced74cbdd5fc5d36db19b0a5835cca7e3");
        TestDigest.testCollision(dig, "d131dd02c5e6eec4693d9a0698aff95c2fcab58712467eab4004583eb8fb7f8955ad340609f4b30283e488832571415a085125e8f7cdc99fd91dbdf280373c5bd8823e3156348f5bae6dacd436c919c6dd53e2b487da03fd02396306d248cda0e99f33420f577ee8ce54b67080a80d1ec69821bcb6a8839396f9652b6ff72a70", "d131dd02c5e6eec4693d9a0698aff95c2fcab50712467eab4004583eb8fb7f8955ad340609f4b30283e4888325f1415a085125e8f7cdc99fd91dbd7280373c5bd8823e3156348f5bae6dacd436c919c6dd53e23487da03fd02396306d248cda0e99f33420f577ee8ce54b67080280d1ec69821bcb6a8839396f965ab6ff72a70");
        TestDigest.reportSuccess("MD5");
    }

    private static void testSHA0() {
        SHA0 dig = new SHA0();
        TestDigest.testKat((Digest)dig, "abc", "0164b8a914cd2a5e74c4f7ff082c4d97f1edf880");
        TestDigest.testKat((Digest)dig, "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", "d2516ee1acfa5baf33dfc1c471e438449ef134c8");
        TestDigest.testKatMillionA(dig, "3232affa48628a26653b5aaa44541fd90d690603");
        TestDigest.testCollision(dig, "a766a602b65cffe773bcf25826b322b3d01b1a972684ef533e3b4b7f53fe376224c08e47e959b2bc3b519880b9286568247d110f70f5c5e2b4590ca3f55f52feeffd4c8fe68de835329e603cc51e7f02545410d1671d108df5a4000dcf20a4394949d72cd14fbb0345cf3a295dcda89f998f87552c9a58b1bdc384835e477185f96e68bebb0025d2d2b69edf21724198f688b41deb9b4913fbe696b5457ab39921e1d7591f89de8457e8613c6c9e3b242879d4d8783b2d9ca9935ea526a729c06edfc50137e69330be976012cc5dfe1c14c4c68bd1db3ecb24438a59a09b5db435563e0d8bdf572f77b53065cef31f32dc9dbaa04146261e9994bd5cd0758e3d", "a766a602b65cffe773bcf25826b322b1d01b1ad72684ef51be3b4b7fd3fe3762a4c08e45e959b2fc3b51988039286528a47d110d70f5c5e034590ce3755f52fc6ffd4c8d668de875329e603e451e7f02d45410d1e71d108df5a4000dcf20a4394949d72cd14fbb0145cf3a695dcda89d198f8755ac9a58b13dc384815e4771c5796e68febb0025d052b69edda17241d87688b41f6b9b49117be696f5c57ab399a1e1d7199f89de8657e8613cec9e3b26a879d498783b2d9e29935ea7a6a729806edfc50337e693303e9760104c5dfe5c14c4c68951db3ecba4438a59209b5db435563e0d8bdf572f77b53065cef31f30dc9dbae04146261c1994bd5c50758e3d");
        TestDigest.reportSuccess("SHA-0");
    }

    private static void testSHA1() {
        SHA1 dig = new SHA1();
        TestDigest.testKat((Digest)dig, "abc", "a9993e364706816aba3e25717850c26c9cd0d89d");
        TestDigest.testKat((Digest)dig, "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", "84983e441c3bd26ebaae4aa1f95129e5e54670f1");
        TestDigest.testKatMillionA(dig, "34aa973cd4c4daa4f61eeb2bdbad27316534016f");
        TestDigest.reportSuccess("SHA-1");
    }

    private static void testSHA224() {
        SHA224 dig = new SHA224();
        TestDigest.testKat((Digest)dig, "abc", "23097d223405d8228642a477bda255b32aadbce4bda0b3f7e36c9da7");
        TestDigest.testKat((Digest)dig, "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", "75388b16512776cc5dba5da1fd890150b0c6455cb4f58b1952522525");
        TestDigest.testKatMillionA(dig, "20794655980c91d8bbb4c1ea97618a4bf03f42581948b2ee4ee7ad67");
        TestDigest.reportSuccess("SHA-224");
    }

    private static void testSHA256() {
        SHA256 dig = new SHA256();
        TestDigest.testKat((Digest)dig, "abc", "ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad");
        TestDigest.testKat((Digest)dig, "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", "248d6a61d20638b8e5c026930c3e6039a33ce45964ff2167f6ecedd419db06c1");
        TestDigest.testKatMillionA(dig, "cdc76e5c9914fb9281a1c7e284d73e67f1809a48a497200e046d39ccc7112cd0");
        TestDigest.reportSuccess("SHA-256");
    }

    private static void testSHA384() {
        SHA384 dig = new SHA384();
        TestDigest.testKat((Digest)dig, "abc", "cb00753f45a35e8bb5a03d699ac65007272c32ab0eded1631a8b605a43ff5bed8086072ba1e7cc2358baeca134c825a7");
        TestDigest.testKat((Digest)dig, "abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu", "09330c33f71147e83d192fc782cd1b4753111b173b3b05d22fa08086e3b0f712fcc7c71a557e2db966c3e9fa91746039");
        TestDigest.testKatMillionA(dig, "9d0e1809716474cb086e834e310a4a1ced149e9c00f248527972cec5704c2a5b07b8b3dc38ecc4ebae97ddd87f3d8985");
        TestDigest.reportSuccess("SHA-384");
    }

    private static void testSHA512() {
        SHA512 dig = new SHA512();
        TestDigest.testKat((Digest)dig, "abc", "ddaf35a193617abacc417349ae20413112e6fa4e89a97ea20a9eeee64b55d39a2192992a274fc1a836ba3c23a3feebbd454d4423643ce80e2a9ac94fa54ca49f");
        TestDigest.testKat((Digest)dig, "abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu", "8e959b75dae313da8cf4f72814fc143f8f7779c6eb9f7fa17299aeadb6889018501d289e4900f7e4331b99dec4b5433ac7d329eeb6dd26545e96e55b874be909");
        TestDigest.testKatMillionA(dig, "e718483d0ce769644e2e42c7bc15b4638e1f98b13b2044285632a803afa973ebde0ff244877ea60a4cb0432ce577c31beb009c5c2c49aa2e4eadb217ad8cc09b");
        TestDigest.reportSuccess("SHA-512");
    }

    private static void testRIPEMD() {
        RIPEMD dig = new RIPEMD();
        TestDigest.testKat((Digest)dig, "", "9f73aa9b372a9dacfb86a6108852e2d9");
        TestDigest.testKat((Digest)dig, "a", "486f74f790bc95ef7963cd2382b4bbc9");
        TestDigest.testKat((Digest)dig, "abc", "3f14bad4c2f9b0ea805e5485d3d6882d");
        TestDigest.testKat((Digest)dig, "message digest", "5f5c7ebe1abbb3c7036482942d5f9d49");
        TestDigest.testKat((Digest)dig, "abcdefghijklmnopqrstuvwxyz", "ff6e1547494251a1cca6f005a6eaa2b4");
        TestDigest.testKat((Digest)dig, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "ff418a5aed3763d8f2ddf88a29e62486");
        TestDigest.testKat((Digest)dig, "12345678901234567890123456789012345678901234567890123456789012345678901234567890", "dfd6b45f60fe79bbbde87c6bfc6580a5");
        TestDigest.testCollision(dig, "8eaf9f5779f5ec09ba6a4a5711354178a410b4a29f6c2fad2c20560b1179754de7aade0bf291bc787d6dbc47b1d1bd9a15205da4ff047181a8584726a54e0661", "8eaf9f5779f5ec09ba6a4a5711355178a410b4a29f6c2fad2c20560b1179754de7aade0bf291bc787d6dc0c7b1d1bd9a15205da4ff047181a8584726a54e06e1");
        TestDigest.testCollision(dig, "8eaf9f5779f5ec09ba6a4a5711354178a410b4a29f6c2fad2c20560b1179754de7aade0bf291bc787d6dbc47b1d1bd9a15205da4ff04a5a0a8588db1b6660ce7", "8eaf9f5779f5ec09ba6a4a5711355178a410b4a29f6c2fad2c20560b1179754de7aade0bf291bc787d6dc0c7b1d1bd9a15205da4ff04a5a0a8588db1b6660c67");
        TestDigest.reportSuccess("RIPEMD");
    }

    private static void testRIPEMD128() {
        RIPEMD128 dig = new RIPEMD128();
        TestDigest.testKat((Digest)dig, "", "cdf26213a150dc3ecb610f18f6b38b46");
        TestDigest.testKat((Digest)dig, "a", "86be7afa339d0fc7cfc785e72f578d33");
        TestDigest.testKat((Digest)dig, "abc", "c14a12199c66e4ba84636b0f69144c77");
        TestDigest.testKat((Digest)dig, "message digest", "9e327b3d6e523062afc1132d7df9d1b8");
        TestDigest.testKat((Digest)dig, "abcdefghijklmnopqrstuvwxyz", "fd2aa607f71dc8f510714922b371834e");
        TestDigest.testKat((Digest)dig, "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", "a1aa0689d0fafa2ddc22e88b49133a06");
        TestDigest.testKat((Digest)dig, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "d1e959eb179c911faea4624c60c5c702");
        TestDigest.testKat((Digest)dig, "12345678901234567890123456789012345678901234567890123456789012345678901234567890", "3f45ef194732c2dbb2c4a2c769795fa3");
        TestDigest.testKatMillionA(dig, "4a7f5723f954eba1216c9d8f6320431f");
        TestDigest.reportSuccess("RIPEMD-128");
    }

    private static void testRIPEMD160() {
        RIPEMD160 dig = new RIPEMD160();
        TestDigest.testKat((Digest)dig, "", "9c1185a5c5e9fc54612808977ee8f548b2258d31");
        TestDigest.testKat((Digest)dig, "a", "0bdc9d2d256b3ee9daae347be6f4dc835a467ffe");
        TestDigest.testKat((Digest)dig, "abc", "8eb208f7e05d987a9b044a8e98c6b087f15a0bfc");
        TestDigest.testKat((Digest)dig, "message digest", "5d0689ef49d2fae572b881b123a85ffa21595f36");
        TestDigest.testKat((Digest)dig, "abcdefghijklmnopqrstuvwxyz", "f71c27109c692c1b56bbdceb5b9d2865b3708dbc");
        TestDigest.testKat((Digest)dig, "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", "12a053384a9c0c88e405a06c27dcf49ada62eb2b");
        TestDigest.testKat((Digest)dig, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "b0e20b6e3116640286ed3a87a5713079b21f5189");
        TestDigest.testKat((Digest)dig, "12345678901234567890123456789012345678901234567890123456789012345678901234567890", "9b752e45573d4b39f4dbd3323cab82bf63326bfb");
        TestDigest.testKatMillionA(dig, "52783243c1697bdbe16d37f97f68f08325dc1528");
        TestDigest.reportSuccess("RIPEMD-160");
    }

    private static void testTiger() {
        Tiger dig = new Tiger();
        TestDigest.testKat((Digest)dig, "", "3293AC630C13F0245F92BBB1766E16167A4E58492DDE73F3");
        TestDigest.testKat((Digest)dig, "a", "77BEFBEF2E7EF8AB2EC8F93BF587A7FC613E247F5F247809");
        TestDigest.testKat((Digest)dig, "abc", "2AAB1484E8C158F2BFB8C5FF41B57A525129131C957B5F93");
        TestDigest.testKat((Digest)dig, "message digest", "D981F8CB78201A950DCF3048751E441C517FCA1AA55A29F6");
        TestDigest.testKat((Digest)dig, "abcdefghijklmnopqrstuvwxyz", "1714A472EEE57D30040412BFCC55032A0B11602FF37BEEE9");
        TestDigest.testKat((Digest)dig, "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", "0F7BF9A19B9C58F2B7610DF7E84F0AC3A71C631E7B53F78E");
        TestDigest.testKat((Digest)dig, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "8DCEA680A17583EE502BA38A3C368651890FFBCCDC49A8CC");
        TestDigest.testKat((Digest)dig, "12345678901234567890123456789012345678901234567890123456789012345678901234567890", "1C14795529FD9F207A958F84C52F11E887FA0CABDFD91BFD");
        TestDigest.testKatMillionA(dig, "6DB0E2729CBEAD93D715C6A7D36302E9B3CEE0D2BC314B41");
        TestDigest.reportSuccess("Tiger");
    }

    private static void testTiger2() {
        Tiger2 dig = new Tiger2();
        TestDigest.testKat((Digest)dig, "", "4441BE75F6018773C206C22745374B924AA8313FEF919F41");
        TestDigest.testKat((Digest)dig, "a", "67E6AE8E9E968999F70A23E72AEAA9251CBC7C78A7916636");
        TestDigest.testKat((Digest)dig, "abc", "F68D7BC5AF4B43A06E048D7829560D4A9415658BB0B1F3BF");
        TestDigest.testKat((Digest)dig, "message digest", "E29419A1B5FA259DE8005E7DE75078EA81A542EF2552462D");
        TestDigest.testKat((Digest)dig, "abcdefghijklmnopqrstuvwxyz", "F5B6B6A78C405C8547E91CD8624CB8BE83FC804A474488FD");
        TestDigest.testKat((Digest)dig, "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", "A6737F3997E8FBB63D20D2DF88F86376B5FE2D5CE36646A9");
        TestDigest.testKat((Digest)dig, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "EA9AB6228CEE7B51B77544FCA6066C8CBB5BBAE6319505CD");
        TestDigest.testKat((Digest)dig, "12345678901234567890123456789012345678901234567890123456789012345678901234567890", "D85278115329EBAA0EEC85ECDC5396FDA8AA3A5820942FFF");
        TestDigest.testKatMillionA(dig, "E068281F060F551628CC5715B9D0226796914D45F7717CF4");
        TestDigest.reportSuccess("Tiger2");
    }

    private static void testPANAMA() {
        PANAMA dig = new PANAMA();
        TestDigest.testKat((Digest)dig, "", "aa0cc954d757d7ac7779ca3342334ca471abd47d5952ac91ed837ecd5b16922b");
        TestDigest.testKat((Digest)dig, "T", "049d698307d8541f22870dfa0a551099d3d02bc6d57c610a06a4585ed8d35ff8");
        TestDigest.testKat((Digest)dig, "The quick brown fox jumps over the lazy dog", "5f5ca355b90ac622b0aa7e654ef5f27e9e75111415b48b8afe3add1c6b89cba1");
        TestDigest.testKatMillionA(dig, "af9c66fb6058e2232a5dfba063ee14b0f86f0e334e165812559435464dd9bb60");
        TestDigest.reportSuccess("PANAMA");
    }

    private static void testHAVAL() {
        HAVAL128_3 dig128_3 = new HAVAL128_3();
        HAVAL128_4 dig128_4 = new HAVAL128_4();
        HAVAL128_5 dig128_5 = new HAVAL128_5();
        HAVAL160_3 dig160_3 = new HAVAL160_3();
        HAVAL160_4 dig160_4 = new HAVAL160_4();
        HAVAL160_5 dig160_5 = new HAVAL160_5();
        HAVAL192_3 dig192_3 = new HAVAL192_3();
        HAVAL192_4 dig192_4 = new HAVAL192_4();
        HAVAL192_5 dig192_5 = new HAVAL192_5();
        HAVAL224_3 dig224_3 = new HAVAL224_3();
        HAVAL224_4 dig224_4 = new HAVAL224_4();
        HAVAL224_5 dig224_5 = new HAVAL224_5();
        HAVAL256_3 dig256_3 = new HAVAL256_3();
        HAVAL256_4 dig256_4 = new HAVAL256_4();
        HAVAL256_5 dig256_5 = new HAVAL256_5();
        TestDigest.testKat((Digest)dig128_3, "", "C68F39913F901F3DDF44C707357A7D70");
        TestDigest.testKat((Digest)dig128_3, "a", "0CD40739683E15F01CA5DBCEEF4059F1");
        TestDigest.testKat((Digest)dig128_3, "HAVAL", "DC1F3C893D17CC4EDD9AE94AF76A0AF0");
        TestDigest.testKat((Digest)dig128_3, "0123456789", "D4BE2164EF387D9F4D46EA8EFB180CF5");
        TestDigest.testKat((Digest)dig128_3, "abcdefghijklmnopqrstuvwxyz", "DC502247FB3EB8376109EDA32D361D82");
        TestDigest.testKat((Digest)dig128_3, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "DE5EB3F7D9EB08FAE7A07D68E3047EC6");
        TestDigest.testKat((Digest)dig160_3, "", "D353C3AE22A25401D257643836D7231A9A95F953");
        TestDigest.testKat((Digest)dig160_3, "a", "4DA08F514A7275DBC4CECE4A347385983983A830");
        TestDigest.testKat((Digest)dig160_3, "HAVAL", "8822BC6F3E694E73798920C77CE3245120DD8214");
        TestDigest.testKat((Digest)dig160_3, "0123456789", "BE68981EB3EBD3F6748B081EE5D4E1818F9BA86C");
        TestDigest.testKat((Digest)dig160_3, "abcdefghijklmnopqrstuvwxyz", "EBA9FA6050F24C07C29D1834A60900EA4E32E61B");
        TestDigest.testKat((Digest)dig160_3, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "97DC988D97CAAE757BE7523C4E8D4EA63007A4B9");
        TestDigest.testKat((Digest)dig192_3, "", "E9C48D7903EAF2A91C5B350151EFCB175C0FC82DE2289A4E");
        TestDigest.testKat((Digest)dig192_3, "a", "B359C8835647F5697472431C142731FF6E2CDDCACC4F6E08");
        TestDigest.testKat((Digest)dig192_3, "HAVAL", "8DA26DDAB4317B392B22B638998FE65B0FBE4610D345CF89");
        TestDigest.testKat((Digest)dig192_3, "0123456789", "DE561F6D818A760D65BDD2823ABE79CDD97E6CFA4021B0C8");
        TestDigest.testKat((Digest)dig192_3, "abcdefghijklmnopqrstuvwxyz", "A25E1456E6863E7D7C74017BB3E098E086AD4BE0580D7056");
        TestDigest.testKat((Digest)dig192_3, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "DEF6653091E3005B43A61681014A066CD189009D00856EE7");
        TestDigest.testKat((Digest)dig224_3, "", "C5AAE9D47BFFCAAF84A8C6E7CCACD60A0DD1932BE7B1A192B9214B6D");
        TestDigest.testKat((Digest)dig224_3, "a", "731814BA5605C59B673E4CAAE4AD28EEB515B3ABC2B198336794E17B");
        TestDigest.testKat((Digest)dig224_3, "HAVAL", "AD33E0596C575D7175E9F72361CA767C89E46E2609D88E719EE69AAA");
        TestDigest.testKat((Digest)dig224_3, "0123456789", "EE345C97A58190BF0F38BF7CE890231AA5FCF9862BF8E7BEBBF76789");
        TestDigest.testKat((Digest)dig224_3, "abcdefghijklmnopqrstuvwxyz", "06AE38EBC43DB58BD6B1D477C7B4E01B85A1E7B19B0BD088E33B58D1");
        TestDigest.testKat((Digest)dig224_3, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "939F7ED7801C1CE4B32BC74A4056EEE6081C999ED246907ADBA880A7");
        TestDigest.testKat((Digest)dig256_3, "", "4F6938531F0BC8991F62DA7BBD6F7DE3FAD44562B8C6F4EBF146D5B4E46F7C17");
        TestDigest.testKat((Digest)dig256_3, "a", "47C838FBB4081D9525A0FF9B1E2C05A98F625714E72DB289010374E27DB021D8");
        TestDigest.testKat((Digest)dig256_3, "HAVAL", "91850C6487C9829E791FC5B58E98E372F3063256BB7D313A93F1F83B426AEDCC");
        TestDigest.testKat((Digest)dig256_3, "0123456789", "63238D99C02BE18C3C5DB7CCE8432F51329012C228CCC17EF048A5D0FD22D4AE");
        TestDigest.testKat((Digest)dig256_3, "abcdefghijklmnopqrstuvwxyz", "72FAD4BDE1DA8C8332FB60561A780E7F504F21547B98686824FC33FC796AFA76");
        TestDigest.testKat((Digest)dig256_3, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "899397D96489281E9E76D5E65ABAB751F312E06C06C07C9C1D42ABD31BB6A404");
        TestDigest.testKat((Digest)dig128_4, "", "EE6BBF4D6A46A679B3A856C88538BB98");
        TestDigest.testKat((Digest)dig128_4, "a", "5CD07F03330C3B5020B29BA75911E17D");
        TestDigest.testKat((Digest)dig128_4, "HAVAL", "958195D3DAC591030EAA0292A37A0CF2");
        TestDigest.testKat((Digest)dig128_4, "0123456789", "2215D3702A80025C858062C53D76CBE5");
        TestDigest.testKat((Digest)dig128_4, "abcdefghijklmnopqrstuvwxyz", "B2A73B99775FFB17CD8781B85EC66221");
        TestDigest.testKat((Digest)dig128_4, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "CAD57C0563BDA208D66BB89EB922E2A2");
        TestDigest.testKat((Digest)dig160_4, "", "1D33AAE1BE4146DBAACA0B6E70D7A11F10801525");
        TestDigest.testKat((Digest)dig160_4, "a", "E0A5BE29627332034D4DD8A910A1A0E6FE04084D");
        TestDigest.testKat((Digest)dig160_4, "HAVAL", "221BA4DD206172F12C2EBA3295FDE08D25B2F982");
        TestDigest.testKat((Digest)dig160_4, "0123456789", "E387C743D14DF304CE5C7A552F4C19CA9B8E741C");
        TestDigest.testKat((Digest)dig160_4, "abcdefghijklmnopqrstuvwxyz", "1C7884AF86D11AC120FE5DF75CEE792D2DFA48EF");
        TestDigest.testKat((Digest)dig160_4, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "148334AAD24B658BDC946C521CDD2B1256608C7B");
        TestDigest.testKat((Digest)dig192_4, "", "4A8372945AFA55C7DEAD800311272523CA19D42EA47B72DA");
        TestDigest.testKat((Digest)dig192_4, "a", "856C19F86214EA9A8A2F0C4B758B973CCE72A2D8FF55505C");
        TestDigest.testKat((Digest)dig192_4, "HAVAL", "0C1396D7772689C46773F3DAACA4EFA982ADBFB2F1467EEA");
        TestDigest.testKat((Digest)dig192_4, "0123456789", "C3A5420BB9D7D82A168F6624E954AAA9CDC69FB0F67D785E");
        TestDigest.testKat((Digest)dig192_4, "abcdefghijklmnopqrstuvwxyz", "2E2E581D725E799FDA1948C75E85A28CFE1CF0C6324A1ADA");
        TestDigest.testKat((Digest)dig192_4, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "E5C9F81AE0B31FC8780FC37CB63BB4EC96496F79A9B58344");
        TestDigest.testKat((Digest)dig224_4, "", "3E56243275B3B81561750550E36FCD676AD2F5DD9E15F2E89E6ED78E");
        TestDigest.testKat((Digest)dig224_4, "a", "742F1DBEEAF17F74960558B44F08AA98BDC7D967E6C0AB8F799B3AC1");
        TestDigest.testKat((Digest)dig224_4, "HAVAL", "85538FFC06F3B1C693C792C49175639666F1DDE227DA8BD000C1E6B4");
        TestDigest.testKat((Digest)dig224_4, "0123456789", "BEBD7816F09BAEECF8903B1B9BC672D9FA428E462BA699F814841529");
        TestDigest.testKat((Digest)dig224_4, "abcdefghijklmnopqrstuvwxyz", "A0AC696CDB2030FA67F6CC1D14613B1962A7B69B4378A9A1B9738796");
        TestDigest.testKat((Digest)dig224_4, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "3E63C95727E0CD85D42034191314401E42AB9063A94772647E3E8E0F");
        TestDigest.testKat((Digest)dig256_4, "", "C92B2E23091E80E375DADCE26982482D197B1A2521BE82DA819F8CA2C579B99B");
        TestDigest.testKat((Digest)dig256_4, "a", "E686D2394A49B44D306ECE295CF9021553221DB132B36CC0FF5B593D39295899");
        TestDigest.testKat((Digest)dig256_4, "HAVAL", "E20643CFA66F5BE2145D13ED09C2FF622B3F0DA426A693FA3B3E529CA89E0D3C");
        TestDigest.testKat((Digest)dig256_4, "0123456789", "ACE5D6E5B155F7C9159F6280327B07CBD4FF54143DC333F0582E9BCEB895C05D");
        TestDigest.testKat((Digest)dig256_4, "abcdefghijklmnopqrstuvwxyz", "124F6EB645DC407637F8F719CC31250089C89903BF1DB8FAC21EA4614DF4E99A");
        TestDigest.testKat((Digest)dig256_4, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "46A3A1DFE867EDE652425CCD7FE8006537EAD26372251686BEA286DA152DC35A");
        TestDigest.testKat((Digest)dig128_5, "", "184B8482A0C050DCA54B59C7F05BF5DD");
        TestDigest.testKat((Digest)dig128_5, "a", "F23FBE704BE8494BFA7A7FB4F8AB09E5");
        TestDigest.testKat((Digest)dig128_5, "HAVAL", "C97990F4FCC8FBA76AF935C405995355");
        TestDigest.testKat((Digest)dig128_5, "0123456789", "466FDCD81C3477CAC6A31FFA1C999CA8");
        TestDigest.testKat((Digest)dig128_5, "abcdefghijklmnopqrstuvwxyz", "0EFFF71D7D14344CBA1F4B25F924A693");
        TestDigest.testKat((Digest)dig128_5, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "4B27D04DDB516BDCDFEB96EB8C7C8E90");
        TestDigest.testKat((Digest)dig160_5, "", "255158CFC1EED1A7BE7C55DDD64D9790415B933B");
        TestDigest.testKat((Digest)dig160_5, "a", "F5147DF7ABC5E3C81B031268927C2B5761B5A2B5");
        TestDigest.testKat((Digest)dig160_5, "HAVAL", "7730CA184CEA2272E88571A7D533E035F33B1096");
        TestDigest.testKat((Digest)dig160_5, "0123456789", "41CC7C1267E88CEF0BB93697D0B6C8AFE59061E6");
        TestDigest.testKat((Digest)dig160_5, "abcdefghijklmnopqrstuvwxyz", "917836A9D27EED42D406F6002E7D11A0F87C404C");
        TestDigest.testKat((Digest)dig160_5, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "6DDBDE98EA1C4F8C7F360FB9163C7C952680AA70");
        TestDigest.testKat((Digest)dig192_5, "", "4839D0626F95935E17EE2FC4509387BBE2CC46CB382FFE85");
        TestDigest.testKat((Digest)dig192_5, "a", "5FFA3B3548A6E2CFC06B7908CEB5263595DF67CF9C4B9341");
        TestDigest.testKat((Digest)dig192_5, "HAVAL", "794A896D1780B76E2767CC4011BAD8885D5CE6BD835A71B8");
        TestDigest.testKat((Digest)dig192_5, "0123456789", "A0B635746E6CFFFFD4B4A503620FEF1040C6C0C5C326476E");
        TestDigest.testKat((Digest)dig192_5, "abcdefghijklmnopqrstuvwxyz", "85F1F1C0ECA04330CF2DE5C8C83CF85A611B696F793284DE");
        TestDigest.testKat((Digest)dig192_5, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "D651C8AC45C9050810D9FD64FC919909900C4664BE0336D0");
        TestDigest.testKat((Digest)dig224_5, "", "4A0513C032754F5582A758D35917AC9ADF3854219B39E3AC77D1837E");
        TestDigest.testKat((Digest)dig224_5, "a", "67B3CB8D4068E3641FA4F156E03B52978B421947328BFB9168C7655D");
        TestDigest.testKat((Digest)dig224_5, "HAVAL", "9D7AE77B8C5C8C1C0BA854EBE3B2673C4163CFD304AD7CD527CE0C82");
        TestDigest.testKat((Digest)dig224_5, "0123456789", "59836D19269135BC815F37B2AEB15F894B5435F2C698D57716760F2B");
        TestDigest.testKat((Digest)dig224_5, "abcdefghijklmnopqrstuvwxyz", "1B360ACFF7806502B5D40C71D237CC0C40343D2000AE2F65CF487C94");
        TestDigest.testKat((Digest)dig224_5, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "180AED7F988266016719F60148BA2C9B4F5EC3B9758960FC735DF274");
        TestDigest.testKat((Digest)dig256_5, "", "BE417BB4DD5CFB76C7126F4F8EEB1553A449039307B1A3CD451DBFDC0FBBE330");
        TestDigest.testKat((Digest)dig256_5, "a", "DE8FD5EE72A5E4265AF0A756F4E1A1F65C9B2B2F47CF17ECF0D1B88679A3E22F");
        TestDigest.testKat((Digest)dig256_5, "HAVAL", "153D2C81CD3C24249AB7CD476934287AF845AF37F53F51F5C7E2BE99BA28443F");
        TestDigest.testKat((Digest)dig256_5, "0123456789", "357E2032774ABBF5F04D5F1DEC665112EA03B23E6E00425D0DF75EA155813126");
        TestDigest.testKat((Digest)dig256_5, "abcdefghijklmnopqrstuvwxyz", "C9C7D8AFA159FD9E965CB83FF5EE6F58AEDA352C0EFF005548153A61551C38EE");
        TestDigest.testKat((Digest)dig256_5, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "B45CB6E62F2B1320E4F8F1B0B273D45ADD47C321FD23999DCF403AC37636D963");
        TestDigest.testCollision(dig128_3, "8b447763189fe5d9bb3caaf2ba92cbd6444a54ee76a59f873346a31c4f5dca76428a7aa68bdc3a8d14d8e3b68d993056cd5dea867bae39a7328efd54362bbbac9a3c183889927ab6b29972c4e59e0327145e55ddd8189083c9d9bbaa32c68fd7a7b3f4ff96000040ac6a467fc0fbffffd216405fd016405fb0e21200877f30f4", "8b487763189fe5d9bb3caaf2ba92cbd6444a54ee76a59f873346a31c4f5dca76428a7aa68bdc3a8d14d8e3b68d9930d6cd5dea867bae39a7328efd54362bbbac9a3c183889927ab6ba9972c4e59e0327145e55ddd8189083c9d9bbaa32c68fd7a7b3f4ff96000040ac6a467fc0fbffffd216405fd016405fb0e21200877f30f4");
        TestDigest.testCollision(dig128_3, "8b447763189fe5d9bb3caaf2ba92cbd6444a54ee76a59f873346a31c4f5dca76428a7aa68bdc3a8d14d8e3b68d993056cd5dea867bae39a7328efd54362bbbac9a3c183889927ab6b29972c4e59e0327145e55ddd8189083c9d9bbaa32c68fd7a7b3f4ff96000040ac6a467fc0fbffffd216405fd016405fb0e212006369b1f5", "8b487763189fe5d9bb3caaf2ba92cbd6444a54ee76a59f873346a31c4f5dca76428a7aa68bdc3a8d14d8e3b68d9930d6cd5dea867bae39a7328efd54362bbbac9a3c183889927ab6ba9972c4e59e0327145e55ddd8189083c9d9bbaa32c68fd7a7b3f4ff96000040ac6a467fc0fbffffd216405fd016405fb0e212006369b1f5");
        TestDigest.reportSuccess("HAVAL");
    }

    private static void testWhirlpool() {
        Whirlpool dig = new Whirlpool();
        Whirlpool0 dig0 = new Whirlpool0();
        Whirlpool1 dig1 = new Whirlpool1();
        TestDigest.testKat((Digest)dig, "", "19FA61D75522A4669B44E39C1D2E1726C530232130D407F89AFEE0964997F7A73E83BE698B288FEBCF88E3E03C4F0757EA8964E59B63D93708B138CC42A66EB3");
        TestDigest.testKat((Digest)dig, "a", "8ACA2602792AEC6F11A67206531FB7D7F0DFF59413145E6973C45001D0087B42D11BC645413AEFF63A42391A39145A591A92200D560195E53B478584FDAE231A");
        TestDigest.testKat((Digest)dig, "abc", "4E2448A4C6F486BB16B6562C73B4020BF3043E3A731BCE721AE1B303D97E6D4C7181EEBDB6C57E277D0E34957114CBD6C797FC9D95D8B582D225292076D4EEF5");
        TestDigest.testKat((Digest)dig, "message digest", "378C84A4126E2DC6E56DCC7458377AAC838D00032230F53CE1F5700C0FFB4D3B8421557659EF55C106B4B52AC5A4AAA692ED920052838F3362E86DBD37A8903E");
        TestDigest.testKat((Digest)dig, "abcdefghijklmnopqrstuvwxyz", "F1D754662636FFE92C82EBB9212A484A8D38631EAD4238F5442EE13B8054E41B08BF2A9251C30B6A0B8AAE86177AB4A6F68F673E7207865D5D9819A3DBA4EB3B");
        TestDigest.testKat((Digest)dig, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "DC37E008CF9EE69BF11F00ED9ABA26901DD7C28CDEC066CC6AF42E40F82F3A1E08EBA26629129D8FB7CB57211B9281A65517CC879D7B962142C65F5A7AF01467");
        TestDigest.testKat((Digest)dig, "12345678901234567890123456789012345678901234567890123456789012345678901234567890", "466EF18BABB0154D25B9D38A6414F5C08784372BCCB204D6549C4AFADB6014294D5BD8DF2A6C44E538CD047B2681A51A2C60481E88C5A20B2C2A80CF3A9A083B");
        TestDigest.testKat((Digest)dig, "abcdbcdecdefdefgefghfghighijhijk", "2A987EA40F917061F5D6F0A0E4644F488A7A5A52DEEE656207C562F988E95C6916BDC8031BC5BE1B7B947639FE050B56939BAAA0ADFF9AE6745B7B181C3BE3FD");
        TestDigest.testKatMillionA(dig, "0C99005BEB57EFF50A7CF005560DDF5D29057FD86B20BFD62DECA0F1CCEA4AF51FC15490EDDC47AF32BB2B66C34FF9AD8C6008AD677F77126953B226E4ED8B01");
        TestDigest.testKat((Digest)dig0, "", "B3E1AB6EAF640A34F784593F2074416ACCD3B8E62C620175FCA0997B1BA2347339AA0D79E754C308209EA36811DFA40C1C32F1A2B9004725D987D3635165D3C8");
        TestDigest.testKat((Digest)dig0, "The quick brown fox jumps over the lazy dog", "4F8F5CB531E3D49A61CF417CD133792CCFA501FD8DA53EE368FED20E5FE0248C3A0B64F98A6533CEE1DA614C3A8DDEC791FF05FEE6D971D57C1348320F4EB42D");
        TestDigest.testKat((Digest)dig0, "The quick brown fox jumps over the lazy eog", "228FBF76B2A93469D4B25929836A12B7D7F2A0803E43DABA0C7FC38BC11C8F2A9416BBCF8AB8392EB2AB7BCB565A64AC50C26179164B26084A253CAF2E012676");
        TestDigest.testKat((Digest)dig1, "", "470F0409ABAA446E49667D4EBE12A14387CEDBD10DD17B8243CAD550A089DC0FEEA7AA40F6C2AAAB71C6EBD076E43C7CFCA0AD32567897DCB5969861049A0F5A");
        TestDigest.testKat((Digest)dig1, "The quick brown fox jumps over the lazy dog", "3CCF8252D8BBB258460D9AA999C06EE38E67CB546CFFCF48E91F700F6FC7C183AC8CC3D3096DD30A35B01F4620A1E3A20D79CD5168544D9E1B7CDF49970E87F1");
        TestDigest.testKat((Digest)dig1, "The quick brown fox jumps over the lazy eog", "C8C15D2A0E0DE6E6885E8A7D9B8A9139746DA299AD50158F5FA9EECDDEF744F91B8B83C617080D77CB4247B1E964C2959C507AB2DB0F1F3BF3E3B299CA00CAE3");
        TestDigest.reportSuccess("Whirlpool");
    }

    private static void testRadioGatun() {
        TestDigest.testKat((Digest)new RadioGatun32(), "", "F30028B54AFAB6B3E55355D277711109A19BEDA7091067E9A492FB5ED9F20117");
        TestDigest.testKat((Digest)new RadioGatun32(), "0", "AF0D3F51B98E90EEEBAE86DD0B304A4003AC5F755FA2CAC2B6866A0A91C5C752");
        TestDigest.testKat((Digest)new RadioGatun32(), "1", "896C580EF77A68C36B040DCD5A650C09B8B5D915ECE298AD0210A21ED5811C95");
        TestDigest.testKat((Digest)new RadioGatun32(), "2", "070182313AB302CFC82459786F4A30EC66260C6676495CE86E72B3BE7C60F7AD");
        TestDigest.testKat((Digest)new RadioGatun32(), "3", "E1D20A1B67028A7C102CF77B444E0F4D8489F95506C76E4F27CE43D4958810AD");
        TestDigest.testKat((Digest)new RadioGatun32(), "4", "2D438E83A3D99929F44A1B0AB5A994EB4ABDFE11F9E72D62DE925BF120CAFCCD");
        TestDigest.testKat((Digest)new RadioGatun32(), "5", "8C3C9529C6CC4D266760670F38C7470D6ABA5A0905170A3692AE87E4ABF291FB");
        TestDigest.testKat((Digest)new RadioGatun32(), "6", "904573304A5BC7BA040F8DEF9EECA4138F7DDD7DA30E4B8FB97B7F6E06076BED");
        TestDigest.testKat((Digest)new RadioGatun32(), "7", "E7195ED9189C0169C90AFFEEFCF8810627DB1607F394FB13C7B43D06C74B1D4B");
        TestDigest.testKat((Digest)new RadioGatun32(), "8", "54E7013E72D94B31324D4878F91AE19A7085F20EFE9DAAB96A1FE559C78AE825");
        TestDigest.testKat((Digest)new RadioGatun32(), "9", "D4D08F6612F8EB58A855B2F5AABFC504E2972BA829DA94EDD960193D18BAD8D1");
        TestDigest.testKat((Digest)new RadioGatun32(), "12", "A7FDB34FD5D85D564A62C0B1B1B60CFA3D7A0C778231C95CDCD9BD293CCA16C6");
        TestDigest.testKat((Digest)new RadioGatun32(), "123", "57364D849286C7B3E98F3FC898094F7DC1675BA881A620B75D70F39631A4AA5B");
        TestDigest.testKat((Digest)new RadioGatun32(), "1234", "9EBDD24F469993796C4AAC6A821735A65A3CDEF8A359944CE71F34E7A08E1182");
        TestDigest.testKat((Digest)new RadioGatun32(), "12345", "B333C8413087FA49882BBD4F76A9223C4AA633A252514852C3F7C0C5F8F4D87B");
        TestDigest.testKat((Digest)new RadioGatun32(), "123456", "862B75D2E8E7F08F93812168502AF97BCE530C66688D4372A08EEA0951B5024A");
        TestDigest.testKat((Digest)new RadioGatun32(), "1234567", "90B7061A244CE7FBA80F9813787CB90EC3FBB3398AEE740AF1C0D44BC5282B73");
        TestDigest.testKat((Digest)new RadioGatun32(), "12345678", "E69E29BA139C20846116D8AD406E6197F1701D8243CC53BB86F2B72C62320A39");
        TestDigest.testKat((Digest)new RadioGatun32(), "123456789", "D77629174F56D8451F73CBE80EC7A20EF2DD65C46A1480CD004CBAA96F3FA1FD");
        TestDigest.testKat((Digest)new RadioGatun32(), "1234567890", "4F88759143CD9D11F6DE8DA4D3724C36C745223A5CFB7AD0E74DA87C80A43326");
        TestDigest.testKat((Digest)new RadioGatun32(), "12345678901", "5FC6C16C29CDD2EF78EE4F3C864C1942A052C110FD5A9711FE9BCF953A2D2D5B");
        TestDigest.testKat((Digest)new RadioGatun32(), "123456789012", "15EDA58156CA398AF49CBE9C9E62BF036A66B303ACB0043FB57ECADF9E9C8EDA");
        TestDigest.testKat((Digest)new RadioGatun32(), "1234567890123", "99F13E01DBF89E6BBF60C87E99F4F18C851D3385D9B5A1678C705E8F31F70B84");
        TestDigest.testKat((Digest)new RadioGatun32(), "12345678901234", "0AC434523B00F5C3D1D2AEEDBAE851D3EEAF3D76963CFD70A8B1D875638C8CD4");
        TestDigest.testKat((Digest)new RadioGatun32(), "123456789012345", "0EC6EAE7879543772B64F320BC5056C81ACE91AEA20F360CEFA57272E2C07197");
        TestDigest.testKat((Digest)new RadioGatun32(), "1234567890123456", "59612324F3F42D3096E69125D2733B86143AE668AE9ED561AD785E0EAC8DBA25");
        TestDigest.testKat((Digest)new RadioGatun32(), "12345678901234567", "D52161B6BB583955B1ABB5781D2044BE8F4174904241533973C66B87880EDB53");
        TestDigest.testKat((Digest)new RadioGatun32(), "123456789012345678", "E42EA26B8B696541CFEA557C47886ED41440A04EF8CCC055CEB6583F6ACF6015");
        TestDigest.testKat((Digest)new RadioGatun32(), "1234567890123456789", "687BDEC54F854303E48300A52C9099E3153F481CE34E12CDC178D841C0926B51");
        TestDigest.testKat((Digest)new RadioGatun32(), "12345678901234567890", "8BD3D5953ED234F7A0051A993776630A9722978D06240EECC66E05A0B2CB60C7");
        TestDigest.testKat((Digest)new RadioGatun32(), "123456789012345678901", "381957046BEC1DFC08EAA0B2818D9FA07BCF78386C43AA41C069B5CF33E4F9AB");
        TestDigest.testKat((Digest)new RadioGatun32(), "1234567890123456789012", "F769558AF4FB0ACB6643B893D3595C2E5B110C60256D1CEB672EB33999EF0887");
        TestDigest.testKat((Digest)new RadioGatun32(), "12345678901234567890123", "4CAE588C3F3C08DF85564379332309EA5F73A51405CD4408C9DBFFF1615EF297");
        TestDigest.testKat((Digest)new RadioGatun32(), "123456789012345678901234", "4884DACCBDA87F1E02814152F0224DAB291B49FFD86516A30EA6C9D546730ECF");
        TestDigest.testKat((Digest)new RadioGatun32(), "SECOND CRYPTOGRAPHIC HASH WORKSHOP", "5DD047238DD574B45621DFEDAFADD6BCB4594B6E0551E78CA2B62BCBD975D429");
        TestDigest.testKat((Digest)new RadioGatun32(), "August 24-25, 2006", "277C1598E324185706F8F3EA72B7DC8FBE361EA02DBB0A35AFC7F0E088ACF2F5");
        TestDigest.testKat((Digest)new RadioGatun32(), "Santa Barbara, California", "041666388EF9655D48996A66DADA1193D6646012A7B25A24FB10E6075CF0FC54");
        TestDigest.testKat((Digest)new RadioGatun32(), "In response to the SHA-1 vulnerability that was announced in Feb. 2005, NIST held a Cryptographic Hash Workshop on Oct. 31-Nov. 1, 2005 to solicit public input on its cryptographic hash function policy and standards. NIST continues to recommend a transition from SHA-1 to the larger approved hash functions (SHA-224, SHA-256, SHA-384, and SHA-512). In response to the workshop, NIST has also decided that it would be prudent in the long-term to develop an additional hash function through a public competition, similar to the development process for the block cipher in the Advanced Encryption Standard (AES).", "4311D3CDC46EFE38FDB5C3023A160C3069B26A2AF0CE0CCAAFFA3F3C61629AD6");
        TestDigest.testKat((Digest)new RadioGatun32(), "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890", "849E6159D45AC1E99BC0D613D71C9E2DA639580CCFDC8013EE81D4E32AAD9C25");
        TestDigest.testKat((Digest)new RadioGatun64(), "", "64A9A7FA139905B57BDAB35D33AA216370D5EAE13E77BFCDD85513408311A584");
        TestDigest.testKat((Digest)new RadioGatun64(), "0", "5DB6B188AFEF88AD8D2E426105ACFFCD42EE439CC26275D11F87B530DE94D066");
        TestDigest.testKat((Digest)new RadioGatun64(), "1", "3A3D7A7B79D1EC5A4DB4DC032B685574F7CA7517105F1634B61A34AA2575FCD3");
        TestDigest.testKat((Digest)new RadioGatun64(), "2", "66E36CE1926EC1F7457B670D7B68BD819B2D546A75E5CDFD2691CB5F3DC2818A");
        TestDigest.testKat((Digest)new RadioGatun64(), "3", "449B69EF4ACA0D081B6B2CE9C8BD22BE30BC1CAA130FB0714C8621E42FFA631D");
        TestDigest.testKat((Digest)new RadioGatun64(), "4", "05B7B2D2F2C0D48415E292325AD0901009F12EF1F9581A7A19C422795CF36459");
        TestDigest.testKat((Digest)new RadioGatun64(), "5", "95A02B2899296E69988B11D47B4B9FBA51AF22A09A854523924E8DFFE0EC8922");
        TestDigest.testKat((Digest)new RadioGatun64(), "6", "ED37ECED317B65B676F72F88CEA918B9B878C3F245E79D0C2D35D86C4DEE5A8F");
        TestDigest.testKat((Digest)new RadioGatun64(), "7", "8862FC05C7E23677904020462809A1F2784E117C349AD1D0D8CB0F433021D75C");
        TestDigest.testKat((Digest)new RadioGatun64(), "8", "7338658BFD49605F1EBB186E7E1EC3E75CF672655BCCE499CB8B3952B448B0B4");
        TestDigest.testKat((Digest)new RadioGatun64(), "9", "E2F59B35CB58EFE2200D9544A0BA5FC0659F6019D3EDD4E94A1BB0363166AFD9");
        TestDigest.testKat((Digest)new RadioGatun64(), "12", "BA12168F91F5C124F8AE3908815DC7F3FBF6BCF6E3C66BB8507B16B9B269541E");
        TestDigest.testKat((Digest)new RadioGatun64(), "123", "9719B972D31893EA2B24BD4AC88ACBA598AEFE75DD596692BDA08414080778C4");
        TestDigest.testKat((Digest)new RadioGatun64(), "1234", "733E2B49A53FB166B6F3BD341919578B8C931880F8B8BD7C0FBBEE1A538E7307");
        TestDigest.testKat((Digest)new RadioGatun64(), "12345", "CE8CEEA40E4FDA63EB2453E2CFFF0C9C68E969BFF13757987B0FF9B242394FC7");
        TestDigest.testKat((Digest)new RadioGatun64(), "123456", "1A41026D8183CB13B39819ACD5281617A25BE557C9C09E939F07EEC72347CE34");
        TestDigest.testKat((Digest)new RadioGatun64(), "1234567", "89C6A058B9E8A2C7176A429E941BBEE5F214A9B0603420562991CBF2751CB817");
        TestDigest.testKat((Digest)new RadioGatun64(), "12345678", "4C92EE54656958C6017A7C780E569695F6C354510537AC87206EE887B1E8F258");
        TestDigest.testKat((Digest)new RadioGatun64(), "123456789", "76A565017A42B258F5C8C9D2D9FD4C7347947A659ED142FF61C1BEA592F103C5");
        TestDigest.testKat((Digest)new RadioGatun64(), "1234567890", "93B2D9E81645DDCD588EDCB8EB0E18160C2CBF891760CB831D88C3D81F218061");
        TestDigest.testKat((Digest)new RadioGatun64(), "12345678901", "09C7288E06FC1040C330962737E95887DC6D8BC2985D04A5CAC122BE2689F26C");
        TestDigest.testKat((Digest)new RadioGatun64(), "123456789012", "54877BD9BA9DCC929B152EFD72F46AFC6A772A84FCEDA7ED85398932B185D5A4");
        TestDigest.testKat((Digest)new RadioGatun64(), "1234567890123", "8DA9DC13C922E28DE1D2AC136904B18B8CA5C9332C89982D9FAED2B00C1D0AF9");
        TestDigest.testKat((Digest)new RadioGatun64(), "12345678901234", "64421D3084602E7388679364D5767AA5381F54ABD92CDBA4F05DAD06227F55AF");
        TestDigest.testKat((Digest)new RadioGatun64(), "123456789012345", "FDE56263C4A79F19A7EB663D1BB427243A6AD3522EC31FC00D81775EB6891978");
        TestDigest.testKat((Digest)new RadioGatun64(), "1234567890123456", "CAAEC14B5B4A7960D6854709770E3071D635D60224F58AA385867E549EF4CC42");
        TestDigest.testKat((Digest)new RadioGatun64(), "12345678901234567", "A0C5AC2493B71A5E9A4D41DD1854DAC0383193BAE0B5E7CA035F86AD052F46AA");
        TestDigest.testKat((Digest)new RadioGatun64(), "123456789012345678", "7898EE3F72838E94336E3DE2AFB4C9A7881D395B21ED74473186D919C78A8B88");
        TestDigest.testKat((Digest)new RadioGatun64(), "1234567890123456789", "F0D6C1B2EFC3D88C52B30DDF46920A22008F07FC4FFC9600FDDF1650FAF3FCB9");
        TestDigest.testKat((Digest)new RadioGatun64(), "12345678901234567890", "073ED06E210785942E619BA6BE2C00D4E8A8C991AAD67FEA3ED5E75A3A1CA534");
        TestDigest.testKat((Digest)new RadioGatun64(), "123456789012345678901", "4B71AF0C9D20CF9E827598592835B58235001D65BAA3779136BC45C8C7B26859");
        TestDigest.testKat((Digest)new RadioGatun64(), "1234567890123456789012", "20E64EC450D4FFE67138850E0F4AFE9C7805AB0F1E0B191DF6E57A5555DA6676");
        TestDigest.testKat((Digest)new RadioGatun64(), "12345678901234567890123", "540D61172733EF9A691C487E3739B49DF4406861D0F0AA8C373A56D5A81CBAC9");
        TestDigest.testKat((Digest)new RadioGatun64(), "123456789012345678901234", "EE7A689B4548FA98D83AB6B71432D4327AC172E3AD1302B0D5235D675B8D4952");
        TestDigest.testKat((Digest)new RadioGatun64(), "SECOND CRYPTOGRAPHIC HASH WORKSHOP", "4B9A38E4A968A2096F70A896DCAD202BC1D2D29B4470227F739BEA973233B43F");
        TestDigest.testKat((Digest)new RadioGatun64(), "August 24-25, 2006", "0950DF1B217D3079CAF7D2F5A7F91D3FEBF1A41C4887297B828E36FEB1998534");
        TestDigest.testKat((Digest)new RadioGatun64(), "Santa Barbara, California", "0D08DAF2354FA95AAA5B6A50F514384ECDD35940252E0631002E600E13CD285F");
        TestDigest.testKat((Digest)new RadioGatun64(), "In response to the SHA-1 vulnerability that was announced in Feb. 2005, NIST held a Cryptographic Hash Workshop on Oct. 31-Nov. 1, 2005 to solicit public input on its cryptographic hash function policy and standards. NIST continues to recommend a transition from SHA-1 to the larger approved hash functions (SHA-224, SHA-256, SHA-384, and SHA-512). In response to the workshop, NIST has also decided that it would be prudent in the long-term to develop an additional hash function through a public competition, similar to the development process for the block cipher in the Advanced Encryption Standard (AES).", "2C9EC1EFC5D2FEEFFC2817CD571F394328111DB8068FC79E2FB84A42416BF5D3");
        TestDigest.testKat((Digest)new RadioGatun64(), "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890", "5B62F66DBF00028A2360E80D7D1AF240C8342C38C8F1674BF7E720AD6FC9EC55");
        TestDigest.reportSuccess("RadioGatun");
    }

    private static void testShabal192() {
        TestDigest.testKat((Digest)new Shabal192(), "abcdefghijklmnopqrstuvwxyz-0123456789-ABCDEFGHIJKLMNOPQRSTUVWXYZ-0123456789-abcdefghijklmnopqrstuvwxyz", "690FAE79226D95760AE8FDB4F58C0537111756557D307B15");
        TestDigest.reportSuccess("Shabal-192");
    }

    private static void testShabal224() {
        TestDigest.testKatHex(new Shabal224(), "", "562b4fdbe1706247552927f814b66a3d74b465a090af23e277bf8029");
        TestDigest.testKatHex(new Shabal224(), "cc", "63d1743b183146ac2a75416c9a0d88c66f85a422a43e3171ef9cc923");
        TestDigest.testKatHex(new Shabal224(), "41fb", "de6707feb8413d0621e40cc8f2843d369647055b35580533db660b8b");
        TestDigest.testKatHex(new Shabal224(), "1f877c", "95d94b88f06c521e55000bd3019e1a45668e11ac9cd4511eea490f5d");
        TestDigest.testKatHex(new Shabal224(), "c1ecfdfc", "223fefcc0539d29cbcfb3d5f63b94d26d0035869b228f38955919686");
        TestDigest.testKatHex(new Shabal224(), "21f134ac57", "2247f2859c81d1e5807ad0cbeda7969d190b3756a6f840e99a74064c");
        TestDigest.testKatHex(new Shabal224(), "c6f50bb74e29", "12db617d00712dd51ea545c2c0b8e7819afa29e258dee6553f1685f8");
        TestDigest.testKatHex(new Shabal224(), "119713cc83eeef", "34d50d8b56e80fe8481bd6f9ca2905eb930d7759c49abe2e6820e90f");
        TestDigest.testKatHex(new Shabal224(), "4a4f202484512526", "6982dbcdfb074bcec4b0939b311399c731a8fc4499b158cce76d2bc6");
        TestDigest.testKatHex(new Shabal224(), "1f66ab4185ed9b6375", "3366d7de5fe29956cf9c6ecdeae4777fb8b4d1f0692a32838b7e10b7");
        TestDigest.testKatHex(new Shabal224(), "eed7422227613b6f53c9", "7c722e789f761155194dd07b42595850dfb206645e4f35554d344f06");
        TestDigest.testKatHex(new Shabal224(), "eaeed5cdffd89dece455f1", "f53e25c699d95aa90d4bb2938f4081cec2a42ab729ae789317e9cfb2");
        TestDigest.testKatHex(new Shabal224(), "5be43c90f22902e4fe8ed2d3", "0cefef2f459d870f69fa6a79d720928db5b636867c03a9b1aa915c5d");
        TestDigest.testKatHex(new Shabal224(), "a746273228122f381c3b46e4f1", "0530841925d57a23bbfc87cad5e140c0594bd150dade13fd2d4c5ddf");
        TestDigest.testKatHex(new Shabal224(), "3c5871cd619c69a63b540eb5a625", "43882cf2d5f996b630b9b966ffbdd83fa72a3555d14f4023ec1255c1");
        TestDigest.testKatHex(new Shabal224(), "fa22874bcc068879e8ef11a69f0722", "2ca8191eed154fd761d8cbe2d6e50bf125539938aa7cc6d6556ac78c");
        TestDigest.testKatHex(new Shabal224(), "52a608ab21ccdd8a4457a57ede782176", "9462ef6b4100fe39e03e779baa7c3e7dadad23ee86ed278d4c2e79ff");
        TestDigest.testKatHex(new Shabal224(), "82e192e4043ddcd12ecf52969d0f807eed", "05a6a9b571bf450fc6bcb3175edf32f605ff1ffcb96ae857c9ba3f10");
        TestDigest.testKatHex(new Shabal224(), "75683dcb556140c522543bb6e9098b21a21e", "6d372b4af120a29dd89786334b7406b6bf8641f6a1fefce78f0cbfda");
        TestDigest.testKatHex(new Shabal224(), "06e4efe45035e61faaf4287b4d8d1f12ca97e5", "3cb8932eee5200e9d0841c02c88cb740b9de909df82c7193d6eedf08");
        TestDigest.testKatHex(new Shabal224(), "e26193989d06568fe688e75540aea06747d9f851", "3028cc2858806a5f0dc6c199d6dd5ec68e7556f2a17fa27d9cf6b48d");
        TestDigest.testKatHex(new Shabal224(), "d8dc8fdefbdce9d44e4cbafe78447bae3b5436102a", "f47f5a632bbc6c30e80ebfa12f559af6a07868b740d36016ee2deca2");
        TestDigest.testKatHex(new Shabal224(), "57085fd7e14216ab102d8317b0cb338a786d5fc32d8f", "cadf066d05b8598d78784a2c183c67e6dceec5a5fd77d08d11160f34");
        TestDigest.testKatHex(new Shabal224(), "a05404df5dbb57697e2c16fa29defac8ab3560d6126fa0", "f3f1054c5b49c339b8fb3c24f7e1e7f2ee8ab84fc27070b0f6eed6f6");
        TestDigest.testKatHex(new Shabal224(), "aecbb02759f7433d6fcb06963c74061cd83b5b3ffa6f13c6", "95769e2be095f0e691b2990009d147f6de26cac959a874558b2a3530");
        TestDigest.testKatHex(new Shabal224(), "aafdc9243d3d4a096558a360cc27c8d862f0be73db5e88aa55", "88e86137bc479bee813aa2feb183ddd9189a976ec603cf4e3c26c364");
        TestDigest.testKatHex(new Shabal224(), "7bc84867f6f9e9fdc3e1046cae3a52c77ed485860ee260e30b15", "476a40f8c7f2196aad956bd0d1e27d196c033f5f0d99af201a99c278");
        TestDigest.testKatHex(new Shabal224(), "fac523575a99ec48279a7a459e98ff901918a475034327efb55843", "9b71fbf13d1db4a7273952a2c9198aa98351776df0ce665eaf89fe87");
        TestDigest.testKatHex(new Shabal224(), "0f8b2d8fcfd9d68cffc17ccfb117709b53d26462a3f346fb7c79b85e", "cb2a3912785cc78aa558ccec054b13a4264d54ddd47e931439b1d96f");
        TestDigest.testKatHex(new Shabal224(), "a963c3e895ff5a0be4824400518d81412f875fa50521e26e85eac90c04", "f8bc968e46c2833be7429ce7a8435048e7e4b6423992ad3244075c76");
        TestDigest.testKatHex(new Shabal224(), "03a18688b10cc0edf83adf0a84808a9718383c4070c6c4f295098699ac2c", "759c3c8f72114cdaced92b3f25e61df433f2b01668f59fc830e15c13");
        TestDigest.testKatHex(new Shabal224(), "84fb51b517df6c5accb5d022f8f28da09b10232d42320ffc32dbecc3835b29", "a5edfd84b189e5fe81e0f2527e6252c82e680c63a740ba1c8e9e612b");
        TestDigest.testKatHex(new Shabal224(), "9f2fcc7c90de090d6b87cd7e9718c1ea6cb21118fc2d5de9f97e5db6ac1e9c10", "ed6115fc31211cfd2b554026bc321c882351122c5c8e39d60d6bbb26");
        TestDigest.testKatHex(new Shabal224(), "de8f1b3faa4b7040ed4563c3b8e598253178e87e4d0df75e4ff2f2dedd5a0be046", "77b89e79bdd7ba45650b9f0ef501ec65cf15c2364dd0348e39663218");
        TestDigest.testKatHex(new Shabal224(), "62f154ec394d0bc757d045c798c8b87a00e0655d0481a7d2d9fb58d93aedc676b5a0", "070c88fee8fd3c800edfd77843ae1c4712936c8f97ab200aa0976208");
        TestDigest.testKatHex(new Shabal224(), "b2dcfe9ff19e2b23ce7da2a4207d3e5ec7c6112a8a22aec9675a886378e14e5bfbad4e", "8ca458f360efceb43b2b23d0dbe0dfa9e22e94c3a5a1cd0a6afffcd8");
        TestDigest.testKatHex(new Shabal224(), "47f5697ac8c31409c0868827347a613a3562041c633cf1f1f86865a576e02835ed2c2492", "c8f2a0d2c018e191ce075616c1e66c4bcee1183c5d455e4ad32d3821");
        TestDigest.testKatHex(new Shabal224(), "512a6d292e67ecb2fe486bfe92660953a75484ff4c4f2eca2b0af0edcdd4339c6b2ee4e542", "ce785556a1d047b53ac83add1eebe4c57e8c7e2660aeffe4d5896094");
        TestDigest.testKatHex(new Shabal224(), "973cf2b4dcf0bfa872b41194cb05bb4e16760a1840d8343301802576197ec19e2a1493d8f4fb", "940e89fc01b9fe9443ff320e87dfb25a8563c2679ba9bd288d906eb3");
        TestDigest.testKatHex(new Shabal224(), "80beebcd2e3f8a9451d4499961c9731ae667cdc24ea020ce3b9aa4bbc0a7f79e30a934467da4b0", "1dac3b8e4e39a2c3206a26159be79c939965a7605b5815b3ac71e9f6");
        TestDigest.testKatHex(new Shabal224(), "7abaa12ec2a7347674e444140ae0fb659d08e1c66decd8d6eae925fa451d65f3c0308e29446b8ed3", "e25ac149c331228f376124845af664d5a37e5ef6a76311f93d97050f");
        TestDigest.testKatHex(new Shabal224(), "c88dee9927679b8af422abcbacf283b904ff31e1cac58c7819809f65d5807d46723b20f67ba610c2b7", "2e0786b362f160646fefe66be3c3d1c88c370a338e1e827e353c1acd");
        TestDigest.testKatHex(new Shabal224(), "01e43fe350fcec450ec9b102053e6b5d56e09896e0ddd9074fe138e6038210270c834ce6eadc2bb86bf6", "9955742716bc38f06032048cbe1ddad4dfcfd91b8678334ac4f855bd");
        TestDigest.testKatHex(new Shabal224(), "337023370a48b62ee43546f17c4ef2bf8d7ecd1d49f90bab604b839c2e6e5bd21540d29ba27ab8e309a4b7", "32fb51b7fba8f6f59686b36b79e4cffbf7d04b1280f583b4a536ae61");
        TestDigest.testKatHex(new Shabal224(), "6892540f964c8c74bd2db02c0ad884510cb38afd4438af31fc912756f3efec6b32b58ebc38fc2a6b913596a8", "f5d3dbb6f476792b3b06f0d4aaa0d287ceab1284600198ae0cb0ec5b");
        TestDigest.testKatHex(new Shabal224(), "f5961dfd2b1ffffda4ffbf30560c165bfedab8ce0be525845deb8dc61004b7db38467205f5dcfb34a2acfe96c0", "523407e765a728ad72fea7bce239928bd0df18414ece1b839e22df2d");
        TestDigest.testKatHex(new Shabal224(), "ca061a2eb6ceed8881ce2057172d869d73a1951e63d57261384b80ceb5451e77b06cf0f5a0ea15ca907ee1c27eba", "b3ef1a4de95c4903b90600f751835f45f18fc618752bed2dc069e395");
        TestDigest.testKatHex(new Shabal224(), "1743a77251d69242750c4f1140532cd3c33f9b5ccdf7514e8584d4a5f9fbd730bcf84d0d4726364b9bf95ab251d9bb", "4c15dfd3b635d718309c8e677dea36225bbd45c11c95d4050247fcb8");
        TestDigest.testKatHex(new Shabal224(), "d8faba1f5194c4db5f176fabfff856924ef627a37cd08cf55608bba8f1e324d7c7f157298eabc4dce7d89ce5162499f9", "e19e2ee4ff6c954f2f95fde50b0522244bd9373d6b0f1a7cc94386fd");
        TestDigest.testKatHex(new Shabal224(), "be9684be70340860373c9c482ba517e899fc81baaa12e5c6d7727975d1d41ba8bef788cdb5cf4606c9c1c7f61aed59f97d", "1ee07459e479c7cbcdbede4384aa96d8996b93b1195a4bed2b438872");
        TestDigest.testKatHex(new Shabal224(), "7e15d2b9ea74ca60f66c8dfab377d9198b7b16deb6a1ba0ea3c7ee2042f89d3786e779cf053c77785aa9e692f821f14a7f51", "bc6cf5c3fa221f9dcb37166cb96d5cb032a169a7020cf350fbede7f2");
        TestDigest.testKatHex(new Shabal224(), "9a219be43713bd578015e9fda66c0f2d83cac563b776ab9f38f3e4f7ef229cb443304fba401efb2bdbd7ece939102298651c86", "5358bbecefdc77292b379689108a99de75d13ef4291f824b2f4dd50c");
        TestDigest.testKatHex(new Shabal224(), "c8f2b693bd0d75ef99caebdc22adf4088a95a3542f637203e283bbc3268780e787d68d28cc3897452f6a22aa8573ccebf245972a", "4f2c5883bb9f92301ed48ddcb44b01c7af6a56579422305731c52543");
        TestDigest.testKatHex(new Shabal224(), "ec0f99711016c6a2a07ad80d16427506ce6f441059fd269442baaa28c6ca037b22eeac49d5d894c0bf66219f2c08e9d0e8ab21de52", "8a109e87ee7d80b47ea12a84e44e8a5bc936c27749cb037058833d51");
        TestDigest.testKatHex(new Shabal224(), "0dc45181337ca32a8222fe7a3bf42fc9f89744259cff653504d6051fe84b1a7ffd20cb47d4696ce212a686bb9be9a8ab1c697b6d6a33", "d534f71dcc0dae1eb07e18d37b28ed0af7bd5c0c4cc551d7c270bb7e");
        TestDigest.testKatHex(new Shabal224(), "de286ba4206e8b005714f80fb1cdfaebde91d29f84603e4a3ebc04686f99a46c9e880b96c574825582e8812a26e5a857ffc6579f63742f", "b4d3f171b1d1d495be85c330957e6c364a0de365907a910930197daa");
        TestDigest.testKatHex(new Shabal224(), "eebcc18057252cbf3f9c070f1a73213356d5d4bc19ac2a411ec8cdeee7a571e2e20eaf61fd0c33a0ffeb297ddb77a97f0a415347db66bcaf", "4a1421f85a93a5dd50980684ac2968b0d34f8462c31b236b12af59d0");
        TestDigest.testKatHex(new Shabal224(), "416b5cdc9fe951bd361bd7abfc120a5054758eba88fdd68fd84e39d3b09ac25497d36b43cbe7b85a6a3cebda8db4e5549c3ee51bb6fcb6ac1e", "67533ccb319e0638569470d5ff90212375309fb2e97122761dc8206a");
        TestDigest.testKatHex(new Shabal224(), "5c5faf66f32e0f8311c32e8da8284a4ed60891a5a7e50fb2956b3cbaa79fc66ca376460e100415401fc2b8518c64502f187ea14bfc9503759705", "379c628e9e62c48de0ee63b28e7aee5bc23e45210a8f6d9650805f89");
        TestDigest.testKatHex(new Shabal224(), "7167e1e02be1a7ca69d788666f823ae4eef39271f3c26a5cf7cee05bca83161066dc2e217b330df821103799df6d74810eed363adc4ab99f36046a", "7978de0cd4a9892610807cbb841141ad99b62bb401a0a4f1fb4708f6");
        TestDigest.testKatHex(new Shabal224(), "2fda311dbba27321c5329510fae6948f03210b76d43e7448d1689a063877b6d14c4f6d0eaa96c150051371f7dd8a4119f7da5c483cc3e6723c01fb7d", "a1f35166051b85c4c5c78dc544ec2fff79ab1f2bcdbb14cf53cebd0b");
        TestDigest.testKatHex(new Shabal224(), "95d1474a5aab5d2422aca6e481187833a6212bd2d0f91451a67dd786dfc91dfed51b35f47e1deb8a8ab4b9cb67b70179cc26f553ae7b569969ce151b8d", "530616057d3d624b8e36582af91ece11eb9a6879d9f787bceadf1b41");
        TestDigest.testKatHex(new Shabal224(), "c71bd7941f41df044a2927a8ff55b4b467c33d089f0988aa253d294addbdb32530c0d4208b10d9959823f0c0f0734684006df79f7099870f6bf53211a88d", "f6bc5e36809a8feb15f43b77e79b8b4a5d47332a510716e8eda494ce");
        TestDigest.testKatHex(new Shabal224(), "f57c64006d9ea761892e145c99df1b24640883da79d9ed5262859dcda8c3c32e05b03d984f1ab4a230242ab6b78d368dc5aaa1e6d3498d53371e84b0c1d4ba", "349b108ce08584f824bda3fb0327682baeef9296a469c008b8b7b49e");
        TestDigest.testKatHex(new Shabal224(), "e926ae8b0af6e53176dbffcc2a6b88c6bd765f939d3d178a9bde9ef3aa131c61e31c1e42cdfaf4b4dcde579a37e150efbef5555b4c1cb40439d835a724e2fae7", "1f53cf00d91cef8e082f4f2e842603e1d6ed51109d577722150d227c");
        TestDigest.testKatHex(new Shabal224(), "16e8b3d8f988e9bb04de9c96f2627811c973ce4a5296b4772ca3eefeb80a652bdf21f50df79f32db23f9f73d393b2d57d9a0297f7a2f2e79cfda39fa393df1ac00", "895bd0aece88d04e020478b65e8537ef42201d2edc78c247add4b7cf");
        TestDigest.testKatHex(new Shabal224(), "fc424eeb27c18a11c01f39c555d8b78a805b88dba1dc2a42ed5e2c0ec737ff68b2456d80eb85e11714fa3f8eabfb906d3c17964cb4f5e76b29c1765db03d91be37fc", "72710319c4837f679bef66d7d2fde97b0f407f221dc4255d35ee5259");
        TestDigest.testKatHex(new Shabal224(), "abe3472b54e72734bdba7d9158736464251c4f21b33fbbc92d7fac9a35c4e3322ff01d2380cbaa4ef8fb07d21a2128b7b9f5b6d9f34e13f39c7ffc2e72e47888599ba5", "a265db544fe4f48d40e012f7702340ccf85f54e64b03555be08ce7fa");
        TestDigest.testKatHex(new Shabal224(), "36f9f0a65f2ca498d739b944d6eff3da5ebba57e7d9c41598a2b0e4380f3cf4b479ec2348d015ffe6256273511154afcf3b4b4bf09d6c4744fdd0f62d75079d440706b05", "5ca4dc99075538a12ff97ca3a1414cc30ccb4977e42d2764fc46dbd7");
        TestDigest.testKatHex(new Shabal224(), "abc87763cae1ca98bd8c5b82caba54ac83286f87e9610128ae4de68ac95df5e329c360717bd349f26b872528492ca7c94c2c1e1ef56b74dbb65c2ac351981fdb31d06c77a4", "1421e8b018b10d14592e50092950e0e0aa76982e4e107caa93c7d9a9");
        TestDigest.testKatHex(new Shabal224(), "94f7ca8e1a54234c6d53cc734bb3d3150c8ba8c5f880eab8d25fed13793a9701ebe320509286fd8e422e931d99c98da4df7e70ae447bab8cffd92382d8a77760a259fc4fbd72", "42d44571026b74d4ebcdf3c66238c422669c72542a4e31d3090fc3e0");
        TestDigest.testKatHex(new Shabal224(), "13bd2811f6ed2b6f04ff3895aceed7bef8dcd45eb121791bc194a0f806206bffc3b9281c2b308b1a729ce008119dd3066e9378acdcc50a98a82e20738800b6cddbe5fe9694ad6d", "600a2565d54bd8e45e6f57d01121c3bcb8bb64178354b79846907db9");
        TestDigest.testKatHex(new Shabal224(), "1eed9cba179a009ec2ec5508773dd305477ca117e6d569e66b5f64c6bc64801ce25a8424ce4a26d575b8a6fb10ead3fd1992edddeec2ebe7150dc98f63adc3237ef57b91397aa8a7", "cefde32827eef1de1512b463deac87bf3ff017163ff5826839eaa2e9");
        TestDigest.testKatHex(new Shabal224(), "ba5b67b5ec3a3ffae2c19dd8176a2ef75c0cd903725d45c9cb7009a900c0b0ca7a2967a95ae68269a6dbf8466c7b6844a1d608ac661f7eff00538e323db5f2c644b78b2d48de1a08aa", "e526bdd950002ab19aab53ddd1558e5dd05b26468bec1bfd4f46cb4a");
        TestDigest.testKatHex(new Shabal224(), "0efa26ac5673167dcacab860932ed612f65ff49b80fa9ae65465e5542cb62075df1c5ae54fba4db807be25b070033efa223bdd5b1d3c94c6e1909c02b620d4b1b3a6c9fed24d70749604", "8bb03568dbee9ec60d3a272e241b19e505f42b656bd08cf503d190bc");
        TestDigest.testKatHex(new Shabal224(), "bbfd933d1fd7bf594ac7f435277dc17d8d5a5b8e4d13d96d2f64e771abbd51a5a8aea741beccbddb177bcea05243ebd003cfdeae877cca4da94605b67691919d8b033f77d384ca01593c1b", "8d716bda9abf47f4e3b538c1a8bc5310430b07311d389d6ff17e4a02");
        TestDigest.testKatHex(new Shabal224(), "90078999fd3c35b8afbf4066cbde335891365f0fc75c1286cdd88fa51fab94f9b8def7c9ac582a5dbcd95817afb7d1b48f63704e19c2baa4df347f48d4a6d603013c23f1e9611d595ebac37c", "2910721e72db42ea0288169e86a583b463e15520c8edf937c6af8a68");
        TestDigest.testKatHex(new Shabal224(), "64105eca863515c20e7cfbaa0a0b8809046164f374d691cdbd6508aaabc1819f9ac84b52bafc1b0fe7cddbc554b608c01c8904c669d8db316a0953a4c68ece324ec5a49ffdb59a1bd6a292aa0e", "b6e1e4e8a98a98addc22f63d2ef8e3103f1c49268d8a238c1912961d");
        TestDigest.testKatHex(new Shabal224(), "d4654be288b9f3b711c2d02015978a8cc57471d5680a092aa534f7372c71ceaab725a383c4fcf4d8deaa57fca3ce056f312961eccf9b86f14981ba5bed6ab5b4498e1f6c82c6cae6fc14845b3c8a", "c168462c01dab4b3d1b614364e92a106da4e58409cb8237d67aac1e1");
        TestDigest.testKatHex(new Shabal224(), "12d9394888305ac96e65f2bf0e1b18c29c90fe9d714dd59f651f52b88b3008c588435548066ea2fc4c101118c91f32556224a540de6efddbca296ef1fb00341f5b01fecfc146bdb251b3bdad556cd2", "3ef03f51eb66b09b7db6e7b9761f2a8025e1147bc700cf77a5fa70b0");
        TestDigest.testKatHex(new Shabal224(), "871a0d7a5f36c3da1dfce57acd8ab8487c274fad336bc137ebd6ff4658b547c1dcfab65f037aa58f35ef16aff4abe77ba61f65826f7be681b5b6d5a1ea8085e2ae9cd5cf0991878a311b549a6d6af230", "375e23fe580d1781ae955396781abdb0b946d4a4b9b4983f771d92e4");
        TestDigest.testKatHex(new Shabal224(), "e90b4ffef4d457bc7711ff4aa72231ca25af6b2e206f8bf859d8758b89a7cd36105db2538d06da83bad5f663ba11a5f6f61f236fd5f8d53c5e89f183a3cec615b50c7c681e773d109ff7491b5cc22296c5", "c55c68861d4be22f22e654429cb9ff77ec7952a5fd2e3c28dff9cccc");
        TestDigest.testKatHex(new Shabal224(), "e728de62d75856500c4c77a428612cd804f30c3f10d36fb219c5ca0aa30726ab190e5f3f279e0733d77e7267c17be27d21650a9a4d1e32f649627638dbada9702c7ca303269ed14014b2f3cf8b894eac8554", "0ecd1bbdc65c11429df01e6d107c878f5fbebd9911775f8d4baae657");
        TestDigest.testKatHex(new Shabal224(), "6348f229e7b1df3b770c77544e5166e081850fa1c6c88169db74c76e42eb983facb276ad6a0d1fa7b50d3e3b6fcd799ec97470920a7abed47d288ff883e24ca21c7f8016b93bb9b9e078bdb9703d2b781b616e", "20a9d78c15567cb06cd14b926d37fd5b041beaa89ae6b77ad9d123a7");
        TestDigest.testKatHex(new Shabal224(), "4b127fde5de733a1680c2790363627e63ac8a3f1b4707d982caea258655d9bf18f89afe54127482ba01e08845594b671306a025c9a5c5b6f93b0a39522dc877437be5c2436cbf300ce7ab6747934fcfc30aeaaf6", "8d07ab00ca8bf6c0c5766ec95ffaea142a19f9c8dc1d6653d43413dc");
        TestDigest.testKatHex(new Shabal224(), "08461f006cff4cc64b752c957287e5a0faabc05c9bff89d23fd902d324c79903b48fcb8f8f4b01f3e4ddb483593d25f000386698f5ade7faade9615fdc50d32785ea51d49894e45baa3dc707e224688c6408b68b11", "d63b769d7526953cb4c6dde5c85c327d8cc125e5d5b7cdeebd280cf6");
        TestDigest.testKatHex(new Shabal224(), "68c8f8849b120e6e0c9969a5866af591a829b92f33cd9a4a3196957a148c49138e1e2f5c7619a6d5edebe995acd81ec8bb9c7b9cfca678d081ea9e25a75d39db04e18d475920ce828b94e72241f24db72546b352a0e4", "03527642f2e22180ad4d030ab4b883cf70a5d5574163bdfb96d49089");
        TestDigest.testKatHex(new Shabal224(), "b8d56472954e31fb54e28fca743f84d8dc34891cb564c64b08f7b71636debd64ca1edbdba7fc5c3e40049ce982bba8c7e0703034e331384695e9de76b5104f2fbc4535ecbeebc33bc27f29f18f6f27e8023b0fbb6f563c", "c0042094a07e2b67fc6289bfefe19a67b7e3af5222c5521b46a928cc");
        TestDigest.testKatHex(new Shabal224(), "0d58ac665fa84342e60cefee31b1a4eacdb092f122dfc68309077aed1f3e528f578859ee9e4cefb4a728e946324927b675cd4f4ac84f64db3dacfe850c1dd18744c74ceccd9fe4dc214085108f404eab6d8f452b5442a47d", "0a8314d6fc80355fcb7ee8e76e064c265968a81d9233d2a8fd7f444a");
        TestDigest.testKatHex(new Shabal224(), "1755e2d2e5d1c1b0156456b539753ff416651d44698e87002dcf61dcfa2b4e72f264d9ad591df1fdee7b41b2eb00283c5aebb3411323b672eaa145c5125185104f20f335804b02325b6dea65603f349f4d5d8b782dd3469ccd", "340082996505051db46e66b805940564c358a322ff7cde70b0ad834b");
        TestDigest.testKatHex(new Shabal224(), "b180de1a611111ee7584ba2c4b020598cd574ac77e404e853d15a101c6f5a2e5c801d7d85dc95286a1804c870bb9f00fd4dcb03aa8328275158819dcad7253f3e3d237aeaa7979268a5db1c6ce08a9ec7c2579783c8afc1f91a7", "b1e7ff88b84ef2eb8ba1f3540b9c8b746f6f9777ede8fef6a202a861");
        TestDigest.testKatHex(new Shabal224(), "cf3583cbdfd4cbc17063b1e7d90b02f0e6e2ee05f99d77e24e560392535e47e05077157f96813544a17046914f9efb64762a23cf7a49fe52a0a4c01c630cfe8727b81fb99a89ff7cc11dca5173057e0417b8fe7a9efba6d95c555f", "5e1669458e31480da0b084acf27bad1017ffaadce6dad260d5758c9e");
        TestDigest.testKatHex(new Shabal224(), "072fc02340ef99115bad72f92c01e4c093b9599f6cfc45cb380ee686cb5eb019e806ab9bd55e634ab10aa62a9510cc0672cd3eddb589c7df2b67fcd3329f61b1a4441eca87a33c8f55da4fbbad5cf2b2527b8e983bb31a2fadec7523", "59b7407b79acbd416bdf7d971b8779a0d3c531a00df0df11c719b009");
        TestDigest.testKatHex(new Shabal224(), "76eecf956a52649f877528146de33df249cd800e21830f65e90f0f25ca9d6540fde40603230eca6760f1139c7f268deba2060631eea92b1fff05f93fd5572fbe29579ecd48bc3a8d6c2eb4a6b26e38d6c5fbf2c08044aeea470a8f2f26", "b1bd0ba61b0babf2d32a0dfbc12ce18f5dc53553dbfe2223ead0ec68");
        TestDigest.testKatHex(new Shabal224(), "7adc0b6693e61c269f278e6944a5a2d8300981e40022f839ac644387bfac9086650085c2cdc585fea47b9d2e52d65a2b29a7dc370401ef5d60dd0d21f9e2b90fae919319b14b8c5565b0423cefb827d5f1203302a9d01523498a4db10374", "d1b7dde473da4bc77680a4439c2fc40fb34ef659fc14f4168be89b52");
        TestDigest.testKatHex(new Shabal224(), "e1fffa9826cce8b86bccefb8794e48c46cdf372013f782eced1e378269b7be2b7bf51374092261ae120e822be685f2e7a83664bcfbe38fe8633f24e633ffe1988e1bc5acf59a587079a57a910bda60060e85b5f5b6f776f0529639d9cce4bd", "8c22151a2fbfe0fc08c81eb6000c0a52edb80d20d728ece0dee0c916");
        TestDigest.testKatHex(new Shabal224(), "69f9abba65592ee01db4dce52dbab90b08fc04193602792ee4daa263033d59081587b09bbe49d0b49c9825d22840b2ff5d9c5155f975f8f2c2e7a90c75d2e4a8040fe39f63bbafb403d9e28cc3b86e04e394a9c9e8065bd3c85fa9f0c7891600", "fcb736418c9648bb99ae4e38e0036be5f02d0532e4978c54e533f1b6");
        TestDigest.testKatHex(new Shabal224(), "38a10a352ca5aedfa8e19c64787d8e9c3a75dbf3b8674bfab29b5dbfc15a63d10fae66cd1a6e6d2452d557967eaad89a4c98449787b0b3164ca5b717a93f24eb0b506ceb70cbbcb8d72b2a72993f909aad92f044e0b5a2c9ac9cb16a0ca2f81f49", "fe0f37a07aa126c028559773756ac07367a26830a9421d7e9d2b8389");
        TestDigest.testKatHex(new Shabal224(), "6d8c6e449bc13634f115749c248c17cd148b72157a2c37bf8969ea83b4d6ba8c0ee2711c28ee11495f43049596520ce436004b026b6c1f7292b9c436b055cbb72d530d860d1276a1502a5140e3c3f54a93663e4d20edec32d284e25564f624955b52", "e92d89a04f82038785330e43ca53a3c3428fb8ad8e815963e763d787");
        TestDigest.testKatHex(new Shabal224(), "6efcbcaf451c129dbe00b9cef0c3749d3ee9d41c7bd500ade40cdc65dedbbbadb885a5b14b32a0c0d087825201e303288a733842fa7e599c0c514e078f05c821c7a4498b01c40032e9f1872a1c925fa17ce253e8935e4c3c71282242cb716b2089ccc1", "c8eb2535fd0c7f198c7ce97b8846612d5453d45801e18fd431ff8e53");
        TestDigest.testKatHex(new Shabal224(), "433c5303131624c0021d868a30825475e8d0bd3052a022180398f4ca4423b98214b6beaac21c8807a2c33f8c93bd42b092cc1b06cedf3224d5ed1ec29784444f22e08a55aa58542b524b02cd3d5d5f6907afe71c5d7462224a3f9d9e53e7e0846dcbb4ce", "c4cccc92ae5b7f7dcf98a26ac1b01400f60cbf8abbdb1833123cb7b3");
        TestDigest.testKatHex(new Shabal224(), "a873e0c67ca639026b6683008f7aa6324d4979550e9bce064ca1e1fb97a30b147a24f3f666c0a72d71348ede701cf2d17e2253c34d1ec3b647dbcef2f879f4eb881c4830b791378c901eb725ea5c172316c6d606e0af7df4df7f76e490cd30b2badf45685f", "f8278565679b385f848dc84859be9cfd9b683454dd92af7c90f06834");
        TestDigest.testKatHex(new Shabal224(), "006917b64f9dcdf1d2d87c8a6173b64f6587168e80faa80f82d84f60301e561e312d9fbce62f39a6fb476e01e925f26bcc91de621449be6504c504830aae394096c8fc7694651051365d4ee9070101ec9b68086f2ea8f8ab7b811ea8ad934d5c9b62c60a4771", "de3480f7c69bf26f9a0d6d6cfa67b0f112f0a0a53094a8f4c6d8f154");
        TestDigest.testKatHex(new Shabal224(), "f13c972c52cb3cc4a4df28c97f2df11ce089b815466be88863243eb318c2adb1a417cb1041308598541720197b9b1cb5ba2318bd5574d1df2174af14884149ba9b2f446d609df240ce335599957b8ec80876d9a085ae084907bc5961b20bf5f6ca58d5dab38adb", "25cf7b1e48be863964b05a392a2e5e6cb44b091657495944b3d40c0f");
        TestDigest.testKatHex(new Shabal224(), "e35780eb9799ad4c77535d4ddb683cf33ef367715327cf4c4a58ed9cbdcdd486f669f80189d549a9364fa82a51a52654ec721bb3aab95dceb4a86a6afa93826db923517e928f33e3fba850d45660ef83b9876accafa2a9987a254b137c6e140a21691e1069413848", "7307c38dacce8a1df42b602edfe252d481f45b81ab4e834e0d925f8c");
        TestDigest.testKatHex(new Shabal224(), "64ec021c9585e01ffe6d31bb50d44c79b6993d72678163db474947a053674619d158016adb243f5c8d50aa92f50ab36e579ff2dabb780a2b529370daa299207cfbcdd3a9a25006d19c4f1fe33e4b1eaec315d8c6ee1e730623fd1941875b924eb57d6d0c2edc4e78d6", "caebe8fae98e63d9c35b41dafdf28b4c854e46b10b2e5c8651bbd814");
        TestDigest.testKatHex(new Shabal224(), "5954bab512cf327d66b5d9f296180080402624ad7628506b555eea8382562324cf452fba4a2130de3e165d11831a270d9cb97ce8c2d32a96f50d71600bb4ca268cf98e90d6496b0a6619a5a8c63db6d8a0634dfc6c7ec8ea9c006b6c456f1b20cd19e781af20454ac880", "6a24a0b09a0158589a41ef6df6f98bf3598a630648d1828557740dc8");
        TestDigest.testKatHex(new Shabal224(), "03d9f92b2c565709a568724a0aff90f8f347f43b02338f94a03ed32e6f33666ff5802da4c81bdce0d0e86c04afd4edc2fc8b4141c2975b6f07639b1994c973d9a9afce3d9d365862003498513bfa166d2629e314d97441667b007414e739d7febf0fe3c32c17aa188a8683", "ba659aef565deceacf05765b156c3136e337f0726fb4dff83a6996fd");
        TestDigest.testKatHex(new Shabal224(), "f31e8b4f9e0621d531d22a380be5d9abd56faec53cbd39b1fab230ea67184440e5b1d15457bd25f56204fa917fa48e669016cb48c1ffc1e1e45274b3b47379e00a43843cf8601a5551411ec12503e5aac43d8676a1b2297ec7a0800dbfee04292e937f21c005f17411473041", "d5a763cd7ca2ed3c0192c61874b21cd4261eac535a45df036334f1e2");
        TestDigest.testKatHex(new Shabal224(), "758ea3fea738973db0b8be7e599bbef4519373d6e6dcd7195ea885fc991d896762992759c2a09002912fb08e0cb5b76f49162aeb8cf87b172cf3ad190253df612f77b1f0c532e3b5fc99c2d31f8f65011695a087a35ee4eee5e334c369d8ee5d29f695815d866da99df3f79403", "18dbcb1f55f4884a3be756dbb230b1dd77f15047213ee284f3d4c198");
        TestDigest.testKatHex(new Shabal224(), "47c6e0c2b74948465921868804f0f7bd50dd323583dc784f998a93cd1ca4c6ef84d41dc81c2c40f34b5bee6a93867b3bdba0052c5f59e6f3657918c382e771d33109122cc8bb0e1e53c4e3d13b43ce44970f5e0c079d2ad7d7a3549cd75760c21bb15b447589e86e8d76b1e9ced2", "e31d9f53224236444be5b2fac309e28c3ffd54d65924cd4e28be568b");
        TestDigest.testKatHex(new Shabal224(), "f690a132ab46b28edfa6479283d6444e371c6459108afd9c35dbd235e0b6b6ff4c4ea58e7554bd002460433b2164ca51e868f7947d7d7a0d792e4abf0be5f450853cc40d85485b2b8857ea31b5ea6e4ccfa2f3a7ef3380066d7d8979fdac618aad3d7e886dea4f005ae4ad05e5065f", "fb35751fb79db26116bac474083024f16e5f705c49d2380373fa5437");
        TestDigest.testKatHex(new Shabal224(), "58d6a99bc6458824b256916770a8417040721cccfd4b79eacd8b65a3767ce5ba7e74104c985ac56b8cc9aebd16febd4cda5adb130b0ff2329cc8d611eb14dac268a2f9e633c99de33997fea41c52a7c5e1317d5b5daed35eba7d5a60e45d1fa7eaabc35f5c2b0a0f2379231953322c4e", "15cff736074fa7c90af614e4a920a820728f8a348349cf915a383a79");
        TestDigest.testKatHex(new Shabal224(), "befab574396d7f8b6705e2d5b58b2c1c820bb24e3f4bae3e8fbcd36dbf734ee14e5d6ab972aedd3540235466e825850ee4c512ea9795abfd33f330d9fd7f79e62bbb63a6ea85de15beaeea6f8d204a28956059e2632d11861dfb0e65bc07ac8a159388d5c3277e227286f65ff5e5b5aec1", "efab764f290cf7694b4627731e050309165e0e000946506062424fb9");
        TestDigest.testKatHex(new Shabal224(), "8e58144fa9179d686478622ce450c748260c95d1ba43b8f9b59abeca8d93488da73463ef40198b4d16fb0b0707201347e0506ff19d01bea0f42b8af9e71a1f1bd168781069d4d338fdef00bf419fbb003031df671f4a37979564f69282de9c65407847dd0da505ab1641c02dea4f0d834986", "f5d1b0b1dd127b50b28490594034850071640746a233989875b8f71b");
        TestDigest.testKatHex(new Shabal224(), "b55c10eae0ec684c16d13463f29291bf26c82e2fa0422a99c71db4af14dd9c7f33eda52fd73d017cc0f2dbe734d831f0d820d06d5f89dacc485739144f8cfd4799223b1aff9031a105cb6a029ba71e6e5867d85a554991c38df3c9ef8c1e1e9a7630be61caabca69280c399c1fb7a12d12aefc", "b683b327fd1af86f6aab07bf84dee8a57427568901722b36c0670b36");
        TestDigest.testKatHex(new Shabal224(), "2eeea693f585f4ed6f6f8865bbae47a6908aecd7c429e4bec4f0de1d0ca0183fa201a0cb14a529b7d7ac0e6ff6607a3243ee9fb11bcf3e2304fe75ffcddd6c5c2e2a4cd45f63c962d010645058d36571404a6d2b4f44755434d76998e83409c3205aa1615db44057db991231d2cb42624574f545", "0eccb42953d6ae48f341afe4172093543b1ef77ce2115ec4dbb71079");
        TestDigest.testKatHex(new Shabal224(), "dab11dc0b047db0420a585f56c42d93175562852428499f66a0db811fcdddab2f7cdffed1543e5fb72110b64686bc7b6887a538ad44c050f1e42631bc4ec8a9f2a047163d822a38989ee4aab01b4c1f161b062d873b1cfa388fd301514f62224157b9bef423c7783b7aac8d30d65cd1bba8d689c2d", "cab55d3c6d6041205550ad32a21d1f30871c24a0068791d3aa5449e1");
        TestDigest.testKatHex(new Shabal224(), "42e99a2f80aee0e001279a2434f731e01d34a44b1a8101726921c0590c30f3120eb83059f325e894a5ac959dca71ce2214799916424e859d27d789437b9d27240bf8c35adbafcecc322b48aa205b293962d858652abacbd588bcf6cbc388d0993bd622f96ed54614c25b6a9aa527589eaaffcf17ddf7", "3c61525fd9267cda2e450682e767f8e28d41951e5353fc2d169cd990");
        TestDigest.testKatHex(new Shabal224(), "3c9b46450c0f2cae8e3823f8bdb4277f31b744ce2eb17054bddc6dff36af7f49fb8a2320cc3bdf8e0a2ea29ad3a55de1165d219adeddb5175253e2d1489e9b6fdd02e2c3d3a4b54d60e3a47334c37913c5695378a669e9b72dec32af5434f93f46176ebf044c4784467c700470d0c0b40c8a088c815816", "d8883bffa85f00be8eb7f1b3a8fe6b4123b10d0689dc1f05ccb66e87");
        TestDigest.testKatHex(new Shabal224(), "d1e654b77cb155f5c77971a64df9e5d34c26a3cad6c7f6b300d39deb1910094691adaa095be4ba5d86690a976428635d5526f3e946f7dc3bd4dbc78999e653441187a81f9adcd5a3c5f254bc8256b0158f54673dcc1232f6e918ebfc6c51ce67eaeb042d9f57eec4bfe910e169af78b3de48d137df4f2840", "c5173d6b89fd84b7e3c5c81f11655c577e450524ccdde80561eb72a6");
        TestDigest.testKatHex(new Shabal224(), "626f68c18a69a6590159a9c46be03d5965698f2dac3de779b878b3d9c421e0f21b955a16c715c1ec1e22ce3eb645b8b4f263f60660ea3028981eebd6c8c3a367285b691c8ee56944a7cd1217997e1d9c21620b536bdbd5de8925ff71dec6fbc06624ab6b21e329813de90d1e572dfb89a18120c3f606355d25", "20e2826eaf9350934e1c9573cc14c91d98183ef67d1b4614b3cb4d01");
        TestDigest.testKatHex(new Shabal224(), "651a6fb3c4b80c7c68c6011675e6094eb56abf5fc3057324ebc6477825061f9f27e7a94633abd1fa598a746e4a577caf524c52ec1788471f92b8c37f23795ca19d559d446cab16cbcdce90b79fa1026cee77bf4ab1b503c5b94c2256ad75b3eac6fd5dcb96aca4b03a834bfb4e9af988cecbf2ae597cb9097940", "83f47c3e45da9ebe55a807d122eadfbda659b94c4e8298ff0f54aea0");
        TestDigest.testKatHex(new Shabal224(), "8aaf072fce8a2d96bc10b3c91c809ee93072fb205ca7f10abd82ecd82cf040b1bc49ea13d1857815c0e99781de3adbb5443ce1c897e55188ceaf221aa9681638de05ae1b322938f46bce51543b57ecdb4c266272259d1798de13be90e10efec2d07484d9b21a3870e2aa9e06c21aa2d0c9cf420080a80a91dee16f", "ab7721d321ea6e5b4c95ea45bb96c133bb4bfeb64695869f1e6f6f57");
        TestDigest.testKatHex(new Shabal224(), "53f918fd00b1701bd504f8cdea803acca21ac18c564ab90c2a17da592c7d69688f6580575395551e8cd33e0fef08ca6ed4588d4d140b3e44c032355df1c531564d7f4835753344345a6781e11cd5e095b73df5f82c8ae3ad00877936896671e947cc52e2b29dcd463d90a0c9929128da222b5a211450bbc0e02448e2", "14eab01b8780da695493186dbe2f9c153677adf2e3cf5b39554d62ca");
        TestDigest.testKatHex(new Shabal224(), "a64599b8a61b5ccec9e67aed69447459c8da3d1ec6c7c7c82a7428b9b584fa67e90f68e2c00fbbed4613666e5168da4a16f395f7a3c3832b3b134bfc9cbaa95d2a0fe252f44ac6681eb6d40ab91c1d0282fed6701c57463d3c5f2bb8c6a7301fb4576aa3b5f15510db8956ff77478c26a7c09bea7b398cfc83503f538e", "82c6f0ab3415146c203a89212fbc6cfe7a0d353ec593227200b9dce2");
        TestDigest.testKatHex(new Shabal224(), "0e3ab0e054739b00cdb6a87bd12cae024b54cb5e550e6c425360c2e87e59401f5ec24ef0314855f0f56c47695d56a7fb1417693af2a1ed5291f2fee95f75eed54a1b1c2e81226fbff6f63ade584911c71967a8eb70933bc3f5d15bc91b5c2644d9516d3c3a8c154ee48e118bd1442c043c7a0dba5ac5b1d5360aae5b9065", "83a4e2cdd410db7e9e5f65cc1924f932d12236d49d0cc3547213f525");
        TestDigest.testKatHex(new Shabal224(), "a62fc595b4096e6336e53fcdfc8d1cc175d71dac9d750a6133d23199eaac288207944cea6b16d27631915b4619f743da2e30a0c00bbdb1bbb35ab852ef3b9aec6b0a8dcc6e9e1abaa3ad62ac0a6c5de765de2c3711b769e3fde44a74016fff82ac46fa8f1797d3b2a726b696e3dea5530439acee3a45c2a51bc32dd055650b", "ad8966767488bd49c9d84d1a112e48e7baf243f0668ac6bca3c15df5");
        TestDigest.testKatHex(new Shabal224(), "2b6db7ced8665ebe9deb080295218426bdaa7c6da9add2088932cdffbaa1c14129bccdd70f369efb149285858d2b1d155d14de2fdb680a8b027284055182a0cae275234cc9c92863c1b4ab66f304cf0621cd54565f5bff461d3b461bd40df28198e3732501b4860eadd503d26d6e69338f4e0456e9e9baf3d827ae685fb1d817", "7868d08191da62938d904835ef709310617d51d5d59cfaa63b2ec5a3");
        TestDigest.testKatHex(new Shabal224(), "10db509b2cdcaba6c062ae33be48116a29eb18e390e1bbada5ca0a2718afbcd23431440106594893043cc7f2625281bf7de2655880966a23705f0c5155c2f5cca9f2c2142e96d0a2e763b70686cd421b5db812daced0c6d65035fde558e94f26b3e6dde5bd13980cc80292b723013bd033284584bff27657871b0cf07a849f4ae2", "99ffe9106b948ba712c0a44d4ca74a76e2e0993f2c31c4a94162a8d6");
        TestDigest.testKatHex(new Shabal224(), "9334de60c997bda6086101a6314f64e4458f5ff9450c509df006e8c547983c651ca97879175aaba0c539e82d05c1e02c480975cbb30118121061b1ebac4f8d9a3781e2db6b18042e01ecf9017a64a0e57447ec7fcbe6a7f82585f7403ee2223d52d37b4bf426428613d6b4257980972a0acab508a7620c1cb28eb4e9d30fc41361ec", "65dadb57eabdc3fdf38da0ab9095a567c657b76e5440988b0ecfc2b3");
        TestDigest.testKatHex(new Shabal224(), "e88ab086891693aa535ceb20e64c7ab97c7dd3548f3786339897a5f0c39031549ca870166e477743ccfbe016b4428d89738e426f5ffe81626137f17aecff61b72dbee2dc20961880cfe281dfab5ee38b1921881450e16032de5e4d55ad8d4fca609721b0692bac79be5a06e177fe8c80c0c83519fb3347de9f43d5561cb8107b9b5edc", "f5779c4ca19a080bdf55a6df0a62332b5eb402d2489abdf3451a68a3");
        TestDigest.testKatHex(new Shabal224(), "fd19e01a83eb6ec810b94582cb8fbfa2fcb992b53684fb748d2264f020d3b960cb1d6b8c348c2b54a9fcea72330c2aaa9a24ecdb00c436abc702361a82bb8828b85369b8c72ece0082fe06557163899c2a0efa466c33c04343a839417057399a63a3929be1ee4805d6ce3e5d0d0967fe9004696a5663f4cac9179006a2ceb75542d75d68", "0fe07cf7edd4b3f2db65e9fae75d459b928b98dc0144a518a7d78de5");
        TestDigest.testKatHex(new Shabal224(), "59ae20b6f7e0b3c7a989afb28324a40fca25d8651cf1f46ae383ef6d8441587aa1c04c3e3bf88e8131ce6145cfb8973d961e8432b202fa5af3e09d625faad825bc19da9b5c6c20d02abda2fcc58b5bd3fe507bf201263f30543819510c12bc23e2ddb4f711d087a86edb1b355313363a2de996b891025e147036087401ccf3ca7815bf3c49", "9245169c738114a6c6df8354d479dd0fa3529099154cd7637d6949d3");
        TestDigest.testKatHex(new Shabal224(), "77ee804b9f3295ab2362798b72b0a1b2d3291dceb8139896355830f34b3b328561531f8079b79a6e9980705150866402fdc176c05897e359a6cb1a7ab067383eb497182a7e5aef7038e4c96d133b2782917417e391535b5e1b51f47d8ed7e4d4025fe98dc87b9c1622614bff3d1029e68e372de719803857ca52067cddaad958951cb2068cc6", "80d14b08da34eb4e17fac4c7f04987159d5ca2570c1ab907720db49a");
        TestDigest.testKatHex(new Shabal224(), "b771d5cef5d1a41a93d15643d7181d2a2ef0a8e84d91812f20ed21f147bef732bf3a60ef4067c3734b85bc8cd471780f10dc9e8291b58339a677b960218f71e793f2797aea349406512829065d37bb55ea796fa4f56fd8896b49b2cd19b43215ad967c712b24e5032d065232e02c127409d2ed4146b9d75d763d52db98d949d3b0fed6a8052fbb", "dce4d28953b4de06c061c2de55fec701abdb54f2edd00b854aa06614");
        TestDigest.testKatHex(new Shabal224(), "b32d95b0b9aad2a8816de6d06d1f86008505bd8c14124f6e9a163b5a2ade55f835d0ec3880ef50700d3b25e42cc0af050ccd1be5e555b23087e04d7bf9813622780c7313a1954f8740b6ee2d3f71f768dd417f520482bd3a08d4f222b4ee9dbd015447b33507dd50f3ab4247c5de9a8abd62a8decea01e3b87c8b927f5b08beb37674c6f8e380c04", "703f1bbc385bddbdfa63f9a17d42f999a8358adbcd829667ec847780");
        TestDigest.testKatHex(new Shabal224(), "04410e31082a47584b406f051398a6abe74e4da59bb6f85e6b49e8a1f7f2ca00dfba5462c2cd2bfde8b64fb21d70c083f11318b56a52d03b81cac5eec29eb31bd0078b6156786da3d6d8c33098c5c47bb67ac64db14165af65b44544d806dde5f487d5373c7f9792c299e9686b7e5821e7c8e2458315b996b5677d926dac57b3f22da873c601016a0d", "b23afdf450f3090d7a787ef3613999b2ea6458b7bcd544ef5f4a7f36");
        TestDigest.testKatHex(new Shabal224(), "8b81e9badde026f14d95c019977024c9e13db7a5cd21f9e9fc491d716164bbacdc7060d882615d411438aea056c340cdf977788f6e17d118de55026855f93270472d1fd18b9e7e812bae107e0dfde7063301b71f6cfe4e225cab3b232905a56e994f08ee2891ba922d49c3dafeb75f7c69750cb67d822c96176c46bd8a29f1701373fb09a1a6e3c7158f", "931b553a758a8bca37caa36adb2068be0b4809b1154ad92c62a08789");
        TestDigest.testKatHex(new Shabal224(), "fa6eed24da6666a22208146b19a532c2ec9ba94f09f1def1e7fc13c399a48e41acc2a589d099276296348f396253b57cb0e40291bd282773656b6e0d8bea1cda084a3738816a840485fcf3fb307f777fa5feac48695c2af4769720258c77943fb4556c362d9cba8bf103aeb9034baa8ea8bfb9c4f8e6742ce0d52c49ea8e974f339612e830e9e7a9c29065", "e1d460f561ee70eab09014e5d1d31d20d28a87539af48d26a9330802");
        TestDigest.testKatHex(new Shabal224(), "9bb4af1b4f09c071ce3cafa92e4eb73ce8a6f5d82a85733440368dee4eb1cbc7b55ac150773b6fe47dbe036c45582ed67e23f4c74585dab509df1b83610564545642b2b1ec463e18048fc23477c6b2aa035594ecd33791af6af4cbc2a1166aba8d628c57e707f0b0e8707caf91cd44bdb915e0296e0190d56d33d8dde10b5b60377838973c1d943c22ed335e", "3dedbcfd6cd84b319a46050ebbb09a7b9f6b40b2b3966d6d276745c8");
        TestDigest.testKatHex(new Shabal224(), "2167f02118cc62043e9091a647cadbed95611a521fe0d64e8518f16c808ab297725598ae296880a773607a798f7c3cfce80d251ebec6885015f9abf7eaabae46798f82cb5926de5c23f44a3f9f9534b3c6f405b5364c2f8a8bdc5ca49c749bed8ce4ba48897062ae8424ca6dde5f55c0e42a95d1e292ca54fb46a84fbc9cd87f2d0c9e7448de3043ae22fdd229", "30f91d79e5adcee3fb1ec02c85b76b0bd4f614359cdcec317391f80c");
        TestDigest.testKatHex(new Shabal224(), "94b7fa0bc1c44e949b1d7617d31b4720cbe7ca57c6fa4f4094d4761567e389ecc64f6968e4064df70df836a47d0c713336b5028b35930d29eb7a7f9a5af9ad5cf441745baec9bb014ceeff5a41ba5c1ce085feb980bab9cf79f2158e03ef7e63e29c38d7816a84d4f71e0f548b7fc316085ae38a060ff9b8dec36f91ad9ebc0a5b6c338cbb8f6659d342a24368cf", "ac258279a720d384613ea2142a8c4edcd562d947ae9366d57f179ca9");
        TestDigest.testKatHex(new Shabal224(), "ea40e83cb18b3a242c1ecc6ccd0b7853a439dab2c569cfc6dc38a19f5c90acbf76aef9ea3742ff3b54ef7d36eb7ce4ff1c9ab3bc119cff6be93c03e208783335c0ab8137be5b10cdc66ff3f89a1bddc6a1eed74f504cbe7290690bb295a872b9e3fe2cee9e6c67c41db8efd7d863cf10f840fe618e7936da3dca5ca6df933f24f6954ba0801a1294cd8d7e66dfafec", "7176dce7cfd4151246d515c74f36d71490d753626e118ed95c6d13a3");
        TestDigest.testKatHex(new Shabal224(), "157d5b7e4507f66d9a267476d33831e7bb768d4d04cc3438da12f9010263ea5fcafbde2579db2f6b58f911d593d5f79fb05fe3596e3fa80ff2f761d1b0e57080055c118c53e53cdb63055261d7c9b2b39bd90acc32520cbbdbda2c4fd8856dbcee173132a2679198daf83007a9b5c51511ae49766c792a29520388444ebefe28256fb33d4260439cba73a9479ee00c63", "1aa195c8d7a04a93868a40b184c2f6856e1541fe5efc8acc785df343");
        TestDigest.testKatHex(new Shabal224(), "836b34b515476f613fe447a4e0c3f3b8f20910ac89a3977055c960d2d5d2b72bd8acc715a9035321b86703a411dde0466d58a59769672aa60ad587b8481de4bba552a1645779789501ec53d540b904821f32b0bd1855b04e4848f9f8cfe9ebd8911be95781a759d7ad9724a7102dbe576776b7c632bc39b9b5e19057e226552a5994c1dbb3b5c7871a11f5537011044c53", "2dc57dab12f14a15c91686eb7214b987d1c39cfe4d1567681c5e1ed2");
        TestDigest.testKatHex(new Shabal224(), "cc7784a4912a7ab5ad3620aab29ba87077cd3cb83636adc9f3dc94f51edf521b2161ef108f21a0a298557981c0e53ce6ced45bdf782c1ef200d29bab81dd6460586964edab7cebdbbec75fd7925060f7da2b853b2b089588fa0f8c16ec6498b14c55dcee335cb3a91d698e4d393ab8e8eac0825f8adebeee196df41205c011674e53426caa453f8de1cbb57932b0b741d4c6", "42280107dd395261c3b3e40e1ef07ad1e94be7d71bc8907b719fd541");
        TestDigest.testKatHex(new Shabal224(), "7639b461fff270b2455ac1d1afce782944aea5e9087eb4a39eb96bb5c3baaf0e868c8526d3404f9405e79e77bfac5ffb89bf1957b523e17d341d7323c302ea7083872dd5e8705694acdda36d5a1b895aaa16eca6104c82688532c8bfe1790b5dc9f4ec5fe95baed37e1d287be710431f1e5e8ee105bc42ed37d74b1e55984bf1c09fe6a1fa13ef3b96faeaed6a2a1950a12153", "b97b2fec0f9d3c5ea1abc72b6472d7e5c6c59ee00e5daa46e620e119");
        TestDigest.testKatHex(new Shabal224(), "eb6513fc61b30cfba58d4d7e80f94d14589090cf1d80b1df2e68088dc6104959ba0d583d585e9578ab0aec0cf36c48435eb52ed9ab4bbce7a5abe679c97ae2dbe35e8cc1d45b06dda3cf418665c57cbee4bbb47fa4caf78f4ee656fec237fe4eebbafa206e1ef2bd0ee4ae71bd0e9b2f54f91daadf1febfd7032381d636b733dcb3bf76fb14e23aff1f68ed3dbcf75c9b99c6f26", "0300b0084b49617d14edfe40cb2ab4dd228f942d839aa0e79d01b999");
        TestDigest.testKatHex(new Shabal224(), "1594d74bf5dde444265d4c04dad9721ff3e34cbf622daf341fe16b96431f6c4df1f760d34f296eb97d98d560ad5286fec4dce1724f20b54fd7df51d4bf137add656c80546fb1bf516d62ee82baa992910ef4cc18b70f3f8698276fcfb44e0ec546c2c39cfd8ee91034ff9303058b4252462f86c823eb15bf481e6b79cc3a02218595b3658e8b37382bd5048eaed5fd02c37944e73b", "a6a86047d86b9ebb1897923fa876dcd4665053a91e107671915eb689");
        TestDigest.testKatHex(new Shabal224(), "4cfa1278903026f66fedd41374558be1b585d03c5c55dac94361df286d4bd39c7cb8037ed3b267b07c346626449d0cc5b0dd2cf221f7e4c3449a4be99985d2d5e67bff2923357ddeab5abcb4619f3a3a57b2cf928a022eb27676c6cf805689004fca4d41ea6c2d0a4789c7605f7bb838dd883b3ad3e6027e775bcf262881428099c7fff95b14c095ea130e0b9938a5e22fc52650f591", "58462559263317231bbc78ee69aee864d411ed86ff563ed7f0f403ba");
        TestDigest.testKatHex(new Shabal224(), "d3e65cb92cfa79662f6af493d696a07ccf32aaadcceff06e73e8d9f6f909209e66715d6e978788c49efb9087b170ecf3aa86d2d4d1a065ae0efc8924f365d676b3cb9e2bec918fd96d0b43dee83727c9a93bf56ca2b2e59adba85696546a815067fc7a78039629d4948d157e7b0d826d1bf8e81237bab7321312fdaa4d521744f988db6fdf04549d0fdca393d639c729af716e9c8bba48", "a3d17a61d2ef2d427c9036bcc594e7202341ae25f28c6e4612263fb2");
        TestDigest.testKatHex(new Shabal224(), "842cc583504539622d7f71e7e31863a2b885c56a0ba62db4c2a3f2fd12e79660dc7205ca29a0dc0a87db4dc62ee47a41db36b9ddb3293b9ac4baae7df5c6e7201e17f717ab56e12cad476be49608ad2d50309e7d48d2d8de4fa58ac3cfeafeee48c0a9eec88498e3efc51f54d300d828dddccb9d0b06dd021a29cf5cb5b2506915beb8a11998b8b886e0f9b7a80e97d91a7d01270f9a7717", "fb052469f4b40d480766e9dcd0666931eae30ebf76d81e26a8cb3608");
        TestDigest.testKatHex(new Shabal224(), "6c4b0a0719573e57248661e98febe326571f9a1ca813d3638531ae28b4860f23c3a3a8ac1c250034a660e2d71e16d3acc4bf9ce215c6f15b1c0fc7e77d3d27157e66da9ceec9258f8f2bf9e02b4ac93793dd6e29e307ede3695a0df63cbdc0fc66fb770813eb149ca2a916911bee4902c47c7802e69e405fe3c04ceb5522792a5503fa829f707272226621f7c488a7698c0d69aa561be9f378", "6c6bac2c44df2995f9b3755aa35971f1fd1ff6f70d047f2f5191f691");
        TestDigest.testKatHex(new Shabal224(), "51b7dbb7ce2ffeb427a91ccfe5218fd40f9e0b7e24756d4c47cd55606008bdc27d16400933906fd9f30effdd4880022d081155342af3fb6cd53672ab7fb5b3a3bcbe47be1fd3a2278cae8a5fd61c1433f7d350675dd21803746cadca574130f01200024c6340ab0cc2cf74f2234669f34e9009ef2eb94823d62b31407f4ba46f1a1eec41641e84d77727b59e746b8a671bef936f05be820759fa", "a0317506299dd44b8b69a08a4ff12cb5c8061836063ce92870c0d0a5");
        TestDigest.testKatHex(new Shabal224(), "83599d93f5561e821bd01a472386bc2ff4efbd4aed60d5821e84aae74d8071029810f5e286f8f17651cd27da07b1eb4382f754cd1c95268783ad09220f5502840370d494beb17124220f6afce91ec8a0f55231f9652433e5ce3489b727716cf4aeba7dcda20cd29aa9a859201253f948dd94395aba9e3852bd1d60dda7ae5dc045b283da006e1cbad83cc13292a315db5553305c628dd091146597", "702d5bc72124606e3b8bd88a5c21b016234d2f44ab102e407f7a36ff");
        TestDigest.testKatHex(new Shabal224(), "2be9bf526c9d5a75d565dd11ef63b979d068659c7f026c08bea4af161d85a462d80e45040e91f4165c074c43ac661380311a8cbed59cc8e4c4518e80cd2c78ab1cabf66bff83eab3a80148550307310950d034a6286c93a1ece8929e6385c5e3bb6ea8a7c0fb6d6332e320e71cc4eb462a2a62e2bfe08f0ccad93e61bedb5dd0b786a728ab666f07e0576d189c92bf9fb20dca49ac2d3956d47385e2", "b6c9412291fb51ad588b432fc9ce8bb1636c802d16fa612f79a1d6f5");
        TestDigest.testKatHex(new Shabal224(), "ca76d3a12595a817682617006848675547d3e8f50c2210f9af906c0e7ce50b4460186fe70457a9e879e79fd4d1a688c70a347361c847ba0dd6aa52936eaf8e58a1be2f5c1c704e20146d366aeb3853bed9de9befe9569ac8aaea37a9fb7139a1a1a7d5c748605a8defb297869ebedd71d615a5da23496d11e11abbb126b206fa0a7797ee7de117986012d0362dcef775c2fe145ada6bda1ccb326bf644", "7cbcb596c75262bed84447aac6d8420fd0a4707b3fa7e4f180453b9a");
        TestDigest.testKatHex(new Shabal224(), "f76b85dc67421025d64e93096d1d712b7baf7fb001716f02d33b2160c2c882c310ef13a576b1c2d30ef8f78ef8d2f465007109aad93f74cb9e7d7bef7c9590e8af3b267c89c15db238138c45833c98cc4a471a7802723ef4c744a853cf80a0c2568dd4ed58a2c9644806f42104cee53628e5bdf7b63b0b338e931e31b87c24b146c6d040605567ceef5960df9e022cb469d4c787f4cba3c544a1ac91f95f", "5c5080f58976334c8c838e595410ae2fae0c7a295683a10e33532a29");
        TestDigest.testKatHex(new Shabal224(), "25b8c9c032ea6bcd733ffc8718fbb2a503a4ea8f71dea1176189f694304f0ff68e862a8197b839957549ef243a5279fc2646bd4c009b6d1edebf24738197abb4c992f6b1dc9ba891f570879accd5a6b18691a93c7d0a8d38f95b639c1daeb48c4c2f15ccf5b9d508f8333c32de78781b41850f261b855c4bebcc125a380c54d501c5d3bd07e6b52102116088e53d76583b0161e2a58d0778f091206aabd5a1", "587f13c0ecf77ddb86c3f0f37c3cd7e24791e774d050e6ff08abc3dc");
        TestDigest.testKatHex(new Shabal224(), "21cfdc2a7ccb7f331b3d2eefff37e48ad9fa9c788c3f3c200e0173d99963e1cbca93623b264e920394ae48bb4c3a5bb96ffbc8f0e53f30e22956adabc2765f57fb761e147ecbf8567533db6e50c8a1f894310a94edf806dd8ca6a0e141c0fa7c9fae6c6ae65f18c93a8529e6e5b553bf55f25be2e80a9882bd37f145fecbeb3d447a3c4e46c21524cc55cdd62f521ab92a8ba72b897996c49bb273198b7b1c9e", "52152244306dd10b897adea3d4297384773d260162ace1eab9609195");
        TestDigest.testKatHex(new Shabal224(), "4e452ba42127dcc956ef4f8f35dd68cb225fb73b5bc7e1ec5a898bba2931563e74faff3b67314f241ec49f4a7061e3bd0213ae826bab380f1f14faab8b0efddd5fd1bb49373853a08f30553d5a55ccbbb8153de4704f29ca2bdeef0419468e05dd51557ccc80c0a96190bbcc4d77ecff21c66bdf486459d427f986410f883a80a5bcc32c20f0478bb9a97a126fc5f95451e40f292a4614930d054c851acd019ccf", "2c5daf16a3eac9bd37ea9789e464553094005a31c8aa8dc9d2da1ba4");
        TestDigest.testKatHex(new Shabal224(), "fa85671df7dadf99a6ffee97a3ab9991671f5629195049880497487867a6c446b60087fac9a0f2fcc8e3b24e97e42345b93b5f7d3691829d3f8ccd4bb36411b85fc2328eb0c51cb3151f70860ad3246ce0623a8dc8b3c49f958f8690f8e3860e71eb2b1479a5cea0b3f8befd87acaf5362435eaeccb52f38617bc6c5c2c6e269ead1fbd69e941d4ad2012da2c5b21bcfbf98e4a77ab2af1f3fda3233f046d38f1dc8", "f76c04392a7021e6ebddf7818df24e6e23e4b2edab9eaba1dc40f264");
        TestDigest.testKatHex(new Shabal224(), "e90847ae6797fbc0b6b36d6e588c0a743d725788ca50b6d792352ea8294f5ba654a15366b8e1b288d84f5178240827975a763bc45c7b0430e8a559df4488505e009c63da994f1403f407958203cebb6e37d89c94a5eacf6039a327f6c4dbbc7a2a307d976aa39e41af6537243fc218dfa6ab4dd817b6a397df5ca69107a9198799ed248641b63b42cb4c29bfdd7975ac96edfc274ac562d0474c60347a078ce4c25e88", "89823d7f798bde72f25d6c035acda0685d93ba8909ccaa27f954ac76");
        TestDigest.testKatHex(new Shabal224(), "f6d5c2b6c93954fc627602c00c4ca9a7d3ed12b27173f0b2c9b0e4a5939398a665e67e69d0b12fb7e4ceb253e8083d1ceb724ac07f009f094e42f2d6f2129489e846eaff0700a8d4453ef453a3eddc18f408c77a83275617fabc4ea3a2833aa73406c0e966276079d38e8e38539a70e194cc5513aaa457c699383fd1900b1e72bdfb835d1fd321b37ba80549b078a49ea08152869a918ca57f5b54ed71e4fd3ac5c06729", "74e8c747cf57dad1b7e338ed5ce0ff5b03e79dd186b2119a22ca3139");
        TestDigest.testKatHex(new Shabal224(), "cf8562b1bed89892d67ddaaf3deeb28246456e972326dbcdb5cf3fb289aca01e68da5d59896e3a6165358b071b304d6ab3d018944be5049d5e0e2bb819acf67a6006111089e6767132d72dd85beddcbb2d64496db0cc92955ab4c6234f1eea24f2d51483f2e209e4589bf9519fac51b4d061e801125e605f8093bb6997bc163d551596fe4ab7cfae8fb9a90f6980480ce0c229fd1675409bd788354daf316240cfe0af93eb", "b7c93be1f42b9926359e230c06a4eedf82be77bb9024ae7e44cb280f");
        TestDigest.testKatHex(new Shabal224(), "2ace31abb0a2e3267944d2f75e1559985db7354c6e605f18dc8470423fca30b7331d9b33c4a4326783d1caae1b4f07060eff978e4746bf0c7e30cd61040bd5ec2746b29863eb7f103ebda614c4291a805b6a4c8214230564a0557bc7102e0bd3ed23719252f7435d64d210ee2aafc585be903fa41e1968c50fd5d5367926df7a05e3a42cf07e656ff92de73b036cf8b19898c0cb34557c0c12c2d8b84e91181af467bc75a9d1", "4a38479074a7d90efa354324af770f703aa48df87689a016e6c1ad6d");
        TestDigest.testKatHex(new Shabal224(), "0d8d09aed19f1013969ce5e7eb92f83a209ae76be31c754844ea9116ceb39a22ebb6003017bbcf26555fa6624185187db8f0cb3564b8b1c06bf685d47f3286eda20b83358f599d2044bbf0583fab8d78f854fe0a596183230c5ef8e54426750eaf2cc4e29d3bdd037e734d863c2bd9789b4c243096138f7672c232314effdfc6513427e2da76916b5248933be312eb5dde4cf70804fb258ac5fb82d58d08177ac6f4756017fff5", "cedd999972c155ebc63f6cba79dc791bff217bb2129d382398153231");
        TestDigest.testKatHex(new Shabal224(), "c3236b73deb7662bf3f3daa58f137b358ba610560ef7455785a9befdb035a066e90704f929bd9689cef0ce3bda5acf4480bceb8d09d10b098ad8500d9b6071dfc3a14af6c77511d81e3aa8844986c3bea6f469f9e02194c92868cd5f51646256798ff0424954c1434bdfed9facb390b07d342e992936e0f88bfd0e884a0ddb679d0547ccdec6384285a45429d115ac7d235a717242021d1dc35641f5f0a48e8445dba58e6cb2c8ea", "6046682438bc6e9635dfceb6ada7f3afa06b70ce5626e1d7d369251b");
        TestDigest.testKatHex(new Shabal224(), "b39feb8283eadc63e8184b51df5ae3fd41aac8a963bb0be1cd08aa5867d8d910c669221e73243360646f6553d1ca05a84e8dc0de05b6419ec349ca994480193d01c92525f3fb3dcefb08afc6d26947bdbbfd85193f53b50609c6140905c53a6686b58e53a319a57b962331ede98149af3de3118a819da4d76706a0424b4e1d2910b0ed26af61d150ebcb46595d4266a0bd7f651ba47d0c7f179ca28545007d92e8419d48fdfbd744ce", "b8f8186674f5648796ddb29c720bfb533090c6d1206dfe8e3e2bea53");
        TestDigest.testKatHex(new Shabal224(), "a983d54f503803e8c7999f4edbbe82e9084f422143a932ddddc47a17b0b7564a7f37a99d0786e99476428d29e29d3c197a72bfab1342c12a0fc4787fd7017d7a6174049ea43b5779169ef7472bdbbd941dcb82fc73aac45a8a94c9f2bd3477f61fd3b796f02a1b8264a214c6fea74b7051b226c722099ec7883a462b83b6afdd4009248b8a237f605fe5a08fe7d8b45321421ebba67bd70a0b00ddbf94baab7f359d5d1eea105f28dcfb", "58ae96400e5bbb886c429a6c2734be96f97ec29f3b6dd5b5a27f093f");
        TestDigest.testKatHex(new Shabal224(), "e4d1c1897a0a866ce564635b74222f9696bf2c7f640dd78d7e2aca66e1b61c642bb03ea7536aae597811e9bf4a7b453ede31f97b46a5f0ef51a071a2b3918df16b152519ae3776f9f1edab4c2a377c3292e96408359d3613844d5eb393000283d5ad3401a318b12fd1474b8612f2bb50fb6a8b9e023a54d7dde28c43d6d8854c8d9d1155935c199811dbfc87e9e0072e90eb88681cc7529714f8fb8a2c9d88567adfb974ee205a9bf7b848", "ef1f62b64a98203b27fbc1a60650fc3de63cd6988d9224f49ea05bd6");
        TestDigest.testKatHex(new Shabal224(), "b10c59723e3dcadd6d75df87d0a1580e73133a9b7d00cb95ec19f5547027323be75158b11f80b6e142c6a78531886d9047b08e551e75e6261e79785366d7024bd7cd9cf322d9be7d57fb661069f2481c7bb759cd71b4b36ca2bc2df6d3a328faebdb995a9794a8d72155ed551a1f87c80bf6059b43fc764900b18a1c2441f7487743cf84e565f61f8dd2ece6b6ccc9444049197aaaf53e926fbee3bfca8be588ec77f29d211be89de18b15f6", "dadb43e1d381fbb1fe00248efd4a782db1ff0d446d8f66467a3aaadd");
        TestDigest.testKatHex(new Shabal224(), "db11f609baba7b0ca634926b1dd539c8cbada24967d7add4d9876f77c2d80c0f4dcefbd7121548373582705cca2495bd2a43716fe64ed26d059cfb566b3364bd49ee0717bdd9810dd14d8fad80dbbdc4cafb37cc60fb0fe2a80fb4541b8ca9d59dce457738a9d3d8f641af8c3fd6da162dc16fc01aac527a4a0255b4d231c0be50f44f0db0b713af03d968fe7f0f61ed0824c55c4b5265548febd6aad5c5eedf63efe793489c39b8fd29d104ce", "41e13635832c6149b22b065a04f47ca6ea22447a0460709e038ef525");
        TestDigest.testKatHex(new Shabal224(), "bebd4f1a84fc8b15e4452a54bd02d69e304b7f32616aadd90537937106ae4e28de9d8aab02d19bc3e2fde1d651559e296453e4dba94370a14dbbb2d1d4e2022302ee90e208321efcd8528ad89e46dc839ea9df618ea8394a6bff308e7726bae0c19bcd4be52da6258e2ef4e96aa21244429f49ef5cb486d7ff35cac1bacb7e95711944bccb2ab34700d42d1eb38b5d536b947348a458ede3dc6bd6ec547b1b0cae5b257be36a7124e1060c170ffa", "41266c32c08fdda6588d1ffa8131bf69ac554e8ed0c71db82a6a8942");
        TestDigest.testKatHex(new Shabal224(), "5aca56a03a13784bdc3289d9364f79e2a85c12276b49b92db0adaa4f206d5028f213f678c3510e111f9dc4c1c1f8b6acb17a6413aa227607c515c62a733817ba5e762cc6748e7e0d6872c984d723c9bb3b117eb8963185300a80bfa65cde495d70a46c44858605fccbed086c2b45cef963d33294dbe9706b13af22f1b7c4cd5a001cfec251fba18e722c6e1c4b1166918b4f6f48a98b64b3c07fc86a6b17a6d0480ab79d4e6415b520f1c484d675b1", "6d7debd7f95e2c5ae01a02497db3af07df2d5461f9d468c99361bca2");
        TestDigest.testKatHex(new Shabal224(), "a5aad0e4646a32c85cfcac73f02fc5300f1982fabb2f2179e28303e447854094cdfc854310e5c0f60993ceff54d84d6b46323d930adb07c17599b35b505f09e784bca5985e0172257797fb53649e2e9723efd16865c31b5c3d5113b58bb0bfc8920fabdda086d7537e66d709d050bd14d0c960873f156fad5b3d3840cdfcdc9be6af519db262a27f40896ab25cc39f96984d650611c0d5a3080d5b3a1bf186abd42956588b3b58cd948970d298776060", "f80d36cc35dd661b36536a168b708ad137da59afca89cfe39d028e2d");
        TestDigest.testKatHex(new Shabal224(), "06cbbe67e94a978203ead6c057a1a5b098478b4b4cbef5a97e93c8e42f5572713575fc2a884531d7622f8f879387a859a80f10ef02708cd8f7413ab385afc357678b9578c0ebf641ef076a1a30f1f75379e9dcb2a885bdd295905ee80c0168a62a9597d10cf12dd2d8cee46645c7e5a141f6e0e23aa482abe5661c16e69ef1e28371e2e236c359ba4e92c25626a7b7ff13f6ea4ae906e1cfe163e91719b1f750a96cbde5fbc953d9e576cd216afc90323a", "ca5bd105256dec050ce91fb37aaa15c6be4685fe9ba9efbd74fdd600");
        TestDigest.testKatHex(new Shabal224(), "f1c528cf7739874707d4d8ad5b98f7c77169de0b57188df233b2dc8a5b31eda5db4291dd9f68e6bad37b8d7f6c9c0044b3bf74bbc3d7d1798e138709b0d75e7c593d3cccdc1b20c7174b4e692add820ace262d45ccfae2077e878796347168060a162ecca8c38c1a88350bd63bb539134f700fd4addd5959e255337daa06bc86358fabcbefdfb5bc889783d843c08aadc6c4f6c36f65f156e851c9a0f917e4a367b5ad93d874812a1de6a7b93cd53ad97232", "817fe01c933a5bc9c8c0ac2bd1bdecf4fc2c76666dfa7d9959f7afb4");
        TestDigest.testKatHex(new Shabal224(), "9d9f3a7ecd51b41f6572fd0d0881e30390dfb780991dae7db3b47619134718e6f987810e542619dfaa7b505c76b7350c6432d8bf1cfebdf1069b90a35f0d04cbdf130b0dfc7875f4a4e62cdb8e525aadd7ce842520a482ac18f09442d78305fe85a74e39e760a4837482ed2f437dd13b2ec1042afcf9decdc3e877e50ff4106ad10a525230d11920324a81094da31deab6476aa42f20c84843cfc1c58545ee80352bdd3740dd6a16792ae2d86f11641bb717c2", "af1980b9e3973455c398f370844b5190b31bb31504c12467575e1987");
        TestDigest.testKatHex(new Shabal224(), "5179888724819fbad3afa927d3577796660e6a81c52d98e9303261d5a4a83232f6f758934d50aa83ff9e20a5926dfebaac49529d006eb923c5ae5048ed544ec471ed7191edf46363383824f915769b3e688094c682b02151e5ee01e510b431c8865aff8b6b6f2f59cb6d129da79e97c6d2b8fa6c6da3f603199d2d1bcab547682a81cd6cf65f6551121391d78bcc23b5bd0e922ec6d8bf97c952e84dd28aef909aba31edb903b28fbfc33b7703cd996215a11238", "0d94f1fc968d168d6668d6cdda15b64309d28a9f6327585ea86efe2b");
        TestDigest.testKatHex(new Shabal224(), "576ef3520d30b7a4899b8c0d5e359e45c5189add100e43be429a02fb3de5ff4f8fd0e79d9663acca72cd29c94582b19292a557c5b1315297d168fbb54e9e2ecd13809c2b5fce998edc6570545e1499dbe7fb74d47cd7f35823b212b05bf3f5a79caa34224fdd670d335fcb106f5d92c3946f44d3afcbae2e41ac554d8e6759f332b76be89a0324aa12c5482d1ea3ee89ded4936f3e3c080436f539fa137e74c6d3389bdf5a45074c47bc7b20b0948407a66d855e2f", "70793eb6c467ef932dfa6237fcbdf302b39764721821b9377a393d67");
        TestDigest.testKatHex(new Shabal224(), "0df2152fa4f4357c8741529dd77e783925d3d76e95bafa2b542a2c33f3d1d117d159cf473f82310356fee4c90a9e505e70f8f24859656368ba09381fa245eb6c3d763f3093f0c89b972e66b53d59406d9f01aea07f8b3b615cac4ee4d05f542e7d0dab45d67ccccd3a606ccbeb31ea1fa7005ba07176e60dab7d78f6810ef086f42f08e595f0ec217372b98970cc6321576d92ce38f7c397a403bada1548d205c343ac09deca86325373c3b76d9f32028fea8eb32515", "7bafac36b5afdbc1eed53ab7b05b1364b9a5502829468128f7ef7358");
        TestDigest.testKatHex(new Shabal224(), "3e15350d87d6ebb5c8ad99d42515cfe17980933c7a8f6b8bbbf0a63728cefaad2052623c0bd5931839112a48633fb3c2004e0749c87a41b26a8b48945539d1ff41a4b269462fd199bfecd45374756f55a9116e92093ac99451aefb2af9fd32d6d7f5fbc7f7a540d5097c096ebc3b3a721541de073a1cc02f7fb0fb1b9327fb0b1218ca49c9487ab5396622a13ae546c97abdef6b56380dda7012a8384091b6656d0ab272d363cea78163ff765cdd13ab1738b940d16cae", "1fb2dcce88440e70ef85ea38932021ebc1246d31650275f8deb27d9c");
        TestDigest.testKatHex(new Shabal224(), "c38d6b0b757cb552be40940ece0009ef3b0b59307c1451686f1a22702922800d58bce7a636c1727ee547c01b214779e898fc0e560f8ae7f61bef4d75eaa696b921fd6b735d171535e9edd267c192b99880c87997711002009095d8a7a437e258104a41a505e5ef71e5613ddd2008195f0c574e6ba3fe40099cfa116e5f1a2fa8a6da04badcb4e2d5d0de31fdc4800891c45781a0aac7c907b56d631fca5ce8b2cde620d11d1777ed9fa603541de794ddc5758fcd5fad78c0", "b5f715c42cb41a919d8b12800fec02dc3b7571272543e7a1936b8e00");
        TestDigest.testKatHex(new Shabal224(), "8d2de3f0b37a6385c90739805b170057f091cd0c7a0bc951540f26a5a75b3e694631bb64c7635eed316f51318e9d8de13c70a2aba04a14836855f35e480528b776d0a1e8a23b547c8b8d6a0d09b241d3be9377160cca4e6793d00a515dc2992cb7fc741daca171431da99cce6f7789f129e2ac5cf65b40d703035cd2185bb936c82002daf8cbc27a7a9e554b06196630446a6f0a14ba155ed26d95bd627b7205c072d02b60db0fd7e49ea058c2e0ba202daff0de91e845cf79", "a4c30b5b90cff66f4da40fe368afbe82d20b1e894c164bd26e56b686");
        TestDigest.testKatHex(new Shabal224(), "c464bbdad275c50dcd983b65ad1019b9ff85a1e71c807f3204bb2c921dc31fbcd8c5fc45868ae9ef85b6c9b83bba2a5a822201ed68586ec5ec27fb2857a5d1a2d09d09115f22dcc39fe61f5e1ba0ff6e8b4acb4c6da748be7f3f0839739394ff7fa8e39f7f7e84a33c3866875c01bcb1263c9405d91908e9e0b50e7459fabb63d8c6bbb73d8e3483c099b55bc30ff092ff68b6adedfd477d63570c9f5515847f36e24ba0b705557130cec57ebad1d0b31a378e91894ee26e3a04", "44b94f61970bc18e376fc03c2eaedc58cb478121aba9ed4985e21561");
        TestDigest.testKatHex(new Shabal224(), "8b8d68bb8a75732fe272815a68a1c9c5aa31b41dedc8493e76525d1d013d33cebd9e21a5bb95db2616976a8c07fcf411f5f6bc6f7e0b57aca78cc2790a6f9b898858ac9c79b165ff24e66677531e39f572be5d81eb3264524181115f32780257bfb9aeec6af12af28e587cac068a1a2953b59ad680f4c245b2e3ec36f59940d37e1d3db38e13edb29b5c0f404f6ff87f80fc8be7a225ff22fbb9c8b6b1d7330c57840d24bc75b06b80d30dad6806544d510af6c4785e823ac3e0b8", "2fcf7f3eabaca917fbd3dfee9cc6b2ddd56d9b86b975f527e51b55a3");
        TestDigest.testKatHex(new Shabal224(), "6b018710446f368e7421f1bc0ccf562d9c1843846bc8d98d1c9bf7d9d6fcb48bfc3bf83b36d44c4fa93430af75cd190bde36a7f92f867f58a803900df8018150384d85d82132f123006ac2aeba58e02a037fe6afbd65eca7c44977dd3dc74f48b6e7a1bfd5cc4dcf24e4d52e92bd4455848e4928b0eac8b7476fe3cc03e862aa4dff4470dbfed6de48e410f25096487ecfc32a27277f3f5023b2725ade461b1355889554a8836c9cf53bd767f5737d55184eea1ab3f53edd0976c485", "10fe90735ac42bd6d12abf8d6437a9f826a11156fcd2bcaae9657d75");
        TestDigest.testKatHex(new Shabal224(), "c9534a24714bd4be37c88a3da1082eda7cabd154c309d7bd670dccd95aa535594463058a29f79031d6ecaa9f675d1211e9359be82669a79c855ea8d89dd38c2c761ddd0ec0ce9e97597432e9a1beae062cdd71edfdfd464119be9e69d18a7a7fd7ce0e2106f0c8b0abf4715e2ca48ef9f454dc203c96656653b727083513f8efb86e49c513bb758b3b052fe21f1c05bb33c37129d6cc81f1aef6adc45b0e8827a830fe545cf57d0955802c117d23ccb55ea28f95c0d8c2f9c5a242b33f", "278036584a28830485b4172c87cad65eb2747f9ddd026916fd411c6e");
        TestDigest.testKatHex(new Shabal224(), "07906c87297b867abf4576e9f3cc7f82f22b154afcbf293b9319f1b0584da6a40c27b32e0b1b7f412c4f1b82480e70a9235b12ec27090a5a33175a2bb28d8adc475cefe33f7803f8ce27967217381f02e67a3b4f84a71f1c5228e0c2ad971373f6f672624fcea8d1a9f85170fad30fa0bbd25035c3b41a6175d467998bd1215f6f3866f53847f9cf68ef3e2fbb54bc994de2302b829c5eea68ec441fcbafd7d16ae4fe9fff98bf00e5bc2ad54dd91ff9fda4dd77b6c754a91955d1fbaad0", "b3663345526dc25a079aaf1ca810fe9de3156af57b0fbaa3175c6f03");
        TestDigest.testKatHex(new Shabal224(), "588e94b9054abc2189df69b8ba34341b77cdd528e7860e5defcaa79b0c9a452ad4b82aa306be84536eb7cedcbe058d7b84a6aef826b028b8a0271b69ac3605a9635ea9f5ea0aa700f3eb7835bc54611b922964300c953efe7491e3677c2cebe0822e956cd16433b02c68c4a23252c3f9e151a416b4963257b783e038f6b4d5c9f110f871652c7a649a7bcedcbccc6f2d0725bb903cc196ba76c76aa9f10a190b1d1168993baa9ffc96a1655216773458bec72b0e39c9f2c121378feab4e76a", "afd4517788491130ee88210f7b02cb7ad8a670ddb6f4bf5378757074");
        TestDigest.testKatHex(new Shabal224(), "08959a7e4baae874928813364071194e2939772f20db7c3157078987c557c2a6d5abe68d520eef3dc491692e1e21bcd880adebf63bb4213b50897fa005256ed41b5690f78f52855c8d9168a4b666fce2da2b456d7a7e7c17ab5f2fb1ee90b79e698712e963715983fd07641ae4b4e9dc73203fac1ae11fa1f8c7941fcc82eab247addb56e2638447e9d609e610b60ce086656aaebf1da3c8a231d7d94e2fd0afe46b391ff14a72eaeb3f44ad4df85866def43d4781a0b3578bc996c87970b132", "20182452562afe1681b8d5b5432c7b58faa2f3f03eb34fcaffe8ce69");
        TestDigest.testKatHex(new Shabal224(), "cb2a234f45e2ecd5863895a451d389a369aab99cfef0d5c9ffca1e6e63f763b5c14fb9b478313c8e8c0efeb3ac9500cf5fd93791b789e67eac12fd038e2547cc8e0fc9db591f33a1e4907c64a922dda23ec9827310b306098554a4a78f050262db5b545b159e1ff1dca6eb734b872343b842c57eafcfda8405eedbb48ef32e99696d135979235c3a05364e371c2d76f1902f1d83146df9495c0a6c57d7bf9ee77e80f9787aee27be1fe126cdc9ef893a4a7dcbbc367e40fe4e1ee90b42ea25af01", "06c7b41357c6ec4f5414fb5112cd0b5a82227ebe7ed7988a548e6e47");
        TestDigest.testKatHex(new Shabal224(), "d16beadf02ab1d4dc6f88b8c4554c51e866df830b89c06e786a5f8757e8909310af51c840efe8d20b35331f4355d80f73295974653ddd620cdde4730fb6c8d0d2dcb2b45d92d4fbdb567c0a3e86bd1a8a795af26fbf29fc6c65941cddb090ff7cd230ac5268ab4606fccba9eded0a2b5d014ee0c34f0b2881ac036e24e151be89eeb6cd9a7a790afccff234d7cb11b99ebf58cd0c589f20bdac4f9f0e28f75e3e04e5b3debce607a496d848d67fa7b49132c71b878fd5557e082a18eca1fbda94d4b", "08a92b5063d0f9169ec0c93cb65dc195d1c57bf98af039f5d2d36754");
        TestDigest.testKatHex(new Shabal224(), "8f65f6bc59a85705016e2bae7fe57980de3127e5ab275f573d334f73f8603106ec3553016608ef2dd6e69b24be0b7113bf6a760ba6e9ce1c48f9e186012cf96a1d4849d75df5bb8315387fd78e9e153e76f8ba7ec6c8849810f59fb4bb9b004318210b37f1299526866f44059e017e22e96cbe418699d014c6ea01c9f0038b10299884dbec3199bb05adc94e955a1533219c1115fed0e5f21228b071f40dd57c4240d98d37b73e412fe0fa4703120d7c0c67972ed233e5deb300a22605472fa3a3ba86", "378074a75d9a50f6c6c69825d06fa88fb529d02631256bc336c9bcf9");
        TestDigest.testKatHex(new Shabal224(), "84891e52e0d451813210c3fd635b39a03a6b7a7317b221a7abc270dfa946c42669aacbbbdf801e1584f330e28c729847ea14152bd637b3d0f2b38b4bd5bf9c791c58806281103a3eabbaede5e711e539e6a8b2cf297cf351c078b4fa8f7f35cf61bebf8814bf248a01d41e86c5715ea40c63f7375379a7eb1d78f27622fb468ab784aaaba4e534a6dfd1df6fa15511341e725ed2e87f98737ccb7b6a6dfae416477472b046bf1811187d151bfa9f7b2bf9acdb23a3be507cdf14cfdf517d2cb5fb9e4ab6", "530799cd31b00fc6f051c3eea849a5fbacb261e3d5339c113cfc0b7a");
        TestDigest.testKatHex(new Shabal224(), "fdd7a9433a3b4afabd7a3a5e3457e56debf78e84b7a0b0ca0e8c6d53bd0c2dae31b2700c6128334f43981be3b213b1d7a118d59c7e6b6493a86f866a1635c12859cfb9ad17460a77b4522a5c1883c3d6acc86e6162667ec414e9a104aa892053a2b1d72165a855bacd8faf8034a5dd9b716f47a0818c09bb6baf22aa503c06b4ca261f557761989d2afbd88b6a678ad128af68672107d0f1fc73c5ca740459297b3292b281e93bceb761bde7221c3a55708e5ec84472cddcaa84ecf23723cc0991355c6280", "dd6e26d2483a6f0348ead9d44bf50d299fef96df79df9663c2ede7dd");
        TestDigest.testKatHex(new Shabal224(), "70a40bfbef92277a1aad72f6b79d0177197c4ebd432668cfec05d099accb651062b5dff156c0b27336687a94b26679cfdd9daf7ad204338dd9c4d14114033a5c225bd11f217b5f4732da167ee3f939262d4043fc9cba92303b7b5e96aea12adda64859df4b86e9ee0b58e39091e6b188b408ac94e1294a8911245ee361e60e601eff58d1d37639f3753bec80ebb4efde25817436076623fc65415fe51d1b0280366d12c554d86743f3c3b6572e400361a60726131441ba493a83fbe9afda90f7af1ae717238d", "8a7f3beaaa9de3161f8c7a96140c17194d5c5cdd9df08493b93ff655");
        TestDigest.testKatHex(new Shabal224(), "74356e449f4bf8644f77b14f4d67cb6bd9c1f5ae357621d5b8147e562b65c66585caf2e491b48529a01a34d226d436959153815380d5689e30b35357cdac6e08d3f2b0e88e200600d62bd9f5eaf488df86a4470ea227006182e44809009868c4c280c43d7d64a5268fa719074960087b3a6abc837882f882c837834535929389a12b2c78187e2ea07ef8b8eef27dc85002c3ae35f1a50bee6a1c48ba7e175f3316670b27983472aa6a61eed0a683a39ee323080620ea44a9f74411ae5ce99030528f9ab49c79f2", "137b2cc048049cf5ba47c0b0dde5d20a0d932c370da75ef1805ae175");
        TestDigest.testKatHex(new Shabal224(), "8c3798e51bc68482d7337d3abb75dc9ffe860714a9ad73551e120059860dde24ab87327222b64cf774415a70f724cdf270de3fe47dda07b61c9ef2a3551f45a5584860248fabde676e1cd75f6355aa3eaeabe3b51dc813d9fb2eaa4f0f1d9f834d7cad9c7c695ae84b329385bc0bef895b9f1edf44a03d4b410cc23a79a6b62e4f346a5e8dd851c2857995ddbf5b2d717aeb847310e1f6a46ac3d26a7f9b44985af656d2b7c9406e8a9e8f47dcb4ef6b83caacf9aefb6118bfcff7e44bef6937ebddc89186839b77", "2536a4c55444f480980692695216f366e82786d641bf66592365cf99");
        TestDigest.testKatHex(new Shabal224(), "fa56bf730c4f8395875189c10c4fb251605757a8fecc31f9737e3c2503b02608e6731e85d7a38393c67de516b85304824bfb135e33bf22b3a23b913bf6acd2b7ab85198b8187b2bcd454d5e3318cacb32fd6261c31ae7f6c54ef6a7a2a4c9f3ecb81ce3555d4f0ad466dd4c108a90399d70041997c3b25345a9653f3c9a6711ab1b91d6a9d2216442da2c973cbd685ee7643bfd77327a2f7ae9cb283620a08716dfb462e5c1d65432ca9d56a90e811443cd1ecb8f0de179c9cb48ba4f6fec360c66f252f6e64edc96b", "6bda02e5eb073bfd27383fd0fb5990bd6ba485afd121b47ba6edfcf8");
        TestDigest.testKatHex(new Shabal224(), "b6134f9c3e91dd8000740d009dd806240811d51ab1546a974bcb18d344642baa5cd5903af84d58ec5ba17301d5ec0f10ccd0509cbb3fd3fff9172d193af0f782252fd1338c7244d40e0e42362275b22d01c4c3389f19dd69bdf958ebe28e31a4ffe2b5f18a87831cfb7095f58a87c9fa21db72ba269379b2dc2384b3da953c7925761fed324620acea435e52b424a7723f6a2357374157a34cd8252351c25a1b232826cefe1bd3e70ffc15a31e7c0598219d7f00436294d11891b82497bc78aa5363892a2495df8c1eef", "2cafada1864d718dd835002306c8893d04ee281d565b1c0e19c70d8b");
        TestDigest.testKatHex(new Shabal224(), "c941cdb9c28ab0a791f2e5c8e8bb52850626aa89205bec3a7e22682313d198b1fa33fc7295381354858758ae6c8ec6fac3245c6e454d16fa2f51c4166fab51df272858f2d603770c40987f64442d487af49cd5c3991ce858ea2a60dab6a65a34414965933973ac2457089e359160b7cdedc42f29e10a91921785f6b7224ee0b349393cdcff6151b50b377d609559923d0984cda6000829b916ab6896693ef6a2199b3c22f7dc5500a15b8258420e314c222bc000bc4e5413e6dd82c993f8330f5c6d1be4bc79f08a1a0a46", "d7175327072f2e417b9760089fe572dc80bd2d570dc67e8b07bb5c73");
        TestDigest.testKatHex(new Shabal224(), "4499efffac4bcea52747efd1e4f20b73e48758be915c88a1ffe5299b0b005837a46b2f20a9cb3c6e64a9e3c564a27c0f1c6ad1960373036ec5bfe1a8fc6a435c2185ed0f114c50e8b3e4c7ed96b06a036819c9463e864a58d6286f785e32a804443a56af0b4df6abc57ed5c2b185ddee8489ea080deeee66aa33c2e6dab36251c402682b6824821f998c32163164298e1fafd31babbcffb594c91888c6219079d907fdb438ed89529d6d96212fd55abe20399dbefd342248507436931cdead496eb6e4a80358acc78647d043", "67b106310be0c940af33a284aaf37ca94fa7ef3dd534116d74756cd2");
        TestDigest.testKatHex(new Shabal224(), "eecbb8fdfa4da62170fd06727f697d81f83f601ff61e478105d3cb7502f2c89bf3e8f56edd469d049807a38882a7eefbc85fc9a950952e9fa84b8afebd3ce782d4da598002827b1eb98882ea1f0a8f7aa9ce013a6e9bc462fb66c8d4a18da21401e1b93356eb12f3725b6db1684f2300a98b9a119e5d27ff704affb618e12708e77e6e5f34139a5a41131fd1d6336c272a8fc37080f041c71341bee6ab550cb4a20a6ddb6a8e0299f2b14bc730c54b8b1c1c487b494bdccfd3a53535ab2f231590bf2c4062fd2ad58f906a2d0d", "d357944b5da4184a22eb3234e7d4e45af98191f78685efcb2591ba9c");
        TestDigest.testKatHex(new Shabal224(), "e64f3e4ace5c8418d65fec2bc5d2a303dd458034736e3b0df719098be7a206deaf52d6ba82316caf330ef852375188cde2b39cc94aa449578a7e2a8e3f5a9d68e816b8d16889fbc0ebf0939d04f63033ae9ae2bdab73b88c26d6bd25ee460ee1ef58fb0afa92cc539f8c76d3d097e7a6a63ebb9b5887edf3cf076028c5bbd5b9db3211371ad3fe121d4e9bf44229f4e1ecf5a0f9f0eba4d5ceb72878ab22c3f0eb5a625323ac66f7061f4a81fac834471e0c59553f108475fe290d43e6a055ae3ee46fb67422f814a68c4be3e8c9", "1c8fe200c6e1023b86278e9c57f41baad9dd191a0d8165d0cfef41fd");
        TestDigest.testKatHex(new Shabal224(), "d2cb2d733033f9e91395312808383cc4f0ca974e87ec68400d52e96b3fa6984ac58d9ad0938dde5a973008d818c49607d9de2284e7618f1b8aed8372fbd52ed54557af4220fac09dfa8443011699b97d743f8f2b1aef3537ebb45dcc9e13dfb438428ee190a4efdb3caeb7f3933117bf63abdc7e57beb4171c7e1ad260ab0587806c4d137b6316b50abc9cce0dff3acada47bbb86be777e617bbe578ff4519844db360e0a96c6701290e76bb95d26f0f804c8a4f2717eac4e7de9f2cff3bbc55a17e776c0d02856032a6cd10ad2838", "87a60e89635e3a291bf583360e355fae7932c6979d987f5f934eaaa5");
        TestDigest.testKatHex(new Shabal224(), "f2998955613dd414cc111df5ce30a995bb792e260b0e37a5b1d942fe90171a4ac2f66d4928d7ad377f4d0554cbf4c523d21f6e5f379d6f4b028cdcb9b1758d3b39663242ff3cb6ede6a36a6f05db3bc41e0d861b384b6dec58bb096d0a422fd542df175e1be1571fb52ae66f2d86a2f6824a8cfaacbac4a7492ad0433eeb15454af8f312b3b2a577750e3efbd370e8a8cac1582581971fba3ba4bd0d76e718dacf8433d33a59d287f8cc92234e7a271041b526e389efb0e40b6a18b3aaf658e82ed1c78631fd23b4c3eb27c3faec8685", "3cb21889ab1bd2c131ac72cb79782887442f927fddf1a0181618aad4");
        TestDigest.testKatHex(new Shabal224(), "447797e2899b72a356ba55bf4df3acca6cdb1041eb477bd1834a9f9acbc340a294d729f2f97df3a610be0ff15edb9c6d5db41644b9874360140fc64f52aa03f0286c8a640670067a84e017926a70438db1bb361defee7317021425f8821def26d1efd77fc853b818545d055adc9284796e583c76e6fe74c9ac2587aa46aa8f8804f2feb5836cc4b3ababab8429a5783e17d5999f32242eb59ef30cd7adabc16d72dbdb097623047c98989f88d14eaf02a7212be16ec2d07981aaa99949ddf89ecd90333a77bc4e1988a82abf7c7caf3291", "dba03e01e3f1b9979decee5c9f6e58fb961dd36bb10ea2c2857a4150");
        TestDigest.testKatHex(new Shabal224(), "9f2c18ade9b380c784e170fb763e9aa205f64303067eb1bcea93df5dac4bf5a2e00b78195f808df24fc76e26cb7be31dc35f0844cded1567bba29858cffc97fb29010331b01d6a3fb3159cc1b973d255da9843e34a0a4061cabdb9ed37f241bfabb3c20d32743f4026b59a4ccc385a2301f83c0b0a190b0f2d01acb8f0d41111e10f2f4e149379275599a52dc089b35fdd5234b0cfb7b6d8aebd563ca1fa653c5c021dfd6f5920e6f18bfafdbecbf0ab00281333ed50b9a999549c1c8f8c63d7626c48322e9791d5ff72294049bde91e73f8", "83ab5d40f1f87cdae360580111a5e93deee06b935698bf75da6cc609");
        TestDigest.testKatHex(new Shabal224(), "ae159f3fa33619002ae6bcce8cbbdd7d28e5ed9d61534595c4c9f43c402a9bb31f3b301cbfd4a43ce4c24cd5c9849cc6259eca90e2a79e01ffbac07ba0e147fa42676a1d668570e0396387b5bcd599e8e66aaed1b8a191c5a47547f61373021fa6deadcb55363d233c24440f2c73dbb519f7c9fa5a8962efd5f6252c0407f190dfefad707f3c7007d69ff36b8489a5b6b7c557e79dd4f50c06511f599f56c896b35c917b63ba35c6ff8092baf7d1658e77fc95d8a6a43eeb4c01f33f03877f92774be89c1114dd531c011e53a34dc248a2f0e6", "3d634ed074304a9c855b5ac500cec9cd43943c0708b0f98fa4ea7a70");
        TestDigest.testKatHex(new Shabal224(), "3b8e97c5ffc2d6a40fa7de7fcefc90f3b12c940e7ab415321e29ee692dfac799b009c99dcddb708fce5a178c5c35ee2b8617143edc4c40b4d313661f49abdd93cea79d117518805496fe6acf292c4c2a1f76b403a97d7c399daf85b46ad84e16246c67d6836757bde336c290d5d401e6c1386ab32797af6bb251e9b2d8fe754c47482b72e0b394eab76916126fd68ea7d65eb93d59f5b4c5ac40f7c3b37e7f3694f29424c24af8c8f0ef59cd9dbf1d28e0e10f799a6f78cad1d45b9db3d7dee4a7059abe99182714983b9c9d44d7f5643596d4f3", "bfec1e66b5e5b8785d540dba0e31a08b1331f0d4092d636b8d99a679");
        TestDigest.testKatHex(new Shabal224(), "3434ec31b10fafdbfeec0dd6bd94e80f7ba9dca19ef075f7eb017512af66d6a4bcf7d16ba0819a1892a6372f9b35bcc7ca8155ee19e8428bc22d214856ed5fa9374c3c09bde169602cc219679f65a1566fc7316f4cc3b631a18fb4449fa6afa16a3db2bc4212eff539c67cf184680826535589c7111d73bffce431b4c40492e763d9279560aaa38eb2dc14a212d723f994a1fe656ff4dd14551ce4e7c621b2aa5604a10001b2878a897a28a08095c325e10a26d2fb1a75bfd64c250309bb55a44f23bbac0d5516a1c687d3b41ef2fbbf9cc56d4739", "1dbcd8cde3845a830a972088c9ca7b07060d09b70d57a775519c7982");
        TestDigest.testKatHex(new Shabal224(), "7c7953d81c8d208fd1c97681d48f49dd003456de60475b84070ef4847c333b74575b1fc8d2a186964485a3b8634feaa3595aaa1a2f4595a7d6b6153563dee31bbac443c8a33eed6d5d956a980a68366c2527b550ee950250dfb691eacbd5d56ae14b970668be174c89df2fea43ae52f13142639c884fd62a3683c0c3792f0f24ab1318bcb27e21f4737fab62c77ea38bc8fd1cf41f7dab64c13febe7152bf5bb7ab5a78f5346d43cc741cb6f72b7b8980f268b68bf62abdfb1577a52438fe14b591498cc95f071228460c7c5d5ceb4a7bde588e7f21c", "15825505d13da7c5f3928694375a7becb66b8245c0aa4b16a468c76c");
        TestDigest.testKatHex(new Shabal224(), "7a6a4f4fdc59a1d223381ae5af498d74b7252ecf59e389e49130c7eaee626e7bd9897effd92017f4ccde66b0440462cdedfd352d8153e6a4c8d7a0812f701cc737b5178c2556f07111200eb627dbc299caa792dfa58f35935299fa3a3519e9b03166dffa159103ffa35e8577f7c0a86c6b46fe13db8e2cdd9dcfba85bdddcce0a7a8e155f81f712d8e9fe646153d3d22c811bd39f830433b2213dd46301941b59293fd0a33e2b63adbd95239bc01315c46fdb678875b3c81e053a40f581cfbec24a1404b1671a1b88a6d06120229518fb13a74ca0ac5ae", "789721f509ce6bc1604ad6662226261274bf860e0831162ccf2f6a67");
        TestDigest.testKatHex(new Shabal224(), "d9faa14cebe9b7de551b6c0765409a33938562013b5e8e0e1e0a6418df7399d0a6a771fb81c3ca9bd3bb8e2951b0bc792525a294ebd1083688806fe5e7f1e17fd4e3a41d00c89e8fcf4a363caedb1acb558e3d562f1302b3d83bb886ed27b76033798131dab05b4217381eaaa7ba15ec820bb5c13b516dd640eaec5a27d05fdfca0f35b3a5312146806b4c0275bcd0aaa3b2017f346975db566f9b4d137f4ee10644c2a2da66deeca5342e236495c3c6280528bfd32e90af4cd9bb908f34012b52b4bc56d48cc8a6b59bab014988eabd12e1a0a1c2e170e7", "277cc21962a001f2bf7f72d0bc7634ca2384bbef7339ce4e4157f0ed");
        TestDigest.testKatHex(new Shabal224(), "2d8427433d0c61f2d96cfe80cf1e932265a191365c3b61aaa3d6dcc039f6ba2ad52a6a8cc30fc10f705e6b7705105977fa496c1c708a277a124304f1fc40911e7441d1b5e77b951aad7b01fd5db1b377d165b05bbf898042e39660caf8b279fe5229d1a8db86c0999ed65e53d01ccbc4b43173ccf992b3a14586f6ba42f5fe30afa8ae40c5df29966f9346da5f8b35f16a1de3ab6de0f477d8d8660918060e88b9b9e9ca6a4207033b87a812dbf5544d39e4882010f82b6ce005f8e8ff6fe3c3806bc2b73c2b83afb704345629304f9f86358712e9fae3ca3e", "cfd0c38b38d8c657a9780f1c624e3cb25f032bc4513720864cec56aa");
        TestDigest.testKatHex(new Shabal224(), "5e19d97887fcaac0387e22c6f803c34a3dacd2604172433f7a8a7a526ca4a2a1271ecfc5d5d7be5ac0d85d921095350dfc65997d443c21c8094e0a3fefd2961bcb94aed03291ae310ccda75d8ace4bc7d89e7d3e5d1650bda5d668b8b50bfc8e608e184f4d3a9a2badc4ff5f07e0c0bc8a9f2e0b2a26fd6d8c550008faaab75fd71af2a424bec9a7cd9d83fad4c8e9319115656a8717d3b523a68ff8004258b9990ed362308461804ba3e3a7e92d8f2ffae5c2fba55ba5a3c27c0a2f71bd711d2fe1799c2adb31b200035481e9ee5c4adf2ab9c0fa50b23975cf", "e7da0e4dea2b2a697661fd7a4eed66ef4077aec1e3e806e1288ce9ec");
        TestDigest.testKatHex(new Shabal224(), "c8e976ab4638909387ce3b8d4e510c3230e5690e02c45093b1d297910abc481e56eea0f296f98379dfc9080af69e73b2399d1c143bee80ae1328162ce1ba7f6a8374679b20aacd380eb4e61382c99998704d62701afa914f9a2705cdb065885f50d086c3eb5753700c387118bb142f3e6da1e988dfb31ac75d7368931e45d1391a274b22f83ceb072f9bcabc0b216685bfd789f5023971024b1878a205442522f9ea7d8797a4102a3df41703768251fd5e017c85d1200a464118aa35654e7ca39f3c375b8ef8cbe7534dbc64bc20befb417cf60ec92f63d9ee7397", "f3b50b28121ebe74dc25fd1477e36157d48fe26a2e775674debc7084");
        TestDigest.testKatHex(new Shabal224(), "7145fa124b7429a1fc2231237a949ba7201bcc1822d3272de005b682398196c25f7e5cc2f289fbf44415f699cb7fe6757791b1443410234ae061edf623359e2b4e32c19bf88450432dd01caa5eb16a1dc378f391ca5e3c4e5f356728bddd4975db7c890da8bbc84cc73ff244394d0d48954978765e4a00b593f70f2ca082673a261ed88dbcef1127728d8cd89bc2c597e9102ced6010f65fa75a14ebe467fa57ce3bd4948b6867d74a9df5c0ec6f530cbf2ee61ce6f06bc8f2864dff5583776b31df8c7ffcb61428a56bf7bd37188b4a5123bbf338393af46eda85e6", "e504b605e4fe26cf9c0f3a12ac53491c92e6b182f22f32a66001d46a");
        TestDigest.testKatHex(new Shabal224(), "7fdfadcc9d29bad23ae038c6c65cda1aef757221b8872ed3d75ff8df7da0627d266e224e812c39f7983e4558bfd0a1f2bef3feb56ba09120ef762917b9c093867948547aee98600d10d87b20106878a8d22c64378bf634f7f75900c03986b077b0bf8b740a82447b61b99fee5376c5eb6680ec9e3088f0bdd0c56883413d60c1357d3c811950e5890e7600103c916341b80c743c6a852b7b4fb60c3ba21f3bc15b8382437a68454779cf3cd7f9f90ccc8ef28d0b706535b1e4108eb5627bb45d719cb046839aee311ca1abdc8319e050d67972cb35a6b1601b25dbf487", "c658faa8db24f88ee094a908048f8a22bff92e435c8141516bb0be03");
        TestDigest.testKatHex(new Shabal224(), "988638219fd3095421f826f56e4f09e356296b628c3ce6930c9f2e758fd1a80c8273f2f61e4daae65c4f110d3e7ca0965ac7d24e34c0dc4ba2d6ff0bf5bbe93b3585f354d7543cb542a1aa54674d375077f2d360a8f4d42f3db131c3b7ab7306267ba107659864a90c8c909460a73621d1f5d9d3fd95beb19b23db1cb6c0d0fba91d36891529b8bd8263caa1bab56a4affaed44962df096d8d5b1eb845ef31188b3e10f1af811a13f156beb7a288aae593ebd1471b624aa1a7c6adf01e2200b3d72d88a3aed3100c88231e41efc376906f0b580dc895f080fda5741db1cb", "f2605537a5dbc99807f42dba62c7f315fb207e09c3e4596d504bd9a1");
        TestDigest.testKatHex(new Shabal224(), "5aab62756d307a669d146aba988d9074c5a159b3de85151a819b117ca1ff6597f6156e80fdd28c9c3176835164d37da7da11d94e09add770b68a6e081cd22ca0c004bfe7cd283bf43a588da91f509b27a6584c474a4a2f3ee0f1f56447379240a5ab1fb77fdca49b305f07ba86b62756fb9efb4fc225c86845f026ea542076b91a0bc2cdd136e122c659be259d98e5841df4c2f60330d4d8cdee7bf1a0a244524eecc68ff2aef5bf0069c9e87a11c6e519de1a4062a10c83837388f7ef58598a3846f49d499682b683c4a062b421594fafbc1383c943ba83bdef515efcf10d", "77ffd9fa3795ca0f14ba0b95f3a3ba050c306a665680ee8a277b9679");
        TestDigest.testKatHex(new Shabal224(), "47b8216aa0fbb5d67966f2e82c17c07aa2d6327e96fcd83e3de7333689f3ee79994a1bf45082c4d725ed8d41205cb5bcdf5c341f77facb1da46a5b9b2cbc49eadf786bcd881f371a95fa17df73f606519aea0ff79d5a11427b98ee7f13a5c00637e2854134691059839121fea9abe2cd1bcbbbf27c74caf3678e05bfb1c949897ea01f56ffa4dafbe8644611685c617a3206c7a7036e4ac816799f693dafe7f19f303ce4eba09d21e03610201bfc665b72400a547a1e00fa9b7ad8d84f84b34aef118515e74def11b9188bd1e1f97d9a12c30132ec2806339bdadacda2fd8b78", "7b64daad457a2793f57c144b8e56b7be4c0770756acccafae0f0f74c");
        TestDigest.testKatHex(new Shabal224(), "8cff1f67fe53c098896d9136389bd8881816ccab34862bb67a656e3d98896f3ce6ffd4da73975809fcdf9666760d6e561c55238b205d8049c1cedeef374d1735daa533147bfa960b2cce4a4f254176bb4d1bd1e89654432b8dbe1a135c42115b394b024856a2a83dc85d6782be4b444239567ccec4b184d4548eae3ff6a192f343292ba2e32a0f267f31cc26719eb85245d415fb897ac2da433ee91a99424c9d7f1766a44171d1651001c38fc79294accc68ceb5665d36218454d3ba169ae058a831338c17743603f81ee173bfc0927464f9bd728dee94c6aeab7aae6ee3a627e8", "2723af440b8b4ba1bff1bb9faa0d1a2d0bad7a70e82624ad6b173568");
        TestDigest.testKatHex(new Shabal224(), "eacd07971cff9b9939903f8c1d8cbb5d4db1b548a85d04e037514a583604e787f32992bf2111b97ac5e8a938233552731321522ab5e8583561260b7d13ebeef785b23a41fd8576a6da764a8ed6d822d4957a545d5244756c18aa80e1aad4d1f9c20d259dee1711e2cc8fd013169fb7cc4ce38b362f8e0936ae9198b7e838dcea4f7a5b9429bb3f6bbcf2dc92565e3676c1c5e6eb3dd2a0f86aa23edd3d0891f197447692794b3dfa269611ad97f72b795602b4fdb198f3fd3eb41b415064256e345e8d8c51c555dc8a21904a9b0f1ad0effab7786aac2da3b196507e9f33ca356427", "0211cc24664aee5ba4bfae11bcc6693fa34c9e34a5a4ee2108cf367b");
        TestDigest.testKatHex(new Shabal224(), "23ac4e9a42c6ef45c3336ce6dfc2ff7de8884cd23dc912fef0f7756c09d335c189f3ad3a23697abda851a81881a0c8ccafc980ab2c702564c2be15fe4c4b9f10dfb2248d0d0cb2e2887fd4598a1d4acda897944a2ffc580ff92719c95cf2aa42dc584674cb5a9bc5765b9d6ddf5789791d15f8dd925aa12bffafbce60827b490bb7df3dda6f2a143c8bf96abc903d83d59a791e2d62814a89b8080a28060568cf24a80ae61179fe84e0ffad00388178cb6a617d37efd54cc01970a4a41d1a8d3ddce46edbba4ab7c90ad565398d376f431189ce8c1c33e132feae6a8cd17a61c630012", "095ae1bde6c788a3bc9d751fb15b9d0f00cf69abd868071880b2edbb");
        TestDigest.testKatHex(new Shabal224(), "0172df732282c9d488669c358e3492260cbe91c95cfbc1e3fea6c4b0ec129b45f242ace09f152fc6234e1bee8aab8cd56e8b486e1dcba9c05407c2f95da8d8f1c0af78ee2ed82a3a79ec0cb0709396ee62aadb84f8a4ee8a7ccca3c1ee84e302a09ea802204afecf04097e67d0f8e8a9d2651126c0a598a37081e42d168b0ae8a71951c524259e4e2054e535b779679bdade566fe55700858618e626b4a0faf895bcce9011504a49e05fd56127eae3d1f8917afb548ecadabda1020111fec9314c413498a360b08640549a22cb23c731ace743252a8227a0d2689d4c6001606678dfb921", "240e46d6cd22a85d41fd47bc573445499777514b58785cdcf081f856");
        TestDigest.testKatHex(new Shabal224(), "3875b9240cf3e0a8b59c658540f26a701cf188496e2c2174788b126fd29402d6a75453ba0635284d08835f40051a2a9683dc92afb9383719191231170379ba6f4adc816fecbb0f9c446b785bf520796841e58878b73c58d3ebb097ce4761fdeabe15de2f319dfbaf1742cdeb389559c788131a6793e193856661376c81ce9568da19aa6925b47ffd77a43c7a0e758c37d69254909ff0fbd415ef8eb937bcd49f91468b49974c07dc819abd67395db0e05874ff83dddab895344abd0e7111b2df9e58d76d85ad98106b36295826be04d435615595605e4b4bb824b33c4afeb5e7bb0d19f909", "dfe07fb76be7bef73b9e37097f27fd151ebf56fe385d7be2eaca2202");
        TestDigest.testKatHex(new Shabal224(), "747cc1a59fefba94a9c75ba866c30dc5c1cb0c0f8e9361d98484956dd5d1a40f6184afbe3dac9f76028d1caeccfbf69199c6ce2b4c092a3f4d2a56fe5a33a00757f4d7dee5dfb0524311a97ae0668a47971b95766e2f6dd48c3f57841f91f04a00ad5ea70f2d479a2620dc5cd78eaab3a3b011719b7e78d19ddf70d9423798af77517ebc55392fcd01fc600d8d466b9e7a7a85bf33f9cc5419e9bd874ddfd60981150ddaf8d7febaa4374f0872a5628d318000311e2f5655365ad4d407c20e5c04df17a222e7deec79c5ab1116d8572f91cd06e1ccc7ced53736fc867fd49ecebe6bf8082e8a", "33223ac26d849c274593cc49e6c61ce56c4ee34606300f2805c96eb4");
        TestDigest.testKatHex(new Shabal224(), "57af971fccaec97435dc2ec9ef0429bcedc6b647729ea168858a6e49ac1071e706f4a5a645ca14e8c7746d65511620682c906c8b86ec901f3dded4167b3f00b06cbfac6aee3728051b3e5ff10b4f9ed8bd0b8da94303c833755b3ca3aeddf0b54bc8d6632138b5d25bab03d17b3458a9d782108006f5bb7de75b5c0ba854b423d8bb801e701e99dc4feaad59bc1c7112453b04d33ea3635639fb802c73c2b71d58a56bbd671b18fe34ed2e3dca38827d63fdb1d4fb3285405004b2b3e26081a8ff08cd6d2b08f8e7b7e90a2ab1ed7a41b1d0128522c2f8bff56a7fe67969422ce839a9d4608f03", "e149c30899c065f29bac58f1c988451e137984bcd83a3d041d3c7968");
        TestDigest.testKatHex(new Shabal224(), "04e16dedc1227902baaf332d3d08923601bdd64f573faa1bb7201918cfe16b1e10151dae875da0c0d63c59c3dd050c4c6a874011b018421afc4623ab0381831b2da2a8ba42c96e4f70864ac44e106f94311051e74c77c1291bf5db9539e69567bf6a11cf6932bbbad33f8946bf5814c066d851633d1a513510039b349939bfd42b858c21827c8ff05f1d09b1b0765dc78a135b5ca4dfba0801bcaddfa175623c8b647eacfb4444b85a44f73890607d06d507a4f8393658788669f6ef4deb58d08c50ca0756d5e2f49d1a7ad73e0f0b3d3b5f090acf622b1878c59133e4a848e05153592ea81c6fbf", "2c2c512f007e177600742e20f839f54a01ea1145ff65d9998a08e615");
        TestDigest.testKatHex(new Shabal224(), "7c815c384eee0f288ece27cced52a01603127b079c007378bc5d1e6c5e9e6d1c735723acbbd5801ac49854b2b569d4472d33f40bbb8882956245c366dc3582d71696a97a4e19557e41e54dee482a14229005f93afd2c4a7d8614d10a97a9dfa07f7cd946fa45263063ddd29db8f9e34db60daa32684f0072ea2a9426ecebfa5239fb67f29c18cbaa2af6ed4bf4283936823ac1790164fec5457a9cba7c767ca59392d94cab7448f50eb34e9a93a80027471ce59736f099c886dea1ab4cba4d89f5fc7ae2f21ccd27f611eca4626b2d08dc22382e92c1efb2f6afdc8fdc3d2172604f5035c46b8197d3", "ba1894fbab91ea8e8168893fdd125bed4c5f2a67f4db76210e980106");
        TestDigest.testKatHex(new Shabal224(), "e29d505158dbdd937d9e3d2145658ee6f5992a2fc790f4f608d9cdb44a091d5b94b88e81fac4fdf5c49442f13b911c55886469629551189eaff62488f1a479b7db11a1560e198ddccccf50159093425ff7f1cb8d1d1246d0978764087d6bac257026b090efae8cec5f22b6f21c59ace1ac7386f5b8837ca6a12b6fbf5534dd0560ef05ca78104d3b943ddb220feaec89aa5e692a00f822a2ab9a2fe60350d75e7be16ff2526dc643872502d01f42f188abed0a6e9a6f5fd0d1ce7d5755c9ffa66b0af0b20bd806f08e06156690d81ac811778ca3dac2c249b96002017fce93e507e3b953acf99964b847", "5304ef83280f5ee4c7d8f83d73252f727016b0ba6de32f13364b9c3a");
        TestDigest.testKatHex(new Shabal224(), "d85588696f576e65eca0155f395f0cfacd83f36a99111ed5768df2d116d2121e32357ba4f54ede927f189f297d3a97fad4e9a0f5b41d8d89dd7fe20156799c2b7b6bf9c957ba0d6763f5c3bc5129747bbb53652b49290cff1c87e2cdf2c4b95d8aaee09bc8fbfa6883e62d237885810491bfc101f1d8c636e3d0ede838ad05c207a3df4fad76452979eb99f29afaecedd1c63b8d36cf378454a1bb67a741c77ac6b6b3f95f4f02b64dabc15438613ea49750df42ee90101f115aa9abb9ff64324dde9dabbb01054e1bd6b4bcdc7930a44c2300d87ca78c06924d0323ad7887e46c90e8c4d100acd9eed21e", "ff5be26e652bb7b179ce6821bf7e1672b179ac44f4fb94bbc610dda7");
        TestDigest.testKatHex(new Shabal224(), "3a12f8508b40c32c74492b66323375dcfe49184c78f73179f3314b79e63376b8ac683f5a51f1534bd729b02b04d002f55cbd8e8fc9b5ec1ea6bbe6a0d0e7431518e6ba45d124035f9d3dce0a8bb7bf1430a9f657e0b4ea9f20eb20c786a58181a1e20a96f1628f8728a13bdf7a4b4b32fc8aa7054cc4881ae7fa19afa65c6c3ee1b3ade3192af42054a8a911b8ec1826865d46d93f1e7c5e2b7813c92a506e53886f3d4701bb93d2a681ad109c845904bb861af8af0646b6e399b38b614051d34f6842563a0f37ec00cb3d865fc5d746c4987de2a65071100883a2a9c7a2bfe1e2dd603d9ea24dc7c5fd06be", "a2f5eafab5f7cd47bba17e1420d6ef5f0a78fc5c70fcea3a037d6dc2");
        TestDigest.testKatHex(new Shabal224(), "1861edce46fa5ad17e1ff1deae084dec580f97d0a67885dfe834b9dfac1ae076742ce9e267512ca51f6df5a455af0c5fd6abf94acea103a3370c354485a7846fb84f3ac7c2904b5b2fbf227002ce512133bb7e1c4e50057bfd1e44db33c7cdb969a99e284b184f50a14b068a1fc5009d9b298dbe92239572a7627aac02abe8f3e3b473417f36d4d2505d16b7577f4526c9d94a270a2dfe450d06da8f6fa956879a0a55cfe99e742ea555ea477ba3e9b44ccd508c375423611af92e55345dc215779b2d5119eba49c71d49b9fe3f1569fa24e5ca3e332d042422a8b8158d3ec66a80012976f31ffdf305f0c9c5e", "fc6ae6a491cd5a57d5e9cc73d0e1c0d73511f62830d759aab1eb5394");
        TestDigest.testKatHex(new Shabal224(), "08d0ffde3a6e4ef65608ea672e4830c12943d7187ccff08f4941cfc13e545f3b9c7ad5eebbe2b01642b486caf855c2c73f58c1e4e3391da8e2d63d96e15fd84953ae5c231911b00ad6050cd7aafdaac9b0f663ae6aab45519d0f5391a541707d479034e73a6ad805ae3598096af078f1393301493d663dd71f83869ca27ba508b7e91e81e128c1716dc3acfe3084b2201e04cf8006617eecf1b640474a5d45cfde9f4d3ef92d6d055b909892194d8a8218db6d8203a84261d200d71473d7488f3427416b6896c137d455f231071cacbc86e0415ab88aec841d96b7b8af41e05bb461a40645bf176601f1e760de5f", "d6eaa45ff7e1a3c2ec7733e2a874019daa6f8edf6e2dd54d64ba2d19");
        TestDigest.testKatHex(new Shabal224(), "d782abb72a5be3392757be02d3e45be6e2099d6f000d042c8a543f50ed6ebc055a7f133b0dd8e9bc348536edcaae2e12ec18e8837df7a1b3c87ec46d50c241dee820fd586197552dc20beea50f445a07a38f1768a39e2b2ff05dddedf751f1def612d2e4d810daa3a0cc904516f9a43af660315385178a529e51f8aae141808c8bc5d7b60cac26bb984ac1890d0436ef780426c547e94a7b08f01acbfc4a3825eae04f520a9016f2fb8bf5165ed12736fc71e36a49a73614739eaa3ec834069b1b40f1350c2b3ab885c02c640b9f7686ed5f99527e41cfcd796fe4c256c9173186c226169ff257954ebda81c0e5f99", "8ce3ff8a8c6d050590525f2a757e6b912556ad06e7f360e4cb9d9dfd");
        TestDigest.testKatHex(new Shabal224(), "5fce8109a358570e40983e1184e541833bb9091e280f258cfb144387b05d190e431cb19baa67273ba0c58abe91308e1844dcd0b3678baa42f335f2fa05267a0240b3c718a5942b3b3e3bfa98a55c25a1466e8d7a603722cb2bbf03afa54cd769a99f310735ee5a05dae2c22d397bd95635f58c48a67f90e1b73aafcd3f82117f0166657838691005b18da6f341d6e90fc1cdb352b30fae45d348294e501b63252de14740f2b85ae5299ddec3172de8b6d0ba219a20a23bb5e10ff434d39db3f583305e9f5c039d98569e377b75a70ab837d1df269b8a4b566f40bb91b577455fd3c356c914fa06b9a7ce24c7317a172d", "9fd25f6edbab7c6d8ec0a2ec6e6fc5d1cffbe23c9114ff2f760bf438");
        TestDigest.testKatHex(new Shabal224(), "6172f1971a6e1e4e6170afbad95d5fec99bf69b24b674bc17dd78011615e502de6f56b86b1a71d3f4348087218ac7b7d09302993be272e4a591968aef18a1262d665610d1070ee91cc8da36e1f841a69a7a682c580e836941d21d909a3afc1f0b963e1ca5ab193e124a1a53df1c587470e5881fb54dae1b0d840f0c8f9d1b04c645ba1041c7d8dbf22030a623aa15638b3d99a2c400ff76f3252079af88d2b37f35ee66c1ad7801a28d3d388ac450b97d5f0f79e4541755356b3b1a5696b023f39ab7ab5f28df4202936bc97393b93bc915cb159ea1bd7a0a414cb4b7a1ac3af68f50d79f0c9c7314e750f7d02faa58bfa", "fc7b8d96bb04d9bacf647e4ff8dee063a1b490772878820729874897");
        TestDigest.testKatHex(new Shabal224(), "5668ecd99dfbe215c4118398ac9c9eaf1a1433fab4ccdd3968064752b625ea944731f75d48a27d047d67547f14dd0ffaa55fa5e29f7af0d161d85eafc4f2029b717c918eab9d304543290bdba7158b68020c0ba4e079bc95b5bc0fc044a992b94b4ccd3bd66d0eabb5dbbab904d62e00752c4e3b0091d773bcf4c14b4377da3efff824b1cb2fa01b32d1e46c909e626ed2dae920f4c7dbeb635bc754facbd8d49beba3f23c1c41ccbfcd0ee0c114e69737f5597c0bf1d859f0c767e18002ae8e39c26261ffde2920d3d0baf0e906138696cfe5b7e32b600f45df3aaa39932f3a7df95b60fa8712a2271fcaf3911ce7b511b1", "cc48368ba520ce797db9192804a5ae40fa189f06d44fbbc5d58c43a2");
        TestDigest.testKatHex(new Shabal224(), "03d625488354df30e3f875a68edfcf340e8366a8e1ab67f9d5c5486a96829dfac0578289082b2a62117e1cf418b43b90e0adc881fc6ae8105c888e9ecd21aea1c9ae1a4038dfd17378fed71d02ae492087d7cdcd98f746855227967cb1ab4714261ee3bead3f4db118329d3ebef4bc48a875c19ba763966da0ebea800e01b2f50b00e9dd4caca6dcb314d00184ef71ea2391d760c950710db4a70f9212ffc54861f9dc752ce18867b8ad0c48df8466ef7231e7ac567f0eb55099e622ebb86cb237520190a61c66ad34f1f4e289cb3282ae3eaac6152ed24d2c92bae5a7658252a53c49b7b02dfe54fdb2e90074b6cf310ac661", "666c5fb6824bb23a8ba1b1a750fa627e2d7cc5e15eccdcacc94fbd5f");
        TestDigest.testKatHex(new Shabal224(), "2edc282ffb90b97118dd03aaa03b145f363905e3cbd2d50ecd692b37bf000185c651d3e9726c690d3773ec1e48510e42b17742b0b0377e7de6b8f55e00a8a4db4740cee6db0830529dd19617501dc1e9359aa3bcf147e0a76b3ab70c4984c13e339e6806bb35e683af8527093670859f3d8a0fc7d493bcba6bb12b5f65e71e705ca5d6c948d66ed3d730b26db395b3447737c26fad089aa0ad0e306cb28bf0acf106f89af3745f0ec72d534968cca543cd2ca50c94b1456743254e358c1317c07a07bf2b0eca438a709367fafc89a57239028fc5fecfd53b8ef958ef10ee0608b7f5cb9923ad97058ec067700cc746c127a61ee3", "95a7e7bdd1f5628766ff883ff08522f48e8708f07aa8c798747b671f");
        TestDigest.testKatHex(new Shabal224(), "90b28a6aa1fe533915bcb8e81ed6cacdc10962b7ff82474f845eeb86977600cf70b07ba8e3796141ee340e3fce842a38a50afbe90301a3bdcc591f2e7d9de53e495525560b908c892439990a2ca2679c5539ffdf636777ad9c1cdef809cda9e8dcdb451abb9e9c17efa4379abd24b182bd981cafc792640a183b61694301d04c5b3eaad694a6bd4cc06ef5da8fa23b4fa2a64559c5a68397930079d250c51bcf00e2b16a6c49171433b0aadfd80231276560b80458dd77089b7a1bbcc9e7e4b9f881eacd6c92c4318348a13f4914eb27115a1cfc5d16d7fd94954c3532efaca2cab025103b2d02c6fd71da3a77f417d7932685888a", "e57266493e3599846937b00e48ea12bce70507af11df844a41edb12c");
        TestDigest.testKatHex(new Shabal224(), "2969447d175490f2aa9bb055014dbef2e6854c95f8d60950bfe8c0be8de254c26b2d31b9e4de9c68c9adf49e4ee9b1c2850967f29f5d08738483b417bb96b2a56f0c8aca632b552059c59aac3f61f7b45c966b75f1d9931ff4e596406378cee91aaa726a3a84c33f37e9cdbe626b5745a0b06064a8a8d56e53aaf102d23dd9df0a3fdf7a638509a6761a33fa42fa8ddbd8e16159c93008b53765019c3f0e9f10b144ce2ac57f5d7297f9c9949e4ff68b70d339f87501ce8550b772f32c6da8ad2ce2100a895d8b08fa1eead7c376b407709703c510b50f87e73e43f8e7348f87c3832a547ef2bbe5799abedcf5e1f372ea809233f006", "c8587da30f2fcdc3c367d75fc51e85c978d131e6ac592ef16a19b78e");
        TestDigest.testKatHex(new Shabal224(), "721645633a44a2c78b19024eaecf58575ab23c27190833c26875dc0f0d50b46aea9c343d82ea7d5b3e50ec700545c615daeaea64726a0f05607576dcd396d812b03fb6551c641087856d050b10e6a4d5577b82a98afb89cee8594c9dc19e79feff0382fcfd127f1b803a4b9946f4ac9a4378e1e6e041b1389a53e3450cd32d9d2941b0cbabdb50da8ea2513145164c3ab6bcbd251c448d2d4b087ac57a59c2285d564f16da4ed5e607ed979592146ffb0ef3f3db308fb342df5eb5924a48256fc763141a278814c82d6d6348577545870ae3a83c7230ac02a1540fe1798f7ef09e335a865a2ae0949b21e4f748fb8a51f44750e213a8fb", "41b92f233cf31caf95be23027f1ea6c056900a686f4abcbbea43fb68");
        TestDigest.testKatHex(new Shabal224(), "6b860d39725a14b498bb714574b4d37ca787404768f64c648b1751b353ac92bac2c3a28ea909fdf0423336401a02e63ec24325300d823b6864bb701f9d7c7a1f8ec9d0ae3584aa6dd62ea1997cd831b4babd9a4da50932d4efda745c61e4130890e156aee6113716daf95764222a91187db2effea49d5d0596102d619bd26a616bbfda8335505fbb0d90b4c180d1a2335b91538e1668f9f9642790b4e55f9cab0fe2bdd2935d001ee6419abab5457880d0dbff20ed8758f4c20fe759efb33141cf0e892587fe8187e5fbc57786b7e8b089612c936dfc03d27efbbe7c8673f1606bd51d5ff386f4a7ab68edf59f385eb1291f117bfe717399", "efc9a0977361f4ad0b2d036d22a2acff83e9549fe5225718467bc502");
        TestDigest.testKatHex(new Shabal224(), "6a01830af3889a25183244decb508bd01253d5b508ab490d3124afbf42626b2e70894e9b562b288d0a2450cfacf14a0ddae5c04716e5a0082c33981f6037d23d5e045ee1ef2283fb8b6378a914c5d9441627a722c282ff452e25a7ea608d69cee4393a0725d17963d0342684f255496d8a18c2961145315130549311fc07f0312fb78e6077334f87eaa873bee8aa95698996eb21375eb2b4ef53c14401207deb4568398e5dd9a7cf97e8c9663e23334b46912f8344c19efcf8c2ba6f04325f1a27e062b62a58d0766fc6db4d2c6a1928604b0175d872d16b7908ebc041761187cc785526c2a3873feac3a642bb39f5351550af9770c328af7b", "107f08486b13440f4381a1bf2adf959e1226d2614efd2c546e3030ec");
        TestDigest.testKatHex(new Shabal224(), "b3c5e74b69933c2533106c563b4ca20238f2b6e675e8681e34a389894785bdade59652d4a73d80a5c85bd454fd1e9ffdad1c3815f5038e9ef432aac5c3c4fe840cc370cf86580a6011778bbedaf511a51b56d1a2eb68394aa299e26da9ada6a2f39b9faff7fba457689b9c1a577b2a1e505fdf75c7a0a64b1df81b3a356001bf0df4e02a1fc59f651c9d585ec6224bb279c6beba2966e8882d68376081b987468e7aed1ef90ebd090ae825795cdca1b4f09a979c8dfc21a48d8a53cdbb26c4db547fc06efe2f9850edd2685a4661cb4911f165d4b63ef25b87d0a96d3dff6ab0758999aad214d07bd4f133a6734fde445fe474711b69a98f7e2b", "726f101f3effc569692070323d839276596815f1587a26451de9ce9c");
        TestDigest.testKatHex(new Shabal224(), "83af34279ccb5430febec07a81950d30f4b66f484826afee7456f0071a51e1bbc55570b5cc7ec6f9309c17bf5befdd7c6ba6e968cf218a2b34bd5cf927ab846e38a40bbd81759e9e33381016a755f699df35d660007b5eadf292feefb735207ebf70b5bd17834f7bfa0e16cb219ad4af524ab1ea37334aa66435e5d397fc0a065c411ebbce32c240b90476d307ce802ec82c1c49bc1bec48c0675ec2a6c6f3ed3e5b741d13437095707c565e10d8a20b8c20468ff9514fcf31b4249cd82dcee58c0a2af538b291a87e3390d737191a07484a5d3f3fb8c8f15ce056e5e5f8febe5e1fb59d6740980aa06ca8a0c20f5712b4cde5d032e92ab89f0ae1", "e674f062aefba4a8d5dd186e1e7cbb39830fbe7341eb47722ca83c62");
        TestDigest.testKatHex(new Shabal224(), "a7ed84749ccc56bb1dfba57119d279d412b8a986886d810f067af349e8749e9ea746a60b03742636c464fc1ee233acc52c1983914692b64309edfdf29f1ab912ec3e8da074d3f1d231511f5756f0b6eead3e89a6a88fe330a10face267bffbfc3e3090c7fd9a850561f363ad75ea881e7244f80ff55802d5ef7a1a4e7b89fcfa80f16df54d1b056ee637e6964b9e0ffd15b6196bdd7db270c56b47251485348e49813b4eb9ed122a01b3ea45ad5e1a929df61d5c0f3e77e1fdc356b63883a60e9cbb9fc3e00c2f32dbd469659883f690c6772e335f617bc33f161d6f6984252ee12e62b6000ac5231e0c9bc65be223d8dfd94c5004a101af9fd6c0fb", "9e8ff25cbdff8e5169d481f535d82688898155cb0f840b0b43ebd20c");
        TestDigest.testKatHex(new Shabal224(), "a6fe30dcfcda1a329e82ab50e32b5f50eb25c873c5d2305860a835aecee6264aa36a47429922c4b8b3afd00da16035830edb897831c4e7b00f2c23fc0b15fdc30d85fb70c30c431c638e1a25b51caf1d7e8b050b7f89bfb30f59f0f20fecff3d639abc4255b3868fc45dd81e47eb12ab40f2aac735df5d1dc1ad997cefc4d836b854cee9ac02900036f3867fe0d84afff37bde3308c2206c62c4743375094108877c73b87b2546fe05ea137bedfc06a2796274099a0d554da8f7d7223a48cbf31b7decaa1ebc8b145763e3673168c1b1b715c1cd99ecd3ddb238b06049885ecad9347c2436dff32c771f34a38587a44a82c5d3d137a03caa27e66c8ff6", "ce76a28d42d7780b9658cfd12a6ca95b81e04707f8f4860959b21c68");
        TestDigest.testKatHex(new Shabal224(), "83167ff53704c3aa19e9fb3303539759c46dd4091a52ddae9ad86408b69335989e61414bc20ab4d01220e35241eff5c9522b079fba597674c8d716fe441e566110b6211531ceccf8fd06bc8e511d00785e57788ed9a1c5c73524f01830d2e1148c92d0edc97113e3b7b5cd3049627abdb8b39dd4d6890e0ee91993f92b03354a88f52251c546e64434d9c3d74544f23fb93e5a2d2f1fb15545b4e1367c97335b0291944c8b730ad3d4789273fa44fb98d78a36c3c3764abeeac7c569c1e43a352e5b770c3504f87090dee075a1c4c85c0c39cf421bdcc615f9eff6cb4fe6468004aece5f30e1ecc6db22ad9939bb2b0ccc96521dfbf4ae008b5b46bc006e", "5cc13ae070a5a87b9c3878f02894de46db7958e6c694c2fdefe66b1e");
        TestDigest.testKatHex(new Shabal224(), "3a3a819c48efde2ad914fbf00e18ab6bc4f14513ab27d0c178a188b61431e7f5623cb66b23346775d386b50e982c493adbbfc54b9a3cd383382336a1a0b2150a15358f336d03ae18f666c7573d55c4fd181c29e6ccfde63ea35f0adf5885cfc0a3d84a2b2e4dd24496db789e663170cef74798aa1bbcd4574ea0bba40489d764b2f83aadc66b148b4a0cd95246c127d5871c4f11418690a5ddf01246a0c80a43c70088b6183639dcfda4125bd113a8f49ee23ed306faac576c3fb0c1e256671d817fc2534a52f5b439f72e424de376f4c565cca82307dd9ef76da5b7c4eb7e085172e328807c02d011ffbf33785378d79dc266f6a5be6bb0e4a92eceebaeb1", "fc3274692c9dfdbf4b747702de26a512c36a55a8f23355acbaaa3a91");
        TestDigest.reportSuccess("Shabal-224");
    }

    private static void testShabal256() {
        TestDigest.testKatHex(new Shabal256(), "", "aec750d11feee9f16271922fbaf5a9be142f62019ef8d720f858940070889014");
        TestDigest.testKatHex(new Shabal256(), "cc", "f52e6a62fa8a0e0fcdea5e12800c3b4301a0bf8b0f897bbe7685cdc659fdd3f8");
        TestDigest.testKatHex(new Shabal256(), "41fb", "b956d01abe2105dad2c6b29896e14afbebd6f0ac750b64e9dca508a8b94a86e4");
        TestDigest.testKatHex(new Shabal256(), "1f877c", "744aa44a262e0551984e1f476030826e9f70fe7d1f84fd279b60806f965a0d8b");
        TestDigest.testKatHex(new Shabal256(), "c1ecfdfc", "ad1cc03ae512d733bb361eff61793d49d63a184c754ebf7f92a9d2b98edb3b2f");
        TestDigest.testKatHex(new Shabal256(), "21f134ac57", "d735cb59bd420d251953ee01181aab8f1ab9451f40f1ec698b5bac89591f3a22");
        TestDigest.testKatHex(new Shabal256(), "c6f50bb74e29", "6856df3951fd3273a33316e466efa9147e54bd0316ce3b546c2552e399477ad5");
        TestDigest.testKatHex(new Shabal256(), "119713cc83eeef", "9eef91260fabc6b8fb29c3a366b511db0d3e0bf8aad146b69dc4d056a6d58fbe");
        TestDigest.testKatHex(new Shabal256(), "4a4f202484512526", "b63da8b03f7970cbe22689f3da21700c4a7036bd61e7c061c374fb7a8236e132");
        TestDigest.testKatHex(new Shabal256(), "1f66ab4185ed9b6375", "32dc2f0a73f89937afc283855140972e27923a1bdf34bd140e5bf55d54e28cdb");
        TestDigest.testKatHex(new Shabal256(), "eed7422227613b6f53c9", "876285f1afae20adb210fb4070887bc656a251530da76f62fdc4384761393268");
        TestDigest.testKatHex(new Shabal256(), "eaeed5cdffd89dece455f1", "2e09c45406d386a9a0f0bc497055bc1319990a65bef2a2977287ec4ce3f625f6");
        TestDigest.testKatHex(new Shabal256(), "5be43c90f22902e4fe8ed2d3", "5fa43f187b8d361d1741b79a547b38fca270ed5b4b1439806f60901962200b2b");
        TestDigest.testKatHex(new Shabal256(), "a746273228122f381c3b46e4f1", "7c05480ce796a73a73ae36739cf9c81d36cf3944af5b8eb5a6889da42d29a0ec");
        TestDigest.testKatHex(new Shabal256(), "3c5871cd619c69a63b540eb5a625", "6d2d9be4a5b988ce3ae3993e512e446c070e6186685c7121de3905a5b7b2b6e9");
        TestDigest.testKatHex(new Shabal256(), "fa22874bcc068879e8ef11a69f0722", "b98c64dc37cc6a52bee59c26d7b14d5daadf231ea18be0643a095947ebbb99ca");
        TestDigest.testKatHex(new Shabal256(), "52a608ab21ccdd8a4457a57ede782176", "e38264f8f4fc5e11ed6a22400cfe4028485f3dffc951919976b659249d803336");
        TestDigest.testKatHex(new Shabal256(), "82e192e4043ddcd12ecf52969d0f807eed", "b5a7b6371ca69c4133afbb2b4c1ed797d79f1f78c6fcab9796106801cc79e100");
        TestDigest.testKatHex(new Shabal256(), "75683dcb556140c522543bb6e9098b21a21e", "547f1a9331c30c0990c29d139a67ad7588f5bceab5ea0c91082e089c3e0259f4");
        TestDigest.testKatHex(new Shabal256(), "06e4efe45035e61faaf4287b4d8d1f12ca97e5", "6df54de46300a7765ee8abe0f328e9619f1ce7eacc87247fad87b7b01421ca95");
        TestDigest.testKatHex(new Shabal256(), "e26193989d06568fe688e75540aea06747d9f851", "7abff2a621473fa6f728f122d4bb530d416639434b8d26244993dde3783e422b");
        TestDigest.testKatHex(new Shabal256(), "d8dc8fdefbdce9d44e4cbafe78447bae3b5436102a", "ba02d41e96d595d792ac0a2b4e22631c6ea99c0f524b95fb1c864bc0e4b7c76d");
        TestDigest.testKatHex(new Shabal256(), "57085fd7e14216ab102d8317b0cb338a786d5fc32d8f", "d56aa87ea3f10ac899439b9050c08f80699417c49f4577e9d11daae97883561b");
        TestDigest.testKatHex(new Shabal256(), "a05404df5dbb57697e2c16fa29defac8ab3560d6126fa0", "8bad7e4ee07375aaf7d2615f9094f3e4c0a2f3bbc60c263b335d7d1a04670e11");
        TestDigest.testKatHex(new Shabal256(), "aecbb02759f7433d6fcb06963c74061cd83b5b3ffa6f13c6", "7a08ab23bcc138d4113dff285f38ccb40e84315ed3158fa77341ffdb41c883ab");
        TestDigest.testKatHex(new Shabal256(), "aafdc9243d3d4a096558a360cc27c8d862f0be73db5e88aa55", "c2ceb7dae6428d05495fb02558b9324c4b1ba2d6948063ad3e64d458f6de5af4");
        TestDigest.testKatHex(new Shabal256(), "7bc84867f6f9e9fdc3e1046cae3a52c77ed485860ee260e30b15", "65a45183bdf45962d17886bc6a4d4ae6d3739e8323be9d8891da8e291fbea9d2");
        TestDigest.testKatHex(new Shabal256(), "fac523575a99ec48279a7a459e98ff901918a475034327efb55843", "f9a6dfa5a7464496ce8d1df1a2a74ae4453d90e3cc46aa30531392ca8d7d3c96");
        TestDigest.testKatHex(new Shabal256(), "0f8b2d8fcfd9d68cffc17ccfb117709b53d26462a3f346fb7c79b85e", "a83c595380ca8134b62478e48f6eb9034905b2f3553247b1fe8d542816bae8b0");
        TestDigest.testKatHex(new Shabal256(), "a963c3e895ff5a0be4824400518d81412f875fa50521e26e85eac90c04", "6c71c734840ed364a9a9a7b98216b48b104073f5d47d214dbd6435db0d703f5c");
        TestDigest.testKatHex(new Shabal256(), "03a18688b10cc0edf83adf0a84808a9718383c4070c6c4f295098699ac2c", "e88def37c5b4e95ccb176d2ec39a7c36a2c4af3013e6317fbcd9eba005d822a7");
        TestDigest.testKatHex(new Shabal256(), "84fb51b517df6c5accb5d022f8f28da09b10232d42320ffc32dbecc3835b29", "7377f287d271befcc1b7fbdedd1e0186e97f9367694fd5c62f76852fafa4bb23");
        TestDigest.testKatHex(new Shabal256(), "9f2fcc7c90de090d6b87cd7e9718c1ea6cb21118fc2d5de9f97e5db6ac1e9c10", "763758817a21e7f2f778313fc84a854040b746ecc575579d09fb277bbd48dd1e");
        TestDigest.testKatHex(new Shabal256(), "de8f1b3faa4b7040ed4563c3b8e598253178e87e4d0df75e4ff2f2dedd5a0be046", "15bd8fec8870ef6a8c4774802b7577d4eb1e2ec542ee5c7b98b16a15568aa805");
        TestDigest.testKatHex(new Shabal256(), "62f154ec394d0bc757d045c798c8b87a00e0655d0481a7d2d9fb58d93aedc676b5a0", "9db69020228c33ce21d541c4c8a3650c33d52ea698d554d35252fcca399d6a82");
        TestDigest.testKatHex(new Shabal256(), "b2dcfe9ff19e2b23ce7da2a4207d3e5ec7c6112a8a22aec9675a886378e14e5bfbad4e", "f4acb5ba137d7eaf6c616fb083176e9970642e7dcd967055d8dce16bbd9b3acb");
        TestDigest.testKatHex(new Shabal256(), "47f5697ac8c31409c0868827347a613a3562041c633cf1f1f86865a576e02835ed2c2492", "dd5784908e12f01eb460b0fb3296dac4fb9d1c057b1e65cb450f7214c38f0101");
        TestDigest.testKatHex(new Shabal256(), "512a6d292e67ecb2fe486bfe92660953a75484ff4c4f2eca2b0af0edcdd4339c6b2ee4e542", "100d112ae3d45aa6279e99482a3708357598b95e58f92683bb5857875fd1d06c");
        TestDigest.testKatHex(new Shabal256(), "973cf2b4dcf0bfa872b41194cb05bb4e16760a1840d8343301802576197ec19e2a1493d8f4fb", "3bd6e440af6d7e90df1485d0a54b34889df342debb4a0e73bae88153c6d387a4");
        TestDigest.testKatHex(new Shabal256(), "80beebcd2e3f8a9451d4499961c9731ae667cdc24ea020ce3b9aa4bbc0a7f79e30a934467da4b0", "d860e50423d3f1d9e0a855b07a2220325c7c6c4a3547bafb3e1993cb36f81318");
        TestDigest.testKatHex(new Shabal256(), "7abaa12ec2a7347674e444140ae0fb659d08e1c66decd8d6eae925fa451d65f3c0308e29446b8ed3", "844ebbba00bad048ed44e7eb24e15e617be60e146586c489f13202c553caa2c1");
        TestDigest.testKatHex(new Shabal256(), "c88dee9927679b8af422abcbacf283b904ff31e1cac58c7819809f65d5807d46723b20f67ba610c2b7", "919e7ba5abd2c11ae720182bdfc99b852f4ae0c666f5deec1de4d111556c6b5c");
        TestDigest.testKatHex(new Shabal256(), "01e43fe350fcec450ec9b102053e6b5d56e09896e0ddd9074fe138e6038210270c834ce6eadc2bb86bf6", "621220d93f9249fe9ffdb67215c5342799b076e014f5e11ebae0f3ec0592a114");
        TestDigest.testKatHex(new Shabal256(), "337023370a48b62ee43546f17c4ef2bf8d7ecd1d49f90bab604b839c2e6e5bd21540d29ba27ab8e309a4b7", "96b8330c32379cef23184863eef9a68aab8144bd08aa5a58b802eb38dd9b41b2");
        TestDigest.testKatHex(new Shabal256(), "6892540f964c8c74bd2db02c0ad884510cb38afd4438af31fc912756f3efec6b32b58ebc38fc2a6b913596a8", "7cd067c92986e453723f97614ec8e7db5faaf295bb1817aa447e5eb4dc4e67ee");
        TestDigest.testKatHex(new Shabal256(), "f5961dfd2b1ffffda4ffbf30560c165bfedab8ce0be525845deb8dc61004b7db38467205f5dcfb34a2acfe96c0", "68626c9f64827027d01603e019b489ef383b7f63735b8b8be21c6bbd4fef716d");
        TestDigest.testKatHex(new Shabal256(), "ca061a2eb6ceed8881ce2057172d869d73a1951e63d57261384b80ceb5451e77b06cf0f5a0ea15ca907ee1c27eba", "04efb07b1e1bfb92699a43ca3d7be8fdcd1e57f86079bf4c871cd79eee2940d0");
        TestDigest.testKatHex(new Shabal256(), "1743a77251d69242750c4f1140532cd3c33f9b5ccdf7514e8584d4a5f9fbd730bcf84d0d4726364b9bf95ab251d9bb", "3b1c5765300dd20fe86601f6b7e042d579d4a761dd5df1ac553b3dc464383777");
        TestDigest.testKatHex(new Shabal256(), "d8faba1f5194c4db5f176fabfff856924ef627a37cd08cf55608bba8f1e324d7c7f157298eabc4dce7d89ce5162499f9", "ab2b619be3fa46d23b12f616cd32bd67becbf59b74c54bbcc7ef57478a8daf46");
        TestDigest.testKatHex(new Shabal256(), "be9684be70340860373c9c482ba517e899fc81baaa12e5c6d7727975d1d41ba8bef788cdb5cf4606c9c1c7f61aed59f97d", "a3240c4a69fa512ca162c96cf81e0342a243fc859de878373eb56ac496b63c38");
        TestDigest.testKatHex(new Shabal256(), "7e15d2b9ea74ca60f66c8dfab377d9198b7b16deb6a1ba0ea3c7ee2042f89d3786e779cf053c77785aa9e692f821f14a7f51", "fa23b0116f96bed89e5d67daa7ee8a4611fc08d158809108d8a46668718d162f");
        TestDigest.testKatHex(new Shabal256(), "9a219be43713bd578015e9fda66c0f2d83cac563b776ab9f38f3e4f7ef229cb443304fba401efb2bdbd7ece939102298651c86", "adb70396dcc2d3e1f563e35945bb5091008dfa63ad3690736ef571f149aa5af8");
        TestDigest.testKatHex(new Shabal256(), "c8f2b693bd0d75ef99caebdc22adf4088a95a3542f637203e283bbc3268780e787d68d28cc3897452f6a22aa8573ccebf245972a", "24d4cc9215169fb77c512d977030ffe26644c09d4fa346ef68bcdf930714de52");
        TestDigest.testKatHex(new Shabal256(), "ec0f99711016c6a2a07ad80d16427506ce6f441059fd269442baaa28c6ca037b22eeac49d5d894c0bf66219f2c08e9d0e8ab21de52", "f9306be237c6f18681b563f46fda1227b548f40c79b4354ad525f9df33fc7caf");
        TestDigest.testKatHex(new Shabal256(), "0dc45181337ca32a8222fe7a3bf42fc9f89744259cff653504d6051fe84b1a7ffd20cb47d4696ce212a686bb9be9a8ab1c697b6d6a33", "79ac55e3c8578d99968dacc65baa4914236edeb9c12bd844bc1f00f4e2dabedc");
        TestDigest.testKatHex(new Shabal256(), "de286ba4206e8b005714f80fb1cdfaebde91d29f84603e4a3ebc04686f99a46c9e880b96c574825582e8812a26e5a857ffc6579f63742f", "61f15be03c1c67f3766708df0b268a5c8e25e96d017c4806979d55031472b64d");
        TestDigest.testKatHex(new Shabal256(), "eebcc18057252cbf3f9c070f1a73213356d5d4bc19ac2a411ec8cdeee7a571e2e20eaf61fd0c33a0ffeb297ddb77a97f0a415347db66bcaf", "deb96e92f997ba5d16b7a3160ccb1cbf55c48ff7b9d6c582a5d91b90496c95fd");
        TestDigest.testKatHex(new Shabal256(), "416b5cdc9fe951bd361bd7abfc120a5054758eba88fdd68fd84e39d3b09ac25497d36b43cbe7b85a6a3cebda8db4e5549c3ee51bb6fcb6ac1e", "c70c29737d739cd887c7adf70dea3d615a65571d2fc8877fc9057573da0c3b7a");
        TestDigest.testKatHex(new Shabal256(), "5c5faf66f32e0f8311c32e8da8284a4ed60891a5a7e50fb2956b3cbaa79fc66ca376460e100415401fc2b8518c64502f187ea14bfc9503759705", "34b74a16252c6a319666afb23355f76034a79817a54dd19cc2083405e8e7cd10");
        TestDigest.testKatHex(new Shabal256(), "7167e1e02be1a7ca69d788666f823ae4eef39271f3c26a5cf7cee05bca83161066dc2e217b330df821103799df6d74810eed363adc4ab99f36046a", "f880eb174b407a5e9f54eb952a4eedfb43c6e4bf961c0b9d36c78992306cbdb6");
        TestDigest.testKatHex(new Shabal256(), "2fda311dbba27321c5329510fae6948f03210b76d43e7448d1689a063877b6d14c4f6d0eaa96c150051371f7dd8a4119f7da5c483cc3e6723c01fb7d", "6cb996995da20b025461e04e38cd341d0487c9adc8e6fe6ae62ed8a77be4405e");
        TestDigest.testKatHex(new Shabal256(), "95d1474a5aab5d2422aca6e481187833a6212bd2d0f91451a67dd786dfc91dfed51b35f47e1deb8a8ab4b9cb67b70179cc26f553ae7b569969ce151b8d", "605058432489c08ada386f116f9bb87e41e6a8d3a43d3a1fbaf263b1ba44ab90");
        TestDigest.testKatHex(new Shabal256(), "c71bd7941f41df044a2927a8ff55b4b467c33d089f0988aa253d294addbdb32530c0d4208b10d9959823f0c0f0734684006df79f7099870f6bf53211a88d", "794efeef1af236e4c870f9fb5c32789783e7a7d17b98849ad34449c6ee6d7f5d");
        TestDigest.testKatHex(new Shabal256(), "f57c64006d9ea761892e145c99df1b24640883da79d9ed5262859dcda8c3c32e05b03d984f1ab4a230242ab6b78d368dc5aaa1e6d3498d53371e84b0c1d4ba", "cc91d63fda30dcaa3efb6e580ef74fe5f343897234af3b5902462764fe2a905a");
        TestDigest.testKatHex(new Shabal256(), "e926ae8b0af6e53176dbffcc2a6b88c6bd765f939d3d178a9bde9ef3aa131c61e31c1e42cdfaf4b4dcde579a37e150efbef5555b4c1cb40439d835a724e2fae7", "1303d2ba5fbaf789c0ed488b07b6a542371780231204ab72398a106a7355e3af");
        TestDigest.testKatHex(new Shabal256(), "16e8b3d8f988e9bb04de9c96f2627811c973ce4a5296b4772ca3eefeb80a652bdf21f50df79f32db23f9f73d393b2d57d9a0297f7a2f2e79cfda39fa393df1ac00", "596d27ef127e129d77b27a26b3a6bbe661cfe4ec11e98a028accbc2fa0435b99");
        TestDigest.testKatHex(new Shabal256(), "fc424eeb27c18a11c01f39c555d8b78a805b88dba1dc2a42ed5e2c0ec737ff68b2456d80eb85e11714fa3f8eabfb906d3c17964cb4f5e76b29c1765db03d91be37fc", "3b633264e72dad8054a2b6db25b12b5052599848a3e688c98391928ca533cace");
        TestDigest.testKatHex(new Shabal256(), "abe3472b54e72734bdba7d9158736464251c4f21b33fbbc92d7fac9a35c4e3322ff01d2380cbaa4ef8fb07d21a2128b7b9f5b6d9f34e13f39c7ffc2e72e47888599ba5", "3458fae10cdb4f6f5ac10bde7cc220441731b0098f0c03e24060920c940b6f9b");
        TestDigest.testKatHex(new Shabal256(), "36f9f0a65f2ca498d739b944d6eff3da5ebba57e7d9c41598a2b0e4380f3cf4b479ec2348d015ffe6256273511154afcf3b4b4bf09d6c4744fdd0f62d75079d440706b05", "6214790affa21a5f5a5dc6ff754ca658505fb818bffaefd506b157357e20f183");
        TestDigest.testKatHex(new Shabal256(), "abc87763cae1ca98bd8c5b82caba54ac83286f87e9610128ae4de68ac95df5e329c360717bd349f26b872528492ca7c94c2c1e1ef56b74dbb65c2ac351981fdb31d06c77a4", "8303ba0e0e63dd8d7d9d84ffcf3e4d1161449f2458ff8a15c415e867cf4db8c7");
        TestDigest.testKatHex(new Shabal256(), "94f7ca8e1a54234c6d53cc734bb3d3150c8ba8c5f880eab8d25fed13793a9701ebe320509286fd8e422e931d99c98da4df7e70ae447bab8cffd92382d8a77760a259fc4fbd72", "8dd2d811c52ec4b792913b302fd14dd70bb863b2b904e3edde0d6e4aea43214a");
        TestDigest.testKatHex(new Shabal256(), "13bd2811f6ed2b6f04ff3895aceed7bef8dcd45eb121791bc194a0f806206bffc3b9281c2b308b1a729ce008119dd3066e9378acdcc50a98a82e20738800b6cddbe5fe9694ad6d", "8cfdd20721ade22c7fde67edc4ec00b188b5648be28839804170fc76c9352c10");
        TestDigest.testKatHex(new Shabal256(), "1eed9cba179a009ec2ec5508773dd305477ca117e6d569e66b5f64c6bc64801ce25a8424ce4a26d575b8a6fb10ead3fd1992edddeec2ebe7150dc98f63adc3237ef57b91397aa8a7", "727521d88a5b704c51e9535ab0e5db69cc28a752aa6986917efcd0297924fad7");
        TestDigest.testKatHex(new Shabal256(), "ba5b67b5ec3a3ffae2c19dd8176a2ef75c0cd903725d45c9cb7009a900c0b0ca7a2967a95ae68269a6dbf8466c7b6844a1d608ac661f7eff00538e323db5f2c644b78b2d48de1a08aa", "6daa216204d041df6b299e069e14bbbc298b86d9ac2784854909ab0ac2038858");
        TestDigest.testKatHex(new Shabal256(), "0efa26ac5673167dcacab860932ed612f65ff49b80fa9ae65465e5542cb62075df1c5ae54fba4db807be25b070033efa223bdd5b1d3c94c6e1909c02b620d4b1b3a6c9fed24d70749604", "0efbadb7c4750e3708fcc0371af85d84a1ad4bd54c4e56437393f8fa075477cc");
        TestDigest.testKatHex(new Shabal256(), "bbfd933d1fd7bf594ac7f435277dc17d8d5a5b8e4d13d96d2f64e771abbd51a5a8aea741beccbddb177bcea05243ebd003cfdeae877cca4da94605b67691919d8b033f77d384ca01593c1b", "541683f7e15df3dd423f8fdd1d47019e885fcbb90a204bdfb176efc8dc874e7a");
        TestDigest.testKatHex(new Shabal256(), "90078999fd3c35b8afbf4066cbde335891365f0fc75c1286cdd88fa51fab94f9b8def7c9ac582a5dbcd95817afb7d1b48f63704e19c2baa4df347f48d4a6d603013c23f1e9611d595ebac37c", "b386a6a8efef98e0b5917cc7897a315f70a2d896646627ab5567ebf1d210ae45");
        TestDigest.testKatHex(new Shabal256(), "64105eca863515c20e7cfbaa0a0b8809046164f374d691cdbd6508aaabc1819f9ac84b52bafc1b0fe7cddbc554b608c01c8904c669d8db316a0953a4c68ece324ec5a49ffdb59a1bd6a292aa0e", "f47d1dfa76ee1d1f91a0d47325949e20b044cbbaeb69a2b7cbbf7ee642248c9c");
        TestDigest.testKatHex(new Shabal256(), "d4654be288b9f3b711c2d02015978a8cc57471d5680a092aa534f7372c71ceaab725a383c4fcf4d8deaa57fca3ce056f312961eccf9b86f14981ba5bed6ab5b4498e1f6c82c6cae6fc14845b3c8a", "fee7286c2dfd227dd473fc7ea937dd9c5e4cda7b69e8fb913ee87df807e27b13");
        TestDigest.testKatHex(new Shabal256(), "12d9394888305ac96e65f2bf0e1b18c29c90fe9d714dd59f651f52b88b3008c588435548066ea2fc4c101118c91f32556224a540de6efddbca296ef1fb00341f5b01fecfc146bdb251b3bdad556cd2", "3f884708a72852540d7dde8031925f74559cf50cd511b85ebb177e163933c3fe");
        TestDigest.testKatHex(new Shabal256(), "871a0d7a5f36c3da1dfce57acd8ab8487c274fad336bc137ebd6ff4658b547c1dcfab65f037aa58f35ef16aff4abe77ba61f65826f7be681b5b6d5a1ea8085e2ae9cd5cf0991878a311b549a6d6af230", "07d9e21d5d2851b3ecb325ddb63b968a0a149ee0a31c581456711c8badcb57a8");
        TestDigest.testKatHex(new Shabal256(), "e90b4ffef4d457bc7711ff4aa72231ca25af6b2e206f8bf859d8758b89a7cd36105db2538d06da83bad5f663ba11a5f6f61f236fd5f8d53c5e89f183a3cec615b50c7c681e773d109ff7491b5cc22296c5", "6c1379ce85472c7e00dceb11ba4ff2086c70d62914314f3bfc75f3978a736bb3");
        TestDigest.testKatHex(new Shabal256(), "e728de62d75856500c4c77a428612cd804f30c3f10d36fb219c5ca0aa30726ab190e5f3f279e0733d77e7267c17be27d21650a9a4d1e32f649627638dbada9702c7ca303269ed14014b2f3cf8b894eac8554", "d332f901a4fdec65759bf519ec8b8465275357fbf391233e88c3f1f24bcd8f4d");
        TestDigest.testKatHex(new Shabal256(), "6348f229e7b1df3b770c77544e5166e081850fa1c6c88169db74c76e42eb983facb276ad6a0d1fa7b50d3e3b6fcd799ec97470920a7abed47d288ff883e24ca21c7f8016b93bb9b9e078bdb9703d2b781b616e", "6d051ba20af8e3f7dbddfa452d8c253d6a17d8a84dc65f3def8df1527a272931");
        TestDigest.testKatHex(new Shabal256(), "4b127fde5de733a1680c2790363627e63ac8a3f1b4707d982caea258655d9bf18f89afe54127482ba01e08845594b671306a025c9a5c5b6f93b0a39522dc877437be5c2436cbf300ce7ab6747934fcfc30aeaaf6", "391084a67d4226fb1f0ddc082f4a29a3148c196d3674e734e1b609fca34ad998");
        TestDigest.testKatHex(new Shabal256(), "08461f006cff4cc64b752c957287e5a0faabc05c9bff89d23fd902d324c79903b48fcb8f8f4b01f3e4ddb483593d25f000386698f5ade7faade9615fdc50d32785ea51d49894e45baa3dc707e224688c6408b68b11", "7367e50885bbafdc1c74f74cab41ca7d9110247376e7ac4c05ec3ebffb23856a");
        TestDigest.testKatHex(new Shabal256(), "68c8f8849b120e6e0c9969a5866af591a829b92f33cd9a4a3196957a148c49138e1e2f5c7619a6d5edebe995acd81ec8bb9c7b9cfca678d081ea9e25a75d39db04e18d475920ce828b94e72241f24db72546b352a0e4", "1ecffbcf91aaaa97a642767e946d5d3b5e3ab138dd0cc64a81f7780b7ad76834");
        TestDigest.testKatHex(new Shabal256(), "b8d56472954e31fb54e28fca743f84d8dc34891cb564c64b08f7b71636debd64ca1edbdba7fc5c3e40049ce982bba8c7e0703034e331384695e9de76b5104f2fbc4535ecbeebc33bc27f29f18f6f27e8023b0fbb6f563c", "c686177b9aa4d3a759f96f1458e28e04bb001fe6f7b903bd482c26feaf9faeac");
        TestDigest.testKatHex(new Shabal256(), "0d58ac665fa84342e60cefee31b1a4eacdb092f122dfc68309077aed1f3e528f578859ee9e4cefb4a728e946324927b675cd4f4ac84f64db3dacfe850c1dd18744c74ceccd9fe4dc214085108f404eab6d8f452b5442a47d", "a06dd2f676855d1e196a1926178d9c21c838cbeec8a256010f01f98ea4dedc9a");
        TestDigest.testKatHex(new Shabal256(), "1755e2d2e5d1c1b0156456b539753ff416651d44698e87002dcf61dcfa2b4e72f264d9ad591df1fdee7b41b2eb00283c5aebb3411323b672eaa145c5125185104f20f335804b02325b6dea65603f349f4d5d8b782dd3469ccd", "ec76bf67b8c8b576d7201ad2e7c6917a243009df9b4d0993a32c19c4fbf573fb");
        TestDigest.testKatHex(new Shabal256(), "b180de1a611111ee7584ba2c4b020598cd574ac77e404e853d15a101c6f5a2e5c801d7d85dc95286a1804c870bb9f00fd4dcb03aa8328275158819dcad7253f3e3d237aeaa7979268a5db1c6ce08a9ec7c2579783c8afc1f91a7", "790f7ddf2c3aed3f1c8164de88eb8f027c2604aa80c93c4a812542d1baa93db4");
        TestDigest.testKatHex(new Shabal256(), "cf3583cbdfd4cbc17063b1e7d90b02f0e6e2ee05f99d77e24e560392535e47e05077157f96813544a17046914f9efb64762a23cf7a49fe52a0a4c01c630cfe8727b81fb99a89ff7cc11dca5173057e0417b8fe7a9efba6d95c555f", "dcfd29876263792fb168ef648075c8586c03316f9ceecea1a5abcbcf8d2f3b7e");
        TestDigest.testKatHex(new Shabal256(), "072fc02340ef99115bad72f92c01e4c093b9599f6cfc45cb380ee686cb5eb019e806ab9bd55e634ab10aa62a9510cc0672cd3eddb589c7df2b67fcd3329f61b1a4441eca87a33c8f55da4fbbad5cf2b2527b8e983bb31a2fadec7523", "a0909086db0ddf8c0bb31592890370b08d2099a89070e98575ce507e4d0a421c");
        TestDigest.testKatHex(new Shabal256(), "76eecf956a52649f877528146de33df249cd800e21830f65e90f0f25ca9d6540fde40603230eca6760f1139c7f268deba2060631eea92b1fff05f93fd5572fbe29579ecd48bc3a8d6c2eb4a6b26e38d6c5fbf2c08044aeea470a8f2f26", "dfebabd69df96d4034cb713f20e62e5cca7073be132a06049abc918dc873126c");
        TestDigest.testKatHex(new Shabal256(), "7adc0b6693e61c269f278e6944a5a2d8300981e40022f839ac644387bfac9086650085c2cdc585fea47b9d2e52d65a2b29a7dc370401ef5d60dd0d21f9e2b90fae919319b14b8c5565b0423cefb827d5f1203302a9d01523498a4db10374", "745ba489a979f92df95cefbcc76f31f556a69526e1c0115b7e3692242db53341");
        TestDigest.testKatHex(new Shabal256(), "e1fffa9826cce8b86bccefb8794e48c46cdf372013f782eced1e378269b7be2b7bf51374092261ae120e822be685f2e7a83664bcfbe38fe8633f24e633ffe1988e1bc5acf59a587079a57a910bda60060e85b5f5b6f776f0529639d9cce4bd", "d9fbf4a1aafc278b0ff9394035b6b0913b4ab3743897d99595d0296f57537332");
        TestDigest.testKatHex(new Shabal256(), "69f9abba65592ee01db4dce52dbab90b08fc04193602792ee4daa263033d59081587b09bbe49d0b49c9825d22840b2ff5d9c5155f975f8f2c2e7a90c75d2e4a8040fe39f63bbafb403d9e28cc3b86e04e394a9c9e8065bd3c85fa9f0c7891600", "f0f1fb5d6ea4f4940c1a06f28a07fe221a2f1638f061832bd131b467cabff9e5");
        TestDigest.testKatHex(new Shabal256(), "38a10a352ca5aedfa8e19c64787d8e9c3a75dbf3b8674bfab29b5dbfc15a63d10fae66cd1a6e6d2452d557967eaad89a4c98449787b0b3164ca5b717a93f24eb0b506ceb70cbbcb8d72b2a72993f909aad92f044e0b5a2c9ac9cb16a0ca2f81f49", "0d8835545e229a26c61d3d886fc8c3ad28329e6b8609743cd5f49dafe725fe1c");
        TestDigest.testKatHex(new Shabal256(), "6d8c6e449bc13634f115749c248c17cd148b72157a2c37bf8969ea83b4d6ba8c0ee2711c28ee11495f43049596520ce436004b026b6c1f7292b9c436b055cbb72d530d860d1276a1502a5140e3c3f54a93663e4d20edec32d284e25564f624955b52", "1e3508f82bfa598cbfd00e9ad2fd4d8280fe0e24fd9e637a1d99f7eb4e266618");
        TestDigest.testKatHex(new Shabal256(), "6efcbcaf451c129dbe00b9cef0c3749d3ee9d41c7bd500ade40cdc65dedbbbadb885a5b14b32a0c0d087825201e303288a733842fa7e599c0c514e078f05c821c7a4498b01c40032e9f1872a1c925fa17ce253e8935e4c3c71282242cb716b2089ccc1", "69d315e53f55c9ce582644f99701273deff510d824c4070596754dd557fe5e20");
        TestDigest.testKatHex(new Shabal256(), "433c5303131624c0021d868a30825475e8d0bd3052a022180398f4ca4423b98214b6beaac21c8807a2c33f8c93bd42b092cc1b06cedf3224d5ed1ec29784444f22e08a55aa58542b524b02cd3d5d5f6907afe71c5d7462224a3f9d9e53e7e0846dcbb4ce", "3ac3c47ba3f83d2f20ad816d6582ce1c921790891b253a3aa2b9b3cfaa88f587");
        TestDigest.testKatHex(new Shabal256(), "a873e0c67ca639026b6683008f7aa6324d4979550e9bce064ca1e1fb97a30b147a24f3f666c0a72d71348ede701cf2d17e2253c34d1ec3b647dbcef2f879f4eb881c4830b791378c901eb725ea5c172316c6d606e0af7df4df7f76e490cd30b2badf45685f", "9d9015bf685fb0e97be4ba79ca4c8cb3ad40323cfe1362a50390c2084dbe8765");
        TestDigest.testKatHex(new Shabal256(), "006917b64f9dcdf1d2d87c8a6173b64f6587168e80faa80f82d84f60301e561e312d9fbce62f39a6fb476e01e925f26bcc91de621449be6504c504830aae394096c8fc7694651051365d4ee9070101ec9b68086f2ea8f8ab7b811ea8ad934d5c9b62c60a4771", "29bd29a1ad8fd8330151546a98cef07964a21f9900e4a222b5d0964b90073290");
        TestDigest.testKatHex(new Shabal256(), "f13c972c52cb3cc4a4df28c97f2df11ce089b815466be88863243eb318c2adb1a417cb1041308598541720197b9b1cb5ba2318bd5574d1df2174af14884149ba9b2f446d609df240ce335599957b8ec80876d9a085ae084907bc5961b20bf5f6ca58d5dab38adb", "241b0053413c62fee03131d9515dc57d4daaa51849a4aa66754dacb3c39f8e72");
        TestDigest.testKatHex(new Shabal256(), "e35780eb9799ad4c77535d4ddb683cf33ef367715327cf4c4a58ed9cbdcdd486f669f80189d549a9364fa82a51a52654ec721bb3aab95dceb4a86a6afa93826db923517e928f33e3fba850d45660ef83b9876accafa2a9987a254b137c6e140a21691e1069413848", "56e834aa548d645a662b7aba4a5325671c4e3d56c3a8534f6965a888241755c6");
        TestDigest.testKatHex(new Shabal256(), "64ec021c9585e01ffe6d31bb50d44c79b6993d72678163db474947a053674619d158016adb243f5c8d50aa92f50ab36e579ff2dabb780a2b529370daa299207cfbcdd3a9a25006d19c4f1fe33e4b1eaec315d8c6ee1e730623fd1941875b924eb57d6d0c2edc4e78d6", "299f593770a26c80d79a34bc17d46150d651b7aa3ebda865106e6adaaf723359");
        TestDigest.testKatHex(new Shabal256(), "5954bab512cf327d66b5d9f296180080402624ad7628506b555eea8382562324cf452fba4a2130de3e165d11831a270d9cb97ce8c2d32a96f50d71600bb4ca268cf98e90d6496b0a6619a5a8c63db6d8a0634dfc6c7ec8ea9c006b6c456f1b20cd19e781af20454ac880", "180c2b70bb144b0138f7f702eae759829da5d0bcd2d5a0b2271af890dce89f5b");
        TestDigest.testKatHex(new Shabal256(), "03d9f92b2c565709a568724a0aff90f8f347f43b02338f94a03ed32e6f33666ff5802da4c81bdce0d0e86c04afd4edc2fc8b4141c2975b6f07639b1994c973d9a9afce3d9d365862003498513bfa166d2629e314d97441667b007414e739d7febf0fe3c32c17aa188a8683", "53edf48f28f4d7a7aaef45b255142887806cfc7bc08e338497b5682175f9365f");
        TestDigest.testKatHex(new Shabal256(), "f31e8b4f9e0621d531d22a380be5d9abd56faec53cbd39b1fab230ea67184440e5b1d15457bd25f56204fa917fa48e669016cb48c1ffc1e1e45274b3b47379e00a43843cf8601a5551411ec12503e5aac43d8676a1b2297ec7a0800dbfee04292e937f21c005f17411473041", "6c05b2f5ff4c0c0ad9719cf94b1f6a2b4097dc81338fe2328c5d78ab8d7f1dab");
        TestDigest.testKatHex(new Shabal256(), "758ea3fea738973db0b8be7e599bbef4519373d6e6dcd7195ea885fc991d896762992759c2a09002912fb08e0cb5b76f49162aeb8cf87b172cf3ad190253df612f77b1f0c532e3b5fc99c2d31f8f65011695a087a35ee4eee5e334c369d8ee5d29f695815d866da99df3f79403", "cf6092a2505aded3f1d1dc015427897db48b73d24b04e656b65329c31b09b31c");
        TestDigest.testKatHex(new Shabal256(), "47c6e0c2b74948465921868804f0f7bd50dd323583dc784f998a93cd1ca4c6ef84d41dc81c2c40f34b5bee6a93867b3bdba0052c5f59e6f3657918c382e771d33109122cc8bb0e1e53c4e3d13b43ce44970f5e0c079d2ad7d7a3549cd75760c21bb15b447589e86e8d76b1e9ced2", "dcd9097a7f53418ead3e081cdf4416d1cbbf08135a8830823ab49c22f0c9955d");
        TestDigest.testKatHex(new Shabal256(), "f690a132ab46b28edfa6479283d6444e371c6459108afd9c35dbd235e0b6b6ff4c4ea58e7554bd002460433b2164ca51e868f7947d7d7a0d792e4abf0be5f450853cc40d85485b2b8857ea31b5ea6e4ccfa2f3a7ef3380066d7d8979fdac618aad3d7e886dea4f005ae4ad05e5065f", "7a99088f1631b9575ef60dd8d3b1aaa6f31fd804024e6e778e66964cfcd83a5f");
        TestDigest.testKatHex(new Shabal256(), "58d6a99bc6458824b256916770a8417040721cccfd4b79eacd8b65a3767ce5ba7e74104c985ac56b8cc9aebd16febd4cda5adb130b0ff2329cc8d611eb14dac268a2f9e633c99de33997fea41c52a7c5e1317d5b5daed35eba7d5a60e45d1fa7eaabc35f5c2b0a0f2379231953322c4e", "11017328952fb055bc71c148c5bef330a266caf1b6376993904fd8aebcd957b4");
        TestDigest.testKatHex(new Shabal256(), "befab574396d7f8b6705e2d5b58b2c1c820bb24e3f4bae3e8fbcd36dbf734ee14e5d6ab972aedd3540235466e825850ee4c512ea9795abfd33f330d9fd7f79e62bbb63a6ea85de15beaeea6f8d204a28956059e2632d11861dfb0e65bc07ac8a159388d5c3277e227286f65ff5e5b5aec1", "a6c8888f1b28edf49855c58612fd6c55f615a20d3fa44a19549f9f526c1a47d0");
        TestDigest.testKatHex(new Shabal256(), "8e58144fa9179d686478622ce450c748260c95d1ba43b8f9b59abeca8d93488da73463ef40198b4d16fb0b0707201347e0506ff19d01bea0f42b8af9e71a1f1bd168781069d4d338fdef00bf419fbb003031df671f4a37979564f69282de9c65407847dd0da505ab1641c02dea4f0d834986", "64d9e9809767c879e56739a49bee4dcabed7c046b9e87c7d426cdf080b21ff3e");
        TestDigest.testKatHex(new Shabal256(), "b55c10eae0ec684c16d13463f29291bf26c82e2fa0422a99c71db4af14dd9c7f33eda52fd73d017cc0f2dbe734d831f0d820d06d5f89dacc485739144f8cfd4799223b1aff9031a105cb6a029ba71e6e5867d85a554991c38df3c9ef8c1e1e9a7630be61caabca69280c399c1fb7a12d12aefc", "bd42e7cfb4318f01ffb0ee83113271f824dc016958146022fdcb9bd4b1242238");
        TestDigest.testKatHex(new Shabal256(), "2eeea693f585f4ed6f6f8865bbae47a6908aecd7c429e4bec4f0de1d0ca0183fa201a0cb14a529b7d7ac0e6ff6607a3243ee9fb11bcf3e2304fe75ffcddd6c5c2e2a4cd45f63c962d010645058d36571404a6d2b4f44755434d76998e83409c3205aa1615db44057db991231d2cb42624574f545", "0356e67e4737171553d88d5d372a695314e404fc097f88e1f8d38ca84c5c76c6");
        TestDigest.testKatHex(new Shabal256(), "dab11dc0b047db0420a585f56c42d93175562852428499f66a0db811fcdddab2f7cdffed1543e5fb72110b64686bc7b6887a538ad44c050f1e42631bc4ec8a9f2a047163d822a38989ee4aab01b4c1f161b062d873b1cfa388fd301514f62224157b9bef423c7783b7aac8d30d65cd1bba8d689c2d", "b48d697b46b6a5a7835a75f8be7371b418db47df1313c8d3005670aa52471516");
        TestDigest.testKatHex(new Shabal256(), "42e99a2f80aee0e001279a2434f731e01d34a44b1a8101726921c0590c30f3120eb83059f325e894a5ac959dca71ce2214799916424e859d27d789437b9d27240bf8c35adbafcecc322b48aa205b293962d858652abacbd588bcf6cbc388d0993bd622f96ed54614c25b6a9aa527589eaaffcf17ddf7", "054ac7bc56f028a454865413da555f9c77481be173553785ecd30b7e602cd1c1");
        TestDigest.testKatHex(new Shabal256(), "3c9b46450c0f2cae8e3823f8bdb4277f31b744ce2eb17054bddc6dff36af7f49fb8a2320cc3bdf8e0a2ea29ad3a55de1165d219adeddb5175253e2d1489e9b6fdd02e2c3d3a4b54d60e3a47334c37913c5695378a669e9b72dec32af5434f93f46176ebf044c4784467c700470d0c0b40c8a088c815816", "1e8170bf97f1ac8628e924abaa98086ddb58b07d98a99d82faaf0ab4d764a745");
        TestDigest.testKatHex(new Shabal256(), "d1e654b77cb155f5c77971a64df9e5d34c26a3cad6c7f6b300d39deb1910094691adaa095be4ba5d86690a976428635d5526f3e946f7dc3bd4dbc78999e653441187a81f9adcd5a3c5f254bc8256b0158f54673dcc1232f6e918ebfc6c51ce67eaeb042d9f57eec4bfe910e169af78b3de48d137df4f2840", "8cf15d94c5278fe34dbe3de69185f60792da8a8cc3a7f95b1be61c5cf8398a45");
        TestDigest.testKatHex(new Shabal256(), "626f68c18a69a6590159a9c46be03d5965698f2dac3de779b878b3d9c421e0f21b955a16c715c1ec1e22ce3eb645b8b4f263f60660ea3028981eebd6c8c3a367285b691c8ee56944a7cd1217997e1d9c21620b536bdbd5de8925ff71dec6fbc06624ab6b21e329813de90d1e572dfb89a18120c3f606355d25", "2862b3445813221e787bc0586ccc0caff89780228376922f522fd9e8c3a19308");
        TestDigest.testKatHex(new Shabal256(), "651a6fb3c4b80c7c68c6011675e6094eb56abf5fc3057324ebc6477825061f9f27e7a94633abd1fa598a746e4a577caf524c52ec1788471f92b8c37f23795ca19d559d446cab16cbcdce90b79fa1026cee77bf4ab1b503c5b94c2256ad75b3eac6fd5dcb96aca4b03a834bfb4e9af988cecbf2ae597cb9097940", "3c77b9c0a9efbf1670905a1c27bc9826432387bdd1fbab1856b321c7389ad9a4");
        TestDigest.testKatHex(new Shabal256(), "8aaf072fce8a2d96bc10b3c91c809ee93072fb205ca7f10abd82ecd82cf040b1bc49ea13d1857815c0e99781de3adbb5443ce1c897e55188ceaf221aa9681638de05ae1b322938f46bce51543b57ecdb4c266272259d1798de13be90e10efec2d07484d9b21a3870e2aa9e06c21aa2d0c9cf420080a80a91dee16f", "b2c89e17d60e3ad78dd82e532947f41d30d8cf4a97381b6220693474e916c340");
        TestDigest.testKatHex(new Shabal256(), "53f918fd00b1701bd504f8cdea803acca21ac18c564ab90c2a17da592c7d69688f6580575395551e8cd33e0fef08ca6ed4588d4d140b3e44c032355df1c531564d7f4835753344345a6781e11cd5e095b73df5f82c8ae3ad00877936896671e947cc52e2b29dcd463d90a0c9929128da222b5a211450bbc0e02448e2", "fc4348f02b77af6ea890649da9e781eec8a2495da32f0ce13420ea8c96dde72b");
        TestDigest.testKatHex(new Shabal256(), "a64599b8a61b5ccec9e67aed69447459c8da3d1ec6c7c7c82a7428b9b584fa67e90f68e2c00fbbed4613666e5168da4a16f395f7a3c3832b3b134bfc9cbaa95d2a0fe252f44ac6681eb6d40ab91c1d0282fed6701c57463d3c5f2bb8c6a7301fb4576aa3b5f15510db8956ff77478c26a7c09bea7b398cfc83503f538e", "eb0fb026104a4b7423856fd422512aea391da3fa59ab4110b53bcb04014dddfa");
        TestDigest.testKatHex(new Shabal256(), "0e3ab0e054739b00cdb6a87bd12cae024b54cb5e550e6c425360c2e87e59401f5ec24ef0314855f0f56c47695d56a7fb1417693af2a1ed5291f2fee95f75eed54a1b1c2e81226fbff6f63ade584911c71967a8eb70933bc3f5d15bc91b5c2644d9516d3c3a8c154ee48e118bd1442c043c7a0dba5ac5b1d5360aae5b9065", "bac25aa3d1097679e7791b7d1496e961e239b76896835acfd4c76ae475bcbf32");
        TestDigest.testKatHex(new Shabal256(), "a62fc595b4096e6336e53fcdfc8d1cc175d71dac9d750a6133d23199eaac288207944cea6b16d27631915b4619f743da2e30a0c00bbdb1bbb35ab852ef3b9aec6b0a8dcc6e9e1abaa3ad62ac0a6c5de765de2c3711b769e3fde44a74016fff82ac46fa8f1797d3b2a726b696e3dea5530439acee3a45c2a51bc32dd055650b", "6eea046c1a389cc93f1cdb783c9da0ac4a38c8f65abe51cca7eec23571b49897");
        TestDigest.testKatHex(new Shabal256(), "2b6db7ced8665ebe9deb080295218426bdaa7c6da9add2088932cdffbaa1c14129bccdd70f369efb149285858d2b1d155d14de2fdb680a8b027284055182a0cae275234cc9c92863c1b4ab66f304cf0621cd54565f5bff461d3b461bd40df28198e3732501b4860eadd503d26d6e69338f4e0456e9e9baf3d827ae685fb1d817", "ddc4eebe6d8ba774e2bb53130bf0447b0158ba0475a13e1d35dd09c740cf00ca");
        TestDigest.testKatHex(new Shabal256(), "10db509b2cdcaba6c062ae33be48116a29eb18e390e1bbada5ca0a2718afbcd23431440106594893043cc7f2625281bf7de2655880966a23705f0c5155c2f5cca9f2c2142e96d0a2e763b70686cd421b5db812daced0c6d65035fde558e94f26b3e6dde5bd13980cc80292b723013bd033284584bff27657871b0cf07a849f4ae2", "f3d633d73deb210c486d1cbbec677d9ed14db7b7d56071e5723c19322c80fa4e");
        TestDigest.testKatHex(new Shabal256(), "9334de60c997bda6086101a6314f64e4458f5ff9450c509df006e8c547983c651ca97879175aaba0c539e82d05c1e02c480975cbb30118121061b1ebac4f8d9a3781e2db6b18042e01ecf9017a64a0e57447ec7fcbe6a7f82585f7403ee2223d52d37b4bf426428613d6b4257980972a0acab508a7620c1cb28eb4e9d30fc41361ec", "225ac1faac9ab457ef3ef710ab95d6ab75cd584418fb3923da3d97a29e17f47f");
        TestDigest.testKatHex(new Shabal256(), "e88ab086891693aa535ceb20e64c7ab97c7dd3548f3786339897a5f0c39031549ca870166e477743ccfbe016b4428d89738e426f5ffe81626137f17aecff61b72dbee2dc20961880cfe281dfab5ee38b1921881450e16032de5e4d55ad8d4fca609721b0692bac79be5a06e177fe8c80c0c83519fb3347de9f43d5561cb8107b9b5edc", "6856ebc0d11d9117a9108f5923e7a3d0315c4f39d6e87520270678172bb5f433");
        TestDigest.testKatHex(new Shabal256(), "fd19e01a83eb6ec810b94582cb8fbfa2fcb992b53684fb748d2264f020d3b960cb1d6b8c348c2b54a9fcea72330c2aaa9a24ecdb00c436abc702361a82bb8828b85369b8c72ece0082fe06557163899c2a0efa466c33c04343a839417057399a63a3929be1ee4805d6ce3e5d0d0967fe9004696a5663f4cac9179006a2ceb75542d75d68", "caf8c3274f9280762bc6b8331c422b94d6a2d0328c7feb3de97edf3cf36ddc6c");
        TestDigest.testKatHex(new Shabal256(), "59ae20b6f7e0b3c7a989afb28324a40fca25d8651cf1f46ae383ef6d8441587aa1c04c3e3bf88e8131ce6145cfb8973d961e8432b202fa5af3e09d625faad825bc19da9b5c6c20d02abda2fcc58b5bd3fe507bf201263f30543819510c12bc23e2ddb4f711d087a86edb1b355313363a2de996b891025e147036087401ccf3ca7815bf3c49", "ac8fcf9efbdc5dc205c1a2a92783f2dfef449373518e5f641349b12ce3ec9294");
        TestDigest.testKatHex(new Shabal256(), "77ee804b9f3295ab2362798b72b0a1b2d3291dceb8139896355830f34b3b328561531f8079b79a6e9980705150866402fdc176c05897e359a6cb1a7ab067383eb497182a7e5aef7038e4c96d133b2782917417e391535b5e1b51f47d8ed7e4d4025fe98dc87b9c1622614bff3d1029e68e372de719803857ca52067cddaad958951cb2068cc6", "01df44b094d90a8f736946a3b3077ffdb2db721ccd9d436d4c249d7bd8390663");
        TestDigest.testKatHex(new Shabal256(), "b771d5cef5d1a41a93d15643d7181d2a2ef0a8e84d91812f20ed21f147bef732bf3a60ef4067c3734b85bc8cd471780f10dc9e8291b58339a677b960218f71e793f2797aea349406512829065d37bb55ea796fa4f56fd8896b49b2cd19b43215ad967c712b24e5032d065232e02c127409d2ed4146b9d75d763d52db98d949d3b0fed6a8052fbb", "0e57c929a6daf2ea35c40e101b450ad44fb8ab6f4842c04007d83aaf72abeddc");
        TestDigest.testKatHex(new Shabal256(), "b32d95b0b9aad2a8816de6d06d1f86008505bd8c14124f6e9a163b5a2ade55f835d0ec3880ef50700d3b25e42cc0af050ccd1be5e555b23087e04d7bf9813622780c7313a1954f8740b6ee2d3f71f768dd417f520482bd3a08d4f222b4ee9dbd015447b33507dd50f3ab4247c5de9a8abd62a8decea01e3b87c8b927f5b08beb37674c6f8e380c04", "c59456bc90d85e28e73dd49ebf19fd7475f4976898f1cb91fa4646f5b2d9d8e3");
        TestDigest.testKatHex(new Shabal256(), "04410e31082a47584b406f051398a6abe74e4da59bb6f85e6b49e8a1f7f2ca00dfba5462c2cd2bfde8b64fb21d70c083f11318b56a52d03b81cac5eec29eb31bd0078b6156786da3d6d8c33098c5c47bb67ac64db14165af65b44544d806dde5f487d5373c7f9792c299e9686b7e5821e7c8e2458315b996b5677d926dac57b3f22da873c601016a0d", "0e4886321570d655e15782d21e5bff4c38fb20222fc39d277a8672ddb55185e4");
        TestDigest.testKatHex(new Shabal256(), "8b81e9badde026f14d95c019977024c9e13db7a5cd21f9e9fc491d716164bbacdc7060d882615d411438aea056c340cdf977788f6e17d118de55026855f93270472d1fd18b9e7e812bae107e0dfde7063301b71f6cfe4e225cab3b232905a56e994f08ee2891ba922d49c3dafeb75f7c69750cb67d822c96176c46bd8a29f1701373fb09a1a6e3c7158f", "e77c6d5a5a2869d8f383291ff9fd58d2f9236c54019bec9aa71e58020966a434");
        TestDigest.testKatHex(new Shabal256(), "fa6eed24da6666a22208146b19a532c2ec9ba94f09f1def1e7fc13c399a48e41acc2a589d099276296348f396253b57cb0e40291bd282773656b6e0d8bea1cda084a3738816a840485fcf3fb307f777fa5feac48695c2af4769720258c77943fb4556c362d9cba8bf103aeb9034baa8ea8bfb9c4f8e6742ce0d52c49ea8e974f339612e830e9e7a9c29065", "b98dcf0061703e758818edf59dccd8ee89a394e042af4408cd9fafc9a4098e2a");
        TestDigest.testKatHex(new Shabal256(), "9bb4af1b4f09c071ce3cafa92e4eb73ce8a6f5d82a85733440368dee4eb1cbc7b55ac150773b6fe47dbe036c45582ed67e23f4c74585dab509df1b83610564545642b2b1ec463e18048fc23477c6b2aa035594ecd33791af6af4cbc2a1166aba8d628c57e707f0b0e8707caf91cd44bdb915e0296e0190d56d33d8dde10b5b60377838973c1d943c22ed335e", "8594204df19773b0c63957706f86368089c9ff8ec3691d4b97330a1228328022");
        TestDigest.testKatHex(new Shabal256(), "2167f02118cc62043e9091a647cadbed95611a521fe0d64e8518f16c808ab297725598ae296880a773607a798f7c3cfce80d251ebec6885015f9abf7eaabae46798f82cb5926de5c23f44a3f9f9534b3c6f405b5364c2f8a8bdc5ca49c749bed8ce4ba48897062ae8424ca6dde5f55c0e42a95d1e292ca54fb46a84fbc9cd87f2d0c9e7448de3043ae22fdd229", "53848f1916086e4d2e13ae44ae4740204cdb04056160d6a1675d5906c4cf59e3");
        TestDigest.testKatHex(new Shabal256(), "94b7fa0bc1c44e949b1d7617d31b4720cbe7ca57c6fa4f4094d4761567e389ecc64f6968e4064df70df836a47d0c713336b5028b35930d29eb7a7f9a5af9ad5cf441745baec9bb014ceeff5a41ba5c1ce085feb980bab9cf79f2158e03ef7e63e29c38d7816a84d4f71e0f548b7fc316085ae38a060ff9b8dec36f91ad9ebc0a5b6c338cbb8f6659d342a24368cf", "26c903cc22f0f31649fd6d4b46c1ef93460d8d384fb7f3d8c372a9a6c0812f9d");
        TestDigest.testKatHex(new Shabal256(), "ea40e83cb18b3a242c1ecc6ccd0b7853a439dab2c569cfc6dc38a19f5c90acbf76aef9ea3742ff3b54ef7d36eb7ce4ff1c9ab3bc119cff6be93c03e208783335c0ab8137be5b10cdc66ff3f89a1bddc6a1eed74f504cbe7290690bb295a872b9e3fe2cee9e6c67c41db8efd7d863cf10f840fe618e7936da3dca5ca6df933f24f6954ba0801a1294cd8d7e66dfafec", "5e41a7131ba7a81fc90dc1b3c1c680a33558c7176e632e10fc7431e9ae99cdd3");
        TestDigest.testKatHex(new Shabal256(), "157d5b7e4507f66d9a267476d33831e7bb768d4d04cc3438da12f9010263ea5fcafbde2579db2f6b58f911d593d5f79fb05fe3596e3fa80ff2f761d1b0e57080055c118c53e53cdb63055261d7c9b2b39bd90acc32520cbbdbda2c4fd8856dbcee173132a2679198daf83007a9b5c51511ae49766c792a29520388444ebefe28256fb33d4260439cba73a9479ee00c63", "c8dd546c8a40f8bbc1994ce32281b25634caa380d587473394411c988238c58a");
        TestDigest.testKatHex(new Shabal256(), "836b34b515476f613fe447a4e0c3f3b8f20910ac89a3977055c960d2d5d2b72bd8acc715a9035321b86703a411dde0466d58a59769672aa60ad587b8481de4bba552a1645779789501ec53d540b904821f32b0bd1855b04e4848f9f8cfe9ebd8911be95781a759d7ad9724a7102dbe576776b7c632bc39b9b5e19057e226552a5994c1dbb3b5c7871a11f5537011044c53", "d8f6ce1042dc9298d28eab27c9948ccaced407daa33aa7a72f3b17341395f320");
        TestDigest.testKatHex(new Shabal256(), "cc7784a4912a7ab5ad3620aab29ba87077cd3cb83636adc9f3dc94f51edf521b2161ef108f21a0a298557981c0e53ce6ced45bdf782c1ef200d29bab81dd6460586964edab7cebdbbec75fd7925060f7da2b853b2b089588fa0f8c16ec6498b14c55dcee335cb3a91d698e4d393ab8e8eac0825f8adebeee196df41205c011674e53426caa453f8de1cbb57932b0b741d4c6", "ccf4ef3d0cf64c443413dade235678b93ec786e0c5afb6f7701b4567509785bc");
        TestDigest.testKatHex(new Shabal256(), "7639b461fff270b2455ac1d1afce782944aea5e9087eb4a39eb96bb5c3baaf0e868c8526d3404f9405e79e77bfac5ffb89bf1957b523e17d341d7323c302ea7083872dd5e8705694acdda36d5a1b895aaa16eca6104c82688532c8bfe1790b5dc9f4ec5fe95baed37e1d287be710431f1e5e8ee105bc42ed37d74b1e55984bf1c09fe6a1fa13ef3b96faeaed6a2a1950a12153", "cca52eb3e0b2d3e5b4139d98c56f539e65c2700d3454310b99841f557f718b04");
        TestDigest.testKatHex(new Shabal256(), "eb6513fc61b30cfba58d4d7e80f94d14589090cf1d80b1df2e68088dc6104959ba0d583d585e9578ab0aec0cf36c48435eb52ed9ab4bbce7a5abe679c97ae2dbe35e8cc1d45b06dda3cf418665c57cbee4bbb47fa4caf78f4ee656fec237fe4eebbafa206e1ef2bd0ee4ae71bd0e9b2f54f91daadf1febfd7032381d636b733dcb3bf76fb14e23aff1f68ed3dbcf75c9b99c6f26", "7dc9904737b45ad6e10f004c05f6b494804a9bfd2cdf8a98c4d8de060e9b04ba");
        TestDigest.testKatHex(new Shabal256(), "1594d74bf5dde444265d4c04dad9721ff3e34cbf622daf341fe16b96431f6c4df1f760d34f296eb97d98d560ad5286fec4dce1724f20b54fd7df51d4bf137add656c80546fb1bf516d62ee82baa992910ef4cc18b70f3f8698276fcfb44e0ec546c2c39cfd8ee91034ff9303058b4252462f86c823eb15bf481e6b79cc3a02218595b3658e8b37382bd5048eaed5fd02c37944e73b", "96b1a5c9fe2881536c1aa5f05914a451568e4155a1620c0dc8ac6e46eb420ae0");
        TestDigest.testKatHex(new Shabal256(), "4cfa1278903026f66fedd41374558be1b585d03c5c55dac94361df286d4bd39c7cb8037ed3b267b07c346626449d0cc5b0dd2cf221f7e4c3449a4be99985d2d5e67bff2923357ddeab5abcb4619f3a3a57b2cf928a022eb27676c6cf805689004fca4d41ea6c2d0a4789c7605f7bb838dd883b3ad3e6027e775bcf262881428099c7fff95b14c095ea130e0b9938a5e22fc52650f591", "f51358d4f724966e30ac2ea56530076f235216fdf1b0ac4d46d7ae6aee33253c");
        TestDigest.testKatHex(new Shabal256(), "d3e65cb92cfa79662f6af493d696a07ccf32aaadcceff06e73e8d9f6f909209e66715d6e978788c49efb9087b170ecf3aa86d2d4d1a065ae0efc8924f365d676b3cb9e2bec918fd96d0b43dee83727c9a93bf56ca2b2e59adba85696546a815067fc7a78039629d4948d157e7b0d826d1bf8e81237bab7321312fdaa4d521744f988db6fdf04549d0fdca393d639c729af716e9c8bba48", "04845d47e38d7868865232646efa0a98756978178de6202fb5107f23c8551173");
        TestDigest.testKatHex(new Shabal256(), "842cc583504539622d7f71e7e31863a2b885c56a0ba62db4c2a3f2fd12e79660dc7205ca29a0dc0a87db4dc62ee47a41db36b9ddb3293b9ac4baae7df5c6e7201e17f717ab56e12cad476be49608ad2d50309e7d48d2d8de4fa58ac3cfeafeee48c0a9eec88498e3efc51f54d300d828dddccb9d0b06dd021a29cf5cb5b2506915beb8a11998b8b886e0f9b7a80e97d91a7d01270f9a7717", "d02fe3657e4983df429f71e9516fe40196d8c7f83686e4f45edd3ef35b834a33");
        TestDigest.testKatHex(new Shabal256(), "6c4b0a0719573e57248661e98febe326571f9a1ca813d3638531ae28b4860f23c3a3a8ac1c250034a660e2d71e16d3acc4bf9ce215c6f15b1c0fc7e77d3d27157e66da9ceec9258f8f2bf9e02b4ac93793dd6e29e307ede3695a0df63cbdc0fc66fb770813eb149ca2a916911bee4902c47c7802e69e405fe3c04ceb5522792a5503fa829f707272226621f7c488a7698c0d69aa561be9f378", "9151ce28490a37365171709df41c5bfb26529e478f6ea374f5d5995c2ad1186e");
        TestDigest.testKatHex(new Shabal256(), "51b7dbb7ce2ffeb427a91ccfe5218fd40f9e0b7e24756d4c47cd55606008bdc27d16400933906fd9f30effdd4880022d081155342af3fb6cd53672ab7fb5b3a3bcbe47be1fd3a2278cae8a5fd61c1433f7d350675dd21803746cadca574130f01200024c6340ab0cc2cf74f2234669f34e9009ef2eb94823d62b31407f4ba46f1a1eec41641e84d77727b59e746b8a671bef936f05be820759fa", "afb4cf77b143fd7798cb5fedd14c8c0344129b4a177dc9012ede262fd558a152");
        TestDigest.testKatHex(new Shabal256(), "83599d93f5561e821bd01a472386bc2ff4efbd4aed60d5821e84aae74d8071029810f5e286f8f17651cd27da07b1eb4382f754cd1c95268783ad09220f5502840370d494beb17124220f6afce91ec8a0f55231f9652433e5ce3489b727716cf4aeba7dcda20cd29aa9a859201253f948dd94395aba9e3852bd1d60dda7ae5dc045b283da006e1cbad83cc13292a315db5553305c628dd091146597", "5ab38854f3f5affd9d76dcf460903cdc59da2a92a3dc6a88b865f7dab4c0ca4b");
        TestDigest.testKatHex(new Shabal256(), "2be9bf526c9d5a75d565dd11ef63b979d068659c7f026c08bea4af161d85a462d80e45040e91f4165c074c43ac661380311a8cbed59cc8e4c4518e80cd2c78ab1cabf66bff83eab3a80148550307310950d034a6286c93a1ece8929e6385c5e3bb6ea8a7c0fb6d6332e320e71cc4eb462a2a62e2bfe08f0ccad93e61bedb5dd0b786a728ab666f07e0576d189c92bf9fb20dca49ac2d3956d47385e2", "5a8e2a56baeec260b164c80af2438716e8807d6f5f6d803e74f84f5977fce2d9");
        TestDigest.testKatHex(new Shabal256(), "ca76d3a12595a817682617006848675547d3e8f50c2210f9af906c0e7ce50b4460186fe70457a9e879e79fd4d1a688c70a347361c847ba0dd6aa52936eaf8e58a1be2f5c1c704e20146d366aeb3853bed9de9befe9569ac8aaea37a9fb7139a1a1a7d5c748605a8defb297869ebedd71d615a5da23496d11e11abbb126b206fa0a7797ee7de117986012d0362dcef775c2fe145ada6bda1ccb326bf644", "e31ad676b31272a2a4fcc57f307a32be4d8836e8037b31f32293c7848a8683a9");
        TestDigest.testKatHex(new Shabal256(), "f76b85dc67421025d64e93096d1d712b7baf7fb001716f02d33b2160c2c882c310ef13a576b1c2d30ef8f78ef8d2f465007109aad93f74cb9e7d7bef7c9590e8af3b267c89c15db238138c45833c98cc4a471a7802723ef4c744a853cf80a0c2568dd4ed58a2c9644806f42104cee53628e5bdf7b63b0b338e931e31b87c24b146c6d040605567ceef5960df9e022cb469d4c787f4cba3c544a1ac91f95f", "f297bf9c8e2187905cdb98ed81bd9fb0477600ed9e291c9a2a633473024ab5e5");
        TestDigest.testKatHex(new Shabal256(), "25b8c9c032ea6bcd733ffc8718fbb2a503a4ea8f71dea1176189f694304f0ff68e862a8197b839957549ef243a5279fc2646bd4c009b6d1edebf24738197abb4c992f6b1dc9ba891f570879accd5a6b18691a93c7d0a8d38f95b639c1daeb48c4c2f15ccf5b9d508f8333c32de78781b41850f261b855c4bebcc125a380c54d501c5d3bd07e6b52102116088e53d76583b0161e2a58d0778f091206aabd5a1", "40bf205976525d0e0d48c983e3bbda2c430a397cb9da4b640defadeac5a6b6b6");
        TestDigest.testKatHex(new Shabal256(), "21cfdc2a7ccb7f331b3d2eefff37e48ad9fa9c788c3f3c200e0173d99963e1cbca93623b264e920394ae48bb4c3a5bb96ffbc8f0e53f30e22956adabc2765f57fb761e147ecbf8567533db6e50c8a1f894310a94edf806dd8ca6a0e141c0fa7c9fae6c6ae65f18c93a8529e6e5b553bf55f25be2e80a9882bd37f145fecbeb3d447a3c4e46c21524cc55cdd62f521ab92a8ba72b897996c49bb273198b7b1c9e", "1c115e564eeaa2a5f1868982f8733ac792397eb8f25e148d158a123671ec4d7c");
        TestDigest.testKatHex(new Shabal256(), "4e452ba42127dcc956ef4f8f35dd68cb225fb73b5bc7e1ec5a898bba2931563e74faff3b67314f241ec49f4a7061e3bd0213ae826bab380f1f14faab8b0efddd5fd1bb49373853a08f30553d5a55ccbbb8153de4704f29ca2bdeef0419468e05dd51557ccc80c0a96190bbcc4d77ecff21c66bdf486459d427f986410f883a80a5bcc32c20f0478bb9a97a126fc5f95451e40f292a4614930d054c851acd019ccf", "87d035a691883278015f72eaa149ebea4a3740abbdbe763b0931e02609a762c4");
        TestDigest.testKatHex(new Shabal256(), "fa85671df7dadf99a6ffee97a3ab9991671f5629195049880497487867a6c446b60087fac9a0f2fcc8e3b24e97e42345b93b5f7d3691829d3f8ccd4bb36411b85fc2328eb0c51cb3151f70860ad3246ce0623a8dc8b3c49f958f8690f8e3860e71eb2b1479a5cea0b3f8befd87acaf5362435eaeccb52f38617bc6c5c2c6e269ead1fbd69e941d4ad2012da2c5b21bcfbf98e4a77ab2af1f3fda3233f046d38f1dc8", "b4f6db68fb8e0385c1775b26dff0196bfdc12bfdee4e6101edd6d96e5dfbb66e");
        TestDigest.testKatHex(new Shabal256(), "e90847ae6797fbc0b6b36d6e588c0a743d725788ca50b6d792352ea8294f5ba654a15366b8e1b288d84f5178240827975a763bc45c7b0430e8a559df4488505e009c63da994f1403f407958203cebb6e37d89c94a5eacf6039a327f6c4dbbc7a2a307d976aa39e41af6537243fc218dfa6ab4dd817b6a397df5ca69107a9198799ed248641b63b42cb4c29bfdd7975ac96edfc274ac562d0474c60347a078ce4c25e88", "e49389b0cd015afb4efde4bd6ecb4492f63426147c616076c27e32d66f0e5cfa");
        TestDigest.testKatHex(new Shabal256(), "f6d5c2b6c93954fc627602c00c4ca9a7d3ed12b27173f0b2c9b0e4a5939398a665e67e69d0b12fb7e4ceb253e8083d1ceb724ac07f009f094e42f2d6f2129489e846eaff0700a8d4453ef453a3eddc18f408c77a83275617fabc4ea3a2833aa73406c0e966276079d38e8e38539a70e194cc5513aaa457c699383fd1900b1e72bdfb835d1fd321b37ba80549b078a49ea08152869a918ca57f5b54ed71e4fd3ac5c06729", "c3f4f501050c62be92c64c17760cedf6bbbbc7d7ddb08ff73461a04d7e768d98");
        TestDigest.testKatHex(new Shabal256(), "cf8562b1bed89892d67ddaaf3deeb28246456e972326dbcdb5cf3fb289aca01e68da5d59896e3a6165358b071b304d6ab3d018944be5049d5e0e2bb819acf67a6006111089e6767132d72dd85beddcbb2d64496db0cc92955ab4c6234f1eea24f2d51483f2e209e4589bf9519fac51b4d061e801125e605f8093bb6997bc163d551596fe4ab7cfae8fb9a90f6980480ce0c229fd1675409bd788354daf316240cfe0af93eb", "a47151cf35c1707b6aa300d09973603ea615b596967a7948e00ec7725b5f604a");
        TestDigest.testKatHex(new Shabal256(), "2ace31abb0a2e3267944d2f75e1559985db7354c6e605f18dc8470423fca30b7331d9b33c4a4326783d1caae1b4f07060eff978e4746bf0c7e30cd61040bd5ec2746b29863eb7f103ebda614c4291a805b6a4c8214230564a0557bc7102e0bd3ed23719252f7435d64d210ee2aafc585be903fa41e1968c50fd5d5367926df7a05e3a42cf07e656ff92de73b036cf8b19898c0cb34557c0c12c2d8b84e91181af467bc75a9d1", "e1081df49f2d68e2d1b6df83fa60ce68cb57b7acfeaa9be025a74e9ac5f0f955");
        TestDigest.testKatHex(new Shabal256(), "0d8d09aed19f1013969ce5e7eb92f83a209ae76be31c754844ea9116ceb39a22ebb6003017bbcf26555fa6624185187db8f0cb3564b8b1c06bf685d47f3286eda20b83358f599d2044bbf0583fab8d78f854fe0a596183230c5ef8e54426750eaf2cc4e29d3bdd037e734d863c2bd9789b4c243096138f7672c232314effdfc6513427e2da76916b5248933be312eb5dde4cf70804fb258ac5fb82d58d08177ac6f4756017fff5", "5cfca46f06f0c3b6d41bd976a5005820da247ebe9daca8a200211cb574a70de7");
        TestDigest.testKatHex(new Shabal256(), "c3236b73deb7662bf3f3daa58f137b358ba610560ef7455785a9befdb035a066e90704f929bd9689cef0ce3bda5acf4480bceb8d09d10b098ad8500d9b6071dfc3a14af6c77511d81e3aa8844986c3bea6f469f9e02194c92868cd5f51646256798ff0424954c1434bdfed9facb390b07d342e992936e0f88bfd0e884a0ddb679d0547ccdec6384285a45429d115ac7d235a717242021d1dc35641f5f0a48e8445dba58e6cb2c8ea", "3d6bf0a7f40ff9b29ae6d26b1c01eb1479fb04fa7059a4b481caa82df7145e53");
        TestDigest.testKatHex(new Shabal256(), "b39feb8283eadc63e8184b51df5ae3fd41aac8a963bb0be1cd08aa5867d8d910c669221e73243360646f6553d1ca05a84e8dc0de05b6419ec349ca994480193d01c92525f3fb3dcefb08afc6d26947bdbbfd85193f53b50609c6140905c53a6686b58e53a319a57b962331ede98149af3de3118a819da4d76706a0424b4e1d2910b0ed26af61d150ebcb46595d4266a0bd7f651ba47d0c7f179ca28545007d92e8419d48fdfbd744ce", "96802210b7abe392f9be3ff5699fa38b98d8ed16b377a3c82cceeb981bc696e0");
        TestDigest.testKatHex(new Shabal256(), "a983d54f503803e8c7999f4edbbe82e9084f422143a932ddddc47a17b0b7564a7f37a99d0786e99476428d29e29d3c197a72bfab1342c12a0fc4787fd7017d7a6174049ea43b5779169ef7472bdbbd941dcb82fc73aac45a8a94c9f2bd3477f61fd3b796f02a1b8264a214c6fea74b7051b226c722099ec7883a462b83b6afdd4009248b8a237f605fe5a08fe7d8b45321421ebba67bd70a0b00ddbf94baab7f359d5d1eea105f28dcfb", "b23cf3c71549832a48670ae21557625934c99c8d739ffc3b1050fe59ce322769");
        TestDigest.testKatHex(new Shabal256(), "e4d1c1897a0a866ce564635b74222f9696bf2c7f640dd78d7e2aca66e1b61c642bb03ea7536aae597811e9bf4a7b453ede31f97b46a5f0ef51a071a2b3918df16b152519ae3776f9f1edab4c2a377c3292e96408359d3613844d5eb393000283d5ad3401a318b12fd1474b8612f2bb50fb6a8b9e023a54d7dde28c43d6d8854c8d9d1155935c199811dbfc87e9e0072e90eb88681cc7529714f8fb8a2c9d88567adfb974ee205a9bf7b848", "148df241b38255ba3338535c7a438fc26779a3223f268069c831a8ee6579d7fe");
        TestDigest.testKatHex(new Shabal256(), "b10c59723e3dcadd6d75df87d0a1580e73133a9b7d00cb95ec19f5547027323be75158b11f80b6e142c6a78531886d9047b08e551e75e6261e79785366d7024bd7cd9cf322d9be7d57fb661069f2481c7bb759cd71b4b36ca2bc2df6d3a328faebdb995a9794a8d72155ed551a1f87c80bf6059b43fc764900b18a1c2441f7487743cf84e565f61f8dd2ece6b6ccc9444049197aaaf53e926fbee3bfca8be588ec77f29d211be89de18b15f6", "5ac092ef44087217077e5c8e0dc62e9b03ebe6891eead051c7fce882ccaa2965");
        TestDigest.testKatHex(new Shabal256(), "db11f609baba7b0ca634926b1dd539c8cbada24967d7add4d9876f77c2d80c0f4dcefbd7121548373582705cca2495bd2a43716fe64ed26d059cfb566b3364bd49ee0717bdd9810dd14d8fad80dbbdc4cafb37cc60fb0fe2a80fb4541b8ca9d59dce457738a9d3d8f641af8c3fd6da162dc16fc01aac527a4a0255b4d231c0be50f44f0db0b713af03d968fe7f0f61ed0824c55c4b5265548febd6aad5c5eedf63efe793489c39b8fd29d104ce", "ea99de8fac6b8b75d0edee49009989a346246bb4346b9ea9ec6bec1b5f8ceded");
        TestDigest.testKatHex(new Shabal256(), "bebd4f1a84fc8b15e4452a54bd02d69e304b7f32616aadd90537937106ae4e28de9d8aab02d19bc3e2fde1d651559e296453e4dba94370a14dbbb2d1d4e2022302ee90e208321efcd8528ad89e46dc839ea9df618ea8394a6bff308e7726bae0c19bcd4be52da6258e2ef4e96aa21244429f49ef5cb486d7ff35cac1bacb7e95711944bccb2ab34700d42d1eb38b5d536b947348a458ede3dc6bd6ec547b1b0cae5b257be36a7124e1060c170ffa", "88decd9dfda1df7a62147d2948ffc4adcd926df5b6ae9cc7ceafc9a9c6df3da2");
        TestDigest.testKatHex(new Shabal256(), "5aca56a03a13784bdc3289d9364f79e2a85c12276b49b92db0adaa4f206d5028f213f678c3510e111f9dc4c1c1f8b6acb17a6413aa227607c515c62a733817ba5e762cc6748e7e0d6872c984d723c9bb3b117eb8963185300a80bfa65cde495d70a46c44858605fccbed086c2b45cef963d33294dbe9706b13af22f1b7c4cd5a001cfec251fba18e722c6e1c4b1166918b4f6f48a98b64b3c07fc86a6b17a6d0480ab79d4e6415b520f1c484d675b1", "0da1ccf633b1c520cfdec57a8e28a1304c5a73031006b107fdfe37a963a2450d");
        TestDigest.testKatHex(new Shabal256(), "a5aad0e4646a32c85cfcac73f02fc5300f1982fabb2f2179e28303e447854094cdfc854310e5c0f60993ceff54d84d6b46323d930adb07c17599b35b505f09e784bca5985e0172257797fb53649e2e9723efd16865c31b5c3d5113b58bb0bfc8920fabdda086d7537e66d709d050bd14d0c960873f156fad5b3d3840cdfcdc9be6af519db262a27f40896ab25cc39f96984d650611c0d5a3080d5b3a1bf186abd42956588b3b58cd948970d298776060", "a360666819702466076eb132d431c0bca4ef32b17b4105f2a427aae509de8a2b");
        TestDigest.testKatHex(new Shabal256(), "06cbbe67e94a978203ead6c057a1a5b098478b4b4cbef5a97e93c8e42f5572713575fc2a884531d7622f8f879387a859a80f10ef02708cd8f7413ab385afc357678b9578c0ebf641ef076a1a30f1f75379e9dcb2a885bdd295905ee80c0168a62a9597d10cf12dd2d8cee46645c7e5a141f6e0e23aa482abe5661c16e69ef1e28371e2e236c359ba4e92c25626a7b7ff13f6ea4ae906e1cfe163e91719b1f750a96cbde5fbc953d9e576cd216afc90323a", "d965d399ef73f792a7ed1d7a94e78c5ade0d2d89b12e3d4f86f559945b207004");
        TestDigest.testKatHex(new Shabal256(), "f1c528cf7739874707d4d8ad5b98f7c77169de0b57188df233b2dc8a5b31eda5db4291dd9f68e6bad37b8d7f6c9c0044b3bf74bbc3d7d1798e138709b0d75e7c593d3cccdc1b20c7174b4e692add820ace262d45ccfae2077e878796347168060a162ecca8c38c1a88350bd63bb539134f700fd4addd5959e255337daa06bc86358fabcbefdfb5bc889783d843c08aadc6c4f6c36f65f156e851c9a0f917e4a367b5ad93d874812a1de6a7b93cd53ad97232", "abd89b2266b9a9102fff719b1f091cf54922a6d0665ebf9229e8cb5ea7e226f5");
        TestDigest.testKatHex(new Shabal256(), "9d9f3a7ecd51b41f6572fd0d0881e30390dfb780991dae7db3b47619134718e6f987810e542619dfaa7b505c76b7350c6432d8bf1cfebdf1069b90a35f0d04cbdf130b0dfc7875f4a4e62cdb8e525aadd7ce842520a482ac18f09442d78305fe85a74e39e760a4837482ed2f437dd13b2ec1042afcf9decdc3e877e50ff4106ad10a525230d11920324a81094da31deab6476aa42f20c84843cfc1c58545ee80352bdd3740dd6a16792ae2d86f11641bb717c2", "f8075fe96405335c0abd445f924d225fffc830fea8f4a03330195fd470c0ac4b");
        TestDigest.testKatHex(new Shabal256(), "5179888724819fbad3afa927d3577796660e6a81c52d98e9303261d5a4a83232f6f758934d50aa83ff9e20a5926dfebaac49529d006eb923c5ae5048ed544ec471ed7191edf46363383824f915769b3e688094c682b02151e5ee01e510b431c8865aff8b6b6f2f59cb6d129da79e97c6d2b8fa6c6da3f603199d2d1bcab547682a81cd6cf65f6551121391d78bcc23b5bd0e922ec6d8bf97c952e84dd28aef909aba31edb903b28fbfc33b7703cd996215a11238", "9ccb8b7f8bb4c4aa2c6690504b3155534c93e0267a87a0149d7865a24d98b138");
        TestDigest.testKatHex(new Shabal256(), "576ef3520d30b7a4899b8c0d5e359e45c5189add100e43be429a02fb3de5ff4f8fd0e79d9663acca72cd29c94582b19292a557c5b1315297d168fbb54e9e2ecd13809c2b5fce998edc6570545e1499dbe7fb74d47cd7f35823b212b05bf3f5a79caa34224fdd670d335fcb106f5d92c3946f44d3afcbae2e41ac554d8e6759f332b76be89a0324aa12c5482d1ea3ee89ded4936f3e3c080436f539fa137e74c6d3389bdf5a45074c47bc7b20b0948407a66d855e2f", "f435c95993549eff8c799a510a956e532763c53d4332818f0f6ec862dec55f99");
        TestDigest.testKatHex(new Shabal256(), "0df2152fa4f4357c8741529dd77e783925d3d76e95bafa2b542a2c33f3d1d117d159cf473f82310356fee4c90a9e505e70f8f24859656368ba09381fa245eb6c3d763f3093f0c89b972e66b53d59406d9f01aea07f8b3b615cac4ee4d05f542e7d0dab45d67ccccd3a606ccbeb31ea1fa7005ba07176e60dab7d78f6810ef086f42f08e595f0ec217372b98970cc6321576d92ce38f7c397a403bada1548d205c343ac09deca86325373c3b76d9f32028fea8eb32515", "e93b1b7a4dfccd090177edc1d380694a7cbecf14b7c1d256f021cb46a8a35fd8");
        TestDigest.testKatHex(new Shabal256(), "3e15350d87d6ebb5c8ad99d42515cfe17980933c7a8f6b8bbbf0a63728cefaad2052623c0bd5931839112a48633fb3c2004e0749c87a41b26a8b48945539d1ff41a4b269462fd199bfecd45374756f55a9116e92093ac99451aefb2af9fd32d6d7f5fbc7f7a540d5097c096ebc3b3a721541de073a1cc02f7fb0fb1b9327fb0b1218ca49c9487ab5396622a13ae546c97abdef6b56380dda7012a8384091b6656d0ab272d363cea78163ff765cdd13ab1738b940d16cae", "a66931a8dbb5e0afa70365a9b4bd830e0495290dac6603c08ef26c8ec40206a8");
        TestDigest.testKatHex(new Shabal256(), "c38d6b0b757cb552be40940ece0009ef3b0b59307c1451686f1a22702922800d58bce7a636c1727ee547c01b214779e898fc0e560f8ae7f61bef4d75eaa696b921fd6b735d171535e9edd267c192b99880c87997711002009095d8a7a437e258104a41a505e5ef71e5613ddd2008195f0c574e6ba3fe40099cfa116e5f1a2fa8a6da04badcb4e2d5d0de31fdc4800891c45781a0aac7c907b56d631fca5ce8b2cde620d11d1777ed9fa603541de794ddc5758fcd5fad78c0", "2e122ac6f6d732f74b0c774b005818aa6ae973ab57f0c60dfae7cb8dc1d1a1f4");
        TestDigest.testKatHex(new Shabal256(), "8d2de3f0b37a6385c90739805b170057f091cd0c7a0bc951540f26a5a75b3e694631bb64c7635eed316f51318e9d8de13c70a2aba04a14836855f35e480528b776d0a1e8a23b547c8b8d6a0d09b241d3be9377160cca4e6793d00a515dc2992cb7fc741daca171431da99cce6f7789f129e2ac5cf65b40d703035cd2185bb936c82002daf8cbc27a7a9e554b06196630446a6f0a14ba155ed26d95bd627b7205c072d02b60db0fd7e49ea058c2e0ba202daff0de91e845cf79", "3f6fac5be6a6c7595a6026cf2fbedbccc611059a89212e9cd2eb4853e656c236");
        TestDigest.testKatHex(new Shabal256(), "c464bbdad275c50dcd983b65ad1019b9ff85a1e71c807f3204bb2c921dc31fbcd8c5fc45868ae9ef85b6c9b83bba2a5a822201ed68586ec5ec27fb2857a5d1a2d09d09115f22dcc39fe61f5e1ba0ff6e8b4acb4c6da748be7f3f0839739394ff7fa8e39f7f7e84a33c3866875c01bcb1263c9405d91908e9e0b50e7459fabb63d8c6bbb73d8e3483c099b55bc30ff092ff68b6adedfd477d63570c9f5515847f36e24ba0b705557130cec57ebad1d0b31a378e91894ee26e3a04", "a4efe66dd5f74295a18823f1f829f99dcf6f292ed22ad591c16ac0fa7616ce5c");
        TestDigest.testKatHex(new Shabal256(), "8b8d68bb8a75732fe272815a68a1c9c5aa31b41dedc8493e76525d1d013d33cebd9e21a5bb95db2616976a8c07fcf411f5f6bc6f7e0b57aca78cc2790a6f9b898858ac9c79b165ff24e66677531e39f572be5d81eb3264524181115f32780257bfb9aeec6af12af28e587cac068a1a2953b59ad680f4c245b2e3ec36f59940d37e1d3db38e13edb29b5c0f404f6ff87f80fc8be7a225ff22fbb9c8b6b1d7330c57840d24bc75b06b80d30dad6806544d510af6c4785e823ac3e0b8", "eceb1910f1e369f549c71c60b09fc7b417354cd038d92ae67c1e22af3bca4675");
        TestDigest.testKatHex(new Shabal256(), "6b018710446f368e7421f1bc0ccf562d9c1843846bc8d98d1c9bf7d9d6fcb48bfc3bf83b36d44c4fa93430af75cd190bde36a7f92f867f58a803900df8018150384d85d82132f123006ac2aeba58e02a037fe6afbd65eca7c44977dd3dc74f48b6e7a1bfd5cc4dcf24e4d52e92bd4455848e4928b0eac8b7476fe3cc03e862aa4dff4470dbfed6de48e410f25096487ecfc32a27277f3f5023b2725ade461b1355889554a8836c9cf53bd767f5737d55184eea1ab3f53edd0976c485", "aef3456075a28823d5b012ea34c8d804e78c391cb450f11c906b88c09a4449b7");
        TestDigest.testKatHex(new Shabal256(), "c9534a24714bd4be37c88a3da1082eda7cabd154c309d7bd670dccd95aa535594463058a29f79031d6ecaa9f675d1211e9359be82669a79c855ea8d89dd38c2c761ddd0ec0ce9e97597432e9a1beae062cdd71edfdfd464119be9e69d18a7a7fd7ce0e2106f0c8b0abf4715e2ca48ef9f454dc203c96656653b727083513f8efb86e49c513bb758b3b052fe21f1c05bb33c37129d6cc81f1aef6adc45b0e8827a830fe545cf57d0955802c117d23ccb55ea28f95c0d8c2f9c5a242b33f", "66ef9d0dcd32ef365a4bcfe0e7dd2a39d001f968ccc12725530dcfe81ca59776");
        TestDigest.testKatHex(new Shabal256(), "07906c87297b867abf4576e9f3cc7f82f22b154afcbf293b9319f1b0584da6a40c27b32e0b1b7f412c4f1b82480e70a9235b12ec27090a5a33175a2bb28d8adc475cefe33f7803f8ce27967217381f02e67a3b4f84a71f1c5228e0c2ad971373f6f672624fcea8d1a9f85170fad30fa0bbd25035c3b41a6175d467998bd1215f6f3866f53847f9cf68ef3e2fbb54bc994de2302b829c5eea68ec441fcbafd7d16ae4fe9fff98bf00e5bc2ad54dd91ff9fda4dd77b6c754a91955d1fbaad0", "334ec5ec3af2c4002943b7827af39472157729051ead1a875f17d9dd138b1e27");
        TestDigest.testKatHex(new Shabal256(), "588e94b9054abc2189df69b8ba34341b77cdd528e7860e5defcaa79b0c9a452ad4b82aa306be84536eb7cedcbe058d7b84a6aef826b028b8a0271b69ac3605a9635ea9f5ea0aa700f3eb7835bc54611b922964300c953efe7491e3677c2cebe0822e956cd16433b02c68c4a23252c3f9e151a416b4963257b783e038f6b4d5c9f110f871652c7a649a7bcedcbccc6f2d0725bb903cc196ba76c76aa9f10a190b1d1168993baa9ffc96a1655216773458bec72b0e39c9f2c121378feab4e76a", "fa74328106b5b1942b5a70371c3b22da51edb52014ccf202a60285e125544609");
        TestDigest.testKatHex(new Shabal256(), "08959a7e4baae874928813364071194e2939772f20db7c3157078987c557c2a6d5abe68d520eef3dc491692e1e21bcd880adebf63bb4213b50897fa005256ed41b5690f78f52855c8d9168a4b666fce2da2b456d7a7e7c17ab5f2fb1ee90b79e698712e963715983fd07641ae4b4e9dc73203fac1ae11fa1f8c7941fcc82eab247addb56e2638447e9d609e610b60ce086656aaebf1da3c8a231d7d94e2fd0afe46b391ff14a72eaeb3f44ad4df85866def43d4781a0b3578bc996c87970b132", "94202446dd5fc8185a1f70c33afb50d3181171cdec8a2c234560aad10a9ae9e8");
        TestDigest.testKatHex(new Shabal256(), "cb2a234f45e2ecd5863895a451d389a369aab99cfef0d5c9ffca1e6e63f763b5c14fb9b478313c8e8c0efeb3ac9500cf5fd93791b789e67eac12fd038e2547cc8e0fc9db591f33a1e4907c64a922dda23ec9827310b306098554a4a78f050262db5b545b159e1ff1dca6eb734b872343b842c57eafcfda8405eedbb48ef32e99696d135979235c3a05364e371c2d76f1902f1d83146df9495c0a6c57d7bf9ee77e80f9787aee27be1fe126cdc9ef893a4a7dcbbc367e40fe4e1ee90b42ea25af01", "869410ec62e422c0124feda47691a06aa6e311f04a211e04950cfb587398f5e6");
        TestDigest.testKatHex(new Shabal256(), "d16beadf02ab1d4dc6f88b8c4554c51e866df830b89c06e786a5f8757e8909310af51c840efe8d20b35331f4355d80f73295974653ddd620cdde4730fb6c8d0d2dcb2b45d92d4fbdb567c0a3e86bd1a8a795af26fbf29fc6c65941cddb090ff7cd230ac5268ab4606fccba9eded0a2b5d014ee0c34f0b2881ac036e24e151be89eeb6cd9a7a790afccff234d7cb11b99ebf58cd0c589f20bdac4f9f0e28f75e3e04e5b3debce607a496d848d67fa7b49132c71b878fd5557e082a18eca1fbda94d4b", "1ea96f5b353d6706e7490f2ca3a1f7a4c79aec03e9e8440a4481caee7375f590");
        TestDigest.testKatHex(new Shabal256(), "8f65f6bc59a85705016e2bae7fe57980de3127e5ab275f573d334f73f8603106ec3553016608ef2dd6e69b24be0b7113bf6a760ba6e9ce1c48f9e186012cf96a1d4849d75df5bb8315387fd78e9e153e76f8ba7ec6c8849810f59fb4bb9b004318210b37f1299526866f44059e017e22e96cbe418699d014c6ea01c9f0038b10299884dbec3199bb05adc94e955a1533219c1115fed0e5f21228b071f40dd57c4240d98d37b73e412fe0fa4703120d7c0c67972ed233e5deb300a22605472fa3a3ba86", "5b2239cf52d5bb0b1184f59999961c6e68b8bd2662ff09aed93f4e0bbeac2746");
        TestDigest.testKatHex(new Shabal256(), "84891e52e0d451813210c3fd635b39a03a6b7a7317b221a7abc270dfa946c42669aacbbbdf801e1584f330e28c729847ea14152bd637b3d0f2b38b4bd5bf9c791c58806281103a3eabbaede5e711e539e6a8b2cf297cf351c078b4fa8f7f35cf61bebf8814bf248a01d41e86c5715ea40c63f7375379a7eb1d78f27622fb468ab784aaaba4e534a6dfd1df6fa15511341e725ed2e87f98737ccb7b6a6dfae416477472b046bf1811187d151bfa9f7b2bf9acdb23a3be507cdf14cfdf517d2cb5fb9e4ab6", "9c3df4200fa7b10e25697f88afefa60db975d83307d9921ef8ac53f82769b4b8");
        TestDigest.testKatHex(new Shabal256(), "fdd7a9433a3b4afabd7a3a5e3457e56debf78e84b7a0b0ca0e8c6d53bd0c2dae31b2700c6128334f43981be3b213b1d7a118d59c7e6b6493a86f866a1635c12859cfb9ad17460a77b4522a5c1883c3d6acc86e6162667ec414e9a104aa892053a2b1d72165a855bacd8faf8034a5dd9b716f47a0818c09bb6baf22aa503c06b4ca261f557761989d2afbd88b6a678ad128af68672107d0f1fc73c5ca740459297b3292b281e93bceb761bde7221c3a55708e5ec84472cddcaa84ecf23723cc0991355c6280", "c4ae30d268450f092d184d35459363055c29a58763d68a6e4661acbbaf28f411");
        TestDigest.testKatHex(new Shabal256(), "70a40bfbef92277a1aad72f6b79d0177197c4ebd432668cfec05d099accb651062b5dff156c0b27336687a94b26679cfdd9daf7ad204338dd9c4d14114033a5c225bd11f217b5f4732da167ee3f939262d4043fc9cba92303b7b5e96aea12adda64859df4b86e9ee0b58e39091e6b188b408ac94e1294a8911245ee361e60e601eff58d1d37639f3753bec80ebb4efde25817436076623fc65415fe51d1b0280366d12c554d86743f3c3b6572e400361a60726131441ba493a83fbe9afda90f7af1ae717238d", "e546db2859498b5234a29594c26fed9a0a0e1fec7b3a76fbc5a727ccf852670c");
        TestDigest.testKatHex(new Shabal256(), "74356e449f4bf8644f77b14f4d67cb6bd9c1f5ae357621d5b8147e562b65c66585caf2e491b48529a01a34d226d436959153815380d5689e30b35357cdac6e08d3f2b0e88e200600d62bd9f5eaf488df86a4470ea227006182e44809009868c4c280c43d7d64a5268fa719074960087b3a6abc837882f882c837834535929389a12b2c78187e2ea07ef8b8eef27dc85002c3ae35f1a50bee6a1c48ba7e175f3316670b27983472aa6a61eed0a683a39ee323080620ea44a9f74411ae5ce99030528f9ab49c79f2", "4aea215fad3231a401fdc1eef5daee721ab50724da6d7c038d514269ecf9a6bf");
        TestDigest.testKatHex(new Shabal256(), "8c3798e51bc68482d7337d3abb75dc9ffe860714a9ad73551e120059860dde24ab87327222b64cf774415a70f724cdf270de3fe47dda07b61c9ef2a3551f45a5584860248fabde676e1cd75f6355aa3eaeabe3b51dc813d9fb2eaa4f0f1d9f834d7cad9c7c695ae84b329385bc0bef895b9f1edf44a03d4b410cc23a79a6b62e4f346a5e8dd851c2857995ddbf5b2d717aeb847310e1f6a46ac3d26a7f9b44985af656d2b7c9406e8a9e8f47dcb4ef6b83caacf9aefb6118bfcff7e44bef6937ebddc89186839b77", "8765bdad27ffbe42400a65cc457c0d96facb3d02ced2610d1e38a9f36d6d3226");
        TestDigest.testKatHex(new Shabal256(), "fa56bf730c4f8395875189c10c4fb251605757a8fecc31f9737e3c2503b02608e6731e85d7a38393c67de516b85304824bfb135e33bf22b3a23b913bf6acd2b7ab85198b8187b2bcd454d5e3318cacb32fd6261c31ae7f6c54ef6a7a2a4c9f3ecb81ce3555d4f0ad466dd4c108a90399d70041997c3b25345a9653f3c9a6711ab1b91d6a9d2216442da2c973cbd685ee7643bfd77327a2f7ae9cb283620a08716dfb462e5c1d65432ca9d56a90e811443cd1ecb8f0de179c9cb48ba4f6fec360c66f252f6e64edc96b", "fdadf0ae5dc053efb187d6055b44eab7bd7885523788f7a357274ac5472555ff");
        TestDigest.testKatHex(new Shabal256(), "b6134f9c3e91dd8000740d009dd806240811d51ab1546a974bcb18d344642baa5cd5903af84d58ec5ba17301d5ec0f10ccd0509cbb3fd3fff9172d193af0f782252fd1338c7244d40e0e42362275b22d01c4c3389f19dd69bdf958ebe28e31a4ffe2b5f18a87831cfb7095f58a87c9fa21db72ba269379b2dc2384b3da953c7925761fed324620acea435e52b424a7723f6a2357374157a34cd8252351c25a1b232826cefe1bd3e70ffc15a31e7c0598219d7f00436294d11891b82497bc78aa5363892a2495df8c1eef", "7b9a57fb8305ccb9de5f847d747ae5703c3b24ec920fdee37e7e89e68eafeaed");
        TestDigest.testKatHex(new Shabal256(), "c941cdb9c28ab0a791f2e5c8e8bb52850626aa89205bec3a7e22682313d198b1fa33fc7295381354858758ae6c8ec6fac3245c6e454d16fa2f51c4166fab51df272858f2d603770c40987f64442d487af49cd5c3991ce858ea2a60dab6a65a34414965933973ac2457089e359160b7cdedc42f29e10a91921785f6b7224ee0b349393cdcff6151b50b377d609559923d0984cda6000829b916ab6896693ef6a2199b3c22f7dc5500a15b8258420e314c222bc000bc4e5413e6dd82c993f8330f5c6d1be4bc79f08a1a0a46", "1b532aa863f55bd7d01305a4955edca16deef8a43f2b34edf9bf556e0a108d97");
        TestDigest.testKatHex(new Shabal256(), "4499efffac4bcea52747efd1e4f20b73e48758be915c88a1ffe5299b0b005837a46b2f20a9cb3c6e64a9e3c564a27c0f1c6ad1960373036ec5bfe1a8fc6a435c2185ed0f114c50e8b3e4c7ed96b06a036819c9463e864a58d6286f785e32a804443a56af0b4df6abc57ed5c2b185ddee8489ea080deeee66aa33c2e6dab36251c402682b6824821f998c32163164298e1fafd31babbcffb594c91888c6219079d907fdb438ed89529d6d96212fd55abe20399dbefd342248507436931cdead496eb6e4a80358acc78647d043", "f7c0a0c8aee65ebb8feec6045ae4c314b65b027f8d2c0157741ec44eb6546c6c");
        TestDigest.testKatHex(new Shabal256(), "eecbb8fdfa4da62170fd06727f697d81f83f601ff61e478105d3cb7502f2c89bf3e8f56edd469d049807a38882a7eefbc85fc9a950952e9fa84b8afebd3ce782d4da598002827b1eb98882ea1f0a8f7aa9ce013a6e9bc462fb66c8d4a18da21401e1b93356eb12f3725b6db1684f2300a98b9a119e5d27ff704affb618e12708e77e6e5f34139a5a41131fd1d6336c272a8fc37080f041c71341bee6ab550cb4a20a6ddb6a8e0299f2b14bc730c54b8b1c1c487b494bdccfd3a53535ab2f231590bf2c4062fd2ad58f906a2d0d", "66f91f57b99acd7487743cabcd8f9e6e97195c35d7d60a8b913a1526cbbdd19c");
        TestDigest.testKatHex(new Shabal256(), "e64f3e4ace5c8418d65fec2bc5d2a303dd458034736e3b0df719098be7a206deaf52d6ba82316caf330ef852375188cde2b39cc94aa449578a7e2a8e3f5a9d68e816b8d16889fbc0ebf0939d04f63033ae9ae2bdab73b88c26d6bd25ee460ee1ef58fb0afa92cc539f8c76d3d097e7a6a63ebb9b5887edf3cf076028c5bbd5b9db3211371ad3fe121d4e9bf44229f4e1ecf5a0f9f0eba4d5ceb72878ab22c3f0eb5a625323ac66f7061f4a81fac834471e0c59553f108475fe290d43e6a055ae3ee46fb67422f814a68c4be3e8c9", "1cfe4fad2fa40d2f1edfa6697ffe978d58a72cf10c14863851c13f85389b6b58");
        TestDigest.testKatHex(new Shabal256(), "d2cb2d733033f9e91395312808383cc4f0ca974e87ec68400d52e96b3fa6984ac58d9ad0938dde5a973008d818c49607d9de2284e7618f1b8aed8372fbd52ed54557af4220fac09dfa8443011699b97d743f8f2b1aef3537ebb45dcc9e13dfb438428ee190a4efdb3caeb7f3933117bf63abdc7e57beb4171c7e1ad260ab0587806c4d137b6316b50abc9cce0dff3acada47bbb86be777e617bbe578ff4519844db360e0a96c6701290e76bb95d26f0f804c8a4f2717eac4e7de9f2cff3bbc55a17e776c0d02856032a6cd10ad2838", "a87cef02e222d8777562735c6024da434c9e120bd787f2f02b0a9634b3b9d691");
        TestDigest.testKatHex(new Shabal256(), "f2998955613dd414cc111df5ce30a995bb792e260b0e37a5b1d942fe90171a4ac2f66d4928d7ad377f4d0554cbf4c523d21f6e5f379d6f4b028cdcb9b1758d3b39663242ff3cb6ede6a36a6f05db3bc41e0d861b384b6dec58bb096d0a422fd542df175e1be1571fb52ae66f2d86a2f6824a8cfaacbac4a7492ad0433eeb15454af8f312b3b2a577750e3efbd370e8a8cac1582581971fba3ba4bd0d76e718dacf8433d33a59d287f8cc92234e7a271041b526e389efb0e40b6a18b3aaf658e82ed1c78631fd23b4c3eb27c3faec8685", "ad93b9f0eadab5de28512e040ed18afb4a3630e8dceffe0354b924bb6ec77ca4");
        TestDigest.testKatHex(new Shabal256(), "447797e2899b72a356ba55bf4df3acca6cdb1041eb477bd1834a9f9acbc340a294d729f2f97df3a610be0ff15edb9c6d5db41644b9874360140fc64f52aa03f0286c8a640670067a84e017926a70438db1bb361defee7317021425f8821def26d1efd77fc853b818545d055adc9284796e583c76e6fe74c9ac2587aa46aa8f8804f2feb5836cc4b3ababab8429a5783e17d5999f32242eb59ef30cd7adabc16d72dbdb097623047c98989f88d14eaf02a7212be16ec2d07981aaa99949ddf89ecd90333a77bc4e1988a82abf7c7caf3291", "9f0a39815afdc8979d4617e4fa96e1a6abeec1cfbcb547ded77e8c0281e4ac59");
        TestDigest.testKatHex(new Shabal256(), "9f2c18ade9b380c784e170fb763e9aa205f64303067eb1bcea93df5dac4bf5a2e00b78195f808df24fc76e26cb7be31dc35f0844cded1567bba29858cffc97fb29010331b01d6a3fb3159cc1b973d255da9843e34a0a4061cabdb9ed37f241bfabb3c20d32743f4026b59a4ccc385a2301f83c0b0a190b0f2d01acb8f0d41111e10f2f4e149379275599a52dc089b35fdd5234b0cfb7b6d8aebd563ca1fa653c5c021dfd6f5920e6f18bfafdbecbf0ab00281333ed50b9a999549c1c8f8c63d7626c48322e9791d5ff72294049bde91e73f8", "5d1bec1affc0b37460ef27ef4188219b77ad23c36d8b99a8c9ca3cc7962439da");
        TestDigest.testKatHex(new Shabal256(), "ae159f3fa33619002ae6bcce8cbbdd7d28e5ed9d61534595c4c9f43c402a9bb31f3b301cbfd4a43ce4c24cd5c9849cc6259eca90e2a79e01ffbac07ba0e147fa42676a1d668570e0396387b5bcd599e8e66aaed1b8a191c5a47547f61373021fa6deadcb55363d233c24440f2c73dbb519f7c9fa5a8962efd5f6252c0407f190dfefad707f3c7007d69ff36b8489a5b6b7c557e79dd4f50c06511f599f56c896b35c917b63ba35c6ff8092baf7d1658e77fc95d8a6a43eeb4c01f33f03877f92774be89c1114dd531c011e53a34dc248a2f0e6", "deb14de3505e935dd17307876228f29dcc74e3c1f86c51907645c44acc2d0c46");
        TestDigest.testKatHex(new Shabal256(), "3b8e97c5ffc2d6a40fa7de7fcefc90f3b12c940e7ab415321e29ee692dfac799b009c99dcddb708fce5a178c5c35ee2b8617143edc4c40b4d313661f49abdd93cea79d117518805496fe6acf292c4c2a1f76b403a97d7c399daf85b46ad84e16246c67d6836757bde336c290d5d401e6c1386ab32797af6bb251e9b2d8fe754c47482b72e0b394eab76916126fd68ea7d65eb93d59f5b4c5ac40f7c3b37e7f3694f29424c24af8c8f0ef59cd9dbf1d28e0e10f799a6f78cad1d45b9db3d7dee4a7059abe99182714983b9c9d44d7f5643596d4f3", "9fa464881cad4d3a8fa456aef5e404088aeb022068a0d370beb00da69fbe0079");
        TestDigest.testKatHex(new Shabal256(), "3434ec31b10fafdbfeec0dd6bd94e80f7ba9dca19ef075f7eb017512af66d6a4bcf7d16ba0819a1892a6372f9b35bcc7ca8155ee19e8428bc22d214856ed5fa9374c3c09bde169602cc219679f65a1566fc7316f4cc3b631a18fb4449fa6afa16a3db2bc4212eff539c67cf184680826535589c7111d73bffce431b4c40492e763d9279560aaa38eb2dc14a212d723f994a1fe656ff4dd14551ce4e7c621b2aa5604a10001b2878a897a28a08095c325e10a26d2fb1a75bfd64c250309bb55a44f23bbac0d5516a1c687d3b41ef2fbbf9cc56d4739", "5d109349a7bb2074c525021feca63ba7a5c90a0bc97791b6e8f274de4d7efa37");
        TestDigest.testKatHex(new Shabal256(), "7c7953d81c8d208fd1c97681d48f49dd003456de60475b84070ef4847c333b74575b1fc8d2a186964485a3b8634feaa3595aaa1a2f4595a7d6b6153563dee31bbac443c8a33eed6d5d956a980a68366c2527b550ee950250dfb691eacbd5d56ae14b970668be174c89df2fea43ae52f13142639c884fd62a3683c0c3792f0f24ab1318bcb27e21f4737fab62c77ea38bc8fd1cf41f7dab64c13febe7152bf5bb7ab5a78f5346d43cc741cb6f72b7b8980f268b68bf62abdfb1577a52438fe14b591498cc95f071228460c7c5d5ceb4a7bde588e7f21c", "1699a77261d8472d48e1800dcef115c1c22be8d7c9692ac1501303b78aae38c5");
        TestDigest.testKatHex(new Shabal256(), "7a6a4f4fdc59a1d223381ae5af498d74b7252ecf59e389e49130c7eaee626e7bd9897effd92017f4ccde66b0440462cdedfd352d8153e6a4c8d7a0812f701cc737b5178c2556f07111200eb627dbc299caa792dfa58f35935299fa3a3519e9b03166dffa159103ffa35e8577f7c0a86c6b46fe13db8e2cdd9dcfba85bdddcce0a7a8e155f81f712d8e9fe646153d3d22c811bd39f830433b2213dd46301941b59293fd0a33e2b63adbd95239bc01315c46fdb678875b3c81e053a40f581cfbec24a1404b1671a1b88a6d06120229518fb13a74ca0ac5ae", "0414a2c77cf9e0a5b6f022ae2c97703aa217caf9895f883356da4efa28327a3e");
        TestDigest.testKatHex(new Shabal256(), "d9faa14cebe9b7de551b6c0765409a33938562013b5e8e0e1e0a6418df7399d0a6a771fb81c3ca9bd3bb8e2951b0bc792525a294ebd1083688806fe5e7f1e17fd4e3a41d00c89e8fcf4a363caedb1acb558e3d562f1302b3d83bb886ed27b76033798131dab05b4217381eaaa7ba15ec820bb5c13b516dd640eaec5a27d05fdfca0f35b3a5312146806b4c0275bcd0aaa3b2017f346975db566f9b4d137f4ee10644c2a2da66deeca5342e236495c3c6280528bfd32e90af4cd9bb908f34012b52b4bc56d48cc8a6b59bab014988eabd12e1a0a1c2e170e7", "71caef941c2905862ec61e80241ba54aeb44d5ea93d28aeb7156a23b116e9312");
        TestDigest.testKatHex(new Shabal256(), "2d8427433d0c61f2d96cfe80cf1e932265a191365c3b61aaa3d6dcc039f6ba2ad52a6a8cc30fc10f705e6b7705105977fa496c1c708a277a124304f1fc40911e7441d1b5e77b951aad7b01fd5db1b377d165b05bbf898042e39660caf8b279fe5229d1a8db86c0999ed65e53d01ccbc4b43173ccf992b3a14586f6ba42f5fe30afa8ae40c5df29966f9346da5f8b35f16a1de3ab6de0f477d8d8660918060e88b9b9e9ca6a4207033b87a812dbf5544d39e4882010f82b6ce005f8e8ff6fe3c3806bc2b73c2b83afb704345629304f9f86358712e9fae3ca3e", "518280901c96c9b191ca4f90fbc7fbb584624a280fdcabd0eaf7ccbf9c7783e1");
        TestDigest.testKatHex(new Shabal256(), "5e19d97887fcaac0387e22c6f803c34a3dacd2604172433f7a8a7a526ca4a2a1271ecfc5d5d7be5ac0d85d921095350dfc65997d443c21c8094e0a3fefd2961bcb94aed03291ae310ccda75d8ace4bc7d89e7d3e5d1650bda5d668b8b50bfc8e608e184f4d3a9a2badc4ff5f07e0c0bc8a9f2e0b2a26fd6d8c550008faaab75fd71af2a424bec9a7cd9d83fad4c8e9319115656a8717d3b523a68ff8004258b9990ed362308461804ba3e3a7e92d8f2ffae5c2fba55ba5a3c27c0a2f71bd711d2fe1799c2adb31b200035481e9ee5c4adf2ab9c0fa50b23975cf", "aea070e6c6555f32b3bb441bc8eb942711a346a5b4cf53955b90c96d1d87d7d6");
        TestDigest.testKatHex(new Shabal256(), "c8e976ab4638909387ce3b8d4e510c3230e5690e02c45093b1d297910abc481e56eea0f296f98379dfc9080af69e73b2399d1c143bee80ae1328162ce1ba7f6a8374679b20aacd380eb4e61382c99998704d62701afa914f9a2705cdb065885f50d086c3eb5753700c387118bb142f3e6da1e988dfb31ac75d7368931e45d1391a274b22f83ceb072f9bcabc0b216685bfd789f5023971024b1878a205442522f9ea7d8797a4102a3df41703768251fd5e017c85d1200a464118aa35654e7ca39f3c375b8ef8cbe7534dbc64bc20befb417cf60ec92f63d9ee7397", "523e349e7f94c80ea701fbf703a96e79a890f2b8aca4268e9a3e818a94fc1e8e");
        TestDigest.testKatHex(new Shabal256(), "7145fa124b7429a1fc2231237a949ba7201bcc1822d3272de005b682398196c25f7e5cc2f289fbf44415f699cb7fe6757791b1443410234ae061edf623359e2b4e32c19bf88450432dd01caa5eb16a1dc378f391ca5e3c4e5f356728bddd4975db7c890da8bbc84cc73ff244394d0d48954978765e4a00b593f70f2ca082673a261ed88dbcef1127728d8cd89bc2c597e9102ced6010f65fa75a14ebe467fa57ce3bd4948b6867d74a9df5c0ec6f530cbf2ee61ce6f06bc8f2864dff5583776b31df8c7ffcb61428a56bf7bd37188b4a5123bbf338393af46eda85e6", "5557cc8df1014e8df4f65e024d4c4aca63db4c3362e29f4e5e4aa792f599164c");
        TestDigest.testKatHex(new Shabal256(), "7fdfadcc9d29bad23ae038c6c65cda1aef757221b8872ed3d75ff8df7da0627d266e224e812c39f7983e4558bfd0a1f2bef3feb56ba09120ef762917b9c093867948547aee98600d10d87b20106878a8d22c64378bf634f7f75900c03986b077b0bf8b740a82447b61b99fee5376c5eb6680ec9e3088f0bdd0c56883413d60c1357d3c811950e5890e7600103c916341b80c743c6a852b7b4fb60c3ba21f3bc15b8382437a68454779cf3cd7f9f90ccc8ef28d0b706535b1e4108eb5627bb45d719cb046839aee311ca1abdc8319e050d67972cb35a6b1601b25dbf487", "61a8d3f8b4beeb8503c2d5c762f56eab1fe040156f7ae5cc6c1527574bbe3bbd");
        TestDigest.testKatHex(new Shabal256(), "988638219fd3095421f826f56e4f09e356296b628c3ce6930c9f2e758fd1a80c8273f2f61e4daae65c4f110d3e7ca0965ac7d24e34c0dc4ba2d6ff0bf5bbe93b3585f354d7543cb542a1aa54674d375077f2d360a8f4d42f3db131c3b7ab7306267ba107659864a90c8c909460a73621d1f5d9d3fd95beb19b23db1cb6c0d0fba91d36891529b8bd8263caa1bab56a4affaed44962df096d8d5b1eb845ef31188b3e10f1af811a13f156beb7a288aae593ebd1471b624aa1a7c6adf01e2200b3d72d88a3aed3100c88231e41efc376906f0b580dc895f080fda5741db1cb", "d5190dfe83ea26fdb7788b2e578f58d90b041ef47b509c4b498b24045160228b");
        TestDigest.testKatHex(new Shabal256(), "5aab62756d307a669d146aba988d9074c5a159b3de85151a819b117ca1ff6597f6156e80fdd28c9c3176835164d37da7da11d94e09add770b68a6e081cd22ca0c004bfe7cd283bf43a588da91f509b27a6584c474a4a2f3ee0f1f56447379240a5ab1fb77fdca49b305f07ba86b62756fb9efb4fc225c86845f026ea542076b91a0bc2cdd136e122c659be259d98e5841df4c2f60330d4d8cdee7bf1a0a244524eecc68ff2aef5bf0069c9e87a11c6e519de1a4062a10c83837388f7ef58598a3846f49d499682b683c4a062b421594fafbc1383c943ba83bdef515efcf10d", "cafe0b32472a19f307994544433a3f80146a1a3fd79c869df080b38feceb64c2");
        TestDigest.testKatHex(new Shabal256(), "47b8216aa0fbb5d67966f2e82c17c07aa2d6327e96fcd83e3de7333689f3ee79994a1bf45082c4d725ed8d41205cb5bcdf5c341f77facb1da46a5b9b2cbc49eadf786bcd881f371a95fa17df73f606519aea0ff79d5a11427b98ee7f13a5c00637e2854134691059839121fea9abe2cd1bcbbbf27c74caf3678e05bfb1c949897ea01f56ffa4dafbe8644611685c617a3206c7a7036e4ac816799f693dafe7f19f303ce4eba09d21e03610201bfc665b72400a547a1e00fa9b7ad8d84f84b34aef118515e74def11b9188bd1e1f97d9a12c30132ec2806339bdadacda2fd8b78", "eb130a90ac83af88d4486c0c1f29bf92c2fe87494465858b71100290516d28f6");
        TestDigest.testKatHex(new Shabal256(), "8cff1f67fe53c098896d9136389bd8881816ccab34862bb67a656e3d98896f3ce6ffd4da73975809fcdf9666760d6e561c55238b205d8049c1cedeef374d1735daa533147bfa960b2cce4a4f254176bb4d1bd1e89654432b8dbe1a135c42115b394b024856a2a83dc85d6782be4b444239567ccec4b184d4548eae3ff6a192f343292ba2e32a0f267f31cc26719eb85245d415fb897ac2da433ee91a99424c9d7f1766a44171d1651001c38fc79294accc68ceb5665d36218454d3ba169ae058a831338c17743603f81ee173bfc0927464f9bd728dee94c6aeab7aae6ee3a627e8", "193debfa8a3d51b8aea6eeeae4b35c5eb4a2b12758ffa5d69c090a6ca8999f0c");
        TestDigest.testKatHex(new Shabal256(), "eacd07971cff9b9939903f8c1d8cbb5d4db1b548a85d04e037514a583604e787f32992bf2111b97ac5e8a938233552731321522ab5e8583561260b7d13ebeef785b23a41fd8576a6da764a8ed6d822d4957a545d5244756c18aa80e1aad4d1f9c20d259dee1711e2cc8fd013169fb7cc4ce38b362f8e0936ae9198b7e838dcea4f7a5b9429bb3f6bbcf2dc92565e3676c1c5e6eb3dd2a0f86aa23edd3d0891f197447692794b3dfa269611ad97f72b795602b4fdb198f3fd3eb41b415064256e345e8d8c51c555dc8a21904a9b0f1ad0effab7786aac2da3b196507e9f33ca356427", "cc5e2348c7332039b00de59d35c642c7614806b72836c2bff6ce4a66f342cb80");
        TestDigest.testKatHex(new Shabal256(), "23ac4e9a42c6ef45c3336ce6dfc2ff7de8884cd23dc912fef0f7756c09d335c189f3ad3a23697abda851a81881a0c8ccafc980ab2c702564c2be15fe4c4b9f10dfb2248d0d0cb2e2887fd4598a1d4acda897944a2ffc580ff92719c95cf2aa42dc584674cb5a9bc5765b9d6ddf5789791d15f8dd925aa12bffafbce60827b490bb7df3dda6f2a143c8bf96abc903d83d59a791e2d62814a89b8080a28060568cf24a80ae61179fe84e0ffad00388178cb6a617d37efd54cc01970a4a41d1a8d3ddce46edbba4ab7c90ad565398d376f431189ce8c1c33e132feae6a8cd17a61c630012", "6d5a286ff541c3fee9a1fb49e6a99f64a04657cb8edff4b24b0542dac172c907");
        TestDigest.testKatHex(new Shabal256(), "0172df732282c9d488669c358e3492260cbe91c95cfbc1e3fea6c4b0ec129b45f242ace09f152fc6234e1bee8aab8cd56e8b486e1dcba9c05407c2f95da8d8f1c0af78ee2ed82a3a79ec0cb0709396ee62aadb84f8a4ee8a7ccca3c1ee84e302a09ea802204afecf04097e67d0f8e8a9d2651126c0a598a37081e42d168b0ae8a71951c524259e4e2054e535b779679bdade566fe55700858618e626b4a0faf895bcce9011504a49e05fd56127eae3d1f8917afb548ecadabda1020111fec9314c413498a360b08640549a22cb23c731ace743252a8227a0d2689d4c6001606678dfb921", "24372706f2d7a48473d3cfa644d7126581c282e0633f86583beb40b0d6669965");
        TestDigest.testKatHex(new Shabal256(), "3875b9240cf3e0a8b59c658540f26a701cf188496e2c2174788b126fd29402d6a75453ba0635284d08835f40051a2a9683dc92afb9383719191231170379ba6f4adc816fecbb0f9c446b785bf520796841e58878b73c58d3ebb097ce4761fdeabe15de2f319dfbaf1742cdeb389559c788131a6793e193856661376c81ce9568da19aa6925b47ffd77a43c7a0e758c37d69254909ff0fbd415ef8eb937bcd49f91468b49974c07dc819abd67395db0e05874ff83dddab895344abd0e7111b2df9e58d76d85ad98106b36295826be04d435615595605e4b4bb824b33c4afeb5e7bb0d19f909", "0ec5ce96e716fcc3bd47feb94f9d52ca2dfeb82f47818a036e73ef6501a9ff6c");
        TestDigest.testKatHex(new Shabal256(), "747cc1a59fefba94a9c75ba866c30dc5c1cb0c0f8e9361d98484956dd5d1a40f6184afbe3dac9f76028d1caeccfbf69199c6ce2b4c092a3f4d2a56fe5a33a00757f4d7dee5dfb0524311a97ae0668a47971b95766e2f6dd48c3f57841f91f04a00ad5ea70f2d479a2620dc5cd78eaab3a3b011719b7e78d19ddf70d9423798af77517ebc55392fcd01fc600d8d466b9e7a7a85bf33f9cc5419e9bd874ddfd60981150ddaf8d7febaa4374f0872a5628d318000311e2f5655365ad4d407c20e5c04df17a222e7deec79c5ab1116d8572f91cd06e1ccc7ced53736fc867fd49ecebe6bf8082e8a", "3d4e4ede52f57e462a7f4bd54a10172c8eaf92eb6f6518df7b26b11259d22d03");
        TestDigest.testKatHex(new Shabal256(), "57af971fccaec97435dc2ec9ef0429bcedc6b647729ea168858a6e49ac1071e706f4a5a645ca14e8c7746d65511620682c906c8b86ec901f3dded4167b3f00b06cbfac6aee3728051b3e5ff10b4f9ed8bd0b8da94303c833755b3ca3aeddf0b54bc8d6632138b5d25bab03d17b3458a9d782108006f5bb7de75b5c0ba854b423d8bb801e701e99dc4feaad59bc1c7112453b04d33ea3635639fb802c73c2b71d58a56bbd671b18fe34ed2e3dca38827d63fdb1d4fb3285405004b2b3e26081a8ff08cd6d2b08f8e7b7e90a2ab1ed7a41b1d0128522c2f8bff56a7fe67969422ce839a9d4608f03", "5a4227b59dad1459c6d508bbea973d65f947582dd184c5b215a8f25e072cd8f5");
        TestDigest.testKatHex(new Shabal256(), "04e16dedc1227902baaf332d3d08923601bdd64f573faa1bb7201918cfe16b1e10151dae875da0c0d63c59c3dd050c4c6a874011b018421afc4623ab0381831b2da2a8ba42c96e4f70864ac44e106f94311051e74c77c1291bf5db9539e69567bf6a11cf6932bbbad33f8946bf5814c066d851633d1a513510039b349939bfd42b858c21827c8ff05f1d09b1b0765dc78a135b5ca4dfba0801bcaddfa175623c8b647eacfb4444b85a44f73890607d06d507a4f8393658788669f6ef4deb58d08c50ca0756d5e2f49d1a7ad73e0f0b3d3b5f090acf622b1878c59133e4a848e05153592ea81c6fbf", "8a1eaf1902a0d6cbca48a1fc320b1db4e195931aa64656dc60598d55ea8bdfda");
        TestDigest.testKatHex(new Shabal256(), "7c815c384eee0f288ece27cced52a01603127b079c007378bc5d1e6c5e9e6d1c735723acbbd5801ac49854b2b569d4472d33f40bbb8882956245c366dc3582d71696a97a4e19557e41e54dee482a14229005f93afd2c4a7d8614d10a97a9dfa07f7cd946fa45263063ddd29db8f9e34db60daa32684f0072ea2a9426ecebfa5239fb67f29c18cbaa2af6ed4bf4283936823ac1790164fec5457a9cba7c767ca59392d94cab7448f50eb34e9a93a80027471ce59736f099c886dea1ab4cba4d89f5fc7ae2f21ccd27f611eca4626b2d08dc22382e92c1efb2f6afdc8fdc3d2172604f5035c46b8197d3", "47d4a2ac8b4b86e8870cce3f0b17cecd1556071fd67b8e3c71aee6a5a5415a15");
        TestDigest.testKatHex(new Shabal256(), "e29d505158dbdd937d9e3d2145658ee6f5992a2fc790f4f608d9cdb44a091d5b94b88e81fac4fdf5c49442f13b911c55886469629551189eaff62488f1a479b7db11a1560e198ddccccf50159093425ff7f1cb8d1d1246d0978764087d6bac257026b090efae8cec5f22b6f21c59ace1ac7386f5b8837ca6a12b6fbf5534dd0560ef05ca78104d3b943ddb220feaec89aa5e692a00f822a2ab9a2fe60350d75e7be16ff2526dc643872502d01f42f188abed0a6e9a6f5fd0d1ce7d5755c9ffa66b0af0b20bd806f08e06156690d81ac811778ca3dac2c249b96002017fce93e507e3b953acf99964b847", "2fce7db05e5e79d6d46084718773cfd62f94dc173317785aba1551c62a5b2d89");
        TestDigest.testKatHex(new Shabal256(), "d85588696f576e65eca0155f395f0cfacd83f36a99111ed5768df2d116d2121e32357ba4f54ede927f189f297d3a97fad4e9a0f5b41d8d89dd7fe20156799c2b7b6bf9c957ba0d6763f5c3bc5129747bbb53652b49290cff1c87e2cdf2c4b95d8aaee09bc8fbfa6883e62d237885810491bfc101f1d8c636e3d0ede838ad05c207a3df4fad76452979eb99f29afaecedd1c63b8d36cf378454a1bb67a741c77ac6b6b3f95f4f02b64dabc15438613ea49750df42ee90101f115aa9abb9ff64324dde9dabbb01054e1bd6b4bcdc7930a44c2300d87ca78c06924d0323ad7887e46c90e8c4d100acd9eed21e", "2e5a308dc96ae57db9d8fab015504cd1a51a14d2997c93ecd13115a24835cb71");
        TestDigest.testKatHex(new Shabal256(), "3a12f8508b40c32c74492b66323375dcfe49184c78f73179f3314b79e63376b8ac683f5a51f1534bd729b02b04d002f55cbd8e8fc9b5ec1ea6bbe6a0d0e7431518e6ba45d124035f9d3dce0a8bb7bf1430a9f657e0b4ea9f20eb20c786a58181a1e20a96f1628f8728a13bdf7a4b4b32fc8aa7054cc4881ae7fa19afa65c6c3ee1b3ade3192af42054a8a911b8ec1826865d46d93f1e7c5e2b7813c92a506e53886f3d4701bb93d2a681ad109c845904bb861af8af0646b6e399b38b614051d34f6842563a0f37ec00cb3d865fc5d746c4987de2a65071100883a2a9c7a2bfe1e2dd603d9ea24dc7c5fd06be", "e8b3aa086bf1859b82346fefd4b2435506b6677ae1fb45b9921f4a13248611e9");
        TestDigest.testKatHex(new Shabal256(), "1861edce46fa5ad17e1ff1deae084dec580f97d0a67885dfe834b9dfac1ae076742ce9e267512ca51f6df5a455af0c5fd6abf94acea103a3370c354485a7846fb84f3ac7c2904b5b2fbf227002ce512133bb7e1c4e50057bfd1e44db33c7cdb969a99e284b184f50a14b068a1fc5009d9b298dbe92239572a7627aac02abe8f3e3b473417f36d4d2505d16b7577f4526c9d94a270a2dfe450d06da8f6fa956879a0a55cfe99e742ea555ea477ba3e9b44ccd508c375423611af92e55345dc215779b2d5119eba49c71d49b9fe3f1569fa24e5ca3e332d042422a8b8158d3ec66a80012976f31ffdf305f0c9c5e", "1554793159d5f0b79bd34513af7b8140f7355aa003cf1c8b5c2f13b366989f0b");
        TestDigest.testKatHex(new Shabal256(), "08d0ffde3a6e4ef65608ea672e4830c12943d7187ccff08f4941cfc13e545f3b9c7ad5eebbe2b01642b486caf855c2c73f58c1e4e3391da8e2d63d96e15fd84953ae5c231911b00ad6050cd7aafdaac9b0f663ae6aab45519d0f5391a541707d479034e73a6ad805ae3598096af078f1393301493d663dd71f83869ca27ba508b7e91e81e128c1716dc3acfe3084b2201e04cf8006617eecf1b640474a5d45cfde9f4d3ef92d6d055b909892194d8a8218db6d8203a84261d200d71473d7488f3427416b6896c137d455f231071cacbc86e0415ab88aec841d96b7b8af41e05bb461a40645bf176601f1e760de5f", "ee073d32dc8ffef11bb632182f0efbd6b3cba014a5066fba217fe7b0d0c371dd");
        TestDigest.testKatHex(new Shabal256(), "d782abb72a5be3392757be02d3e45be6e2099d6f000d042c8a543f50ed6ebc055a7f133b0dd8e9bc348536edcaae2e12ec18e8837df7a1b3c87ec46d50c241dee820fd586197552dc20beea50f445a07a38f1768a39e2b2ff05dddedf751f1def612d2e4d810daa3a0cc904516f9a43af660315385178a529e51f8aae141808c8bc5d7b60cac26bb984ac1890d0436ef780426c547e94a7b08f01acbfc4a3825eae04f520a9016f2fb8bf5165ed12736fc71e36a49a73614739eaa3ec834069b1b40f1350c2b3ab885c02c640b9f7686ed5f99527e41cfcd796fe4c256c9173186c226169ff257954ebda81c0e5f99", "efaf7286e9bd4c684a2c29d2a2a6e12bf6971d90c169c01d4f9312128cb4491e");
        TestDigest.testKatHex(new Shabal256(), "5fce8109a358570e40983e1184e541833bb9091e280f258cfb144387b05d190e431cb19baa67273ba0c58abe91308e1844dcd0b3678baa42f335f2fa05267a0240b3c718a5942b3b3e3bfa98a55c25a1466e8d7a603722cb2bbf03afa54cd769a99f310735ee5a05dae2c22d397bd95635f58c48a67f90e1b73aafcd3f82117f0166657838691005b18da6f341d6e90fc1cdb352b30fae45d348294e501b63252de14740f2b85ae5299ddec3172de8b6d0ba219a20a23bb5e10ff434d39db3f583305e9f5c039d98569e377b75a70ab837d1df269b8a4b566f40bb91b577455fd3c356c914fa06b9a7ce24c7317a172d", "6042e1838af5a6b6f11f32d9a35d14f35d113b0e839a1b5975eb5ba52e2b25cc");
        TestDigest.testKatHex(new Shabal256(), "6172f1971a6e1e4e6170afbad95d5fec99bf69b24b674bc17dd78011615e502de6f56b86b1a71d3f4348087218ac7b7d09302993be272e4a591968aef18a1262d665610d1070ee91cc8da36e1f841a69a7a682c580e836941d21d909a3afc1f0b963e1ca5ab193e124a1a53df1c587470e5881fb54dae1b0d840f0c8f9d1b04c645ba1041c7d8dbf22030a623aa15638b3d99a2c400ff76f3252079af88d2b37f35ee66c1ad7801a28d3d388ac450b97d5f0f79e4541755356b3b1a5696b023f39ab7ab5f28df4202936bc97393b93bc915cb159ea1bd7a0a414cb4b7a1ac3af68f50d79f0c9c7314e750f7d02faa58bfa", "df38a26011fb38a869dc42a8ae41ec812b240b6b2047c736a4bb07477c4b99b1");
        TestDigest.testKatHex(new Shabal256(), "5668ecd99dfbe215c4118398ac9c9eaf1a1433fab4ccdd3968064752b625ea944731f75d48a27d047d67547f14dd0ffaa55fa5e29f7af0d161d85eafc4f2029b717c918eab9d304543290bdba7158b68020c0ba4e079bc95b5bc0fc044a992b94b4ccd3bd66d0eabb5dbbab904d62e00752c4e3b0091d773bcf4c14b4377da3efff824b1cb2fa01b32d1e46c909e626ed2dae920f4c7dbeb635bc754facbd8d49beba3f23c1c41ccbfcd0ee0c114e69737f5597c0bf1d859f0c767e18002ae8e39c26261ffde2920d3d0baf0e906138696cfe5b7e32b600f45df3aaa39932f3a7df95b60fa8712a2271fcaf3911ce7b511b1", "c75ac2626bc40ef4ceaaf62afdd2010d8042abec461db1eb1def14658a0aa4ed");
        TestDigest.testKatHex(new Shabal256(), "03d625488354df30e3f875a68edfcf340e8366a8e1ab67f9d5c5486a96829dfac0578289082b2a62117e1cf418b43b90e0adc881fc6ae8105c888e9ecd21aea1c9ae1a4038dfd17378fed71d02ae492087d7cdcd98f746855227967cb1ab4714261ee3bead3f4db118329d3ebef4bc48a875c19ba763966da0ebea800e01b2f50b00e9dd4caca6dcb314d00184ef71ea2391d760c950710db4a70f9212ffc54861f9dc752ce18867b8ad0c48df8466ef7231e7ac567f0eb55099e622ebb86cb237520190a61c66ad34f1f4e289cb3282ae3eaac6152ed24d2c92bae5a7658252a53c49b7b02dfe54fdb2e90074b6cf310ac661", "15dbd37ed425141dd8e6b49698ddb26245ad68ba460bd08aecb3dbcf93d67c51");
        TestDigest.testKatHex(new Shabal256(), "2edc282ffb90b97118dd03aaa03b145f363905e3cbd2d50ecd692b37bf000185c651d3e9726c690d3773ec1e48510e42b17742b0b0377e7de6b8f55e00a8a4db4740cee6db0830529dd19617501dc1e9359aa3bcf147e0a76b3ab70c4984c13e339e6806bb35e683af8527093670859f3d8a0fc7d493bcba6bb12b5f65e71e705ca5d6c948d66ed3d730b26db395b3447737c26fad089aa0ad0e306cb28bf0acf106f89af3745f0ec72d534968cca543cd2ca50c94b1456743254e358c1317c07a07bf2b0eca438a709367fafc89a57239028fc5fecfd53b8ef958ef10ee0608b7f5cb9923ad97058ec067700cc746c127a61ee3", "a78a97ad5ff2fc7a57fd50e364692768e6bc1803c1ac52de3fa095a8413491d3");
        TestDigest.testKatHex(new Shabal256(), "90b28a6aa1fe533915bcb8e81ed6cacdc10962b7ff82474f845eeb86977600cf70b07ba8e3796141ee340e3fce842a38a50afbe90301a3bdcc591f2e7d9de53e495525560b908c892439990a2ca2679c5539ffdf636777ad9c1cdef809cda9e8dcdb451abb9e9c17efa4379abd24b182bd981cafc792640a183b61694301d04c5b3eaad694a6bd4cc06ef5da8fa23b4fa2a64559c5a68397930079d250c51bcf00e2b16a6c49171433b0aadfd80231276560b80458dd77089b7a1bbcc9e7e4b9f881eacd6c92c4318348a13f4914eb27115a1cfc5d16d7fd94954c3532efaca2cab025103b2d02c6fd71da3a77f417d7932685888a", "7800a1a47b215c8f415f44beceb36dcb78fc6b7624b3a2ea1472add178fa03d6");
        TestDigest.testKatHex(new Shabal256(), "2969447d175490f2aa9bb055014dbef2e6854c95f8d60950bfe8c0be8de254c26b2d31b9e4de9c68c9adf49e4ee9b1c2850967f29f5d08738483b417bb96b2a56f0c8aca632b552059c59aac3f61f7b45c966b75f1d9931ff4e596406378cee91aaa726a3a84c33f37e9cdbe626b5745a0b06064a8a8d56e53aaf102d23dd9df0a3fdf7a638509a6761a33fa42fa8ddbd8e16159c93008b53765019c3f0e9f10b144ce2ac57f5d7297f9c9949e4ff68b70d339f87501ce8550b772f32c6da8ad2ce2100a895d8b08fa1eead7c376b407709703c510b50f87e73e43f8e7348f87c3832a547ef2bbe5799abedcf5e1f372ea809233f006", "521fb873c30ab74e1fae88c036ca15a9ea6a6e026ec8a6eca77d8aadc5d06c2c");
        TestDigest.testKatHex(new Shabal256(), "721645633a44a2c78b19024eaecf58575ab23c27190833c26875dc0f0d50b46aea9c343d82ea7d5b3e50ec700545c615daeaea64726a0f05607576dcd396d812b03fb6551c641087856d050b10e6a4d5577b82a98afb89cee8594c9dc19e79feff0382fcfd127f1b803a4b9946f4ac9a4378e1e6e041b1389a53e3450cd32d9d2941b0cbabdb50da8ea2513145164c3ab6bcbd251c448d2d4b087ac57a59c2285d564f16da4ed5e607ed979592146ffb0ef3f3db308fb342df5eb5924a48256fc763141a278814c82d6d6348577545870ae3a83c7230ac02a1540fe1798f7ef09e335a865a2ae0949b21e4f748fb8a51f44750e213a8fb", "8a65e0d96ceb7609966b1b59f983c410a51d2bf378c4225aac71488362fccf53");
        TestDigest.testKatHex(new Shabal256(), "6b860d39725a14b498bb714574b4d37ca787404768f64c648b1751b353ac92bac2c3a28ea909fdf0423336401a02e63ec24325300d823b6864bb701f9d7c7a1f8ec9d0ae3584aa6dd62ea1997cd831b4babd9a4da50932d4efda745c61e4130890e156aee6113716daf95764222a91187db2effea49d5d0596102d619bd26a616bbfda8335505fbb0d90b4c180d1a2335b91538e1668f9f9642790b4e55f9cab0fe2bdd2935d001ee6419abab5457880d0dbff20ed8758f4c20fe759efb33141cf0e892587fe8187e5fbc57786b7e8b089612c936dfc03d27efbbe7c8673f1606bd51d5ff386f4a7ab68edf59f385eb1291f117bfe717399", "66e594a605e8f445f638dd689f478f0870b3e37f67eb43992907939496e31d1c");
        TestDigest.testKatHex(new Shabal256(), "6a01830af3889a25183244decb508bd01253d5b508ab490d3124afbf42626b2e70894e9b562b288d0a2450cfacf14a0ddae5c04716e5a0082c33981f6037d23d5e045ee1ef2283fb8b6378a914c5d9441627a722c282ff452e25a7ea608d69cee4393a0725d17963d0342684f255496d8a18c2961145315130549311fc07f0312fb78e6077334f87eaa873bee8aa95698996eb21375eb2b4ef53c14401207deb4568398e5dd9a7cf97e8c9663e23334b46912f8344c19efcf8c2ba6f04325f1a27e062b62a58d0766fc6db4d2c6a1928604b0175d872d16b7908ebc041761187cc785526c2a3873feac3a642bb39f5351550af9770c328af7b", "4410ebd344d4b80ef83ed2b6b81e16d32303783c1e7e8a7472b56d5d05afc38c");
        TestDigest.testKatHex(new Shabal256(), "b3c5e74b69933c2533106c563b4ca20238f2b6e675e8681e34a389894785bdade59652d4a73d80a5c85bd454fd1e9ffdad1c3815f5038e9ef432aac5c3c4fe840cc370cf86580a6011778bbedaf511a51b56d1a2eb68394aa299e26da9ada6a2f39b9faff7fba457689b9c1a577b2a1e505fdf75c7a0a64b1df81b3a356001bf0df4e02a1fc59f651c9d585ec6224bb279c6beba2966e8882d68376081b987468e7aed1ef90ebd090ae825795cdca1b4f09a979c8dfc21a48d8a53cdbb26c4db547fc06efe2f9850edd2685a4661cb4911f165d4b63ef25b87d0a96d3dff6ab0758999aad214d07bd4f133a6734fde445fe474711b69a98f7e2b", "f111b50c6b39e6f3acd32fed4e6675d675605fe3b928b7b248dd1ac1268ebb56");
        TestDigest.testKatHex(new Shabal256(), "83af34279ccb5430febec07a81950d30f4b66f484826afee7456f0071a51e1bbc55570b5cc7ec6f9309c17bf5befdd7c6ba6e968cf218a2b34bd5cf927ab846e38a40bbd81759e9e33381016a755f699df35d660007b5eadf292feefb735207ebf70b5bd17834f7bfa0e16cb219ad4af524ab1ea37334aa66435e5d397fc0a065c411ebbce32c240b90476d307ce802ec82c1c49bc1bec48c0675ec2a6c6f3ed3e5b741d13437095707c565e10d8a20b8c20468ff9514fcf31b4249cd82dcee58c0a2af538b291a87e3390d737191a07484a5d3f3fb8c8f15ce056e5e5f8febe5e1fb59d6740980aa06ca8a0c20f5712b4cde5d032e92ab89f0ae1", "07c438ac4e4422cb60232f2558378221527f645ea9e67597c715610af5a6b9e1");
        TestDigest.testKatHex(new Shabal256(), "a7ed84749ccc56bb1dfba57119d279d412b8a986886d810f067af349e8749e9ea746a60b03742636c464fc1ee233acc52c1983914692b64309edfdf29f1ab912ec3e8da074d3f1d231511f5756f0b6eead3e89a6a88fe330a10face267bffbfc3e3090c7fd9a850561f363ad75ea881e7244f80ff55802d5ef7a1a4e7b89fcfa80f16df54d1b056ee637e6964b9e0ffd15b6196bdd7db270c56b47251485348e49813b4eb9ed122a01b3ea45ad5e1a929df61d5c0f3e77e1fdc356b63883a60e9cbb9fc3e00c2f32dbd469659883f690c6772e335f617bc33f161d6f6984252ee12e62b6000ac5231e0c9bc65be223d8dfd94c5004a101af9fd6c0fb", "63114f686c9a6e860818f09bf7cb964914e5b03d61f48cf47b805197b0013a3b");
        TestDigest.testKatHex(new Shabal256(), "a6fe30dcfcda1a329e82ab50e32b5f50eb25c873c5d2305860a835aecee6264aa36a47429922c4b8b3afd00da16035830edb897831c4e7b00f2c23fc0b15fdc30d85fb70c30c431c638e1a25b51caf1d7e8b050b7f89bfb30f59f0f20fecff3d639abc4255b3868fc45dd81e47eb12ab40f2aac735df5d1dc1ad997cefc4d836b854cee9ac02900036f3867fe0d84afff37bde3308c2206c62c4743375094108877c73b87b2546fe05ea137bedfc06a2796274099a0d554da8f7d7223a48cbf31b7decaa1ebc8b145763e3673168c1b1b715c1cd99ecd3ddb238b06049885ecad9347c2436dff32c771f34a38587a44a82c5d3d137a03caa27e66c8ff6", "d99b0357530e1d4f91b2e2e816cd2afb95316ce4052d4ce70cb423a200c427be");
        TestDigest.testKatHex(new Shabal256(), "83167ff53704c3aa19e9fb3303539759c46dd4091a52ddae9ad86408b69335989e61414bc20ab4d01220e35241eff5c9522b079fba597674c8d716fe441e566110b6211531ceccf8fd06bc8e511d00785e57788ed9a1c5c73524f01830d2e1148c92d0edc97113e3b7b5cd3049627abdb8b39dd4d6890e0ee91993f92b03354a88f52251c546e64434d9c3d74544f23fb93e5a2d2f1fb15545b4e1367c97335b0291944c8b730ad3d4789273fa44fb98d78a36c3c3764abeeac7c569c1e43a352e5b770c3504f87090dee075a1c4c85c0c39cf421bdcc615f9eff6cb4fe6468004aece5f30e1ecc6db22ad9939bb2b0ccc96521dfbf4ae008b5b46bc006e", "02054e70511c5052bdd840559e70954d22dac4cfdea9b92f3891cdc8907315fb");
        TestDigest.testKatHex(new Shabal256(), "3a3a819c48efde2ad914fbf00e18ab6bc4f14513ab27d0c178a188b61431e7f5623cb66b23346775d386b50e982c493adbbfc54b9a3cd383382336a1a0b2150a15358f336d03ae18f666c7573d55c4fd181c29e6ccfde63ea35f0adf5885cfc0a3d84a2b2e4dd24496db789e663170cef74798aa1bbcd4574ea0bba40489d764b2f83aadc66b148b4a0cd95246c127d5871c4f11418690a5ddf01246a0c80a43c70088b6183639dcfda4125bd113a8f49ee23ed306faac576c3fb0c1e256671d817fc2534a52f5b439f72e424de376f4c565cca82307dd9ef76da5b7c4eb7e085172e328807c02d011ffbf33785378d79dc266f6a5be6bb0e4a92eceebaeb1", "25121361afe9d75ec3024c662130115d3d3e9744fd5060950240119937434aad");
        TestDigest.reportSuccess("Shabal-256");
    }

    private static void testShabal384() {
        TestDigest.testKatHex(new Shabal384(), "", "ff093d67d22b06a674b5f384719150d617e0ff9c8923569a2ab60cda886df63c91a25f33cd71cc22c9eebc5cd6aee52a");
        TestDigest.testKatHex(new Shabal384(), "cc", "da6e116f4fc2740abb1308089251582e516c1b0da5e56492126e3aa8fe4be1a9ce5d58514cf32a5c1bd9211b535acfb5");
        TestDigest.testKatHex(new Shabal384(), "41fb", "f3b641253750a156b84750a9ff6beaf19b96426f0189df0a749f792a1a78543cbd419b324bb24d999ebbd188f9cfb62f");
        TestDigest.testKatHex(new Shabal384(), "1f877c", "796411d75fb36c8025a2f69c1ca0c10f0d88902291c4cec14375ce73194defc91e98a54c09b1e86f10a9641fac57b916");
        TestDigest.testKatHex(new Shabal384(), "c1ecfdfc", "1f4c7ddce5089de154ceba5def970903195ca1c45cbda93a0860e387e65915f9946bfa625065d5c64ecdd3d2d6282042");
        TestDigest.testKatHex(new Shabal384(), "21f134ac57", "f83540065bbe7716124c7cbb9d1c747311ad13897d015cb65ec658d3bf4fb1a64dec0a57a5085ffc653db0c59ec9688e");
        TestDigest.testKatHex(new Shabal384(), "c6f50bb74e29", "513353b95143c1c33cf2dac68d73ed92e3be052b92f05d246605437078916494e7190cad974f4f30042cec5c54c96826");
        TestDigest.testKatHex(new Shabal384(), "119713cc83eeef", "c47e41e79e48e3319f178fef09bbc411585be28a271c35c0fd3fdbe186d60e514ec1be5fe12f4339bad1561e55b432e4");
        TestDigest.testKatHex(new Shabal384(), "4a4f202484512526", "50fdaaffb12ead8d0a84ca4ad9569da280f8959f273fa8d62c2da6be64eecc29dca987051f4b48d4a02354d7396442e9");
        TestDigest.testKatHex(new Shabal384(), "1f66ab4185ed9b6375", "084ef351bfbae50d247183dcd88f240a5bfddd511b2fa285b736d78f9e71be2de245654145d239142622d125d2a56b82");
        TestDigest.testKatHex(new Shabal384(), "eed7422227613b6f53c9", "fd9d38ad6ad915be998e076cd260e5703f701ac5bbe4a0c708ff7edccc2eb3d0f7c4fcfcb44020f82c577a95833ad4c5");
        TestDigest.testKatHex(new Shabal384(), "eaeed5cdffd89dece455f1", "0a422782b03917acffaa363a292a45903f2dcd544c3206993fc2dfba90106ebde33bccd6965d559370cc0ec4f99879ad");
        TestDigest.testKatHex(new Shabal384(), "5be43c90f22902e4fe8ed2d3", "c57a3255341d67377548694b7617758fa30e1627017651af3195ce14a135b737fc3ae23fbd67189787fcdb2434b09bb2");
        TestDigest.testKatHex(new Shabal384(), "a746273228122f381c3b46e4f1", "3587f792d92ed9152a174c17294e0ef38d95debdb2f43a811bea85a7c0de849bdc2333f48055be6fa0abd198877d3cf7");
        TestDigest.testKatHex(new Shabal384(), "3c5871cd619c69a63b540eb5a625", "fdcfe7f3dcd310d8ddca22701b87e299c4b1c5a42d3716df4d66ae04db8fa94c81805d3cf17b8a05dbf01f64c939e3a0");
        TestDigest.testKatHex(new Shabal384(), "fa22874bcc068879e8ef11a69f0722", "fc2a411021384e031d4d4efd1605fb58d881ddf10d46da8085a7b8b02c0e47815ace6b8eb446eaeb01ea1d6eccd4003a");
        TestDigest.testKatHex(new Shabal384(), "52a608ab21ccdd8a4457a57ede782176", "91399966a2d9009133c0ccd3b84eb94c04b556b195074a402a07482d0e45e1b47e49a07031ef010b70030a686198028c");
        TestDigest.testKatHex(new Shabal384(), "82e192e4043ddcd12ecf52969d0f807eed", "a66a8a95c1876e7d8caeb2980e6e81fe98d4ecb51fba71ac9f67e6d7cd7350e75c698bc6c147e0baca0a24dead24f404");
        TestDigest.testKatHex(new Shabal384(), "75683dcb556140c522543bb6e9098b21a21e", "bdb4a71b2bb63a117dbac238b35a65a010fa090971adeccde878a27f5bc97c699ec88fe4b18ac3b72c0f4a958b363baa");
        TestDigest.testKatHex(new Shabal384(), "06e4efe45035e61faaf4287b4d8d1f12ca97e5", "1335ee372d7f6e11d4aff5b96f3e7f9a81aea99a4bef103dd5ddecd6fa177a3d03e673299f7b653143fa9cb454ced90b");
        TestDigest.testKatHex(new Shabal384(), "e26193989d06568fe688e75540aea06747d9f851", "47630e21e65c03f318051de43c3d9f0fab0231078774f08c0aea9880e9a9329d3d4cfeb7379d804aa8a9c3b9f12618c4");
        TestDigest.testKatHex(new Shabal384(), "d8dc8fdefbdce9d44e4cbafe78447bae3b5436102a", "bf4badcdb081b6401c28ba778567111bd644f958c295536e2b2306c12c65193ee4d4b85ac27a9d9f1ff49f19ffaa14a7");
        TestDigest.testKatHex(new Shabal384(), "57085fd7e14216ab102d8317b0cb338a786d5fc32d8f", "255f0702f69a9d2eeab0fdf16b3c659b089fb9663bd5463682d477143e82abe096089acb5a60ab99cfd58fcaea8566c9");
        TestDigest.testKatHex(new Shabal384(), "a05404df5dbb57697e2c16fa29defac8ab3560d6126fa0", "20bf86df325e8b44911e4714fdd10e0667f596333f808941fe142f400571af8de4e11a7d18117c483548f1d0505b7a43");
        TestDigest.testKatHex(new Shabal384(), "aecbb02759f7433d6fcb06963c74061cd83b5b3ffa6f13c6", "3b8075927601790f106cbc9a16c8e8283cd95599098a4cf57e9a3571381372d676b144bcf73f327d5d49692db689fe63");
        TestDigest.testKatHex(new Shabal384(), "aafdc9243d3d4a096558a360cc27c8d862f0be73db5e88aa55", "b283b32e801065276bca263b670c7ae866e1c379c0eacfb0d1c210cd294fddce9260a81b6985bd48452f8a9a8128d049");
        TestDigest.testKatHex(new Shabal384(), "7bc84867f6f9e9fdc3e1046cae3a52c77ed485860ee260e30b15", "48bdbbefaa8817025b9f430096708291a58f1a45b337b687fdf2cc2aeb210da08c3bd99835711c8ee60150201fc49436");
        TestDigest.testKatHex(new Shabal384(), "fac523575a99ec48279a7a459e98ff901918a475034327efb55843", "a9c33633c1cb2fcabcd037185d0c32c9d4931538390d5c1c7e25682d07ed79b226ae512ca44bc8d6e3c56fee0864f7d0");
        TestDigest.testKatHex(new Shabal384(), "0f8b2d8fcfd9d68cffc17ccfb117709b53d26462a3f346fb7c79b85e", "983f180de78d64ee4edffc5b79e92821089487d6a1fc47f863f4bb17d412c7fe64244249390dc3bbf2f4e9bea8ae26da");
        TestDigest.testKatHex(new Shabal384(), "a963c3e895ff5a0be4824400518d81412f875fa50521e26e85eac90c04", "3a0f5717e032083d97fbca29407a285fb155e34c0f36ba99ac21c4335385006c4282997c61fe3996303f85bc9494e902");
        TestDigest.testKatHex(new Shabal384(), "03a18688b10cc0edf83adf0a84808a9718383c4070c6c4f295098699ac2c", "56a36192626610beabffdfac4ee2cd09f7996233f3494e8b8ef50b3abd1d48262b981af75fc9dd795394ba52ffa1f703");
        TestDigest.testKatHex(new Shabal384(), "84fb51b517df6c5accb5d022f8f28da09b10232d42320ffc32dbecc3835b29", "96bc0b2a628b5ca8e45c249b3c6464fcda886aa4e8158879a5b9ae9d9bababd668d0a16beb9265913732a5a9c2deabfc");
        TestDigest.testKatHex(new Shabal384(), "9f2fcc7c90de090d6b87cd7e9718c1ea6cb21118fc2d5de9f97e5db6ac1e9c10", "809de8085383deed181a44e45e872c82532582219e47320a18046f8f7cd81d92753b3ea043257be04a8129678ea9ddb5");
        TestDigest.testKatHex(new Shabal384(), "de8f1b3faa4b7040ed4563c3b8e598253178e87e4d0df75e4ff2f2dedd5a0be046", "9874ce197211d0463d7b77965098b8b66f80340412ab35458f07cedc618adf384c65a6b42dab7118854cd4da39025742");
        TestDigest.testKatHex(new Shabal384(), "62f154ec394d0bc757d045c798c8b87a00e0655d0481a7d2d9fb58d93aedc676b5a0", "f5602d87bca447466e317ffe269b6a26192ac8b1a052da7a391f3564db6d4f08f0cf887c4721329d88fc0f33953e4c47");
        TestDigest.testKatHex(new Shabal384(), "b2dcfe9ff19e2b23ce7da2a4207d3e5ec7c6112a8a22aec9675a886378e14e5bfbad4e", "bcb357549a72fd23c221b9b27d6a172bf5f0645101e6aa3d34a95babffebf704159c12423117152e3e6c77307fe3167d");
        TestDigest.testKatHex(new Shabal384(), "47f5697ac8c31409c0868827347a613a3562041c633cf1f1f86865a576e02835ed2c2492", "3ebc99d4970fe864e88c1a423fd522c6b3ac4743558829b90e40d149fe776a878ebd8f77be4af1d6e501b223f0a986f7");
        TestDigest.testKatHex(new Shabal384(), "512a6d292e67ecb2fe486bfe92660953a75484ff4c4f2eca2b0af0edcdd4339c6b2ee4e542", "a4ed21db40b4f50b1773e75a1c65aeb94c9ea21b4600f80a3008b863a2fde1c480a3a4f549270618c69dc96b3328a2b1");
        TestDigest.testKatHex(new Shabal384(), "973cf2b4dcf0bfa872b41194cb05bb4e16760a1840d8343301802576197ec19e2a1493d8f4fb", "b8fa4d944f60bdb47a978c3ec9896df617e18f9ca4365c63e075b5b8972d624143814240d158619b12b94041072c7160");
        TestDigest.testKatHex(new Shabal384(), "80beebcd2e3f8a9451d4499961c9731ae667cdc24ea020ce3b9aa4bbc0a7f79e30a934467da4b0", "9917ccb10fb406c95fcc7c4c989842052d4eff2e724695fd5b024f329c418b0a5aac73d9ef77891c36819c646c7bea57");
        TestDigest.testKatHex(new Shabal384(), "7abaa12ec2a7347674e444140ae0fb659d08e1c66decd8d6eae925fa451d65f3c0308e29446b8ed3", "1c9a0c7e30f5e4dd61d3904a46c1508b34688ffe2635d9f182db0f9aba6c0cdce83d6877f371aa46361968acf8f6b464");
        TestDigest.testKatHex(new Shabal384(), "c88dee9927679b8af422abcbacf283b904ff31e1cac58c7819809f65d5807d46723b20f67ba610c2b7", "75bc494fa3bc58cb872d8a9fea7bea9651dcf32db8cec79cb7fe1b7597881b0342309f4751b492813f1092127f4683a0");
        TestDigest.testKatHex(new Shabal384(), "01e43fe350fcec450ec9b102053e6b5d56e09896e0ddd9074fe138e6038210270c834ce6eadc2bb86bf6", "0a5bb1f5263ab457bba5e5d52dd977992f3eee138096318ca202bc20f255dca58f9af382af8e8c479906a85d50ccc0f5");
        TestDigest.testKatHex(new Shabal384(), "337023370a48b62ee43546f17c4ef2bf8d7ecd1d49f90bab604b839c2e6e5bd21540d29ba27ab8e309a4b7", "0341050cf3a46fe52d0c9995504bd9cd401bd84c5a0476c09473df2420bfad93c1ab9805c5326e4fd6d4431158e741ab");
        TestDigest.testKatHex(new Shabal384(), "6892540f964c8c74bd2db02c0ad884510cb38afd4438af31fc912756f3efec6b32b58ebc38fc2a6b913596a8", "8a87cf9a8b77b370e9fb9e090da55ca54ebc95abd7a5d7f5f5df84026ef4c363156b627a16e0ff2063f07bfee1524e3c");
        TestDigest.testKatHex(new Shabal384(), "f5961dfd2b1ffffda4ffbf30560c165bfedab8ce0be525845deb8dc61004b7db38467205f5dcfb34a2acfe96c0", "3a4905fad00bdb7870eefc18e6d4890357c4812c424e9690a3d484aaeda188b3437a13a45f63bbdd9b509b75774e4166");
        TestDigest.testKatHex(new Shabal384(), "ca061a2eb6ceed8881ce2057172d869d73a1951e63d57261384b80ceb5451e77b06cf0f5a0ea15ca907ee1c27eba", "e9c7a7f703695682dbdb75718e6880b16c8650bb51575dd2e723d723e869e9a58abeaf4c9f1b9806d6f2268d9af8f684");
        TestDigest.testKatHex(new Shabal384(), "1743a77251d69242750c4f1140532cd3c33f9b5ccdf7514e8584d4a5f9fbd730bcf84d0d4726364b9bf95ab251d9bb", "14dc8a36c571d257f60897094052fefcab047cc205509a21e0940f163333bdd48158095125f39f6a302f4aa6fa321761");
        TestDigest.testKatHex(new Shabal384(), "d8faba1f5194c4db5f176fabfff856924ef627a37cd08cf55608bba8f1e324d7c7f157298eabc4dce7d89ce5162499f9", "fcf296e7186f64db10f9041aa3907813d10e366e482f424cbba455caff5f1329cc50e0dedc72f59d73221647b9dbe960");
        TestDigest.testKatHex(new Shabal384(), "be9684be70340860373c9c482ba517e899fc81baaa12e5c6d7727975d1d41ba8bef788cdb5cf4606c9c1c7f61aed59f97d", "84a505ae4280abf602740e7415739ce0622c68231af5ce5f237dda3c3fdb295654270c8a39dc78fc01276f46e773d6dd");
        TestDigest.testKatHex(new Shabal384(), "7e15d2b9ea74ca60f66c8dfab377d9198b7b16deb6a1ba0ea3c7ee2042f89d3786e779cf053c77785aa9e692f821f14a7f51", "53cb9a2284bd43f887e8816c441861883217913497c82f279b780f237d96ce9fa87a2220bb628be072be49ea5b9494b3");
        TestDigest.testKatHex(new Shabal384(), "9a219be43713bd578015e9fda66c0f2d83cac563b776ab9f38f3e4f7ef229cb443304fba401efb2bdbd7ece939102298651c86", "70d3ad1f9580b3f333d89a4eca72325b9cb6ed65f660fdfabe1684c0f7b173e38040e8d56c88752dc367bbaa42cc2250");
        TestDigest.testKatHex(new Shabal384(), "c8f2b693bd0d75ef99caebdc22adf4088a95a3542f637203e283bbc3268780e787d68d28cc3897452f6a22aa8573ccebf245972a", "764ffc1fbdcb97d960520168a1cd5ef25cb2daae24f290fbbf339806cecf0107c2968b6236edb5649fe240058aa034e0");
        TestDigest.testKatHex(new Shabal384(), "ec0f99711016c6a2a07ad80d16427506ce6f441059fd269442baaa28c6ca037b22eeac49d5d894c0bf66219f2c08e9d0e8ab21de52", "1df8d77e8cac72be6e50a49c2c15e8013a84b5f45c1a9a723f310a5aa9c840c310b7d78d1822b631197c05ddb0f6f93c");
        TestDigest.testKatHex(new Shabal384(), "0dc45181337ca32a8222fe7a3bf42fc9f89744259cff653504d6051fe84b1a7ffd20cb47d4696ce212a686bb9be9a8ab1c697b6d6a33", "f294d501b14a01d95cab7d646a11128bf42267b795a5ca7545309d9ff3900382e3cbe5bd56e36f52b617c5ccb2dc89af");
        TestDigest.testKatHex(new Shabal384(), "de286ba4206e8b005714f80fb1cdfaebde91d29f84603e4a3ebc04686f99a46c9e880b96c574825582e8812a26e5a857ffc6579f63742f", "c7d6eeffaf31ff3b86a34ba22617b528f98113faf5fe99e2c7bef469b39b9f10679504fed35a7b83458e04dc3f0214a1");
        TestDigest.testKatHex(new Shabal384(), "eebcc18057252cbf3f9c070f1a73213356d5d4bc19ac2a411ec8cdeee7a571e2e20eaf61fd0c33a0ffeb297ddb77a97f0a415347db66bcaf", "3209fbb38415ba937b6a6f74af81feb85d5c9d2c5a08066b102c452c001dde33997ae9f4818593c8ca3bcbed176f2c6b");
        TestDigest.testKatHex(new Shabal384(), "416b5cdc9fe951bd361bd7abfc120a5054758eba88fdd68fd84e39d3b09ac25497d36b43cbe7b85a6a3cebda8db4e5549c3ee51bb6fcb6ac1e", "6292c34791378088622acb616071a8280f09791502581883c6a354672640884744880bb4246fc7f65c1098c0d4f28367");
        TestDigest.testKatHex(new Shabal384(), "5c5faf66f32e0f8311c32e8da8284a4ed60891a5a7e50fb2956b3cbaa79fc66ca376460e100415401fc2b8518c64502f187ea14bfc9503759705", "75aa2ec1f0a92f77cb19be219a527102fb049ee8a39d844593e30c31908553f9f5543791195baada0b9c300f046db37f");
        TestDigest.testKatHex(new Shabal384(), "7167e1e02be1a7ca69d788666f823ae4eef39271f3c26a5cf7cee05bca83161066dc2e217b330df821103799df6d74810eed363adc4ab99f36046a", "81c704836fbacbbd880de55188dda3c746cb157517e99b9bc166774bb5d02369dc8adfc6b839578b30a69f27ec72ecf0");
        TestDigest.testKatHex(new Shabal384(), "2fda311dbba27321c5329510fae6948f03210b76d43e7448d1689a063877b6d14c4f6d0eaa96c150051371f7dd8a4119f7da5c483cc3e6723c01fb7d", "d1211bee0b8a8ea76438c45d7f385af528b174428591b097142a5a68e7f4a9fc8f8573daebe7ac440e2f36b0c4b761c8");
        TestDigest.testKatHex(new Shabal384(), "95d1474a5aab5d2422aca6e481187833a6212bd2d0f91451a67dd786dfc91dfed51b35f47e1deb8a8ab4b9cb67b70179cc26f553ae7b569969ce151b8d", "4cc67605926a8dbfff3b508cefad260f6fadc78119063c860d8fab72333809f365b0ca03d2bddc6e27e99643f0c5cb48");
        TestDigest.testKatHex(new Shabal384(), "c71bd7941f41df044a2927a8ff55b4b467c33d089f0988aa253d294addbdb32530c0d4208b10d9959823f0c0f0734684006df79f7099870f6bf53211a88d", "741d1e6575236e6d8fea6bd1735d25c087da6bc1419f80852f1a6f7aad8fe24b06d1a10741c701ab1c4746592d377cc0");
        TestDigest.testKatHex(new Shabal384(), "f57c64006d9ea761892e145c99df1b24640883da79d9ed5262859dcda8c3c32e05b03d984f1ab4a230242ab6b78d368dc5aaa1e6d3498d53371e84b0c1d4ba", "5d08a206824624183efe7d76e127b6d3b126ce879de7c286235b7bf875b27665358741dd61afdbbb333cf4bfcad9f89e");
        TestDigest.testKatHex(new Shabal384(), "e926ae8b0af6e53176dbffcc2a6b88c6bd765f939d3d178a9bde9ef3aa131c61e31c1e42cdfaf4b4dcde579a37e150efbef5555b4c1cb40439d835a724e2fae7", "166c63e8bbe2af4310ab59b8707f82a0e9c3947a434bfd409db486e25d33c9894ee0d232a078a5280182fc75d67bc9b1");
        TestDigest.testKatHex(new Shabal384(), "16e8b3d8f988e9bb04de9c96f2627811c973ce4a5296b4772ca3eefeb80a652bdf21f50df79f32db23f9f73d393b2d57d9a0297f7a2f2e79cfda39fa393df1ac00", "33d1a460b27ed08d9fe19a35bb60df4b7a239ce26a66e7f0ddb6b358fde925b25bb5adf0307fc4324b4286221b1bf965");
        TestDigest.testKatHex(new Shabal384(), "fc424eeb27c18a11c01f39c555d8b78a805b88dba1dc2a42ed5e2c0ec737ff68b2456d80eb85e11714fa3f8eabfb906d3c17964cb4f5e76b29c1765db03d91be37fc", "dec018a42964cd47140441dd5915fbd52366c9ab370346a9176a57f47f4278761630203a71c6ef99658d70d1b438cbcd");
        TestDigest.testKatHex(new Shabal384(), "abe3472b54e72734bdba7d9158736464251c4f21b33fbbc92d7fac9a35c4e3322ff01d2380cbaa4ef8fb07d21a2128b7b9f5b6d9f34e13f39c7ffc2e72e47888599ba5", "9561d841c5aedfe3f8a8bec575ca8653e8d98d510ceed5757ea91b70ed7f1f6e26822fa7c733aa0eeadebe01adacba22");
        TestDigest.testKatHex(new Shabal384(), "36f9f0a65f2ca498d739b944d6eff3da5ebba57e7d9c41598a2b0e4380f3cf4b479ec2348d015ffe6256273511154afcf3b4b4bf09d6c4744fdd0f62d75079d440706b05", "7daa717972b3dfd4510e5d8381bf31244616ee680c5de03420967151ff442c8fa9db1a4ca52b679b0b0f98ad24b9d028");
        TestDigest.testKatHex(new Shabal384(), "abc87763cae1ca98bd8c5b82caba54ac83286f87e9610128ae4de68ac95df5e329c360717bd349f26b872528492ca7c94c2c1e1ef56b74dbb65c2ac351981fdb31d06c77a4", "68a1b2ffcbe6cc5626221eb991d2186b2556897e0bda767adaadc0bba618bd6a9c2e414813ec275253e4c05cdd431cd2");
        TestDigest.testKatHex(new Shabal384(), "94f7ca8e1a54234c6d53cc734bb3d3150c8ba8c5f880eab8d25fed13793a9701ebe320509286fd8e422e931d99c98da4df7e70ae447bab8cffd92382d8a77760a259fc4fbd72", "9272711d028547486ebd0a9cf656117dda78becd6a081ba28cb52e2c5632c6e73e5f2cc3cc875a91ef440509ac3f444e");
        TestDigest.testKatHex(new Shabal384(), "13bd2811f6ed2b6f04ff3895aceed7bef8dcd45eb121791bc194a0f806206bffc3b9281c2b308b1a729ce008119dd3066e9378acdcc50a98a82e20738800b6cddbe5fe9694ad6d", "e89fff26b0e558f59a81ed36e86a361de6901aaca53ed402159c6f6653ea5917e30553d64e0667360cdca57fcd34d605");
        TestDigest.testKatHex(new Shabal384(), "1eed9cba179a009ec2ec5508773dd305477ca117e6d569e66b5f64c6bc64801ce25a8424ce4a26d575b8a6fb10ead3fd1992edddeec2ebe7150dc98f63adc3237ef57b91397aa8a7", "b6f1c3b6ce48a8af3d43f504eb08a3b75375f7f3b0d5df41e155fa61ec8615b33808fdd86c0bb19176c55de7ceb676af");
        TestDigest.testKatHex(new Shabal384(), "ba5b67b5ec3a3ffae2c19dd8176a2ef75c0cd903725d45c9cb7009a900c0b0ca7a2967a95ae68269a6dbf8466c7b6844a1d608ac661f7eff00538e323db5f2c644b78b2d48de1a08aa", "b542ed62491cdb7f436f5f9bff27dc324c1553f5220de8e85968b44de264f1eb1a20bcee632ebdfa0fb1b77bc543864c");
        TestDigest.testKatHex(new Shabal384(), "0efa26ac5673167dcacab860932ed612f65ff49b80fa9ae65465e5542cb62075df1c5ae54fba4db807be25b070033efa223bdd5b1d3c94c6e1909c02b620d4b1b3a6c9fed24d70749604", "b34a009d1ddab8a594e27d80201545cf309ac74698a663ed14439a822ede36d0fbf8de37e43bc2bf7083e6740d954f1e");
        TestDigest.testKatHex(new Shabal384(), "bbfd933d1fd7bf594ac7f435277dc17d8d5a5b8e4d13d96d2f64e771abbd51a5a8aea741beccbddb177bcea05243ebd003cfdeae877cca4da94605b67691919d8b033f77d384ca01593c1b", "4886e6f8919f6738e5c2371db970961713a49da75819151a1418a1833d291ad8cc882c664e48957dab2071dabb045c24");
        TestDigest.testKatHex(new Shabal384(), "90078999fd3c35b8afbf4066cbde335891365f0fc75c1286cdd88fa51fab94f9b8def7c9ac582a5dbcd95817afb7d1b48f63704e19c2baa4df347f48d4a6d603013c23f1e9611d595ebac37c", "21193465b21c325cae38589d02bf0a30a0b1f1e2712f5a830a926f968dbedac4b5cee336ea3b40a60a8143a26104785b");
        TestDigest.testKatHex(new Shabal384(), "64105eca863515c20e7cfbaa0a0b8809046164f374d691cdbd6508aaabc1819f9ac84b52bafc1b0fe7cddbc554b608c01c8904c669d8db316a0953a4c68ece324ec5a49ffdb59a1bd6a292aa0e", "f46532e62798db3a6325d45c95a996585923092eaf6824bea72e72fdbb3112423664b11c6d9955553489c34a50f94b1e");
        TestDigest.testKatHex(new Shabal384(), "d4654be288b9f3b711c2d02015978a8cc57471d5680a092aa534f7372c71ceaab725a383c4fcf4d8deaa57fca3ce056f312961eccf9b86f14981ba5bed6ab5b4498e1f6c82c6cae6fc14845b3c8a", "0bf5689d08a3227cf69c3df7a7fc1fa10152222cbf16c40738bc19c9085b374c5344186653a54f20f71bc3f14a9e2d84");
        TestDigest.testKatHex(new Shabal384(), "12d9394888305ac96e65f2bf0e1b18c29c90fe9d714dd59f651f52b88b3008c588435548066ea2fc4c101118c91f32556224a540de6efddbca296ef1fb00341f5b01fecfc146bdb251b3bdad556cd2", "1c7f2f8947c7bc0bb1942045593448063a042d5843b85f476c2012f056bbb07051ed47c65c5c7e72f1b5e2629fe244db");
        TestDigest.testKatHex(new Shabal384(), "871a0d7a5f36c3da1dfce57acd8ab8487c274fad336bc137ebd6ff4658b547c1dcfab65f037aa58f35ef16aff4abe77ba61f65826f7be681b5b6d5a1ea8085e2ae9cd5cf0991878a311b549a6d6af230", "9b4a64a023191662ffbb9914eea9f76de20821675140a9cb907a1071d965292add75d3b55866129bd2f81409867730c0");
        TestDigest.testKatHex(new Shabal384(), "e90b4ffef4d457bc7711ff4aa72231ca25af6b2e206f8bf859d8758b89a7cd36105db2538d06da83bad5f663ba11a5f6f61f236fd5f8d53c5e89f183a3cec615b50c7c681e773d109ff7491b5cc22296c5", "a59c65722288dd2e3e06c02212b00f8b2d9defb8d18c1c0a1868afb40f6351925283805ff7bac1c8cd4150ae7d6c9e2b");
        TestDigest.testKatHex(new Shabal384(), "e728de62d75856500c4c77a428612cd804f30c3f10d36fb219c5ca0aa30726ab190e5f3f279e0733d77e7267c17be27d21650a9a4d1e32f649627638dbada9702c7ca303269ed14014b2f3cf8b894eac8554", "8afbb88a597f2bb4964ed9b8079032f1d04ae9e152dac86f1045b72a1d16cae566763db214bc7932fca05f4182f0abe2");
        TestDigest.testKatHex(new Shabal384(), "6348f229e7b1df3b770c77544e5166e081850fa1c6c88169db74c76e42eb983facb276ad6a0d1fa7b50d3e3b6fcd799ec97470920a7abed47d288ff883e24ca21c7f8016b93bb9b9e078bdb9703d2b781b616e", "6ab542a30aea21046f04850f10dda0fe552886148c2e8e6ba67e38bd355307a399de096a8b08398dfbb343f291648c8f");
        TestDigest.testKatHex(new Shabal384(), "4b127fde5de733a1680c2790363627e63ac8a3f1b4707d982caea258655d9bf18f89afe54127482ba01e08845594b671306a025c9a5c5b6f93b0a39522dc877437be5c2436cbf300ce7ab6747934fcfc30aeaaf6", "c19a34a7c5849aee4831121d4b16d22129fa56c7bd6be127626487a9f6af6cb450542fa83974f6dcde336f2f3c7d5ee5");
        TestDigest.testKatHex(new Shabal384(), "08461f006cff4cc64b752c957287e5a0faabc05c9bff89d23fd902d324c79903b48fcb8f8f4b01f3e4ddb483593d25f000386698f5ade7faade9615fdc50d32785ea51d49894e45baa3dc707e224688c6408b68b11", "4c2a530a47c683e9f0c7bd7a2a13242a282ca1ba341c2c19c8388106678163bfb9b558dc7e6c1abe17bbf355ac361ff1");
        TestDigest.testKatHex(new Shabal384(), "68c8f8849b120e6e0c9969a5866af591a829b92f33cd9a4a3196957a148c49138e1e2f5c7619a6d5edebe995acd81ec8bb9c7b9cfca678d081ea9e25a75d39db04e18d475920ce828b94e72241f24db72546b352a0e4", "ede2e9cac7b002e32e1f4769c2df07c7fe310f1b41f00e58c40964150effd010c177dcb771ffbf2554f7017f974bbe39");
        TestDigest.testKatHex(new Shabal384(), "b8d56472954e31fb54e28fca743f84d8dc34891cb564c64b08f7b71636debd64ca1edbdba7fc5c3e40049ce982bba8c7e0703034e331384695e9de76b5104f2fbc4535ecbeebc33bc27f29f18f6f27e8023b0fbb6f563c", "6b1033181783c6e4f4ade7996b88951263ef7be5d41eb9474233c1feca98624a4d32c2ccb0c0f0610eb32989b931decc");
        TestDigest.testKatHex(new Shabal384(), "0d58ac665fa84342e60cefee31b1a4eacdb092f122dfc68309077aed1f3e528f578859ee9e4cefb4a728e946324927b675cd4f4ac84f64db3dacfe850c1dd18744c74ceccd9fe4dc214085108f404eab6d8f452b5442a47d", "8b354d5f0c6f594b87b3e7880f87422f1127adc159cf78840bf37666ae6174fd234b2f08357cd09714fc141b381322e7");
        TestDigest.testKatHex(new Shabal384(), "1755e2d2e5d1c1b0156456b539753ff416651d44698e87002dcf61dcfa2b4e72f264d9ad591df1fdee7b41b2eb00283c5aebb3411323b672eaa145c5125185104f20f335804b02325b6dea65603f349f4d5d8b782dd3469ccd", "02ddd9d501c1cc3f4b27ddb4bb611e42b4eff9d517592a770b13ba3c7ee0eb1be6c47c9d372fbd4165859f8563ca1e8a");
        TestDigest.testKatHex(new Shabal384(), "b180de1a611111ee7584ba2c4b020598cd574ac77e404e853d15a101c6f5a2e5c801d7d85dc95286a1804c870bb9f00fd4dcb03aa8328275158819dcad7253f3e3d237aeaa7979268a5db1c6ce08a9ec7c2579783c8afc1f91a7", "a279a3a3370481f1ef6cd3b2ea887b8422b3e86b2e80d65e4144d992510eb58785366e43c27d2732500aeac09d44c5ca");
        TestDigest.testKatHex(new Shabal384(), "cf3583cbdfd4cbc17063b1e7d90b02f0e6e2ee05f99d77e24e560392535e47e05077157f96813544a17046914f9efb64762a23cf7a49fe52a0a4c01c630cfe8727b81fb99a89ff7cc11dca5173057e0417b8fe7a9efba6d95c555f", "ff0a8f8147d5d27f2e5c6f397be60dcb0ad281daa3f8ce6e34085291d1f77db49064c28ed365f2b888a08109f193908b");
        TestDigest.testKatHex(new Shabal384(), "072fc02340ef99115bad72f92c01e4c093b9599f6cfc45cb380ee686cb5eb019e806ab9bd55e634ab10aa62a9510cc0672cd3eddb589c7df2b67fcd3329f61b1a4441eca87a33c8f55da4fbbad5cf2b2527b8e983bb31a2fadec7523", "83e3bd1b563e839ffd4c96c17c3d178ae18ccf7de89dc36ded57e031d7d3e8fd86b64e2daa856e87c433ba98d109eaa1");
        TestDigest.testKatHex(new Shabal384(), "76eecf956a52649f877528146de33df249cd800e21830f65e90f0f25ca9d6540fde40603230eca6760f1139c7f268deba2060631eea92b1fff05f93fd5572fbe29579ecd48bc3a8d6c2eb4a6b26e38d6c5fbf2c08044aeea470a8f2f26", "1ec81de3828b04b60a1fef4d23a10f75b6ea66331b9758dfbadf4210e809fcfe28bc0af5763e2724cb41a3ad2c6b6913");
        TestDigest.testKatHex(new Shabal384(), "7adc0b6693e61c269f278e6944a5a2d8300981e40022f839ac644387bfac9086650085c2cdc585fea47b9d2e52d65a2b29a7dc370401ef5d60dd0d21f9e2b90fae919319b14b8c5565b0423cefb827d5f1203302a9d01523498a4db10374", "ad8f0951cb85657371021f29305198f7718f7f551c08c83fa1babeb8c762b2ecf4d12567839f792503b863ab2ff400d4");
        TestDigest.testKatHex(new Shabal384(), "e1fffa9826cce8b86bccefb8794e48c46cdf372013f782eced1e378269b7be2b7bf51374092261ae120e822be685f2e7a83664bcfbe38fe8633f24e633ffe1988e1bc5acf59a587079a57a910bda60060e85b5f5b6f776f0529639d9cce4bd", "b43d0660b61bcac7de5dc85bbe7e5bc3571d0e35fa38ae5defe68dea79d1de2f4f67577a8ba56725fb8dc545f773530e");
        TestDigest.testKatHex(new Shabal384(), "69f9abba65592ee01db4dce52dbab90b08fc04193602792ee4daa263033d59081587b09bbe49d0b49c9825d22840b2ff5d9c5155f975f8f2c2e7a90c75d2e4a8040fe39f63bbafb403d9e28cc3b86e04e394a9c9e8065bd3c85fa9f0c7891600", "681dd6b14b43d1d891cf582cbd6dc138333b1cf75feddc6a81e597463f73079a5cb6835384db36e5e4aeab20bd939e94");
        TestDigest.testKatHex(new Shabal384(), "38a10a352ca5aedfa8e19c64787d8e9c3a75dbf3b8674bfab29b5dbfc15a63d10fae66cd1a6e6d2452d557967eaad89a4c98449787b0b3164ca5b717a93f24eb0b506ceb70cbbcb8d72b2a72993f909aad92f044e0b5a2c9ac9cb16a0ca2f81f49", "ffb96fa0f703cd7a6c8563fb2c1813d8f2fb4785888ac6355dec5b85a0e094bf6144bed266eb1a543f33c96d7b7936c0");
        TestDigest.testKatHex(new Shabal384(), "6d8c6e449bc13634f115749c248c17cd148b72157a2c37bf8969ea83b4d6ba8c0ee2711c28ee11495f43049596520ce436004b026b6c1f7292b9c436b055cbb72d530d860d1276a1502a5140e3c3f54a93663e4d20edec32d284e25564f624955b52", "76aef248299e8e8d1f323249fa6f49f35ae01c9ace38eebe93ee6a01b8ce8d4b5471add08eb0e7a321c8098f31c3e207");
        TestDigest.testKatHex(new Shabal384(), "6efcbcaf451c129dbe00b9cef0c3749d3ee9d41c7bd500ade40cdc65dedbbbadb885a5b14b32a0c0d087825201e303288a733842fa7e599c0c514e078f05c821c7a4498b01c40032e9f1872a1c925fa17ce253e8935e4c3c71282242cb716b2089ccc1", "332e9d35fc1dce56756c8e1e9cb034c8be41793d8ccb9399d1a6c0901a462c08897a2823afc9aff5880f225f18104b32");
        TestDigest.testKatHex(new Shabal384(), "433c5303131624c0021d868a30825475e8d0bd3052a022180398f4ca4423b98214b6beaac21c8807a2c33f8c93bd42b092cc1b06cedf3224d5ed1ec29784444f22e08a55aa58542b524b02cd3d5d5f6907afe71c5d7462224a3f9d9e53e7e0846dcbb4ce", "c83ff784da6d8a1f9edec4ca2fd36019f267bf54077ba8b4e4135f6cc6722d1a64f66e274465fc27c4f9e0de2e2717c5");
        TestDigest.testKatHex(new Shabal384(), "a873e0c67ca639026b6683008f7aa6324d4979550e9bce064ca1e1fb97a30b147a24f3f666c0a72d71348ede701cf2d17e2253c34d1ec3b647dbcef2f879f4eb881c4830b791378c901eb725ea5c172316c6d606e0af7df4df7f76e490cd30b2badf45685f", "2fc11c4848d1f027cb1dde48c1d70dc7ed3e0fd1034ebb141cba60fcd24620ca39a0cf0b0235fb2b135468c3a176c2d5");
        TestDigest.testKatHex(new Shabal384(), "006917b64f9dcdf1d2d87c8a6173b64f6587168e80faa80f82d84f60301e561e312d9fbce62f39a6fb476e01e925f26bcc91de621449be6504c504830aae394096c8fc7694651051365d4ee9070101ec9b68086f2ea8f8ab7b811ea8ad934d5c9b62c60a4771", "51c7b26b143480381a249a294a1f6b4469b5161107d729d15f44645e5aa71b959ca414aa0e8c4644df8e1c4e60e924eb");
        TestDigest.testKatHex(new Shabal384(), "f13c972c52cb3cc4a4df28c97f2df11ce089b815466be88863243eb318c2adb1a417cb1041308598541720197b9b1cb5ba2318bd5574d1df2174af14884149ba9b2f446d609df240ce335599957b8ec80876d9a085ae084907bc5961b20bf5f6ca58d5dab38adb", "54709fef954df44751b4dd6ead215d2a49176e461552a2ed67f132c60adf14f64ad7f53037e77d4a8d9171ebf052085e");
        TestDigest.testKatHex(new Shabal384(), "e35780eb9799ad4c77535d4ddb683cf33ef367715327cf4c4a58ed9cbdcdd486f669f80189d549a9364fa82a51a52654ec721bb3aab95dceb4a86a6afa93826db923517e928f33e3fba850d45660ef83b9876accafa2a9987a254b137c6e140a21691e1069413848", "669a9d3b99ad9276e972bc9b292407d09d108b6796c6dcefe17ad26beb4e9fadb764d62e6f59f7e1e9897a9e9a10305b");
        TestDigest.testKatHex(new Shabal384(), "64ec021c9585e01ffe6d31bb50d44c79b6993d72678163db474947a053674619d158016adb243f5c8d50aa92f50ab36e579ff2dabb780a2b529370daa299207cfbcdd3a9a25006d19c4f1fe33e4b1eaec315d8c6ee1e730623fd1941875b924eb57d6d0c2edc4e78d6", "2ca2d70218607dce710d7811e62229031898a2351f00d4a9a30d2227096a85f2e9be380285c4def787059d5daa332341");
        TestDigest.testKatHex(new Shabal384(), "5954bab512cf327d66b5d9f296180080402624ad7628506b555eea8382562324cf452fba4a2130de3e165d11831a270d9cb97ce8c2d32a96f50d71600bb4ca268cf98e90d6496b0a6619a5a8c63db6d8a0634dfc6c7ec8ea9c006b6c456f1b20cd19e781af20454ac880", "82c5f557215e85443d653f5005b42ab2dd60364d2d9950c448c3f6c1e5f5fdb54b9ad656cfc8df01932f74cb12ff0359");
        TestDigest.testKatHex(new Shabal384(), "03d9f92b2c565709a568724a0aff90f8f347f43b02338f94a03ed32e6f33666ff5802da4c81bdce0d0e86c04afd4edc2fc8b4141c2975b6f07639b1994c973d9a9afce3d9d365862003498513bfa166d2629e314d97441667b007414e739d7febf0fe3c32c17aa188a8683", "61c6cf43cb6845d5d01269bae9635c2343bc3d284cc3e5ffe0acca3f6a3fb269ad8e3ccdcd766d24f6fbd77747b332bb");
        TestDigest.testKatHex(new Shabal384(), "f31e8b4f9e0621d531d22a380be5d9abd56faec53cbd39b1fab230ea67184440e5b1d15457bd25f56204fa917fa48e669016cb48c1ffc1e1e45274b3b47379e00a43843cf8601a5551411ec12503e5aac43d8676a1b2297ec7a0800dbfee04292e937f21c005f17411473041", "404dd049fc681259fcfb91bd4e35ae9f52f1e14660168ac81492ca1bd636d433cb473566cc318ad32df1c790144cde22");
        TestDigest.testKatHex(new Shabal384(), "758ea3fea738973db0b8be7e599bbef4519373d6e6dcd7195ea885fc991d896762992759c2a09002912fb08e0cb5b76f49162aeb8cf87b172cf3ad190253df612f77b1f0c532e3b5fc99c2d31f8f65011695a087a35ee4eee5e334c369d8ee5d29f695815d866da99df3f79403", "ee5fc636be854d91e4b5e17b36c1a3a0bfcfa735067b60efc1aba8f3a8d8ac76fce4a54086934c07a17b816b29a979b4");
        TestDigest.testKatHex(new Shabal384(), "47c6e0c2b74948465921868804f0f7bd50dd323583dc784f998a93cd1ca4c6ef84d41dc81c2c40f34b5bee6a93867b3bdba0052c5f59e6f3657918c382e771d33109122cc8bb0e1e53c4e3d13b43ce44970f5e0c079d2ad7d7a3549cd75760c21bb15b447589e86e8d76b1e9ced2", "f63574903c362f74104a849abd19eb6c62bb18355d6c03eff024d1ca69cb0be57fac8d806d1cf88e2441c66f3e370ba3");
        TestDigest.testKatHex(new Shabal384(), "f690a132ab46b28edfa6479283d6444e371c6459108afd9c35dbd235e0b6b6ff4c4ea58e7554bd002460433b2164ca51e868f7947d7d7a0d792e4abf0be5f450853cc40d85485b2b8857ea31b5ea6e4ccfa2f3a7ef3380066d7d8979fdac618aad3d7e886dea4f005ae4ad05e5065f", "4e596c93c114af43231c7e5e441600826fe4f01723ff5da4382867269a62a02001505e1385f8e3413cbbe88825834ed9");
        TestDigest.testKatHex(new Shabal384(), "58d6a99bc6458824b256916770a8417040721cccfd4b79eacd8b65a3767ce5ba7e74104c985ac56b8cc9aebd16febd4cda5adb130b0ff2329cc8d611eb14dac268a2f9e633c99de33997fea41c52a7c5e1317d5b5daed35eba7d5a60e45d1fa7eaabc35f5c2b0a0f2379231953322c4e", "5ee0e64bd725717f60f0e25b2400fce38d260d289d508b2c7b30e91fe95b1a3cd41e5cfc76c9e88f4fd4dd69009adfd7");
        TestDigest.testKatHex(new Shabal384(), "befab574396d7f8b6705e2d5b58b2c1c820bb24e3f4bae3e8fbcd36dbf734ee14e5d6ab972aedd3540235466e825850ee4c512ea9795abfd33f330d9fd7f79e62bbb63a6ea85de15beaeea6f8d204a28956059e2632d11861dfb0e65bc07ac8a159388d5c3277e227286f65ff5e5b5aec1", "ed37438df258611acccd2f46e9f589d8463fdfbc37494d3c239171ea4c7b2f30eaf2668d4d08674a586b486fa3c417df");
        TestDigest.testKatHex(new Shabal384(), "8e58144fa9179d686478622ce450c748260c95d1ba43b8f9b59abeca8d93488da73463ef40198b4d16fb0b0707201347e0506ff19d01bea0f42b8af9e71a1f1bd168781069d4d338fdef00bf419fbb003031df671f4a37979564f69282de9c65407847dd0da505ab1641c02dea4f0d834986", "e1417ee061b2677db266b30c4ea3a8ba8e85ddaaf4d33f12663239d0d811cb2cb66e310b6e7d46504ad26c55608038c9");
        TestDigest.testKatHex(new Shabal384(), "b55c10eae0ec684c16d13463f29291bf26c82e2fa0422a99c71db4af14dd9c7f33eda52fd73d017cc0f2dbe734d831f0d820d06d5f89dacc485739144f8cfd4799223b1aff9031a105cb6a029ba71e6e5867d85a554991c38df3c9ef8c1e1e9a7630be61caabca69280c399c1fb7a12d12aefc", "31403fadb621882061f1a57602cc50b80befe96bb530f6a75f541bbfeecfb6f07fb227a3fe0dba766817af13e9f62b0e");
        TestDigest.testKatHex(new Shabal384(), "2eeea693f585f4ed6f6f8865bbae47a6908aecd7c429e4bec4f0de1d0ca0183fa201a0cb14a529b7d7ac0e6ff6607a3243ee9fb11bcf3e2304fe75ffcddd6c5c2e2a4cd45f63c962d010645058d36571404a6d2b4f44755434d76998e83409c3205aa1615db44057db991231d2cb42624574f545", "18557a88fd0b255b696ec0458a3b372f6015a2f7cbb572caed26c524b6a393c22c270174ad1667169e0bdf5040db490d");
        TestDigest.testKatHex(new Shabal384(), "dab11dc0b047db0420a585f56c42d93175562852428499f66a0db811fcdddab2f7cdffed1543e5fb72110b64686bc7b6887a538ad44c050f1e42631bc4ec8a9f2a047163d822a38989ee4aab01b4c1f161b062d873b1cfa388fd301514f62224157b9bef423c7783b7aac8d30d65cd1bba8d689c2d", "7ef0746198ee68a43fb7a68df637f0e74df703460bd99d9b030cfe56024a1d896e6506960abe33992bf7c765e32f887b");
        TestDigest.testKatHex(new Shabal384(), "42e99a2f80aee0e001279a2434f731e01d34a44b1a8101726921c0590c30f3120eb83059f325e894a5ac959dca71ce2214799916424e859d27d789437b9d27240bf8c35adbafcecc322b48aa205b293962d858652abacbd588bcf6cbc388d0993bd622f96ed54614c25b6a9aa527589eaaffcf17ddf7", "b06afe938a5e0282fc70e1c3dbb802445779c634c211f9571dc241ee227cd8bba545d6debacd3f5b19c4ec4cc93c9967");
        TestDigest.testKatHex(new Shabal384(), "3c9b46450c0f2cae8e3823f8bdb4277f31b744ce2eb17054bddc6dff36af7f49fb8a2320cc3bdf8e0a2ea29ad3a55de1165d219adeddb5175253e2d1489e9b6fdd02e2c3d3a4b54d60e3a47334c37913c5695378a669e9b72dec32af5434f93f46176ebf044c4784467c700470d0c0b40c8a088c815816", "b99b91296030a2cbe85dfa078ef43a2a304373fa1db08442035921a1a6c6d9590aa8e99a51225f114de358df62d6c5fe");
        TestDigest.testKatHex(new Shabal384(), "d1e654b77cb155f5c77971a64df9e5d34c26a3cad6c7f6b300d39deb1910094691adaa095be4ba5d86690a976428635d5526f3e946f7dc3bd4dbc78999e653441187a81f9adcd5a3c5f254bc8256b0158f54673dcc1232f6e918ebfc6c51ce67eaeb042d9f57eec4bfe910e169af78b3de48d137df4f2840", "d548d03c5a0b7d50f42547fddda4d539790d9e9f8e08f86087b464e0e691b020a8bf5d9817b87000f8b84c368bf03234");
        TestDigest.testKatHex(new Shabal384(), "626f68c18a69a6590159a9c46be03d5965698f2dac3de779b878b3d9c421e0f21b955a16c715c1ec1e22ce3eb645b8b4f263f60660ea3028981eebd6c8c3a367285b691c8ee56944a7cd1217997e1d9c21620b536bdbd5de8925ff71dec6fbc06624ab6b21e329813de90d1e572dfb89a18120c3f606355d25", "eca295a914506bc7e80e134723514112c59b57950af26485eb9755c6030cb66df03f7ae3fa8c5572b99b508bd47e4238");
        TestDigest.testKatHex(new Shabal384(), "651a6fb3c4b80c7c68c6011675e6094eb56abf5fc3057324ebc6477825061f9f27e7a94633abd1fa598a746e4a577caf524c52ec1788471f92b8c37f23795ca19d559d446cab16cbcdce90b79fa1026cee77bf4ab1b503c5b94c2256ad75b3eac6fd5dcb96aca4b03a834bfb4e9af988cecbf2ae597cb9097940", "479474d431b28276fd8c80bca3cf2a7d5f2df012fca3248504bc8a251ae401ff4b7fbf0ff0c090547397e2b37ab13b6d");
        TestDigest.testKatHex(new Shabal384(), "8aaf072fce8a2d96bc10b3c91c809ee93072fb205ca7f10abd82ecd82cf040b1bc49ea13d1857815c0e99781de3adbb5443ce1c897e55188ceaf221aa9681638de05ae1b322938f46bce51543b57ecdb4c266272259d1798de13be90e10efec2d07484d9b21a3870e2aa9e06c21aa2d0c9cf420080a80a91dee16f", "3528e40dd98b48dc229dd9df78994476c34db704c270fd0fa718475933e4545d959ed7e2496312542fe5a2e5616edd86");
        TestDigest.testKatHex(new Shabal384(), "53f918fd00b1701bd504f8cdea803acca21ac18c564ab90c2a17da592c7d69688f6580575395551e8cd33e0fef08ca6ed4588d4d140b3e44c032355df1c531564d7f4835753344345a6781e11cd5e095b73df5f82c8ae3ad00877936896671e947cc52e2b29dcd463d90a0c9929128da222b5a211450bbc0e02448e2", "310ec1395d87a51b280d6628d5904127ee2183e954ce6b08a0c73cbdcb757bb4b43ca7dc06459d55e376e3c063ee662e");
        TestDigest.testKatHex(new Shabal384(), "a64599b8a61b5ccec9e67aed69447459c8da3d1ec6c7c7c82a7428b9b584fa67e90f68e2c00fbbed4613666e5168da4a16f395f7a3c3832b3b134bfc9cbaa95d2a0fe252f44ac6681eb6d40ab91c1d0282fed6701c57463d3c5f2bb8c6a7301fb4576aa3b5f15510db8956ff77478c26a7c09bea7b398cfc83503f538e", "d17ccab02044bb1f6af49ebcd451a3620027a70e054c46971cbf7f64a598e945e2d14beaf028400df447252bf421e3ff");
        TestDigest.testKatHex(new Shabal384(), "0e3ab0e054739b00cdb6a87bd12cae024b54cb5e550e6c425360c2e87e59401f5ec24ef0314855f0f56c47695d56a7fb1417693af2a1ed5291f2fee95f75eed54a1b1c2e81226fbff6f63ade584911c71967a8eb70933bc3f5d15bc91b5c2644d9516d3c3a8c154ee48e118bd1442c043c7a0dba5ac5b1d5360aae5b9065", "2b4c37026b2cdc636721541a939074fecd69316333a85d9194661fded44a3f11f43b94b74a2228f94bbd56b0a3e7649b");
        TestDigest.testKatHex(new Shabal384(), "a62fc595b4096e6336e53fcdfc8d1cc175d71dac9d750a6133d23199eaac288207944cea6b16d27631915b4619f743da2e30a0c00bbdb1bbb35ab852ef3b9aec6b0a8dcc6e9e1abaa3ad62ac0a6c5de765de2c3711b769e3fde44a74016fff82ac46fa8f1797d3b2a726b696e3dea5530439acee3a45c2a51bc32dd055650b", "070dc6a175ef1fe6fe6bc8187371890ecbdeaca2c747ea5cba48535ea00786652b6db1cf14fdb7b4917f8b6d45cf4220");
        TestDigest.testKatHex(new Shabal384(), "2b6db7ced8665ebe9deb080295218426bdaa7c6da9add2088932cdffbaa1c14129bccdd70f369efb149285858d2b1d155d14de2fdb680a8b027284055182a0cae275234cc9c92863c1b4ab66f304cf0621cd54565f5bff461d3b461bd40df28198e3732501b4860eadd503d26d6e69338f4e0456e9e9baf3d827ae685fb1d817", "03a37aa2fdf6c8bb11c3e760ec3fe533ef72807c39fd6e83c73669f44ec70bea67fdbaba02fad35c43a9e067b1794138");
        TestDigest.testKatHex(new Shabal384(), "10db509b2cdcaba6c062ae33be48116a29eb18e390e1bbada5ca0a2718afbcd23431440106594893043cc7f2625281bf7de2655880966a23705f0c5155c2f5cca9f2c2142e96d0a2e763b70686cd421b5db812daced0c6d65035fde558e94f26b3e6dde5bd13980cc80292b723013bd033284584bff27657871b0cf07a849f4ae2", "91aa8ec534d61fba15b4dc391f9be3db9c274371aeb771451035cfebcf1a637abc621475bb8823a1ee44d3cdcbe1a486");
        TestDigest.testKatHex(new Shabal384(), "9334de60c997bda6086101a6314f64e4458f5ff9450c509df006e8c547983c651ca97879175aaba0c539e82d05c1e02c480975cbb30118121061b1ebac4f8d9a3781e2db6b18042e01ecf9017a64a0e57447ec7fcbe6a7f82585f7403ee2223d52d37b4bf426428613d6b4257980972a0acab508a7620c1cb28eb4e9d30fc41361ec", "94a3d9d8ef9e48fc8f82d1adca4ecc7fae5c2d5addfbde6aa4325973af32ed56af69eb5b0506be05dcf73d70080a1d1f");
        TestDigest.testKatHex(new Shabal384(), "e88ab086891693aa535ceb20e64c7ab97c7dd3548f3786339897a5f0c39031549ca870166e477743ccfbe016b4428d89738e426f5ffe81626137f17aecff61b72dbee2dc20961880cfe281dfab5ee38b1921881450e16032de5e4d55ad8d4fca609721b0692bac79be5a06e177fe8c80c0c83519fb3347de9f43d5561cb8107b9b5edc", "ec35fccb3e2364ab0cc6f9f4ffdc4fa249826e660a8a691b65bcc1cfc47305c29a43e6c9274372dfea6705858f079b19");
        TestDigest.testKatHex(new Shabal384(), "fd19e01a83eb6ec810b94582cb8fbfa2fcb992b53684fb748d2264f020d3b960cb1d6b8c348c2b54a9fcea72330c2aaa9a24ecdb00c436abc702361a82bb8828b85369b8c72ece0082fe06557163899c2a0efa466c33c04343a839417057399a63a3929be1ee4805d6ce3e5d0d0967fe9004696a5663f4cac9179006a2ceb75542d75d68", "71326ce184ec473e1074bb2b6685d0c72210e5d8d4cc690d528851748bc10daded6c8a938f210413bf512ea70f2235d6");
        TestDigest.testKatHex(new Shabal384(), "59ae20b6f7e0b3c7a989afb28324a40fca25d8651cf1f46ae383ef6d8441587aa1c04c3e3bf88e8131ce6145cfb8973d961e8432b202fa5af3e09d625faad825bc19da9b5c6c20d02abda2fcc58b5bd3fe507bf201263f30543819510c12bc23e2ddb4f711d087a86edb1b355313363a2de996b891025e147036087401ccf3ca7815bf3c49", "72c7d26d93492a5e32d34f4113bfcfecb8f388e3edafbb5d1fbce9d73a53dda8fcc1d2493304b4f9cdff1c43ee3c2c6d");
        TestDigest.testKatHex(new Shabal384(), "77ee804b9f3295ab2362798b72b0a1b2d3291dceb8139896355830f34b3b328561531f8079b79a6e9980705150866402fdc176c05897e359a6cb1a7ab067383eb497182a7e5aef7038e4c96d133b2782917417e391535b5e1b51f47d8ed7e4d4025fe98dc87b9c1622614bff3d1029e68e372de719803857ca52067cddaad958951cb2068cc6", "d397f8fd85a73aa8b3ec4cf0d27b2faf2e4472cea349baa53b5762976cc568d5ccb6e206baf5c5acac512e6c28a84926");
        TestDigest.testKatHex(new Shabal384(), "b771d5cef5d1a41a93d15643d7181d2a2ef0a8e84d91812f20ed21f147bef732bf3a60ef4067c3734b85bc8cd471780f10dc9e8291b58339a677b960218f71e793f2797aea349406512829065d37bb55ea796fa4f56fd8896b49b2cd19b43215ad967c712b24e5032d065232e02c127409d2ed4146b9d75d763d52db98d949d3b0fed6a8052fbb", "a595e1b338eb411d8f475781ab57a76c62af0ec325566baffe7774eb0a0d7a1630f1d7b4de0011d0ee70338e9cf81cd5");
        TestDigest.testKatHex(new Shabal384(), "b32d95b0b9aad2a8816de6d06d1f86008505bd8c14124f6e9a163b5a2ade55f835d0ec3880ef50700d3b25e42cc0af050ccd1be5e555b23087e04d7bf9813622780c7313a1954f8740b6ee2d3f71f768dd417f520482bd3a08d4f222b4ee9dbd015447b33507dd50f3ab4247c5de9a8abd62a8decea01e3b87c8b927f5b08beb37674c6f8e380c04", "0cab27244abf0d2d2e74067855a2567dd26245f55bf23b32fc0e38064249cb1a91a9d6517b8e6ce06f44048e6aeb5aa3");
        TestDigest.testKatHex(new Shabal384(), "04410e31082a47584b406f051398a6abe74e4da59bb6f85e6b49e8a1f7f2ca00dfba5462c2cd2bfde8b64fb21d70c083f11318b56a52d03b81cac5eec29eb31bd0078b6156786da3d6d8c33098c5c47bb67ac64db14165af65b44544d806dde5f487d5373c7f9792c299e9686b7e5821e7c8e2458315b996b5677d926dac57b3f22da873c601016a0d", "4020e9d09221cf76b2e2dd1a6f8a6a9cd22dfa286f605b39692e4ec2a4940ab46c3d5c9ff4bf43d2d9376a0708f55ae6");
        TestDigest.testKatHex(new Shabal384(), "8b81e9badde026f14d95c019977024c9e13db7a5cd21f9e9fc491d716164bbacdc7060d882615d411438aea056c340cdf977788f6e17d118de55026855f93270472d1fd18b9e7e812bae107e0dfde7063301b71f6cfe4e225cab3b232905a56e994f08ee2891ba922d49c3dafeb75f7c69750cb67d822c96176c46bd8a29f1701373fb09a1a6e3c7158f", "55ea45d46eef1d9bb7b08ed45e44bc51cdc1701682dd86852cfba6132cd55cd6d45f853c556382fa889487858dd1f1cf");
        TestDigest.testKatHex(new Shabal384(), "fa6eed24da6666a22208146b19a532c2ec9ba94f09f1def1e7fc13c399a48e41acc2a589d099276296348f396253b57cb0e40291bd282773656b6e0d8bea1cda084a3738816a840485fcf3fb307f777fa5feac48695c2af4769720258c77943fb4556c362d9cba8bf103aeb9034baa8ea8bfb9c4f8e6742ce0d52c49ea8e974f339612e830e9e7a9c29065", "b15dde9a6f2b8f704e14f4d911d8e56622185f59fcbe06f41fa4d8f13f858fa7e7e1791b435425ed56e036d950cbaee5");
        TestDigest.testKatHex(new Shabal384(), "9bb4af1b4f09c071ce3cafa92e4eb73ce8a6f5d82a85733440368dee4eb1cbc7b55ac150773b6fe47dbe036c45582ed67e23f4c74585dab509df1b83610564545642b2b1ec463e18048fc23477c6b2aa035594ecd33791af6af4cbc2a1166aba8d628c57e707f0b0e8707caf91cd44bdb915e0296e0190d56d33d8dde10b5b60377838973c1d943c22ed335e", "068cd3f65c16a6cd4abf700c42fd6cc015daeab9047ea844a186b5f360058c1eed6364b9cc92b8c5055859e8206e9bca");
        TestDigest.testKatHex(new Shabal384(), "2167f02118cc62043e9091a647cadbed95611a521fe0d64e8518f16c808ab297725598ae296880a773607a798f7c3cfce80d251ebec6885015f9abf7eaabae46798f82cb5926de5c23f44a3f9f9534b3c6f405b5364c2f8a8bdc5ca49c749bed8ce4ba48897062ae8424ca6dde5f55c0e42a95d1e292ca54fb46a84fbc9cd87f2d0c9e7448de3043ae22fdd229", "4426e836022f3105bb8c9d01a5cdd8fbb26eba8059f0bddead89c736ba2c0769de6aba1c648ce1f23e02fc0fa38982ce");
        TestDigest.testKatHex(new Shabal384(), "94b7fa0bc1c44e949b1d7617d31b4720cbe7ca57c6fa4f4094d4761567e389ecc64f6968e4064df70df836a47d0c713336b5028b35930d29eb7a7f9a5af9ad5cf441745baec9bb014ceeff5a41ba5c1ce085feb980bab9cf79f2158e03ef7e63e29c38d7816a84d4f71e0f548b7fc316085ae38a060ff9b8dec36f91ad9ebc0a5b6c338cbb8f6659d342a24368cf", "df0e634c4f9e090d647e58d3c5fedb756ab1601df068d5b14982c62dc9a9c17f6ee5b87f3ba08ee97e4f5663118528f5");
        TestDigest.testKatHex(new Shabal384(), "ea40e83cb18b3a242c1ecc6ccd0b7853a439dab2c569cfc6dc38a19f5c90acbf76aef9ea3742ff3b54ef7d36eb7ce4ff1c9ab3bc119cff6be93c03e208783335c0ab8137be5b10cdc66ff3f89a1bddc6a1eed74f504cbe7290690bb295a872b9e3fe2cee9e6c67c41db8efd7d863cf10f840fe618e7936da3dca5ca6df933f24f6954ba0801a1294cd8d7e66dfafec", "d81b1fd2cfe71ba66fbfb2aaf0c020324344ffdc1843ff98459e0dbedb56c0bf5aa25a9129d674ddc4f4b3975aedcdee");
        TestDigest.testKatHex(new Shabal384(), "157d5b7e4507f66d9a267476d33831e7bb768d4d04cc3438da12f9010263ea5fcafbde2579db2f6b58f911d593d5f79fb05fe3596e3fa80ff2f761d1b0e57080055c118c53e53cdb63055261d7c9b2b39bd90acc32520cbbdbda2c4fd8856dbcee173132a2679198daf83007a9b5c51511ae49766c792a29520388444ebefe28256fb33d4260439cba73a9479ee00c63", "4c026e2a7699a04cc6d0f9caeefc3635d3f634aafd50b489020c900417f2f97dbea307b683293f34c5439a305a232c7e");
        TestDigest.testKatHex(new Shabal384(), "836b34b515476f613fe447a4e0c3f3b8f20910ac89a3977055c960d2d5d2b72bd8acc715a9035321b86703a411dde0466d58a59769672aa60ad587b8481de4bba552a1645779789501ec53d540b904821f32b0bd1855b04e4848f9f8cfe9ebd8911be95781a759d7ad9724a7102dbe576776b7c632bc39b9b5e19057e226552a5994c1dbb3b5c7871a11f5537011044c53", "98b1293b1393c3488214328e292482b0ba27d38e2e3616f4663f5feb5a9afaf90be4f24f1af7ae48b49b5245167e6ee8");
        TestDigest.testKatHex(new Shabal384(), "cc7784a4912a7ab5ad3620aab29ba87077cd3cb83636adc9f3dc94f51edf521b2161ef108f21a0a298557981c0e53ce6ced45bdf782c1ef200d29bab81dd6460586964edab7cebdbbec75fd7925060f7da2b853b2b089588fa0f8c16ec6498b14c55dcee335cb3a91d698e4d393ab8e8eac0825f8adebeee196df41205c011674e53426caa453f8de1cbb57932b0b741d4c6", "25c0e1f792b8d58d0896c6019855a52cc7a1c028f10102c426946d2ec9580e080b91c266eb88b94ae06a6a6fedb4060c");
        TestDigest.testKatHex(new Shabal384(), "7639b461fff270b2455ac1d1afce782944aea5e9087eb4a39eb96bb5c3baaf0e868c8526d3404f9405e79e77bfac5ffb89bf1957b523e17d341d7323c302ea7083872dd5e8705694acdda36d5a1b895aaa16eca6104c82688532c8bfe1790b5dc9f4ec5fe95baed37e1d287be710431f1e5e8ee105bc42ed37d74b1e55984bf1c09fe6a1fa13ef3b96faeaed6a2a1950a12153", "0b49f42b5b5a05863534e2d15af9822b8729e66dbb9ba94e6142a788e65b91a2a2a5eba99ba97acaa5a378c2dd9b5f72");
        TestDigest.testKatHex(new Shabal384(), "eb6513fc61b30cfba58d4d7e80f94d14589090cf1d80b1df2e68088dc6104959ba0d583d585e9578ab0aec0cf36c48435eb52ed9ab4bbce7a5abe679c97ae2dbe35e8cc1d45b06dda3cf418665c57cbee4bbb47fa4caf78f4ee656fec237fe4eebbafa206e1ef2bd0ee4ae71bd0e9b2f54f91daadf1febfd7032381d636b733dcb3bf76fb14e23aff1f68ed3dbcf75c9b99c6f26", "cc25949eb92209e79b98b896ca6781a851cb0fcd9abf91480fc0ad9ca63feb4a990421656569cd4deefaf3cc1ebd9877");
        TestDigest.testKatHex(new Shabal384(), "1594d74bf5dde444265d4c04dad9721ff3e34cbf622daf341fe16b96431f6c4df1f760d34f296eb97d98d560ad5286fec4dce1724f20b54fd7df51d4bf137add656c80546fb1bf516d62ee82baa992910ef4cc18b70f3f8698276fcfb44e0ec546c2c39cfd8ee91034ff9303058b4252462f86c823eb15bf481e6b79cc3a02218595b3658e8b37382bd5048eaed5fd02c37944e73b", "cf92b903c3fa48334eec5a50e861b3467e7998edba67e2135a797d2021aa78614ae867dadb17d06a886d891f8b60ef03");
        TestDigest.testKatHex(new Shabal384(), "4cfa1278903026f66fedd41374558be1b585d03c5c55dac94361df286d4bd39c7cb8037ed3b267b07c346626449d0cc5b0dd2cf221f7e4c3449a4be99985d2d5e67bff2923357ddeab5abcb4619f3a3a57b2cf928a022eb27676c6cf805689004fca4d41ea6c2d0a4789c7605f7bb838dd883b3ad3e6027e775bcf262881428099c7fff95b14c095ea130e0b9938a5e22fc52650f591", "7ddcbaf5c24be82075ab59f6e2852d8208343283297ec15df62bf8e635800adfb3017a1123711d42845a1f79fd9d81b6");
        TestDigest.testKatHex(new Shabal384(), "d3e65cb92cfa79662f6af493d696a07ccf32aaadcceff06e73e8d9f6f909209e66715d6e978788c49efb9087b170ecf3aa86d2d4d1a065ae0efc8924f365d676b3cb9e2bec918fd96d0b43dee83727c9a93bf56ca2b2e59adba85696546a815067fc7a78039629d4948d157e7b0d826d1bf8e81237bab7321312fdaa4d521744f988db6fdf04549d0fdca393d639c729af716e9c8bba48", "71a30b6a9e436904f9335457847695410e4a64346ed6f78b15d14968211e68f7564ee5f86261f91d8a65c400f768ed7f");
        TestDigest.testKatHex(new Shabal384(), "842cc583504539622d7f71e7e31863a2b885c56a0ba62db4c2a3f2fd12e79660dc7205ca29a0dc0a87db4dc62ee47a41db36b9ddb3293b9ac4baae7df5c6e7201e17f717ab56e12cad476be49608ad2d50309e7d48d2d8de4fa58ac3cfeafeee48c0a9eec88498e3efc51f54d300d828dddccb9d0b06dd021a29cf5cb5b2506915beb8a11998b8b886e0f9b7a80e97d91a7d01270f9a7717", "45d45c41a4b2575eff249e00e2ba6c51f8b6a1800af265aed9d9524382ee68f635626c06602b6e77764125082eeb84ac");
        TestDigest.testKatHex(new Shabal384(), "6c4b0a0719573e57248661e98febe326571f9a1ca813d3638531ae28b4860f23c3a3a8ac1c250034a660e2d71e16d3acc4bf9ce215c6f15b1c0fc7e77d3d27157e66da9ceec9258f8f2bf9e02b4ac93793dd6e29e307ede3695a0df63cbdc0fc66fb770813eb149ca2a916911bee4902c47c7802e69e405fe3c04ceb5522792a5503fa829f707272226621f7c488a7698c0d69aa561be9f378", "30b1c29db9c4c9a8ef2221bca25a8272b8dd9600aa40e6d7c9a2e0d4c9ad7403a022ff6829e17e82540153aa668c54ff");
        TestDigest.testKatHex(new Shabal384(), "51b7dbb7ce2ffeb427a91ccfe5218fd40f9e0b7e24756d4c47cd55606008bdc27d16400933906fd9f30effdd4880022d081155342af3fb6cd53672ab7fb5b3a3bcbe47be1fd3a2278cae8a5fd61c1433f7d350675dd21803746cadca574130f01200024c6340ab0cc2cf74f2234669f34e9009ef2eb94823d62b31407f4ba46f1a1eec41641e84d77727b59e746b8a671bef936f05be820759fa", "308900728c1dbeb4c4fa670d8bef0abb1124a77d2e751031d3e81fd22dc9a14a261764a5b005630b2eb8d978996c251a");
        TestDigest.testKatHex(new Shabal384(), "83599d93f5561e821bd01a472386bc2ff4efbd4aed60d5821e84aae74d8071029810f5e286f8f17651cd27da07b1eb4382f754cd1c95268783ad09220f5502840370d494beb17124220f6afce91ec8a0f55231f9652433e5ce3489b727716cf4aeba7dcda20cd29aa9a859201253f948dd94395aba9e3852bd1d60dda7ae5dc045b283da006e1cbad83cc13292a315db5553305c628dd091146597", "58df0e84dfb70c1c9dad4c60b7d22931d691c4826979a9a9812fc007c8a27a99bed3b97a1ea37fc10c5a689d0a29d8c1");
        TestDigest.testKatHex(new Shabal384(), "2be9bf526c9d5a75d565dd11ef63b979d068659c7f026c08bea4af161d85a462d80e45040e91f4165c074c43ac661380311a8cbed59cc8e4c4518e80cd2c78ab1cabf66bff83eab3a80148550307310950d034a6286c93a1ece8929e6385c5e3bb6ea8a7c0fb6d6332e320e71cc4eb462a2a62e2bfe08f0ccad93e61bedb5dd0b786a728ab666f07e0576d189c92bf9fb20dca49ac2d3956d47385e2", "17226d2739ae2b11107da6f1512c0cc3f0597a7871f21d356450fc2e14e3ab2c2fe86d69076646a5d1dfe272430b1c0b");
        TestDigest.testKatHex(new Shabal384(), "ca76d3a12595a817682617006848675547d3e8f50c2210f9af906c0e7ce50b4460186fe70457a9e879e79fd4d1a688c70a347361c847ba0dd6aa52936eaf8e58a1be2f5c1c704e20146d366aeb3853bed9de9befe9569ac8aaea37a9fb7139a1a1a7d5c748605a8defb297869ebedd71d615a5da23496d11e11abbb126b206fa0a7797ee7de117986012d0362dcef775c2fe145ada6bda1ccb326bf644", "bbd4b31e2e8a1b579c3a488c6118f8faca634ca4e1615a34936a5a0b9bd110fc4e5ee60813cff1c4d2a6176dd5b82cbf");
        TestDigest.testKatHex(new Shabal384(), "f76b85dc67421025d64e93096d1d712b7baf7fb001716f02d33b2160c2c882c310ef13a576b1c2d30ef8f78ef8d2f465007109aad93f74cb9e7d7bef7c9590e8af3b267c89c15db238138c45833c98cc4a471a7802723ef4c744a853cf80a0c2568dd4ed58a2c9644806f42104cee53628e5bdf7b63b0b338e931e31b87c24b146c6d040605567ceef5960df9e022cb469d4c787f4cba3c544a1ac91f95f", "6cd76f2d3d8d4ff2d433fbdf171fec312b3713c52920e965a18e823dc14b63ddda968a781ab70dd50fa88309bf2440dd");
        TestDigest.testKatHex(new Shabal384(), "25b8c9c032ea6bcd733ffc8718fbb2a503a4ea8f71dea1176189f694304f0ff68e862a8197b839957549ef243a5279fc2646bd4c009b6d1edebf24738197abb4c992f6b1dc9ba891f570879accd5a6b18691a93c7d0a8d38f95b639c1daeb48c4c2f15ccf5b9d508f8333c32de78781b41850f261b855c4bebcc125a380c54d501c5d3bd07e6b52102116088e53d76583b0161e2a58d0778f091206aabd5a1", "65b6fd174b3382692ae40b3a32712806f2375d423d41dc289b15a681c4d9a0854cf4c95ae81c73c6cac1b3935d860b9c");
        TestDigest.testKatHex(new Shabal384(), "21cfdc2a7ccb7f331b3d2eefff37e48ad9fa9c788c3f3c200e0173d99963e1cbca93623b264e920394ae48bb4c3a5bb96ffbc8f0e53f30e22956adabc2765f57fb761e147ecbf8567533db6e50c8a1f894310a94edf806dd8ca6a0e141c0fa7c9fae6c6ae65f18c93a8529e6e5b553bf55f25be2e80a9882bd37f145fecbeb3d447a3c4e46c21524cc55cdd62f521ab92a8ba72b897996c49bb273198b7b1c9e", "4297950dfc80ab6d799e24114ec556e537e97f28b2309f50153c8e7d2ded6762fb58d875c8c136cf8f75462a963d6913");
        TestDigest.testKatHex(new Shabal384(), "4e452ba42127dcc956ef4f8f35dd68cb225fb73b5bc7e1ec5a898bba2931563e74faff3b67314f241ec49f4a7061e3bd0213ae826bab380f1f14faab8b0efddd5fd1bb49373853a08f30553d5a55ccbbb8153de4704f29ca2bdeef0419468e05dd51557ccc80c0a96190bbcc4d77ecff21c66bdf486459d427f986410f883a80a5bcc32c20f0478bb9a97a126fc5f95451e40f292a4614930d054c851acd019ccf", "203b246fa3b5454a5c7624e94c6fcb6ecd0a0ed6542bfc54d94d237b13459fbf790d7cefed3c91cb3724f1726d603436");
        TestDigest.testKatHex(new Shabal384(), "fa85671df7dadf99a6ffee97a3ab9991671f5629195049880497487867a6c446b60087fac9a0f2fcc8e3b24e97e42345b93b5f7d3691829d3f8ccd4bb36411b85fc2328eb0c51cb3151f70860ad3246ce0623a8dc8b3c49f958f8690f8e3860e71eb2b1479a5cea0b3f8befd87acaf5362435eaeccb52f38617bc6c5c2c6e269ead1fbd69e941d4ad2012da2c5b21bcfbf98e4a77ab2af1f3fda3233f046d38f1dc8", "ab79365e5face1aeeb1f0d541dbbaf9c33167c49fbe06247ed9772547616cbd6df075d046f05dc067a247b284f3bc3e1");
        TestDigest.testKatHex(new Shabal384(), "e90847ae6797fbc0b6b36d6e588c0a743d725788ca50b6d792352ea8294f5ba654a15366b8e1b288d84f5178240827975a763bc45c7b0430e8a559df4488505e009c63da994f1403f407958203cebb6e37d89c94a5eacf6039a327f6c4dbbc7a2a307d976aa39e41af6537243fc218dfa6ab4dd817b6a397df5ca69107a9198799ed248641b63b42cb4c29bfdd7975ac96edfc274ac562d0474c60347a078ce4c25e88", "b0670c1a6d6f8332a4144f8bf396a3fe649b4096da403ac48590d5e73da5ae7b550435953f3e75fa1dbd497317b455e4");
        TestDigest.testKatHex(new Shabal384(), "f6d5c2b6c93954fc627602c00c4ca9a7d3ed12b27173f0b2c9b0e4a5939398a665e67e69d0b12fb7e4ceb253e8083d1ceb724ac07f009f094e42f2d6f2129489e846eaff0700a8d4453ef453a3eddc18f408c77a83275617fabc4ea3a2833aa73406c0e966276079d38e8e38539a70e194cc5513aaa457c699383fd1900b1e72bdfb835d1fd321b37ba80549b078a49ea08152869a918ca57f5b54ed71e4fd3ac5c06729", "b9b004284a528fd845e442d8f9751d65adb2f772325c507558ff5d43434b3b102d8d26bd90c2e7ed91688dc2795d168a");
        TestDigest.testKatHex(new Shabal384(), "cf8562b1bed89892d67ddaaf3deeb28246456e972326dbcdb5cf3fb289aca01e68da5d59896e3a6165358b071b304d6ab3d018944be5049d5e0e2bb819acf67a6006111089e6767132d72dd85beddcbb2d64496db0cc92955ab4c6234f1eea24f2d51483f2e209e4589bf9519fac51b4d061e801125e605f8093bb6997bc163d551596fe4ab7cfae8fb9a90f6980480ce0c229fd1675409bd788354daf316240cfe0af93eb", "9321b91f790fd4c128992809c389e407519c0c1939ec2e69e56b1437e9fb5f86eef91589d6b72410032215ad191b4443");
        TestDigest.testKatHex(new Shabal384(), "2ace31abb0a2e3267944d2f75e1559985db7354c6e605f18dc8470423fca30b7331d9b33c4a4326783d1caae1b4f07060eff978e4746bf0c7e30cd61040bd5ec2746b29863eb7f103ebda614c4291a805b6a4c8214230564a0557bc7102e0bd3ed23719252f7435d64d210ee2aafc585be903fa41e1968c50fd5d5367926df7a05e3a42cf07e656ff92de73b036cf8b19898c0cb34557c0c12c2d8b84e91181af467bc75a9d1", "b92bc2fb5ffaa47118c538c148c81c250fea35b3250e091d5c2d7e7fcfd66a739d33018ce1590f212319505cf1b950df");
        TestDigest.testKatHex(new Shabal384(), "0d8d09aed19f1013969ce5e7eb92f83a209ae76be31c754844ea9116ceb39a22ebb6003017bbcf26555fa6624185187db8f0cb3564b8b1c06bf685d47f3286eda20b83358f599d2044bbf0583fab8d78f854fe0a596183230c5ef8e54426750eaf2cc4e29d3bdd037e734d863c2bd9789b4c243096138f7672c232314effdfc6513427e2da76916b5248933be312eb5dde4cf70804fb258ac5fb82d58d08177ac6f4756017fff5", "540405fa8f5e0e53b567838aee6e45d940b2033cd4d0b2533062bb09a558a706f579bcfe0cce695c5134eb4a8e0489e8");
        TestDigest.testKatHex(new Shabal384(), "c3236b73deb7662bf3f3daa58f137b358ba610560ef7455785a9befdb035a066e90704f929bd9689cef0ce3bda5acf4480bceb8d09d10b098ad8500d9b6071dfc3a14af6c77511d81e3aa8844986c3bea6f469f9e02194c92868cd5f51646256798ff0424954c1434bdfed9facb390b07d342e992936e0f88bfd0e884a0ddb679d0547ccdec6384285a45429d115ac7d235a717242021d1dc35641f5f0a48e8445dba58e6cb2c8ea", "7165c2742a868259a8e64584a756ec2be0fbbff1bad2637f29df9c722897ecc18f9973b5441d20b930697f2a501dc326");
        TestDigest.testKatHex(new Shabal384(), "b39feb8283eadc63e8184b51df5ae3fd41aac8a963bb0be1cd08aa5867d8d910c669221e73243360646f6553d1ca05a84e8dc0de05b6419ec349ca994480193d01c92525f3fb3dcefb08afc6d26947bdbbfd85193f53b50609c6140905c53a6686b58e53a319a57b962331ede98149af3de3118a819da4d76706a0424b4e1d2910b0ed26af61d150ebcb46595d4266a0bd7f651ba47d0c7f179ca28545007d92e8419d48fdfbd744ce", "5ce31c3a4a8cfa5bf0ec3b64519860d25e956f3759d2562e492c5cccebd0d5a70cc7c77e85bb36166a3b48a165f75f27");
        TestDigest.testKatHex(new Shabal384(), "a983d54f503803e8c7999f4edbbe82e9084f422143a932ddddc47a17b0b7564a7f37a99d0786e99476428d29e29d3c197a72bfab1342c12a0fc4787fd7017d7a6174049ea43b5779169ef7472bdbbd941dcb82fc73aac45a8a94c9f2bd3477f61fd3b796f02a1b8264a214c6fea74b7051b226c722099ec7883a462b83b6afdd4009248b8a237f605fe5a08fe7d8b45321421ebba67bd70a0b00ddbf94baab7f359d5d1eea105f28dcfb", "088727724b9a83d6346fa0e4183a09942bcb6c96657c511287451f5e4c451979841535c5c2fbcaa86d91c3e2fc8e2981");
        TestDigest.testKatHex(new Shabal384(), "e4d1c1897a0a866ce564635b74222f9696bf2c7f640dd78d7e2aca66e1b61c642bb03ea7536aae597811e9bf4a7b453ede31f97b46a5f0ef51a071a2b3918df16b152519ae3776f9f1edab4c2a377c3292e96408359d3613844d5eb393000283d5ad3401a318b12fd1474b8612f2bb50fb6a8b9e023a54d7dde28c43d6d8854c8d9d1155935c199811dbfc87e9e0072e90eb88681cc7529714f8fb8a2c9d88567adfb974ee205a9bf7b848", "53c8fb422b58fc0c2b2fe2d98e3872c299ceaa71b11699d2ed25b7fa868f7fff4311ea9c98619896f6daa8fe6477e735");
        TestDigest.testKatHex(new Shabal384(), "b10c59723e3dcadd6d75df87d0a1580e73133a9b7d00cb95ec19f5547027323be75158b11f80b6e142c6a78531886d9047b08e551e75e6261e79785366d7024bd7cd9cf322d9be7d57fb661069f2481c7bb759cd71b4b36ca2bc2df6d3a328faebdb995a9794a8d72155ed551a1f87c80bf6059b43fc764900b18a1c2441f7487743cf84e565f61f8dd2ece6b6ccc9444049197aaaf53e926fbee3bfca8be588ec77f29d211be89de18b15f6", "c9e5d95b7aca7b0947d818f9fa3a7f19f80762bc331e3da08a312116f5ed3cbc37479131fe5e7b81ada643c151b05fda");
        TestDigest.testKatHex(new Shabal384(), "db11f609baba7b0ca634926b1dd539c8cbada24967d7add4d9876f77c2d80c0f4dcefbd7121548373582705cca2495bd2a43716fe64ed26d059cfb566b3364bd49ee0717bdd9810dd14d8fad80dbbdc4cafb37cc60fb0fe2a80fb4541b8ca9d59dce457738a9d3d8f641af8c3fd6da162dc16fc01aac527a4a0255b4d231c0be50f44f0db0b713af03d968fe7f0f61ed0824c55c4b5265548febd6aad5c5eedf63efe793489c39b8fd29d104ce", "807b25e6716f5cf44a8f8733d40b992e799d9fa3e3823899d935756f57e5d4d4f6b91c1f092bbeac505ea927093467fd");
        TestDigest.testKatHex(new Shabal384(), "bebd4f1a84fc8b15e4452a54bd02d69e304b7f32616aadd90537937106ae4e28de9d8aab02d19bc3e2fde1d651559e296453e4dba94370a14dbbb2d1d4e2022302ee90e208321efcd8528ad89e46dc839ea9df618ea8394a6bff308e7726bae0c19bcd4be52da6258e2ef4e96aa21244429f49ef5cb486d7ff35cac1bacb7e95711944bccb2ab34700d42d1eb38b5d536b947348a458ede3dc6bd6ec547b1b0cae5b257be36a7124e1060c170ffa", "a2e708ae3440cd4d359c5f2ee3c71b233f59973048f482880a04fadf2b8a788888b9355aa1753699691b47e1d7ce7bf7");
        TestDigest.testKatHex(new Shabal384(), "5aca56a03a13784bdc3289d9364f79e2a85c12276b49b92db0adaa4f206d5028f213f678c3510e111f9dc4c1c1f8b6acb17a6413aa227607c515c62a733817ba5e762cc6748e7e0d6872c984d723c9bb3b117eb8963185300a80bfa65cde495d70a46c44858605fccbed086c2b45cef963d33294dbe9706b13af22f1b7c4cd5a001cfec251fba18e722c6e1c4b1166918b4f6f48a98b64b3c07fc86a6b17a6d0480ab79d4e6415b520f1c484d675b1", "2c3f0eae16d4588f6d2f524268c1785f6633111ad1234c69c37bdd81f8aa318816846dc6a0edc23b198e15bcd1bd9970");
        TestDigest.testKatHex(new Shabal384(), "a5aad0e4646a32c85cfcac73f02fc5300f1982fabb2f2179e28303e447854094cdfc854310e5c0f60993ceff54d84d6b46323d930adb07c17599b35b505f09e784bca5985e0172257797fb53649e2e9723efd16865c31b5c3d5113b58bb0bfc8920fabdda086d7537e66d709d050bd14d0c960873f156fad5b3d3840cdfcdc9be6af519db262a27f40896ab25cc39f96984d650611c0d5a3080d5b3a1bf186abd42956588b3b58cd948970d298776060", "789ac90779dd934afb64a72bc35066d3c5d701069998206fa5bca41d90ff58bc93492b4b9be92450b4337ad731303a73");
        TestDigest.testKatHex(new Shabal384(), "06cbbe67e94a978203ead6c057a1a5b098478b4b4cbef5a97e93c8e42f5572713575fc2a884531d7622f8f879387a859a80f10ef02708cd8f7413ab385afc357678b9578c0ebf641ef076a1a30f1f75379e9dcb2a885bdd295905ee80c0168a62a9597d10cf12dd2d8cee46645c7e5a141f6e0e23aa482abe5661c16e69ef1e28371e2e236c359ba4e92c25626a7b7ff13f6ea4ae906e1cfe163e91719b1f750a96cbde5fbc953d9e576cd216afc90323a", "b59318b1d2b5deb4e906a57ad552d9d4641d323e9fd1d847c7601c50b8db6d0bcb1c9fe2420c0788b38cef133aa8888e");
        TestDigest.testKatHex(new Shabal384(), "f1c528cf7739874707d4d8ad5b98f7c77169de0b57188df233b2dc8a5b31eda5db4291dd9f68e6bad37b8d7f6c9c0044b3bf74bbc3d7d1798e138709b0d75e7c593d3cccdc1b20c7174b4e692add820ace262d45ccfae2077e878796347168060a162ecca8c38c1a88350bd63bb539134f700fd4addd5959e255337daa06bc86358fabcbefdfb5bc889783d843c08aadc6c4f6c36f65f156e851c9a0f917e4a367b5ad93d874812a1de6a7b93cd53ad97232", "896f88a666faa5518a19af0c8914afd2e44d5715f698b73c2f7c36f22c6727ceb1b2efa70c8c923c6821d4759007e2fb");
        TestDigest.testKatHex(new Shabal384(), "9d9f3a7ecd51b41f6572fd0d0881e30390dfb780991dae7db3b47619134718e6f987810e542619dfaa7b505c76b7350c6432d8bf1cfebdf1069b90a35f0d04cbdf130b0dfc7875f4a4e62cdb8e525aadd7ce842520a482ac18f09442d78305fe85a74e39e760a4837482ed2f437dd13b2ec1042afcf9decdc3e877e50ff4106ad10a525230d11920324a81094da31deab6476aa42f20c84843cfc1c58545ee80352bdd3740dd6a16792ae2d86f11641bb717c2", "3cb59f43cfb5508aba024679f9f9827b40d7dee40bb494763f3a1acd0ccb305ceaaec473203fd5736b3ee8892af2f6d5");
        TestDigest.testKatHex(new Shabal384(), "5179888724819fbad3afa927d3577796660e6a81c52d98e9303261d5a4a83232f6f758934d50aa83ff9e20a5926dfebaac49529d006eb923c5ae5048ed544ec471ed7191edf46363383824f915769b3e688094c682b02151e5ee01e510b431c8865aff8b6b6f2f59cb6d129da79e97c6d2b8fa6c6da3f603199d2d1bcab547682a81cd6cf65f6551121391d78bcc23b5bd0e922ec6d8bf97c952e84dd28aef909aba31edb903b28fbfc33b7703cd996215a11238", "c5e0f38383e0ffcef6e96b62f58b9373980449bd3dfbf83b33e438eb3672fc3ad5eb59f0193c62e154d8ee70c5f4e87a");
        TestDigest.testKatHex(new Shabal384(), "576ef3520d30b7a4899b8c0d5e359e45c5189add100e43be429a02fb3de5ff4f8fd0e79d9663acca72cd29c94582b19292a557c5b1315297d168fbb54e9e2ecd13809c2b5fce998edc6570545e1499dbe7fb74d47cd7f35823b212b05bf3f5a79caa34224fdd670d335fcb106f5d92c3946f44d3afcbae2e41ac554d8e6759f332b76be89a0324aa12c5482d1ea3ee89ded4936f3e3c080436f539fa137e74c6d3389bdf5a45074c47bc7b20b0948407a66d855e2f", "c564674ee927d60702cd189c438d078820c67b1053bc2fa2b355170d5d4684de1227b78f44d05c0f0eca7c580f772071");
        TestDigest.testKatHex(new Shabal384(), "0df2152fa4f4357c8741529dd77e783925d3d76e95bafa2b542a2c33f3d1d117d159cf473f82310356fee4c90a9e505e70f8f24859656368ba09381fa245eb6c3d763f3093f0c89b972e66b53d59406d9f01aea07f8b3b615cac4ee4d05f542e7d0dab45d67ccccd3a606ccbeb31ea1fa7005ba07176e60dab7d78f6810ef086f42f08e595f0ec217372b98970cc6321576d92ce38f7c397a403bada1548d205c343ac09deca86325373c3b76d9f32028fea8eb32515", "1236554d1ecc9f3ce7ad020e255558700909a50f65fbc84abf08f93db92fd05a03ddaef945596fddde97a45c63dba136");
        TestDigest.testKatHex(new Shabal384(), "3e15350d87d6ebb5c8ad99d42515cfe17980933c7a8f6b8bbbf0a63728cefaad2052623c0bd5931839112a48633fb3c2004e0749c87a41b26a8b48945539d1ff41a4b269462fd199bfecd45374756f55a9116e92093ac99451aefb2af9fd32d6d7f5fbc7f7a540d5097c096ebc3b3a721541de073a1cc02f7fb0fb1b9327fb0b1218ca49c9487ab5396622a13ae546c97abdef6b56380dda7012a8384091b6656d0ab272d363cea78163ff765cdd13ab1738b940d16cae", "70db37088aff9442f9be5297c4e390dcfd2485c367f74e4938debb9ad4676b8be3f5c2660191c7fe5e94421a4bbc677b");
        TestDigest.testKatHex(new Shabal384(), "c38d6b0b757cb552be40940ece0009ef3b0b59307c1451686f1a22702922800d58bce7a636c1727ee547c01b214779e898fc0e560f8ae7f61bef4d75eaa696b921fd6b735d171535e9edd267c192b99880c87997711002009095d8a7a437e258104a41a505e5ef71e5613ddd2008195f0c574e6ba3fe40099cfa116e5f1a2fa8a6da04badcb4e2d5d0de31fdc4800891c45781a0aac7c907b56d631fca5ce8b2cde620d11d1777ed9fa603541de794ddc5758fcd5fad78c0", "d69f90c6b9a9b52eadeb856d618eaab6dde3d650694d2b593bbd7629d23e3b4276841be4aa9ee2f7f10d3ad1bbea5bde");
        TestDigest.testKatHex(new Shabal384(), "8d2de3f0b37a6385c90739805b170057f091cd0c7a0bc951540f26a5a75b3e694631bb64c7635eed316f51318e9d8de13c70a2aba04a14836855f35e480528b776d0a1e8a23b547c8b8d6a0d09b241d3be9377160cca4e6793d00a515dc2992cb7fc741daca171431da99cce6f7789f129e2ac5cf65b40d703035cd2185bb936c82002daf8cbc27a7a9e554b06196630446a6f0a14ba155ed26d95bd627b7205c072d02b60db0fd7e49ea058c2e0ba202daff0de91e845cf79", "901c52021e47e6d6628499261725604b3386582c0d16f13c4c373a4192309513774700cdd84ff90a75d7ab5281d73a16");
        TestDigest.testKatHex(new Shabal384(), "c464bbdad275c50dcd983b65ad1019b9ff85a1e71c807f3204bb2c921dc31fbcd8c5fc45868ae9ef85b6c9b83bba2a5a822201ed68586ec5ec27fb2857a5d1a2d09d09115f22dcc39fe61f5e1ba0ff6e8b4acb4c6da748be7f3f0839739394ff7fa8e39f7f7e84a33c3866875c01bcb1263c9405d91908e9e0b50e7459fabb63d8c6bbb73d8e3483c099b55bc30ff092ff68b6adedfd477d63570c9f5515847f36e24ba0b705557130cec57ebad1d0b31a378e91894ee26e3a04", "819f3fcfcadb2324184a7b32ba7c01324e40642acea9993c58d5cdfcb87d215ab2542aeab130a532ac3d29ab72928b35");
        TestDigest.testKatHex(new Shabal384(), "8b8d68bb8a75732fe272815a68a1c9c5aa31b41dedc8493e76525d1d013d33cebd9e21a5bb95db2616976a8c07fcf411f5f6bc6f7e0b57aca78cc2790a6f9b898858ac9c79b165ff24e66677531e39f572be5d81eb3264524181115f32780257bfb9aeec6af12af28e587cac068a1a2953b59ad680f4c245b2e3ec36f59940d37e1d3db38e13edb29b5c0f404f6ff87f80fc8be7a225ff22fbb9c8b6b1d7330c57840d24bc75b06b80d30dad6806544d510af6c4785e823ac3e0b8", "5e7d094983da901a5c5cc43945b25ee5794f78dd4fb8f00e2d8de8cef5981a6235d69d8c3a4f3f8d1cc1b2a9d677a53a");
        TestDigest.testKatHex(new Shabal384(), "6b018710446f368e7421f1bc0ccf562d9c1843846bc8d98d1c9bf7d9d6fcb48bfc3bf83b36d44c4fa93430af75cd190bde36a7f92f867f58a803900df8018150384d85d82132f123006ac2aeba58e02a037fe6afbd65eca7c44977dd3dc74f48b6e7a1bfd5cc4dcf24e4d52e92bd4455848e4928b0eac8b7476fe3cc03e862aa4dff4470dbfed6de48e410f25096487ecfc32a27277f3f5023b2725ade461b1355889554a8836c9cf53bd767f5737d55184eea1ab3f53edd0976c485", "315cdf8ba1c8309f419a7fb911df319162a4981d414838daec275e9066431b89f5b43fa12022504a8cdd94fddbc2ee23");
        TestDigest.testKatHex(new Shabal384(), "c9534a24714bd4be37c88a3da1082eda7cabd154c309d7bd670dccd95aa535594463058a29f79031d6ecaa9f675d1211e9359be82669a79c855ea8d89dd38c2c761ddd0ec0ce9e97597432e9a1beae062cdd71edfdfd464119be9e69d18a7a7fd7ce0e2106f0c8b0abf4715e2ca48ef9f454dc203c96656653b727083513f8efb86e49c513bb758b3b052fe21f1c05bb33c37129d6cc81f1aef6adc45b0e8827a830fe545cf57d0955802c117d23ccb55ea28f95c0d8c2f9c5a242b33f", "513e8cec24f7ae96bdcd1b367cb4931e52eb2c19ab45193b2dae8a37366f83b6f4321857eb061bd3c8c48bfa8b1765d5");
        TestDigest.testKatHex(new Shabal384(), "07906c87297b867abf4576e9f3cc7f82f22b154afcbf293b9319f1b0584da6a40c27b32e0b1b7f412c4f1b82480e70a9235b12ec27090a5a33175a2bb28d8adc475cefe33f7803f8ce27967217381f02e67a3b4f84a71f1c5228e0c2ad971373f6f672624fcea8d1a9f85170fad30fa0bbd25035c3b41a6175d467998bd1215f6f3866f53847f9cf68ef3e2fbb54bc994de2302b829c5eea68ec441fcbafd7d16ae4fe9fff98bf00e5bc2ad54dd91ff9fda4dd77b6c754a91955d1fbaad0", "93b8c62d4309c6fb2a3d6e6c0bb1d8b296a6ef375c3654ce629e4150d329ed2fc232e8c008b9abe6e8ae44d6155de03f");
        TestDigest.testKatHex(new Shabal384(), "588e94b9054abc2189df69b8ba34341b77cdd528e7860e5defcaa79b0c9a452ad4b82aa306be84536eb7cedcbe058d7b84a6aef826b028b8a0271b69ac3605a9635ea9f5ea0aa700f3eb7835bc54611b922964300c953efe7491e3677c2cebe0822e956cd16433b02c68c4a23252c3f9e151a416b4963257b783e038f6b4d5c9f110f871652c7a649a7bcedcbccc6f2d0725bb903cc196ba76c76aa9f10a190b1d1168993baa9ffc96a1655216773458bec72b0e39c9f2c121378feab4e76a", "6dfc80c5f0673b1a6a6d326dcfe64bc434cd2a4659365359fd98019f439c0a3753debc31de58c6fbfc95959cfe7cbb3d");
        TestDigest.testKatHex(new Shabal384(), "08959a7e4baae874928813364071194e2939772f20db7c3157078987c557c2a6d5abe68d520eef3dc491692e1e21bcd880adebf63bb4213b50897fa005256ed41b5690f78f52855c8d9168a4b666fce2da2b456d7a7e7c17ab5f2fb1ee90b79e698712e963715983fd07641ae4b4e9dc73203fac1ae11fa1f8c7941fcc82eab247addb56e2638447e9d609e610b60ce086656aaebf1da3c8a231d7d94e2fd0afe46b391ff14a72eaeb3f44ad4df85866def43d4781a0b3578bc996c87970b132", "065b3a3ca430c6cb8aa95cd87a7c2d2fcea63d197fd87c343f61bd10d89d6cb33506fe820ba3ad98fc7fa1bf75a74282");
        TestDigest.testKatHex(new Shabal384(), "cb2a234f45e2ecd5863895a451d389a369aab99cfef0d5c9ffca1e6e63f763b5c14fb9b478313c8e8c0efeb3ac9500cf5fd93791b789e67eac12fd038e2547cc8e0fc9db591f33a1e4907c64a922dda23ec9827310b306098554a4a78f050262db5b545b159e1ff1dca6eb734b872343b842c57eafcfda8405eedbb48ef32e99696d135979235c3a05364e371c2d76f1902f1d83146df9495c0a6c57d7bf9ee77e80f9787aee27be1fe126cdc9ef893a4a7dcbbc367e40fe4e1ee90b42ea25af01", "23bb80e85e1b063a1ad12177ddb33dadee27f4d65f3c18bd2309c1070be40c8dafe16dff7af46a7f4dac54a5d9d57f07");
        TestDigest.testKatHex(new Shabal384(), "d16beadf02ab1d4dc6f88b8c4554c51e866df830b89c06e786a5f8757e8909310af51c840efe8d20b35331f4355d80f73295974653ddd620cdde4730fb6c8d0d2dcb2b45d92d4fbdb567c0a3e86bd1a8a795af26fbf29fc6c65941cddb090ff7cd230ac5268ab4606fccba9eded0a2b5d014ee0c34f0b2881ac036e24e151be89eeb6cd9a7a790afccff234d7cb11b99ebf58cd0c589f20bdac4f9f0e28f75e3e04e5b3debce607a496d848d67fa7b49132c71b878fd5557e082a18eca1fbda94d4b", "1fe538c12932f6286c8e399c829f8b026d7609618d16e96b5ce74276fb6592cf4b9a7b4a4123c157b5d62503beb88abd");
        TestDigest.testKatHex(new Shabal384(), "8f65f6bc59a85705016e2bae7fe57980de3127e5ab275f573d334f73f8603106ec3553016608ef2dd6e69b24be0b7113bf6a760ba6e9ce1c48f9e186012cf96a1d4849d75df5bb8315387fd78e9e153e76f8ba7ec6c8849810f59fb4bb9b004318210b37f1299526866f44059e017e22e96cbe418699d014c6ea01c9f0038b10299884dbec3199bb05adc94e955a1533219c1115fed0e5f21228b071f40dd57c4240d98d37b73e412fe0fa4703120d7c0c67972ed233e5deb300a22605472fa3a3ba86", "cc4f7d6e5e86559dd6887b8bc218059d1513b8d06dbd181043381dab3a4e4eac542b9ba8487ff0500c41065691f25a53");
        TestDigest.testKatHex(new Shabal384(), "84891e52e0d451813210c3fd635b39a03a6b7a7317b221a7abc270dfa946c42669aacbbbdf801e1584f330e28c729847ea14152bd637b3d0f2b38b4bd5bf9c791c58806281103a3eabbaede5e711e539e6a8b2cf297cf351c078b4fa8f7f35cf61bebf8814bf248a01d41e86c5715ea40c63f7375379a7eb1d78f27622fb468ab784aaaba4e534a6dfd1df6fa15511341e725ed2e87f98737ccb7b6a6dfae416477472b046bf1811187d151bfa9f7b2bf9acdb23a3be507cdf14cfdf517d2cb5fb9e4ab6", "c1e170e18ecb2e532162d4409e8ee9348c854ab3fe12134906fb3ea6a019225208618c7b5c2941dbb845278bffb02f03");
        TestDigest.testKatHex(new Shabal384(), "fdd7a9433a3b4afabd7a3a5e3457e56debf78e84b7a0b0ca0e8c6d53bd0c2dae31b2700c6128334f43981be3b213b1d7a118d59c7e6b6493a86f866a1635c12859cfb9ad17460a77b4522a5c1883c3d6acc86e6162667ec414e9a104aa892053a2b1d72165a855bacd8faf8034a5dd9b716f47a0818c09bb6baf22aa503c06b4ca261f557761989d2afbd88b6a678ad128af68672107d0f1fc73c5ca740459297b3292b281e93bceb761bde7221c3a55708e5ec84472cddcaa84ecf23723cc0991355c6280", "2566349aec3ea4b22b689a836567543377f825fbeed6a420d7fcce101c0ca945d2047a36edaa0eaa6c03fd8da9fc4505");
        TestDigest.testKatHex(new Shabal384(), "70a40bfbef92277a1aad72f6b79d0177197c4ebd432668cfec05d099accb651062b5dff156c0b27336687a94b26679cfdd9daf7ad204338dd9c4d14114033a5c225bd11f217b5f4732da167ee3f939262d4043fc9cba92303b7b5e96aea12adda64859df4b86e9ee0b58e39091e6b188b408ac94e1294a8911245ee361e60e601eff58d1d37639f3753bec80ebb4efde25817436076623fc65415fe51d1b0280366d12c554d86743f3c3b6572e400361a60726131441ba493a83fbe9afda90f7af1ae717238d", "42977441ce5f1d5b27651bbdd3bf2762ca996886be9bd55e825871ffd7488fee9edc5354bab9fe8a16b93c713da43474");
        TestDigest.testKatHex(new Shabal384(), "74356e449f4bf8644f77b14f4d67cb6bd9c1f5ae357621d5b8147e562b65c66585caf2e491b48529a01a34d226d436959153815380d5689e30b35357cdac6e08d3f2b0e88e200600d62bd9f5eaf488df86a4470ea227006182e44809009868c4c280c43d7d64a5268fa719074960087b3a6abc837882f882c837834535929389a12b2c78187e2ea07ef8b8eef27dc85002c3ae35f1a50bee6a1c48ba7e175f3316670b27983472aa6a61eed0a683a39ee323080620ea44a9f74411ae5ce99030528f9ab49c79f2", "05a0d9cfca8a89af9fce5b6820c003d9c3ef92d2f65f4976c9e7776c44bea674f516278026dc9f71a93723946d6bf1b9");
        TestDigest.testKatHex(new Shabal384(), "8c3798e51bc68482d7337d3abb75dc9ffe860714a9ad73551e120059860dde24ab87327222b64cf774415a70f724cdf270de3fe47dda07b61c9ef2a3551f45a5584860248fabde676e1cd75f6355aa3eaeabe3b51dc813d9fb2eaa4f0f1d9f834d7cad9c7c695ae84b329385bc0bef895b9f1edf44a03d4b410cc23a79a6b62e4f346a5e8dd851c2857995ddbf5b2d717aeb847310e1f6a46ac3d26a7f9b44985af656d2b7c9406e8a9e8f47dcb4ef6b83caacf9aefb6118bfcff7e44bef6937ebddc89186839b77", "01dc519ca0db749cbf65c2555da1e21f1253f2b9ad6c6e84bbec873cbfb73547fec95daf98e7b57792203a3aef959ac0");
        TestDigest.testKatHex(new Shabal384(), "fa56bf730c4f8395875189c10c4fb251605757a8fecc31f9737e3c2503b02608e6731e85d7a38393c67de516b85304824bfb135e33bf22b3a23b913bf6acd2b7ab85198b8187b2bcd454d5e3318cacb32fd6261c31ae7f6c54ef6a7a2a4c9f3ecb81ce3555d4f0ad466dd4c108a90399d70041997c3b25345a9653f3c9a6711ab1b91d6a9d2216442da2c973cbd685ee7643bfd77327a2f7ae9cb283620a08716dfb462e5c1d65432ca9d56a90e811443cd1ecb8f0de179c9cb48ba4f6fec360c66f252f6e64edc96b", "488b711de580911433bd11da6c0a76f0da4f5dea7864deebe904d9619e3608ea36ff85958a6890c23a644e39ea764624");
        TestDigest.testKatHex(new Shabal384(), "b6134f9c3e91dd8000740d009dd806240811d51ab1546a974bcb18d344642baa5cd5903af84d58ec5ba17301d5ec0f10ccd0509cbb3fd3fff9172d193af0f782252fd1338c7244d40e0e42362275b22d01c4c3389f19dd69bdf958ebe28e31a4ffe2b5f18a87831cfb7095f58a87c9fa21db72ba269379b2dc2384b3da953c7925761fed324620acea435e52b424a7723f6a2357374157a34cd8252351c25a1b232826cefe1bd3e70ffc15a31e7c0598219d7f00436294d11891b82497bc78aa5363892a2495df8c1eef", "a98fbed126dd0c4938693a76ba4154277283473238752673ec06016d050b7eba65793dbd492991f3bfa56987992f0986");
        TestDigest.testKatHex(new Shabal384(), "c941cdb9c28ab0a791f2e5c8e8bb52850626aa89205bec3a7e22682313d198b1fa33fc7295381354858758ae6c8ec6fac3245c6e454d16fa2f51c4166fab51df272858f2d603770c40987f64442d487af49cd5c3991ce858ea2a60dab6a65a34414965933973ac2457089e359160b7cdedc42f29e10a91921785f6b7224ee0b349393cdcff6151b50b377d609559923d0984cda6000829b916ab6896693ef6a2199b3c22f7dc5500a15b8258420e314c222bc000bc4e5413e6dd82c993f8330f5c6d1be4bc79f08a1a0a46", "895849354a53b04c113898c4ee90012fd02bbdd5a899ff6f9367261bf010813bd11a1e699ff339beb3239f6af6b97ca4");
        TestDigest.testKatHex(new Shabal384(), "4499efffac4bcea52747efd1e4f20b73e48758be915c88a1ffe5299b0b005837a46b2f20a9cb3c6e64a9e3c564a27c0f1c6ad1960373036ec5bfe1a8fc6a435c2185ed0f114c50e8b3e4c7ed96b06a036819c9463e864a58d6286f785e32a804443a56af0b4df6abc57ed5c2b185ddee8489ea080deeee66aa33c2e6dab36251c402682b6824821f998c32163164298e1fafd31babbcffb594c91888c6219079d907fdb438ed89529d6d96212fd55abe20399dbefd342248507436931cdead496eb6e4a80358acc78647d043", "4ac3c9847d288d84a109ebe1c47fcf1c80ff98339933137e930b874fd97bf9b3fcd7e78e3efc4e0f33f8f9620fc9335b");
        TestDigest.testKatHex(new Shabal384(), "eecbb8fdfa4da62170fd06727f697d81f83f601ff61e478105d3cb7502f2c89bf3e8f56edd469d049807a38882a7eefbc85fc9a950952e9fa84b8afebd3ce782d4da598002827b1eb98882ea1f0a8f7aa9ce013a6e9bc462fb66c8d4a18da21401e1b93356eb12f3725b6db1684f2300a98b9a119e5d27ff704affb618e12708e77e6e5f34139a5a41131fd1d6336c272a8fc37080f041c71341bee6ab550cb4a20a6ddb6a8e0299f2b14bc730c54b8b1c1c487b494bdccfd3a53535ab2f231590bf2c4062fd2ad58f906a2d0d", "8dfa47a3153722cb4c276a4eb1973da4a7fed9cdb80989caa3831df38d78e3fdd2d686d8ed9764f268817b9d2e056554");
        TestDigest.testKatHex(new Shabal384(), "e64f3e4ace5c8418d65fec2bc5d2a303dd458034736e3b0df719098be7a206deaf52d6ba82316caf330ef852375188cde2b39cc94aa449578a7e2a8e3f5a9d68e816b8d16889fbc0ebf0939d04f63033ae9ae2bdab73b88c26d6bd25ee460ee1ef58fb0afa92cc539f8c76d3d097e7a6a63ebb9b5887edf3cf076028c5bbd5b9db3211371ad3fe121d4e9bf44229f4e1ecf5a0f9f0eba4d5ceb72878ab22c3f0eb5a625323ac66f7061f4a81fac834471e0c59553f108475fe290d43e6a055ae3ee46fb67422f814a68c4be3e8c9", "c97cf7cac0019ca1ffde633fa856b6bac72688f8ce6f75a4f9fba08b91390fa1eda15624a6c19c4ba48cb81b69de7b67");
        TestDigest.testKatHex(new Shabal384(), "d2cb2d733033f9e91395312808383cc4f0ca974e87ec68400d52e96b3fa6984ac58d9ad0938dde5a973008d818c49607d9de2284e7618f1b8aed8372fbd52ed54557af4220fac09dfa8443011699b97d743f8f2b1aef3537ebb45dcc9e13dfb438428ee190a4efdb3caeb7f3933117bf63abdc7e57beb4171c7e1ad260ab0587806c4d137b6316b50abc9cce0dff3acada47bbb86be777e617bbe578ff4519844db360e0a96c6701290e76bb95d26f0f804c8a4f2717eac4e7de9f2cff3bbc55a17e776c0d02856032a6cd10ad2838", "eebd8089e6f7ee4651c9fd8b50dbf098dc5bea6f5509d1703bc8f1c6f3d7239a880e74d21e8a38b7db473a700b0ddd15");
        TestDigest.testKatHex(new Shabal384(), "f2998955613dd414cc111df5ce30a995bb792e260b0e37a5b1d942fe90171a4ac2f66d4928d7ad377f4d0554cbf4c523d21f6e5f379d6f4b028cdcb9b1758d3b39663242ff3cb6ede6a36a6f05db3bc41e0d861b384b6dec58bb096d0a422fd542df175e1be1571fb52ae66f2d86a2f6824a8cfaacbac4a7492ad0433eeb15454af8f312b3b2a577750e3efbd370e8a8cac1582581971fba3ba4bd0d76e718dacf8433d33a59d287f8cc92234e7a271041b526e389efb0e40b6a18b3aaf658e82ed1c78631fd23b4c3eb27c3faec8685", "52a98e429c639dd8f3b61b87494d21034928cbdf8597604c89960a74c52b984ed1b5953fb30a20b1a31484e0b11531d5");
        TestDigest.testKatHex(new Shabal384(), "447797e2899b72a356ba55bf4df3acca6cdb1041eb477bd1834a9f9acbc340a294d729f2f97df3a610be0ff15edb9c6d5db41644b9874360140fc64f52aa03f0286c8a640670067a84e017926a70438db1bb361defee7317021425f8821def26d1efd77fc853b818545d055adc9284796e583c76e6fe74c9ac2587aa46aa8f8804f2feb5836cc4b3ababab8429a5783e17d5999f32242eb59ef30cd7adabc16d72dbdb097623047c98989f88d14eaf02a7212be16ec2d07981aaa99949ddf89ecd90333a77bc4e1988a82abf7c7caf3291", "d420d4484293edc7054de9332cbdcc38d1a50e4580ba34d73bd2b6b4aa8b8c87a72c5f4dfbcd1b5b5a9cb468ee969711");
        TestDigest.testKatHex(new Shabal384(), "9f2c18ade9b380c784e170fb763e9aa205f64303067eb1bcea93df5dac4bf5a2e00b78195f808df24fc76e26cb7be31dc35f0844cded1567bba29858cffc97fb29010331b01d6a3fb3159cc1b973d255da9843e34a0a4061cabdb9ed37f241bfabb3c20d32743f4026b59a4ccc385a2301f83c0b0a190b0f2d01acb8f0d41111e10f2f4e149379275599a52dc089b35fdd5234b0cfb7b6d8aebd563ca1fa653c5c021dfd6f5920e6f18bfafdbecbf0ab00281333ed50b9a999549c1c8f8c63d7626c48322e9791d5ff72294049bde91e73f8", "e6c72f3edb69efd36bf6a02232aaf77eabaa76cff044811808814afb5bfeffd7935df26e773c76dbdccc346c56037b6a");
        TestDigest.testKatHex(new Shabal384(), "ae159f3fa33619002ae6bcce8cbbdd7d28e5ed9d61534595c4c9f43c402a9bb31f3b301cbfd4a43ce4c24cd5c9849cc6259eca90e2a79e01ffbac07ba0e147fa42676a1d668570e0396387b5bcd599e8e66aaed1b8a191c5a47547f61373021fa6deadcb55363d233c24440f2c73dbb519f7c9fa5a8962efd5f6252c0407f190dfefad707f3c7007d69ff36b8489a5b6b7c557e79dd4f50c06511f599f56c896b35c917b63ba35c6ff8092baf7d1658e77fc95d8a6a43eeb4c01f33f03877f92774be89c1114dd531c011e53a34dc248a2f0e6", "424766e01f2edb8798acf8fba7c63f47827815fac7de51cfd25297c5be3a5c57e1c154443184bd47a11260d78ad2e231");
        TestDigest.testKatHex(new Shabal384(), "3b8e97c5ffc2d6a40fa7de7fcefc90f3b12c940e7ab415321e29ee692dfac799b009c99dcddb708fce5a178c5c35ee2b8617143edc4c40b4d313661f49abdd93cea79d117518805496fe6acf292c4c2a1f76b403a97d7c399daf85b46ad84e16246c67d6836757bde336c290d5d401e6c1386ab32797af6bb251e9b2d8fe754c47482b72e0b394eab76916126fd68ea7d65eb93d59f5b4c5ac40f7c3b37e7f3694f29424c24af8c8f0ef59cd9dbf1d28e0e10f799a6f78cad1d45b9db3d7dee4a7059abe99182714983b9c9d44d7f5643596d4f3", "bec22db51a46aa94fd58f58c7d6db71cccdb8e5ddeed1ea7ecbdb3ecb24a317d16a517fc9f0e598f300c31db9ae01914");
        TestDigest.testKatHex(new Shabal384(), "3434ec31b10fafdbfeec0dd6bd94e80f7ba9dca19ef075f7eb017512af66d6a4bcf7d16ba0819a1892a6372f9b35bcc7ca8155ee19e8428bc22d214856ed5fa9374c3c09bde169602cc219679f65a1566fc7316f4cc3b631a18fb4449fa6afa16a3db2bc4212eff539c67cf184680826535589c7111d73bffce431b4c40492e763d9279560aaa38eb2dc14a212d723f994a1fe656ff4dd14551ce4e7c621b2aa5604a10001b2878a897a28a08095c325e10a26d2fb1a75bfd64c250309bb55a44f23bbac0d5516a1c687d3b41ef2fbbf9cc56d4739", "51b0dd3e48af70a280e79017bec421daa569fd148e242d17c617241808a700d8ae0790951a4241ef5b42becb96aca8cb");
        TestDigest.testKatHex(new Shabal384(), "7c7953d81c8d208fd1c97681d48f49dd003456de60475b84070ef4847c333b74575b1fc8d2a186964485a3b8634feaa3595aaa1a2f4595a7d6b6153563dee31bbac443c8a33eed6d5d956a980a68366c2527b550ee950250dfb691eacbd5d56ae14b970668be174c89df2fea43ae52f13142639c884fd62a3683c0c3792f0f24ab1318bcb27e21f4737fab62c77ea38bc8fd1cf41f7dab64c13febe7152bf5bb7ab5a78f5346d43cc741cb6f72b7b8980f268b68bf62abdfb1577a52438fe14b591498cc95f071228460c7c5d5ceb4a7bde588e7f21c", "f26ac24dd1194b5cd659bf99b267b6a4ce207ea999c65e028b757db528a2f923bb50260fd0e24e9aeebfa8c6324ffbe1");
        TestDigest.testKatHex(new Shabal384(), "7a6a4f4fdc59a1d223381ae5af498d74b7252ecf59e389e49130c7eaee626e7bd9897effd92017f4ccde66b0440462cdedfd352d8153e6a4c8d7a0812f701cc737b5178c2556f07111200eb627dbc299caa792dfa58f35935299fa3a3519e9b03166dffa159103ffa35e8577f7c0a86c6b46fe13db8e2cdd9dcfba85bdddcce0a7a8e155f81f712d8e9fe646153d3d22c811bd39f830433b2213dd46301941b59293fd0a33e2b63adbd95239bc01315c46fdb678875b3c81e053a40f581cfbec24a1404b1671a1b88a6d06120229518fb13a74ca0ac5ae", "f0bd88d33fcb9080013b4d50859d91921e38fd0bc9a230acc327b26d6e99df0e2155eeb15d501ec40b219ab50767057c");
        TestDigest.testKatHex(new Shabal384(), "d9faa14cebe9b7de551b6c0765409a33938562013b5e8e0e1e0a6418df7399d0a6a771fb81c3ca9bd3bb8e2951b0bc792525a294ebd1083688806fe5e7f1e17fd4e3a41d00c89e8fcf4a363caedb1acb558e3d562f1302b3d83bb886ed27b76033798131dab05b4217381eaaa7ba15ec820bb5c13b516dd640eaec5a27d05fdfca0f35b3a5312146806b4c0275bcd0aaa3b2017f346975db566f9b4d137f4ee10644c2a2da66deeca5342e236495c3c6280528bfd32e90af4cd9bb908f34012b52b4bc56d48cc8a6b59bab014988eabd12e1a0a1c2e170e7", "d6724c9829c068c4a68c1215dd6a395cccba45e662d38977592eb40141d826c056262bce4fe46fc979b3a8e327b17659");
        TestDigest.testKatHex(new Shabal384(), "2d8427433d0c61f2d96cfe80cf1e932265a191365c3b61aaa3d6dcc039f6ba2ad52a6a8cc30fc10f705e6b7705105977fa496c1c708a277a124304f1fc40911e7441d1b5e77b951aad7b01fd5db1b377d165b05bbf898042e39660caf8b279fe5229d1a8db86c0999ed65e53d01ccbc4b43173ccf992b3a14586f6ba42f5fe30afa8ae40c5df29966f9346da5f8b35f16a1de3ab6de0f477d8d8660918060e88b9b9e9ca6a4207033b87a812dbf5544d39e4882010f82b6ce005f8e8ff6fe3c3806bc2b73c2b83afb704345629304f9f86358712e9fae3ca3e", "1f29cd5f9301eea68893eef61a9a62977e4ae041106dacefc996917a34e89f1de1202a1be73af79bae263cd0f6e6cfa5");
        TestDigest.testKatHex(new Shabal384(), "5e19d97887fcaac0387e22c6f803c34a3dacd2604172433f7a8a7a526ca4a2a1271ecfc5d5d7be5ac0d85d921095350dfc65997d443c21c8094e0a3fefd2961bcb94aed03291ae310ccda75d8ace4bc7d89e7d3e5d1650bda5d668b8b50bfc8e608e184f4d3a9a2badc4ff5f07e0c0bc8a9f2e0b2a26fd6d8c550008faaab75fd71af2a424bec9a7cd9d83fad4c8e9319115656a8717d3b523a68ff8004258b9990ed362308461804ba3e3a7e92d8f2ffae5c2fba55ba5a3c27c0a2f71bd711d2fe1799c2adb31b200035481e9ee5c4adf2ab9c0fa50b23975cf", "73e5806d0b6735c377f67331890c65d5cd8cd342dccbe38b405f2eacfdcf0ccaaf8e9ca75f7f869026d1956b1b67bd4a");
        TestDigest.testKatHex(new Shabal384(), "c8e976ab4638909387ce3b8d4e510c3230e5690e02c45093b1d297910abc481e56eea0f296f98379dfc9080af69e73b2399d1c143bee80ae1328162ce1ba7f6a8374679b20aacd380eb4e61382c99998704d62701afa914f9a2705cdb065885f50d086c3eb5753700c387118bb142f3e6da1e988dfb31ac75d7368931e45d1391a274b22f83ceb072f9bcabc0b216685bfd789f5023971024b1878a205442522f9ea7d8797a4102a3df41703768251fd5e017c85d1200a464118aa35654e7ca39f3c375b8ef8cbe7534dbc64bc20befb417cf60ec92f63d9ee7397", "69b6965e05af44d0dd9e263b6c29176ace43e461b2fdfbac9ccc76cc6d1cde6812a773e0a8a6889fd93b6ed96f3a1610");
        TestDigest.testKatHex(new Shabal384(), "7145fa124b7429a1fc2231237a949ba7201bcc1822d3272de005b682398196c25f7e5cc2f289fbf44415f699cb7fe6757791b1443410234ae061edf623359e2b4e32c19bf88450432dd01caa5eb16a1dc378f391ca5e3c4e5f356728bddd4975db7c890da8bbc84cc73ff244394d0d48954978765e4a00b593f70f2ca082673a261ed88dbcef1127728d8cd89bc2c597e9102ced6010f65fa75a14ebe467fa57ce3bd4948b6867d74a9df5c0ec6f530cbf2ee61ce6f06bc8f2864dff5583776b31df8c7ffcb61428a56bf7bd37188b4a5123bbf338393af46eda85e6", "f9da9c9032adaab84b8ab7d21e96dd79220e6224ed5ce4b14230846ff79a6035d75b3a9abe7e0000051000af75121a20");
        TestDigest.testKatHex(new Shabal384(), "7fdfadcc9d29bad23ae038c6c65cda1aef757221b8872ed3d75ff8df7da0627d266e224e812c39f7983e4558bfd0a1f2bef3feb56ba09120ef762917b9c093867948547aee98600d10d87b20106878a8d22c64378bf634f7f75900c03986b077b0bf8b740a82447b61b99fee5376c5eb6680ec9e3088f0bdd0c56883413d60c1357d3c811950e5890e7600103c916341b80c743c6a852b7b4fb60c3ba21f3bc15b8382437a68454779cf3cd7f9f90ccc8ef28d0b706535b1e4108eb5627bb45d719cb046839aee311ca1abdc8319e050d67972cb35a6b1601b25dbf487", "4c8707cf2247dd4e8c9611378dbff43dde36cb5202e390dfd438f2c617da290a21b1e55d37d4239a882700300a9218f3");
        TestDigest.testKatHex(new Shabal384(), "988638219fd3095421f826f56e4f09e356296b628c3ce6930c9f2e758fd1a80c8273f2f61e4daae65c4f110d3e7ca0965ac7d24e34c0dc4ba2d6ff0bf5bbe93b3585f354d7543cb542a1aa54674d375077f2d360a8f4d42f3db131c3b7ab7306267ba107659864a90c8c909460a73621d1f5d9d3fd95beb19b23db1cb6c0d0fba91d36891529b8bd8263caa1bab56a4affaed44962df096d8d5b1eb845ef31188b3e10f1af811a13f156beb7a288aae593ebd1471b624aa1a7c6adf01e2200b3d72d88a3aed3100c88231e41efc376906f0b580dc895f080fda5741db1cb", "d409d979bbfa324d6e76413dad9adde2062e7fb8ece2b35507d05a5a1df9089106291ecb428138da620020b6711902eb");
        TestDigest.testKatHex(new Shabal384(), "5aab62756d307a669d146aba988d9074c5a159b3de85151a819b117ca1ff6597f6156e80fdd28c9c3176835164d37da7da11d94e09add770b68a6e081cd22ca0c004bfe7cd283bf43a588da91f509b27a6584c474a4a2f3ee0f1f56447379240a5ab1fb77fdca49b305f07ba86b62756fb9efb4fc225c86845f026ea542076b91a0bc2cdd136e122c659be259d98e5841df4c2f60330d4d8cdee7bf1a0a244524eecc68ff2aef5bf0069c9e87a11c6e519de1a4062a10c83837388f7ef58598a3846f49d499682b683c4a062b421594fafbc1383c943ba83bdef515efcf10d", "664807985d29c44e3c61890ddc3414a3e8f927454883a4be7cc2c30db1c64834853e819795eca671ca3dd6ad6bc3d4cb");
        TestDigest.testKatHex(new Shabal384(), "47b8216aa0fbb5d67966f2e82c17c07aa2d6327e96fcd83e3de7333689f3ee79994a1bf45082c4d725ed8d41205cb5bcdf5c341f77facb1da46a5b9b2cbc49eadf786bcd881f371a95fa17df73f606519aea0ff79d5a11427b98ee7f13a5c00637e2854134691059839121fea9abe2cd1bcbbbf27c74caf3678e05bfb1c949897ea01f56ffa4dafbe8644611685c617a3206c7a7036e4ac816799f693dafe7f19f303ce4eba09d21e03610201bfc665b72400a547a1e00fa9b7ad8d84f84b34aef118515e74def11b9188bd1e1f97d9a12c30132ec2806339bdadacda2fd8b78", "133759b6188f17c2905a5d51077c38bb3e9e9c8194d9c594401781ed0d509f94ae48eae893a8c9ad030b1943ae107b4d");
        TestDigest.testKatHex(new Shabal384(), "8cff1f67fe53c098896d9136389bd8881816ccab34862bb67a656e3d98896f3ce6ffd4da73975809fcdf9666760d6e561c55238b205d8049c1cedeef374d1735daa533147bfa960b2cce4a4f254176bb4d1bd1e89654432b8dbe1a135c42115b394b024856a2a83dc85d6782be4b444239567ccec4b184d4548eae3ff6a192f343292ba2e32a0f267f31cc26719eb85245d415fb897ac2da433ee91a99424c9d7f1766a44171d1651001c38fc79294accc68ceb5665d36218454d3ba169ae058a831338c17743603f81ee173bfc0927464f9bd728dee94c6aeab7aae6ee3a627e8", "a26a2b893b86eab721aeddf196414168ffbb21c91152d6c900bf23d8853c4983d641f78848c46a2ab968a2b0a0f6ad2d");
        TestDigest.testKatHex(new Shabal384(), "eacd07971cff9b9939903f8c1d8cbb5d4db1b548a85d04e037514a583604e787f32992bf2111b97ac5e8a938233552731321522ab5e8583561260b7d13ebeef785b23a41fd8576a6da764a8ed6d822d4957a545d5244756c18aa80e1aad4d1f9c20d259dee1711e2cc8fd013169fb7cc4ce38b362f8e0936ae9198b7e838dcea4f7a5b9429bb3f6bbcf2dc92565e3676c1c5e6eb3dd2a0f86aa23edd3d0891f197447692794b3dfa269611ad97f72b795602b4fdb198f3fd3eb41b415064256e345e8d8c51c555dc8a21904a9b0f1ad0effab7786aac2da3b196507e9f33ca356427", "6c26c6bb4b2653ee58f8fbf0bcc709ac76281c3579fc18fede4a21b400159da2b57a30dfeb26cf0e90867a9f46b758b7");
        TestDigest.testKatHex(new Shabal384(), "23ac4e9a42c6ef45c3336ce6dfc2ff7de8884cd23dc912fef0f7756c09d335c189f3ad3a23697abda851a81881a0c8ccafc980ab2c702564c2be15fe4c4b9f10dfb2248d0d0cb2e2887fd4598a1d4acda897944a2ffc580ff92719c95cf2aa42dc584674cb5a9bc5765b9d6ddf5789791d15f8dd925aa12bffafbce60827b490bb7df3dda6f2a143c8bf96abc903d83d59a791e2d62814a89b8080a28060568cf24a80ae61179fe84e0ffad00388178cb6a617d37efd54cc01970a4a41d1a8d3ddce46edbba4ab7c90ad565398d376f431189ce8c1c33e132feae6a8cd17a61c630012", "67ab7f2b91bb84822bb977749495cc0cf5f6b084405ec632751f3fc9687edc6e84905749c000801fe22be46db8284830");
        TestDigest.testKatHex(new Shabal384(), "0172df732282c9d488669c358e3492260cbe91c95cfbc1e3fea6c4b0ec129b45f242ace09f152fc6234e1bee8aab8cd56e8b486e1dcba9c05407c2f95da8d8f1c0af78ee2ed82a3a79ec0cb0709396ee62aadb84f8a4ee8a7ccca3c1ee84e302a09ea802204afecf04097e67d0f8e8a9d2651126c0a598a37081e42d168b0ae8a71951c524259e4e2054e535b779679bdade566fe55700858618e626b4a0faf895bcce9011504a49e05fd56127eae3d1f8917afb548ecadabda1020111fec9314c413498a360b08640549a22cb23c731ace743252a8227a0d2689d4c6001606678dfb921", "6c7c7f499fa011a3ed5a085a15b998fbb77684063d2a7a188e23edf6618e6d14e2aa8935867465662a54a48f12ec641f");
        TestDigest.testKatHex(new Shabal384(), "3875b9240cf3e0a8b59c658540f26a701cf188496e2c2174788b126fd29402d6a75453ba0635284d08835f40051a2a9683dc92afb9383719191231170379ba6f4adc816fecbb0f9c446b785bf520796841e58878b73c58d3ebb097ce4761fdeabe15de2f319dfbaf1742cdeb389559c788131a6793e193856661376c81ce9568da19aa6925b47ffd77a43c7a0e758c37d69254909ff0fbd415ef8eb937bcd49f91468b49974c07dc819abd67395db0e05874ff83dddab895344abd0e7111b2df9e58d76d85ad98106b36295826be04d435615595605e4b4bb824b33c4afeb5e7bb0d19f909", "7bd189ad3f372fa4e60eaa60fa8b155a190dfac935ee26c5245f4265b53c6fc51cfac0550fd6a933a889aa8b5d306fe5");
        TestDigest.testKatHex(new Shabal384(), "747cc1a59fefba94a9c75ba866c30dc5c1cb0c0f8e9361d98484956dd5d1a40f6184afbe3dac9f76028d1caeccfbf69199c6ce2b4c092a3f4d2a56fe5a33a00757f4d7dee5dfb0524311a97ae0668a47971b95766e2f6dd48c3f57841f91f04a00ad5ea70f2d479a2620dc5cd78eaab3a3b011719b7e78d19ddf70d9423798af77517ebc55392fcd01fc600d8d466b9e7a7a85bf33f9cc5419e9bd874ddfd60981150ddaf8d7febaa4374f0872a5628d318000311e2f5655365ad4d407c20e5c04df17a222e7deec79c5ab1116d8572f91cd06e1ccc7ced53736fc867fd49ecebe6bf8082e8a", "40cf7d1798c1822ccaa8dd8873149c93a058499e21e3aa0143730e198c2c488c8bfd7624fea76f832329e1fe4950cb75");
        TestDigest.testKatHex(new Shabal384(), "57af971fccaec97435dc2ec9ef0429bcedc6b647729ea168858a6e49ac1071e706f4a5a645ca14e8c7746d65511620682c906c8b86ec901f3dded4167b3f00b06cbfac6aee3728051b3e5ff10b4f9ed8bd0b8da94303c833755b3ca3aeddf0b54bc8d6632138b5d25bab03d17b3458a9d782108006f5bb7de75b5c0ba854b423d8bb801e701e99dc4feaad59bc1c7112453b04d33ea3635639fb802c73c2b71d58a56bbd671b18fe34ed2e3dca38827d63fdb1d4fb3285405004b2b3e26081a8ff08cd6d2b08f8e7b7e90a2ab1ed7a41b1d0128522c2f8bff56a7fe67969422ce839a9d4608f03", "9f5c981ed68e3b9207a165340c8ccce66ec217846bdbbfa5a8369e46dedf6f519ac924884ffca8cbc830fe9f6b741314");
        TestDigest.testKatHex(new Shabal384(), "04e16dedc1227902baaf332d3d08923601bdd64f573faa1bb7201918cfe16b1e10151dae875da0c0d63c59c3dd050c4c6a874011b018421afc4623ab0381831b2da2a8ba42c96e4f70864ac44e106f94311051e74c77c1291bf5db9539e69567bf6a11cf6932bbbad33f8946bf5814c066d851633d1a513510039b349939bfd42b858c21827c8ff05f1d09b1b0765dc78a135b5ca4dfba0801bcaddfa175623c8b647eacfb4444b85a44f73890607d06d507a4f8393658788669f6ef4deb58d08c50ca0756d5e2f49d1a7ad73e0f0b3d3b5f090acf622b1878c59133e4a848e05153592ea81c6fbf", "4b0599b35be5557c429d92cd96261ff8abc8337a7037287c760c5b865db6c0deef2b34005e9308c2ecf3a32be024ec2e");
        TestDigest.testKatHex(new Shabal384(), "7c815c384eee0f288ece27cced52a01603127b079c007378bc5d1e6c5e9e6d1c735723acbbd5801ac49854b2b569d4472d33f40bbb8882956245c366dc3582d71696a97a4e19557e41e54dee482a14229005f93afd2c4a7d8614d10a97a9dfa07f7cd946fa45263063ddd29db8f9e34db60daa32684f0072ea2a9426ecebfa5239fb67f29c18cbaa2af6ed4bf4283936823ac1790164fec5457a9cba7c767ca59392d94cab7448f50eb34e9a93a80027471ce59736f099c886dea1ab4cba4d89f5fc7ae2f21ccd27f611eca4626b2d08dc22382e92c1efb2f6afdc8fdc3d2172604f5035c46b8197d3", "35cf858adb34a1dc13cacc2be68e340dfd5a4d9a695b8948c23f1b8d252f3798f7c280c2afdd2c30ffbe3aac6449aa41");
        TestDigest.testKatHex(new Shabal384(), "e29d505158dbdd937d9e3d2145658ee6f5992a2fc790f4f608d9cdb44a091d5b94b88e81fac4fdf5c49442f13b911c55886469629551189eaff62488f1a479b7db11a1560e198ddccccf50159093425ff7f1cb8d1d1246d0978764087d6bac257026b090efae8cec5f22b6f21c59ace1ac7386f5b8837ca6a12b6fbf5534dd0560ef05ca78104d3b943ddb220feaec89aa5e692a00f822a2ab9a2fe60350d75e7be16ff2526dc643872502d01f42f188abed0a6e9a6f5fd0d1ce7d5755c9ffa66b0af0b20bd806f08e06156690d81ac811778ca3dac2c249b96002017fce93e507e3b953acf99964b847", "cebd12b6787985a772aa04cdae83f419c4413a3a11d21ec155b4b574de25b8dd3f950f5e003c3b5af10f92afa2598f0a");
        TestDigest.testKatHex(new Shabal384(), "d85588696f576e65eca0155f395f0cfacd83f36a99111ed5768df2d116d2121e32357ba4f54ede927f189f297d3a97fad4e9a0f5b41d8d89dd7fe20156799c2b7b6bf9c957ba0d6763f5c3bc5129747bbb53652b49290cff1c87e2cdf2c4b95d8aaee09bc8fbfa6883e62d237885810491bfc101f1d8c636e3d0ede838ad05c207a3df4fad76452979eb99f29afaecedd1c63b8d36cf378454a1bb67a741c77ac6b6b3f95f4f02b64dabc15438613ea49750df42ee90101f115aa9abb9ff64324dde9dabbb01054e1bd6b4bcdc7930a44c2300d87ca78c06924d0323ad7887e46c90e8c4d100acd9eed21e", "0da4dccad49da7b95c54fafaf6803a0c23f6659f51d6c1f4bc27a5ff282230325b6fc4a51b22eaa08a30b1c649d169fe");
        TestDigest.testKatHex(new Shabal384(), "3a12f8508b40c32c74492b66323375dcfe49184c78f73179f3314b79e63376b8ac683f5a51f1534bd729b02b04d002f55cbd8e8fc9b5ec1ea6bbe6a0d0e7431518e6ba45d124035f9d3dce0a8bb7bf1430a9f657e0b4ea9f20eb20c786a58181a1e20a96f1628f8728a13bdf7a4b4b32fc8aa7054cc4881ae7fa19afa65c6c3ee1b3ade3192af42054a8a911b8ec1826865d46d93f1e7c5e2b7813c92a506e53886f3d4701bb93d2a681ad109c845904bb861af8af0646b6e399b38b614051d34f6842563a0f37ec00cb3d865fc5d746c4987de2a65071100883a2a9c7a2bfe1e2dd603d9ea24dc7c5fd06be", "cc14e94cb3c6c8f011e4711cfb0c9f6ac74701983736517a5ce042bd8a3c6b4d883031f2472d8a4bcda3374f962cbfdd");
        TestDigest.testKatHex(new Shabal384(), "1861edce46fa5ad17e1ff1deae084dec580f97d0a67885dfe834b9dfac1ae076742ce9e267512ca51f6df5a455af0c5fd6abf94acea103a3370c354485a7846fb84f3ac7c2904b5b2fbf227002ce512133bb7e1c4e50057bfd1e44db33c7cdb969a99e284b184f50a14b068a1fc5009d9b298dbe92239572a7627aac02abe8f3e3b473417f36d4d2505d16b7577f4526c9d94a270a2dfe450d06da8f6fa956879a0a55cfe99e742ea555ea477ba3e9b44ccd508c375423611af92e55345dc215779b2d5119eba49c71d49b9fe3f1569fa24e5ca3e332d042422a8b8158d3ec66a80012976f31ffdf305f0c9c5e", "94848da6e15042eab5b11f53bb3c276eaf4787557bfc06f8e572a3369a10e76d0b7c606fabe35a219b6ef0895ed585f3");
        TestDigest.testKatHex(new Shabal384(), "08d0ffde3a6e4ef65608ea672e4830c12943d7187ccff08f4941cfc13e545f3b9c7ad5eebbe2b01642b486caf855c2c73f58c1e4e3391da8e2d63d96e15fd84953ae5c231911b00ad6050cd7aafdaac9b0f663ae6aab45519d0f5391a541707d479034e73a6ad805ae3598096af078f1393301493d663dd71f83869ca27ba508b7e91e81e128c1716dc3acfe3084b2201e04cf8006617eecf1b640474a5d45cfde9f4d3ef92d6d055b909892194d8a8218db6d8203a84261d200d71473d7488f3427416b6896c137d455f231071cacbc86e0415ab88aec841d96b7b8af41e05bb461a40645bf176601f1e760de5f", "1795269472de464ea95ef2f97da37cba6610855d94647e7823c9494b53c3e9dbc470758769b935eba4b5bf017883634f");
        TestDigest.testKatHex(new Shabal384(), "d782abb72a5be3392757be02d3e45be6e2099d6f000d042c8a543f50ed6ebc055a7f133b0dd8e9bc348536edcaae2e12ec18e8837df7a1b3c87ec46d50c241dee820fd586197552dc20beea50f445a07a38f1768a39e2b2ff05dddedf751f1def612d2e4d810daa3a0cc904516f9a43af660315385178a529e51f8aae141808c8bc5d7b60cac26bb984ac1890d0436ef780426c547e94a7b08f01acbfc4a3825eae04f520a9016f2fb8bf5165ed12736fc71e36a49a73614739eaa3ec834069b1b40f1350c2b3ab885c02c640b9f7686ed5f99527e41cfcd796fe4c256c9173186c226169ff257954ebda81c0e5f99", "936f9829f443a850ddd2d5f3579de501baa636c0f01c027f073443cc3923148f318a8b4bf07d8a982a9c9f14cc2e4b44");
        TestDigest.testKatHex(new Shabal384(), "5fce8109a358570e40983e1184e541833bb9091e280f258cfb144387b05d190e431cb19baa67273ba0c58abe91308e1844dcd0b3678baa42f335f2fa05267a0240b3c718a5942b3b3e3bfa98a55c25a1466e8d7a603722cb2bbf03afa54cd769a99f310735ee5a05dae2c22d397bd95635f58c48a67f90e1b73aafcd3f82117f0166657838691005b18da6f341d6e90fc1cdb352b30fae45d348294e501b63252de14740f2b85ae5299ddec3172de8b6d0ba219a20a23bb5e10ff434d39db3f583305e9f5c039d98569e377b75a70ab837d1df269b8a4b566f40bb91b577455fd3c356c914fa06b9a7ce24c7317a172d", "a95a70be024e96b00a983b422fc87e33f3d2ddc89fb24bc19403ac6f671a5a3e90e1acdd8d43eb2092e984b39df2792d");
        TestDigest.testKatHex(new Shabal384(), "6172f1971a6e1e4e6170afbad95d5fec99bf69b24b674bc17dd78011615e502de6f56b86b1a71d3f4348087218ac7b7d09302993be272e4a591968aef18a1262d665610d1070ee91cc8da36e1f841a69a7a682c580e836941d21d909a3afc1f0b963e1ca5ab193e124a1a53df1c587470e5881fb54dae1b0d840f0c8f9d1b04c645ba1041c7d8dbf22030a623aa15638b3d99a2c400ff76f3252079af88d2b37f35ee66c1ad7801a28d3d388ac450b97d5f0f79e4541755356b3b1a5696b023f39ab7ab5f28df4202936bc97393b93bc915cb159ea1bd7a0a414cb4b7a1ac3af68f50d79f0c9c7314e750f7d02faa58bfa", "8b99f6374c16f0c3a929434e4d8d2e7cf6fe031d9dbdf7926347a1f8e5b6b850aa9850f0bdb989866709ff49de5b7ca4");
        TestDigest.testKatHex(new Shabal384(), "5668ecd99dfbe215c4118398ac9c9eaf1a1433fab4ccdd3968064752b625ea944731f75d48a27d047d67547f14dd0ffaa55fa5e29f7af0d161d85eafc4f2029b717c918eab9d304543290bdba7158b68020c0ba4e079bc95b5bc0fc044a992b94b4ccd3bd66d0eabb5dbbab904d62e00752c4e3b0091d773bcf4c14b4377da3efff824b1cb2fa01b32d1e46c909e626ed2dae920f4c7dbeb635bc754facbd8d49beba3f23c1c41ccbfcd0ee0c114e69737f5597c0bf1d859f0c767e18002ae8e39c26261ffde2920d3d0baf0e906138696cfe5b7e32b600f45df3aaa39932f3a7df95b60fa8712a2271fcaf3911ce7b511b1", "f5f3d6899ad461418e925d4daaffef743c65f8b0fcd05560a1b5c898c17b5dfdecba762fa0fb614513f194391efffd6e");
        TestDigest.testKatHex(new Shabal384(), "03d625488354df30e3f875a68edfcf340e8366a8e1ab67f9d5c5486a96829dfac0578289082b2a62117e1cf418b43b90e0adc881fc6ae8105c888e9ecd21aea1c9ae1a4038dfd17378fed71d02ae492087d7cdcd98f746855227967cb1ab4714261ee3bead3f4db118329d3ebef4bc48a875c19ba763966da0ebea800e01b2f50b00e9dd4caca6dcb314d00184ef71ea2391d760c950710db4a70f9212ffc54861f9dc752ce18867b8ad0c48df8466ef7231e7ac567f0eb55099e622ebb86cb237520190a61c66ad34f1f4e289cb3282ae3eaac6152ed24d2c92bae5a7658252a53c49b7b02dfe54fdb2e90074b6cf310ac661", "ad4229066f5b1225871370e2e3db0a418a84e904a5eeeacd1e1e1b18b86faea4679500c25d58f3352817324eaeac89ac");
        TestDigest.testKatHex(new Shabal384(), "2edc282ffb90b97118dd03aaa03b145f363905e3cbd2d50ecd692b37bf000185c651d3e9726c690d3773ec1e48510e42b17742b0b0377e7de6b8f55e00a8a4db4740cee6db0830529dd19617501dc1e9359aa3bcf147e0a76b3ab70c4984c13e339e6806bb35e683af8527093670859f3d8a0fc7d493bcba6bb12b5f65e71e705ca5d6c948d66ed3d730b26db395b3447737c26fad089aa0ad0e306cb28bf0acf106f89af3745f0ec72d534968cca543cd2ca50c94b1456743254e358c1317c07a07bf2b0eca438a709367fafc89a57239028fc5fecfd53b8ef958ef10ee0608b7f5cb9923ad97058ec067700cc746c127a61ee3", "aad3dfad414334ab96ba1f052b530f92c53e2d14aa4b84ce1075eb1614c772959b26ef4eb1bdb59f0059af6169e2e8a7");
        TestDigest.testKatHex(new Shabal384(), "90b28a6aa1fe533915bcb8e81ed6cacdc10962b7ff82474f845eeb86977600cf70b07ba8e3796141ee340e3fce842a38a50afbe90301a3bdcc591f2e7d9de53e495525560b908c892439990a2ca2679c5539ffdf636777ad9c1cdef809cda9e8dcdb451abb9e9c17efa4379abd24b182bd981cafc792640a183b61694301d04c5b3eaad694a6bd4cc06ef5da8fa23b4fa2a64559c5a68397930079d250c51bcf00e2b16a6c49171433b0aadfd80231276560b80458dd77089b7a1bbcc9e7e4b9f881eacd6c92c4318348a13f4914eb27115a1cfc5d16d7fd94954c3532efaca2cab025103b2d02c6fd71da3a77f417d7932685888a", "05ae362f67d91626aa27755599b8ef4acd968784cabbbb98916ed597aad891b348819e46d480f07eaf5c67b07cb6cc12");
        TestDigest.testKatHex(new Shabal384(), "2969447d175490f2aa9bb055014dbef2e6854c95f8d60950bfe8c0be8de254c26b2d31b9e4de9c68c9adf49e4ee9b1c2850967f29f5d08738483b417bb96b2a56f0c8aca632b552059c59aac3f61f7b45c966b75f1d9931ff4e596406378cee91aaa726a3a84c33f37e9cdbe626b5745a0b06064a8a8d56e53aaf102d23dd9df0a3fdf7a638509a6761a33fa42fa8ddbd8e16159c93008b53765019c3f0e9f10b144ce2ac57f5d7297f9c9949e4ff68b70d339f87501ce8550b772f32c6da8ad2ce2100a895d8b08fa1eead7c376b407709703c510b50f87e73e43f8e7348f87c3832a547ef2bbe5799abedcf5e1f372ea809233f006", "12a442a4c3e49a68e39647dab7d446730abc12f5cba84fc00871c62f5c07050dc3ec4aa3b553cfa8ae24323a9796bb72");
        TestDigest.testKatHex(new Shabal384(), "721645633a44a2c78b19024eaecf58575ab23c27190833c26875dc0f0d50b46aea9c343d82ea7d5b3e50ec700545c615daeaea64726a0f05607576dcd396d812b03fb6551c641087856d050b10e6a4d5577b82a98afb89cee8594c9dc19e79feff0382fcfd127f1b803a4b9946f4ac9a4378e1e6e041b1389a53e3450cd32d9d2941b0cbabdb50da8ea2513145164c3ab6bcbd251c448d2d4b087ac57a59c2285d564f16da4ed5e607ed979592146ffb0ef3f3db308fb342df5eb5924a48256fc763141a278814c82d6d6348577545870ae3a83c7230ac02a1540fe1798f7ef09e335a865a2ae0949b21e4f748fb8a51f44750e213a8fb", "e05b22baf2ed13eedf46facd57ef5a2e416d856d724fb39fbd51492f7f0686552b7d6a0c2d23052e1e6fca0eb3bdd7c1");
        TestDigest.testKatHex(new Shabal384(), "6b860d39725a14b498bb714574b4d37ca787404768f64c648b1751b353ac92bac2c3a28ea909fdf0423336401a02e63ec24325300d823b6864bb701f9d7c7a1f8ec9d0ae3584aa6dd62ea1997cd831b4babd9a4da50932d4efda745c61e4130890e156aee6113716daf95764222a91187db2effea49d5d0596102d619bd26a616bbfda8335505fbb0d90b4c180d1a2335b91538e1668f9f9642790b4e55f9cab0fe2bdd2935d001ee6419abab5457880d0dbff20ed8758f4c20fe759efb33141cf0e892587fe8187e5fbc57786b7e8b089612c936dfc03d27efbbe7c8673f1606bd51d5ff386f4a7ab68edf59f385eb1291f117bfe717399", "8b683ca069cbb46b9256a4a6b17fec4abaff53fc9953851784a9473b9fddbaedee633d7f9606b88c332933a6a27bf537");
        TestDigest.testKatHex(new Shabal384(), "6a01830af3889a25183244decb508bd01253d5b508ab490d3124afbf42626b2e70894e9b562b288d0a2450cfacf14a0ddae5c04716e5a0082c33981f6037d23d5e045ee1ef2283fb8b6378a914c5d9441627a722c282ff452e25a7ea608d69cee4393a0725d17963d0342684f255496d8a18c2961145315130549311fc07f0312fb78e6077334f87eaa873bee8aa95698996eb21375eb2b4ef53c14401207deb4568398e5dd9a7cf97e8c9663e23334b46912f8344c19efcf8c2ba6f04325f1a27e062b62a58d0766fc6db4d2c6a1928604b0175d872d16b7908ebc041761187cc785526c2a3873feac3a642bb39f5351550af9770c328af7b", "be63982a1bf108c657f0d54953b551d5a0ba57f9f95ec397fc671e958f573e520a44ac0e9fd1d030d27402cab5b9c2f3");
        TestDigest.testKatHex(new Shabal384(), "b3c5e74b69933c2533106c563b4ca20238f2b6e675e8681e34a389894785bdade59652d4a73d80a5c85bd454fd1e9ffdad1c3815f5038e9ef432aac5c3c4fe840cc370cf86580a6011778bbedaf511a51b56d1a2eb68394aa299e26da9ada6a2f39b9faff7fba457689b9c1a577b2a1e505fdf75c7a0a64b1df81b3a356001bf0df4e02a1fc59f651c9d585ec6224bb279c6beba2966e8882d68376081b987468e7aed1ef90ebd090ae825795cdca1b4f09a979c8dfc21a48d8a53cdbb26c4db547fc06efe2f9850edd2685a4661cb4911f165d4b63ef25b87d0a96d3dff6ab0758999aad214d07bd4f133a6734fde445fe474711b69a98f7e2b", "fb8fdf08a64d66eec1ba8dce158e421879bc066f85ecade0d0e92d1ec77a5c9958aac6fcbd72c6eea4230500afd9f6ad");
        TestDigest.testKatHex(new Shabal384(), "83af34279ccb5430febec07a81950d30f4b66f484826afee7456f0071a51e1bbc55570b5cc7ec6f9309c17bf5befdd7c6ba6e968cf218a2b34bd5cf927ab846e38a40bbd81759e9e33381016a755f699df35d660007b5eadf292feefb735207ebf70b5bd17834f7bfa0e16cb219ad4af524ab1ea37334aa66435e5d397fc0a065c411ebbce32c240b90476d307ce802ec82c1c49bc1bec48c0675ec2a6c6f3ed3e5b741d13437095707c565e10d8a20b8c20468ff9514fcf31b4249cd82dcee58c0a2af538b291a87e3390d737191a07484a5d3f3fb8c8f15ce056e5e5f8febe5e1fb59d6740980aa06ca8a0c20f5712b4cde5d032e92ab89f0ae1", "a56dff4f83b532087fe5e8c5076f6dc4c0404a0de2c80e26a5803eb2ecdf89734a6d2a8ea73c712e7248aa75921a33a8");
        TestDigest.testKatHex(new Shabal384(), "a7ed84749ccc56bb1dfba57119d279d412b8a986886d810f067af349e8749e9ea746a60b03742636c464fc1ee233acc52c1983914692b64309edfdf29f1ab912ec3e8da074d3f1d231511f5756f0b6eead3e89a6a88fe330a10face267bffbfc3e3090c7fd9a850561f363ad75ea881e7244f80ff55802d5ef7a1a4e7b89fcfa80f16df54d1b056ee637e6964b9e0ffd15b6196bdd7db270c56b47251485348e49813b4eb9ed122a01b3ea45ad5e1a929df61d5c0f3e77e1fdc356b63883a60e9cbb9fc3e00c2f32dbd469659883f690c6772e335f617bc33f161d6f6984252ee12e62b6000ac5231e0c9bc65be223d8dfd94c5004a101af9fd6c0fb", "45ab5ad41c3ae16bcc8e25aa4b6b9bbfe1623bdcd74c6a0ba1991c95ae0320d909165d35635f40a235aa9af71f200ee6");
        TestDigest.testKatHex(new Shabal384(), "a6fe30dcfcda1a329e82ab50e32b5f50eb25c873c5d2305860a835aecee6264aa36a47429922c4b8b3afd00da16035830edb897831c4e7b00f2c23fc0b15fdc30d85fb70c30c431c638e1a25b51caf1d7e8b050b7f89bfb30f59f0f20fecff3d639abc4255b3868fc45dd81e47eb12ab40f2aac735df5d1dc1ad997cefc4d836b854cee9ac02900036f3867fe0d84afff37bde3308c2206c62c4743375094108877c73b87b2546fe05ea137bedfc06a2796274099a0d554da8f7d7223a48cbf31b7decaa1ebc8b145763e3673168c1b1b715c1cd99ecd3ddb238b06049885ecad9347c2436dff32c771f34a38587a44a82c5d3d137a03caa27e66c8ff6", "9b7e5d7a1aaa88fdfa95154bbcf32a543e7e3c61428ae2f13e78ce730f7cb9c4b5e258bdb8fcc99e07fccdbb65b4288d");
        TestDigest.testKatHex(new Shabal384(), "83167ff53704c3aa19e9fb3303539759c46dd4091a52ddae9ad86408b69335989e61414bc20ab4d01220e35241eff5c9522b079fba597674c8d716fe441e566110b6211531ceccf8fd06bc8e511d00785e57788ed9a1c5c73524f01830d2e1148c92d0edc97113e3b7b5cd3049627abdb8b39dd4d6890e0ee91993f92b03354a88f52251c546e64434d9c3d74544f23fb93e5a2d2f1fb15545b4e1367c97335b0291944c8b730ad3d4789273fa44fb98d78a36c3c3764abeeac7c569c1e43a352e5b770c3504f87090dee075a1c4c85c0c39cf421bdcc615f9eff6cb4fe6468004aece5f30e1ecc6db22ad9939bb2b0ccc96521dfbf4ae008b5b46bc006e", "e1fa4aefd798e95562bcd8fbb3965b0a8a9adbb502c2b12b227ec78146da68b20b3471afb85d7df62619c19039d6858a");
        TestDigest.testKatHex(new Shabal384(), "3a3a819c48efde2ad914fbf00e18ab6bc4f14513ab27d0c178a188b61431e7f5623cb66b23346775d386b50e982c493adbbfc54b9a3cd383382336a1a0b2150a15358f336d03ae18f666c7573d55c4fd181c29e6ccfde63ea35f0adf5885cfc0a3d84a2b2e4dd24496db789e663170cef74798aa1bbcd4574ea0bba40489d764b2f83aadc66b148b4a0cd95246c127d5871c4f11418690a5ddf01246a0c80a43c70088b6183639dcfda4125bd113a8f49ee23ed306faac576c3fb0c1e256671d817fc2534a52f5b439f72e424de376f4c565cca82307dd9ef76da5b7c4eb7e085172e328807c02d011ffbf33785378d79dc266f6a5be6bb0e4a92eceebaeb1", "0be93d4b86dd40e7999fbc1fde318431080d8612c28d8290b71167934b17c51589e1d5d083a5e2e6ca0e5826478a80e9");
        TestDigest.reportSuccess("Shabal-384");
    }

    private static void testShabal512() {
        TestDigest.testKatHex(new Shabal512(), "", "fc2d5dff5d70b7f6b1f8c2fcc8c1f9fe9934e54257eded0cf2b539a2ef0a19ccffa84f8d9fa135e4bd3c09f590f3a927ebd603ac29eb729e6f2a9af031ad8dc6");
        TestDigest.testKatHex(new Shabal512(), "cc", "da2621ac83fa9ed23e2fd977cdba8906492e7c9405940974a4017c61a9615bb32a3ec0ff89937b58395168b012175973dea0def7b4412c4c1ed80e5b2d9a6ad0");
        TestDigest.testKatHex(new Shabal512(), "41fb", "4632729e95eef7a43e701f85c9754506d00ac7ea239a7772b920580a93c95daafcd9acc5e29bef2d6fa954355f80095e3521bd1665e5d1fcb079706676319267");
        TestDigest.testKatHex(new Shabal512(), "1f877c", "6e1d4a235cfdad76f8a51396624a28e0b403cc172b94fa3ac198848f66b4033107b5c15f67da912358b4f3fedc85496b4ca5feafbe1e6fdaa921cd6f63f76772");
        TestDigest.testKatHex(new Shabal512(), "c1ecfdfc", "9c97939f8ae8f7a2eef79871cd5dead034b2473ea42a1a07851b343f694b2ecf64da457e75526241f5cc419686f85c9f537c88686057fc3d5dc3546306a30750");
        TestDigest.testKatHex(new Shabal512(), "21f134ac57", "54b1595bf9419f3b84502dd448b00d01731eaea413d4915802afc9fa7c571ffe5488e042bac81f898367873417341c90f6d0ac43743db8be96b362f5eb5e3d7e");
        TestDigest.testKatHex(new Shabal512(), "c6f50bb74e29", "10ca666fc70b270d026f5474149fcef7bf22b1bdd7bf4a9cd2cce0e712096b994c05470b6e923ef342e66f2f785a984a81e638b66502043ceb8315764d2f29ed");
        TestDigest.testKatHex(new Shabal512(), "119713cc83eeef", "a7c8a016e9f7a79f41e04d8654eab638b95d1101ff1f8f8790995c75c765881c880f37e31f24888ddba752cafaffd3c2ca4d9cab645fb2dfa699ad23468d505f");
        TestDigest.testKatHex(new Shabal512(), "4a4f202484512526", "9b01fa44db08b566aec47444a001fc98bae1ab65a13b080b4d17f4da365a23d2ef983e1d974b98b446ae2153bffdcd01345bb168caabbe276317339926853112");
        TestDigest.testKatHex(new Shabal512(), "1f66ab4185ed9b6375", "2daf819e7c98a9f1f53d5448c230a0a4a9345ee019a0881a7849196b8a395b2f0d83ce598e4c640f4e5c9c939a3626660993f58f9541bd4cadc339037e8bd9b0");
        TestDigest.testKatHex(new Shabal512(), "eed7422227613b6f53c9", "4dbab46bc8300e6ebe5e194df7d7098c91dc3f949a03670a21dd211830666b826ad32b788fab0dddb699949708b4056baa3c892bc764adb926c53e918c5dbd6f");
        TestDigest.testKatHex(new Shabal512(), "eaeed5cdffd89dece455f1", "ec9473d49dc9bddda2b5e6194d27a5e828ac0f7fb06998369d734e8786d23efd81742abb0a55636a6186117d2bffb53bf7acc509f71a68cdc6a98a881888d189");
        TestDigest.testKatHex(new Shabal512(), "5be43c90f22902e4fe8ed2d3", "043a8a2b6cc8a4e50e91c2f2c7d6a4a861b07c00137cb8a5922a26017aeb5a94516c81b9afd2be1a2d271f237c8d5285c8dac22c6605d2733958e1687e4e4827");
        TestDigest.testKatHex(new Shabal512(), "a746273228122f381c3b46e4f1", "bff2a10129af8c8f9921b9acd8e27f7ed910d6575183d9542070eea87214dd8481ad3c5844e9d183cee3c8bcc5e90c130d9fa8b2be60e838cf74d9a6bf9c0ecf");
        TestDigest.testKatHex(new Shabal512(), "3c5871cd619c69a63b540eb5a625", "85fc8e23b3020b22902721735e38e68cbb005e7699011a6447a6f201a792c934beef8493d46ec3bcfdb40e2f3a440475ac3e81ac3413fd3dcffbe7d5e889fd9b");
        TestDigest.testKatHex(new Shabal512(), "fa22874bcc068879e8ef11a69f0722", "4031437cbb5d3577ca8d0de6716a1aa097053686534014e83d50bb0f21a79d430f8b39c0acccb1092ffe0473b0ea4f870305e22d32117a0e11fd0e35e50eef4b");
        TestDigest.testKatHex(new Shabal512(), "52a608ab21ccdd8a4457a57ede782176", "50fbb0a4c4c7005c59703c3dee2e2c1ce30b2d20bfdf6331a008b91fc9f7912aedb54691036bfbaa0447b4a6f175ed5ee5909c8cdede09dc9224c9043e97a066");
        TestDigest.testKatHex(new Shabal512(), "82e192e4043ddcd12ecf52969d0f807eed", "e5122dd20a689558143204b7e5b9cb3e26564b9200dd3b6340f9d4c45a51c3a61f6d578c1657890640bdf31f7f4ea3595fff8e6e79fdc04ca9e38885025eac95");
        TestDigest.testKatHex(new Shabal512(), "75683dcb556140c522543bb6e9098b21a21e", "5f96e8a0085e971e69d6f019663c9526f4556a1b220d2ebc06d7b484962a68e00af4402428dec62eaca5a16d3d2c19742f74e8788ce2bef06819fa4be0fbaf51");
        TestDigest.testKatHex(new Shabal512(), "06e4efe45035e61faaf4287b4d8d1f12ca97e5", "e19060dbc19a99a501266f598a6b5bc33b1a6b8e7b736d14473586e497b4b7f965ff4eaee7083ccc3c17ec3323058385f246749a12093486a1fe5917bcc000a6");
        TestDigest.testKatHex(new Shabal512(), "e26193989d06568fe688e75540aea06747d9f851", "f3c06376935aa7fac817f0f9cf06bb04b0574907ded21a631b153c19f3176c0cb0fe3839352a8a5b5acef4cc90b1ac72bd25c7d64c336e101dba3a0b2790d497");
        TestDigest.testKatHex(new Shabal512(), "d8dc8fdefbdce9d44e4cbafe78447bae3b5436102a", "f6c7de9252c46c23dccc4833b611128bef9b66d1fe1b1eedca1ac38646a24da0c9a333d924dbbc6b4c4bca6c461ff2d2e12954092dd2a63f5e2cab2775ee7bbd");
        TestDigest.testKatHex(new Shabal512(), "57085fd7e14216ab102d8317b0cb338a786d5fc32d8f", "90afd209034cad167ab1fc65bf8be05d35492837347cd5a53f4bffa64f772e9c59142541def1586240e94acfc7dfb1dbac8d8851cbecf0d5673438067ba10645");
        TestDigest.testKatHex(new Shabal512(), "a05404df5dbb57697e2c16fa29defac8ab3560d6126fa0", "470f5ed64b254fb22bc20b630ab92612fa22a292ecc7a198b534cf1109c9a3f54e64e29b1231786a1368ee4ab800b627014c83998727ece36470fabab129d55b");
        TestDigest.testKatHex(new Shabal512(), "aecbb02759f7433d6fcb06963c74061cd83b5b3ffa6f13c6", "dc5f847875f3001fe2001c9190383091b65b77936e5465700728a500f3d1f71f8daf7eb59efabb0f73769a8c9f2226e38e5dc2f9b965527c9b2e4dc1265e1174");
        TestDigest.testKatHex(new Shabal512(), "aafdc9243d3d4a096558a360cc27c8d862f0be73db5e88aa55", "c981f4ad4dc1c93f25bee9b76c5501dc2beb86f69c054830d01840ee41834774aeba95aba2705037613760e33b280c6fc866812ff820a1254c21eedf2654e200");
        TestDigest.testKatHex(new Shabal512(), "7bc84867f6f9e9fdc3e1046cae3a52c77ed485860ee260e30b15", "378d903a9bec5f0351da6f7e22603759113416378e39d926f207a217725c6c931b71e04d0193edd637c135de9b966a601704c7dbed895eef9214f629bcd26e6a");
        TestDigest.testKatHex(new Shabal512(), "fac523575a99ec48279a7a459e98ff901918a475034327efb55843", "eb70c65b99f8204b2733d4a92a8c1225bc4974738cc9b7784f1e16c889b96c3d322a7ad62d006c119ea57839eed353d9a841e34b3ef77acf46a8be453066eea0");
        TestDigest.testKatHex(new Shabal512(), "0f8b2d8fcfd9d68cffc17ccfb117709b53d26462a3f346fb7c79b85e", "8daa7f08597352aa8351fac55d8b03962642f159dd2a5c2c8207f26382eb8ed1bb862e878edb880d2931bdbf3af291e4987be4a3b776e5873833d96e537d2ede");
        TestDigest.testKatHex(new Shabal512(), "a963c3e895ff5a0be4824400518d81412f875fa50521e26e85eac90c04", "2f2ee586b1872d091e3293bcfb6554d5b15d11a577f5efe0bc1ec3ae8e3f73ad7d1889958be9e6e816bb20b5af115bcba8a5663cb84a027efa407366e42e769b");
        TestDigest.testKatHex(new Shabal512(), "03a18688b10cc0edf83adf0a84808a9718383c4070c6c4f295098699ac2c", "2856f641be1db58f852fd9bfad37119d8d51515033cbf91cc0fff2a6321596efd2a0b77910356e418621576342f49a21e67f0dd0b54426d8be70dc748d6ff3a5");
        TestDigest.testKatHex(new Shabal512(), "84fb51b517df6c5accb5d022f8f28da09b10232d42320ffc32dbecc3835b29", "11f1d513b267ac8f6752d6645cd64e8cd23ed7e816ffe6b46032563abe77929b3dfc5c46182dc121adedf2cf8314080075d766c4554be6653d851645537cc964");
        TestDigest.testKatHex(new Shabal512(), "9f2fcc7c90de090d6b87cd7e9718c1ea6cb21118fc2d5de9f97e5db6ac1e9c10", "a87b10c3b753180a90b3a0e8651d15e8bee532520883b66bba76e95a7395987b66c438e58ea6d655776d40578c4d4d953a258402853c28f696fc3a18ae242d5e");
        TestDigest.testKatHex(new Shabal512(), "de8f1b3faa4b7040ed4563c3b8e598253178e87e4d0df75e4ff2f2dedd5a0be046", "82a5a1a66b75b7d00acb370275d3d36da6c6af03416ad0df8610f383c732feee823819e539ec17104744ad766786979ad101f8157bdf8372f4e6edd6f0ffe6f8");
        TestDigest.testKatHex(new Shabal512(), "62f154ec394d0bc757d045c798c8b87a00e0655d0481a7d2d9fb58d93aedc676b5a0", "abe62de8a43aebd6ba926f256aef55203feb496db4c1dbf1925eec8dfe6b8e5d1b05aad3ac4b277193f71541c12b7fdc87cbd29dd6efe5be9533d6d26a8f3a38");
        TestDigest.testKatHex(new Shabal512(), "b2dcfe9ff19e2b23ce7da2a4207d3e5ec7c6112a8a22aec9675a886378e14e5bfbad4e", "cd3e55ae0b68504b402cf05b63005d69a22831dbf9d64da6d621a6d9f11c0fa3face1f4117c03e53bc4afec7448b30348151db937102ea8ce66ff866aff13c8a");
        TestDigest.testKatHex(new Shabal512(), "47f5697ac8c31409c0868827347a613a3562041c633cf1f1f86865a576e02835ed2c2492", "3a48941cee753caf7d7816658e482229b8be18176b7826d971908db59d2525d3358a0371ded4cc43c0e1fa6cfb31174341f124cc11774b97a793dbcc284f0a79");
        TestDigest.testKatHex(new Shabal512(), "512a6d292e67ecb2fe486bfe92660953a75484ff4c4f2eca2b0af0edcdd4339c6b2ee4e542", "e2f513d074c82c67f41d769e5a3b8bbdb90815a215611074e3e9592d942c6b345e3d436b9590be03a026144d1571f087ee4a2d93fe9a2fba552d202f812fee45");
        TestDigest.testKatHex(new Shabal512(), "973cf2b4dcf0bfa872b41194cb05bb4e16760a1840d8343301802576197ec19e2a1493d8f4fb", "f5e34e917119698c1118a622d0053060cefb20fcd6688f05181ca4928024a5be014c6ff1795fcf41671d90a9a00c956ade5cc66868edc16664ff7259adc8bd71");
        TestDigest.testKatHex(new Shabal512(), "80beebcd2e3f8a9451d4499961c9731ae667cdc24ea020ce3b9aa4bbc0a7f79e30a934467da4b0", "f39d50d168fee95d82ff6d5f12a71b5a9df565a649e28c5f657bd09ebe896a81e46d3a4624b10ad052725c8865b0f680f53f9312affbf1fe9993bb94258f548f");
        TestDigest.testKatHex(new Shabal512(), "7abaa12ec2a7347674e444140ae0fb659d08e1c66decd8d6eae925fa451d65f3c0308e29446b8ed3", "38c2c20a3896e85a4f57848d88dc99a763e4bc3b36208bd69f1bd9d8de49fe2599158d47b3fd66817aebd61c6d988d56a4139c4774be989b378d1e73b7f22666");
        TestDigest.testKatHex(new Shabal512(), "c88dee9927679b8af422abcbacf283b904ff31e1cac58c7819809f65d5807d46723b20f67ba610c2b7", "7d5d782a1726c21051b33bb2b3cc051182f504a78b29885bfb545e33fecb50bcfc431bbfdcf4afefddfdec497a5674745eaf622619a8dd2cfd73ae8703adbdaf");
        TestDigest.testKatHex(new Shabal512(), "01e43fe350fcec450ec9b102053e6b5d56e09896e0ddd9074fe138e6038210270c834ce6eadc2bb86bf6", "e039799b2abf879d73683f1f7434d4ebe4381199a8bb6649e08091ba41774a53eb2157c83f8e4e90996eb1e12f5d363c39cf200d3e0caae759f980857c113a26");
        TestDigest.testKatHex(new Shabal512(), "337023370a48b62ee43546f17c4ef2bf8d7ecd1d49f90bab604b839c2e6e5bd21540d29ba27ab8e309a4b7", "e8489ee7df2771bda94c90c36f46a4117976e98a8af6adb1c1ea8d84cbd632b6ab23c17e80ac9dd26744f7a7e79ab3454fd7ccac9603c27d58f35c58a86e5da7");
        TestDigest.testKatHex(new Shabal512(), "6892540f964c8c74bd2db02c0ad884510cb38afd4438af31fc912756f3efec6b32b58ebc38fc2a6b913596a8", "1c93bf9e96cd762a9f41b366a928072eef3264965a5867e6ad748a8d3befa5c1dd001dabb3358555eda277042b2ecc044fd194fb4f6fa071bdaad6b5fb51d32d");
        TestDigest.testKatHex(new Shabal512(), "f5961dfd2b1ffffda4ffbf30560c165bfedab8ce0be525845deb8dc61004b7db38467205f5dcfb34a2acfe96c0", "900090ebf1e0b0e5a13d41be17070e49c35469d7aa72b0acbd7f8d806e15ea083043ad6c530aa7a6de15d74e8ab9803b89031117e0538b39cc386e3cd8a3500e");
        TestDigest.testKatHex(new Shabal512(), "ca061a2eb6ceed8881ce2057172d869d73a1951e63d57261384b80ceb5451e77b06cf0f5a0ea15ca907ee1c27eba", "13a3b43be9654f24d055ea7887e26b0542a5d5276919390993ac614ed649f7550418ee350b74b3ccd05efc096fdf23f56b05861146f355360d6d03031d6e99ea");
        TestDigest.testKatHex(new Shabal512(), "1743a77251d69242750c4f1140532cd3c33f9b5ccdf7514e8584d4a5f9fbd730bcf84d0d4726364b9bf95ab251d9bb", "551428d08cd4aa7f858aa1084622bd742fe5ea20b1f2ab5dbba33008239563ea2b772a807a31753822078b3512b41662c0ba8d85cdb9c2745c597186d3319932");
        TestDigest.testKatHex(new Shabal512(), "d8faba1f5194c4db5f176fabfff856924ef627a37cd08cf55608bba8f1e324d7c7f157298eabc4dce7d89ce5162499f9", "d4e627849dbcb2e7156da1ac1080f90f367488b9d8ed411664e5bd77efff877b967f0ce4912c42f85546a041836bc5bbfe8fc084b28dc4e1345c84217e53c2b3");
        TestDigest.testKatHex(new Shabal512(), "be9684be70340860373c9c482ba517e899fc81baaa12e5c6d7727975d1d41ba8bef788cdb5cf4606c9c1c7f61aed59f97d", "a589e7e6a9e2f127e93f527446c43c67bc525f5cfe9f70640ee85d145d4e764d009a5fb5e53838a653c4dae89ca225da69605a60d01a5548ce6139a72adb38f0");
        TestDigest.testKatHex(new Shabal512(), "7e15d2b9ea74ca60f66c8dfab377d9198b7b16deb6a1ba0ea3c7ee2042f89d3786e779cf053c77785aa9e692f821f14a7f51", "ca7b56accb924c6cb22a0283727d56bc47010578d8b847a90bbd11d0213196aa31e951caa8a7e342ac1634e5ad87849dece7d8f77921ffd6af5ca78517cd0bd6");
        TestDigest.testKatHex(new Shabal512(), "9a219be43713bd578015e9fda66c0f2d83cac563b776ab9f38f3e4f7ef229cb443304fba401efb2bdbd7ece939102298651c86", "9c6f32a4cc438fe869105da8bca5bf6a1ecb716f890ebfe628b5928217a5bb9457a819b5f2993fbfb429f4d9bfe02fbe7751d3e8f693f83dd61a300949e956f8");
        TestDigest.testKatHex(new Shabal512(), "c8f2b693bd0d75ef99caebdc22adf4088a95a3542f637203e283bbc3268780e787d68d28cc3897452f6a22aa8573ccebf245972a", "80ec4079f2f6a2cc44755303b772343d837de891d79bd4db7e5994687ff786f90718d4b85d4c01d0b0ba42f491aef18188f4515d4867bf82800c1f8fd218a877");
        TestDigest.testKatHex(new Shabal512(), "ec0f99711016c6a2a07ad80d16427506ce6f441059fd269442baaa28c6ca037b22eeac49d5d894c0bf66219f2c08e9d0e8ab21de52", "9d74d01d9ace10be0b409daba16f9fb345ba161a715a2e058f30d9ec640a19a1bf56d154442a1f42d9e2ab4639f13755ba2a525b698955c914c965d5490d6e1f");
        TestDigest.testKatHex(new Shabal512(), "0dc45181337ca32a8222fe7a3bf42fc9f89744259cff653504d6051fe84b1a7ffd20cb47d4696ce212a686bb9be9a8ab1c697b6d6a33", "cab86aa81e2e23b6c6c7910b2a80127af0b75555d5d642b8b31ef9a164ed43a0e247b578f9bb8a1d077fe72c02152c32b97e51d697f6cc25fdf57ff86b633a4c");
        TestDigest.testKatHex(new Shabal512(), "de286ba4206e8b005714f80fb1cdfaebde91d29f84603e4a3ebc04686f99a46c9e880b96c574825582e8812a26e5a857ffc6579f63742f", "9ebf9d01dfea6c8718a740c75afa4697ae2edd92068e0cef8457553d0a3c230b8462698034b9a9ff5952d62dec75874e3c04e35d5e143f293a0dae267f5a23eb");
        TestDigest.testKatHex(new Shabal512(), "eebcc18057252cbf3f9c070f1a73213356d5d4bc19ac2a411ec8cdeee7a571e2e20eaf61fd0c33a0ffeb297ddb77a97f0a415347db66bcaf", "82a6d1e5c9c17719d36ce001c15f5f760b58c75e12d8c4e59be78a93c6eb799305d36277d0add7a406b2fc7dcd441110ed8ece817a6c38390402c2d49d91b6a0");
        TestDigest.testKatHex(new Shabal512(), "416b5cdc9fe951bd361bd7abfc120a5054758eba88fdd68fd84e39d3b09ac25497d36b43cbe7b85a6a3cebda8db4e5549c3ee51bb6fcb6ac1e", "a81365a4b7853cfa8d3371e3d0047851895d91fc5e8af1b1ec65e0beb98712076a00a50adb3ef99c35ad72fa1e2946ed5d9d29633f414d12b3ee1b91da274a8f");
        TestDigest.testKatHex(new Shabal512(), "5c5faf66f32e0f8311c32e8da8284a4ed60891a5a7e50fb2956b3cbaa79fc66ca376460e100415401fc2b8518c64502f187ea14bfc9503759705", "97489d6513a5176f8115aa4d2c46ab19e21ed461841afa51f24013edbfa9d564f463c9a1cee6d16cf7b96a0b5ce094344deb4e1e8c27bea7364c225853b56f07");
        TestDigest.testKatHex(new Shabal512(), "7167e1e02be1a7ca69d788666f823ae4eef39271f3c26a5cf7cee05bca83161066dc2e217b330df821103799df6d74810eed363adc4ab99f36046a", "44e67b6c8eb5921306b9f2017266e2d2e227a1e346e4a3dfc59dd1f66600a98a82b7e4ff1fb5f56bb69e42e56323542cf8a3f483c368b49291c5eb0eb252d64d");
        TestDigest.testKatHex(new Shabal512(), "2fda311dbba27321c5329510fae6948f03210b76d43e7448d1689a063877b6d14c4f6d0eaa96c150051371f7dd8a4119f7da5c483cc3e6723c01fb7d", "4eeb9c38bfd05ffb06b2144c8b44429eafac22688bfd2493d325156b0c3bc60ca046ccacc9d3d6c4b84245d3945a9530ddf7a341fa694d4348363d9bc7ad9d6a");
        TestDigest.testKatHex(new Shabal512(), "95d1474a5aab5d2422aca6e481187833a6212bd2d0f91451a67dd786dfc91dfed51b35f47e1deb8a8ab4b9cb67b70179cc26f553ae7b569969ce151b8d", "43fd1dc3167918928e1fe7abc46e1455c17688c697d45d5cf5c97112054d61803fad165b6538143dd6279793753c29a26cec1dbc48ba72a492cb33f471c21072");
        TestDigest.testKatHex(new Shabal512(), "c71bd7941f41df044a2927a8ff55b4b467c33d089f0988aa253d294addbdb32530c0d4208b10d9959823f0c0f0734684006df79f7099870f6bf53211a88d", "8e1c1d56a6c405abf8d00e92271977589ba3a463c398b5f04ffaf70a86b67115f71cf6a47102788764b1f3a63fed1811d467fe122d5ac54559d8dc8ba3abd1fb");
        TestDigest.testKatHex(new Shabal512(), "f57c64006d9ea761892e145c99df1b24640883da79d9ed5262859dcda8c3c32e05b03d984f1ab4a230242ab6b78d368dc5aaa1e6d3498d53371e84b0c1d4ba", "73981b87c3038e99d2c863729315aea3d0294904a6d6f0e4c3c2a28d2a503ed835b68f2f4407c99205fa08b2d6067633abc03cfa921dc61b55f9d1671cbe3257");
        TestDigest.testKatHex(new Shabal512(), "e926ae8b0af6e53176dbffcc2a6b88c6bd765f939d3d178a9bde9ef3aa131c61e31c1e42cdfaf4b4dcde579a37e150efbef5555b4c1cb40439d835a724e2fae7", "ec6dbea0c9817a4a29b91e55358da61a9bf6938d5464190f82e48d1c8adc5cdeee3f0b3c6d37ee097db55a725c20282d3b6ddfbc00c57bd8f375536dfdfba36c");
        TestDigest.testKatHex(new Shabal512(), "16e8b3d8f988e9bb04de9c96f2627811c973ce4a5296b4772ca3eefeb80a652bdf21f50df79f32db23f9f73d393b2d57d9a0297f7a2f2e79cfda39fa393df1ac00", "0e7ef0baa779ca25aec58208794c881b2a6a6d1d9d428e77230ef3d810bd6d26c0fc903ca69a76879e42b9a2f7fd6dd8bd24ea9ad3494cab4c91e68d557b559d");
        TestDigest.testKatHex(new Shabal512(), "fc424eeb27c18a11c01f39c555d8b78a805b88dba1dc2a42ed5e2c0ec737ff68b2456d80eb85e11714fa3f8eabfb906d3c17964cb4f5e76b29c1765db03d91be37fc", "da3790270fe14a6b23d84b2ee4f94b3ebb790be0871923a72c80af3de155c1428fb1ddf5a9d5b65600ebb6ab5a7fa4fd6054c178f0dfeb23e5efff6948bbbea5");
        TestDigest.testKatHex(new Shabal512(), "abe3472b54e72734bdba7d9158736464251c4f21b33fbbc92d7fac9a35c4e3322ff01d2380cbaa4ef8fb07d21a2128b7b9f5b6d9f34e13f39c7ffc2e72e47888599ba5", "7c444025258f2b1c7f5bb69a012c9dc94d7e5d8f6b14027c1f5618833b6f079c79060f74476e774f85d00b13c3f678544421b69680e3429a9ca80c856a352163");
        TestDigest.testKatHex(new Shabal512(), "36f9f0a65f2ca498d739b944d6eff3da5ebba57e7d9c41598a2b0e4380f3cf4b479ec2348d015ffe6256273511154afcf3b4b4bf09d6c4744fdd0f62d75079d440706b05", "9121ac20a3450f4fc59d910ce04e17d35567b1e95c15d18e66484bc1be6c8834ade669d0c54bb1decb90a66bc20c6733c3e4386b94dd563296dd565ff918d1f2");
        TestDigest.testKatHex(new Shabal512(), "abc87763cae1ca98bd8c5b82caba54ac83286f87e9610128ae4de68ac95df5e329c360717bd349f26b872528492ca7c94c2c1e1ef56b74dbb65c2ac351981fdb31d06c77a4", "9f56238971ec985fd7a2fa474c92bfeb5c9339308d935212a1b2aefb41e2b0483a147f32ba6a1c9df74a4770656f3d364763e1fc936d4ae8726ee7c4bccf947e");
        TestDigest.testKatHex(new Shabal512(), "94f7ca8e1a54234c6d53cc734bb3d3150c8ba8c5f880eab8d25fed13793a9701ebe320509286fd8e422e931d99c98da4df7e70ae447bab8cffd92382d8a77760a259fc4fbd72", "3d8e1a41f298b79ce5f5320324e858ca995cbc151e9ac6421947cb03349fa9a80c5be83b1f11439e78138eed3d2013308054d578f37e2944b7268bffddf364e1");
        TestDigest.testKatHex(new Shabal512(), "13bd2811f6ed2b6f04ff3895aceed7bef8dcd45eb121791bc194a0f806206bffc3b9281c2b308b1a729ce008119dd3066e9378acdcc50a98a82e20738800b6cddbe5fe9694ad6d", "4148f1271fd2d78a22547b36ee70d3db2ece46cf88d04896b1daa5d248f595aeaaf92ad8193bfc070ab3ad85fca64d8a5bd5c0220ee013c072fe16b996b1824d");
        TestDigest.testKatHex(new Shabal512(), "1eed9cba179a009ec2ec5508773dd305477ca117e6d569e66b5f64c6bc64801ce25a8424ce4a26d575b8a6fb10ead3fd1992edddeec2ebe7150dc98f63adc3237ef57b91397aa8a7", "8000ddfa1adecd711daba701c19cc864ca34d8ed5190d3ed851702bf7095e8713e335015b7daa952929c236b3fbc3dd15a1da27af11338d77240409d3ce3918a");
        TestDigest.testKatHex(new Shabal512(), "ba5b67b5ec3a3ffae2c19dd8176a2ef75c0cd903725d45c9cb7009a900c0b0ca7a2967a95ae68269a6dbf8466c7b6844a1d608ac661f7eff00538e323db5f2c644b78b2d48de1a08aa", "78b35a858da87a410518441f648c1b6784be369c894f63d75381be421e9358bf24e044bf17319a59c0745a9ae509e962efa3392688a20dff97ae061b965d585a");
        TestDigest.testKatHex(new Shabal512(), "0efa26ac5673167dcacab860932ed612f65ff49b80fa9ae65465e5542cb62075df1c5ae54fba4db807be25b070033efa223bdd5b1d3c94c6e1909c02b620d4b1b3a6c9fed24d70749604", "fea95ad572e59b7bd42ab2d8324355e44dfbcedb7a2e1d2e07eebb5fd3fa99a9463b60b73cfd121eb2eb190f52dd49c9bef3f07e90ebc653dd694a4abb5ff06d");
        TestDigest.testKatHex(new Shabal512(), "bbfd933d1fd7bf594ac7f435277dc17d8d5a5b8e4d13d96d2f64e771abbd51a5a8aea741beccbddb177bcea05243ebd003cfdeae877cca4da94605b67691919d8b033f77d384ca01593c1b", "6d353e270f654249deb5a1ca1f0d3ae6761458b6fee7633b6e0664c0a631a85b8f97d25ea7ee3a5acce9dc0f402ff11e354a9003b45f113c1715b17e7198bc72");
        TestDigest.testKatHex(new Shabal512(), "90078999fd3c35b8afbf4066cbde335891365f0fc75c1286cdd88fa51fab94f9b8def7c9ac582a5dbcd95817afb7d1b48f63704e19c2baa4df347f48d4a6d603013c23f1e9611d595ebac37c", "bd36ebc4747b65008167a3c0c70a05e8da43e666a3ca1e42708122a07835aa7af628c4d0e4b321e3cceea60e148311e7871073597bba94ef3f0a86b8201a0b29");
        TestDigest.testKatHex(new Shabal512(), "64105eca863515c20e7cfbaa0a0b8809046164f374d691cdbd6508aaabc1819f9ac84b52bafc1b0fe7cddbc554b608c01c8904c669d8db316a0953a4c68ece324ec5a49ffdb59a1bd6a292aa0e", "c5953d17f3e8ccc08b4d4e95194911aba8f64b5ac34536d740cfac43d2cb294a8c1c4a17ac09e5c9bd4ff575191023b3381360417f473402c753b0980c3dcaae");
        TestDigest.testKatHex(new Shabal512(), "d4654be288b9f3b711c2d02015978a8cc57471d5680a092aa534f7372c71ceaab725a383c4fcf4d8deaa57fca3ce056f312961eccf9b86f14981ba5bed6ab5b4498e1f6c82c6cae6fc14845b3c8a", "9179478c79dbdb3984f3a0eed60241daffd925b0044b6425ece029b8aab4f5a5c0108d65430291e3373930bc766e50e30033068e6b8c4e3b87f13ccb2dd4837e");
        TestDigest.testKatHex(new Shabal512(), "12d9394888305ac96e65f2bf0e1b18c29c90fe9d714dd59f651f52b88b3008c588435548066ea2fc4c101118c91f32556224a540de6efddbca296ef1fb00341f5b01fecfc146bdb251b3bdad556cd2", "c0252afb4c716c3771888cb6a6629d82ea1400030b8eb3691c89327447d861cd2ef9a3fad5693d7ca4c302803d3551d64300cbd23d8e7f83bd3387fe28d92194");
        TestDigest.testKatHex(new Shabal512(), "871a0d7a5f36c3da1dfce57acd8ab8487c274fad336bc137ebd6ff4658b547c1dcfab65f037aa58f35ef16aff4abe77ba61f65826f7be681b5b6d5a1ea8085e2ae9cd5cf0991878a311b549a6d6af230", "5602d9fb8abe287d9a3afbc5e9d145d63c4fa8e0dee76064e268d2f76685eb195fbcf981eae8b2b78c5ad34e383d20ec732cfd8fec637e48fa1fc1ec3880a217");
        TestDigest.testKatHex(new Shabal512(), "e90b4ffef4d457bc7711ff4aa72231ca25af6b2e206f8bf859d8758b89a7cd36105db2538d06da83bad5f663ba11a5f6f61f236fd5f8d53c5e89f183a3cec615b50c7c681e773d109ff7491b5cc22296c5", "88509edd6fe3fc52d42c687115f26abf42b21c11a41145ca8081f71721834bf5d6537517fc5027e0a8cc4e880b55bef9b7caef3449933af2986400c7a19cb9b4");
        TestDigest.testKatHex(new Shabal512(), "e728de62d75856500c4c77a428612cd804f30c3f10d36fb219c5ca0aa30726ab190e5f3f279e0733d77e7267c17be27d21650a9a4d1e32f649627638dbada9702c7ca303269ed14014b2f3cf8b894eac8554", "43a9ac59fca3d971518018c78ea480a8b912c0edb62a362fdb938557c911dc00c60db267af3bf1521e23f0c54eb645d6ea415909f9638ad6b937fcc1dfca25be");
        TestDigest.testKatHex(new Shabal512(), "6348f229e7b1df3b770c77544e5166e081850fa1c6c88169db74c76e42eb983facb276ad6a0d1fa7b50d3e3b6fcd799ec97470920a7abed47d288ff883e24ca21c7f8016b93bb9b9e078bdb9703d2b781b616e", "5b1a8e76ccc21e7ee4989f4020ce4df397cc08bd94c1455f75015aa65e8a499f9c21fdfd35e7258a6201a28e6e083df366e0802ae835312e6f37631163643277");
        TestDigest.testKatHex(new Shabal512(), "4b127fde5de733a1680c2790363627e63ac8a3f1b4707d982caea258655d9bf18f89afe54127482ba01e08845594b671306a025c9a5c5b6f93b0a39522dc877437be5c2436cbf300ce7ab6747934fcfc30aeaaf6", "169fb8aa2f5604135393b89a237212f1abd9202ba5a85fc059be3ae20e2f118481191fcf4a4f3276c2d9ebe1675f1ac96b1319d96815711920345c18f1efc0de");
        TestDigest.testKatHex(new Shabal512(), "08461f006cff4cc64b752c957287e5a0faabc05c9bff89d23fd902d324c79903b48fcb8f8f4b01f3e4ddb483593d25f000386698f5ade7faade9615fdc50d32785ea51d49894e45baa3dc707e224688c6408b68b11", "1c88aca68b57ee2440d5a3cf7fa567fa78756e462b48ffbd8f574f93282568fc4337fef99fb5e471a704f7111e37dae15dec6bcdcfe064c612893faaa1ad6e4d");
        TestDigest.testKatHex(new Shabal512(), "68c8f8849b120e6e0c9969a5866af591a829b92f33cd9a4a3196957a148c49138e1e2f5c7619a6d5edebe995acd81ec8bb9c7b9cfca678d081ea9e25a75d39db04e18d475920ce828b94e72241f24db72546b352a0e4", "2e32776d0cbf2bb6142dfc79fc96a82e03561ef3826c430f8e33f45349f2031f85b4df5c8f3c811125a9348680b5764f2e39f295b6168a0fa90d2da8fc471b7f");
        TestDigest.testKatHex(new Shabal512(), "b8d56472954e31fb54e28fca743f84d8dc34891cb564c64b08f7b71636debd64ca1edbdba7fc5c3e40049ce982bba8c7e0703034e331384695e9de76b5104f2fbc4535ecbeebc33bc27f29f18f6f27e8023b0fbb6f563c", "599482ce8bc8cf06c0c0719cfc85fe5cd4282a56e2c16ac62e55e78a78a8ebe5ab0e9f56a67c177c741b81dd5a90aff882cb1b9feadb78b9859d2e3856b357a8");
        TestDigest.testKatHex(new Shabal512(), "0d58ac665fa84342e60cefee31b1a4eacdb092f122dfc68309077aed1f3e528f578859ee9e4cefb4a728e946324927b675cd4f4ac84f64db3dacfe850c1dd18744c74ceccd9fe4dc214085108f404eab6d8f452b5442a47d", "5a44fcf12cdd24290100f94062e975bf3f1892ff74f87ed430ffa80f1b8aa464d862d4c252e8f4739ac8b73151c652d7224733ef4f02803d2aae54c6356822a0");
        TestDigest.testKatHex(new Shabal512(), "1755e2d2e5d1c1b0156456b539753ff416651d44698e87002dcf61dcfa2b4e72f264d9ad591df1fdee7b41b2eb00283c5aebb3411323b672eaa145c5125185104f20f335804b02325b6dea65603f349f4d5d8b782dd3469ccd", "12dca8e6c0b74b9913e204de2909515ec17db6aab7b26332ed23033f964eef2750281e24b26c60dc7572ca0e44a9b855c723ae94455810c1a8c839efd5c11c14");
        TestDigest.testKatHex(new Shabal512(), "b180de1a611111ee7584ba2c4b020598cd574ac77e404e853d15a101c6f5a2e5c801d7d85dc95286a1804c870bb9f00fd4dcb03aa8328275158819dcad7253f3e3d237aeaa7979268a5db1c6ce08a9ec7c2579783c8afc1f91a7", "41ff98a0f1a8efe1d902a27bf8ebc5d2e3517d733ae40b0c78346532a0b0f835a92870c82c3c76af5256fb18289adfc0036d7dd0f300458208f60fe03dadc6be");
        TestDigest.testKatHex(new Shabal512(), "cf3583cbdfd4cbc17063b1e7d90b02f0e6e2ee05f99d77e24e560392535e47e05077157f96813544a17046914f9efb64762a23cf7a49fe52a0a4c01c630cfe8727b81fb99a89ff7cc11dca5173057e0417b8fe7a9efba6d95c555f", "60c546278aebaac927dbc99cf9c99f9f889f47976b91154be142fc7c7c7d56e26aca8a224ab979c723e49a0575238d643d9ceab1c1a7da22ea03fb9a4d54d80d");
        TestDigest.testKatHex(new Shabal512(), "072fc02340ef99115bad72f92c01e4c093b9599f6cfc45cb380ee686cb5eb019e806ab9bd55e634ab10aa62a9510cc0672cd3eddb589c7df2b67fcd3329f61b1a4441eca87a33c8f55da4fbbad5cf2b2527b8e983bb31a2fadec7523", "c80d8f4e68f44c3c407d4272d3f9885cb02743e7de21b266e8e44a23bfc614d884a6a4b6f3f3ac6a0e5894348aeb93e4ff69d0bb923ab5068b59eecc5420089f");
        TestDigest.testKatHex(new Shabal512(), "76eecf956a52649f877528146de33df249cd800e21830f65e90f0f25ca9d6540fde40603230eca6760f1139c7f268deba2060631eea92b1fff05f93fd5572fbe29579ecd48bc3a8d6c2eb4a6b26e38d6c5fbf2c08044aeea470a8f2f26", "cd513f77e081f4f0acbf2758d0e253d4ea32e771cd7a88e1b5409427f3c09aecb9f75a0f21343c3a6e44a53fce4892da26daa716a702b6824ac380208b41dfe0");
        TestDigest.testKatHex(new Shabal512(), "7adc0b6693e61c269f278e6944a5a2d8300981e40022f839ac644387bfac9086650085c2cdc585fea47b9d2e52d65a2b29a7dc370401ef5d60dd0d21f9e2b90fae919319b14b8c5565b0423cefb827d5f1203302a9d01523498a4db10374", "2b9bc22f46cde3442b4cdfd9529ae70e83c1b8c9461060c83fc9887a082b05bbb4efa4c529093418dc0bcb1b2977a7d950984995398b76b440551e7a10d3f39c");
        TestDigest.testKatHex(new Shabal512(), "e1fffa9826cce8b86bccefb8794e48c46cdf372013f782eced1e378269b7be2b7bf51374092261ae120e822be685f2e7a83664bcfbe38fe8633f24e633ffe1988e1bc5acf59a587079a57a910bda60060e85b5f5b6f776f0529639d9cce4bd", "6847c4ea525ab6d0f6585df367c7ab77f2c8317098e784b852aacaeff4baead52b65ffd3afdc415ca808392eb2833ae957b862165ab2873a5d2216e27c6b5573");
        TestDigest.testKatHex(new Shabal512(), "69f9abba65592ee01db4dce52dbab90b08fc04193602792ee4daa263033d59081587b09bbe49d0b49c9825d22840b2ff5d9c5155f975f8f2c2e7a90c75d2e4a8040fe39f63bbafb403d9e28cc3b86e04e394a9c9e8065bd3c85fa9f0c7891600", "9a47315e05811ab6e144b72b3903e15e4a106c7339ad221bbb65c51739bba2b2b298daa72d10f95cdc579c110881e063b241f746750ff91a54158ac6d29c4a75");
        TestDigest.testKatHex(new Shabal512(), "38a10a352ca5aedfa8e19c64787d8e9c3a75dbf3b8674bfab29b5dbfc15a63d10fae66cd1a6e6d2452d557967eaad89a4c98449787b0b3164ca5b717a93f24eb0b506ceb70cbbcb8d72b2a72993f909aad92f044e0b5a2c9ac9cb16a0ca2f81f49", "19fe9b55a0f3289893f212e340111ccaa587431010c1309a2a37988f8ee46f582a02a52287ad326de4134282d4cb3b4655c30f11d8eb45aeff4dcdb13b877136");
        TestDigest.testKatHex(new Shabal512(), "6d8c6e449bc13634f115749c248c17cd148b72157a2c37bf8969ea83b4d6ba8c0ee2711c28ee11495f43049596520ce436004b026b6c1f7292b9c436b055cbb72d530d860d1276a1502a5140e3c3f54a93663e4d20edec32d284e25564f624955b52", "dad93ec47f211aaa00f43a1546e4c2fc2da0fd28d5c35455f723ff04e37061d83e5a41918c5ab677e6e44fe2bb55de4915dec8d75546aa29d9d07e5c0621faf4");
        TestDigest.testKatHex(new Shabal512(), "6efcbcaf451c129dbe00b9cef0c3749d3ee9d41c7bd500ade40cdc65dedbbbadb885a5b14b32a0c0d087825201e303288a733842fa7e599c0c514e078f05c821c7a4498b01c40032e9f1872a1c925fa17ce253e8935e4c3c71282242cb716b2089ccc1", "5bc29da2f55a6188c710c470017d5e33ef27fe5156e489c67404f989bceb3eaca5bcd462a1d31ee14817073bb0b71228b249a5947d5a657114b587df26a05778");
        TestDigest.testKatHex(new Shabal512(), "433c5303131624c0021d868a30825475e8d0bd3052a022180398f4ca4423b98214b6beaac21c8807a2c33f8c93bd42b092cc1b06cedf3224d5ed1ec29784444f22e08a55aa58542b524b02cd3d5d5f6907afe71c5d7462224a3f9d9e53e7e0846dcbb4ce", "acdaa2c71b9ad576ec5bc73ce30b88a77abe2acbaa2e753faaafc445cb4f9f2ef2383b503f38db14cc0a1218dc6b81f7f5dda7bb3467a5ece9d1e1c53d7f1061");
        TestDigest.testKatHex(new Shabal512(), "a873e0c67ca639026b6683008f7aa6324d4979550e9bce064ca1e1fb97a30b147a24f3f666c0a72d71348ede701cf2d17e2253c34d1ec3b647dbcef2f879f4eb881c4830b791378c901eb725ea5c172316c6d606e0af7df4df7f76e490cd30b2badf45685f", "afadbc4ae0d3e446d010ce9af7ac4f3ca3c20ec99a87f6faa4fb2ef61c448a8c8bbbebd011b343115a3385b98c03201c0bf05db7e72d92aae21230214e37b895");
        TestDigest.testKatHex(new Shabal512(), "006917b64f9dcdf1d2d87c8a6173b64f6587168e80faa80f82d84f60301e561e312d9fbce62f39a6fb476e01e925f26bcc91de621449be6504c504830aae394096c8fc7694651051365d4ee9070101ec9b68086f2ea8f8ab7b811ea8ad934d5c9b62c60a4771", "3d1e5cef8ba3072e0b60fba237c464fbb77c4a936b641517796dcd6e4c19d3e34df75fd12d2a9fcb510cbbea2679582ad2c11f85430de529c728b310d41076b1");
        TestDigest.testKatHex(new Shabal512(), "f13c972c52cb3cc4a4df28c97f2df11ce089b815466be88863243eb318c2adb1a417cb1041308598541720197b9b1cb5ba2318bd5574d1df2174af14884149ba9b2f446d609df240ce335599957b8ec80876d9a085ae084907bc5961b20bf5f6ca58d5dab38adb", "c82089a6b6d64c58da651abfd0794c2f2245b0e3ab9019393b553983f0bc27c04c2669f9422bd634a02761fa51ded9dc821d8a8deb90756d4df0f071e1e6777f");
        TestDigest.testKatHex(new Shabal512(), "e35780eb9799ad4c77535d4ddb683cf33ef367715327cf4c4a58ed9cbdcdd486f669f80189d549a9364fa82a51a52654ec721bb3aab95dceb4a86a6afa93826db923517e928f33e3fba850d45660ef83b9876accafa2a9987a254b137c6e140a21691e1069413848", "456f094683e088abe2a372d9f527936ea7a8349cc4dfa2e6bda5eac4e031abe67f92082d1ef088af721dfef9f3863ed30e418249e1c2667bc9c1cc59144d9189");
        TestDigest.testKatHex(new Shabal512(), "64ec021c9585e01ffe6d31bb50d44c79b6993d72678163db474947a053674619d158016adb243f5c8d50aa92f50ab36e579ff2dabb780a2b529370daa299207cfbcdd3a9a25006d19c4f1fe33e4b1eaec315d8c6ee1e730623fd1941875b924eb57d6d0c2edc4e78d6", "8a81080a123a4bbea22e2a2453b6f64047e97d1f435b09f6c97e62bc4aef70faceddf27b70f0159303fa95b450bcdca6f97c0e926ce880cf6ec537c4cabede59");
        TestDigest.testKatHex(new Shabal512(), "5954bab512cf327d66b5d9f296180080402624ad7628506b555eea8382562324cf452fba4a2130de3e165d11831a270d9cb97ce8c2d32a96f50d71600bb4ca268cf98e90d6496b0a6619a5a8c63db6d8a0634dfc6c7ec8ea9c006b6c456f1b20cd19e781af20454ac880", "a5d3a45670ca6ecb2c6b4bfe1846329b48f58a124f1c9aec209d534f3493399688dab97d6942e1292ade3130e3d03a26356cc11e90519600fcb6a7556053ded3");
        TestDigest.testKatHex(new Shabal512(), "03d9f92b2c565709a568724a0aff90f8f347f43b02338f94a03ed32e6f33666ff5802da4c81bdce0d0e86c04afd4edc2fc8b4141c2975b6f07639b1994c973d9a9afce3d9d365862003498513bfa166d2629e314d97441667b007414e739d7febf0fe3c32c17aa188a8683", "594150557ec70d2080cec95aa2744df7d35df555467397b1eb5fc89e589a277424d143397173cd43a80c93a87376e88c5ca88429e39e7e208afcc7da0c128c87");
        TestDigest.testKatHex(new Shabal512(), "f31e8b4f9e0621d531d22a380be5d9abd56faec53cbd39b1fab230ea67184440e5b1d15457bd25f56204fa917fa48e669016cb48c1ffc1e1e45274b3b47379e00a43843cf8601a5551411ec12503e5aac43d8676a1b2297ec7a0800dbfee04292e937f21c005f17411473041", "cd15b8fbdd1176bdaee28223f0626305248a39df9088335d5c94f1953e287e0cb425a7bc41d420f50a0981546914b280b1148450cbed9cff29ff60ff63f6d99c");
        TestDigest.testKatHex(new Shabal512(), "758ea3fea738973db0b8be7e599bbef4519373d6e6dcd7195ea885fc991d896762992759c2a09002912fb08e0cb5b76f49162aeb8cf87b172cf3ad190253df612f77b1f0c532e3b5fc99c2d31f8f65011695a087a35ee4eee5e334c369d8ee5d29f695815d866da99df3f79403", "662e512f83a3bafe929498ad56f0f0aff8b1728d46e88586bcfe8c738c0574bd8e4524dc832906b3b86993d6b365c04089696192879faa52c8b82a7cb72aa878");
        TestDigest.testKatHex(new Shabal512(), "47c6e0c2b74948465921868804f0f7bd50dd323583dc784f998a93cd1ca4c6ef84d41dc81c2c40f34b5bee6a93867b3bdba0052c5f59e6f3657918c382e771d33109122cc8bb0e1e53c4e3d13b43ce44970f5e0c079d2ad7d7a3549cd75760c21bb15b447589e86e8d76b1e9ced2", "575e30e413db31b5e9b170767d05a748a74c8fd991f8cf7b5b24991cbef7d042696eb57fcac75cf3a8d6420af3ed8f5be6ade113bec9f583f55274b62528ebce");
        TestDigest.testKatHex(new Shabal512(), "f690a132ab46b28edfa6479283d6444e371c6459108afd9c35dbd235e0b6b6ff4c4ea58e7554bd002460433b2164ca51e868f7947d7d7a0d792e4abf0be5f450853cc40d85485b2b8857ea31b5ea6e4ccfa2f3a7ef3380066d7d8979fdac618aad3d7e886dea4f005ae4ad05e5065f", "085ba4367a4e1f24072eda3f157c06583b9a11db25206053e5a277a9468838dc40280b7700681904292d288da2b362d038bef6262ded43a685bb5a5979b1e02e");
        TestDigest.testKatHex(new Shabal512(), "58d6a99bc6458824b256916770a8417040721cccfd4b79eacd8b65a3767ce5ba7e74104c985ac56b8cc9aebd16febd4cda5adb130b0ff2329cc8d611eb14dac268a2f9e633c99de33997fea41c52a7c5e1317d5b5daed35eba7d5a60e45d1fa7eaabc35f5c2b0a0f2379231953322c4e", "f2def966399d551475ddcd96fde854180a977046eeadda6f9d10a9e013823b92f213b15275f2749058422d9d127667ced5c336fd9be33a8d6c766550f13e540e");
        TestDigest.testKatHex(new Shabal512(), "befab574396d7f8b6705e2d5b58b2c1c820bb24e3f4bae3e8fbcd36dbf734ee14e5d6ab972aedd3540235466e825850ee4c512ea9795abfd33f330d9fd7f79e62bbb63a6ea85de15beaeea6f8d204a28956059e2632d11861dfb0e65bc07ac8a159388d5c3277e227286f65ff5e5b5aec1", "214c882fb25d61b6aa94e151c25bc9c2fb412d62f32fff648a726f45e9672ab02fffcb928827184cd84847492f010ebfe7b4d1933f32b1df336ed7569e795bdb");
        TestDigest.testKatHex(new Shabal512(), "8e58144fa9179d686478622ce450c748260c95d1ba43b8f9b59abeca8d93488da73463ef40198b4d16fb0b0707201347e0506ff19d01bea0f42b8af9e71a1f1bd168781069d4d338fdef00bf419fbb003031df671f4a37979564f69282de9c65407847dd0da505ab1641c02dea4f0d834986", "49f2874249183fda35df05bec8915815119daf1aca8043cf520c883381ab73fec0b5279e449c139bf37a7b07bfc9f195cda656a4b654e4828ae6e4403b5137e8");
        TestDigest.testKatHex(new Shabal512(), "b55c10eae0ec684c16d13463f29291bf26c82e2fa0422a99c71db4af14dd9c7f33eda52fd73d017cc0f2dbe734d831f0d820d06d5f89dacc485739144f8cfd4799223b1aff9031a105cb6a029ba71e6e5867d85a554991c38df3c9ef8c1e1e9a7630be61caabca69280c399c1fb7a12d12aefc", "0f7c546d703e9a5055f6f1cfda1fa73e185370e4168b334db67ea6692658b0a0bed1b7b30e67cebdaae6e83a6655b6a561315267b6791b7c59d41c16d84e7cef");
        TestDigest.testKatHex(new Shabal512(), "2eeea693f585f4ed6f6f8865bbae47a6908aecd7c429e4bec4f0de1d0ca0183fa201a0cb14a529b7d7ac0e6ff6607a3243ee9fb11bcf3e2304fe75ffcddd6c5c2e2a4cd45f63c962d010645058d36571404a6d2b4f44755434d76998e83409c3205aa1615db44057db991231d2cb42624574f545", "7bb5ae43d0127a2cd4bea05394fd9fdb02d7eeb0980054dadfdb372fae7395c6a31fa937cf6872816bbd3ee7db8754192181b70a974aa80ba33005fdda2a3dac");
        TestDigest.testKatHex(new Shabal512(), "dab11dc0b047db0420a585f56c42d93175562852428499f66a0db811fcdddab2f7cdffed1543e5fb72110b64686bc7b6887a538ad44c050f1e42631bc4ec8a9f2a047163d822a38989ee4aab01b4c1f161b062d873b1cfa388fd301514f62224157b9bef423c7783b7aac8d30d65cd1bba8d689c2d", "47a5cd65910aed85ab175395a674d4d8d40aa44cf15374d39427ec8a8202a579b6c6f577264b694f11f6a67aa68e90265bbcab9b2482d9fec297099943e0baca");
        TestDigest.testKatHex(new Shabal512(), "42e99a2f80aee0e001279a2434f731e01d34a44b1a8101726921c0590c30f3120eb83059f325e894a5ac959dca71ce2214799916424e859d27d789437b9d27240bf8c35adbafcecc322b48aa205b293962d858652abacbd588bcf6cbc388d0993bd622f96ed54614c25b6a9aa527589eaaffcf17ddf7", "a33f8314c1510965c6b751001328b456036a43e23209b9ccc3f05f913a9fa54b0ef38c3c5ba48b13fd463e1470b543f01338b24421c947f3398b606ee5366530");
        TestDigest.testKatHex(new Shabal512(), "3c9b46450c0f2cae8e3823f8bdb4277f31b744ce2eb17054bddc6dff36af7f49fb8a2320cc3bdf8e0a2ea29ad3a55de1165d219adeddb5175253e2d1489e9b6fdd02e2c3d3a4b54d60e3a47334c37913c5695378a669e9b72dec32af5434f93f46176ebf044c4784467c700470d0c0b40c8a088c815816", "2dc3c4c1c17632328ad9e31cf679ecf51e603725ebbd25d06f9ac154b71a5ceb3a91701249f531f7019a14cee2f5756b1e975c5ad4459d12b8032531cff3a54e");
        TestDigest.testKatHex(new Shabal512(), "d1e654b77cb155f5c77971a64df9e5d34c26a3cad6c7f6b300d39deb1910094691adaa095be4ba5d86690a976428635d5526f3e946f7dc3bd4dbc78999e653441187a81f9adcd5a3c5f254bc8256b0158f54673dcc1232f6e918ebfc6c51ce67eaeb042d9f57eec4bfe910e169af78b3de48d137df4f2840", "be477521f3922419ec4d50dbcaa80095c39b55e080235f6ce9cf4df63dfb3d4634abfb587ae2cff236793f2f75c3827fa4c417f8fe70d7cc9e508dc212e3bc4c");
        TestDigest.testKatHex(new Shabal512(), "626f68c18a69a6590159a9c46be03d5965698f2dac3de779b878b3d9c421e0f21b955a16c715c1ec1e22ce3eb645b8b4f263f60660ea3028981eebd6c8c3a367285b691c8ee56944a7cd1217997e1d9c21620b536bdbd5de8925ff71dec6fbc06624ab6b21e329813de90d1e572dfb89a18120c3f606355d25", "af27b748e31de518d42e52af3584fd1bc5c1460ee2fa187aafaf7a76d5e2762fcf458415ef6cb7d783237af3a8f046817b494e692cec95a1cd443b57428bd940");
        TestDigest.testKatHex(new Shabal512(), "651a6fb3c4b80c7c68c6011675e6094eb56abf5fc3057324ebc6477825061f9f27e7a94633abd1fa598a746e4a577caf524c52ec1788471f92b8c37f23795ca19d559d446cab16cbcdce90b79fa1026cee77bf4ab1b503c5b94c2256ad75b3eac6fd5dcb96aca4b03a834bfb4e9af988cecbf2ae597cb9097940", "1b344be28daf9b413602672589db80ca3c5813e016c1fdd11a976c48b4a798f098987db2c2d3c2c97fc02a0e2f774decf8a3d7fec0ac99da60ae9eed19db6052");
        TestDigest.testKatHex(new Shabal512(), "8aaf072fce8a2d96bc10b3c91c809ee93072fb205ca7f10abd82ecd82cf040b1bc49ea13d1857815c0e99781de3adbb5443ce1c897e55188ceaf221aa9681638de05ae1b322938f46bce51543b57ecdb4c266272259d1798de13be90e10efec2d07484d9b21a3870e2aa9e06c21aa2d0c9cf420080a80a91dee16f", "e5438193b68984f7a2661df0eac5382ff774323b5ae2c13ac7ae32911ab5610631494d5eb43bc8c8205f7ea192c91d63590996bacf1a1192ed9bb0d7ed6123de");
        TestDigest.testKatHex(new Shabal512(), "53f918fd00b1701bd504f8cdea803acca21ac18c564ab90c2a17da592c7d69688f6580575395551e8cd33e0fef08ca6ed4588d4d140b3e44c032355df1c531564d7f4835753344345a6781e11cd5e095b73df5f82c8ae3ad00877936896671e947cc52e2b29dcd463d90a0c9929128da222b5a211450bbc0e02448e2", "9c89a6ed2b2b56747e4bcf5f624b34358b86c26b1df32fc65ef82e644855517acfc5821e3db9bfe4dcd9dd916211a3854792c7d718cc7f80805b31bdcf849de9");
        TestDigest.testKatHex(new Shabal512(), "a64599b8a61b5ccec9e67aed69447459c8da3d1ec6c7c7c82a7428b9b584fa67e90f68e2c00fbbed4613666e5168da4a16f395f7a3c3832b3b134bfc9cbaa95d2a0fe252f44ac6681eb6d40ab91c1d0282fed6701c57463d3c5f2bb8c6a7301fb4576aa3b5f15510db8956ff77478c26a7c09bea7b398cfc83503f538e", "b6cce6004963be8887f3696a60a5709efbc6cdbe45e71454a6cd2d386793587a88929dc94d99bda42fe08f20e6661847aab90c1668459f1dd1f5ab44f55ec4c6");
        TestDigest.testKatHex(new Shabal512(), "0e3ab0e054739b00cdb6a87bd12cae024b54cb5e550e6c425360c2e87e59401f5ec24ef0314855f0f56c47695d56a7fb1417693af2a1ed5291f2fee95f75eed54a1b1c2e81226fbff6f63ade584911c71967a8eb70933bc3f5d15bc91b5c2644d9516d3c3a8c154ee48e118bd1442c043c7a0dba5ac5b1d5360aae5b9065", "049e2244b2900d8939c5539955e95b7342629a6b713a67caa575d35c3c8b7a505d671f57ee3432f386161dda09c89e0584adb7a83a3df10d050256679a481e34");
        TestDigest.testKatHex(new Shabal512(), "a62fc595b4096e6336e53fcdfc8d1cc175d71dac9d750a6133d23199eaac288207944cea6b16d27631915b4619f743da2e30a0c00bbdb1bbb35ab852ef3b9aec6b0a8dcc6e9e1abaa3ad62ac0a6c5de765de2c3711b769e3fde44a74016fff82ac46fa8f1797d3b2a726b696e3dea5530439acee3a45c2a51bc32dd055650b", "426f43d642d488abe1b8df01a3360f2502cef215ef054627a36866f288a4d3eb6f8f6a235247570a8ed4d33dd0419d8f468c8f424e72ae9faa0be929e7824f78");
        TestDigest.testKatHex(new Shabal512(), "2b6db7ced8665ebe9deb080295218426bdaa7c6da9add2088932cdffbaa1c14129bccdd70f369efb149285858d2b1d155d14de2fdb680a8b027284055182a0cae275234cc9c92863c1b4ab66f304cf0621cd54565f5bff461d3b461bd40df28198e3732501b4860eadd503d26d6e69338f4e0456e9e9baf3d827ae685fb1d817", "523d5356af034b0539cdb3f79345167224a4869d19d57ba5f7b5bfecf5b6a4e6b4a88dd2ace88e692c30610ed80753f34baf67ca5bf2698d711b95b77dea58f0");
        TestDigest.testKatHex(new Shabal512(), "10db509b2cdcaba6c062ae33be48116a29eb18e390e1bbada5ca0a2718afbcd23431440106594893043cc7f2625281bf7de2655880966a23705f0c5155c2f5cca9f2c2142e96d0a2e763b70686cd421b5db812daced0c6d65035fde558e94f26b3e6dde5bd13980cc80292b723013bd033284584bff27657871b0cf07a849f4ae2", "02b36c667544ac83108036625eec1b792a32aba2083650afcdb67037009153dfb63f1c2b4c32f61636ff28ec556394f28bff3b524757e829820cdb2f743a85b6");
        TestDigest.testKatHex(new Shabal512(), "9334de60c997bda6086101a6314f64e4458f5ff9450c509df006e8c547983c651ca97879175aaba0c539e82d05c1e02c480975cbb30118121061b1ebac4f8d9a3781e2db6b18042e01ecf9017a64a0e57447ec7fcbe6a7f82585f7403ee2223d52d37b4bf426428613d6b4257980972a0acab508a7620c1cb28eb4e9d30fc41361ec", "7dfd4c6d8af8881b1663d933238f617add982e5437d108ed6a5f7654811732d7a65ab0ef71af83ae078c89d4e99bfcc73ff63ff9dfde887d77007dfd1b3188ad");
        TestDigest.testKatHex(new Shabal512(), "e88ab086891693aa535ceb20e64c7ab97c7dd3548f3786339897a5f0c39031549ca870166e477743ccfbe016b4428d89738e426f5ffe81626137f17aecff61b72dbee2dc20961880cfe281dfab5ee38b1921881450e16032de5e4d55ad8d4fca609721b0692bac79be5a06e177fe8c80c0c83519fb3347de9f43d5561cb8107b9b5edc", "95c4ee5c639428c13c905d72516618893850313fe624b52175ac1b045dc6fb88add293ca6ebd5385ff4e7fb99a5b6dd27e59c8ed0190eab4d1cda6286e223cad");
        TestDigest.testKatHex(new Shabal512(), "fd19e01a83eb6ec810b94582cb8fbfa2fcb992b53684fb748d2264f020d3b960cb1d6b8c348c2b54a9fcea72330c2aaa9a24ecdb00c436abc702361a82bb8828b85369b8c72ece0082fe06557163899c2a0efa466c33c04343a839417057399a63a3929be1ee4805d6ce3e5d0d0967fe9004696a5663f4cac9179006a2ceb75542d75d68", "4c405d3f4cdc3725cdf8b5dda532b9bfb4961f6fd35782b9615a1550f187839823c0d157c13e70f46d15215a7dae01d3b2a433f65eb6b0e7259ef7e6328e4814");
        TestDigest.testKatHex(new Shabal512(), "59ae20b6f7e0b3c7a989afb28324a40fca25d8651cf1f46ae383ef6d8441587aa1c04c3e3bf88e8131ce6145cfb8973d961e8432b202fa5af3e09d625faad825bc19da9b5c6c20d02abda2fcc58b5bd3fe507bf201263f30543819510c12bc23e2ddb4f711d087a86edb1b355313363a2de996b891025e147036087401ccf3ca7815bf3c49", "c17408057b00f30b5733391cb3745ddaede0f76547f82473100e095a57e751f5e2548758e0e9242ed138235b558461b4e1ff7a047efb5261eed8c9c7a5eea73d");
        TestDigest.testKatHex(new Shabal512(), "77ee804b9f3295ab2362798b72b0a1b2d3291dceb8139896355830f34b3b328561531f8079b79a6e9980705150866402fdc176c05897e359a6cb1a7ab067383eb497182a7e5aef7038e4c96d133b2782917417e391535b5e1b51f47d8ed7e4d4025fe98dc87b9c1622614bff3d1029e68e372de719803857ca52067cddaad958951cb2068cc6", "3683e093ec525cc54713504727955aced85fafedd684b78722b96abf989d0b9525f07efbef63ec304de451f425cd36e3580026f6d950ce48bc39f254e4c49b89");
        TestDigest.testKatHex(new Shabal512(), "b771d5cef5d1a41a93d15643d7181d2a2ef0a8e84d91812f20ed21f147bef732bf3a60ef4067c3734b85bc8cd471780f10dc9e8291b58339a677b960218f71e793f2797aea349406512829065d37bb55ea796fa4f56fd8896b49b2cd19b43215ad967c712b24e5032d065232e02c127409d2ed4146b9d75d763d52db98d949d3b0fed6a8052fbb", "d7d8171152228aac608349587369b2d025a4f9b6ff62a55a465718da60337ae6256d7ac51a23aaee2b11ea887093b4248b7ecb98fa27d5aa7b164251a3886c15");
        TestDigest.testKatHex(new Shabal512(), "b32d95b0b9aad2a8816de6d06d1f86008505bd8c14124f6e9a163b5a2ade55f835d0ec3880ef50700d3b25e42cc0af050ccd1be5e555b23087e04d7bf9813622780c7313a1954f8740b6ee2d3f71f768dd417f520482bd3a08d4f222b4ee9dbd015447b33507dd50f3ab4247c5de9a8abd62a8decea01e3b87c8b927f5b08beb37674c6f8e380c04", "1e4bc1daaf45534fa27302a38c56d7d854d726114a74cf0b78e33b1971f2cefa0999c34490714e06a4baf11670ac6fcfbf469ff24a06f5a30ff9ff4af6c6d2af");
        TestDigest.testKatHex(new Shabal512(), "04410e31082a47584b406f051398a6abe74e4da59bb6f85e6b49e8a1f7f2ca00dfba5462c2cd2bfde8b64fb21d70c083f11318b56a52d03b81cac5eec29eb31bd0078b6156786da3d6d8c33098c5c47bb67ac64db14165af65b44544d806dde5f487d5373c7f9792c299e9686b7e5821e7c8e2458315b996b5677d926dac57b3f22da873c601016a0d", "ce48506fa912743b9a91bdea829c6f77794fd73987d25c156d18cea9af442f95c2e32dab4108d99107338b9935e70076f748bb3b2d3cc0c5df401e6193d455c6");
        TestDigest.testKatHex(new Shabal512(), "8b81e9badde026f14d95c019977024c9e13db7a5cd21f9e9fc491d716164bbacdc7060d882615d411438aea056c340cdf977788f6e17d118de55026855f93270472d1fd18b9e7e812bae107e0dfde7063301b71f6cfe4e225cab3b232905a56e994f08ee2891ba922d49c3dafeb75f7c69750cb67d822c96176c46bd8a29f1701373fb09a1a6e3c7158f", "204a0948d591d46bbe62ffa7a2e5ec2fddb775cd5ff8097d69fab62e5fe0f8e17b787c7217c83fed2c367f03e560fe89c40857716ebd4e7a1a9586e4257f4179");
        TestDigest.testKatHex(new Shabal512(), "fa6eed24da6666a22208146b19a532c2ec9ba94f09f1def1e7fc13c399a48e41acc2a589d099276296348f396253b57cb0e40291bd282773656b6e0d8bea1cda084a3738816a840485fcf3fb307f777fa5feac48695c2af4769720258c77943fb4556c362d9cba8bf103aeb9034baa8ea8bfb9c4f8e6742ce0d52c49ea8e974f339612e830e9e7a9c29065", "297c7378811bdd0068f1d92b0c6d0f52ad38da7371d6b217135f827e03751aed62ba0dd2854d0aebfa9dd8e50e3afe63aa76e63e9820994de63cd87005f60488");
        TestDigest.testKatHex(new Shabal512(), "9bb4af1b4f09c071ce3cafa92e4eb73ce8a6f5d82a85733440368dee4eb1cbc7b55ac150773b6fe47dbe036c45582ed67e23f4c74585dab509df1b83610564545642b2b1ec463e18048fc23477c6b2aa035594ecd33791af6af4cbc2a1166aba8d628c57e707f0b0e8707caf91cd44bdb915e0296e0190d56d33d8dde10b5b60377838973c1d943c22ed335e", "a13e1b2922dc478d717865b4bf2140afef7269c0bb132a5f6a684425262622996c96fbbc4c2c6d8eca2d7b2baef0050c69389f3819b99413757d469f2c7a27a6");
        TestDigest.testKatHex(new Shabal512(), "2167f02118cc62043e9091a647cadbed95611a521fe0d64e8518f16c808ab297725598ae296880a773607a798f7c3cfce80d251ebec6885015f9abf7eaabae46798f82cb5926de5c23f44a3f9f9534b3c6f405b5364c2f8a8bdc5ca49c749bed8ce4ba48897062ae8424ca6dde5f55c0e42a95d1e292ca54fb46a84fbc9cd87f2d0c9e7448de3043ae22fdd229", "740582dfe3e3b21997938a30db3263aab38e20be3e143f9d998ea1b261d5969089f81a88d4d9cbaf7efc8b59f5a6301df99feb37b17c2d730ee752d8a0cfdf16");
        TestDigest.testKatHex(new Shabal512(), "94b7fa0bc1c44e949b1d7617d31b4720cbe7ca57c6fa4f4094d4761567e389ecc64f6968e4064df70df836a47d0c713336b5028b35930d29eb7a7f9a5af9ad5cf441745baec9bb014ceeff5a41ba5c1ce085feb980bab9cf79f2158e03ef7e63e29c38d7816a84d4f71e0f548b7fc316085ae38a060ff9b8dec36f91ad9ebc0a5b6c338cbb8f6659d342a24368cf", "7eeaf351c425ac0740fa3f7d2b177f5f68d365c6ba6073f20a9c5b5637d1c37d390965ce2ff3d51b07417179b4e611fc25a0e5585467a8a60f7b5cddf29ad91d");
        TestDigest.testKatHex(new Shabal512(), "ea40e83cb18b3a242c1ecc6ccd0b7853a439dab2c569cfc6dc38a19f5c90acbf76aef9ea3742ff3b54ef7d36eb7ce4ff1c9ab3bc119cff6be93c03e208783335c0ab8137be5b10cdc66ff3f89a1bddc6a1eed74f504cbe7290690bb295a872b9e3fe2cee9e6c67c41db8efd7d863cf10f840fe618e7936da3dca5ca6df933f24f6954ba0801a1294cd8d7e66dfafec", "2dedbbb59c60b85fcc720265105f580748814d744fdbd44c877ef57ae36731ebb4b0e7a5e59500daed111863838b54cdbce7c0fae0133f5adca135496a0a5be8");
        TestDigest.testKatHex(new Shabal512(), "157d5b7e4507f66d9a267476d33831e7bb768d4d04cc3438da12f9010263ea5fcafbde2579db2f6b58f911d593d5f79fb05fe3596e3fa80ff2f761d1b0e57080055c118c53e53cdb63055261d7c9b2b39bd90acc32520cbbdbda2c4fd8856dbcee173132a2679198daf83007a9b5c51511ae49766c792a29520388444ebefe28256fb33d4260439cba73a9479ee00c63", "43e3bb1183e73059945e3167722d90fa1c30e5f73654ae3638ae34682ccb83bb687faa8fb0c522610bdea1c326c87b5245ef7679cf3b9ed38dd604c60e09961c");
        TestDigest.testKatHex(new Shabal512(), "836b34b515476f613fe447a4e0c3f3b8f20910ac89a3977055c960d2d5d2b72bd8acc715a9035321b86703a411dde0466d58a59769672aa60ad587b8481de4bba552a1645779789501ec53d540b904821f32b0bd1855b04e4848f9f8cfe9ebd8911be95781a759d7ad9724a7102dbe576776b7c632bc39b9b5e19057e226552a5994c1dbb3b5c7871a11f5537011044c53", "ad24a75d085be832b08643926f2ca3e0ec691114ddf8d70c8816fc3c02ec1ab95dbcfd129a89e18e0940267e0006c819d6e99c01dc9e0a239ca15760c180e86b");
        TestDigest.testKatHex(new Shabal512(), "cc7784a4912a7ab5ad3620aab29ba87077cd3cb83636adc9f3dc94f51edf521b2161ef108f21a0a298557981c0e53ce6ced45bdf782c1ef200d29bab81dd6460586964edab7cebdbbec75fd7925060f7da2b853b2b089588fa0f8c16ec6498b14c55dcee335cb3a91d698e4d393ab8e8eac0825f8adebeee196df41205c011674e53426caa453f8de1cbb57932b0b741d4c6", "b42c7f1291cd0fdb09f85536a8055df28bc2b2f989567fe2fc3dd8f4515e32ac6a5d154aa159046eea2e522918859a61fa401474c1d6c571ec26c31c42b799b9");
        TestDigest.testKatHex(new Shabal512(), "7639b461fff270b2455ac1d1afce782944aea5e9087eb4a39eb96bb5c3baaf0e868c8526d3404f9405e79e77bfac5ffb89bf1957b523e17d341d7323c302ea7083872dd5e8705694acdda36d5a1b895aaa16eca6104c82688532c8bfe1790b5dc9f4ec5fe95baed37e1d287be710431f1e5e8ee105bc42ed37d74b1e55984bf1c09fe6a1fa13ef3b96faeaed6a2a1950a12153", "a1d058de15bc30b3d2d408860a6ecd33b52301649173bab558be123f1ef509b72107ba7a014a2393a8cb93d64b172894077d455242e552cd6403e758cdad73e7");
        TestDigest.testKatHex(new Shabal512(), "eb6513fc61b30cfba58d4d7e80f94d14589090cf1d80b1df2e68088dc6104959ba0d583d585e9578ab0aec0cf36c48435eb52ed9ab4bbce7a5abe679c97ae2dbe35e8cc1d45b06dda3cf418665c57cbee4bbb47fa4caf78f4ee656fec237fe4eebbafa206e1ef2bd0ee4ae71bd0e9b2f54f91daadf1febfd7032381d636b733dcb3bf76fb14e23aff1f68ed3dbcf75c9b99c6f26", "13868c4d4e25d026bea0b5031e746de208cfcf11b785a788d1c11e9c53240693854d184a4494679708ac581b16ca6c37a0b4994f34ee67fd69d4f132e516638c");
        TestDigest.testKatHex(new Shabal512(), "1594d74bf5dde444265d4c04dad9721ff3e34cbf622daf341fe16b96431f6c4df1f760d34f296eb97d98d560ad5286fec4dce1724f20b54fd7df51d4bf137add656c80546fb1bf516d62ee82baa992910ef4cc18b70f3f8698276fcfb44e0ec546c2c39cfd8ee91034ff9303058b4252462f86c823eb15bf481e6b79cc3a02218595b3658e8b37382bd5048eaed5fd02c37944e73b", "3d99124858f46242417961f31067b25459acc2d00c78a5b0d0f6c747b85d6d5e51a853110904f1e159a3ce3861158e4359689e363abd9daa687a035543f13a7b");
        TestDigest.testKatHex(new Shabal512(), "4cfa1278903026f66fedd41374558be1b585d03c5c55dac94361df286d4bd39c7cb8037ed3b267b07c346626449d0cc5b0dd2cf221f7e4c3449a4be99985d2d5e67bff2923357ddeab5abcb4619f3a3a57b2cf928a022eb27676c6cf805689004fca4d41ea6c2d0a4789c7605f7bb838dd883b3ad3e6027e775bcf262881428099c7fff95b14c095ea130e0b9938a5e22fc52650f591", "8cd9e93a0c8b84cb3889c1830f5ff65ee274584969635f6c48694c46f3206b9ca230a749f6d83bfb16802511d24b3714a97d49783735b05a509464864a64e312");
        TestDigest.testKatHex(new Shabal512(), "d3e65cb92cfa79662f6af493d696a07ccf32aaadcceff06e73e8d9f6f909209e66715d6e978788c49efb9087b170ecf3aa86d2d4d1a065ae0efc8924f365d676b3cb9e2bec918fd96d0b43dee83727c9a93bf56ca2b2e59adba85696546a815067fc7a78039629d4948d157e7b0d826d1bf8e81237bab7321312fdaa4d521744f988db6fdf04549d0fdca393d639c729af716e9c8bba48", "9a551f9016840eca81a40963a1ac8b0f88b3770ea0db3c2696458f2cd613a2b94bf0328a2d3ecabe4563776a973d2ff28ddeec2009f20e70163e52fcebcb0f5f");
        TestDigest.testKatHex(new Shabal512(), "842cc583504539622d7f71e7e31863a2b885c56a0ba62db4c2a3f2fd12e79660dc7205ca29a0dc0a87db4dc62ee47a41db36b9ddb3293b9ac4baae7df5c6e7201e17f717ab56e12cad476be49608ad2d50309e7d48d2d8de4fa58ac3cfeafeee48c0a9eec88498e3efc51f54d300d828dddccb9d0b06dd021a29cf5cb5b2506915beb8a11998b8b886e0f9b7a80e97d91a7d01270f9a7717", "0d607b80d51ffde1f84a5484205e9321be4c862dc8cf7cfe6bb4fd519419d1695426a2b4e06db5f0061ae687891ea9bbf929f78204d03bff6b6ddd0c684b583e");
        TestDigest.testKatHex(new Shabal512(), "6c4b0a0719573e57248661e98febe326571f9a1ca813d3638531ae28b4860f23c3a3a8ac1c250034a660e2d71e16d3acc4bf9ce215c6f15b1c0fc7e77d3d27157e66da9ceec9258f8f2bf9e02b4ac93793dd6e29e307ede3695a0df63cbdc0fc66fb770813eb149ca2a916911bee4902c47c7802e69e405fe3c04ceb5522792a5503fa829f707272226621f7c488a7698c0d69aa561be9f378", "69581389954c5c140a9a98c6d32935cb2600e698ecfc4617e969438ba5b169d449511543604fb37f91f85df3c66c8137f8bca289ab37549c9e6186da40b73c87");
        TestDigest.testKatHex(new Shabal512(), "51b7dbb7ce2ffeb427a91ccfe5218fd40f9e0b7e24756d4c47cd55606008bdc27d16400933906fd9f30effdd4880022d081155342af3fb6cd53672ab7fb5b3a3bcbe47be1fd3a2278cae8a5fd61c1433f7d350675dd21803746cadca574130f01200024c6340ab0cc2cf74f2234669f34e9009ef2eb94823d62b31407f4ba46f1a1eec41641e84d77727b59e746b8a671bef936f05be820759fa", "2043aa77b68b2d2f32691fd42541fa29869f89fc0d08352561a47009fca174ee209977bbea8c86bf1611e9d729b4bd9dd26dcc5f4ca8d3b1c260914e965ae1df");
        TestDigest.testKatHex(new Shabal512(), "83599d93f5561e821bd01a472386bc2ff4efbd4aed60d5821e84aae74d8071029810f5e286f8f17651cd27da07b1eb4382f754cd1c95268783ad09220f5502840370d494beb17124220f6afce91ec8a0f55231f9652433e5ce3489b727716cf4aeba7dcda20cd29aa9a859201253f948dd94395aba9e3852bd1d60dda7ae5dc045b283da006e1cbad83cc13292a315db5553305c628dd091146597", "db452782b6311b718674b31169fb49d255ae68793711ef58e10b328c20a463f340a570b82c79ee19f4f78588936102c8a390e79f6350bf1c8def2042a548328d");
        TestDigest.testKatHex(new Shabal512(), "2be9bf526c9d5a75d565dd11ef63b979d068659c7f026c08bea4af161d85a462d80e45040e91f4165c074c43ac661380311a8cbed59cc8e4c4518e80cd2c78ab1cabf66bff83eab3a80148550307310950d034a6286c93a1ece8929e6385c5e3bb6ea8a7c0fb6d6332e320e71cc4eb462a2a62e2bfe08f0ccad93e61bedb5dd0b786a728ab666f07e0576d189c92bf9fb20dca49ac2d3956d47385e2", "3bd164289d1ea88fa4e3b8a0f89329a9925e71334210e478a2fc1a64b15b7a0de364b68901f7a11dbe92c1d8b5364018e6b478fa70506507195d937f0d5800a3");
        TestDigest.testKatHex(new Shabal512(), "ca76d3a12595a817682617006848675547d3e8f50c2210f9af906c0e7ce50b4460186fe70457a9e879e79fd4d1a688c70a347361c847ba0dd6aa52936eaf8e58a1be2f5c1c704e20146d366aeb3853bed9de9befe9569ac8aaea37a9fb7139a1a1a7d5c748605a8defb297869ebedd71d615a5da23496d11e11abbb126b206fa0a7797ee7de117986012d0362dcef775c2fe145ada6bda1ccb326bf644", "7ff8d77cf940c06faeca9480cea54ec0cef9c62eef0d91442dfe888e88ffd982e251aa29e2e4c73385b84bc198244b4088cee99aec71a857bbeb74e13f3ea5d2");
        TestDigest.testKatHex(new Shabal512(), "f76b85dc67421025d64e93096d1d712b7baf7fb001716f02d33b2160c2c882c310ef13a576b1c2d30ef8f78ef8d2f465007109aad93f74cb9e7d7bef7c9590e8af3b267c89c15db238138c45833c98cc4a471a7802723ef4c744a853cf80a0c2568dd4ed58a2c9644806f42104cee53628e5bdf7b63b0b338e931e31b87c24b146c6d040605567ceef5960df9e022cb469d4c787f4cba3c544a1ac91f95f", "7bb47d72b52fcbc8045c070b93e662f4271e527548ef8af3ce7b8c11fa57c31fbc07b1401e5af426ceaeb334908f4fa482f45df4b6215800dedd921f53c0a352");
        TestDigest.testKatHex(new Shabal512(), "25b8c9c032ea6bcd733ffc8718fbb2a503a4ea8f71dea1176189f694304f0ff68e862a8197b839957549ef243a5279fc2646bd4c009b6d1edebf24738197abb4c992f6b1dc9ba891f570879accd5a6b18691a93c7d0a8d38f95b639c1daeb48c4c2f15ccf5b9d508f8333c32de78781b41850f261b855c4bebcc125a380c54d501c5d3bd07e6b52102116088e53d76583b0161e2a58d0778f091206aabd5a1", "4e4bf67a2d7e7e5152f76720107d6e601a68b78fd54b20dad850fb96dc7cca78880c23b104158b7b849d708a3f726d6bcd4488388149f9c0f5e387d4205d44be");
        TestDigest.testKatHex(new Shabal512(), "21cfdc2a7ccb7f331b3d2eefff37e48ad9fa9c788c3f3c200e0173d99963e1cbca93623b264e920394ae48bb4c3a5bb96ffbc8f0e53f30e22956adabc2765f57fb761e147ecbf8567533db6e50c8a1f894310a94edf806dd8ca6a0e141c0fa7c9fae6c6ae65f18c93a8529e6e5b553bf55f25be2e80a9882bd37f145fecbeb3d447a3c4e46c21524cc55cdd62f521ab92a8ba72b897996c49bb273198b7b1c9e", "b6014df7772c98fefcf94e55afa87e8b09a997510461d9d0a6f1dc7ed3b8439dbc180c50361bb0952a9d36d267a95225a15e10dc61ed8416d48ab9fba0bb68f1");
        TestDigest.testKatHex(new Shabal512(), "4e452ba42127dcc956ef4f8f35dd68cb225fb73b5bc7e1ec5a898bba2931563e74faff3b67314f241ec49f4a7061e3bd0213ae826bab380f1f14faab8b0efddd5fd1bb49373853a08f30553d5a55ccbbb8153de4704f29ca2bdeef0419468e05dd51557ccc80c0a96190bbcc4d77ecff21c66bdf486459d427f986410f883a80a5bcc32c20f0478bb9a97a126fc5f95451e40f292a4614930d054c851acd019ccf", "d9b299d65fd3a667627e84a81e48b6d73c9769ec41d4527c4afa20ec351af13dcaea0a9cf2c284da4fcfb97721e65b8689a91d9de0894145a3cd957b8338a058");
        TestDigest.testKatHex(new Shabal512(), "fa85671df7dadf99a6ffee97a3ab9991671f5629195049880497487867a6c446b60087fac9a0f2fcc8e3b24e97e42345b93b5f7d3691829d3f8ccd4bb36411b85fc2328eb0c51cb3151f70860ad3246ce0623a8dc8b3c49f958f8690f8e3860e71eb2b1479a5cea0b3f8befd87acaf5362435eaeccb52f38617bc6c5c2c6e269ead1fbd69e941d4ad2012da2c5b21bcfbf98e4a77ab2af1f3fda3233f046d38f1dc8", "898c31b45ed39104a63da9664795759d604febd3087037fb291d54d76840b0fda32253a721ff7430d3481d8a98ba8e6c86b2cb43d334ce09c2d5fa3c00317a47");
        TestDigest.testKatHex(new Shabal512(), "e90847ae6797fbc0b6b36d6e588c0a743d725788ca50b6d792352ea8294f5ba654a15366b8e1b288d84f5178240827975a763bc45c7b0430e8a559df4488505e009c63da994f1403f407958203cebb6e37d89c94a5eacf6039a327f6c4dbbc7a2a307d976aa39e41af6537243fc218dfa6ab4dd817b6a397df5ca69107a9198799ed248641b63b42cb4c29bfdd7975ac96edfc274ac562d0474c60347a078ce4c25e88", "52667dd56e6965e342ad6f933e44057f28ba6775e8f4953e25211661e1e0da34277f59c0af7802c97c1c9a1bdec913b8f634031080c6f69231f5c5a725cf8f42");
        TestDigest.testKatHex(new Shabal512(), "f6d5c2b6c93954fc627602c00c4ca9a7d3ed12b27173f0b2c9b0e4a5939398a665e67e69d0b12fb7e4ceb253e8083d1ceb724ac07f009f094e42f2d6f2129489e846eaff0700a8d4453ef453a3eddc18f408c77a83275617fabc4ea3a2833aa73406c0e966276079d38e8e38539a70e194cc5513aaa457c699383fd1900b1e72bdfb835d1fd321b37ba80549b078a49ea08152869a918ca57f5b54ed71e4fd3ac5c06729", "ac7b168ab9ceaf38efe7512e95f6bae7458b927568a33d85afb8dd1558e11a886ce2527bc46178471d4d07e84d6311b7e4e7da9d95c350736131b1e330c53cec");
        TestDigest.testKatHex(new Shabal512(), "cf8562b1bed89892d67ddaaf3deeb28246456e972326dbcdb5cf3fb289aca01e68da5d59896e3a6165358b071b304d6ab3d018944be5049d5e0e2bb819acf67a6006111089e6767132d72dd85beddcbb2d64496db0cc92955ab4c6234f1eea24f2d51483f2e209e4589bf9519fac51b4d061e801125e605f8093bb6997bc163d551596fe4ab7cfae8fb9a90f6980480ce0c229fd1675409bd788354daf316240cfe0af93eb", "d3e9692c6c3a96a38b172e4ffa2abf154838aedf6d1a15587c6c6c173887a1ff376bae1df86ba11062ebf371948478a298cae33b8e4dd405f0423cca2cf031f6");
        TestDigest.testKatHex(new Shabal512(), "2ace31abb0a2e3267944d2f75e1559985db7354c6e605f18dc8470423fca30b7331d9b33c4a4326783d1caae1b4f07060eff978e4746bf0c7e30cd61040bd5ec2746b29863eb7f103ebda614c4291a805b6a4c8214230564a0557bc7102e0bd3ed23719252f7435d64d210ee2aafc585be903fa41e1968c50fd5d5367926df7a05e3a42cf07e656ff92de73b036cf8b19898c0cb34557c0c12c2d8b84e91181af467bc75a9d1", "29a55a860a9091e834341bb7c79b80c2db0963c0c2d73fbb9ce220016e81cb5801c18ba26d26335afaec1133cb9aa3fe9fe9cad2b2053b6fcd4d314c4717e303");
        TestDigest.testKatHex(new Shabal512(), "0d8d09aed19f1013969ce5e7eb92f83a209ae76be31c754844ea9116ceb39a22ebb6003017bbcf26555fa6624185187db8f0cb3564b8b1c06bf685d47f3286eda20b83358f599d2044bbf0583fab8d78f854fe0a596183230c5ef8e54426750eaf2cc4e29d3bdd037e734d863c2bd9789b4c243096138f7672c232314effdfc6513427e2da76916b5248933be312eb5dde4cf70804fb258ac5fb82d58d08177ac6f4756017fff5", "be348239feecbdcb31013ad434b9fca5f1a1db147dfbe3e2d37b3aeb30d7a02b9130843135460ae9787d9005b66cc6ebda19f12922b6869e642e9e815e122a06");
        TestDigest.testKatHex(new Shabal512(), "c3236b73deb7662bf3f3daa58f137b358ba610560ef7455785a9befdb035a066e90704f929bd9689cef0ce3bda5acf4480bceb8d09d10b098ad8500d9b6071dfc3a14af6c77511d81e3aa8844986c3bea6f469f9e02194c92868cd5f51646256798ff0424954c1434bdfed9facb390b07d342e992936e0f88bfd0e884a0ddb679d0547ccdec6384285a45429d115ac7d235a717242021d1dc35641f5f0a48e8445dba58e6cb2c8ea", "84dd20545d9959fa130cd18c8c5002c929610cfd7a3c634381bb16a75876c25eea8fd933122316dc299634d22582c1defc3d35208806fd1c66e26dbb87fd4dc4");
        TestDigest.testKatHex(new Shabal512(), "b39feb8283eadc63e8184b51df5ae3fd41aac8a963bb0be1cd08aa5867d8d910c669221e73243360646f6553d1ca05a84e8dc0de05b6419ec349ca994480193d01c92525f3fb3dcefb08afc6d26947bdbbfd85193f53b50609c6140905c53a6686b58e53a319a57b962331ede98149af3de3118a819da4d76706a0424b4e1d2910b0ed26af61d150ebcb46595d4266a0bd7f651ba47d0c7f179ca28545007d92e8419d48fdfbd744ce", "3f31fb9d7d72818c7951ad5baf652d3638237386e249316d1fd4b05ede808a56e1c7cdd92f036c1d3e8edddc6d0e4eed65ff2bd4bcefd202662a19ea012a59ae");
        TestDigest.testKatHex(new Shabal512(), "a983d54f503803e8c7999f4edbbe82e9084f422143a932ddddc47a17b0b7564a7f37a99d0786e99476428d29e29d3c197a72bfab1342c12a0fc4787fd7017d7a6174049ea43b5779169ef7472bdbbd941dcb82fc73aac45a8a94c9f2bd3477f61fd3b796f02a1b8264a214c6fea74b7051b226c722099ec7883a462b83b6afdd4009248b8a237f605fe5a08fe7d8b45321421ebba67bd70a0b00ddbf94baab7f359d5d1eea105f28dcfb", "71c9f8344066288aff2a40d2587fda07829833921db52db32842afbf6485adf80452eedb08f725b4e8276d660a4127c9633fa05b81675873498e5522a2875cf9");
        TestDigest.testKatHex(new Shabal512(), "e4d1c1897a0a866ce564635b74222f9696bf2c7f640dd78d7e2aca66e1b61c642bb03ea7536aae597811e9bf4a7b453ede31f97b46a5f0ef51a071a2b3918df16b152519ae3776f9f1edab4c2a377c3292e96408359d3613844d5eb393000283d5ad3401a318b12fd1474b8612f2bb50fb6a8b9e023a54d7dde28c43d6d8854c8d9d1155935c199811dbfc87e9e0072e90eb88681cc7529714f8fb8a2c9d88567adfb974ee205a9bf7b848", "a03fdd3b8f9033d1eea5cfb7fc2dde28c1b3b9e8649e4ef21f1044a65868c9e88006ca025ce327ad8ad5925629348a0970261b72df4843a7209e0e2a8b06a1ba");
        TestDigest.testKatHex(new Shabal512(), "b10c59723e3dcadd6d75df87d0a1580e73133a9b7d00cb95ec19f5547027323be75158b11f80b6e142c6a78531886d9047b08e551e75e6261e79785366d7024bd7cd9cf322d9be7d57fb661069f2481c7bb759cd71b4b36ca2bc2df6d3a328faebdb995a9794a8d72155ed551a1f87c80bf6059b43fc764900b18a1c2441f7487743cf84e565f61f8dd2ece6b6ccc9444049197aaaf53e926fbee3bfca8be588ec77f29d211be89de18b15f6", "9518670d8200337a4033ff4d285ab21fff409bf82b2551a1581b8738449166816f0b331a60a9e57c254999d35ef862960664bfe1303090840c5e19a526eeec15");
        TestDigest.testKatHex(new Shabal512(), "db11f609baba7b0ca634926b1dd539c8cbada24967d7add4d9876f77c2d80c0f4dcefbd7121548373582705cca2495bd2a43716fe64ed26d059cfb566b3364bd49ee0717bdd9810dd14d8fad80dbbdc4cafb37cc60fb0fe2a80fb4541b8ca9d59dce457738a9d3d8f641af8c3fd6da162dc16fc01aac527a4a0255b4d231c0be50f44f0db0b713af03d968fe7f0f61ed0824c55c4b5265548febd6aad5c5eedf63efe793489c39b8fd29d104ce", "d5d6ab2cd66072471f14d7d7957c914ddc75c80e27144bd5205eb435520288349970a8a51b5c57856d7dc8ecaa2d8aa4afb121bf6d2489f694782fee7b0ec71d");
        TestDigest.testKatHex(new Shabal512(), "bebd4f1a84fc8b15e4452a54bd02d69e304b7f32616aadd90537937106ae4e28de9d8aab02d19bc3e2fde1d651559e296453e4dba94370a14dbbb2d1d4e2022302ee90e208321efcd8528ad89e46dc839ea9df618ea8394a6bff308e7726bae0c19bcd4be52da6258e2ef4e96aa21244429f49ef5cb486d7ff35cac1bacb7e95711944bccb2ab34700d42d1eb38b5d536b947348a458ede3dc6bd6ec547b1b0cae5b257be36a7124e1060c170ffa", "8c9fd939803ef7b9e00e8443c26ae4a0973fa62704f0d4522c95d6ffd854e77ecbe919cf40168552b29f5b0a385d505299a2b1a2e2bda5d9a47e17e30d648f21");
        TestDigest.testKatHex(new Shabal512(), "5aca56a03a13784bdc3289d9364f79e2a85c12276b49b92db0adaa4f206d5028f213f678c3510e111f9dc4c1c1f8b6acb17a6413aa227607c515c62a733817ba5e762cc6748e7e0d6872c984d723c9bb3b117eb8963185300a80bfa65cde495d70a46c44858605fccbed086c2b45cef963d33294dbe9706b13af22f1b7c4cd5a001cfec251fba18e722c6e1c4b1166918b4f6f48a98b64b3c07fc86a6b17a6d0480ab79d4e6415b520f1c484d675b1", "cf16306cc7cb05dd9c0414161825961a531a5d175cfc08260e7b72f4cd4a4d96a438ac93c1957fe65dbd03373c0eceda002c85b7ed51cc090dc6b4de7c50dce9");
        TestDigest.testKatHex(new Shabal512(), "a5aad0e4646a32c85cfcac73f02fc5300f1982fabb2f2179e28303e447854094cdfc854310e5c0f60993ceff54d84d6b46323d930adb07c17599b35b505f09e784bca5985e0172257797fb53649e2e9723efd16865c31b5c3d5113b58bb0bfc8920fabdda086d7537e66d709d050bd14d0c960873f156fad5b3d3840cdfcdc9be6af519db262a27f40896ab25cc39f96984d650611c0d5a3080d5b3a1bf186abd42956588b3b58cd948970d298776060", "a22443801043c2a3cfae4f46e7d4ca56ff43bdc595db5184c22652e4a0b1dc08113d8d11c521a5a0eeedb2b427eb97ef7ee46fa5a66bc7f89b672f69fe26e5a6");
        TestDigest.testKatHex(new Shabal512(), "06cbbe67e94a978203ead6c057a1a5b098478b4b4cbef5a97e93c8e42f5572713575fc2a884531d7622f8f879387a859a80f10ef02708cd8f7413ab385afc357678b9578c0ebf641ef076a1a30f1f75379e9dcb2a885bdd295905ee80c0168a62a9597d10cf12dd2d8cee46645c7e5a141f6e0e23aa482abe5661c16e69ef1e28371e2e236c359ba4e92c25626a7b7ff13f6ea4ae906e1cfe163e91719b1f750a96cbde5fbc953d9e576cd216afc90323a", "3ba601ec2e4888be0d74916075f437b899d664e68eda73fcc86cecc536a5eeaffab3c5ed0ba0e0ab2138c4e6ce4afb4e9bc6d06172b462ba03cb3b009b57067f");
        TestDigest.testKatHex(new Shabal512(), "f1c528cf7739874707d4d8ad5b98f7c77169de0b57188df233b2dc8a5b31eda5db4291dd9f68e6bad37b8d7f6c9c0044b3bf74bbc3d7d1798e138709b0d75e7c593d3cccdc1b20c7174b4e692add820ace262d45ccfae2077e878796347168060a162ecca8c38c1a88350bd63bb539134f700fd4addd5959e255337daa06bc86358fabcbefdfb5bc889783d843c08aadc6c4f6c36f65f156e851c9a0f917e4a367b5ad93d874812a1de6a7b93cd53ad97232", "543db7636a0cf8aede73ab5135d9872455a128eb4b8bcc73ea33bf0d79b4ba0d467948db94c9d743daf07ba4d9ba92ef8037948083bd3284c4cdd54e99a8f5e1");
        TestDigest.testKatHex(new Shabal512(), "9d9f3a7ecd51b41f6572fd0d0881e30390dfb780991dae7db3b47619134718e6f987810e542619dfaa7b505c76b7350c6432d8bf1cfebdf1069b90a35f0d04cbdf130b0dfc7875f4a4e62cdb8e525aadd7ce842520a482ac18f09442d78305fe85a74e39e760a4837482ed2f437dd13b2ec1042afcf9decdc3e877e50ff4106ad10a525230d11920324a81094da31deab6476aa42f20c84843cfc1c58545ee80352bdd3740dd6a16792ae2d86f11641bb717c2", "a46f0874bc462ce20f877475c0e3c966b80aa37252167940bd0408eeb878cd273817af45418a20ae8145c8709da3c60c1a02ab1b6ce910f0327380f9cb2a92f0");
        TestDigest.testKatHex(new Shabal512(), "5179888724819fbad3afa927d3577796660e6a81c52d98e9303261d5a4a83232f6f758934d50aa83ff9e20a5926dfebaac49529d006eb923c5ae5048ed544ec471ed7191edf46363383824f915769b3e688094c682b02151e5ee01e510b431c8865aff8b6b6f2f59cb6d129da79e97c6d2b8fa6c6da3f603199d2d1bcab547682a81cd6cf65f6551121391d78bcc23b5bd0e922ec6d8bf97c952e84dd28aef909aba31edb903b28fbfc33b7703cd996215a11238", "f6886b9f8b4ac59bd633db7a7a8597270cc06acd843872141934c1f79d28ac15bac57dbefbde899aa148a032825fb1bc131d40fd1f72013578bec5e0f20fc811");
        TestDigest.testKatHex(new Shabal512(), "576ef3520d30b7a4899b8c0d5e359e45c5189add100e43be429a02fb3de5ff4f8fd0e79d9663acca72cd29c94582b19292a557c5b1315297d168fbb54e9e2ecd13809c2b5fce998edc6570545e1499dbe7fb74d47cd7f35823b212b05bf3f5a79caa34224fdd670d335fcb106f5d92c3946f44d3afcbae2e41ac554d8e6759f332b76be89a0324aa12c5482d1ea3ee89ded4936f3e3c080436f539fa137e74c6d3389bdf5a45074c47bc7b20b0948407a66d855e2f", "6df3870b21c5c729b408e1f3d19ba68c0be765205e401ec3427bf7404865c662241d46ded7ce3a4ce118973d29a0153b56d25a22545f7d22916a6efe1101b4da");
        TestDigest.testKatHex(new Shabal512(), "0df2152fa4f4357c8741529dd77e783925d3d76e95bafa2b542a2c33f3d1d117d159cf473f82310356fee4c90a9e505e70f8f24859656368ba09381fa245eb6c3d763f3093f0c89b972e66b53d59406d9f01aea07f8b3b615cac4ee4d05f542e7d0dab45d67ccccd3a606ccbeb31ea1fa7005ba07176e60dab7d78f6810ef086f42f08e595f0ec217372b98970cc6321576d92ce38f7c397a403bada1548d205c343ac09deca86325373c3b76d9f32028fea8eb32515", "239b983d8acc0c68eb66ceb0b9e364e296457ffc8ef2bd2c7980c860589215e70172e084ccf3aafcba25ef621e31e8f318ea4e36bf4851d435ecbeccdcc720f4");
        TestDigest.testKatHex(new Shabal512(), "3e15350d87d6ebb5c8ad99d42515cfe17980933c7a8f6b8bbbf0a63728cefaad2052623c0bd5931839112a48633fb3c2004e0749c87a41b26a8b48945539d1ff41a4b269462fd199bfecd45374756f55a9116e92093ac99451aefb2af9fd32d6d7f5fbc7f7a540d5097c096ebc3b3a721541de073a1cc02f7fb0fb1b9327fb0b1218ca49c9487ab5396622a13ae546c97abdef6b56380dda7012a8384091b6656d0ab272d363cea78163ff765cdd13ab1738b940d16cae", "45c35812126376922acabd4de26dec6c9dbef1a03e56417af37a21e089ef4c6acf9dcbd3bef6d77502117caa728a7a76a30dea9c7090c50a619c01c36be569be");
        TestDigest.testKatHex(new Shabal512(), "c38d6b0b757cb552be40940ece0009ef3b0b59307c1451686f1a22702922800d58bce7a636c1727ee547c01b214779e898fc0e560f8ae7f61bef4d75eaa696b921fd6b735d171535e9edd267c192b99880c87997711002009095d8a7a437e258104a41a505e5ef71e5613ddd2008195f0c574e6ba3fe40099cfa116e5f1a2fa8a6da04badcb4e2d5d0de31fdc4800891c45781a0aac7c907b56d631fca5ce8b2cde620d11d1777ed9fa603541de794ddc5758fcd5fad78c0", "bc35f6aa0e55fd2fa495d1876ad5ba8bd6f336822343a07713cc71c44b892ffc344c88cbebadf2fd7e2094e11b90747c4fc87fdd63a342ac204052be6530a7bd");
        TestDigest.testKatHex(new Shabal512(), "8d2de3f0b37a6385c90739805b170057f091cd0c7a0bc951540f26a5a75b3e694631bb64c7635eed316f51318e9d8de13c70a2aba04a14836855f35e480528b776d0a1e8a23b547c8b8d6a0d09b241d3be9377160cca4e6793d00a515dc2992cb7fc741daca171431da99cce6f7789f129e2ac5cf65b40d703035cd2185bb936c82002daf8cbc27a7a9e554b06196630446a6f0a14ba155ed26d95bd627b7205c072d02b60db0fd7e49ea058c2e0ba202daff0de91e845cf79", "8225b83d20eb8e15d5b6286cee404e414e29e6d72a470d5b76521093795796b8f83c9c1ba58d4f7afd6a5552d2676fc2106b10acbf90087c5e2a8b1ce9ed7a21");
        TestDigest.testKatHex(new Shabal512(), "c464bbdad275c50dcd983b65ad1019b9ff85a1e71c807f3204bb2c921dc31fbcd8c5fc45868ae9ef85b6c9b83bba2a5a822201ed68586ec5ec27fb2857a5d1a2d09d09115f22dcc39fe61f5e1ba0ff6e8b4acb4c6da748be7f3f0839739394ff7fa8e39f7f7e84a33c3866875c01bcb1263c9405d91908e9e0b50e7459fabb63d8c6bbb73d8e3483c099b55bc30ff092ff68b6adedfd477d63570c9f5515847f36e24ba0b705557130cec57ebad1d0b31a378e91894ee26e3a04", "30c62c0816ab3d4651443eaae531331889684038f7376e7c7c72a5ab5e59d82d71ed356e8a26cee601ccd111f6874921fffa9dab1465a7ce70db2b1f26ca390f");
        TestDigest.testKatHex(new Shabal512(), "8b8d68bb8a75732fe272815a68a1c9c5aa31b41dedc8493e76525d1d013d33cebd9e21a5bb95db2616976a8c07fcf411f5f6bc6f7e0b57aca78cc2790a6f9b898858ac9c79b165ff24e66677531e39f572be5d81eb3264524181115f32780257bfb9aeec6af12af28e587cac068a1a2953b59ad680f4c245b2e3ec36f59940d37e1d3db38e13edb29b5c0f404f6ff87f80fc8be7a225ff22fbb9c8b6b1d7330c57840d24bc75b06b80d30dad6806544d510af6c4785e823ac3e0b8", "c980bb303f4207db77325cc0b05572ab54592f7094468d4b1a2b8c78bc3ffda17e9c447e8949d22ea8f1cbae6a782fa531c61111ee16272804c0eb9079f26f20");
        TestDigest.testKatHex(new Shabal512(), "6b018710446f368e7421f1bc0ccf562d9c1843846bc8d98d1c9bf7d9d6fcb48bfc3bf83b36d44c4fa93430af75cd190bde36a7f92f867f58a803900df8018150384d85d82132f123006ac2aeba58e02a037fe6afbd65eca7c44977dd3dc74f48b6e7a1bfd5cc4dcf24e4d52e92bd4455848e4928b0eac8b7476fe3cc03e862aa4dff4470dbfed6de48e410f25096487ecfc32a27277f3f5023b2725ade461b1355889554a8836c9cf53bd767f5737d55184eea1ab3f53edd0976c485", "8e34c34d9b1f9841c51cadcb4d476c8cda875ef40e59dd91709adb323d10ae0d12b48241dedbe67ccc33cc90b8851adda265bceec417e133e369ff0a3c4ca384");
        TestDigest.testKatHex(new Shabal512(), "c9534a24714bd4be37c88a3da1082eda7cabd154c309d7bd670dccd95aa535594463058a29f79031d6ecaa9f675d1211e9359be82669a79c855ea8d89dd38c2c761ddd0ec0ce9e97597432e9a1beae062cdd71edfdfd464119be9e69d18a7a7fd7ce0e2106f0c8b0abf4715e2ca48ef9f454dc203c96656653b727083513f8efb86e49c513bb758b3b052fe21f1c05bb33c37129d6cc81f1aef6adc45b0e8827a830fe545cf57d0955802c117d23ccb55ea28f95c0d8c2f9c5a242b33f", "fcb5df3edb2735c53a89cdef8962ec7209963ed0f5e5f6e8b039b53788022bcaddfa9b58231719fe29fd3b9819a585c08e757fdbb277781733fc2587f43ce6df");
        TestDigest.testKatHex(new Shabal512(), "07906c87297b867abf4576e9f3cc7f82f22b154afcbf293b9319f1b0584da6a40c27b32e0b1b7f412c4f1b82480e70a9235b12ec27090a5a33175a2bb28d8adc475cefe33f7803f8ce27967217381f02e67a3b4f84a71f1c5228e0c2ad971373f6f672624fcea8d1a9f85170fad30fa0bbd25035c3b41a6175d467998bd1215f6f3866f53847f9cf68ef3e2fbb54bc994de2302b829c5eea68ec441fcbafd7d16ae4fe9fff98bf00e5bc2ad54dd91ff9fda4dd77b6c754a91955d1fbaad0", "46ea549c671716d93343bae2516b728eb424d3406faeb528cfaf80fa3f99dce922e462130b9e13d68502d4119ff8f5aab9dca4ff2fbf758ef940b58f5a70c39c");
        TestDigest.testKatHex(new Shabal512(), "588e94b9054abc2189df69b8ba34341b77cdd528e7860e5defcaa79b0c9a452ad4b82aa306be84536eb7cedcbe058d7b84a6aef826b028b8a0271b69ac3605a9635ea9f5ea0aa700f3eb7835bc54611b922964300c953efe7491e3677c2cebe0822e956cd16433b02c68c4a23252c3f9e151a416b4963257b783e038f6b4d5c9f110f871652c7a649a7bcedcbccc6f2d0725bb903cc196ba76c76aa9f10a190b1d1168993baa9ffc96a1655216773458bec72b0e39c9f2c121378feab4e76a", "b2e143621c151edc374133deea0fd255f6c1ca78f859e7adc2861593d33dd90dd6d9894637dc28e57091640c7f1d7112ea847d5b95f125969d5c312e6dcc1a62");
        TestDigest.testKatHex(new Shabal512(), "08959a7e4baae874928813364071194e2939772f20db7c3157078987c557c2a6d5abe68d520eef3dc491692e1e21bcd880adebf63bb4213b50897fa005256ed41b5690f78f52855c8d9168a4b666fce2da2b456d7a7e7c17ab5f2fb1ee90b79e698712e963715983fd07641ae4b4e9dc73203fac1ae11fa1f8c7941fcc82eab247addb56e2638447e9d609e610b60ce086656aaebf1da3c8a231d7d94e2fd0afe46b391ff14a72eaeb3f44ad4df85866def43d4781a0b3578bc996c87970b132", "5423f6db2e59bb9eb3aea362568905f6e0c0f11e3dfdde4e0e8f35df61b61b991edf229390f623a579262373e9561e994fc5dc2ba3e2e8f192fc9e9d62028d79");
        TestDigest.testKatHex(new Shabal512(), "cb2a234f45e2ecd5863895a451d389a369aab99cfef0d5c9ffca1e6e63f763b5c14fb9b478313c8e8c0efeb3ac9500cf5fd93791b789e67eac12fd038e2547cc8e0fc9db591f33a1e4907c64a922dda23ec9827310b306098554a4a78f050262db5b545b159e1ff1dca6eb734b872343b842c57eafcfda8405eedbb48ef32e99696d135979235c3a05364e371c2d76f1902f1d83146df9495c0a6c57d7bf9ee77e80f9787aee27be1fe126cdc9ef893a4a7dcbbc367e40fe4e1ee90b42ea25af01", "686d6e171d7efa461c7e1b447939409e6f6dd78c6ecb5aaa73e448db49e53acc12f6ee36e33a1c2aecb0bcdcf7a55e7d36b6038485e0c23788bad9677e27abad");
        TestDigest.testKatHex(new Shabal512(), "d16beadf02ab1d4dc6f88b8c4554c51e866df830b89c06e786a5f8757e8909310af51c840efe8d20b35331f4355d80f73295974653ddd620cdde4730fb6c8d0d2dcb2b45d92d4fbdb567c0a3e86bd1a8a795af26fbf29fc6c65941cddb090ff7cd230ac5268ab4606fccba9eded0a2b5d014ee0c34f0b2881ac036e24e151be89eeb6cd9a7a790afccff234d7cb11b99ebf58cd0c589f20bdac4f9f0e28f75e3e04e5b3debce607a496d848d67fa7b49132c71b878fd5557e082a18eca1fbda94d4b", "783cf2fac90d087bedbc0482225b9710b1d520894b5d5cc74202e76b4aa518f4f7d14f86403f25ce3b1475b33b1ccd4dce0ced375dead58636bec4df40372fc9");
        TestDigest.testKatHex(new Shabal512(), "8f65f6bc59a85705016e2bae7fe57980de3127e5ab275f573d334f73f8603106ec3553016608ef2dd6e69b24be0b7113bf6a760ba6e9ce1c48f9e186012cf96a1d4849d75df5bb8315387fd78e9e153e76f8ba7ec6c8849810f59fb4bb9b004318210b37f1299526866f44059e017e22e96cbe418699d014c6ea01c9f0038b10299884dbec3199bb05adc94e955a1533219c1115fed0e5f21228b071f40dd57c4240d98d37b73e412fe0fa4703120d7c0c67972ed233e5deb300a22605472fa3a3ba86", "dbf0ebb8dbed29874ed1cf7aa53aed99bbb470d71438b36c7548e215fcf25eef204401e7f7239badd3b40287b5a641773c808c50f7074a5218746673212d8e6f");
        TestDigest.testKatHex(new Shabal512(), "84891e52e0d451813210c3fd635b39a03a6b7a7317b221a7abc270dfa946c42669aacbbbdf801e1584f330e28c729847ea14152bd637b3d0f2b38b4bd5bf9c791c58806281103a3eabbaede5e711e539e6a8b2cf297cf351c078b4fa8f7f35cf61bebf8814bf248a01d41e86c5715ea40c63f7375379a7eb1d78f27622fb468ab784aaaba4e534a6dfd1df6fa15511341e725ed2e87f98737ccb7b6a6dfae416477472b046bf1811187d151bfa9f7b2bf9acdb23a3be507cdf14cfdf517d2cb5fb9e4ab6", "de8fc38b758de6bb05bf846df99109bbb87a0c9b6b236501ee551227b0189fea96fd82006db61d241c15bec37fcfaa15362f53280d49d6281219f40c4d8778ad");
        TestDigest.testKatHex(new Shabal512(), "fdd7a9433a3b4afabd7a3a5e3457e56debf78e84b7a0b0ca0e8c6d53bd0c2dae31b2700c6128334f43981be3b213b1d7a118d59c7e6b6493a86f866a1635c12859cfb9ad17460a77b4522a5c1883c3d6acc86e6162667ec414e9a104aa892053a2b1d72165a855bacd8faf8034a5dd9b716f47a0818c09bb6baf22aa503c06b4ca261f557761989d2afbd88b6a678ad128af68672107d0f1fc73c5ca740459297b3292b281e93bceb761bde7221c3a55708e5ec84472cddcaa84ecf23723cc0991355c6280", "dccd451f3836f3a429bf4a1cd2458cc99773eb8f544ff567247625b6c5ddc7f5bdc0210098449652a4f03e8bc89b13a733e0560f969dc5292dbdabac8e67966a");
        TestDigest.testKatHex(new Shabal512(), "70a40bfbef92277a1aad72f6b79d0177197c4ebd432668cfec05d099accb651062b5dff156c0b27336687a94b26679cfdd9daf7ad204338dd9c4d14114033a5c225bd11f217b5f4732da167ee3f939262d4043fc9cba92303b7b5e96aea12adda64859df4b86e9ee0b58e39091e6b188b408ac94e1294a8911245ee361e60e601eff58d1d37639f3753bec80ebb4efde25817436076623fc65415fe51d1b0280366d12c554d86743f3c3b6572e400361a60726131441ba493a83fbe9afda90f7af1ae717238d", "a52f7fd8d2655057a024de36a016aa1f38b813058a46b79dbfca3114eb2491c86852792d84906ef8f909a717d4967f02bf8b741ef6e15743298ddbb4ed6d5888");
        TestDigest.testKatHex(new Shabal512(), "74356e449f4bf8644f77b14f4d67cb6bd9c1f5ae357621d5b8147e562b65c66585caf2e491b48529a01a34d226d436959153815380d5689e30b35357cdac6e08d3f2b0e88e200600d62bd9f5eaf488df86a4470ea227006182e44809009868c4c280c43d7d64a5268fa719074960087b3a6abc837882f882c837834535929389a12b2c78187e2ea07ef8b8eef27dc85002c3ae35f1a50bee6a1c48ba7e175f3316670b27983472aa6a61eed0a683a39ee323080620ea44a9f74411ae5ce99030528f9ab49c79f2", "a0274bcc35291f13f4dc097d2194011a36b25386331914ef7a2e2180d608663f80e852ca49aade7c338510bbdc96b1cd358e428f1a868b34f62b6214586713f6");
        TestDigest.testKatHex(new Shabal512(), "8c3798e51bc68482d7337d3abb75dc9ffe860714a9ad73551e120059860dde24ab87327222b64cf774415a70f724cdf270de3fe47dda07b61c9ef2a3551f45a5584860248fabde676e1cd75f6355aa3eaeabe3b51dc813d9fb2eaa4f0f1d9f834d7cad9c7c695ae84b329385bc0bef895b9f1edf44a03d4b410cc23a79a6b62e4f346a5e8dd851c2857995ddbf5b2d717aeb847310e1f6a46ac3d26a7f9b44985af656d2b7c9406e8a9e8f47dcb4ef6b83caacf9aefb6118bfcff7e44bef6937ebddc89186839b77", "9cfdc80bf5967f22d262ea0a85bc95cbe75782013cb51778d59e8c596de9034f809fd3dc8cc6d4ffffca9f316bc4c0e5fc25c6802d67487e9c41ecadd6f284f4");
        TestDigest.testKatHex(new Shabal512(), "fa56bf730c4f8395875189c10c4fb251605757a8fecc31f9737e3c2503b02608e6731e85d7a38393c67de516b85304824bfb135e33bf22b3a23b913bf6acd2b7ab85198b8187b2bcd454d5e3318cacb32fd6261c31ae7f6c54ef6a7a2a4c9f3ecb81ce3555d4f0ad466dd4c108a90399d70041997c3b25345a9653f3c9a6711ab1b91d6a9d2216442da2c973cbd685ee7643bfd77327a2f7ae9cb283620a08716dfb462e5c1d65432ca9d56a90e811443cd1ecb8f0de179c9cb48ba4f6fec360c66f252f6e64edc96b", "bd97944cd66b9ccecc5377efbafbbaf073cd06964f8e51085120f50a408e8869c3b5dd1dbffafc49d576568628d142c7c5b7b4bcddbab44751b7823d416e4b7c");
        TestDigest.testKatHex(new Shabal512(), "b6134f9c3e91dd8000740d009dd806240811d51ab1546a974bcb18d344642baa5cd5903af84d58ec5ba17301d5ec0f10ccd0509cbb3fd3fff9172d193af0f782252fd1338c7244d40e0e42362275b22d01c4c3389f19dd69bdf958ebe28e31a4ffe2b5f18a87831cfb7095f58a87c9fa21db72ba269379b2dc2384b3da953c7925761fed324620acea435e52b424a7723f6a2357374157a34cd8252351c25a1b232826cefe1bd3e70ffc15a31e7c0598219d7f00436294d11891b82497bc78aa5363892a2495df8c1eef", "94812bc68f241d28654c6f2c5cc0709d9d9efef97666d38fdeb948b634734060e9062ff1125922482dd952caf7adc120f66d3103551fff030be67a3a7575e9d6");
        TestDigest.testKatHex(new Shabal512(), "c941cdb9c28ab0a791f2e5c8e8bb52850626aa89205bec3a7e22682313d198b1fa33fc7295381354858758ae6c8ec6fac3245c6e454d16fa2f51c4166fab51df272858f2d603770c40987f64442d487af49cd5c3991ce858ea2a60dab6a65a34414965933973ac2457089e359160b7cdedc42f29e10a91921785f6b7224ee0b349393cdcff6151b50b377d609559923d0984cda6000829b916ab6896693ef6a2199b3c22f7dc5500a15b8258420e314c222bc000bc4e5413e6dd82c993f8330f5c6d1be4bc79f08a1a0a46", "0dde349b82ca9476de6e8cf833d98ea467a26c037c72f93ad5e4a2c7e10e4f70e1eaeffdfafc06d7c302a5679c7cca0ff0f919bf06bfe9e50ba58e8d69529a45");
        TestDigest.testKatHex(new Shabal512(), "4499efffac4bcea52747efd1e4f20b73e48758be915c88a1ffe5299b0b005837a46b2f20a9cb3c6e64a9e3c564a27c0f1c6ad1960373036ec5bfe1a8fc6a435c2185ed0f114c50e8b3e4c7ed96b06a036819c9463e864a58d6286f785e32a804443a56af0b4df6abc57ed5c2b185ddee8489ea080deeee66aa33c2e6dab36251c402682b6824821f998c32163164298e1fafd31babbcffb594c91888c6219079d907fdb438ed89529d6d96212fd55abe20399dbefd342248507436931cdead496eb6e4a80358acc78647d043", "e64a05fa539110defa9cdf5271ca18f470bd1cf30b263e6e0d5be4ca90570d8e38a7a43b77455914708a967eb7c9bf2da87980eb2d140b113556705032079a22");
        TestDigest.testKatHex(new Shabal512(), "eecbb8fdfa4da62170fd06727f697d81f83f601ff61e478105d3cb7502f2c89bf3e8f56edd469d049807a38882a7eefbc85fc9a950952e9fa84b8afebd3ce782d4da598002827b1eb98882ea1f0a8f7aa9ce013a6e9bc462fb66c8d4a18da21401e1b93356eb12f3725b6db1684f2300a98b9a119e5d27ff704affb618e12708e77e6e5f34139a5a41131fd1d6336c272a8fc37080f041c71341bee6ab550cb4a20a6ddb6a8e0299f2b14bc730c54b8b1c1c487b494bdccfd3a53535ab2f231590bf2c4062fd2ad58f906a2d0d", "9197dff8d38886018fd1918a01d5a868c6caa2bf7c0d132f710785cd669c01cdc2f28576b42a401410b97fb78c4a73bc6eb8992e21013347b481e26ef380acf2");
        TestDigest.testKatHex(new Shabal512(), "e64f3e4ace5c8418d65fec2bc5d2a303dd458034736e3b0df719098be7a206deaf52d6ba82316caf330ef852375188cde2b39cc94aa449578a7e2a8e3f5a9d68e816b8d16889fbc0ebf0939d04f63033ae9ae2bdab73b88c26d6bd25ee460ee1ef58fb0afa92cc539f8c76d3d097e7a6a63ebb9b5887edf3cf076028c5bbd5b9db3211371ad3fe121d4e9bf44229f4e1ecf5a0f9f0eba4d5ceb72878ab22c3f0eb5a625323ac66f7061f4a81fac834471e0c59553f108475fe290d43e6a055ae3ee46fb67422f814a68c4be3e8c9", "300f89e7e657a3f62ec417fa7f690eaa8d27600871ef95a7bd3a5e0910701f545bee31bff68652cadd6e30c0131d053e22fb5b4e8867e446999680658bbd2d29");
        TestDigest.testKatHex(new Shabal512(), "d2cb2d733033f9e91395312808383cc4f0ca974e87ec68400d52e96b3fa6984ac58d9ad0938dde5a973008d818c49607d9de2284e7618f1b8aed8372fbd52ed54557af4220fac09dfa8443011699b97d743f8f2b1aef3537ebb45dcc9e13dfb438428ee190a4efdb3caeb7f3933117bf63abdc7e57beb4171c7e1ad260ab0587806c4d137b6316b50abc9cce0dff3acada47bbb86be777e617bbe578ff4519844db360e0a96c6701290e76bb95d26f0f804c8a4f2717eac4e7de9f2cff3bbc55a17e776c0d02856032a6cd10ad2838", "82b7f58794f09160642ba6ae896aa70d36a86c17899b933b0227264cb875c5ce28642b58e6096880ae26664696f07eb3bbd9467415b479fe745e0efee8c2b2e1");
        TestDigest.testKatHex(new Shabal512(), "f2998955613dd414cc111df5ce30a995bb792e260b0e37a5b1d942fe90171a4ac2f66d4928d7ad377f4d0554cbf4c523d21f6e5f379d6f4b028cdcb9b1758d3b39663242ff3cb6ede6a36a6f05db3bc41e0d861b384b6dec58bb096d0a422fd542df175e1be1571fb52ae66f2d86a2f6824a8cfaacbac4a7492ad0433eeb15454af8f312b3b2a577750e3efbd370e8a8cac1582581971fba3ba4bd0d76e718dacf8433d33a59d287f8cc92234e7a271041b526e389efb0e40b6a18b3aaf658e82ed1c78631fd23b4c3eb27c3faec8685", "89e4060d284b01d8476c6ae56b92f7ac1797893aadf7048276e80189667bc7278d8a4477f0d4290400e96626d1d3cc27a656bf1fac0dd7f5cd0a631ee1abc6c5");
        TestDigest.testKatHex(new Shabal512(), "447797e2899b72a356ba55bf4df3acca6cdb1041eb477bd1834a9f9acbc340a294d729f2f97df3a610be0ff15edb9c6d5db41644b9874360140fc64f52aa03f0286c8a640670067a84e017926a70438db1bb361defee7317021425f8821def26d1efd77fc853b818545d055adc9284796e583c76e6fe74c9ac2587aa46aa8f8804f2feb5836cc4b3ababab8429a5783e17d5999f32242eb59ef30cd7adabc16d72dbdb097623047c98989f88d14eaf02a7212be16ec2d07981aaa99949ddf89ecd90333a77bc4e1988a82abf7c7caf3291", "6953ab5cde1de836488fa5f1b895a3cc480a89d0dd15c4d039ebb0499575b0f648cc4c60667d65ec0779d03e504a616da1d65598d85348e409422885e126be8f");
        TestDigest.testKatHex(new Shabal512(), "9f2c18ade9b380c784e170fb763e9aa205f64303067eb1bcea93df5dac4bf5a2e00b78195f808df24fc76e26cb7be31dc35f0844cded1567bba29858cffc97fb29010331b01d6a3fb3159cc1b973d255da9843e34a0a4061cabdb9ed37f241bfabb3c20d32743f4026b59a4ccc385a2301f83c0b0a190b0f2d01acb8f0d41111e10f2f4e149379275599a52dc089b35fdd5234b0cfb7b6d8aebd563ca1fa653c5c021dfd6f5920e6f18bfafdbecbf0ab00281333ed50b9a999549c1c8f8c63d7626c48322e9791d5ff72294049bde91e73f8", "c20e6ab46f4973aca675179764d51857be6686c77ecdc82d822398e36f541718969c324e6a8e90bf88f6f9328e8e4560fd232ceedb11b021605b066399d1d643");
        TestDigest.testKatHex(new Shabal512(), "ae159f3fa33619002ae6bcce8cbbdd7d28e5ed9d61534595c4c9f43c402a9bb31f3b301cbfd4a43ce4c24cd5c9849cc6259eca90e2a79e01ffbac07ba0e147fa42676a1d668570e0396387b5bcd599e8e66aaed1b8a191c5a47547f61373021fa6deadcb55363d233c24440f2c73dbb519f7c9fa5a8962efd5f6252c0407f190dfefad707f3c7007d69ff36b8489a5b6b7c557e79dd4f50c06511f599f56c896b35c917b63ba35c6ff8092baf7d1658e77fc95d8a6a43eeb4c01f33f03877f92774be89c1114dd531c011e53a34dc248a2f0e6", "23794b83278cbca6448a9a5f199d2694d65d10864c3e2e87ba155e6da4f06c59c210b414e5892110da57e0728c56142b1b338c7cbeeae21ad3a93de87e9c52cb");
        TestDigest.testKatHex(new Shabal512(), "3b8e97c5ffc2d6a40fa7de7fcefc90f3b12c940e7ab415321e29ee692dfac799b009c99dcddb708fce5a178c5c35ee2b8617143edc4c40b4d313661f49abdd93cea79d117518805496fe6acf292c4c2a1f76b403a97d7c399daf85b46ad84e16246c67d6836757bde336c290d5d401e6c1386ab32797af6bb251e9b2d8fe754c47482b72e0b394eab76916126fd68ea7d65eb93d59f5b4c5ac40f7c3b37e7f3694f29424c24af8c8f0ef59cd9dbf1d28e0e10f799a6f78cad1d45b9db3d7dee4a7059abe99182714983b9c9d44d7f5643596d4f3", "574988c8d2faec5693ec7dc2502f146ec8e0608e011168cc8dbdd69695452f0e26bf0512823e9f0ff91f86436961df66aa5dec486b1ee8285826ca17a15ed0c7");
        TestDigest.testKatHex(new Shabal512(), "3434ec31b10fafdbfeec0dd6bd94e80f7ba9dca19ef075f7eb017512af66d6a4bcf7d16ba0819a1892a6372f9b35bcc7ca8155ee19e8428bc22d214856ed5fa9374c3c09bde169602cc219679f65a1566fc7316f4cc3b631a18fb4449fa6afa16a3db2bc4212eff539c67cf184680826535589c7111d73bffce431b4c40492e763d9279560aaa38eb2dc14a212d723f994a1fe656ff4dd14551ce4e7c621b2aa5604a10001b2878a897a28a08095c325e10a26d2fb1a75bfd64c250309bb55a44f23bbac0d5516a1c687d3b41ef2fbbf9cc56d4739", "a54c8c81f20624e9f8d27daee8c7cbca377bc5b4f38e236387c905a28835beadbff1f6a145d8e0f4918e916c47fdd6805913561ebf3302ccc765d5994d3948c8");
        TestDigest.testKatHex(new Shabal512(), "7c7953d81c8d208fd1c97681d48f49dd003456de60475b84070ef4847c333b74575b1fc8d2a186964485a3b8634feaa3595aaa1a2f4595a7d6b6153563dee31bbac443c8a33eed6d5d956a980a68366c2527b550ee950250dfb691eacbd5d56ae14b970668be174c89df2fea43ae52f13142639c884fd62a3683c0c3792f0f24ab1318bcb27e21f4737fab62c77ea38bc8fd1cf41f7dab64c13febe7152bf5bb7ab5a78f5346d43cc741cb6f72b7b8980f268b68bf62abdfb1577a52438fe14b591498cc95f071228460c7c5d5ceb4a7bde588e7f21c", "1d2759710c6ed59a59751516263fa445832f48db9b16fbbaf651868ba39e26dee880751850c0b0f32c0480f2cf5723d32467ba156af45091d1a1a489a5a649e5");
        TestDigest.testKatHex(new Shabal512(), "7a6a4f4fdc59a1d223381ae5af498d74b7252ecf59e389e49130c7eaee626e7bd9897effd92017f4ccde66b0440462cdedfd352d8153e6a4c8d7a0812f701cc737b5178c2556f07111200eb627dbc299caa792dfa58f35935299fa3a3519e9b03166dffa159103ffa35e8577f7c0a86c6b46fe13db8e2cdd9dcfba85bdddcce0a7a8e155f81f712d8e9fe646153d3d22c811bd39f830433b2213dd46301941b59293fd0a33e2b63adbd95239bc01315c46fdb678875b3c81e053a40f581cfbec24a1404b1671a1b88a6d06120229518fb13a74ca0ac5ae", "2794c876d1605d1cd51d60804858710013c30ac4f689d26b4311cfe7c7786a5093da302d77b27056cc4bd2cfed7494fa2ca3a0c1509ac47e5d19449490e9cb93");
        TestDigest.testKatHex(new Shabal512(), "d9faa14cebe9b7de551b6c0765409a33938562013b5e8e0e1e0a6418df7399d0a6a771fb81c3ca9bd3bb8e2951b0bc792525a294ebd1083688806fe5e7f1e17fd4e3a41d00c89e8fcf4a363caedb1acb558e3d562f1302b3d83bb886ed27b76033798131dab05b4217381eaaa7ba15ec820bb5c13b516dd640eaec5a27d05fdfca0f35b3a5312146806b4c0275bcd0aaa3b2017f346975db566f9b4d137f4ee10644c2a2da66deeca5342e236495c3c6280528bfd32e90af4cd9bb908f34012b52b4bc56d48cc8a6b59bab014988eabd12e1a0a1c2e170e7", "7e95b9799bb0ce4f92cdaba3b0e76936f40f4f47ab96325c876a02a521574274a12331f6a083bfed4ad194a8d434447fbb2e32791d1e3a5cf20a6ed2eed867ef");
        TestDigest.testKatHex(new Shabal512(), "2d8427433d0c61f2d96cfe80cf1e932265a191365c3b61aaa3d6dcc039f6ba2ad52a6a8cc30fc10f705e6b7705105977fa496c1c708a277a124304f1fc40911e7441d1b5e77b951aad7b01fd5db1b377d165b05bbf898042e39660caf8b279fe5229d1a8db86c0999ed65e53d01ccbc4b43173ccf992b3a14586f6ba42f5fe30afa8ae40c5df29966f9346da5f8b35f16a1de3ab6de0f477d8d8660918060e88b9b9e9ca6a4207033b87a812dbf5544d39e4882010f82b6ce005f8e8ff6fe3c3806bc2b73c2b83afb704345629304f9f86358712e9fae3ca3e", "79490e2c6563ec74b713e0d0420f57b52e04168a152741d742d10e81b40b8a0b5097a5c886fdd314bbdf7f591ac62caad32ca64e1a755c1ebab602c53f59c18c");
        TestDigest.testKatHex(new Shabal512(), "5e19d97887fcaac0387e22c6f803c34a3dacd2604172433f7a8a7a526ca4a2a1271ecfc5d5d7be5ac0d85d921095350dfc65997d443c21c8094e0a3fefd2961bcb94aed03291ae310ccda75d8ace4bc7d89e7d3e5d1650bda5d668b8b50bfc8e608e184f4d3a9a2badc4ff5f07e0c0bc8a9f2e0b2a26fd6d8c550008faaab75fd71af2a424bec9a7cd9d83fad4c8e9319115656a8717d3b523a68ff8004258b9990ed362308461804ba3e3a7e92d8f2ffae5c2fba55ba5a3c27c0a2f71bd711d2fe1799c2adb31b200035481e9ee5c4adf2ab9c0fa50b23975cf", "4dee46027ea3d18564e62a7412ffe2a90ba8f33a276af4b069411ba76ddc2507fa37f0b02a2491061544131464871528d6231c8e766ce2f2ba73e4f70163dddc");
        TestDigest.testKatHex(new Shabal512(), "c8e976ab4638909387ce3b8d4e510c3230e5690e02c45093b1d297910abc481e56eea0f296f98379dfc9080af69e73b2399d1c143bee80ae1328162ce1ba7f6a8374679b20aacd380eb4e61382c99998704d62701afa914f9a2705cdb065885f50d086c3eb5753700c387118bb142f3e6da1e988dfb31ac75d7368931e45d1391a274b22f83ceb072f9bcabc0b216685bfd789f5023971024b1878a205442522f9ea7d8797a4102a3df41703768251fd5e017c85d1200a464118aa35654e7ca39f3c375b8ef8cbe7534dbc64bc20befb417cf60ec92f63d9ee7397", "df7651658c9a987c4533944bf319b56062a01f6aec2a657b515fa2f8e484a1f361e7fc78a40de991641b4fc93b4128294f1329e872600e96cbb641e50e55f4c8");
        TestDigest.testKatHex(new Shabal512(), "7145fa124b7429a1fc2231237a949ba7201bcc1822d3272de005b682398196c25f7e5cc2f289fbf44415f699cb7fe6757791b1443410234ae061edf623359e2b4e32c19bf88450432dd01caa5eb16a1dc378f391ca5e3c4e5f356728bddd4975db7c890da8bbc84cc73ff244394d0d48954978765e4a00b593f70f2ca082673a261ed88dbcef1127728d8cd89bc2c597e9102ced6010f65fa75a14ebe467fa57ce3bd4948b6867d74a9df5c0ec6f530cbf2ee61ce6f06bc8f2864dff5583776b31df8c7ffcb61428a56bf7bd37188b4a5123bbf338393af46eda85e6", "69f2b9f5475f39a45a679a0915623cdd56c49265350ab7c5976d0582ee2e1e267b7e698aab9ee2452700a087e411371727225c5461294b96283a7c508cb26a1a");
        TestDigest.testKatHex(new Shabal512(), "7fdfadcc9d29bad23ae038c6c65cda1aef757221b8872ed3d75ff8df7da0627d266e224e812c39f7983e4558bfd0a1f2bef3feb56ba09120ef762917b9c093867948547aee98600d10d87b20106878a8d22c64378bf634f7f75900c03986b077b0bf8b740a82447b61b99fee5376c5eb6680ec9e3088f0bdd0c56883413d60c1357d3c811950e5890e7600103c916341b80c743c6a852b7b4fb60c3ba21f3bc15b8382437a68454779cf3cd7f9f90ccc8ef28d0b706535b1e4108eb5627bb45d719cb046839aee311ca1abdc8319e050d67972cb35a6b1601b25dbf487", "b7f62a960fd22e9bb864dec42588658d9a0ed7a076ee1255f201d33d9231424522a378235b8c2b452d21b493796e8ac367884356aa693127bc144f3109fbf681");
        TestDigest.testKatHex(new Shabal512(), "988638219fd3095421f826f56e4f09e356296b628c3ce6930c9f2e758fd1a80c8273f2f61e4daae65c4f110d3e7ca0965ac7d24e34c0dc4ba2d6ff0bf5bbe93b3585f354d7543cb542a1aa54674d375077f2d360a8f4d42f3db131c3b7ab7306267ba107659864a90c8c909460a73621d1f5d9d3fd95beb19b23db1cb6c0d0fba91d36891529b8bd8263caa1bab56a4affaed44962df096d8d5b1eb845ef31188b3e10f1af811a13f156beb7a288aae593ebd1471b624aa1a7c6adf01e2200b3d72d88a3aed3100c88231e41efc376906f0b580dc895f080fda5741db1cb", "4e4a219cc3f92b2499542000ca39013bd91dfe2bd862357e2829936eafc9cf9ea1b90cddb61e20f428adc1ecedf367630b8b4f84a3ff313bd6fb1fb3bde69183");
        TestDigest.testKatHex(new Shabal512(), "5aab62756d307a669d146aba988d9074c5a159b3de85151a819b117ca1ff6597f6156e80fdd28c9c3176835164d37da7da11d94e09add770b68a6e081cd22ca0c004bfe7cd283bf43a588da91f509b27a6584c474a4a2f3ee0f1f56447379240a5ab1fb77fdca49b305f07ba86b62756fb9efb4fc225c86845f026ea542076b91a0bc2cdd136e122c659be259d98e5841df4c2f60330d4d8cdee7bf1a0a244524eecc68ff2aef5bf0069c9e87a11c6e519de1a4062a10c83837388f7ef58598a3846f49d499682b683c4a062b421594fafbc1383c943ba83bdef515efcf10d", "8075b23ee2a691eaeff619f17695b2b77f7b418c5d64ef84f501cffd0bd5343bc9552514ba2606a5918a4608af20ef7ab489da293b0d7b55ad5683432f63d4c5");
        TestDigest.testKatHex(new Shabal512(), "47b8216aa0fbb5d67966f2e82c17c07aa2d6327e96fcd83e3de7333689f3ee79994a1bf45082c4d725ed8d41205cb5bcdf5c341f77facb1da46a5b9b2cbc49eadf786bcd881f371a95fa17df73f606519aea0ff79d5a11427b98ee7f13a5c00637e2854134691059839121fea9abe2cd1bcbbbf27c74caf3678e05bfb1c949897ea01f56ffa4dafbe8644611685c617a3206c7a7036e4ac816799f693dafe7f19f303ce4eba09d21e03610201bfc665b72400a547a1e00fa9b7ad8d84f84b34aef118515e74def11b9188bd1e1f97d9a12c30132ec2806339bdadacda2fd8b78", "3421a2b96c3e939e720298dbcb365694f165bed3950c029134f6f03eb000f47dbb34d24f12e9ab30ae1f00448febbdfd14a7f36aa4bc9bd550cc1e0c089abf27");
        TestDigest.testKatHex(new Shabal512(), "8cff1f67fe53c098896d9136389bd8881816ccab34862bb67a656e3d98896f3ce6ffd4da73975809fcdf9666760d6e561c55238b205d8049c1cedeef374d1735daa533147bfa960b2cce4a4f254176bb4d1bd1e89654432b8dbe1a135c42115b394b024856a2a83dc85d6782be4b444239567ccec4b184d4548eae3ff6a192f343292ba2e32a0f267f31cc26719eb85245d415fb897ac2da433ee91a99424c9d7f1766a44171d1651001c38fc79294accc68ceb5665d36218454d3ba169ae058a831338c17743603f81ee173bfc0927464f9bd728dee94c6aeab7aae6ee3a627e8", "b77e7caa7bb2fd7f52ab9d74f7b7a69ced574c622ba1c7ad4c9538363ee30101cd944247e0bb3af77f3b6d8e638b3dbc97e245b58547b6bbd25f25db7595300d");
        TestDigest.testKatHex(new Shabal512(), "eacd07971cff9b9939903f8c1d8cbb5d4db1b548a85d04e037514a583604e787f32992bf2111b97ac5e8a938233552731321522ab5e8583561260b7d13ebeef785b23a41fd8576a6da764a8ed6d822d4957a545d5244756c18aa80e1aad4d1f9c20d259dee1711e2cc8fd013169fb7cc4ce38b362f8e0936ae9198b7e838dcea4f7a5b9429bb3f6bbcf2dc92565e3676c1c5e6eb3dd2a0f86aa23edd3d0891f197447692794b3dfa269611ad97f72b795602b4fdb198f3fd3eb41b415064256e345e8d8c51c555dc8a21904a9b0f1ad0effab7786aac2da3b196507e9f33ca356427", "087b6f925af2486aa1b4ef1ea3623d3dd96dd46fac0dec81621bc3844b8fe4785e23938a0d8bfbfdfe7eef03759cd656d43911d117267fd675c4a3dde5f5db35");
        TestDigest.testKatHex(new Shabal512(), "23ac4e9a42c6ef45c3336ce6dfc2ff7de8884cd23dc912fef0f7756c09d335c189f3ad3a23697abda851a81881a0c8ccafc980ab2c702564c2be15fe4c4b9f10dfb2248d0d0cb2e2887fd4598a1d4acda897944a2ffc580ff92719c95cf2aa42dc584674cb5a9bc5765b9d6ddf5789791d15f8dd925aa12bffafbce60827b490bb7df3dda6f2a143c8bf96abc903d83d59a791e2d62814a89b8080a28060568cf24a80ae61179fe84e0ffad00388178cb6a617d37efd54cc01970a4a41d1a8d3ddce46edbba4ab7c90ad565398d376f431189ce8c1c33e132feae6a8cd17a61c630012", "539ad068ed10e83d29becb105b9d2c2d42ddfb0ab7f29e62a9ee2a0d27b7212a761e2d5b542c8dad92b2c4b5e4564624597fbe980505f0bf5ea2e91dc1e57e6f");
        TestDigest.testKatHex(new Shabal512(), "0172df732282c9d488669c358e3492260cbe91c95cfbc1e3fea6c4b0ec129b45f242ace09f152fc6234e1bee8aab8cd56e8b486e1dcba9c05407c2f95da8d8f1c0af78ee2ed82a3a79ec0cb0709396ee62aadb84f8a4ee8a7ccca3c1ee84e302a09ea802204afecf04097e67d0f8e8a9d2651126c0a598a37081e42d168b0ae8a71951c524259e4e2054e535b779679bdade566fe55700858618e626b4a0faf895bcce9011504a49e05fd56127eae3d1f8917afb548ecadabda1020111fec9314c413498a360b08640549a22cb23c731ace743252a8227a0d2689d4c6001606678dfb921", "20b070a59ebfdc2c9355521eda0db608738e18d19f52d8abd2a03dca964e4419e07a24eac94f93d738d5f21549d4957c70caa6b39fec851800e717358166a5ed");
        TestDigest.testKatHex(new Shabal512(), "3875b9240cf3e0a8b59c658540f26a701cf188496e2c2174788b126fd29402d6a75453ba0635284d08835f40051a2a9683dc92afb9383719191231170379ba6f4adc816fecbb0f9c446b785bf520796841e58878b73c58d3ebb097ce4761fdeabe15de2f319dfbaf1742cdeb389559c788131a6793e193856661376c81ce9568da19aa6925b47ffd77a43c7a0e758c37d69254909ff0fbd415ef8eb937bcd49f91468b49974c07dc819abd67395db0e05874ff83dddab895344abd0e7111b2df9e58d76d85ad98106b36295826be04d435615595605e4b4bb824b33c4afeb5e7bb0d19f909", "b4b8ab3accba799be95d4f4095126d34daccfb694a94bf2de91c2069ef81c31c2f3703dc7eabb8c59674571d5c2d59620a1c100b05c876170d6152d364a24671");
        TestDigest.testKatHex(new Shabal512(), "747cc1a59fefba94a9c75ba866c30dc5c1cb0c0f8e9361d98484956dd5d1a40f6184afbe3dac9f76028d1caeccfbf69199c6ce2b4c092a3f4d2a56fe5a33a00757f4d7dee5dfb0524311a97ae0668a47971b95766e2f6dd48c3f57841f91f04a00ad5ea70f2d479a2620dc5cd78eaab3a3b011719b7e78d19ddf70d9423798af77517ebc55392fcd01fc600d8d466b9e7a7a85bf33f9cc5419e9bd874ddfd60981150ddaf8d7febaa4374f0872a5628d318000311e2f5655365ad4d407c20e5c04df17a222e7deec79c5ab1116d8572f91cd06e1ccc7ced53736fc867fd49ecebe6bf8082e8a", "34f0c574dc7044407d11d27cae24a492e5fcc4361bd9111c61a45d6e00f7b2d8c4c26fc9eeaf94440d681c2afcb5ed6fd918c1e83922e74830b8e2f4a12831fa");
        TestDigest.testKatHex(new Shabal512(), "57af971fccaec97435dc2ec9ef0429bcedc6b647729ea168858a6e49ac1071e706f4a5a645ca14e8c7746d65511620682c906c8b86ec901f3dded4167b3f00b06cbfac6aee3728051b3e5ff10b4f9ed8bd0b8da94303c833755b3ca3aeddf0b54bc8d6632138b5d25bab03d17b3458a9d782108006f5bb7de75b5c0ba854b423d8bb801e701e99dc4feaad59bc1c7112453b04d33ea3635639fb802c73c2b71d58a56bbd671b18fe34ed2e3dca38827d63fdb1d4fb3285405004b2b3e26081a8ff08cd6d2b08f8e7b7e90a2ab1ed7a41b1d0128522c2f8bff56a7fe67969422ce839a9d4608f03", "42076971dc7979f9ad2c00f24ffabb7d4389f39f156584c53fbb20de3f67bb536bce3c62d4eeb205c9c525156ad55592907ddaa1822ce2aebaf424cc4ea8a386");
        TestDigest.testKatHex(new Shabal512(), "04e16dedc1227902baaf332d3d08923601bdd64f573faa1bb7201918cfe16b1e10151dae875da0c0d63c59c3dd050c4c6a874011b018421afc4623ab0381831b2da2a8ba42c96e4f70864ac44e106f94311051e74c77c1291bf5db9539e69567bf6a11cf6932bbbad33f8946bf5814c066d851633d1a513510039b349939bfd42b858c21827c8ff05f1d09b1b0765dc78a135b5ca4dfba0801bcaddfa175623c8b647eacfb4444b85a44f73890607d06d507a4f8393658788669f6ef4deb58d08c50ca0756d5e2f49d1a7ad73e0f0b3d3b5f090acf622b1878c59133e4a848e05153592ea81c6fbf", "2ac4f4d67dee9a5411785efa7fac8cc2ac53b8f50b52266dd384a88203997d87a512398619509740bfd4b011db31e6473f89d560ea9e299de82cb6271110dbda");
        TestDigest.testKatHex(new Shabal512(), "7c815c384eee0f288ece27cced52a01603127b079c007378bc5d1e6c5e9e6d1c735723acbbd5801ac49854b2b569d4472d33f40bbb8882956245c366dc3582d71696a97a4e19557e41e54dee482a14229005f93afd2c4a7d8614d10a97a9dfa07f7cd946fa45263063ddd29db8f9e34db60daa32684f0072ea2a9426ecebfa5239fb67f29c18cbaa2af6ed4bf4283936823ac1790164fec5457a9cba7c767ca59392d94cab7448f50eb34e9a93a80027471ce59736f099c886dea1ab4cba4d89f5fc7ae2f21ccd27f611eca4626b2d08dc22382e92c1efb2f6afdc8fdc3d2172604f5035c46b8197d3", "781d7d018e863d027abef220f4d023d22e564f8b56dbf428e4b30c5bc1b76008c22e9474e3700cf2bc34e7c845bd7bb9856dfe53c0b4d49a9f5d69b496832a41");
        TestDigest.testKatHex(new Shabal512(), "e29d505158dbdd937d9e3d2145658ee6f5992a2fc790f4f608d9cdb44a091d5b94b88e81fac4fdf5c49442f13b911c55886469629551189eaff62488f1a479b7db11a1560e198ddccccf50159093425ff7f1cb8d1d1246d0978764087d6bac257026b090efae8cec5f22b6f21c59ace1ac7386f5b8837ca6a12b6fbf5534dd0560ef05ca78104d3b943ddb220feaec89aa5e692a00f822a2ab9a2fe60350d75e7be16ff2526dc643872502d01f42f188abed0a6e9a6f5fd0d1ce7d5755c9ffa66b0af0b20bd806f08e06156690d81ac811778ca3dac2c249b96002017fce93e507e3b953acf99964b847", "bdd217f0bb3d0cc0f67028cdcfc470c64f1f7f8597f9ad5d79a0cd481e0e1567c7ecd35cb59a04b5befdb0e63ab3e223f4a1fad806e272a926a5c3a0041ae19e");
        TestDigest.testKatHex(new Shabal512(), "d85588696f576e65eca0155f395f0cfacd83f36a99111ed5768df2d116d2121e32357ba4f54ede927f189f297d3a97fad4e9a0f5b41d8d89dd7fe20156799c2b7b6bf9c957ba0d6763f5c3bc5129747bbb53652b49290cff1c87e2cdf2c4b95d8aaee09bc8fbfa6883e62d237885810491bfc101f1d8c636e3d0ede838ad05c207a3df4fad76452979eb99f29afaecedd1c63b8d36cf378454a1bb67a741c77ac6b6b3f95f4f02b64dabc15438613ea49750df42ee90101f115aa9abb9ff64324dde9dabbb01054e1bd6b4bcdc7930a44c2300d87ca78c06924d0323ad7887e46c90e8c4d100acd9eed21e", "d117787fafbc5a072a295a8d4db2e9c2ddfe7b6bc2854e788389fc34f5c28b4a7bfc7217392f66c2ca7c719e8571a2cd22f31173a247a14a9c1d1ce57354d991");
        TestDigest.testKatHex(new Shabal512(), "3a12f8508b40c32c74492b66323375dcfe49184c78f73179f3314b79e63376b8ac683f5a51f1534bd729b02b04d002f55cbd8e8fc9b5ec1ea6bbe6a0d0e7431518e6ba45d124035f9d3dce0a8bb7bf1430a9f657e0b4ea9f20eb20c786a58181a1e20a96f1628f8728a13bdf7a4b4b32fc8aa7054cc4881ae7fa19afa65c6c3ee1b3ade3192af42054a8a911b8ec1826865d46d93f1e7c5e2b7813c92a506e53886f3d4701bb93d2a681ad109c845904bb861af8af0646b6e399b38b614051d34f6842563a0f37ec00cb3d865fc5d746c4987de2a65071100883a2a9c7a2bfe1e2dd603d9ea24dc7c5fd06be", "d884c1a3dbc946cdc1cc9954c9a562861d95b3a12104cd2e44ab259667e92c6e9acc3c746ec41b4ebdc6441cd2ca33a794534a4d73249f712164dbc9056e7a74");
        TestDigest.testKatHex(new Shabal512(), "1861edce46fa5ad17e1ff1deae084dec580f97d0a67885dfe834b9dfac1ae076742ce9e267512ca51f6df5a455af0c5fd6abf94acea103a3370c354485a7846fb84f3ac7c2904b5b2fbf227002ce512133bb7e1c4e50057bfd1e44db33c7cdb969a99e284b184f50a14b068a1fc5009d9b298dbe92239572a7627aac02abe8f3e3b473417f36d4d2505d16b7577f4526c9d94a270a2dfe450d06da8f6fa956879a0a55cfe99e742ea555ea477ba3e9b44ccd508c375423611af92e55345dc215779b2d5119eba49c71d49b9fe3f1569fa24e5ca3e332d042422a8b8158d3ec66a80012976f31ffdf305f0c9c5e", "5e8c6cc234ca4243f41aa0032aac83c8512204fe9fd57a518bce17eb1e058fd3dcd85b66a4cfb497566d3c69631c639b8c212c1302dc982a3428ab6061a1daa1");
        TestDigest.testKatHex(new Shabal512(), "08d0ffde3a6e4ef65608ea672e4830c12943d7187ccff08f4941cfc13e545f3b9c7ad5eebbe2b01642b486caf855c2c73f58c1e4e3391da8e2d63d96e15fd84953ae5c231911b00ad6050cd7aafdaac9b0f663ae6aab45519d0f5391a541707d479034e73a6ad805ae3598096af078f1393301493d663dd71f83869ca27ba508b7e91e81e128c1716dc3acfe3084b2201e04cf8006617eecf1b640474a5d45cfde9f4d3ef92d6d055b909892194d8a8218db6d8203a84261d200d71473d7488f3427416b6896c137d455f231071cacbc86e0415ab88aec841d96b7b8af41e05bb461a40645bf176601f1e760de5f", "43fc0908bc21a58875402a13108379c6f09fcdd72a499a0659677765c87127a0f1dc359217ce0cbc1200cfebd68903ae4ba4538db5540c7d265d005208df0c26");
        TestDigest.testKatHex(new Shabal512(), "d782abb72a5be3392757be02d3e45be6e2099d6f000d042c8a543f50ed6ebc055a7f133b0dd8e9bc348536edcaae2e12ec18e8837df7a1b3c87ec46d50c241dee820fd586197552dc20beea50f445a07a38f1768a39e2b2ff05dddedf751f1def612d2e4d810daa3a0cc904516f9a43af660315385178a529e51f8aae141808c8bc5d7b60cac26bb984ac1890d0436ef780426c547e94a7b08f01acbfc4a3825eae04f520a9016f2fb8bf5165ed12736fc71e36a49a73614739eaa3ec834069b1b40f1350c2b3ab885c02c640b9f7686ed5f99527e41cfcd796fe4c256c9173186c226169ff257954ebda81c0e5f99", "35829171a41ea7a3fcf64792389d7b67232714c377aa150da2f020c90d095cbd60625002926165e659bf0efc29756bd590b044af8f2700635fafaab524ba2441");
        TestDigest.testKatHex(new Shabal512(), "5fce8109a358570e40983e1184e541833bb9091e280f258cfb144387b05d190e431cb19baa67273ba0c58abe91308e1844dcd0b3678baa42f335f2fa05267a0240b3c718a5942b3b3e3bfa98a55c25a1466e8d7a603722cb2bbf03afa54cd769a99f310735ee5a05dae2c22d397bd95635f58c48a67f90e1b73aafcd3f82117f0166657838691005b18da6f341d6e90fc1cdb352b30fae45d348294e501b63252de14740f2b85ae5299ddec3172de8b6d0ba219a20a23bb5e10ff434d39db3f583305e9f5c039d98569e377b75a70ab837d1df269b8a4b566f40bb91b577455fd3c356c914fa06b9a7ce24c7317a172d", "5da77cddd2805e7ed2d7fc32ffde3fcdce9fb7e871d36f9687990977c528abf55ee21a33fe3079752582f39f5f5274e465aa64f06d3b807d7f065187ae94dd6b");
        TestDigest.testKatHex(new Shabal512(), "6172f1971a6e1e4e6170afbad95d5fec99bf69b24b674bc17dd78011615e502de6f56b86b1a71d3f4348087218ac7b7d09302993be272e4a591968aef18a1262d665610d1070ee91cc8da36e1f841a69a7a682c580e836941d21d909a3afc1f0b963e1ca5ab193e124a1a53df1c587470e5881fb54dae1b0d840f0c8f9d1b04c645ba1041c7d8dbf22030a623aa15638b3d99a2c400ff76f3252079af88d2b37f35ee66c1ad7801a28d3d388ac450b97d5f0f79e4541755356b3b1a5696b023f39ab7ab5f28df4202936bc97393b93bc915cb159ea1bd7a0a414cb4b7a1ac3af68f50d79f0c9c7314e750f7d02faa58bfa", "b1545ca0ddc16953f34441824034852662a76127c25f5046b63d5f777fa1967b44075565d11197173f284ddc0ce106123b1fcd8ab4aba54cdddbec78749889d5");
        TestDigest.testKatHex(new Shabal512(), "5668ecd99dfbe215c4118398ac9c9eaf1a1433fab4ccdd3968064752b625ea944731f75d48a27d047d67547f14dd0ffaa55fa5e29f7af0d161d85eafc4f2029b717c918eab9d304543290bdba7158b68020c0ba4e079bc95b5bc0fc044a992b94b4ccd3bd66d0eabb5dbbab904d62e00752c4e3b0091d773bcf4c14b4377da3efff824b1cb2fa01b32d1e46c909e626ed2dae920f4c7dbeb635bc754facbd8d49beba3f23c1c41ccbfcd0ee0c114e69737f5597c0bf1d859f0c767e18002ae8e39c26261ffde2920d3d0baf0e906138696cfe5b7e32b600f45df3aaa39932f3a7df95b60fa8712a2271fcaf3911ce7b511b1", "852028c1cb7b6cf0ca8825fee2bf88093ec31db352f0e00ee75b081a79227481c462690289f08895ff68d60318bb57f45fe11b27f485641f230ffe9f53da4145");
        TestDigest.testKatHex(new Shabal512(), "03d625488354df30e3f875a68edfcf340e8366a8e1ab67f9d5c5486a96829dfac0578289082b2a62117e1cf418b43b90e0adc881fc6ae8105c888e9ecd21aea1c9ae1a4038dfd17378fed71d02ae492087d7cdcd98f746855227967cb1ab4714261ee3bead3f4db118329d3ebef4bc48a875c19ba763966da0ebea800e01b2f50b00e9dd4caca6dcb314d00184ef71ea2391d760c950710db4a70f9212ffc54861f9dc752ce18867b8ad0c48df8466ef7231e7ac567f0eb55099e622ebb86cb237520190a61c66ad34f1f4e289cb3282ae3eaac6152ed24d2c92bae5a7658252a53c49b7b02dfe54fdb2e90074b6cf310ac661", "874b8ef4c1166be87d916c39c2c5f33e1e4f9695ad6178d271f5706f88da3a0a408850847aab07e7470740322bb02b4098d8ec02c9d9dbb97c90b347a9e09ff1");
        TestDigest.testKatHex(new Shabal512(), "2edc282ffb90b97118dd03aaa03b145f363905e3cbd2d50ecd692b37bf000185c651d3e9726c690d3773ec1e48510e42b17742b0b0377e7de6b8f55e00a8a4db4740cee6db0830529dd19617501dc1e9359aa3bcf147e0a76b3ab70c4984c13e339e6806bb35e683af8527093670859f3d8a0fc7d493bcba6bb12b5f65e71e705ca5d6c948d66ed3d730b26db395b3447737c26fad089aa0ad0e306cb28bf0acf106f89af3745f0ec72d534968cca543cd2ca50c94b1456743254e358c1317c07a07bf2b0eca438a709367fafc89a57239028fc5fecfd53b8ef958ef10ee0608b7f5cb9923ad97058ec067700cc746c127a61ee3", "bd75a0e380082ba99a40ca37a46655e251c90986958adee288fdb1287db420e00135b0302cd062efb97ef02d053c00988847ebf19acfd6740f12f4955f3c0568");
        TestDigest.testKatHex(new Shabal512(), "90b28a6aa1fe533915bcb8e81ed6cacdc10962b7ff82474f845eeb86977600cf70b07ba8e3796141ee340e3fce842a38a50afbe90301a3bdcc591f2e7d9de53e495525560b908c892439990a2ca2679c5539ffdf636777ad9c1cdef809cda9e8dcdb451abb9e9c17efa4379abd24b182bd981cafc792640a183b61694301d04c5b3eaad694a6bd4cc06ef5da8fa23b4fa2a64559c5a68397930079d250c51bcf00e2b16a6c49171433b0aadfd80231276560b80458dd77089b7a1bbcc9e7e4b9f881eacd6c92c4318348a13f4914eb27115a1cfc5d16d7fd94954c3532efaca2cab025103b2d02c6fd71da3a77f417d7932685888a", "f9e67f04312a52b84e3e0fbff3469ba2743382af3bc604f004d2a5e4396fcfed70833e9f9521813c8c2f60a5b19312bb75dee9d62768da6eced114e6be8ef218");
        TestDigest.testKatHex(new Shabal512(), "2969447d175490f2aa9bb055014dbef2e6854c95f8d60950bfe8c0be8de254c26b2d31b9e4de9c68c9adf49e4ee9b1c2850967f29f5d08738483b417bb96b2a56f0c8aca632b552059c59aac3f61f7b45c966b75f1d9931ff4e596406378cee91aaa726a3a84c33f37e9cdbe626b5745a0b06064a8a8d56e53aaf102d23dd9df0a3fdf7a638509a6761a33fa42fa8ddbd8e16159c93008b53765019c3f0e9f10b144ce2ac57f5d7297f9c9949e4ff68b70d339f87501ce8550b772f32c6da8ad2ce2100a895d8b08fa1eead7c376b407709703c510b50f87e73e43f8e7348f87c3832a547ef2bbe5799abedcf5e1f372ea809233f006", "c3f61bfc8c7059a4bd4413448fefef8f22d47cacb70f0f6286fbe47e70617defb957c8a7c8ee7562735c0c9d72f3561639d3ad1040cae4b84697a803f816edb6");
        TestDigest.testKatHex(new Shabal512(), "721645633a44a2c78b19024eaecf58575ab23c27190833c26875dc0f0d50b46aea9c343d82ea7d5b3e50ec700545c615daeaea64726a0f05607576dcd396d812b03fb6551c641087856d050b10e6a4d5577b82a98afb89cee8594c9dc19e79feff0382fcfd127f1b803a4b9946f4ac9a4378e1e6e041b1389a53e3450cd32d9d2941b0cbabdb50da8ea2513145164c3ab6bcbd251c448d2d4b087ac57a59c2285d564f16da4ed5e607ed979592146ffb0ef3f3db308fb342df5eb5924a48256fc763141a278814c82d6d6348577545870ae3a83c7230ac02a1540fe1798f7ef09e335a865a2ae0949b21e4f748fb8a51f44750e213a8fb", "3d1afb6ce2a72f77c2c4d32607c6acdd1a19f22d5c82c47fa8e101c1607cf45879348520e33a4d3ddbce909d2b7702b46fed53dc8fc341116d54b71eba93fb83");
        TestDigest.testKatHex(new Shabal512(), "6b860d39725a14b498bb714574b4d37ca787404768f64c648b1751b353ac92bac2c3a28ea909fdf0423336401a02e63ec24325300d823b6864bb701f9d7c7a1f8ec9d0ae3584aa6dd62ea1997cd831b4babd9a4da50932d4efda745c61e4130890e156aee6113716daf95764222a91187db2effea49d5d0596102d619bd26a616bbfda8335505fbb0d90b4c180d1a2335b91538e1668f9f9642790b4e55f9cab0fe2bdd2935d001ee6419abab5457880d0dbff20ed8758f4c20fe759efb33141cf0e892587fe8187e5fbc57786b7e8b089612c936dfc03d27efbbe7c8673f1606bd51d5ff386f4a7ab68edf59f385eb1291f117bfe717399", "7f7a6232e4d8f6d6fcd15588f1b1373bb6a882d296a7f4821dba69c958576bd745e39bf7eb733e15aedcf269465196030ff4af0c49682ec243ddafd956322c1e");
        TestDigest.testKatHex(new Shabal512(), "6a01830af3889a25183244decb508bd01253d5b508ab490d3124afbf42626b2e70894e9b562b288d0a2450cfacf14a0ddae5c04716e5a0082c33981f6037d23d5e045ee1ef2283fb8b6378a914c5d9441627a722c282ff452e25a7ea608d69cee4393a0725d17963d0342684f255496d8a18c2961145315130549311fc07f0312fb78e6077334f87eaa873bee8aa95698996eb21375eb2b4ef53c14401207deb4568398e5dd9a7cf97e8c9663e23334b46912f8344c19efcf8c2ba6f04325f1a27e062b62a58d0766fc6db4d2c6a1928604b0175d872d16b7908ebc041761187cc785526c2a3873feac3a642bb39f5351550af9770c328af7b", "5c56422bd0c55e8f04cb0d340b44c647d7780637c0f8f54443b12b0642ba24844be8da11f0b2b96c9b40220a3aefedd44f833c7d5ca6795186d4c508a381c92f");
        TestDigest.testKatHex(new Shabal512(), "b3c5e74b69933c2533106c563b4ca20238f2b6e675e8681e34a389894785bdade59652d4a73d80a5c85bd454fd1e9ffdad1c3815f5038e9ef432aac5c3c4fe840cc370cf86580a6011778bbedaf511a51b56d1a2eb68394aa299e26da9ada6a2f39b9faff7fba457689b9c1a577b2a1e505fdf75c7a0a64b1df81b3a356001bf0df4e02a1fc59f651c9d585ec6224bb279c6beba2966e8882d68376081b987468e7aed1ef90ebd090ae825795cdca1b4f09a979c8dfc21a48d8a53cdbb26c4db547fc06efe2f9850edd2685a4661cb4911f165d4b63ef25b87d0a96d3dff6ab0758999aad214d07bd4f133a6734fde445fe474711b69a98f7e2b", "af2e72f75f350d54136c5d744bcbfeb1c5641f7074b52a52c14f25821f00d84f4a174d549f0ef4f1c863e3c5ef6d6e1dfefe5223c765640a966e005d7d5ffb4c");
        TestDigest.testKatHex(new Shabal512(), "83af34279ccb5430febec07a81950d30f4b66f484826afee7456f0071a51e1bbc55570b5cc7ec6f9309c17bf5befdd7c6ba6e968cf218a2b34bd5cf927ab846e38a40bbd81759e9e33381016a755f699df35d660007b5eadf292feefb735207ebf70b5bd17834f7bfa0e16cb219ad4af524ab1ea37334aa66435e5d397fc0a065c411ebbce32c240b90476d307ce802ec82c1c49bc1bec48c0675ec2a6c6f3ed3e5b741d13437095707c565e10d8a20b8c20468ff9514fcf31b4249cd82dcee58c0a2af538b291a87e3390d737191a07484a5d3f3fb8c8f15ce056e5e5f8febe5e1fb59d6740980aa06ca8a0c20f5712b4cde5d032e92ab89f0ae1", "38daddcc67541473e33d7ec58ce3a371b1ecb2463a9b768112843e650e7eff18f4bcf6e2802e1930050d2049de7c523def0f52193240511ce037215b228fa9da");
        TestDigest.testKatHex(new Shabal512(), "a7ed84749ccc56bb1dfba57119d279d412b8a986886d810f067af349e8749e9ea746a60b03742636c464fc1ee233acc52c1983914692b64309edfdf29f1ab912ec3e8da074d3f1d231511f5756f0b6eead3e89a6a88fe330a10face267bffbfc3e3090c7fd9a850561f363ad75ea881e7244f80ff55802d5ef7a1a4e7b89fcfa80f16df54d1b056ee637e6964b9e0ffd15b6196bdd7db270c56b47251485348e49813b4eb9ed122a01b3ea45ad5e1a929df61d5c0f3e77e1fdc356b63883a60e9cbb9fc3e00c2f32dbd469659883f690c6772e335f617bc33f161d6f6984252ee12e62b6000ac5231e0c9bc65be223d8dfd94c5004a101af9fd6c0fb", "5253a7aef82c959fc6e718ecd7e5b649bd88b888098b4f9cb56ae495d4c3744ee32ac8b400e021e081ae375c2c8ffcd797e83d92b9186b5deb65fabd90a47a07");
        TestDigest.testKatHex(new Shabal512(), "a6fe30dcfcda1a329e82ab50e32b5f50eb25c873c5d2305860a835aecee6264aa36a47429922c4b8b3afd00da16035830edb897831c4e7b00f2c23fc0b15fdc30d85fb70c30c431c638e1a25b51caf1d7e8b050b7f89bfb30f59f0f20fecff3d639abc4255b3868fc45dd81e47eb12ab40f2aac735df5d1dc1ad997cefc4d836b854cee9ac02900036f3867fe0d84afff37bde3308c2206c62c4743375094108877c73b87b2546fe05ea137bedfc06a2796274099a0d554da8f7d7223a48cbf31b7decaa1ebc8b145763e3673168c1b1b715c1cd99ecd3ddb238b06049885ecad9347c2436dff32c771f34a38587a44a82c5d3d137a03caa27e66c8ff6", "31469f6481adc3ef94f3ef7b97a04bc2c22768affd550cf8c64865a6cfc3f9e5115927db97c1d1ca084766db03b779b9c2eeb8a28c2ee283a0eb87496443defe");
        TestDigest.testKatHex(new Shabal512(), "83167ff53704c3aa19e9fb3303539759c46dd4091a52ddae9ad86408b69335989e61414bc20ab4d01220e35241eff5c9522b079fba597674c8d716fe441e566110b6211531ceccf8fd06bc8e511d00785e57788ed9a1c5c73524f01830d2e1148c92d0edc97113e3b7b5cd3049627abdb8b39dd4d6890e0ee91993f92b03354a88f52251c546e64434d9c3d74544f23fb93e5a2d2f1fb15545b4e1367c97335b0291944c8b730ad3d4789273fa44fb98d78a36c3c3764abeeac7c569c1e43a352e5b770c3504f87090dee075a1c4c85c0c39cf421bdcc615f9eff6cb4fe6468004aece5f30e1ecc6db22ad9939bb2b0ccc96521dfbf4ae008b5b46bc006e", "48d7226502683b2ef812a272e246ca62ad03bca676a1e968dea592199cc330a7ab2e8cd3eb41186358ea9a41cb8920a91daa0aff979eb15802bb56116d2ea1e4");
        TestDigest.testKatHex(new Shabal512(), "3a3a819c48efde2ad914fbf00e18ab6bc4f14513ab27d0c178a188b61431e7f5623cb66b23346775d386b50e982c493adbbfc54b9a3cd383382336a1a0b2150a15358f336d03ae18f666c7573d55c4fd181c29e6ccfde63ea35f0adf5885cfc0a3d84a2b2e4dd24496db789e663170cef74798aa1bbcd4574ea0bba40489d764b2f83aadc66b148b4a0cd95246c127d5871c4f11418690a5ddf01246a0c80a43c70088b6183639dcfda4125bd113a8f49ee23ed306faac576c3fb0c1e256671d817fc2534a52f5b439f72e424de376f4c565cca82307dd9ef76da5b7c4eb7e085172e328807c02d011ffbf33785378d79dc266f6a5be6bb0e4a92eceebaeb1", "2b8f4b56628a8791b452185253c432f92a71254228cca283de2bf5eae51da857b8e8eba05c785cac9317c770fd6e91402fe965b8bb619ada7330c80b29b672aa");
        TestDigest.reportSuccess("Shabal-512");
    }

    private static void testBLAKE224() {
        TestDigest.testKatHex(new BLAKE224(), "", "7dc5313b1c04512a174bd6503b89607aecbee0903d40a8a569c94eed");
        TestDigest.testKatHex(new BLAKE224(), "cc", "5e21c1e375c7bc822046fad96910c95031bd4262ada71b4c91052fea");
        TestDigest.testKatHex(new BLAKE224(), "41fb", "195707e8ce71fb91c2c82ccf78022609a598bd80c9a505ef035314db");
        TestDigest.testKatHex(new BLAKE224(), "1f877c", "4239b4afa926f2269b117059dc0310033c9c85acea1a031f97cd4e2a");
        TestDigest.testKatHex(new BLAKE224(), "c1ecfdfc", "9cd80af6d0181b831e1879959f287735c9cbf5d1e480e7341266d6f0");
        TestDigest.testKatHex(new BLAKE224(), "21f134ac57", "9e908983741757ff632c01f2b2c4d7f1ec8e642d112c212ba9739fd1");
        TestDigest.testKatHex(new BLAKE224(), "c6f50bb74e29", "6d6d952053aead200de9daa856c2993a7a7fa4a15b3924fb77dbb384");
        TestDigest.testKatHex(new BLAKE224(), "119713cc83eeef", "f258e503c5cb61b124f5b8e154d639470a534aca6b3b7fcca7f683bc");
        TestDigest.testKatHex(new BLAKE224(), "4a4f202484512526", "9a103b050484c01f0054c5ffc2eff886d8839a7943b1a350049add7c");
        TestDigest.testKatHex(new BLAKE224(), "1f66ab4185ed9b6375", "cd7d246935e6310221b3fa356ca4717ff62c20adfa9ad45071c92918");
        TestDigest.testKatHex(new BLAKE224(), "eed7422227613b6f53c9", "0cdbf92cef46f4a8836565b703bdc9821f1bb5d18c1777f0532dd4f7");
        TestDigest.testKatHex(new BLAKE224(), "eaeed5cdffd89dece455f1", "a0f2552e9de9067dba81ce1e25024ce7e817aee22caa91cc58c1f8d2");
        TestDigest.testKatHex(new BLAKE224(), "5be43c90f22902e4fe8ed2d3", "dc7ced9e4f1ce473caa7a0c7278013e3d634ffdf0f37d1240befd206");
        TestDigest.testKatHex(new BLAKE224(), "a746273228122f381c3b46e4f1", "d7b948f5df46d92c4487bee7f5a94824331313309cf8b01d1a8a557f");
        TestDigest.testKatHex(new BLAKE224(), "3c5871cd619c69a63b540eb5a625", "16d22db06a838cee8ab0453afee23b7191442180b47939e306634d84");
        TestDigest.testKatHex(new BLAKE224(), "fa22874bcc068879e8ef11a69f0722", "13c5d61600d576bafa87aee925f5f614fde7ded0d2d5f8b254ab5cc4");
        TestDigest.testKatHex(new BLAKE224(), "52a608ab21ccdd8a4457a57ede782176", "6bbf59e7bfd3438e1108d3856f09ebe5902403ce36f37ec75c73aff0");
        TestDigest.testKatHex(new BLAKE224(), "82e192e4043ddcd12ecf52969d0f807eed", "517041f7fae6873f1cd1824d8c9293665527c493ea0320b761671ce6");
        TestDigest.testKatHex(new BLAKE224(), "75683dcb556140c522543bb6e9098b21a21e", "0643a03855cec95cbb3b791f9f39bf8bf9fbc63d1c0cfaf66034ee0c");
        TestDigest.testKatHex(new BLAKE224(), "06e4efe45035e61faaf4287b4d8d1f12ca97e5", "d88631681900862c69ca0f02b8662fd819ea5d45b15b0f6bb4127872");
        TestDigest.testKatHex(new BLAKE224(), "e26193989d06568fe688e75540aea06747d9f851", "44535befce8de9335dc0a34557d4c893161c4a5993ab7517229d37b6");
        TestDigest.testKatHex(new BLAKE224(), "d8dc8fdefbdce9d44e4cbafe78447bae3b5436102a", "0549425cf8149e10eba8af140910026556d4412e992f5d851a604199");
        TestDigest.testKatHex(new BLAKE224(), "57085fd7e14216ab102d8317b0cb338a786d5fc32d8f", "e8f7c92cfd4c2d3f2fcde654eb8032b8c954d3c27b12e3cb9d557861");
        TestDigest.testKatHex(new BLAKE224(), "a05404df5dbb57697e2c16fa29defac8ab3560d6126fa0", "80129bfa2eb6894c513257b4fbeda696fe26e22fb43848f25989b040");
        TestDigest.testKatHex(new BLAKE224(), "aecbb02759f7433d6fcb06963c74061cd83b5b3ffa6f13c6", "1e097fec3c34b0ffbf02a274a48d91e7282384e1a506925ee5d45f52");
        TestDigest.testKatHex(new BLAKE224(), "aafdc9243d3d4a096558a360cc27c8d862f0be73db5e88aa55", "1b014aeffd4cba4a2e0161a1cc694eff83693ffc914866f8337b5ca5");
        TestDigest.testKatHex(new BLAKE224(), "7bc84867f6f9e9fdc3e1046cae3a52c77ed485860ee260e30b15", "1a6d0c379a03e4989b1d5cee3f91f89aaae07c1ce16b738013dd0d08");
        TestDigest.testKatHex(new BLAKE224(), "fac523575a99ec48279a7a459e98ff901918a475034327efb55843", "e2fa24118061c20652aea9ee6f09356f1cdd6235d58621bb7320a7ef");
        TestDigest.testKatHex(new BLAKE224(), "0f8b2d8fcfd9d68cffc17ccfb117709b53d26462a3f346fb7c79b85e", "a976a1cf2e4bba7f6ac5ec24d926706708b737026297903b71b68e13");
        TestDigest.testKatHex(new BLAKE224(), "a963c3e895ff5a0be4824400518d81412f875fa50521e26e85eac90c04", "287a9ca672599c335f7234e8fccf549c4a1d3d6b305c0180745bfc92");
        TestDigest.testKatHex(new BLAKE224(), "03a18688b10cc0edf83adf0a84808a9718383c4070c6c4f295098699ac2c", "577c0ad4c2543e4dd564da90f8cefc5cf42bf1cf5ff77a0557feef3c");
        TestDigest.testKatHex(new BLAKE224(), "84fb51b517df6c5accb5d022f8f28da09b10232d42320ffc32dbecc3835b29", "58ecb1fea5694c000821a741569321659b94a0a8e341b74558b31a6a");
        TestDigest.testKatHex(new BLAKE224(), "9f2fcc7c90de090d6b87cd7e9718c1ea6cb21118fc2d5de9f97e5db6ac1e9c10", "e03abd8d5fb7f2c2e7ea6f4ac1fdfb207fd6c43f4d98923d0e478d7f");
        TestDigest.testKatHex(new BLAKE224(), "de8f1b3faa4b7040ed4563c3b8e598253178e87e4d0df75e4ff2f2dedd5a0be046", "9a916492f830a2e1012c1e13443ef936d2c22f0246bce97896ba51e2");
        TestDigest.testKatHex(new BLAKE224(), "62f154ec394d0bc757d045c798c8b87a00e0655d0481a7d2d9fb58d93aedc676b5a0", "68615896484efce43e73fb0ea5fa2d150eca80658b043c0a1f63fade");
        TestDigest.testKatHex(new BLAKE224(), "b2dcfe9ff19e2b23ce7da2a4207d3e5ec7c6112a8a22aec9675a886378e14e5bfbad4e", "3d0cd51e70c05bcc367ce0bb2e8d242facdbf12dd3ed862baee6ec6a");
        TestDigest.testKatHex(new BLAKE224(), "47f5697ac8c31409c0868827347a613a3562041c633cf1f1f86865a576e02835ed2c2492", "3e98d6fc3977f9a68c850093c05fe7e71d01b370eb41997d2cd3e9a5");
        TestDigest.testKatHex(new BLAKE224(), "512a6d292e67ecb2fe486bfe92660953a75484ff4c4f2eca2b0af0edcdd4339c6b2ee4e542", "dced7bb2e882d4586e867e49df28e445dcdd029ccd202b21ce0afb51");
        TestDigest.testKatHex(new BLAKE224(), "973cf2b4dcf0bfa872b41194cb05bb4e16760a1840d8343301802576197ec19e2a1493d8f4fb", "4f8ddd053f7e58501c6347f0684e7f7b9359a118c82ca716c9862d98");
        TestDigest.testKatHex(new BLAKE224(), "80beebcd2e3f8a9451d4499961c9731ae667cdc24ea020ce3b9aa4bbc0a7f79e30a934467da4b0", "44caf3d40c82c4a83c7871495ea202f9179e8b3fa0286ee5184bc23d");
        TestDigest.testKatHex(new BLAKE224(), "7abaa12ec2a7347674e444140ae0fb659d08e1c66decd8d6eae925fa451d65f3c0308e29446b8ed3", "f8af63fa15f62d207a7b1c04fd6650bff6f3ab1e07a5aec6bcbd0672");
        TestDigest.testKatHex(new BLAKE224(), "c88dee9927679b8af422abcbacf283b904ff31e1cac58c7819809f65d5807d46723b20f67ba610c2b7", "a3412cfb6364c5d5a77b548afa209e1079249ec76dabc69af4b29c4f");
        TestDigest.testKatHex(new BLAKE224(), "01e43fe350fcec450ec9b102053e6b5d56e09896e0ddd9074fe138e6038210270c834ce6eadc2bb86bf6", "bb3570d61a725c9743df98104e7dfd7039615623d5b340d619f59bfb");
        TestDigest.testKatHex(new BLAKE224(), "337023370a48b62ee43546f17c4ef2bf8d7ecd1d49f90bab604b839c2e6e5bd21540d29ba27ab8e309a4b7", "a3838559fb9a7c40746a86633d638c7e027037375cd8e921a36702fa");
        TestDigest.testKatHex(new BLAKE224(), "6892540f964c8c74bd2db02c0ad884510cb38afd4438af31fc912756f3efec6b32b58ebc38fc2a6b913596a8", "51bba904814be07049607800715ec7f70113e0e0c5a2bbda79ed3cdb");
        TestDigest.testKatHex(new BLAKE224(), "f5961dfd2b1ffffda4ffbf30560c165bfedab8ce0be525845deb8dc61004b7db38467205f5dcfb34a2acfe96c0", "3568017ed4ae045dc2fdc63c31d01c048ca1624632cc309927ae397d");
        TestDigest.testKatHex(new BLAKE224(), "ca061a2eb6ceed8881ce2057172d869d73a1951e63d57261384b80ceb5451e77b06cf0f5a0ea15ca907ee1c27eba", "51babc4ed5d173779a3e4cae6de2c0cf115e36e0a4089abea946f654");
        TestDigest.testKatHex(new BLAKE224(), "1743a77251d69242750c4f1140532cd3c33f9b5ccdf7514e8584d4a5f9fbd730bcf84d0d4726364b9bf95ab251d9bb", "d5096b7e03d4ff7ed6dca151145b0a8b021b463dbc1465417b2905ac");
        TestDigest.testKatHex(new BLAKE224(), "d8faba1f5194c4db5f176fabfff856924ef627a37cd08cf55608bba8f1e324d7c7f157298eabc4dce7d89ce5162499f9", "ec2b93cc960afecbfa3f9e35be5fc19a2d10ae2adc280f35cbcd5627");
        TestDigest.testKatHex(new BLAKE224(), "be9684be70340860373c9c482ba517e899fc81baaa12e5c6d7727975d1d41ba8bef788cdb5cf4606c9c1c7f61aed59f97d", "6a3db9902d79c0377678a76f974ee39aca5d0365073d653ae718b4b2");
        TestDigest.testKatHex(new BLAKE224(), "7e15d2b9ea74ca60f66c8dfab377d9198b7b16deb6a1ba0ea3c7ee2042f89d3786e779cf053c77785aa9e692f821f14a7f51", "2e4474518b3eb81c8a487f6bd9ed5a45ad28f21cc62e6a7ce95a9cd5");
        TestDigest.testKatHex(new BLAKE224(), "9a219be43713bd578015e9fda66c0f2d83cac563b776ab9f38f3e4f7ef229cb443304fba401efb2bdbd7ece939102298651c86", "97d57e51861f649eb5a5734c1ce5af6bbd6645702b12247787ff878a");
        TestDigest.testKatHex(new BLAKE224(), "c8f2b693bd0d75ef99caebdc22adf4088a95a3542f637203e283bbc3268780e787d68d28cc3897452f6a22aa8573ccebf245972a", "c3f6723443b166e1fef4b0e529096abb9a23d8730b6a93397eadabea");
        TestDigest.testKatHex(new BLAKE224(), "ec0f99711016c6a2a07ad80d16427506ce6f441059fd269442baaa28c6ca037b22eeac49d5d894c0bf66219f2c08e9d0e8ab21de52", "ae0d255a97845e6dee90c4cc85f8867704108780fced0ea3cb75cde8");
        TestDigest.testKatHex(new BLAKE224(), "0dc45181337ca32a8222fe7a3bf42fc9f89744259cff653504d6051fe84b1a7ffd20cb47d4696ce212a686bb9be9a8ab1c697b6d6a33", "46e2b619b0a4c8a6a26bebd5fefe1d4bc543923ac6c9f12bed6a1131");
        TestDigest.testKatHex(new BLAKE224(), "de286ba4206e8b005714f80fb1cdfaebde91d29f84603e4a3ebc04686f99a46c9e880b96c574825582e8812a26e5a857ffc6579f63742f", "fa083b9d06432539780b306f8869c12ebc8c893e9308a208b337182d");
        TestDigest.testKatHex(new BLAKE224(), "eebcc18057252cbf3f9c070f1a73213356d5d4bc19ac2a411ec8cdeee7a571e2e20eaf61fd0c33a0ffeb297ddb77a97f0a415347db66bcaf", "309389f16f265e921d06be744032b8d12947557887bfb91055a00950");
        TestDigest.testKatHex(new BLAKE224(), "416b5cdc9fe951bd361bd7abfc120a5054758eba88fdd68fd84e39d3b09ac25497d36b43cbe7b85a6a3cebda8db4e5549c3ee51bb6fcb6ac1e", "fafd21a3440ba0f7599585ce8dc9094cbd85a1f9bc9d6a9a838d113c");
        TestDigest.testKatHex(new BLAKE224(), "5c5faf66f32e0f8311c32e8da8284a4ed60891a5a7e50fb2956b3cbaa79fc66ca376460e100415401fc2b8518c64502f187ea14bfc9503759705", "2f66a5be6f2f4d2cd6ee4c2d8a16dc652506b7940dc1b96e37f6f193");
        TestDigest.testKatHex(new BLAKE224(), "7167e1e02be1a7ca69d788666f823ae4eef39271f3c26a5cf7cee05bca83161066dc2e217b330df821103799df6d74810eed363adc4ab99f36046a", "bff8898f254944dad61eebcd74f6ceafccd0ebc869dbfc31dd9cf193");
        TestDigest.testKatHex(new BLAKE224(), "2fda311dbba27321c5329510fae6948f03210b76d43e7448d1689a063877b6d14c4f6d0eaa96c150051371f7dd8a4119f7da5c483cc3e6723c01fb7d", "a7d13ef44c126aa41aa08d5c9dfa57d11d16e10245d59ccb64cf817a");
        TestDigest.testKatHex(new BLAKE224(), "95d1474a5aab5d2422aca6e481187833a6212bd2d0f91451a67dd786dfc91dfed51b35f47e1deb8a8ab4b9cb67b70179cc26f553ae7b569969ce151b8d", "7179a6576869873f73a442771864bac55ea9eadd962a135647ef951d");
        TestDigest.testKatHex(new BLAKE224(), "c71bd7941f41df044a2927a8ff55b4b467c33d089f0988aa253d294addbdb32530c0d4208b10d9959823f0c0f0734684006df79f7099870f6bf53211a88d", "203280f8e0e3e881f83b858a7321a0d419afc60a546cf21fa7e0dedc");
        TestDigest.testKatHex(new BLAKE224(), "f57c64006d9ea761892e145c99df1b24640883da79d9ed5262859dcda8c3c32e05b03d984f1ab4a230242ab6b78d368dc5aaa1e6d3498d53371e84b0c1d4ba", "0549471fcdd5a11ee1617c6a82c67193f20f24898db956b7367ae358");
        TestDigest.testKatHex(new BLAKE224(), "e926ae8b0af6e53176dbffcc2a6b88c6bd765f939d3d178a9bde9ef3aa131c61e31c1e42cdfaf4b4dcde579a37e150efbef5555b4c1cb40439d835a724e2fae7", "2c57f9f809acc4c7b2f2c76af7eeac9da6c0d19e44cfa95f585e91d0");
        TestDigest.testKatHex(new BLAKE224(), "16e8b3d8f988e9bb04de9c96f2627811c973ce4a5296b4772ca3eefeb80a652bdf21f50df79f32db23f9f73d393b2d57d9a0297f7a2f2e79cfda39fa393df1ac00", "b9fc1906a0804675769550ba4942b4b4688e2ad29eb1ac6e4d926650");
        TestDigest.testKatHex(new BLAKE224(), "fc424eeb27c18a11c01f39c555d8b78a805b88dba1dc2a42ed5e2c0ec737ff68b2456d80eb85e11714fa3f8eabfb906d3c17964cb4f5e76b29c1765db03d91be37fc", "977ceba7acd6e6ed8c81850d3a4a7b9059a08da92d1639bf9f402668");
        TestDigest.testKatHex(new BLAKE224(), "abe3472b54e72734bdba7d9158736464251c4f21b33fbbc92d7fac9a35c4e3322ff01d2380cbaa4ef8fb07d21a2128b7b9f5b6d9f34e13f39c7ffc2e72e47888599ba5", "be288eb83d900ee3526c8049421e8a7b49a4eb4602aa177e212f63c3");
        TestDigest.testKatHex(new BLAKE224(), "36f9f0a65f2ca498d739b944d6eff3da5ebba57e7d9c41598a2b0e4380f3cf4b479ec2348d015ffe6256273511154afcf3b4b4bf09d6c4744fdd0f62d75079d440706b05", "9757d4417427f0ff962bd74ac76e58a2d0c0a531b9f2a438b2b4d78e");
        TestDigest.testKatHex(new BLAKE224(), "abc87763cae1ca98bd8c5b82caba54ac83286f87e9610128ae4de68ac95df5e329c360717bd349f26b872528492ca7c94c2c1e1ef56b74dbb65c2ac351981fdb31d06c77a4", "2bb3a0a411c5f9f7369258a1f945aea4aba9cc04f8323bf92e967f1b");
        TestDigest.testKatHex(new BLAKE224(), "94f7ca8e1a54234c6d53cc734bb3d3150c8ba8c5f880eab8d25fed13793a9701ebe320509286fd8e422e931d99c98da4df7e70ae447bab8cffd92382d8a77760a259fc4fbd72", "262f286b8076db4e3fb796b84232a8194fbaa0a286909316fb8de8ce");
        TestDigest.testKatHex(new BLAKE224(), "13bd2811f6ed2b6f04ff3895aceed7bef8dcd45eb121791bc194a0f806206bffc3b9281c2b308b1a729ce008119dd3066e9378acdcc50a98a82e20738800b6cddbe5fe9694ad6d", "09b07523037d6c00bb6aa44f3c6748739275cda0f0d0387517c769db");
        TestDigest.testKatHex(new BLAKE224(), "1eed9cba179a009ec2ec5508773dd305477ca117e6d569e66b5f64c6bc64801ce25a8424ce4a26d575b8a6fb10ead3fd1992edddeec2ebe7150dc98f63adc3237ef57b91397aa8a7", "79078b441b04c421e83492e114ade3326f35f06124e9a1a6d9280d5e");
        TestDigest.testKatHex(new BLAKE224(), "ba5b67b5ec3a3ffae2c19dd8176a2ef75c0cd903725d45c9cb7009a900c0b0ca7a2967a95ae68269a6dbf8466c7b6844a1d608ac661f7eff00538e323db5f2c644b78b2d48de1a08aa", "e20090ab464613629f612d5da8d27994758936ecd69b346889ae5bc4");
        TestDigest.testKatHex(new BLAKE224(), "0efa26ac5673167dcacab860932ed612f65ff49b80fa9ae65465e5542cb62075df1c5ae54fba4db807be25b070033efa223bdd5b1d3c94c6e1909c02b620d4b1b3a6c9fed24d70749604", "5c04c54f9d9fd19ba3c5b0ffd4e11b088051f6fc375b35af13d3c5ea");
        TestDigest.testKatHex(new BLAKE224(), "bbfd933d1fd7bf594ac7f435277dc17d8d5a5b8e4d13d96d2f64e771abbd51a5a8aea741beccbddb177bcea05243ebd003cfdeae877cca4da94605b67691919d8b033f77d384ca01593c1b", "67afbde226545c0ded0753b5fb825ce9672c20d24e918500161101aa");
        TestDigest.testKatHex(new BLAKE224(), "90078999fd3c35b8afbf4066cbde335891365f0fc75c1286cdd88fa51fab94f9b8def7c9ac582a5dbcd95817afb7d1b48f63704e19c2baa4df347f48d4a6d603013c23f1e9611d595ebac37c", "8b4f405b594031ad60c24b7959e07aff4badd3052bac6b0495bbd716");
        TestDigest.testKatHex(new BLAKE224(), "64105eca863515c20e7cfbaa0a0b8809046164f374d691cdbd6508aaabc1819f9ac84b52bafc1b0fe7cddbc554b608c01c8904c669d8db316a0953a4c68ece324ec5a49ffdb59a1bd6a292aa0e", "fffc3e4cf1aea05efc8caf4863b11f9d890c2b858306d9e54499c506");
        TestDigest.testKatHex(new BLAKE224(), "d4654be288b9f3b711c2d02015978a8cc57471d5680a092aa534f7372c71ceaab725a383c4fcf4d8deaa57fca3ce056f312961eccf9b86f14981ba5bed6ab5b4498e1f6c82c6cae6fc14845b3c8a", "c170426ccf6d9e5551cd38a31f4ba65c57f51c773dbd4e7b1aa41816");
        TestDigest.testKatHex(new BLAKE224(), "12d9394888305ac96e65f2bf0e1b18c29c90fe9d714dd59f651f52b88b3008c588435548066ea2fc4c101118c91f32556224a540de6efddbca296ef1fb00341f5b01fecfc146bdb251b3bdad556cd2", "13e6d98ee936bb18f31ae9c03c08fa113cdaab99e20a566147d3ba12");
        TestDigest.testKatHex(new BLAKE224(), "871a0d7a5f36c3da1dfce57acd8ab8487c274fad336bc137ebd6ff4658b547c1dcfab65f037aa58f35ef16aff4abe77ba61f65826f7be681b5b6d5a1ea8085e2ae9cd5cf0991878a311b549a6d6af230", "3d73a3bad182d3092ae72871fe8dbe0802c73bd282a0fd1f7325e7d4");
        TestDigest.testKatHex(new BLAKE224(), "e90b4ffef4d457bc7711ff4aa72231ca25af6b2e206f8bf859d8758b89a7cd36105db2538d06da83bad5f663ba11a5f6f61f236fd5f8d53c5e89f183a3cec615b50c7c681e773d109ff7491b5cc22296c5", "1124f8163aee7afaa3519a7f9ce2a2c45bbdcb6a8c48bd70e41ccd3d");
        TestDigest.testKatHex(new BLAKE224(), "e728de62d75856500c4c77a428612cd804f30c3f10d36fb219c5ca0aa30726ab190e5f3f279e0733d77e7267c17be27d21650a9a4d1e32f649627638dbada9702c7ca303269ed14014b2f3cf8b894eac8554", "89b66ca643a596e01e8358012379519e0b862e59c94d80aeda5ae366");
        TestDigest.testKatHex(new BLAKE224(), "6348f229e7b1df3b770c77544e5166e081850fa1c6c88169db74c76e42eb983facb276ad6a0d1fa7b50d3e3b6fcd799ec97470920a7abed47d288ff883e24ca21c7f8016b93bb9b9e078bdb9703d2b781b616e", "4fcd888867d558003f9ac86b2f2e9d5b4df4fd9b39ea2e2c8de638b3");
        TestDigest.testKatHex(new BLAKE224(), "4b127fde5de733a1680c2790363627e63ac8a3f1b4707d982caea258655d9bf18f89afe54127482ba01e08845594b671306a025c9a5c5b6f93b0a39522dc877437be5c2436cbf300ce7ab6747934fcfc30aeaaf6", "0bfcd3874247890a4537b75943e5afe0b82f1d6219e4452788d6429a");
        TestDigest.testKatHex(new BLAKE224(), "08461f006cff4cc64b752c957287e5a0faabc05c9bff89d23fd902d324c79903b48fcb8f8f4b01f3e4ddb483593d25f000386698f5ade7faade9615fdc50d32785ea51d49894e45baa3dc707e224688c6408b68b11", "5a9826fbedaa5d0e568b4ad5f419857dd339132a64c61e9733368dca");
        TestDigest.testKatHex(new BLAKE224(), "68c8f8849b120e6e0c9969a5866af591a829b92f33cd9a4a3196957a148c49138e1e2f5c7619a6d5edebe995acd81ec8bb9c7b9cfca678d081ea9e25a75d39db04e18d475920ce828b94e72241f24db72546b352a0e4", "b04e8ff2df25f3044d40bc0181bec02c0f459345d1a4c3381cc1ef50");
        TestDigest.testKatHex(new BLAKE224(), "b8d56472954e31fb54e28fca743f84d8dc34891cb564c64b08f7b71636debd64ca1edbdba7fc5c3e40049ce982bba8c7e0703034e331384695e9de76b5104f2fbc4535ecbeebc33bc27f29f18f6f27e8023b0fbb6f563c", "fd0890dff5d15d1e031ef546795d677db0fddfd2a46708dd8fe86828");
        TestDigest.testKatHex(new BLAKE224(), "0d58ac665fa84342e60cefee31b1a4eacdb092f122dfc68309077aed1f3e528f578859ee9e4cefb4a728e946324927b675cd4f4ac84f64db3dacfe850c1dd18744c74ceccd9fe4dc214085108f404eab6d8f452b5442a47d", "53d0e5d19282d21aac0aadc8784826c029ba75f0bbe5f82199e8a4c2");
        TestDigest.testKatHex(new BLAKE224(), "1755e2d2e5d1c1b0156456b539753ff416651d44698e87002dcf61dcfa2b4e72f264d9ad591df1fdee7b41b2eb00283c5aebb3411323b672eaa145c5125185104f20f335804b02325b6dea65603f349f4d5d8b782dd3469ccd", "3cf37bbdca9af2dca0942197221228ccdac6dd3cea958a74543c49da");
        TestDigest.testKatHex(new BLAKE224(), "b180de1a611111ee7584ba2c4b020598cd574ac77e404e853d15a101c6f5a2e5c801d7d85dc95286a1804c870bb9f00fd4dcb03aa8328275158819dcad7253f3e3d237aeaa7979268a5db1c6ce08a9ec7c2579783c8afc1f91a7", "36aab0aa2c24d1f512ecd83e2580012f97967be2bd91904465bca039");
        TestDigest.testKatHex(new BLAKE224(), "cf3583cbdfd4cbc17063b1e7d90b02f0e6e2ee05f99d77e24e560392535e47e05077157f96813544a17046914f9efb64762a23cf7a49fe52a0a4c01c630cfe8727b81fb99a89ff7cc11dca5173057e0417b8fe7a9efba6d95c555f", "60d99cbd8e1b82b72e958d69091e5c25095fde2eb53f13c8ecc3572a");
        TestDigest.testKatHex(new BLAKE224(), "072fc02340ef99115bad72f92c01e4c093b9599f6cfc45cb380ee686cb5eb019e806ab9bd55e634ab10aa62a9510cc0672cd3eddb589c7df2b67fcd3329f61b1a4441eca87a33c8f55da4fbbad5cf2b2527b8e983bb31a2fadec7523", "3a06febaa52f96fa5f76bcb7da151f930683633d36fccddec928f5e8");
        TestDigest.testKatHex(new BLAKE224(), "76eecf956a52649f877528146de33df249cd800e21830f65e90f0f25ca9d6540fde40603230eca6760f1139c7f268deba2060631eea92b1fff05f93fd5572fbe29579ecd48bc3a8d6c2eb4a6b26e38d6c5fbf2c08044aeea470a8f2f26", "e114100a00bf4f4146b6651fd001167bdac63ed4d54bc27388e3afcf");
        TestDigest.testKatHex(new BLAKE224(), "7adc0b6693e61c269f278e6944a5a2d8300981e40022f839ac644387bfac9086650085c2cdc585fea47b9d2e52d65a2b29a7dc370401ef5d60dd0d21f9e2b90fae919319b14b8c5565b0423cefb827d5f1203302a9d01523498a4db10374", "ff40685106c276dedc0da562837860cb2d43fe463046d11af8891d9b");
        TestDigest.testKatHex(new BLAKE224(), "e1fffa9826cce8b86bccefb8794e48c46cdf372013f782eced1e378269b7be2b7bf51374092261ae120e822be685f2e7a83664bcfbe38fe8633f24e633ffe1988e1bc5acf59a587079a57a910bda60060e85b5f5b6f776f0529639d9cce4bd", "99e8fc95971557bfef0c4fefb5971c982dd859d23aed76bf071cfe52");
        TestDigest.testKatHex(new BLAKE224(), "69f9abba65592ee01db4dce52dbab90b08fc04193602792ee4daa263033d59081587b09bbe49d0b49c9825d22840b2ff5d9c5155f975f8f2c2e7a90c75d2e4a8040fe39f63bbafb403d9e28cc3b86e04e394a9c9e8065bd3c85fa9f0c7891600", "a24f89a17d0c4490a8c2e1f8c406460c7a0939d0b55880f37caffc30");
        TestDigest.testKatHex(new BLAKE224(), "38a10a352ca5aedfa8e19c64787d8e9c3a75dbf3b8674bfab29b5dbfc15a63d10fae66cd1a6e6d2452d557967eaad89a4c98449787b0b3164ca5b717a93f24eb0b506ceb70cbbcb8d72b2a72993f909aad92f044e0b5a2c9ac9cb16a0ca2f81f49", "8873e4385c93a3f1a2ac4cae7a1e8920a5303fda3c777695f2c0839c");
        TestDigest.testKatHex(new BLAKE224(), "6d8c6e449bc13634f115749c248c17cd148b72157a2c37bf8969ea83b4d6ba8c0ee2711c28ee11495f43049596520ce436004b026b6c1f7292b9c436b055cbb72d530d860d1276a1502a5140e3c3f54a93663e4d20edec32d284e25564f624955b52", "6027d240f1d124459da56d81e34dedb9ec7aec89912900a8582413b9");
        TestDigest.testKatHex(new BLAKE224(), "6efcbcaf451c129dbe00b9cef0c3749d3ee9d41c7bd500ade40cdc65dedbbbadb885a5b14b32a0c0d087825201e303288a733842fa7e599c0c514e078f05c821c7a4498b01c40032e9f1872a1c925fa17ce253e8935e4c3c71282242cb716b2089ccc1", "d0cce346b20764c44574a49815009e63661f1c672c0ed5d3e6c1f3b4");
        TestDigest.testKatHex(new BLAKE224(), "433c5303131624c0021d868a30825475e8d0bd3052a022180398f4ca4423b98214b6beaac21c8807a2c33f8c93bd42b092cc1b06cedf3224d5ed1ec29784444f22e08a55aa58542b524b02cd3d5d5f6907afe71c5d7462224a3f9d9e53e7e0846dcbb4ce", "0db2af3746903ab6a026abd77f3896fc0016db757ba4fc9c8238b023");
        TestDigest.testKatHex(new BLAKE224(), "a873e0c67ca639026b6683008f7aa6324d4979550e9bce064ca1e1fb97a30b147a24f3f666c0a72d71348ede701cf2d17e2253c34d1ec3b647dbcef2f879f4eb881c4830b791378c901eb725ea5c172316c6d606e0af7df4df7f76e490cd30b2badf45685f", "0fa16ac87910b19a9f99e519d97b8e8759cb598ecac67dcb27cb8037");
        TestDigest.testKatHex(new BLAKE224(), "006917b64f9dcdf1d2d87c8a6173b64f6587168e80faa80f82d84f60301e561e312d9fbce62f39a6fb476e01e925f26bcc91de621449be6504c504830aae394096c8fc7694651051365d4ee9070101ec9b68086f2ea8f8ab7b811ea8ad934d5c9b62c60a4771", "d5320b08ed866300046922fe2c431fdf495458be8176b00b438b4bec");
        TestDigest.testKatHex(new BLAKE224(), "f13c972c52cb3cc4a4df28c97f2df11ce089b815466be88863243eb318c2adb1a417cb1041308598541720197b9b1cb5ba2318bd5574d1df2174af14884149ba9b2f446d609df240ce335599957b8ec80876d9a085ae084907bc5961b20bf5f6ca58d5dab38adb", "53616191f92bd46f2630c7488ccdb68de055e44053eeaacb0f6de7f4");
        TestDigest.testKatHex(new BLAKE224(), "e35780eb9799ad4c77535d4ddb683cf33ef367715327cf4c4a58ed9cbdcdd486f669f80189d549a9364fa82a51a52654ec721bb3aab95dceb4a86a6afa93826db923517e928f33e3fba850d45660ef83b9876accafa2a9987a254b137c6e140a21691e1069413848", "04a0a973306f9269a21381825d8df2ff661eaa4547503e24854ccead");
        TestDigest.testKatHex(new BLAKE224(), "64ec021c9585e01ffe6d31bb50d44c79b6993d72678163db474947a053674619d158016adb243f5c8d50aa92f50ab36e579ff2dabb780a2b529370daa299207cfbcdd3a9a25006d19c4f1fe33e4b1eaec315d8c6ee1e730623fd1941875b924eb57d6d0c2edc4e78d6", "cc558cba16da4c0f188535f6cb1342442ebb157d0b63e4021c416357");
        TestDigest.testKatHex(new BLAKE224(), "5954bab512cf327d66b5d9f296180080402624ad7628506b555eea8382562324cf452fba4a2130de3e165d11831a270d9cb97ce8c2d32a96f50d71600bb4ca268cf98e90d6496b0a6619a5a8c63db6d8a0634dfc6c7ec8ea9c006b6c456f1b20cd19e781af20454ac880", "95ffcbd42c93966c4d9a3208aa61a235fc032bb98732eb65e6f071d8");
        TestDigest.testKatHex(new BLAKE224(), "03d9f92b2c565709a568724a0aff90f8f347f43b02338f94a03ed32e6f33666ff5802da4c81bdce0d0e86c04afd4edc2fc8b4141c2975b6f07639b1994c973d9a9afce3d9d365862003498513bfa166d2629e314d97441667b007414e739d7febf0fe3c32c17aa188a8683", "dabcd99de12b54a796d1b57f879bae349f921867bc50e9a182bbce30");
        TestDigest.testKatHex(new BLAKE224(), "f31e8b4f9e0621d531d22a380be5d9abd56faec53cbd39b1fab230ea67184440e5b1d15457bd25f56204fa917fa48e669016cb48c1ffc1e1e45274b3b47379e00a43843cf8601a5551411ec12503e5aac43d8676a1b2297ec7a0800dbfee04292e937f21c005f17411473041", "8feb990ea88b34a63922b82d9a58b32f7019d06df610a59a22a84f3d");
        TestDigest.testKatHex(new BLAKE224(), "758ea3fea738973db0b8be7e599bbef4519373d6e6dcd7195ea885fc991d896762992759c2a09002912fb08e0cb5b76f49162aeb8cf87b172cf3ad190253df612f77b1f0c532e3b5fc99c2d31f8f65011695a087a35ee4eee5e334c369d8ee5d29f695815d866da99df3f79403", "9639f86c92b54cde4931d474be40f5e59e7d32e2f9a8aa882ee487f6");
        TestDigest.testKatHex(new BLAKE224(), "47c6e0c2b74948465921868804f0f7bd50dd323583dc784f998a93cd1ca4c6ef84d41dc81c2c40f34b5bee6a93867b3bdba0052c5f59e6f3657918c382e771d33109122cc8bb0e1e53c4e3d13b43ce44970f5e0c079d2ad7d7a3549cd75760c21bb15b447589e86e8d76b1e9ced2", "2978136cf1fae327ab067b79345522fc2e99f5ce387b6034ae42f11f");
        TestDigest.testKatHex(new BLAKE224(), "f690a132ab46b28edfa6479283d6444e371c6459108afd9c35dbd235e0b6b6ff4c4ea58e7554bd002460433b2164ca51e868f7947d7d7a0d792e4abf0be5f450853cc40d85485b2b8857ea31b5ea6e4ccfa2f3a7ef3380066d7d8979fdac618aad3d7e886dea4f005ae4ad05e5065f", "ac78e686255de094e780041ce091721943674fb219bcb87a4ddb7d7c");
        TestDigest.testKatHex(new BLAKE224(), "58d6a99bc6458824b256916770a8417040721cccfd4b79eacd8b65a3767ce5ba7e74104c985ac56b8cc9aebd16febd4cda5adb130b0ff2329cc8d611eb14dac268a2f9e633c99de33997fea41c52a7c5e1317d5b5daed35eba7d5a60e45d1fa7eaabc35f5c2b0a0f2379231953322c4e", "451d6bc79d3bb9fd2ed56131eb3f88d2cd8e6368377f4172f1401366");
        TestDigest.testKatHex(new BLAKE224(), "befab574396d7f8b6705e2d5b58b2c1c820bb24e3f4bae3e8fbcd36dbf734ee14e5d6ab972aedd3540235466e825850ee4c512ea9795abfd33f330d9fd7f79e62bbb63a6ea85de15beaeea6f8d204a28956059e2632d11861dfb0e65bc07ac8a159388d5c3277e227286f65ff5e5b5aec1", "5fb446e86397da412d186a83d67fe71e5261564571efd97467053b48");
        TestDigest.testKatHex(new BLAKE224(), "8e58144fa9179d686478622ce450c748260c95d1ba43b8f9b59abeca8d93488da73463ef40198b4d16fb0b0707201347e0506ff19d01bea0f42b8af9e71a1f1bd168781069d4d338fdef00bf419fbb003031df671f4a37979564f69282de9c65407847dd0da505ab1641c02dea4f0d834986", "b70d3278c1160f7f6a717e2d39c2f259e00a2d43f6b7af4baf618f6f");
        TestDigest.testKatHex(new BLAKE224(), "b55c10eae0ec684c16d13463f29291bf26c82e2fa0422a99c71db4af14dd9c7f33eda52fd73d017cc0f2dbe734d831f0d820d06d5f89dacc485739144f8cfd4799223b1aff9031a105cb6a029ba71e6e5867d85a554991c38df3c9ef8c1e1e9a7630be61caabca69280c399c1fb7a12d12aefc", "e0768d2d8099df65bdf485ad2a8ee7b9cd73cc8d2802bf2f0cd18dc1");
        TestDigest.testKatHex(new BLAKE224(), "2eeea693f585f4ed6f6f8865bbae47a6908aecd7c429e4bec4f0de1d0ca0183fa201a0cb14a529b7d7ac0e6ff6607a3243ee9fb11bcf3e2304fe75ffcddd6c5c2e2a4cd45f63c962d010645058d36571404a6d2b4f44755434d76998e83409c3205aa1615db44057db991231d2cb42624574f545", "fbf955b5f37684eacb814d473c202b27e92d3beea596390d6c48b70b");
        TestDigest.testKatHex(new BLAKE224(), "dab11dc0b047db0420a585f56c42d93175562852428499f66a0db811fcdddab2f7cdffed1543e5fb72110b64686bc7b6887a538ad44c050f1e42631bc4ec8a9f2a047163d822a38989ee4aab01b4c1f161b062d873b1cfa388fd301514f62224157b9bef423c7783b7aac8d30d65cd1bba8d689c2d", "60ec6f5536f1131032f0df9563dced512f56244ff503c00d54ae87c5");
        TestDigest.testKatHex(new BLAKE224(), "42e99a2f80aee0e001279a2434f731e01d34a44b1a8101726921c0590c30f3120eb83059f325e894a5ac959dca71ce2214799916424e859d27d789437b9d27240bf8c35adbafcecc322b48aa205b293962d858652abacbd588bcf6cbc388d0993bd622f96ed54614c25b6a9aa527589eaaffcf17ddf7", "d48ceb4f54b7e56a751451fd17fc69fde8df8f786bcb6ccd1657129d");
        TestDigest.testKatHex(new BLAKE224(), "3c9b46450c0f2cae8e3823f8bdb4277f31b744ce2eb17054bddc6dff36af7f49fb8a2320cc3bdf8e0a2ea29ad3a55de1165d219adeddb5175253e2d1489e9b6fdd02e2c3d3a4b54d60e3a47334c37913c5695378a669e9b72dec32af5434f93f46176ebf044c4784467c700470d0c0b40c8a088c815816", "dc72fba113f7441108e6141dad6739925ee0dc94c8744181df4818c0");
        TestDigest.testKatHex(new BLAKE224(), "d1e654b77cb155f5c77971a64df9e5d34c26a3cad6c7f6b300d39deb1910094691adaa095be4ba5d86690a976428635d5526f3e946f7dc3bd4dbc78999e653441187a81f9adcd5a3c5f254bc8256b0158f54673dcc1232f6e918ebfc6c51ce67eaeb042d9f57eec4bfe910e169af78b3de48d137df4f2840", "a203cc685110cc9278cf8e32112d615f887b66fa383fd916d89245cc");
        TestDigest.testKatHex(new BLAKE224(), "626f68c18a69a6590159a9c46be03d5965698f2dac3de779b878b3d9c421e0f21b955a16c715c1ec1e22ce3eb645b8b4f263f60660ea3028981eebd6c8c3a367285b691c8ee56944a7cd1217997e1d9c21620b536bdbd5de8925ff71dec6fbc06624ab6b21e329813de90d1e572dfb89a18120c3f606355d25", "814183ca12ade24733ca7176f5576d7dc042135d93b4f4eb6fdecb20");
        TestDigest.testKatHex(new BLAKE224(), "651a6fb3c4b80c7c68c6011675e6094eb56abf5fc3057324ebc6477825061f9f27e7a94633abd1fa598a746e4a577caf524c52ec1788471f92b8c37f23795ca19d559d446cab16cbcdce90b79fa1026cee77bf4ab1b503c5b94c2256ad75b3eac6fd5dcb96aca4b03a834bfb4e9af988cecbf2ae597cb9097940", "7f2d73589a9671299fe147012430bf185653b1c54010189b886adb70");
        TestDigest.testKatHex(new BLAKE224(), "8aaf072fce8a2d96bc10b3c91c809ee93072fb205ca7f10abd82ecd82cf040b1bc49ea13d1857815c0e99781de3adbb5443ce1c897e55188ceaf221aa9681638de05ae1b322938f46bce51543b57ecdb4c266272259d1798de13be90e10efec2d07484d9b21a3870e2aa9e06c21aa2d0c9cf420080a80a91dee16f", "b65a881d64d5856e2b2ffd407f35261a2358f2f73994e5c83c5d9d86");
        TestDigest.testKatHex(new BLAKE224(), "53f918fd00b1701bd504f8cdea803acca21ac18c564ab90c2a17da592c7d69688f6580575395551e8cd33e0fef08ca6ed4588d4d140b3e44c032355df1c531564d7f4835753344345a6781e11cd5e095b73df5f82c8ae3ad00877936896671e947cc52e2b29dcd463d90a0c9929128da222b5a211450bbc0e02448e2", "3536262d675e69ad44aa85eac9f871ff44c33eb3dc45e374672c39b0");
        TestDigest.testKatHex(new BLAKE224(), "a64599b8a61b5ccec9e67aed69447459c8da3d1ec6c7c7c82a7428b9b584fa67e90f68e2c00fbbed4613666e5168da4a16f395f7a3c3832b3b134bfc9cbaa95d2a0fe252f44ac6681eb6d40ab91c1d0282fed6701c57463d3c5f2bb8c6a7301fb4576aa3b5f15510db8956ff77478c26a7c09bea7b398cfc83503f538e", "aef6ad067ddd98579547b4f1c2508c407fefe8db8ac37f0764278c76");
        TestDigest.testKatHex(new BLAKE224(), "0e3ab0e054739b00cdb6a87bd12cae024b54cb5e550e6c425360c2e87e59401f5ec24ef0314855f0f56c47695d56a7fb1417693af2a1ed5291f2fee95f75eed54a1b1c2e81226fbff6f63ade584911c71967a8eb70933bc3f5d15bc91b5c2644d9516d3c3a8c154ee48e118bd1442c043c7a0dba5ac5b1d5360aae5b9065", "aa6c3733bc8ab8d5c853c4eceffe38fa02091401f81328202d60e3c8");
        TestDigest.testKatHex(new BLAKE224(), "a62fc595b4096e6336e53fcdfc8d1cc175d71dac9d750a6133d23199eaac288207944cea6b16d27631915b4619f743da2e30a0c00bbdb1bbb35ab852ef3b9aec6b0a8dcc6e9e1abaa3ad62ac0a6c5de765de2c3711b769e3fde44a74016fff82ac46fa8f1797d3b2a726b696e3dea5530439acee3a45c2a51bc32dd055650b", "43f5dcd3b1f1c2388bfcb5f52c339b708785d67a99def12288ad01ca");
        TestDigest.testKatHex(new BLAKE224(), "2b6db7ced8665ebe9deb080295218426bdaa7c6da9add2088932cdffbaa1c14129bccdd70f369efb149285858d2b1d155d14de2fdb680a8b027284055182a0cae275234cc9c92863c1b4ab66f304cf0621cd54565f5bff461d3b461bd40df28198e3732501b4860eadd503d26d6e69338f4e0456e9e9baf3d827ae685fb1d817", "d704873be44a7cc70caabca8babb62cde45f589bb457ad4a92eae6e1");
        TestDigest.testKatHex(new BLAKE224(), "10db509b2cdcaba6c062ae33be48116a29eb18e390e1bbada5ca0a2718afbcd23431440106594893043cc7f2625281bf7de2655880966a23705f0c5155c2f5cca9f2c2142e96d0a2e763b70686cd421b5db812daced0c6d65035fde558e94f26b3e6dde5bd13980cc80292b723013bd033284584bff27657871b0cf07a849f4ae2", "4a5142935e9c503005045ffa8fa0463e8b8b344bf44b03ee5d97ae7b");
        TestDigest.testKatHex(new BLAKE224(), "9334de60c997bda6086101a6314f64e4458f5ff9450c509df006e8c547983c651ca97879175aaba0c539e82d05c1e02c480975cbb30118121061b1ebac4f8d9a3781e2db6b18042e01ecf9017a64a0e57447ec7fcbe6a7f82585f7403ee2223d52d37b4bf426428613d6b4257980972a0acab508a7620c1cb28eb4e9d30fc41361ec", "7f0af94798706f0f548b54f3ac4a6f2063928d19434fea54ad3e6cfb");
        TestDigest.testKatHex(new BLAKE224(), "e88ab086891693aa535ceb20e64c7ab97c7dd3548f3786339897a5f0c39031549ca870166e477743ccfbe016b4428d89738e426f5ffe81626137f17aecff61b72dbee2dc20961880cfe281dfab5ee38b1921881450e16032de5e4d55ad8d4fca609721b0692bac79be5a06e177fe8c80c0c83519fb3347de9f43d5561cb8107b9b5edc", "3c0c3ca7cae23c611d3114a9b4489280eb1268c5957a4f94a702aa60");
        TestDigest.testKatHex(new BLAKE224(), "fd19e01a83eb6ec810b94582cb8fbfa2fcb992b53684fb748d2264f020d3b960cb1d6b8c348c2b54a9fcea72330c2aaa9a24ecdb00c436abc702361a82bb8828b85369b8c72ece0082fe06557163899c2a0efa466c33c04343a839417057399a63a3929be1ee4805d6ce3e5d0d0967fe9004696a5663f4cac9179006a2ceb75542d75d68", "8a6bb3fa5d69ca267a8cf659c2eada52ba16a660775e6307abadaa48");
        TestDigest.testKatHex(new BLAKE224(), "59ae20b6f7e0b3c7a989afb28324a40fca25d8651cf1f46ae383ef6d8441587aa1c04c3e3bf88e8131ce6145cfb8973d961e8432b202fa5af3e09d625faad825bc19da9b5c6c20d02abda2fcc58b5bd3fe507bf201263f30543819510c12bc23e2ddb4f711d087a86edb1b355313363a2de996b891025e147036087401ccf3ca7815bf3c49", "a4ec4219862c884147ddc0e3bae99092014139b538dc5ec770ca6a50");
        TestDigest.testKatHex(new BLAKE224(), "77ee804b9f3295ab2362798b72b0a1b2d3291dceb8139896355830f34b3b328561531f8079b79a6e9980705150866402fdc176c05897e359a6cb1a7ab067383eb497182a7e5aef7038e4c96d133b2782917417e391535b5e1b51f47d8ed7e4d4025fe98dc87b9c1622614bff3d1029e68e372de719803857ca52067cddaad958951cb2068cc6", "d9fcdc6cc7c5aedce6cae67cdbb7f5149ba5c50eb13a8b5f30fd87a7");
        TestDigest.testKatHex(new BLAKE224(), "b771d5cef5d1a41a93d15643d7181d2a2ef0a8e84d91812f20ed21f147bef732bf3a60ef4067c3734b85bc8cd471780f10dc9e8291b58339a677b960218f71e793f2797aea349406512829065d37bb55ea796fa4f56fd8896b49b2cd19b43215ad967c712b24e5032d065232e02c127409d2ed4146b9d75d763d52db98d949d3b0fed6a8052fbb", "eb9137cdcbf56deda4b06598d793b115de72dff184ada6eebc383f9a");
        TestDigest.testKatHex(new BLAKE224(), "b32d95b0b9aad2a8816de6d06d1f86008505bd8c14124f6e9a163b5a2ade55f835d0ec3880ef50700d3b25e42cc0af050ccd1be5e555b23087e04d7bf9813622780c7313a1954f8740b6ee2d3f71f768dd417f520482bd3a08d4f222b4ee9dbd015447b33507dd50f3ab4247c5de9a8abd62a8decea01e3b87c8b927f5b08beb37674c6f8e380c04", "93267ec55b666734918653df0367a5ea8293f9cb5fbc392db07bf722");
        TestDigest.testKatHex(new BLAKE224(), "04410e31082a47584b406f051398a6abe74e4da59bb6f85e6b49e8a1f7f2ca00dfba5462c2cd2bfde8b64fb21d70c083f11318b56a52d03b81cac5eec29eb31bd0078b6156786da3d6d8c33098c5c47bb67ac64db14165af65b44544d806dde5f487d5373c7f9792c299e9686b7e5821e7c8e2458315b996b5677d926dac57b3f22da873c601016a0d", "ce2a835e4a10beeee54a0e28b15aa15a456fe6b048272d6e7d8e704b");
        TestDigest.testKatHex(new BLAKE224(), "8b81e9badde026f14d95c019977024c9e13db7a5cd21f9e9fc491d716164bbacdc7060d882615d411438aea056c340cdf977788f6e17d118de55026855f93270472d1fd18b9e7e812bae107e0dfde7063301b71f6cfe4e225cab3b232905a56e994f08ee2891ba922d49c3dafeb75f7c69750cb67d822c96176c46bd8a29f1701373fb09a1a6e3c7158f", "9dee28c562a74c65240dc3d6262e881420f98dc4759a630402a7b224");
        TestDigest.testKatHex(new BLAKE224(), "fa6eed24da6666a22208146b19a532c2ec9ba94f09f1def1e7fc13c399a48e41acc2a589d099276296348f396253b57cb0e40291bd282773656b6e0d8bea1cda084a3738816a840485fcf3fb307f777fa5feac48695c2af4769720258c77943fb4556c362d9cba8bf103aeb9034baa8ea8bfb9c4f8e6742ce0d52c49ea8e974f339612e830e9e7a9c29065", "d8950c6252aa3b0d804fd757bb06bd45d076d341475039e34acd3a4c");
        TestDigest.testKatHex(new BLAKE224(), "9bb4af1b4f09c071ce3cafa92e4eb73ce8a6f5d82a85733440368dee4eb1cbc7b55ac150773b6fe47dbe036c45582ed67e23f4c74585dab509df1b83610564545642b2b1ec463e18048fc23477c6b2aa035594ecd33791af6af4cbc2a1166aba8d628c57e707f0b0e8707caf91cd44bdb915e0296e0190d56d33d8dde10b5b60377838973c1d943c22ed335e", "cb275bb8ecf4fcba43797737dc5658f947c9cfc00bc0e36362d73e26");
        TestDigest.testKatHex(new BLAKE224(), "2167f02118cc62043e9091a647cadbed95611a521fe0d64e8518f16c808ab297725598ae296880a773607a798f7c3cfce80d251ebec6885015f9abf7eaabae46798f82cb5926de5c23f44a3f9f9534b3c6f405b5364c2f8a8bdc5ca49c749bed8ce4ba48897062ae8424ca6dde5f55c0e42a95d1e292ca54fb46a84fbc9cd87f2d0c9e7448de3043ae22fdd229", "94b82035643053e6bbff3b7d2e6db23be9441f8f694739eaffa5daa8");
        TestDigest.testKatHex(new BLAKE224(), "94b7fa0bc1c44e949b1d7617d31b4720cbe7ca57c6fa4f4094d4761567e389ecc64f6968e4064df70df836a47d0c713336b5028b35930d29eb7a7f9a5af9ad5cf441745baec9bb014ceeff5a41ba5c1ce085feb980bab9cf79f2158e03ef7e63e29c38d7816a84d4f71e0f548b7fc316085ae38a060ff9b8dec36f91ad9ebc0a5b6c338cbb8f6659d342a24368cf", "15fe288e80a00874dc10d11aaa1189b38f394026694b490d08ef49a7");
        TestDigest.testKatHex(new BLAKE224(), "ea40e83cb18b3a242c1ecc6ccd0b7853a439dab2c569cfc6dc38a19f5c90acbf76aef9ea3742ff3b54ef7d36eb7ce4ff1c9ab3bc119cff6be93c03e208783335c0ab8137be5b10cdc66ff3f89a1bddc6a1eed74f504cbe7290690bb295a872b9e3fe2cee9e6c67c41db8efd7d863cf10f840fe618e7936da3dca5ca6df933f24f6954ba0801a1294cd8d7e66dfafec", "c861f2f8e7efb1199da313fa39762ad0231c5bd2a4b70605bb167a75");
        TestDigest.testKatHex(new BLAKE224(), "157d5b7e4507f66d9a267476d33831e7bb768d4d04cc3438da12f9010263ea5fcafbde2579db2f6b58f911d593d5f79fb05fe3596e3fa80ff2f761d1b0e57080055c118c53e53cdb63055261d7c9b2b39bd90acc32520cbbdbda2c4fd8856dbcee173132a2679198daf83007a9b5c51511ae49766c792a29520388444ebefe28256fb33d4260439cba73a9479ee00c63", "7a1077a5de9d22f24a01052f98786287d1e808ffc42e22cbc6096a6b");
        TestDigest.testKatHex(new BLAKE224(), "836b34b515476f613fe447a4e0c3f3b8f20910ac89a3977055c960d2d5d2b72bd8acc715a9035321b86703a411dde0466d58a59769672aa60ad587b8481de4bba552a1645779789501ec53d540b904821f32b0bd1855b04e4848f9f8cfe9ebd8911be95781a759d7ad9724a7102dbe576776b7c632bc39b9b5e19057e226552a5994c1dbb3b5c7871a11f5537011044c53", "8fa9f05747c98432b8642a46f2ee7d0f5698a8a46c6f5438a18b0bdc");
        TestDigest.testKatHex(new BLAKE224(), "cc7784a4912a7ab5ad3620aab29ba87077cd3cb83636adc9f3dc94f51edf521b2161ef108f21a0a298557981c0e53ce6ced45bdf782c1ef200d29bab81dd6460586964edab7cebdbbec75fd7925060f7da2b853b2b089588fa0f8c16ec6498b14c55dcee335cb3a91d698e4d393ab8e8eac0825f8adebeee196df41205c011674e53426caa453f8de1cbb57932b0b741d4c6", "ff3d8501bc623783e490631a875e73e87f1a279aec3e88a4f3b314b8");
        TestDigest.testKatHex(new BLAKE224(), "7639b461fff270b2455ac1d1afce782944aea5e9087eb4a39eb96bb5c3baaf0e868c8526d3404f9405e79e77bfac5ffb89bf1957b523e17d341d7323c302ea7083872dd5e8705694acdda36d5a1b895aaa16eca6104c82688532c8bfe1790b5dc9f4ec5fe95baed37e1d287be710431f1e5e8ee105bc42ed37d74b1e55984bf1c09fe6a1fa13ef3b96faeaed6a2a1950a12153", "dea69eb9369513b0ab4b5f1eb3fb7929096fc57171f0fe106c36f836");
        TestDigest.testKatHex(new BLAKE224(), "eb6513fc61b30cfba58d4d7e80f94d14589090cf1d80b1df2e68088dc6104959ba0d583d585e9578ab0aec0cf36c48435eb52ed9ab4bbce7a5abe679c97ae2dbe35e8cc1d45b06dda3cf418665c57cbee4bbb47fa4caf78f4ee656fec237fe4eebbafa206e1ef2bd0ee4ae71bd0e9b2f54f91daadf1febfd7032381d636b733dcb3bf76fb14e23aff1f68ed3dbcf75c9b99c6f26", "da078c4508d65d05f3fab00f6f7279728e83bc2e62d326ba77e8c780");
        TestDigest.testKatHex(new BLAKE224(), "1594d74bf5dde444265d4c04dad9721ff3e34cbf622daf341fe16b96431f6c4df1f760d34f296eb97d98d560ad5286fec4dce1724f20b54fd7df51d4bf137add656c80546fb1bf516d62ee82baa992910ef4cc18b70f3f8698276fcfb44e0ec546c2c39cfd8ee91034ff9303058b4252462f86c823eb15bf481e6b79cc3a02218595b3658e8b37382bd5048eaed5fd02c37944e73b", "670b46ab5d214ded504b5776b74903ff382a51894a4c4688134423ff");
        TestDigest.testKatHex(new BLAKE224(), "4cfa1278903026f66fedd41374558be1b585d03c5c55dac94361df286d4bd39c7cb8037ed3b267b07c346626449d0cc5b0dd2cf221f7e4c3449a4be99985d2d5e67bff2923357ddeab5abcb4619f3a3a57b2cf928a022eb27676c6cf805689004fca4d41ea6c2d0a4789c7605f7bb838dd883b3ad3e6027e775bcf262881428099c7fff95b14c095ea130e0b9938a5e22fc52650f591", "6be7d9b4415753f21c802d2eabccc70ad7496c29b75ee53f272d1413");
        TestDigest.testKatHex(new BLAKE224(), "d3e65cb92cfa79662f6af493d696a07ccf32aaadcceff06e73e8d9f6f909209e66715d6e978788c49efb9087b170ecf3aa86d2d4d1a065ae0efc8924f365d676b3cb9e2bec918fd96d0b43dee83727c9a93bf56ca2b2e59adba85696546a815067fc7a78039629d4948d157e7b0d826d1bf8e81237bab7321312fdaa4d521744f988db6fdf04549d0fdca393d639c729af716e9c8bba48", "586273df984ae511bc0a53fd77ba58a0b8dbddccfdf5c1df990ac2d0");
        TestDigest.testKatHex(new BLAKE224(), "842cc583504539622d7f71e7e31863a2b885c56a0ba62db4c2a3f2fd12e79660dc7205ca29a0dc0a87db4dc62ee47a41db36b9ddb3293b9ac4baae7df5c6e7201e17f717ab56e12cad476be49608ad2d50309e7d48d2d8de4fa58ac3cfeafeee48c0a9eec88498e3efc51f54d300d828dddccb9d0b06dd021a29cf5cb5b2506915beb8a11998b8b886e0f9b7a80e97d91a7d01270f9a7717", "ebcf92b4f6f1db0ef05112dd0749a922196f71739ccfb5111afbafb8");
        TestDigest.testKatHex(new BLAKE224(), "6c4b0a0719573e57248661e98febe326571f9a1ca813d3638531ae28b4860f23c3a3a8ac1c250034a660e2d71e16d3acc4bf9ce215c6f15b1c0fc7e77d3d27157e66da9ceec9258f8f2bf9e02b4ac93793dd6e29e307ede3695a0df63cbdc0fc66fb770813eb149ca2a916911bee4902c47c7802e69e405fe3c04ceb5522792a5503fa829f707272226621f7c488a7698c0d69aa561be9f378", "4f4032f23422f41b76b64b0a4b3c925ca40ce613015867f19481537a");
        TestDigest.testKatHex(new BLAKE224(), "51b7dbb7ce2ffeb427a91ccfe5218fd40f9e0b7e24756d4c47cd55606008bdc27d16400933906fd9f30effdd4880022d081155342af3fb6cd53672ab7fb5b3a3bcbe47be1fd3a2278cae8a5fd61c1433f7d350675dd21803746cadca574130f01200024c6340ab0cc2cf74f2234669f34e9009ef2eb94823d62b31407f4ba46f1a1eec41641e84d77727b59e746b8a671bef936f05be820759fa", "3826aaf1d20e3a6d0532213fd596fbacd171a08dae038ce820c37279");
        TestDigest.testKatHex(new BLAKE224(), "83599d93f5561e821bd01a472386bc2ff4efbd4aed60d5821e84aae74d8071029810f5e286f8f17651cd27da07b1eb4382f754cd1c95268783ad09220f5502840370d494beb17124220f6afce91ec8a0f55231f9652433e5ce3489b727716cf4aeba7dcda20cd29aa9a859201253f948dd94395aba9e3852bd1d60dda7ae5dc045b283da006e1cbad83cc13292a315db5553305c628dd091146597", "6bbc6cea5e1a3e03740aaf25ddb59d22adee27119213c425d9717b57");
        TestDigest.testKatHex(new BLAKE224(), "2be9bf526c9d5a75d565dd11ef63b979d068659c7f026c08bea4af161d85a462d80e45040e91f4165c074c43ac661380311a8cbed59cc8e4c4518e80cd2c78ab1cabf66bff83eab3a80148550307310950d034a6286c93a1ece8929e6385c5e3bb6ea8a7c0fb6d6332e320e71cc4eb462a2a62e2bfe08f0ccad93e61bedb5dd0b786a728ab666f07e0576d189c92bf9fb20dca49ac2d3956d47385e2", "a05feed52a97302d0445531d1264a632bc4fa563408d9f1e60c58f45");
        TestDigest.testKatHex(new BLAKE224(), "ca76d3a12595a817682617006848675547d3e8f50c2210f9af906c0e7ce50b4460186fe70457a9e879e79fd4d1a688c70a347361c847ba0dd6aa52936eaf8e58a1be2f5c1c704e20146d366aeb3853bed9de9befe9569ac8aaea37a9fb7139a1a1a7d5c748605a8defb297869ebedd71d615a5da23496d11e11abbb126b206fa0a7797ee7de117986012d0362dcef775c2fe145ada6bda1ccb326bf644", "4421b74c7314cdb8d442805e7079a0e038213b6da279d088c53bbdd7");
        TestDigest.testKatHex(new BLAKE224(), "f76b85dc67421025d64e93096d1d712b7baf7fb001716f02d33b2160c2c882c310ef13a576b1c2d30ef8f78ef8d2f465007109aad93f74cb9e7d7bef7c9590e8af3b267c89c15db238138c45833c98cc4a471a7802723ef4c744a853cf80a0c2568dd4ed58a2c9644806f42104cee53628e5bdf7b63b0b338e931e31b87c24b146c6d040605567ceef5960df9e022cb469d4c787f4cba3c544a1ac91f95f", "07c79b372da6b593d4646b3cfd339333a60785904a9ea40659389ca1");
        TestDigest.testKatHex(new BLAKE224(), "25b8c9c032ea6bcd733ffc8718fbb2a503a4ea8f71dea1176189f694304f0ff68e862a8197b839957549ef243a5279fc2646bd4c009b6d1edebf24738197abb4c992f6b1dc9ba891f570879accd5a6b18691a93c7d0a8d38f95b639c1daeb48c4c2f15ccf5b9d508f8333c32de78781b41850f261b855c4bebcc125a380c54d501c5d3bd07e6b52102116088e53d76583b0161e2a58d0778f091206aabd5a1", "7889519e8d3cef453f9d88902aa02376f3e503de3eb0782d8f53200d");
        TestDigest.testKatHex(new BLAKE224(), "21cfdc2a7ccb7f331b3d2eefff37e48ad9fa9c788c3f3c200e0173d99963e1cbca93623b264e920394ae48bb4c3a5bb96ffbc8f0e53f30e22956adabc2765f57fb761e147ecbf8567533db6e50c8a1f894310a94edf806dd8ca6a0e141c0fa7c9fae6c6ae65f18c93a8529e6e5b553bf55f25be2e80a9882bd37f145fecbeb3d447a3c4e46c21524cc55cdd62f521ab92a8ba72b897996c49bb273198b7b1c9e", "484e071fc78d276bc28d650139cd2a9d1ea9aaa4fad1db956835852a");
        TestDigest.testKatHex(new BLAKE224(), "4e452ba42127dcc956ef4f8f35dd68cb225fb73b5bc7e1ec5a898bba2931563e74faff3b67314f241ec49f4a7061e3bd0213ae826bab380f1f14faab8b0efddd5fd1bb49373853a08f30553d5a55ccbbb8153de4704f29ca2bdeef0419468e05dd51557ccc80c0a96190bbcc4d77ecff21c66bdf486459d427f986410f883a80a5bcc32c20f0478bb9a97a126fc5f95451e40f292a4614930d054c851acd019ccf", "3467b6c5df1604193093737f6c973e486e6b58d310861ff7e7b96b8e");
        TestDigest.testKatHex(new BLAKE224(), "fa85671df7dadf99a6ffee97a3ab9991671f5629195049880497487867a6c446b60087fac9a0f2fcc8e3b24e97e42345b93b5f7d3691829d3f8ccd4bb36411b85fc2328eb0c51cb3151f70860ad3246ce0623a8dc8b3c49f958f8690f8e3860e71eb2b1479a5cea0b3f8befd87acaf5362435eaeccb52f38617bc6c5c2c6e269ead1fbd69e941d4ad2012da2c5b21bcfbf98e4a77ab2af1f3fda3233f046d38f1dc8", "7823ef8296de1d4e362f90e2279ae6e4533bf00b7a41e0a079a5b2b4");
        TestDigest.testKatHex(new BLAKE224(), "e90847ae6797fbc0b6b36d6e588c0a743d725788ca50b6d792352ea8294f5ba654a15366b8e1b288d84f5178240827975a763bc45c7b0430e8a559df4488505e009c63da994f1403f407958203cebb6e37d89c94a5eacf6039a327f6c4dbbc7a2a307d976aa39e41af6537243fc218dfa6ab4dd817b6a397df5ca69107a9198799ed248641b63b42cb4c29bfdd7975ac96edfc274ac562d0474c60347a078ce4c25e88", "14477f63b6199d5b38e1c2aae3db4828bbfb58b9cc688a063abc5768");
        TestDigest.testKatHex(new BLAKE224(), "f6d5c2b6c93954fc627602c00c4ca9a7d3ed12b27173f0b2c9b0e4a5939398a665e67e69d0b12fb7e4ceb253e8083d1ceb724ac07f009f094e42f2d6f2129489e846eaff0700a8d4453ef453a3eddc18f408c77a83275617fabc4ea3a2833aa73406c0e966276079d38e8e38539a70e194cc5513aaa457c699383fd1900b1e72bdfb835d1fd321b37ba80549b078a49ea08152869a918ca57f5b54ed71e4fd3ac5c06729", "ad4ac83217893a8826487ffe0f6b216f14e0d970e28d2f6aabd2d824");
        TestDigest.testKatHex(new BLAKE224(), "cf8562b1bed89892d67ddaaf3deeb28246456e972326dbcdb5cf3fb289aca01e68da5d59896e3a6165358b071b304d6ab3d018944be5049d5e0e2bb819acf67a6006111089e6767132d72dd85beddcbb2d64496db0cc92955ab4c6234f1eea24f2d51483f2e209e4589bf9519fac51b4d061e801125e605f8093bb6997bc163d551596fe4ab7cfae8fb9a90f6980480ce0c229fd1675409bd788354daf316240cfe0af93eb", "daf8c68080de4ead9c89416acef004a4e133cc99a73e5712dba7dc85");
        TestDigest.testKatHex(new BLAKE224(), "2ace31abb0a2e3267944d2f75e1559985db7354c6e605f18dc8470423fca30b7331d9b33c4a4326783d1caae1b4f07060eff978e4746bf0c7e30cd61040bd5ec2746b29863eb7f103ebda614c4291a805b6a4c8214230564a0557bc7102e0bd3ed23719252f7435d64d210ee2aafc585be903fa41e1968c50fd5d5367926df7a05e3a42cf07e656ff92de73b036cf8b19898c0cb34557c0c12c2d8b84e91181af467bc75a9d1", "c5be0cf710c59b43591039eea299233093c0b10a0328a1a30d1ac3c5");
        TestDigest.testKatHex(new BLAKE224(), "0d8d09aed19f1013969ce5e7eb92f83a209ae76be31c754844ea9116ceb39a22ebb6003017bbcf26555fa6624185187db8f0cb3564b8b1c06bf685d47f3286eda20b83358f599d2044bbf0583fab8d78f854fe0a596183230c5ef8e54426750eaf2cc4e29d3bdd037e734d863c2bd9789b4c243096138f7672c232314effdfc6513427e2da76916b5248933be312eb5dde4cf70804fb258ac5fb82d58d08177ac6f4756017fff5", "acbf22d2cbb0f70a5a86d202a18a03c5a13b50dfcc1622ce3407b1cc");
        TestDigest.testKatHex(new BLAKE224(), "c3236b73deb7662bf3f3daa58f137b358ba610560ef7455785a9befdb035a066e90704f929bd9689cef0ce3bda5acf4480bceb8d09d10b098ad8500d9b6071dfc3a14af6c77511d81e3aa8844986c3bea6f469f9e02194c92868cd5f51646256798ff0424954c1434bdfed9facb390b07d342e992936e0f88bfd0e884a0ddb679d0547ccdec6384285a45429d115ac7d235a717242021d1dc35641f5f0a48e8445dba58e6cb2c8ea", "6dc7ab7846d9b91deacd9d023f186cce6f5eba590cece62e384503d2");
        TestDigest.testKatHex(new BLAKE224(), "b39feb8283eadc63e8184b51df5ae3fd41aac8a963bb0be1cd08aa5867d8d910c669221e73243360646f6553d1ca05a84e8dc0de05b6419ec349ca994480193d01c92525f3fb3dcefb08afc6d26947bdbbfd85193f53b50609c6140905c53a6686b58e53a319a57b962331ede98149af3de3118a819da4d76706a0424b4e1d2910b0ed26af61d150ebcb46595d4266a0bd7f651ba47d0c7f179ca28545007d92e8419d48fdfbd744ce", "e35db214e368fee06df1d33077d2cbacbd674748a30ba5020c3bece7");
        TestDigest.testKatHex(new BLAKE224(), "a983d54f503803e8c7999f4edbbe82e9084f422143a932ddddc47a17b0b7564a7f37a99d0786e99476428d29e29d3c197a72bfab1342c12a0fc4787fd7017d7a6174049ea43b5779169ef7472bdbbd941dcb82fc73aac45a8a94c9f2bd3477f61fd3b796f02a1b8264a214c6fea74b7051b226c722099ec7883a462b83b6afdd4009248b8a237f605fe5a08fe7d8b45321421ebba67bd70a0b00ddbf94baab7f359d5d1eea105f28dcfb", "3ed5f17b46f67fd26fc47815776ed3154d51183aa7afbbfed5b0d261");
        TestDigest.testKatHex(new BLAKE224(), "e4d1c1897a0a866ce564635b74222f9696bf2c7f640dd78d7e2aca66e1b61c642bb03ea7536aae597811e9bf4a7b453ede31f97b46a5f0ef51a071a2b3918df16b152519ae3776f9f1edab4c2a377c3292e96408359d3613844d5eb393000283d5ad3401a318b12fd1474b8612f2bb50fb6a8b9e023a54d7dde28c43d6d8854c8d9d1155935c199811dbfc87e9e0072e90eb88681cc7529714f8fb8a2c9d88567adfb974ee205a9bf7b848", "950f3a812685d2abe84d0ed736219cc9b92f84b05534361b623d379b");
        TestDigest.testKatHex(new BLAKE224(), "b10c59723e3dcadd6d75df87d0a1580e73133a9b7d00cb95ec19f5547027323be75158b11f80b6e142c6a78531886d9047b08e551e75e6261e79785366d7024bd7cd9cf322d9be7d57fb661069f2481c7bb759cd71b4b36ca2bc2df6d3a328faebdb995a9794a8d72155ed551a1f87c80bf6059b43fc764900b18a1c2441f7487743cf84e565f61f8dd2ece6b6ccc9444049197aaaf53e926fbee3bfca8be588ec77f29d211be89de18b15f6", "97d20ae6413ca18e2cfb234fd8755cae53b63728c17aeffc77f67691");
        TestDigest.testKatHex(new BLAKE224(), "db11f609baba7b0ca634926b1dd539c8cbada24967d7add4d9876f77c2d80c0f4dcefbd7121548373582705cca2495bd2a43716fe64ed26d059cfb566b3364bd49ee0717bdd9810dd14d8fad80dbbdc4cafb37cc60fb0fe2a80fb4541b8ca9d59dce457738a9d3d8f641af8c3fd6da162dc16fc01aac527a4a0255b4d231c0be50f44f0db0b713af03d968fe7f0f61ed0824c55c4b5265548febd6aad5c5eedf63efe793489c39b8fd29d104ce", "97999fafba4b93f246f4f9f92eef3211d367b9f92e27c4736f370135");
        TestDigest.testKatHex(new BLAKE224(), "bebd4f1a84fc8b15e4452a54bd02d69e304b7f32616aadd90537937106ae4e28de9d8aab02d19bc3e2fde1d651559e296453e4dba94370a14dbbb2d1d4e2022302ee90e208321efcd8528ad89e46dc839ea9df618ea8394a6bff308e7726bae0c19bcd4be52da6258e2ef4e96aa21244429f49ef5cb486d7ff35cac1bacb7e95711944bccb2ab34700d42d1eb38b5d536b947348a458ede3dc6bd6ec547b1b0cae5b257be36a7124e1060c170ffa", "b61d869f99839ce0ba4f5ee770a916049c036cc084b5d88b119f9e1f");
        TestDigest.testKatHex(new BLAKE224(), "5aca56a03a13784bdc3289d9364f79e2a85c12276b49b92db0adaa4f206d5028f213f678c3510e111f9dc4c1c1f8b6acb17a6413aa227607c515c62a733817ba5e762cc6748e7e0d6872c984d723c9bb3b117eb8963185300a80bfa65cde495d70a46c44858605fccbed086c2b45cef963d33294dbe9706b13af22f1b7c4cd5a001cfec251fba18e722c6e1c4b1166918b4f6f48a98b64b3c07fc86a6b17a6d0480ab79d4e6415b520f1c484d675b1", "920d25238eade6185bb73565808807945dd9190b03968ba10d962835");
        TestDigest.testKatHex(new BLAKE224(), "a5aad0e4646a32c85cfcac73f02fc5300f1982fabb2f2179e28303e447854094cdfc854310e5c0f60993ceff54d84d6b46323d930adb07c17599b35b505f09e784bca5985e0172257797fb53649e2e9723efd16865c31b5c3d5113b58bb0bfc8920fabdda086d7537e66d709d050bd14d0c960873f156fad5b3d3840cdfcdc9be6af519db262a27f40896ab25cc39f96984d650611c0d5a3080d5b3a1bf186abd42956588b3b58cd948970d298776060", "9065a4334dc69dddd7ef6e843aec4c5d5c5226a89122263ab7066c25");
        TestDigest.testKatHex(new BLAKE224(), "06cbbe67e94a978203ead6c057a1a5b098478b4b4cbef5a97e93c8e42f5572713575fc2a884531d7622f8f879387a859a80f10ef02708cd8f7413ab385afc357678b9578c0ebf641ef076a1a30f1f75379e9dcb2a885bdd295905ee80c0168a62a9597d10cf12dd2d8cee46645c7e5a141f6e0e23aa482abe5661c16e69ef1e28371e2e236c359ba4e92c25626a7b7ff13f6ea4ae906e1cfe163e91719b1f750a96cbde5fbc953d9e576cd216afc90323a", "c528a201ed2b2192ce557d19dfa5bdf42324a23f21148f0f46710751");
        TestDigest.testKatHex(new BLAKE224(), "f1c528cf7739874707d4d8ad5b98f7c77169de0b57188df233b2dc8a5b31eda5db4291dd9f68e6bad37b8d7f6c9c0044b3bf74bbc3d7d1798e138709b0d75e7c593d3cccdc1b20c7174b4e692add820ace262d45ccfae2077e878796347168060a162ecca8c38c1a88350bd63bb539134f700fd4addd5959e255337daa06bc86358fabcbefdfb5bc889783d843c08aadc6c4f6c36f65f156e851c9a0f917e4a367b5ad93d874812a1de6a7b93cd53ad97232", "f864c2e72281e7bd25d650a0a2fb1efaf707cb6b1588389707bc4ed9");
        TestDigest.testKatHex(new BLAKE224(), "9d9f3a7ecd51b41f6572fd0d0881e30390dfb780991dae7db3b47619134718e6f987810e542619dfaa7b505c76b7350c6432d8bf1cfebdf1069b90a35f0d04cbdf130b0dfc7875f4a4e62cdb8e525aadd7ce842520a482ac18f09442d78305fe85a74e39e760a4837482ed2f437dd13b2ec1042afcf9decdc3e877e50ff4106ad10a525230d11920324a81094da31deab6476aa42f20c84843cfc1c58545ee80352bdd3740dd6a16792ae2d86f11641bb717c2", "e22979853f14d41f0a0cc2bdddd089ff148d57782ff6d23ed52c11a9");
        TestDigest.testKatHex(new BLAKE224(), "5179888724819fbad3afa927d3577796660e6a81c52d98e9303261d5a4a83232f6f758934d50aa83ff9e20a5926dfebaac49529d006eb923c5ae5048ed544ec471ed7191edf46363383824f915769b3e688094c682b02151e5ee01e510b431c8865aff8b6b6f2f59cb6d129da79e97c6d2b8fa6c6da3f603199d2d1bcab547682a81cd6cf65f6551121391d78bcc23b5bd0e922ec6d8bf97c952e84dd28aef909aba31edb903b28fbfc33b7703cd996215a11238", "a90796dec2e0001c9fd6dd6f56165eb66112b6242a9835b15beb1725");
        TestDigest.testKatHex(new BLAKE224(), "576ef3520d30b7a4899b8c0d5e359e45c5189add100e43be429a02fb3de5ff4f8fd0e79d9663acca72cd29c94582b19292a557c5b1315297d168fbb54e9e2ecd13809c2b5fce998edc6570545e1499dbe7fb74d47cd7f35823b212b05bf3f5a79caa34224fdd670d335fcb106f5d92c3946f44d3afcbae2e41ac554d8e6759f332b76be89a0324aa12c5482d1ea3ee89ded4936f3e3c080436f539fa137e74c6d3389bdf5a45074c47bc7b20b0948407a66d855e2f", "13a62ef12cbaf71fee45bcdd0ad70943d835553f4c351be5c82fd289");
        TestDigest.testKatHex(new BLAKE224(), "0df2152fa4f4357c8741529dd77e783925d3d76e95bafa2b542a2c33f3d1d117d159cf473f82310356fee4c90a9e505e70f8f24859656368ba09381fa245eb6c3d763f3093f0c89b972e66b53d59406d9f01aea07f8b3b615cac4ee4d05f542e7d0dab45d67ccccd3a606ccbeb31ea1fa7005ba07176e60dab7d78f6810ef086f42f08e595f0ec217372b98970cc6321576d92ce38f7c397a403bada1548d205c343ac09deca86325373c3b76d9f32028fea8eb32515", "5d82d1c60672c83ab6042744aff036952e9e9780a5c8c4db084eec89");
        TestDigest.testKatHex(new BLAKE224(), "3e15350d87d6ebb5c8ad99d42515cfe17980933c7a8f6b8bbbf0a63728cefaad2052623c0bd5931839112a48633fb3c2004e0749c87a41b26a8b48945539d1ff41a4b269462fd199bfecd45374756f55a9116e92093ac99451aefb2af9fd32d6d7f5fbc7f7a540d5097c096ebc3b3a721541de073a1cc02f7fb0fb1b9327fb0b1218ca49c9487ab5396622a13ae546c97abdef6b56380dda7012a8384091b6656d0ab272d363cea78163ff765cdd13ab1738b940d16cae", "61ab2f7bd42c384d68d89fde6533c5f6381c6aae387a8aa86db462ee");
        TestDigest.testKatHex(new BLAKE224(), "c38d6b0b757cb552be40940ece0009ef3b0b59307c1451686f1a22702922800d58bce7a636c1727ee547c01b214779e898fc0e560f8ae7f61bef4d75eaa696b921fd6b735d171535e9edd267c192b99880c87997711002009095d8a7a437e258104a41a505e5ef71e5613ddd2008195f0c574e6ba3fe40099cfa116e5f1a2fa8a6da04badcb4e2d5d0de31fdc4800891c45781a0aac7c907b56d631fca5ce8b2cde620d11d1777ed9fa603541de794ddc5758fcd5fad78c0", "42b2fb3be3f0f03d300d56a0f150cc14e9e525ac4f85c6e127da2718");
        TestDigest.testKatHex(new BLAKE224(), "8d2de3f0b37a6385c90739805b170057f091cd0c7a0bc951540f26a5a75b3e694631bb64c7635eed316f51318e9d8de13c70a2aba04a14836855f35e480528b776d0a1e8a23b547c8b8d6a0d09b241d3be9377160cca4e6793d00a515dc2992cb7fc741daca171431da99cce6f7789f129e2ac5cf65b40d703035cd2185bb936c82002daf8cbc27a7a9e554b06196630446a6f0a14ba155ed26d95bd627b7205c072d02b60db0fd7e49ea058c2e0ba202daff0de91e845cf79", "3af81b70e15b90893abadc8694b360caa94bd4ad7e32459330bac2e1");
        TestDigest.testKatHex(new BLAKE224(), "c464bbdad275c50dcd983b65ad1019b9ff85a1e71c807f3204bb2c921dc31fbcd8c5fc45868ae9ef85b6c9b83bba2a5a822201ed68586ec5ec27fb2857a5d1a2d09d09115f22dcc39fe61f5e1ba0ff6e8b4acb4c6da748be7f3f0839739394ff7fa8e39f7f7e84a33c3866875c01bcb1263c9405d91908e9e0b50e7459fabb63d8c6bbb73d8e3483c099b55bc30ff092ff68b6adedfd477d63570c9f5515847f36e24ba0b705557130cec57ebad1d0b31a378e91894ee26e3a04", "55030e801ea59528cb3b07d027354971b21134e5df13f8ced535f218");
        TestDigest.testKatHex(new BLAKE224(), "8b8d68bb8a75732fe272815a68a1c9c5aa31b41dedc8493e76525d1d013d33cebd9e21a5bb95db2616976a8c07fcf411f5f6bc6f7e0b57aca78cc2790a6f9b898858ac9c79b165ff24e66677531e39f572be5d81eb3264524181115f32780257bfb9aeec6af12af28e587cac068a1a2953b59ad680f4c245b2e3ec36f59940d37e1d3db38e13edb29b5c0f404f6ff87f80fc8be7a225ff22fbb9c8b6b1d7330c57840d24bc75b06b80d30dad6806544d510af6c4785e823ac3e0b8", "fbdbabbc3f834003e2a107afc54d93856b5b89c6eae9b2eb5e3fc2fa");
        TestDigest.testKatHex(new BLAKE224(), "6b018710446f368e7421f1bc0ccf562d9c1843846bc8d98d1c9bf7d9d6fcb48bfc3bf83b36d44c4fa93430af75cd190bde36a7f92f867f58a803900df8018150384d85d82132f123006ac2aeba58e02a037fe6afbd65eca7c44977dd3dc74f48b6e7a1bfd5cc4dcf24e4d52e92bd4455848e4928b0eac8b7476fe3cc03e862aa4dff4470dbfed6de48e410f25096487ecfc32a27277f3f5023b2725ade461b1355889554a8836c9cf53bd767f5737d55184eea1ab3f53edd0976c485", "8e4cabd70334b30c2bde231075c9d67650f5a39f29af2c8fde6bc0bc");
        TestDigest.testKatHex(new BLAKE224(), "c9534a24714bd4be37c88a3da1082eda7cabd154c309d7bd670dccd95aa535594463058a29f79031d6ecaa9f675d1211e9359be82669a79c855ea8d89dd38c2c761ddd0ec0ce9e97597432e9a1beae062cdd71edfdfd464119be9e69d18a7a7fd7ce0e2106f0c8b0abf4715e2ca48ef9f454dc203c96656653b727083513f8efb86e49c513bb758b3b052fe21f1c05bb33c37129d6cc81f1aef6adc45b0e8827a830fe545cf57d0955802c117d23ccb55ea28f95c0d8c2f9c5a242b33f", "251f1b54f096be0dc8c7ef4dabb35e6cc94899914627e839569ed677");
        TestDigest.testKatHex(new BLAKE224(), "07906c87297b867abf4576e9f3cc7f82f22b154afcbf293b9319f1b0584da6a40c27b32e0b1b7f412c4f1b82480e70a9235b12ec27090a5a33175a2bb28d8adc475cefe33f7803f8ce27967217381f02e67a3b4f84a71f1c5228e0c2ad971373f6f672624fcea8d1a9f85170fad30fa0bbd25035c3b41a6175d467998bd1215f6f3866f53847f9cf68ef3e2fbb54bc994de2302b829c5eea68ec441fcbafd7d16ae4fe9fff98bf00e5bc2ad54dd91ff9fda4dd77b6c754a91955d1fbaad0", "f1642d68112fb7ba5459b1d84df3c9a2b0cf5ff7bf2f2b8dd3c568e3");
        TestDigest.testKatHex(new BLAKE224(), "588e94b9054abc2189df69b8ba34341b77cdd528e7860e5defcaa79b0c9a452ad4b82aa306be84536eb7cedcbe058d7b84a6aef826b028b8a0271b69ac3605a9635ea9f5ea0aa700f3eb7835bc54611b922964300c953efe7491e3677c2cebe0822e956cd16433b02c68c4a23252c3f9e151a416b4963257b783e038f6b4d5c9f110f871652c7a649a7bcedcbccc6f2d0725bb903cc196ba76c76aa9f10a190b1d1168993baa9ffc96a1655216773458bec72b0e39c9f2c121378feab4e76a", "6658cab9b47d6d183a0aab2bb2a1e5b565cc11a96cf04b22841b46a8");
        TestDigest.testKatHex(new BLAKE224(), "08959a7e4baae874928813364071194e2939772f20db7c3157078987c557c2a6d5abe68d520eef3dc491692e1e21bcd880adebf63bb4213b50897fa005256ed41b5690f78f52855c8d9168a4b666fce2da2b456d7a7e7c17ab5f2fb1ee90b79e698712e963715983fd07641ae4b4e9dc73203fac1ae11fa1f8c7941fcc82eab247addb56e2638447e9d609e610b60ce086656aaebf1da3c8a231d7d94e2fd0afe46b391ff14a72eaeb3f44ad4df85866def43d4781a0b3578bc996c87970b132", "5a5c66e677cbb0476cb5d58a82e795e3bf74dd92e5d73d89db053ee0");
        TestDigest.testKatHex(new BLAKE224(), "cb2a234f45e2ecd5863895a451d389a369aab99cfef0d5c9ffca1e6e63f763b5c14fb9b478313c8e8c0efeb3ac9500cf5fd93791b789e67eac12fd038e2547cc8e0fc9db591f33a1e4907c64a922dda23ec9827310b306098554a4a78f050262db5b545b159e1ff1dca6eb734b872343b842c57eafcfda8405eedbb48ef32e99696d135979235c3a05364e371c2d76f1902f1d83146df9495c0a6c57d7bf9ee77e80f9787aee27be1fe126cdc9ef893a4a7dcbbc367e40fe4e1ee90b42ea25af01", "e424b92178f16575826e12276d2ab00cb7b605e40e0540131a1fb25f");
        TestDigest.testKatHex(new BLAKE224(), "d16beadf02ab1d4dc6f88b8c4554c51e866df830b89c06e786a5f8757e8909310af51c840efe8d20b35331f4355d80f73295974653ddd620cdde4730fb6c8d0d2dcb2b45d92d4fbdb567c0a3e86bd1a8a795af26fbf29fc6c65941cddb090ff7cd230ac5268ab4606fccba9eded0a2b5d014ee0c34f0b2881ac036e24e151be89eeb6cd9a7a790afccff234d7cb11b99ebf58cd0c589f20bdac4f9f0e28f75e3e04e5b3debce607a496d848d67fa7b49132c71b878fd5557e082a18eca1fbda94d4b", "6e8df320c7dc314f355b7ecd86a3b6d68c2c4a28a4cd23a68421f894");
        TestDigest.testKatHex(new BLAKE224(), "8f65f6bc59a85705016e2bae7fe57980de3127e5ab275f573d334f73f8603106ec3553016608ef2dd6e69b24be0b7113bf6a760ba6e9ce1c48f9e186012cf96a1d4849d75df5bb8315387fd78e9e153e76f8ba7ec6c8849810f59fb4bb9b004318210b37f1299526866f44059e017e22e96cbe418699d014c6ea01c9f0038b10299884dbec3199bb05adc94e955a1533219c1115fed0e5f21228b071f40dd57c4240d98d37b73e412fe0fa4703120d7c0c67972ed233e5deb300a22605472fa3a3ba86", "f98299b846db17bf38f449749db447e77ceeb89946f127631cbcd837");
        TestDigest.testKatHex(new BLAKE224(), "84891e52e0d451813210c3fd635b39a03a6b7a7317b221a7abc270dfa946c42669aacbbbdf801e1584f330e28c729847ea14152bd637b3d0f2b38b4bd5bf9c791c58806281103a3eabbaede5e711e539e6a8b2cf297cf351c078b4fa8f7f35cf61bebf8814bf248a01d41e86c5715ea40c63f7375379a7eb1d78f27622fb468ab784aaaba4e534a6dfd1df6fa15511341e725ed2e87f98737ccb7b6a6dfae416477472b046bf1811187d151bfa9f7b2bf9acdb23a3be507cdf14cfdf517d2cb5fb9e4ab6", "f24c7e23b42f9758ea03fa735baf009164092a66cf7dba57ed64a974");
        TestDigest.testKatHex(new BLAKE224(), "fdd7a9433a3b4afabd7a3a5e3457e56debf78e84b7a0b0ca0e8c6d53bd0c2dae31b2700c6128334f43981be3b213b1d7a118d59c7e6b6493a86f866a1635c12859cfb9ad17460a77b4522a5c1883c3d6acc86e6162667ec414e9a104aa892053a2b1d72165a855bacd8faf8034a5dd9b716f47a0818c09bb6baf22aa503c06b4ca261f557761989d2afbd88b6a678ad128af68672107d0f1fc73c5ca740459297b3292b281e93bceb761bde7221c3a55708e5ec84472cddcaa84ecf23723cc0991355c6280", "0190c61d845e30a9b6b1b88664d4ab0c82f5468b58aa00ea3791c83f");
        TestDigest.testKatHex(new BLAKE224(), "70a40bfbef92277a1aad72f6b79d0177197c4ebd432668cfec05d099accb651062b5dff156c0b27336687a94b26679cfdd9daf7ad204338dd9c4d14114033a5c225bd11f217b5f4732da167ee3f939262d4043fc9cba92303b7b5e96aea12adda64859df4b86e9ee0b58e39091e6b188b408ac94e1294a8911245ee361e60e601eff58d1d37639f3753bec80ebb4efde25817436076623fc65415fe51d1b0280366d12c554d86743f3c3b6572e400361a60726131441ba493a83fbe9afda90f7af1ae717238d", "955e1a70543377159b71fd78011456ece364bb68e330f17f42b0aef7");
        TestDigest.testKatHex(new BLAKE224(), "74356e449f4bf8644f77b14f4d67cb6bd9c1f5ae357621d5b8147e562b65c66585caf2e491b48529a01a34d226d436959153815380d5689e30b35357cdac6e08d3f2b0e88e200600d62bd9f5eaf488df86a4470ea227006182e44809009868c4c280c43d7d64a5268fa719074960087b3a6abc837882f882c837834535929389a12b2c78187e2ea07ef8b8eef27dc85002c3ae35f1a50bee6a1c48ba7e175f3316670b27983472aa6a61eed0a683a39ee323080620ea44a9f74411ae5ce99030528f9ab49c79f2", "8c839383b225c6086e51e597db53415aa6b7a26576860f6308a8fc25");
        TestDigest.testKatHex(new BLAKE224(), "8c3798e51bc68482d7337d3abb75dc9ffe860714a9ad73551e120059860dde24ab87327222b64cf774415a70f724cdf270de3fe47dda07b61c9ef2a3551f45a5584860248fabde676e1cd75f6355aa3eaeabe3b51dc813d9fb2eaa4f0f1d9f834d7cad9c7c695ae84b329385bc0bef895b9f1edf44a03d4b410cc23a79a6b62e4f346a5e8dd851c2857995ddbf5b2d717aeb847310e1f6a46ac3d26a7f9b44985af656d2b7c9406e8a9e8f47dcb4ef6b83caacf9aefb6118bfcff7e44bef6937ebddc89186839b77", "bccad51b4457990330f8ed494a51f328231c0bab38250f0bf2820b43");
        TestDigest.testKatHex(new BLAKE224(), "fa56bf730c4f8395875189c10c4fb251605757a8fecc31f9737e3c2503b02608e6731e85d7a38393c67de516b85304824bfb135e33bf22b3a23b913bf6acd2b7ab85198b8187b2bcd454d5e3318cacb32fd6261c31ae7f6c54ef6a7a2a4c9f3ecb81ce3555d4f0ad466dd4c108a90399d70041997c3b25345a9653f3c9a6711ab1b91d6a9d2216442da2c973cbd685ee7643bfd77327a2f7ae9cb283620a08716dfb462e5c1d65432ca9d56a90e811443cd1ecb8f0de179c9cb48ba4f6fec360c66f252f6e64edc96b", "fced43234aa8e44b55e6bf95cd64cbb3ff58faade7f992007573ab56");
        TestDigest.testKatHex(new BLAKE224(), "b6134f9c3e91dd8000740d009dd806240811d51ab1546a974bcb18d344642baa5cd5903af84d58ec5ba17301d5ec0f10ccd0509cbb3fd3fff9172d193af0f782252fd1338c7244d40e0e42362275b22d01c4c3389f19dd69bdf958ebe28e31a4ffe2b5f18a87831cfb7095f58a87c9fa21db72ba269379b2dc2384b3da953c7925761fed324620acea435e52b424a7723f6a2357374157a34cd8252351c25a1b232826cefe1bd3e70ffc15a31e7c0598219d7f00436294d11891b82497bc78aa5363892a2495df8c1eef", "5bd71bbea3a992330d4b4d56db4d6e5276da773d2a1d2fe16c0a9241");
        TestDigest.testKatHex(new BLAKE224(), "c941cdb9c28ab0a791f2e5c8e8bb52850626aa89205bec3a7e22682313d198b1fa33fc7295381354858758ae6c8ec6fac3245c6e454d16fa2f51c4166fab51df272858f2d603770c40987f64442d487af49cd5c3991ce858ea2a60dab6a65a34414965933973ac2457089e359160b7cdedc42f29e10a91921785f6b7224ee0b349393cdcff6151b50b377d609559923d0984cda6000829b916ab6896693ef6a2199b3c22f7dc5500a15b8258420e314c222bc000bc4e5413e6dd82c993f8330f5c6d1be4bc79f08a1a0a46", "3ba370757344dfca05bd281394d84f2e45ebb88d2271774f916e8866");
        TestDigest.testKatHex(new BLAKE224(), "4499efffac4bcea52747efd1e4f20b73e48758be915c88a1ffe5299b0b005837a46b2f20a9cb3c6e64a9e3c564a27c0f1c6ad1960373036ec5bfe1a8fc6a435c2185ed0f114c50e8b3e4c7ed96b06a036819c9463e864a58d6286f785e32a804443a56af0b4df6abc57ed5c2b185ddee8489ea080deeee66aa33c2e6dab36251c402682b6824821f998c32163164298e1fafd31babbcffb594c91888c6219079d907fdb438ed89529d6d96212fd55abe20399dbefd342248507436931cdead496eb6e4a80358acc78647d043", "29bbc894d5fcc2241caead2014929e06ebb8cd8317002c4ff4a6c327");
        TestDigest.testKatHex(new BLAKE224(), "eecbb8fdfa4da62170fd06727f697d81f83f601ff61e478105d3cb7502f2c89bf3e8f56edd469d049807a38882a7eefbc85fc9a950952e9fa84b8afebd3ce782d4da598002827b1eb98882ea1f0a8f7aa9ce013a6e9bc462fb66c8d4a18da21401e1b93356eb12f3725b6db1684f2300a98b9a119e5d27ff704affb618e12708e77e6e5f34139a5a41131fd1d6336c272a8fc37080f041c71341bee6ab550cb4a20a6ddb6a8e0299f2b14bc730c54b8b1c1c487b494bdccfd3a53535ab2f231590bf2c4062fd2ad58f906a2d0d", "c672ad63603d46a203a17be19ed87fcdec3aac6c21e5468813605da6");
        TestDigest.testKatHex(new BLAKE224(), "e64f3e4ace5c8418d65fec2bc5d2a303dd458034736e3b0df719098be7a206deaf52d6ba82316caf330ef852375188cde2b39cc94aa449578a7e2a8e3f5a9d68e816b8d16889fbc0ebf0939d04f63033ae9ae2bdab73b88c26d6bd25ee460ee1ef58fb0afa92cc539f8c76d3d097e7a6a63ebb9b5887edf3cf076028c5bbd5b9db3211371ad3fe121d4e9bf44229f4e1ecf5a0f9f0eba4d5ceb72878ab22c3f0eb5a625323ac66f7061f4a81fac834471e0c59553f108475fe290d43e6a055ae3ee46fb67422f814a68c4be3e8c9", "ed7c305ab0d654af1611c4474ae17ed9bcbcd003216b15bac6a4e391");
        TestDigest.testKatHex(new BLAKE224(), "d2cb2d733033f9e91395312808383cc4f0ca974e87ec68400d52e96b3fa6984ac58d9ad0938dde5a973008d818c49607d9de2284e7618f1b8aed8372fbd52ed54557af4220fac09dfa8443011699b97d743f8f2b1aef3537ebb45dcc9e13dfb438428ee190a4efdb3caeb7f3933117bf63abdc7e57beb4171c7e1ad260ab0587806c4d137b6316b50abc9cce0dff3acada47bbb86be777e617bbe578ff4519844db360e0a96c6701290e76bb95d26f0f804c8a4f2717eac4e7de9f2cff3bbc55a17e776c0d02856032a6cd10ad2838", "3cd5ecb258d1daa03df3890540d3fdcd29fcb91e424fe1b893160a46");
        TestDigest.testKatHex(new BLAKE224(), "f2998955613dd414cc111df5ce30a995bb792e260b0e37a5b1d942fe90171a4ac2f66d4928d7ad377f4d0554cbf4c523d21f6e5f379d6f4b028cdcb9b1758d3b39663242ff3cb6ede6a36a6f05db3bc41e0d861b384b6dec58bb096d0a422fd542df175e1be1571fb52ae66f2d86a2f6824a8cfaacbac4a7492ad0433eeb15454af8f312b3b2a577750e3efbd370e8a8cac1582581971fba3ba4bd0d76e718dacf8433d33a59d287f8cc92234e7a271041b526e389efb0e40b6a18b3aaf658e82ed1c78631fd23b4c3eb27c3faec8685", "01a4b79e97812e97ea25e655920b4a0b83a07466a656c5f1ebdcf046");
        TestDigest.testKatHex(new BLAKE224(), "447797e2899b72a356ba55bf4df3acca6cdb1041eb477bd1834a9f9acbc340a294d729f2f97df3a610be0ff15edb9c6d5db41644b9874360140fc64f52aa03f0286c8a640670067a84e017926a70438db1bb361defee7317021425f8821def26d1efd77fc853b818545d055adc9284796e583c76e6fe74c9ac2587aa46aa8f8804f2feb5836cc4b3ababab8429a5783e17d5999f32242eb59ef30cd7adabc16d72dbdb097623047c98989f88d14eaf02a7212be16ec2d07981aaa99949ddf89ecd90333a77bc4e1988a82abf7c7caf3291", "67a28cc06abce4940c199e81fcd3c745ffd72f10cc77b3ffc4628988");
        TestDigest.testKatHex(new BLAKE224(), "9f2c18ade9b380c784e170fb763e9aa205f64303067eb1bcea93df5dac4bf5a2e00b78195f808df24fc76e26cb7be31dc35f0844cded1567bba29858cffc97fb29010331b01d6a3fb3159cc1b973d255da9843e34a0a4061cabdb9ed37f241bfabb3c20d32743f4026b59a4ccc385a2301f83c0b0a190b0f2d01acb8f0d41111e10f2f4e149379275599a52dc089b35fdd5234b0cfb7b6d8aebd563ca1fa653c5c021dfd6f5920e6f18bfafdbecbf0ab00281333ed50b9a999549c1c8f8c63d7626c48322e9791d5ff72294049bde91e73f8", "534f894c76eb30ce96e082655b9a4217d261e9ed6b2e09706453b408");
        TestDigest.testKatHex(new BLAKE224(), "ae159f3fa33619002ae6bcce8cbbdd7d28e5ed9d61534595c4c9f43c402a9bb31f3b301cbfd4a43ce4c24cd5c9849cc6259eca90e2a79e01ffbac07ba0e147fa42676a1d668570e0396387b5bcd599e8e66aaed1b8a191c5a47547f61373021fa6deadcb55363d233c24440f2c73dbb519f7c9fa5a8962efd5f6252c0407f190dfefad707f3c7007d69ff36b8489a5b6b7c557e79dd4f50c06511f599f56c896b35c917b63ba35c6ff8092baf7d1658e77fc95d8a6a43eeb4c01f33f03877f92774be89c1114dd531c011e53a34dc248a2f0e6", "d7f55e6eb163ebe12172ce606dcec889b68c75905572e10ebff5b1e8");
        TestDigest.testKatHex(new BLAKE224(), "3b8e97c5ffc2d6a40fa7de7fcefc90f3b12c940e7ab415321e29ee692dfac799b009c99dcddb708fce5a178c5c35ee2b8617143edc4c40b4d313661f49abdd93cea79d117518805496fe6acf292c4c2a1f76b403a97d7c399daf85b46ad84e16246c67d6836757bde336c290d5d401e6c1386ab32797af6bb251e9b2d8fe754c47482b72e0b394eab76916126fd68ea7d65eb93d59f5b4c5ac40f7c3b37e7f3694f29424c24af8c8f0ef59cd9dbf1d28e0e10f799a6f78cad1d45b9db3d7dee4a7059abe99182714983b9c9d44d7f5643596d4f3", "ee8b236c8196cfea86c37c8a093d654c8d424df7bab74a30e98ad1fa");
        TestDigest.testKatHex(new BLAKE224(), "3434ec31b10fafdbfeec0dd6bd94e80f7ba9dca19ef075f7eb017512af66d6a4bcf7d16ba0819a1892a6372f9b35bcc7ca8155ee19e8428bc22d214856ed5fa9374c3c09bde169602cc219679f65a1566fc7316f4cc3b631a18fb4449fa6afa16a3db2bc4212eff539c67cf184680826535589c7111d73bffce431b4c40492e763d9279560aaa38eb2dc14a212d723f994a1fe656ff4dd14551ce4e7c621b2aa5604a10001b2878a897a28a08095c325e10a26d2fb1a75bfd64c250309bb55a44f23bbac0d5516a1c687d3b41ef2fbbf9cc56d4739", "44e51376454bb40afbee0cdb3a3942beb684bebbee03ae9461d7d2e4");
        TestDigest.testKatHex(new BLAKE224(), "7c7953d81c8d208fd1c97681d48f49dd003456de60475b84070ef4847c333b74575b1fc8d2a186964485a3b8634feaa3595aaa1a2f4595a7d6b6153563dee31bbac443c8a33eed6d5d956a980a68366c2527b550ee950250dfb691eacbd5d56ae14b970668be174c89df2fea43ae52f13142639c884fd62a3683c0c3792f0f24ab1318bcb27e21f4737fab62c77ea38bc8fd1cf41f7dab64c13febe7152bf5bb7ab5a78f5346d43cc741cb6f72b7b8980f268b68bf62abdfb1577a52438fe14b591498cc95f071228460c7c5d5ceb4a7bde588e7f21c", "fe891b01f916aae5df0038883a012843b2ebcd1c14754fd8179ce0b9");
        TestDigest.testKatHex(new BLAKE224(), "7a6a4f4fdc59a1d223381ae5af498d74b7252ecf59e389e49130c7eaee626e7bd9897effd92017f4ccde66b0440462cdedfd352d8153e6a4c8d7a0812f701cc737b5178c2556f07111200eb627dbc299caa792dfa58f35935299fa3a3519e9b03166dffa159103ffa35e8577f7c0a86c6b46fe13db8e2cdd9dcfba85bdddcce0a7a8e155f81f712d8e9fe646153d3d22c811bd39f830433b2213dd46301941b59293fd0a33e2b63adbd95239bc01315c46fdb678875b3c81e053a40f581cfbec24a1404b1671a1b88a6d06120229518fb13a74ca0ac5ae", "f351988bc56e01e2ba70a0b34f598c1249200e7883d9756da59612a9");
        TestDigest.testKatHex(new BLAKE224(), "d9faa14cebe9b7de551b6c0765409a33938562013b5e8e0e1e0a6418df7399d0a6a771fb81c3ca9bd3bb8e2951b0bc792525a294ebd1083688806fe5e7f1e17fd4e3a41d00c89e8fcf4a363caedb1acb558e3d562f1302b3d83bb886ed27b76033798131dab05b4217381eaaa7ba15ec820bb5c13b516dd640eaec5a27d05fdfca0f35b3a5312146806b4c0275bcd0aaa3b2017f346975db566f9b4d137f4ee10644c2a2da66deeca5342e236495c3c6280528bfd32e90af4cd9bb908f34012b52b4bc56d48cc8a6b59bab014988eabd12e1a0a1c2e170e7", "fd14d429cc082d1b16b06b9b051ad3da459c040a209a66c870f3c7ec");
        TestDigest.testKatHex(new BLAKE224(), "2d8427433d0c61f2d96cfe80cf1e932265a191365c3b61aaa3d6dcc039f6ba2ad52a6a8cc30fc10f705e6b7705105977fa496c1c708a277a124304f1fc40911e7441d1b5e77b951aad7b01fd5db1b377d165b05bbf898042e39660caf8b279fe5229d1a8db86c0999ed65e53d01ccbc4b43173ccf992b3a14586f6ba42f5fe30afa8ae40c5df29966f9346da5f8b35f16a1de3ab6de0f477d8d8660918060e88b9b9e9ca6a4207033b87a812dbf5544d39e4882010f82b6ce005f8e8ff6fe3c3806bc2b73c2b83afb704345629304f9f86358712e9fae3ca3e", "c5cf8953f29c7098af404657698784c7557144fc5d2d00c93af14182");
        TestDigest.testKatHex(new BLAKE224(), "5e19d97887fcaac0387e22c6f803c34a3dacd2604172433f7a8a7a526ca4a2a1271ecfc5d5d7be5ac0d85d921095350dfc65997d443c21c8094e0a3fefd2961bcb94aed03291ae310ccda75d8ace4bc7d89e7d3e5d1650bda5d668b8b50bfc8e608e184f4d3a9a2badc4ff5f07e0c0bc8a9f2e0b2a26fd6d8c550008faaab75fd71af2a424bec9a7cd9d83fad4c8e9319115656a8717d3b523a68ff8004258b9990ed362308461804ba3e3a7e92d8f2ffae5c2fba55ba5a3c27c0a2f71bd711d2fe1799c2adb31b200035481e9ee5c4adf2ab9c0fa50b23975cf", "33f4e26c770dde558e1e772e574c75fb249d7f0797bff6e1b137119b");
        TestDigest.testKatHex(new BLAKE224(), "c8e976ab4638909387ce3b8d4e510c3230e5690e02c45093b1d297910abc481e56eea0f296f98379dfc9080af69e73b2399d1c143bee80ae1328162ce1ba7f6a8374679b20aacd380eb4e61382c99998704d62701afa914f9a2705cdb065885f50d086c3eb5753700c387118bb142f3e6da1e988dfb31ac75d7368931e45d1391a274b22f83ceb072f9bcabc0b216685bfd789f5023971024b1878a205442522f9ea7d8797a4102a3df41703768251fd5e017c85d1200a464118aa35654e7ca39f3c375b8ef8cbe7534dbc64bc20befb417cf60ec92f63d9ee7397", "e6db9346bc2f116e0e90cb069d39f4ad5471d600775b9e3613c87ad9");
        TestDigest.testKatHex(new BLAKE224(), "7145fa124b7429a1fc2231237a949ba7201bcc1822d3272de005b682398196c25f7e5cc2f289fbf44415f699cb7fe6757791b1443410234ae061edf623359e2b4e32c19bf88450432dd01caa5eb16a1dc378f391ca5e3c4e5f356728bddd4975db7c890da8bbc84cc73ff244394d0d48954978765e4a00b593f70f2ca082673a261ed88dbcef1127728d8cd89bc2c597e9102ced6010f65fa75a14ebe467fa57ce3bd4948b6867d74a9df5c0ec6f530cbf2ee61ce6f06bc8f2864dff5583776b31df8c7ffcb61428a56bf7bd37188b4a5123bbf338393af46eda85e6", "e410d2f7c660ee866086294cddd4b1b3e49eea22756d06abe9f1d29c");
        TestDigest.testKatHex(new BLAKE224(), "7fdfadcc9d29bad23ae038c6c65cda1aef757221b8872ed3d75ff8df7da0627d266e224e812c39f7983e4558bfd0a1f2bef3feb56ba09120ef762917b9c093867948547aee98600d10d87b20106878a8d22c64378bf634f7f75900c03986b077b0bf8b740a82447b61b99fee5376c5eb6680ec9e3088f0bdd0c56883413d60c1357d3c811950e5890e7600103c916341b80c743c6a852b7b4fb60c3ba21f3bc15b8382437a68454779cf3cd7f9f90ccc8ef28d0b706535b1e4108eb5627bb45d719cb046839aee311ca1abdc8319e050d67972cb35a6b1601b25dbf487", "bb64e353bf5d1794b2d96502462f0dff3517c371d5a34c3c0bc88017");
        TestDigest.testKatHex(new BLAKE224(), "988638219fd3095421f826f56e4f09e356296b628c3ce6930c9f2e758fd1a80c8273f2f61e4daae65c4f110d3e7ca0965ac7d24e34c0dc4ba2d6ff0bf5bbe93b3585f354d7543cb542a1aa54674d375077f2d360a8f4d42f3db131c3b7ab7306267ba107659864a90c8c909460a73621d1f5d9d3fd95beb19b23db1cb6c0d0fba91d36891529b8bd8263caa1bab56a4affaed44962df096d8d5b1eb845ef31188b3e10f1af811a13f156beb7a288aae593ebd1471b624aa1a7c6adf01e2200b3d72d88a3aed3100c88231e41efc376906f0b580dc895f080fda5741db1cb", "b6186f541025f3bce6e212a5022d867df846cad81b5f336e40e7d27c");
        TestDigest.testKatHex(new BLAKE224(), "5aab62756d307a669d146aba988d9074c5a159b3de85151a819b117ca1ff6597f6156e80fdd28c9c3176835164d37da7da11d94e09add770b68a6e081cd22ca0c004bfe7cd283bf43a588da91f509b27a6584c474a4a2f3ee0f1f56447379240a5ab1fb77fdca49b305f07ba86b62756fb9efb4fc225c86845f026ea542076b91a0bc2cdd136e122c659be259d98e5841df4c2f60330d4d8cdee7bf1a0a244524eecc68ff2aef5bf0069c9e87a11c6e519de1a4062a10c83837388f7ef58598a3846f49d499682b683c4a062b421594fafbc1383c943ba83bdef515efcf10d", "ded6dbd3e6f76bdb41c0830c8bb97ccc381d55aee625c5b025330eda");
        TestDigest.testKatHex(new BLAKE224(), "47b8216aa0fbb5d67966f2e82c17c07aa2d6327e96fcd83e3de7333689f3ee79994a1bf45082c4d725ed8d41205cb5bcdf5c341f77facb1da46a5b9b2cbc49eadf786bcd881f371a95fa17df73f606519aea0ff79d5a11427b98ee7f13a5c00637e2854134691059839121fea9abe2cd1bcbbbf27c74caf3678e05bfb1c949897ea01f56ffa4dafbe8644611685c617a3206c7a7036e4ac816799f693dafe7f19f303ce4eba09d21e03610201bfc665b72400a547a1e00fa9b7ad8d84f84b34aef118515e74def11b9188bd1e1f97d9a12c30132ec2806339bdadacda2fd8b78", "b61fd9189e3a650f3797d61333ddd4c7000353fd2d08a2cae74e6802");
        TestDigest.testKatHex(new BLAKE224(), "8cff1f67fe53c098896d9136389bd8881816ccab34862bb67a656e3d98896f3ce6ffd4da73975809fcdf9666760d6e561c55238b205d8049c1cedeef374d1735daa533147bfa960b2cce4a4f254176bb4d1bd1e89654432b8dbe1a135c42115b394b024856a2a83dc85d6782be4b444239567ccec4b184d4548eae3ff6a192f343292ba2e32a0f267f31cc26719eb85245d415fb897ac2da433ee91a99424c9d7f1766a44171d1651001c38fc79294accc68ceb5665d36218454d3ba169ae058a831338c17743603f81ee173bfc0927464f9bd728dee94c6aeab7aae6ee3a627e8", "2be3a2cc7e9269f43bedf51afefa323c6ac76d97a9124c4e8fe7755f");
        TestDigest.testKatHex(new BLAKE224(), "eacd07971cff9b9939903f8c1d8cbb5d4db1b548a85d04e037514a583604e787f32992bf2111b97ac5e8a938233552731321522ab5e8583561260b7d13ebeef785b23a41fd8576a6da764a8ed6d822d4957a545d5244756c18aa80e1aad4d1f9c20d259dee1711e2cc8fd013169fb7cc4ce38b362f8e0936ae9198b7e838dcea4f7a5b9429bb3f6bbcf2dc92565e3676c1c5e6eb3dd2a0f86aa23edd3d0891f197447692794b3dfa269611ad97f72b795602b4fdb198f3fd3eb41b415064256e345e8d8c51c555dc8a21904a9b0f1ad0effab7786aac2da3b196507e9f33ca356427", "522b2b66dd380adbc5f5c8f33bf9a9c722e9861ac272529fc6a654ba");
        TestDigest.testKatHex(new BLAKE224(), "23ac4e9a42c6ef45c3336ce6dfc2ff7de8884cd23dc912fef0f7756c09d335c189f3ad3a23697abda851a81881a0c8ccafc980ab2c702564c2be15fe4c4b9f10dfb2248d0d0cb2e2887fd4598a1d4acda897944a2ffc580ff92719c95cf2aa42dc584674cb5a9bc5765b9d6ddf5789791d15f8dd925aa12bffafbce60827b490bb7df3dda6f2a143c8bf96abc903d83d59a791e2d62814a89b8080a28060568cf24a80ae61179fe84e0ffad00388178cb6a617d37efd54cc01970a4a41d1a8d3ddce46edbba4ab7c90ad565398d376f431189ce8c1c33e132feae6a8cd17a61c630012", "b0502c0b1fa9f74c28cc94a25fdeec5a8a7c73fd97df6fd297e09a7a");
        TestDigest.testKatHex(new BLAKE224(), "0172df732282c9d488669c358e3492260cbe91c95cfbc1e3fea6c4b0ec129b45f242ace09f152fc6234e1bee8aab8cd56e8b486e1dcba9c05407c2f95da8d8f1c0af78ee2ed82a3a79ec0cb0709396ee62aadb84f8a4ee8a7ccca3c1ee84e302a09ea802204afecf04097e67d0f8e8a9d2651126c0a598a37081e42d168b0ae8a71951c524259e4e2054e535b779679bdade566fe55700858618e626b4a0faf895bcce9011504a49e05fd56127eae3d1f8917afb548ecadabda1020111fec9314c413498a360b08640549a22cb23c731ace743252a8227a0d2689d4c6001606678dfb921", "3f27bd57b2490c04cd5e9762bdd673568019fed84776271a6929d744");
        TestDigest.testKatHex(new BLAKE224(), "3875b9240cf3e0a8b59c658540f26a701cf188496e2c2174788b126fd29402d6a75453ba0635284d08835f40051a2a9683dc92afb9383719191231170379ba6f4adc816fecbb0f9c446b785bf520796841e58878b73c58d3ebb097ce4761fdeabe15de2f319dfbaf1742cdeb389559c788131a6793e193856661376c81ce9568da19aa6925b47ffd77a43c7a0e758c37d69254909ff0fbd415ef8eb937bcd49f91468b49974c07dc819abd67395db0e05874ff83dddab895344abd0e7111b2df9e58d76d85ad98106b36295826be04d435615595605e4b4bb824b33c4afeb5e7bb0d19f909", "c95184228ccbd3c08d13db3f08143d2f3769f95c9bd2a2cfadf33bb6");
        TestDigest.testKatHex(new BLAKE224(), "747cc1a59fefba94a9c75ba866c30dc5c1cb0c0f8e9361d98484956dd5d1a40f6184afbe3dac9f76028d1caeccfbf69199c6ce2b4c092a3f4d2a56fe5a33a00757f4d7dee5dfb0524311a97ae0668a47971b95766e2f6dd48c3f57841f91f04a00ad5ea70f2d479a2620dc5cd78eaab3a3b011719b7e78d19ddf70d9423798af77517ebc55392fcd01fc600d8d466b9e7a7a85bf33f9cc5419e9bd874ddfd60981150ddaf8d7febaa4374f0872a5628d318000311e2f5655365ad4d407c20e5c04df17a222e7deec79c5ab1116d8572f91cd06e1ccc7ced53736fc867fd49ecebe6bf8082e8a", "724d9895175c6faf7d967cd0ce42b1891e4490cfa4050d01a5e09171");
        TestDigest.testKatHex(new BLAKE224(), "57af971fccaec97435dc2ec9ef0429bcedc6b647729ea168858a6e49ac1071e706f4a5a645ca14e8c7746d65511620682c906c8b86ec901f3dded4167b3f00b06cbfac6aee3728051b3e5ff10b4f9ed8bd0b8da94303c833755b3ca3aeddf0b54bc8d6632138b5d25bab03d17b3458a9d782108006f5bb7de75b5c0ba854b423d8bb801e701e99dc4feaad59bc1c7112453b04d33ea3635639fb802c73c2b71d58a56bbd671b18fe34ed2e3dca38827d63fdb1d4fb3285405004b2b3e26081a8ff08cd6d2b08f8e7b7e90a2ab1ed7a41b1d0128522c2f8bff56a7fe67969422ce839a9d4608f03", "0e3d2ba44c92c860cdad5e1bd59283ff4e29a2c85966d019fe2a18cc");
        TestDigest.testKatHex(new BLAKE224(), "04e16dedc1227902baaf332d3d08923601bdd64f573faa1bb7201918cfe16b1e10151dae875da0c0d63c59c3dd050c4c6a874011b018421afc4623ab0381831b2da2a8ba42c96e4f70864ac44e106f94311051e74c77c1291bf5db9539e69567bf6a11cf6932bbbad33f8946bf5814c066d851633d1a513510039b349939bfd42b858c21827c8ff05f1d09b1b0765dc78a135b5ca4dfba0801bcaddfa175623c8b647eacfb4444b85a44f73890607d06d507a4f8393658788669f6ef4deb58d08c50ca0756d5e2f49d1a7ad73e0f0b3d3b5f090acf622b1878c59133e4a848e05153592ea81c6fbf", "520563ea5306a7d38f70d354e01d1480c75b3068aaa15a82251dcfea");
        TestDigest.testKatHex(new BLAKE224(), "7c815c384eee0f288ece27cced52a01603127b079c007378bc5d1e6c5e9e6d1c735723acbbd5801ac49854b2b569d4472d33f40bbb8882956245c366dc3582d71696a97a4e19557e41e54dee482a14229005f93afd2c4a7d8614d10a97a9dfa07f7cd946fa45263063ddd29db8f9e34db60daa32684f0072ea2a9426ecebfa5239fb67f29c18cbaa2af6ed4bf4283936823ac1790164fec5457a9cba7c767ca59392d94cab7448f50eb34e9a93a80027471ce59736f099c886dea1ab4cba4d89f5fc7ae2f21ccd27f611eca4626b2d08dc22382e92c1efb2f6afdc8fdc3d2172604f5035c46b8197d3", "3645cd6a519fcb81f17efaa99b7bd9d01202d7993396c57ca70f87f2");
        TestDigest.testKatHex(new BLAKE224(), "e29d505158dbdd937d9e3d2145658ee6f5992a2fc790f4f608d9cdb44a091d5b94b88e81fac4fdf5c49442f13b911c55886469629551189eaff62488f1a479b7db11a1560e198ddccccf50159093425ff7f1cb8d1d1246d0978764087d6bac257026b090efae8cec5f22b6f21c59ace1ac7386f5b8837ca6a12b6fbf5534dd0560ef05ca78104d3b943ddb220feaec89aa5e692a00f822a2ab9a2fe60350d75e7be16ff2526dc643872502d01f42f188abed0a6e9a6f5fd0d1ce7d5755c9ffa66b0af0b20bd806f08e06156690d81ac811778ca3dac2c249b96002017fce93e507e3b953acf99964b847", "798643fba1baef01484259cbf0f6b379bc3f39c364539edcbdcc512f");
        TestDigest.testKatHex(new BLAKE224(), "d85588696f576e65eca0155f395f0cfacd83f36a99111ed5768df2d116d2121e32357ba4f54ede927f189f297d3a97fad4e9a0f5b41d8d89dd7fe20156799c2b7b6bf9c957ba0d6763f5c3bc5129747bbb53652b49290cff1c87e2cdf2c4b95d8aaee09bc8fbfa6883e62d237885810491bfc101f1d8c636e3d0ede838ad05c207a3df4fad76452979eb99f29afaecedd1c63b8d36cf378454a1bb67a741c77ac6b6b3f95f4f02b64dabc15438613ea49750df42ee90101f115aa9abb9ff64324dde9dabbb01054e1bd6b4bcdc7930a44c2300d87ca78c06924d0323ad7887e46c90e8c4d100acd9eed21e", "fdaf33d61ed95d7a1d7ef5eab40281fb3b42826ab280e54d35036f54");
        TestDigest.testKatHex(new BLAKE224(), "3a12f8508b40c32c74492b66323375dcfe49184c78f73179f3314b79e63376b8ac683f5a51f1534bd729b02b04d002f55cbd8e8fc9b5ec1ea6bbe6a0d0e7431518e6ba45d124035f9d3dce0a8bb7bf1430a9f657e0b4ea9f20eb20c786a58181a1e20a96f1628f8728a13bdf7a4b4b32fc8aa7054cc4881ae7fa19afa65c6c3ee1b3ade3192af42054a8a911b8ec1826865d46d93f1e7c5e2b7813c92a506e53886f3d4701bb93d2a681ad109c845904bb861af8af0646b6e399b38b614051d34f6842563a0f37ec00cb3d865fc5d746c4987de2a65071100883a2a9c7a2bfe1e2dd603d9ea24dc7c5fd06be", "0fb66fd71295b047bb35514a6096a011064b8e4d060693180129f906");
        TestDigest.testKatHex(new BLAKE224(), "1861edce46fa5ad17e1ff1deae084dec580f97d0a67885dfe834b9dfac1ae076742ce9e267512ca51f6df5a455af0c5fd6abf94acea103a3370c354485a7846fb84f3ac7c2904b5b2fbf227002ce512133bb7e1c4e50057bfd1e44db33c7cdb969a99e284b184f50a14b068a1fc5009d9b298dbe92239572a7627aac02abe8f3e3b473417f36d4d2505d16b7577f4526c9d94a270a2dfe450d06da8f6fa956879a0a55cfe99e742ea555ea477ba3e9b44ccd508c375423611af92e55345dc215779b2d5119eba49c71d49b9fe3f1569fa24e5ca3e332d042422a8b8158d3ec66a80012976f31ffdf305f0c9c5e", "55a61d468fadfa190471bdcb50da9b6fea110ac8fd7c992c3af26b83");
        TestDigest.testKatHex(new BLAKE224(), "08d0ffde3a6e4ef65608ea672e4830c12943d7187ccff08f4941cfc13e545f3b9c7ad5eebbe2b01642b486caf855c2c73f58c1e4e3391da8e2d63d96e15fd84953ae5c231911b00ad6050cd7aafdaac9b0f663ae6aab45519d0f5391a541707d479034e73a6ad805ae3598096af078f1393301493d663dd71f83869ca27ba508b7e91e81e128c1716dc3acfe3084b2201e04cf8006617eecf1b640474a5d45cfde9f4d3ef92d6d055b909892194d8a8218db6d8203a84261d200d71473d7488f3427416b6896c137d455f231071cacbc86e0415ab88aec841d96b7b8af41e05bb461a40645bf176601f1e760de5f", "3480c7b5f1e2b262610f3de4e6ce14df140dba474f7e01e9825e2a1d");
        TestDigest.testKatHex(new BLAKE224(), "d782abb72a5be3392757be02d3e45be6e2099d6f000d042c8a543f50ed6ebc055a7f133b0dd8e9bc348536edcaae2e12ec18e8837df7a1b3c87ec46d50c241dee820fd586197552dc20beea50f445a07a38f1768a39e2b2ff05dddedf751f1def612d2e4d810daa3a0cc904516f9a43af660315385178a529e51f8aae141808c8bc5d7b60cac26bb984ac1890d0436ef780426c547e94a7b08f01acbfc4a3825eae04f520a9016f2fb8bf5165ed12736fc71e36a49a73614739eaa3ec834069b1b40f1350c2b3ab885c02c640b9f7686ed5f99527e41cfcd796fe4c256c9173186c226169ff257954ebda81c0e5f99", "2bd55e6119119b79a3169ef9505d65165ebd09f07f8c38e138b3ba28");
        TestDigest.testKatHex(new BLAKE224(), "5fce8109a358570e40983e1184e541833bb9091e280f258cfb144387b05d190e431cb19baa67273ba0c58abe91308e1844dcd0b3678baa42f335f2fa05267a0240b3c718a5942b3b3e3bfa98a55c25a1466e8d7a603722cb2bbf03afa54cd769a99f310735ee5a05dae2c22d397bd95635f58c48a67f90e1b73aafcd3f82117f0166657838691005b18da6f341d6e90fc1cdb352b30fae45d348294e501b63252de14740f2b85ae5299ddec3172de8b6d0ba219a20a23bb5e10ff434d39db3f583305e9f5c039d98569e377b75a70ab837d1df269b8a4b566f40bb91b577455fd3c356c914fa06b9a7ce24c7317a172d", "3335560c444a5966883b34bce6407710888ca8e7a7fbc4dd0ec8c05f");
        TestDigest.testKatHex(new BLAKE224(), "6172f1971a6e1e4e6170afbad95d5fec99bf69b24b674bc17dd78011615e502de6f56b86b1a71d3f4348087218ac7b7d09302993be272e4a591968aef18a1262d665610d1070ee91cc8da36e1f841a69a7a682c580e836941d21d909a3afc1f0b963e1ca5ab193e124a1a53df1c587470e5881fb54dae1b0d840f0c8f9d1b04c645ba1041c7d8dbf22030a623aa15638b3d99a2c400ff76f3252079af88d2b37f35ee66c1ad7801a28d3d388ac450b97d5f0f79e4541755356b3b1a5696b023f39ab7ab5f28df4202936bc97393b93bc915cb159ea1bd7a0a414cb4b7a1ac3af68f50d79f0c9c7314e750f7d02faa58bfa", "9b4f36f6572512604ab8f21e0361a3f1cfcb4a39a73e8feebd0c67b9");
        TestDigest.testKatHex(new BLAKE224(), "5668ecd99dfbe215c4118398ac9c9eaf1a1433fab4ccdd3968064752b625ea944731f75d48a27d047d67547f14dd0ffaa55fa5e29f7af0d161d85eafc4f2029b717c918eab9d304543290bdba7158b68020c0ba4e079bc95b5bc0fc044a992b94b4ccd3bd66d0eabb5dbbab904d62e00752c4e3b0091d773bcf4c14b4377da3efff824b1cb2fa01b32d1e46c909e626ed2dae920f4c7dbeb635bc754facbd8d49beba3f23c1c41ccbfcd0ee0c114e69737f5597c0bf1d859f0c767e18002ae8e39c26261ffde2920d3d0baf0e906138696cfe5b7e32b600f45df3aaa39932f3a7df95b60fa8712a2271fcaf3911ce7b511b1", "e09b068b065a1ad2d69e15d3c81b13a1f05014c7015cfad3adb23d06");
        TestDigest.testKatHex(new BLAKE224(), "03d625488354df30e3f875a68edfcf340e8366a8e1ab67f9d5c5486a96829dfac0578289082b2a62117e1cf418b43b90e0adc881fc6ae8105c888e9ecd21aea1c9ae1a4038dfd17378fed71d02ae492087d7cdcd98f746855227967cb1ab4714261ee3bead3f4db118329d3ebef4bc48a875c19ba763966da0ebea800e01b2f50b00e9dd4caca6dcb314d00184ef71ea2391d760c950710db4a70f9212ffc54861f9dc752ce18867b8ad0c48df8466ef7231e7ac567f0eb55099e622ebb86cb237520190a61c66ad34f1f4e289cb3282ae3eaac6152ed24d2c92bae5a7658252a53c49b7b02dfe54fdb2e90074b6cf310ac661", "a3652f19cfacd803b9cb78fd2c34294f9252e1e85b5271eb8f2da957");
        TestDigest.testKatHex(new BLAKE224(), "2edc282ffb90b97118dd03aaa03b145f363905e3cbd2d50ecd692b37bf000185c651d3e9726c690d3773ec1e48510e42b17742b0b0377e7de6b8f55e00a8a4db4740cee6db0830529dd19617501dc1e9359aa3bcf147e0a76b3ab70c4984c13e339e6806bb35e683af8527093670859f3d8a0fc7d493bcba6bb12b5f65e71e705ca5d6c948d66ed3d730b26db395b3447737c26fad089aa0ad0e306cb28bf0acf106f89af3745f0ec72d534968cca543cd2ca50c94b1456743254e358c1317c07a07bf2b0eca438a709367fafc89a57239028fc5fecfd53b8ef958ef10ee0608b7f5cb9923ad97058ec067700cc746c127a61ee3", "5ce3d83f9cb3fa00716574c930d72a762c825ee0230e859488c6989e");
        TestDigest.testKatHex(new BLAKE224(), "90b28a6aa1fe533915bcb8e81ed6cacdc10962b7ff82474f845eeb86977600cf70b07ba8e3796141ee340e3fce842a38a50afbe90301a3bdcc591f2e7d9de53e495525560b908c892439990a2ca2679c5539ffdf636777ad9c1cdef809cda9e8dcdb451abb9e9c17efa4379abd24b182bd981cafc792640a183b61694301d04c5b3eaad694a6bd4cc06ef5da8fa23b4fa2a64559c5a68397930079d250c51bcf00e2b16a6c49171433b0aadfd80231276560b80458dd77089b7a1bbcc9e7e4b9f881eacd6c92c4318348a13f4914eb27115a1cfc5d16d7fd94954c3532efaca2cab025103b2d02c6fd71da3a77f417d7932685888a", "68905f7e7d84b777bb51ec92cd9a6534cd2b0b25a6cfeddd228b434b");
        TestDigest.testKatHex(new BLAKE224(), "2969447d175490f2aa9bb055014dbef2e6854c95f8d60950bfe8c0be8de254c26b2d31b9e4de9c68c9adf49e4ee9b1c2850967f29f5d08738483b417bb96b2a56f0c8aca632b552059c59aac3f61f7b45c966b75f1d9931ff4e596406378cee91aaa726a3a84c33f37e9cdbe626b5745a0b06064a8a8d56e53aaf102d23dd9df0a3fdf7a638509a6761a33fa42fa8ddbd8e16159c93008b53765019c3f0e9f10b144ce2ac57f5d7297f9c9949e4ff68b70d339f87501ce8550b772f32c6da8ad2ce2100a895d8b08fa1eead7c376b407709703c510b50f87e73e43f8e7348f87c3832a547ef2bbe5799abedcf5e1f372ea809233f006", "702a18bdb11e6968b05fd27fcb3d427d616f87d7982a088426a2b2e8");
        TestDigest.testKatHex(new BLAKE224(), "721645633a44a2c78b19024eaecf58575ab23c27190833c26875dc0f0d50b46aea9c343d82ea7d5b3e50ec700545c615daeaea64726a0f05607576dcd396d812b03fb6551c641087856d050b10e6a4d5577b82a98afb89cee8594c9dc19e79feff0382fcfd127f1b803a4b9946f4ac9a4378e1e6e041b1389a53e3450cd32d9d2941b0cbabdb50da8ea2513145164c3ab6bcbd251c448d2d4b087ac57a59c2285d564f16da4ed5e607ed979592146ffb0ef3f3db308fb342df5eb5924a48256fc763141a278814c82d6d6348577545870ae3a83c7230ac02a1540fe1798f7ef09e335a865a2ae0949b21e4f748fb8a51f44750e213a8fb", "b81ef103ac364626d9f9ed68346301df146f073322b05a1a283de76e");
        TestDigest.testKatHex(new BLAKE224(), "6b860d39725a14b498bb714574b4d37ca787404768f64c648b1751b353ac92bac2c3a28ea909fdf0423336401a02e63ec24325300d823b6864bb701f9d7c7a1f8ec9d0ae3584aa6dd62ea1997cd831b4babd9a4da50932d4efda745c61e4130890e156aee6113716daf95764222a91187db2effea49d5d0596102d619bd26a616bbfda8335505fbb0d90b4c180d1a2335b91538e1668f9f9642790b4e55f9cab0fe2bdd2935d001ee6419abab5457880d0dbff20ed8758f4c20fe759efb33141cf0e892587fe8187e5fbc57786b7e8b089612c936dfc03d27efbbe7c8673f1606bd51d5ff386f4a7ab68edf59f385eb1291f117bfe717399", "a8357307df9172fce18966660de7b7646abb4ba58d8df91a1307003a");
        TestDigest.testKatHex(new BLAKE224(), "6a01830af3889a25183244decb508bd01253d5b508ab490d3124afbf42626b2e70894e9b562b288d0a2450cfacf14a0ddae5c04716e5a0082c33981f6037d23d5e045ee1ef2283fb8b6378a914c5d9441627a722c282ff452e25a7ea608d69cee4393a0725d17963d0342684f255496d8a18c2961145315130549311fc07f0312fb78e6077334f87eaa873bee8aa95698996eb21375eb2b4ef53c14401207deb4568398e5dd9a7cf97e8c9663e23334b46912f8344c19efcf8c2ba6f04325f1a27e062b62a58d0766fc6db4d2c6a1928604b0175d872d16b7908ebc041761187cc785526c2a3873feac3a642bb39f5351550af9770c328af7b", "35e77d1506e53d2ffeb94f210c76f981804693673c1c1bf62438adb6");
        TestDigest.testKatHex(new BLAKE224(), "b3c5e74b69933c2533106c563b4ca20238f2b6e675e8681e34a389894785bdade59652d4a73d80a5c85bd454fd1e9ffdad1c3815f5038e9ef432aac5c3c4fe840cc370cf86580a6011778bbedaf511a51b56d1a2eb68394aa299e26da9ada6a2f39b9faff7fba457689b9c1a577b2a1e505fdf75c7a0a64b1df81b3a356001bf0df4e02a1fc59f651c9d585ec6224bb279c6beba2966e8882d68376081b987468e7aed1ef90ebd090ae825795cdca1b4f09a979c8dfc21a48d8a53cdbb26c4db547fc06efe2f9850edd2685a4661cb4911f165d4b63ef25b87d0a96d3dff6ab0758999aad214d07bd4f133a6734fde445fe474711b69a98f7e2b", "7a8681be6389dbe00532ceb80a3be34e3b52581ee49048a6d7468d41");
        TestDigest.testKatHex(new BLAKE224(), "83af34279ccb5430febec07a81950d30f4b66f484826afee7456f0071a51e1bbc55570b5cc7ec6f9309c17bf5befdd7c6ba6e968cf218a2b34bd5cf927ab846e38a40bbd81759e9e33381016a755f699df35d660007b5eadf292feefb735207ebf70b5bd17834f7bfa0e16cb219ad4af524ab1ea37334aa66435e5d397fc0a065c411ebbce32c240b90476d307ce802ec82c1c49bc1bec48c0675ec2a6c6f3ed3e5b741d13437095707c565e10d8a20b8c20468ff9514fcf31b4249cd82dcee58c0a2af538b291a87e3390d737191a07484a5d3f3fb8c8f15ce056e5e5f8febe5e1fb59d6740980aa06ca8a0c20f5712b4cde5d032e92ab89f0ae1", "2f692b3e48ed1851ec18067d4b4ee41115fa1de84b2e29a83f85e78a");
        TestDigest.testKatHex(new BLAKE224(), "a7ed84749ccc56bb1dfba57119d279d412b8a986886d810f067af349e8749e9ea746a60b03742636c464fc1ee233acc52c1983914692b64309edfdf29f1ab912ec3e8da074d3f1d231511f5756f0b6eead3e89a6a88fe330a10face267bffbfc3e3090c7fd9a850561f363ad75ea881e7244f80ff55802d5ef7a1a4e7b89fcfa80f16df54d1b056ee637e6964b9e0ffd15b6196bdd7db270c56b47251485348e49813b4eb9ed122a01b3ea45ad5e1a929df61d5c0f3e77e1fdc356b63883a60e9cbb9fc3e00c2f32dbd469659883f690c6772e335f617bc33f161d6f6984252ee12e62b6000ac5231e0c9bc65be223d8dfd94c5004a101af9fd6c0fb", "bd2bfcd3fff1affb8eb55a559e472c1fc93898d78072879ed67ce1dd");
        TestDigest.testKatHex(new BLAKE224(), "a6fe30dcfcda1a329e82ab50e32b5f50eb25c873c5d2305860a835aecee6264aa36a47429922c4b8b3afd00da16035830edb897831c4e7b00f2c23fc0b15fdc30d85fb70c30c431c638e1a25b51caf1d7e8b050b7f89bfb30f59f0f20fecff3d639abc4255b3868fc45dd81e47eb12ab40f2aac735df5d1dc1ad997cefc4d836b854cee9ac02900036f3867fe0d84afff37bde3308c2206c62c4743375094108877c73b87b2546fe05ea137bedfc06a2796274099a0d554da8f7d7223a48cbf31b7decaa1ebc8b145763e3673168c1b1b715c1cd99ecd3ddb238b06049885ecad9347c2436dff32c771f34a38587a44a82c5d3d137a03caa27e66c8ff6", "80a744e348689673d0ac725370356f5607b36fb4a1f625342e02cf8b");
        TestDigest.testKatHex(new BLAKE224(), "83167ff53704c3aa19e9fb3303539759c46dd4091a52ddae9ad86408b69335989e61414bc20ab4d01220e35241eff5c9522b079fba597674c8d716fe441e566110b6211531ceccf8fd06bc8e511d00785e57788ed9a1c5c73524f01830d2e1148c92d0edc97113e3b7b5cd3049627abdb8b39dd4d6890e0ee91993f92b03354a88f52251c546e64434d9c3d74544f23fb93e5a2d2f1fb15545b4e1367c97335b0291944c8b730ad3d4789273fa44fb98d78a36c3c3764abeeac7c569c1e43a352e5b770c3504f87090dee075a1c4c85c0c39cf421bdcc615f9eff6cb4fe6468004aece5f30e1ecc6db22ad9939bb2b0ccc96521dfbf4ae008b5b46bc006e", "a1bf53a5c5f1c87d0ebf2ae39493085e59bd4cb7228a4ecffefeb853");
        TestDigest.testKatHex(new BLAKE224(), "3a3a819c48efde2ad914fbf00e18ab6bc4f14513ab27d0c178a188b61431e7f5623cb66b23346775d386b50e982c493adbbfc54b9a3cd383382336a1a0b2150a15358f336d03ae18f666c7573d55c4fd181c29e6ccfde63ea35f0adf5885cfc0a3d84a2b2e4dd24496db789e663170cef74798aa1bbcd4574ea0bba40489d764b2f83aadc66b148b4a0cd95246c127d5871c4f11418690a5ddf01246a0c80a43c70088b6183639dcfda4125bd113a8f49ee23ed306faac576c3fb0c1e256671d817fc2534a52f5b439f72e424de376f4c565cca82307dd9ef76da5b7c4eb7e085172e328807c02d011ffbf33785378d79dc266f6a5be6bb0e4a92eceebaeb1", "0fea9a7d9165d6d66031af59e57dae69e92dbf9601f7f752c1f771f6");
        TestDigest.reportSuccess("BLAKE-224");
    }

    private static void testBLAKE256() {
        TestDigest.testKatHex(new BLAKE256(), "", "716f6e863f744b9ac22c97ec7b76ea5f5908bc5b2f67c61510bfc4751384ea7a");
        TestDigest.testKatHex(new BLAKE256(), "cc", "e104256a2bc501f459d03fac96b9014f593e22d30f4de525fa680c3aa189eb4f");
        TestDigest.testKatHex(new BLAKE256(), "41fb", "8f341148be7e354fdf38b693d8c6b4e0bd57301a734f6fd35cd85b8491c3ddcd");
        TestDigest.testKatHex(new BLAKE256(), "1f877c", "bc334d1069099f10c601883ac6f3e7e9787c6aa53171f76a21923cc5ad3ab937");
        TestDigest.testKatHex(new BLAKE256(), "c1ecfdfc", "b672a16f53982bab1e77685b71c0a5f6703ffd46a1c834be69f614bd128d658e");
        TestDigest.testKatHex(new BLAKE256(), "21f134ac57", "d9134b2899057a7d8d320cc99e3e116982bc99d3c69d260a7f1ed3da8be68d99");
        TestDigest.testKatHex(new BLAKE256(), "c6f50bb74e29", "637923bd29a35aa3ecbbd2a50549fc32c14cf0fdcaf41c3194dd7414fd224815");
        TestDigest.testKatHex(new BLAKE256(), "119713cc83eeef", "70c092fd5c8c21e9ef4bbc82a5c7819e262a530a748caf285ff0cba891954f1e");
        TestDigest.testKatHex(new BLAKE256(), "4a4f202484512526", "fdf092993edbb7a0dc7ca67f04051bbd14481639da0808947aff8bfab5abed4b");
        TestDigest.testKatHex(new BLAKE256(), "1f66ab4185ed9b6375", "6f6fc234bf35beae1a366c44c520c59ad5aa70351b5f5085e21e1fe2bfcee709");
        TestDigest.testKatHex(new BLAKE256(), "eed7422227613b6f53c9", "4fdaf89e2a0e78c000061b59455e0ea93a4445b440e7562c8f0cfa165c93de2e");
        TestDigest.testKatHex(new BLAKE256(), "eaeed5cdffd89dece455f1", "d6b780eee9c811f664393dc2c58b5a68c92b3c9fe9ceb70371d33ece63b5787e");
        TestDigest.testKatHex(new BLAKE256(), "5be43c90f22902e4fe8ed2d3", "d0015071d3e7ed048c764850d76406eceae52b8e2e6e5a2c3aa92ae880485b34");
        TestDigest.testKatHex(new BLAKE256(), "a746273228122f381c3b46e4f1", "9b0207902f9932f7a85c24722e93e31f6ed2c75c406509aa0f2f6d1cab046ce4");
        TestDigest.testKatHex(new BLAKE256(), "3c5871cd619c69a63b540eb5a625", "258020d5b04a814f2b72c1c661e1f5a5c395d9799e5eee8b8519cf7300e90cb1");
        TestDigest.testKatHex(new BLAKE256(), "fa22874bcc068879e8ef11a69f0722", "4adae3b55baa907fefc253365fdd99d8398befd0551ed6bf9a2a2784d3c304d1");
        TestDigest.testKatHex(new BLAKE256(), "52a608ab21ccdd8a4457a57ede782176", "6dd10d772f8d5b4a96c3c5d30878cd9a1073fa835bfe6d2b924fa64a1fab1711");
        TestDigest.testKatHex(new BLAKE256(), "82e192e4043ddcd12ecf52969d0f807eed", "0b8741ddf2259d3af2901eb1ae354f22836442c965556f5c1eb89501191cb46a");
        TestDigest.testKatHex(new BLAKE256(), "75683dcb556140c522543bb6e9098b21a21e", "f48a754ca8193a82643150ab94038b5dd170b4ebd1e0751b78cfb0a98fa5076a");
        TestDigest.testKatHex(new BLAKE256(), "06e4efe45035e61faaf4287b4d8d1f12ca97e5", "5698409ab856b74d9fa5e9b259dfa46001f89041752da424e56e491577b88c86");
        TestDigest.testKatHex(new BLAKE256(), "e26193989d06568fe688e75540aea06747d9f851", "31d27842634441f452ef6f7319e43c864f9543f04c8dee0bdf02632d20afc2a6");
        TestDigest.testKatHex(new BLAKE256(), "d8dc8fdefbdce9d44e4cbafe78447bae3b5436102a", "924c3797a6d97bc2dcbe905e3922b12f4c97bfd1390056678918284da530b37f");
        TestDigest.testKatHex(new BLAKE256(), "57085fd7e14216ab102d8317b0cb338a786d5fc32d8f", "3e5dc9922f82da4b51d2bb202962977fc17546b901335c7ef4e074e8e6b6fadb");
        TestDigest.testKatHex(new BLAKE256(), "a05404df5dbb57697e2c16fa29defac8ab3560d6126fa0", "efdce9ccc566aa560d77a0c6703694a1136af9b119add173d4923cefc5f4feb1");
        TestDigest.testKatHex(new BLAKE256(), "aecbb02759f7433d6fcb06963c74061cd83b5b3ffa6f13c6", "bec6b97cc2a873239da37eae2d50a4e6a29de228e68c40d8ad5f5fe0dd139fa2");
        TestDigest.testKatHex(new BLAKE256(), "aafdc9243d3d4a096558a360cc27c8d862f0be73db5e88aa55", "7d10e374784c9275627a6d3401b75216af415a228b40e2c36b113777bb90831c");
        TestDigest.testKatHex(new BLAKE256(), "7bc84867f6f9e9fdc3e1046cae3a52c77ed485860ee260e30b15", "8db764ebced55e0fff19a82119c5a3d47a0fb19fc7e1a021d0d0425f5db8b193");
        TestDigest.testKatHex(new BLAKE256(), "fac523575a99ec48279a7a459e98ff901918a475034327efb55843", "9149f241af9b134bb2fb970bd4586b0ff59de17202706b470d58ca7a4f86e0c2");
        TestDigest.testKatHex(new BLAKE256(), "0f8b2d8fcfd9d68cffc17ccfb117709b53d26462a3f346fb7c79b85e", "51331e6e7af3a193ed66a2e58e1f8610779196145622a458e57bc5f52ad78c0f");
        TestDigest.testKatHex(new BLAKE256(), "a963c3e895ff5a0be4824400518d81412f875fa50521e26e85eac90c04", "485f559159c58ccec696b756543a2f8b1c4490634b4ec31fb9b3d8913b59da95");
        TestDigest.testKatHex(new BLAKE256(), "03a18688b10cc0edf83adf0a84808a9718383c4070c6c4f295098699ac2c", "faf3b2da998fd51d4f6e359790c0bf533f806d39a00613662cf96ce2b09ff6ce");
        TestDigest.testKatHex(new BLAKE256(), "84fb51b517df6c5accb5d022f8f28da09b10232d42320ffc32dbecc3835b29", "6796cc8fd9960890bd42a6f139992ab9bcacc5a17672648ae3e5ce600652627e");
        TestDigest.testKatHex(new BLAKE256(), "9f2fcc7c90de090d6b87cd7e9718c1ea6cb21118fc2d5de9f97e5db6ac1e9c10", "bb603441f9cc752e780ebe371a02ec39bd810ffc7797dd49be728eb1fd50b384");
        TestDigest.testKatHex(new BLAKE256(), "de8f1b3faa4b7040ed4563c3b8e598253178e87e4d0df75e4ff2f2dedd5a0be046", "fede0ad668c6bb8d2d65cd65ef6ff6e1a2fa03b98e46e642e1ea1f23f356e330");
        TestDigest.testKatHex(new BLAKE256(), "62f154ec394d0bc757d045c798c8b87a00e0655d0481a7d2d9fb58d93aedc676b5a0", "ee9ade0ce8d1e864451dc8a79f3b36f7259d3f025eb0f405c2da609066408aad");
        TestDigest.testKatHex(new BLAKE256(), "b2dcfe9ff19e2b23ce7da2a4207d3e5ec7c6112a8a22aec9675a886378e14e5bfbad4e", "9d8fed5ecc492de1bb1d0932ea41d8e6e5bd0ff4b66047fcac179df9c1acd640");
        TestDigest.testKatHex(new BLAKE256(), "47f5697ac8c31409c0868827347a613a3562041c633cf1f1f86865a576e02835ed2c2492", "759a023d09a25e5f88770190df7dfad00cd34c3c236ff40bf4d95c0f81193851");
        TestDigest.testKatHex(new BLAKE256(), "512a6d292e67ecb2fe486bfe92660953a75484ff4c4f2eca2b0af0edcdd4339c6b2ee4e542", "47ef7975922884f5fa0567c4306984a92cb2e012565eeb3388994c5c62364e4d");
        TestDigest.testKatHex(new BLAKE256(), "973cf2b4dcf0bfa872b41194cb05bb4e16760a1840d8343301802576197ec19e2a1493d8f4fb", "73495ae2b0ab412f9f24c73613fb09ff676b9c2a39f2aa5c36f11154320a78bf");
        TestDigest.testKatHex(new BLAKE256(), "80beebcd2e3f8a9451d4499961c9731ae667cdc24ea020ce3b9aa4bbc0a7f79e30a934467da4b0", "fd40278998e7925a5beb6fef313edde96117af5249f54cad7659a3c13e82b714");
        TestDigest.testKatHex(new BLAKE256(), "7abaa12ec2a7347674e444140ae0fb659d08e1c66decd8d6eae925fa451d65f3c0308e29446b8ed3", "6ee3915a5d8fef80b03e4e3dab9072e4143330675525988450c54554d5e61c94");
        TestDigest.testKatHex(new BLAKE256(), "c88dee9927679b8af422abcbacf283b904ff31e1cac58c7819809f65d5807d46723b20f67ba610c2b7", "0c382ff250e6dee2569e5250a1f480b6accd0238f8d3840d9958fbd4d1160d8f");
        TestDigest.testKatHex(new BLAKE256(), "01e43fe350fcec450ec9b102053e6b5d56e09896e0ddd9074fe138e6038210270c834ce6eadc2bb86bf6", "d1efe8700d3d47a80a422fe86540a89f0e103fdead8848f616cfd3b939c29dd3");
        TestDigest.testKatHex(new BLAKE256(), "337023370a48b62ee43546f17c4ef2bf8d7ecd1d49f90bab604b839c2e6e5bd21540d29ba27ab8e309a4b7", "b14bb4c03111e62ee6751d1c35498835df566fddc5ed5b70d2849b453d436b64");
        TestDigest.testKatHex(new BLAKE256(), "6892540f964c8c74bd2db02c0ad884510cb38afd4438af31fc912756f3efec6b32b58ebc38fc2a6b913596a8", "75d95470d72557d86cad03967552b34d925f6e5e9be7e887b57d6d444ec93d70");
        TestDigest.testKatHex(new BLAKE256(), "f5961dfd2b1ffffda4ffbf30560c165bfedab8ce0be525845deb8dc61004b7db38467205f5dcfb34a2acfe96c0", "0d7c8efbee6b3fd4903e60c4ab19602c50b5020990ea248d98f5ad735103c541");
        TestDigest.testKatHex(new BLAKE256(), "ca061a2eb6ceed8881ce2057172d869d73a1951e63d57261384b80ceb5451e77b06cf0f5a0ea15ca907ee1c27eba", "473bb75be6e05c0b8155c3c6777b34497037a14b24c76ab2e1b1c1e9e4d468ce");
        TestDigest.testKatHex(new BLAKE256(), "1743a77251d69242750c4f1140532cd3c33f9b5ccdf7514e8584d4a5f9fbd730bcf84d0d4726364b9bf95ab251d9bb", "9fd55a16ed058649ecb835bed965f32fc9ed16c4a1c1bafd3f1bebc258ff9fc1");
        TestDigest.testKatHex(new BLAKE256(), "d8faba1f5194c4db5f176fabfff856924ef627a37cd08cf55608bba8f1e324d7c7f157298eabc4dce7d89ce5162499f9", "9d2b64fe62ad33552545a30c450cbe451c332d4bf6a859f24413782abd1258f1");
        TestDigest.testKatHex(new BLAKE256(), "be9684be70340860373c9c482ba517e899fc81baaa12e5c6d7727975d1d41ba8bef788cdb5cf4606c9c1c7f61aed59f97d", "b38fe07d9ab29794659b678ee6ec8501f23b4e7b5b81dff263429b0e70f1cd29");
        TestDigest.testKatHex(new BLAKE256(), "7e15d2b9ea74ca60f66c8dfab377d9198b7b16deb6a1ba0ea3c7ee2042f89d3786e779cf053c77785aa9e692f821f14a7f51", "b1457e6086ccc67cfb332325e3a3f4118ded982317798d4410c789b3b770baae");
        TestDigest.testKatHex(new BLAKE256(), "9a219be43713bd578015e9fda66c0f2d83cac563b776ab9f38f3e4f7ef229cb443304fba401efb2bdbd7ece939102298651c86", "866f44fbfba3978c7a161c11623c5197d3781987b4566b709cc00f11fde4f559");
        TestDigest.testKatHex(new BLAKE256(), "c8f2b693bd0d75ef99caebdc22adf4088a95a3542f637203e283bbc3268780e787d68d28cc3897452f6a22aa8573ccebf245972a", "abd55d3989f3fcd0d0b039fa5a1c8d03df1d65fdc049ac881c008d09235dba00");
        TestDigest.testKatHex(new BLAKE256(), "ec0f99711016c6a2a07ad80d16427506ce6f441059fd269442baaa28c6ca037b22eeac49d5d894c0bf66219f2c08e9d0e8ab21de52", "30c4f40c042a391b8c55fdbf5b2e76bc10df15d053748f39a2719601f99893c4");
        TestDigest.testKatHex(new BLAKE256(), "0dc45181337ca32a8222fe7a3bf42fc9f89744259cff653504d6051fe84b1a7ffd20cb47d4696ce212a686bb9be9a8ab1c697b6d6a33", "7670067cdbf1868e8bb82c9c73ee6cf39d3e6b2215fe481806e8234babc94c27");
        TestDigest.testKatHex(new BLAKE256(), "de286ba4206e8b005714f80fb1cdfaebde91d29f84603e4a3ebc04686f99a46c9e880b96c574825582e8812a26e5a857ffc6579f63742f", "ad373db6defaefbeeff69e78e220a4ca9ef510ad5f85f0c698a749e0e6dcaeb5");
        TestDigest.testKatHex(new BLAKE256(), "eebcc18057252cbf3f9c070f1a73213356d5d4bc19ac2a411ec8cdeee7a571e2e20eaf61fd0c33a0ffeb297ddb77a97f0a415347db66bcaf", "cad656a57a59591a03e7b540a1e5a76a7645a60228e1057ea39b34f6b691510d");
        TestDigest.testKatHex(new BLAKE256(), "416b5cdc9fe951bd361bd7abfc120a5054758eba88fdd68fd84e39d3b09ac25497d36b43cbe7b85a6a3cebda8db4e5549c3ee51bb6fcb6ac1e", "526fb1365175af61f6d33ee66c51f9eb67658742bd5ad827e3b3f12f535b8a3f");
        TestDigest.testKatHex(new BLAKE256(), "5c5faf66f32e0f8311c32e8da8284a4ed60891a5a7e50fb2956b3cbaa79fc66ca376460e100415401fc2b8518c64502f187ea14bfc9503759705", "f93ea4fbe593e41d458148486363b9436b0700c0407c05eb88403632bab1efa5");
        TestDigest.testKatHex(new BLAKE256(), "7167e1e02be1a7ca69d788666f823ae4eef39271f3c26a5cf7cee05bca83161066dc2e217b330df821103799df6d74810eed363adc4ab99f36046a", "ff39988c582120d695b00606757074841a75a3ed0f2cc7321858c2ff09085003");
        TestDigest.testKatHex(new BLAKE256(), "2fda311dbba27321c5329510fae6948f03210b76d43e7448d1689a063877b6d14c4f6d0eaa96c150051371f7dd8a4119f7da5c483cc3e6723c01fb7d", "94ba07439ed47e21b91ec7709c5605b116ef8caba952bdd27b1a9a0ca59aec4c");
        TestDigest.testKatHex(new BLAKE256(), "95d1474a5aab5d2422aca6e481187833a6212bd2d0f91451a67dd786dfc91dfed51b35f47e1deb8a8ab4b9cb67b70179cc26f553ae7b569969ce151b8d", "f0c7105f3b62d5fb78e82c1761809e9be1f44914f43c5bd96e7972ea6c3b7663");
        TestDigest.testKatHex(new BLAKE256(), "c71bd7941f41df044a2927a8ff55b4b467c33d089f0988aa253d294addbdb32530c0d4208b10d9959823f0c0f0734684006df79f7099870f6bf53211a88d", "34ff717bd5fdc5618ffc8da403a2f2359ecec9078f8c234f275d8cfaa39cc1d6");
        TestDigest.testKatHex(new BLAKE256(), "f57c64006d9ea761892e145c99df1b24640883da79d9ed5262859dcda8c3c32e05b03d984f1ab4a230242ab6b78d368dc5aaa1e6d3498d53371e84b0c1d4ba", "a17d2cdd3e3fd0aa2790ee8c3802606b46ae91b66db66684a56768fe52fb9760");
        TestDigest.testKatHex(new BLAKE256(), "e926ae8b0af6e53176dbffcc2a6b88c6bd765f939d3d178a9bde9ef3aa131c61e31c1e42cdfaf4b4dcde579a37e150efbef5555b4c1cb40439d835a724e2fae7", "f76305a1bb52917ce0882111f20f57eb51ee545cf064ce331a61d35ef17272c3");
        TestDigest.testKatHex(new BLAKE256(), "16e8b3d8f988e9bb04de9c96f2627811c973ce4a5296b4772ca3eefeb80a652bdf21f50df79f32db23f9f73d393b2d57d9a0297f7a2f2e79cfda39fa393df1ac00", "d184236acc1b11b65b13752dd97928519a8504391fd4c8389d3bec3583ece2ef");
        TestDigest.testKatHex(new BLAKE256(), "fc424eeb27c18a11c01f39c555d8b78a805b88dba1dc2a42ed5e2c0ec737ff68b2456d80eb85e11714fa3f8eabfb906d3c17964cb4f5e76b29c1765db03d91be37fc", "29b27ed19703a7d94f3d4262db1970d53d752a2e83ab494fcb8077aa7edbe2f3");
        TestDigest.testKatHex(new BLAKE256(), "abe3472b54e72734bdba7d9158736464251c4f21b33fbbc92d7fac9a35c4e3322ff01d2380cbaa4ef8fb07d21a2128b7b9f5b6d9f34e13f39c7ffc2e72e47888599ba5", "277bea584fc97d2eb1bc7ae14c0eafacb5baf03d7d865fcce5b9ef40908a6279");
        TestDigest.testKatHex(new BLAKE256(), "36f9f0a65f2ca498d739b944d6eff3da5ebba57e7d9c41598a2b0e4380f3cf4b479ec2348d015ffe6256273511154afcf3b4b4bf09d6c4744fdd0f62d75079d440706b05", "6e7a7bf2379339c004c0acdaa52aa71aea7496eb3e931b9d658427eb22767d77");
        TestDigest.testKatHex(new BLAKE256(), "abc87763cae1ca98bd8c5b82caba54ac83286f87e9610128ae4de68ac95df5e329c360717bd349f26b872528492ca7c94c2c1e1ef56b74dbb65c2ac351981fdb31d06c77a4", "ec6854b56c285e8b9a8a37aca30581d52e839c569a328f63b7aa07810f49cd68");
        TestDigest.testKatHex(new BLAKE256(), "94f7ca8e1a54234c6d53cc734bb3d3150c8ba8c5f880eab8d25fed13793a9701ebe320509286fd8e422e931d99c98da4df7e70ae447bab8cffd92382d8a77760a259fc4fbd72", "c1ddb90c5eab10a482fd25c9575505bd4f9ab3d991b026c8de55d314022eedb5");
        TestDigest.testKatHex(new BLAKE256(), "13bd2811f6ed2b6f04ff3895aceed7bef8dcd45eb121791bc194a0f806206bffc3b9281c2b308b1a729ce008119dd3066e9378acdcc50a98a82e20738800b6cddbe5fe9694ad6d", "975a4986c2af8cc6a1f807dbefa5b15ed433831e7d0d9b00c2628497ababcb6e");
        TestDigest.testKatHex(new BLAKE256(), "1eed9cba179a009ec2ec5508773dd305477ca117e6d569e66b5f64c6bc64801ce25a8424ce4a26d575b8a6fb10ead3fd1992edddeec2ebe7150dc98f63adc3237ef57b91397aa8a7", "ce7e64a7fea919ed5361e92e44579fadadbb95cbd10f87b538cd02f5a7468c00");
        TestDigest.testKatHex(new BLAKE256(), "ba5b67b5ec3a3ffae2c19dd8176a2ef75c0cd903725d45c9cb7009a900c0b0ca7a2967a95ae68269a6dbf8466c7b6844a1d608ac661f7eff00538e323db5f2c644b78b2d48de1a08aa", "007a1e2c31fbc056a9e7a994c8eebb9b01824506687f4b382064b10680f65886");
        TestDigest.testKatHex(new BLAKE256(), "0efa26ac5673167dcacab860932ed612f65ff49b80fa9ae65465e5542cb62075df1c5ae54fba4db807be25b070033efa223bdd5b1d3c94c6e1909c02b620d4b1b3a6c9fed24d70749604", "0289b40b14608a7ff9901b40d9ab66e7f434c42d3b7f4a6ed833903963493a29");
        TestDigest.testKatHex(new BLAKE256(), "bbfd933d1fd7bf594ac7f435277dc17d8d5a5b8e4d13d96d2f64e771abbd51a5a8aea741beccbddb177bcea05243ebd003cfdeae877cca4da94605b67691919d8b033f77d384ca01593c1b", "0d363cc0d3a7653228ccced5b7c1e0ed58d24e386bc18b578f6cf50e8289befb");
        TestDigest.testKatHex(new BLAKE256(), "90078999fd3c35b8afbf4066cbde335891365f0fc75c1286cdd88fa51fab94f9b8def7c9ac582a5dbcd95817afb7d1b48f63704e19c2baa4df347f48d4a6d603013c23f1e9611d595ebac37c", "6543286a4799a9f74a948a740fecfab6898517979bf3b77d2488cd037ea0e4a1");
        TestDigest.testKatHex(new BLAKE256(), "64105eca863515c20e7cfbaa0a0b8809046164f374d691cdbd6508aaabc1819f9ac84b52bafc1b0fe7cddbc554b608c01c8904c669d8db316a0953a4c68ece324ec5a49ffdb59a1bd6a292aa0e", "bd291ad3741aa3c69cc869a1eb81da30c98f5de0452734d00457cc979d86d5ee");
        TestDigest.testKatHex(new BLAKE256(), "d4654be288b9f3b711c2d02015978a8cc57471d5680a092aa534f7372c71ceaab725a383c4fcf4d8deaa57fca3ce056f312961eccf9b86f14981ba5bed6ab5b4498e1f6c82c6cae6fc14845b3c8a", "4e3dba974a3cdd4995c256a34ae01063c716e760d3602e785170f02127a72f85");
        TestDigest.testKatHex(new BLAKE256(), "12d9394888305ac96e65f2bf0e1b18c29c90fe9d714dd59f651f52b88b3008c588435548066ea2fc4c101118c91f32556224a540de6efddbca296ef1fb00341f5b01fecfc146bdb251b3bdad556cd2", "6d8b3ade529979111f8099a9fd1f0cd7fda3dd258a400b29846db8f5387de15e");
        TestDigest.testKatHex(new BLAKE256(), "871a0d7a5f36c3da1dfce57acd8ab8487c274fad336bc137ebd6ff4658b547c1dcfab65f037aa58f35ef16aff4abe77ba61f65826f7be681b5b6d5a1ea8085e2ae9cd5cf0991878a311b549a6d6af230", "917cf68371edab397f933efd7916f0fa18792cbbec331070259546c440de7daf");
        TestDigest.testKatHex(new BLAKE256(), "e90b4ffef4d457bc7711ff4aa72231ca25af6b2e206f8bf859d8758b89a7cd36105db2538d06da83bad5f663ba11a5f6f61f236fd5f8d53c5e89f183a3cec615b50c7c681e773d109ff7491b5cc22296c5", "73277049d2dcc2487a5fa342514de70032de1683d2f0e2f0253ce196f1fbf693");
        TestDigest.testKatHex(new BLAKE256(), "e728de62d75856500c4c77a428612cd804f30c3f10d36fb219c5ca0aa30726ab190e5f3f279e0733d77e7267c17be27d21650a9a4d1e32f649627638dbada9702c7ca303269ed14014b2f3cf8b894eac8554", "e6024aef25ca0a496e6f8fbd030dccb5b22306f3d71e37e51053156a880ec73c");
        TestDigest.testKatHex(new BLAKE256(), "6348f229e7b1df3b770c77544e5166e081850fa1c6c88169db74c76e42eb983facb276ad6a0d1fa7b50d3e3b6fcd799ec97470920a7abed47d288ff883e24ca21c7f8016b93bb9b9e078bdb9703d2b781b616e", "44405d0508518b43b3c33f2d8e526f0064ee26cc5572584e49e664c2846783b5");
        TestDigest.testKatHex(new BLAKE256(), "4b127fde5de733a1680c2790363627e63ac8a3f1b4707d982caea258655d9bf18f89afe54127482ba01e08845594b671306a025c9a5c5b6f93b0a39522dc877437be5c2436cbf300ce7ab6747934fcfc30aeaaf6", "039eed9e12e0b695cc70ba4fbbc8911a86c174d9165e12b8aa944d657e7aa65f");
        TestDigest.testKatHex(new BLAKE256(), "08461f006cff4cc64b752c957287e5a0faabc05c9bff89d23fd902d324c79903b48fcb8f8f4b01f3e4ddb483593d25f000386698f5ade7faade9615fdc50d32785ea51d49894e45baa3dc707e224688c6408b68b11", "6d40d076120ae4a5a5301fbc2fc5764f83fcfcfbb608738527b769108a33bb41");
        TestDigest.testKatHex(new BLAKE256(), "68c8f8849b120e6e0c9969a5866af591a829b92f33cd9a4a3196957a148c49138e1e2f5c7619a6d5edebe995acd81ec8bb9c7b9cfca678d081ea9e25a75d39db04e18d475920ce828b94e72241f24db72546b352a0e4", "f2490ed06e97f50bb209a748fa505982897f95814465e41dfa9daffd2f9bea32");
        TestDigest.testKatHex(new BLAKE256(), "b8d56472954e31fb54e28fca743f84d8dc34891cb564c64b08f7b71636debd64ca1edbdba7fc5c3e40049ce982bba8c7e0703034e331384695e9de76b5104f2fbc4535ecbeebc33bc27f29f18f6f27e8023b0fbb6f563c", "498f1736592b047b26080b6e1dc4e686cef4dce2929da83a8d140963cbb31068");
        TestDigest.testKatHex(new BLAKE256(), "0d58ac665fa84342e60cefee31b1a4eacdb092f122dfc68309077aed1f3e528f578859ee9e4cefb4a728e946324927b675cd4f4ac84f64db3dacfe850c1dd18744c74ceccd9fe4dc214085108f404eab6d8f452b5442a47d", "689723c496746815869c2b8f2771db492a60edfaacce29ded86e2b4d11ca5118");
        TestDigest.testKatHex(new BLAKE256(), "1755e2d2e5d1c1b0156456b539753ff416651d44698e87002dcf61dcfa2b4e72f264d9ad591df1fdee7b41b2eb00283c5aebb3411323b672eaa145c5125185104f20f335804b02325b6dea65603f349f4d5d8b782dd3469ccd", "bf958c62a4bdb72e1fed5cd0d68bed4b569557263183a622478d96c618f63f6a");
        TestDigest.testKatHex(new BLAKE256(), "b180de1a611111ee7584ba2c4b020598cd574ac77e404e853d15a101c6f5a2e5c801d7d85dc95286a1804c870bb9f00fd4dcb03aa8328275158819dcad7253f3e3d237aeaa7979268a5db1c6ce08a9ec7c2579783c8afc1f91a7", "5367368481ac046bf983f499552b0ca87b226350bd4cdf5023def4c6c7c7beb9");
        TestDigest.testKatHex(new BLAKE256(), "cf3583cbdfd4cbc17063b1e7d90b02f0e6e2ee05f99d77e24e560392535e47e05077157f96813544a17046914f9efb64762a23cf7a49fe52a0a4c01c630cfe8727b81fb99a89ff7cc11dca5173057e0417b8fe7a9efba6d95c555f", "c9019a4a6f1da3d76ef4008f08dd7bb4e01680142dc6789ede0cc735c02f7b86");
        TestDigest.testKatHex(new BLAKE256(), "072fc02340ef99115bad72f92c01e4c093b9599f6cfc45cb380ee686cb5eb019e806ab9bd55e634ab10aa62a9510cc0672cd3eddb589c7df2b67fcd3329f61b1a4441eca87a33c8f55da4fbbad5cf2b2527b8e983bb31a2fadec7523", "d8c82b3fa8f39d9f70e5149240a9b03272926621ab306af634e983bf0913cb3e");
        TestDigest.testKatHex(new BLAKE256(), "76eecf956a52649f877528146de33df249cd800e21830f65e90f0f25ca9d6540fde40603230eca6760f1139c7f268deba2060631eea92b1fff05f93fd5572fbe29579ecd48bc3a8d6c2eb4a6b26e38d6c5fbf2c08044aeea470a8f2f26", "714fac886919af28a9fa1be1eb1fdb19673814a676d739ebc3a141a48545f504");
        TestDigest.testKatHex(new BLAKE256(), "7adc0b6693e61c269f278e6944a5a2d8300981e40022f839ac644387bfac9086650085c2cdc585fea47b9d2e52d65a2b29a7dc370401ef5d60dd0d21f9e2b90fae919319b14b8c5565b0423cefb827d5f1203302a9d01523498a4db10374", "a5be5b53c877628fd0210e38cfc45cdb5612395ce320aef5be28a742a5d54c99");
        TestDigest.testKatHex(new BLAKE256(), "e1fffa9826cce8b86bccefb8794e48c46cdf372013f782eced1e378269b7be2b7bf51374092261ae120e822be685f2e7a83664bcfbe38fe8633f24e633ffe1988e1bc5acf59a587079a57a910bda60060e85b5f5b6f776f0529639d9cce4bd", "9427036469f4375d424a00cadff752517fec80a690a114f6118aca6be5ae9127");
        TestDigest.testKatHex(new BLAKE256(), "69f9abba65592ee01db4dce52dbab90b08fc04193602792ee4daa263033d59081587b09bbe49d0b49c9825d22840b2ff5d9c5155f975f8f2c2e7a90c75d2e4a8040fe39f63bbafb403d9e28cc3b86e04e394a9c9e8065bd3c85fa9f0c7891600", "66ca51e2d44ab7b53d415345781c6f1205823c1e71d9b4cee074b75a8728977f");
        TestDigest.testKatHex(new BLAKE256(), "38a10a352ca5aedfa8e19c64787d8e9c3a75dbf3b8674bfab29b5dbfc15a63d10fae66cd1a6e6d2452d557967eaad89a4c98449787b0b3164ca5b717a93f24eb0b506ceb70cbbcb8d72b2a72993f909aad92f044e0b5a2c9ac9cb16a0ca2f81f49", "67d1761ff1de244dad4cc6fc972f9f1c4451fa91cb630e2a1008202e64cdda47");
        TestDigest.testKatHex(new BLAKE256(), "6d8c6e449bc13634f115749c248c17cd148b72157a2c37bf8969ea83b4d6ba8c0ee2711c28ee11495f43049596520ce436004b026b6c1f7292b9c436b055cbb72d530d860d1276a1502a5140e3c3f54a93663e4d20edec32d284e25564f624955b52", "12d264488aab5f92a89c647c4716b44d0b54bd1c59caa4c63086214419ba3e29");
        TestDigest.testKatHex(new BLAKE256(), "6efcbcaf451c129dbe00b9cef0c3749d3ee9d41c7bd500ade40cdc65dedbbbadb885a5b14b32a0c0d087825201e303288a733842fa7e599c0c514e078f05c821c7a4498b01c40032e9f1872a1c925fa17ce253e8935e4c3c71282242cb716b2089ccc1", "2e5df5fd1c5e6d63a478b36a3571a2ddc095e1ffd93056682bf1aaab830582e7");
        TestDigest.testKatHex(new BLAKE256(), "433c5303131624c0021d868a30825475e8d0bd3052a022180398f4ca4423b98214b6beaac21c8807a2c33f8c93bd42b092cc1b06cedf3224d5ed1ec29784444f22e08a55aa58542b524b02cd3d5d5f6907afe71c5d7462224a3f9d9e53e7e0846dcbb4ce", "1195a9f43d5528e2bcb43d8443e7b18c05f7f80946b61e2ab3d9eb15c8fff7a4");
        TestDigest.testKatHex(new BLAKE256(), "a873e0c67ca639026b6683008f7aa6324d4979550e9bce064ca1e1fb97a30b147a24f3f666c0a72d71348ede701cf2d17e2253c34d1ec3b647dbcef2f879f4eb881c4830b791378c901eb725ea5c172316c6d606e0af7df4df7f76e490cd30b2badf45685f", "ad30542976e20a93bf2a2e2b341f04253cdc95826a629082fd668580777e488b");
        TestDigest.testKatHex(new BLAKE256(), "006917b64f9dcdf1d2d87c8a6173b64f6587168e80faa80f82d84f60301e561e312d9fbce62f39a6fb476e01e925f26bcc91de621449be6504c504830aae394096c8fc7694651051365d4ee9070101ec9b68086f2ea8f8ab7b811ea8ad934d5c9b62c60a4771", "79676a020a388a0da82bf48ed3e92c5abc6e34206ab3a1b3038344ae663f2fb2");
        TestDigest.testKatHex(new BLAKE256(), "f13c972c52cb3cc4a4df28c97f2df11ce089b815466be88863243eb318c2adb1a417cb1041308598541720197b9b1cb5ba2318bd5574d1df2174af14884149ba9b2f446d609df240ce335599957b8ec80876d9a085ae084907bc5961b20bf5f6ca58d5dab38adb", "3d422f89bf9114776ae98024197429535113dc4f4ea1b1ba12d6b120dd55fd29");
        TestDigest.testKatHex(new BLAKE256(), "e35780eb9799ad4c77535d4ddb683cf33ef367715327cf4c4a58ed9cbdcdd486f669f80189d549a9364fa82a51a52654ec721bb3aab95dceb4a86a6afa93826db923517e928f33e3fba850d45660ef83b9876accafa2a9987a254b137c6e140a21691e1069413848", "e6dcdb50f90e7b0fc3bde1a24857927ae57a4f730d6a30d4bb8b4525fea4cf71");
        TestDigest.testKatHex(new BLAKE256(), "64ec021c9585e01ffe6d31bb50d44c79b6993d72678163db474947a053674619d158016adb243f5c8d50aa92f50ab36e579ff2dabb780a2b529370daa299207cfbcdd3a9a25006d19c4f1fe33e4b1eaec315d8c6ee1e730623fd1941875b924eb57d6d0c2edc4e78d6", "53b93da8322604c79566119f860b0179a5684e7450aee256fc2dd7e7593dfa39");
        TestDigest.testKatHex(new BLAKE256(), "5954bab512cf327d66b5d9f296180080402624ad7628506b555eea8382562324cf452fba4a2130de3e165d11831a270d9cb97ce8c2d32a96f50d71600bb4ca268cf98e90d6496b0a6619a5a8c63db6d8a0634dfc6c7ec8ea9c006b6c456f1b20cd19e781af20454ac880", "84c2cc80029b26b026342c562e2d31b1ab0be57c4a159e206f41367f5eef9c27");
        TestDigest.testKatHex(new BLAKE256(), "03d9f92b2c565709a568724a0aff90f8f347f43b02338f94a03ed32e6f33666ff5802da4c81bdce0d0e86c04afd4edc2fc8b4141c2975b6f07639b1994c973d9a9afce3d9d365862003498513bfa166d2629e314d97441667b007414e739d7febf0fe3c32c17aa188a8683", "ae6e977c0ba5e4dc36badceb2b0ddbbfc92383a6f0dfa8d5a8bafd08896e9141");
        TestDigest.testKatHex(new BLAKE256(), "f31e8b4f9e0621d531d22a380be5d9abd56faec53cbd39b1fab230ea67184440e5b1d15457bd25f56204fa917fa48e669016cb48c1ffc1e1e45274b3b47379e00a43843cf8601a5551411ec12503e5aac43d8676a1b2297ec7a0800dbfee04292e937f21c005f17411473041", "59c7e77fcaac2dd7b931fb681de0c7abadf103da0a3956c1a1834370a34830a5");
        TestDigest.testKatHex(new BLAKE256(), "758ea3fea738973db0b8be7e599bbef4519373d6e6dcd7195ea885fc991d896762992759c2a09002912fb08e0cb5b76f49162aeb8cf87b172cf3ad190253df612f77b1f0c532e3b5fc99c2d31f8f65011695a087a35ee4eee5e334c369d8ee5d29f695815d866da99df3f79403", "992a70622862446236a42e353b08503b1f62758e42a944331f4c4140d7420037");
        TestDigest.testKatHex(new BLAKE256(), "47c6e0c2b74948465921868804f0f7bd50dd323583dc784f998a93cd1ca4c6ef84d41dc81c2c40f34b5bee6a93867b3bdba0052c5f59e6f3657918c382e771d33109122cc8bb0e1e53c4e3d13b43ce44970f5e0c079d2ad7d7a3549cd75760c21bb15b447589e86e8d76b1e9ced2", "c777f7ec527e56a347841df01d3238ad592ce68805b6974056c172f19aabc8e8");
        TestDigest.testKatHex(new BLAKE256(), "f690a132ab46b28edfa6479283d6444e371c6459108afd9c35dbd235e0b6b6ff4c4ea58e7554bd002460433b2164ca51e868f7947d7d7a0d792e4abf0be5f450853cc40d85485b2b8857ea31b5ea6e4ccfa2f3a7ef3380066d7d8979fdac618aad3d7e886dea4f005ae4ad05e5065f", "d49ea6685748992f274bb158cd4a936c479f1eba9217518068ffbbf9a44bb968");
        TestDigest.testKatHex(new BLAKE256(), "58d6a99bc6458824b256916770a8417040721cccfd4b79eacd8b65a3767ce5ba7e74104c985ac56b8cc9aebd16febd4cda5adb130b0ff2329cc8d611eb14dac268a2f9e633c99de33997fea41c52a7c5e1317d5b5daed35eba7d5a60e45d1fa7eaabc35f5c2b0a0f2379231953322c4e", "166ed4abd425d074e8091f44ec2e9eeed471a9020adec03a4f1f003d7826f5ef");
        TestDigest.testKatHex(new BLAKE256(), "befab574396d7f8b6705e2d5b58b2c1c820bb24e3f4bae3e8fbcd36dbf734ee14e5d6ab972aedd3540235466e825850ee4c512ea9795abfd33f330d9fd7f79e62bbb63a6ea85de15beaeea6f8d204a28956059e2632d11861dfb0e65bc07ac8a159388d5c3277e227286f65ff5e5b5aec1", "158dbc6d91cd8403b8803a671e2d64ca2af964d5b61d20ae30b67c258b5acc0c");
        TestDigest.testKatHex(new BLAKE256(), "8e58144fa9179d686478622ce450c748260c95d1ba43b8f9b59abeca8d93488da73463ef40198b4d16fb0b0707201347e0506ff19d01bea0f42b8af9e71a1f1bd168781069d4d338fdef00bf419fbb003031df671f4a37979564f69282de9c65407847dd0da505ab1641c02dea4f0d834986", "133c98d45490eb82d60a7bdb7981927a6e05d0ed82ec841ddef6a0a9c368637b");
        TestDigest.testKatHex(new BLAKE256(), "b55c10eae0ec684c16d13463f29291bf26c82e2fa0422a99c71db4af14dd9c7f33eda52fd73d017cc0f2dbe734d831f0d820d06d5f89dacc485739144f8cfd4799223b1aff9031a105cb6a029ba71e6e5867d85a554991c38df3c9ef8c1e1e9a7630be61caabca69280c399c1fb7a12d12aefc", "0b1bccebc785202d23966d8962ab8c030c62a9607267b2fcd56368ca95027105");
        TestDigest.testKatHex(new BLAKE256(), "2eeea693f585f4ed6f6f8865bbae47a6908aecd7c429e4bec4f0de1d0ca0183fa201a0cb14a529b7d7ac0e6ff6607a3243ee9fb11bcf3e2304fe75ffcddd6c5c2e2a4cd45f63c962d010645058d36571404a6d2b4f44755434d76998e83409c3205aa1615db44057db991231d2cb42624574f545", "76eb772a6c20e7ee60b6c22307991f4e418c265907b46b61abbb73558777ed89");
        TestDigest.testKatHex(new BLAKE256(), "dab11dc0b047db0420a585f56c42d93175562852428499f66a0db811fcdddab2f7cdffed1543e5fb72110b64686bc7b6887a538ad44c050f1e42631bc4ec8a9f2a047163d822a38989ee4aab01b4c1f161b062d873b1cfa388fd301514f62224157b9bef423c7783b7aac8d30d65cd1bba8d689c2d", "de391381e7893d29cff28fe50bdba78d9d78daabe7bc13455e5994471bf36471");
        TestDigest.testKatHex(new BLAKE256(), "42e99a2f80aee0e001279a2434f731e01d34a44b1a8101726921c0590c30f3120eb83059f325e894a5ac959dca71ce2214799916424e859d27d789437b9d27240bf8c35adbafcecc322b48aa205b293962d858652abacbd588bcf6cbc388d0993bd622f96ed54614c25b6a9aa527589eaaffcf17ddf7", "9191b96a3ab156ce4f1c8cdeda412f4fbb8fe82fea89e5e06b6e3cb0c31d1ba5");
        TestDigest.testKatHex(new BLAKE256(), "3c9b46450c0f2cae8e3823f8bdb4277f31b744ce2eb17054bddc6dff36af7f49fb8a2320cc3bdf8e0a2ea29ad3a55de1165d219adeddb5175253e2d1489e9b6fdd02e2c3d3a4b54d60e3a47334c37913c5695378a669e9b72dec32af5434f93f46176ebf044c4784467c700470d0c0b40c8a088c815816", "216fa0351b39850c2bd7f2b5b9671cf8e40d9ff61a8e39f12f3a6e4494d7556b");
        TestDigest.testKatHex(new BLAKE256(), "d1e654b77cb155f5c77971a64df9e5d34c26a3cad6c7f6b300d39deb1910094691adaa095be4ba5d86690a976428635d5526f3e946f7dc3bd4dbc78999e653441187a81f9adcd5a3c5f254bc8256b0158f54673dcc1232f6e918ebfc6c51ce67eaeb042d9f57eec4bfe910e169af78b3de48d137df4f2840", "97fc8bcdc75df30be496c8a19cc1374cf6a1ccb65f3a1395523aa293806a8dec");
        TestDigest.testKatHex(new BLAKE256(), "626f68c18a69a6590159a9c46be03d5965698f2dac3de779b878b3d9c421e0f21b955a16c715c1ec1e22ce3eb645b8b4f263f60660ea3028981eebd6c8c3a367285b691c8ee56944a7cd1217997e1d9c21620b536bdbd5de8925ff71dec6fbc06624ab6b21e329813de90d1e572dfb89a18120c3f606355d25", "c9cdda7b2b3cc695d6d5ca1531801a4f3a23e0916b08d721e9e6fee4f7d0810a");
        TestDigest.testKatHex(new BLAKE256(), "651a6fb3c4b80c7c68c6011675e6094eb56abf5fc3057324ebc6477825061f9f27e7a94633abd1fa598a746e4a577caf524c52ec1788471f92b8c37f23795ca19d559d446cab16cbcdce90b79fa1026cee77bf4ab1b503c5b94c2256ad75b3eac6fd5dcb96aca4b03a834bfb4e9af988cecbf2ae597cb9097940", "d4df2dd32859879f6a5f1c431cad5b87510bd5a0532765366c945ca358b71db0");
        TestDigest.testKatHex(new BLAKE256(), "8aaf072fce8a2d96bc10b3c91c809ee93072fb205ca7f10abd82ecd82cf040b1bc49ea13d1857815c0e99781de3adbb5443ce1c897e55188ceaf221aa9681638de05ae1b322938f46bce51543b57ecdb4c266272259d1798de13be90e10efec2d07484d9b21a3870e2aa9e06c21aa2d0c9cf420080a80a91dee16f", "d1f095caf1d7442428a58e5fa21478d9b94d39430562074fac9a0dff3432d39d");
        TestDigest.testKatHex(new BLAKE256(), "53f918fd00b1701bd504f8cdea803acca21ac18c564ab90c2a17da592c7d69688f6580575395551e8cd33e0fef08ca6ed4588d4d140b3e44c032355df1c531564d7f4835753344345a6781e11cd5e095b73df5f82c8ae3ad00877936896671e947cc52e2b29dcd463d90a0c9929128da222b5a211450bbc0e02448e2", "140458c9a70ab6980f1c292a4da574dc9bce8cd5855321dc67d108e54bfa03ec");
        TestDigest.testKatHex(new BLAKE256(), "a64599b8a61b5ccec9e67aed69447459c8da3d1ec6c7c7c82a7428b9b584fa67e90f68e2c00fbbed4613666e5168da4a16f395f7a3c3832b3b134bfc9cbaa95d2a0fe252f44ac6681eb6d40ab91c1d0282fed6701c57463d3c5f2bb8c6a7301fb4576aa3b5f15510db8956ff77478c26a7c09bea7b398cfc83503f538e", "a5e935286f44db39a0b08726238ae3ee89038064eb4ba311f3954707613c6186");
        TestDigest.testKatHex(new BLAKE256(), "0e3ab0e054739b00cdb6a87bd12cae024b54cb5e550e6c425360c2e87e59401f5ec24ef0314855f0f56c47695d56a7fb1417693af2a1ed5291f2fee95f75eed54a1b1c2e81226fbff6f63ade584911c71967a8eb70933bc3f5d15bc91b5c2644d9516d3c3a8c154ee48e118bd1442c043c7a0dba5ac5b1d5360aae5b9065", "eff0707442c2b43e455302819dec3894a2e41a9aab63ad168dd437a37408324a");
        TestDigest.testKatHex(new BLAKE256(), "a62fc595b4096e6336e53fcdfc8d1cc175d71dac9d750a6133d23199eaac288207944cea6b16d27631915b4619f743da2e30a0c00bbdb1bbb35ab852ef3b9aec6b0a8dcc6e9e1abaa3ad62ac0a6c5de765de2c3711b769e3fde44a74016fff82ac46fa8f1797d3b2a726b696e3dea5530439acee3a45c2a51bc32dd055650b", "45d0808107836411153667b2ca1b0b68476dad3eb8a46627923aceb32a920aaa");
        TestDigest.testKatHex(new BLAKE256(), "2b6db7ced8665ebe9deb080295218426bdaa7c6da9add2088932cdffbaa1c14129bccdd70f369efb149285858d2b1d155d14de2fdb680a8b027284055182a0cae275234cc9c92863c1b4ab66f304cf0621cd54565f5bff461d3b461bd40df28198e3732501b4860eadd503d26d6e69338f4e0456e9e9baf3d827ae685fb1d817", "e9916891100d60a4f6686701b0ec5bc5ad200a496a89658e18ad10505b898ee6");
        TestDigest.testKatHex(new BLAKE256(), "10db509b2cdcaba6c062ae33be48116a29eb18e390e1bbada5ca0a2718afbcd23431440106594893043cc7f2625281bf7de2655880966a23705f0c5155c2f5cca9f2c2142e96d0a2e763b70686cd421b5db812daced0c6d65035fde558e94f26b3e6dde5bd13980cc80292b723013bd033284584bff27657871b0cf07a849f4ae2", "38443bdd9d99dd16d7570d0529f0662bc1797a516276d063327a722e43667fe8");
        TestDigest.testKatHex(new BLAKE256(), "9334de60c997bda6086101a6314f64e4458f5ff9450c509df006e8c547983c651ca97879175aaba0c539e82d05c1e02c480975cbb30118121061b1ebac4f8d9a3781e2db6b18042e01ecf9017a64a0e57447ec7fcbe6a7f82585f7403ee2223d52d37b4bf426428613d6b4257980972a0acab508a7620c1cb28eb4e9d30fc41361ec", "5ce13a4c40ad6e564e2eb90d0f34690f527d07d146443e88b263d0d943d0f820");
        TestDigest.testKatHex(new BLAKE256(), "e88ab086891693aa535ceb20e64c7ab97c7dd3548f3786339897a5f0c39031549ca870166e477743ccfbe016b4428d89738e426f5ffe81626137f17aecff61b72dbee2dc20961880cfe281dfab5ee38b1921881450e16032de5e4d55ad8d4fca609721b0692bac79be5a06e177fe8c80c0c83519fb3347de9f43d5561cb8107b9b5edc", "19cb674d35076b2083f0fc9826fe184b5ea2e358300259cc934bf265ef121789");
        TestDigest.testKatHex(new BLAKE256(), "fd19e01a83eb6ec810b94582cb8fbfa2fcb992b53684fb748d2264f020d3b960cb1d6b8c348c2b54a9fcea72330c2aaa9a24ecdb00c436abc702361a82bb8828b85369b8c72ece0082fe06557163899c2a0efa466c33c04343a839417057399a63a3929be1ee4805d6ce3e5d0d0967fe9004696a5663f4cac9179006a2ceb75542d75d68", "4f25eefba9cea8b323c6917a72027c668e9859ae025d2618467444800f695414");
        TestDigest.testKatHex(new BLAKE256(), "59ae20b6f7e0b3c7a989afb28324a40fca25d8651cf1f46ae383ef6d8441587aa1c04c3e3bf88e8131ce6145cfb8973d961e8432b202fa5af3e09d625faad825bc19da9b5c6c20d02abda2fcc58b5bd3fe507bf201263f30543819510c12bc23e2ddb4f711d087a86edb1b355313363a2de996b891025e147036087401ccf3ca7815bf3c49", "da316803110775e55eaf40e85ba50f470acee5c7429dd9bc53bd70133071feeb");
        TestDigest.testKatHex(new BLAKE256(), "77ee804b9f3295ab2362798b72b0a1b2d3291dceb8139896355830f34b3b328561531f8079b79a6e9980705150866402fdc176c05897e359a6cb1a7ab067383eb497182a7e5aef7038e4c96d133b2782917417e391535b5e1b51f47d8ed7e4d4025fe98dc87b9c1622614bff3d1029e68e372de719803857ca52067cddaad958951cb2068cc6", "dcedc570a476055725f062daa0651383fe997cf539b2f1228a8da225befdb7d3");
        TestDigest.testKatHex(new BLAKE256(), "b771d5cef5d1a41a93d15643d7181d2a2ef0a8e84d91812f20ed21f147bef732bf3a60ef4067c3734b85bc8cd471780f10dc9e8291b58339a677b960218f71e793f2797aea349406512829065d37bb55ea796fa4f56fd8896b49b2cd19b43215ad967c712b24e5032d065232e02c127409d2ed4146b9d75d763d52db98d949d3b0fed6a8052fbb", "9213860134edd9693b7455405a1139e72fc1637fc7c6f4deb05950fe1cc4c8ae");
        TestDigest.testKatHex(new BLAKE256(), "b32d95b0b9aad2a8816de6d06d1f86008505bd8c14124f6e9a163b5a2ade55f835d0ec3880ef50700d3b25e42cc0af050ccd1be5e555b23087e04d7bf9813622780c7313a1954f8740b6ee2d3f71f768dd417f520482bd3a08d4f222b4ee9dbd015447b33507dd50f3ab4247c5de9a8abd62a8decea01e3b87c8b927f5b08beb37674c6f8e380c04", "2feb9de1b8f6706b05c594ac6ba953d2eb1077bcdc273586a1e9a7693b719b35");
        TestDigest.testKatHex(new BLAKE256(), "04410e31082a47584b406f051398a6abe74e4da59bb6f85e6b49e8a1f7f2ca00dfba5462c2cd2bfde8b64fb21d70c083f11318b56a52d03b81cac5eec29eb31bd0078b6156786da3d6d8c33098c5c47bb67ac64db14165af65b44544d806dde5f487d5373c7f9792c299e9686b7e5821e7c8e2458315b996b5677d926dac57b3f22da873c601016a0d", "a7170c8b1c7c2ff96ff4324f1f91b49a06129d1e3b29dc70b303a735771c42c2");
        TestDigest.testKatHex(new BLAKE256(), "8b81e9badde026f14d95c019977024c9e13db7a5cd21f9e9fc491d716164bbacdc7060d882615d411438aea056c340cdf977788f6e17d118de55026855f93270472d1fd18b9e7e812bae107e0dfde7063301b71f6cfe4e225cab3b232905a56e994f08ee2891ba922d49c3dafeb75f7c69750cb67d822c96176c46bd8a29f1701373fb09a1a6e3c7158f", "17f6b2a1f965b02a9b00c9af67308f45baac0e2702c4fe1f473ebd8ac865ff78");
        TestDigest.testKatHex(new BLAKE256(), "fa6eed24da6666a22208146b19a532c2ec9ba94f09f1def1e7fc13c399a48e41acc2a589d099276296348f396253b57cb0e40291bd282773656b6e0d8bea1cda084a3738816a840485fcf3fb307f777fa5feac48695c2af4769720258c77943fb4556c362d9cba8bf103aeb9034baa8ea8bfb9c4f8e6742ce0d52c49ea8e974f339612e830e9e7a9c29065", "ff5c60968e17a08f9ecddf3327a95aec0964ec03ba5dab4ccdd1f0386b0b0ee1");
        TestDigest.testKatHex(new BLAKE256(), "9bb4af1b4f09c071ce3cafa92e4eb73ce8a6f5d82a85733440368dee4eb1cbc7b55ac150773b6fe47dbe036c45582ed67e23f4c74585dab509df1b83610564545642b2b1ec463e18048fc23477c6b2aa035594ecd33791af6af4cbc2a1166aba8d628c57e707f0b0e8707caf91cd44bdb915e0296e0190d56d33d8dde10b5b60377838973c1d943c22ed335e", "caf601a14e6f040318605c4134e845f9110c28358b91e9d059f426eb0e6af94b");
        TestDigest.testKatHex(new BLAKE256(), "2167f02118cc62043e9091a647cadbed95611a521fe0d64e8518f16c808ab297725598ae296880a773607a798f7c3cfce80d251ebec6885015f9abf7eaabae46798f82cb5926de5c23f44a3f9f9534b3c6f405b5364c2f8a8bdc5ca49c749bed8ce4ba48897062ae8424ca6dde5f55c0e42a95d1e292ca54fb46a84fbc9cd87f2d0c9e7448de3043ae22fdd229", "44679d891ed6e8afe8d57b6decd41cb7a376c38ab6d0240f81806db625d02f09");
        TestDigest.testKatHex(new BLAKE256(), "94b7fa0bc1c44e949b1d7617d31b4720cbe7ca57c6fa4f4094d4761567e389ecc64f6968e4064df70df836a47d0c713336b5028b35930d29eb7a7f9a5af9ad5cf441745baec9bb014ceeff5a41ba5c1ce085feb980bab9cf79f2158e03ef7e63e29c38d7816a84d4f71e0f548b7fc316085ae38a060ff9b8dec36f91ad9ebc0a5b6c338cbb8f6659d342a24368cf", "7b2ebd05afd8d80da41e30d4751454919d4274ac3dcc7d68043e66baae1cecf4");
        TestDigest.testKatHex(new BLAKE256(), "ea40e83cb18b3a242c1ecc6ccd0b7853a439dab2c569cfc6dc38a19f5c90acbf76aef9ea3742ff3b54ef7d36eb7ce4ff1c9ab3bc119cff6be93c03e208783335c0ab8137be5b10cdc66ff3f89a1bddc6a1eed74f504cbe7290690bb295a872b9e3fe2cee9e6c67c41db8efd7d863cf10f840fe618e7936da3dca5ca6df933f24f6954ba0801a1294cd8d7e66dfafec", "b65e629abbfdfb1ea74835fdece61da229198d71d2408627c9afb30da8af89e7");
        TestDigest.testKatHex(new BLAKE256(), "157d5b7e4507f66d9a267476d33831e7bb768d4d04cc3438da12f9010263ea5fcafbde2579db2f6b58f911d593d5f79fb05fe3596e3fa80ff2f761d1b0e57080055c118c53e53cdb63055261d7c9b2b39bd90acc32520cbbdbda2c4fd8856dbcee173132a2679198daf83007a9b5c51511ae49766c792a29520388444ebefe28256fb33d4260439cba73a9479ee00c63", "f2e3f93d6d23a16bf97a2ad32c3e1293de59805ee26277a04fe42f166570d296");
        TestDigest.testKatHex(new BLAKE256(), "836b34b515476f613fe447a4e0c3f3b8f20910ac89a3977055c960d2d5d2b72bd8acc715a9035321b86703a411dde0466d58a59769672aa60ad587b8481de4bba552a1645779789501ec53d540b904821f32b0bd1855b04e4848f9f8cfe9ebd8911be95781a759d7ad9724a7102dbe576776b7c632bc39b9b5e19057e226552a5994c1dbb3b5c7871a11f5537011044c53", "0c647ea28d33c91160a56b0444400c2b1fbbf05cbcd579674c84c3911a705cc9");
        TestDigest.testKatHex(new BLAKE256(), "cc7784a4912a7ab5ad3620aab29ba87077cd3cb83636adc9f3dc94f51edf521b2161ef108f21a0a298557981c0e53ce6ced45bdf782c1ef200d29bab81dd6460586964edab7cebdbbec75fd7925060f7da2b853b2b089588fa0f8c16ec6498b14c55dcee335cb3a91d698e4d393ab8e8eac0825f8adebeee196df41205c011674e53426caa453f8de1cbb57932b0b741d4c6", "78b62c2d16293639013f16fc5472f61a95e6ec004f67e96e2151d70708994476");
        TestDigest.testKatHex(new BLAKE256(), "7639b461fff270b2455ac1d1afce782944aea5e9087eb4a39eb96bb5c3baaf0e868c8526d3404f9405e79e77bfac5ffb89bf1957b523e17d341d7323c302ea7083872dd5e8705694acdda36d5a1b895aaa16eca6104c82688532c8bfe1790b5dc9f4ec5fe95baed37e1d287be710431f1e5e8ee105bc42ed37d74b1e55984bf1c09fe6a1fa13ef3b96faeaed6a2a1950a12153", "c8f3afdae102094517caa3210d02da830531964863eefbd015c46f69810ab33d");
        TestDigest.testKatHex(new BLAKE256(), "eb6513fc61b30cfba58d4d7e80f94d14589090cf1d80b1df2e68088dc6104959ba0d583d585e9578ab0aec0cf36c48435eb52ed9ab4bbce7a5abe679c97ae2dbe35e8cc1d45b06dda3cf418665c57cbee4bbb47fa4caf78f4ee656fec237fe4eebbafa206e1ef2bd0ee4ae71bd0e9b2f54f91daadf1febfd7032381d636b733dcb3bf76fb14e23aff1f68ed3dbcf75c9b99c6f26", "8912c6802e940c57664e714dd848d93dfa710ca879c75089595999a6082b5df6");
        TestDigest.testKatHex(new BLAKE256(), "1594d74bf5dde444265d4c04dad9721ff3e34cbf622daf341fe16b96431f6c4df1f760d34f296eb97d98d560ad5286fec4dce1724f20b54fd7df51d4bf137add656c80546fb1bf516d62ee82baa992910ef4cc18b70f3f8698276fcfb44e0ec546c2c39cfd8ee91034ff9303058b4252462f86c823eb15bf481e6b79cc3a02218595b3658e8b37382bd5048eaed5fd02c37944e73b", "70cc75de5ab9b56d4080afa804da9fcb951bb05e2c22f4045f856e54ad2f1b16");
        TestDigest.testKatHex(new BLAKE256(), "4cfa1278903026f66fedd41374558be1b585d03c5c55dac94361df286d4bd39c7cb8037ed3b267b07c346626449d0cc5b0dd2cf221f7e4c3449a4be99985d2d5e67bff2923357ddeab5abcb4619f3a3a57b2cf928a022eb27676c6cf805689004fca4d41ea6c2d0a4789c7605f7bb838dd883b3ad3e6027e775bcf262881428099c7fff95b14c095ea130e0b9938a5e22fc52650f591", "b1e1b0c8bc208702f72e7d6fa5f7b977c6553cc729fee45e43bd372f1e47a2e4");
        TestDigest.testKatHex(new BLAKE256(), "d3e65cb92cfa79662f6af493d696a07ccf32aaadcceff06e73e8d9f6f909209e66715d6e978788c49efb9087b170ecf3aa86d2d4d1a065ae0efc8924f365d676b3cb9e2bec918fd96d0b43dee83727c9a93bf56ca2b2e59adba85696546a815067fc7a78039629d4948d157e7b0d826d1bf8e81237bab7321312fdaa4d521744f988db6fdf04549d0fdca393d639c729af716e9c8bba48", "91731e07a6b2d25c15895ecc7935029ec2977e74642efba76034446fbda7d11b");
        TestDigest.testKatHex(new BLAKE256(), "842cc583504539622d7f71e7e31863a2b885c56a0ba62db4c2a3f2fd12e79660dc7205ca29a0dc0a87db4dc62ee47a41db36b9ddb3293b9ac4baae7df5c6e7201e17f717ab56e12cad476be49608ad2d50309e7d48d2d8de4fa58ac3cfeafeee48c0a9eec88498e3efc51f54d300d828dddccb9d0b06dd021a29cf5cb5b2506915beb8a11998b8b886e0f9b7a80e97d91a7d01270f9a7717", "0290b3a745c53f38a6698f1ab888f09a427eec3db47a151d13c5b7e91bd63a49");
        TestDigest.testKatHex(new BLAKE256(), "6c4b0a0719573e57248661e98febe326571f9a1ca813d3638531ae28b4860f23c3a3a8ac1c250034a660e2d71e16d3acc4bf9ce215c6f15b1c0fc7e77d3d27157e66da9ceec9258f8f2bf9e02b4ac93793dd6e29e307ede3695a0df63cbdc0fc66fb770813eb149ca2a916911bee4902c47c7802e69e405fe3c04ceb5522792a5503fa829f707272226621f7c488a7698c0d69aa561be9f378", "87b31ba330c464b08b0f9f93197534d415a958217a65c6cec77aba7c7f1e3faa");
        TestDigest.testKatHex(new BLAKE256(), "51b7dbb7ce2ffeb427a91ccfe5218fd40f9e0b7e24756d4c47cd55606008bdc27d16400933906fd9f30effdd4880022d081155342af3fb6cd53672ab7fb5b3a3bcbe47be1fd3a2278cae8a5fd61c1433f7d350675dd21803746cadca574130f01200024c6340ab0cc2cf74f2234669f34e9009ef2eb94823d62b31407f4ba46f1a1eec41641e84d77727b59e746b8a671bef936f05be820759fa", "ae21d00bbe5899e35926e38666975ce50eac4d4edb9cdd6d8f2bb7b06902c014");
        TestDigest.testKatHex(new BLAKE256(), "83599d93f5561e821bd01a472386bc2ff4efbd4aed60d5821e84aae74d8071029810f5e286f8f17651cd27da07b1eb4382f754cd1c95268783ad09220f5502840370d494beb17124220f6afce91ec8a0f55231f9652433e5ce3489b727716cf4aeba7dcda20cd29aa9a859201253f948dd94395aba9e3852bd1d60dda7ae5dc045b283da006e1cbad83cc13292a315db5553305c628dd091146597", "461e3b5ac9591519c6708a0f48134213274bbca65a66acf1c760edd7800a3a7e");
        TestDigest.testKatHex(new BLAKE256(), "2be9bf526c9d5a75d565dd11ef63b979d068659c7f026c08bea4af161d85a462d80e45040e91f4165c074c43ac661380311a8cbed59cc8e4c4518e80cd2c78ab1cabf66bff83eab3a80148550307310950d034a6286c93a1ece8929e6385c5e3bb6ea8a7c0fb6d6332e320e71cc4eb462a2a62e2bfe08f0ccad93e61bedb5dd0b786a728ab666f07e0576d189c92bf9fb20dca49ac2d3956d47385e2", "17f7c34dd3fde49241a36d36feae4fc3f9623758e07a5b1fd6d6b2bbc19080fd");
        TestDigest.testKatHex(new BLAKE256(), "ca76d3a12595a817682617006848675547d3e8f50c2210f9af906c0e7ce50b4460186fe70457a9e879e79fd4d1a688c70a347361c847ba0dd6aa52936eaf8e58a1be2f5c1c704e20146d366aeb3853bed9de9befe9569ac8aaea37a9fb7139a1a1a7d5c748605a8defb297869ebedd71d615a5da23496d11e11abbb126b206fa0a7797ee7de117986012d0362dcef775c2fe145ada6bda1ccb326bf644", "68562edbbd1ceefc12bb9930444a810090f8d08720e1fbf00b2e8605db81033f");
        TestDigest.testKatHex(new BLAKE256(), "f76b85dc67421025d64e93096d1d712b7baf7fb001716f02d33b2160c2c882c310ef13a576b1c2d30ef8f78ef8d2f465007109aad93f74cb9e7d7bef7c9590e8af3b267c89c15db238138c45833c98cc4a471a7802723ef4c744a853cf80a0c2568dd4ed58a2c9644806f42104cee53628e5bdf7b63b0b338e931e31b87c24b146c6d040605567ceef5960df9e022cb469d4c787f4cba3c544a1ac91f95f", "1a9a95676b6032d9cc66ffcfb8d424411bdb7d163562d70d9eb538a2eb9df46a");
        TestDigest.testKatHex(new BLAKE256(), "25b8c9c032ea6bcd733ffc8718fbb2a503a4ea8f71dea1176189f694304f0ff68e862a8197b839957549ef243a5279fc2646bd4c009b6d1edebf24738197abb4c992f6b1dc9ba891f570879accd5a6b18691a93c7d0a8d38f95b639c1daeb48c4c2f15ccf5b9d508f8333c32de78781b41850f261b855c4bebcc125a380c54d501c5d3bd07e6b52102116088e53d76583b0161e2a58d0778f091206aabd5a1", "4732298d9c2825fe41274b71031afcdc963e39e1a8028e066361737bf959affc");
        TestDigest.testKatHex(new BLAKE256(), "21cfdc2a7ccb7f331b3d2eefff37e48ad9fa9c788c3f3c200e0173d99963e1cbca93623b264e920394ae48bb4c3a5bb96ffbc8f0e53f30e22956adabc2765f57fb761e147ecbf8567533db6e50c8a1f894310a94edf806dd8ca6a0e141c0fa7c9fae6c6ae65f18c93a8529e6e5b553bf55f25be2e80a9882bd37f145fecbeb3d447a3c4e46c21524cc55cdd62f521ab92a8ba72b897996c49bb273198b7b1c9e", "d55722366e397cd9740fdb19e3120c4d5df92e3d6e0a1d7daabfb1bbe1d61165");
        TestDigest.testKatHex(new BLAKE256(), "4e452ba42127dcc956ef4f8f35dd68cb225fb73b5bc7e1ec5a898bba2931563e74faff3b67314f241ec49f4a7061e3bd0213ae826bab380f1f14faab8b0efddd5fd1bb49373853a08f30553d5a55ccbbb8153de4704f29ca2bdeef0419468e05dd51557ccc80c0a96190bbcc4d77ecff21c66bdf486459d427f986410f883a80a5bcc32c20f0478bb9a97a126fc5f95451e40f292a4614930d054c851acd019ccf", "0862390d0191bdd152788f63e44ebd827b88f911919069083366019ef2709fdd");
        TestDigest.testKatHex(new BLAKE256(), "fa85671df7dadf99a6ffee97a3ab9991671f5629195049880497487867a6c446b60087fac9a0f2fcc8e3b24e97e42345b93b5f7d3691829d3f8ccd4bb36411b85fc2328eb0c51cb3151f70860ad3246ce0623a8dc8b3c49f958f8690f8e3860e71eb2b1479a5cea0b3f8befd87acaf5362435eaeccb52f38617bc6c5c2c6e269ead1fbd69e941d4ad2012da2c5b21bcfbf98e4a77ab2af1f3fda3233f046d38f1dc8", "04d01f5e37b134563dc69111f042d8060a80e8ff71fc0b947aaa032887e17678");
        TestDigest.testKatHex(new BLAKE256(), "e90847ae6797fbc0b6b36d6e588c0a743d725788ca50b6d792352ea8294f5ba654a15366b8e1b288d84f5178240827975a763bc45c7b0430e8a559df4488505e009c63da994f1403f407958203cebb6e37d89c94a5eacf6039a327f6c4dbbc7a2a307d976aa39e41af6537243fc218dfa6ab4dd817b6a397df5ca69107a9198799ed248641b63b42cb4c29bfdd7975ac96edfc274ac562d0474c60347a078ce4c25e88", "9a8e5b17512c41a4b2d05248f0468e26f4c55d64f51a0c7b6e8a9af1db6f5f8d");
        TestDigest.testKatHex(new BLAKE256(), "f6d5c2b6c93954fc627602c00c4ca9a7d3ed12b27173f0b2c9b0e4a5939398a665e67e69d0b12fb7e4ceb253e8083d1ceb724ac07f009f094e42f2d6f2129489e846eaff0700a8d4453ef453a3eddc18f408c77a83275617fabc4ea3a2833aa73406c0e966276079d38e8e38539a70e194cc5513aaa457c699383fd1900b1e72bdfb835d1fd321b37ba80549b078a49ea08152869a918ca57f5b54ed71e4fd3ac5c06729", "353185898990d860f1d17d886970643715c0e6e3bbbbe908688f01c1292a23fc");
        TestDigest.testKatHex(new BLAKE256(), "cf8562b1bed89892d67ddaaf3deeb28246456e972326dbcdb5cf3fb289aca01e68da5d59896e3a6165358b071b304d6ab3d018944be5049d5e0e2bb819acf67a6006111089e6767132d72dd85beddcbb2d64496db0cc92955ab4c6234f1eea24f2d51483f2e209e4589bf9519fac51b4d061e801125e605f8093bb6997bc163d551596fe4ab7cfae8fb9a90f6980480ce0c229fd1675409bd788354daf316240cfe0af93eb", "afd00d9023347ea28e4217a64f0ff709e3ba9d19a78e80152d61fcfc244d3f4a");
        TestDigest.testKatHex(new BLAKE256(), "2ace31abb0a2e3267944d2f75e1559985db7354c6e605f18dc8470423fca30b7331d9b33c4a4326783d1caae1b4f07060eff978e4746bf0c7e30cd61040bd5ec2746b29863eb7f103ebda614c4291a805b6a4c8214230564a0557bc7102e0bd3ed23719252f7435d64d210ee2aafc585be903fa41e1968c50fd5d5367926df7a05e3a42cf07e656ff92de73b036cf8b19898c0cb34557c0c12c2d8b84e91181af467bc75a9d1", "b9d6c27d1e95fe186d5d7f7ec080f82ed2e0710838c741e426de537d65128fe6");
        TestDigest.testKatHex(new BLAKE256(), "0d8d09aed19f1013969ce5e7eb92f83a209ae76be31c754844ea9116ceb39a22ebb6003017bbcf26555fa6624185187db8f0cb3564b8b1c06bf685d47f3286eda20b83358f599d2044bbf0583fab8d78f854fe0a596183230c5ef8e54426750eaf2cc4e29d3bdd037e734d863c2bd9789b4c243096138f7672c232314effdfc6513427e2da76916b5248933be312eb5dde4cf70804fb258ac5fb82d58d08177ac6f4756017fff5", "b79172c5f852a390e76616bc1c4dc65579608f64fd76f1729ec8f1899c6e60eb");
        TestDigest.testKatHex(new BLAKE256(), "c3236b73deb7662bf3f3daa58f137b358ba610560ef7455785a9befdb035a066e90704f929bd9689cef0ce3bda5acf4480bceb8d09d10b098ad8500d9b6071dfc3a14af6c77511d81e3aa8844986c3bea6f469f9e02194c92868cd5f51646256798ff0424954c1434bdfed9facb390b07d342e992936e0f88bfd0e884a0ddb679d0547ccdec6384285a45429d115ac7d235a717242021d1dc35641f5f0a48e8445dba58e6cb2c8ea", "ff15b4aa0ce77a3179d9b1079d7187c737ba37c7999c89d899e42bbd9e7e0d59");
        TestDigest.testKatHex(new BLAKE256(), "b39feb8283eadc63e8184b51df5ae3fd41aac8a963bb0be1cd08aa5867d8d910c669221e73243360646f6553d1ca05a84e8dc0de05b6419ec349ca994480193d01c92525f3fb3dcefb08afc6d26947bdbbfd85193f53b50609c6140905c53a6686b58e53a319a57b962331ede98149af3de3118a819da4d76706a0424b4e1d2910b0ed26af61d150ebcb46595d4266a0bd7f651ba47d0c7f179ca28545007d92e8419d48fdfbd744ce", "0766425f0911053564d7ad11bae97aeafe3f83142390bac6c802917598949d73");
        TestDigest.testKatHex(new BLAKE256(), "a983d54f503803e8c7999f4edbbe82e9084f422143a932ddddc47a17b0b7564a7f37a99d0786e99476428d29e29d3c197a72bfab1342c12a0fc4787fd7017d7a6174049ea43b5779169ef7472bdbbd941dcb82fc73aac45a8a94c9f2bd3477f61fd3b796f02a1b8264a214c6fea74b7051b226c722099ec7883a462b83b6afdd4009248b8a237f605fe5a08fe7d8b45321421ebba67bd70a0b00ddbf94baab7f359d5d1eea105f28dcfb", "4433e407c250469f6264a1e33e98c53f342ddf1c07273983a231117f05c73529");
        TestDigest.testKatHex(new BLAKE256(), "e4d1c1897a0a866ce564635b74222f9696bf2c7f640dd78d7e2aca66e1b61c642bb03ea7536aae597811e9bf4a7b453ede31f97b46a5f0ef51a071a2b3918df16b152519ae3776f9f1edab4c2a377c3292e96408359d3613844d5eb393000283d5ad3401a318b12fd1474b8612f2bb50fb6a8b9e023a54d7dde28c43d6d8854c8d9d1155935c199811dbfc87e9e0072e90eb88681cc7529714f8fb8a2c9d88567adfb974ee205a9bf7b848", "2883e69c655ef374f61fc28171eeec8568945ca51ca782f27b111a83be5c8605");
        TestDigest.testKatHex(new BLAKE256(), "b10c59723e3dcadd6d75df87d0a1580e73133a9b7d00cb95ec19f5547027323be75158b11f80b6e142c6a78531886d9047b08e551e75e6261e79785366d7024bd7cd9cf322d9be7d57fb661069f2481c7bb759cd71b4b36ca2bc2df6d3a328faebdb995a9794a8d72155ed551a1f87c80bf6059b43fc764900b18a1c2441f7487743cf84e565f61f8dd2ece6b6ccc9444049197aaaf53e926fbee3bfca8be588ec77f29d211be89de18b15f6", "a8b47e1fccbf494fbf02d16330c8d7386526b418d9ac85e921573e9a0d9e6ce5");
        TestDigest.testKatHex(new BLAKE256(), "db11f609baba7b0ca634926b1dd539c8cbada24967d7add4d9876f77c2d80c0f4dcefbd7121548373582705cca2495bd2a43716fe64ed26d059cfb566b3364bd49ee0717bdd9810dd14d8fad80dbbdc4cafb37cc60fb0fe2a80fb4541b8ca9d59dce457738a9d3d8f641af8c3fd6da162dc16fc01aac527a4a0255b4d231c0be50f44f0db0b713af03d968fe7f0f61ed0824c55c4b5265548febd6aad5c5eedf63efe793489c39b8fd29d104ce", "3cf7e2f6bfa41354403a16b18644005289d97a725ee4b32a9642beb7fef4d576");
        TestDigest.testKatHex(new BLAKE256(), "bebd4f1a84fc8b15e4452a54bd02d69e304b7f32616aadd90537937106ae4e28de9d8aab02d19bc3e2fde1d651559e296453e4dba94370a14dbbb2d1d4e2022302ee90e208321efcd8528ad89e46dc839ea9df618ea8394a6bff308e7726bae0c19bcd4be52da6258e2ef4e96aa21244429f49ef5cb486d7ff35cac1bacb7e95711944bccb2ab34700d42d1eb38b5d536b947348a458ede3dc6bd6ec547b1b0cae5b257be36a7124e1060c170ffa", "108a3fbb93af7c0c2713116407767f08610c6e856cdf3474e406e35d8c64a140");
        TestDigest.testKatHex(new BLAKE256(), "5aca56a03a13784bdc3289d9364f79e2a85c12276b49b92db0adaa4f206d5028f213f678c3510e111f9dc4c1c1f8b6acb17a6413aa227607c515c62a733817ba5e762cc6748e7e0d6872c984d723c9bb3b117eb8963185300a80bfa65cde495d70a46c44858605fccbed086c2b45cef963d33294dbe9706b13af22f1b7c4cd5a001cfec251fba18e722c6e1c4b1166918b4f6f48a98b64b3c07fc86a6b17a6d0480ab79d4e6415b520f1c484d675b1", "8fc89f8288be14a0b56e39a366bd112dddfd9af92f86366c16bbf9ffb77425b8");
        TestDigest.testKatHex(new BLAKE256(), "a5aad0e4646a32c85cfcac73f02fc5300f1982fabb2f2179e28303e447854094cdfc854310e5c0f60993ceff54d84d6b46323d930adb07c17599b35b505f09e784bca5985e0172257797fb53649e2e9723efd16865c31b5c3d5113b58bb0bfc8920fabdda086d7537e66d709d050bd14d0c960873f156fad5b3d3840cdfcdc9be6af519db262a27f40896ab25cc39f96984d650611c0d5a3080d5b3a1bf186abd42956588b3b58cd948970d298776060", "a92eb887c9ba1129f4315401c8aec9c4bd46b0c38539004f57b4e144938fa855");
        TestDigest.testKatHex(new BLAKE256(), "06cbbe67e94a978203ead6c057a1a5b098478b4b4cbef5a97e93c8e42f5572713575fc2a884531d7622f8f879387a859a80f10ef02708cd8f7413ab385afc357678b9578c0ebf641ef076a1a30f1f75379e9dcb2a885bdd295905ee80c0168a62a9597d10cf12dd2d8cee46645c7e5a141f6e0e23aa482abe5661c16e69ef1e28371e2e236c359ba4e92c25626a7b7ff13f6ea4ae906e1cfe163e91719b1f750a96cbde5fbc953d9e576cd216afc90323a", "c2b7a22def0e5583a2ced2d4a295a0dc5cac7765e5ab94e9609cbf155ccbbf3a");
        TestDigest.testKatHex(new BLAKE256(), "f1c528cf7739874707d4d8ad5b98f7c77169de0b57188df233b2dc8a5b31eda5db4291dd9f68e6bad37b8d7f6c9c0044b3bf74bbc3d7d1798e138709b0d75e7c593d3cccdc1b20c7174b4e692add820ace262d45ccfae2077e878796347168060a162ecca8c38c1a88350bd63bb539134f700fd4addd5959e255337daa06bc86358fabcbefdfb5bc889783d843c08aadc6c4f6c36f65f156e851c9a0f917e4a367b5ad93d874812a1de6a7b93cd53ad97232", "3ccb149e7e8025d854b5a4ec8bab3622837ed7a5f89c019d26a42bb6dfef3074");
        TestDigest.testKatHex(new BLAKE256(), "9d9f3a7ecd51b41f6572fd0d0881e30390dfb780991dae7db3b47619134718e6f987810e542619dfaa7b505c76b7350c6432d8bf1cfebdf1069b90a35f0d04cbdf130b0dfc7875f4a4e62cdb8e525aadd7ce842520a482ac18f09442d78305fe85a74e39e760a4837482ed2f437dd13b2ec1042afcf9decdc3e877e50ff4106ad10a525230d11920324a81094da31deab6476aa42f20c84843cfc1c58545ee80352bdd3740dd6a16792ae2d86f11641bb717c2", "4856403fe69f0293fc655b95d01a026826d5fbc4ac5cd906c89e370afbc523ab");
        TestDigest.testKatHex(new BLAKE256(), "5179888724819fbad3afa927d3577796660e6a81c52d98e9303261d5a4a83232f6f758934d50aa83ff9e20a5926dfebaac49529d006eb923c5ae5048ed544ec471ed7191edf46363383824f915769b3e688094c682b02151e5ee01e510b431c8865aff8b6b6f2f59cb6d129da79e97c6d2b8fa6c6da3f603199d2d1bcab547682a81cd6cf65f6551121391d78bcc23b5bd0e922ec6d8bf97c952e84dd28aef909aba31edb903b28fbfc33b7703cd996215a11238", "41d77e6571e39028e57bb5896d57c085d30f12ed423de8994f146b0c244cfcf5");
        TestDigest.testKatHex(new BLAKE256(), "576ef3520d30b7a4899b8c0d5e359e45c5189add100e43be429a02fb3de5ff4f8fd0e79d9663acca72cd29c94582b19292a557c5b1315297d168fbb54e9e2ecd13809c2b5fce998edc6570545e1499dbe7fb74d47cd7f35823b212b05bf3f5a79caa34224fdd670d335fcb106f5d92c3946f44d3afcbae2e41ac554d8e6759f332b76be89a0324aa12c5482d1ea3ee89ded4936f3e3c080436f539fa137e74c6d3389bdf5a45074c47bc7b20b0948407a66d855e2f", "13fb8443c7490b1cbe9842a99a69d760ce51c347037f9ae1a01066953641f6e9");
        TestDigest.testKatHex(new BLAKE256(), "0df2152fa4f4357c8741529dd77e783925d3d76e95bafa2b542a2c33f3d1d117d159cf473f82310356fee4c90a9e505e70f8f24859656368ba09381fa245eb6c3d763f3093f0c89b972e66b53d59406d9f01aea07f8b3b615cac4ee4d05f542e7d0dab45d67ccccd3a606ccbeb31ea1fa7005ba07176e60dab7d78f6810ef086f42f08e595f0ec217372b98970cc6321576d92ce38f7c397a403bada1548d205c343ac09deca86325373c3b76d9f32028fea8eb32515", "7f4d4f09cf585ab8ff2b8bd432fd2c090b8eb9e6d9ee2a87f63f7f4b6de6a88e");
        TestDigest.testKatHex(new BLAKE256(), "3e15350d87d6ebb5c8ad99d42515cfe17980933c7a8f6b8bbbf0a63728cefaad2052623c0bd5931839112a48633fb3c2004e0749c87a41b26a8b48945539d1ff41a4b269462fd199bfecd45374756f55a9116e92093ac99451aefb2af9fd32d6d7f5fbc7f7a540d5097c096ebc3b3a721541de073a1cc02f7fb0fb1b9327fb0b1218ca49c9487ab5396622a13ae546c97abdef6b56380dda7012a8384091b6656d0ab272d363cea78163ff765cdd13ab1738b940d16cae", "f25fe32f288cda7a485074918a49cbd4c2290b13f3e4960d530b99a0d3661c66");
        TestDigest.testKatHex(new BLAKE256(), "c38d6b0b757cb552be40940ece0009ef3b0b59307c1451686f1a22702922800d58bce7a636c1727ee547c01b214779e898fc0e560f8ae7f61bef4d75eaa696b921fd6b735d171535e9edd267c192b99880c87997711002009095d8a7a437e258104a41a505e5ef71e5613ddd2008195f0c574e6ba3fe40099cfa116e5f1a2fa8a6da04badcb4e2d5d0de31fdc4800891c45781a0aac7c907b56d631fca5ce8b2cde620d11d1777ed9fa603541de794ddc5758fcd5fad78c0", "5a3fd997324783c6b7758cce29e641e580c2aac62dcb38c7b1dcab2922807521");
        TestDigest.testKatHex(new BLAKE256(), "8d2de3f0b37a6385c90739805b170057f091cd0c7a0bc951540f26a5a75b3e694631bb64c7635eed316f51318e9d8de13c70a2aba04a14836855f35e480528b776d0a1e8a23b547c8b8d6a0d09b241d3be9377160cca4e6793d00a515dc2992cb7fc741daca171431da99cce6f7789f129e2ac5cf65b40d703035cd2185bb936c82002daf8cbc27a7a9e554b06196630446a6f0a14ba155ed26d95bd627b7205c072d02b60db0fd7e49ea058c2e0ba202daff0de91e845cf79", "aa17fda17d2ecf6d17dd48725fc72b2f0e81f53349a4923ef6b556b2245b6773");
        TestDigest.testKatHex(new BLAKE256(), "c464bbdad275c50dcd983b65ad1019b9ff85a1e71c807f3204bb2c921dc31fbcd8c5fc45868ae9ef85b6c9b83bba2a5a822201ed68586ec5ec27fb2857a5d1a2d09d09115f22dcc39fe61f5e1ba0ff6e8b4acb4c6da748be7f3f0839739394ff7fa8e39f7f7e84a33c3866875c01bcb1263c9405d91908e9e0b50e7459fabb63d8c6bbb73d8e3483c099b55bc30ff092ff68b6adedfd477d63570c9f5515847f36e24ba0b705557130cec57ebad1d0b31a378e91894ee26e3a04", "6a9561677ebbe041fa2c90875e147a63ab8da53ba0864580aeaa0679c8180fab");
        TestDigest.testKatHex(new BLAKE256(), "8b8d68bb8a75732fe272815a68a1c9c5aa31b41dedc8493e76525d1d013d33cebd9e21a5bb95db2616976a8c07fcf411f5f6bc6f7e0b57aca78cc2790a6f9b898858ac9c79b165ff24e66677531e39f572be5d81eb3264524181115f32780257bfb9aeec6af12af28e587cac068a1a2953b59ad680f4c245b2e3ec36f59940d37e1d3db38e13edb29b5c0f404f6ff87f80fc8be7a225ff22fbb9c8b6b1d7330c57840d24bc75b06b80d30dad6806544d510af6c4785e823ac3e0b8", "90e235e455596158a9022afe81b86d89cdf03ae5738b25e78727c9d46eb5aa1b");
        TestDigest.testKatHex(new BLAKE256(), "6b018710446f368e7421f1bc0ccf562d9c1843846bc8d98d1c9bf7d9d6fcb48bfc3bf83b36d44c4fa93430af75cd190bde36a7f92f867f58a803900df8018150384d85d82132f123006ac2aeba58e02a037fe6afbd65eca7c44977dd3dc74f48b6e7a1bfd5cc4dcf24e4d52e92bd4455848e4928b0eac8b7476fe3cc03e862aa4dff4470dbfed6de48e410f25096487ecfc32a27277f3f5023b2725ade461b1355889554a8836c9cf53bd767f5737d55184eea1ab3f53edd0976c485", "3fb8d2afa87a90ab98955b4e82240a7bd7cf779d03a5375c049bfbc05be32fad");
        TestDigest.testKatHex(new BLAKE256(), "c9534a24714bd4be37c88a3da1082eda7cabd154c309d7bd670dccd95aa535594463058a29f79031d6ecaa9f675d1211e9359be82669a79c855ea8d89dd38c2c761ddd0ec0ce9e97597432e9a1beae062cdd71edfdfd464119be9e69d18a7a7fd7ce0e2106f0c8b0abf4715e2ca48ef9f454dc203c96656653b727083513f8efb86e49c513bb758b3b052fe21f1c05bb33c37129d6cc81f1aef6adc45b0e8827a830fe545cf57d0955802c117d23ccb55ea28f95c0d8c2f9c5a242b33f", "348228c78f0d6051ac26bb293a25c85ecca518fa9ec0bcde0e8a76ed71dd8d02");
        TestDigest.testKatHex(new BLAKE256(), "07906c87297b867abf4576e9f3cc7f82f22b154afcbf293b9319f1b0584da6a40c27b32e0b1b7f412c4f1b82480e70a9235b12ec27090a5a33175a2bb28d8adc475cefe33f7803f8ce27967217381f02e67a3b4f84a71f1c5228e0c2ad971373f6f672624fcea8d1a9f85170fad30fa0bbd25035c3b41a6175d467998bd1215f6f3866f53847f9cf68ef3e2fbb54bc994de2302b829c5eea68ec441fcbafd7d16ae4fe9fff98bf00e5bc2ad54dd91ff9fda4dd77b6c754a91955d1fbaad0", "135fdd756450b9cd60ae96e8f94fba1dae68bb115c441e7b025556c1d4c5542a");
        TestDigest.testKatHex(new BLAKE256(), "588e94b9054abc2189df69b8ba34341b77cdd528e7860e5defcaa79b0c9a452ad4b82aa306be84536eb7cedcbe058d7b84a6aef826b028b8a0271b69ac3605a9635ea9f5ea0aa700f3eb7835bc54611b922964300c953efe7491e3677c2cebe0822e956cd16433b02c68c4a23252c3f9e151a416b4963257b783e038f6b4d5c9f110f871652c7a649a7bcedcbccc6f2d0725bb903cc196ba76c76aa9f10a190b1d1168993baa9ffc96a1655216773458bec72b0e39c9f2c121378feab4e76a", "733b20df55216003deeb53f846ae05945073ad2463ddf38932a1f89f6487a15b");
        TestDigest.testKatHex(new BLAKE256(), "08959a7e4baae874928813364071194e2939772f20db7c3157078987c557c2a6d5abe68d520eef3dc491692e1e21bcd880adebf63bb4213b50897fa005256ed41b5690f78f52855c8d9168a4b666fce2da2b456d7a7e7c17ab5f2fb1ee90b79e698712e963715983fd07641ae4b4e9dc73203fac1ae11fa1f8c7941fcc82eab247addb56e2638447e9d609e610b60ce086656aaebf1da3c8a231d7d94e2fd0afe46b391ff14a72eaeb3f44ad4df85866def43d4781a0b3578bc996c87970b132", "e668c1b29fa473b1b408a6572883ad1f6d19f9e98c2dbf9dd80a806e01971316");
        TestDigest.testKatHex(new BLAKE256(), "cb2a234f45e2ecd5863895a451d389a369aab99cfef0d5c9ffca1e6e63f763b5c14fb9b478313c8e8c0efeb3ac9500cf5fd93791b789e67eac12fd038e2547cc8e0fc9db591f33a1e4907c64a922dda23ec9827310b306098554a4a78f050262db5b545b159e1ff1dca6eb734b872343b842c57eafcfda8405eedbb48ef32e99696d135979235c3a05364e371c2d76f1902f1d83146df9495c0a6c57d7bf9ee77e80f9787aee27be1fe126cdc9ef893a4a7dcbbc367e40fe4e1ee90b42ea25af01", "16d95c2c49428e83a2b233f9a457fc063c8060b8baee9e6e14330a2e4697bb36");
        TestDigest.testKatHex(new BLAKE256(), "d16beadf02ab1d4dc6f88b8c4554c51e866df830b89c06e786a5f8757e8909310af51c840efe8d20b35331f4355d80f73295974653ddd620cdde4730fb6c8d0d2dcb2b45d92d4fbdb567c0a3e86bd1a8a795af26fbf29fc6c65941cddb090ff7cd230ac5268ab4606fccba9eded0a2b5d014ee0c34f0b2881ac036e24e151be89eeb6cd9a7a790afccff234d7cb11b99ebf58cd0c589f20bdac4f9f0e28f75e3e04e5b3debce607a496d848d67fa7b49132c71b878fd5557e082a18eca1fbda94d4b", "d6e589f9efdb02f8eadceb0c3cbd2f6c124d21ffc285c865c37210a542d679e7");
        TestDigest.testKatHex(new BLAKE256(), "8f65f6bc59a85705016e2bae7fe57980de3127e5ab275f573d334f73f8603106ec3553016608ef2dd6e69b24be0b7113bf6a760ba6e9ce1c48f9e186012cf96a1d4849d75df5bb8315387fd78e9e153e76f8ba7ec6c8849810f59fb4bb9b004318210b37f1299526866f44059e017e22e96cbe418699d014c6ea01c9f0038b10299884dbec3199bb05adc94e955a1533219c1115fed0e5f21228b071f40dd57c4240d98d37b73e412fe0fa4703120d7c0c67972ed233e5deb300a22605472fa3a3ba86", "71ce35be3f5678864e97967efe59ae7aa043ec80760264d8374838aa87364310");
        TestDigest.testKatHex(new BLAKE256(), "84891e52e0d451813210c3fd635b39a03a6b7a7317b221a7abc270dfa946c42669aacbbbdf801e1584f330e28c729847ea14152bd637b3d0f2b38b4bd5bf9c791c58806281103a3eabbaede5e711e539e6a8b2cf297cf351c078b4fa8f7f35cf61bebf8814bf248a01d41e86c5715ea40c63f7375379a7eb1d78f27622fb468ab784aaaba4e534a6dfd1df6fa15511341e725ed2e87f98737ccb7b6a6dfae416477472b046bf1811187d151bfa9f7b2bf9acdb23a3be507cdf14cfdf517d2cb5fb9e4ab6", "8ebb40af11c7572012e0de2aca9260f7276c8fd3e7419d2c047ac238ecb7b5b5");
        TestDigest.testKatHex(new BLAKE256(), "fdd7a9433a3b4afabd7a3a5e3457e56debf78e84b7a0b0ca0e8c6d53bd0c2dae31b2700c6128334f43981be3b213b1d7a118d59c7e6b6493a86f866a1635c12859cfb9ad17460a77b4522a5c1883c3d6acc86e6162667ec414e9a104aa892053a2b1d72165a855bacd8faf8034a5dd9b716f47a0818c09bb6baf22aa503c06b4ca261f557761989d2afbd88b6a678ad128af68672107d0f1fc73c5ca740459297b3292b281e93bceb761bde7221c3a55708e5ec84472cddcaa84ecf23723cc0991355c6280", "0c828f3467d2cd08edd9badcf1963444c3ad270adf6e511f03c88349d8869b54");
        TestDigest.testKatHex(new BLAKE256(), "70a40bfbef92277a1aad72f6b79d0177197c4ebd432668cfec05d099accb651062b5dff156c0b27336687a94b26679cfdd9daf7ad204338dd9c4d14114033a5c225bd11f217b5f4732da167ee3f939262d4043fc9cba92303b7b5e96aea12adda64859df4b86e9ee0b58e39091e6b188b408ac94e1294a8911245ee361e60e601eff58d1d37639f3753bec80ebb4efde25817436076623fc65415fe51d1b0280366d12c554d86743f3c3b6572e400361a60726131441ba493a83fbe9afda90f7af1ae717238d", "313a38d32b97476b9b28ce8fe6b81377713f9833d6256e7ba2570adbefdc15a4");
        TestDigest.testKatHex(new BLAKE256(), "74356e449f4bf8644f77b14f4d67cb6bd9c1f5ae357621d5b8147e562b65c66585caf2e491b48529a01a34d226d436959153815380d5689e30b35357cdac6e08d3f2b0e88e200600d62bd9f5eaf488df86a4470ea227006182e44809009868c4c280c43d7d64a5268fa719074960087b3a6abc837882f882c837834535929389a12b2c78187e2ea07ef8b8eef27dc85002c3ae35f1a50bee6a1c48ba7e175f3316670b27983472aa6a61eed0a683a39ee323080620ea44a9f74411ae5ce99030528f9ab49c79f2", "72880b5673f50c071b59a625f4210d4e5104e76d8bcc250a636d86f359f03d52");
        TestDigest.testKatHex(new BLAKE256(), "8c3798e51bc68482d7337d3abb75dc9ffe860714a9ad73551e120059860dde24ab87327222b64cf774415a70f724cdf270de3fe47dda07b61c9ef2a3551f45a5584860248fabde676e1cd75f6355aa3eaeabe3b51dc813d9fb2eaa4f0f1d9f834d7cad9c7c695ae84b329385bc0bef895b9f1edf44a03d4b410cc23a79a6b62e4f346a5e8dd851c2857995ddbf5b2d717aeb847310e1f6a46ac3d26a7f9b44985af656d2b7c9406e8a9e8f47dcb4ef6b83caacf9aefb6118bfcff7e44bef6937ebddc89186839b77", "0f7dce85d2ccdd765235e016caf17075c278727c1e433608aeffa2799352225e");
        TestDigest.testKatHex(new BLAKE256(), "fa56bf730c4f8395875189c10c4fb251605757a8fecc31f9737e3c2503b02608e6731e85d7a38393c67de516b85304824bfb135e33bf22b3a23b913bf6acd2b7ab85198b8187b2bcd454d5e3318cacb32fd6261c31ae7f6c54ef6a7a2a4c9f3ecb81ce3555d4f0ad466dd4c108a90399d70041997c3b25345a9653f3c9a6711ab1b91d6a9d2216442da2c973cbd685ee7643bfd77327a2f7ae9cb283620a08716dfb462e5c1d65432ca9d56a90e811443cd1ecb8f0de179c9cb48ba4f6fec360c66f252f6e64edc96b", "cbdc6acd2ec50b59d14aab724285f541f44860acb559dc8c34a0d2510febfe0e");
        TestDigest.testKatHex(new BLAKE256(), "b6134f9c3e91dd8000740d009dd806240811d51ab1546a974bcb18d344642baa5cd5903af84d58ec5ba17301d5ec0f10ccd0509cbb3fd3fff9172d193af0f782252fd1338c7244d40e0e42362275b22d01c4c3389f19dd69bdf958ebe28e31a4ffe2b5f18a87831cfb7095f58a87c9fa21db72ba269379b2dc2384b3da953c7925761fed324620acea435e52b424a7723f6a2357374157a34cd8252351c25a1b232826cefe1bd3e70ffc15a31e7c0598219d7f00436294d11891b82497bc78aa5363892a2495df8c1eef", "c5306c224bebafd19eb92fa480bd10a7d332279856f1ad7b37d2cae1b9b999ed");
        TestDigest.testKatHex(new BLAKE256(), "c941cdb9c28ab0a791f2e5c8e8bb52850626aa89205bec3a7e22682313d198b1fa33fc7295381354858758ae6c8ec6fac3245c6e454d16fa2f51c4166fab51df272858f2d603770c40987f64442d487af49cd5c3991ce858ea2a60dab6a65a34414965933973ac2457089e359160b7cdedc42f29e10a91921785f6b7224ee0b349393cdcff6151b50b377d609559923d0984cda6000829b916ab6896693ef6a2199b3c22f7dc5500a15b8258420e314c222bc000bc4e5413e6dd82c993f8330f5c6d1be4bc79f08a1a0a46", "8d2e8fcc878cfc6843247debf62a89e3844c94d32920937f83a9c378ffe97cd0");
        TestDigest.testKatHex(new BLAKE256(), "4499efffac4bcea52747efd1e4f20b73e48758be915c88a1ffe5299b0b005837a46b2f20a9cb3c6e64a9e3c564a27c0f1c6ad1960373036ec5bfe1a8fc6a435c2185ed0f114c50e8b3e4c7ed96b06a036819c9463e864a58d6286f785e32a804443a56af0b4df6abc57ed5c2b185ddee8489ea080deeee66aa33c2e6dab36251c402682b6824821f998c32163164298e1fafd31babbcffb594c91888c6219079d907fdb438ed89529d6d96212fd55abe20399dbefd342248507436931cdead496eb6e4a80358acc78647d043", "eafe83d51c716d4761554f55be42d586f50fdc9dc39a2f932dc06e950669dfc4");
        TestDigest.testKatHex(new BLAKE256(), "eecbb8fdfa4da62170fd06727f697d81f83f601ff61e478105d3cb7502f2c89bf3e8f56edd469d049807a38882a7eefbc85fc9a950952e9fa84b8afebd3ce782d4da598002827b1eb98882ea1f0a8f7aa9ce013a6e9bc462fb66c8d4a18da21401e1b93356eb12f3725b6db1684f2300a98b9a119e5d27ff704affb618e12708e77e6e5f34139a5a41131fd1d6336c272a8fc37080f041c71341bee6ab550cb4a20a6ddb6a8e0299f2b14bc730c54b8b1c1c487b494bdccfd3a53535ab2f231590bf2c4062fd2ad58f906a2d0d", "82a80f1b11ed92bbddc5ef6b90b1bca76a26878359c1b14b59b90282f71b0b2c");
        TestDigest.testKatHex(new BLAKE256(), "e64f3e4ace5c8418d65fec2bc5d2a303dd458034736e3b0df719098be7a206deaf52d6ba82316caf330ef852375188cde2b39cc94aa449578a7e2a8e3f5a9d68e816b8d16889fbc0ebf0939d04f63033ae9ae2bdab73b88c26d6bd25ee460ee1ef58fb0afa92cc539f8c76d3d097e7a6a63ebb9b5887edf3cf076028c5bbd5b9db3211371ad3fe121d4e9bf44229f4e1ecf5a0f9f0eba4d5ceb72878ab22c3f0eb5a625323ac66f7061f4a81fac834471e0c59553f108475fe290d43e6a055ae3ee46fb67422f814a68c4be3e8c9", "eff240f24a8e7f37ceff92b73e18f34afcad14fc419055e9ec359e6c2bd3af4e");
        TestDigest.testKatHex(new BLAKE256(), "d2cb2d733033f9e91395312808383cc4f0ca974e87ec68400d52e96b3fa6984ac58d9ad0938dde5a973008d818c49607d9de2284e7618f1b8aed8372fbd52ed54557af4220fac09dfa8443011699b97d743f8f2b1aef3537ebb45dcc9e13dfb438428ee190a4efdb3caeb7f3933117bf63abdc7e57beb4171c7e1ad260ab0587806c4d137b6316b50abc9cce0dff3acada47bbb86be777e617bbe578ff4519844db360e0a96c6701290e76bb95d26f0f804c8a4f2717eac4e7de9f2cff3bbc55a17e776c0d02856032a6cd10ad2838", "7985f2ebee310f6f307cf438fe162a57cba90e1bdd5522c51c927525f98c7e97");
        TestDigest.testKatHex(new BLAKE256(), "f2998955613dd414cc111df5ce30a995bb792e260b0e37a5b1d942fe90171a4ac2f66d4928d7ad377f4d0554cbf4c523d21f6e5f379d6f4b028cdcb9b1758d3b39663242ff3cb6ede6a36a6f05db3bc41e0d861b384b6dec58bb096d0a422fd542df175e1be1571fb52ae66f2d86a2f6824a8cfaacbac4a7492ad0433eeb15454af8f312b3b2a577750e3efbd370e8a8cac1582581971fba3ba4bd0d76e718dacf8433d33a59d287f8cc92234e7a271041b526e389efb0e40b6a18b3aaf658e82ed1c78631fd23b4c3eb27c3faec8685", "0146b3848391f9bd60ac650ccfdd49a0fe60f18aa044a16d10d10189fce7f15b");
        TestDigest.testKatHex(new BLAKE256(), "447797e2899b72a356ba55bf4df3acca6cdb1041eb477bd1834a9f9acbc340a294d729f2f97df3a610be0ff15edb9c6d5db41644b9874360140fc64f52aa03f0286c8a640670067a84e017926a70438db1bb361defee7317021425f8821def26d1efd77fc853b818545d055adc9284796e583c76e6fe74c9ac2587aa46aa8f8804f2feb5836cc4b3ababab8429a5783e17d5999f32242eb59ef30cd7adabc16d72dbdb097623047c98989f88d14eaf02a7212be16ec2d07981aaa99949ddf89ecd90333a77bc4e1988a82abf7c7caf3291", "718a00ed31d5375aa4e9dc26d5621e21d0901f9e1569e237e6535bd4e5d5f363");
        TestDigest.testKatHex(new BLAKE256(), "9f2c18ade9b380c784e170fb763e9aa205f64303067eb1bcea93df5dac4bf5a2e00b78195f808df24fc76e26cb7be31dc35f0844cded1567bba29858cffc97fb29010331b01d6a3fb3159cc1b973d255da9843e34a0a4061cabdb9ed37f241bfabb3c20d32743f4026b59a4ccc385a2301f83c0b0a190b0f2d01acb8f0d41111e10f2f4e149379275599a52dc089b35fdd5234b0cfb7b6d8aebd563ca1fa653c5c021dfd6f5920e6f18bfafdbecbf0ab00281333ed50b9a999549c1c8f8c63d7626c48322e9791d5ff72294049bde91e73f8", "b17366f76307d583f52c211f4a025d032a1eb573a995ff9c3c1e31df014bd709");
        TestDigest.testKatHex(new BLAKE256(), "ae159f3fa33619002ae6bcce8cbbdd7d28e5ed9d61534595c4c9f43c402a9bb31f3b301cbfd4a43ce4c24cd5c9849cc6259eca90e2a79e01ffbac07ba0e147fa42676a1d668570e0396387b5bcd599e8e66aaed1b8a191c5a47547f61373021fa6deadcb55363d233c24440f2c73dbb519f7c9fa5a8962efd5f6252c0407f190dfefad707f3c7007d69ff36b8489a5b6b7c557e79dd4f50c06511f599f56c896b35c917b63ba35c6ff8092baf7d1658e77fc95d8a6a43eeb4c01f33f03877f92774be89c1114dd531c011e53a34dc248a2f0e6", "389724e7e0f8af0fae8dea24ab3c3e343df97adbafb624f341bd4df0bf1de40c");
        TestDigest.testKatHex(new BLAKE256(), "3b8e97c5ffc2d6a40fa7de7fcefc90f3b12c940e7ab415321e29ee692dfac799b009c99dcddb708fce5a178c5c35ee2b8617143edc4c40b4d313661f49abdd93cea79d117518805496fe6acf292c4c2a1f76b403a97d7c399daf85b46ad84e16246c67d6836757bde336c290d5d401e6c1386ab32797af6bb251e9b2d8fe754c47482b72e0b394eab76916126fd68ea7d65eb93d59f5b4c5ac40f7c3b37e7f3694f29424c24af8c8f0ef59cd9dbf1d28e0e10f799a6f78cad1d45b9db3d7dee4a7059abe99182714983b9c9d44d7f5643596d4f3", "d6c2cb98a9f5ce5ca862f0188cb928aec4e3db5ab341829fda81753abb71db64");
        TestDigest.testKatHex(new BLAKE256(), "3434ec31b10fafdbfeec0dd6bd94e80f7ba9dca19ef075f7eb017512af66d6a4bcf7d16ba0819a1892a6372f9b35bcc7ca8155ee19e8428bc22d214856ed5fa9374c3c09bde169602cc219679f65a1566fc7316f4cc3b631a18fb4449fa6afa16a3db2bc4212eff539c67cf184680826535589c7111d73bffce431b4c40492e763d9279560aaa38eb2dc14a212d723f994a1fe656ff4dd14551ce4e7c621b2aa5604a10001b2878a897a28a08095c325e10a26d2fb1a75bfd64c250309bb55a44f23bbac0d5516a1c687d3b41ef2fbbf9cc56d4739", "77e624db0016d71adfa33d77eabac4912a2f32c5a403d12b13ae9dffa6e65492");
        TestDigest.testKatHex(new BLAKE256(), "7c7953d81c8d208fd1c97681d48f49dd003456de60475b84070ef4847c333b74575b1fc8d2a186964485a3b8634feaa3595aaa1a2f4595a7d6b6153563dee31bbac443c8a33eed6d5d956a980a68366c2527b550ee950250dfb691eacbd5d56ae14b970668be174c89df2fea43ae52f13142639c884fd62a3683c0c3792f0f24ab1318bcb27e21f4737fab62c77ea38bc8fd1cf41f7dab64c13febe7152bf5bb7ab5a78f5346d43cc741cb6f72b7b8980f268b68bf62abdfb1577a52438fe14b591498cc95f071228460c7c5d5ceb4a7bde588e7f21c", "88c4852ec2ceaf975d72a6d47bdfcd800797ed730fa528446f6168da6140005d");
        TestDigest.testKatHex(new BLAKE256(), "7a6a4f4fdc59a1d223381ae5af498d74b7252ecf59e389e49130c7eaee626e7bd9897effd92017f4ccde66b0440462cdedfd352d8153e6a4c8d7a0812f701cc737b5178c2556f07111200eb627dbc299caa792dfa58f35935299fa3a3519e9b03166dffa159103ffa35e8577f7c0a86c6b46fe13db8e2cdd9dcfba85bdddcce0a7a8e155f81f712d8e9fe646153d3d22c811bd39f830433b2213dd46301941b59293fd0a33e2b63adbd95239bc01315c46fdb678875b3c81e053a40f581cfbec24a1404b1671a1b88a6d06120229518fb13a74ca0ac5ae", "30f68700be6fd947d523cfa5710435364cf1ccd4ae2c472759ef47404c4be0f2");
        TestDigest.testKatHex(new BLAKE256(), "d9faa14cebe9b7de551b6c0765409a33938562013b5e8e0e1e0a6418df7399d0a6a771fb81c3ca9bd3bb8e2951b0bc792525a294ebd1083688806fe5e7f1e17fd4e3a41d00c89e8fcf4a363caedb1acb558e3d562f1302b3d83bb886ed27b76033798131dab05b4217381eaaa7ba15ec820bb5c13b516dd640eaec5a27d05fdfca0f35b3a5312146806b4c0275bcd0aaa3b2017f346975db566f9b4d137f4ee10644c2a2da66deeca5342e236495c3c6280528bfd32e90af4cd9bb908f34012b52b4bc56d48cc8a6b59bab014988eabd12e1a0a1c2e170e7", "a1a1230b5c360e14d1a8f538abc89efa63eeebb567c4833a49a184eab6e5960b");
        TestDigest.testKatHex(new BLAKE256(), "2d8427433d0c61f2d96cfe80cf1e932265a191365c3b61aaa3d6dcc039f6ba2ad52a6a8cc30fc10f705e6b7705105977fa496c1c708a277a124304f1fc40911e7441d1b5e77b951aad7b01fd5db1b377d165b05bbf898042e39660caf8b279fe5229d1a8db86c0999ed65e53d01ccbc4b43173ccf992b3a14586f6ba42f5fe30afa8ae40c5df29966f9346da5f8b35f16a1de3ab6de0f477d8d8660918060e88b9b9e9ca6a4207033b87a812dbf5544d39e4882010f82b6ce005f8e8ff6fe3c3806bc2b73c2b83afb704345629304f9f86358712e9fae3ca3e", "0be6ab58bb34ae7640c0d31e548c8100defb9e9013187d7628331432fdda37a0");
        TestDigest.testKatHex(new BLAKE256(), "5e19d97887fcaac0387e22c6f803c34a3dacd2604172433f7a8a7a526ca4a2a1271ecfc5d5d7be5ac0d85d921095350dfc65997d443c21c8094e0a3fefd2961bcb94aed03291ae310ccda75d8ace4bc7d89e7d3e5d1650bda5d668b8b50bfc8e608e184f4d3a9a2badc4ff5f07e0c0bc8a9f2e0b2a26fd6d8c550008faaab75fd71af2a424bec9a7cd9d83fad4c8e9319115656a8717d3b523a68ff8004258b9990ed362308461804ba3e3a7e92d8f2ffae5c2fba55ba5a3c27c0a2f71bd711d2fe1799c2adb31b200035481e9ee5c4adf2ab9c0fa50b23975cf", "8539f8d93bb669908b34440c219980a3c0195768e5cf751e07045afe4fcfea05");
        TestDigest.testKatHex(new BLAKE256(), "c8e976ab4638909387ce3b8d4e510c3230e5690e02c45093b1d297910abc481e56eea0f296f98379dfc9080af69e73b2399d1c143bee80ae1328162ce1ba7f6a8374679b20aacd380eb4e61382c99998704d62701afa914f9a2705cdb065885f50d086c3eb5753700c387118bb142f3e6da1e988dfb31ac75d7368931e45d1391a274b22f83ceb072f9bcabc0b216685bfd789f5023971024b1878a205442522f9ea7d8797a4102a3df41703768251fd5e017c85d1200a464118aa35654e7ca39f3c375b8ef8cbe7534dbc64bc20befb417cf60ec92f63d9ee7397", "1fa468b1b220013035925acb87dee25c5bb4f734599784c66628cb81b6a8d7a4");
        TestDigest.testKatHex(new BLAKE256(), "7145fa124b7429a1fc2231237a949ba7201bcc1822d3272de005b682398196c25f7e5cc2f289fbf44415f699cb7fe6757791b1443410234ae061edf623359e2b4e32c19bf88450432dd01caa5eb16a1dc378f391ca5e3c4e5f356728bddd4975db7c890da8bbc84cc73ff244394d0d48954978765e4a00b593f70f2ca082673a261ed88dbcef1127728d8cd89bc2c597e9102ced6010f65fa75a14ebe467fa57ce3bd4948b6867d74a9df5c0ec6f530cbf2ee61ce6f06bc8f2864dff5583776b31df8c7ffcb61428a56bf7bd37188b4a5123bbf338393af46eda85e6", "5bedb760cb1b6f713eb4479069d2962a50befec45850064651191f1bcc536be2");
        TestDigest.testKatHex(new BLAKE256(), "7fdfadcc9d29bad23ae038c6c65cda1aef757221b8872ed3d75ff8df7da0627d266e224e812c39f7983e4558bfd0a1f2bef3feb56ba09120ef762917b9c093867948547aee98600d10d87b20106878a8d22c64378bf634f7f75900c03986b077b0bf8b740a82447b61b99fee5376c5eb6680ec9e3088f0bdd0c56883413d60c1357d3c811950e5890e7600103c916341b80c743c6a852b7b4fb60c3ba21f3bc15b8382437a68454779cf3cd7f9f90ccc8ef28d0b706535b1e4108eb5627bb45d719cb046839aee311ca1abdc8319e050d67972cb35a6b1601b25dbf487", "a9f6370705bd8be565645567ba02a77cf84f359acc912993a72aee709f9687f1");
        TestDigest.testKatHex(new BLAKE256(), "988638219fd3095421f826f56e4f09e356296b628c3ce6930c9f2e758fd1a80c8273f2f61e4daae65c4f110d3e7ca0965ac7d24e34c0dc4ba2d6ff0bf5bbe93b3585f354d7543cb542a1aa54674d375077f2d360a8f4d42f3db131c3b7ab7306267ba107659864a90c8c909460a73621d1f5d9d3fd95beb19b23db1cb6c0d0fba91d36891529b8bd8263caa1bab56a4affaed44962df096d8d5b1eb845ef31188b3e10f1af811a13f156beb7a288aae593ebd1471b624aa1a7c6adf01e2200b3d72d88a3aed3100c88231e41efc376906f0b580dc895f080fda5741db1cb", "6afbd061f024f85fadf64d1151f87be6c5d0322580a36a0ec6c7a439182404ca");
        TestDigest.testKatHex(new BLAKE256(), "5aab62756d307a669d146aba988d9074c5a159b3de85151a819b117ca1ff6597f6156e80fdd28c9c3176835164d37da7da11d94e09add770b68a6e081cd22ca0c004bfe7cd283bf43a588da91f509b27a6584c474a4a2f3ee0f1f56447379240a5ab1fb77fdca49b305f07ba86b62756fb9efb4fc225c86845f026ea542076b91a0bc2cdd136e122c659be259d98e5841df4c2f60330d4d8cdee7bf1a0a244524eecc68ff2aef5bf0069c9e87a11c6e519de1a4062a10c83837388f7ef58598a3846f49d499682b683c4a062b421594fafbc1383c943ba83bdef515efcf10d", "39945efa3a76c7a7d1caa901d912d42c3e36d9759c16e1bf15abb39f53856f8d");
        TestDigest.testKatHex(new BLAKE256(), "47b8216aa0fbb5d67966f2e82c17c07aa2d6327e96fcd83e3de7333689f3ee79994a1bf45082c4d725ed8d41205cb5bcdf5c341f77facb1da46a5b9b2cbc49eadf786bcd881f371a95fa17df73f606519aea0ff79d5a11427b98ee7f13a5c00637e2854134691059839121fea9abe2cd1bcbbbf27c74caf3678e05bfb1c949897ea01f56ffa4dafbe8644611685c617a3206c7a7036e4ac816799f693dafe7f19f303ce4eba09d21e03610201bfc665b72400a547a1e00fa9b7ad8d84f84b34aef118515e74def11b9188bd1e1f97d9a12c30132ec2806339bdadacda2fd8b78", "c88f730c14a7b34d3b41e6d368a1370d6d773665bff573c32effe950e0045dc8");
        TestDigest.testKatHex(new BLAKE256(), "8cff1f67fe53c098896d9136389bd8881816ccab34862bb67a656e3d98896f3ce6ffd4da73975809fcdf9666760d6e561c55238b205d8049c1cedeef374d1735daa533147bfa960b2cce4a4f254176bb4d1bd1e89654432b8dbe1a135c42115b394b024856a2a83dc85d6782be4b444239567ccec4b184d4548eae3ff6a192f343292ba2e32a0f267f31cc26719eb85245d415fb897ac2da433ee91a99424c9d7f1766a44171d1651001c38fc79294accc68ceb5665d36218454d3ba169ae058a831338c17743603f81ee173bfc0927464f9bd728dee94c6aeab7aae6ee3a627e8", "593be66e2c5c96c5019ce038e84d5e3f5c99d745b91cf4507cdbaf4d846009c8");
        TestDigest.testKatHex(new BLAKE256(), "eacd07971cff9b9939903f8c1d8cbb5d4db1b548a85d04e037514a583604e787f32992bf2111b97ac5e8a938233552731321522ab5e8583561260b7d13ebeef785b23a41fd8576a6da764a8ed6d822d4957a545d5244756c18aa80e1aad4d1f9c20d259dee1711e2cc8fd013169fb7cc4ce38b362f8e0936ae9198b7e838dcea4f7a5b9429bb3f6bbcf2dc92565e3676c1c5e6eb3dd2a0f86aa23edd3d0891f197447692794b3dfa269611ad97f72b795602b4fdb198f3fd3eb41b415064256e345e8d8c51c555dc8a21904a9b0f1ad0effab7786aac2da3b196507e9f33ca356427", "c1455e3d7f3dcdd64eba0b32d64518578713c241bb73d88847df3a16cabde318");
        TestDigest.testKatHex(new BLAKE256(), "23ac4e9a42c6ef45c3336ce6dfc2ff7de8884cd23dc912fef0f7756c09d335c189f3ad3a23697abda851a81881a0c8ccafc980ab2c702564c2be15fe4c4b9f10dfb2248d0d0cb2e2887fd4598a1d4acda897944a2ffc580ff92719c95cf2aa42dc584674cb5a9bc5765b9d6ddf5789791d15f8dd925aa12bffafbce60827b490bb7df3dda6f2a143c8bf96abc903d83d59a791e2d62814a89b8080a28060568cf24a80ae61179fe84e0ffad00388178cb6a617d37efd54cc01970a4a41d1a8d3ddce46edbba4ab7c90ad565398d376f431189ce8c1c33e132feae6a8cd17a61c630012", "85c14348d396111ec5ce76500d87cf46f99a22e6f569dbc4cedc5d9d129b38f5");
        TestDigest.testKatHex(new BLAKE256(), "0172df732282c9d488669c358e3492260cbe91c95cfbc1e3fea6c4b0ec129b45f242ace09f152fc6234e1bee8aab8cd56e8b486e1dcba9c05407c2f95da8d8f1c0af78ee2ed82a3a79ec0cb0709396ee62aadb84f8a4ee8a7ccca3c1ee84e302a09ea802204afecf04097e67d0f8e8a9d2651126c0a598a37081e42d168b0ae8a71951c524259e4e2054e535b779679bdade566fe55700858618e626b4a0faf895bcce9011504a49e05fd56127eae3d1f8917afb548ecadabda1020111fec9314c413498a360b08640549a22cb23c731ace743252a8227a0d2689d4c6001606678dfb921", "2072345a273c2f8f5a060e97a567ea70a4471a78953fd7af0fbd9acba9978990");
        TestDigest.testKatHex(new BLAKE256(), "3875b9240cf3e0a8b59c658540f26a701cf188496e2c2174788b126fd29402d6a75453ba0635284d08835f40051a2a9683dc92afb9383719191231170379ba6f4adc816fecbb0f9c446b785bf520796841e58878b73c58d3ebb097ce4761fdeabe15de2f319dfbaf1742cdeb389559c788131a6793e193856661376c81ce9568da19aa6925b47ffd77a43c7a0e758c37d69254909ff0fbd415ef8eb937bcd49f91468b49974c07dc819abd67395db0e05874ff83dddab895344abd0e7111b2df9e58d76d85ad98106b36295826be04d435615595605e4b4bb824b33c4afeb5e7bb0d19f909", "81dff0b99f2d0af83f56700ed14bf214c2c94181c6f3abacc5b33e07a2b7ef89");
        TestDigest.testKatHex(new BLAKE256(), "747cc1a59fefba94a9c75ba866c30dc5c1cb0c0f8e9361d98484956dd5d1a40f6184afbe3dac9f76028d1caeccfbf69199c6ce2b4c092a3f4d2a56fe5a33a00757f4d7dee5dfb0524311a97ae0668a47971b95766e2f6dd48c3f57841f91f04a00ad5ea70f2d479a2620dc5cd78eaab3a3b011719b7e78d19ddf70d9423798af77517ebc55392fcd01fc600d8d466b9e7a7a85bf33f9cc5419e9bd874ddfd60981150ddaf8d7febaa4374f0872a5628d318000311e2f5655365ad4d407c20e5c04df17a222e7deec79c5ab1116d8572f91cd06e1ccc7ced53736fc867fd49ecebe6bf8082e8a", "a90fba78a75aa9cda52d0b0937330edf55d46fc2474c29388e1a40978ccc6ffc");
        TestDigest.testKatHex(new BLAKE256(), "57af971fccaec97435dc2ec9ef0429bcedc6b647729ea168858a6e49ac1071e706f4a5a645ca14e8c7746d65511620682c906c8b86ec901f3dded4167b3f00b06cbfac6aee3728051b3e5ff10b4f9ed8bd0b8da94303c833755b3ca3aeddf0b54bc8d6632138b5d25bab03d17b3458a9d782108006f5bb7de75b5c0ba854b423d8bb801e701e99dc4feaad59bc1c7112453b04d33ea3635639fb802c73c2b71d58a56bbd671b18fe34ed2e3dca38827d63fdb1d4fb3285405004b2b3e26081a8ff08cd6d2b08f8e7b7e90a2ab1ed7a41b1d0128522c2f8bff56a7fe67969422ce839a9d4608f03", "b953444533c87532ebde64faef511eb8cced6a99007cce8cbffda7f86dbaa482");
        TestDigest.testKatHex(new BLAKE256(), "04e16dedc1227902baaf332d3d08923601bdd64f573faa1bb7201918cfe16b1e10151dae875da0c0d63c59c3dd050c4c6a874011b018421afc4623ab0381831b2da2a8ba42c96e4f70864ac44e106f94311051e74c77c1291bf5db9539e69567bf6a11cf6932bbbad33f8946bf5814c066d851633d1a513510039b349939bfd42b858c21827c8ff05f1d09b1b0765dc78a135b5ca4dfba0801bcaddfa175623c8b647eacfb4444b85a44f73890607d06d507a4f8393658788669f6ef4deb58d08c50ca0756d5e2f49d1a7ad73e0f0b3d3b5f090acf622b1878c59133e4a848e05153592ea81c6fbf", "89ba5316a8c4aaa899d63b23ce0d30a54dd9f3f03eda58d9e83b1bc3b7f20902");
        TestDigest.testKatHex(new BLAKE256(), "7c815c384eee0f288ece27cced52a01603127b079c007378bc5d1e6c5e9e6d1c735723acbbd5801ac49854b2b569d4472d33f40bbb8882956245c366dc3582d71696a97a4e19557e41e54dee482a14229005f93afd2c4a7d8614d10a97a9dfa07f7cd946fa45263063ddd29db8f9e34db60daa32684f0072ea2a9426ecebfa5239fb67f29c18cbaa2af6ed4bf4283936823ac1790164fec5457a9cba7c767ca59392d94cab7448f50eb34e9a93a80027471ce59736f099c886dea1ab4cba4d89f5fc7ae2f21ccd27f611eca4626b2d08dc22382e92c1efb2f6afdc8fdc3d2172604f5035c46b8197d3", "df00136d02abce412f093ac9dd83448cd9e50535c9565d105d723ae0859fc3c9");
        TestDigest.testKatHex(new BLAKE256(), "e29d505158dbdd937d9e3d2145658ee6f5992a2fc790f4f608d9cdb44a091d5b94b88e81fac4fdf5c49442f13b911c55886469629551189eaff62488f1a479b7db11a1560e198ddccccf50159093425ff7f1cb8d1d1246d0978764087d6bac257026b090efae8cec5f22b6f21c59ace1ac7386f5b8837ca6a12b6fbf5534dd0560ef05ca78104d3b943ddb220feaec89aa5e692a00f822a2ab9a2fe60350d75e7be16ff2526dc643872502d01f42f188abed0a6e9a6f5fd0d1ce7d5755c9ffa66b0af0b20bd806f08e06156690d81ac811778ca3dac2c249b96002017fce93e507e3b953acf99964b847", "b8fc7e6eda0086aa84ff61f92f2b7be06aa3b2465196f5580a6c0dcf1386c516");
        TestDigest.testKatHex(new BLAKE256(), "d85588696f576e65eca0155f395f0cfacd83f36a99111ed5768df2d116d2121e32357ba4f54ede927f189f297d3a97fad4e9a0f5b41d8d89dd7fe20156799c2b7b6bf9c957ba0d6763f5c3bc5129747bbb53652b49290cff1c87e2cdf2c4b95d8aaee09bc8fbfa6883e62d237885810491bfc101f1d8c636e3d0ede838ad05c207a3df4fad76452979eb99f29afaecedd1c63b8d36cf378454a1bb67a741c77ac6b6b3f95f4f02b64dabc15438613ea49750df42ee90101f115aa9abb9ff64324dde9dabbb01054e1bd6b4bcdc7930a44c2300d87ca78c06924d0323ad7887e46c90e8c4d100acd9eed21e", "df47d9543ea09b04851efa7df647b63d3b991699af4b277f14829d6c75f47906");
        TestDigest.testKatHex(new BLAKE256(), "3a12f8508b40c32c74492b66323375dcfe49184c78f73179f3314b79e63376b8ac683f5a51f1534bd729b02b04d002f55cbd8e8fc9b5ec1ea6bbe6a0d0e7431518e6ba45d124035f9d3dce0a8bb7bf1430a9f657e0b4ea9f20eb20c786a58181a1e20a96f1628f8728a13bdf7a4b4b32fc8aa7054cc4881ae7fa19afa65c6c3ee1b3ade3192af42054a8a911b8ec1826865d46d93f1e7c5e2b7813c92a506e53886f3d4701bb93d2a681ad109c845904bb861af8af0646b6e399b38b614051d34f6842563a0f37ec00cb3d865fc5d746c4987de2a65071100883a2a9c7a2bfe1e2dd603d9ea24dc7c5fd06be", "85d560b1517bd45c88c130a7e8fe3b080291deb162c7c5977a6ace13fcfeffec");
        TestDigest.testKatHex(new BLAKE256(), "1861edce46fa5ad17e1ff1deae084dec580f97d0a67885dfe834b9dfac1ae076742ce9e267512ca51f6df5a455af0c5fd6abf94acea103a3370c354485a7846fb84f3ac7c2904b5b2fbf227002ce512133bb7e1c4e50057bfd1e44db33c7cdb969a99e284b184f50a14b068a1fc5009d9b298dbe92239572a7627aac02abe8f3e3b473417f36d4d2505d16b7577f4526c9d94a270a2dfe450d06da8f6fa956879a0a55cfe99e742ea555ea477ba3e9b44ccd508c375423611af92e55345dc215779b2d5119eba49c71d49b9fe3f1569fa24e5ca3e332d042422a8b8158d3ec66a80012976f31ffdf305f0c9c5e", "96f65533fd89b8a48a0cb5e3b7e60fec3b1773f8bbc75d89e4773da423d4f3c7");
        TestDigest.testKatHex(new BLAKE256(), "08d0ffde3a6e4ef65608ea672e4830c12943d7187ccff08f4941cfc13e545f3b9c7ad5eebbe2b01642b486caf855c2c73f58c1e4e3391da8e2d63d96e15fd84953ae5c231911b00ad6050cd7aafdaac9b0f663ae6aab45519d0f5391a541707d479034e73a6ad805ae3598096af078f1393301493d663dd71f83869ca27ba508b7e91e81e128c1716dc3acfe3084b2201e04cf8006617eecf1b640474a5d45cfde9f4d3ef92d6d055b909892194d8a8218db6d8203a84261d200d71473d7488f3427416b6896c137d455f231071cacbc86e0415ab88aec841d96b7b8af41e05bb461a40645bf176601f1e760de5f", "122a894106b7ab1e52677fdb432d1db0b70187815d704b978acd5c2548a31626");
        TestDigest.testKatHex(new BLAKE256(), "d782abb72a5be3392757be02d3e45be6e2099d6f000d042c8a543f50ed6ebc055a7f133b0dd8e9bc348536edcaae2e12ec18e8837df7a1b3c87ec46d50c241dee820fd586197552dc20beea50f445a07a38f1768a39e2b2ff05dddedf751f1def612d2e4d810daa3a0cc904516f9a43af660315385178a529e51f8aae141808c8bc5d7b60cac26bb984ac1890d0436ef780426c547e94a7b08f01acbfc4a3825eae04f520a9016f2fb8bf5165ed12736fc71e36a49a73614739eaa3ec834069b1b40f1350c2b3ab885c02c640b9f7686ed5f99527e41cfcd796fe4c256c9173186c226169ff257954ebda81c0e5f99", "ce1056a8ae81b0159931a803e0bb7498393292dd31bf38937ce2e11a2f1f8f6b");
        TestDigest.testKatHex(new BLAKE256(), "5fce8109a358570e40983e1184e541833bb9091e280f258cfb144387b05d190e431cb19baa67273ba0c58abe91308e1844dcd0b3678baa42f335f2fa05267a0240b3c718a5942b3b3e3bfa98a55c25a1466e8d7a603722cb2bbf03afa54cd769a99f310735ee5a05dae2c22d397bd95635f58c48a67f90e1b73aafcd3f82117f0166657838691005b18da6f341d6e90fc1cdb352b30fae45d348294e501b63252de14740f2b85ae5299ddec3172de8b6d0ba219a20a23bb5e10ff434d39db3f583305e9f5c039d98569e377b75a70ab837d1df269b8a4b566f40bb91b577455fd3c356c914fa06b9a7ce24c7317a172d", "930ce249bc62194653f326268d33cd349535498f48a808e22032b064dfe99bb4");
        TestDigest.testKatHex(new BLAKE256(), "6172f1971a6e1e4e6170afbad95d5fec99bf69b24b674bc17dd78011615e502de6f56b86b1a71d3f4348087218ac7b7d09302993be272e4a591968aef18a1262d665610d1070ee91cc8da36e1f841a69a7a682c580e836941d21d909a3afc1f0b963e1ca5ab193e124a1a53df1c587470e5881fb54dae1b0d840f0c8f9d1b04c645ba1041c7d8dbf22030a623aa15638b3d99a2c400ff76f3252079af88d2b37f35ee66c1ad7801a28d3d388ac450b97d5f0f79e4541755356b3b1a5696b023f39ab7ab5f28df4202936bc97393b93bc915cb159ea1bd7a0a414cb4b7a1ac3af68f50d79f0c9c7314e750f7d02faa58bfa", "295b04a3eb72bae7d1af8c97778e317e0c9d3bfe797a568d0e942434f0e30143");
        TestDigest.testKatHex(new BLAKE256(), "5668ecd99dfbe215c4118398ac9c9eaf1a1433fab4ccdd3968064752b625ea944731f75d48a27d047d67547f14dd0ffaa55fa5e29f7af0d161d85eafc4f2029b717c918eab9d304543290bdba7158b68020c0ba4e079bc95b5bc0fc044a992b94b4ccd3bd66d0eabb5dbbab904d62e00752c4e3b0091d773bcf4c14b4377da3efff824b1cb2fa01b32d1e46c909e626ed2dae920f4c7dbeb635bc754facbd8d49beba3f23c1c41ccbfcd0ee0c114e69737f5597c0bf1d859f0c767e18002ae8e39c26261ffde2920d3d0baf0e906138696cfe5b7e32b600f45df3aaa39932f3a7df95b60fa8712a2271fcaf3911ce7b511b1", "e29ff387a5dcb86ac6e3442e0590172f4161c34e1f3b4f83146c094cfd02fd99");
        TestDigest.testKatHex(new BLAKE256(), "03d625488354df30e3f875a68edfcf340e8366a8e1ab67f9d5c5486a96829dfac0578289082b2a62117e1cf418b43b90e0adc881fc6ae8105c888e9ecd21aea1c9ae1a4038dfd17378fed71d02ae492087d7cdcd98f746855227967cb1ab4714261ee3bead3f4db118329d3ebef4bc48a875c19ba763966da0ebea800e01b2f50b00e9dd4caca6dcb314d00184ef71ea2391d760c950710db4a70f9212ffc54861f9dc752ce18867b8ad0c48df8466ef7231e7ac567f0eb55099e622ebb86cb237520190a61c66ad34f1f4e289cb3282ae3eaac6152ed24d2c92bae5a7658252a53c49b7b02dfe54fdb2e90074b6cf310ac661", "1ea1e16a92d23d49b84bee4cc022c4b3d11ac26273be1e9440d358b8b7b3fe45");
        TestDigest.testKatHex(new BLAKE256(), "2edc282ffb90b97118dd03aaa03b145f363905e3cbd2d50ecd692b37bf000185c651d3e9726c690d3773ec1e48510e42b17742b0b0377e7de6b8f55e00a8a4db4740cee6db0830529dd19617501dc1e9359aa3bcf147e0a76b3ab70c4984c13e339e6806bb35e683af8527093670859f3d8a0fc7d493bcba6bb12b5f65e71e705ca5d6c948d66ed3d730b26db395b3447737c26fad089aa0ad0e306cb28bf0acf106f89af3745f0ec72d534968cca543cd2ca50c94b1456743254e358c1317c07a07bf2b0eca438a709367fafc89a57239028fc5fecfd53b8ef958ef10ee0608b7f5cb9923ad97058ec067700cc746c127a61ee3", "ba95a7e5eaa57cd8339286b53b6aca811763cfed558aea46f0e9518e45312d7f");
        TestDigest.testKatHex(new BLAKE256(), "90b28a6aa1fe533915bcb8e81ed6cacdc10962b7ff82474f845eeb86977600cf70b07ba8e3796141ee340e3fce842a38a50afbe90301a3bdcc591f2e7d9de53e495525560b908c892439990a2ca2679c5539ffdf636777ad9c1cdef809cda9e8dcdb451abb9e9c17efa4379abd24b182bd981cafc792640a183b61694301d04c5b3eaad694a6bd4cc06ef5da8fa23b4fa2a64559c5a68397930079d250c51bcf00e2b16a6c49171433b0aadfd80231276560b80458dd77089b7a1bbcc9e7e4b9f881eacd6c92c4318348a13f4914eb27115a1cfc5d16d7fd94954c3532efaca2cab025103b2d02c6fd71da3a77f417d7932685888a", "b1b21afb252748a178212650ddc4d25dd75e3608ce9418ea3e3a77026752037f");
        TestDigest.testKatHex(new BLAKE256(), "2969447d175490f2aa9bb055014dbef2e6854c95f8d60950bfe8c0be8de254c26b2d31b9e4de9c68c9adf49e4ee9b1c2850967f29f5d08738483b417bb96b2a56f0c8aca632b552059c59aac3f61f7b45c966b75f1d9931ff4e596406378cee91aaa726a3a84c33f37e9cdbe626b5745a0b06064a8a8d56e53aaf102d23dd9df0a3fdf7a638509a6761a33fa42fa8ddbd8e16159c93008b53765019c3f0e9f10b144ce2ac57f5d7297f9c9949e4ff68b70d339f87501ce8550b772f32c6da8ad2ce2100a895d8b08fa1eead7c376b407709703c510b50f87e73e43f8e7348f87c3832a547ef2bbe5799abedcf5e1f372ea809233f006", "05fad405421d9aac1e2a0bb281f290044db798c9c81d2e7e37b8cf27ea3dbde7");
        TestDigest.testKatHex(new BLAKE256(), "721645633a44a2c78b19024eaecf58575ab23c27190833c26875dc0f0d50b46aea9c343d82ea7d5b3e50ec700545c615daeaea64726a0f05607576dcd396d812b03fb6551c641087856d050b10e6a4d5577b82a98afb89cee8594c9dc19e79feff0382fcfd127f1b803a4b9946f4ac9a4378e1e6e041b1389a53e3450cd32d9d2941b0cbabdb50da8ea2513145164c3ab6bcbd251c448d2d4b087ac57a59c2285d564f16da4ed5e607ed979592146ffb0ef3f3db308fb342df5eb5924a48256fc763141a278814c82d6d6348577545870ae3a83c7230ac02a1540fe1798f7ef09e335a865a2ae0949b21e4f748fb8a51f44750e213a8fb", "1067006f5ba77614c85654e29e6b8731d626da0e106a5fce8c60f40548ce3ee9");
        TestDigest.testKatHex(new BLAKE256(), "6b860d39725a14b498bb714574b4d37ca787404768f64c648b1751b353ac92bac2c3a28ea909fdf0423336401a02e63ec24325300d823b6864bb701f9d7c7a1f8ec9d0ae3584aa6dd62ea1997cd831b4babd9a4da50932d4efda745c61e4130890e156aee6113716daf95764222a91187db2effea49d5d0596102d619bd26a616bbfda8335505fbb0d90b4c180d1a2335b91538e1668f9f9642790b4e55f9cab0fe2bdd2935d001ee6419abab5457880d0dbff20ed8758f4c20fe759efb33141cf0e892587fe8187e5fbc57786b7e8b089612c936dfc03d27efbbe7c8673f1606bd51d5ff386f4a7ab68edf59f385eb1291f117bfe717399", "04cb00e26c2956c95b4271d63b354128bf91377352903a0c8f3cc81316a45c52");
        TestDigest.testKatHex(new BLAKE256(), "6a01830af3889a25183244decb508bd01253d5b508ab490d3124afbf42626b2e70894e9b562b288d0a2450cfacf14a0ddae5c04716e5a0082c33981f6037d23d5e045ee1ef2283fb8b6378a914c5d9441627a722c282ff452e25a7ea608d69cee4393a0725d17963d0342684f255496d8a18c2961145315130549311fc07f0312fb78e6077334f87eaa873bee8aa95698996eb21375eb2b4ef53c14401207deb4568398e5dd9a7cf97e8c9663e23334b46912f8344c19efcf8c2ba6f04325f1a27e062b62a58d0766fc6db4d2c6a1928604b0175d872d16b7908ebc041761187cc785526c2a3873feac3a642bb39f5351550af9770c328af7b", "99eaa72ed6a8e331edbd368c47cf409604969e7f7c26f5f4958cc01f5cdf92aa");
        TestDigest.testKatHex(new BLAKE256(), "b3c5e74b69933c2533106c563b4ca20238f2b6e675e8681e34a389894785bdade59652d4a73d80a5c85bd454fd1e9ffdad1c3815f5038e9ef432aac5c3c4fe840cc370cf86580a6011778bbedaf511a51b56d1a2eb68394aa299e26da9ada6a2f39b9faff7fba457689b9c1a577b2a1e505fdf75c7a0a64b1df81b3a356001bf0df4e02a1fc59f651c9d585ec6224bb279c6beba2966e8882d68376081b987468e7aed1ef90ebd090ae825795cdca1b4f09a979c8dfc21a48d8a53cdbb26c4db547fc06efe2f9850edd2685a4661cb4911f165d4b63ef25b87d0a96d3dff6ab0758999aad214d07bd4f133a6734fde445fe474711b69a98f7e2b", "09242088f93a06bc379e4c5a0df13c85294b6b7d8a1694e4cf1e82cbba70e6f3");
        TestDigest.testKatHex(new BLAKE256(), "83af34279ccb5430febec07a81950d30f4b66f484826afee7456f0071a51e1bbc55570b5cc7ec6f9309c17bf5befdd7c6ba6e968cf218a2b34bd5cf927ab846e38a40bbd81759e9e33381016a755f699df35d660007b5eadf292feefb735207ebf70b5bd17834f7bfa0e16cb219ad4af524ab1ea37334aa66435e5d397fc0a065c411ebbce32c240b90476d307ce802ec82c1c49bc1bec48c0675ec2a6c6f3ed3e5b741d13437095707c565e10d8a20b8c20468ff9514fcf31b4249cd82dcee58c0a2af538b291a87e3390d737191a07484a5d3f3fb8c8f15ce056e5e5f8febe5e1fb59d6740980aa06ca8a0c20f5712b4cde5d032e92ab89f0ae1", "03c9894656d0d1a69702c1ae8418f59d22d62b6de7c1e86e7425a2f5a1e97bde");
        TestDigest.testKatHex(new BLAKE256(), "a7ed84749ccc56bb1dfba57119d279d412b8a986886d810f067af349e8749e9ea746a60b03742636c464fc1ee233acc52c1983914692b64309edfdf29f1ab912ec3e8da074d3f1d231511f5756f0b6eead3e89a6a88fe330a10face267bffbfc3e3090c7fd9a850561f363ad75ea881e7244f80ff55802d5ef7a1a4e7b89fcfa80f16df54d1b056ee637e6964b9e0ffd15b6196bdd7db270c56b47251485348e49813b4eb9ed122a01b3ea45ad5e1a929df61d5c0f3e77e1fdc356b63883a60e9cbb9fc3e00c2f32dbd469659883f690c6772e335f617bc33f161d6f6984252ee12e62b6000ac5231e0c9bc65be223d8dfd94c5004a101af9fd6c0fb", "d16b9501702423d6497a1922352b8b298df15b72ebaf83687ea808e1b4c2fb17");
        TestDigest.testKatHex(new BLAKE256(), "a6fe30dcfcda1a329e82ab50e32b5f50eb25c873c5d2305860a835aecee6264aa36a47429922c4b8b3afd00da16035830edb897831c4e7b00f2c23fc0b15fdc30d85fb70c30c431c638e1a25b51caf1d7e8b050b7f89bfb30f59f0f20fecff3d639abc4255b3868fc45dd81e47eb12ab40f2aac735df5d1dc1ad997cefc4d836b854cee9ac02900036f3867fe0d84afff37bde3308c2206c62c4743375094108877c73b87b2546fe05ea137bedfc06a2796274099a0d554da8f7d7223a48cbf31b7decaa1ebc8b145763e3673168c1b1b715c1cd99ecd3ddb238b06049885ecad9347c2436dff32c771f34a38587a44a82c5d3d137a03caa27e66c8ff6", "0066894354c34948d24296383063e73ccdd2600611bfee86a143e7c21e4ab094");
        TestDigest.testKatHex(new BLAKE256(), "83167ff53704c3aa19e9fb3303539759c46dd4091a52ddae9ad86408b69335989e61414bc20ab4d01220e35241eff5c9522b079fba597674c8d716fe441e566110b6211531ceccf8fd06bc8e511d00785e57788ed9a1c5c73524f01830d2e1148c92d0edc97113e3b7b5cd3049627abdb8b39dd4d6890e0ee91993f92b03354a88f52251c546e64434d9c3d74544f23fb93e5a2d2f1fb15545b4e1367c97335b0291944c8b730ad3d4789273fa44fb98d78a36c3c3764abeeac7c569c1e43a352e5b770c3504f87090dee075a1c4c85c0c39cf421bdcc615f9eff6cb4fe6468004aece5f30e1ecc6db22ad9939bb2b0ccc96521dfbf4ae008b5b46bc006e", "8843695ff3055fa63c6190500ebfe5a4ba4b64706d0f4fdbdc49b5834b34b28a");
        TestDigest.testKatHex(new BLAKE256(), "3a3a819c48efde2ad914fbf00e18ab6bc4f14513ab27d0c178a188b61431e7f5623cb66b23346775d386b50e982c493adbbfc54b9a3cd383382336a1a0b2150a15358f336d03ae18f666c7573d55c4fd181c29e6ccfde63ea35f0adf5885cfc0a3d84a2b2e4dd24496db789e663170cef74798aa1bbcd4574ea0bba40489d764b2f83aadc66b148b4a0cd95246c127d5871c4f11418690a5ddf01246a0c80a43c70088b6183639dcfda4125bd113a8f49ee23ed306faac576c3fb0c1e256671d817fc2534a52f5b439f72e424de376f4c565cca82307dd9ef76da5b7c4eb7e085172e328807c02d011ffbf33785378d79dc266f6a5be6bb0e4a92eceebaeb1", "29a2913d7b509828fc8dbd420dc76ecac0f007569d9df431294bf3d6cdd9ae9f");
        TestDigest.reportSuccess("BLAKE-256");
    }

    private static void testBLAKE384() {
        TestDigest.testKatHex(new BLAKE384(), "", "c6cbd89c926ab525c242e6621f2f5fa73aa4afe3d9e24aed727faaadd6af38b620bdb623dd2b4788b1c8086984af8706");
        TestDigest.testKatHex(new BLAKE384(), "cc", "a77e65c0c03ecb831dbcdd50a3c2bce300d55eac002a9c197095518d8514c0b578e3ecb7415291f99ede91d49197dd05");
        TestDigest.testKatHex(new BLAKE384(), "41fb", "e80a87362c9d39e2074ac135e2514b0cdf0001bfd8c35888d7ca8bbc4e918a157386524d41579e7fcd9c3c9a4f7a991a");
        TestDigest.testKatHex(new BLAKE384(), "1f877c", "d67cfa1b09c8c050094ea018bb5ecd3ce0c02835325467a8fa79701f0ad6bbd4a34947bbaa2fc5f9379985ccd6a1dc0e");
        TestDigest.testKatHex(new BLAKE384(), "c1ecfdfc", "7a57c41d850b7ab51c6075aba299ff649fdaf08a4c37088ece73b21304b1072c21930cc34ac6b0fc5f27b95f4f389b26");
        TestDigest.testKatHex(new BLAKE384(), "21f134ac57", "324155f4f5e346bfe0b08e9642bebe86505795be186146d30242273ebebb3d51e076b1105ab647c130e6efc0b75072a7");
        TestDigest.testKatHex(new BLAKE384(), "c6f50bb74e29", "5ddb50068ca430bffae7e5a8bbcb2c59171743cce027c0ea937fa2b511848192af2aca98ead30b0850b4d2d1542decdb");
        TestDigest.testKatHex(new BLAKE384(), "119713cc83eeef", "3011ca63a5583cfe37ec4f3cf6477859d9c7ba11a72e5ad07f8a67d62da643fa41617db2eedc017a8b43421b650b715c");
        TestDigest.testKatHex(new BLAKE384(), "4a4f202484512526", "de8220a9b59327074de5934db1e4784b5a3699c5693ca47c7411a5cd05688bd2581d1bae8c32b05ef7d057812603c0c9");
        TestDigest.testKatHex(new BLAKE384(), "1f66ab4185ed9b6375", "f1f89d0c861a25294fd307cb71d96f9ad4c5b11ade6321b8340ffc3a9a29641b5e2027c328bdc6e4bb6d21b533cc7944");
        TestDigest.testKatHex(new BLAKE384(), "eed7422227613b6f53c9", "6659fa5b2c4874d82ae964df895d44fbd9029ea07adea8acfd57c747ab8c6df120b5e485e457692591e3d5acbbb78133");
        TestDigest.testKatHex(new BLAKE384(), "eaeed5cdffd89dece455f1", "729d593f2112370a56caf8e90bebb713a9bd9922cf4bae5f22a8e727f5ab6a71a7c45c3c34b06b6d13c5b1a12d4d0027");
        TestDigest.testKatHex(new BLAKE384(), "5be43c90f22902e4fe8ed2d3", "1743b2752164bb4aa62bf714bd5c2d7d14ae7cd94e50dd04741f239cb4aba2c4e25f1caaf9ef225657331960e2a14eab");
        TestDigest.testKatHex(new BLAKE384(), "a746273228122f381c3b46e4f1", "0dd5ad80c5c44fe0208d6af5e24a384c0d4829133af500a78ed43160d5f759334598a82dd63bc7ef956ca7e38ec6afb9");
        TestDigest.testKatHex(new BLAKE384(), "3c5871cd619c69a63b540eb5a625", "0aa19c3d90c3c5436a873a51be500b64da9b8e987015c92927e94c461796966378bbfaf6d6a123c8dd197d20d56b2620");
        TestDigest.testKatHex(new BLAKE384(), "fa22874bcc068879e8ef11a69f0722", "0d747784a6ad6b678cb7014fa24d1bbd603d2aec4dd0fc32bff40a060271ee96a79f89d1a39232e0e8724fb0e34e5899");
        TestDigest.testKatHex(new BLAKE384(), "52a608ab21ccdd8a4457a57ede782176", "e2559e7455e906ca63d23a3782ad1855abfac875cb6c00d63532c92d5e16cd5854ed1348c9e52e49355c887b3475450c");
        TestDigest.testKatHex(new BLAKE384(), "82e192e4043ddcd12ecf52969d0f807eed", "7960b3c17de4b93d0950cf1db5b9c21d09c6b7121ec37ebe897647ea074b5141bcf455dea6ab375bbff1886d6349aa3e");
        TestDigest.testKatHex(new BLAKE384(), "75683dcb556140c522543bb6e9098b21a21e", "d311f1815693952436ee528e3d6b0cbb964b2a11efb43abf8c3bc58216bbe281ff39bc029811bd4c9aadf896dd04578b");
        TestDigest.testKatHex(new BLAKE384(), "06e4efe45035e61faaf4287b4d8d1f12ca97e5", "38b83c8e3bd94f70944554e1c5020d13eb8bf429964ea9466d30f2c2eb805cdfa904b7e693163644bf3d0c59173ae2e9");
        TestDigest.testKatHex(new BLAKE384(), "e26193989d06568fe688e75540aea06747d9f851", "091bff770df40f4f8168675169ca3dffbebee56f3888bf1a2a868f2bebafcf7d08d37937e7f242ca47bd2b659a4b52ac");
        TestDigest.testKatHex(new BLAKE384(), "d8dc8fdefbdce9d44e4cbafe78447bae3b5436102a", "e73c75d35a826e03b5ee528b81945fe877b6229c861a22e5f19fe37bde44e6708bd4645bee6e431ef75c36f5a8994350");
        TestDigest.testKatHex(new BLAKE384(), "57085fd7e14216ab102d8317b0cb338a786d5fc32d8f", "79e1b64018985457cd107c9acc3b87016565b0c9449296b18ed6b280e3b071d4af951c0b28ccaa683d1864a988a14da9");
        TestDigest.testKatHex(new BLAKE384(), "a05404df5dbb57697e2c16fa29defac8ab3560d6126fa0", "f6b8e7777293a590a125d754ceed0ee2e492863d61c8cd9c44cb4145176cd0ac63c3627d61e5b8f91c75d7d79fddcad1");
        TestDigest.testKatHex(new BLAKE384(), "aecbb02759f7433d6fcb06963c74061cd83b5b3ffa6f13c6", "ab0da0a06cc3f76d82c27503ebefe0d5fc77ebf7dcc5bb384739e77cabda6bebe3237e7e7ff937883bf1e12f887abeaa");
        TestDigest.testKatHex(new BLAKE384(), "aafdc9243d3d4a096558a360cc27c8d862f0be73db5e88aa55", "bb6f4dba32b894eb928a5a8e45cb20120c6c6f2ceac45a60dadbc683831b12b700943360fa0139e8e8290f7d458eea76");
        TestDigest.testKatHex(new BLAKE384(), "7bc84867f6f9e9fdc3e1046cae3a52c77ed485860ee260e30b15", "2cb38b29f0e88dc00f6cbd998a916a09757f780f62b48cd72882630c97031f9b09bc7134ee134321012d73081fb20966");
        TestDigest.testKatHex(new BLAKE384(), "fac523575a99ec48279a7a459e98ff901918a475034327efb55843", "28e326a3b706d67f2ea7f46f3545e0fe4d39583b9907256715dfeae8fc363d683cf843a4d96a0306854712b43c5bdc79");
        TestDigest.testKatHex(new BLAKE384(), "0f8b2d8fcfd9d68cffc17ccfb117709b53d26462a3f346fb7c79b85e", "ba89867f9a1f5a99c1d6ca57fdadf3910486ce0991989e028b7352e9ef3cd48c3e1593e813e4d563beaf06b938be377d");
        TestDigest.testKatHex(new BLAKE384(), "a963c3e895ff5a0be4824400518d81412f875fa50521e26e85eac90c04", "9ece04b3084795e2c35de58541c66934bcf124ca7b5a8685ccee15435edb43e535b9bf09e7cbfeeedf7d84986ed5e84b");
        TestDigest.testKatHex(new BLAKE384(), "03a18688b10cc0edf83adf0a84808a9718383c4070c6c4f295098699ac2c", "a63987ba02bc84406bf0070e4bd92eda5e4d1848e39c3e62965680a7ae6e36a88b06ed1f59685bfa32a2ed56b711c4fc");
        TestDigest.testKatHex(new BLAKE384(), "84fb51b517df6c5accb5d022f8f28da09b10232d42320ffc32dbecc3835b29", "43a7e5243bbd711e4d82e57c5355a897034a332ddea4ae07536e007692cb275dbcd45ceb0e1978fbfe709aa35d8995a9");
        TestDigest.testKatHex(new BLAKE384(), "9f2fcc7c90de090d6b87cd7e9718c1ea6cb21118fc2d5de9f97e5db6ac1e9c10", "822aed872d9aa450e139295babf3c81e346327085dc88f04aa5b7aa207751df3392fc1c19f435a51e66cccf3dafa4c9e");
        TestDigest.testKatHex(new BLAKE384(), "de8f1b3faa4b7040ed4563c3b8e598253178e87e4d0df75e4ff2f2dedd5a0be046", "ac16c75059163b1da958b5d2223c4412b028776e8b4745a1d42fad640b9c0e037ca35064d575ef8dd8b8a48da8f250cd");
        TestDigest.testKatHex(new BLAKE384(), "62f154ec394d0bc757d045c798c8b87a00e0655d0481a7d2d9fb58d93aedc676b5a0", "731e42c94415cf4c8bcd1f84631527dc90e7b23b3c44cc2e3455999b3a15ce46c7d7ec90d5a60292c60bb83496fbecdd");
        TestDigest.testKatHex(new BLAKE384(), "b2dcfe9ff19e2b23ce7da2a4207d3e5ec7c6112a8a22aec9675a886378e14e5bfbad4e", "d1ee154234fe74d3b527abd32847ddf4b53ec0f3de044a58e1e3360f3e1173d2ee8b829a446021b6fada0fef2dfa1fdc");
        TestDigest.testKatHex(new BLAKE384(), "47f5697ac8c31409c0868827347a613a3562041c633cf1f1f86865a576e02835ed2c2492", "b09ff806f91321b704558da8fe1766f22c92eb84896441f456a9b14e1e4d065f36855c3608427192278e75c03b3d3c53");
        TestDigest.testKatHex(new BLAKE384(), "512a6d292e67ecb2fe486bfe92660953a75484ff4c4f2eca2b0af0edcdd4339c6b2ee4e542", "af5be5f32063b121b8a484d22cddbfaf67a680a9ec3e0b0b497fbd083fda94ca41851c9573abb8e1fe22e6a7540b78b1");
        TestDigest.testKatHex(new BLAKE384(), "973cf2b4dcf0bfa872b41194cb05bb4e16760a1840d8343301802576197ec19e2a1493d8f4fb", "4538f1041c2d373ed18a0ebb13ac8c3694fc059f03b40da6f24557a1ef07e12bb2552d1da64d7dfe48bb45c3db75f82a");
        TestDigest.testKatHex(new BLAKE384(), "80beebcd2e3f8a9451d4499961c9731ae667cdc24ea020ce3b9aa4bbc0a7f79e30a934467da4b0", "e71ec9ad8c8812935c3f4a49b8b2ea5f6f58b1733a3be51d24e6a345d9fbcd3cd768c5b8d85b56a90bef242870621f77");
        TestDigest.testKatHex(new BLAKE384(), "7abaa12ec2a7347674e444140ae0fb659d08e1c66decd8d6eae925fa451d65f3c0308e29446b8ed3", "027b7ae734ffe64ae20149d3ba681889d475640a5a075a56f09e2a78702c9c5a43a7a12235877cea3b76b4ed407088c4");
        TestDigest.testKatHex(new BLAKE384(), "c88dee9927679b8af422abcbacf283b904ff31e1cac58c7819809f65d5807d46723b20f67ba610c2b7", "28ee7e4960e71dd9a0f98125ec5eedfda5c54dfba8e9d09a7642e1c142658030ada17e11b557c935f9ecd2058a9f686f");
        TestDigest.testKatHex(new BLAKE384(), "01e43fe350fcec450ec9b102053e6b5d56e09896e0ddd9074fe138e6038210270c834ce6eadc2bb86bf6", "3946cb293fec56c421ee7367832fec9c1d2bafae6a4ac5ef121362069c98441406d10e939297e24f2c856e5a2b07e2da");
        TestDigest.testKatHex(new BLAKE384(), "337023370a48b62ee43546f17c4ef2bf8d7ecd1d49f90bab604b839c2e6e5bd21540d29ba27ab8e309a4b7", "480ea728918f73a770b0bf7e592f009e04c3620282ebd68457a5c432265aed3312b5d82c854c91ad7918766c9f767659");
        TestDigest.testKatHex(new BLAKE384(), "6892540f964c8c74bd2db02c0ad884510cb38afd4438af31fc912756f3efec6b32b58ebc38fc2a6b913596a8", "663a90d17448018084d106abd1232fc607d78dd2b48f46440ea13abcb6bf97eca02a4330e730c26996dc0b32950cd054");
        TestDigest.testKatHex(new BLAKE384(), "f5961dfd2b1ffffda4ffbf30560c165bfedab8ce0be525845deb8dc61004b7db38467205f5dcfb34a2acfe96c0", "bb13d419b439cf08d354421ea1fd8d2a551909a013acc26fa0d18e43c33d9911bc9440b55c4733116974fe4c4bc7795a");
        TestDigest.testKatHex(new BLAKE384(), "ca061a2eb6ceed8881ce2057172d869d73a1951e63d57261384b80ceb5451e77b06cf0f5a0ea15ca907ee1c27eba", "0458c4eb0e9bbe69abd7506e52fc89d41b18553d6b65743b66b9b35674ccf5bafc11ce0202df4e2c3e8f1290c200a568");
        TestDigest.testKatHex(new BLAKE384(), "1743a77251d69242750c4f1140532cd3c33f9b5ccdf7514e8584d4a5f9fbd730bcf84d0d4726364b9bf95ab251d9bb", "91a0fa08b6c33f2f86ae4c3787b5f307351b43a943fa64eb59a63415c9615cc50a0935bea4c0bed07eb1775168cdb525");
        TestDigest.testKatHex(new BLAKE384(), "d8faba1f5194c4db5f176fabfff856924ef627a37cd08cf55608bba8f1e324d7c7f157298eabc4dce7d89ce5162499f9", "4c2e732a108500455c610ada1ec54cd88106cebae4ee882fb1e6f48891b05b8dc8cef6ddfaf74d51d75c53f9bf04e828");
        TestDigest.testKatHex(new BLAKE384(), "be9684be70340860373c9c482ba517e899fc81baaa12e5c6d7727975d1d41ba8bef788cdb5cf4606c9c1c7f61aed59f97d", "15a9fee3a25b55f6315a0846cc3395ec642bfc14303680ed242053a75fc3ed33861e553d67ac5d054cd828e10dd6a403");
        TestDigest.testKatHex(new BLAKE384(), "7e15d2b9ea74ca60f66c8dfab377d9198b7b16deb6a1ba0ea3c7ee2042f89d3786e779cf053c77785aa9e692f821f14a7f51", "7aafe640a0f38b34b16395a8e4a4bdc6f08fd126adcc3dfe77f4db6b2d92b7080d0f5ba88d1d68e69c22400f1c50f372");
        TestDigest.testKatHex(new BLAKE384(), "9a219be43713bd578015e9fda66c0f2d83cac563b776ab9f38f3e4f7ef229cb443304fba401efb2bdbd7ece939102298651c86", "25ab1eb34e2ce57ef898589fb9116d8c1058afe05616674b9b581ee4a3d45fea5223c932cec84e5a1c4a6e7e9f676d6a");
        TestDigest.testKatHex(new BLAKE384(), "c8f2b693bd0d75ef99caebdc22adf4088a95a3542f637203e283bbc3268780e787d68d28cc3897452f6a22aa8573ccebf245972a", "6b2d02bdd362d73ee156249e00b3c913f3f2f723e6d18f96698248a3b6318081dbb4484e03a5b3b325239f3be4d16efc");
        TestDigest.testKatHex(new BLAKE384(), "ec0f99711016c6a2a07ad80d16427506ce6f441059fd269442baaa28c6ca037b22eeac49d5d894c0bf66219f2c08e9d0e8ab21de52", "026565bafac7572a9630230092d63e3d74ed1f49f558011fdab8060f641ac6d5154d8373e1e6682c264abe38f31f9eab");
        TestDigest.testKatHex(new BLAKE384(), "0dc45181337ca32a8222fe7a3bf42fc9f89744259cff653504d6051fe84b1a7ffd20cb47d4696ce212a686bb9be9a8ab1c697b6d6a33", "abbde7c9961c790547d8431cf58121ceacb3e1528232c19a3c90795224a3ffa864bf1925a3f645159ff537b28211674c");
        TestDigest.testKatHex(new BLAKE384(), "de286ba4206e8b005714f80fb1cdfaebde91d29f84603e4a3ebc04686f99a46c9e880b96c574825582e8812a26e5a857ffc6579f63742f", "a61f716166653a3bd743231ebf1eb0afac0c1880c7ec9c834cd282c069263b31b8abd4a44395a326f4ff587b990fa8a8");
        TestDigest.testKatHex(new BLAKE384(), "eebcc18057252cbf3f9c070f1a73213356d5d4bc19ac2a411ec8cdeee7a571e2e20eaf61fd0c33a0ffeb297ddb77a97f0a415347db66bcaf", "7ca4372641c7ee1233e813391fdb28cf4877ae2100a229a3d4df0551a5c4c14c4ced0861a5b7eaa60e62252a96502da9");
        TestDigest.testKatHex(new BLAKE384(), "416b5cdc9fe951bd361bd7abfc120a5054758eba88fdd68fd84e39d3b09ac25497d36b43cbe7b85a6a3cebda8db4e5549c3ee51bb6fcb6ac1e", "b910a2f8b835fdfcddf964e63839a58bee638b006a9201c61d792a1e0c76fefb54ce109e69c1c912acc0309ca918b2f2");
        TestDigest.testKatHex(new BLAKE384(), "5c5faf66f32e0f8311c32e8da8284a4ed60891a5a7e50fb2956b3cbaa79fc66ca376460e100415401fc2b8518c64502f187ea14bfc9503759705", "52d58a05f4d64fbf397bf2c58238ac5df10b7e25feaf9cdce58de3c19c8111a029235fead59e0a6bf81c81dd376bab74");
        TestDigest.testKatHex(new BLAKE384(), "7167e1e02be1a7ca69d788666f823ae4eef39271f3c26a5cf7cee05bca83161066dc2e217b330df821103799df6d74810eed363adc4ab99f36046a", "a4f83bf247206839823849f99cb8c534c9f595c785130a6713b3a545e9dd6feee25f7d83f1fed22363f0dd3f38cf0dde");
        TestDigest.testKatHex(new BLAKE384(), "2fda311dbba27321c5329510fae6948f03210b76d43e7448d1689a063877b6d14c4f6d0eaa96c150051371f7dd8a4119f7da5c483cc3e6723c01fb7d", "c7a8d7e223b1e3e91ed6d0d82b7b54db37ed4deb90f84d4930a7b1114f9f68549624e5c1b731c385821d46c65a184753");
        TestDigest.testKatHex(new BLAKE384(), "95d1474a5aab5d2422aca6e481187833a6212bd2d0f91451a67dd786dfc91dfed51b35f47e1deb8a8ab4b9cb67b70179cc26f553ae7b569969ce151b8d", "4f13a38034866a811bb3be24dd82bfc06f7f7cdc2889924729a5bdab777b0d9a206dbb8eb2f9ba48f9115bcb0e33a544");
        TestDigest.testKatHex(new BLAKE384(), "c71bd7941f41df044a2927a8ff55b4b467c33d089f0988aa253d294addbdb32530c0d4208b10d9959823f0c0f0734684006df79f7099870f6bf53211a88d", "56d666a3584be6fef365bf60b9fb1803b9b56fd0de0fea8a5b0e2a761e610c18554ee71ea7aae0363f1e3d1a07c04c90");
        TestDigest.testKatHex(new BLAKE384(), "f57c64006d9ea761892e145c99df1b24640883da79d9ed5262859dcda8c3c32e05b03d984f1ab4a230242ab6b78d368dc5aaa1e6d3498d53371e84b0c1d4ba", "4938f0f3f7f64183afcf52138623b15a672d6f1db0c8b7b7c2b8c9dedbd741e3963d829696e8ad866ac7aa58b9196fec");
        TestDigest.testKatHex(new BLAKE384(), "e926ae8b0af6e53176dbffcc2a6b88c6bd765f939d3d178a9bde9ef3aa131c61e31c1e42cdfaf4b4dcde579a37e150efbef5555b4c1cb40439d835a724e2fae7", "c6610ebb4fd0433a61ae16ecb61cb161c14d8e6317caedfbd10d07470ddc83e7ff0872aaf440998fcd88abc8ca69d353");
        TestDigest.testKatHex(new BLAKE384(), "16e8b3d8f988e9bb04de9c96f2627811c973ce4a5296b4772ca3eefeb80a652bdf21f50df79f32db23f9f73d393b2d57d9a0297f7a2f2e79cfda39fa393df1ac00", "4ad239a060bed281126e941de11f3ac78d2db6d4df4d7c1b85db4fb53439efec7a91c155b5bd082fddeaf7765f298575");
        TestDigest.testKatHex(new BLAKE384(), "fc424eeb27c18a11c01f39c555d8b78a805b88dba1dc2a42ed5e2c0ec737ff68b2456d80eb85e11714fa3f8eabfb906d3c17964cb4f5e76b29c1765db03d91be37fc", "9c59eefbaffff3340365e944b5e635cb8ed239d70401b8acb7aab5d6f87bd641aa9207b191ad96915deae1855f174e4f");
        TestDigest.testKatHex(new BLAKE384(), "abe3472b54e72734bdba7d9158736464251c4f21b33fbbc92d7fac9a35c4e3322ff01d2380cbaa4ef8fb07d21a2128b7b9f5b6d9f34e13f39c7ffc2e72e47888599ba5", "8383c72bb96e98d18214f4fdaba8d1e1fe93109de6717cd9cc30064a75e56528e72e61fbea134df73da680726a313265");
        TestDigest.testKatHex(new BLAKE384(), "36f9f0a65f2ca498d739b944d6eff3da5ebba57e7d9c41598a2b0e4380f3cf4b479ec2348d015ffe6256273511154afcf3b4b4bf09d6c4744fdd0f62d75079d440706b05", "4003c3f0b1914b75a9d4b4db1a4a222a6ca2031e3cd8051c4f1d2dd6785151f77b650a16533bf65fff2cd4a971b95864");
        TestDigest.testKatHex(new BLAKE384(), "abc87763cae1ca98bd8c5b82caba54ac83286f87e9610128ae4de68ac95df5e329c360717bd349f26b872528492ca7c94c2c1e1ef56b74dbb65c2ac351981fdb31d06c77a4", "291dff41a4db05878e747d61b2e61f184a14571f6be6a6255de509a5225865dae6a67e9844e96b836e22b9daf3b91fdf");
        TestDigest.testKatHex(new BLAKE384(), "94f7ca8e1a54234c6d53cc734bb3d3150c8ba8c5f880eab8d25fed13793a9701ebe320509286fd8e422e931d99c98da4df7e70ae447bab8cffd92382d8a77760a259fc4fbd72", "fc6094533ed582c0085a802ef4d75d5b622126abd171e5f636821d884d8a3a5bf50bcb0f04c4426c58e656825d929389");
        TestDigest.testKatHex(new BLAKE384(), "13bd2811f6ed2b6f04ff3895aceed7bef8dcd45eb121791bc194a0f806206bffc3b9281c2b308b1a729ce008119dd3066e9378acdcc50a98a82e20738800b6cddbe5fe9694ad6d", "6006189d23fc5c9427f4f311a7f8891356bba560c3c6315b42dd33761a96ed6415d1ff59b2f07b70e67134fee1c0cbfc");
        TestDigest.testKatHex(new BLAKE384(), "1eed9cba179a009ec2ec5508773dd305477ca117e6d569e66b5f64c6bc64801ce25a8424ce4a26d575b8a6fb10ead3fd1992edddeec2ebe7150dc98f63adc3237ef57b91397aa8a7", "6aeb3ffc9280f06082e49bcf1a461e96b89d8eb0da93fb2d107151322057d0697eb710aa08d4ca7e8c5358edaa5524fa");
        TestDigest.testKatHex(new BLAKE384(), "ba5b67b5ec3a3ffae2c19dd8176a2ef75c0cd903725d45c9cb7009a900c0b0ca7a2967a95ae68269a6dbf8466c7b6844a1d608ac661f7eff00538e323db5f2c644b78b2d48de1a08aa", "aa612e2ef54a50bdf6f88ae4252e742ddda75bd22c34b6ee3a0c413d640d2d2cc483e0957b0499c12298253acbdf7813");
        TestDigest.testKatHex(new BLAKE384(), "0efa26ac5673167dcacab860932ed612f65ff49b80fa9ae65465e5542cb62075df1c5ae54fba4db807be25b070033efa223bdd5b1d3c94c6e1909c02b620d4b1b3a6c9fed24d70749604", "6ccc26ad50ab30104303c48130bd48ba7172a4e53ba2f219ebc17b14ee1be4c4c7717b367dde06354eccce3e1ad29025");
        TestDigest.testKatHex(new BLAKE384(), "bbfd933d1fd7bf594ac7f435277dc17d8d5a5b8e4d13d96d2f64e771abbd51a5a8aea741beccbddb177bcea05243ebd003cfdeae877cca4da94605b67691919d8b033f77d384ca01593c1b", "53edb2e6ba99b3d1bb41bca0613758986be63a06561fb54f7aec8b89c2b0e5d49f2b0e2fc924076a4333a2ba0f75ae18");
        TestDigest.testKatHex(new BLAKE384(), "90078999fd3c35b8afbf4066cbde335891365f0fc75c1286cdd88fa51fab94f9b8def7c9ac582a5dbcd95817afb7d1b48f63704e19c2baa4df347f48d4a6d603013c23f1e9611d595ebac37c", "7d81a43a11012b37244df3193c580064d39a8a83870f1d0dfcecd5d2f6d59bcb1059053b0039dc3598b1bad71a7da703");
        TestDigest.testKatHex(new BLAKE384(), "64105eca863515c20e7cfbaa0a0b8809046164f374d691cdbd6508aaabc1819f9ac84b52bafc1b0fe7cddbc554b608c01c8904c669d8db316a0953a4c68ece324ec5a49ffdb59a1bd6a292aa0e", "de05f9ff7c0e3896974aa1c5c5e4248613371c3d16e69012ec8ce0c391fe73f38950312caef89e0e9c982bc6cc7b5d02");
        TestDigest.testKatHex(new BLAKE384(), "d4654be288b9f3b711c2d02015978a8cc57471d5680a092aa534f7372c71ceaab725a383c4fcf4d8deaa57fca3ce056f312961eccf9b86f14981ba5bed6ab5b4498e1f6c82c6cae6fc14845b3c8a", "38e41ad235563135144f0ec95d486ebd639a045b88ffe5374a6253a10f9e4ae124d096712d97410cf7d8a3a66da43699");
        TestDigest.testKatHex(new BLAKE384(), "12d9394888305ac96e65f2bf0e1b18c29c90fe9d714dd59f651f52b88b3008c588435548066ea2fc4c101118c91f32556224a540de6efddbca296ef1fb00341f5b01fecfc146bdb251b3bdad556cd2", "b5f4cbfab4e63f6653d8eb12222f1fd0af5c0e4beef7844fea6a8989fa0723eea5c97d4ae0378ca4ae6c614ad50f95d3");
        TestDigest.testKatHex(new BLAKE384(), "871a0d7a5f36c3da1dfce57acd8ab8487c274fad336bc137ebd6ff4658b547c1dcfab65f037aa58f35ef16aff4abe77ba61f65826f7be681b5b6d5a1ea8085e2ae9cd5cf0991878a311b549a6d6af230", "d47e3baee87a5524a71982dedf68b265801dac1d53c28d71793ff0eb9d70d3ce48ceed911628be28c4ec7b351aead0b5");
        TestDigest.testKatHex(new BLAKE384(), "e90b4ffef4d457bc7711ff4aa72231ca25af6b2e206f8bf859d8758b89a7cd36105db2538d06da83bad5f663ba11a5f6f61f236fd5f8d53c5e89f183a3cec615b50c7c681e773d109ff7491b5cc22296c5", "c17e736c60cb60f89e8816db5e88fa93b6902440d6461fe0f2999ca07fec4eb01f102d6a530474dc4d75aaf640409aba");
        TestDigest.testKatHex(new BLAKE384(), "e728de62d75856500c4c77a428612cd804f30c3f10d36fb219c5ca0aa30726ab190e5f3f279e0733d77e7267c17be27d21650a9a4d1e32f649627638dbada9702c7ca303269ed14014b2f3cf8b894eac8554", "2776321bf957e17eaaf7e3a1f4d8d82388c0a3326a5104c9ab5fdc120f79fe45a4945abd8e685f0f731412e7e68002a9");
        TestDigest.testKatHex(new BLAKE384(), "6348f229e7b1df3b770c77544e5166e081850fa1c6c88169db74c76e42eb983facb276ad6a0d1fa7b50d3e3b6fcd799ec97470920a7abed47d288ff883e24ca21c7f8016b93bb9b9e078bdb9703d2b781b616e", "323084f189b718c0c08f80d7a0f59c630ce0336dddbff5beeec2a7a74920abbf278c57713d70f17b16bbfd08745fc313");
        TestDigest.testKatHex(new BLAKE384(), "4b127fde5de733a1680c2790363627e63ac8a3f1b4707d982caea258655d9bf18f89afe54127482ba01e08845594b671306a025c9a5c5b6f93b0a39522dc877437be5c2436cbf300ce7ab6747934fcfc30aeaaf6", "9643d625db98136b9b19a9a6bb6eac69b8aa5a60be3020f8c1dd8a9001530aeda6e00b6f9ada414cf869afdc6d892893");
        TestDigest.testKatHex(new BLAKE384(), "08461f006cff4cc64b752c957287e5a0faabc05c9bff89d23fd902d324c79903b48fcb8f8f4b01f3e4ddb483593d25f000386698f5ade7faade9615fdc50d32785ea51d49894e45baa3dc707e224688c6408b68b11", "1034282849069e1909399d62c8bfadc34f8386d8038f50fa76d0e1c18b90e7164ec7d2d5ae635f055d4b188dd0db7c3e");
        TestDigest.testKatHex(new BLAKE384(), "68c8f8849b120e6e0c9969a5866af591a829b92f33cd9a4a3196957a148c49138e1e2f5c7619a6d5edebe995acd81ec8bb9c7b9cfca678d081ea9e25a75d39db04e18d475920ce828b94e72241f24db72546b352a0e4", "079227c7aebc026432c3e2f0da9676da1ce5e8a86b027943e066a570c03edfd0d58da6db79559353892235057674d8cc");
        TestDigest.testKatHex(new BLAKE384(), "b8d56472954e31fb54e28fca743f84d8dc34891cb564c64b08f7b71636debd64ca1edbdba7fc5c3e40049ce982bba8c7e0703034e331384695e9de76b5104f2fbc4535ecbeebc33bc27f29f18f6f27e8023b0fbb6f563c", "33c777f1161b2880d5d5b5ab05a06151eea68e7cdeb01efa3f303f73e162b0b013896a5d8d6764744b29e6bbd679fdad");
        TestDigest.testKatHex(new BLAKE384(), "0d58ac665fa84342e60cefee31b1a4eacdb092f122dfc68309077aed1f3e528f578859ee9e4cefb4a728e946324927b675cd4f4ac84f64db3dacfe850c1dd18744c74ceccd9fe4dc214085108f404eab6d8f452b5442a47d", "57e25cd876134bfdbee7575fa58014c35e8ca8de68ff5b9be81485760645a86421c75c2dbaf2d26014ff91f2d9ca8ecf");
        TestDigest.testKatHex(new BLAKE384(), "1755e2d2e5d1c1b0156456b539753ff416651d44698e87002dcf61dcfa2b4e72f264d9ad591df1fdee7b41b2eb00283c5aebb3411323b672eaa145c5125185104f20f335804b02325b6dea65603f349f4d5d8b782dd3469ccd", "1e295059a52def6d95ac5063b1d6f75fa1b398bd37701692cd238dbe3d0df3155b0b2116d5af29d74142a64d6d7b7dbe");
        TestDigest.testKatHex(new BLAKE384(), "b180de1a611111ee7584ba2c4b020598cd574ac77e404e853d15a101c6f5a2e5c801d7d85dc95286a1804c870bb9f00fd4dcb03aa8328275158819dcad7253f3e3d237aeaa7979268a5db1c6ce08a9ec7c2579783c8afc1f91a7", "a287c1c6597780b9f3f83deaaaac134185e99f5b3974d90993870d856c3127f0d5ca833a5998279790e6bf6316cbc2f9");
        TestDigest.testKatHex(new BLAKE384(), "cf3583cbdfd4cbc17063b1e7d90b02f0e6e2ee05f99d77e24e560392535e47e05077157f96813544a17046914f9efb64762a23cf7a49fe52a0a4c01c630cfe8727b81fb99a89ff7cc11dca5173057e0417b8fe7a9efba6d95c555f", "b8fc28ed2026d49beb35554abf63c661f58baf239e625bf3505b930289f13f8798b9e2fc5436873e14e9587f0786de48");
        TestDigest.testKatHex(new BLAKE384(), "072fc02340ef99115bad72f92c01e4c093b9599f6cfc45cb380ee686cb5eb019e806ab9bd55e634ab10aa62a9510cc0672cd3eddb589c7df2b67fcd3329f61b1a4441eca87a33c8f55da4fbbad5cf2b2527b8e983bb31a2fadec7523", "6598f6974a245220abd6d62b317602ed01340505d847cad98f705ee0ec9a55a53787955e7b858921e81ce1e56bc081d9");
        TestDigest.testKatHex(new BLAKE384(), "76eecf956a52649f877528146de33df249cd800e21830f65e90f0f25ca9d6540fde40603230eca6760f1139c7f268deba2060631eea92b1fff05f93fd5572fbe29579ecd48bc3a8d6c2eb4a6b26e38d6c5fbf2c08044aeea470a8f2f26", "3d8de1a818ba0195313490fb1489fe58e9877e0c6e106757f8b438a92f6365d91420394dccddcc83bf58972eb43922aa");
        TestDigest.testKatHex(new BLAKE384(), "7adc0b6693e61c269f278e6944a5a2d8300981e40022f839ac644387bfac9086650085c2cdc585fea47b9d2e52d65a2b29a7dc370401ef5d60dd0d21f9e2b90fae919319b14b8c5565b0423cefb827d5f1203302a9d01523498a4db10374", "a3cd52de3aed088ce72d2392d4603822695cd5d28d2a0e199aafc017b3be25a94ceff9a78e9652990a84680e18ab9a9f");
        TestDigest.testKatHex(new BLAKE384(), "e1fffa9826cce8b86bccefb8794e48c46cdf372013f782eced1e378269b7be2b7bf51374092261ae120e822be685f2e7a83664bcfbe38fe8633f24e633ffe1988e1bc5acf59a587079a57a910bda60060e85b5f5b6f776f0529639d9cce4bd", "362b67bbadcfa5f34c1d1a5c7aa7054ee888cf42af485f35242633ec72400d48b08e348c30c4d7e2244acbe1ac93b22c");
        TestDigest.testKatHex(new BLAKE384(), "69f9abba65592ee01db4dce52dbab90b08fc04193602792ee4daa263033d59081587b09bbe49d0b49c9825d22840b2ff5d9c5155f975f8f2c2e7a90c75d2e4a8040fe39f63bbafb403d9e28cc3b86e04e394a9c9e8065bd3c85fa9f0c7891600", "10a8afd9dad859b8f99675c0f396c4586464f3633294cf8ef7fae0e12844d0066472b4476af787a142535360870e7aad");
        TestDigest.testKatHex(new BLAKE384(), "38a10a352ca5aedfa8e19c64787d8e9c3a75dbf3b8674bfab29b5dbfc15a63d10fae66cd1a6e6d2452d557967eaad89a4c98449787b0b3164ca5b717a93f24eb0b506ceb70cbbcb8d72b2a72993f909aad92f044e0b5a2c9ac9cb16a0ca2f81f49", "753a7e61b0552aa7a16ff005401fa0f2642efaa4ae0734a69e6696f87faed44b32e71be33013b1ef62211d8516b3e456");
        TestDigest.testKatHex(new BLAKE384(), "6d8c6e449bc13634f115749c248c17cd148b72157a2c37bf8969ea83b4d6ba8c0ee2711c28ee11495f43049596520ce436004b026b6c1f7292b9c436b055cbb72d530d860d1276a1502a5140e3c3f54a93663e4d20edec32d284e25564f624955b52", "f35442e08ff188aa034464d82725da849bdd998673c62706f5d7a919904ea06f0cf701c560f2f2d5b8a8a2c633561098");
        TestDigest.testKatHex(new BLAKE384(), "6efcbcaf451c129dbe00b9cef0c3749d3ee9d41c7bd500ade40cdc65dedbbbadb885a5b14b32a0c0d087825201e303288a733842fa7e599c0c514e078f05c821c7a4498b01c40032e9f1872a1c925fa17ce253e8935e4c3c71282242cb716b2089ccc1", "ed2f8355d1fe9e2295a863eb2e05eee4e1e33302daa830ebc36160f2bcb0651ebe163a8bbaacd60ed55437e5bfd4bc23");
        TestDigest.testKatHex(new BLAKE384(), "433c5303131624c0021d868a30825475e8d0bd3052a022180398f4ca4423b98214b6beaac21c8807a2c33f8c93bd42b092cc1b06cedf3224d5ed1ec29784444f22e08a55aa58542b524b02cd3d5d5f6907afe71c5d7462224a3f9d9e53e7e0846dcbb4ce", "677d3d23d3e708ced8da8e2befbf0c973f4152c99dd6c4b6abf9c2525ad14728a0b8bdd9316af980697ce54097308337");
        TestDigest.testKatHex(new BLAKE384(), "a873e0c67ca639026b6683008f7aa6324d4979550e9bce064ca1e1fb97a30b147a24f3f666c0a72d71348ede701cf2d17e2253c34d1ec3b647dbcef2f879f4eb881c4830b791378c901eb725ea5c172316c6d606e0af7df4df7f76e490cd30b2badf45685f", "a3e01b2a7822ecc9cb4f3234084f27326a72e20cea7a4c77f6655be2ffb9e2d7042a055fca443b7fc52d73878c2ff48b");
        TestDigest.testKatHex(new BLAKE384(), "006917b64f9dcdf1d2d87c8a6173b64f6587168e80faa80f82d84f60301e561e312d9fbce62f39a6fb476e01e925f26bcc91de621449be6504c504830aae394096c8fc7694651051365d4ee9070101ec9b68086f2ea8f8ab7b811ea8ad934d5c9b62c60a4771", "b5e0fa9a84520f6840605baa242e4376406c3d4b84d6c06eeb59041a176c49f00de929e50f00200ff44f6beb799a792f");
        TestDigest.testKatHex(new BLAKE384(), "f13c972c52cb3cc4a4df28c97f2df11ce089b815466be88863243eb318c2adb1a417cb1041308598541720197b9b1cb5ba2318bd5574d1df2174af14884149ba9b2f446d609df240ce335599957b8ec80876d9a085ae084907bc5961b20bf5f6ca58d5dab38adb", "991dfca47fbbeac7674dd57972fda9c829e74c78d4cb0a5db9187816dc7853e1d10edf1bcad4fdf8b47c8cb91b4920ae");
        TestDigest.testKatHex(new BLAKE384(), "e35780eb9799ad4c77535d4ddb683cf33ef367715327cf4c4a58ed9cbdcdd486f669f80189d549a9364fa82a51a52654ec721bb3aab95dceb4a86a6afa93826db923517e928f33e3fba850d45660ef83b9876accafa2a9987a254b137c6e140a21691e1069413848", "ba72d875a5e71475dfa6799665336b8a88297df2ee2a8a9cc08d2c17b2de277f21fbb1b4bfa3c2944892e18b5b0ceb9d");
        TestDigest.testKatHex(new BLAKE384(), "64ec021c9585e01ffe6d31bb50d44c79b6993d72678163db474947a053674619d158016adb243f5c8d50aa92f50ab36e579ff2dabb780a2b529370daa299207cfbcdd3a9a25006d19c4f1fe33e4b1eaec315d8c6ee1e730623fd1941875b924eb57d6d0c2edc4e78d6", "1740ab60d174a872da848b412258c755fe1fef5cd1a592b2fac235fe7a6f2f7350e632d92ec57737295ea1f326b6c3cc");
        TestDigest.testKatHex(new BLAKE384(), "5954bab512cf327d66b5d9f296180080402624ad7628506b555eea8382562324cf452fba4a2130de3e165d11831a270d9cb97ce8c2d32a96f50d71600bb4ca268cf98e90d6496b0a6619a5a8c63db6d8a0634dfc6c7ec8ea9c006b6c456f1b20cd19e781af20454ac880", "a11cb1a619f263a75728439676fdb3abe2c375fdd9b70e82455e1077a430ae2ce9bf9420fbb2a80075aa2096464b1cfb");
        TestDigest.testKatHex(new BLAKE384(), "03d9f92b2c565709a568724a0aff90f8f347f43b02338f94a03ed32e6f33666ff5802da4c81bdce0d0e86c04afd4edc2fc8b4141c2975b6f07639b1994c973d9a9afce3d9d365862003498513bfa166d2629e314d97441667b007414e739d7febf0fe3c32c17aa188a8683", "fa747cfb13ae58a31416d6878c51aaa217a917d84ae448d973315ee0494efe1242c20bfff03aa927ab7a059eedb33897");
        TestDigest.testKatHex(new BLAKE384(), "f31e8b4f9e0621d531d22a380be5d9abd56faec53cbd39b1fab230ea67184440e5b1d15457bd25f56204fa917fa48e669016cb48c1ffc1e1e45274b3b47379e00a43843cf8601a5551411ec12503e5aac43d8676a1b2297ec7a0800dbfee04292e937f21c005f17411473041", "4dfe5761a1feea6f5e6239f47271237cb9e4c3eeb9e48e8c89aea50cf86f9cf0d1c4681c3dc53ac04dd7ea1e7298dead");
        TestDigest.testKatHex(new BLAKE384(), "758ea3fea738973db0b8be7e599bbef4519373d6e6dcd7195ea885fc991d896762992759c2a09002912fb08e0cb5b76f49162aeb8cf87b172cf3ad190253df612f77b1f0c532e3b5fc99c2d31f8f65011695a087a35ee4eee5e334c369d8ee5d29f695815d866da99df3f79403", "e107139596afa0cac26ad54f1cc864344138de949a6c66eb67d5c742749b3a7081469983b115853dc4bc8128a3a0ef81");
        TestDigest.testKatHex(new BLAKE384(), "47c6e0c2b74948465921868804f0f7bd50dd323583dc784f998a93cd1ca4c6ef84d41dc81c2c40f34b5bee6a93867b3bdba0052c5f59e6f3657918c382e771d33109122cc8bb0e1e53c4e3d13b43ce44970f5e0c079d2ad7d7a3549cd75760c21bb15b447589e86e8d76b1e9ced2", "dd7f6cee712ac54e4782e4f3c2a4c0ff2cb1bb3fa16a64fcbd756ba82f4768d0c7b1b9ef6124114dce134d3626d215f9");
        TestDigest.testKatHex(new BLAKE384(), "f690a132ab46b28edfa6479283d6444e371c6459108afd9c35dbd235e0b6b6ff4c4ea58e7554bd002460433b2164ca51e868f7947d7d7a0d792e4abf0be5f450853cc40d85485b2b8857ea31b5ea6e4ccfa2f3a7ef3380066d7d8979fdac618aad3d7e886dea4f005ae4ad05e5065f", "10b485a54f643131d18647ed8ddebd36f3d403ccf658d477dceab018b349814b90939ed19b5978f3e6a980e94b966b5d");
        TestDigest.testKatHex(new BLAKE384(), "58d6a99bc6458824b256916770a8417040721cccfd4b79eacd8b65a3767ce5ba7e74104c985ac56b8cc9aebd16febd4cda5adb130b0ff2329cc8d611eb14dac268a2f9e633c99de33997fea41c52a7c5e1317d5b5daed35eba7d5a60e45d1fa7eaabc35f5c2b0a0f2379231953322c4e", "b0661bf4d2aa466d905c36fd689c0da1eeb23f750f5cae4bd9b4938b8e5e9f6db37df95c8f031411cf54c22e858ef694");
        TestDigest.testKatHex(new BLAKE384(), "befab574396d7f8b6705e2d5b58b2c1c820bb24e3f4bae3e8fbcd36dbf734ee14e5d6ab972aedd3540235466e825850ee4c512ea9795abfd33f330d9fd7f79e62bbb63a6ea85de15beaeea6f8d204a28956059e2632d11861dfb0e65bc07ac8a159388d5c3277e227286f65ff5e5b5aec1", "0d3bd61e8569b82c4c95059210c2944bbe809d9c2252cfa92dd43d82d1d5e404508cda417bd32daa6e8546ed05dc2eb6");
        TestDigest.testKatHex(new BLAKE384(), "8e58144fa9179d686478622ce450c748260c95d1ba43b8f9b59abeca8d93488da73463ef40198b4d16fb0b0707201347e0506ff19d01bea0f42b8af9e71a1f1bd168781069d4d338fdef00bf419fbb003031df671f4a37979564f69282de9c65407847dd0da505ab1641c02dea4f0d834986", "e099927d5fa66feb22a41e701290d0252e32b705c88c49056aee7994b58c5305959d6f0bcd0a8db6cce5146c0586053a");
        TestDigest.testKatHex(new BLAKE384(), "b55c10eae0ec684c16d13463f29291bf26c82e2fa0422a99c71db4af14dd9c7f33eda52fd73d017cc0f2dbe734d831f0d820d06d5f89dacc485739144f8cfd4799223b1aff9031a105cb6a029ba71e6e5867d85a554991c38df3c9ef8c1e1e9a7630be61caabca69280c399c1fb7a12d12aefc", "22326049c233942741b67d130ce7d56ab145137630adc83523887e649cf5e9f3cad0b6d6e23682a3007cabeda013d3b2");
        TestDigest.testKatHex(new BLAKE384(), "2eeea693f585f4ed6f6f8865bbae47a6908aecd7c429e4bec4f0de1d0ca0183fa201a0cb14a529b7d7ac0e6ff6607a3243ee9fb11bcf3e2304fe75ffcddd6c5c2e2a4cd45f63c962d010645058d36571404a6d2b4f44755434d76998e83409c3205aa1615db44057db991231d2cb42624574f545", "ba52ea9cf4379dd1905557110cd287330c73a25b846414f40093315900696b9a5b754e2186a7bd5eac84d7f0a681a1d8");
        TestDigest.testKatHex(new BLAKE384(), "dab11dc0b047db0420a585f56c42d93175562852428499f66a0db811fcdddab2f7cdffed1543e5fb72110b64686bc7b6887a538ad44c050f1e42631bc4ec8a9f2a047163d822a38989ee4aab01b4c1f161b062d873b1cfa388fd301514f62224157b9bef423c7783b7aac8d30d65cd1bba8d689c2d", "2155a6fb96978e2a094a3a6c24bd2fad6d97b58006a0d701289df7c1df382ed64f8733a22bd2367ba67d49c4490fb872");
        TestDigest.testKatHex(new BLAKE384(), "42e99a2f80aee0e001279a2434f731e01d34a44b1a8101726921c0590c30f3120eb83059f325e894a5ac959dca71ce2214799916424e859d27d789437b9d27240bf8c35adbafcecc322b48aa205b293962d858652abacbd588bcf6cbc388d0993bd622f96ed54614c25b6a9aa527589eaaffcf17ddf7", "1c753fb233d92ab37d10c9831569646a801a8702b65b6157113d30305e02175339ebe1fd9e0435faf917697622091af2");
        TestDigest.testKatHex(new BLAKE384(), "3c9b46450c0f2cae8e3823f8bdb4277f31b744ce2eb17054bddc6dff36af7f49fb8a2320cc3bdf8e0a2ea29ad3a55de1165d219adeddb5175253e2d1489e9b6fdd02e2c3d3a4b54d60e3a47334c37913c5695378a669e9b72dec32af5434f93f46176ebf044c4784467c700470d0c0b40c8a088c815816", "d89257ed2483a34e554f7a35accabfa7214abe9bd6ba28ec17b22c637469a1549bf87e72b899ae127af0c83e14ebd9cb");
        TestDigest.testKatHex(new BLAKE384(), "d1e654b77cb155f5c77971a64df9e5d34c26a3cad6c7f6b300d39deb1910094691adaa095be4ba5d86690a976428635d5526f3e946f7dc3bd4dbc78999e653441187a81f9adcd5a3c5f254bc8256b0158f54673dcc1232f6e918ebfc6c51ce67eaeb042d9f57eec4bfe910e169af78b3de48d137df4f2840", "821a5ef64ff74b0e1688b9284f8980dd335424c4327d484bb25ac31c98e462353dcae2c502d84e69cf6450b145bb1d78");
        TestDigest.testKatHex(new BLAKE384(), "626f68c18a69a6590159a9c46be03d5965698f2dac3de779b878b3d9c421e0f21b955a16c715c1ec1e22ce3eb645b8b4f263f60660ea3028981eebd6c8c3a367285b691c8ee56944a7cd1217997e1d9c21620b536bdbd5de8925ff71dec6fbc06624ab6b21e329813de90d1e572dfb89a18120c3f606355d25", "ae560fdebe31efbe282e5a7f5e3fbaa8ce572ef9cbd4052a6bc3a62fe3dc7c984370a87dbe4cfe3b1ae2e4bb427e4dab");
        TestDigest.testKatHex(new BLAKE384(), "651a6fb3c4b80c7c68c6011675e6094eb56abf5fc3057324ebc6477825061f9f27e7a94633abd1fa598a746e4a577caf524c52ec1788471f92b8c37f23795ca19d559d446cab16cbcdce90b79fa1026cee77bf4ab1b503c5b94c2256ad75b3eac6fd5dcb96aca4b03a834bfb4e9af988cecbf2ae597cb9097940", "8cb088a34b1ba908247b2573d8ead10761422fb556a4603f65716c953ae91bdf5c3168b32c0d01ec59bd3baf81d592b8");
        TestDigest.testKatHex(new BLAKE384(), "8aaf072fce8a2d96bc10b3c91c809ee93072fb205ca7f10abd82ecd82cf040b1bc49ea13d1857815c0e99781de3adbb5443ce1c897e55188ceaf221aa9681638de05ae1b322938f46bce51543b57ecdb4c266272259d1798de13be90e10efec2d07484d9b21a3870e2aa9e06c21aa2d0c9cf420080a80a91dee16f", "85e9a286024645b98180d4e74160b857adb9d57af1e132d184b3a39296d813d778844817e9f73d3a1bfbe3b84da8a897");
        TestDigest.testKatHex(new BLAKE384(), "53f918fd00b1701bd504f8cdea803acca21ac18c564ab90c2a17da592c7d69688f6580575395551e8cd33e0fef08ca6ed4588d4d140b3e44c032355df1c531564d7f4835753344345a6781e11cd5e095b73df5f82c8ae3ad00877936896671e947cc52e2b29dcd463d90a0c9929128da222b5a211450bbc0e02448e2", "874c5416fb49e0550f671be82ca8482231496b5c19d03a2a64fc80e2d44d6138f72f2aa52fc4acc72330384829274326");
        TestDigest.testKatHex(new BLAKE384(), "a64599b8a61b5ccec9e67aed69447459c8da3d1ec6c7c7c82a7428b9b584fa67e90f68e2c00fbbed4613666e5168da4a16f395f7a3c3832b3b134bfc9cbaa95d2a0fe252f44ac6681eb6d40ab91c1d0282fed6701c57463d3c5f2bb8c6a7301fb4576aa3b5f15510db8956ff77478c26a7c09bea7b398cfc83503f538e", "9c177e32a113eaee68cd8dc34b9d42363bab2c6430e8338270396daebf8dc462d315e947d5da9300f9170d202cd80ffd");
        TestDigest.testKatHex(new BLAKE384(), "0e3ab0e054739b00cdb6a87bd12cae024b54cb5e550e6c425360c2e87e59401f5ec24ef0314855f0f56c47695d56a7fb1417693af2a1ed5291f2fee95f75eed54a1b1c2e81226fbff6f63ade584911c71967a8eb70933bc3f5d15bc91b5c2644d9516d3c3a8c154ee48e118bd1442c043c7a0dba5ac5b1d5360aae5b9065", "7698aed91808500722840411ac1395f92180411791f2a2ced826ab64dff8ec1807668fff8029381f64926934be6f2528");
        TestDigest.testKatHex(new BLAKE384(), "a62fc595b4096e6336e53fcdfc8d1cc175d71dac9d750a6133d23199eaac288207944cea6b16d27631915b4619f743da2e30a0c00bbdb1bbb35ab852ef3b9aec6b0a8dcc6e9e1abaa3ad62ac0a6c5de765de2c3711b769e3fde44a74016fff82ac46fa8f1797d3b2a726b696e3dea5530439acee3a45c2a51bc32dd055650b", "3bc7d07a5c87e63c30341cf290d3c21205a6230956a8657b56053dbf0ac2518bb505690024ac7be4463861a89e100d3e");
        TestDigest.testKatHex(new BLAKE384(), "2b6db7ced8665ebe9deb080295218426bdaa7c6da9add2088932cdffbaa1c14129bccdd70f369efb149285858d2b1d155d14de2fdb680a8b027284055182a0cae275234cc9c92863c1b4ab66f304cf0621cd54565f5bff461d3b461bd40df28198e3732501b4860eadd503d26d6e69338f4e0456e9e9baf3d827ae685fb1d817", "71d25053787827490d86a4d70927c2fd9049b0d9a933df239b870919ca6b0979a9964aa9f934045d0bdb36d66d51a923");
        TestDigest.testKatHex(new BLAKE384(), "10db509b2cdcaba6c062ae33be48116a29eb18e390e1bbada5ca0a2718afbcd23431440106594893043cc7f2625281bf7de2655880966a23705f0c5155c2f5cca9f2c2142e96d0a2e763b70686cd421b5db812daced0c6d65035fde558e94f26b3e6dde5bd13980cc80292b723013bd033284584bff27657871b0cf07a849f4ae2", "9183593ac37732ae9741c9f0a1b8ecf619692a5fc936a6c7437475af0072e842132ccb5f7de4c4786065e35dcf5d5a02");
        TestDigest.testKatHex(new BLAKE384(), "9334de60c997bda6086101a6314f64e4458f5ff9450c509df006e8c547983c651ca97879175aaba0c539e82d05c1e02c480975cbb30118121061b1ebac4f8d9a3781e2db6b18042e01ecf9017a64a0e57447ec7fcbe6a7f82585f7403ee2223d52d37b4bf426428613d6b4257980972a0acab508a7620c1cb28eb4e9d30fc41361ec", "18a83f0426a7b43a1ba05cde4d2bd42005d0d5b4db1339823ce2632dabdafdde74b03dda639270231578eade040da638");
        TestDigest.testKatHex(new BLAKE384(), "e88ab086891693aa535ceb20e64c7ab97c7dd3548f3786339897a5f0c39031549ca870166e477743ccfbe016b4428d89738e426f5ffe81626137f17aecff61b72dbee2dc20961880cfe281dfab5ee38b1921881450e16032de5e4d55ad8d4fca609721b0692bac79be5a06e177fe8c80c0c83519fb3347de9f43d5561cb8107b9b5edc", "dcea2832426ff468ba6fea66ed860f7037cddca19b0dc43ba7e0db9beea17027ea6ace4778372b160f77c90ad41d8ccd");
        TestDigest.testKatHex(new BLAKE384(), "fd19e01a83eb6ec810b94582cb8fbfa2fcb992b53684fb748d2264f020d3b960cb1d6b8c348c2b54a9fcea72330c2aaa9a24ecdb00c436abc702361a82bb8828b85369b8c72ece0082fe06557163899c2a0efa466c33c04343a839417057399a63a3929be1ee4805d6ce3e5d0d0967fe9004696a5663f4cac9179006a2ceb75542d75d68", "4f469166f897b16a284932479a229a3fcfddc5978ca81c159b7f1011f314f9eef7a959c728c2911604db925c667b48a0");
        TestDigest.testKatHex(new BLAKE384(), "59ae20b6f7e0b3c7a989afb28324a40fca25d8651cf1f46ae383ef6d8441587aa1c04c3e3bf88e8131ce6145cfb8973d961e8432b202fa5af3e09d625faad825bc19da9b5c6c20d02abda2fcc58b5bd3fe507bf201263f30543819510c12bc23e2ddb4f711d087a86edb1b355313363a2de996b891025e147036087401ccf3ca7815bf3c49", "58cad7816349ab16ff86ec0e9f97ad34ae55324439f743b4a2828fccd79de182f10392801384f33310cf74f88ed24726");
        TestDigest.testKatHex(new BLAKE384(), "77ee804b9f3295ab2362798b72b0a1b2d3291dceb8139896355830f34b3b328561531f8079b79a6e9980705150866402fdc176c05897e359a6cb1a7ab067383eb497182a7e5aef7038e4c96d133b2782917417e391535b5e1b51f47d8ed7e4d4025fe98dc87b9c1622614bff3d1029e68e372de719803857ca52067cddaad958951cb2068cc6", "5719383506cdedd37abc5a04ec73a442249983436bdfcfeb0aca3ebb68d5f22aac3a8c3279997c2bdb011460f4984fbc");
        TestDigest.testKatHex(new BLAKE384(), "b771d5cef5d1a41a93d15643d7181d2a2ef0a8e84d91812f20ed21f147bef732bf3a60ef4067c3734b85bc8cd471780f10dc9e8291b58339a677b960218f71e793f2797aea349406512829065d37bb55ea796fa4f56fd8896b49b2cd19b43215ad967c712b24e5032d065232e02c127409d2ed4146b9d75d763d52db98d949d3b0fed6a8052fbb", "e09e83f49a413c08534fb8167e8933abfc54971f66de9d8d38243bceb260893845034808e6ee5a76a4d997d5cc91a0da");
        TestDigest.testKatHex(new BLAKE384(), "b32d95b0b9aad2a8816de6d06d1f86008505bd8c14124f6e9a163b5a2ade55f835d0ec3880ef50700d3b25e42cc0af050ccd1be5e555b23087e04d7bf9813622780c7313a1954f8740b6ee2d3f71f768dd417f520482bd3a08d4f222b4ee9dbd015447b33507dd50f3ab4247c5de9a8abd62a8decea01e3b87c8b927f5b08beb37674c6f8e380c04", "eea448cb8bfbd5013a654f710772c72ceea13fa33b0f5e1458ae8e84e4a36c4329a3494fcd72b6ff8a6314bd981f36a5");
        TestDigest.testKatHex(new BLAKE384(), "04410e31082a47584b406f051398a6abe74e4da59bb6f85e6b49e8a1f7f2ca00dfba5462c2cd2bfde8b64fb21d70c083f11318b56a52d03b81cac5eec29eb31bd0078b6156786da3d6d8c33098c5c47bb67ac64db14165af65b44544d806dde5f487d5373c7f9792c299e9686b7e5821e7c8e2458315b996b5677d926dac57b3f22da873c601016a0d", "38c85c78e874f6fae1d65c371314b76407104bc32d60efbeab574f96a627d8958417c94c2ca8277eb77d1b676340f93b");
        TestDigest.testKatHex(new BLAKE384(), "8b81e9badde026f14d95c019977024c9e13db7a5cd21f9e9fc491d716164bbacdc7060d882615d411438aea056c340cdf977788f6e17d118de55026855f93270472d1fd18b9e7e812bae107e0dfde7063301b71f6cfe4e225cab3b232905a56e994f08ee2891ba922d49c3dafeb75f7c69750cb67d822c96176c46bd8a29f1701373fb09a1a6e3c7158f", "41dbb95f7b269b7fbaceb2af9d001d7bcb530069d7b671cfef7bd0adf2fd97b17f0241cd28faff48b3fdf7287a249366");
        TestDigest.testKatHex(new BLAKE384(), "fa6eed24da6666a22208146b19a532c2ec9ba94f09f1def1e7fc13c399a48e41acc2a589d099276296348f396253b57cb0e40291bd282773656b6e0d8bea1cda084a3738816a840485fcf3fb307f777fa5feac48695c2af4769720258c77943fb4556c362d9cba8bf103aeb9034baa8ea8bfb9c4f8e6742ce0d52c49ea8e974f339612e830e9e7a9c29065", "53454f499e4bf24f8878f5bcbd43abc7c8bd1010e7a9f71a36e7874dbf1665296d3c7367e2ad542a6e16ff64acf8ca25");
        TestDigest.testKatHex(new BLAKE384(), "9bb4af1b4f09c071ce3cafa92e4eb73ce8a6f5d82a85733440368dee4eb1cbc7b55ac150773b6fe47dbe036c45582ed67e23f4c74585dab509df1b83610564545642b2b1ec463e18048fc23477c6b2aa035594ecd33791af6af4cbc2a1166aba8d628c57e707f0b0e8707caf91cd44bdb915e0296e0190d56d33d8dde10b5b60377838973c1d943c22ed335e", "8850f9fb22b99bb96df346140ccce07f66d237af08046879e8aa61660bfcac75c5b87cd052cbea323fba2677d6d5af1d");
        TestDigest.testKatHex(new BLAKE384(), "2167f02118cc62043e9091a647cadbed95611a521fe0d64e8518f16c808ab297725598ae296880a773607a798f7c3cfce80d251ebec6885015f9abf7eaabae46798f82cb5926de5c23f44a3f9f9534b3c6f405b5364c2f8a8bdc5ca49c749bed8ce4ba48897062ae8424ca6dde5f55c0e42a95d1e292ca54fb46a84fbc9cd87f2d0c9e7448de3043ae22fdd229", "48b5f739e4e57086147b217777016864095c2cf9ed4f6429c188ff9f17f725d67b0f1d7034b8391ac5dc834a0d96ed52");
        TestDigest.testKatHex(new BLAKE384(), "94b7fa0bc1c44e949b1d7617d31b4720cbe7ca57c6fa4f4094d4761567e389ecc64f6968e4064df70df836a47d0c713336b5028b35930d29eb7a7f9a5af9ad5cf441745baec9bb014ceeff5a41ba5c1ce085feb980bab9cf79f2158e03ef7e63e29c38d7816a84d4f71e0f548b7fc316085ae38a060ff9b8dec36f91ad9ebc0a5b6c338cbb8f6659d342a24368cf", "7f3f3292b32af03ed4d7674752d7be1d53a05eaa586287cd33937ebce84ade25a960c28ebfe92e87556824d0087e6570");
        TestDigest.testKatHex(new BLAKE384(), "ea40e83cb18b3a242c1ecc6ccd0b7853a439dab2c569cfc6dc38a19f5c90acbf76aef9ea3742ff3b54ef7d36eb7ce4ff1c9ab3bc119cff6be93c03e208783335c0ab8137be5b10cdc66ff3f89a1bddc6a1eed74f504cbe7290690bb295a872b9e3fe2cee9e6c67c41db8efd7d863cf10f840fe618e7936da3dca5ca6df933f24f6954ba0801a1294cd8d7e66dfafec", "03a2247c1664e0b74795b0a9c9b4d46e1f81ee050351cf3abecd94bcdb3d9f95594bcfc6fdf35bb6235db5726aac87bd");
        TestDigest.testKatHex(new BLAKE384(), "157d5b7e4507f66d9a267476d33831e7bb768d4d04cc3438da12f9010263ea5fcafbde2579db2f6b58f911d593d5f79fb05fe3596e3fa80ff2f761d1b0e57080055c118c53e53cdb63055261d7c9b2b39bd90acc32520cbbdbda2c4fd8856dbcee173132a2679198daf83007a9b5c51511ae49766c792a29520388444ebefe28256fb33d4260439cba73a9479ee00c63", "8f2caedfcb5a7b1ce3cf228992d70e74bc7bb519d549b12af4ec32a95a18b64434bf234a2b2b479a5812c7a30d98491d");
        TestDigest.testKatHex(new BLAKE384(), "836b34b515476f613fe447a4e0c3f3b8f20910ac89a3977055c960d2d5d2b72bd8acc715a9035321b86703a411dde0466d58a59769672aa60ad587b8481de4bba552a1645779789501ec53d540b904821f32b0bd1855b04e4848f9f8cfe9ebd8911be95781a759d7ad9724a7102dbe576776b7c632bc39b9b5e19057e226552a5994c1dbb3b5c7871a11f5537011044c53", "f65db613c7a7bf3dc1ad35e2046f68f29405fbe02763c9835ed2e969251db5eee7887b44b9f04b90dea0f2f4b9970f68");
        TestDigest.testKatHex(new BLAKE384(), "cc7784a4912a7ab5ad3620aab29ba87077cd3cb83636adc9f3dc94f51edf521b2161ef108f21a0a298557981c0e53ce6ced45bdf782c1ef200d29bab81dd6460586964edab7cebdbbec75fd7925060f7da2b853b2b089588fa0f8c16ec6498b14c55dcee335cb3a91d698e4d393ab8e8eac0825f8adebeee196df41205c011674e53426caa453f8de1cbb57932b0b741d4c6", "2c3c9d3042719a170852669f5f72a35c22a399c154813d41472ec1f773ea5e7bb9f1be46a3c4c922fb62315bf1941c8e");
        TestDigest.testKatHex(new BLAKE384(), "7639b461fff270b2455ac1d1afce782944aea5e9087eb4a39eb96bb5c3baaf0e868c8526d3404f9405e79e77bfac5ffb89bf1957b523e17d341d7323c302ea7083872dd5e8705694acdda36d5a1b895aaa16eca6104c82688532c8bfe1790b5dc9f4ec5fe95baed37e1d287be710431f1e5e8ee105bc42ed37d74b1e55984bf1c09fe6a1fa13ef3b96faeaed6a2a1950a12153", "38eedb1f638390b8c7cc76393ffd7ed40e306d04f57bad9603e02b6cecec730e02cabe19f1eaf84d129ae0cda1207452");
        TestDigest.testKatHex(new BLAKE384(), "eb6513fc61b30cfba58d4d7e80f94d14589090cf1d80b1df2e68088dc6104959ba0d583d585e9578ab0aec0cf36c48435eb52ed9ab4bbce7a5abe679c97ae2dbe35e8cc1d45b06dda3cf418665c57cbee4bbb47fa4caf78f4ee656fec237fe4eebbafa206e1ef2bd0ee4ae71bd0e9b2f54f91daadf1febfd7032381d636b733dcb3bf76fb14e23aff1f68ed3dbcf75c9b99c6f26", "2f68db904ca6289454b84a302ab8e752b4c8da0e4802520b324d32e0fceb052b43ec99aea3ef3298875ff984a19780af");
        TestDigest.testKatHex(new BLAKE384(), "1594d74bf5dde444265d4c04dad9721ff3e34cbf622daf341fe16b96431f6c4df1f760d34f296eb97d98d560ad5286fec4dce1724f20b54fd7df51d4bf137add656c80546fb1bf516d62ee82baa992910ef4cc18b70f3f8698276fcfb44e0ec546c2c39cfd8ee91034ff9303058b4252462f86c823eb15bf481e6b79cc3a02218595b3658e8b37382bd5048eaed5fd02c37944e73b", "a3abb3a5b2b948e98bb403f5612a80e3d6b60d57dfa01e1786ca1cb8b1818f70877a6ded84e5c60df8f9043b982bd63b");
        TestDigest.testKatHex(new BLAKE384(), "4cfa1278903026f66fedd41374558be1b585d03c5c55dac94361df286d4bd39c7cb8037ed3b267b07c346626449d0cc5b0dd2cf221f7e4c3449a4be99985d2d5e67bff2923357ddeab5abcb4619f3a3a57b2cf928a022eb27676c6cf805689004fca4d41ea6c2d0a4789c7605f7bb838dd883b3ad3e6027e775bcf262881428099c7fff95b14c095ea130e0b9938a5e22fc52650f591", "c8ba9a86f357ae3da2c4dde8419953e736637872e8e040d31ef6457658f63217d04f389271d53c5181344f9f8e19647f");
        TestDigest.testKatHex(new BLAKE384(), "d3e65cb92cfa79662f6af493d696a07ccf32aaadcceff06e73e8d9f6f909209e66715d6e978788c49efb9087b170ecf3aa86d2d4d1a065ae0efc8924f365d676b3cb9e2bec918fd96d0b43dee83727c9a93bf56ca2b2e59adba85696546a815067fc7a78039629d4948d157e7b0d826d1bf8e81237bab7321312fdaa4d521744f988db6fdf04549d0fdca393d639c729af716e9c8bba48", "11b6cc02ef3e4ad4312e20d0f638abb0368a56dd9a1aa090f2cbdbed1cee6613ac2f019a31ed1e0965453221d0c9560c");
        TestDigest.testKatHex(new BLAKE384(), "842cc583504539622d7f71e7e31863a2b885c56a0ba62db4c2a3f2fd12e79660dc7205ca29a0dc0a87db4dc62ee47a41db36b9ddb3293b9ac4baae7df5c6e7201e17f717ab56e12cad476be49608ad2d50309e7d48d2d8de4fa58ac3cfeafeee48c0a9eec88498e3efc51f54d300d828dddccb9d0b06dd021a29cf5cb5b2506915beb8a11998b8b886e0f9b7a80e97d91a7d01270f9a7717", "e8e2e1a205ac5412b3092ad245d7e8fdb7802155ae4e83a9b387e450d7f0b6bbf40e6ea923029823ac988fdc4070d468");
        TestDigest.testKatHex(new BLAKE384(), "6c4b0a0719573e57248661e98febe326571f9a1ca813d3638531ae28b4860f23c3a3a8ac1c250034a660e2d71e16d3acc4bf9ce215c6f15b1c0fc7e77d3d27157e66da9ceec9258f8f2bf9e02b4ac93793dd6e29e307ede3695a0df63cbdc0fc66fb770813eb149ca2a916911bee4902c47c7802e69e405fe3c04ceb5522792a5503fa829f707272226621f7c488a7698c0d69aa561be9f378", "32f9761cdba65f19750e37cd710c657aca45193f1c2fd6cc40bae9dfd410b4a59bce85dee5b0eadb6e75a9e83676f752");
        TestDigest.testKatHex(new BLAKE384(), "51b7dbb7ce2ffeb427a91ccfe5218fd40f9e0b7e24756d4c47cd55606008bdc27d16400933906fd9f30effdd4880022d081155342af3fb6cd53672ab7fb5b3a3bcbe47be1fd3a2278cae8a5fd61c1433f7d350675dd21803746cadca574130f01200024c6340ab0cc2cf74f2234669f34e9009ef2eb94823d62b31407f4ba46f1a1eec41641e84d77727b59e746b8a671bef936f05be820759fa", "9618c65c3d98ec5697ebc8f262b4ed9942bcc0312f71adea99b1e2d69c6975f17768281878ff75579f0b974519ff2325");
        TestDigest.testKatHex(new BLAKE384(), "83599d93f5561e821bd01a472386bc2ff4efbd4aed60d5821e84aae74d8071029810f5e286f8f17651cd27da07b1eb4382f754cd1c95268783ad09220f5502840370d494beb17124220f6afce91ec8a0f55231f9652433e5ce3489b727716cf4aeba7dcda20cd29aa9a859201253f948dd94395aba9e3852bd1d60dda7ae5dc045b283da006e1cbad83cc13292a315db5553305c628dd091146597", "6091ecdd39737dc6c76763cefe46087d6d75e1ec6d92fcd51b2ce548f43ab53f421ed3bc5d0377d6d0347735d5406f0e");
        TestDigest.testKatHex(new BLAKE384(), "2be9bf526c9d5a75d565dd11ef63b979d068659c7f026c08bea4af161d85a462d80e45040e91f4165c074c43ac661380311a8cbed59cc8e4c4518e80cd2c78ab1cabf66bff83eab3a80148550307310950d034a6286c93a1ece8929e6385c5e3bb6ea8a7c0fb6d6332e320e71cc4eb462a2a62e2bfe08f0ccad93e61bedb5dd0b786a728ab666f07e0576d189c92bf9fb20dca49ac2d3956d47385e2", "002d1af739b3d03a171c7d7fb59d4ba388996cdb95118dc1b7a4616ab78225e9c6d38f6a441c7d54cfa554c81fce26f7");
        TestDigest.testKatHex(new BLAKE384(), "ca76d3a12595a817682617006848675547d3e8f50c2210f9af906c0e7ce50b4460186fe70457a9e879e79fd4d1a688c70a347361c847ba0dd6aa52936eaf8e58a1be2f5c1c704e20146d366aeb3853bed9de9befe9569ac8aaea37a9fb7139a1a1a7d5c748605a8defb297869ebedd71d615a5da23496d11e11abbb126b206fa0a7797ee7de117986012d0362dcef775c2fe145ada6bda1ccb326bf644", "f258863cdf41862eabb4338e0d4f29f92977071497a8d361121c3287390a04c35ca0409ea6a1536fae3cda7c1ef13b1c");
        TestDigest.testKatHex(new BLAKE384(), "f76b85dc67421025d64e93096d1d712b7baf7fb001716f02d33b2160c2c882c310ef13a576b1c2d30ef8f78ef8d2f465007109aad93f74cb9e7d7bef7c9590e8af3b267c89c15db238138c45833c98cc4a471a7802723ef4c744a853cf80a0c2568dd4ed58a2c9644806f42104cee53628e5bdf7b63b0b338e931e31b87c24b146c6d040605567ceef5960df9e022cb469d4c787f4cba3c544a1ac91f95f", "3ee6da42fd0778c9486c138fd54633e3a070631297e7123c494af052ac7c7d7bf3c9c3a1472fa7d12e773a24fb7f965e");
        TestDigest.testKatHex(new BLAKE384(), "25b8c9c032ea6bcd733ffc8718fbb2a503a4ea8f71dea1176189f694304f0ff68e862a8197b839957549ef243a5279fc2646bd4c009b6d1edebf24738197abb4c992f6b1dc9ba891f570879accd5a6b18691a93c7d0a8d38f95b639c1daeb48c4c2f15ccf5b9d508f8333c32de78781b41850f261b855c4bebcc125a380c54d501c5d3bd07e6b52102116088e53d76583b0161e2a58d0778f091206aabd5a1", "58fdde48783daed82b142135ec09a7ab7ca1824442ac559de99c018db11ec5d2baf83ca31fcb1c03d44641a3d060871f");
        TestDigest.testKatHex(new BLAKE384(), "21cfdc2a7ccb7f331b3d2eefff37e48ad9fa9c788c3f3c200e0173d99963e1cbca93623b264e920394ae48bb4c3a5bb96ffbc8f0e53f30e22956adabc2765f57fb761e147ecbf8567533db6e50c8a1f894310a94edf806dd8ca6a0e141c0fa7c9fae6c6ae65f18c93a8529e6e5b553bf55f25be2e80a9882bd37f145fecbeb3d447a3c4e46c21524cc55cdd62f521ab92a8ba72b897996c49bb273198b7b1c9e", "5eb7f6af0842fa8f10ad2591760eeb9d4c6651db65e14ce83d351f501da5e30f88efe0967c0e391df5d6c3fedcfafef7");
        TestDigest.testKatHex(new BLAKE384(), "4e452ba42127dcc956ef4f8f35dd68cb225fb73b5bc7e1ec5a898bba2931563e74faff3b67314f241ec49f4a7061e3bd0213ae826bab380f1f14faab8b0efddd5fd1bb49373853a08f30553d5a55ccbbb8153de4704f29ca2bdeef0419468e05dd51557ccc80c0a96190bbcc4d77ecff21c66bdf486459d427f986410f883a80a5bcc32c20f0478bb9a97a126fc5f95451e40f292a4614930d054c851acd019ccf", "d3ce4dae3235f19901201c4ef128cb025c445e21324bf828f03dba1d924c3d97a0a02a3517e7627ed414196f6a17dd14");
        TestDigest.testKatHex(new BLAKE384(), "fa85671df7dadf99a6ffee97a3ab9991671f5629195049880497487867a6c446b60087fac9a0f2fcc8e3b24e97e42345b93b5f7d3691829d3f8ccd4bb36411b85fc2328eb0c51cb3151f70860ad3246ce0623a8dc8b3c49f958f8690f8e3860e71eb2b1479a5cea0b3f8befd87acaf5362435eaeccb52f38617bc6c5c2c6e269ead1fbd69e941d4ad2012da2c5b21bcfbf98e4a77ab2af1f3fda3233f046d38f1dc8", "e4b3885bee7075acb02a1b8c21dfc36832ca1ae9253be46fd165ce9a46a5b0e8387493523b8f8271782357d5d44dd879");
        TestDigest.testKatHex(new BLAKE384(), "e90847ae6797fbc0b6b36d6e588c0a743d725788ca50b6d792352ea8294f5ba654a15366b8e1b288d84f5178240827975a763bc45c7b0430e8a559df4488505e009c63da994f1403f407958203cebb6e37d89c94a5eacf6039a327f6c4dbbc7a2a307d976aa39e41af6537243fc218dfa6ab4dd817b6a397df5ca69107a9198799ed248641b63b42cb4c29bfdd7975ac96edfc274ac562d0474c60347a078ce4c25e88", "295e8c4f1b545e37d02a74dd855dc364681b7838470e1b1c937f5dceefdadff4f864e398dcd1c8f088666cec8990faa6");
        TestDigest.testKatHex(new BLAKE384(), "f6d5c2b6c93954fc627602c00c4ca9a7d3ed12b27173f0b2c9b0e4a5939398a665e67e69d0b12fb7e4ceb253e8083d1ceb724ac07f009f094e42f2d6f2129489e846eaff0700a8d4453ef453a3eddc18f408c77a83275617fabc4ea3a2833aa73406c0e966276079d38e8e38539a70e194cc5513aaa457c699383fd1900b1e72bdfb835d1fd321b37ba80549b078a49ea08152869a918ca57f5b54ed71e4fd3ac5c06729", "9649de9e67514a4011ca2f2a77c748ea1994c394b5c011483d1ff2c79b41da09b92b7b717b36a3bd3d54eb72853abce2");
        TestDigest.testKatHex(new BLAKE384(), "cf8562b1bed89892d67ddaaf3deeb28246456e972326dbcdb5cf3fb289aca01e68da5d59896e3a6165358b071b304d6ab3d018944be5049d5e0e2bb819acf67a6006111089e6767132d72dd85beddcbb2d64496db0cc92955ab4c6234f1eea24f2d51483f2e209e4589bf9519fac51b4d061e801125e605f8093bb6997bc163d551596fe4ab7cfae8fb9a90f6980480ce0c229fd1675409bd788354daf316240cfe0af93eb", "1be2fc45ccade289af0db27c604c8c701f857caf18e86af7aa2a3ad41db8b32843fd9a310ab57c6c6de1b53d2b586bfa");
        TestDigest.testKatHex(new BLAKE384(), "2ace31abb0a2e3267944d2f75e1559985db7354c6e605f18dc8470423fca30b7331d9b33c4a4326783d1caae1b4f07060eff978e4746bf0c7e30cd61040bd5ec2746b29863eb7f103ebda614c4291a805b6a4c8214230564a0557bc7102e0bd3ed23719252f7435d64d210ee2aafc585be903fa41e1968c50fd5d5367926df7a05e3a42cf07e656ff92de73b036cf8b19898c0cb34557c0c12c2d8b84e91181af467bc75a9d1", "47a3ef1639dac1da24769bd714575e7770c9b763f700ba01fe6443f01cf627abc0a9820569b497d6a0f885e55975bde6");
        TestDigest.testKatHex(new BLAKE384(), "0d8d09aed19f1013969ce5e7eb92f83a209ae76be31c754844ea9116ceb39a22ebb6003017bbcf26555fa6624185187db8f0cb3564b8b1c06bf685d47f3286eda20b83358f599d2044bbf0583fab8d78f854fe0a596183230c5ef8e54426750eaf2cc4e29d3bdd037e734d863c2bd9789b4c243096138f7672c232314effdfc6513427e2da76916b5248933be312eb5dde4cf70804fb258ac5fb82d58d08177ac6f4756017fff5", "e96c13061e71add3592e4889b8452a8666db3a5fb1a0eb60b67234d702cda995381bd2c7a631904c6ba7c6bcf832f62e");
        TestDigest.testKatHex(new BLAKE384(), "c3236b73deb7662bf3f3daa58f137b358ba610560ef7455785a9befdb035a066e90704f929bd9689cef0ce3bda5acf4480bceb8d09d10b098ad8500d9b6071dfc3a14af6c77511d81e3aa8844986c3bea6f469f9e02194c92868cd5f51646256798ff0424954c1434bdfed9facb390b07d342e992936e0f88bfd0e884a0ddb679d0547ccdec6384285a45429d115ac7d235a717242021d1dc35641f5f0a48e8445dba58e6cb2c8ea", "cd678535d1d24f7bdc8d86b551abb040833f7b78805b6ffe0df28c420bd6b68ac57c65a22946ef6cfc98f8883856ca98");
        TestDigest.testKatHex(new BLAKE384(), "b39feb8283eadc63e8184b51df5ae3fd41aac8a963bb0be1cd08aa5867d8d910c669221e73243360646f6553d1ca05a84e8dc0de05b6419ec349ca994480193d01c92525f3fb3dcefb08afc6d26947bdbbfd85193f53b50609c6140905c53a6686b58e53a319a57b962331ede98149af3de3118a819da4d76706a0424b4e1d2910b0ed26af61d150ebcb46595d4266a0bd7f651ba47d0c7f179ca28545007d92e8419d48fdfbd744ce", "5ecee373b724035ffd0dcb1633851ce560b7983592e175a94cd596b96cfb96a75769149c234dd3176da42fd90ac09024");
        TestDigest.testKatHex(new BLAKE384(), "a983d54f503803e8c7999f4edbbe82e9084f422143a932ddddc47a17b0b7564a7f37a99d0786e99476428d29e29d3c197a72bfab1342c12a0fc4787fd7017d7a6174049ea43b5779169ef7472bdbbd941dcb82fc73aac45a8a94c9f2bd3477f61fd3b796f02a1b8264a214c6fea74b7051b226c722099ec7883a462b83b6afdd4009248b8a237f605fe5a08fe7d8b45321421ebba67bd70a0b00ddbf94baab7f359d5d1eea105f28dcfb", "2b8f0f82cb0c9259ca409a0340db8f03f4b647e90eb69c7a4fd3ec60aa850481e90b9ffd47b60998d714922efb07c2a0");
        TestDigest.testKatHex(new BLAKE384(), "e4d1c1897a0a866ce564635b74222f9696bf2c7f640dd78d7e2aca66e1b61c642bb03ea7536aae597811e9bf4a7b453ede31f97b46a5f0ef51a071a2b3918df16b152519ae3776f9f1edab4c2a377c3292e96408359d3613844d5eb393000283d5ad3401a318b12fd1474b8612f2bb50fb6a8b9e023a54d7dde28c43d6d8854c8d9d1155935c199811dbfc87e9e0072e90eb88681cc7529714f8fb8a2c9d88567adfb974ee205a9bf7b848", "c7f02607e1f3218fa9692b3cec3f9ad7d90a02b8507e564ca45df4c966542fcecb63193ead9ce77158bd1a41b2b37738");
        TestDigest.testKatHex(new BLAKE384(), "b10c59723e3dcadd6d75df87d0a1580e73133a9b7d00cb95ec19f5547027323be75158b11f80b6e142c6a78531886d9047b08e551e75e6261e79785366d7024bd7cd9cf322d9be7d57fb661069f2481c7bb759cd71b4b36ca2bc2df6d3a328faebdb995a9794a8d72155ed551a1f87c80bf6059b43fc764900b18a1c2441f7487743cf84e565f61f8dd2ece6b6ccc9444049197aaaf53e926fbee3bfca8be588ec77f29d211be89de18b15f6", "07185627b84e871dc25d6650bf96f7c09164d01fa091b84496a0a84151a0a551892c2d706c5c1804468a26a65e728156");
        TestDigest.testKatHex(new BLAKE384(), "db11f609baba7b0ca634926b1dd539c8cbada24967d7add4d9876f77c2d80c0f4dcefbd7121548373582705cca2495bd2a43716fe64ed26d059cfb566b3364bd49ee0717bdd9810dd14d8fad80dbbdc4cafb37cc60fb0fe2a80fb4541b8ca9d59dce457738a9d3d8f641af8c3fd6da162dc16fc01aac527a4a0255b4d231c0be50f44f0db0b713af03d968fe7f0f61ed0824c55c4b5265548febd6aad5c5eedf63efe793489c39b8fd29d104ce", "6fb012ca5d8a4805f13a2f04a212dc7802b75d5c504511156533718c76ed938391e140d327d0f6be6f776e26f98ebe6a");
        TestDigest.testKatHex(new BLAKE384(), "bebd4f1a84fc8b15e4452a54bd02d69e304b7f32616aadd90537937106ae4e28de9d8aab02d19bc3e2fde1d651559e296453e4dba94370a14dbbb2d1d4e2022302ee90e208321efcd8528ad89e46dc839ea9df618ea8394a6bff308e7726bae0c19bcd4be52da6258e2ef4e96aa21244429f49ef5cb486d7ff35cac1bacb7e95711944bccb2ab34700d42d1eb38b5d536b947348a458ede3dc6bd6ec547b1b0cae5b257be36a7124e1060c170ffa", "bc8fca4e710f1f24d20e8670500d6c1164c0256bd3ddb945a2b548e6605029434b373c933536d36bb5a27f4980757577");
        TestDigest.testKatHex(new BLAKE384(), "5aca56a03a13784bdc3289d9364f79e2a85c12276b49b92db0adaa4f206d5028f213f678c3510e111f9dc4c1c1f8b6acb17a6413aa227607c515c62a733817ba5e762cc6748e7e0d6872c984d723c9bb3b117eb8963185300a80bfa65cde495d70a46c44858605fccbed086c2b45cef963d33294dbe9706b13af22f1b7c4cd5a001cfec251fba18e722c6e1c4b1166918b4f6f48a98b64b3c07fc86a6b17a6d0480ab79d4e6415b520f1c484d675b1", "3eab979960be226ab1cfdb29500b31c62c29189f57a84b8fb530e85e241cbd81316ddacb6d18a9a5cff3b57a3503e0f8");
        TestDigest.testKatHex(new BLAKE384(), "a5aad0e4646a32c85cfcac73f02fc5300f1982fabb2f2179e28303e447854094cdfc854310e5c0f60993ceff54d84d6b46323d930adb07c17599b35b505f09e784bca5985e0172257797fb53649e2e9723efd16865c31b5c3d5113b58bb0bfc8920fabdda086d7537e66d709d050bd14d0c960873f156fad5b3d3840cdfcdc9be6af519db262a27f40896ab25cc39f96984d650611c0d5a3080d5b3a1bf186abd42956588b3b58cd948970d298776060", "a2d232347e66eb171078e3addbebd4b33196b99be9a076745daf29a7c148663dd1e5f6cf58b6e34f8a3bbc17880d8072");
        TestDigest.testKatHex(new BLAKE384(), "06cbbe67e94a978203ead6c057a1a5b098478b4b4cbef5a97e93c8e42f5572713575fc2a884531d7622f8f879387a859a80f10ef02708cd8f7413ab385afc357678b9578c0ebf641ef076a1a30f1f75379e9dcb2a885bdd295905ee80c0168a62a9597d10cf12dd2d8cee46645c7e5a141f6e0e23aa482abe5661c16e69ef1e28371e2e236c359ba4e92c25626a7b7ff13f6ea4ae906e1cfe163e91719b1f750a96cbde5fbc953d9e576cd216afc90323a", "75e8a23fd96ec773e06783554b66cc5ade2faad023fbc353be02d4d747f1b6fd264f85d9b7a48b5b5ca17e44455920e2");
        TestDigest.testKatHex(new BLAKE384(), "f1c528cf7739874707d4d8ad5b98f7c77169de0b57188df233b2dc8a5b31eda5db4291dd9f68e6bad37b8d7f6c9c0044b3bf74bbc3d7d1798e138709b0d75e7c593d3cccdc1b20c7174b4e692add820ace262d45ccfae2077e878796347168060a162ecca8c38c1a88350bd63bb539134f700fd4addd5959e255337daa06bc86358fabcbefdfb5bc889783d843c08aadc6c4f6c36f65f156e851c9a0f917e4a367b5ad93d874812a1de6a7b93cd53ad97232", "f1db3a19115d5e9f8a27280a8225ee1ba9a67e045bc9d1b0b7aa0e5f898ac4f92558a1c4d15439656c11a89203f7e04f");
        TestDigest.testKatHex(new BLAKE384(), "9d9f3a7ecd51b41f6572fd0d0881e30390dfb780991dae7db3b47619134718e6f987810e542619dfaa7b505c76b7350c6432d8bf1cfebdf1069b90a35f0d04cbdf130b0dfc7875f4a4e62cdb8e525aadd7ce842520a482ac18f09442d78305fe85a74e39e760a4837482ed2f437dd13b2ec1042afcf9decdc3e877e50ff4106ad10a525230d11920324a81094da31deab6476aa42f20c84843cfc1c58545ee80352bdd3740dd6a16792ae2d86f11641bb717c2", "fb4b57c0a42625c96360d46d9ea2cac17f4336eb98d4432745b866d28208f84abca46c9d38fa67f664f4a8e43355e4d6");
        TestDigest.testKatHex(new BLAKE384(), "5179888724819fbad3afa927d3577796660e6a81c52d98e9303261d5a4a83232f6f758934d50aa83ff9e20a5926dfebaac49529d006eb923c5ae5048ed544ec471ed7191edf46363383824f915769b3e688094c682b02151e5ee01e510b431c8865aff8b6b6f2f59cb6d129da79e97c6d2b8fa6c6da3f603199d2d1bcab547682a81cd6cf65f6551121391d78bcc23b5bd0e922ec6d8bf97c952e84dd28aef909aba31edb903b28fbfc33b7703cd996215a11238", "1dd27cbe75917f5052ac68dc4662fd8c62b1cf60bbdd40b8f9918e708731718ab69ac9445c78819c20e74ad8c9ae0471");
        TestDigest.testKatHex(new BLAKE384(), "576ef3520d30b7a4899b8c0d5e359e45c5189add100e43be429a02fb3de5ff4f8fd0e79d9663acca72cd29c94582b19292a557c5b1315297d168fbb54e9e2ecd13809c2b5fce998edc6570545e1499dbe7fb74d47cd7f35823b212b05bf3f5a79caa34224fdd670d335fcb106f5d92c3946f44d3afcbae2e41ac554d8e6759f332b76be89a0324aa12c5482d1ea3ee89ded4936f3e3c080436f539fa137e74c6d3389bdf5a45074c47bc7b20b0948407a66d855e2f", "69afdfb787553374345fcc80c97b6fbbd27972899decd7a2bbef5d498f0aa1e9b4fbe7cd31d9eb560c0a3744f5a5c9a1");
        TestDigest.testKatHex(new BLAKE384(), "0df2152fa4f4357c8741529dd77e783925d3d76e95bafa2b542a2c33f3d1d117d159cf473f82310356fee4c90a9e505e70f8f24859656368ba09381fa245eb6c3d763f3093f0c89b972e66b53d59406d9f01aea07f8b3b615cac4ee4d05f542e7d0dab45d67ccccd3a606ccbeb31ea1fa7005ba07176e60dab7d78f6810ef086f42f08e595f0ec217372b98970cc6321576d92ce38f7c397a403bada1548d205c343ac09deca86325373c3b76d9f32028fea8eb32515", "5febe0580cf2ddabd8a05bf1bed8388b97997e88d4ff3e03b57fa352eaf67793f8d8b59f0dfc2ac6b93d442fc8c1c095");
        TestDigest.testKatHex(new BLAKE384(), "3e15350d87d6ebb5c8ad99d42515cfe17980933c7a8f6b8bbbf0a63728cefaad2052623c0bd5931839112a48633fb3c2004e0749c87a41b26a8b48945539d1ff41a4b269462fd199bfecd45374756f55a9116e92093ac99451aefb2af9fd32d6d7f5fbc7f7a540d5097c096ebc3b3a721541de073a1cc02f7fb0fb1b9327fb0b1218ca49c9487ab5396622a13ae546c97abdef6b56380dda7012a8384091b6656d0ab272d363cea78163ff765cdd13ab1738b940d16cae", "70f7699b7d819a14389c28cd16e61e9c08d560a2da19b3b17a3c4a339551db5caa51d65cb306dda42aa5f7cb86211113");
        TestDigest.testKatHex(new BLAKE384(), "c38d6b0b757cb552be40940ece0009ef3b0b59307c1451686f1a22702922800d58bce7a636c1727ee547c01b214779e898fc0e560f8ae7f61bef4d75eaa696b921fd6b735d171535e9edd267c192b99880c87997711002009095d8a7a437e258104a41a505e5ef71e5613ddd2008195f0c574e6ba3fe40099cfa116e5f1a2fa8a6da04badcb4e2d5d0de31fdc4800891c45781a0aac7c907b56d631fca5ce8b2cde620d11d1777ed9fa603541de794ddc5758fcd5fad78c0", "44112f10f13bdbb0bf47e7a6f0f6471692595ef62f1401e4e57149f0d3781c596fbf3257196829f0c4201937d33b8b2d");
        TestDigest.testKatHex(new BLAKE384(), "8d2de3f0b37a6385c90739805b170057f091cd0c7a0bc951540f26a5a75b3e694631bb64c7635eed316f51318e9d8de13c70a2aba04a14836855f35e480528b776d0a1e8a23b547c8b8d6a0d09b241d3be9377160cca4e6793d00a515dc2992cb7fc741daca171431da99cce6f7789f129e2ac5cf65b40d703035cd2185bb936c82002daf8cbc27a7a9e554b06196630446a6f0a14ba155ed26d95bd627b7205c072d02b60db0fd7e49ea058c2e0ba202daff0de91e845cf79", "e308794b8f5d7384c43a77d51953744618652cb7c3d43b5b714195b35c96a62599b2973f3c81a55d0334faa9c2b034b8");
        TestDigest.testKatHex(new BLAKE384(), "c464bbdad275c50dcd983b65ad1019b9ff85a1e71c807f3204bb2c921dc31fbcd8c5fc45868ae9ef85b6c9b83bba2a5a822201ed68586ec5ec27fb2857a5d1a2d09d09115f22dcc39fe61f5e1ba0ff6e8b4acb4c6da748be7f3f0839739394ff7fa8e39f7f7e84a33c3866875c01bcb1263c9405d91908e9e0b50e7459fabb63d8c6bbb73d8e3483c099b55bc30ff092ff68b6adedfd477d63570c9f5515847f36e24ba0b705557130cec57ebad1d0b31a378e91894ee26e3a04", "42395cbe743a5b16238e1b68e5fcc8289e45811b72f6ff55838c53fe7d699e8c97dc7d6516ffadb6d435734642d06869");
        TestDigest.testKatHex(new BLAKE384(), "8b8d68bb8a75732fe272815a68a1c9c5aa31b41dedc8493e76525d1d013d33cebd9e21a5bb95db2616976a8c07fcf411f5f6bc6f7e0b57aca78cc2790a6f9b898858ac9c79b165ff24e66677531e39f572be5d81eb3264524181115f32780257bfb9aeec6af12af28e587cac068a1a2953b59ad680f4c245b2e3ec36f59940d37e1d3db38e13edb29b5c0f404f6ff87f80fc8be7a225ff22fbb9c8b6b1d7330c57840d24bc75b06b80d30dad6806544d510af6c4785e823ac3e0b8", "d978002d95d38ca66be37a232f01772b7dcaa942db59cd058ffd52d69af8fea75042132a98ffd2d29ec0e8ef73be52b4");
        TestDigest.testKatHex(new BLAKE384(), "6b018710446f368e7421f1bc0ccf562d9c1843846bc8d98d1c9bf7d9d6fcb48bfc3bf83b36d44c4fa93430af75cd190bde36a7f92f867f58a803900df8018150384d85d82132f123006ac2aeba58e02a037fe6afbd65eca7c44977dd3dc74f48b6e7a1bfd5cc4dcf24e4d52e92bd4455848e4928b0eac8b7476fe3cc03e862aa4dff4470dbfed6de48e410f25096487ecfc32a27277f3f5023b2725ade461b1355889554a8836c9cf53bd767f5737d55184eea1ab3f53edd0976c485", "c7ccf3f1db2a575188b46c7747b04c1f5d24ff5d751e983154c8862339a01e1a19b38a5260f4b3cad4fdc7464d7eb585");
        TestDigest.testKatHex(new BLAKE384(), "c9534a24714bd4be37c88a3da1082eda7cabd154c309d7bd670dccd95aa535594463058a29f79031d6ecaa9f675d1211e9359be82669a79c855ea8d89dd38c2c761ddd0ec0ce9e97597432e9a1beae062cdd71edfdfd464119be9e69d18a7a7fd7ce0e2106f0c8b0abf4715e2ca48ef9f454dc203c96656653b727083513f8efb86e49c513bb758b3b052fe21f1c05bb33c37129d6cc81f1aef6adc45b0e8827a830fe545cf57d0955802c117d23ccb55ea28f95c0d8c2f9c5a242b33f", "3064c777cfd3c588956f181971934298db61d783e2a57a7dc35d1074c7961d792773c5c7387edf8a8e2f271fe06904a9");
        TestDigest.testKatHex(new BLAKE384(), "07906c87297b867abf4576e9f3cc7f82f22b154afcbf293b9319f1b0584da6a40c27b32e0b1b7f412c4f1b82480e70a9235b12ec27090a5a33175a2bb28d8adc475cefe33f7803f8ce27967217381f02e67a3b4f84a71f1c5228e0c2ad971373f6f672624fcea8d1a9f85170fad30fa0bbd25035c3b41a6175d467998bd1215f6f3866f53847f9cf68ef3e2fbb54bc994de2302b829c5eea68ec441fcbafd7d16ae4fe9fff98bf00e5bc2ad54dd91ff9fda4dd77b6c754a91955d1fbaad0", "ec8f6699c046c4098e246288a6ab03eee09885320759397bf50d5b88bc256e4d31fd2de2fb6dd324b9be40e95e3546d4");
        TestDigest.testKatHex(new BLAKE384(), "588e94b9054abc2189df69b8ba34341b77cdd528e7860e5defcaa79b0c9a452ad4b82aa306be84536eb7cedcbe058d7b84a6aef826b028b8a0271b69ac3605a9635ea9f5ea0aa700f3eb7835bc54611b922964300c953efe7491e3677c2cebe0822e956cd16433b02c68c4a23252c3f9e151a416b4963257b783e038f6b4d5c9f110f871652c7a649a7bcedcbccc6f2d0725bb903cc196ba76c76aa9f10a190b1d1168993baa9ffc96a1655216773458bec72b0e39c9f2c121378feab4e76a", "5ec1a457aaa4fb8fd671122739de146087916a9866dfe1042cdaa6bb94474f8e7d23788888e19db75fc39855834f4c03");
        TestDigest.testKatHex(new BLAKE384(), "08959a7e4baae874928813364071194e2939772f20db7c3157078987c557c2a6d5abe68d520eef3dc491692e1e21bcd880adebf63bb4213b50897fa005256ed41b5690f78f52855c8d9168a4b666fce2da2b456d7a7e7c17ab5f2fb1ee90b79e698712e963715983fd07641ae4b4e9dc73203fac1ae11fa1f8c7941fcc82eab247addb56e2638447e9d609e610b60ce086656aaebf1da3c8a231d7d94e2fd0afe46b391ff14a72eaeb3f44ad4df85866def43d4781a0b3578bc996c87970b132", "76421185d080f195a827ddcaa56d0d22a32df98f931f69b7cf838fee3768db3e5e34b1e920cdc7081c646ab90ee898eb");
        TestDigest.testKatHex(new BLAKE384(), "cb2a234f45e2ecd5863895a451d389a369aab99cfef0d5c9ffca1e6e63f763b5c14fb9b478313c8e8c0efeb3ac9500cf5fd93791b789e67eac12fd038e2547cc8e0fc9db591f33a1e4907c64a922dda23ec9827310b306098554a4a78f050262db5b545b159e1ff1dca6eb734b872343b842c57eafcfda8405eedbb48ef32e99696d135979235c3a05364e371c2d76f1902f1d83146df9495c0a6c57d7bf9ee77e80f9787aee27be1fe126cdc9ef893a4a7dcbbc367e40fe4e1ee90b42ea25af01", "355b2849d4d64e8a9f5b7f4ee0f9c38b04e8334cf9af702ede912a40b25b621b90e50d88fddae5ce91d4e2d53da85e26");
        TestDigest.testKatHex(new BLAKE384(), "d16beadf02ab1d4dc6f88b8c4554c51e866df830b89c06e786a5f8757e8909310af51c840efe8d20b35331f4355d80f73295974653ddd620cdde4730fb6c8d0d2dcb2b45d92d4fbdb567c0a3e86bd1a8a795af26fbf29fc6c65941cddb090ff7cd230ac5268ab4606fccba9eded0a2b5d014ee0c34f0b2881ac036e24e151be89eeb6cd9a7a790afccff234d7cb11b99ebf58cd0c589f20bdac4f9f0e28f75e3e04e5b3debce607a496d848d67fa7b49132c71b878fd5557e082a18eca1fbda94d4b", "712b7283c60818680eb8d50ca731dc2e42e6d3dc3c1c92b117131922d842fa57650bfc36f9238005b5af42a4c078b452");
        TestDigest.testKatHex(new BLAKE384(), "8f65f6bc59a85705016e2bae7fe57980de3127e5ab275f573d334f73f8603106ec3553016608ef2dd6e69b24be0b7113bf6a760ba6e9ce1c48f9e186012cf96a1d4849d75df5bb8315387fd78e9e153e76f8ba7ec6c8849810f59fb4bb9b004318210b37f1299526866f44059e017e22e96cbe418699d014c6ea01c9f0038b10299884dbec3199bb05adc94e955a1533219c1115fed0e5f21228b071f40dd57c4240d98d37b73e412fe0fa4703120d7c0c67972ed233e5deb300a22605472fa3a3ba86", "a6e6d3b9fec325f82f3029875d609243dafd055763789e604fe2524c17d5c91fbdbc8493db4f0ac811aabb9f4159d284");
        TestDigest.testKatHex(new BLAKE384(), "84891e52e0d451813210c3fd635b39a03a6b7a7317b221a7abc270dfa946c42669aacbbbdf801e1584f330e28c729847ea14152bd637b3d0f2b38b4bd5bf9c791c58806281103a3eabbaede5e711e539e6a8b2cf297cf351c078b4fa8f7f35cf61bebf8814bf248a01d41e86c5715ea40c63f7375379a7eb1d78f27622fb468ab784aaaba4e534a6dfd1df6fa15511341e725ed2e87f98737ccb7b6a6dfae416477472b046bf1811187d151bfa9f7b2bf9acdb23a3be507cdf14cfdf517d2cb5fb9e4ab6", "c9f5d4c7af225758988c5b14f914399bdd661a16614bff43c78edcf60a81574242687721766e04741823a5493328c167");
        TestDigest.testKatHex(new BLAKE384(), "fdd7a9433a3b4afabd7a3a5e3457e56debf78e84b7a0b0ca0e8c6d53bd0c2dae31b2700c6128334f43981be3b213b1d7a118d59c7e6b6493a86f866a1635c12859cfb9ad17460a77b4522a5c1883c3d6acc86e6162667ec414e9a104aa892053a2b1d72165a855bacd8faf8034a5dd9b716f47a0818c09bb6baf22aa503c06b4ca261f557761989d2afbd88b6a678ad128af68672107d0f1fc73c5ca740459297b3292b281e93bceb761bde7221c3a55708e5ec84472cddcaa84ecf23723cc0991355c6280", "f5daa5f9652ac75906673c512b14c6aed32f13d08dbc9201569e8df2a14f1369846e393b20a1b991133130c172786b7e");
        TestDigest.testKatHex(new BLAKE384(), "70a40bfbef92277a1aad72f6b79d0177197c4ebd432668cfec05d099accb651062b5dff156c0b27336687a94b26679cfdd9daf7ad204338dd9c4d14114033a5c225bd11f217b5f4732da167ee3f939262d4043fc9cba92303b7b5e96aea12adda64859df4b86e9ee0b58e39091e6b188b408ac94e1294a8911245ee361e60e601eff58d1d37639f3753bec80ebb4efde25817436076623fc65415fe51d1b0280366d12c554d86743f3c3b6572e400361a60726131441ba493a83fbe9afda90f7af1ae717238d", "161254177f2a7f3bdb20600ad403e330545e6854e1257b6ffb768debb8c1e79b039402ad9daf637b7553494ab2d7345e");
        TestDigest.testKatHex(new BLAKE384(), "74356e449f4bf8644f77b14f4d67cb6bd9c1f5ae357621d5b8147e562b65c66585caf2e491b48529a01a34d226d436959153815380d5689e30b35357cdac6e08d3f2b0e88e200600d62bd9f5eaf488df86a4470ea227006182e44809009868c4c280c43d7d64a5268fa719074960087b3a6abc837882f882c837834535929389a12b2c78187e2ea07ef8b8eef27dc85002c3ae35f1a50bee6a1c48ba7e175f3316670b27983472aa6a61eed0a683a39ee323080620ea44a9f74411ae5ce99030528f9ab49c79f2", "def4517c39a3c04eea1bf87df0ea9ae57dd1606282b25eab8fe9910060f2b0e4dbf865829d045755199c70b2d6876d2d");
        TestDigest.testKatHex(new BLAKE384(), "8c3798e51bc68482d7337d3abb75dc9ffe860714a9ad73551e120059860dde24ab87327222b64cf774415a70f724cdf270de3fe47dda07b61c9ef2a3551f45a5584860248fabde676e1cd75f6355aa3eaeabe3b51dc813d9fb2eaa4f0f1d9f834d7cad9c7c695ae84b329385bc0bef895b9f1edf44a03d4b410cc23a79a6b62e4f346a5e8dd851c2857995ddbf5b2d717aeb847310e1f6a46ac3d26a7f9b44985af656d2b7c9406e8a9e8f47dcb4ef6b83caacf9aefb6118bfcff7e44bef6937ebddc89186839b77", "8ba2f9b6ab5923ee8c5a6ff48cb113d87c935b2331624aa8a4c40b0a48848e29ef368968b40ef0f22300093ce252dd91");
        TestDigest.testKatHex(new BLAKE384(), "fa56bf730c4f8395875189c10c4fb251605757a8fecc31f9737e3c2503b02608e6731e85d7a38393c67de516b85304824bfb135e33bf22b3a23b913bf6acd2b7ab85198b8187b2bcd454d5e3318cacb32fd6261c31ae7f6c54ef6a7a2a4c9f3ecb81ce3555d4f0ad466dd4c108a90399d70041997c3b25345a9653f3c9a6711ab1b91d6a9d2216442da2c973cbd685ee7643bfd77327a2f7ae9cb283620a08716dfb462e5c1d65432ca9d56a90e811443cd1ecb8f0de179c9cb48ba4f6fec360c66f252f6e64edc96b", "66daedeb202da8b865031316ff11c1ed758ee40db17fa3607b8284b542cbd4cc1ecacf4eb61d8c608af619837f4bedca");
        TestDigest.testKatHex(new BLAKE384(), "b6134f9c3e91dd8000740d009dd806240811d51ab1546a974bcb18d344642baa5cd5903af84d58ec5ba17301d5ec0f10ccd0509cbb3fd3fff9172d193af0f782252fd1338c7244d40e0e42362275b22d01c4c3389f19dd69bdf958ebe28e31a4ffe2b5f18a87831cfb7095f58a87c9fa21db72ba269379b2dc2384b3da953c7925761fed324620acea435e52b424a7723f6a2357374157a34cd8252351c25a1b232826cefe1bd3e70ffc15a31e7c0598219d7f00436294d11891b82497bc78aa5363892a2495df8c1eef", "9e795abf80b0040c97ff4931467f2a8e53c4750a7699359d424ea50f27606c437f8e87170c2776cf8b0cf07b551d520e");
        TestDigest.testKatHex(new BLAKE384(), "c941cdb9c28ab0a791f2e5c8e8bb52850626aa89205bec3a7e22682313d198b1fa33fc7295381354858758ae6c8ec6fac3245c6e454d16fa2f51c4166fab51df272858f2d603770c40987f64442d487af49cd5c3991ce858ea2a60dab6a65a34414965933973ac2457089e359160b7cdedc42f29e10a91921785f6b7224ee0b349393cdcff6151b50b377d609559923d0984cda6000829b916ab6896693ef6a2199b3c22f7dc5500a15b8258420e314c222bc000bc4e5413e6dd82c993f8330f5c6d1be4bc79f08a1a0a46", "39570e9fb83bd77eab0194653e08ce36dcc6ccf2fe49822868db1c13ee5c2ac925ee52b3fb902a4b5d5bd33c617d12a6");
        TestDigest.testKatHex(new BLAKE384(), "4499efffac4bcea52747efd1e4f20b73e48758be915c88a1ffe5299b0b005837a46b2f20a9cb3c6e64a9e3c564a27c0f1c6ad1960373036ec5bfe1a8fc6a435c2185ed0f114c50e8b3e4c7ed96b06a036819c9463e864a58d6286f785e32a804443a56af0b4df6abc57ed5c2b185ddee8489ea080deeee66aa33c2e6dab36251c402682b6824821f998c32163164298e1fafd31babbcffb594c91888c6219079d907fdb438ed89529d6d96212fd55abe20399dbefd342248507436931cdead496eb6e4a80358acc78647d043", "a6842c1d02b18905fcd8274cfce6c72820457436f6dbcb087011eb1dae44bccb016e114211b1c21bfc3d7e5763d7daf6");
        TestDigest.testKatHex(new BLAKE384(), "eecbb8fdfa4da62170fd06727f697d81f83f601ff61e478105d3cb7502f2c89bf3e8f56edd469d049807a38882a7eefbc85fc9a950952e9fa84b8afebd3ce782d4da598002827b1eb98882ea1f0a8f7aa9ce013a6e9bc462fb66c8d4a18da21401e1b93356eb12f3725b6db1684f2300a98b9a119e5d27ff704affb618e12708e77e6e5f34139a5a41131fd1d6336c272a8fc37080f041c71341bee6ab550cb4a20a6ddb6a8e0299f2b14bc730c54b8b1c1c487b494bdccfd3a53535ab2f231590bf2c4062fd2ad58f906a2d0d", "e852abc95b04fcc3cb719cf8a26f0f93614a9ad23b11715c25c5856a7c535654300ceb14f10f7b5f4c494b052d084063");
        TestDigest.testKatHex(new BLAKE384(), "e64f3e4ace5c8418d65fec2bc5d2a303dd458034736e3b0df719098be7a206deaf52d6ba82316caf330ef852375188cde2b39cc94aa449578a7e2a8e3f5a9d68e816b8d16889fbc0ebf0939d04f63033ae9ae2bdab73b88c26d6bd25ee460ee1ef58fb0afa92cc539f8c76d3d097e7a6a63ebb9b5887edf3cf076028c5bbd5b9db3211371ad3fe121d4e9bf44229f4e1ecf5a0f9f0eba4d5ceb72878ab22c3f0eb5a625323ac66f7061f4a81fac834471e0c59553f108475fe290d43e6a055ae3ee46fb67422f814a68c4be3e8c9", "c3ae4b2d2f21cf38e1eb54ea6eace7ddc3ec9d3c206377a50b9eac97637187409a1ddcf44cbf0308509705d33a837096");
        TestDigest.testKatHex(new BLAKE384(), "d2cb2d733033f9e91395312808383cc4f0ca974e87ec68400d52e96b3fa6984ac58d9ad0938dde5a973008d818c49607d9de2284e7618f1b8aed8372fbd52ed54557af4220fac09dfa8443011699b97d743f8f2b1aef3537ebb45dcc9e13dfb438428ee190a4efdb3caeb7f3933117bf63abdc7e57beb4171c7e1ad260ab0587806c4d137b6316b50abc9cce0dff3acada47bbb86be777e617bbe578ff4519844db360e0a96c6701290e76bb95d26f0f804c8a4f2717eac4e7de9f2cff3bbc55a17e776c0d02856032a6cd10ad2838", "351abe9e52ef5b8ed6f3078d663f5e58c0549a0fbf5641a29c39efa722b7ceae04059993e388854afdece59c193ae95f");
        TestDigest.testKatHex(new BLAKE384(), "f2998955613dd414cc111df5ce30a995bb792e260b0e37a5b1d942fe90171a4ac2f66d4928d7ad377f4d0554cbf4c523d21f6e5f379d6f4b028cdcb9b1758d3b39663242ff3cb6ede6a36a6f05db3bc41e0d861b384b6dec58bb096d0a422fd542df175e1be1571fb52ae66f2d86a2f6824a8cfaacbac4a7492ad0433eeb15454af8f312b3b2a577750e3efbd370e8a8cac1582581971fba3ba4bd0d76e718dacf8433d33a59d287f8cc92234e7a271041b526e389efb0e40b6a18b3aaf658e82ed1c78631fd23b4c3eb27c3faec8685", "0d87752e07963f3524646b7e8a84afff38062ff1eaeec7c1f8fd8d1608c27997a5b377a8ec47ffd0c430ab9aeff4b299");
        TestDigest.testKatHex(new BLAKE384(), "447797e2899b72a356ba55bf4df3acca6cdb1041eb477bd1834a9f9acbc340a294d729f2f97df3a610be0ff15edb9c6d5db41644b9874360140fc64f52aa03f0286c8a640670067a84e017926a70438db1bb361defee7317021425f8821def26d1efd77fc853b818545d055adc9284796e583c76e6fe74c9ac2587aa46aa8f8804f2feb5836cc4b3ababab8429a5783e17d5999f32242eb59ef30cd7adabc16d72dbdb097623047c98989f88d14eaf02a7212be16ec2d07981aaa99949ddf89ecd90333a77bc4e1988a82abf7c7caf3291", "ed09d9c98a13d61ac90304b872adbdcda78e1eb83cbc5110226f2cf7212862b062c9f5a46370ef83d6642e84b2432d3e");
        TestDigest.testKatHex(new BLAKE384(), "9f2c18ade9b380c784e170fb763e9aa205f64303067eb1bcea93df5dac4bf5a2e00b78195f808df24fc76e26cb7be31dc35f0844cded1567bba29858cffc97fb29010331b01d6a3fb3159cc1b973d255da9843e34a0a4061cabdb9ed37f241bfabb3c20d32743f4026b59a4ccc385a2301f83c0b0a190b0f2d01acb8f0d41111e10f2f4e149379275599a52dc089b35fdd5234b0cfb7b6d8aebd563ca1fa653c5c021dfd6f5920e6f18bfafdbecbf0ab00281333ed50b9a999549c1c8f8c63d7626c48322e9791d5ff72294049bde91e73f8", "85b7af961bd0901ee58e46ae3d278c7d0d674127e5b8e7a9546b0ec5c51270cf60747ee692a72c59360e9249a506f3d9");
        TestDigest.testKatHex(new BLAKE384(), "ae159f3fa33619002ae6bcce8cbbdd7d28e5ed9d61534595c4c9f43c402a9bb31f3b301cbfd4a43ce4c24cd5c9849cc6259eca90e2a79e01ffbac07ba0e147fa42676a1d668570e0396387b5bcd599e8e66aaed1b8a191c5a47547f61373021fa6deadcb55363d233c24440f2c73dbb519f7c9fa5a8962efd5f6252c0407f190dfefad707f3c7007d69ff36b8489a5b6b7c557e79dd4f50c06511f599f56c896b35c917b63ba35c6ff8092baf7d1658e77fc95d8a6a43eeb4c01f33f03877f92774be89c1114dd531c011e53a34dc248a2f0e6", "8f15d03e9daf0315439b4eae078edb93770f26d83abc0c9f1765927573a7edbe94f17ad2d5f1c71525b0eeeef3db0603");
        TestDigest.testKatHex(new BLAKE384(), "3b8e97c5ffc2d6a40fa7de7fcefc90f3b12c940e7ab415321e29ee692dfac799b009c99dcddb708fce5a178c5c35ee2b8617143edc4c40b4d313661f49abdd93cea79d117518805496fe6acf292c4c2a1f76b403a97d7c399daf85b46ad84e16246c67d6836757bde336c290d5d401e6c1386ab32797af6bb251e9b2d8fe754c47482b72e0b394eab76916126fd68ea7d65eb93d59f5b4c5ac40f7c3b37e7f3694f29424c24af8c8f0ef59cd9dbf1d28e0e10f799a6f78cad1d45b9db3d7dee4a7059abe99182714983b9c9d44d7f5643596d4f3", "1e0545467f229d6066162aa91a333a4dc37d26a8bbb373600f26d5d6af2191f44840d9f879d10147871b68ff03c92772");
        TestDigest.testKatHex(new BLAKE384(), "3434ec31b10fafdbfeec0dd6bd94e80f7ba9dca19ef075f7eb017512af66d6a4bcf7d16ba0819a1892a6372f9b35bcc7ca8155ee19e8428bc22d214856ed5fa9374c3c09bde169602cc219679f65a1566fc7316f4cc3b631a18fb4449fa6afa16a3db2bc4212eff539c67cf184680826535589c7111d73bffce431b4c40492e763d9279560aaa38eb2dc14a212d723f994a1fe656ff4dd14551ce4e7c621b2aa5604a10001b2878a897a28a08095c325e10a26d2fb1a75bfd64c250309bb55a44f23bbac0d5516a1c687d3b41ef2fbbf9cc56d4739", "ffbbe2165cb0806538eb3c85927ad7bb16285e8facfe7185b865b4c77f856c850c0f08d45698744a53b460533479db4b");
        TestDigest.testKatHex(new BLAKE384(), "7c7953d81c8d208fd1c97681d48f49dd003456de60475b84070ef4847c333b74575b1fc8d2a186964485a3b8634feaa3595aaa1a2f4595a7d6b6153563dee31bbac443c8a33eed6d5d956a980a68366c2527b550ee950250dfb691eacbd5d56ae14b970668be174c89df2fea43ae52f13142639c884fd62a3683c0c3792f0f24ab1318bcb27e21f4737fab62c77ea38bc8fd1cf41f7dab64c13febe7152bf5bb7ab5a78f5346d43cc741cb6f72b7b8980f268b68bf62abdfb1577a52438fe14b591498cc95f071228460c7c5d5ceb4a7bde588e7f21c", "01efa58201b4afc38ea52082b52905fec3c62628ef21bc770094e97554ffffc7ec961ba15ace0f6b5016da9aa630210e");
        TestDigest.testKatHex(new BLAKE384(), "7a6a4f4fdc59a1d223381ae5af498d74b7252ecf59e389e49130c7eaee626e7bd9897effd92017f4ccde66b0440462cdedfd352d8153e6a4c8d7a0812f701cc737b5178c2556f07111200eb627dbc299caa792dfa58f35935299fa3a3519e9b03166dffa159103ffa35e8577f7c0a86c6b46fe13db8e2cdd9dcfba85bdddcce0a7a8e155f81f712d8e9fe646153d3d22c811bd39f830433b2213dd46301941b59293fd0a33e2b63adbd95239bc01315c46fdb678875b3c81e053a40f581cfbec24a1404b1671a1b88a6d06120229518fb13a74ca0ac5ae", "bb793c14b14f1b2620b07eef6ce8a8f87b4cc8dc8cc9bfcb501f15a2a7c5422151083b1c8d51d4d2e3e124f130e4ea08");
        TestDigest.testKatHex(new BLAKE384(), "d9faa14cebe9b7de551b6c0765409a33938562013b5e8e0e1e0a6418df7399d0a6a771fb81c3ca9bd3bb8e2951b0bc792525a294ebd1083688806fe5e7f1e17fd4e3a41d00c89e8fcf4a363caedb1acb558e3d562f1302b3d83bb886ed27b76033798131dab05b4217381eaaa7ba15ec820bb5c13b516dd640eaec5a27d05fdfca0f35b3a5312146806b4c0275bcd0aaa3b2017f346975db566f9b4d137f4ee10644c2a2da66deeca5342e236495c3c6280528bfd32e90af4cd9bb908f34012b52b4bc56d48cc8a6b59bab014988eabd12e1a0a1c2e170e7", "037ca0705a93e3eb7aa31e5eef54872ca029f6f07e695daa9602281d6633fbadffd93bef96353d2de2a74e67388cb71d");
        TestDigest.testKatHex(new BLAKE384(), "2d8427433d0c61f2d96cfe80cf1e932265a191365c3b61aaa3d6dcc039f6ba2ad52a6a8cc30fc10f705e6b7705105977fa496c1c708a277a124304f1fc40911e7441d1b5e77b951aad7b01fd5db1b377d165b05bbf898042e39660caf8b279fe5229d1a8db86c0999ed65e53d01ccbc4b43173ccf992b3a14586f6ba42f5fe30afa8ae40c5df29966f9346da5f8b35f16a1de3ab6de0f477d8d8660918060e88b9b9e9ca6a4207033b87a812dbf5544d39e4882010f82b6ce005f8e8ff6fe3c3806bc2b73c2b83afb704345629304f9f86358712e9fae3ca3e", "8e2b0448ad47a8ed78d4cc35c97f0dba145786967e290b20ff85542d9f3c49a1ac83b5c21103ab7cc4db5f4a819dba35");
        TestDigest.testKatHex(new BLAKE384(), "5e19d97887fcaac0387e22c6f803c34a3dacd2604172433f7a8a7a526ca4a2a1271ecfc5d5d7be5ac0d85d921095350dfc65997d443c21c8094e0a3fefd2961bcb94aed03291ae310ccda75d8ace4bc7d89e7d3e5d1650bda5d668b8b50bfc8e608e184f4d3a9a2badc4ff5f07e0c0bc8a9f2e0b2a26fd6d8c550008faaab75fd71af2a424bec9a7cd9d83fad4c8e9319115656a8717d3b523a68ff8004258b9990ed362308461804ba3e3a7e92d8f2ffae5c2fba55ba5a3c27c0a2f71bd711d2fe1799c2adb31b200035481e9ee5c4adf2ab9c0fa50b23975cf", "e280f7444c6e251e43c85056b30948c1b67b86fe5635bc323a5cc59a5820510b7c50cbfdd6fd5c0a279c5afdfd708116");
        TestDigest.testKatHex(new BLAKE384(), "c8e976ab4638909387ce3b8d4e510c3230e5690e02c45093b1d297910abc481e56eea0f296f98379dfc9080af69e73b2399d1c143bee80ae1328162ce1ba7f6a8374679b20aacd380eb4e61382c99998704d62701afa914f9a2705cdb065885f50d086c3eb5753700c387118bb142f3e6da1e988dfb31ac75d7368931e45d1391a274b22f83ceb072f9bcabc0b216685bfd789f5023971024b1878a205442522f9ea7d8797a4102a3df41703768251fd5e017c85d1200a464118aa35654e7ca39f3c375b8ef8cbe7534dbc64bc20befb417cf60ec92f63d9ee7397", "71332f7e71730a82294cb6521b6f6be692b1b614af54d6242435c62e59979d16d7605bf38ea848551a20da39a709125c");
        TestDigest.testKatHex(new BLAKE384(), "7145fa124b7429a1fc2231237a949ba7201bcc1822d3272de005b682398196c25f7e5cc2f289fbf44415f699cb7fe6757791b1443410234ae061edf623359e2b4e32c19bf88450432dd01caa5eb16a1dc378f391ca5e3c4e5f356728bddd4975db7c890da8bbc84cc73ff244394d0d48954978765e4a00b593f70f2ca082673a261ed88dbcef1127728d8cd89bc2c597e9102ced6010f65fa75a14ebe467fa57ce3bd4948b6867d74a9df5c0ec6f530cbf2ee61ce6f06bc8f2864dff5583776b31df8c7ffcb61428a56bf7bd37188b4a5123bbf338393af46eda85e6", "4633b72f6419df90251dff7f49e081ced92256574c309c0c393746482562446ad63bb51369f8edf2972a062a17e27957");
        TestDigest.testKatHex(new BLAKE384(), "7fdfadcc9d29bad23ae038c6c65cda1aef757221b8872ed3d75ff8df7da0627d266e224e812c39f7983e4558bfd0a1f2bef3feb56ba09120ef762917b9c093867948547aee98600d10d87b20106878a8d22c64378bf634f7f75900c03986b077b0bf8b740a82447b61b99fee5376c5eb6680ec9e3088f0bdd0c56883413d60c1357d3c811950e5890e7600103c916341b80c743c6a852b7b4fb60c3ba21f3bc15b8382437a68454779cf3cd7f9f90ccc8ef28d0b706535b1e4108eb5627bb45d719cb046839aee311ca1abdc8319e050d67972cb35a6b1601b25dbf487", "788ed19c77a5f273ab4334ec018b929d619b9db5863912b7e2c7c202eb7d74b5a4bda02185c52e23b0038043f7a3ca08");
        TestDigest.testKatHex(new BLAKE384(), "988638219fd3095421f826f56e4f09e356296b628c3ce6930c9f2e758fd1a80c8273f2f61e4daae65c4f110d3e7ca0965ac7d24e34c0dc4ba2d6ff0bf5bbe93b3585f354d7543cb542a1aa54674d375077f2d360a8f4d42f3db131c3b7ab7306267ba107659864a90c8c909460a73621d1f5d9d3fd95beb19b23db1cb6c0d0fba91d36891529b8bd8263caa1bab56a4affaed44962df096d8d5b1eb845ef31188b3e10f1af811a13f156beb7a288aae593ebd1471b624aa1a7c6adf01e2200b3d72d88a3aed3100c88231e41efc376906f0b580dc895f080fda5741db1cb", "515abc53104a282e30ddb6a47f6dfa5423be67d9ecd2b49deff7e548c6d8a9db9b7f013a0d6b39a52c133fbacb327be4");
        TestDigest.testKatHex(new BLAKE384(), "5aab62756d307a669d146aba988d9074c5a159b3de85151a819b117ca1ff6597f6156e80fdd28c9c3176835164d37da7da11d94e09add770b68a6e081cd22ca0c004bfe7cd283bf43a588da91f509b27a6584c474a4a2f3ee0f1f56447379240a5ab1fb77fdca49b305f07ba86b62756fb9efb4fc225c86845f026ea542076b91a0bc2cdd136e122c659be259d98e5841df4c2f60330d4d8cdee7bf1a0a244524eecc68ff2aef5bf0069c9e87a11c6e519de1a4062a10c83837388f7ef58598a3846f49d499682b683c4a062b421594fafbc1383c943ba83bdef515efcf10d", "0a58e0ade0683f13f64f9a13dc57e71309baf4d6de56c7b66d7973595ba54fbeff40b333f238a432c9eaa6ed169620ce");
        TestDigest.testKatHex(new BLAKE384(), "47b8216aa0fbb5d67966f2e82c17c07aa2d6327e96fcd83e3de7333689f3ee79994a1bf45082c4d725ed8d41205cb5bcdf5c341f77facb1da46a5b9b2cbc49eadf786bcd881f371a95fa17df73f606519aea0ff79d5a11427b98ee7f13a5c00637e2854134691059839121fea9abe2cd1bcbbbf27c74caf3678e05bfb1c949897ea01f56ffa4dafbe8644611685c617a3206c7a7036e4ac816799f693dafe7f19f303ce4eba09d21e03610201bfc665b72400a547a1e00fa9b7ad8d84f84b34aef118515e74def11b9188bd1e1f97d9a12c30132ec2806339bdadacda2fd8b78", "5e9ed49f7074aa2af7064e293e2855964aa7dcd706aad54b3c229a29a0145cc8f2927938fb7ed4698628e91c467b830f");
        TestDigest.testKatHex(new BLAKE384(), "8cff1f67fe53c098896d9136389bd8881816ccab34862bb67a656e3d98896f3ce6ffd4da73975809fcdf9666760d6e561c55238b205d8049c1cedeef374d1735daa533147bfa960b2cce4a4f254176bb4d1bd1e89654432b8dbe1a135c42115b394b024856a2a83dc85d6782be4b444239567ccec4b184d4548eae3ff6a192f343292ba2e32a0f267f31cc26719eb85245d415fb897ac2da433ee91a99424c9d7f1766a44171d1651001c38fc79294accc68ceb5665d36218454d3ba169ae058a831338c17743603f81ee173bfc0927464f9bd728dee94c6aeab7aae6ee3a627e8", "5526a2ff658d6997e0aa7ac70085132e3770ffd7711c60e9a42bbb10ed703f5d4c45f29f1ef093f1cab0db9dc5184f22");
        TestDigest.testKatHex(new BLAKE384(), "eacd07971cff9b9939903f8c1d8cbb5d4db1b548a85d04e037514a583604e787f32992bf2111b97ac5e8a938233552731321522ab5e8583561260b7d13ebeef785b23a41fd8576a6da764a8ed6d822d4957a545d5244756c18aa80e1aad4d1f9c20d259dee1711e2cc8fd013169fb7cc4ce38b362f8e0936ae9198b7e838dcea4f7a5b9429bb3f6bbcf2dc92565e3676c1c5e6eb3dd2a0f86aa23edd3d0891f197447692794b3dfa269611ad97f72b795602b4fdb198f3fd3eb41b415064256e345e8d8c51c555dc8a21904a9b0f1ad0effab7786aac2da3b196507e9f33ca356427", "e4b1bb0efcfdba851f2c25e38f4b13c25b7a5ac3b77b54c044c5070eb3f2d76969f2fd826da33b544d845f30ff2a757d");
        TestDigest.testKatHex(new BLAKE384(), "23ac4e9a42c6ef45c3336ce6dfc2ff7de8884cd23dc912fef0f7756c09d335c189f3ad3a23697abda851a81881a0c8ccafc980ab2c702564c2be15fe4c4b9f10dfb2248d0d0cb2e2887fd4598a1d4acda897944a2ffc580ff92719c95cf2aa42dc584674cb5a9bc5765b9d6ddf5789791d15f8dd925aa12bffafbce60827b490bb7df3dda6f2a143c8bf96abc903d83d59a791e2d62814a89b8080a28060568cf24a80ae61179fe84e0ffad00388178cb6a617d37efd54cc01970a4a41d1a8d3ddce46edbba4ab7c90ad565398d376f431189ce8c1c33e132feae6a8cd17a61c630012", "50384567d90a558f73a3874274c2d8d7c5f33105b4c0b4785a6b9eabd8d5a5b0f1f765ecb90299330aca62a1983bbc3e");
        TestDigest.testKatHex(new BLAKE384(), "0172df732282c9d488669c358e3492260cbe91c95cfbc1e3fea6c4b0ec129b45f242ace09f152fc6234e1bee8aab8cd56e8b486e1dcba9c05407c2f95da8d8f1c0af78ee2ed82a3a79ec0cb0709396ee62aadb84f8a4ee8a7ccca3c1ee84e302a09ea802204afecf04097e67d0f8e8a9d2651126c0a598a37081e42d168b0ae8a71951c524259e4e2054e535b779679bdade566fe55700858618e626b4a0faf895bcce9011504a49e05fd56127eae3d1f8917afb548ecadabda1020111fec9314c413498a360b08640549a22cb23c731ace743252a8227a0d2689d4c6001606678dfb921", "d53eaa72f07b42679f81102a5fb54219990a03e174124451d1bcb06d0fa5dabf41a4772e33dd67c46de7f35f2ee44c6d");
        TestDigest.testKatHex(new BLAKE384(), "3875b9240cf3e0a8b59c658540f26a701cf188496e2c2174788b126fd29402d6a75453ba0635284d08835f40051a2a9683dc92afb9383719191231170379ba6f4adc816fecbb0f9c446b785bf520796841e58878b73c58d3ebb097ce4761fdeabe15de2f319dfbaf1742cdeb389559c788131a6793e193856661376c81ce9568da19aa6925b47ffd77a43c7a0e758c37d69254909ff0fbd415ef8eb937bcd49f91468b49974c07dc819abd67395db0e05874ff83dddab895344abd0e7111b2df9e58d76d85ad98106b36295826be04d435615595605e4b4bb824b33c4afeb5e7bb0d19f909", "3f224c3b024a5e73a50022cbc59167c54efcef5e888244443be6dd05522e095ec9d5501ae57939478c6f5ef608490c8d");
        TestDigest.testKatHex(new BLAKE384(), "747cc1a59fefba94a9c75ba866c30dc5c1cb0c0f8e9361d98484956dd5d1a40f6184afbe3dac9f76028d1caeccfbf69199c6ce2b4c092a3f4d2a56fe5a33a00757f4d7dee5dfb0524311a97ae0668a47971b95766e2f6dd48c3f57841f91f04a00ad5ea70f2d479a2620dc5cd78eaab3a3b011719b7e78d19ddf70d9423798af77517ebc55392fcd01fc600d8d466b9e7a7a85bf33f9cc5419e9bd874ddfd60981150ddaf8d7febaa4374f0872a5628d318000311e2f5655365ad4d407c20e5c04df17a222e7deec79c5ab1116d8572f91cd06e1ccc7ced53736fc867fd49ecebe6bf8082e8a", "d3b84ec2c171c1a7a6f3a8a90727504e32a8a6037571d96a2e883eb01cfae5a7ac6c7c0000205652d492a84156eb68ce");
        TestDigest.testKatHex(new BLAKE384(), "57af971fccaec97435dc2ec9ef0429bcedc6b647729ea168858a6e49ac1071e706f4a5a645ca14e8c7746d65511620682c906c8b86ec901f3dded4167b3f00b06cbfac6aee3728051b3e5ff10b4f9ed8bd0b8da94303c833755b3ca3aeddf0b54bc8d6632138b5d25bab03d17b3458a9d782108006f5bb7de75b5c0ba854b423d8bb801e701e99dc4feaad59bc1c7112453b04d33ea3635639fb802c73c2b71d58a56bbd671b18fe34ed2e3dca38827d63fdb1d4fb3285405004b2b3e26081a8ff08cd6d2b08f8e7b7e90a2ab1ed7a41b1d0128522c2f8bff56a7fe67969422ce839a9d4608f03", "15af3a7f74220bf19ccf7d295b76c10daf440e3a4e2518c3eac96fb04f1486fc658f60b4f99852645fb0475edf3f8e5d");
        TestDigest.testKatHex(new BLAKE384(), "04e16dedc1227902baaf332d3d08923601bdd64f573faa1bb7201918cfe16b1e10151dae875da0c0d63c59c3dd050c4c6a874011b018421afc4623ab0381831b2da2a8ba42c96e4f70864ac44e106f94311051e74c77c1291bf5db9539e69567bf6a11cf6932bbbad33f8946bf5814c066d851633d1a513510039b349939bfd42b858c21827c8ff05f1d09b1b0765dc78a135b5ca4dfba0801bcaddfa175623c8b647eacfb4444b85a44f73890607d06d507a4f8393658788669f6ef4deb58d08c50ca0756d5e2f49d1a7ad73e0f0b3d3b5f090acf622b1878c59133e4a848e05153592ea81c6fbf", "a5c30e470aba5c2d1b507bbc1c7da2c4f82fa4878eb13f057e7416effc85af79b4ffee0353e460553acc145f8a6c6af3");
        TestDigest.testKatHex(new BLAKE384(), "7c815c384eee0f288ece27cced52a01603127b079c007378bc5d1e6c5e9e6d1c735723acbbd5801ac49854b2b569d4472d33f40bbb8882956245c366dc3582d71696a97a4e19557e41e54dee482a14229005f93afd2c4a7d8614d10a97a9dfa07f7cd946fa45263063ddd29db8f9e34db60daa32684f0072ea2a9426ecebfa5239fb67f29c18cbaa2af6ed4bf4283936823ac1790164fec5457a9cba7c767ca59392d94cab7448f50eb34e9a93a80027471ce59736f099c886dea1ab4cba4d89f5fc7ae2f21ccd27f611eca4626b2d08dc22382e92c1efb2f6afdc8fdc3d2172604f5035c46b8197d3", "5ddb128a54c84322ddf8de291adbd1634bc1ea019ee8518c8190050b800ac9f3ec27f46f4c2a5193f092f8aacf40f9c5");
        TestDigest.testKatHex(new BLAKE384(), "e29d505158dbdd937d9e3d2145658ee6f5992a2fc790f4f608d9cdb44a091d5b94b88e81fac4fdf5c49442f13b911c55886469629551189eaff62488f1a479b7db11a1560e198ddccccf50159093425ff7f1cb8d1d1246d0978764087d6bac257026b090efae8cec5f22b6f21c59ace1ac7386f5b8837ca6a12b6fbf5534dd0560ef05ca78104d3b943ddb220feaec89aa5e692a00f822a2ab9a2fe60350d75e7be16ff2526dc643872502d01f42f188abed0a6e9a6f5fd0d1ce7d5755c9ffa66b0af0b20bd806f08e06156690d81ac811778ca3dac2c249b96002017fce93e507e3b953acf99964b847", "c91f1111473795be3ecdb542b92ba691025de3792e5364c02c60427eece000dfa606c77b3de4523e6073e0ba3b2cd7a3");
        TestDigest.testKatHex(new BLAKE384(), "d85588696f576e65eca0155f395f0cfacd83f36a99111ed5768df2d116d2121e32357ba4f54ede927f189f297d3a97fad4e9a0f5b41d8d89dd7fe20156799c2b7b6bf9c957ba0d6763f5c3bc5129747bbb53652b49290cff1c87e2cdf2c4b95d8aaee09bc8fbfa6883e62d237885810491bfc101f1d8c636e3d0ede838ad05c207a3df4fad76452979eb99f29afaecedd1c63b8d36cf378454a1bb67a741c77ac6b6b3f95f4f02b64dabc15438613ea49750df42ee90101f115aa9abb9ff64324dde9dabbb01054e1bd6b4bcdc7930a44c2300d87ca78c06924d0323ad7887e46c90e8c4d100acd9eed21e", "8bed6e9f76ab819a8ef28a7a65c291d1235a02aec0ba2356478b17130d98c56b8a03166329867894490d7590ccbb1136");
        TestDigest.testKatHex(new BLAKE384(), "3a12f8508b40c32c74492b66323375dcfe49184c78f73179f3314b79e63376b8ac683f5a51f1534bd729b02b04d002f55cbd8e8fc9b5ec1ea6bbe6a0d0e7431518e6ba45d124035f9d3dce0a8bb7bf1430a9f657e0b4ea9f20eb20c786a58181a1e20a96f1628f8728a13bdf7a4b4b32fc8aa7054cc4881ae7fa19afa65c6c3ee1b3ade3192af42054a8a911b8ec1826865d46d93f1e7c5e2b7813c92a506e53886f3d4701bb93d2a681ad109c845904bb861af8af0646b6e399b38b614051d34f6842563a0f37ec00cb3d865fc5d746c4987de2a65071100883a2a9c7a2bfe1e2dd603d9ea24dc7c5fd06be", "c45e57f5656ac45a2c2fcacadb998ec0f080e70b9fb0b9cefe1003ef957286f8d87486cc981c8e662a9deba2e44d96b6");
        TestDigest.testKatHex(new BLAKE384(), "1861edce46fa5ad17e1ff1deae084dec580f97d0a67885dfe834b9dfac1ae076742ce9e267512ca51f6df5a455af0c5fd6abf94acea103a3370c354485a7846fb84f3ac7c2904b5b2fbf227002ce512133bb7e1c4e50057bfd1e44db33c7cdb969a99e284b184f50a14b068a1fc5009d9b298dbe92239572a7627aac02abe8f3e3b473417f36d4d2505d16b7577f4526c9d94a270a2dfe450d06da8f6fa956879a0a55cfe99e742ea555ea477ba3e9b44ccd508c375423611af92e55345dc215779b2d5119eba49c71d49b9fe3f1569fa24e5ca3e332d042422a8b8158d3ec66a80012976f31ffdf305f0c9c5e", "9091b0f214c13840070b2758291f7f56c6c95ef68d94c91690007abe2edffe40f20904e7776d6a25f7ee4eac72bc4304");
        TestDigest.testKatHex(new BLAKE384(), "08d0ffde3a6e4ef65608ea672e4830c12943d7187ccff08f4941cfc13e545f3b9c7ad5eebbe2b01642b486caf855c2c73f58c1e4e3391da8e2d63d96e15fd84953ae5c231911b00ad6050cd7aafdaac9b0f663ae6aab45519d0f5391a541707d479034e73a6ad805ae3598096af078f1393301493d663dd71f83869ca27ba508b7e91e81e128c1716dc3acfe3084b2201e04cf8006617eecf1b640474a5d45cfde9f4d3ef92d6d055b909892194d8a8218db6d8203a84261d200d71473d7488f3427416b6896c137d455f231071cacbc86e0415ab88aec841d96b7b8af41e05bb461a40645bf176601f1e760de5f", "a2ec1fe4f945c14ccc312b2204edfaa0610c112637cd929ff5a3b8fe01cf17f8a6c0277d1181f56328cb098a2e845720");
        TestDigest.testKatHex(new BLAKE384(), "d782abb72a5be3392757be02d3e45be6e2099d6f000d042c8a543f50ed6ebc055a7f133b0dd8e9bc348536edcaae2e12ec18e8837df7a1b3c87ec46d50c241dee820fd586197552dc20beea50f445a07a38f1768a39e2b2ff05dddedf751f1def612d2e4d810daa3a0cc904516f9a43af660315385178a529e51f8aae141808c8bc5d7b60cac26bb984ac1890d0436ef780426c547e94a7b08f01acbfc4a3825eae04f520a9016f2fb8bf5165ed12736fc71e36a49a73614739eaa3ec834069b1b40f1350c2b3ab885c02c640b9f7686ed5f99527e41cfcd796fe4c256c9173186c226169ff257954ebda81c0e5f99", "b760bb81ff00f71515d4fb052479b9d4cc904178274c63b0678ec76f92e7e0669d8ed574561f60994c7076c12f9ef8fe");
        TestDigest.testKatHex(new BLAKE384(), "5fce8109a358570e40983e1184e541833bb9091e280f258cfb144387b05d190e431cb19baa67273ba0c58abe91308e1844dcd0b3678baa42f335f2fa05267a0240b3c718a5942b3b3e3bfa98a55c25a1466e8d7a603722cb2bbf03afa54cd769a99f310735ee5a05dae2c22d397bd95635f58c48a67f90e1b73aafcd3f82117f0166657838691005b18da6f341d6e90fc1cdb352b30fae45d348294e501b63252de14740f2b85ae5299ddec3172de8b6d0ba219a20a23bb5e10ff434d39db3f583305e9f5c039d98569e377b75a70ab837d1df269b8a4b566f40bb91b577455fd3c356c914fa06b9a7ce24c7317a172d", "110fc253f6851f61a2c032bb3719e429a135c7c612c173fe0af23a8b9a9350df994f43d22bc4e335601f32eaad2fd552");
        TestDigest.testKatHex(new BLAKE384(), "6172f1971a6e1e4e6170afbad95d5fec99bf69b24b674bc17dd78011615e502de6f56b86b1a71d3f4348087218ac7b7d09302993be272e4a591968aef18a1262d665610d1070ee91cc8da36e1f841a69a7a682c580e836941d21d909a3afc1f0b963e1ca5ab193e124a1a53df1c587470e5881fb54dae1b0d840f0c8f9d1b04c645ba1041c7d8dbf22030a623aa15638b3d99a2c400ff76f3252079af88d2b37f35ee66c1ad7801a28d3d388ac450b97d5f0f79e4541755356b3b1a5696b023f39ab7ab5f28df4202936bc97393b93bc915cb159ea1bd7a0a414cb4b7a1ac3af68f50d79f0c9c7314e750f7d02faa58bfa", "bcc536a2024c526e03d422095e6c57fa7f06ad2430b3ac5dd921f723cc444b807550dd77d5c0038755438796685fa29f");
        TestDigest.testKatHex(new BLAKE384(), "5668ecd99dfbe215c4118398ac9c9eaf1a1433fab4ccdd3968064752b625ea944731f75d48a27d047d67547f14dd0ffaa55fa5e29f7af0d161d85eafc4f2029b717c918eab9d304543290bdba7158b68020c0ba4e079bc95b5bc0fc044a992b94b4ccd3bd66d0eabb5dbbab904d62e00752c4e3b0091d773bcf4c14b4377da3efff824b1cb2fa01b32d1e46c909e626ed2dae920f4c7dbeb635bc754facbd8d49beba3f23c1c41ccbfcd0ee0c114e69737f5597c0bf1d859f0c767e18002ae8e39c26261ffde2920d3d0baf0e906138696cfe5b7e32b600f45df3aaa39932f3a7df95b60fa8712a2271fcaf3911ce7b511b1", "abd9116f54f2a566b8d3136032e7755280671862d9d1a765f554ffb5bf16c84bbf1f65718c0d4daf42cf1528598022a6");
        TestDigest.testKatHex(new BLAKE384(), "03d625488354df30e3f875a68edfcf340e8366a8e1ab67f9d5c5486a96829dfac0578289082b2a62117e1cf418b43b90e0adc881fc6ae8105c888e9ecd21aea1c9ae1a4038dfd17378fed71d02ae492087d7cdcd98f746855227967cb1ab4714261ee3bead3f4db118329d3ebef4bc48a875c19ba763966da0ebea800e01b2f50b00e9dd4caca6dcb314d00184ef71ea2391d760c950710db4a70f9212ffc54861f9dc752ce18867b8ad0c48df8466ef7231e7ac567f0eb55099e622ebb86cb237520190a61c66ad34f1f4e289cb3282ae3eaac6152ed24d2c92bae5a7658252a53c49b7b02dfe54fdb2e90074b6cf310ac661", "dc42a92b4bd0dad911482155db2ff64f6505c5568c77c862808bedc1116008786572cadd0a899e8f1d69b46f3a66dfb2");
        TestDigest.testKatHex(new BLAKE384(), "2edc282ffb90b97118dd03aaa03b145f363905e3cbd2d50ecd692b37bf000185c651d3e9726c690d3773ec1e48510e42b17742b0b0377e7de6b8f55e00a8a4db4740cee6db0830529dd19617501dc1e9359aa3bcf147e0a76b3ab70c4984c13e339e6806bb35e683af8527093670859f3d8a0fc7d493bcba6bb12b5f65e71e705ca5d6c948d66ed3d730b26db395b3447737c26fad089aa0ad0e306cb28bf0acf106f89af3745f0ec72d534968cca543cd2ca50c94b1456743254e358c1317c07a07bf2b0eca438a709367fafc89a57239028fc5fecfd53b8ef958ef10ee0608b7f5cb9923ad97058ec067700cc746c127a61ee3", "040dc71157d7c235929effa63c9c24d2f42fe16fe3a8f15decf60e42ddcb5036cd8af11ca4af296fa1c9fc83f19395e0");
        TestDigest.testKatHex(new BLAKE384(), "90b28a6aa1fe533915bcb8e81ed6cacdc10962b7ff82474f845eeb86977600cf70b07ba8e3796141ee340e3fce842a38a50afbe90301a3bdcc591f2e7d9de53e495525560b908c892439990a2ca2679c5539ffdf636777ad9c1cdef809cda9e8dcdb451abb9e9c17efa4379abd24b182bd981cafc792640a183b61694301d04c5b3eaad694a6bd4cc06ef5da8fa23b4fa2a64559c5a68397930079d250c51bcf00e2b16a6c49171433b0aadfd80231276560b80458dd77089b7a1bbcc9e7e4b9f881eacd6c92c4318348a13f4914eb27115a1cfc5d16d7fd94954c3532efaca2cab025103b2d02c6fd71da3a77f417d7932685888a", "82ac577552a6d39c9168375c164fedc80d86a2bef29d19b6314d04873f68830dba557bd3b3c5d3e3a511844ecf48aab7");
        TestDigest.testKatHex(new BLAKE384(), "2969447d175490f2aa9bb055014dbef2e6854c95f8d60950bfe8c0be8de254c26b2d31b9e4de9c68c9adf49e4ee9b1c2850967f29f5d08738483b417bb96b2a56f0c8aca632b552059c59aac3f61f7b45c966b75f1d9931ff4e596406378cee91aaa726a3a84c33f37e9cdbe626b5745a0b06064a8a8d56e53aaf102d23dd9df0a3fdf7a638509a6761a33fa42fa8ddbd8e16159c93008b53765019c3f0e9f10b144ce2ac57f5d7297f9c9949e4ff68b70d339f87501ce8550b772f32c6da8ad2ce2100a895d8b08fa1eead7c376b407709703c510b50f87e73e43f8e7348f87c3832a547ef2bbe5799abedcf5e1f372ea809233f006", "2403d430657db7bba560a627d1567a13363fb3a8bb47f0b7353c144f5e55cbdaae35a9b58bb529a3175efdd68ef78b67");
        TestDigest.testKatHex(new BLAKE384(), "721645633a44a2c78b19024eaecf58575ab23c27190833c26875dc0f0d50b46aea9c343d82ea7d5b3e50ec700545c615daeaea64726a0f05607576dcd396d812b03fb6551c641087856d050b10e6a4d5577b82a98afb89cee8594c9dc19e79feff0382fcfd127f1b803a4b9946f4ac9a4378e1e6e041b1389a53e3450cd32d9d2941b0cbabdb50da8ea2513145164c3ab6bcbd251c448d2d4b087ac57a59c2285d564f16da4ed5e607ed979592146ffb0ef3f3db308fb342df5eb5924a48256fc763141a278814c82d6d6348577545870ae3a83c7230ac02a1540fe1798f7ef09e335a865a2ae0949b21e4f748fb8a51f44750e213a8fb", "5a77e7de75d641540d65608ae4e98fe4ce2e5b0e7e6f10d207f830a1c5b70c269d920d5d85cbf28710ed7b93d70aabc7");
        TestDigest.testKatHex(new BLAKE384(), "6b860d39725a14b498bb714574b4d37ca787404768f64c648b1751b353ac92bac2c3a28ea909fdf0423336401a02e63ec24325300d823b6864bb701f9d7c7a1f8ec9d0ae3584aa6dd62ea1997cd831b4babd9a4da50932d4efda745c61e4130890e156aee6113716daf95764222a91187db2effea49d5d0596102d619bd26a616bbfda8335505fbb0d90b4c180d1a2335b91538e1668f9f9642790b4e55f9cab0fe2bdd2935d001ee6419abab5457880d0dbff20ed8758f4c20fe759efb33141cf0e892587fe8187e5fbc57786b7e8b089612c936dfc03d27efbbe7c8673f1606bd51d5ff386f4a7ab68edf59f385eb1291f117bfe717399", "97ad75bbf4afce742a3e0b357327c43cea4932def33dadaf2fd8c0aa1493ce8ad7823d86bbdb759f2c6d5cea960eccfa");
        TestDigest.testKatHex(new BLAKE384(), "6a01830af3889a25183244decb508bd01253d5b508ab490d3124afbf42626b2e70894e9b562b288d0a2450cfacf14a0ddae5c04716e5a0082c33981f6037d23d5e045ee1ef2283fb8b6378a914c5d9441627a722c282ff452e25a7ea608d69cee4393a0725d17963d0342684f255496d8a18c2961145315130549311fc07f0312fb78e6077334f87eaa873bee8aa95698996eb21375eb2b4ef53c14401207deb4568398e5dd9a7cf97e8c9663e23334b46912f8344c19efcf8c2ba6f04325f1a27e062b62a58d0766fc6db4d2c6a1928604b0175d872d16b7908ebc041761187cc785526c2a3873feac3a642bb39f5351550af9770c328af7b", "637d9b3e90599a04cc1a6eb0f6ad93f4c4808a5270bfec56f511e660b4090099b837a75d2ad3a8677a09441358dbe9b8");
        TestDigest.testKatHex(new BLAKE384(), "b3c5e74b69933c2533106c563b4ca20238f2b6e675e8681e34a389894785bdade59652d4a73d80a5c85bd454fd1e9ffdad1c3815f5038e9ef432aac5c3c4fe840cc370cf86580a6011778bbedaf511a51b56d1a2eb68394aa299e26da9ada6a2f39b9faff7fba457689b9c1a577b2a1e505fdf75c7a0a64b1df81b3a356001bf0df4e02a1fc59f651c9d585ec6224bb279c6beba2966e8882d68376081b987468e7aed1ef90ebd090ae825795cdca1b4f09a979c8dfc21a48d8a53cdbb26c4db547fc06efe2f9850edd2685a4661cb4911f165d4b63ef25b87d0a96d3dff6ab0758999aad214d07bd4f133a6734fde445fe474711b69a98f7e2b", "b2c583188c40170089a11c09881b3d796bdf0389ac7a3801ff7e7edfe420b47c9b6cd4b26bcab153f5647e7b9a7e9808");
        TestDigest.testKatHex(new BLAKE384(), "83af34279ccb5430febec07a81950d30f4b66f484826afee7456f0071a51e1bbc55570b5cc7ec6f9309c17bf5befdd7c6ba6e968cf218a2b34bd5cf927ab846e38a40bbd81759e9e33381016a755f699df35d660007b5eadf292feefb735207ebf70b5bd17834f7bfa0e16cb219ad4af524ab1ea37334aa66435e5d397fc0a065c411ebbce32c240b90476d307ce802ec82c1c49bc1bec48c0675ec2a6c6f3ed3e5b741d13437095707c565e10d8a20b8c20468ff9514fcf31b4249cd82dcee58c0a2af538b291a87e3390d737191a07484a5d3f3fb8c8f15ce056e5e5f8febe5e1fb59d6740980aa06ca8a0c20f5712b4cde5d032e92ab89f0ae1", "9e0b2e4b461bb8c707dfe2d91ac958beeb202d1a732acc654d64767c01096c73a8c1f092da927591ca3fcf79f54b63dc");
        TestDigest.testKatHex(new BLAKE384(), "a7ed84749ccc56bb1dfba57119d279d412b8a986886d810f067af349e8749e9ea746a60b03742636c464fc1ee233acc52c1983914692b64309edfdf29f1ab912ec3e8da074d3f1d231511f5756f0b6eead3e89a6a88fe330a10face267bffbfc3e3090c7fd9a850561f363ad75ea881e7244f80ff55802d5ef7a1a4e7b89fcfa80f16df54d1b056ee637e6964b9e0ffd15b6196bdd7db270c56b47251485348e49813b4eb9ed122a01b3ea45ad5e1a929df61d5c0f3e77e1fdc356b63883a60e9cbb9fc3e00c2f32dbd469659883f690c6772e335f617bc33f161d6f6984252ee12e62b6000ac5231e0c9bc65be223d8dfd94c5004a101af9fd6c0fb", "0da702947dc623f60552ce632f69c4b93ee7279094dd838ca26b2bcc342e11f965520239e1bd9a3a2dc06f761f3f9acc");
        TestDigest.testKatHex(new BLAKE384(), "a6fe30dcfcda1a329e82ab50e32b5f50eb25c873c5d2305860a835aecee6264aa36a47429922c4b8b3afd00da16035830edb897831c4e7b00f2c23fc0b15fdc30d85fb70c30c431c638e1a25b51caf1d7e8b050b7f89bfb30f59f0f20fecff3d639abc4255b3868fc45dd81e47eb12ab40f2aac735df5d1dc1ad997cefc4d836b854cee9ac02900036f3867fe0d84afff37bde3308c2206c62c4743375094108877c73b87b2546fe05ea137bedfc06a2796274099a0d554da8f7d7223a48cbf31b7decaa1ebc8b145763e3673168c1b1b715c1cd99ecd3ddb238b06049885ecad9347c2436dff32c771f34a38587a44a82c5d3d137a03caa27e66c8ff6", "d05086b24ba82a06d0371860a4485e9cd435328a99d0c59064999c3fa7704e4a4077944bccd2f9b5b6412ea2fc4af8c5");
        TestDigest.testKatHex(new BLAKE384(), "83167ff53704c3aa19e9fb3303539759c46dd4091a52ddae9ad86408b69335989e61414bc20ab4d01220e35241eff5c9522b079fba597674c8d716fe441e566110b6211531ceccf8fd06bc8e511d00785e57788ed9a1c5c73524f01830d2e1148c92d0edc97113e3b7b5cd3049627abdb8b39dd4d6890e0ee91993f92b03354a88f52251c546e64434d9c3d74544f23fb93e5a2d2f1fb15545b4e1367c97335b0291944c8b730ad3d4789273fa44fb98d78a36c3c3764abeeac7c569c1e43a352e5b770c3504f87090dee075a1c4c85c0c39cf421bdcc615f9eff6cb4fe6468004aece5f30e1ecc6db22ad9939bb2b0ccc96521dfbf4ae008b5b46bc006e", "bc3259abfbacd8bee4a9655d838af0ab1d66a40479146475e38f53d1126371493c23eab0a891872d0953d9297a367197");
        TestDigest.testKatHex(new BLAKE384(), "3a3a819c48efde2ad914fbf00e18ab6bc4f14513ab27d0c178a188b61431e7f5623cb66b23346775d386b50e982c493adbbfc54b9a3cd383382336a1a0b2150a15358f336d03ae18f666c7573d55c4fd181c29e6ccfde63ea35f0adf5885cfc0a3d84a2b2e4dd24496db789e663170cef74798aa1bbcd4574ea0bba40489d764b2f83aadc66b148b4a0cd95246c127d5871c4f11418690a5ddf01246a0c80a43c70088b6183639dcfda4125bd113a8f49ee23ed306faac576c3fb0c1e256671d817fc2534a52f5b439f72e424de376f4c565cca82307dd9ef76da5b7c4eb7e085172e328807c02d011ffbf33785378d79dc266f6a5be6bb0e4a92eceebaeb1", "9af9d76f8b730c82afb4ce184adb51ab4e39960f7c80f61a794239629f2421b10fa7e04036d567673e85db4ef5c65ee6");
        TestDigest.reportSuccess("BLAKE-384");
    }

    private static void testBLAKE512() {
        TestDigest.testKatHex(new BLAKE512(), "", "a8cfbbd73726062df0c6864dda65defe58ef0cc52a5625090fa17601e1eecd1b628e94f396ae402a00acc9eab77b4d4c2e852aaaa25a636d80af3fc7913ef5b8");
        TestDigest.testKatHex(new BLAKE512(), "cc", "4f0ef594f20172d23504873f596984c64c1583c7b2abb8d8786aa2aeeae1c46c744b61893d661b0733b76d1fe19257dd68e0ef05422ca25d058dfe6c33d68709");
        TestDigest.testKatHex(new BLAKE512(), "41fb", "20afd72afbb66a5a0efd8b4a627cc2c82a5e4b6c63b0c9a78735c188d248c7588fb4ee566b3b6fdcc235a498f7263feb7ab1411582a7055e3ce7a8c976e61fcc");
        TestDigest.testKatHex(new BLAKE512(), "1f877c", "b1211367fd8a886674f74d92716e7585f9b6e933edc5ee7f974facdccc481cfa42a0532375b94f2c0dd73d6189a815c2bafb5686d784be81fbb447b0f291272b");
        TestDigest.testKatHex(new BLAKE512(), "c1ecfdfc", "ccbcdbc1a30ebbcc4fc015fdb1caba6c0ad6719301b4bbad4b0efab1141174a15e2e8b8b8e5671c1864a0f75ecb20f76dac45159e67786d07d79a29b1827e5a4");
        TestDigest.testKatHex(new BLAKE512(), "21f134ac57", "ec6eaabc2a128c38dfcddf9aaad5bb6fba397aac06a4b584b2dbdeb0cd7fdb1fd248ef93c0686b73818b2b78c923c70eba63c096f33d842ada959f7674e4730c");
        TestDigest.testKatHex(new BLAKE512(), "c6f50bb74e29", "b6e8a7380df1f007d7c271e7255bbca7714f25029ac1fd6fe92ef74cbcd9e99c112f8ae1a45ccb566ce19d9678a122c612beff5f8eeeee3f3f402fd2781182d4");
        TestDigest.testKatHex(new BLAKE512(), "119713cc83eeef", "6e66bae94df2233958b1be831afa7678e247104cafdf41c15aeada5ac18715f1d4512114f299527a8434ed5daa99b12ba7bb9465f6799cb0bff9a31fd34c22d9");
        TestDigest.testKatHex(new BLAKE512(), "4a4f202484512526", "e2069c9d8a33314f3bc22e519c80f08647ac238ece2d709e3904ce77097c7ec0f0a398f60c5667b26a76df8023e39c84c979f424539cb96b736440b854bcaf55");
        TestDigest.testKatHex(new BLAKE512(), "1f66ab4185ed9b6375", "dc8b900ff8f8c9a748a14be429fafe7bfe9e5f829d8c663d02893148c8dcac7a89e8c7d46570b32c3933985c6f3d048ff58431787891b4804a1050cadb169e6d");
        TestDigest.testKatHex(new BLAKE512(), "eed7422227613b6f53c9", "c5633a1b9e45cef38647603cbd9710e1aca4f2fb84f8d56a0d729fd6d480ef05f8a46f1dc0e771ec114aea2f9ad534b70bf03046118a5f2fbdd371442d9d8895");
        TestDigest.testKatHex(new BLAKE512(), "eaeed5cdffd89dece455f1", "4e3edbcb1598fe5cdd444dcd6fa1390982e21107d2ab104d3fc1ed35bb08ac32b66b86b23b55429cd246179b99ca90be1929b049a96e2c3434806114c33309e2");
        TestDigest.testKatHex(new BLAKE512(), "5be43c90f22902e4fe8ed2d3", "123322d5d95f0794446d28288af53e594ee046a48b7456bd37dacf921c83889b8e9d92c4f1a706fa8713146e60f1997dc85755b8900b23d08a46e081db0b50d7");
        TestDigest.testKatHex(new BLAKE512(), "a746273228122f381c3b46e4f1", "3a3ffd51985380c91fdc503ab72cce0a711bff3d945640b61d40be720a79af3ada2299788213cd62ee33e9d3355d68e9d7eed0c0c56eebfbc4c5a7c0ca29fe03");
        TestDigest.testKatHex(new BLAKE512(), "3c5871cd619c69a63b540eb5a625", "2f88021f36ed80f95be05c0aa39cd0d77b0a10a285086fd4882debbadc7cbf4ee402469f7ac71a3cd2464b5756838897c3807fdf8fe83fcbf6ff320a0351b71a");
        TestDigest.testKatHex(new BLAKE512(), "fa22874bcc068879e8ef11a69f0722", "979cc4edf67a07d35a376bc1b791a0266b7aab97fa733544cdef95b4968b194519594a5f24008fff42de132bfca2168896c44a0fcec2167ecac1fa907c8c5470");
        TestDigest.testKatHex(new BLAKE512(), "52a608ab21ccdd8a4457a57ede782176", "ff2f4d280127ac37d54528333f9f268ddb70dd044a558d8895173d1d9d253489947e4ed16a52e57298b2126d7761d31e060ab5eb28ba04e05f032abdcf344f0a");
        TestDigest.testKatHex(new BLAKE512(), "82e192e4043ddcd12ecf52969d0f807eed", "db47fe031f185db94489e02c69b066ba25187c1009aea0614f2292838062685d38a5dcb13bc0b0cc5451727f5ad4b47524921b8ce06b03236681e200aeaf258c");
        TestDigest.testKatHex(new BLAKE512(), "75683dcb556140c522543bb6e9098b21a21e", "434949fc2dcf01de14ae1c05cc2ca201da5c9008aa222f77a4e5fa8f81e5c3d847ac2da8ed9d63a2552eacd7ed90586ad9da38cad0b1dcc542b21e76d5b85f2b");
        TestDigest.testKatHex(new BLAKE512(), "06e4efe45035e61faaf4287b4d8d1f12ca97e5", "8dd8bacf14837b8d343ff5678f05642d7566b8d874b02a958b469a9bbe949386e1f999c004b397bc987b2c6a63988d170d4a6317d49640201f712fe943d03ff3");
        TestDigest.testKatHex(new BLAKE512(), "e26193989d06568fe688e75540aea06747d9f851", "3107d40d9b83837aea236649acea28cef05010f529d8974282f1028726860f6fca837082382e80ca541b21ab685ed60d8809b5bd826b42aca0227be03f689f7a");
        TestDigest.testKatHex(new BLAKE512(), "d8dc8fdefbdce9d44e4cbafe78447bae3b5436102a", "b2802809b757a950ccc31faf56af6f206ff40f63382856566905dd420d5474c1ce069dd9729f8c31744180a07f9d90539f696058f5f5d3b654382c745afbdb05");
        TestDigest.testKatHex(new BLAKE512(), "57085fd7e14216ab102d8317b0cb338a786d5fc32d8f", "023972123b0e4c8dea7eb126144f84c145f2db46ad691e95e56fcaccb11b4129227014500ae1f9eb37e518c67d2aa8605ddc6ba22020496c422fda29e8503668");
        TestDigest.testKatHex(new BLAKE512(), "a05404df5dbb57697e2c16fa29defac8ab3560d6126fa0", "870d82edce6f1a83143df266a556443f920b69d7ccfd58403d912cd10af61901cdb6f4877d317638e8f0592a2d35b9b5e9183aa1fdf36c9d2dda9de086e8ec43");
        TestDigest.testKatHex(new BLAKE512(), "aecbb02759f7433d6fcb06963c74061cd83b5b3ffa6f13c6", "a1d715fe1edaf888e25bf9785e2401ae6b5d45a637474bcdf940bb37f3502c5e4309a44549385e601a8bc99f881ae4ba411b0464849f2aa2d03bc237ddbafeff");
        TestDigest.testKatHex(new BLAKE512(), "aafdc9243d3d4a096558a360cc27c8d862f0be73db5e88aa55", "3319cdd45556d834bd0be8d5e905365e1f9cd31ef0383402bc5251cbd34e09f064f6ccdbcdfda3973a62766d0ab4866660064b80cef413f2d0d490d99f62d052");
        TestDigest.testKatHex(new BLAKE512(), "7bc84867f6f9e9fdc3e1046cae3a52c77ed485860ee260e30b15", "cd6d552bdcb77d68454b2f2f1452ffef6266f07b4534d06ce2748cddbe4d7045968965f4a574c786f8006464f154d89478a3cd675cb11449e82890dcf314a6cc");
        TestDigest.testKatHex(new BLAKE512(), "fac523575a99ec48279a7a459e98ff901918a475034327efb55843", "dde54dd4baf9aa946c2ebee0afa98819211acd034709d2bc8b2260df43751f18f8c41c8f63366858949028be41a2d68cdcf4a777c27edd283007dd80161cbd88");
        TestDigest.testKatHex(new BLAKE512(), "0f8b2d8fcfd9d68cffc17ccfb117709b53d26462a3f346fb7c79b85e", "c01f2f4b337cfd746411fe69af676f909025dbb56f995ef6a735777cd7ea7d93c89086385f9136acb8e5a232af2eb107d7ee1e5a47cb90dbfd1d3000cf857992");
        TestDigest.testKatHex(new BLAKE512(), "a963c3e895ff5a0be4824400518d81412f875fa50521e26e85eac90c04", "66dc93d34e6494fdfea43100037a88bfa8191d72419ba01c8e2eefa60c584eb83bce8b20ac9888ef19cc2b3e2f6734f53752cd8ee04610fe36fdaaf0b73b6c58");
        TestDigest.testKatHex(new BLAKE512(), "03a18688b10cc0edf83adf0a84808a9718383c4070c6c4f295098699ac2c", "c668b4949f9274755fe2e5f74b0ab4c2498ea7e50ed28de46d500916fac4f52b15f8a1620c9ea1de98cc6e6ea145137f54774d3ef5176b9bc1d854585bd7367b");
        TestDigest.testKatHex(new BLAKE512(), "84fb51b517df6c5accb5d022f8f28da09b10232d42320ffc32dbecc3835b29", "03bfeee81a1da5a8ab71b6391b3f41ade891934877330f943ae487c960fb426c2f5d8cd2bfb48019bca84e9fb9199677cbd9fcff896472d15bf6fa3f7cdc163e");
        TestDigest.testKatHex(new BLAKE512(), "9f2fcc7c90de090d6b87cd7e9718c1ea6cb21118fc2d5de9f97e5db6ac1e9c10", "b9330e5858b8c5ab4465ac8f1393a4eaf616d668581a8958c5fe8caebe6d37bb7862153b34ffa4059a6f2496b925cef8a7d556b49b46757bf061a77e5712faa8");
        TestDigest.testKatHex(new BLAKE512(), "de8f1b3faa4b7040ed4563c3b8e598253178e87e4d0df75e4ff2f2dedd5a0be046", "95143b7e851c8f95fd55f73ef0306f256d434e86d2acdce3c3f48ddc2f1b96c9dc1e84c60703737d11bf14283f84e751dddf2c99c69a74b82b1735dfc99e1482");
        TestDigest.testKatHex(new BLAKE512(), "62f154ec394d0bc757d045c798c8b87a00e0655d0481a7d2d9fb58d93aedc676b5a0", "b6e00a6118101f5f782bd958f7df189956c01dd36b586a16667cebd5d04397417d605e7f4980553129b8e25f4035e3c919a76b8288bf5bdfdeff9ace77ecfb70");
        TestDigest.testKatHex(new BLAKE512(), "b2dcfe9ff19e2b23ce7da2a4207d3e5ec7c6112a8a22aec9675a886378e14e5bfbad4e", "eea743043c1daa6132359c57e16580084a79c3357aa622eabd29b129818c6633e3f5356eb0eacf4f19d158edeada45c586141f798eee692c8e38305e8de1f275");
        TestDigest.testKatHex(new BLAKE512(), "47f5697ac8c31409c0868827347a613a3562041c633cf1f1f86865a576e02835ed2c2492", "7ec5e1adebe2e3be5b7cf5ac81d04a2362b8f2aaff913f143d209040f2083a9d064f7eeaf4c12a54fd26f3b24927788d874bcd1d6db4ae9caaf129fcb9239364");
        TestDigest.testKatHex(new BLAKE512(), "512a6d292e67ecb2fe486bfe92660953a75484ff4c4f2eca2b0af0edcdd4339c6b2ee4e542", "7695c6662cadea5725a03dd2b0d97dff3665cd7e1a627214bbc919e338df2795b711f7173d1d30d0555691a9793d2c132d7cb949265977a8dc7df0fe087d2b07");
        TestDigest.testKatHex(new BLAKE512(), "973cf2b4dcf0bfa872b41194cb05bb4e16760a1840d8343301802576197ec19e2a1493d8f4fb", "df59dda7164b1e193b37e887c8169dfae473ac8dee543e7902e902e253c717cad750a145b8bf9950a009db4e834d060f4e08643b82be5b945aeb529f5c52553c");
        TestDigest.testKatHex(new BLAKE512(), "80beebcd2e3f8a9451d4499961c9731ae667cdc24ea020ce3b9aa4bbc0a7f79e30a934467da4b0", "e85247e33827f464643f2fe8ed901b0e0664950bdb892a2b6105d9315405f27c9868401300dcbc361d8b2704bb885ab27e5e881efcb082664802da97a7769a85");
        TestDigest.testKatHex(new BLAKE512(), "7abaa12ec2a7347674e444140ae0fb659d08e1c66decd8d6eae925fa451d65f3c0308e29446b8ed3", "3295ac4d0105a7cb0993b198be1ddd12f60ef40d32aa0638475e59b82f097d14151f5ec1fbba5a3e1403e37266b0f27e4d6305feea3d063c819800b7aac5a2b2");
        TestDigest.testKatHex(new BLAKE512(), "c88dee9927679b8af422abcbacf283b904ff31e1cac58c7819809f65d5807d46723b20f67ba610c2b7", "23f1d701490e1e737203f8562b230b5d0ea65ed6aa7ae79e1db34f54a2466f86307b6aa8c9e45e38e5cbd5494e87b74a2d83cd80fdb076f4286437535f330d69");
        TestDigest.testKatHex(new BLAKE512(), "01e43fe350fcec450ec9b102053e6b5d56e09896e0ddd9074fe138e6038210270c834ce6eadc2bb86bf6", "ee5c884e3e3298239122db76e541378bbac0e85416164537cb103ab5610cdc8a09426982d3c4fb4c95766e866ce6a964a33cc8e3a3aa62a01307fc6382606181");
        TestDigest.testKatHex(new BLAKE512(), "337023370a48b62ee43546f17c4ef2bf8d7ecd1d49f90bab604b839c2e6e5bd21540d29ba27ab8e309a4b7", "721a5c4d8812398291161b85eb63114edc67151ae4a9f0b1ff510c2c1b9504a8c69210f8913282e42718cf0123451fab201a3843b1897e60daa6e8d3ea647b57");
        TestDigest.testKatHex(new BLAKE512(), "6892540f964c8c74bd2db02c0ad884510cb38afd4438af31fc912756f3efec6b32b58ebc38fc2a6b913596a8", "0021f6b894f2e60d6966ed1dfb55eb5666b5038b4fa9ebeb8cc25be19f00caf100e8bd3dff3cd75a6aac4d198885b7d7f1abe25e8741d475dee4e430bd454137");
        TestDigest.testKatHex(new BLAKE512(), "f5961dfd2b1ffffda4ffbf30560c165bfedab8ce0be525845deb8dc61004b7db38467205f5dcfb34a2acfe96c0", "ccc320256088cacaf58359bf9ec3c25b404bdd56b9d86ffd4aa08413f0f324d74fa050dcc1d862c6273a55a85f5c02d6941b305666a803cd17a4b5b75325dc7b");
        TestDigest.testKatHex(new BLAKE512(), "ca061a2eb6ceed8881ce2057172d869d73a1951e63d57261384b80ceb5451e77b06cf0f5a0ea15ca907ee1c27eba", "75adfb8b4c9e7a951bd6da1785e120ad9659e248046fed3ef9ba95fd67539479cd084cf126a974a02354e6e95f298ae83bcd61e0d95fe99d7e0b15c46a2d1f96");
        TestDigest.testKatHex(new BLAKE512(), "1743a77251d69242750c4f1140532cd3c33f9b5ccdf7514e8584d4a5f9fbd730bcf84d0d4726364b9bf95ab251d9bb", "0b39015415080d54570b9f7087e9cea3d99b035c06252040752141561038ee2426388ede2c7c98ddeca1747fc38c358dced5ae4cb3f35a213e297b0ac6d94545");
        TestDigest.testKatHex(new BLAKE512(), "d8faba1f5194c4db5f176fabfff856924ef627a37cd08cf55608bba8f1e324d7c7f157298eabc4dce7d89ce5162499f9", "5e77fed99fed053f5dfa6f4b2458b2a5d75f3d73f8a1b436a3127809575c01438ecc92256946fdd79969c33d1e4e4578860c84837c8313c371ad3ef43f6a54e3");
        TestDigest.testKatHex(new BLAKE512(), "be9684be70340860373c9c482ba517e899fc81baaa12e5c6d7727975d1d41ba8bef788cdb5cf4606c9c1c7f61aed59f97d", "d2457d97f88b8ca48fd5899d790bb102f0debdcdffedf9d546a330f683204a67d1f2eaab4934738bef700b0dc8647ee63e3aea55d7c6c244de76c232e75fe87b");
        TestDigest.testKatHex(new BLAKE512(), "7e15d2b9ea74ca60f66c8dfab377d9198b7b16deb6a1ba0ea3c7ee2042f89d3786e779cf053c77785aa9e692f821f14a7f51", "2f7918b8a9ca5a0262e43de95f29dcab5cc8c0d483ebc5a717a6c5d2bcef064c47b232f1abd43a7802bf980eb15dd04ac5b656ce76a2faa4982450913509ec15");
        TestDigest.testKatHex(new BLAKE512(), "9a219be43713bd578015e9fda66c0f2d83cac563b776ab9f38f3e4f7ef229cb443304fba401efb2bdbd7ece939102298651c86", "68d76315aebb41951d9e2498d118896c0bcca500033754baba113c602f82607ae224813a7db0035fc206cc9d5d7600269384ae6c66c88b99b22daaa8c7b9d3af");
        TestDigest.testKatHex(new BLAKE512(), "c8f2b693bd0d75ef99caebdc22adf4088a95a3542f637203e283bbc3268780e787d68d28cc3897452f6a22aa8573ccebf245972a", "47a5dc88882a1f7ca55c410d691cd058b75fce334bada777ec94739298ddcaf0e8e9cca611cbc78e838694ed3932d71738bf38da3245eb880902b78d1c0a8caf");
        TestDigest.testKatHex(new BLAKE512(), "ec0f99711016c6a2a07ad80d16427506ce6f441059fd269442baaa28c6ca037b22eeac49d5d894c0bf66219f2c08e9d0e8ab21de52", "b12317778cecc403aec339bbb8977d4ecac1e477f6c4db41098c7883f759d5c4954f590e531fc98c00f0131c427998aff481db82d4a27e87fd777c8129a33657");
        TestDigest.testKatHex(new BLAKE512(), "0dc45181337ca32a8222fe7a3bf42fc9f89744259cff653504d6051fe84b1a7ffd20cb47d4696ce212a686bb9be9a8ab1c697b6d6a33", "95932e3f12283fff258cb03d6279bf6937ffc3bf2d4f3baf90f858035863e910db1f1051294817477f7ac6d66eeea0cd141e8c9e822bfb0073afa6bbb41ee907");
        TestDigest.testKatHex(new BLAKE512(), "de286ba4206e8b005714f80fb1cdfaebde91d29f84603e4a3ebc04686f99a46c9e880b96c574825582e8812a26e5a857ffc6579f63742f", "939b3b16698f14b4de2c5e1894d8a75fa641188e5887e74511a128c005b135f04d00db30b82efd8e63cdc02eedca26d1c15f1cb50baab6db517521e154a0e11c");
        TestDigest.testKatHex(new BLAKE512(), "eebcc18057252cbf3f9c070f1a73213356d5d4bc19ac2a411ec8cdeee7a571e2e20eaf61fd0c33a0ffeb297ddb77a97f0a415347db66bcaf", "f6396e00bbdb23dbdc6ccb900a9ccc7ee6a15148ae291879d1665fbf10f63c87204ecaa1541a5ec8cc02023e3b8c09a9261411f80c26ef658fab3e032e16db86");
        TestDigest.testKatHex(new BLAKE512(), "416b5cdc9fe951bd361bd7abfc120a5054758eba88fdd68fd84e39d3b09ac25497d36b43cbe7b85a6a3cebda8db4e5549c3ee51bb6fcb6ac1e", "ed3dd7f65d7d55e9af70ae694179be48dee50669fdfe09fef55950c7d1f14d0b4dc8791735939181c0ef7d17f4976f9a1d2396f22b9a1d0f40de1678adab4e32");
        TestDigest.testKatHex(new BLAKE512(), "5c5faf66f32e0f8311c32e8da8284a4ed60891a5a7e50fb2956b3cbaa79fc66ca376460e100415401fc2b8518c64502f187ea14bfc9503759705", "1c716598b1f4deed02617d5afaed4309ac06dcca6f6a586d6036892e188618e3a0c31882dc90545d33d10a64289d362dd36986d694fff69387f4bdc2bfe57217");
        TestDigest.testKatHex(new BLAKE512(), "7167e1e02be1a7ca69d788666f823ae4eef39271f3c26a5cf7cee05bca83161066dc2e217b330df821103799df6d74810eed363adc4ab99f36046a", "436d5fb1504a58aeba281fe6214e7cad9448a54edc5371c056c47cc220a1b9510cecb6709f180b5382487f87be8fb745b449a7187391589e26f85a7805f33129");
        TestDigest.testKatHex(new BLAKE512(), "2fda311dbba27321c5329510fae6948f03210b76d43e7448d1689a063877b6d14c4f6d0eaa96c150051371f7dd8a4119f7da5c483cc3e6723c01fb7d", "c90dd10ff70f5a77e34917ef0ad03f2ec156b46b2fe851ad567ea478f8b0c75cc911dd5ba3552fdf150ca8b970f634c513d952786d262b16a8451390a4375e7f");
        TestDigest.testKatHex(new BLAKE512(), "95d1474a5aab5d2422aca6e481187833a6212bd2d0f91451a67dd786dfc91dfed51b35f47e1deb8a8ab4b9cb67b70179cc26f553ae7b569969ce151b8d", "f74bee0be34d658d5915d345731fb3d4ce234331eb02a807cff5b8faaca8633bb1f44845f68e24bd29e22bb7d8ee5fb453d04f0a9ef5ba9e60811c44c99a4a1b");
        TestDigest.testKatHex(new BLAKE512(), "c71bd7941f41df044a2927a8ff55b4b467c33d089f0988aa253d294addbdb32530c0d4208b10d9959823f0c0f0734684006df79f7099870f6bf53211a88d", "130a6b23b4af7d090d5a3a5a43b0e234271fbb3048e4832b487f600f23db0b9c2572deda814e56c457dee10cfabbdcda0e85ce07795347948028bec57d9f4f30");
        TestDigest.testKatHex(new BLAKE512(), "f57c64006d9ea761892e145c99df1b24640883da79d9ed5262859dcda8c3c32e05b03d984f1ab4a230242ab6b78d368dc5aaa1e6d3498d53371e84b0c1d4ba", "7baf21fd1b9c1aa50cafc611fe640f33004aacb5dfa1baff3ddeb8360ce574ff0ca8bbabd694af4d11cac1e04bda44b729fa007e57c2d63841c95e0ef6daa4d0");
        TestDigest.testKatHex(new BLAKE512(), "e926ae8b0af6e53176dbffcc2a6b88c6bd765f939d3d178a9bde9ef3aa131c61e31c1e42cdfaf4b4dcde579a37e150efbef5555b4c1cb40439d835a724e2fae7", "ec1270cb5c96df2106a9c4f694ad6dc8d83a8ae1c375b613a447b95e2a09e76d1a32c73cae58ef8c6822ad7ba50aabba00f01de11ac3606fabb67fadbb5be530");
        TestDigest.testKatHex(new BLAKE512(), "16e8b3d8f988e9bb04de9c96f2627811c973ce4a5296b4772ca3eefeb80a652bdf21f50df79f32db23f9f73d393b2d57d9a0297f7a2f2e79cfda39fa393df1ac00", "ea6bd3422c8e5108ee70085e5626ded927efa7439f430e0c5d0b2bf78863d5f3c60591c24f8dde3cc13100cfdf31d96a4b24f1a45e49138aa8b2e4bd50446ab7");
        TestDigest.testKatHex(new BLAKE512(), "fc424eeb27c18a11c01f39c555d8b78a805b88dba1dc2a42ed5e2c0ec737ff68b2456d80eb85e11714fa3f8eabfb906d3c17964cb4f5e76b29c1765db03d91be37fc", "1317f755155658dbd426c1635c2529a167246d86cc6506e8d6142ffe736284a8d27f93ab2bcb27f61a107bb684a9e891137607a3be0ed95823f911bb457c6a70");
        TestDigest.testKatHex(new BLAKE512(), "abe3472b54e72734bdba7d9158736464251c4f21b33fbbc92d7fac9a35c4e3322ff01d2380cbaa4ef8fb07d21a2128b7b9f5b6d9f34e13f39c7ffc2e72e47888599ba5", "bd84b45984dfd71a565fec6f6a90bbc51492491746e312f6f442c15183735269b3afafc2538ee1d475016df7670fabae9baf593af130c3a20ac5d0f7697bc642");
        TestDigest.testKatHex(new BLAKE512(), "36f9f0a65f2ca498d739b944d6eff3da5ebba57e7d9c41598a2b0e4380f3cf4b479ec2348d015ffe6256273511154afcf3b4b4bf09d6c4744fdd0f62d75079d440706b05", "e4f7828628b6440e638972ffa247c63b277cdfc1dcee82641c582fd339369776bd926b72966a7fb3e498489a38298130efce37d87929f225931bdec68605f8f3");
        TestDigest.testKatHex(new BLAKE512(), "abc87763cae1ca98bd8c5b82caba54ac83286f87e9610128ae4de68ac95df5e329c360717bd349f26b872528492ca7c94c2c1e1ef56b74dbb65c2ac351981fdb31d06c77a4", "a1002c74578776c2daea440992b013515d6fef54f14d3cc5358753dedea5bb1bf3dd6f88937ca02d2ee05c45593d9a2dc39e347bbbae5394247887ca62380841");
        TestDigest.testKatHex(new BLAKE512(), "94f7ca8e1a54234c6d53cc734bb3d3150c8ba8c5f880eab8d25fed13793a9701ebe320509286fd8e422e931d99c98da4df7e70ae447bab8cffd92382d8a77760a259fc4fbd72", "710f65da4ffb867d12d80f4742e09f83db740ecbbdf7e3308e7bbc363bc009de9134e5c087e844f4b078b92e4716204722242238f6be25dad4414e5869821e11");
        TestDigest.testKatHex(new BLAKE512(), "13bd2811f6ed2b6f04ff3895aceed7bef8dcd45eb121791bc194a0f806206bffc3b9281c2b308b1a729ce008119dd3066e9378acdcc50a98a82e20738800b6cddbe5fe9694ad6d", "7c390c36a8c5cafd6d9b36d00194dc5a515b0cf484a12b8d29e5951da4a10ad015a092f2f33b6392b04a2bfdb53e6ce05bdabcf8a33a4fdad7db47d15db1fdb2");
        TestDigest.testKatHex(new BLAKE512(), "1eed9cba179a009ec2ec5508773dd305477ca117e6d569e66b5f64c6bc64801ce25a8424ce4a26d575b8a6fb10ead3fd1992edddeec2ebe7150dc98f63adc3237ef57b91397aa8a7", "16815f22f7974211b97f789aabf46fea4027f3579a5085471bd286e5040fb1e48bf999d3341c60b2a871a0c64aeb975f9c1c8b7e7550be498d053e89675c3b27");
        TestDigest.testKatHex(new BLAKE512(), "ba5b67b5ec3a3ffae2c19dd8176a2ef75c0cd903725d45c9cb7009a900c0b0ca7a2967a95ae68269a6dbf8466c7b6844a1d608ac661f7eff00538e323db5f2c644b78b2d48de1a08aa", "277349189e99f43b1e0316cecd81c4c4eb41d7e6c6832f78cdb556330740a0747504017e104550a4168d94a37251534f82c2f8de2b40980fdc6ac9f3a2572395");
        TestDigest.testKatHex(new BLAKE512(), "0efa26ac5673167dcacab860932ed612f65ff49b80fa9ae65465e5542cb62075df1c5ae54fba4db807be25b070033efa223bdd5b1d3c94c6e1909c02b620d4b1b3a6c9fed24d70749604", "ad2aa587c604e03dc8b63128750773c7bb6b5fa3339dc4c46685e194fc00bf874afacc815e1da3ff293d737e2dd362a20f6a502b2e5b6c30e1d09c2c65036136");
        TestDigest.testKatHex(new BLAKE512(), "bbfd933d1fd7bf594ac7f435277dc17d8d5a5b8e4d13d96d2f64e771abbd51a5a8aea741beccbddb177bcea05243ebd003cfdeae877cca4da94605b67691919d8b033f77d384ca01593c1b", "f409347b780ac724a3764aeca953811639019962b921207681ce8acf25cbcc7e2fdb2c6f597f0942739406a412a7734b962583737d1e2c121b39258906fbba01");
        TestDigest.testKatHex(new BLAKE512(), "90078999fd3c35b8afbf4066cbde335891365f0fc75c1286cdd88fa51fab94f9b8def7c9ac582a5dbcd95817afb7d1b48f63704e19c2baa4df347f48d4a6d603013c23f1e9611d595ebac37c", "1ad787f55ba95a2dda24366299a6fa938d2bf59a0e1d3a08f6a6d5f7727716e2a93681d004f9868827feaa998333918219235e59ada192199cbf6d8deac3e2ac");
        TestDigest.testKatHex(new BLAKE512(), "64105eca863515c20e7cfbaa0a0b8809046164f374d691cdbd6508aaabc1819f9ac84b52bafc1b0fe7cddbc554b608c01c8904c669d8db316a0953a4c68ece324ec5a49ffdb59a1bd6a292aa0e", "3222fea2380fbf1666972b218732f8104cf816df2f1ca430cebfe21019037b443cf3738bef98921448fecd336db3fefdf07277f83690c19b4d8e68d77faae4b2");
        TestDigest.testKatHex(new BLAKE512(), "d4654be288b9f3b711c2d02015978a8cc57471d5680a092aa534f7372c71ceaab725a383c4fcf4d8deaa57fca3ce056f312961eccf9b86f14981ba5bed6ab5b4498e1f6c82c6cae6fc14845b3c8a", "af76537d3aa53ef9c93f8227e84345f251696051ac591e7cb66ff21cff5019fbf13aad7947736f01c922c126a73e395651d0c92e625cf46241951e09165fc973");
        TestDigest.testKatHex(new BLAKE512(), "12d9394888305ac96e65f2bf0e1b18c29c90fe9d714dd59f651f52b88b3008c588435548066ea2fc4c101118c91f32556224a540de6efddbca296ef1fb00341f5b01fecfc146bdb251b3bdad556cd2", "d564270c28062327139f1f48fa8daaad0420046b8136170c68fa60cc3d01ec8e9a72a3f3882a8e6a8a54b2d5b08c8ec2688bf6bd589a6cee9d2aad61f1d8a8e7");
        TestDigest.testKatHex(new BLAKE512(), "871a0d7a5f36c3da1dfce57acd8ab8487c274fad336bc137ebd6ff4658b547c1dcfab65f037aa58f35ef16aff4abe77ba61f65826f7be681b5b6d5a1ea8085e2ae9cd5cf0991878a311b549a6d6af230", "9262d860468ee8d565544a255b800111c55a95ae681bafc694d66bc244921bb8d1b280e845e5f87ebe9e06da246361a09742563c0978b97d0ec22799e66729f6");
        TestDigest.testKatHex(new BLAKE512(), "e90b4ffef4d457bc7711ff4aa72231ca25af6b2e206f8bf859d8758b89a7cd36105db2538d06da83bad5f663ba11a5f6f61f236fd5f8d53c5e89f183a3cec615b50c7c681e773d109ff7491b5cc22296c5", "279e088d5a5ab0a18d2fd540e76f9504c27e2cbd7917cbd2edc8a5e37ea956e3adbcc5cb543edb37b8579aa6a2f68d769e3a7958a9ae66fbe6354d95f0d5c141");
        TestDigest.testKatHex(new BLAKE512(), "e728de62d75856500c4c77a428612cd804f30c3f10d36fb219c5ca0aa30726ab190e5f3f279e0733d77e7267c17be27d21650a9a4d1e32f649627638dbada9702c7ca303269ed14014b2f3cf8b894eac8554", "fa97f977171c29a9501b4fdcaebe22d296f457e92808a985293eb708bff0c6bbc211d3a1ffe321df32c806db3c7f8e58c00cc1ad658bf6c65b2066b928152762");
        TestDigest.testKatHex(new BLAKE512(), "6348f229e7b1df3b770c77544e5166e081850fa1c6c88169db74c76e42eb983facb276ad6a0d1fa7b50d3e3b6fcd799ec97470920a7abed47d288ff883e24ca21c7f8016b93bb9b9e078bdb9703d2b781b616e", "ad25850a967c6889ac6e62adf5b8fe6a2ba391817fc7221c3b77a15a5e4f04c12f956179f3186710ab1df6dd808351dc7c55affa3f5068548f2117335dc7c82f");
        TestDigest.testKatHex(new BLAKE512(), "4b127fde5de733a1680c2790363627e63ac8a3f1b4707d982caea258655d9bf18f89afe54127482ba01e08845594b671306a025c9a5c5b6f93b0a39522dc877437be5c2436cbf300ce7ab6747934fcfc30aeaaf6", "8c25c98b780b468eddd84181d9b1f083844475a9da8260817d25318202b9f25176a934fd201835d6b3f6f8d3fb7d45dbbeff6c915403ed13fcfbe0add0018126");
        TestDigest.testKatHex(new BLAKE512(), "08461f006cff4cc64b752c957287e5a0faabc05c9bff89d23fd902d324c79903b48fcb8f8f4b01f3e4ddb483593d25f000386698f5ade7faade9615fdc50d32785ea51d49894e45baa3dc707e224688c6408b68b11", "88f0bda147ee85476bf00350f17cbdbe37fcf91df31c051d8abe070dfcda3cadd9ec60da83e299b504660b3aa1cd70a94da0593e2f18befe0a4a3f5eb7733b3d");
        TestDigest.testKatHex(new BLAKE512(), "68c8f8849b120e6e0c9969a5866af591a829b92f33cd9a4a3196957a148c49138e1e2f5c7619a6d5edebe995acd81ec8bb9c7b9cfca678d081ea9e25a75d39db04e18d475920ce828b94e72241f24db72546b352a0e4", "065a7f9d8366c26b59f1c412ec938d2c74db584c0b45fd6a5b6bdd5b8f690b264c2c9a5c3058a7f0ca65b8e7bbdf1b2d44b6df1deeda60cfc836d03d5c732bcb");
        TestDigest.testKatHex(new BLAKE512(), "b8d56472954e31fb54e28fca743f84d8dc34891cb564c64b08f7b71636debd64ca1edbdba7fc5c3e40049ce982bba8c7e0703034e331384695e9de76b5104f2fbc4535ecbeebc33bc27f29f18f6f27e8023b0fbb6f563c", "d99819e135abb478fcaf809c94fe08c6c87d66bf98e611fdbde77658d1e222404da0434978844193e5fbb7a7384f71fcc127a751d8257d26513ae418d9f605c4");
        TestDigest.testKatHex(new BLAKE512(), "0d58ac665fa84342e60cefee31b1a4eacdb092f122dfc68309077aed1f3e528f578859ee9e4cefb4a728e946324927b675cd4f4ac84f64db3dacfe850c1dd18744c74ceccd9fe4dc214085108f404eab6d8f452b5442a47d", "c018897f3cecf608a620c70a8c402228e78f3439d949ea6c98d52d36c06badc5d96714e81364730a7448e4281a618cab45f5b723751248d90b234c5f9a8551ce");
        TestDigest.testKatHex(new BLAKE512(), "1755e2d2e5d1c1b0156456b539753ff416651d44698e87002dcf61dcfa2b4e72f264d9ad591df1fdee7b41b2eb00283c5aebb3411323b672eaa145c5125185104f20f335804b02325b6dea65603f349f4d5d8b782dd3469ccd", "c844082a46209636a04f7a305c06ac6db84e1e1e36a6c7ac90ea389360b613ebcb95527a5cc7b9ee9bb3be0a6bdafa9d2dcf3b5dd5ad323d8e6ed659b1004b9b");
        TestDigest.testKatHex(new BLAKE512(), "b180de1a611111ee7584ba2c4b020598cd574ac77e404e853d15a101c6f5a2e5c801d7d85dc95286a1804c870bb9f00fd4dcb03aa8328275158819dcad7253f3e3d237aeaa7979268a5db1c6ce08a9ec7c2579783c8afc1f91a7", "730e05303e749e0e6b62cc97858f23765ae619f2786aa188bcc6d0c83e19fd930c03a8edb4618549d7edf0d92b876c36a32db3ec0432be0e5a133d955a1e1828");
        TestDigest.testKatHex(new BLAKE512(), "cf3583cbdfd4cbc17063b1e7d90b02f0e6e2ee05f99d77e24e560392535e47e05077157f96813544a17046914f9efb64762a23cf7a49fe52a0a4c01c630cfe8727b81fb99a89ff7cc11dca5173057e0417b8fe7a9efba6d95c555f", "9e037c85a12045be3062f27058fe7b3e7ea7b076e9164320057b31dd3038dbd4be5bc812ab259e5fff9fda533be068dd35fffda3c9fb06ea159f5b9024bbab1b");
        TestDigest.testKatHex(new BLAKE512(), "072fc02340ef99115bad72f92c01e4c093b9599f6cfc45cb380ee686cb5eb019e806ab9bd55e634ab10aa62a9510cc0672cd3eddb589c7df2b67fcd3329f61b1a4441eca87a33c8f55da4fbbad5cf2b2527b8e983bb31a2fadec7523", "da071ea95c579760f2033de1eb563d19a87b929d5d1ce96a157ee2c5c234fe80c19035b7d31af968ba27e01960cd31b483be411b3bd537ff05d68b46bbf7ff3a");
        TestDigest.testKatHex(new BLAKE512(), "76eecf956a52649f877528146de33df249cd800e21830f65e90f0f25ca9d6540fde40603230eca6760f1139c7f268deba2060631eea92b1fff05f93fd5572fbe29579ecd48bc3a8d6c2eb4a6b26e38d6c5fbf2c08044aeea470a8f2f26", "6eb93f432b8c78d84cdfe52e3d6a454be5b79f7a0251584ee04e0b222042728fae6aeaa8883642500233c1e0e9bbad8066b08ba12dd0f46d333e9e699fc3c1d8");
        TestDigest.testKatHex(new BLAKE512(), "7adc0b6693e61c269f278e6944a5a2d8300981e40022f839ac644387bfac9086650085c2cdc585fea47b9d2e52d65a2b29a7dc370401ef5d60dd0d21f9e2b90fae919319b14b8c5565b0423cefb827d5f1203302a9d01523498a4db10374", "5124cd7acff28280c5b57a6e624889785f1a2e13dd52db995946e795c2a76f42b039096210910c577133ae1c5b860cfb633f69ab2ef500535487d6bc38eecd1a");
        TestDigest.testKatHex(new BLAKE512(), "e1fffa9826cce8b86bccefb8794e48c46cdf372013f782eced1e378269b7be2b7bf51374092261ae120e822be685f2e7a83664bcfbe38fe8633f24e633ffe1988e1bc5acf59a587079a57a910bda60060e85b5f5b6f776f0529639d9cce4bd", "64e659d993815e3350866c863c5540740abfbab602ddf68a0b29d39d3a57475476a17a354c58a30219cb514721d85795e753db090c6815b1f2d5a2f66983f0f0");
        TestDigest.testKatHex(new BLAKE512(), "69f9abba65592ee01db4dce52dbab90b08fc04193602792ee4daa263033d59081587b09bbe49d0b49c9825d22840b2ff5d9c5155f975f8f2c2e7a90c75d2e4a8040fe39f63bbafb403d9e28cc3b86e04e394a9c9e8065bd3c85fa9f0c7891600", "a9dae30af950a9e144648ff141779b74d5b7b7cb04ceb66fdd54fa2b2a042070a3b310ec96cb35639386ef02bee3164f2dbd7be10932a99d520af921a2df92db");
        TestDigest.testKatHex(new BLAKE512(), "38a10a352ca5aedfa8e19c64787d8e9c3a75dbf3b8674bfab29b5dbfc15a63d10fae66cd1a6e6d2452d557967eaad89a4c98449787b0b3164ca5b717a93f24eb0b506ceb70cbbcb8d72b2a72993f909aad92f044e0b5a2c9ac9cb16a0ca2f81f49", "22bf460d823a2de8e4f34ae26703a3971adf4252cf15ab7afe55bce4d4b746d2af8a5327d13494ced6f8ee24f5161c742e5f48197825b2ebb87117493d21961a");
        TestDigest.testKatHex(new BLAKE512(), "6d8c6e449bc13634f115749c248c17cd148b72157a2c37bf8969ea83b4d6ba8c0ee2711c28ee11495f43049596520ce436004b026b6c1f7292b9c436b055cbb72d530d860d1276a1502a5140e3c3f54a93663e4d20edec32d284e25564f624955b52", "2a7f9fd15654bc71c032a7c7a5514eecc2a082418c6fd7b9ee7566949864455ee74f54316da084730dd789790d011521ee8243cd10322e17c2d9c6d675d84d37");
        TestDigest.testKatHex(new BLAKE512(), "6efcbcaf451c129dbe00b9cef0c3749d3ee9d41c7bd500ade40cdc65dedbbbadb885a5b14b32a0c0d087825201e303288a733842fa7e599c0c514e078f05c821c7a4498b01c40032e9f1872a1c925fa17ce253e8935e4c3c71282242cb716b2089ccc1", "22eb00ad4ba0a9fbcee7e4c7e74442b4697791cb549d0254d3644f7b359ed73db6a9ba90a12b7dfa943253ae81a9a40b8d95f2c273387c4b20a7f1362d9c6f4d");
        TestDigest.testKatHex(new BLAKE512(), "433c5303131624c0021d868a30825475e8d0bd3052a022180398f4ca4423b98214b6beaac21c8807a2c33f8c93bd42b092cc1b06cedf3224d5ed1ec29784444f22e08a55aa58542b524b02cd3d5d5f6907afe71c5d7462224a3f9d9e53e7e0846dcbb4ce", "eb0de6909b3d69eed50317edd08eec2be20bc71b39901ddd5dc77a097cba1360498286a441564447d0fce4b324e48d48367f44a380fbc8c8c0fe545ca1404876");
        TestDigest.testKatHex(new BLAKE512(), "a873e0c67ca639026b6683008f7aa6324d4979550e9bce064ca1e1fb97a30b147a24f3f666c0a72d71348ede701cf2d17e2253c34d1ec3b647dbcef2f879f4eb881c4830b791378c901eb725ea5c172316c6d606e0af7df4df7f76e490cd30b2badf45685f", "2f5a63f91b190a76e2805c78d62ab76937d81671ca71b01e3f92ab737b667bde6b904355495ae1c666f097d99ab0b4f267ad27e99367de54b86c299400a09c89");
        TestDigest.testKatHex(new BLAKE512(), "006917b64f9dcdf1d2d87c8a6173b64f6587168e80faa80f82d84f60301e561e312d9fbce62f39a6fb476e01e925f26bcc91de621449be6504c504830aae394096c8fc7694651051365d4ee9070101ec9b68086f2ea8f8ab7b811ea8ad934d5c9b62c60a4771", "9983ebfd7a08d40460aac2ee8da51c8e216ec8cf379aad99e863614bc76a95a1129b7a33e508640c512e1d81a88a5a169b98260e7b98bca9035927db24541594");
        TestDigest.testKatHex(new BLAKE512(), "f13c972c52cb3cc4a4df28c97f2df11ce089b815466be88863243eb318c2adb1a417cb1041308598541720197b9b1cb5ba2318bd5574d1df2174af14884149ba9b2f446d609df240ce335599957b8ec80876d9a085ae084907bc5961b20bf5f6ca58d5dab38adb", "c88c5b3b3e64ec3f1cb6db0707e67ebf63046c399b479ed6288f036f297a2d0c141b81414676a4397cfae198f48a6051e04c8550d176425a8b28573be9230071");
        TestDigest.testKatHex(new BLAKE512(), "e35780eb9799ad4c77535d4ddb683cf33ef367715327cf4c4a58ed9cbdcdd486f669f80189d549a9364fa82a51a52654ec721bb3aab95dceb4a86a6afa93826db923517e928f33e3fba850d45660ef83b9876accafa2a9987a254b137c6e140a21691e1069413848", "65acd075901d97557a4e16e52f4483417e3ab7f675163e8c23fd3a4c3594df8293aa8e5c60e54d5f9e4b122047ba5474e11ca62d178a4847cfcc4235fbd60323");
        TestDigest.testKatHex(new BLAKE512(), "64ec021c9585e01ffe6d31bb50d44c79b6993d72678163db474947a053674619d158016adb243f5c8d50aa92f50ab36e579ff2dabb780a2b529370daa299207cfbcdd3a9a25006d19c4f1fe33e4b1eaec315d8c6ee1e730623fd1941875b924eb57d6d0c2edc4e78d6", "e944aa0b87d3b59e574c53a69d038290f3b8d96eae2a8e06d49e654130925e6b56193fbb7cb0ca30cdd0a665524381b4f627ee35dca4fe790fe405c6426828ee");
        TestDigest.testKatHex(new BLAKE512(), "5954bab512cf327d66b5d9f296180080402624ad7628506b555eea8382562324cf452fba4a2130de3e165d11831a270d9cb97ce8c2d32a96f50d71600bb4ca268cf98e90d6496b0a6619a5a8c63db6d8a0634dfc6c7ec8ea9c006b6c456f1b20cd19e781af20454ac880", "a0094b373aa403a25c3d40496129215036b5e0a336fcc9ad48b08a96483de7c5bf1994d7cf0c639e098d79005289ef36b4bf09966e2fdf2da35c71fa402690cf");
        TestDigest.testKatHex(new BLAKE512(), "03d9f92b2c565709a568724a0aff90f8f347f43b02338f94a03ed32e6f33666ff5802da4c81bdce0d0e86c04afd4edc2fc8b4141c2975b6f07639b1994c973d9a9afce3d9d365862003498513bfa166d2629e314d97441667b007414e739d7febf0fe3c32c17aa188a8683", "46ccf9ef411dd67d01686d3cdb2043681455cb22609b33f37c8c3dd8b4613b77b887af5c530fc1e11ce4ce6595456fb9f9dbb54dfbebf7f18260aefba5cf932d");
        TestDigest.testKatHex(new BLAKE512(), "f31e8b4f9e0621d531d22a380be5d9abd56faec53cbd39b1fab230ea67184440e5b1d15457bd25f56204fa917fa48e669016cb48c1ffc1e1e45274b3b47379e00a43843cf8601a5551411ec12503e5aac43d8676a1b2297ec7a0800dbfee04292e937f21c005f17411473041", "0d2dd2691689fe46c0bc7d53d54f251d04fcc7491097685446d7586c52863ac696808bce1886c21886c9d9af671895f8393b12019e6cf5bc233b5cc7d6581880");
        TestDigest.testKatHex(new BLAKE512(), "758ea3fea738973db0b8be7e599bbef4519373d6e6dcd7195ea885fc991d896762992759c2a09002912fb08e0cb5b76f49162aeb8cf87b172cf3ad190253df612f77b1f0c532e3b5fc99c2d31f8f65011695a087a35ee4eee5e334c369d8ee5d29f695815d866da99df3f79403", "fded53017461f045f26ec8c063935aff541b56fdd560c57408950808992beae0ac89f660cca54c360a1e9090abe67646deccd4fc0efb6003446eac0b246a303f");
        TestDigest.testKatHex(new BLAKE512(), "47c6e0c2b74948465921868804f0f7bd50dd323583dc784f998a93cd1ca4c6ef84d41dc81c2c40f34b5bee6a93867b3bdba0052c5f59e6f3657918c382e771d33109122cc8bb0e1e53c4e3d13b43ce44970f5e0c079d2ad7d7a3549cd75760c21bb15b447589e86e8d76b1e9ced2", "4ea2f30a58e0876c6d9d2662fcdb1b9c48b32f364860468cfb768ae280a48fcff9f43456ed9094859435527d8450a0348fd177f1ded7b01194d1571807c8a35d");
        TestDigest.testKatHex(new BLAKE512(), "f690a132ab46b28edfa6479283d6444e371c6459108afd9c35dbd235e0b6b6ff4c4ea58e7554bd002460433b2164ca51e868f7947d7d7a0d792e4abf0be5f450853cc40d85485b2b8857ea31b5ea6e4ccfa2f3a7ef3380066d7d8979fdac618aad3d7e886dea4f005ae4ad05e5065f", "0043e39f7d08a1eb38a80712d6e6ce244fb1834bbf19a3e60a7bf9067de49a18cb6bcefeb3885c099eaadc8e9c8f04dad0c2a0599c61194ded218354f255badd");
        TestDigest.testKatHex(new BLAKE512(), "58d6a99bc6458824b256916770a8417040721cccfd4b79eacd8b65a3767ce5ba7e74104c985ac56b8cc9aebd16febd4cda5adb130b0ff2329cc8d611eb14dac268a2f9e633c99de33997fea41c52a7c5e1317d5b5daed35eba7d5a60e45d1fa7eaabc35f5c2b0a0f2379231953322c4e", "3909717a6f65c8e8cdc78dc446f53a44ea9d08993a83a51edeba291af3a0fa874ebcd758293a70f4b660bc3b7909004c73e8755dd72e12db2d60d102d9b2dd60");
        TestDigest.testKatHex(new BLAKE512(), "befab574396d7f8b6705e2d5b58b2c1c820bb24e3f4bae3e8fbcd36dbf734ee14e5d6ab972aedd3540235466e825850ee4c512ea9795abfd33f330d9fd7f79e62bbb63a6ea85de15beaeea6f8d204a28956059e2632d11861dfb0e65bc07ac8a159388d5c3277e227286f65ff5e5b5aec1", "32253900f9287b250c2dfb72ba6b83e51695d06c438f655ab2c1f67732418436232328dbb60bcb80a619c3b2cd2e435f4a882df302242dd2eadc7e216eade299");
        TestDigest.testKatHex(new BLAKE512(), "8e58144fa9179d686478622ce450c748260c95d1ba43b8f9b59abeca8d93488da73463ef40198b4d16fb0b0707201347e0506ff19d01bea0f42b8af9e71a1f1bd168781069d4d338fdef00bf419fbb003031df671f4a37979564f69282de9c65407847dd0da505ab1641c02dea4f0d834986", "1dc47b8809b00ee341208c606ae29fc85d0eb4c1b12599291ec33cdedf63199a462feddb5f7313712b41082761fd79cf3f662702f3e9a06e6b65a9aa4538c82d");
        TestDigest.testKatHex(new BLAKE512(), "b55c10eae0ec684c16d13463f29291bf26c82e2fa0422a99c71db4af14dd9c7f33eda52fd73d017cc0f2dbe734d831f0d820d06d5f89dacc485739144f8cfd4799223b1aff9031a105cb6a029ba71e6e5867d85a554991c38df3c9ef8c1e1e9a7630be61caabca69280c399c1fb7a12d12aefc", "d866fe4a230791c8e7828050077f2dcb6958d191af929fd69a125d2fd6e4666f634aea76de9167261a2dc69f4596822255e1b5dcfb2d98bf8219190e6770ef33");
        TestDigest.testKatHex(new BLAKE512(), "2eeea693f585f4ed6f6f8865bbae47a6908aecd7c429e4bec4f0de1d0ca0183fa201a0cb14a529b7d7ac0e6ff6607a3243ee9fb11bcf3e2304fe75ffcddd6c5c2e2a4cd45f63c962d010645058d36571404a6d2b4f44755434d76998e83409c3205aa1615db44057db991231d2cb42624574f545", "2ef07bad5c41ce2ac94719022da4c3cdabb9f028db12bac0cc9418456c0d89a48cddea15cba69a8023d31456cb175768e1f51e4e5a642832e3ed2699a031b244");
        TestDigest.testKatHex(new BLAKE512(), "dab11dc0b047db0420a585f56c42d93175562852428499f66a0db811fcdddab2f7cdffed1543e5fb72110b64686bc7b6887a538ad44c050f1e42631bc4ec8a9f2a047163d822a38989ee4aab01b4c1f161b062d873b1cfa388fd301514f62224157b9bef423c7783b7aac8d30d65cd1bba8d689c2d", "b164ac505fe25759a1f9ff66ce50909f0e8481b21281b3e692f627d7adf68607a1475cbeeba3e85487a22a55a918a0903ba543057bdb8942d49964ad7f220977");
        TestDigest.testKatHex(new BLAKE512(), "42e99a2f80aee0e001279a2434f731e01d34a44b1a8101726921c0590c30f3120eb83059f325e894a5ac959dca71ce2214799916424e859d27d789437b9d27240bf8c35adbafcecc322b48aa205b293962d858652abacbd588bcf6cbc388d0993bd622f96ed54614c25b6a9aa527589eaaffcf17ddf7", "2e37d97706655ad2385385a69eaa650eec945860c14fd45f1e32d5c76160ca5636c5905036833c4f06078f97b628932e64a0a9c409ebe4cee1c3989c3f7a7a00");
        TestDigest.testKatHex(new BLAKE512(), "3c9b46450c0f2cae8e3823f8bdb4277f31b744ce2eb17054bddc6dff36af7f49fb8a2320cc3bdf8e0a2ea29ad3a55de1165d219adeddb5175253e2d1489e9b6fdd02e2c3d3a4b54d60e3a47334c37913c5695378a669e9b72dec32af5434f93f46176ebf044c4784467c700470d0c0b40c8a088c815816", "80a0ef7eda4fe8dafe26ed9871f3a283924386c450716e45841400025bad79b6aaf1f5863c583c1074dbe7192998a89136cda21161b2619c55334473eb130286");
        TestDigest.testKatHex(new BLAKE512(), "d1e654b77cb155f5c77971a64df9e5d34c26a3cad6c7f6b300d39deb1910094691adaa095be4ba5d86690a976428635d5526f3e946f7dc3bd4dbc78999e653441187a81f9adcd5a3c5f254bc8256b0158f54673dcc1232f6e918ebfc6c51ce67eaeb042d9f57eec4bfe910e169af78b3de48d137df4f2840", "4aa70e2e777ba0879c79e7c2cd1492d948c89141827f776099e4672140ac09a4f77b6c4a2989c58c1340ddbb504c6f90ab695bdf77e9fdb45fe7ce4a1b18dcf2");
        TestDigest.testKatHex(new BLAKE512(), "626f68c18a69a6590159a9c46be03d5965698f2dac3de779b878b3d9c421e0f21b955a16c715c1ec1e22ce3eb645b8b4f263f60660ea3028981eebd6c8c3a367285b691c8ee56944a7cd1217997e1d9c21620b536bdbd5de8925ff71dec6fbc06624ab6b21e329813de90d1e572dfb89a18120c3f606355d25", "6a7c8f361a11dbd29df56c57cdb68d445ff88d076403dd308d1a15767b5b78d26edea2391358534ee519d6cd62b689ee95e2a28d6e4e8383c9061601204fd303");
        TestDigest.testKatHex(new BLAKE512(), "651a6fb3c4b80c7c68c6011675e6094eb56abf5fc3057324ebc6477825061f9f27e7a94633abd1fa598a746e4a577caf524c52ec1788471f92b8c37f23795ca19d559d446cab16cbcdce90b79fa1026cee77bf4ab1b503c5b94c2256ad75b3eac6fd5dcb96aca4b03a834bfb4e9af988cecbf2ae597cb9097940", "46e6910b9f6900485d526c3a3498019ca243db5a8ec269218f4db8a574c5dddb5869bd4188799b0ae5e489f922c6e37947ce7c777b1f9292fb0b007db9d22c41");
        TestDigest.testKatHex(new BLAKE512(), "8aaf072fce8a2d96bc10b3c91c809ee93072fb205ca7f10abd82ecd82cf040b1bc49ea13d1857815c0e99781de3adbb5443ce1c897e55188ceaf221aa9681638de05ae1b322938f46bce51543b57ecdb4c266272259d1798de13be90e10efec2d07484d9b21a3870e2aa9e06c21aa2d0c9cf420080a80a91dee16f", "68ad53d5455822cfc08bf4e43dc8d1b4bcc079c0fe55a933d5f80628390bd0d73ddccb33d697492330b2740815f8b12a281adc62284874021ba5242177e277ea");
        TestDigest.testKatHex(new BLAKE512(), "53f918fd00b1701bd504f8cdea803acca21ac18c564ab90c2a17da592c7d69688f6580575395551e8cd33e0fef08ca6ed4588d4d140b3e44c032355df1c531564d7f4835753344345a6781e11cd5e095b73df5f82c8ae3ad00877936896671e947cc52e2b29dcd463d90a0c9929128da222b5a211450bbc0e02448e2", "977acdc9f93cac665a301cd995e9f7260b9bda079e0aceab296a25064d828caead957c29f9815137e7951c9fe3a50e2ad308d27a02f19e91a9adb7f395c415d6");
        TestDigest.testKatHex(new BLAKE512(), "a64599b8a61b5ccec9e67aed69447459c8da3d1ec6c7c7c82a7428b9b584fa67e90f68e2c00fbbed4613666e5168da4a16f395f7a3c3832b3b134bfc9cbaa95d2a0fe252f44ac6681eb6d40ab91c1d0282fed6701c57463d3c5f2bb8c6a7301fb4576aa3b5f15510db8956ff77478c26a7c09bea7b398cfc83503f538e", "24e7b10ff1653e4780d12e9bbedbe7afdf0181db1dcbf69117222a34c792973991b27a5b844579a0f1d9acf8ed95d979de11c79989ef70731e707c2f262654a1");
        TestDigest.testKatHex(new BLAKE512(), "0e3ab0e054739b00cdb6a87bd12cae024b54cb5e550e6c425360c2e87e59401f5ec24ef0314855f0f56c47695d56a7fb1417693af2a1ed5291f2fee95f75eed54a1b1c2e81226fbff6f63ade584911c71967a8eb70933bc3f5d15bc91b5c2644d9516d3c3a8c154ee48e118bd1442c043c7a0dba5ac5b1d5360aae5b9065", "151ba1ca1c71b85004aced1b9298d213a2933c91f0d207fc63b5ecf1bfccc968ba88953a9ec013b9591434be2283f4776d30ccade812bb31d9dfac9fd45bd373");
        TestDigest.testKatHex(new BLAKE512(), "a62fc595b4096e6336e53fcdfc8d1cc175d71dac9d750a6133d23199eaac288207944cea6b16d27631915b4619f743da2e30a0c00bbdb1bbb35ab852ef3b9aec6b0a8dcc6e9e1abaa3ad62ac0a6c5de765de2c3711b769e3fde44a74016fff82ac46fa8f1797d3b2a726b696e3dea5530439acee3a45c2a51bc32dd055650b", "0b2cd74713892965dcaa2a32b9ee1b86b505b1e7bf90382353767c938e15784d754f197fc47348c8db58fb526c3680ede4fdd5bec8bb850b019906d454f4515a");
        TestDigest.testKatHex(new BLAKE512(), "2b6db7ced8665ebe9deb080295218426bdaa7c6da9add2088932cdffbaa1c14129bccdd70f369efb149285858d2b1d155d14de2fdb680a8b027284055182a0cae275234cc9c92863c1b4ab66f304cf0621cd54565f5bff461d3b461bd40df28198e3732501b4860eadd503d26d6e69338f4e0456e9e9baf3d827ae685fb1d817", "708dbd20edbd4cb8d1127e8ed75d8b89f7507c15b3eadbc8a2a0a352d8801dfda778d9c0a96b04c517cc8565ba28b6260b788a5ea0c8cd7091d3cc75036b412e");
        TestDigest.testKatHex(new BLAKE512(), "10db509b2cdcaba6c062ae33be48116a29eb18e390e1bbada5ca0a2718afbcd23431440106594893043cc7f2625281bf7de2655880966a23705f0c5155c2f5cca9f2c2142e96d0a2e763b70686cd421b5db812daced0c6d65035fde558e94f26b3e6dde5bd13980cc80292b723013bd033284584bff27657871b0cf07a849f4ae2", "5312a940cc8f82a2e575d486273788cfa9bc5d940e41c373a75b47db2b9847f09bd71c8f65fa15ff168ed1bb4143b09a8c4f678c23384e47754387842b5358af");
        TestDigest.testKatHex(new BLAKE512(), "9334de60c997bda6086101a6314f64e4458f5ff9450c509df006e8c547983c651ca97879175aaba0c539e82d05c1e02c480975cbb30118121061b1ebac4f8d9a3781e2db6b18042e01ecf9017a64a0e57447ec7fcbe6a7f82585f7403ee2223d52d37b4bf426428613d6b4257980972a0acab508a7620c1cb28eb4e9d30fc41361ec", "d5e0a3cdae0613e6ab159635938d247b5a11a41ab503001fa730a65259b7577b17edb13e7c75d0e90612c5ced843d7776f12a4e8f5678d00497aca92e64b2062");
        TestDigest.testKatHex(new BLAKE512(), "e88ab086891693aa535ceb20e64c7ab97c7dd3548f3786339897a5f0c39031549ca870166e477743ccfbe016b4428d89738e426f5ffe81626137f17aecff61b72dbee2dc20961880cfe281dfab5ee38b1921881450e16032de5e4d55ad8d4fca609721b0692bac79be5a06e177fe8c80c0c83519fb3347de9f43d5561cb8107b9b5edc", "40a84fb7e6e0ebabaffb69fa6607759afb20babd9ef4ae29fab24b98fa0bb9ef36ec7215797bab0ffc2eaa14e5fa2c110143c84ab8d672f0dc64a689c84ebf91");
        TestDigest.testKatHex(new BLAKE512(), "fd19e01a83eb6ec810b94582cb8fbfa2fcb992b53684fb748d2264f020d3b960cb1d6b8c348c2b54a9fcea72330c2aaa9a24ecdb00c436abc702361a82bb8828b85369b8c72ece0082fe06557163899c2a0efa466c33c04343a839417057399a63a3929be1ee4805d6ce3e5d0d0967fe9004696a5663f4cac9179006a2ceb75542d75d68", "8b5b19af484b48e8537bb0e82667f45f0ebfad4e8a4024ba6c080fccb8de573891ecc908b96c9b60c9225eba12e2e181f874ea91db03b106696d467420451d91");
        TestDigest.testKatHex(new BLAKE512(), "59ae20b6f7e0b3c7a989afb28324a40fca25d8651cf1f46ae383ef6d8441587aa1c04c3e3bf88e8131ce6145cfb8973d961e8432b202fa5af3e09d625faad825bc19da9b5c6c20d02abda2fcc58b5bd3fe507bf201263f30543819510c12bc23e2ddb4f711d087a86edb1b355313363a2de996b891025e147036087401ccf3ca7815bf3c49", "9f21c6efc2e7f8b37377b79a8c1a952021dcc666be670dcdd6d15a573dce67a810f19c4a65a7dd3d2a3bb3a31563456bc315a3f460eae6762af2d8fe6dc060d4");
        TestDigest.testKatHex(new BLAKE512(), "77ee804b9f3295ab2362798b72b0a1b2d3291dceb8139896355830f34b3b328561531f8079b79a6e9980705150866402fdc176c05897e359a6cb1a7ab067383eb497182a7e5aef7038e4c96d133b2782917417e391535b5e1b51f47d8ed7e4d4025fe98dc87b9c1622614bff3d1029e68e372de719803857ca52067cddaad958951cb2068cc6", "1791e85d4becece7ae1c6430d108e97d23da1e6ebfc573ec1e0cdbf3f81ca4bfaad240257dc5c125c7d31687759a99c9fac7a0feffb478f33f1809cf10a80b16");
        TestDigest.testKatHex(new BLAKE512(), "b771d5cef5d1a41a93d15643d7181d2a2ef0a8e84d91812f20ed21f147bef732bf3a60ef4067c3734b85bc8cd471780f10dc9e8291b58339a677b960218f71e793f2797aea349406512829065d37bb55ea796fa4f56fd8896b49b2cd19b43215ad967c712b24e5032d065232e02c127409d2ed4146b9d75d763d52db98d949d3b0fed6a8052fbb", "ffad3f92f582e77813a7bb6e99b877e8d50e6ed211392345d4bf8f2ca5349d2aac686860d23635e3eea4c5ba45b38e35fbe34e5d4d6742553c1edefaebd5ab81");
        TestDigest.testKatHex(new BLAKE512(), "b32d95b0b9aad2a8816de6d06d1f86008505bd8c14124f6e9a163b5a2ade55f835d0ec3880ef50700d3b25e42cc0af050ccd1be5e555b23087e04d7bf9813622780c7313a1954f8740b6ee2d3f71f768dd417f520482bd3a08d4f222b4ee9dbd015447b33507dd50f3ab4247c5de9a8abd62a8decea01e3b87c8b927f5b08beb37674c6f8e380c04", "3a3decb9e8716ccb0478e688a7c988ba7a613cc329ec5ddf937d6574de328431450194d69cdd6c054d3cfc3fc5dca9f323151251c2a23f9fa2066e7ead09652b");
        TestDigest.testKatHex(new BLAKE512(), "04410e31082a47584b406f051398a6abe74e4da59bb6f85e6b49e8a1f7f2ca00dfba5462c2cd2bfde8b64fb21d70c083f11318b56a52d03b81cac5eec29eb31bd0078b6156786da3d6d8c33098c5c47bb67ac64db14165af65b44544d806dde5f487d5373c7f9792c299e9686b7e5821e7c8e2458315b996b5677d926dac57b3f22da873c601016a0d", "08dd6ed5c5510b7b242216119fa3998881238ed02197c5e3ae27ed3a3ca4ebc5b0fe54547994e4602aaf8675898d39ca198023099783fe4d0d23331e504732b0");
        TestDigest.testKatHex(new BLAKE512(), "8b81e9badde026f14d95c019977024c9e13db7a5cd21f9e9fc491d716164bbacdc7060d882615d411438aea056c340cdf977788f6e17d118de55026855f93270472d1fd18b9e7e812bae107e0dfde7063301b71f6cfe4e225cab3b232905a56e994f08ee2891ba922d49c3dafeb75f7c69750cb67d822c96176c46bd8a29f1701373fb09a1a6e3c7158f", "c1a165227619e78caa19f283e955f8e143837a4dfb0207ee35f26e7e480bc6de5fe78e16407018555659b81905142d42aa09502697ba66deabc4c4d2a54f2b0b");
        TestDigest.testKatHex(new BLAKE512(), "fa6eed24da6666a22208146b19a532c2ec9ba94f09f1def1e7fc13c399a48e41acc2a589d099276296348f396253b57cb0e40291bd282773656b6e0d8bea1cda084a3738816a840485fcf3fb307f777fa5feac48695c2af4769720258c77943fb4556c362d9cba8bf103aeb9034baa8ea8bfb9c4f8e6742ce0d52c49ea8e974f339612e830e9e7a9c29065", "05e5dc3559393f22b5112ca50fe6f1ef8155a9ad450f1ada2f721b56f4b0288d64b41e3275f7ede1b0ec6beb89a458277c8c862b60cc34443f7dfb49a0285b4c");
        TestDigest.testKatHex(new BLAKE512(), "9bb4af1b4f09c071ce3cafa92e4eb73ce8a6f5d82a85733440368dee4eb1cbc7b55ac150773b6fe47dbe036c45582ed67e23f4c74585dab509df1b83610564545642b2b1ec463e18048fc23477c6b2aa035594ecd33791af6af4cbc2a1166aba8d628c57e707f0b0e8707caf91cd44bdb915e0296e0190d56d33d8dde10b5b60377838973c1d943c22ed335e", "181455eb50d22398d978797c0b1cb32bb423616fe5f12ef2e136ddf8bbc830d208799e8cc017dbf105cadfa58b3eb9723f28e21a4f1cc6998c7a6997be851933");
        TestDigest.testKatHex(new BLAKE512(), "2167f02118cc62043e9091a647cadbed95611a521fe0d64e8518f16c808ab297725598ae296880a773607a798f7c3cfce80d251ebec6885015f9abf7eaabae46798f82cb5926de5c23f44a3f9f9534b3c6f405b5364c2f8a8bdc5ca49c749bed8ce4ba48897062ae8424ca6dde5f55c0e42a95d1e292ca54fb46a84fbc9cd87f2d0c9e7448de3043ae22fdd229", "160bfbda492c6a6dd33ba92ef8f16d4eb7df9e4f67ca5210bbddcb7b541474d914b61b38c1a3d1d00dd8b6954b1cb30f403c800781472f9aaa4f26d618d2615f");
        TestDigest.testKatHex(new BLAKE512(), "94b7fa0bc1c44e949b1d7617d31b4720cbe7ca57c6fa4f4094d4761567e389ecc64f6968e4064df70df836a47d0c713336b5028b35930d29eb7a7f9a5af9ad5cf441745baec9bb014ceeff5a41ba5c1ce085feb980bab9cf79f2158e03ef7e63e29c38d7816a84d4f71e0f548b7fc316085ae38a060ff9b8dec36f91ad9ebc0a5b6c338cbb8f6659d342a24368cf", "56f0cd12d41b0dcca5d63b5b74166b3d96d8eaf7cbc9cc832b6d131e7d7b408f2bba0179c022e8531d5264a3fa5d82bc6b4390ff2922f5674dbc51dbaadaafe2");
        TestDigest.testKatHex(new BLAKE512(), "ea40e83cb18b3a242c1ecc6ccd0b7853a439dab2c569cfc6dc38a19f5c90acbf76aef9ea3742ff3b54ef7d36eb7ce4ff1c9ab3bc119cff6be93c03e208783335c0ab8137be5b10cdc66ff3f89a1bddc6a1eed74f504cbe7290690bb295a872b9e3fe2cee9e6c67c41db8efd7d863cf10f840fe618e7936da3dca5ca6df933f24f6954ba0801a1294cd8d7e66dfafec", "7eee5de498ca8f74964a14290dcf6c7c1124bb839d94a99a24100e577ade541d47937574f9343908c802e22226b5a19235112677f4fa6f2e88525169177a3d7c");
        TestDigest.testKatHex(new BLAKE512(), "157d5b7e4507f66d9a267476d33831e7bb768d4d04cc3438da12f9010263ea5fcafbde2579db2f6b58f911d593d5f79fb05fe3596e3fa80ff2f761d1b0e57080055c118c53e53cdb63055261d7c9b2b39bd90acc32520cbbdbda2c4fd8856dbcee173132a2679198daf83007a9b5c51511ae49766c792a29520388444ebefe28256fb33d4260439cba73a9479ee00c63", "e39234dcf3b22d9cc6286cd7fe8789ed72909f38fa4dbb2a544bc90ef2ded6bddf257eebb700df2d6acb42198d8b45e13b3f3398903a6334ba058337560823f4");
        TestDigest.testKatHex(new BLAKE512(), "836b34b515476f613fe447a4e0c3f3b8f20910ac89a3977055c960d2d5d2b72bd8acc715a9035321b86703a411dde0466d58a59769672aa60ad587b8481de4bba552a1645779789501ec53d540b904821f32b0bd1855b04e4848f9f8cfe9ebd8911be95781a759d7ad9724a7102dbe576776b7c632bc39b9b5e19057e226552a5994c1dbb3b5c7871a11f5537011044c53", "1e90545225ed271876afb17fdd3a61ce86e3136bd00329a8859da4d0e6560c1e6e9451ddce86e1b791cc1d771371391a73e160966aae0e6333a19a19bd3507f2");
        TestDigest.testKatHex(new BLAKE512(), "cc7784a4912a7ab5ad3620aab29ba87077cd3cb83636adc9f3dc94f51edf521b2161ef108f21a0a298557981c0e53ce6ced45bdf782c1ef200d29bab81dd6460586964edab7cebdbbec75fd7925060f7da2b853b2b089588fa0f8c16ec6498b14c55dcee335cb3a91d698e4d393ab8e8eac0825f8adebeee196df41205c011674e53426caa453f8de1cbb57932b0b741d4c6", "48252ec638475c7d08728949523ff66198e1f277a4d810e0232cd1ff3f293de7b3824a64e87aab544ea1af4ee098fb13069d14c9e006851793093e6b08bd8185");
        TestDigest.testKatHex(new BLAKE512(), "7639b461fff270b2455ac1d1afce782944aea5e9087eb4a39eb96bb5c3baaf0e868c8526d3404f9405e79e77bfac5ffb89bf1957b523e17d341d7323c302ea7083872dd5e8705694acdda36d5a1b895aaa16eca6104c82688532c8bfe1790b5dc9f4ec5fe95baed37e1d287be710431f1e5e8ee105bc42ed37d74b1e55984bf1c09fe6a1fa13ef3b96faeaed6a2a1950a12153", "6f5b503f5e42498d2406dedc12e6785039d08c487d2630d84d464a1113eca6bd8eb2ff5716dc1c76631f2d6170ebb07ab0ccbcaae3cd2d066694e62ba4349e01");
        TestDigest.testKatHex(new BLAKE512(), "eb6513fc61b30cfba58d4d7e80f94d14589090cf1d80b1df2e68088dc6104959ba0d583d585e9578ab0aec0cf36c48435eb52ed9ab4bbce7a5abe679c97ae2dbe35e8cc1d45b06dda3cf418665c57cbee4bbb47fa4caf78f4ee656fec237fe4eebbafa206e1ef2bd0ee4ae71bd0e9b2f54f91daadf1febfd7032381d636b733dcb3bf76fb14e23aff1f68ed3dbcf75c9b99c6f26", "842fdb576b68979e7bcf01c09fdaa677c010b0620c3c28d34585e48b6d008f843a1bf7cdaeee6c195cfffba79c06cdc6d29a3f5a9b176b12dcb9a16c864e38b6");
        TestDigest.testKatHex(new BLAKE512(), "1594d74bf5dde444265d4c04dad9721ff3e34cbf622daf341fe16b96431f6c4df1f760d34f296eb97d98d560ad5286fec4dce1724f20b54fd7df51d4bf137add656c80546fb1bf516d62ee82baa992910ef4cc18b70f3f8698276fcfb44e0ec546c2c39cfd8ee91034ff9303058b4252462f86c823eb15bf481e6b79cc3a02218595b3658e8b37382bd5048eaed5fd02c37944e73b", "c99591d4a302e225e808e8e867f282bdefeb0b646c4a4a67ae21671e5e0295ae3d36b2bf67be61f0788c6f6b04de7d87e7a0f1ddbcae643216da7c236a6db552");
        TestDigest.testKatHex(new BLAKE512(), "4cfa1278903026f66fedd41374558be1b585d03c5c55dac94361df286d4bd39c7cb8037ed3b267b07c346626449d0cc5b0dd2cf221f7e4c3449a4be99985d2d5e67bff2923357ddeab5abcb4619f3a3a57b2cf928a022eb27676c6cf805689004fca4d41ea6c2d0a4789c7605f7bb838dd883b3ad3e6027e775bcf262881428099c7fff95b14c095ea130e0b9938a5e22fc52650f591", "68b73dbb73a4dac672d0a671aa75f44503775e6c7cfc24ff24aa59069acc76b311ea4107dde14e43476a32694bc8721e6f1cfcb0d48c7c9142ce8c7629fb1871");
        TestDigest.testKatHex(new BLAKE512(), "d3e65cb92cfa79662f6af493d696a07ccf32aaadcceff06e73e8d9f6f909209e66715d6e978788c49efb9087b170ecf3aa86d2d4d1a065ae0efc8924f365d676b3cb9e2bec918fd96d0b43dee83727c9a93bf56ca2b2e59adba85696546a815067fc7a78039629d4948d157e7b0d826d1bf8e81237bab7321312fdaa4d521744f988db6fdf04549d0fdca393d639c729af716e9c8bba48", "a5e52f7092358ea28b7841864c385aee154fa6fd57e287c8739f21e7abfecacb8a80353bca0ce57d7758d2e57e039c47923ed773c761ba5dd48c80cb64a40b36");
        TestDigest.testKatHex(new BLAKE512(), "842cc583504539622d7f71e7e31863a2b885c56a0ba62db4c2a3f2fd12e79660dc7205ca29a0dc0a87db4dc62ee47a41db36b9ddb3293b9ac4baae7df5c6e7201e17f717ab56e12cad476be49608ad2d50309e7d48d2d8de4fa58ac3cfeafeee48c0a9eec88498e3efc51f54d300d828dddccb9d0b06dd021a29cf5cb5b2506915beb8a11998b8b886e0f9b7a80e97d91a7d01270f9a7717", "662e3e3ca086b824a5ad6d5a3140e762883cb59ae30d0cdf318469d3c88b8ecec4bc486df0efaaacbc6dd883280ded821220ac7de63ac7e3e5f99c3e278e38fb");
        TestDigest.testKatHex(new BLAKE512(), "6c4b0a0719573e57248661e98febe326571f9a1ca813d3638531ae28b4860f23c3a3a8ac1c250034a660e2d71e16d3acc4bf9ce215c6f15b1c0fc7e77d3d27157e66da9ceec9258f8f2bf9e02b4ac93793dd6e29e307ede3695a0df63cbdc0fc66fb770813eb149ca2a916911bee4902c47c7802e69e405fe3c04ceb5522792a5503fa829f707272226621f7c488a7698c0d69aa561be9f378", "ff0adfd6619291a4f9444195da6297ffde314b0d5965d1ebaff3bc546e22cf39f25f2f47110183cfc5bf193849b84d944732542d1a2865f056094658eab57ad8");
        TestDigest.testKatHex(new BLAKE512(), "51b7dbb7ce2ffeb427a91ccfe5218fd40f9e0b7e24756d4c47cd55606008bdc27d16400933906fd9f30effdd4880022d081155342af3fb6cd53672ab7fb5b3a3bcbe47be1fd3a2278cae8a5fd61c1433f7d350675dd21803746cadca574130f01200024c6340ab0cc2cf74f2234669f34e9009ef2eb94823d62b31407f4ba46f1a1eec41641e84d77727b59e746b8a671bef936f05be820759fa", "ed4d69acfed5f5660f82573a17552ba7ac5169fd4953283fce1efd56ef4a132959e34725e6d26b1a3f6f8b5cf41cf55006a643f28890130f258cbfded292067e");
        TestDigest.testKatHex(new BLAKE512(), "83599d93f5561e821bd01a472386bc2ff4efbd4aed60d5821e84aae74d8071029810f5e286f8f17651cd27da07b1eb4382f754cd1c95268783ad09220f5502840370d494beb17124220f6afce91ec8a0f55231f9652433e5ce3489b727716cf4aeba7dcda20cd29aa9a859201253f948dd94395aba9e3852bd1d60dda7ae5dc045b283da006e1cbad83cc13292a315db5553305c628dd091146597", "656a7b7348440e8b2e2102302fa07972b2ae8ac7cf7bdacb53a27e6d2afa84f2bc01ff4d3bef02975d602586b5b757a791940839b628cf05fa712a79f1957c5d");
        TestDigest.testKatHex(new BLAKE512(), "2be9bf526c9d5a75d565dd11ef63b979d068659c7f026c08bea4af161d85a462d80e45040e91f4165c074c43ac661380311a8cbed59cc8e4c4518e80cd2c78ab1cabf66bff83eab3a80148550307310950d034a6286c93a1ece8929e6385c5e3bb6ea8a7c0fb6d6332e320e71cc4eb462a2a62e2bfe08f0ccad93e61bedb5dd0b786a728ab666f07e0576d189c92bf9fb20dca49ac2d3956d47385e2", "a8534a181579f4e2c528d6313854f0126ae744128460a05f17d13464f3445b27129815176fa4f9ecc9e569ed30abda86a4f7d0fdf4fffb4b60353dd67fa2bcea");
        TestDigest.testKatHex(new BLAKE512(), "ca76d3a12595a817682617006848675547d3e8f50c2210f9af906c0e7ce50b4460186fe70457a9e879e79fd4d1a688c70a347361c847ba0dd6aa52936eaf8e58a1be2f5c1c704e20146d366aeb3853bed9de9befe9569ac8aaea37a9fb7139a1a1a7d5c748605a8defb297869ebedd71d615a5da23496d11e11abbb126b206fa0a7797ee7de117986012d0362dcef775c2fe145ada6bda1ccb326bf644", "dff7595c4e729a6d9745a7a5b232cc32fac0d734e83e692a84f0c2c1a120960dad143c9096c1cfef0c52d17b26dc15e177dea13defe61bbe60f57c33200f368a");
        TestDigest.testKatHex(new BLAKE512(), "f76b85dc67421025d64e93096d1d712b7baf7fb001716f02d33b2160c2c882c310ef13a576b1c2d30ef8f78ef8d2f465007109aad93f74cb9e7d7bef7c9590e8af3b267c89c15db238138c45833c98cc4a471a7802723ef4c744a853cf80a0c2568dd4ed58a2c9644806f42104cee53628e5bdf7b63b0b338e931e31b87c24b146c6d040605567ceef5960df9e022cb469d4c787f4cba3c544a1ac91f95f", "1a9a95a7f6bcb220c7e2d53f94d37270d8440355c041a5e34db8e2f01a69e82edb04ad698e4ad475b9a9bd0594b7e3c93582575761da313148e6648672145ee4");
        TestDigest.testKatHex(new BLAKE512(), "25b8c9c032ea6bcd733ffc8718fbb2a503a4ea8f71dea1176189f694304f0ff68e862a8197b839957549ef243a5279fc2646bd4c009b6d1edebf24738197abb4c992f6b1dc9ba891f570879accd5a6b18691a93c7d0a8d38f95b639c1daeb48c4c2f15ccf5b9d508f8333c32de78781b41850f261b855c4bebcc125a380c54d501c5d3bd07e6b52102116088e53d76583b0161e2a58d0778f091206aabd5a1", "c06d042b67d109bc95b941b129bbc17ca007b158255544b80a01515e7a8c16a2651af9c4fc243a28425757e670ec39eae68d135e693892c057b5d2dd5176b88a");
        TestDigest.testKatHex(new BLAKE512(), "21cfdc2a7ccb7f331b3d2eefff37e48ad9fa9c788c3f3c200e0173d99963e1cbca93623b264e920394ae48bb4c3a5bb96ffbc8f0e53f30e22956adabc2765f57fb761e147ecbf8567533db6e50c8a1f894310a94edf806dd8ca6a0e141c0fa7c9fae6c6ae65f18c93a8529e6e5b553bf55f25be2e80a9882bd37f145fecbeb3d447a3c4e46c21524cc55cdd62f521ab92a8ba72b897996c49bb273198b7b1c9e", "de5597a4d2b83c84b010e8c967a99958ac9c4b5b3df2538e34e740f8a09253eecc718dcac488e738e1f788b7f00737279de979232e2875445eb3490a93aec036");
        TestDigest.testKatHex(new BLAKE512(), "4e452ba42127dcc956ef4f8f35dd68cb225fb73b5bc7e1ec5a898bba2931563e74faff3b67314f241ec49f4a7061e3bd0213ae826bab380f1f14faab8b0efddd5fd1bb49373853a08f30553d5a55ccbbb8153de4704f29ca2bdeef0419468e05dd51557ccc80c0a96190bbcc4d77ecff21c66bdf486459d427f986410f883a80a5bcc32c20f0478bb9a97a126fc5f95451e40f292a4614930d054c851acd019ccf", "409253c674428aebee16e5a85c72ca9af79437769dfac6526eff389a502eecb973c0dc19b07de4dade107365b9457c10966bcfbaa39d276c2435f7af85c21d0f");
        TestDigest.testKatHex(new BLAKE512(), "fa85671df7dadf99a6ffee97a3ab9991671f5629195049880497487867a6c446b60087fac9a0f2fcc8e3b24e97e42345b93b5f7d3691829d3f8ccd4bb36411b85fc2328eb0c51cb3151f70860ad3246ce0623a8dc8b3c49f958f8690f8e3860e71eb2b1479a5cea0b3f8befd87acaf5362435eaeccb52f38617bc6c5c2c6e269ead1fbd69e941d4ad2012da2c5b21bcfbf98e4a77ab2af1f3fda3233f046d38f1dc8", "85620f3e0c5d4fead6fb1fa1138be3ce14b3c71ab54c3b3caeea06dcfbf640ece675c5943deb7a3e422e840b9e183e5ba0dd68820f44d8d04ec465909e151d76");
        TestDigest.testKatHex(new BLAKE512(), "e90847ae6797fbc0b6b36d6e588c0a743d725788ca50b6d792352ea8294f5ba654a15366b8e1b288d84f5178240827975a763bc45c7b0430e8a559df4488505e009c63da994f1403f407958203cebb6e37d89c94a5eacf6039a327f6c4dbbc7a2a307d976aa39e41af6537243fc218dfa6ab4dd817b6a397df5ca69107a9198799ed248641b63b42cb4c29bfdd7975ac96edfc274ac562d0474c60347a078ce4c25e88", "3c3af58466d1e7b6d45ee4491558ff6b93f3e9c4b69e11f6377f7ca2d23ff672e2d4138e41738277392d6d50976c44737ce37c5d1d72fc4d8676ec75e35cb7bd");
        TestDigest.testKatHex(new BLAKE512(), "f6d5c2b6c93954fc627602c00c4ca9a7d3ed12b27173f0b2c9b0e4a5939398a665e67e69d0b12fb7e4ceb253e8083d1ceb724ac07f009f094e42f2d6f2129489e846eaff0700a8d4453ef453a3eddc18f408c77a83275617fabc4ea3a2833aa73406c0e966276079d38e8e38539a70e194cc5513aaa457c699383fd1900b1e72bdfb835d1fd321b37ba80549b078a49ea08152869a918ca57f5b54ed71e4fd3ac5c06729", "1c8062b81ea089bcf4f9c7db6b1ff7dfa6258ba4a74a4a600c2144649ef6fc84cb6b9d210d263a07596149d6efc8147b281d88efb3a44d0cd51f959e42d58e3b");
        TestDigest.testKatHex(new BLAKE512(), "cf8562b1bed89892d67ddaaf3deeb28246456e972326dbcdb5cf3fb289aca01e68da5d59896e3a6165358b071b304d6ab3d018944be5049d5e0e2bb819acf67a6006111089e6767132d72dd85beddcbb2d64496db0cc92955ab4c6234f1eea24f2d51483f2e209e4589bf9519fac51b4d061e801125e605f8093bb6997bc163d551596fe4ab7cfae8fb9a90f6980480ce0c229fd1675409bd788354daf316240cfe0af93eb", "d4ef9ab758062c85dc0288f8965e72db202d46a95f0d921a596859e6e059cfee2472a2eec20bb0138af94db5bcc2db4e4ece20f121c0254e823d4a0c8a328fb0");
        TestDigest.testKatHex(new BLAKE512(), "2ace31abb0a2e3267944d2f75e1559985db7354c6e605f18dc8470423fca30b7331d9b33c4a4326783d1caae1b4f07060eff978e4746bf0c7e30cd61040bd5ec2746b29863eb7f103ebda614c4291a805b6a4c8214230564a0557bc7102e0bd3ed23719252f7435d64d210ee2aafc585be903fa41e1968c50fd5d5367926df7a05e3a42cf07e656ff92de73b036cf8b19898c0cb34557c0c12c2d8b84e91181af467bc75a9d1", "0649b648793d57d0af7f64f33ab80659b3ad3cf235e9ca318e33fc2cdbc15246285b8345974be4505134cde3463f77727698d86d9d51ed3209cb27baba20d443");
        TestDigest.testKatHex(new BLAKE512(), "0d8d09aed19f1013969ce5e7eb92f83a209ae76be31c754844ea9116ceb39a22ebb6003017bbcf26555fa6624185187db8f0cb3564b8b1c06bf685d47f3286eda20b83358f599d2044bbf0583fab8d78f854fe0a596183230c5ef8e54426750eaf2cc4e29d3bdd037e734d863c2bd9789b4c243096138f7672c232314effdfc6513427e2da76916b5248933be312eb5dde4cf70804fb258ac5fb82d58d08177ac6f4756017fff5", "bca5efea79f5b84dae25e056bdc320142a6e5613818dfca03cfb74a1724956de6f7cf301f303c8972aa0c5b4b9e26ece3ddbea7e032d30e4ac71e722170d850c");
        TestDigest.testKatHex(new BLAKE512(), "c3236b73deb7662bf3f3daa58f137b358ba610560ef7455785a9befdb035a066e90704f929bd9689cef0ce3bda5acf4480bceb8d09d10b098ad8500d9b6071dfc3a14af6c77511d81e3aa8844986c3bea6f469f9e02194c92868cd5f51646256798ff0424954c1434bdfed9facb390b07d342e992936e0f88bfd0e884a0ddb679d0547ccdec6384285a45429d115ac7d235a717242021d1dc35641f5f0a48e8445dba58e6cb2c8ea", "ba3156299d1ed69713a079b0d1eaaedacccb1b3a22e88135b15f172fceae6195b62a05e3421ff093bd15c352df8e45ab554a3e968a4624a9f2f852d398f2bd7f");
        TestDigest.testKatHex(new BLAKE512(), "b39feb8283eadc63e8184b51df5ae3fd41aac8a963bb0be1cd08aa5867d8d910c669221e73243360646f6553d1ca05a84e8dc0de05b6419ec349ca994480193d01c92525f3fb3dcefb08afc6d26947bdbbfd85193f53b50609c6140905c53a6686b58e53a319a57b962331ede98149af3de3118a819da4d76706a0424b4e1d2910b0ed26af61d150ebcb46595d4266a0bd7f651ba47d0c7f179ca28545007d92e8419d48fdfbd744ce", "755f0b54ca4e68fe1f2449fa710d411156c281478dd409e457f497ccbadb6581b36eae605af93df89fd06ef47816a82d4da3e7f43f9e99217616bcab31789c4f");
        TestDigest.testKatHex(new BLAKE512(), "a983d54f503803e8c7999f4edbbe82e9084f422143a932ddddc47a17b0b7564a7f37a99d0786e99476428d29e29d3c197a72bfab1342c12a0fc4787fd7017d7a6174049ea43b5779169ef7472bdbbd941dcb82fc73aac45a8a94c9f2bd3477f61fd3b796f02a1b8264a214c6fea74b7051b226c722099ec7883a462b83b6afdd4009248b8a237f605fe5a08fe7d8b45321421ebba67bd70a0b00ddbf94baab7f359d5d1eea105f28dcfb", "716f0758627091c58c61bbba6aead3004f1f80f45217c584dfb8644071d289d4f2d393a96b41481a4007e01aeba15fec5dece066170ae2483d17c8bfb5244de1");
        TestDigest.testKatHex(new BLAKE512(), "e4d1c1897a0a866ce564635b74222f9696bf2c7f640dd78d7e2aca66e1b61c642bb03ea7536aae597811e9bf4a7b453ede31f97b46a5f0ef51a071a2b3918df16b152519ae3776f9f1edab4c2a377c3292e96408359d3613844d5eb393000283d5ad3401a318b12fd1474b8612f2bb50fb6a8b9e023a54d7dde28c43d6d8854c8d9d1155935c199811dbfc87e9e0072e90eb88681cc7529714f8fb8a2c9d88567adfb974ee205a9bf7b848", "ba0f029d0fd3e89bec451c97eaa51eeb368a9f96a93a7a51d6be93975ac71a70274158e5178e169b789d156fbd095db68459ab3a0ddbd659cba246d6c470d9e1");
        TestDigest.testKatHex(new BLAKE512(), "b10c59723e3dcadd6d75df87d0a1580e73133a9b7d00cb95ec19f5547027323be75158b11f80b6e142c6a78531886d9047b08e551e75e6261e79785366d7024bd7cd9cf322d9be7d57fb661069f2481c7bb759cd71b4b36ca2bc2df6d3a328faebdb995a9794a8d72155ed551a1f87c80bf6059b43fc764900b18a1c2441f7487743cf84e565f61f8dd2ece6b6ccc9444049197aaaf53e926fbee3bfca8be588ec77f29d211be89de18b15f6", "cf7f04f41b86defed622eed843425ae0e0b1eda9c3ceb0bdade2715a1fd5e6c44996e9d3baa083b1c0881b3bf4cccf942390b8548e8b804aee2c8ed2bb8b8759");
        TestDigest.testKatHex(new BLAKE512(), "db11f609baba7b0ca634926b1dd539c8cbada24967d7add4d9876f77c2d80c0f4dcefbd7121548373582705cca2495bd2a43716fe64ed26d059cfb566b3364bd49ee0717bdd9810dd14d8fad80dbbdc4cafb37cc60fb0fe2a80fb4541b8ca9d59dce457738a9d3d8f641af8c3fd6da162dc16fc01aac527a4a0255b4d231c0be50f44f0db0b713af03d968fe7f0f61ed0824c55c4b5265548febd6aad5c5eedf63efe793489c39b8fd29d104ce", "3e5bdc8a121624df2fb77bc0873bc572f1fa3457483c53cd6a1dc153cf534508586a7030b1b1ed453cea4c2f84b85a8b94c11355eae02cf08550dcfa7bde38a9");
        TestDigest.testKatHex(new BLAKE512(), "bebd4f1a84fc8b15e4452a54bd02d69e304b7f32616aadd90537937106ae4e28de9d8aab02d19bc3e2fde1d651559e296453e4dba94370a14dbbb2d1d4e2022302ee90e208321efcd8528ad89e46dc839ea9df618ea8394a6bff308e7726bae0c19bcd4be52da6258e2ef4e96aa21244429f49ef5cb486d7ff35cac1bacb7e95711944bccb2ab34700d42d1eb38b5d536b947348a458ede3dc6bd6ec547b1b0cae5b257be36a7124e1060c170ffa", "9a3388ef92ba591e66b0182d9064e9267dbec923f3c4d01d57bb770dd84e16a959c7c1599e4d20c3e01845319fca47c78d42629acf09c198fbcf32c4cec7de86");
        TestDigest.testKatHex(new BLAKE512(), "5aca56a03a13784bdc3289d9364f79e2a85c12276b49b92db0adaa4f206d5028f213f678c3510e111f9dc4c1c1f8b6acb17a6413aa227607c515c62a733817ba5e762cc6748e7e0d6872c984d723c9bb3b117eb8963185300a80bfa65cde495d70a46c44858605fccbed086c2b45cef963d33294dbe9706b13af22f1b7c4cd5a001cfec251fba18e722c6e1c4b1166918b4f6f48a98b64b3c07fc86a6b17a6d0480ab79d4e6415b520f1c484d675b1", "7b87482af3571a8a42f91b2e9dc57b3a5a8dc0d3528ad92c9eb8803cd0d1d86f8621775a20d6ff168ae1a76260ff05d0016251b7042dde6dc2454cfd805b9b53");
        TestDigest.testKatHex(new BLAKE512(), "a5aad0e4646a32c85cfcac73f02fc5300f1982fabb2f2179e28303e447854094cdfc854310e5c0f60993ceff54d84d6b46323d930adb07c17599b35b505f09e784bca5985e0172257797fb53649e2e9723efd16865c31b5c3d5113b58bb0bfc8920fabdda086d7537e66d709d050bd14d0c960873f156fad5b3d3840cdfcdc9be6af519db262a27f40896ab25cc39f96984d650611c0d5a3080d5b3a1bf186abd42956588b3b58cd948970d298776060", "f64a740fb876c1e8c99404a293ca54cdf016c84ba5f61b9015456f4763a66b9783be60a4c16dc518bb22fadca8841b5206adf3859ca533b24baec0718bb2a5ae");
        TestDigest.testKatHex(new BLAKE512(), "06cbbe67e94a978203ead6c057a1a5b098478b4b4cbef5a97e93c8e42f5572713575fc2a884531d7622f8f879387a859a80f10ef02708cd8f7413ab385afc357678b9578c0ebf641ef076a1a30f1f75379e9dcb2a885bdd295905ee80c0168a62a9597d10cf12dd2d8cee46645c7e5a141f6e0e23aa482abe5661c16e69ef1e28371e2e236c359ba4e92c25626a7b7ff13f6ea4ae906e1cfe163e91719b1f750a96cbde5fbc953d9e576cd216afc90323a", "e7b77c1746e0a03ea9f127468ecd884f0f21661e4b2acde0cf2c0798ca150042881f4dd40442e7735b937662cf471a131e86c25fb57da14a6a811b6192b8db4a");
        TestDigest.testKatHex(new BLAKE512(), "f1c528cf7739874707d4d8ad5b98f7c77169de0b57188df233b2dc8a5b31eda5db4291dd9f68e6bad37b8d7f6c9c0044b3bf74bbc3d7d1798e138709b0d75e7c593d3cccdc1b20c7174b4e692add820ace262d45ccfae2077e878796347168060a162ecca8c38c1a88350bd63bb539134f700fd4addd5959e255337daa06bc86358fabcbefdfb5bc889783d843c08aadc6c4f6c36f65f156e851c9a0f917e4a367b5ad93d874812a1de6a7b93cd53ad97232", "40666786204844ce3359577ed720e5249e56a021fadcefbf630949cabaf730d1f9a0741f9585af035ed06b21ebd314093d9bbe1ca8da5298c0fabe46e1050338");
        TestDigest.testKatHex(new BLAKE512(), "9d9f3a7ecd51b41f6572fd0d0881e30390dfb780991dae7db3b47619134718e6f987810e542619dfaa7b505c76b7350c6432d8bf1cfebdf1069b90a35f0d04cbdf130b0dfc7875f4a4e62cdb8e525aadd7ce842520a482ac18f09442d78305fe85a74e39e760a4837482ed2f437dd13b2ec1042afcf9decdc3e877e50ff4106ad10a525230d11920324a81094da31deab6476aa42f20c84843cfc1c58545ee80352bdd3740dd6a16792ae2d86f11641bb717c2", "e5bd057c96c9348223a2464db7d778049177c6191e4359e992051047265b7c5723d605f5d5ecd01a0d3538934db2da8a88dde94cd57823d00d72091a423dde23");
        TestDigest.testKatHex(new BLAKE512(), "5179888724819fbad3afa927d3577796660e6a81c52d98e9303261d5a4a83232f6f758934d50aa83ff9e20a5926dfebaac49529d006eb923c5ae5048ed544ec471ed7191edf46363383824f915769b3e688094c682b02151e5ee01e510b431c8865aff8b6b6f2f59cb6d129da79e97c6d2b8fa6c6da3f603199d2d1bcab547682a81cd6cf65f6551121391d78bcc23b5bd0e922ec6d8bf97c952e84dd28aef909aba31edb903b28fbfc33b7703cd996215a11238", "565f299e5643c6541965de447e6b5abdffaccd5bcd151a40f0fd882206d7d8690933975904e54f3c7f040d0af87da562959cb4d25ba390f958eb80dbe884ab46");
        TestDigest.testKatHex(new BLAKE512(), "576ef3520d30b7a4899b8c0d5e359e45c5189add100e43be429a02fb3de5ff4f8fd0e79d9663acca72cd29c94582b19292a557c5b1315297d168fbb54e9e2ecd13809c2b5fce998edc6570545e1499dbe7fb74d47cd7f35823b212b05bf3f5a79caa34224fdd670d335fcb106f5d92c3946f44d3afcbae2e41ac554d8e6759f332b76be89a0324aa12c5482d1ea3ee89ded4936f3e3c080436f539fa137e74c6d3389bdf5a45074c47bc7b20b0948407a66d855e2f", "8504fd534797a5ca5da31c37ba41f728b3b37a76242d3add44517ea8d06405d12b2eec1f8daa6dddbb46d6649b1c7a1ad575412f05faddbec83d5b122dccad24");
        TestDigest.testKatHex(new BLAKE512(), "0df2152fa4f4357c8741529dd77e783925d3d76e95bafa2b542a2c33f3d1d117d159cf473f82310356fee4c90a9e505e70f8f24859656368ba09381fa245eb6c3d763f3093f0c89b972e66b53d59406d9f01aea07f8b3b615cac4ee4d05f542e7d0dab45d67ccccd3a606ccbeb31ea1fa7005ba07176e60dab7d78f6810ef086f42f08e595f0ec217372b98970cc6321576d92ce38f7c397a403bada1548d205c343ac09deca86325373c3b76d9f32028fea8eb32515", "79d705406cace2a0fc74526d698e3c7deae5442466c3e6a1ae505d2560277bc7978fbdd09e7d50c262c1b915a39d55c0d83de6de9243b4663cffc2173dd48bfc");
        TestDigest.testKatHex(new BLAKE512(), "3e15350d87d6ebb5c8ad99d42515cfe17980933c7a8f6b8bbbf0a63728cefaad2052623c0bd5931839112a48633fb3c2004e0749c87a41b26a8b48945539d1ff41a4b269462fd199bfecd45374756f55a9116e92093ac99451aefb2af9fd32d6d7f5fbc7f7a540d5097c096ebc3b3a721541de073a1cc02f7fb0fb1b9327fb0b1218ca49c9487ab5396622a13ae546c97abdef6b56380dda7012a8384091b6656d0ab272d363cea78163ff765cdd13ab1738b940d16cae", "fe511e4fc147d8bc8a3650900042dcf7981e6fdf13dc51931eabc9c81a6ec41d0de0ad3fc68ad20ff6a1ecd32ec106a5ae3e12560552f9081a8c130c79497d5c");
        TestDigest.testKatHex(new BLAKE512(), "c38d6b0b757cb552be40940ece0009ef3b0b59307c1451686f1a22702922800d58bce7a636c1727ee547c01b214779e898fc0e560f8ae7f61bef4d75eaa696b921fd6b735d171535e9edd267c192b99880c87997711002009095d8a7a437e258104a41a505e5ef71e5613ddd2008195f0c574e6ba3fe40099cfa116e5f1a2fa8a6da04badcb4e2d5d0de31fdc4800891c45781a0aac7c907b56d631fca5ce8b2cde620d11d1777ed9fa603541de794ddc5758fcd5fad78c0", "c774aebcfe6feab775ad08bb9ffa2f19d1c5e0ef9882d7bddafe633b1193f7f64fbd0de77bc7ee041751ed4bd0d8bdb951156e401ed21f0eda79b31d9d19861f");
        TestDigest.testKatHex(new BLAKE512(), "8d2de3f0b37a6385c90739805b170057f091cd0c7a0bc951540f26a5a75b3e694631bb64c7635eed316f51318e9d8de13c70a2aba04a14836855f35e480528b776d0a1e8a23b547c8b8d6a0d09b241d3be9377160cca4e6793d00a515dc2992cb7fc741daca171431da99cce6f7789f129e2ac5cf65b40d703035cd2185bb936c82002daf8cbc27a7a9e554b06196630446a6f0a14ba155ed26d95bd627b7205c072d02b60db0fd7e49ea058c2e0ba202daff0de91e845cf79", "bf2dc1cc03ff73f5e63c06eea00634d326ff9a2b754858eccb5f9b27f29762c83325f3cee5e587a7770b55c8a12d8a8d6883b93df799def00d3f8557ccea59b4");
        TestDigest.testKatHex(new BLAKE512(), "c464bbdad275c50dcd983b65ad1019b9ff85a1e71c807f3204bb2c921dc31fbcd8c5fc45868ae9ef85b6c9b83bba2a5a822201ed68586ec5ec27fb2857a5d1a2d09d09115f22dcc39fe61f5e1ba0ff6e8b4acb4c6da748be7f3f0839739394ff7fa8e39f7f7e84a33c3866875c01bcb1263c9405d91908e9e0b50e7459fabb63d8c6bbb73d8e3483c099b55bc30ff092ff68b6adedfd477d63570c9f5515847f36e24ba0b705557130cec57ebad1d0b31a378e91894ee26e3a04", "d66dea1758eaee530f5625b1dfc8f89456076b8d851fbd91ee197468aba5fcb9e4920a2258a3400e3b0f27537c1d4c892cb87c85d7bcf92015628c168bf6265e");
        TestDigest.testKatHex(new BLAKE512(), "8b8d68bb8a75732fe272815a68a1c9c5aa31b41dedc8493e76525d1d013d33cebd9e21a5bb95db2616976a8c07fcf411f5f6bc6f7e0b57aca78cc2790a6f9b898858ac9c79b165ff24e66677531e39f572be5d81eb3264524181115f32780257bfb9aeec6af12af28e587cac068a1a2953b59ad680f4c245b2e3ec36f59940d37e1d3db38e13edb29b5c0f404f6ff87f80fc8be7a225ff22fbb9c8b6b1d7330c57840d24bc75b06b80d30dad6806544d510af6c4785e823ac3e0b8", "80ec8f624ba097c737739875f4dd86e274a246529b051cbe151cbc34a9529e3f49ff596ca3805f3994c6a53996a8ff70218880f86cb0298cada7ea684dbdedd3");
        TestDigest.testKatHex(new BLAKE512(), "6b018710446f368e7421f1bc0ccf562d9c1843846bc8d98d1c9bf7d9d6fcb48bfc3bf83b36d44c4fa93430af75cd190bde36a7f92f867f58a803900df8018150384d85d82132f123006ac2aeba58e02a037fe6afbd65eca7c44977dd3dc74f48b6e7a1bfd5cc4dcf24e4d52e92bd4455848e4928b0eac8b7476fe3cc03e862aa4dff4470dbfed6de48e410f25096487ecfc32a27277f3f5023b2725ade461b1355889554a8836c9cf53bd767f5737d55184eea1ab3f53edd0976c485", "6a535653fa2e1e90d3de5b1c4d319eb607ffc57fd373fc3a9dbe98b458992f478ab8534ca94f202b2ab344493b210379f39dfe4fe6825dc57fd380d553a0f1bc");
        TestDigest.testKatHex(new BLAKE512(), "c9534a24714bd4be37c88a3da1082eda7cabd154c309d7bd670dccd95aa535594463058a29f79031d6ecaa9f675d1211e9359be82669a79c855ea8d89dd38c2c761ddd0ec0ce9e97597432e9a1beae062cdd71edfdfd464119be9e69d18a7a7fd7ce0e2106f0c8b0abf4715e2ca48ef9f454dc203c96656653b727083513f8efb86e49c513bb758b3b052fe21f1c05bb33c37129d6cc81f1aef6adc45b0e8827a830fe545cf57d0955802c117d23ccb55ea28f95c0d8c2f9c5a242b33f", "44ae1a8868accba99c4849e3494905aadb383818d82a3d9b06c17c049fd489e68ace4c4861988f0c3fff4df9915e34668fe8b1f7a46e8e4207162a54c7e4c7f8");
        TestDigest.testKatHex(new BLAKE512(), "07906c87297b867abf4576e9f3cc7f82f22b154afcbf293b9319f1b0584da6a40c27b32e0b1b7f412c4f1b82480e70a9235b12ec27090a5a33175a2bb28d8adc475cefe33f7803f8ce27967217381f02e67a3b4f84a71f1c5228e0c2ad971373f6f672624fcea8d1a9f85170fad30fa0bbd25035c3b41a6175d467998bd1215f6f3866f53847f9cf68ef3e2fbb54bc994de2302b829c5eea68ec441fcbafd7d16ae4fe9fff98bf00e5bc2ad54dd91ff9fda4dd77b6c754a91955d1fbaad0", "1ecaa6004020d5f70f1572ea2c14eb22f54538f7c29fa57b2f127539db2cbc34623acc35f49f5a4f4c2f948b104b383da5b7e999d22dd535ba3e42d76a7e1f62");
        TestDigest.testKatHex(new BLAKE512(), "588e94b9054abc2189df69b8ba34341b77cdd528e7860e5defcaa79b0c9a452ad4b82aa306be84536eb7cedcbe058d7b84a6aef826b028b8a0271b69ac3605a9635ea9f5ea0aa700f3eb7835bc54611b922964300c953efe7491e3677c2cebe0822e956cd16433b02c68c4a23252c3f9e151a416b4963257b783e038f6b4d5c9f110f871652c7a649a7bcedcbccc6f2d0725bb903cc196ba76c76aa9f10a190b1d1168993baa9ffc96a1655216773458bec72b0e39c9f2c121378feab4e76a", "44c3022ee9c021cd36ca6a41f2c90282ddee53efb130d39c563b3952a352a01c1e7da713fde70abdf79830b1abd2f2af9be6b8ac1b3691db680c0f5824793a41");
        TestDigest.testKatHex(new BLAKE512(), "08959a7e4baae874928813364071194e2939772f20db7c3157078987c557c2a6d5abe68d520eef3dc491692e1e21bcd880adebf63bb4213b50897fa005256ed41b5690f78f52855c8d9168a4b666fce2da2b456d7a7e7c17ab5f2fb1ee90b79e698712e963715983fd07641ae4b4e9dc73203fac1ae11fa1f8c7941fcc82eab247addb56e2638447e9d609e610b60ce086656aaebf1da3c8a231d7d94e2fd0afe46b391ff14a72eaeb3f44ad4df85866def43d4781a0b3578bc996c87970b132", "aa9d335f77683d89c0a06e4d9584198672ebe7c6eb7efcd4433927afb39b448207185297153ecf1423e9e63e132c6bc49e6e8610b4331271912b7dd4715d53d3");
        TestDigest.testKatHex(new BLAKE512(), "cb2a234f45e2ecd5863895a451d389a369aab99cfef0d5c9ffca1e6e63f763b5c14fb9b478313c8e8c0efeb3ac9500cf5fd93791b789e67eac12fd038e2547cc8e0fc9db591f33a1e4907c64a922dda23ec9827310b306098554a4a78f050262db5b545b159e1ff1dca6eb734b872343b842c57eafcfda8405eedbb48ef32e99696d135979235c3a05364e371c2d76f1902f1d83146df9495c0a6c57d7bf9ee77e80f9787aee27be1fe126cdc9ef893a4a7dcbbc367e40fe4e1ee90b42ea25af01", "18ff6302c39711b029e6f838007d56ac569993cc713dc71d932e4e5fd78c845eb9c79b4d9a21a3add3867611bb217179c93938bcfc7d06af3a67319dca2061ed");
        TestDigest.testKatHex(new BLAKE512(), "d16beadf02ab1d4dc6f88b8c4554c51e866df830b89c06e786a5f8757e8909310af51c840efe8d20b35331f4355d80f73295974653ddd620cdde4730fb6c8d0d2dcb2b45d92d4fbdb567c0a3e86bd1a8a795af26fbf29fc6c65941cddb090ff7cd230ac5268ab4606fccba9eded0a2b5d014ee0c34f0b2881ac036e24e151be89eeb6cd9a7a790afccff234d7cb11b99ebf58cd0c589f20bdac4f9f0e28f75e3e04e5b3debce607a496d848d67fa7b49132c71b878fd5557e082a18eca1fbda94d4b", "45ebe0bbad30bb4d921aff04084cfe0e4fe2b93af11d83fd5c3e25cdfe6900c25f4fc4bfbf7a82277005cf280e3f4890731da9066e6185227493d314f1d03dd6");
        TestDigest.testKatHex(new BLAKE512(), "8f65f6bc59a85705016e2bae7fe57980de3127e5ab275f573d334f73f8603106ec3553016608ef2dd6e69b24be0b7113bf6a760ba6e9ce1c48f9e186012cf96a1d4849d75df5bb8315387fd78e9e153e76f8ba7ec6c8849810f59fb4bb9b004318210b37f1299526866f44059e017e22e96cbe418699d014c6ea01c9f0038b10299884dbec3199bb05adc94e955a1533219c1115fed0e5f21228b071f40dd57c4240d98d37b73e412fe0fa4703120d7c0c67972ed233e5deb300a22605472fa3a3ba86", "94c5cbca6a5d947799636cf8c4418535686a909fef68fb7406539eee6a84a6274c723bc6e2e1d3a67ec4fc8f63453acf5931af87d865855f089aef6c918c6dc6");
        TestDigest.testKatHex(new BLAKE512(), "84891e52e0d451813210c3fd635b39a03a6b7a7317b221a7abc270dfa946c42669aacbbbdf801e1584f330e28c729847ea14152bd637b3d0f2b38b4bd5bf9c791c58806281103a3eabbaede5e711e539e6a8b2cf297cf351c078b4fa8f7f35cf61bebf8814bf248a01d41e86c5715ea40c63f7375379a7eb1d78f27622fb468ab784aaaba4e534a6dfd1df6fa15511341e725ed2e87f98737ccb7b6a6dfae416477472b046bf1811187d151bfa9f7b2bf9acdb23a3be507cdf14cfdf517d2cb5fb9e4ab6", "7dd38f9b6ecbe0e734239f6158ce287f49f950fb191b0635a3a3c643205d59c2a8ab435893fea5c82b7e73ed0f7739c124f9cbda5d807a6410e03d2eedd7e0ed");
        TestDigest.testKatHex(new BLAKE512(), "fdd7a9433a3b4afabd7a3a5e3457e56debf78e84b7a0b0ca0e8c6d53bd0c2dae31b2700c6128334f43981be3b213b1d7a118d59c7e6b6493a86f866a1635c12859cfb9ad17460a77b4522a5c1883c3d6acc86e6162667ec414e9a104aa892053a2b1d72165a855bacd8faf8034a5dd9b716f47a0818c09bb6baf22aa503c06b4ca261f557761989d2afbd88b6a678ad128af68672107d0f1fc73c5ca740459297b3292b281e93bceb761bde7221c3a55708e5ec84472cddcaa84ecf23723cc0991355c6280", "c4fe52c611f369f99388634dd9aded9f2ef2400521453a44c4f972213d3f6d67811d13aa1effc5c464242662b47251044b24f6b618a502eccfd70f2a830637e2");
        TestDigest.testKatHex(new BLAKE512(), "70a40bfbef92277a1aad72f6b79d0177197c4ebd432668cfec05d099accb651062b5dff156c0b27336687a94b26679cfdd9daf7ad204338dd9c4d14114033a5c225bd11f217b5f4732da167ee3f939262d4043fc9cba92303b7b5e96aea12adda64859df4b86e9ee0b58e39091e6b188b408ac94e1294a8911245ee361e60e601eff58d1d37639f3753bec80ebb4efde25817436076623fc65415fe51d1b0280366d12c554d86743f3c3b6572e400361a60726131441ba493a83fbe9afda90f7af1ae717238d", "7bbc0adbc558e55b3f733f952a1d3d842fa104ebc3057cdd4f970ff05e508def2116c225f44007197ea1fce49fb59fb55ebf61f5265187de3f3752c7c828e5f5");
        TestDigest.testKatHex(new BLAKE512(), "74356e449f4bf8644f77b14f4d67cb6bd9c1f5ae357621d5b8147e562b65c66585caf2e491b48529a01a34d226d436959153815380d5689e30b35357cdac6e08d3f2b0e88e200600d62bd9f5eaf488df86a4470ea227006182e44809009868c4c280c43d7d64a5268fa719074960087b3a6abc837882f882c837834535929389a12b2c78187e2ea07ef8b8eef27dc85002c3ae35f1a50bee6a1c48ba7e175f3316670b27983472aa6a61eed0a683a39ee323080620ea44a9f74411ae5ce99030528f9ab49c79f2", "6f08eabbfce4fa5fe21f09ce980986d0ff53ab1f82ede5faa6d4449bf0eceb6b45c4a11329da4395d9d501bea01084a01a26c91de7317dafb92aba3e445c0617");
        TestDigest.testKatHex(new BLAKE512(), "8c3798e51bc68482d7337d3abb75dc9ffe860714a9ad73551e120059860dde24ab87327222b64cf774415a70f724cdf270de3fe47dda07b61c9ef2a3551f45a5584860248fabde676e1cd75f6355aa3eaeabe3b51dc813d9fb2eaa4f0f1d9f834d7cad9c7c695ae84b329385bc0bef895b9f1edf44a03d4b410cc23a79a6b62e4f346a5e8dd851c2857995ddbf5b2d717aeb847310e1f6a46ac3d26a7f9b44985af656d2b7c9406e8a9e8f47dcb4ef6b83caacf9aefb6118bfcff7e44bef6937ebddc89186839b77", "52c9d570ccc1bffdb286a0aa89cc7ced7cc564f30179ead16b81212236c791ed2cf5249301285286668599007ce5e2180bd1e1cf956f19390de16324546acfec");
        TestDigest.testKatHex(new BLAKE512(), "fa56bf730c4f8395875189c10c4fb251605757a8fecc31f9737e3c2503b02608e6731e85d7a38393c67de516b85304824bfb135e33bf22b3a23b913bf6acd2b7ab85198b8187b2bcd454d5e3318cacb32fd6261c31ae7f6c54ef6a7a2a4c9f3ecb81ce3555d4f0ad466dd4c108a90399d70041997c3b25345a9653f3c9a6711ab1b91d6a9d2216442da2c973cbd685ee7643bfd77327a2f7ae9cb283620a08716dfb462e5c1d65432ca9d56a90e811443cd1ecb8f0de179c9cb48ba4f6fec360c66f252f6e64edc96b", "0222ff6fa48ca9056d3596fa7b3ad0c39c1945ddd9a72a6e9e2058bc31d07e1dc4caa193d3a71b064df636680c1133102d1f38fbdf1c8ccfe39e6ae5be9ddd45");
        TestDigest.testKatHex(new BLAKE512(), "b6134f9c3e91dd8000740d009dd806240811d51ab1546a974bcb18d344642baa5cd5903af84d58ec5ba17301d5ec0f10ccd0509cbb3fd3fff9172d193af0f782252fd1338c7244d40e0e42362275b22d01c4c3389f19dd69bdf958ebe28e31a4ffe2b5f18a87831cfb7095f58a87c9fa21db72ba269379b2dc2384b3da953c7925761fed324620acea435e52b424a7723f6a2357374157a34cd8252351c25a1b232826cefe1bd3e70ffc15a31e7c0598219d7f00436294d11891b82497bc78aa5363892a2495df8c1eef", "ebfedf780cad7c64f36cf0e65c209263daafce82ba4a69de080cf7924d1cc70038a0bdbfc5ff30d9bfc3969fe83aeb20fc6c3b4ec3b080baf8a6e4fb4f36dc93");
        TestDigest.testKatHex(new BLAKE512(), "c941cdb9c28ab0a791f2e5c8e8bb52850626aa89205bec3a7e22682313d198b1fa33fc7295381354858758ae6c8ec6fac3245c6e454d16fa2f51c4166fab51df272858f2d603770c40987f64442d487af49cd5c3991ce858ea2a60dab6a65a34414965933973ac2457089e359160b7cdedc42f29e10a91921785f6b7224ee0b349393cdcff6151b50b377d609559923d0984cda6000829b916ab6896693ef6a2199b3c22f7dc5500a15b8258420e314c222bc000bc4e5413e6dd82c993f8330f5c6d1be4bc79f08a1a0a46", "8dd938109b2d25c92f4d31ca6fead90f345a50ab137f7954e834052793c3cc3925a5a118759c01020f6172992ece8b95515dd0cda5585ceccee08c4695cf9b48");
        TestDigest.testKatHex(new BLAKE512(), "4499efffac4bcea52747efd1e4f20b73e48758be915c88a1ffe5299b0b005837a46b2f20a9cb3c6e64a9e3c564a27c0f1c6ad1960373036ec5bfe1a8fc6a435c2185ed0f114c50e8b3e4c7ed96b06a036819c9463e864a58d6286f785e32a804443a56af0b4df6abc57ed5c2b185ddee8489ea080deeee66aa33c2e6dab36251c402682b6824821f998c32163164298e1fafd31babbcffb594c91888c6219079d907fdb438ed89529d6d96212fd55abe20399dbefd342248507436931cdead496eb6e4a80358acc78647d043", "23af776f4ff1f7e2829076c31e6cead89abe313ab876a14b15aa6f4943eeb7bb1bdbb4a8ecc1ffca27b398f9cd595f13805a4c3040be9c43f52f94eccaae90ef");
        TestDigest.testKatHex(new BLAKE512(), "eecbb8fdfa4da62170fd06727f697d81f83f601ff61e478105d3cb7502f2c89bf3e8f56edd469d049807a38882a7eefbc85fc9a950952e9fa84b8afebd3ce782d4da598002827b1eb98882ea1f0a8f7aa9ce013a6e9bc462fb66c8d4a18da21401e1b93356eb12f3725b6db1684f2300a98b9a119e5d27ff704affb618e12708e77e6e5f34139a5a41131fd1d6336c272a8fc37080f041c71341bee6ab550cb4a20a6ddb6a8e0299f2b14bc730c54b8b1c1c487b494bdccfd3a53535ab2f231590bf2c4062fd2ad58f906a2d0d", "9f7b5a338c1a03e8ed275296d8bfac93824545f3b87dde8eae6fb516e34e96642480b062d1be58fd0365371e1d9ac4815b07bcebed33a7dd4c5d3774d24f83b4");
        TestDigest.testKatHex(new BLAKE512(), "e64f3e4ace5c8418d65fec2bc5d2a303dd458034736e3b0df719098be7a206deaf52d6ba82316caf330ef852375188cde2b39cc94aa449578a7e2a8e3f5a9d68e816b8d16889fbc0ebf0939d04f63033ae9ae2bdab73b88c26d6bd25ee460ee1ef58fb0afa92cc539f8c76d3d097e7a6a63ebb9b5887edf3cf076028c5bbd5b9db3211371ad3fe121d4e9bf44229f4e1ecf5a0f9f0eba4d5ceb72878ab22c3f0eb5a625323ac66f7061f4a81fac834471e0c59553f108475fe290d43e6a055ae3ee46fb67422f814a68c4be3e8c9", "fb51de4751a6ce74db00b579367c5ca14e41af631ba3db0f81ce936c680456d591e60b2bc089533e3cdfb5318497d4b1645af8f1b17425d7feb3c1bcf474dc7d");
        TestDigest.testKatHex(new BLAKE512(), "d2cb2d733033f9e91395312808383cc4f0ca974e87ec68400d52e96b3fa6984ac58d9ad0938dde5a973008d818c49607d9de2284e7618f1b8aed8372fbd52ed54557af4220fac09dfa8443011699b97d743f8f2b1aef3537ebb45dcc9e13dfb438428ee190a4efdb3caeb7f3933117bf63abdc7e57beb4171c7e1ad260ab0587806c4d137b6316b50abc9cce0dff3acada47bbb86be777e617bbe578ff4519844db360e0a96c6701290e76bb95d26f0f804c8a4f2717eac4e7de9f2cff3bbc55a17e776c0d02856032a6cd10ad2838", "a84964aedc48ffa6a8f2f8be2a58d7194042c571c21d8a3da9966dae0ad0f3e0024646647e8528e6e9ebc6535b7ccba3dbe29a077a9914cb5d0a58f220c2643f");
        TestDigest.testKatHex(new BLAKE512(), "f2998955613dd414cc111df5ce30a995bb792e260b0e37a5b1d942fe90171a4ac2f66d4928d7ad377f4d0554cbf4c523d21f6e5f379d6f4b028cdcb9b1758d3b39663242ff3cb6ede6a36a6f05db3bc41e0d861b384b6dec58bb096d0a422fd542df175e1be1571fb52ae66f2d86a2f6824a8cfaacbac4a7492ad0433eeb15454af8f312b3b2a577750e3efbd370e8a8cac1582581971fba3ba4bd0d76e718dacf8433d33a59d287f8cc92234e7a271041b526e389efb0e40b6a18b3aaf658e82ed1c78631fd23b4c3eb27c3faec8685", "c6bf55ba3524b554f2db6e0ea59bc5a87eeba0682016cb1f10e74dd9946e0f17f6cc280e187a2e6e0cea616f900ba528a78145f3409382f5ecab3440bf79ae6d");
        TestDigest.testKatHex(new BLAKE512(), "447797e2899b72a356ba55bf4df3acca6cdb1041eb477bd1834a9f9acbc340a294d729f2f97df3a610be0ff15edb9c6d5db41644b9874360140fc64f52aa03f0286c8a640670067a84e017926a70438db1bb361defee7317021425f8821def26d1efd77fc853b818545d055adc9284796e583c76e6fe74c9ac2587aa46aa8f8804f2feb5836cc4b3ababab8429a5783e17d5999f32242eb59ef30cd7adabc16d72dbdb097623047c98989f88d14eaf02a7212be16ec2d07981aaa99949ddf89ecd90333a77bc4e1988a82abf7c7caf3291", "e73dc851654f730a1c6f20cd63cbe5a58eeb9b0dd9a81b55e1a7ea0c674b3c769162e706e5d0fef12688e665ad6cd7b9478cb74f4f1793fbf776c42b24bab093");
        TestDigest.testKatHex(new BLAKE512(), "9f2c18ade9b380c784e170fb763e9aa205f64303067eb1bcea93df5dac4bf5a2e00b78195f808df24fc76e26cb7be31dc35f0844cded1567bba29858cffc97fb29010331b01d6a3fb3159cc1b973d255da9843e34a0a4061cabdb9ed37f241bfabb3c20d32743f4026b59a4ccc385a2301f83c0b0a190b0f2d01acb8f0d41111e10f2f4e149379275599a52dc089b35fdd5234b0cfb7b6d8aebd563ca1fa653c5c021dfd6f5920e6f18bfafdbecbf0ab00281333ed50b9a999549c1c8f8c63d7626c48322e9791d5ff72294049bde91e73f8", "fc0ec0cdafada3f2c6ad8fb5481ca7d872475fafa286b4328b6c792b2bc2d8c618fb015d8a1d4b22c0da015dafc0632573784d1f22a20144dc9efa841385114b");
        TestDigest.testKatHex(new BLAKE512(), "ae159f3fa33619002ae6bcce8cbbdd7d28e5ed9d61534595c4c9f43c402a9bb31f3b301cbfd4a43ce4c24cd5c9849cc6259eca90e2a79e01ffbac07ba0e147fa42676a1d668570e0396387b5bcd599e8e66aaed1b8a191c5a47547f61373021fa6deadcb55363d233c24440f2c73dbb519f7c9fa5a8962efd5f6252c0407f190dfefad707f3c7007d69ff36b8489a5b6b7c557e79dd4f50c06511f599f56c896b35c917b63ba35c6ff8092baf7d1658e77fc95d8a6a43eeb4c01f33f03877f92774be89c1114dd531c011e53a34dc248a2f0e6", "16e4521fdf0157ae62e3f50c93868e364018b0b0e068de0bddbe2847ce4672531ebdde4bb9bb74f41470e10d930aa14dc15cf10ee39360f99e06dc3f7e7a5bf8");
        TestDigest.testKatHex(new BLAKE512(), "3b8e97c5ffc2d6a40fa7de7fcefc90f3b12c940e7ab415321e29ee692dfac799b009c99dcddb708fce5a178c5c35ee2b8617143edc4c40b4d313661f49abdd93cea79d117518805496fe6acf292c4c2a1f76b403a97d7c399daf85b46ad84e16246c67d6836757bde336c290d5d401e6c1386ab32797af6bb251e9b2d8fe754c47482b72e0b394eab76916126fd68ea7d65eb93d59f5b4c5ac40f7c3b37e7f3694f29424c24af8c8f0ef59cd9dbf1d28e0e10f799a6f78cad1d45b9db3d7dee4a7059abe99182714983b9c9d44d7f5643596d4f3", "39f76a3b0e98af019cdaa4fa5fce94195c063c9e16ce6370e1936fc792ebd9e28b0e0445bff1a826cc4444589cd161d0395478a6d23d8385b271eb3a152c745f");
        TestDigest.testKatHex(new BLAKE512(), "3434ec31b10fafdbfeec0dd6bd94e80f7ba9dca19ef075f7eb017512af66d6a4bcf7d16ba0819a1892a6372f9b35bcc7ca8155ee19e8428bc22d214856ed5fa9374c3c09bde169602cc219679f65a1566fc7316f4cc3b631a18fb4449fa6afa16a3db2bc4212eff539c67cf184680826535589c7111d73bffce431b4c40492e763d9279560aaa38eb2dc14a212d723f994a1fe656ff4dd14551ce4e7c621b2aa5604a10001b2878a897a28a08095c325e10a26d2fb1a75bfd64c250309bb55a44f23bbac0d5516a1c687d3b41ef2fbbf9cc56d4739", "2df488ccb009f0061f22048088ae033ae3a97d17c766957db64e05638c437c8b2d0c6eef99b076d7fa203ea788d0871259f7462fa2c989ef06a00948d4de09ff");
        TestDigest.testKatHex(new BLAKE512(), "7c7953d81c8d208fd1c97681d48f49dd003456de60475b84070ef4847c333b74575b1fc8d2a186964485a3b8634feaa3595aaa1a2f4595a7d6b6153563dee31bbac443c8a33eed6d5d956a980a68366c2527b550ee950250dfb691eacbd5d56ae14b970668be174c89df2fea43ae52f13142639c884fd62a3683c0c3792f0f24ab1318bcb27e21f4737fab62c77ea38bc8fd1cf41f7dab64c13febe7152bf5bb7ab5a78f5346d43cc741cb6f72b7b8980f268b68bf62abdfb1577a52438fe14b591498cc95f071228460c7c5d5ceb4a7bde588e7f21c", "b5a49d8fc447135282136155c74e621595e380e3ce0d1bbbffdc246db36be9efdae5b18a9fd964623b0c7a0574ff768b3bc398b1957331252a1a8b2ed64da7ff");
        TestDigest.testKatHex(new BLAKE512(), "7a6a4f4fdc59a1d223381ae5af498d74b7252ecf59e389e49130c7eaee626e7bd9897effd92017f4ccde66b0440462cdedfd352d8153e6a4c8d7a0812f701cc737b5178c2556f07111200eb627dbc299caa792dfa58f35935299fa3a3519e9b03166dffa159103ffa35e8577f7c0a86c6b46fe13db8e2cdd9dcfba85bdddcce0a7a8e155f81f712d8e9fe646153d3d22c811bd39f830433b2213dd46301941b59293fd0a33e2b63adbd95239bc01315c46fdb678875b3c81e053a40f581cfbec24a1404b1671a1b88a6d06120229518fb13a74ca0ac5ae", "46e18dd6793d1413dd4e8d3fdd2f84572a9b9d93be61971d10c5d04e498f3b198f38169c20dadf5c217786d511c109fc51037ae154dac394cfd4ae619d529e69");
        TestDigest.testKatHex(new BLAKE512(), "d9faa14cebe9b7de551b6c0765409a33938562013b5e8e0e1e0a6418df7399d0a6a771fb81c3ca9bd3bb8e2951b0bc792525a294ebd1083688806fe5e7f1e17fd4e3a41d00c89e8fcf4a363caedb1acb558e3d562f1302b3d83bb886ed27b76033798131dab05b4217381eaaa7ba15ec820bb5c13b516dd640eaec5a27d05fdfca0f35b3a5312146806b4c0275bcd0aaa3b2017f346975db566f9b4d137f4ee10644c2a2da66deeca5342e236495c3c6280528bfd32e90af4cd9bb908f34012b52b4bc56d48cc8a6b59bab014988eabd12e1a0a1c2e170e7", "d9452d26b85efafc66b4ee6893d9bdbd996c88ef7d093832cbc22bb777852ca390117cecc987685b0698ae3953a12d2376b61d9e5672ad78304885481d9a8cd6");
        TestDigest.testKatHex(new BLAKE512(), "2d8427433d0c61f2d96cfe80cf1e932265a191365c3b61aaa3d6dcc039f6ba2ad52a6a8cc30fc10f705e6b7705105977fa496c1c708a277a124304f1fc40911e7441d1b5e77b951aad7b01fd5db1b377d165b05bbf898042e39660caf8b279fe5229d1a8db86c0999ed65e53d01ccbc4b43173ccf992b3a14586f6ba42f5fe30afa8ae40c5df29966f9346da5f8b35f16a1de3ab6de0f477d8d8660918060e88b9b9e9ca6a4207033b87a812dbf5544d39e4882010f82b6ce005f8e8ff6fe3c3806bc2b73c2b83afb704345629304f9f86358712e9fae3ca3e", "cfaa16147199f85948fd6c4cb1e992f8fe138768fc163f95cfe6951f50f9b8724460bba406ba2cde4a62b98c6b5ce7b24bd10d147082e0ff4cfb7cad717ddb0d");
        TestDigest.testKatHex(new BLAKE512(), "5e19d97887fcaac0387e22c6f803c34a3dacd2604172433f7a8a7a526ca4a2a1271ecfc5d5d7be5ac0d85d921095350dfc65997d443c21c8094e0a3fefd2961bcb94aed03291ae310ccda75d8ace4bc7d89e7d3e5d1650bda5d668b8b50bfc8e608e184f4d3a9a2badc4ff5f07e0c0bc8a9f2e0b2a26fd6d8c550008faaab75fd71af2a424bec9a7cd9d83fad4c8e9319115656a8717d3b523a68ff8004258b9990ed362308461804ba3e3a7e92d8f2ffae5c2fba55ba5a3c27c0a2f71bd711d2fe1799c2adb31b200035481e9ee5c4adf2ab9c0fa50b23975cf", "d292e96385cb31c06e8e7b2e1c014644dbdab25b116711b663cfd786f94b4e2d262a73338d978a6d1f29c1caa30a5bd6b14cf760cebadaf74fec6af2fd7f96bd");
        TestDigest.testKatHex(new BLAKE512(), "c8e976ab4638909387ce3b8d4e510c3230e5690e02c45093b1d297910abc481e56eea0f296f98379dfc9080af69e73b2399d1c143bee80ae1328162ce1ba7f6a8374679b20aacd380eb4e61382c99998704d62701afa914f9a2705cdb065885f50d086c3eb5753700c387118bb142f3e6da1e988dfb31ac75d7368931e45d1391a274b22f83ceb072f9bcabc0b216685bfd789f5023971024b1878a205442522f9ea7d8797a4102a3df41703768251fd5e017c85d1200a464118aa35654e7ca39f3c375b8ef8cbe7534dbc64bc20befb417cf60ec92f63d9ee7397", "a6de6ca55d4bb50ccf2c41cc76a1f5f16b5b0f4c06fe12cd0d8cc06c060e7863bc50dcb9bf381f6609cae526f2d4ef1798fa6d5a13959705068b0db0cdf66e56");
        TestDigest.testKatHex(new BLAKE512(), "7145fa124b7429a1fc2231237a949ba7201bcc1822d3272de005b682398196c25f7e5cc2f289fbf44415f699cb7fe6757791b1443410234ae061edf623359e2b4e32c19bf88450432dd01caa5eb16a1dc378f391ca5e3c4e5f356728bddd4975db7c890da8bbc84cc73ff244394d0d48954978765e4a00b593f70f2ca082673a261ed88dbcef1127728d8cd89bc2c597e9102ced6010f65fa75a14ebe467fa57ce3bd4948b6867d74a9df5c0ec6f530cbf2ee61ce6f06bc8f2864dff5583776b31df8c7ffcb61428a56bf7bd37188b4a5123bbf338393af46eda85e6", "1e22c478c068b0cfd5ab59a86a3c08291ee17a8116ab86b4a52c7519c84f0b1d701ab4e0c4000ba5f245bffbab705fb7776f53cd21e476798edf005708ec82cb");
        TestDigest.testKatHex(new BLAKE512(), "7fdfadcc9d29bad23ae038c6c65cda1aef757221b8872ed3d75ff8df7da0627d266e224e812c39f7983e4558bfd0a1f2bef3feb56ba09120ef762917b9c093867948547aee98600d10d87b20106878a8d22c64378bf634f7f75900c03986b077b0bf8b740a82447b61b99fee5376c5eb6680ec9e3088f0bdd0c56883413d60c1357d3c811950e5890e7600103c916341b80c743c6a852b7b4fb60c3ba21f3bc15b8382437a68454779cf3cd7f9f90ccc8ef28d0b706535b1e4108eb5627bb45d719cb046839aee311ca1abdc8319e050d67972cb35a6b1601b25dbf487", "80e0179192ed48d651dccb6eaa09e12b4bd2d8f163d662472185032d3d4fb0d3164f54956d650eb4639d8f3c65c6c7425bb454fe738abbf03bdad4dcb1e8e315");
        TestDigest.testKatHex(new BLAKE512(), "988638219fd3095421f826f56e4f09e356296b628c3ce6930c9f2e758fd1a80c8273f2f61e4daae65c4f110d3e7ca0965ac7d24e34c0dc4ba2d6ff0bf5bbe93b3585f354d7543cb542a1aa54674d375077f2d360a8f4d42f3db131c3b7ab7306267ba107659864a90c8c909460a73621d1f5d9d3fd95beb19b23db1cb6c0d0fba91d36891529b8bd8263caa1bab56a4affaed44962df096d8d5b1eb845ef31188b3e10f1af811a13f156beb7a288aae593ebd1471b624aa1a7c6adf01e2200b3d72d88a3aed3100c88231e41efc376906f0b580dc895f080fda5741db1cb", "ca887b0ce77d774a21a9239b81218086328dffd1d65caeeb6a4774dcf9b936c19545b7e37915f9bb4583f05f7e20ae832041463088b04fd6c7ba526a6261ebff");
        TestDigest.testKatHex(new BLAKE512(), "5aab62756d307a669d146aba988d9074c5a159b3de85151a819b117ca1ff6597f6156e80fdd28c9c3176835164d37da7da11d94e09add770b68a6e081cd22ca0c004bfe7cd283bf43a588da91f509b27a6584c474a4a2f3ee0f1f56447379240a5ab1fb77fdca49b305f07ba86b62756fb9efb4fc225c86845f026ea542076b91a0bc2cdd136e122c659be259d98e5841df4c2f60330d4d8cdee7bf1a0a244524eecc68ff2aef5bf0069c9e87a11c6e519de1a4062a10c83837388f7ef58598a3846f49d499682b683c4a062b421594fafbc1383c943ba83bdef515efcf10d", "c4db541df34e7fab92694eec1d68280fe4c3dd5681afb59614e3b11afa8091b890ee98658257f0a256c11810c562b4bd07b57b1d007247c26fca0422d667e6fb");
        TestDigest.testKatHex(new BLAKE512(), "47b8216aa0fbb5d67966f2e82c17c07aa2d6327e96fcd83e3de7333689f3ee79994a1bf45082c4d725ed8d41205cb5bcdf5c341f77facb1da46a5b9b2cbc49eadf786bcd881f371a95fa17df73f606519aea0ff79d5a11427b98ee7f13a5c00637e2854134691059839121fea9abe2cd1bcbbbf27c74caf3678e05bfb1c949897ea01f56ffa4dafbe8644611685c617a3206c7a7036e4ac816799f693dafe7f19f303ce4eba09d21e03610201bfc665b72400a547a1e00fa9b7ad8d84f84b34aef118515e74def11b9188bd1e1f97d9a12c30132ec2806339bdadacda2fd8b78", "ab15b50b37e861b8ab5098080da6388c04bcc9d774378f7a00b672f8d51d82ce34ef7f6d963b9ec640295723bb965bc59289271953bc7377a2a6b0e8de371779");
        TestDigest.testKatHex(new BLAKE512(), "8cff1f67fe53c098896d9136389bd8881816ccab34862bb67a656e3d98896f3ce6ffd4da73975809fcdf9666760d6e561c55238b205d8049c1cedeef374d1735daa533147bfa960b2cce4a4f254176bb4d1bd1e89654432b8dbe1a135c42115b394b024856a2a83dc85d6782be4b444239567ccec4b184d4548eae3ff6a192f343292ba2e32a0f267f31cc26719eb85245d415fb897ac2da433ee91a99424c9d7f1766a44171d1651001c38fc79294accc68ceb5665d36218454d3ba169ae058a831338c17743603f81ee173bfc0927464f9bd728dee94c6aeab7aae6ee3a627e8", "aa1714fe3c5ed277ae212284b9d0aba46cac79f5d123ce639c16b4cdd9e5ef1219683505f4153a323a8c2a30f513cf55815ed815efc430ea4d5955fa760b2fb6");
        TestDigest.testKatHex(new BLAKE512(), "eacd07971cff9b9939903f8c1d8cbb5d4db1b548a85d04e037514a583604e787f32992bf2111b97ac5e8a938233552731321522ab5e8583561260b7d13ebeef785b23a41fd8576a6da764a8ed6d822d4957a545d5244756c18aa80e1aad4d1f9c20d259dee1711e2cc8fd013169fb7cc4ce38b362f8e0936ae9198b7e838dcea4f7a5b9429bb3f6bbcf2dc92565e3676c1c5e6eb3dd2a0f86aa23edd3d0891f197447692794b3dfa269611ad97f72b795602b4fdb198f3fd3eb41b415064256e345e8d8c51c555dc8a21904a9b0f1ad0effab7786aac2da3b196507e9f33ca356427", "37299e62cba5b3ff5384f39ce32b52001958cc710a00a536ee14baf8865fa66d222b79365e5b85ae02ff9bc3ed17e7fe7e3e18ceb49698595debc46fd1dc833a");
        TestDigest.testKatHex(new BLAKE512(), "23ac4e9a42c6ef45c3336ce6dfc2ff7de8884cd23dc912fef0f7756c09d335c189f3ad3a23697abda851a81881a0c8ccafc980ab2c702564c2be15fe4c4b9f10dfb2248d0d0cb2e2887fd4598a1d4acda897944a2ffc580ff92719c95cf2aa42dc584674cb5a9bc5765b9d6ddf5789791d15f8dd925aa12bffafbce60827b490bb7df3dda6f2a143c8bf96abc903d83d59a791e2d62814a89b8080a28060568cf24a80ae61179fe84e0ffad00388178cb6a617d37efd54cc01970a4a41d1a8d3ddce46edbba4ab7c90ad565398d376f431189ce8c1c33e132feae6a8cd17a61c630012", "4247c012215e85acafb94c5c1840382ba096ddc1d62212f570d61a21c1677ba8d776e5679a6b8f2bbf0de6c3f980e1aa78bdd7900a018e537c4b76dd767be3e4");
        TestDigest.testKatHex(new BLAKE512(), "0172df732282c9d488669c358e3492260cbe91c95cfbc1e3fea6c4b0ec129b45f242ace09f152fc6234e1bee8aab8cd56e8b486e1dcba9c05407c2f95da8d8f1c0af78ee2ed82a3a79ec0cb0709396ee62aadb84f8a4ee8a7ccca3c1ee84e302a09ea802204afecf04097e67d0f8e8a9d2651126c0a598a37081e42d168b0ae8a71951c524259e4e2054e535b779679bdade566fe55700858618e626b4a0faf895bcce9011504a49e05fd56127eae3d1f8917afb548ecadabda1020111fec9314c413498a360b08640549a22cb23c731ace743252a8227a0d2689d4c6001606678dfb921", "8a9f46c05566c83aa8bdc8fc7aff4822fb75fec2c1f948182709b51683149d00b8773beed53a19e4e4a53df308e5c1920ed7e39e0b9a1ffeec4ef39f724afe5b");
        TestDigest.testKatHex(new BLAKE512(), "3875b9240cf3e0a8b59c658540f26a701cf188496e2c2174788b126fd29402d6a75453ba0635284d08835f40051a2a9683dc92afb9383719191231170379ba6f4adc816fecbb0f9c446b785bf520796841e58878b73c58d3ebb097ce4761fdeabe15de2f319dfbaf1742cdeb389559c788131a6793e193856661376c81ce9568da19aa6925b47ffd77a43c7a0e758c37d69254909ff0fbd415ef8eb937bcd49f91468b49974c07dc819abd67395db0e05874ff83dddab895344abd0e7111b2df9e58d76d85ad98106b36295826be04d435615595605e4b4bb824b33c4afeb5e7bb0d19f909", "91d7beee49a87986ef217d509d4cd4948cffe7a20c9117f8517d2c8c9de094f794032f189079e9735463f02ba0c61d3b9f2e27455a89ecee440562e17f554e92");
        TestDigest.testKatHex(new BLAKE512(), "747cc1a59fefba94a9c75ba866c30dc5c1cb0c0f8e9361d98484956dd5d1a40f6184afbe3dac9f76028d1caeccfbf69199c6ce2b4c092a3f4d2a56fe5a33a00757f4d7dee5dfb0524311a97ae0668a47971b95766e2f6dd48c3f57841f91f04a00ad5ea70f2d479a2620dc5cd78eaab3a3b011719b7e78d19ddf70d9423798af77517ebc55392fcd01fc600d8d466b9e7a7a85bf33f9cc5419e9bd874ddfd60981150ddaf8d7febaa4374f0872a5628d318000311e2f5655365ad4d407c20e5c04df17a222e7deec79c5ab1116d8572f91cd06e1ccc7ced53736fc867fd49ecebe6bf8082e8a", "ef90babeeb7be41f556b89b52f879166121240b30456a23f296b6bb7b6ec949b2a821abe79d9da6375077db41d115144f4bc6c6fd2383b8a766a65de5c36dde2");
        TestDigest.testKatHex(new BLAKE512(), "57af971fccaec97435dc2ec9ef0429bcedc6b647729ea168858a6e49ac1071e706f4a5a645ca14e8c7746d65511620682c906c8b86ec901f3dded4167b3f00b06cbfac6aee3728051b3e5ff10b4f9ed8bd0b8da94303c833755b3ca3aeddf0b54bc8d6632138b5d25bab03d17b3458a9d782108006f5bb7de75b5c0ba854b423d8bb801e701e99dc4feaad59bc1c7112453b04d33ea3635639fb802c73c2b71d58a56bbd671b18fe34ed2e3dca38827d63fdb1d4fb3285405004b2b3e26081a8ff08cd6d2b08f8e7b7e90a2ab1ed7a41b1d0128522c2f8bff56a7fe67969422ce839a9d4608f03", "ac8709d7758d8954ee95d6621789d716119bc6f214f87388622f27aaa4c655d769abf97c72a1e2405ed9834fad5e3b49b4be8106ec894293c48d21c0a607897a");
        TestDigest.testKatHex(new BLAKE512(), "04e16dedc1227902baaf332d3d08923601bdd64f573faa1bb7201918cfe16b1e10151dae875da0c0d63c59c3dd050c4c6a874011b018421afc4623ab0381831b2da2a8ba42c96e4f70864ac44e106f94311051e74c77c1291bf5db9539e69567bf6a11cf6932bbbad33f8946bf5814c066d851633d1a513510039b349939bfd42b858c21827c8ff05f1d09b1b0765dc78a135b5ca4dfba0801bcaddfa175623c8b647eacfb4444b85a44f73890607d06d507a4f8393658788669f6ef4deb58d08c50ca0756d5e2f49d1a7ad73e0f0b3d3b5f090acf622b1878c59133e4a848e05153592ea81c6fbf", "545ea9fcdd344ca84d2457a62f4d3eb4f59722fad0547a680d4e9014d4f568633f2c691a63e41d6fbecbbd77605cd0c57f4203ca6485bf75049f8dfcfaff6ac4");
        TestDigest.testKatHex(new BLAKE512(), "7c815c384eee0f288ece27cced52a01603127b079c007378bc5d1e6c5e9e6d1c735723acbbd5801ac49854b2b569d4472d33f40bbb8882956245c366dc3582d71696a97a4e19557e41e54dee482a14229005f93afd2c4a7d8614d10a97a9dfa07f7cd946fa45263063ddd29db8f9e34db60daa32684f0072ea2a9426ecebfa5239fb67f29c18cbaa2af6ed4bf4283936823ac1790164fec5457a9cba7c767ca59392d94cab7448f50eb34e9a93a80027471ce59736f099c886dea1ab4cba4d89f5fc7ae2f21ccd27f611eca4626b2d08dc22382e92c1efb2f6afdc8fdc3d2172604f5035c46b8197d3", "b75e25e6d92be1424ba4003f0be981d9596eeeba6e86a0cdde978220f4e3906cd8a5ea150cc18ac1b175b9d9501f1ec1dda89fb92344f28eea18454fd826c118");
        TestDigest.testKatHex(new BLAKE512(), "e29d505158dbdd937d9e3d2145658ee6f5992a2fc790f4f608d9cdb44a091d5b94b88e81fac4fdf5c49442f13b911c55886469629551189eaff62488f1a479b7db11a1560e198ddccccf50159093425ff7f1cb8d1d1246d0978764087d6bac257026b090efae8cec5f22b6f21c59ace1ac7386f5b8837ca6a12b6fbf5534dd0560ef05ca78104d3b943ddb220feaec89aa5e692a00f822a2ab9a2fe60350d75e7be16ff2526dc643872502d01f42f188abed0a6e9a6f5fd0d1ce7d5755c9ffa66b0af0b20bd806f08e06156690d81ac811778ca3dac2c249b96002017fce93e507e3b953acf99964b847", "d77ce73f451c9fecf9ee096f457ca8a062667c2d03c7783f101933dad8bdf0dbc46193216df8bfcb25508d41b66adacd185dd3a4e9647c31b45afdb99f0680a3");
        TestDigest.testKatHex(new BLAKE512(), "d85588696f576e65eca0155f395f0cfacd83f36a99111ed5768df2d116d2121e32357ba4f54ede927f189f297d3a97fad4e9a0f5b41d8d89dd7fe20156799c2b7b6bf9c957ba0d6763f5c3bc5129747bbb53652b49290cff1c87e2cdf2c4b95d8aaee09bc8fbfa6883e62d237885810491bfc101f1d8c636e3d0ede838ad05c207a3df4fad76452979eb99f29afaecedd1c63b8d36cf378454a1bb67a741c77ac6b6b3f95f4f02b64dabc15438613ea49750df42ee90101f115aa9abb9ff64324dde9dabbb01054e1bd6b4bcdc7930a44c2300d87ca78c06924d0323ad7887e46c90e8c4d100acd9eed21e", "be19b72f71139c10c3e549af4975d0dcca95df14d81859fa9f5a6b4b1d38cb393fda64dd11d351bd2c3ccb4c5053df9c750308358e7754a8bb7a3b499cdde48f");
        TestDigest.testKatHex(new BLAKE512(), "3a12f8508b40c32c74492b66323375dcfe49184c78f73179f3314b79e63376b8ac683f5a51f1534bd729b02b04d002f55cbd8e8fc9b5ec1ea6bbe6a0d0e7431518e6ba45d124035f9d3dce0a8bb7bf1430a9f657e0b4ea9f20eb20c786a58181a1e20a96f1628f8728a13bdf7a4b4b32fc8aa7054cc4881ae7fa19afa65c6c3ee1b3ade3192af42054a8a911b8ec1826865d46d93f1e7c5e2b7813c92a506e53886f3d4701bb93d2a681ad109c845904bb861af8af0646b6e399b38b614051d34f6842563a0f37ec00cb3d865fc5d746c4987de2a65071100883a2a9c7a2bfe1e2dd603d9ea24dc7c5fd06be", "155f3b26abbee6fa1a44ad01ebad262f4c3485766f9f93dacb2ec0b3a6d77c14a4ea19927674e331acffe2c97ac2ce47302865c1cb5601a09b5e69868763d76e");
        TestDigest.testKatHex(new BLAKE512(), "1861edce46fa5ad17e1ff1deae084dec580f97d0a67885dfe834b9dfac1ae076742ce9e267512ca51f6df5a455af0c5fd6abf94acea103a3370c354485a7846fb84f3ac7c2904b5b2fbf227002ce512133bb7e1c4e50057bfd1e44db33c7cdb969a99e284b184f50a14b068a1fc5009d9b298dbe92239572a7627aac02abe8f3e3b473417f36d4d2505d16b7577f4526c9d94a270a2dfe450d06da8f6fa956879a0a55cfe99e742ea555ea477ba3e9b44ccd508c375423611af92e55345dc215779b2d5119eba49c71d49b9fe3f1569fa24e5ca3e332d042422a8b8158d3ec66a80012976f31ffdf305f0c9c5e", "9f5293a1c3691717b995e398829b0783dc3169b3add4d1cf062e0d74dfbf6697f9e814384f5c077a448df99a8302efb095161da3086008b8f179682b44873040");
        TestDigest.testKatHex(new BLAKE512(), "08d0ffde3a6e4ef65608ea672e4830c12943d7187ccff08f4941cfc13e545f3b9c7ad5eebbe2b01642b486caf855c2c73f58c1e4e3391da8e2d63d96e15fd84953ae5c231911b00ad6050cd7aafdaac9b0f663ae6aab45519d0f5391a541707d479034e73a6ad805ae3598096af078f1393301493d663dd71f83869ca27ba508b7e91e81e128c1716dc3acfe3084b2201e04cf8006617eecf1b640474a5d45cfde9f4d3ef92d6d055b909892194d8a8218db6d8203a84261d200d71473d7488f3427416b6896c137d455f231071cacbc86e0415ab88aec841d96b7b8af41e05bb461a40645bf176601f1e760de5f", "748f0b6d8aeae399b29f9dd922b4d939c5403df8bf21629cfce448f929e910c67ac2c9bba5cca34f066f279fd012b2e72e8218cc6422aadb2ebad3333e414c00");
        TestDigest.testKatHex(new BLAKE512(), "d782abb72a5be3392757be02d3e45be6e2099d6f000d042c8a543f50ed6ebc055a7f133b0dd8e9bc348536edcaae2e12ec18e8837df7a1b3c87ec46d50c241dee820fd586197552dc20beea50f445a07a38f1768a39e2b2ff05dddedf751f1def612d2e4d810daa3a0cc904516f9a43af660315385178a529e51f8aae141808c8bc5d7b60cac26bb984ac1890d0436ef780426c547e94a7b08f01acbfc4a3825eae04f520a9016f2fb8bf5165ed12736fc71e36a49a73614739eaa3ec834069b1b40f1350c2b3ab885c02c640b9f7686ed5f99527e41cfcd796fe4c256c9173186c226169ff257954ebda81c0e5f99", "e46045fd8a28d09481e4b5910178687d96ac1fd3a80b6be92ee464c8b5629170570e0a0626610e0d871bb32ac589fa7ea43ad07a84b61a292231a69cda43ce3e");
        TestDigest.testKatHex(new BLAKE512(), "5fce8109a358570e40983e1184e541833bb9091e280f258cfb144387b05d190e431cb19baa67273ba0c58abe91308e1844dcd0b3678baa42f335f2fa05267a0240b3c718a5942b3b3e3bfa98a55c25a1466e8d7a603722cb2bbf03afa54cd769a99f310735ee5a05dae2c22d397bd95635f58c48a67f90e1b73aafcd3f82117f0166657838691005b18da6f341d6e90fc1cdb352b30fae45d348294e501b63252de14740f2b85ae5299ddec3172de8b6d0ba219a20a23bb5e10ff434d39db3f583305e9f5c039d98569e377b75a70ab837d1df269b8a4b566f40bb91b577455fd3c356c914fa06b9a7ce24c7317a172d", "8a6ff1efde11e0cc0dcd5a06d11adf1b6c0d1140dc7e5fdde7196e60a0e30f60d3ba84d5f80274a018634162356139145fb02f27aba1b4c7b0ebd3ded63ffc46");
        TestDigest.testKatHex(new BLAKE512(), "6172f1971a6e1e4e6170afbad95d5fec99bf69b24b674bc17dd78011615e502de6f56b86b1a71d3f4348087218ac7b7d09302993be272e4a591968aef18a1262d665610d1070ee91cc8da36e1f841a69a7a682c580e836941d21d909a3afc1f0b963e1ca5ab193e124a1a53df1c587470e5881fb54dae1b0d840f0c8f9d1b04c645ba1041c7d8dbf22030a623aa15638b3d99a2c400ff76f3252079af88d2b37f35ee66c1ad7801a28d3d388ac450b97d5f0f79e4541755356b3b1a5696b023f39ab7ab5f28df4202936bc97393b93bc915cb159ea1bd7a0a414cb4b7a1ac3af68f50d79f0c9c7314e750f7d02faa58bfa", "e37ee7cd2b033cfa6844547d37d0a6c33c6eba595648c0354e942f68396dbd1919d044a6c317761ec2d4185a804cd6f9b460cfba4895947e6bc96b227a314d19");
        TestDigest.testKatHex(new BLAKE512(), "5668ecd99dfbe215c4118398ac9c9eaf1a1433fab4ccdd3968064752b625ea944731f75d48a27d047d67547f14dd0ffaa55fa5e29f7af0d161d85eafc4f2029b717c918eab9d304543290bdba7158b68020c0ba4e079bc95b5bc0fc044a992b94b4ccd3bd66d0eabb5dbbab904d62e00752c4e3b0091d773bcf4c14b4377da3efff824b1cb2fa01b32d1e46c909e626ed2dae920f4c7dbeb635bc754facbd8d49beba3f23c1c41ccbfcd0ee0c114e69737f5597c0bf1d859f0c767e18002ae8e39c26261ffde2920d3d0baf0e906138696cfe5b7e32b600f45df3aaa39932f3a7df95b60fa8712a2271fcaf3911ce7b511b1", "dec59ce102fb58ca5de6abeb16fc5370352e65a06a5cab414ec83cea5da7594e3fda7ff451b10eb5fb7c0154f47ab09b399ec4c22674d387b53cc8fb6e4be12e");
        TestDigest.testKatHex(new BLAKE512(), "03d625488354df30e3f875a68edfcf340e8366a8e1ab67f9d5c5486a96829dfac0578289082b2a62117e1cf418b43b90e0adc881fc6ae8105c888e9ecd21aea1c9ae1a4038dfd17378fed71d02ae492087d7cdcd98f746855227967cb1ab4714261ee3bead3f4db118329d3ebef4bc48a875c19ba763966da0ebea800e01b2f50b00e9dd4caca6dcb314d00184ef71ea2391d760c950710db4a70f9212ffc54861f9dc752ce18867b8ad0c48df8466ef7231e7ac567f0eb55099e622ebb86cb237520190a61c66ad34f1f4e289cb3282ae3eaac6152ed24d2c92bae5a7658252a53c49b7b02dfe54fdb2e90074b6cf310ac661", "66880f8426f5dfc6129b505e5a8627d6221a779a68a72eb697665a302544f6684a26c842af9430288e033dcd6dbbba44abd9c6e90159ad6f00014a6843a7f943");
        TestDigest.testKatHex(new BLAKE512(), "2edc282ffb90b97118dd03aaa03b145f363905e3cbd2d50ecd692b37bf000185c651d3e9726c690d3773ec1e48510e42b17742b0b0377e7de6b8f55e00a8a4db4740cee6db0830529dd19617501dc1e9359aa3bcf147e0a76b3ab70c4984c13e339e6806bb35e683af8527093670859f3d8a0fc7d493bcba6bb12b5f65e71e705ca5d6c948d66ed3d730b26db395b3447737c26fad089aa0ad0e306cb28bf0acf106f89af3745f0ec72d534968cca543cd2ca50c94b1456743254e358c1317c07a07bf2b0eca438a709367fafc89a57239028fc5fecfd53b8ef958ef10ee0608b7f5cb9923ad97058ec067700cc746c127a61ee3", "35556c377ef87ca540037d0483eeb60f698ebf9fec4824055ac59f1f949067852ca41dbbe2da169107fba05ec97cb7b52afac2ec1bb6e928173ac4d7a05f97f1");
        TestDigest.testKatHex(new BLAKE512(), "90b28a6aa1fe533915bcb8e81ed6cacdc10962b7ff82474f845eeb86977600cf70b07ba8e3796141ee340e3fce842a38a50afbe90301a3bdcc591f2e7d9de53e495525560b908c892439990a2ca2679c5539ffdf636777ad9c1cdef809cda9e8dcdb451abb9e9c17efa4379abd24b182bd981cafc792640a183b61694301d04c5b3eaad694a6bd4cc06ef5da8fa23b4fa2a64559c5a68397930079d250c51bcf00e2b16a6c49171433b0aadfd80231276560b80458dd77089b7a1bbcc9e7e4b9f881eacd6c92c4318348a13f4914eb27115a1cfc5d16d7fd94954c3532efaca2cab025103b2d02c6fd71da3a77f417d7932685888a", "55faac4f58c0a8dcb0a06344ba673b584be931961d7d42c424c0338ae69fa019a9de91a2959cf26ca55462a108c0650120eb881c37f4c58622cba3442b1c74ed");
        TestDigest.testKatHex(new BLAKE512(), "2969447d175490f2aa9bb055014dbef2e6854c95f8d60950bfe8c0be8de254c26b2d31b9e4de9c68c9adf49e4ee9b1c2850967f29f5d08738483b417bb96b2a56f0c8aca632b552059c59aac3f61f7b45c966b75f1d9931ff4e596406378cee91aaa726a3a84c33f37e9cdbe626b5745a0b06064a8a8d56e53aaf102d23dd9df0a3fdf7a638509a6761a33fa42fa8ddbd8e16159c93008b53765019c3f0e9f10b144ce2ac57f5d7297f9c9949e4ff68b70d339f87501ce8550b772f32c6da8ad2ce2100a895d8b08fa1eead7c376b407709703c510b50f87e73e43f8e7348f87c3832a547ef2bbe5799abedcf5e1f372ea809233f006", "0bfa0b883bd1b7fca5413fcbc60dcaba2a8ff7395593afb6a3bae8d6a8f41e8b2b00dc4b0e54c59dde28f384f72d2d3985b6034048a3b1643a3abe67d45ba2fa");
        TestDigest.testKatHex(new BLAKE512(), "721645633a44a2c78b19024eaecf58575ab23c27190833c26875dc0f0d50b46aea9c343d82ea7d5b3e50ec700545c615daeaea64726a0f05607576dcd396d812b03fb6551c641087856d050b10e6a4d5577b82a98afb89cee8594c9dc19e79feff0382fcfd127f1b803a4b9946f4ac9a4378e1e6e041b1389a53e3450cd32d9d2941b0cbabdb50da8ea2513145164c3ab6bcbd251c448d2d4b087ac57a59c2285d564f16da4ed5e607ed979592146ffb0ef3f3db308fb342df5eb5924a48256fc763141a278814c82d6d6348577545870ae3a83c7230ac02a1540fe1798f7ef09e335a865a2ae0949b21e4f748fb8a51f44750e213a8fb", "4a4a68eacd20764ef2d9b4fca3887eb227e62a264097d12fb3de4cd1a37b7d75dec0c8b0a40197c71c3f27e5434ef59be896b4be2aacfe3facb6cf892b608f45");
        TestDigest.testKatHex(new BLAKE512(), "6b860d39725a14b498bb714574b4d37ca787404768f64c648b1751b353ac92bac2c3a28ea909fdf0423336401a02e63ec24325300d823b6864bb701f9d7c7a1f8ec9d0ae3584aa6dd62ea1997cd831b4babd9a4da50932d4efda745c61e4130890e156aee6113716daf95764222a91187db2effea49d5d0596102d619bd26a616bbfda8335505fbb0d90b4c180d1a2335b91538e1668f9f9642790b4e55f9cab0fe2bdd2935d001ee6419abab5457880d0dbff20ed8758f4c20fe759efb33141cf0e892587fe8187e5fbc57786b7e8b089612c936dfc03d27efbbe7c8673f1606bd51d5ff386f4a7ab68edf59f385eb1291f117bfe717399", "783983769dbbbbc94ba856b35b647efafa29137c9c9a5c405f5ad2085297489ca53ac64dbb161a8cb614e9f4cf4e05721069f78f4b68517468536a009b9e527a");
        TestDigest.testKatHex(new BLAKE512(), "6a01830af3889a25183244decb508bd01253d5b508ab490d3124afbf42626b2e70894e9b562b288d0a2450cfacf14a0ddae5c04716e5a0082c33981f6037d23d5e045ee1ef2283fb8b6378a914c5d9441627a722c282ff452e25a7ea608d69cee4393a0725d17963d0342684f255496d8a18c2961145315130549311fc07f0312fb78e6077334f87eaa873bee8aa95698996eb21375eb2b4ef53c14401207deb4568398e5dd9a7cf97e8c9663e23334b46912f8344c19efcf8c2ba6f04325f1a27e062b62a58d0766fc6db4d2c6a1928604b0175d872d16b7908ebc041761187cc785526c2a3873feac3a642bb39f5351550af9770c328af7b", "3335d73d36749c942c34148aa745e354c0233d57db92fc9f1d0c9462bb3d19a0903341182607dd5966a5effb51512c51f851699d692a623aca4912ad960fcefe");
        TestDigest.testKatHex(new BLAKE512(), "b3c5e74b69933c2533106c563b4ca20238f2b6e675e8681e34a389894785bdade59652d4a73d80a5c85bd454fd1e9ffdad1c3815f5038e9ef432aac5c3c4fe840cc370cf86580a6011778bbedaf511a51b56d1a2eb68394aa299e26da9ada6a2f39b9faff7fba457689b9c1a577b2a1e505fdf75c7a0a64b1df81b3a356001bf0df4e02a1fc59f651c9d585ec6224bb279c6beba2966e8882d68376081b987468e7aed1ef90ebd090ae825795cdca1b4f09a979c8dfc21a48d8a53cdbb26c4db547fc06efe2f9850edd2685a4661cb4911f165d4b63ef25b87d0a96d3dff6ab0758999aad214d07bd4f133a6734fde445fe474711b69a98f7e2b", "7ce0f6b623d56dfe6275d18a07348b2cd92baf8c1b464cfc480c2b12280f0242d6303409add2a9082efe34ddc6297946944941d9ff0097662cb1dd6fc126312d");
        TestDigest.testKatHex(new BLAKE512(), "83af34279ccb5430febec07a81950d30f4b66f484826afee7456f0071a51e1bbc55570b5cc7ec6f9309c17bf5befdd7c6ba6e968cf218a2b34bd5cf927ab846e38a40bbd81759e9e33381016a755f699df35d660007b5eadf292feefb735207ebf70b5bd17834f7bfa0e16cb219ad4af524ab1ea37334aa66435e5d397fc0a065c411ebbce32c240b90476d307ce802ec82c1c49bc1bec48c0675ec2a6c6f3ed3e5b741d13437095707c565e10d8a20b8c20468ff9514fcf31b4249cd82dcee58c0a2af538b291a87e3390d737191a07484a5d3f3fb8c8f15ce056e5e5f8febe5e1fb59d6740980aa06ca8a0c20f5712b4cde5d032e92ab89f0ae1", "30d4c4a760307870700d8b1a9266a52a9b1ac3c9df4594de50abcc471868490bbf320b92cb1195a6adf0aca7fc702365d6aff1db24d9a6d516b90ace9503ac1d");
        TestDigest.testKatHex(new BLAKE512(), "a7ed84749ccc56bb1dfba57119d279d412b8a986886d810f067af349e8749e9ea746a60b03742636c464fc1ee233acc52c1983914692b64309edfdf29f1ab912ec3e8da074d3f1d231511f5756f0b6eead3e89a6a88fe330a10face267bffbfc3e3090c7fd9a850561f363ad75ea881e7244f80ff55802d5ef7a1a4e7b89fcfa80f16df54d1b056ee637e6964b9e0ffd15b6196bdd7db270c56b47251485348e49813b4eb9ed122a01b3ea45ad5e1a929df61d5c0f3e77e1fdc356b63883a60e9cbb9fc3e00c2f32dbd469659883f690c6772e335f617bc33f161d6f6984252ee12e62b6000ac5231e0c9bc65be223d8dfd94c5004a101af9fd6c0fb", "ff13d64a919f4a3cbc3247453e0ca88e32256a8f6b8a91b3915ba4d3866450ca5c3fa63de9f632b146847467d9b5477c5b37bee924cf2cb18d3a5e70fef3bcd4");
        TestDigest.testKatHex(new BLAKE512(), "a6fe30dcfcda1a329e82ab50e32b5f50eb25c873c5d2305860a835aecee6264aa36a47429922c4b8b3afd00da16035830edb897831c4e7b00f2c23fc0b15fdc30d85fb70c30c431c638e1a25b51caf1d7e8b050b7f89bfb30f59f0f20fecff3d639abc4255b3868fc45dd81e47eb12ab40f2aac735df5d1dc1ad997cefc4d836b854cee9ac02900036f3867fe0d84afff37bde3308c2206c62c4743375094108877c73b87b2546fe05ea137bedfc06a2796274099a0d554da8f7d7223a48cbf31b7decaa1ebc8b145763e3673168c1b1b715c1cd99ecd3ddb238b06049885ecad9347c2436dff32c771f34a38587a44a82c5d3d137a03caa27e66c8ff6", "c5aad2fbb8b2da175da315960ca5f74cd94984bb8f667c38985ca0cade27ac688cb28edfa3d39edc766ea30f8957c83bf8225021d5d30c68b895ec564a99b49d");
        TestDigest.testKatHex(new BLAKE512(), "83167ff53704c3aa19e9fb3303539759c46dd4091a52ddae9ad86408b69335989e61414bc20ab4d01220e35241eff5c9522b079fba597674c8d716fe441e566110b6211531ceccf8fd06bc8e511d00785e57788ed9a1c5c73524f01830d2e1148c92d0edc97113e3b7b5cd3049627abdb8b39dd4d6890e0ee91993f92b03354a88f52251c546e64434d9c3d74544f23fb93e5a2d2f1fb15545b4e1367c97335b0291944c8b730ad3d4789273fa44fb98d78a36c3c3764abeeac7c569c1e43a352e5b770c3504f87090dee075a1c4c85c0c39cf421bdcc615f9eff6cb4fe6468004aece5f30e1ecc6db22ad9939bb2b0ccc96521dfbf4ae008b5b46bc006e", "08134331ae5c909391d30632bd864120caf5da96972a0de1b67d90070f1594c84d4caa78d2f6eb86dfacb2a2260092c9bfc8d3d9aff3e73e7e31416a9394fcea");
        TestDigest.testKatHex(new BLAKE512(), "3a3a819c48efde2ad914fbf00e18ab6bc4f14513ab27d0c178a188b61431e7f5623cb66b23346775d386b50e982c493adbbfc54b9a3cd383382336a1a0b2150a15358f336d03ae18f666c7573d55c4fd181c29e6ccfde63ea35f0adf5885cfc0a3d84a2b2e4dd24496db789e663170cef74798aa1bbcd4574ea0bba40489d764b2f83aadc66b148b4a0cd95246c127d5871c4f11418690a5ddf01246a0c80a43c70088b6183639dcfda4125bd113a8f49ee23ed306faac576c3fb0c1e256671d817fc2534a52f5b439f72e424de376f4c565cca82307dd9ef76da5b7c4eb7e085172e328807c02d011ffbf33785378d79dc266f6a5be6bb0e4a92eceebaeb1", "df5ce5623bdd1f0fbcd84aa754dc30041449e0e8d99780b00fac6fc8e02ed3ea37dc14a458427d5b6a1c126bfad782b73b6c98a80d688e4c566c86694498b131");
        TestDigest.reportSuccess("BLAKE-512");
    }

    private static void testLuffa224() {
        TestDigest.testKatHex(new Luffa224(), "616263", "f29311b87e9e40de7699be23fbeb5a47cb16ea4f5556d47ca40c12ad");
        TestDigest.testKatHex(new Luffa224(), "", "dbb8665871f4154d3e4396aefbba417cb7837dd683c332ba6be87e02");
        TestDigest.testKatHex(new Luffa224(), "cc", "e47d4158bfe03555d370d8fd877ead17d6aa9fdc689a9614c411fbba");
        TestDigest.testKatHex(new Luffa224(), "41fb", "08cbdd1c9caea9711ab2b30b872ddc09f2954b98ac1850abe3f648f1");
        TestDigest.testKatHex(new Luffa224(), "1f877c", "a590d4995c909abd9150398d4ab9465a8e9f768c576921c26a998857");
        TestDigest.testKatHex(new Luffa224(), "c1ecfdfc", "25c82f898f66355aba7a6215d07cab27fbeeedd16b52aa910040b40f");
        TestDigest.testKatHex(new Luffa224(), "21f134ac57", "c3c9b051075ca4da37dd0a43136e1e6566cb147371325e1dbefefb8a");
        TestDigest.testKatHex(new Luffa224(), "c6f50bb74e29", "81ddb86c64f4a06160121ed6e8a4a50c6144cdf27f5cd0ca85c197d9");
        TestDigest.testKatHex(new Luffa224(), "119713cc83eeef", "f826d9974939ab9722f3581e51df6587325cd58ed30e0e771a85eb1e");
        TestDigest.testKatHex(new Luffa224(), "4a4f202484512526", "375a7e893a3b0da1a0ca0272654451c7992a84ca9bd1578cf1507997");
        TestDigest.testKatHex(new Luffa224(), "1f66ab4185ed9b6375", "2ae8ccefd8eb75d7767d4db991a6dd36e7d39a35e54a9e205c074d0e");
        TestDigest.testKatHex(new Luffa224(), "eed7422227613b6f53c9", "93c5d8f185e9e12490ddcbc46c0d19546dc82763272a07733f368dd7");
        TestDigest.testKatHex(new Luffa224(), "eaeed5cdffd89dece455f1", "66954c41a49483055b86391fdf4d64c7ce59067656052d53f56d211c");
        TestDigest.testKatHex(new Luffa224(), "5be43c90f22902e4fe8ed2d3", "e3f264279d15b3a0e45475ac23a95bc11d590251d51fded2152815f7");
        TestDigest.testKatHex(new Luffa224(), "a746273228122f381c3b46e4f1", "72467235c784fbc2d31d0743bf9ef68b0b3a56ae7e2be95f56a2837a");
        TestDigest.testKatHex(new Luffa224(), "3c5871cd619c69a63b540eb5a625", "73a6e93b7fbb5a42b15ae6d1863e84d6efa89f4761cdec2f0dd235bc");
        TestDigest.testKatHex(new Luffa224(), "fa22874bcc068879e8ef11a69f0722", "0c76e5a5feaf776d767ff45a27ea06faad4c1a4d893846501caae9ef");
        TestDigest.testKatHex(new Luffa224(), "52a608ab21ccdd8a4457a57ede782176", "f530e9c931b893d4fb4245b08564046a1baa5f2b51ef30899448661e");
        TestDigest.testKatHex(new Luffa224(), "82e192e4043ddcd12ecf52969d0f807eed", "1f0fb33a7c8e2cefa025791919034dd4685404cc77e82410997d2cfd");
        TestDigest.testKatHex(new Luffa224(), "75683dcb556140c522543bb6e9098b21a21e", "34ff9975b494979bdfb3ff6f265654aae017c384aa9e8b7ae46fde7b");
        TestDigest.testKatHex(new Luffa224(), "06e4efe45035e61faaf4287b4d8d1f12ca97e5", "46dc757a8a3d8d9f336b4d6657918055e0a55c03205cf919959f13fa");
        TestDigest.testKatHex(new Luffa224(), "e26193989d06568fe688e75540aea06747d9f851", "419ab3a0c3129fb69c43f0f03760208f036567a69ce19459a488fd79");
        TestDigest.testKatHex(new Luffa224(), "d8dc8fdefbdce9d44e4cbafe78447bae3b5436102a", "383121b1c9e7e2d0e0b0bd63caf89ea25bcfe6092e9e90215c1fd2b7");
        TestDigest.testKatHex(new Luffa224(), "57085fd7e14216ab102d8317b0cb338a786d5fc32d8f", "2362b7da89251eca923750e51495dccfaac60da85e52a0f6433d3c03");
        TestDigest.testKatHex(new Luffa224(), "a05404df5dbb57697e2c16fa29defac8ab3560d6126fa0", "1f21d604490bfd9e3047dbee4ae78907fdeb1c2109e89018cc3f8f2f");
        TestDigest.testKatHex(new Luffa224(), "aecbb02759f7433d6fcb06963c74061cd83b5b3ffa6f13c6", "a65984fe81e98324c070151b1d726f74c15bd1587732185bdcdec716");
        TestDigest.testKatHex(new Luffa224(), "aafdc9243d3d4a096558a360cc27c8d862f0be73db5e88aa55", "136a5ead994a1c7c54332e54910a306cc1aa29fa1d2bab502d7c56f3");
        TestDigest.testKatHex(new Luffa224(), "7bc84867f6f9e9fdc3e1046cae3a52c77ed485860ee260e30b15", "653ec34deec311cd38d0d474167183a59cf7b721abe417e4814f486a");
        TestDigest.testKatHex(new Luffa224(), "fac523575a99ec48279a7a459e98ff901918a475034327efb55843", "0f192b38e98ca792c7f54c845c10e427002be23d0b80c180e0efc8ea");
        TestDigest.testKatHex(new Luffa224(), "0f8b2d8fcfd9d68cffc17ccfb117709b53d26462a3f346fb7c79b85e", "4669eafc59178a5a77aee3621c7d8c932e4434202dbf5118a368d1fb");
        TestDigest.testKatHex(new Luffa224(), "a963c3e895ff5a0be4824400518d81412f875fa50521e26e85eac90c04", "a415d63928de0792e02820be200e52d32081b34014ae8c779d4ad2a7");
        TestDigest.testKatHex(new Luffa224(), "03a18688b10cc0edf83adf0a84808a9718383c4070c6c4f295098699ac2c", "1ca8f1d71296c07eb13d988db7cec4bccd2f6f9e3c97776b7dc04540");
        TestDigest.testKatHex(new Luffa224(), "84fb51b517df6c5accb5d022f8f28da09b10232d42320ffc32dbecc3835b29", "e0d34790dd95f336c67172070982b61f715d2ce3f8d5afb95e003f89");
        TestDigest.testKatHex(new Luffa224(), "9f2fcc7c90de090d6b87cd7e9718c1ea6cb21118fc2d5de9f97e5db6ac1e9c10", "a2604f434b7bea9b156c54fe297869edb1b1249b38b0923884fe25d8");
        TestDigest.testKatHex(new Luffa224(), "de8f1b3faa4b7040ed4563c3b8e598253178e87e4d0df75e4ff2f2dedd5a0be046", "abbc5e77ba63a5a9569e0b4b346ef944b3c4b9f287f2aa0029b2aea1");
        TestDigest.testKatHex(new Luffa224(), "62f154ec394d0bc757d045c798c8b87a00e0655d0481a7d2d9fb58d93aedc676b5a0", "519ae93d6bd290988e243044bd92729e8f05d4d546fa3d44f8fd5472");
        TestDigest.testKatHex(new Luffa224(), "b2dcfe9ff19e2b23ce7da2a4207d3e5ec7c6112a8a22aec9675a886378e14e5bfbad4e", "f08f2d55cf38e44355547ec8c9adcb7184fbd2cd9d69be154eb3f913");
        TestDigest.testKatHex(new Luffa224(), "47f5697ac8c31409c0868827347a613a3562041c633cf1f1f86865a576e02835ed2c2492", "03b3a5833e3ea623dd274c2695ea096100dfa4252a602368bbd41fde");
        TestDigest.testKatHex(new Luffa224(), "512a6d292e67ecb2fe486bfe92660953a75484ff4c4f2eca2b0af0edcdd4339c6b2ee4e542", "4e093b0251214d672f1e30093271a269c0c7042a714b6cdb4733ec7d");
        TestDigest.testKatHex(new Luffa224(), "973cf2b4dcf0bfa872b41194cb05bb4e16760a1840d8343301802576197ec19e2a1493d8f4fb", "0c1b2dd372bbdce5708880630ab94e07e9d9cf16c34b2ba9979eff3c");
        TestDigest.testKatHex(new Luffa224(), "80beebcd2e3f8a9451d4499961c9731ae667cdc24ea020ce3b9aa4bbc0a7f79e30a934467da4b0", "6f7d8a893fe5205c50aa4ceab70060a0ac0ad894bd982c4810bc7a13");
        TestDigest.testKatHex(new Luffa224(), "7abaa12ec2a7347674e444140ae0fb659d08e1c66decd8d6eae925fa451d65f3c0308e29446b8ed3", "addd4250956d57d8320bbdaa6c8b230dc428ebf559d837bdc3b27e53");
        TestDigest.testKatHex(new Luffa224(), "c88dee9927679b8af422abcbacf283b904ff31e1cac58c7819809f65d5807d46723b20f67ba610c2b7", "8ee79d61164664ff083e80dc8f35b769409b1542c7a3175be17ff5a3");
        TestDigest.testKatHex(new Luffa224(), "01e43fe350fcec450ec9b102053e6b5d56e09896e0ddd9074fe138e6038210270c834ce6eadc2bb86bf6", "ae2349d1fa2a62b67e7b44578c3f28d72aa5e78d90870e4353dc38b0");
        TestDigest.testKatHex(new Luffa224(), "337023370a48b62ee43546f17c4ef2bf8d7ecd1d49f90bab604b839c2e6e5bd21540d29ba27ab8e309a4b7", "2acd01db8d0ff1ce2660bbf3b53890b6ab767cd2460362b3209fd96d");
        TestDigest.testKatHex(new Luffa224(), "6892540f964c8c74bd2db02c0ad884510cb38afd4438af31fc912756f3efec6b32b58ebc38fc2a6b913596a8", "a124290d7e8e0385ea18f0561f1705f0ed84813ea535f2f9d66a66fb");
        TestDigest.testKatHex(new Luffa224(), "f5961dfd2b1ffffda4ffbf30560c165bfedab8ce0be525845deb8dc61004b7db38467205f5dcfb34a2acfe96c0", "0e8aeb8ea525d66efcc3787cae93cf1d5d13c5bfcc714761f3883df9");
        TestDigest.testKatHex(new Luffa224(), "ca061a2eb6ceed8881ce2057172d869d73a1951e63d57261384b80ceb5451e77b06cf0f5a0ea15ca907ee1c27eba", "9a0e4801a2a79e197d6a540ad46209a948b34c486ac52cb045a0d221");
        TestDigest.testKatHex(new Luffa224(), "1743a77251d69242750c4f1140532cd3c33f9b5ccdf7514e8584d4a5f9fbd730bcf84d0d4726364b9bf95ab251d9bb", "d938d35b8017398b5e28e91aba29eafa11451fb82adebd1e83f13e48");
        TestDigest.testKatHex(new Luffa224(), "d8faba1f5194c4db5f176fabfff856924ef627a37cd08cf55608bba8f1e324d7c7f157298eabc4dce7d89ce5162499f9", "a39529cd1cb4da4f7fb0e7b4c8369056a8b39640a87db75a93d9af2c");
        TestDigest.testKatHex(new Luffa224(), "be9684be70340860373c9c482ba517e899fc81baaa12e5c6d7727975d1d41ba8bef788cdb5cf4606c9c1c7f61aed59f97d", "bc23f022c558eedd1cf03e9dd0be8fbeb97a9793011cfa000f32807a");
        TestDigest.testKatHex(new Luffa224(), "7e15d2b9ea74ca60f66c8dfab377d9198b7b16deb6a1ba0ea3c7ee2042f89d3786e779cf053c77785aa9e692f821f14a7f51", "3738dd9c5354f0baed8f661af0a228332a45c86c2d6da8df007418cc");
        TestDigest.testKatHex(new Luffa224(), "9a219be43713bd578015e9fda66c0f2d83cac563b776ab9f38f3e4f7ef229cb443304fba401efb2bdbd7ece939102298651c86", "77a48025632edca4f3966c6e69375ec8aba0396ab908e9c87cf640c4");
        TestDigest.testKatHex(new Luffa224(), "c8f2b693bd0d75ef99caebdc22adf4088a95a3542f637203e283bbc3268780e787d68d28cc3897452f6a22aa8573ccebf245972a", "7a19772a92ef84c85a89cc2105b274162395a9f9f48d0635239db5ac");
        TestDigest.testKatHex(new Luffa224(), "ec0f99711016c6a2a07ad80d16427506ce6f441059fd269442baaa28c6ca037b22eeac49d5d894c0bf66219f2c08e9d0e8ab21de52", "9654de2f80b74c4fb66765b4a5393fddbb0a3a31f36c944b69acd795");
        TestDigest.testKatHex(new Luffa224(), "0dc45181337ca32a8222fe7a3bf42fc9f89744259cff653504d6051fe84b1a7ffd20cb47d4696ce212a686bb9be9a8ab1c697b6d6a33", "bf147f9bb5cb143f833dadc1c58000ecd5baa3b7033cffa08c2da343");
        TestDigest.testKatHex(new Luffa224(), "de286ba4206e8b005714f80fb1cdfaebde91d29f84603e4a3ebc04686f99a46c9e880b96c574825582e8812a26e5a857ffc6579f63742f", "9f6ab58b301d5bf3c8e739055e89a9d51f202d8a7914aa8a1bc007b8");
        TestDigest.testKatHex(new Luffa224(), "eebcc18057252cbf3f9c070f1a73213356d5d4bc19ac2a411ec8cdeee7a571e2e20eaf61fd0c33a0ffeb297ddb77a97f0a415347db66bcaf", "cb63ff9a4eef2eb55dc2ca58045b7aaef0381e770c29b429403c4b8e");
        TestDigest.testKatHex(new Luffa224(), "416b5cdc9fe951bd361bd7abfc120a5054758eba88fdd68fd84e39d3b09ac25497d36b43cbe7b85a6a3cebda8db4e5549c3ee51bb6fcb6ac1e", "2927461e0023dc414465f89b55df5b93730dbb96f4372f729869e46e");
        TestDigest.testKatHex(new Luffa224(), "5c5faf66f32e0f8311c32e8da8284a4ed60891a5a7e50fb2956b3cbaa79fc66ca376460e100415401fc2b8518c64502f187ea14bfc9503759705", "8d05f2532ecf724afa84f100d74038179bdc1fe789e3f4aa57b714bc");
        TestDigest.testKatHex(new Luffa224(), "7167e1e02be1a7ca69d788666f823ae4eef39271f3c26a5cf7cee05bca83161066dc2e217b330df821103799df6d74810eed363adc4ab99f36046a", "30d642180f2352ffef3746814d2ddd1a835789c9125821e03ea30131");
        TestDigest.testKatHex(new Luffa224(), "2fda311dbba27321c5329510fae6948f03210b76d43e7448d1689a063877b6d14c4f6d0eaa96c150051371f7dd8a4119f7da5c483cc3e6723c01fb7d", "bd39b656c785d3c73a0be80094a067e12dea16209f369da27bf310c0");
        TestDigest.testKatHex(new Luffa224(), "95d1474a5aab5d2422aca6e481187833a6212bd2d0f91451a67dd786dfc91dfed51b35f47e1deb8a8ab4b9cb67b70179cc26f553ae7b569969ce151b8d", "58707573d4274ed093d5fa91576f2823b6fa48246d7488ba0fcb8d0d");
        TestDigest.testKatHex(new Luffa224(), "c71bd7941f41df044a2927a8ff55b4b467c33d089f0988aa253d294addbdb32530c0d4208b10d9959823f0c0f0734684006df79f7099870f6bf53211a88d", "742c924c264f3b6aa9aebfc931451451d32424c2c6723bd9ea07d3df");
        TestDigest.testKatHex(new Luffa224(), "f57c64006d9ea761892e145c99df1b24640883da79d9ed5262859dcda8c3c32e05b03d984f1ab4a230242ab6b78d368dc5aaa1e6d3498d53371e84b0c1d4ba", "0e6ffa34b54f36b1ce8fb186aaa3e78f6a981779d3cfaf69593f7004");
        TestDigest.testKatHex(new Luffa224(), "e926ae8b0af6e53176dbffcc2a6b88c6bd765f939d3d178a9bde9ef3aa131c61e31c1e42cdfaf4b4dcde579a37e150efbef5555b4c1cb40439d835a724e2fae7", "002b4c9191bec2c87b46c23fc79f72fc7b3a2ef242d6b5460d138f49");
        TestDigest.testKatHex(new Luffa224(), "16e8b3d8f988e9bb04de9c96f2627811c973ce4a5296b4772ca3eefeb80a652bdf21f50df79f32db23f9f73d393b2d57d9a0297f7a2f2e79cfda39fa393df1ac00", "6ab389588354b7c5dd7591da8228bed96342d1ca3dec77d6b67be8ea");
        TestDigest.testKatHex(new Luffa224(), "fc424eeb27c18a11c01f39c555d8b78a805b88dba1dc2a42ed5e2c0ec737ff68b2456d80eb85e11714fa3f8eabfb906d3c17964cb4f5e76b29c1765db03d91be37fc", "ed4d17e9de3e9e3322a744ff981c307a74f57cbbfc6eea8c3e88e555");
        TestDigest.testKatHex(new Luffa224(), "abe3472b54e72734bdba7d9158736464251c4f21b33fbbc92d7fac9a35c4e3322ff01d2380cbaa4ef8fb07d21a2128b7b9f5b6d9f34e13f39c7ffc2e72e47888599ba5", "f84724deedf130cf8b0c9d4cac0e3b7727810f800ab115b8ab20bd8b");
        TestDigest.testKatHex(new Luffa224(), "36f9f0a65f2ca498d739b944d6eff3da5ebba57e7d9c41598a2b0e4380f3cf4b479ec2348d015ffe6256273511154afcf3b4b4bf09d6c4744fdd0f62d75079d440706b05", "bc5d5ffd0ae42b04b91fb9bd5c868387a61c9466b1197f8c1cd7bee3");
        TestDigest.testKatHex(new Luffa224(), "abc87763cae1ca98bd8c5b82caba54ac83286f87e9610128ae4de68ac95df5e329c360717bd349f26b872528492ca7c94c2c1e1ef56b74dbb65c2ac351981fdb31d06c77a4", "5fbbe4a62e2b3aefc627334a256768c89ffc67971aed49c53c0f0afa");
        TestDigest.testKatHex(new Luffa224(), "94f7ca8e1a54234c6d53cc734bb3d3150c8ba8c5f880eab8d25fed13793a9701ebe320509286fd8e422e931d99c98da4df7e70ae447bab8cffd92382d8a77760a259fc4fbd72", "8335c00f01f81fdee0586da33d78d0e8099a64e439ee0df192000450");
        TestDigest.reportSuccess("Luffa-224");
    }

    private static void testLuffa256() {
        TestDigest.testKatHex(new Luffa256(), "616263", "f29311b87e9e40de7699be23fbeb5a47cb16ea4f5556d47ca40c12ad764a73bd");
        TestDigest.testKatHex(new Luffa256(), "", "dbb8665871f4154d3e4396aefbba417cb7837dd683c332ba6be87e02a2712d6f");
        TestDigest.testKatHex(new Luffa256(), "cc", "e47d4158bfe03555d370d8fd877ead17d6aa9fdc689a9614c411fbba370c1706");
        TestDigest.testKatHex(new Luffa256(), "41fb", "08cbdd1c9caea9711ab2b30b872ddc09f2954b98ac1850abe3f648f11b76bf92");
        TestDigest.testKatHex(new Luffa256(), "1f877c", "a590d4995c909abd9150398d4ab9465a8e9f768c576921c26a998857e7b0a604");
        TestDigest.testKatHex(new Luffa256(), "c1ecfdfc", "25c82f898f66355aba7a6215d07cab27fbeeedd16b52aa910040b40fda859981");
        TestDigest.testKatHex(new Luffa256(), "21f134ac57", "c3c9b051075ca4da37dd0a43136e1e6566cb147371325e1dbefefb8a26a2c7bf");
        TestDigest.testKatHex(new Luffa256(), "c6f50bb74e29", "81ddb86c64f4a06160121ed6e8a4a50c6144cdf27f5cd0ca85c197d9eb209751");
        TestDigest.testKatHex(new Luffa256(), "119713cc83eeef", "f826d9974939ab9722f3581e51df6587325cd58ed30e0e771a85eb1ee0666023");
        TestDigest.testKatHex(new Luffa256(), "4a4f202484512526", "375a7e893a3b0da1a0ca0272654451c7992a84ca9bd1578cf1507997b20628b5");
        TestDigest.testKatHex(new Luffa256(), "1f66ab4185ed9b6375", "2ae8ccefd8eb75d7767d4db991a6dd36e7d39a35e54a9e205c074d0e28cb9885");
        TestDigest.testKatHex(new Luffa256(), "eed7422227613b6f53c9", "93c5d8f185e9e12490ddcbc46c0d19546dc82763272a07733f368dd7812a2898");
        TestDigest.testKatHex(new Luffa256(), "eaeed5cdffd89dece455f1", "66954c41a49483055b86391fdf4d64c7ce59067656052d53f56d211c8179a8c2");
        TestDigest.testKatHex(new Luffa256(), "5be43c90f22902e4fe8ed2d3", "e3f264279d15b3a0e45475ac23a95bc11d590251d51fded2152815f787730fa8");
        TestDigest.testKatHex(new Luffa256(), "a746273228122f381c3b46e4f1", "72467235c784fbc2d31d0743bf9ef68b0b3a56ae7e2be95f56a2837a6067fefc");
        TestDigest.testKatHex(new Luffa256(), "3c5871cd619c69a63b540eb5a625", "73a6e93b7fbb5a42b15ae6d1863e84d6efa89f4761cdec2f0dd235bcc60a89b0");
        TestDigest.testKatHex(new Luffa256(), "fa22874bcc068879e8ef11a69f0722", "0c76e5a5feaf776d767ff45a27ea06faad4c1a4d893846501caae9ef334cd590");
        TestDigest.testKatHex(new Luffa256(), "52a608ab21ccdd8a4457a57ede782176", "f530e9c931b893d4fb4245b08564046a1baa5f2b51ef30899448661e9716f6ff");
        TestDigest.testKatHex(new Luffa256(), "82e192e4043ddcd12ecf52969d0f807eed", "1f0fb33a7c8e2cefa025791919034dd4685404cc77e82410997d2cfd6866819e");
        TestDigest.testKatHex(new Luffa256(), "75683dcb556140c522543bb6e9098b21a21e", "34ff9975b494979bdfb3ff6f265654aae017c384aa9e8b7ae46fde7b9520aa32");
        TestDigest.testKatHex(new Luffa256(), "06e4efe45035e61faaf4287b4d8d1f12ca97e5", "46dc757a8a3d8d9f336b4d6657918055e0a55c03205cf919959f13fa3d7ae6a9");
        TestDigest.testKatHex(new Luffa256(), "e26193989d06568fe688e75540aea06747d9f851", "419ab3a0c3129fb69c43f0f03760208f036567a69ce19459a488fd7990c62ffb");
        TestDigest.testKatHex(new Luffa256(), "d8dc8fdefbdce9d44e4cbafe78447bae3b5436102a", "383121b1c9e7e2d0e0b0bd63caf89ea25bcfe6092e9e90215c1fd2b7ee8bfb45");
        TestDigest.testKatHex(new Luffa256(), "57085fd7e14216ab102d8317b0cb338a786d5fc32d8f", "2362b7da89251eca923750e51495dccfaac60da85e52a0f6433d3c036a8ea54b");
        TestDigest.testKatHex(new Luffa256(), "a05404df5dbb57697e2c16fa29defac8ab3560d6126fa0", "1f21d604490bfd9e3047dbee4ae78907fdeb1c2109e89018cc3f8f2f1cafa40e");
        TestDigest.testKatHex(new Luffa256(), "aecbb02759f7433d6fcb06963c74061cd83b5b3ffa6f13c6", "a65984fe81e98324c070151b1d726f74c15bd1587732185bdcdec716cdec4767");
        TestDigest.testKatHex(new Luffa256(), "aafdc9243d3d4a096558a360cc27c8d862f0be73db5e88aa55", "136a5ead994a1c7c54332e54910a306cc1aa29fa1d2bab502d7c56f360ccdce6");
        TestDigest.testKatHex(new Luffa256(), "7bc84867f6f9e9fdc3e1046cae3a52c77ed485860ee260e30b15", "653ec34deec311cd38d0d474167183a59cf7b721abe417e4814f486a1ad9b94d");
        TestDigest.testKatHex(new Luffa256(), "fac523575a99ec48279a7a459e98ff901918a475034327efb55843", "0f192b38e98ca792c7f54c845c10e427002be23d0b80c180e0efc8ea1b03ab59");
        TestDigest.testKatHex(new Luffa256(), "0f8b2d8fcfd9d68cffc17ccfb117709b53d26462a3f346fb7c79b85e", "4669eafc59178a5a77aee3621c7d8c932e4434202dbf5118a368d1fb7f5d90d8");
        TestDigest.testKatHex(new Luffa256(), "a963c3e895ff5a0be4824400518d81412f875fa50521e26e85eac90c04", "a415d63928de0792e02820be200e52d32081b34014ae8c779d4ad2a7fa629a8a");
        TestDigest.testKatHex(new Luffa256(), "03a18688b10cc0edf83adf0a84808a9718383c4070c6c4f295098699ac2c", "1ca8f1d71296c07eb13d988db7cec4bccd2f6f9e3c97776b7dc0454058e3157f");
        TestDigest.testKatHex(new Luffa256(), "84fb51b517df6c5accb5d022f8f28da09b10232d42320ffc32dbecc3835b29", "e0d34790dd95f336c67172070982b61f715d2ce3f8d5afb95e003f89fdf8c888");
        TestDigest.testKatHex(new Luffa256(), "9f2fcc7c90de090d6b87cd7e9718c1ea6cb21118fc2d5de9f97e5db6ac1e9c10", "a2604f434b7bea9b156c54fe297869edb1b1249b38b0923884fe25d835e0909b");
        TestDigest.testKatHex(new Luffa256(), "de8f1b3faa4b7040ed4563c3b8e598253178e87e4d0df75e4ff2f2dedd5a0be046", "abbc5e77ba63a5a9569e0b4b346ef944b3c4b9f287f2aa0029b2aea1b7b2de61");
        TestDigest.testKatHex(new Luffa256(), "62f154ec394d0bc757d045c798c8b87a00e0655d0481a7d2d9fb58d93aedc676b5a0", "519ae93d6bd290988e243044bd92729e8f05d4d546fa3d44f8fd54728b70a113");
        TestDigest.testKatHex(new Luffa256(), "b2dcfe9ff19e2b23ce7da2a4207d3e5ec7c6112a8a22aec9675a886378e14e5bfbad4e", "f08f2d55cf38e44355547ec8c9adcb7184fbd2cd9d69be154eb3f91385d1d17f");
        TestDigest.testKatHex(new Luffa256(), "47f5697ac8c31409c0868827347a613a3562041c633cf1f1f86865a576e02835ed2c2492", "03b3a5833e3ea623dd274c2695ea096100dfa4252a602368bbd41fde3f05761a");
        TestDigest.testKatHex(new Luffa256(), "512a6d292e67ecb2fe486bfe92660953a75484ff4c4f2eca2b0af0edcdd4339c6b2ee4e542", "4e093b0251214d672f1e30093271a269c0c7042a714b6cdb4733ec7db10207af");
        TestDigest.testKatHex(new Luffa256(), "973cf2b4dcf0bfa872b41194cb05bb4e16760a1840d8343301802576197ec19e2a1493d8f4fb", "0c1b2dd372bbdce5708880630ab94e07e9d9cf16c34b2ba9979eff3cb0ffbb80");
        TestDigest.testKatHex(new Luffa256(), "80beebcd2e3f8a9451d4499961c9731ae667cdc24ea020ce3b9aa4bbc0a7f79e30a934467da4b0", "6f7d8a893fe5205c50aa4ceab70060a0ac0ad894bd982c4810bc7a13a9168be8");
        TestDigest.testKatHex(new Luffa256(), "7abaa12ec2a7347674e444140ae0fb659d08e1c66decd8d6eae925fa451d65f3c0308e29446b8ed3", "addd4250956d57d8320bbdaa6c8b230dc428ebf559d837bdc3b27e531dbed955");
        TestDigest.testKatHex(new Luffa256(), "c88dee9927679b8af422abcbacf283b904ff31e1cac58c7819809f65d5807d46723b20f67ba610c2b7", "8ee79d61164664ff083e80dc8f35b769409b1542c7a3175be17ff5a39ca57f5f");
        TestDigest.testKatHex(new Luffa256(), "01e43fe350fcec450ec9b102053e6b5d56e09896e0ddd9074fe138e6038210270c834ce6eadc2bb86bf6", "ae2349d1fa2a62b67e7b44578c3f28d72aa5e78d90870e4353dc38b08ff638db");
        TestDigest.testKatHex(new Luffa256(), "337023370a48b62ee43546f17c4ef2bf8d7ecd1d49f90bab604b839c2e6e5bd21540d29ba27ab8e309a4b7", "2acd01db8d0ff1ce2660bbf3b53890b6ab767cd2460362b3209fd96d84510182");
        TestDigest.testKatHex(new Luffa256(), "6892540f964c8c74bd2db02c0ad884510cb38afd4438af31fc912756f3efec6b32b58ebc38fc2a6b913596a8", "a124290d7e8e0385ea18f0561f1705f0ed84813ea535f2f9d66a66fba269e49b");
        TestDigest.testKatHex(new Luffa256(), "f5961dfd2b1ffffda4ffbf30560c165bfedab8ce0be525845deb8dc61004b7db38467205f5dcfb34a2acfe96c0", "0e8aeb8ea525d66efcc3787cae93cf1d5d13c5bfcc714761f3883df9ff9e47d9");
        TestDigest.testKatHex(new Luffa256(), "ca061a2eb6ceed8881ce2057172d869d73a1951e63d57261384b80ceb5451e77b06cf0f5a0ea15ca907ee1c27eba", "9a0e4801a2a79e197d6a540ad46209a948b34c486ac52cb045a0d221e124fe31");
        TestDigest.testKatHex(new Luffa256(), "1743a77251d69242750c4f1140532cd3c33f9b5ccdf7514e8584d4a5f9fbd730bcf84d0d4726364b9bf95ab251d9bb", "d938d35b8017398b5e28e91aba29eafa11451fb82adebd1e83f13e48e0c68639");
        TestDigest.testKatHex(new Luffa256(), "d8faba1f5194c4db5f176fabfff856924ef627a37cd08cf55608bba8f1e324d7c7f157298eabc4dce7d89ce5162499f9", "a39529cd1cb4da4f7fb0e7b4c8369056a8b39640a87db75a93d9af2c5c94cdf5");
        TestDigest.testKatHex(new Luffa256(), "be9684be70340860373c9c482ba517e899fc81baaa12e5c6d7727975d1d41ba8bef788cdb5cf4606c9c1c7f61aed59f97d", "bc23f022c558eedd1cf03e9dd0be8fbeb97a9793011cfa000f32807a0721b7e0");
        TestDigest.testKatHex(new Luffa256(), "7e15d2b9ea74ca60f66c8dfab377d9198b7b16deb6a1ba0ea3c7ee2042f89d3786e779cf053c77785aa9e692f821f14a7f51", "3738dd9c5354f0baed8f661af0a228332a45c86c2d6da8df007418cc02f276ef");
        TestDigest.testKatHex(new Luffa256(), "9a219be43713bd578015e9fda66c0f2d83cac563b776ab9f38f3e4f7ef229cb443304fba401efb2bdbd7ece939102298651c86", "77a48025632edca4f3966c6e69375ec8aba0396ab908e9c87cf640c4d897cd99");
        TestDigest.testKatHex(new Luffa256(), "c8f2b693bd0d75ef99caebdc22adf4088a95a3542f637203e283bbc3268780e787d68d28cc3897452f6a22aa8573ccebf245972a", "7a19772a92ef84c85a89cc2105b274162395a9f9f48d0635239db5ace4fc3e88");
        TestDigest.testKatHex(new Luffa256(), "ec0f99711016c6a2a07ad80d16427506ce6f441059fd269442baaa28c6ca037b22eeac49d5d894c0bf66219f2c08e9d0e8ab21de52", "9654de2f80b74c4fb66765b4a5393fddbb0a3a31f36c944b69acd7956d8cc452");
        TestDigest.testKatHex(new Luffa256(), "0dc45181337ca32a8222fe7a3bf42fc9f89744259cff653504d6051fe84b1a7ffd20cb47d4696ce212a686bb9be9a8ab1c697b6d6a33", "bf147f9bb5cb143f833dadc1c58000ecd5baa3b7033cffa08c2da343f67caa2b");
        TestDigest.testKatHex(new Luffa256(), "de286ba4206e8b005714f80fb1cdfaebde91d29f84603e4a3ebc04686f99a46c9e880b96c574825582e8812a26e5a857ffc6579f63742f", "9f6ab58b301d5bf3c8e739055e89a9d51f202d8a7914aa8a1bc007b83675ee3c");
        TestDigest.testKatHex(new Luffa256(), "eebcc18057252cbf3f9c070f1a73213356d5d4bc19ac2a411ec8cdeee7a571e2e20eaf61fd0c33a0ffeb297ddb77a97f0a415347db66bcaf", "cb63ff9a4eef2eb55dc2ca58045b7aaef0381e770c29b429403c4b8eab6b204b");
        TestDigest.testKatHex(new Luffa256(), "416b5cdc9fe951bd361bd7abfc120a5054758eba88fdd68fd84e39d3b09ac25497d36b43cbe7b85a6a3cebda8db4e5549c3ee51bb6fcb6ac1e", "2927461e0023dc414465f89b55df5b93730dbb96f4372f729869e46e7a6437b0");
        TestDigest.testKatHex(new Luffa256(), "5c5faf66f32e0f8311c32e8da8284a4ed60891a5a7e50fb2956b3cbaa79fc66ca376460e100415401fc2b8518c64502f187ea14bfc9503759705", "8d05f2532ecf724afa84f100d74038179bdc1fe789e3f4aa57b714bc71274d2d");
        TestDigest.testKatHex(new Luffa256(), "7167e1e02be1a7ca69d788666f823ae4eef39271f3c26a5cf7cee05bca83161066dc2e217b330df821103799df6d74810eed363adc4ab99f36046a", "30d642180f2352ffef3746814d2ddd1a835789c9125821e03ea3013167667cc9");
        TestDigest.testKatHex(new Luffa256(), "2fda311dbba27321c5329510fae6948f03210b76d43e7448d1689a063877b6d14c4f6d0eaa96c150051371f7dd8a4119f7da5c483cc3e6723c01fb7d", "bd39b656c785d3c73a0be80094a067e12dea16209f369da27bf310c097548b8c");
        TestDigest.testKatHex(new Luffa256(), "95d1474a5aab5d2422aca6e481187833a6212bd2d0f91451a67dd786dfc91dfed51b35f47e1deb8a8ab4b9cb67b70179cc26f553ae7b569969ce151b8d", "58707573d4274ed093d5fa91576f2823b6fa48246d7488ba0fcb8d0d25b28e33");
        TestDigest.testKatHex(new Luffa256(), "c71bd7941f41df044a2927a8ff55b4b467c33d089f0988aa253d294addbdb32530c0d4208b10d9959823f0c0f0734684006df79f7099870f6bf53211a88d", "742c924c264f3b6aa9aebfc931451451d32424c2c6723bd9ea07d3df05c6cc5e");
        TestDigest.testKatHex(new Luffa256(), "f57c64006d9ea761892e145c99df1b24640883da79d9ed5262859dcda8c3c32e05b03d984f1ab4a230242ab6b78d368dc5aaa1e6d3498d53371e84b0c1d4ba", "0e6ffa34b54f36b1ce8fb186aaa3e78f6a981779d3cfaf69593f70044ea77995");
        TestDigest.testKatHex(new Luffa256(), "e926ae8b0af6e53176dbffcc2a6b88c6bd765f939d3d178a9bde9ef3aa131c61e31c1e42cdfaf4b4dcde579a37e150efbef5555b4c1cb40439d835a724e2fae7", "002b4c9191bec2c87b46c23fc79f72fc7b3a2ef242d6b5460d138f4995e4fea1");
        TestDigest.testKatHex(new Luffa256(), "16e8b3d8f988e9bb04de9c96f2627811c973ce4a5296b4772ca3eefeb80a652bdf21f50df79f32db23f9f73d393b2d57d9a0297f7a2f2e79cfda39fa393df1ac00", "6ab389588354b7c5dd7591da8228bed96342d1ca3dec77d6b67be8eae8bcff80");
        TestDigest.testKatHex(new Luffa256(), "fc424eeb27c18a11c01f39c555d8b78a805b88dba1dc2a42ed5e2c0ec737ff68b2456d80eb85e11714fa3f8eabfb906d3c17964cb4f5e76b29c1765db03d91be37fc", "ed4d17e9de3e9e3322a744ff981c307a74f57cbbfc6eea8c3e88e555b8149530");
        TestDigest.testKatHex(new Luffa256(), "abe3472b54e72734bdba7d9158736464251c4f21b33fbbc92d7fac9a35c4e3322ff01d2380cbaa4ef8fb07d21a2128b7b9f5b6d9f34e13f39c7ffc2e72e47888599ba5", "f84724deedf130cf8b0c9d4cac0e3b7727810f800ab115b8ab20bd8ba62756dc");
        TestDigest.testKatHex(new Luffa256(), "36f9f0a65f2ca498d739b944d6eff3da5ebba57e7d9c41598a2b0e4380f3cf4b479ec2348d015ffe6256273511154afcf3b4b4bf09d6c4744fdd0f62d75079d440706b05", "bc5d5ffd0ae42b04b91fb9bd5c868387a61c9466b1197f8c1cd7bee3666b5ec6");
        TestDigest.testKatHex(new Luffa256(), "abc87763cae1ca98bd8c5b82caba54ac83286f87e9610128ae4de68ac95df5e329c360717bd349f26b872528492ca7c94c2c1e1ef56b74dbb65c2ac351981fdb31d06c77a4", "5fbbe4a62e2b3aefc627334a256768c89ffc67971aed49c53c0f0afa9fb317a5");
        TestDigest.testKatHex(new Luffa256(), "94f7ca8e1a54234c6d53cc734bb3d3150c8ba8c5f880eab8d25fed13793a9701ebe320509286fd8e422e931d99c98da4df7e70ae447bab8cffd92382d8a77760a259fc4fbd72", "8335c00f01f81fdee0586da33d78d0e8099a64e439ee0df192000450de39441a");
        TestDigest.reportSuccess("Luffa-256");
    }

    private static void testLuffa384() {
        TestDigest.testKatHex(new Luffa384(), "", "117d3ad49024dfe2994f4e335c9b330b48c537a13a9b7fa465938e1a02ff862bcdf33838bc0f371b045d26952d3ea0c5");
        TestDigest.testKatHex(new Luffa384(), "cc", "e1979d16848976ca9ff183ec28998ab3d4b56942497f8e2c6d51895a96c7465df6d7b66d6ba9636a16dbe51aae6d2eb9");
        TestDigest.testKatHex(new Luffa384(), "41fb", "836e9c8429d4a071935c72b0e575ea4cca81642dc14a98a87307e02ac2d812682ce3eeaf8043330a7ea5cbe3a578b5d2");
        TestDigest.testKatHex(new Luffa384(), "1f877c", "0aff61867c087908d2b9742012bb980cae833c79fd4ecaaea31bc1279f4ce356d6308c36d1fd0dbe70f652b0e2c66d35");
        TestDigest.testKatHex(new Luffa384(), "c1ecfdfc", "3736466ca7dc43a81025378e6ce678fe010ebb06382a73113af39104cea0f9bf00e27d12e0a1e7f37516e5cd0f2e9752");
        TestDigest.testKatHex(new Luffa384(), "21f134ac57", "fac3b3788807c40cfe268f27534aaddbd85ca21444add77d96acfc2b05f992143be70a8ef21db3aa6057974b5824f886");
        TestDigest.testKatHex(new Luffa384(), "c6f50bb74e29", "5186e3872799f8fbcbfcca6522a6c05e900386d543795dd288766dff642ddd30f5dfe0a6d5a515ae0d86e6e0a66a4f58");
        TestDigest.testKatHex(new Luffa384(), "119713cc83eeef", "d5dccf4694b4a67a3d0e31e87bf0afcfcfeed912d882658adfa8372f7d04591e4c7a1657018de7dcd458b56f2c3ab630");
        TestDigest.testKatHex(new Luffa384(), "4a4f202484512526", "1b4ede443782fe73d5844d47f7f55ebbdb58fcdbc0adc9a572cdf117bbe955134a96c5c7886b424ef8d8d183ecc5d19a");
        TestDigest.testKatHex(new Luffa384(), "1f66ab4185ed9b6375", "7772a0c884ee0b24eddd7d863db7d28a0902268054eb4098539881c0530473a8a6d5ad4ab0168c58dc6788d31a65e3f9");
        TestDigest.testKatHex(new Luffa384(), "eed7422227613b6f53c9", "5a4d1aeace552e5e133f3f3d0b31858551dba12e025a25a951697de6bdf1ab619505b3a1b6a9a8bb4ec8bc198f3cba69");
        TestDigest.testKatHex(new Luffa384(), "eaeed5cdffd89dece455f1", "d0e814fb9b74019b9efe6f78769ab6d2d3c8a1e34eaf9466ef848a732c9f2b548860f826bebd7ffe0185aebe59537e4f");
        TestDigest.testKatHex(new Luffa384(), "5be43c90f22902e4fe8ed2d3", "768e4ded90617e4465d56db01db1aa410e07d8fabc509e1096465ed1866c6a61ca4d0b8221944feeee0d755eb15f2af8");
        TestDigest.testKatHex(new Luffa384(), "a746273228122f381c3b46e4f1", "3f799bc392ca79e7a7d71a3fdb513b86eb871bd3c718c1ce7091c88e431208c76a94aeeecb822cfc7b71876ed83bc98c");
        TestDigest.testKatHex(new Luffa384(), "3c5871cd619c69a63b540eb5a625", "de35e068ec1be3f0f412d609a972e2a59b01cf3231fec41adc3ddf4f980cd474a80dcb698e2d57147272d91226029a90");
        TestDigest.testKatHex(new Luffa384(), "fa22874bcc068879e8ef11a69f0722", "f9ca1ed09b57bef64ba99a0ac98755ca8eb18be1327848c47f1b6d39a39bdaaf407123e90ce188f65795341c7096d64b");
        TestDigest.testKatHex(new Luffa384(), "52a608ab21ccdd8a4457a57ede782176", "394558843fea14250669a5cca36b84df6732647f6fee8ecd7ede5bfc7a2ebabf74533c48bff82572aa3dfa0ae4564eb8");
        TestDigest.testKatHex(new Luffa384(), "82e192e4043ddcd12ecf52969d0f807eed", "23218697306f93c00658accc0eb3f35d7ba52c2192c3c9827529d9060a34c34973dec6ee04880c9a7d84230cc73cef34");
        TestDigest.testKatHex(new Luffa384(), "75683dcb556140c522543bb6e9098b21a21e", "831f03dfcdf779526ccdc7a9a8e15089dd131eb049ecf5fa86c0b91ac3a780b46d3e7f26f73787abe04ca6809aba51a9");
        TestDigest.testKatHex(new Luffa384(), "06e4efe45035e61faaf4287b4d8d1f12ca97e5", "4528e5bbf2e2f7b94651bc77adea5fa66a96bed6e8f94979a00e492669f073735d9fc382c2574a1a1b264b1ddc13a2c2");
        TestDigest.testKatHex(new Luffa384(), "e26193989d06568fe688e75540aea06747d9f851", "cad5fd9e36b5f6f3782dd69d3396a34ff59d5ac6547f855fbbb688c8412ef7a3a1ef859c6a61ffc947e6a26d86dd9187");
        TestDigest.testKatHex(new Luffa384(), "d8dc8fdefbdce9d44e4cbafe78447bae3b5436102a", "2bca547654d4ad268e8e080b5484d6607876dff50c1021c855bfe48ca9ce51cfe0f79f671c61c4c43622c1d704270079");
        TestDigest.testKatHex(new Luffa384(), "57085fd7e14216ab102d8317b0cb338a786d5fc32d8f", "0107a50f8089e18be40c5d7f3b0475205f95b9214f1d8eb32a17c1fa77b9e4ccc5eee3077d19b6305875d7643c76fcc6");
        TestDigest.testKatHex(new Luffa384(), "a05404df5dbb57697e2c16fa29defac8ab3560d6126fa0", "d5abeb0c1452ca4e66f947e2305212fec57bce96a1c7e9c346500977fc8219957baf362de9107031313ed3208ecdf825");
        TestDigest.testKatHex(new Luffa384(), "aecbb02759f7433d6fcb06963c74061cd83b5b3ffa6f13c6", "112293cc150e8b5b040c4f07c561a90e1afdf21b0dda7577c75f2f0adae3da1170573250fab5cabe28349b693cd70ee8");
        TestDigest.testKatHex(new Luffa384(), "aafdc9243d3d4a096558a360cc27c8d862f0be73db5e88aa55", "0a8bedcd7c5a0f979e4c3e1a2158eb02aa75b878e76da0efd218a847ba5c2f8ef1f1e642d5aeea34c24af3832923fd2f");
        TestDigest.testKatHex(new Luffa384(), "7bc84867f6f9e9fdc3e1046cae3a52c77ed485860ee260e30b15", "91bfc94131fc79c53edf5f7f935b025a712392015e45aa93743e6106bf7fde180a45343cd94f3595f7caf8c8d21dc8c5");
        TestDigest.testKatHex(new Luffa384(), "fac523575a99ec48279a7a459e98ff901918a475034327efb55843", "b2804db486b75336ac60c7f0da77a30123c65784813d7ed2d59500814c5af1bac0ab44ab7d30804c310f58d20f13a6a4");
        TestDigest.testKatHex(new Luffa384(), "0f8b2d8fcfd9d68cffc17ccfb117709b53d26462a3f346fb7c79b85e", "219277be04f39bd533a53de928f4bb92f7a402b11b150359aeaae4fde883eda50007b89b44d77be25e66add1813e7006");
        TestDigest.testKatHex(new Luffa384(), "a963c3e895ff5a0be4824400518d81412f875fa50521e26e85eac90c04", "89b3f7d4f593d12eb2fab8f7ac4ad8aae8b8a5ceb1b78ffba874b63132cbf66b03d44bbeb9697a24c735142a892b8174");
        TestDigest.testKatHex(new Luffa384(), "03a18688b10cc0edf83adf0a84808a9718383c4070c6c4f295098699ac2c", "0b1ae626b76bea8f765aa9ba7a1ff9ebb24fcbb21e8dca3886ad2c1c459b9f1f2e638d516d8fc13baa00278da809731f");
        TestDigest.testKatHex(new Luffa384(), "84fb51b517df6c5accb5d022f8f28da09b10232d42320ffc32dbecc3835b29", "949451902c0a00fc04a97a8d59bef41c4f39645b6f3f80b8b6ed5c6a2b615fef61f17577394756d6262e25bafd0c13b7");
        TestDigest.testKatHex(new Luffa384(), "9f2fcc7c90de090d6b87cd7e9718c1ea6cb21118fc2d5de9f97e5db6ac1e9c10", "58df58119b690814dca7f845ab5bfe4837d51f9f59d9ef8835ea9cd4a8dc172ffd3bae6bf75139d2f85225e9972969f2");
        TestDigest.testKatHex(new Luffa384(), "de8f1b3faa4b7040ed4563c3b8e598253178e87e4d0df75e4ff2f2dedd5a0be046", "e3253247d8e3740a7030e47ae190a760cddb9ddbba4b3383693df43dd21d1897dd292f5d43b40e5654d8ac27d7a805c4");
        TestDigest.testKatHex(new Luffa384(), "62f154ec394d0bc757d045c798c8b87a00e0655d0481a7d2d9fb58d93aedc676b5a0", "e413cc9f5a00e79a47d6d87ded153276c18b0fb3708ba1c5d92107d756ac5f489337fd06d6091d5353bf457c7740a6f9");
        TestDigest.testKatHex(new Luffa384(), "b2dcfe9ff19e2b23ce7da2a4207d3e5ec7c6112a8a22aec9675a886378e14e5bfbad4e", "b6ab6aca3309d91b0155b0ff42ad32caa35cbb4597d9db32280275a23744a1e5f0630275f7de3af8e39a39dbc5cf17e0");
        TestDigest.testKatHex(new Luffa384(), "47f5697ac8c31409c0868827347a613a3562041c633cf1f1f86865a576e02835ed2c2492", "27fb306fd7e0ae1fa8122835df37db90f0c9f1869a32cd10dd21bb380dbe88623683d88bc48422f2ede44c53bdda1f4a");
        TestDigest.testKatHex(new Luffa384(), "512a6d292e67ecb2fe486bfe92660953a75484ff4c4f2eca2b0af0edcdd4339c6b2ee4e542", "52157924efefdcbbb56647ec9a70ec1372d92217bf699f92902ff227d08ddae72677b83d97304efaaffe280c83a6ed77");
        TestDigest.testKatHex(new Luffa384(), "973cf2b4dcf0bfa872b41194cb05bb4e16760a1840d8343301802576197ec19e2a1493d8f4fb", "d60477e6d917ef6e1b2a0ce414b11e69b89b41ac27f82314c256cf30a972405306c2983a2c2b1d7ae2365273b050a4b1");
        TestDigest.testKatHex(new Luffa384(), "80beebcd2e3f8a9451d4499961c9731ae667cdc24ea020ce3b9aa4bbc0a7f79e30a934467da4b0", "6b4183eb6f7dca54fb511f422a3f4f72c1bb62d7cefd27f5d0b071cff05d9cbce61c44596c6561e2b03ae7a257d7a5a3");
        TestDigest.testKatHex(new Luffa384(), "7abaa12ec2a7347674e444140ae0fb659d08e1c66decd8d6eae925fa451d65f3c0308e29446b8ed3", "52769b8dbb7dccf0835e1cf5dbd2aadfe9c3a1d737d5ea366a82afc799224fc8aa80c7dda3996fdac2e19bd5d12035ec");
        TestDigest.testKatHex(new Luffa384(), "c88dee9927679b8af422abcbacf283b904ff31e1cac58c7819809f65d5807d46723b20f67ba610c2b7", "71390e32929d2b2ccfa59118c5498bec49b0b84ac35e79aec45d552b53e4a11c7174ce32ce54fe0770f43882b9bc62c2");
        TestDigest.testKatHex(new Luffa384(), "01e43fe350fcec450ec9b102053e6b5d56e09896e0ddd9074fe138e6038210270c834ce6eadc2bb86bf6", "384eed23f96247c86745426dfc91745cb2eb61c06acbbde100be0a6cb6f1b05e280cff5e715220b119d27de7118abd60");
        TestDigest.testKatHex(new Luffa384(), "337023370a48b62ee43546f17c4ef2bf8d7ecd1d49f90bab604b839c2e6e5bd21540d29ba27ab8e309a4b7", "5e80aaf8ce209e6f1822eae305e380ad0ec0a338c21876c94dde423455b8be041b9d62def9575b24905d859623a24bb6");
        TestDigest.testKatHex(new Luffa384(), "6892540f964c8c74bd2db02c0ad884510cb38afd4438af31fc912756f3efec6b32b58ebc38fc2a6b913596a8", "5202d481175a692e952600330c48a8f149e5168e8a96c83497b7204f4e807dadd81f90790d5db9adbb6958445132e1f7");
        TestDigest.testKatHex(new Luffa384(), "f5961dfd2b1ffffda4ffbf30560c165bfedab8ce0be525845deb8dc61004b7db38467205f5dcfb34a2acfe96c0", "c04b9d79687212147470f218a50b93985a4d9712783b90d963768935db7bbf9c8e3cbb61b73a3c03e605ce258b84b369");
        TestDigest.testKatHex(new Luffa384(), "ca061a2eb6ceed8881ce2057172d869d73a1951e63d57261384b80ceb5451e77b06cf0f5a0ea15ca907ee1c27eba", "7cfaa6b8f152dbe1bd1ae0dfd60a05867d761f837ab5b83fecf2de311f5f045b70b08e51beeb9416dc07efb64f8a6b6d");
        TestDigest.testKatHex(new Luffa384(), "1743a77251d69242750c4f1140532cd3c33f9b5ccdf7514e8584d4a5f9fbd730bcf84d0d4726364b9bf95ab251d9bb", "9d4da47ee0d789ade021f4f830d15bcbce68522327c86979a692a5db54963da8f02eff45b87e9c7f50a85978ed565a94");
        TestDigest.testKatHex(new Luffa384(), "d8faba1f5194c4db5f176fabfff856924ef627a37cd08cf55608bba8f1e324d7c7f157298eabc4dce7d89ce5162499f9", "5d5ad92160a9648cf631278299db1b7b2a69acec0f0843bb081b59efcf2df13b7f7a1999c409021c99f510b233dc220e");
        TestDigest.testKatHex(new Luffa384(), "be9684be70340860373c9c482ba517e899fc81baaa12e5c6d7727975d1d41ba8bef788cdb5cf4606c9c1c7f61aed59f97d", "db42633f3fc8b92d3fe596ce42295e6afb5a7256ba468a10bc1571f9cf9d4374bd87ea5f2f3617b669404543cdf17857");
        TestDigest.testKatHex(new Luffa384(), "7e15d2b9ea74ca60f66c8dfab377d9198b7b16deb6a1ba0ea3c7ee2042f89d3786e779cf053c77785aa9e692f821f14a7f51", "f817c628a6de77077f8e5424c7c1e0a7bd966f6b7bf7fddeb625094e1481a0213d3058dccacdbe4f060f303002061bbd");
        TestDigest.testKatHex(new Luffa384(), "9a219be43713bd578015e9fda66c0f2d83cac563b776ab9f38f3e4f7ef229cb443304fba401efb2bdbd7ece939102298651c86", "4fc8277eeeae11593f226fc202fd10376e8e90700cded36251334e95646a1b846a770f46d582af40c9da97e17c7bd1ab");
        TestDigest.testKatHex(new Luffa384(), "c8f2b693bd0d75ef99caebdc22adf4088a95a3542f637203e283bbc3268780e787d68d28cc3897452f6a22aa8573ccebf245972a", "7c7e305439b7cdb1e73fdc31246ad70f3ea70374f6e876902aac66b6a76a720575fd938c5f88b99bab2abafdcb334441");
        TestDigest.testKatHex(new Luffa384(), "ec0f99711016c6a2a07ad80d16427506ce6f441059fd269442baaa28c6ca037b22eeac49d5d894c0bf66219f2c08e9d0e8ab21de52", "c0996611cc8075f327e427bca6aac253e2985196fcc1da0e5b6946e838d2719f31b45e559eae2c5c4b1cc61f848969b1");
        TestDigest.testKatHex(new Luffa384(), "0dc45181337ca32a8222fe7a3bf42fc9f89744259cff653504d6051fe84b1a7ffd20cb47d4696ce212a686bb9be9a8ab1c697b6d6a33", "cbae6d91fd89f6a5872daffafd0693c57e3ed1b62ee90573714a251cf0e7af7ce1c38b2361bfef360f3c18938863b511");
        TestDigest.testKatHex(new Luffa384(), "de286ba4206e8b005714f80fb1cdfaebde91d29f84603e4a3ebc04686f99a46c9e880b96c574825582e8812a26e5a857ffc6579f63742f", "47ca5bec323bc8938ce409eda83bde8830b21c783585fbc47dd4502845a105bfacbfa74aeba7f95d6b2a73636acc75d1");
        TestDigest.testKatHex(new Luffa384(), "eebcc18057252cbf3f9c070f1a73213356d5d4bc19ac2a411ec8cdeee7a571e2e20eaf61fd0c33a0ffeb297ddb77a97f0a415347db66bcaf", "213319c72a262d45d5a342fc1346ca8bc48ed732bb33a1d01025f31b9136d3ce5bcaca413e318f09bf539fcf23384a10");
        TestDigest.testKatHex(new Luffa384(), "416b5cdc9fe951bd361bd7abfc120a5054758eba88fdd68fd84e39d3b09ac25497d36b43cbe7b85a6a3cebda8db4e5549c3ee51bb6fcb6ac1e", "dcf6e726ce6ad81fceb15fbea8b5b667a38125fd5a51c0d54f044da420771349cca3a1c473256641812b71aae446e6d9");
        TestDigest.testKatHex(new Luffa384(), "5c5faf66f32e0f8311c32e8da8284a4ed60891a5a7e50fb2956b3cbaa79fc66ca376460e100415401fc2b8518c64502f187ea14bfc9503759705", "f7480880c5d48aecdc50f991344c59913e7794d95d078a4390b15aec86265526fc32a213fb922be68c94025cc76e507c");
        TestDigest.testKatHex(new Luffa384(), "7167e1e02be1a7ca69d788666f823ae4eef39271f3c26a5cf7cee05bca83161066dc2e217b330df821103799df6d74810eed363adc4ab99f36046a", "b5df2530dcb996a08ac587fd9c5c5f54cd5b967cc3f3f3bf746e0866a1fae607bd76d26adab4de37035fa37f60112d6b");
        TestDigest.testKatHex(new Luffa384(), "2fda311dbba27321c5329510fae6948f03210b76d43e7448d1689a063877b6d14c4f6d0eaa96c150051371f7dd8a4119f7da5c483cc3e6723c01fb7d", "5425812b422a5af7e4299b7759e85727186566ace7f088f98125814b2d545ed6228803476a52a0118fe5a7fbbacce296");
        TestDigest.testKatHex(new Luffa384(), "95d1474a5aab5d2422aca6e481187833a6212bd2d0f91451a67dd786dfc91dfed51b35f47e1deb8a8ab4b9cb67b70179cc26f553ae7b569969ce151b8d", "dc51485e19cd24f7588414b5cd26d52ab0c149663c7fc3ab19e00186aa733f2d1269d8b3e82f0a8c678f24e10703e5b0");
        TestDigest.testKatHex(new Luffa384(), "c71bd7941f41df044a2927a8ff55b4b467c33d089f0988aa253d294addbdb32530c0d4208b10d9959823f0c0f0734684006df79f7099870f6bf53211a88d", "b7ad2d74e0da5854223161c6853ad48e45e6da48277ac245140813629d6ddcb265db17930efcfe189f8675ce9f8a2425");
        TestDigest.testKatHex(new Luffa384(), "f57c64006d9ea761892e145c99df1b24640883da79d9ed5262859dcda8c3c32e05b03d984f1ab4a230242ab6b78d368dc5aaa1e6d3498d53371e84b0c1d4ba", "4bf036e19b92ff175300d1ac1203942996caab2c6c4989ee38d6fd2f0680aee950dc13619f3c0c61d22c11418bfc6cf8");
        TestDigest.testKatHex(new Luffa384(), "e926ae8b0af6e53176dbffcc2a6b88c6bd765f939d3d178a9bde9ef3aa131c61e31c1e42cdfaf4b4dcde579a37e150efbef5555b4c1cb40439d835a724e2fae7", "ec2b1c4f9b86c459b80c8023380b3145628359ed983be18118fafecbaecf6fe4022186ff8365ccd5b4956cbbf082912a");
        TestDigest.testKatHex(new Luffa384(), "16e8b3d8f988e9bb04de9c96f2627811c973ce4a5296b4772ca3eefeb80a652bdf21f50df79f32db23f9f73d393b2d57d9a0297f7a2f2e79cfda39fa393df1ac00", "1bfbbdd31754a84dd057156388b484e94385a191e96fa87fecf8640023c4270cdf7d4285033e680d45662f6335504c0e");
        TestDigest.testKatHex(new Luffa384(), "fc424eeb27c18a11c01f39c555d8b78a805b88dba1dc2a42ed5e2c0ec737ff68b2456d80eb85e11714fa3f8eabfb906d3c17964cb4f5e76b29c1765db03d91be37fc", "d19e24696f866479235b05951f30a047b05fa4c60b67fc701ad8a67cac10dcf9670d3018e55d06c909870bf7e6cd653f");
        TestDigest.testKatHex(new Luffa384(), "abe3472b54e72734bdba7d9158736464251c4f21b33fbbc92d7fac9a35c4e3322ff01d2380cbaa4ef8fb07d21a2128b7b9f5b6d9f34e13f39c7ffc2e72e47888599ba5", "a09f988e222424ada34db954f78296ec3517c8b91eb78fd436bddce0ab7e5b19ecc8e388c23324e53173960622e08337");
        TestDigest.testKatHex(new Luffa384(), "36f9f0a65f2ca498d739b944d6eff3da5ebba57e7d9c41598a2b0e4380f3cf4b479ec2348d015ffe6256273511154afcf3b4b4bf09d6c4744fdd0f62d75079d440706b05", "3d5887d2237a992f5eef41b660c0cbf1a56b59854ac1089daae4242c88472b209ef975a253d9785719c2115b767df57b");
        TestDigest.testKatHex(new Luffa384(), "abc87763cae1ca98bd8c5b82caba54ac83286f87e9610128ae4de68ac95df5e329c360717bd349f26b872528492ca7c94c2c1e1ef56b74dbb65c2ac351981fdb31d06c77a4", "b4c2e78596a3fd88250fe66ed7fa7b171b738000c7bc8383e436afacad75e49f8ef4d96ceb400085ef3631c71c022d4c");
        TestDigest.testKatHex(new Luffa384(), "94f7ca8e1a54234c6d53cc734bb3d3150c8ba8c5f880eab8d25fed13793a9701ebe320509286fd8e422e931d99c98da4df7e70ae447bab8cffd92382d8a77760a259fc4fbd72", "4b902d53f10843e3fd3a8a3756ca310705e278fc6e9a969c8948eef8f359ca820e870d07564f01349cc7a035b2149865");
        TestDigest.reportSuccess("Luffa-384");
    }

    private static void testLuffa512() {
        TestDigest.testKatHex(new Luffa512(), "", "6e7de4501189b3ca58f3ac114916654bbcd4922024b4cc1cd764acfe8ab4b7805df133eab345ffdb1c414564c924f48e0a301824e2ac4c34bd4efde2e43da90e");
        TestDigest.testKatHex(new Luffa512(), "cc", "91f1b09b2842871bc2f069e5d278d2d707ddafabfe3ced5154faf841e96781908290e6533d146183e8b7ec298f6da20e0cfb1d41f4f711a3050faa8dd4641f7f");
        TestDigest.testKatHex(new Luffa512(), "41fb", "3448d8766e1c8cf84ca83d0882305a8ebcab3f9c5b87f8f1bb94ec8abbe86320e6d33024fbe9363595ed3b36bf49a5440a1248f0606940aec1321fc74dbb6be5");
        TestDigest.testKatHex(new Luffa512(), "1f877c", "327ed73e847b90a1d098250020e45915ce4991b686e3920043ab17f026b2d3c77f9fed996673d527e4a1f628fb2f4f05949d3eabb0b00d9967063877e4370015");
        TestDigest.testKatHex(new Luffa512(), "c1ecfdfc", "d6c06a024d386a58a01d9c5852229593f2197bd9f3afc9eb3f3230807d99c06d8eeb7aa36d7eea74fda69ec1356191985cadedb24bf0c312ba1db9e974442b16");
        TestDigest.testKatHex(new Luffa512(), "21f134ac57", "7b576d395d624f6ffff5e97954b56b9e5bcdd6f50beaedd2a0e24e2439cb48f1e567b1d7442eb3d60c95be6c366967689b9b59d79a5794e764c2708386e5a8e2");
        TestDigest.testKatHex(new Luffa512(), "c6f50bb74e29", "08e6c3b2b275005ba963ea7a06d16a4397f9895b635956ff8c5fc53fdc3684f3883297743e2776690f69669ab816e7cfdcbffad427026f6e7f22eef93832dfe0");
        TestDigest.testKatHex(new Luffa512(), "119713cc83eeef", "9851c57d40c270a591e1ae43bec788ade7dbe0457d33aa04d606989b298285bb98c80a16931b915d76f3f57d3d4f4a1c90a4032473fd2ce888e1f68d3789326f");
        TestDigest.testKatHex(new Luffa512(), "4a4f202484512526", "ad830c702679ca7fe84433d12ed53fd9aa66156b0eb52caa995562ef5e8ebbc76379c5f0aaab163c24734ef7ad839d4f410d3bad9f70586c3361378207b511df");
        TestDigest.testKatHex(new Luffa512(), "1f66ab4185ed9b6375", "2d0288e2090f0d306a033c96c2d17d6cf6d9803d682e01f40c83890156e872152a24dd26a9812b2b7bdbb31670d22a2f8c492e592ed5c2a9076ebb2a55014772");
        TestDigest.testKatHex(new Luffa512(), "eed7422227613b6f53c9", "b5a3c5ab94a5ef494f661a293e08887e11b88494205b2509f08f80865da88081a3a617c262f04d02fd27dc14c1c1148c42c461bfad549796b844eeff40049c68");
        TestDigest.testKatHex(new Luffa512(), "eaeed5cdffd89dece455f1", "69e208680961bcf7494eb2ad39814cbeec2c9268fe36fd3a8544ea3a0195ef5175e060ff547b0f7c626358168114040d026747eec4aa21d3068a5c6e8e5395f0");
        TestDigest.testKatHex(new Luffa512(), "5be43c90f22902e4fe8ed2d3", "40244bedd3d17b5d59b56ed2db0891b4cb7af510ba2b28064691d15aa8ac2eeab04c0aeb70ce2b385878e313bc5c68938d6b6797d2e6bf9eb7f7d28992a036df");
        TestDigest.testKatHex(new Luffa512(), "a746273228122f381c3b46e4f1", "e8955edd828e3bf0db896e394aefc9ca7ee0e39622ca7649023506500d2d673fcbb1ba341ca35713ff1f07d45c2503b966ddef23ec5a4e8bce61f1dd0492e32d");
        TestDigest.testKatHex(new Luffa512(), "3c5871cd619c69a63b540eb5a625", "e72e941ff72b4fc0af23e0bd26fc091482f835c07602cdaede6e4ccba090f106a4bc90b39449c3f29987af3daa29dc0960b73593299a8927651de9e4d229b402");
        TestDigest.testKatHex(new Luffa512(), "fa22874bcc068879e8ef11a69f0722", "6871089aa1edf7ce1aee06eb67db3fffb9f29ddf829cb456eb86eb6c2a2b75bdd78316fd77be821c3d397af0135f3218ffc5a8a937f1b50cb96a970e995e8d3d");
        TestDigest.testKatHex(new Luffa512(), "52a608ab21ccdd8a4457a57ede782176", "575eace1ac1a16b1f16ee6b8b5fa48713125a5f842e9238b1f2ddf79a25146831085786418ea8f4b51b3d2b48a715170e59cbdd951c47732eb24df2a6651b0f5");
        TestDigest.testKatHex(new Luffa512(), "82e192e4043ddcd12ecf52969d0f807eed", "b0ab1ccbe68b22e9db2965167823ebc8c0a583f22ca364d36e62b533d1f7ead625786d05373aa1d187306ddeacba095222c32be3b277f461efb9f32c822b9558");
        TestDigest.testKatHex(new Luffa512(), "75683dcb556140c522543bb6e9098b21a21e", "0e27c1cd3107b8ca95e65e823a2a2fbd609a191a0636ba98d9ab4d3e8e414c1d11a93cfcf1f30cc359a00dd7900dc3bf02c3403f730b6bfd414bac761f82678c");
        TestDigest.testKatHex(new Luffa512(), "06e4efe45035e61faaf4287b4d8d1f12ca97e5", "9cb8887ec665e0e1a90e2d2c7f442fa4c2617446f5bb5b59b1aab4e09aa1dacf3e97fa1f58567a7b53d36b08f0970ba19412c3cc9713081a099b4b3fa0e7c568");
        TestDigest.testKatHex(new Luffa512(), "e26193989d06568fe688e75540aea06747d9f851", "4942b78508cae719dda5785b2571fe70301a63c38bd497913ed807946a77fa95920daad6ffc45939b21b8471ed2685490d2c1c6fd2c0ae2b16c4e494741dfe2a");
        TestDigest.testKatHex(new Luffa512(), "d8dc8fdefbdce9d44e4cbafe78447bae3b5436102a", "730fff7f3a49b3602b9d242363b8e5a34864c4c20c0d432ac2bbfdf7a6d37646218827e541c600f3e50b45757058a69a89b6f011190247ad6f3c3b3df856a93e");
        TestDigest.testKatHex(new Luffa512(), "57085fd7e14216ab102d8317b0cb338a786d5fc32d8f", "6ca5c58bfa1926944efd1f9ae424943113723d8fe47612b8f0c180c01b6bda241490d51be3f4efc5dc1b4b77ec34e1ed555d93005bb2feac8441bab4624a4708");
        TestDigest.testKatHex(new Luffa512(), "a05404df5dbb57697e2c16fa29defac8ab3560d6126fa0", "437e0f52bf9d00e95417ecad1a1dc4ab7b08e2b5cc5d4b910d960213e3ef8a3ace82500ce01b014c0a8db1cc91e22f0c85fdb057f01d50f0e2916d3ae09683f8");
        TestDigest.testKatHex(new Luffa512(), "aecbb02759f7433d6fcb06963c74061cd83b5b3ffa6f13c6", "78ad8a9b487907c61ff260707b31f743ff1b5dfbb812649d096cc619930d2010b9496f299d0bc36e5962f53a085a8981a9ce624d4624bd782c8269fbd994b236");
        TestDigest.testKatHex(new Luffa512(), "aafdc9243d3d4a096558a360cc27c8d862f0be73db5e88aa55", "73a90fd7a44c4cf6dd4cb1c0c6b19cad555e42b5ab7656dd4853170a83a48984643de31a07452d402cf4a918633bd2aaf792f4b2f3cd13f0d26636d676182c20");
        TestDigest.testKatHex(new Luffa512(), "7bc84867f6f9e9fdc3e1046cae3a52c77ed485860ee260e30b15", "dc8e61e71ebca8a192261c58b89d68c9cd835a0e645f8dd0c7ebda540c57fd8de08f9de43592f2137799c7a1b5b4e1810878a51c468eb2e602f174732b47d5ee");
        TestDigest.testKatHex(new Luffa512(), "fac523575a99ec48279a7a459e98ff901918a475034327efb55843", "9668efbe7be895a5a1266515e4c7d20eb7a8ed00a445ee36eaa0a8bcd487eaee5aae8941a52c4d6a2fe6553c225634da769512dde2e3b03d973ad671802ef801");
        TestDigest.testKatHex(new Luffa512(), "0f8b2d8fcfd9d68cffc17ccfb117709b53d26462a3f346fb7c79b85e", "710531d66d7fe05830bbf9da7c513a6a8513fdb5c0519bbe44700ee5646f00301628b438c8004475a5109dc50c823e0b11b5bfeea246bb8e6cd7fa31863e657f");
        TestDigest.testKatHex(new Luffa512(), "a963c3e895ff5a0be4824400518d81412f875fa50521e26e85eac90c04", "810d2c6c277acc914cec0b98c89abf84d98449472915771fa2fab1f9af96eb5518d796c6cb1c7f4631ed7f4fce2a8a20d0a97c6871a9646e02d7158a376f92b3");
        TestDigest.testKatHex(new Luffa512(), "03a18688b10cc0edf83adf0a84808a9718383c4070c6c4f295098699ac2c", "3e0c4bf565f63ae391cfb164dfb30439ce81edfef6eee1da3767740916288bd4a2ea783ac32874c5f939156bd045515369c03cfa50db62f79ead4932f2b6117f");
        TestDigest.testKatHex(new Luffa512(), "84fb51b517df6c5accb5d022f8f28da09b10232d42320ffc32dbecc3835b29", "8c423ef68e6ebc93711884e2ce53c5dfdb9e4ce52fdce4c11143985f204df2949e15c908a14e807aaa409f90a0c0fefbb7436af034339f9d9f229a9c5de05b43");
        TestDigest.testKatHex(new Luffa512(), "9f2fcc7c90de090d6b87cd7e9718c1ea6cb21118fc2d5de9f97e5db6ac1e9c10", "ccf8e56977551f2e8d69122fb6f2ae4db6ac44198898aa2cc9af01c373b02822f46c872f22eac53cdbacfabd87f8165a94d121fe58f670cf38affb73e6e22619");
        TestDigest.testKatHex(new Luffa512(), "de8f1b3faa4b7040ed4563c3b8e598253178e87e4d0df75e4ff2f2dedd5a0be046", "8a9ce6fa86ce71456fda0cc3c67f0830a2f2012c6e63142d363c6f549f1124a10eaf196d8e44757e51847d7fda4fdbde31e74cd747fc57226d14eacf302b7dc5");
        TestDigest.testKatHex(new Luffa512(), "62f154ec394d0bc757d045c798c8b87a00e0655d0481a7d2d9fb58d93aedc676b5a0", "ea711ecd5d6d29680379a01d61b9aabdc271cc73c531a7e9fae4708e18c0f7177924acd913cb49dead9e60ab1a10f8f8f37137072084c4b8768bd493fd8862a8");
        TestDigest.testKatHex(new Luffa512(), "b2dcfe9ff19e2b23ce7da2a4207d3e5ec7c6112a8a22aec9675a886378e14e5bfbad4e", "b215df95dcd3aa20001d1eaa3ae6a88506d1a897795c9b5b736a26c0595343feac5e57d602316458d77cc4952249a1e48fad5219677903d37352036ba4fc74d7");
        TestDigest.testKatHex(new Luffa512(), "47f5697ac8c31409c0868827347a613a3562041c633cf1f1f86865a576e02835ed2c2492", "1726be6a7b9fca0a43e6350272631eaf24119ef7f8acce8b3489e46fb68ef5623dce5b3473c062fe5414d8462477efd10dd4526cfb70b67116ba4d2859fbe5ea");
        TestDigest.testKatHex(new Luffa512(), "512a6d292e67ecb2fe486bfe92660953a75484ff4c4f2eca2b0af0edcdd4339c6b2ee4e542", "1bdaba0419cf95c66943dd3fc8b7e23aabe970482aa9467ee6d8cfb73e1653eb0adb4c7145dddce546cc05a1f7746a02519265136b759da3dc670e5559590c4b");
        TestDigest.testKatHex(new Luffa512(), "973cf2b4dcf0bfa872b41194cb05bb4e16760a1840d8343301802576197ec19e2a1493d8f4fb", "aed0743f6de0ef70b7610f3f4f4eafe67d9f80f01de9bad0970435cb41de796aef7f2d19d8c965a9bbb6dea9cd87f1bf2faa5d73717dab948bac6808ae186bf5");
        TestDigest.testKatHex(new Luffa512(), "80beebcd2e3f8a9451d4499961c9731ae667cdc24ea020ce3b9aa4bbc0a7f79e30a934467da4b0", "7a918e7d7ca5e165f1ab76a091da9de7b73469ffefb79a6a09ad99c7d0eaa37aa035d7feb1b1f92a78fc895a419b1ca7fa6a4c4a37200cbf53510bb6d376f594");
        TestDigest.testKatHex(new Luffa512(), "7abaa12ec2a7347674e444140ae0fb659d08e1c66decd8d6eae925fa451d65f3c0308e29446b8ed3", "c1ecf8daff34596ba651cf9034495bfd277409dfac5360d9149ab1bade8c2d1174368960454d8b1183ab141f36dc71f8722b318de37644b75db098cf69070999");
        TestDigest.testKatHex(new Luffa512(), "c88dee9927679b8af422abcbacf283b904ff31e1cac58c7819809f65d5807d46723b20f67ba610c2b7", "01e7023cc6864bd2982fde528801652a7bc28f2928854efc18b782672bffa5275ae24ec3ebde3b4c251f61036dfdf94c6b75725ac2fc05272d61dae67bf3d156");
        TestDigest.testKatHex(new Luffa512(), "01e43fe350fcec450ec9b102053e6b5d56e09896e0ddd9074fe138e6038210270c834ce6eadc2bb86bf6", "183f86ad1dd7b0ab9327858b1d0eba337a14fc856b1a5276e60b1746234c17ab116b07102a4d747502c6337f49535b960c8e75b223a735d8b17a7e3c222ba780");
        TestDigest.testKatHex(new Luffa512(), "337023370a48b62ee43546f17c4ef2bf8d7ecd1d49f90bab604b839c2e6e5bd21540d29ba27ab8e309a4b7", "ebb9747b256674d4e70b383a49de10c63541b3dde85e6de1642e72ba4402292e16f38b7da3f20ce02d39597d8294c1a80c7dee5f4234922bb86ec45bfaa857c3");
        TestDigest.testKatHex(new Luffa512(), "6892540f964c8c74bd2db02c0ad884510cb38afd4438af31fc912756f3efec6b32b58ebc38fc2a6b913596a8", "62741b52443d54c898a70dc88e5be7a796b014a94bbdc8d87a0dc326fb88b7e54155dc0c8bde7c3ea0fb6841902c8b32286156279f1006d661c9297f171855c5");
        TestDigest.testKatHex(new Luffa512(), "f5961dfd2b1ffffda4ffbf30560c165bfedab8ce0be525845deb8dc61004b7db38467205f5dcfb34a2acfe96c0", "a9d068a8ac64dbab2a7c608e2d6984d1747f654c2a2788fcb8d964621a74a1faf3cdc06e7609da121baab53d3a6ee7564a29311d1d363989406aef88c74fcf0b");
        TestDigest.testKatHex(new Luffa512(), "ca061a2eb6ceed8881ce2057172d869d73a1951e63d57261384b80ceb5451e77b06cf0f5a0ea15ca907ee1c27eba", "8f18bb3723dce6bab11c297ce8f9de6bd055808649ee2282b79e8097291dc5dbaf9c0f773273497383a9bcb2ea33aa4efbf63b73279ffc643728e8583fa1cb9f");
        TestDigest.testKatHex(new Luffa512(), "1743a77251d69242750c4f1140532cd3c33f9b5ccdf7514e8584d4a5f9fbd730bcf84d0d4726364b9bf95ab251d9bb", "39076a478874b64c5f869f343d9224286d581d79e038e0f61aaada077d67fb095fca54b126ddd5f7be561a7a7d6c1a704eaab605ea20a0a618f7b63084f34497");
        TestDigest.testKatHex(new Luffa512(), "d8faba1f5194c4db5f176fabfff856924ef627a37cd08cf55608bba8f1e324d7c7f157298eabc4dce7d89ce5162499f9", "7f7c889e9e8d72d5123eb80f2c96633ebcdd7baec0a6f47d8dc30f844d34e4407b93076506f74ccfd226ae2c4f6278507de606c6398594132ac03ec54d1a3a93");
        TestDigest.testKatHex(new Luffa512(), "be9684be70340860373c9c482ba517e899fc81baaa12e5c6d7727975d1d41ba8bef788cdb5cf4606c9c1c7f61aed59f97d", "a946194ae6362f5d37659d3cf625779847dc890eba942e4ccc3422edca22458beb717af2699d5e4b7bac319974e9a87512c28790d92f28d1df9f5995fb07911d");
        TestDigest.testKatHex(new Luffa512(), "7e15d2b9ea74ca60f66c8dfab377d9198b7b16deb6a1ba0ea3c7ee2042f89d3786e779cf053c77785aa9e692f821f14a7f51", "0ad9cce6a271f42a78a5f0f1ce9f1251a1e8304a2f9b0685c0a508462555d05f33f4f44fabe0ae54d2a58ea19350b825dd25444c5c07616fb4ab741469ebc1b1");
        TestDigest.testKatHex(new Luffa512(), "9a219be43713bd578015e9fda66c0f2d83cac563b776ab9f38f3e4f7ef229cb443304fba401efb2bdbd7ece939102298651c86", "39d0d70c9703e551e9435b2c8c64d98c341c5b842842f8de88cb2424dd13d77f188b13086b45de9868c5f71359a3dbdf9ccefb9ffc87b10d30932870bf1f1766");
        TestDigest.testKatHex(new Luffa512(), "c8f2b693bd0d75ef99caebdc22adf4088a95a3542f637203e283bbc3268780e787d68d28cc3897452f6a22aa8573ccebf245972a", "caf30faf0d446fc8bc52b7050d7c49a60e8e40bb1ec26ff0a0a9b75edd7475a605bed2f8624d6c8e3f83744a6c2e65490ea1ec39765a93dc4a3608906c315df4");
        TestDigest.testKatHex(new Luffa512(), "ec0f99711016c6a2a07ad80d16427506ce6f441059fd269442baaa28c6ca037b22eeac49d5d894c0bf66219f2c08e9d0e8ab21de52", "e22d89cfd14c01ab7e659f731b7a8364fbb1115fc626e930a990112c4e3144b189cb74c4f2e094deaebc4f0c35eda4bc6e517fc2871147419da6e477341b4a9c");
        TestDigest.testKatHex(new Luffa512(), "0dc45181337ca32a8222fe7a3bf42fc9f89744259cff653504d6051fe84b1a7ffd20cb47d4696ce212a686bb9be9a8ab1c697b6d6a33", "575307712f2425d3e9640dc43d2d7c8618e62b1d017c0c19068c2db98501243b18177431f586f43ba5ff4617ac2918fefc39144b45c96d7241b501786fb7fb50");
        TestDigest.testKatHex(new Luffa512(), "de286ba4206e8b005714f80fb1cdfaebde91d29f84603e4a3ebc04686f99a46c9e880b96c574825582e8812a26e5a857ffc6579f63742f", "30ffdcb029e5a11805c465329d05b0b39cdd564444f245e067a6d8b31a7c8fb5ee3246fafadf63bfd411f9394511a520e32f2c5cf87ba265a4f64e1a2c56669b");
        TestDigest.testKatHex(new Luffa512(), "eebcc18057252cbf3f9c070f1a73213356d5d4bc19ac2a411ec8cdeee7a571e2e20eaf61fd0c33a0ffeb297ddb77a97f0a415347db66bcaf", "a071071928b7fb529f7f2ebd72287a6a77fbcef5654a19e68335e0b575845d7b9f52a870060bc92e115181de96389aef2b4d8bf748f5f81438f2119c375f9acd");
        TestDigest.testKatHex(new Luffa512(), "416b5cdc9fe951bd361bd7abfc120a5054758eba88fdd68fd84e39d3b09ac25497d36b43cbe7b85a6a3cebda8db4e5549c3ee51bb6fcb6ac1e", "c57282ba2493ca6277851165048f690454dd97a8da0a100c7b483024815fe14afe7e023db8852b1603039d44cfcbe16ef537a349a5196ae044247a7d677724cc");
        TestDigest.testKatHex(new Luffa512(), "5c5faf66f32e0f8311c32e8da8284a4ed60891a5a7e50fb2956b3cbaa79fc66ca376460e100415401fc2b8518c64502f187ea14bfc9503759705", "c27062a0c9c27cc11d3f4ae6612340a6ad88f874a249f24669f712ca3ab1cf1ff66794dd262a67c04a822b2c8a6a85382b9c81c867cfa469c6012e56529dcf45");
        TestDigest.testKatHex(new Luffa512(), "7167e1e02be1a7ca69d788666f823ae4eef39271f3c26a5cf7cee05bca83161066dc2e217b330df821103799df6d74810eed363adc4ab99f36046a", "0d253f2d01ce47c10919f06526e1400f373137c1902bd7e71177efc5d8e673c009d85ec9b16bdd1a2d2690040d6f25847ab20a0bea9d8590d56645057170b89d");
        TestDigest.testKatHex(new Luffa512(), "2fda311dbba27321c5329510fae6948f03210b76d43e7448d1689a063877b6d14c4f6d0eaa96c150051371f7dd8a4119f7da5c483cc3e6723c01fb7d", "529e8eca9b0275a6c6178e8764d14cd660b2651f47a67b296296fb81080678dbb38d57d2bd367e60e9f59c2a736eff5209b1b9d4ce2e80847c5d62cfe96bc0d2");
        TestDigest.testKatHex(new Luffa512(), "95d1474a5aab5d2422aca6e481187833a6212bd2d0f91451a67dd786dfc91dfed51b35f47e1deb8a8ab4b9cb67b70179cc26f553ae7b569969ce151b8d", "d49efefec450e46e9c3d9efea0e8839361c477af1c671fa515c27608b8064a0c7497529e6253e0a8e8d00a4c24113010fb5f02dbdffc29d716be0096ca03ec79");
        TestDigest.testKatHex(new Luffa512(), "c71bd7941f41df044a2927a8ff55b4b467c33d089f0988aa253d294addbdb32530c0d4208b10d9959823f0c0f0734684006df79f7099870f6bf53211a88d", "2365557868737474eb9734982c1381da7e35b9391e632b2339027775504c4e86a7a45709a64ee06e97819da0bf95d5fa62ca6f0658be4945b67a74ba02385628");
        TestDigest.testKatHex(new Luffa512(), "f57c64006d9ea761892e145c99df1b24640883da79d9ed5262859dcda8c3c32e05b03d984f1ab4a230242ab6b78d368dc5aaa1e6d3498d53371e84b0c1d4ba", "5f685015ccbdb4affe23d2d985e7931380ea79c7c44d8834820a6b6eb7af552bc4ae788adeaf42bcc8403dd3ac559d48e88644e2040e404551794b520660f72f");
        TestDigest.testKatHex(new Luffa512(), "e926ae8b0af6e53176dbffcc2a6b88c6bd765f939d3d178a9bde9ef3aa131c61e31c1e42cdfaf4b4dcde579a37e150efbef5555b4c1cb40439d835a724e2fae7", "e18b08234bed8586b8d40314dc2854086d8d85ddf83b321800b4039bf162fc4ab9229ca3d34f5c554e8409ef70a50c13164d00094142a6139b36e3ab911c81de");
        TestDigest.testKatHex(new Luffa512(), "16e8b3d8f988e9bb04de9c96f2627811c973ce4a5296b4772ca3eefeb80a652bdf21f50df79f32db23f9f73d393b2d57d9a0297f7a2f2e79cfda39fa393df1ac00", "64e3ce3acec24013749dc8f8854eea890c1a714879d35967d89f9df12fcd068956e9c230040fb7c405ff98c962173da4218684a766113615a7924ca20ebffbb0");
        TestDigest.testKatHex(new Luffa512(), "fc424eeb27c18a11c01f39c555d8b78a805b88dba1dc2a42ed5e2c0ec737ff68b2456d80eb85e11714fa3f8eabfb906d3c17964cb4f5e76b29c1765db03d91be37fc", "5c1482084a214f77cd90ab0dc96cbe726e1df208f79562d3514e07bcc14027f0213a091d0ee337a502d2611346385f37894b13fbe145f5963804483cbb932be6");
        TestDigest.testKatHex(new Luffa512(), "abe3472b54e72734bdba7d9158736464251c4f21b33fbbc92d7fac9a35c4e3322ff01d2380cbaa4ef8fb07d21a2128b7b9f5b6d9f34e13f39c7ffc2e72e47888599ba5", "d52772799d7563737a377da549f9227f5f2708ff74f6320122bf6bafe268b927fd726147e17a7fcf77cc483957f3ffe5c3f61edeee2db0e76698435549757990");
        TestDigest.testKatHex(new Luffa512(), "36f9f0a65f2ca498d739b944d6eff3da5ebba57e7d9c41598a2b0e4380f3cf4b479ec2348d015ffe6256273511154afcf3b4b4bf09d6c4744fdd0f62d75079d440706b05", "b11d01a32b72f715a530567e0a672a9f97c59b3cc9337955c95d8e1d0f7d75f5535cf5e20e2080162e447f8a8d5c37f0116336c4dd0946323af728e4b80fd8f5");
        TestDigest.testKatHex(new Luffa512(), "abc87763cae1ca98bd8c5b82caba54ac83286f87e9610128ae4de68ac95df5e329c360717bd349f26b872528492ca7c94c2c1e1ef56b74dbb65c2ac351981fdb31d06c77a4", "ce5fecb999ca6283ed980bd85d4ebe75431529adfce3a74e658cb4af5c8fe65d603f0c7ab183485d8360cfe2a505de4aee026288c6845e88f1a4b5a6e069acf3");
        TestDigest.testKatHex(new Luffa512(), "94f7ca8e1a54234c6d53cc734bb3d3150c8ba8c5f880eab8d25fed13793a9701ebe320509286fd8e422e931d99c98da4df7e70ae447bab8cffd92382d8a77760a259fc4fbd72", "ec624ed0d48d3dc3c7dddf4d6b6217c815addda9b9b45f9bc38189f7794214bc21eff46cb48b4cfad225b9e78397fb9ac91a193906febc94e0fc7129f0525d24");
        TestDigest.reportSuccess("Luffa-512");
    }

    private static void testECHO224() {
        TestDigest.testKatHex(new ECHO224(), "", "17da087595166f733fff7cdb0bca6438f303d0e00c48b5e7a3075905");
        TestDigest.testKatHex(new ECHO224(), "cc", "34d81c434b63c8fbcf023b6417af87d906942ebd7b56c1d7b08baddc");
        TestDigest.testKatHex(new ECHO224(), "41fb", "63f315e0cc161aa98749d9783866ec2c2bf70cd033431e97eb8c6963");
        TestDigest.testKatHex(new ECHO224(), "1f877c", "ed7a2952cbc3068c58ff4c870ab850afa0a499fe64fb2e943655ab88");
        TestDigest.testKatHex(new ECHO224(), "c1ecfdfc", "6ed24b67ec06a8f6e9b4d707244e3f61859c855c9fa17b1b60792b8f");
        TestDigest.testKatHex(new ECHO224(), "21f134ac57", "5bc9aed703b41bb3834f6ec3902ddd93c2f4f6f6a2dfc7cf6be68138");
        TestDigest.testKatHex(new ECHO224(), "c6f50bb74e29", "9d1828002b45002d0229842f23b707c4c5495851172ddc31586a9c5b");
        TestDigest.testKatHex(new ECHO224(), "119713cc83eeef", "e952c88c5b80c44cd60e45acafc4e118f8be45900b5b4e5ab6f4dec9");
        TestDigest.testKatHex(new ECHO224(), "4a4f202484512526", "4bf079d0c16ae30e50718648d51ad2555ebb8de85dd9e95c208d4fe1");
        TestDigest.testKatHex(new ECHO224(), "1f66ab4185ed9b6375", "e0db938f5da99f15f01e12058f47b5e0d0deeb3cf2c294dcf2d4cb67");
        TestDigest.testKatHex(new ECHO224(), "eed7422227613b6f53c9", "f42bc8129a630fad8264c6c03de36af1e06410456af1dcb1d3892b82");
        TestDigest.testKatHex(new ECHO224(), "eaeed5cdffd89dece455f1", "9b1f14acfa8684656271250e932df68884f5dab64e862b41a13f86fd");
        TestDigest.testKatHex(new ECHO224(), "5be43c90f22902e4fe8ed2d3", "c787d4615eae6e733e2f450bedee3fe0428c9e46f817d1724cd46f98");
        TestDigest.testKatHex(new ECHO224(), "a746273228122f381c3b46e4f1", "650d6d201d844ce59fd154057322223a70130b49de0c253e2051e494");
        TestDigest.testKatHex(new ECHO224(), "3c5871cd619c69a63b540eb5a625", "ce6e89b3b7621fb025d8588d07ab061c0f6b4d630d77753e8cd77c47");
        TestDigest.testKatHex(new ECHO224(), "fa22874bcc068879e8ef11a69f0722", "cdea3f0b9a6e6b4dc1463bd034da527f487d85bebe2be003868e0262");
        TestDigest.testKatHex(new ECHO224(), "52a608ab21ccdd8a4457a57ede782176", "3fe94695d66d210b63c91148a96fb37da75a36d1e65e4eb743d5f8e3");
        TestDigest.testKatHex(new ECHO224(), "82e192e4043ddcd12ecf52969d0f807eed", "a9c4c76789fa34d15beff34a30aafc1d732d362ac368d1b7431ef27c");
        TestDigest.testKatHex(new ECHO224(), "75683dcb556140c522543bb6e9098b21a21e", "2bf8d2df3fb47e06329d19088b9805f824bbc92d45b3efd316fe5e2a");
        TestDigest.testKatHex(new ECHO224(), "06e4efe45035e61faaf4287b4d8d1f12ca97e5", "fdf5097bf98f917587ddf677bc729b97d4b9a302de9b4e08d76e3bda");
        TestDigest.testKatHex(new ECHO224(), "e26193989d06568fe688e75540aea06747d9f851", "1fd6bfc350e86dd170fee060c28ea957272b0813c445949fb35c7cbd");
        TestDigest.testKatHex(new ECHO224(), "d8dc8fdefbdce9d44e4cbafe78447bae3b5436102a", "bde986c5c6254cbd4b03b448d683b657ad395799203b44f079cf9345");
        TestDigest.testKatHex(new ECHO224(), "57085fd7e14216ab102d8317b0cb338a786d5fc32d8f", "3ee22e50b29b4ba6e2b6049c2f7e880372530b60946a41580ad39e65");
        TestDigest.testKatHex(new ECHO224(), "a05404df5dbb57697e2c16fa29defac8ab3560d6126fa0", "b3cb1c71acb776b6b32cabbc669cf1c8c8fc47aa90ecd951ee4b5e06");
        TestDigest.testKatHex(new ECHO224(), "aecbb02759f7433d6fcb06963c74061cd83b5b3ffa6f13c6", "2585b6a7e3209fc6e5462f4535abcf17d3c8461affffbe5b5489e2a8");
        TestDigest.testKatHex(new ECHO224(), "aafdc9243d3d4a096558a360cc27c8d862f0be73db5e88aa55", "f163edf2ee049a27aa6282b7caabbcabdf3d8fd0a6f3f1d336a84194");
        TestDigest.testKatHex(new ECHO224(), "7bc84867f6f9e9fdc3e1046cae3a52c77ed485860ee260e30b15", "c2515ab2a2b8a35d6ca8e83e8000d83db63124a2871253f010abbb4d");
        TestDigest.testKatHex(new ECHO224(), "fac523575a99ec48279a7a459e98ff901918a475034327efb55843", "37410ad0da878b59868817280aafcbfae3a28a60d93d5ca9c2cb294d");
        TestDigest.testKatHex(new ECHO224(), "0f8b2d8fcfd9d68cffc17ccfb117709b53d26462a3f346fb7c79b85e", "6ca755bee2b8cec0d953f7fd52f7943858e583351cc0837b76fac933");
        TestDigest.testKatHex(new ECHO224(), "a963c3e895ff5a0be4824400518d81412f875fa50521e26e85eac90c04", "f3c47d36520e669354bcb9f12c039238af5af087a0ef1425ce5dde2f");
        TestDigest.testKatHex(new ECHO224(), "03a18688b10cc0edf83adf0a84808a9718383c4070c6c4f295098699ac2c", "8ea6fed934040eced00cfd72c4802dcbd911889b59790281813e776d");
        TestDigest.testKatHex(new ECHO224(), "84fb51b517df6c5accb5d022f8f28da09b10232d42320ffc32dbecc3835b29", "3e217abbd13d4efa1ea2d1bc5a0510430b0ff4b2f2624f31c5f322f6");
        TestDigest.testKatHex(new ECHO224(), "9f2fcc7c90de090d6b87cd7e9718c1ea6cb21118fc2d5de9f97e5db6ac1e9c10", "6d36008b8178c85c79c4e501b95f654b01123a4aad6951d13a420fd6");
        TestDigest.testKatHex(new ECHO224(), "de8f1b3faa4b7040ed4563c3b8e598253178e87e4d0df75e4ff2f2dedd5a0be046", "49506ce768794d91eea89f4fc407e33244f64a80b6462a1d722b0ab2");
        TestDigest.testKatHex(new ECHO224(), "62f154ec394d0bc757d045c798c8b87a00e0655d0481a7d2d9fb58d93aedc676b5a0", "3951aea1fee0ac6cc19507571f989a44f796348b9e81519aa9f1b580");
        TestDigest.testKatHex(new ECHO224(), "b2dcfe9ff19e2b23ce7da2a4207d3e5ec7c6112a8a22aec9675a886378e14e5bfbad4e", "ad3b8f15cc789e1602443335189fb77c59d1f1469e75a0b218e64a94");
        TestDigest.testKatHex(new ECHO224(), "47f5697ac8c31409c0868827347a613a3562041c633cf1f1f86865a576e02835ed2c2492", "bab7ce2c66f90e1b8cd7620c429b0b09c0c60485a79f804fde9d4f2d");
        TestDigest.testKatHex(new ECHO224(), "512a6d292e67ecb2fe486bfe92660953a75484ff4c4f2eca2b0af0edcdd4339c6b2ee4e542", "abf48e34a5b27168c3d8c3a80bc54e01e1047c208fce10865ee488f9");
        TestDigest.testKatHex(new ECHO224(), "973cf2b4dcf0bfa872b41194cb05bb4e16760a1840d8343301802576197ec19e2a1493d8f4fb", "eccc93b1a3347ad60ebfdfc7ba2d7c1a18b94584d2377f1a418435aa");
        TestDigest.testKatHex(new ECHO224(), "80beebcd2e3f8a9451d4499961c9731ae667cdc24ea020ce3b9aa4bbc0a7f79e30a934467da4b0", "7bdb6fe2fbfa641ad170387ec664a63954790606182ab983cc01d5c0");
        TestDigest.testKatHex(new ECHO224(), "7abaa12ec2a7347674e444140ae0fb659d08e1c66decd8d6eae925fa451d65f3c0308e29446b8ed3", "f3e29412a3cbc3d268e159d4f9832944d533d354beb4f37918d442e1");
        TestDigest.testKatHex(new ECHO224(), "c88dee9927679b8af422abcbacf283b904ff31e1cac58c7819809f65d5807d46723b20f67ba610c2b7", "ff5241d1d47a3a3f2510696ee06d0d3ebbfee0a49964487a339e06b7");
        TestDigest.testKatHex(new ECHO224(), "01e43fe350fcec450ec9b102053e6b5d56e09896e0ddd9074fe138e6038210270c834ce6eadc2bb86bf6", "b32ca427f9ce2c3590c6932501e688ed2b87bfb0e2e3eff4154877a4");
        TestDigest.testKatHex(new ECHO224(), "337023370a48b62ee43546f17c4ef2bf8d7ecd1d49f90bab604b839c2e6e5bd21540d29ba27ab8e309a4b7", "4d68ea206d2e616cdfed80afdc44eede5f9b2b92dd7adec827f3b2b4");
        TestDigest.testKatHex(new ECHO224(), "6892540f964c8c74bd2db02c0ad884510cb38afd4438af31fc912756f3efec6b32b58ebc38fc2a6b913596a8", "76df266bc8ba90223570a03fe54abef0075af6eb59ff8c61793f4028");
        TestDigest.testKatHex(new ECHO224(), "f5961dfd2b1ffffda4ffbf30560c165bfedab8ce0be525845deb8dc61004b7db38467205f5dcfb34a2acfe96c0", "9b1d0441d55fe3b58be88d78af1815dd51788b0f440c52615ae7372c");
        TestDigest.testKatHex(new ECHO224(), "ca061a2eb6ceed8881ce2057172d869d73a1951e63d57261384b80ceb5451e77b06cf0f5a0ea15ca907ee1c27eba", "e3b5852f5e2c846caf05cfedb701ab0628b20531cae02612cc8d52a1");
        TestDigest.testKatHex(new ECHO224(), "1743a77251d69242750c4f1140532cd3c33f9b5ccdf7514e8584d4a5f9fbd730bcf84d0d4726364b9bf95ab251d9bb", "ef66be869d6a75ed240648f4cd3f89a421c170a2b0bf01f80e11088a");
        TestDigest.testKatHex(new ECHO224(), "d8faba1f5194c4db5f176fabfff856924ef627a37cd08cf55608bba8f1e324d7c7f157298eabc4dce7d89ce5162499f9", "2d3aee27cc05b2b6d85cc0f5db52972e630b6c1eb37acb014e9564bc");
        TestDigest.testKatHex(new ECHO224(), "be9684be70340860373c9c482ba517e899fc81baaa12e5c6d7727975d1d41ba8bef788cdb5cf4606c9c1c7f61aed59f97d", "cf6d1fcedb174ab1eee54f71acd4a5cd3ba280b148ac74c8a255c906");
        TestDigest.testKatHex(new ECHO224(), "7e15d2b9ea74ca60f66c8dfab377d9198b7b16deb6a1ba0ea3c7ee2042f89d3786e779cf053c77785aa9e692f821f14a7f51", "260e207d3f3198330d5f26d4e8c30c97a145f67409ff7b7c54859a48");
        TestDigest.testKatHex(new ECHO224(), "9a219be43713bd578015e9fda66c0f2d83cac563b776ab9f38f3e4f7ef229cb443304fba401efb2bdbd7ece939102298651c86", "0889b9b6a6f30e1103dd46c6946024bff88a54873bc44ca76abb95fd");
        TestDigest.testKatHex(new ECHO224(), "c8f2b693bd0d75ef99caebdc22adf4088a95a3542f637203e283bbc3268780e787d68d28cc3897452f6a22aa8573ccebf245972a", "5a34d992a575597d64f2a6e7cdff8e047d5c043f9d85b210e65ed85a");
        TestDigest.testKatHex(new ECHO224(), "ec0f99711016c6a2a07ad80d16427506ce6f441059fd269442baaa28c6ca037b22eeac49d5d894c0bf66219f2c08e9d0e8ab21de52", "cb5bdefd3ed7def426c1e05405588ecc000aca026f369d5d862ecbd8");
        TestDigest.testKatHex(new ECHO224(), "0dc45181337ca32a8222fe7a3bf42fc9f89744259cff653504d6051fe84b1a7ffd20cb47d4696ce212a686bb9be9a8ab1c697b6d6a33", "07dae0baf3c51f1a255d5684c5d6c4671cc35751c64cc4004dfcb3f1");
        TestDigest.testKatHex(new ECHO224(), "de286ba4206e8b005714f80fb1cdfaebde91d29f84603e4a3ebc04686f99a46c9e880b96c574825582e8812a26e5a857ffc6579f63742f", "5a62964bc064999c9f6f830b09311c765b36fbd2caf7f50e613b563f");
        TestDigest.testKatHex(new ECHO224(), "eebcc18057252cbf3f9c070f1a73213356d5d4bc19ac2a411ec8cdeee7a571e2e20eaf61fd0c33a0ffeb297ddb77a97f0a415347db66bcaf", "fabe473b8527592b2542b22b1591f0cc925072a8e0c0ab5e0333f281");
        TestDigest.testKatHex(new ECHO224(), "416b5cdc9fe951bd361bd7abfc120a5054758eba88fdd68fd84e39d3b09ac25497d36b43cbe7b85a6a3cebda8db4e5549c3ee51bb6fcb6ac1e", "6d4d8787c318e80805ff1bef48fa1c4e04d4f8c8ecf871f9f78c5485");
        TestDigest.testKatHex(new ECHO224(), "5c5faf66f32e0f8311c32e8da8284a4ed60891a5a7e50fb2956b3cbaa79fc66ca376460e100415401fc2b8518c64502f187ea14bfc9503759705", "2b42a4425f36218e723a80e2c16999db53d9caae70ba55b270c4dd11");
        TestDigest.testKatHex(new ECHO224(), "7167e1e02be1a7ca69d788666f823ae4eef39271f3c26a5cf7cee05bca83161066dc2e217b330df821103799df6d74810eed363adc4ab99f36046a", "620292bc1c03465d5aa2a5e82bf4f431cb538d1fee1754667f1540f5");
        TestDigest.testKatHex(new ECHO224(), "2fda311dbba27321c5329510fae6948f03210b76d43e7448d1689a063877b6d14c4f6d0eaa96c150051371f7dd8a4119f7da5c483cc3e6723c01fb7d", "63a4388415350752c4a3699197a140a7a5cecb0ebf51bd1006d2c442");
        TestDigest.testKatHex(new ECHO224(), "95d1474a5aab5d2422aca6e481187833a6212bd2d0f91451a67dd786dfc91dfed51b35f47e1deb8a8ab4b9cb67b70179cc26f553ae7b569969ce151b8d", "8a25e12246d733ca944e1a8df6004bb75304f57a0231d62b537c6246");
        TestDigest.testKatHex(new ECHO224(), "c71bd7941f41df044a2927a8ff55b4b467c33d089f0988aa253d294addbdb32530c0d4208b10d9959823f0c0f0734684006df79f7099870f6bf53211a88d", "0b9ca39c295d827b95aac0fcae304a5a92ab1506212002f93f33bac5");
        TestDigest.testKatHex(new ECHO224(), "f57c64006d9ea761892e145c99df1b24640883da79d9ed5262859dcda8c3c32e05b03d984f1ab4a230242ab6b78d368dc5aaa1e6d3498d53371e84b0c1d4ba", "ddeca087b44b107aba83ba0d92632e061dcd76d0c01928b6cd954e5a");
        TestDigest.testKatHex(new ECHO224(), "e926ae8b0af6e53176dbffcc2a6b88c6bd765f939d3d178a9bde9ef3aa131c61e31c1e42cdfaf4b4dcde579a37e150efbef5555b4c1cb40439d835a724e2fae7", "9469acfade22153a470374ed35fcd576898da8d084311d42f381b735");
        TestDigest.testKatHex(new ECHO224(), "16e8b3d8f988e9bb04de9c96f2627811c973ce4a5296b4772ca3eefeb80a652bdf21f50df79f32db23f9f73d393b2d57d9a0297f7a2f2e79cfda39fa393df1ac00", "3a88fafef6c5a205d209aa55f82b8dc50c0c477ee1257d8535f80a83");
        TestDigest.testKatHex(new ECHO224(), "fc424eeb27c18a11c01f39c555d8b78a805b88dba1dc2a42ed5e2c0ec737ff68b2456d80eb85e11714fa3f8eabfb906d3c17964cb4f5e76b29c1765db03d91be37fc", "b36b2b16b613161320932c8c13cf5abf89bbcce8e35f1eef7866d93e");
        TestDigest.testKatHex(new ECHO224(), "abe3472b54e72734bdba7d9158736464251c4f21b33fbbc92d7fac9a35c4e3322ff01d2380cbaa4ef8fb07d21a2128b7b9f5b6d9f34e13f39c7ffc2e72e47888599ba5", "0f758dd7ea93ad0dbd05e036fd51bb2b84b65d0ee64156705ea43404");
        TestDigest.testKatHex(new ECHO224(), "36f9f0a65f2ca498d739b944d6eff3da5ebba57e7d9c41598a2b0e4380f3cf4b479ec2348d015ffe6256273511154afcf3b4b4bf09d6c4744fdd0f62d75079d440706b05", "27ddbf38bc6bb77cc87d782aff3099fb9c48ecc183fb43589fee6b42");
        TestDigest.testKatHex(new ECHO224(), "abc87763cae1ca98bd8c5b82caba54ac83286f87e9610128ae4de68ac95df5e329c360717bd349f26b872528492ca7c94c2c1e1ef56b74dbb65c2ac351981fdb31d06c77a4", "6ab9607801bb222322fc962f38cf54d3487eead1ff093659847755f5");
        TestDigest.testKatHex(new ECHO224(), "94f7ca8e1a54234c6d53cc734bb3d3150c8ba8c5f880eab8d25fed13793a9701ebe320509286fd8e422e931d99c98da4df7e70ae447bab8cffd92382d8a77760a259fc4fbd72", "c2c7609da135b45c5ed079d9265cbc4f60c36b18a67f70c26aec24e9");
        TestDigest.testKatHex(new ECHO224(), "13bd2811f6ed2b6f04ff3895aceed7bef8dcd45eb121791bc194a0f806206bffc3b9281c2b308b1a729ce008119dd3066e9378acdcc50a98a82e20738800b6cddbe5fe9694ad6d", "b4c7aaf588d46de1059b4434f6a1a3c6721ff35e0aa0b62376a3a56b");
        TestDigest.testKatHex(new ECHO224(), "1eed9cba179a009ec2ec5508773dd305477ca117e6d569e66b5f64c6bc64801ce25a8424ce4a26d575b8a6fb10ead3fd1992edddeec2ebe7150dc98f63adc3237ef57b91397aa8a7", "2ef6c845735561f46c5537aec424f8d02c314f216b5baea57f198983");
        TestDigest.testKatHex(new ECHO224(), "ba5b67b5ec3a3ffae2c19dd8176a2ef75c0cd903725d45c9cb7009a900c0b0ca7a2967a95ae68269a6dbf8466c7b6844a1d608ac661f7eff00538e323db5f2c644b78b2d48de1a08aa", "48caadda7982f562c405a3d757f6b9cf9252006257b3690b6f2afde1");
        TestDigest.testKatHex(new ECHO224(), "0efa26ac5673167dcacab860932ed612f65ff49b80fa9ae65465e5542cb62075df1c5ae54fba4db807be25b070033efa223bdd5b1d3c94c6e1909c02b620d4b1b3a6c9fed24d70749604", "24dbc4103bf5ba667664912262d3b500f8594c4da665c41f32476801");
        TestDigest.testKatHex(new ECHO224(), "bbfd933d1fd7bf594ac7f435277dc17d8d5a5b8e4d13d96d2f64e771abbd51a5a8aea741beccbddb177bcea05243ebd003cfdeae877cca4da94605b67691919d8b033f77d384ca01593c1b", "edfe2587ab9e3e5aa09481f9accc4012ef59f91d1796193543c5fead");
        TestDigest.testKatHex(new ECHO224(), "90078999fd3c35b8afbf4066cbde335891365f0fc75c1286cdd88fa51fab94f9b8def7c9ac582a5dbcd95817afb7d1b48f63704e19c2baa4df347f48d4a6d603013c23f1e9611d595ebac37c", "8a661feef93365166b79e7cd4eb4bfd1ff9e357eecbe7fc3579c5131");
        TestDigest.testKatHex(new ECHO224(), "64105eca863515c20e7cfbaa0a0b8809046164f374d691cdbd6508aaabc1819f9ac84b52bafc1b0fe7cddbc554b608c01c8904c669d8db316a0953a4c68ece324ec5a49ffdb59a1bd6a292aa0e", "52f934f639eca0e7dd903836e122a6bf7589df6c6a66320ad9c1bedd");
        TestDigest.testKatHex(new ECHO224(), "d4654be288b9f3b711c2d02015978a8cc57471d5680a092aa534f7372c71ceaab725a383c4fcf4d8deaa57fca3ce056f312961eccf9b86f14981ba5bed6ab5b4498e1f6c82c6cae6fc14845b3c8a", "49f516bbb27b375682d80e2720d2afa6a39b0b9dc6302c7ed059a2fd");
        TestDigest.testKatHex(new ECHO224(), "12d9394888305ac96e65f2bf0e1b18c29c90fe9d714dd59f651f52b88b3008c588435548066ea2fc4c101118c91f32556224a540de6efddbca296ef1fb00341f5b01fecfc146bdb251b3bdad556cd2", "a8f26f6a6bc09e1cbb724e4e8f00b28c2e9615b736094e5a40e1c672");
        TestDigest.testKatHex(new ECHO224(), "871a0d7a5f36c3da1dfce57acd8ab8487c274fad336bc137ebd6ff4658b547c1dcfab65f037aa58f35ef16aff4abe77ba61f65826f7be681b5b6d5a1ea8085e2ae9cd5cf0991878a311b549a6d6af230", "908b37894b2220ad45f558b97f73a1de7314a18d1f20a7ce53b406ae");
        TestDigest.testKatHex(new ECHO224(), "e90b4ffef4d457bc7711ff4aa72231ca25af6b2e206f8bf859d8758b89a7cd36105db2538d06da83bad5f663ba11a5f6f61f236fd5f8d53c5e89f183a3cec615b50c7c681e773d109ff7491b5cc22296c5", "2d3a0014b7af8d8bf4ce4acbc99b0859ba93b7b4f5935d7638356260");
        TestDigest.testKatHex(new ECHO224(), "e728de62d75856500c4c77a428612cd804f30c3f10d36fb219c5ca0aa30726ab190e5f3f279e0733d77e7267c17be27d21650a9a4d1e32f649627638dbada9702c7ca303269ed14014b2f3cf8b894eac8554", "96294f8a1a2f850e30d603b9884df298bc48663f46197bf866296a3f");
        TestDigest.testKatHex(new ECHO224(), "6348f229e7b1df3b770c77544e5166e081850fa1c6c88169db74c76e42eb983facb276ad6a0d1fa7b50d3e3b6fcd799ec97470920a7abed47d288ff883e24ca21c7f8016b93bb9b9e078bdb9703d2b781b616e", "88061531e2b7455fdc957b5549b701d3626d315e26bd76c4ef845d69");
        TestDigest.testKatHex(new ECHO224(), "4b127fde5de733a1680c2790363627e63ac8a3f1b4707d982caea258655d9bf18f89afe54127482ba01e08845594b671306a025c9a5c5b6f93b0a39522dc877437be5c2436cbf300ce7ab6747934fcfc30aeaaf6", "0e5ed62d022a4327426c1bc835bdca31bdeba99660c078b8b1517d6e");
        TestDigest.testKatHex(new ECHO224(), "08461f006cff4cc64b752c957287e5a0faabc05c9bff89d23fd902d324c79903b48fcb8f8f4b01f3e4ddb483593d25f000386698f5ade7faade9615fdc50d32785ea51d49894e45baa3dc707e224688c6408b68b11", "2417143aa75038e037a7675dbfd002997c2b52a49861a9d81a6825d6");
        TestDigest.testKatHex(new ECHO224(), "68c8f8849b120e6e0c9969a5866af591a829b92f33cd9a4a3196957a148c49138e1e2f5c7619a6d5edebe995acd81ec8bb9c7b9cfca678d081ea9e25a75d39db04e18d475920ce828b94e72241f24db72546b352a0e4", "57b139a6602c63a86bc326296143d3fa3ba02a48bdb59606461214f3");
        TestDigest.testKatHex(new ECHO224(), "b8d56472954e31fb54e28fca743f84d8dc34891cb564c64b08f7b71636debd64ca1edbdba7fc5c3e40049ce982bba8c7e0703034e331384695e9de76b5104f2fbc4535ecbeebc33bc27f29f18f6f27e8023b0fbb6f563c", "2ba47bc5728c05ca1f1661bd5da607bdbfb0edba2f7b565e8deb7a89");
        TestDigest.testKatHex(new ECHO224(), "0d58ac665fa84342e60cefee31b1a4eacdb092f122dfc68309077aed1f3e528f578859ee9e4cefb4a728e946324927b675cd4f4ac84f64db3dacfe850c1dd18744c74ceccd9fe4dc214085108f404eab6d8f452b5442a47d", "ce9d2f970eb72945b8e06a7199900e643a1b522430b2bf59dd11de6c");
        TestDigest.testKatHex(new ECHO224(), "1755e2d2e5d1c1b0156456b539753ff416651d44698e87002dcf61dcfa2b4e72f264d9ad591df1fdee7b41b2eb00283c5aebb3411323b672eaa145c5125185104f20f335804b02325b6dea65603f349f4d5d8b782dd3469ccd", "c02a606320fd4439ae1109741077f78405c0cd5f54dbd22c0f342ef7");
        TestDigest.testKatHex(new ECHO224(), "b180de1a611111ee7584ba2c4b020598cd574ac77e404e853d15a101c6f5a2e5c801d7d85dc95286a1804c870bb9f00fd4dcb03aa8328275158819dcad7253f3e3d237aeaa7979268a5db1c6ce08a9ec7c2579783c8afc1f91a7", "fd4d36745339aacb976daf9288837f862180f7243cdf767f699a4fed");
        TestDigest.testKatHex(new ECHO224(), "cf3583cbdfd4cbc17063b1e7d90b02f0e6e2ee05f99d77e24e560392535e47e05077157f96813544a17046914f9efb64762a23cf7a49fe52a0a4c01c630cfe8727b81fb99a89ff7cc11dca5173057e0417b8fe7a9efba6d95c555f", "ecf1b725f898b438d400120b32d6ba7eaffa47346a59c9e79b2ef917");
        TestDigest.testKatHex(new ECHO224(), "072fc02340ef99115bad72f92c01e4c093b9599f6cfc45cb380ee686cb5eb019e806ab9bd55e634ab10aa62a9510cc0672cd3eddb589c7df2b67fcd3329f61b1a4441eca87a33c8f55da4fbbad5cf2b2527b8e983bb31a2fadec7523", "e519e80ffb52ca6e4550aa87a95f330ee86473854dd9740b96f9c2c0");
        TestDigest.testKatHex(new ECHO224(), "76eecf956a52649f877528146de33df249cd800e21830f65e90f0f25ca9d6540fde40603230eca6760f1139c7f268deba2060631eea92b1fff05f93fd5572fbe29579ecd48bc3a8d6c2eb4a6b26e38d6c5fbf2c08044aeea470a8f2f26", "441c08088f73137b334789b5bfdb38a98d44523cd325fa241d0c49b8");
        TestDigest.testKatHex(new ECHO224(), "7adc0b6693e61c269f278e6944a5a2d8300981e40022f839ac644387bfac9086650085c2cdc585fea47b9d2e52d65a2b29a7dc370401ef5d60dd0d21f9e2b90fae919319b14b8c5565b0423cefb827d5f1203302a9d01523498a4db10374", "e3f4d61917d6c9aa22e1a2ea6bd3d6f162755adc6bf111effd04f934");
        TestDigest.testKatHex(new ECHO224(), "e1fffa9826cce8b86bccefb8794e48c46cdf372013f782eced1e378269b7be2b7bf51374092261ae120e822be685f2e7a83664bcfbe38fe8633f24e633ffe1988e1bc5acf59a587079a57a910bda60060e85b5f5b6f776f0529639d9cce4bd", "b17657f9a6e00639f5956a238e8840f6ed720d1f40dd4f012f195a8e");
        TestDigest.testKatHex(new ECHO224(), "69f9abba65592ee01db4dce52dbab90b08fc04193602792ee4daa263033d59081587b09bbe49d0b49c9825d22840b2ff5d9c5155f975f8f2c2e7a90c75d2e4a8040fe39f63bbafb403d9e28cc3b86e04e394a9c9e8065bd3c85fa9f0c7891600", "dc226f0b4c53dbb530181ca48a3d88d6b1192bcf35fb034aac58f638");
        TestDigest.testKatHex(new ECHO224(), "38a10a352ca5aedfa8e19c64787d8e9c3a75dbf3b8674bfab29b5dbfc15a63d10fae66cd1a6e6d2452d557967eaad89a4c98449787b0b3164ca5b717a93f24eb0b506ceb70cbbcb8d72b2a72993f909aad92f044e0b5a2c9ac9cb16a0ca2f81f49", "90b97ac475b012aa69a15735c5674e2d7b8b3753513302d02b9870ae");
        TestDigest.testKatHex(new ECHO224(), "6d8c6e449bc13634f115749c248c17cd148b72157a2c37bf8969ea83b4d6ba8c0ee2711c28ee11495f43049596520ce436004b026b6c1f7292b9c436b055cbb72d530d860d1276a1502a5140e3c3f54a93663e4d20edec32d284e25564f624955b52", "396f7d83737dc991e8ffaa8addb937e78a9a4d27170bde1ed59ae7ca");
        TestDigest.testKatHex(new ECHO224(), "6efcbcaf451c129dbe00b9cef0c3749d3ee9d41c7bd500ade40cdc65dedbbbadb885a5b14b32a0c0d087825201e303288a733842fa7e599c0c514e078f05c821c7a4498b01c40032e9f1872a1c925fa17ce253e8935e4c3c71282242cb716b2089ccc1", "ff20f753db7a6ba3553466f3a04085f86ad8f8379308899fe2b5b470");
        TestDigest.testKatHex(new ECHO224(), "433c5303131624c0021d868a30825475e8d0bd3052a022180398f4ca4423b98214b6beaac21c8807a2c33f8c93bd42b092cc1b06cedf3224d5ed1ec29784444f22e08a55aa58542b524b02cd3d5d5f6907afe71c5d7462224a3f9d9e53e7e0846dcbb4ce", "35c874bcf71aeb9742f8bbb819e3b612a4d57449168d2b0b867c7f15");
        TestDigest.testKatHex(new ECHO224(), "a873e0c67ca639026b6683008f7aa6324d4979550e9bce064ca1e1fb97a30b147a24f3f666c0a72d71348ede701cf2d17e2253c34d1ec3b647dbcef2f879f4eb881c4830b791378c901eb725ea5c172316c6d606e0af7df4df7f76e490cd30b2badf45685f", "a647eb8d7fbab75881f12ed3a3d23a15ec46dd2b29e7abf2df63a35e");
        TestDigest.testKatHex(new ECHO224(), "006917b64f9dcdf1d2d87c8a6173b64f6587168e80faa80f82d84f60301e561e312d9fbce62f39a6fb476e01e925f26bcc91de621449be6504c504830aae394096c8fc7694651051365d4ee9070101ec9b68086f2ea8f8ab7b811ea8ad934d5c9b62c60a4771", "0eb9f956904f0347aa69e23d0a7228c13a7c9112247a446f13bb7627");
        TestDigest.testKatHex(new ECHO224(), "f13c972c52cb3cc4a4df28c97f2df11ce089b815466be88863243eb318c2adb1a417cb1041308598541720197b9b1cb5ba2318bd5574d1df2174af14884149ba9b2f446d609df240ce335599957b8ec80876d9a085ae084907bc5961b20bf5f6ca58d5dab38adb", "a569f51f103b75c5df7b40f5888c4c58ce6fbb82a99a5ef21f333a1e");
        TestDigest.testKatHex(new ECHO224(), "e35780eb9799ad4c77535d4ddb683cf33ef367715327cf4c4a58ed9cbdcdd486f669f80189d549a9364fa82a51a52654ec721bb3aab95dceb4a86a6afa93826db923517e928f33e3fba850d45660ef83b9876accafa2a9987a254b137c6e140a21691e1069413848", "f5afc002f5f2ff067fc9a93e30de1081d95895a096e32d16f6f5a7e3");
        TestDigest.testKatHex(new ECHO224(), "64ec021c9585e01ffe6d31bb50d44c79b6993d72678163db474947a053674619d158016adb243f5c8d50aa92f50ab36e579ff2dabb780a2b529370daa299207cfbcdd3a9a25006d19c4f1fe33e4b1eaec315d8c6ee1e730623fd1941875b924eb57d6d0c2edc4e78d6", "34d32e254bc8b77247aea8e86d2b3e609c64a40a46d869467371a8e3");
        TestDigest.testKatHex(new ECHO224(), "5954bab512cf327d66b5d9f296180080402624ad7628506b555eea8382562324cf452fba4a2130de3e165d11831a270d9cb97ce8c2d32a96f50d71600bb4ca268cf98e90d6496b0a6619a5a8c63db6d8a0634dfc6c7ec8ea9c006b6c456f1b20cd19e781af20454ac880", "2d38036b4eb32296b209cb538a8ce98aa477e6970271ddcfd275e235");
        TestDigest.testKatHex(new ECHO224(), "03d9f92b2c565709a568724a0aff90f8f347f43b02338f94a03ed32e6f33666ff5802da4c81bdce0d0e86c04afd4edc2fc8b4141c2975b6f07639b1994c973d9a9afce3d9d365862003498513bfa166d2629e314d97441667b007414e739d7febf0fe3c32c17aa188a8683", "80fd15ecb4a4c5f132c5ad2d05ae877a82254ab1604913bc23e003c6");
        TestDigest.testKatHex(new ECHO224(), "f31e8b4f9e0621d531d22a380be5d9abd56faec53cbd39b1fab230ea67184440e5b1d15457bd25f56204fa917fa48e669016cb48c1ffc1e1e45274b3b47379e00a43843cf8601a5551411ec12503e5aac43d8676a1b2297ec7a0800dbfee04292e937f21c005f17411473041", "11e546e07612ac9ebc970f22cef1c23a4ab52897700140e082ace0d0");
        TestDigest.testKatHex(new ECHO224(), "758ea3fea738973db0b8be7e599bbef4519373d6e6dcd7195ea885fc991d896762992759c2a09002912fb08e0cb5b76f49162aeb8cf87b172cf3ad190253df612f77b1f0c532e3b5fc99c2d31f8f65011695a087a35ee4eee5e334c369d8ee5d29f695815d866da99df3f79403", "3910afc9c630b361fb2dfb4772c53e00066bff7ede87e5b0b55acf45");
        TestDigest.testKatHex(new ECHO224(), "47c6e0c2b74948465921868804f0f7bd50dd323583dc784f998a93cd1ca4c6ef84d41dc81c2c40f34b5bee6a93867b3bdba0052c5f59e6f3657918c382e771d33109122cc8bb0e1e53c4e3d13b43ce44970f5e0c079d2ad7d7a3549cd75760c21bb15b447589e86e8d76b1e9ced2", "b85303d542db7e1a4875b2300fce2453986ccc6d006905e99a20d2e0");
        TestDigest.testKatHex(new ECHO224(), "f690a132ab46b28edfa6479283d6444e371c6459108afd9c35dbd235e0b6b6ff4c4ea58e7554bd002460433b2164ca51e868f7947d7d7a0d792e4abf0be5f450853cc40d85485b2b8857ea31b5ea6e4ccfa2f3a7ef3380066d7d8979fdac618aad3d7e886dea4f005ae4ad05e5065f", "a2f5583da6af32f003cb1117ca8a01d5d767ec905e14dd0cb3884a74");
        TestDigest.testKatHex(new ECHO224(), "58d6a99bc6458824b256916770a8417040721cccfd4b79eacd8b65a3767ce5ba7e74104c985ac56b8cc9aebd16febd4cda5adb130b0ff2329cc8d611eb14dac268a2f9e633c99de33997fea41c52a7c5e1317d5b5daed35eba7d5a60e45d1fa7eaabc35f5c2b0a0f2379231953322c4e", "a8b9bc38e09a0be5633a571882905544e3cc7dddd1eb834628110221");
        TestDigest.testKatHex(new ECHO224(), "befab574396d7f8b6705e2d5b58b2c1c820bb24e3f4bae3e8fbcd36dbf734ee14e5d6ab972aedd3540235466e825850ee4c512ea9795abfd33f330d9fd7f79e62bbb63a6ea85de15beaeea6f8d204a28956059e2632d11861dfb0e65bc07ac8a159388d5c3277e227286f65ff5e5b5aec1", "d0a9a1d038d48860bbd46df4d8b733c3d26b8208a181bc00ae1428e0");
        TestDigest.testKatHex(new ECHO224(), "8e58144fa9179d686478622ce450c748260c95d1ba43b8f9b59abeca8d93488da73463ef40198b4d16fb0b0707201347e0506ff19d01bea0f42b8af9e71a1f1bd168781069d4d338fdef00bf419fbb003031df671f4a37979564f69282de9c65407847dd0da505ab1641c02dea4f0d834986", "d004a7e4636c93c29ce3b704c16073bd4084960c91107e5dab0424f7");
        TestDigest.testKatHex(new ECHO224(), "b55c10eae0ec684c16d13463f29291bf26c82e2fa0422a99c71db4af14dd9c7f33eda52fd73d017cc0f2dbe734d831f0d820d06d5f89dacc485739144f8cfd4799223b1aff9031a105cb6a029ba71e6e5867d85a554991c38df3c9ef8c1e1e9a7630be61caabca69280c399c1fb7a12d12aefc", "51594fc0bca4c2ee4ebd633ba4acf18c307cac093f74899d353df763");
        TestDigest.testKatHex(new ECHO224(), "2eeea693f585f4ed6f6f8865bbae47a6908aecd7c429e4bec4f0de1d0ca0183fa201a0cb14a529b7d7ac0e6ff6607a3243ee9fb11bcf3e2304fe75ffcddd6c5c2e2a4cd45f63c962d010645058d36571404a6d2b4f44755434d76998e83409c3205aa1615db44057db991231d2cb42624574f545", "0215912bfd1563de03a2e0d0e46493a7ece1c4a29d45ca3c067b6c3d");
        TestDigest.testKatHex(new ECHO224(), "dab11dc0b047db0420a585f56c42d93175562852428499f66a0db811fcdddab2f7cdffed1543e5fb72110b64686bc7b6887a538ad44c050f1e42631bc4ec8a9f2a047163d822a38989ee4aab01b4c1f161b062d873b1cfa388fd301514f62224157b9bef423c7783b7aac8d30d65cd1bba8d689c2d", "ef2b626a84f7e9d79de6e16fac390de534cd49dfe54e870789e43639");
        TestDigest.testKatHex(new ECHO224(), "42e99a2f80aee0e001279a2434f731e01d34a44b1a8101726921c0590c30f3120eb83059f325e894a5ac959dca71ce2214799916424e859d27d789437b9d27240bf8c35adbafcecc322b48aa205b293962d858652abacbd588bcf6cbc388d0993bd622f96ed54614c25b6a9aa527589eaaffcf17ddf7", "7926976fb3c32acb90a4484dcd83bfe3c62f2f299691f66d483165c5");
        TestDigest.testKatHex(new ECHO224(), "3c9b46450c0f2cae8e3823f8bdb4277f31b744ce2eb17054bddc6dff36af7f49fb8a2320cc3bdf8e0a2ea29ad3a55de1165d219adeddb5175253e2d1489e9b6fdd02e2c3d3a4b54d60e3a47334c37913c5695378a669e9b72dec32af5434f93f46176ebf044c4784467c700470d0c0b40c8a088c815816", "25e7534b0d552dbc336cadbc14067c1bb0f27540df6cf89072d04ad0");
        TestDigest.testKatHex(new ECHO224(), "d1e654b77cb155f5c77971a64df9e5d34c26a3cad6c7f6b300d39deb1910094691adaa095be4ba5d86690a976428635d5526f3e946f7dc3bd4dbc78999e653441187a81f9adcd5a3c5f254bc8256b0158f54673dcc1232f6e918ebfc6c51ce67eaeb042d9f57eec4bfe910e169af78b3de48d137df4f2840", "0525bdb698d51b48fb2a1f1bf9328d052c6dd8105e20dd741c718b30");
        TestDigest.testKatHex(new ECHO224(), "626f68c18a69a6590159a9c46be03d5965698f2dac3de779b878b3d9c421e0f21b955a16c715c1ec1e22ce3eb645b8b4f263f60660ea3028981eebd6c8c3a367285b691c8ee56944a7cd1217997e1d9c21620b536bdbd5de8925ff71dec6fbc06624ab6b21e329813de90d1e572dfb89a18120c3f606355d25", "88381b2141267598c21d17711baeba8488a3107192f820a250fb08f2");
        TestDigest.testKatHex(new ECHO224(), "651a6fb3c4b80c7c68c6011675e6094eb56abf5fc3057324ebc6477825061f9f27e7a94633abd1fa598a746e4a577caf524c52ec1788471f92b8c37f23795ca19d559d446cab16cbcdce90b79fa1026cee77bf4ab1b503c5b94c2256ad75b3eac6fd5dcb96aca4b03a834bfb4e9af988cecbf2ae597cb9097940", "5b7f436bbe25306224453c9dfecc63ebad07138af91afe3b3b8daf26");
        TestDigest.testKatHex(new ECHO224(), "8aaf072fce8a2d96bc10b3c91c809ee93072fb205ca7f10abd82ecd82cf040b1bc49ea13d1857815c0e99781de3adbb5443ce1c897e55188ceaf221aa9681638de05ae1b322938f46bce51543b57ecdb4c266272259d1798de13be90e10efec2d07484d9b21a3870e2aa9e06c21aa2d0c9cf420080a80a91dee16f", "9decc32b7b826a294fd24830e4a5c3b277c53620995eb50941ba708d");
        TestDigest.testKatHex(new ECHO224(), "53f918fd00b1701bd504f8cdea803acca21ac18c564ab90c2a17da592c7d69688f6580575395551e8cd33e0fef08ca6ed4588d4d140b3e44c032355df1c531564d7f4835753344345a6781e11cd5e095b73df5f82c8ae3ad00877936896671e947cc52e2b29dcd463d90a0c9929128da222b5a211450bbc0e02448e2", "a4fcd5763f12d3f93a4250de4b3b21b1dd72fe137d1d7c98e1e6ae6b");
        TestDigest.testKatHex(new ECHO224(), "a64599b8a61b5ccec9e67aed69447459c8da3d1ec6c7c7c82a7428b9b584fa67e90f68e2c00fbbed4613666e5168da4a16f395f7a3c3832b3b134bfc9cbaa95d2a0fe252f44ac6681eb6d40ab91c1d0282fed6701c57463d3c5f2bb8c6a7301fb4576aa3b5f15510db8956ff77478c26a7c09bea7b398cfc83503f538e", "92e17eb1c17056b6ff3874682fd9123e2642158181536e7dcebaeeff");
        TestDigest.testKatHex(new ECHO224(), "0e3ab0e054739b00cdb6a87bd12cae024b54cb5e550e6c425360c2e87e59401f5ec24ef0314855f0f56c47695d56a7fb1417693af2a1ed5291f2fee95f75eed54a1b1c2e81226fbff6f63ade584911c71967a8eb70933bc3f5d15bc91b5c2644d9516d3c3a8c154ee48e118bd1442c043c7a0dba5ac5b1d5360aae5b9065", "afc0941439b92d6aff3c0079defbd818fb3a3b2335be166b9eacbeb5");
        TestDigest.testKatHex(new ECHO224(), "a62fc595b4096e6336e53fcdfc8d1cc175d71dac9d750a6133d23199eaac288207944cea6b16d27631915b4619f743da2e30a0c00bbdb1bbb35ab852ef3b9aec6b0a8dcc6e9e1abaa3ad62ac0a6c5de765de2c3711b769e3fde44a74016fff82ac46fa8f1797d3b2a726b696e3dea5530439acee3a45c2a51bc32dd055650b", "cfee0744b04a514de1fe8747edf4c1ce1c6cf9333a76941a7befec1b");
        TestDigest.testKatHex(new ECHO224(), "2b6db7ced8665ebe9deb080295218426bdaa7c6da9add2088932cdffbaa1c14129bccdd70f369efb149285858d2b1d155d14de2fdb680a8b027284055182a0cae275234cc9c92863c1b4ab66f304cf0621cd54565f5bff461d3b461bd40df28198e3732501b4860eadd503d26d6e69338f4e0456e9e9baf3d827ae685fb1d817", "da9e9e064f307c70ded9c7d3e3439eba127842ceef2834f4fff43836");
        TestDigest.testKatHex(new ECHO224(), "10db509b2cdcaba6c062ae33be48116a29eb18e390e1bbada5ca0a2718afbcd23431440106594893043cc7f2625281bf7de2655880966a23705f0c5155c2f5cca9f2c2142e96d0a2e763b70686cd421b5db812daced0c6d65035fde558e94f26b3e6dde5bd13980cc80292b723013bd033284584bff27657871b0cf07a849f4ae2", "44149e059717f8f84b2935554bb3de9fe15a00489f82cb51a057428a");
        TestDigest.testKatHex(new ECHO224(), "9334de60c997bda6086101a6314f64e4458f5ff9450c509df006e8c547983c651ca97879175aaba0c539e82d05c1e02c480975cbb30118121061b1ebac4f8d9a3781e2db6b18042e01ecf9017a64a0e57447ec7fcbe6a7f82585f7403ee2223d52d37b4bf426428613d6b4257980972a0acab508a7620c1cb28eb4e9d30fc41361ec", "5229bcf70dc57c77251f1b2d7dc95025c15148e14da949c544c3c4fc");
        TestDigest.testKatHex(new ECHO224(), "e88ab086891693aa535ceb20e64c7ab97c7dd3548f3786339897a5f0c39031549ca870166e477743ccfbe016b4428d89738e426f5ffe81626137f17aecff61b72dbee2dc20961880cfe281dfab5ee38b1921881450e16032de5e4d55ad8d4fca609721b0692bac79be5a06e177fe8c80c0c83519fb3347de9f43d5561cb8107b9b5edc", "120e2ca4345d313b3cef17edfb90be7d2be8683eccf5d9757aaaa57f");
        TestDigest.testKatHex(new ECHO224(), "fd19e01a83eb6ec810b94582cb8fbfa2fcb992b53684fb748d2264f020d3b960cb1d6b8c348c2b54a9fcea72330c2aaa9a24ecdb00c436abc702361a82bb8828b85369b8c72ece0082fe06557163899c2a0efa466c33c04343a839417057399a63a3929be1ee4805d6ce3e5d0d0967fe9004696a5663f4cac9179006a2ceb75542d75d68", "b640061f3edbe72582fed90b778a44c14987b97d574a6b37063c5589");
        TestDigest.testKatHex(new ECHO224(), "59ae20b6f7e0b3c7a989afb28324a40fca25d8651cf1f46ae383ef6d8441587aa1c04c3e3bf88e8131ce6145cfb8973d961e8432b202fa5af3e09d625faad825bc19da9b5c6c20d02abda2fcc58b5bd3fe507bf201263f30543819510c12bc23e2ddb4f711d087a86edb1b355313363a2de996b891025e147036087401ccf3ca7815bf3c49", "60021fc98ac58dc84b758920e3d5ffe473733c5ca3b489333399f906");
        TestDigest.testKatHex(new ECHO224(), "77ee804b9f3295ab2362798b72b0a1b2d3291dceb8139896355830f34b3b328561531f8079b79a6e9980705150866402fdc176c05897e359a6cb1a7ab067383eb497182a7e5aef7038e4c96d133b2782917417e391535b5e1b51f47d8ed7e4d4025fe98dc87b9c1622614bff3d1029e68e372de719803857ca52067cddaad958951cb2068cc6", "9c44876bc015f6bb78040dcf44c08cad22e85075bdca6398744d6c10");
        TestDigest.testKatHex(new ECHO224(), "b771d5cef5d1a41a93d15643d7181d2a2ef0a8e84d91812f20ed21f147bef732bf3a60ef4067c3734b85bc8cd471780f10dc9e8291b58339a677b960218f71e793f2797aea349406512829065d37bb55ea796fa4f56fd8896b49b2cd19b43215ad967c712b24e5032d065232e02c127409d2ed4146b9d75d763d52db98d949d3b0fed6a8052fbb", "056395d00a36a7967dbb0f752d5213737f699b84c5c8806786bc63cc");
        TestDigest.testKatHex(new ECHO224(), "b32d95b0b9aad2a8816de6d06d1f86008505bd8c14124f6e9a163b5a2ade55f835d0ec3880ef50700d3b25e42cc0af050ccd1be5e555b23087e04d7bf9813622780c7313a1954f8740b6ee2d3f71f768dd417f520482bd3a08d4f222b4ee9dbd015447b33507dd50f3ab4247c5de9a8abd62a8decea01e3b87c8b927f5b08beb37674c6f8e380c04", "42461c06a2aeeec70fa75236cd8fc8095a036e40985353e05cd42a09");
        TestDigest.testKatHex(new ECHO224(), "04410e31082a47584b406f051398a6abe74e4da59bb6f85e6b49e8a1f7f2ca00dfba5462c2cd2bfde8b64fb21d70c083f11318b56a52d03b81cac5eec29eb31bd0078b6156786da3d6d8c33098c5c47bb67ac64db14165af65b44544d806dde5f487d5373c7f9792c299e9686b7e5821e7c8e2458315b996b5677d926dac57b3f22da873c601016a0d", "7cb5fbff5c7b1c12e4b60da38c35d16e428b149a15a6a588f6929e71");
        TestDigest.testKatHex(new ECHO224(), "8b81e9badde026f14d95c019977024c9e13db7a5cd21f9e9fc491d716164bbacdc7060d882615d411438aea056c340cdf977788f6e17d118de55026855f93270472d1fd18b9e7e812bae107e0dfde7063301b71f6cfe4e225cab3b232905a56e994f08ee2891ba922d49c3dafeb75f7c69750cb67d822c96176c46bd8a29f1701373fb09a1a6e3c7158f", "0b970d7da30d29ec014e3cb4959bf0d3634bc33ad90db2d902176b3e");
        TestDigest.testKatHex(new ECHO224(), "fa6eed24da6666a22208146b19a532c2ec9ba94f09f1def1e7fc13c399a48e41acc2a589d099276296348f396253b57cb0e40291bd282773656b6e0d8bea1cda084a3738816a840485fcf3fb307f777fa5feac48695c2af4769720258c77943fb4556c362d9cba8bf103aeb9034baa8ea8bfb9c4f8e6742ce0d52c49ea8e974f339612e830e9e7a9c29065", "94aa95ffd7be90a7b24a49fe49c0a2c700cce5355169da78a49a4966");
        TestDigest.testKatHex(new ECHO224(), "9bb4af1b4f09c071ce3cafa92e4eb73ce8a6f5d82a85733440368dee4eb1cbc7b55ac150773b6fe47dbe036c45582ed67e23f4c74585dab509df1b83610564545642b2b1ec463e18048fc23477c6b2aa035594ecd33791af6af4cbc2a1166aba8d628c57e707f0b0e8707caf91cd44bdb915e0296e0190d56d33d8dde10b5b60377838973c1d943c22ed335e", "248edd7ac1c5e603fea0ca853bef35c4ae7a07274362cbaafb96cfe6");
        TestDigest.testKatHex(new ECHO224(), "2167f02118cc62043e9091a647cadbed95611a521fe0d64e8518f16c808ab297725598ae296880a773607a798f7c3cfce80d251ebec6885015f9abf7eaabae46798f82cb5926de5c23f44a3f9f9534b3c6f405b5364c2f8a8bdc5ca49c749bed8ce4ba48897062ae8424ca6dde5f55c0e42a95d1e292ca54fb46a84fbc9cd87f2d0c9e7448de3043ae22fdd229", "9c2fb4727e99d77edb43769b31f37303b24ebaadc1d751af896850d9");
        TestDigest.testKatHex(new ECHO224(), "94b7fa0bc1c44e949b1d7617d31b4720cbe7ca57c6fa4f4094d4761567e389ecc64f6968e4064df70df836a47d0c713336b5028b35930d29eb7a7f9a5af9ad5cf441745baec9bb014ceeff5a41ba5c1ce085feb980bab9cf79f2158e03ef7e63e29c38d7816a84d4f71e0f548b7fc316085ae38a060ff9b8dec36f91ad9ebc0a5b6c338cbb8f6659d342a24368cf", "83fc3d03c0262fa808a5a9efa8f56ef8de05d715bbc5b844c7e38880");
        TestDigest.testKatHex(new ECHO224(), "ea40e83cb18b3a242c1ecc6ccd0b7853a439dab2c569cfc6dc38a19f5c90acbf76aef9ea3742ff3b54ef7d36eb7ce4ff1c9ab3bc119cff6be93c03e208783335c0ab8137be5b10cdc66ff3f89a1bddc6a1eed74f504cbe7290690bb295a872b9e3fe2cee9e6c67c41db8efd7d863cf10f840fe618e7936da3dca5ca6df933f24f6954ba0801a1294cd8d7e66dfafec", "66dfe6f5217921543e9e3722d45af532855d6d5e19c7a92f02e5c15e");
        TestDigest.testKatHex(new ECHO224(), "157d5b7e4507f66d9a267476d33831e7bb768d4d04cc3438da12f9010263ea5fcafbde2579db2f6b58f911d593d5f79fb05fe3596e3fa80ff2f761d1b0e57080055c118c53e53cdb63055261d7c9b2b39bd90acc32520cbbdbda2c4fd8856dbcee173132a2679198daf83007a9b5c51511ae49766c792a29520388444ebefe28256fb33d4260439cba73a9479ee00c63", "f8f17511c3ed74635b42f7ea6725925b77eaa6f89f5e7d870a0e044f");
        TestDigest.testKatHex(new ECHO224(), "836b34b515476f613fe447a4e0c3f3b8f20910ac89a3977055c960d2d5d2b72bd8acc715a9035321b86703a411dde0466d58a59769672aa60ad587b8481de4bba552a1645779789501ec53d540b904821f32b0bd1855b04e4848f9f8cfe9ebd8911be95781a759d7ad9724a7102dbe576776b7c632bc39b9b5e19057e226552a5994c1dbb3b5c7871a11f5537011044c53", "9379aba891799562819a69b12bab220cfbe5321d038cb1a70174c48a");
        TestDigest.testKatHex(new ECHO224(), "cc7784a4912a7ab5ad3620aab29ba87077cd3cb83636adc9f3dc94f51edf521b2161ef108f21a0a298557981c0e53ce6ced45bdf782c1ef200d29bab81dd6460586964edab7cebdbbec75fd7925060f7da2b853b2b089588fa0f8c16ec6498b14c55dcee335cb3a91d698e4d393ab8e8eac0825f8adebeee196df41205c011674e53426caa453f8de1cbb57932b0b741d4c6", "9c81ac2cdbd06b5cd5efaab6b70f301a7a4a0cf50cab1879e6408adf");
        TestDigest.testKatHex(new ECHO224(), "7639b461fff270b2455ac1d1afce782944aea5e9087eb4a39eb96bb5c3baaf0e868c8526d3404f9405e79e77bfac5ffb89bf1957b523e17d341d7323c302ea7083872dd5e8705694acdda36d5a1b895aaa16eca6104c82688532c8bfe1790b5dc9f4ec5fe95baed37e1d287be710431f1e5e8ee105bc42ed37d74b1e55984bf1c09fe6a1fa13ef3b96faeaed6a2a1950a12153", "360c75320af5c69187667d9fa5284114c73cc68715ab441690902901");
        TestDigest.testKatHex(new ECHO224(), "eb6513fc61b30cfba58d4d7e80f94d14589090cf1d80b1df2e68088dc6104959ba0d583d585e9578ab0aec0cf36c48435eb52ed9ab4bbce7a5abe679c97ae2dbe35e8cc1d45b06dda3cf418665c57cbee4bbb47fa4caf78f4ee656fec237fe4eebbafa206e1ef2bd0ee4ae71bd0e9b2f54f91daadf1febfd7032381d636b733dcb3bf76fb14e23aff1f68ed3dbcf75c9b99c6f26", "d56b8aa5b262cf1012aa0ae5215af5bafe8db9214553cd89a22b14f0");
        TestDigest.testKatHex(new ECHO224(), "1594d74bf5dde444265d4c04dad9721ff3e34cbf622daf341fe16b96431f6c4df1f760d34f296eb97d98d560ad5286fec4dce1724f20b54fd7df51d4bf137add656c80546fb1bf516d62ee82baa992910ef4cc18b70f3f8698276fcfb44e0ec546c2c39cfd8ee91034ff9303058b4252462f86c823eb15bf481e6b79cc3a02218595b3658e8b37382bd5048eaed5fd02c37944e73b", "efecd8b2f242621d44dd2b093f93b7d454f8572ace28ceee49cc5b74");
        TestDigest.testKatHex(new ECHO224(), "4cfa1278903026f66fedd41374558be1b585d03c5c55dac94361df286d4bd39c7cb8037ed3b267b07c346626449d0cc5b0dd2cf221f7e4c3449a4be99985d2d5e67bff2923357ddeab5abcb4619f3a3a57b2cf928a022eb27676c6cf805689004fca4d41ea6c2d0a4789c7605f7bb838dd883b3ad3e6027e775bcf262881428099c7fff95b14c095ea130e0b9938a5e22fc52650f591", "46395ba4308b3bd87e9f6935585cc9800d86214468a3cdbb96e1056c");
        TestDigest.testKatHex(new ECHO224(), "d3e65cb92cfa79662f6af493d696a07ccf32aaadcceff06e73e8d9f6f909209e66715d6e978788c49efb9087b170ecf3aa86d2d4d1a065ae0efc8924f365d676b3cb9e2bec918fd96d0b43dee83727c9a93bf56ca2b2e59adba85696546a815067fc7a78039629d4948d157e7b0d826d1bf8e81237bab7321312fdaa4d521744f988db6fdf04549d0fdca393d639c729af716e9c8bba48", "6da517afc4946ff895564a55d4a25ceb8a5b5a4ba88276755542dde7");
        TestDigest.testKatHex(new ECHO224(), "842cc583504539622d7f71e7e31863a2b885c56a0ba62db4c2a3f2fd12e79660dc7205ca29a0dc0a87db4dc62ee47a41db36b9ddb3293b9ac4baae7df5c6e7201e17f717ab56e12cad476be49608ad2d50309e7d48d2d8de4fa58ac3cfeafeee48c0a9eec88498e3efc51f54d300d828dddccb9d0b06dd021a29cf5cb5b2506915beb8a11998b8b886e0f9b7a80e97d91a7d01270f9a7717", "5dbe0ca63b7ac4dcbbaa5ea82db28d7a2141f847b87b56b448c7a7f6");
        TestDigest.testKatHex(new ECHO224(), "6c4b0a0719573e57248661e98febe326571f9a1ca813d3638531ae28b4860f23c3a3a8ac1c250034a660e2d71e16d3acc4bf9ce215c6f15b1c0fc7e77d3d27157e66da9ceec9258f8f2bf9e02b4ac93793dd6e29e307ede3695a0df63cbdc0fc66fb770813eb149ca2a916911bee4902c47c7802e69e405fe3c04ceb5522792a5503fa829f707272226621f7c488a7698c0d69aa561be9f378", "1b621d4fd8a23d25c49a92d9c1393c869b14a2653497ede56cfa131e");
        TestDigest.testKatHex(new ECHO224(), "51b7dbb7ce2ffeb427a91ccfe5218fd40f9e0b7e24756d4c47cd55606008bdc27d16400933906fd9f30effdd4880022d081155342af3fb6cd53672ab7fb5b3a3bcbe47be1fd3a2278cae8a5fd61c1433f7d350675dd21803746cadca574130f01200024c6340ab0cc2cf74f2234669f34e9009ef2eb94823d62b31407f4ba46f1a1eec41641e84d77727b59e746b8a671bef936f05be820759fa", "7b55f86218053ff974362382127ae2c01730c17d5147d364b78922f2");
        TestDigest.testKatHex(new ECHO224(), "83599d93f5561e821bd01a472386bc2ff4efbd4aed60d5821e84aae74d8071029810f5e286f8f17651cd27da07b1eb4382f754cd1c95268783ad09220f5502840370d494beb17124220f6afce91ec8a0f55231f9652433e5ce3489b727716cf4aeba7dcda20cd29aa9a859201253f948dd94395aba9e3852bd1d60dda7ae5dc045b283da006e1cbad83cc13292a315db5553305c628dd091146597", "b90938bf0526989f11c97a89b81489737e3bb648dc051eb31a31ab37");
        TestDigest.testKatHex(new ECHO224(), "2be9bf526c9d5a75d565dd11ef63b979d068659c7f026c08bea4af161d85a462d80e45040e91f4165c074c43ac661380311a8cbed59cc8e4c4518e80cd2c78ab1cabf66bff83eab3a80148550307310950d034a6286c93a1ece8929e6385c5e3bb6ea8a7c0fb6d6332e320e71cc4eb462a2a62e2bfe08f0ccad93e61bedb5dd0b786a728ab666f07e0576d189c92bf9fb20dca49ac2d3956d47385e2", "6f8120d1bd39fd10f8db1919c4f9e91f36bfb0f0315d8618c323238e");
        TestDigest.testKatHex(new ECHO224(), "ca76d3a12595a817682617006848675547d3e8f50c2210f9af906c0e7ce50b4460186fe70457a9e879e79fd4d1a688c70a347361c847ba0dd6aa52936eaf8e58a1be2f5c1c704e20146d366aeb3853bed9de9befe9569ac8aaea37a9fb7139a1a1a7d5c748605a8defb297869ebedd71d615a5da23496d11e11abbb126b206fa0a7797ee7de117986012d0362dcef775c2fe145ada6bda1ccb326bf644", "a18ab3e4f49dedfbe0c36568a1cacafe25718933a244e5aec24a4b98");
        TestDigest.testKatHex(new ECHO224(), "f76b85dc67421025d64e93096d1d712b7baf7fb001716f02d33b2160c2c882c310ef13a576b1c2d30ef8f78ef8d2f465007109aad93f74cb9e7d7bef7c9590e8af3b267c89c15db238138c45833c98cc4a471a7802723ef4c744a853cf80a0c2568dd4ed58a2c9644806f42104cee53628e5bdf7b63b0b338e931e31b87c24b146c6d040605567ceef5960df9e022cb469d4c787f4cba3c544a1ac91f95f", "c88d984989300d783d128a6762ac474bfc5a1c8f1ba8fde08941762d");
        TestDigest.testKatHex(new ECHO224(), "25b8c9c032ea6bcd733ffc8718fbb2a503a4ea8f71dea1176189f694304f0ff68e862a8197b839957549ef243a5279fc2646bd4c009b6d1edebf24738197abb4c992f6b1dc9ba891f570879accd5a6b18691a93c7d0a8d38f95b639c1daeb48c4c2f15ccf5b9d508f8333c32de78781b41850f261b855c4bebcc125a380c54d501c5d3bd07e6b52102116088e53d76583b0161e2a58d0778f091206aabd5a1", "0f77b96593f97a655978104c059a315200b01578c429fb5c7b4e5bbe");
        TestDigest.testKatHex(new ECHO224(), "21cfdc2a7ccb7f331b3d2eefff37e48ad9fa9c788c3f3c200e0173d99963e1cbca93623b264e920394ae48bb4c3a5bb96ffbc8f0e53f30e22956adabc2765f57fb761e147ecbf8567533db6e50c8a1f894310a94edf806dd8ca6a0e141c0fa7c9fae6c6ae65f18c93a8529e6e5b553bf55f25be2e80a9882bd37f145fecbeb3d447a3c4e46c21524cc55cdd62f521ab92a8ba72b897996c49bb273198b7b1c9e", "9ba3ca7f42f8a197e052640b59d06abd8629d24c0918c05abd521abc");
        TestDigest.testKatHex(new ECHO224(), "4e452ba42127dcc956ef4f8f35dd68cb225fb73b5bc7e1ec5a898bba2931563e74faff3b67314f241ec49f4a7061e3bd0213ae826bab380f1f14faab8b0efddd5fd1bb49373853a08f30553d5a55ccbbb8153de4704f29ca2bdeef0419468e05dd51557ccc80c0a96190bbcc4d77ecff21c66bdf486459d427f986410f883a80a5bcc32c20f0478bb9a97a126fc5f95451e40f292a4614930d054c851acd019ccf", "822b99dee3faa4175e229cc3b776bf0fd4a4096b0683305136a652ef");
        TestDigest.testKatHex(new ECHO224(), "fa85671df7dadf99a6ffee97a3ab9991671f5629195049880497487867a6c446b60087fac9a0f2fcc8e3b24e97e42345b93b5f7d3691829d3f8ccd4bb36411b85fc2328eb0c51cb3151f70860ad3246ce0623a8dc8b3c49f958f8690f8e3860e71eb2b1479a5cea0b3f8befd87acaf5362435eaeccb52f38617bc6c5c2c6e269ead1fbd69e941d4ad2012da2c5b21bcfbf98e4a77ab2af1f3fda3233f046d38f1dc8", "be0a2543fa7d19908e7d2e6f4a043085237faa20e338d3ac526968cf");
        TestDigest.testKatHex(new ECHO224(), "e90847ae6797fbc0b6b36d6e588c0a743d725788ca50b6d792352ea8294f5ba654a15366b8e1b288d84f5178240827975a763bc45c7b0430e8a559df4488505e009c63da994f1403f407958203cebb6e37d89c94a5eacf6039a327f6c4dbbc7a2a307d976aa39e41af6537243fc218dfa6ab4dd817b6a397df5ca69107a9198799ed248641b63b42cb4c29bfdd7975ac96edfc274ac562d0474c60347a078ce4c25e88", "320ac8689cc73fb40e0f55319a17e6b56c1644321c6aa3b0e44c063a");
        TestDigest.testKatHex(new ECHO224(), "f6d5c2b6c93954fc627602c00c4ca9a7d3ed12b27173f0b2c9b0e4a5939398a665e67e69d0b12fb7e4ceb253e8083d1ceb724ac07f009f094e42f2d6f2129489e846eaff0700a8d4453ef453a3eddc18f408c77a83275617fabc4ea3a2833aa73406c0e966276079d38e8e38539a70e194cc5513aaa457c699383fd1900b1e72bdfb835d1fd321b37ba80549b078a49ea08152869a918ca57f5b54ed71e4fd3ac5c06729", "0b2d0d639c92258505e1ce48d30b7b45fefc044e79f5ceed8845488b");
        TestDigest.testKatHex(new ECHO224(), "cf8562b1bed89892d67ddaaf3deeb28246456e972326dbcdb5cf3fb289aca01e68da5d59896e3a6165358b071b304d6ab3d018944be5049d5e0e2bb819acf67a6006111089e6767132d72dd85beddcbb2d64496db0cc92955ab4c6234f1eea24f2d51483f2e209e4589bf9519fac51b4d061e801125e605f8093bb6997bc163d551596fe4ab7cfae8fb9a90f6980480ce0c229fd1675409bd788354daf316240cfe0af93eb", "7966fcc6d57bab34c5c57db4f89b98197106ef9abd6e0f52e325123f");
        TestDigest.testKatHex(new ECHO224(), "2ace31abb0a2e3267944d2f75e1559985db7354c6e605f18dc8470423fca30b7331d9b33c4a4326783d1caae1b4f07060eff978e4746bf0c7e30cd61040bd5ec2746b29863eb7f103ebda614c4291a805b6a4c8214230564a0557bc7102e0bd3ed23719252f7435d64d210ee2aafc585be903fa41e1968c50fd5d5367926df7a05e3a42cf07e656ff92de73b036cf8b19898c0cb34557c0c12c2d8b84e91181af467bc75a9d1", "8f167718798c6ba1722fe3f8fbfec054b410be543e6816455b41dd4b");
        TestDigest.testKatHex(new ECHO224(), "0d8d09aed19f1013969ce5e7eb92f83a209ae76be31c754844ea9116ceb39a22ebb6003017bbcf26555fa6624185187db8f0cb3564b8b1c06bf685d47f3286eda20b83358f599d2044bbf0583fab8d78f854fe0a596183230c5ef8e54426750eaf2cc4e29d3bdd037e734d863c2bd9789b4c243096138f7672c232314effdfc6513427e2da76916b5248933be312eb5dde4cf70804fb258ac5fb82d58d08177ac6f4756017fff5", "505ba932996f05429c419f47a57131fcca3c89433808095bd4a43c09");
        TestDigest.testKatHex(new ECHO224(), "c3236b73deb7662bf3f3daa58f137b358ba610560ef7455785a9befdb035a066e90704f929bd9689cef0ce3bda5acf4480bceb8d09d10b098ad8500d9b6071dfc3a14af6c77511d81e3aa8844986c3bea6f469f9e02194c92868cd5f51646256798ff0424954c1434bdfed9facb390b07d342e992936e0f88bfd0e884a0ddb679d0547ccdec6384285a45429d115ac7d235a717242021d1dc35641f5f0a48e8445dba58e6cb2c8ea", "1c17ebf4a60f6a17dd959addc817563a1d213867484a6e4a190b502d");
        TestDigest.testKatHex(new ECHO224(), "b39feb8283eadc63e8184b51df5ae3fd41aac8a963bb0be1cd08aa5867d8d910c669221e73243360646f6553d1ca05a84e8dc0de05b6419ec349ca994480193d01c92525f3fb3dcefb08afc6d26947bdbbfd85193f53b50609c6140905c53a6686b58e53a319a57b962331ede98149af3de3118a819da4d76706a0424b4e1d2910b0ed26af61d150ebcb46595d4266a0bd7f651ba47d0c7f179ca28545007d92e8419d48fdfbd744ce", "c644bcc79e001a37d2ec9e50e4be2f202f9bf47f54ca2e95e022b9d4");
        TestDigest.testKatHex(new ECHO224(), "a983d54f503803e8c7999f4edbbe82e9084f422143a932ddddc47a17b0b7564a7f37a99d0786e99476428d29e29d3c197a72bfab1342c12a0fc4787fd7017d7a6174049ea43b5779169ef7472bdbbd941dcb82fc73aac45a8a94c9f2bd3477f61fd3b796f02a1b8264a214c6fea74b7051b226c722099ec7883a462b83b6afdd4009248b8a237f605fe5a08fe7d8b45321421ebba67bd70a0b00ddbf94baab7f359d5d1eea105f28dcfb", "e26a7282171f9f7adccde5c1644b0d7692948252f6201f51fc1fc569");
        TestDigest.testKatHex(new ECHO224(), "e4d1c1897a0a866ce564635b74222f9696bf2c7f640dd78d7e2aca66e1b61c642bb03ea7536aae597811e9bf4a7b453ede31f97b46a5f0ef51a071a2b3918df16b152519ae3776f9f1edab4c2a377c3292e96408359d3613844d5eb393000283d5ad3401a318b12fd1474b8612f2bb50fb6a8b9e023a54d7dde28c43d6d8854c8d9d1155935c199811dbfc87e9e0072e90eb88681cc7529714f8fb8a2c9d88567adfb974ee205a9bf7b848", "2d2cef40fa9347fca058e74c0136a2d91b649c11802e539be047d1ba");
        TestDigest.testKatHex(new ECHO224(), "b10c59723e3dcadd6d75df87d0a1580e73133a9b7d00cb95ec19f5547027323be75158b11f80b6e142c6a78531886d9047b08e551e75e6261e79785366d7024bd7cd9cf322d9be7d57fb661069f2481c7bb759cd71b4b36ca2bc2df6d3a328faebdb995a9794a8d72155ed551a1f87c80bf6059b43fc764900b18a1c2441f7487743cf84e565f61f8dd2ece6b6ccc9444049197aaaf53e926fbee3bfca8be588ec77f29d211be89de18b15f6", "7370d85c6dda904f93526df168f580133d937cf9e89e99f3b25ee526");
        TestDigest.testKatHex(new ECHO224(), "db11f609baba7b0ca634926b1dd539c8cbada24967d7add4d9876f77c2d80c0f4dcefbd7121548373582705cca2495bd2a43716fe64ed26d059cfb566b3364bd49ee0717bdd9810dd14d8fad80dbbdc4cafb37cc60fb0fe2a80fb4541b8ca9d59dce457738a9d3d8f641af8c3fd6da162dc16fc01aac527a4a0255b4d231c0be50f44f0db0b713af03d968fe7f0f61ed0824c55c4b5265548febd6aad5c5eedf63efe793489c39b8fd29d104ce", "a66217dd3b48c563d887edd76ccfd6ec0f5ba823524fabd96deb40bf");
        TestDigest.testKatHex(new ECHO224(), "bebd4f1a84fc8b15e4452a54bd02d69e304b7f32616aadd90537937106ae4e28de9d8aab02d19bc3e2fde1d651559e296453e4dba94370a14dbbb2d1d4e2022302ee90e208321efcd8528ad89e46dc839ea9df618ea8394a6bff308e7726bae0c19bcd4be52da6258e2ef4e96aa21244429f49ef5cb486d7ff35cac1bacb7e95711944bccb2ab34700d42d1eb38b5d536b947348a458ede3dc6bd6ec547b1b0cae5b257be36a7124e1060c170ffa", "e533b89c25bcfbf4a4a512c3fd322c05ed5f91b641147a7dabd8648f");
        TestDigest.testKatHex(new ECHO224(), "5aca56a03a13784bdc3289d9364f79e2a85c12276b49b92db0adaa4f206d5028f213f678c3510e111f9dc4c1c1f8b6acb17a6413aa227607c515c62a733817ba5e762cc6748e7e0d6872c984d723c9bb3b117eb8963185300a80bfa65cde495d70a46c44858605fccbed086c2b45cef963d33294dbe9706b13af22f1b7c4cd5a001cfec251fba18e722c6e1c4b1166918b4f6f48a98b64b3c07fc86a6b17a6d0480ab79d4e6415b520f1c484d675b1", "69f9536cae92ef6b21870a73a6f8383ffbeb9ccac8c4254760550cf9");
        TestDigest.testKatHex(new ECHO224(), "a5aad0e4646a32c85cfcac73f02fc5300f1982fabb2f2179e28303e447854094cdfc854310e5c0f60993ceff54d84d6b46323d930adb07c17599b35b505f09e784bca5985e0172257797fb53649e2e9723efd16865c31b5c3d5113b58bb0bfc8920fabdda086d7537e66d709d050bd14d0c960873f156fad5b3d3840cdfcdc9be6af519db262a27f40896ab25cc39f96984d650611c0d5a3080d5b3a1bf186abd42956588b3b58cd948970d298776060", "8d9d11fc4e962912d3b72843b1c758eeaddfc9e95291decc5c285f93");
        TestDigest.testKatHex(new ECHO224(), "06cbbe67e94a978203ead6c057a1a5b098478b4b4cbef5a97e93c8e42f5572713575fc2a884531d7622f8f879387a859a80f10ef02708cd8f7413ab385afc357678b9578c0ebf641ef076a1a30f1f75379e9dcb2a885bdd295905ee80c0168a62a9597d10cf12dd2d8cee46645c7e5a141f6e0e23aa482abe5661c16e69ef1e28371e2e236c359ba4e92c25626a7b7ff13f6ea4ae906e1cfe163e91719b1f750a96cbde5fbc953d9e576cd216afc90323a", "0c1c42a4051a93db582635af34c5082633e8c4466aca947c9c3fc005");
        TestDigest.testKatHex(new ECHO224(), "f1c528cf7739874707d4d8ad5b98f7c77169de0b57188df233b2dc8a5b31eda5db4291dd9f68e6bad37b8d7f6c9c0044b3bf74bbc3d7d1798e138709b0d75e7c593d3cccdc1b20c7174b4e692add820ace262d45ccfae2077e878796347168060a162ecca8c38c1a88350bd63bb539134f700fd4addd5959e255337daa06bc86358fabcbefdfb5bc889783d843c08aadc6c4f6c36f65f156e851c9a0f917e4a367b5ad93d874812a1de6a7b93cd53ad97232", "170fb854d01f1bc4b87ef5b87e4f829106f8bbb85daa72473fc4bf36");
        TestDigest.testKatHex(new ECHO224(), "9d9f3a7ecd51b41f6572fd0d0881e30390dfb780991dae7db3b47619134718e6f987810e542619dfaa7b505c76b7350c6432d8bf1cfebdf1069b90a35f0d04cbdf130b0dfc7875f4a4e62cdb8e525aadd7ce842520a482ac18f09442d78305fe85a74e39e760a4837482ed2f437dd13b2ec1042afcf9decdc3e877e50ff4106ad10a525230d11920324a81094da31deab6476aa42f20c84843cfc1c58545ee80352bdd3740dd6a16792ae2d86f11641bb717c2", "3e74157b860dc5e9a85ccfe20a6094d8603d8707a1a569f0825d6c69");
        TestDigest.testKatHex(new ECHO224(), "5179888724819fbad3afa927d3577796660e6a81c52d98e9303261d5a4a83232f6f758934d50aa83ff9e20a5926dfebaac49529d006eb923c5ae5048ed544ec471ed7191edf46363383824f915769b3e688094c682b02151e5ee01e510b431c8865aff8b6b6f2f59cb6d129da79e97c6d2b8fa6c6da3f603199d2d1bcab547682a81cd6cf65f6551121391d78bcc23b5bd0e922ec6d8bf97c952e84dd28aef909aba31edb903b28fbfc33b7703cd996215a11238", "d3b24eec88356365168b2d68b4557d9d911c17cc0fa4ee773c1cd089");
        TestDigest.testKatHex(new ECHO224(), "576ef3520d30b7a4899b8c0d5e359e45c5189add100e43be429a02fb3de5ff4f8fd0e79d9663acca72cd29c94582b19292a557c5b1315297d168fbb54e9e2ecd13809c2b5fce998edc6570545e1499dbe7fb74d47cd7f35823b212b05bf3f5a79caa34224fdd670d335fcb106f5d92c3946f44d3afcbae2e41ac554d8e6759f332b76be89a0324aa12c5482d1ea3ee89ded4936f3e3c080436f539fa137e74c6d3389bdf5a45074c47bc7b20b0948407a66d855e2f", "eac8f6af38e1f35a9ba4275241ed70b9434db74186861ba99148a77c");
        TestDigest.testKatHex(new ECHO224(), "0df2152fa4f4357c8741529dd77e783925d3d76e95bafa2b542a2c33f3d1d117d159cf473f82310356fee4c90a9e505e70f8f24859656368ba09381fa245eb6c3d763f3093f0c89b972e66b53d59406d9f01aea07f8b3b615cac4ee4d05f542e7d0dab45d67ccccd3a606ccbeb31ea1fa7005ba07176e60dab7d78f6810ef086f42f08e595f0ec217372b98970cc6321576d92ce38f7c397a403bada1548d205c343ac09deca86325373c3b76d9f32028fea8eb32515", "71e34e0444cfcc094facc0d436e65524197329d24f0f70f5974ebea9");
        TestDigest.testKatHex(new ECHO224(), "3e15350d87d6ebb5c8ad99d42515cfe17980933c7a8f6b8bbbf0a63728cefaad2052623c0bd5931839112a48633fb3c2004e0749c87a41b26a8b48945539d1ff41a4b269462fd199bfecd45374756f55a9116e92093ac99451aefb2af9fd32d6d7f5fbc7f7a540d5097c096ebc3b3a721541de073a1cc02f7fb0fb1b9327fb0b1218ca49c9487ab5396622a13ae546c97abdef6b56380dda7012a8384091b6656d0ab272d363cea78163ff765cdd13ab1738b940d16cae", "b3e19eb2c60132720e0b2b7c3bc9219008640c5fddd12db50d990b9d");
        TestDigest.testKatHex(new ECHO224(), "c38d6b0b757cb552be40940ece0009ef3b0b59307c1451686f1a22702922800d58bce7a636c1727ee547c01b214779e898fc0e560f8ae7f61bef4d75eaa696b921fd6b735d171535e9edd267c192b99880c87997711002009095d8a7a437e258104a41a505e5ef71e5613ddd2008195f0c574e6ba3fe40099cfa116e5f1a2fa8a6da04badcb4e2d5d0de31fdc4800891c45781a0aac7c907b56d631fca5ce8b2cde620d11d1777ed9fa603541de794ddc5758fcd5fad78c0", "31ed6681b36f9b8aafae7a9824d0af7eb68fc37fbc085496081ae295");
        TestDigest.testKatHex(new ECHO224(), "8d2de3f0b37a6385c90739805b170057f091cd0c7a0bc951540f26a5a75b3e694631bb64c7635eed316f51318e9d8de13c70a2aba04a14836855f35e480528b776d0a1e8a23b547c8b8d6a0d09b241d3be9377160cca4e6793d00a515dc2992cb7fc741daca171431da99cce6f7789f129e2ac5cf65b40d703035cd2185bb936c82002daf8cbc27a7a9e554b06196630446a6f0a14ba155ed26d95bd627b7205c072d02b60db0fd7e49ea058c2e0ba202daff0de91e845cf79", "0d725160fa79fbd19f17e33463f8eaafda65ced2f6ef8368f4c07ba7");
        TestDigest.testKatHex(new ECHO224(), "c464bbdad275c50dcd983b65ad1019b9ff85a1e71c807f3204bb2c921dc31fbcd8c5fc45868ae9ef85b6c9b83bba2a5a822201ed68586ec5ec27fb2857a5d1a2d09d09115f22dcc39fe61f5e1ba0ff6e8b4acb4c6da748be7f3f0839739394ff7fa8e39f7f7e84a33c3866875c01bcb1263c9405d91908e9e0b50e7459fabb63d8c6bbb73d8e3483c099b55bc30ff092ff68b6adedfd477d63570c9f5515847f36e24ba0b705557130cec57ebad1d0b31a378e91894ee26e3a04", "86e7906aeccdd8802fca15f17a2f6f41153387fc38772e9b7cfd919f");
        TestDigest.testKatHex(new ECHO224(), "8b8d68bb8a75732fe272815a68a1c9c5aa31b41dedc8493e76525d1d013d33cebd9e21a5bb95db2616976a8c07fcf411f5f6bc6f7e0b57aca78cc2790a6f9b898858ac9c79b165ff24e66677531e39f572be5d81eb3264524181115f32780257bfb9aeec6af12af28e587cac068a1a2953b59ad680f4c245b2e3ec36f59940d37e1d3db38e13edb29b5c0f404f6ff87f80fc8be7a225ff22fbb9c8b6b1d7330c57840d24bc75b06b80d30dad6806544d510af6c4785e823ac3e0b8", "bf51e136f3d47acf00d078286aacef559a4ce0e227ec51060625aeef");
        TestDigest.testKatHex(new ECHO224(), "6b018710446f368e7421f1bc0ccf562d9c1843846bc8d98d1c9bf7d9d6fcb48bfc3bf83b36d44c4fa93430af75cd190bde36a7f92f867f58a803900df8018150384d85d82132f123006ac2aeba58e02a037fe6afbd65eca7c44977dd3dc74f48b6e7a1bfd5cc4dcf24e4d52e92bd4455848e4928b0eac8b7476fe3cc03e862aa4dff4470dbfed6de48e410f25096487ecfc32a27277f3f5023b2725ade461b1355889554a8836c9cf53bd767f5737d55184eea1ab3f53edd0976c485", "6c55d79b279cc343d193c166696ac3873c6ee6fb41757dede11b1b95");
        TestDigest.testKatHex(new ECHO224(), "c9534a24714bd4be37c88a3da1082eda7cabd154c309d7bd670dccd95aa535594463058a29f79031d6ecaa9f675d1211e9359be82669a79c855ea8d89dd38c2c761ddd0ec0ce9e97597432e9a1beae062cdd71edfdfd464119be9e69d18a7a7fd7ce0e2106f0c8b0abf4715e2ca48ef9f454dc203c96656653b727083513f8efb86e49c513bb758b3b052fe21f1c05bb33c37129d6cc81f1aef6adc45b0e8827a830fe545cf57d0955802c117d23ccb55ea28f95c0d8c2f9c5a242b33f", "002d3c0019e2ee227f3a37f23958c49986158dac48e0517a23283f21");
        TestDigest.testKatHex(new ECHO224(), "07906c87297b867abf4576e9f3cc7f82f22b154afcbf293b9319f1b0584da6a40c27b32e0b1b7f412c4f1b82480e70a9235b12ec27090a5a33175a2bb28d8adc475cefe33f7803f8ce27967217381f02e67a3b4f84a71f1c5228e0c2ad971373f6f672624fcea8d1a9f85170fad30fa0bbd25035c3b41a6175d467998bd1215f6f3866f53847f9cf68ef3e2fbb54bc994de2302b829c5eea68ec441fcbafd7d16ae4fe9fff98bf00e5bc2ad54dd91ff9fda4dd77b6c754a91955d1fbaad0", "db91cb5f20e6d83f2639534374d90ca26cf2fb997f763f4c524de9d7");
        TestDigest.testKatHex(new ECHO224(), "588e94b9054abc2189df69b8ba34341b77cdd528e7860e5defcaa79b0c9a452ad4b82aa306be84536eb7cedcbe058d7b84a6aef826b028b8a0271b69ac3605a9635ea9f5ea0aa700f3eb7835bc54611b922964300c953efe7491e3677c2cebe0822e956cd16433b02c68c4a23252c3f9e151a416b4963257b783e038f6b4d5c9f110f871652c7a649a7bcedcbccc6f2d0725bb903cc196ba76c76aa9f10a190b1d1168993baa9ffc96a1655216773458bec72b0e39c9f2c121378feab4e76a", "4a7da1eb8bb39a93c64bab1a889ebb2c05170b1701afc253b6532c58");
        TestDigest.testKatHex(new ECHO224(), "08959a7e4baae874928813364071194e2939772f20db7c3157078987c557c2a6d5abe68d520eef3dc491692e1e21bcd880adebf63bb4213b50897fa005256ed41b5690f78f52855c8d9168a4b666fce2da2b456d7a7e7c17ab5f2fb1ee90b79e698712e963715983fd07641ae4b4e9dc73203fac1ae11fa1f8c7941fcc82eab247addb56e2638447e9d609e610b60ce086656aaebf1da3c8a231d7d94e2fd0afe46b391ff14a72eaeb3f44ad4df85866def43d4781a0b3578bc996c87970b132", "09b0ec7cdb068d2a7dc89d81ccd768c0e183b96077a694f9328ed315");
        TestDigest.testKatHex(new ECHO224(), "cb2a234f45e2ecd5863895a451d389a369aab99cfef0d5c9ffca1e6e63f763b5c14fb9b478313c8e8c0efeb3ac9500cf5fd93791b789e67eac12fd038e2547cc8e0fc9db591f33a1e4907c64a922dda23ec9827310b306098554a4a78f050262db5b545b159e1ff1dca6eb734b872343b842c57eafcfda8405eedbb48ef32e99696d135979235c3a05364e371c2d76f1902f1d83146df9495c0a6c57d7bf9ee77e80f9787aee27be1fe126cdc9ef893a4a7dcbbc367e40fe4e1ee90b42ea25af01", "b274680de577e51bb4a4fd38e5d93e51fd5f5a017e32156a85d702de");
        TestDigest.testKatHex(new ECHO224(), "d16beadf02ab1d4dc6f88b8c4554c51e866df830b89c06e786a5f8757e8909310af51c840efe8d20b35331f4355d80f73295974653ddd620cdde4730fb6c8d0d2dcb2b45d92d4fbdb567c0a3e86bd1a8a795af26fbf29fc6c65941cddb090ff7cd230ac5268ab4606fccba9eded0a2b5d014ee0c34f0b2881ac036e24e151be89eeb6cd9a7a790afccff234d7cb11b99ebf58cd0c589f20bdac4f9f0e28f75e3e04e5b3debce607a496d848d67fa7b49132c71b878fd5557e082a18eca1fbda94d4b", "486db2bbbeb7ee191aa0daf219fe859342b5b0bc157705c250ffad31");
        TestDigest.testKatHex(new ECHO224(), "8f65f6bc59a85705016e2bae7fe57980de3127e5ab275f573d334f73f8603106ec3553016608ef2dd6e69b24be0b7113bf6a760ba6e9ce1c48f9e186012cf96a1d4849d75df5bb8315387fd78e9e153e76f8ba7ec6c8849810f59fb4bb9b004318210b37f1299526866f44059e017e22e96cbe418699d014c6ea01c9f0038b10299884dbec3199bb05adc94e955a1533219c1115fed0e5f21228b071f40dd57c4240d98d37b73e412fe0fa4703120d7c0c67972ed233e5deb300a22605472fa3a3ba86", "1410df2921a706fb1b7384b02f66409a5e7a71bb217878ba5790b911");
        TestDigest.testKatHex(new ECHO224(), "84891e52e0d451813210c3fd635b39a03a6b7a7317b221a7abc270dfa946c42669aacbbbdf801e1584f330e28c729847ea14152bd637b3d0f2b38b4bd5bf9c791c58806281103a3eabbaede5e711e539e6a8b2cf297cf351c078b4fa8f7f35cf61bebf8814bf248a01d41e86c5715ea40c63f7375379a7eb1d78f27622fb468ab784aaaba4e534a6dfd1df6fa15511341e725ed2e87f98737ccb7b6a6dfae416477472b046bf1811187d151bfa9f7b2bf9acdb23a3be507cdf14cfdf517d2cb5fb9e4ab6", "d00cca947a29b4760ff2dc8b9e007a8d42dea53ae90393461cc0c95a");
        TestDigest.testKatHex(new ECHO224(), "fdd7a9433a3b4afabd7a3a5e3457e56debf78e84b7a0b0ca0e8c6d53bd0c2dae31b2700c6128334f43981be3b213b1d7a118d59c7e6b6493a86f866a1635c12859cfb9ad17460a77b4522a5c1883c3d6acc86e6162667ec414e9a104aa892053a2b1d72165a855bacd8faf8034a5dd9b716f47a0818c09bb6baf22aa503c06b4ca261f557761989d2afbd88b6a678ad128af68672107d0f1fc73c5ca740459297b3292b281e93bceb761bde7221c3a55708e5ec84472cddcaa84ecf23723cc0991355c6280", "e2cc81f121184d369e6af61da9cf03ca4de2dcb9dcc2b2acb913efd2");
        TestDigest.testKatHex(new ECHO224(), "70a40bfbef92277a1aad72f6b79d0177197c4ebd432668cfec05d099accb651062b5dff156c0b27336687a94b26679cfdd9daf7ad204338dd9c4d14114033a5c225bd11f217b5f4732da167ee3f939262d4043fc9cba92303b7b5e96aea12adda64859df4b86e9ee0b58e39091e6b188b408ac94e1294a8911245ee361e60e601eff58d1d37639f3753bec80ebb4efde25817436076623fc65415fe51d1b0280366d12c554d86743f3c3b6572e400361a60726131441ba493a83fbe9afda90f7af1ae717238d", "9341767680939180807b998ebd7020584abb01922916713bf6041f11");
        TestDigest.testKatHex(new ECHO224(), "74356e449f4bf8644f77b14f4d67cb6bd9c1f5ae357621d5b8147e562b65c66585caf2e491b48529a01a34d226d436959153815380d5689e30b35357cdac6e08d3f2b0e88e200600d62bd9f5eaf488df86a4470ea227006182e44809009868c4c280c43d7d64a5268fa719074960087b3a6abc837882f882c837834535929389a12b2c78187e2ea07ef8b8eef27dc85002c3ae35f1a50bee6a1c48ba7e175f3316670b27983472aa6a61eed0a683a39ee323080620ea44a9f74411ae5ce99030528f9ab49c79f2", "6f7f644dba2699b2ee671778ee9f0b3fa6a828c6c291a285a0aaa780");
        TestDigest.testKatHex(new ECHO224(), "8c3798e51bc68482d7337d3abb75dc9ffe860714a9ad73551e120059860dde24ab87327222b64cf774415a70f724cdf270de3fe47dda07b61c9ef2a3551f45a5584860248fabde676e1cd75f6355aa3eaeabe3b51dc813d9fb2eaa4f0f1d9f834d7cad9c7c695ae84b329385bc0bef895b9f1edf44a03d4b410cc23a79a6b62e4f346a5e8dd851c2857995ddbf5b2d717aeb847310e1f6a46ac3d26a7f9b44985af656d2b7c9406e8a9e8f47dcb4ef6b83caacf9aefb6118bfcff7e44bef6937ebddc89186839b77", "eb6f00b18c15dbfc615e161b3d437dc1b9285348ba6df8a2aa1c62b1");
        TestDigest.reportSuccess("ECHO-224");
    }

    private static void testECHO256() {
        TestDigest.testKatHex(new ECHO256(), "", "4496cd09d425999aefa75189ee7fd3c97362aa9e4ca898328002d20a4b519788");
        TestDigest.testKatHex(new ECHO256(), "cc", "01c382b5b9d7d10ec36c98785c27eaccfb2f772a7e58b6b97bf62212b8584ae5");
        TestDigest.testKatHex(new ECHO256(), "41fb", "83fcaa405da0c6aad4f690fc4d294d502227b60b9a90a1613adb7cd241d23997");
        TestDigest.testKatHex(new ECHO256(), "1f877c", "e8ca26c44e8efba4f0392b9691853baaf79c6ffe567e6232520a053310d10888");
        TestDigest.testKatHex(new ECHO256(), "c1ecfdfc", "e28ded239a401da2d36227a6134eace7ca61b775ea45af853332018cd2903fc9");
        TestDigest.testKatHex(new ECHO256(), "21f134ac57", "8c5c206a91bac18a7f518f37a7e39d2711497db5d528948a7362a0b46038439c");
        TestDigest.testKatHex(new ECHO256(), "c6f50bb74e29", "2687958c4938e524a0021d5045bd05b90b26a3f7201a02cb04525f91c4979985");
        TestDigest.testKatHex(new ECHO256(), "119713cc83eeef", "b00d5f494821463ca1e4168fe6c21b0e665c138cb9e5c1374e9cecf2e944d25e");
        TestDigest.testKatHex(new ECHO256(), "4a4f202484512526", "6b93a635adb230cf34dc57e326be59bad2a2cfa071232d5b1d39d28f3897c5a1");
        TestDigest.testKatHex(new ECHO256(), "1f66ab4185ed9b6375", "2433b6e0529ac04ed031eaecde3b0fea71f427a2da1958a83637d1a3837b1854");
        TestDigest.testKatHex(new ECHO256(), "eed7422227613b6f53c9", "872dbe9520760463528985653a5679200a27a51bddcd0ebcf44690c78ad3f976");
        TestDigest.testKatHex(new ECHO256(), "eaeed5cdffd89dece455f1", "b1061d8d52d51151adfe4f73b7595552fb3cc20e382a2b7e900b654823b132d5");
        TestDigest.testKatHex(new ECHO256(), "5be43c90f22902e4fe8ed2d3", "e110e4884e77a1809817d975a30a531b65d5257404e7de198dd1a2cf8b73b14c");
        TestDigest.testKatHex(new ECHO256(), "a746273228122f381c3b46e4f1", "60638dfbcb0faddd7d2010ab789b3ec8f0e91e6fa1f844c5ae45324038c8805e");
        TestDigest.testKatHex(new ECHO256(), "3c5871cd619c69a63b540eb5a625", "226f1900ddbf0624f4fa5f1ca6a7994b1b60b573784a5d57dbacddb52adb88b6");
        TestDigest.testKatHex(new ECHO256(), "fa22874bcc068879e8ef11a69f0722", "3510cf8fe63c887c865cc6714920c1cc28af2279a6a3388171584979a0270636");
        TestDigest.testKatHex(new ECHO256(), "52a608ab21ccdd8a4457a57ede782176", "a544f92120c482e0a364563de6cc94cdfb9e179a5b8d00fbe749700c121a6733");
        TestDigest.testKatHex(new ECHO256(), "82e192e4043ddcd12ecf52969d0f807eed", "21d15fc64780170bccb77288f4e0f568a2d2ce70606843b6664f6c8d49da2c39");
        TestDigest.testKatHex(new ECHO256(), "75683dcb556140c522543bb6e9098b21a21e", "85ac156d947d9d83a188bab1f268767c2b94d62482c4e01ba59e0b7f9a07f341");
        TestDigest.testKatHex(new ECHO256(), "06e4efe45035e61faaf4287b4d8d1f12ca97e5", "e818a701103b4abde9771ec9e78700b2ad37f368d258de3afdf8cf277f640a59");
        TestDigest.testKatHex(new ECHO256(), "e26193989d06568fe688e75540aea06747d9f851", "aa4d39d3c8baa9ff3d8cbc2b665d8bf29d0be8c40c01029664ccde32fa1f54ed");
        TestDigest.testKatHex(new ECHO256(), "d8dc8fdefbdce9d44e4cbafe78447bae3b5436102a", "1cf3b9205ea6b8ff59ab8c66122ffec446501ae8b42a29d40b232e452bbea0a9");
        TestDigest.testKatHex(new ECHO256(), "57085fd7e14216ab102d8317b0cb338a786d5fc32d8f", "72792cb9ec24d86036aee5291c2a2a755ee7a00cfb64993a81a210f815c32fa6");
        TestDigest.testKatHex(new ECHO256(), "a05404df5dbb57697e2c16fa29defac8ab3560d6126fa0", "2718bba8d8fcd0b57bcea0bb2394c68a7304a1c310f1a9ad40ce1438a6e80a91");
        TestDigest.testKatHex(new ECHO256(), "aecbb02759f7433d6fcb06963c74061cd83b5b3ffa6f13c6", "2ab9116826916d5c08ff636c939c9496ac2df7496871fa6735fef1b9b48a17d9");
        TestDigest.testKatHex(new ECHO256(), "aafdc9243d3d4a096558a360cc27c8d862f0be73db5e88aa55", "057a88ba7ab6c5ff237c1f59f2c2a5a825e76236bf4accc4bbfd83818f4ea60e");
        TestDigest.testKatHex(new ECHO256(), "7bc84867f6f9e9fdc3e1046cae3a52c77ed485860ee260e30b15", "61064ebf77ef387755456ddc1bf5e7228bab179be3b4e1f445e27ea8b11f92f1");
        TestDigest.testKatHex(new ECHO256(), "fac523575a99ec48279a7a459e98ff901918a475034327efb55843", "21918fd899f60f29208bf8615100d5b7dbe3f39a6539e1ae4a267e136a0bbf46");
        TestDigest.testKatHex(new ECHO256(), "0f8b2d8fcfd9d68cffc17ccfb117709b53d26462a3f346fb7c79b85e", "2c2884d24c68a462873ed3860b324b307281e768417bbc6e6b7bb60b48a10629");
        TestDigest.testKatHex(new ECHO256(), "a963c3e895ff5a0be4824400518d81412f875fa50521e26e85eac90c04", "5024b5a249220df9b77ec7e794e2d07dd171bb3626ba273261a045954ac7185b");
        TestDigest.testKatHex(new ECHO256(), "03a18688b10cc0edf83adf0a84808a9718383c4070c6c4f295098699ac2c", "101245baec79912b6c64e73886f44a008b991178718990ffffd148d7605f2460");
        TestDigest.testKatHex(new ECHO256(), "84fb51b517df6c5accb5d022f8f28da09b10232d42320ffc32dbecc3835b29", "0035d51267195c1af760be2e11a060760e34d7bbe527850cb8f1eb07a92e9a6a");
        TestDigest.testKatHex(new ECHO256(), "9f2fcc7c90de090d6b87cd7e9718c1ea6cb21118fc2d5de9f97e5db6ac1e9c10", "d972b69fbde639a4035ce4ab3985692f4da4bb7d66997c6f5b9ddafab64fcfe8");
        TestDigest.testKatHex(new ECHO256(), "de8f1b3faa4b7040ed4563c3b8e598253178e87e4d0df75e4ff2f2dedd5a0be046", "1a69246875d8248774c96725e080cff5958d7c7e3cbe5cf425c4c17d3d70f631");
        TestDigest.testKatHex(new ECHO256(), "62f154ec394d0bc757d045c798c8b87a00e0655d0481a7d2d9fb58d93aedc676b5a0", "c90777afd77ba7ef8376223bfed94799ebd22b40e150c061c2cb157658f5905a");
        TestDigest.testKatHex(new ECHO256(), "b2dcfe9ff19e2b23ce7da2a4207d3e5ec7c6112a8a22aec9675a886378e14e5bfbad4e", "0522abd0f48ab60f748706ca29903af2d05c673afb887652bce950a2bda2148e");
        TestDigest.testKatHex(new ECHO256(), "47f5697ac8c31409c0868827347a613a3562041c633cf1f1f86865a576e02835ed2c2492", "275ca851b8ec2407b8f70a130453f7a19ac0c8e41353c9f7c17db7611524db36");
        TestDigest.testKatHex(new ECHO256(), "512a6d292e67ecb2fe486bfe92660953a75484ff4c4f2eca2b0af0edcdd4339c6b2ee4e542", "8b19b79863e8435f1ef7fd31f13c1cab5a77c03c2614b31a0699eba3e6ed8203");
        TestDigest.testKatHex(new ECHO256(), "973cf2b4dcf0bfa872b41194cb05bb4e16760a1840d8343301802576197ec19e2a1493d8f4fb", "de1278a3ea435d7978c89c17fb4ee80c4eae9eec5a3932285070773152b7c73e");
        TestDigest.testKatHex(new ECHO256(), "80beebcd2e3f8a9451d4499961c9731ae667cdc24ea020ce3b9aa4bbc0a7f79e30a934467da4b0", "f4e960fc7b86ca508b0c470a249dc5601d23d7640c76dc199830e37c67ed0a73");
        TestDigest.testKatHex(new ECHO256(), "7abaa12ec2a7347674e444140ae0fb659d08e1c66decd8d6eae925fa451d65f3c0308e29446b8ed3", "c3d6020eb2832a9bb7689abc7f6bf9b5cb1419702f8ffe16164a2bd5f567fa61");
        TestDigest.testKatHex(new ECHO256(), "c88dee9927679b8af422abcbacf283b904ff31e1cac58c7819809f65d5807d46723b20f67ba610c2b7", "c3d93c11e01298b8e3bc7104b76a120fa01bdeb2dfde50027839e41e64ab1320");
        TestDigest.testKatHex(new ECHO256(), "01e43fe350fcec450ec9b102053e6b5d56e09896e0ddd9074fe138e6038210270c834ce6eadc2bb86bf6", "30cf27fc365dcf4f61695c6020ef04cc098826a3c0a98ae2c5bee1e8d561b34e");
        TestDigest.testKatHex(new ECHO256(), "337023370a48b62ee43546f17c4ef2bf8d7ecd1d49f90bab604b839c2e6e5bd21540d29ba27ab8e309a4b7", "f961e50c643e6ce4b05a07e