/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import org.bitcoinj.core.AuxPoW;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.MessageSerializer;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.UnsafeByteArrayOutputStream;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.libdohj.core.AltcoinNetworkParameters;
import org.libdohj.core.AuxPoWNetworkParameters;
import org.libdohj.core.ScryptHash;
import org.libdohj.params.AbstractLitecoinParams;

public class AltcoinBlock
extends Block {
    private static final int BYTE_BITS = 8;
    private boolean auxpowParsed = false;
    private boolean auxpowBytesValid = false;
    @Nullable
    private AuxPoW auxpow;
    private boolean auxpowChain = false;
    private ScryptHash scryptHash;
    private Sha256Hash altcoinHash = null;

    public AltcoinBlock(NetworkParameters params, long version) {
        super(params, version);
    }

    public AltcoinBlock(NetworkParameters params, byte[] payloadBytes) {
        this(params, payloadBytes, 0, params.getDefaultSerializer(), payloadBytes.length);
    }

    public AltcoinBlock(NetworkParameters params, byte[] payloadBytes, int offset, MessageSerializer serializer, int length) throws ProtocolException {
        super(params, payloadBytes, offset, serializer, length);
    }

    public AltcoinBlock(NetworkParameters params, byte[] payloadBytes, int offset, Message parent, MessageSerializer serializer, int length) throws ProtocolException {
        super(params, payloadBytes, serializer, length);
    }

    public AltcoinBlock(NetworkParameters params, long version, Sha256Hash prevBlockHash, Sha256Hash merkleRoot, long time, long difficultyTarget, long nonce, List<Transaction> transactions) {
        super(params, version, prevBlockHash, merkleRoot, time, difficultyTarget, nonce, transactions);
    }

    private ScryptHash calculateScryptHash() {
        try {
            UnsafeByteArrayOutputStream bos = new UnsafeByteArrayOutputStream(80);
            this.writeHeader((OutputStream)bos);
            return new ScryptHash(Utils.reverseBytes((byte[])org.libdohj.core.Utils.scryptDigest(bos.toByteArray())));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public AuxPoW getAuxPoW() {
        return this.auxpow;
    }

    public void setAuxPoW(AuxPoW auxpow) {
        this.auxpow = auxpow;
    }

    public ScryptHash getScryptHash() {
        if (this.scryptHash == null) {
            this.scryptHash = this.calculateScryptHash();
        }
        return this.scryptHash;
    }

    public String getScryptHashAsString() {
        return this.getScryptHash().toString();
    }

    public Coin getBlockInflation(int height) {
        AltcoinNetworkParameters altParams = (AltcoinNetworkParameters)this.params;
        return altParams.getBlockSubsidy(height);
    }

    public static long getChainID(long rawVersion) {
        return rawVersion >> 16;
    }

    public long getChainID() {
        return AltcoinBlock.getChainID(this.getRawVersion());
    }

    public BitSet getVersionFlags() {
        BitSet bitset = new BitSet(8);
        int bits = (int)(this.getRawVersion() & 0xFF00L) >> 8;
        for (int bit = 0; bit < 8; ++bit) {
            if ((bits & 1 << bit) <= 0) continue;
            bitset.set(bit);
        }
        return bitset;
    }

    public final long getRawVersion() {
        return super.getVersion();
    }

    public static long getBaseVersion(long rawVersion) {
        return rawVersion & 0xFFL;
    }

    public long getVersion() {
        if (this.params instanceof AbstractLitecoinParams) {
            return super.getVersion();
        }
        if (this.params instanceof AltcoinNetworkParameters) {
            return AltcoinBlock.getBaseVersion(super.getVersion());
        }
        return super.getVersion();
    }

    protected void parseAuxPoW() throws ProtocolException {
        AuxPoWNetworkParameters auxpowParams;
        if (this.auxpowParsed) {
            return;
        }
        this.auxpow = null;
        if (this.auxpowChain && (auxpowParams = (AuxPoWNetworkParameters)this.params).isAuxPoWBlockVersion(this.getRawVersion()) && this.payload.length >= 160) {
            this.auxpow = new AuxPoW(this.params, this.payload, this.cursor, (Message)this, this.serializer);
        }
        this.auxpowParsed = true;
        this.auxpowBytesValid = this.serializer.isParseRetainMode();
    }

    protected void parseTransactions(int offset) {
        this.auxpowChain = this.params instanceof AuxPoWNetworkParameters;
        this.parseAuxPoW();
        if (null != this.auxpow) {
            super.parseTransactions(offset + this.auxpow.getMessageSize());
            this.optimalEncodingMessageSize += this.auxpow.getMessageSize();
        } else {
            super.parseTransactions(offset);
        }
    }

    void writeHeader(OutputStream stream) throws IOException {
        super.writeHeader(stream);
        if (null != this.auxpow) {
            this.auxpow.bitcoinSerialize(stream);
        }
    }

    public Block cloneAsHeader() {
        AltcoinBlock block = new AltcoinBlock(this.params, this.getRawVersion());
        super.copyBitcoinHeaderTo((Block)block);
        block.auxpow = this.auxpow;
        return block;
    }

    protected boolean checkProofOfWork(boolean throwException) throws VerificationException {
        if (this.params instanceof AltcoinNetworkParameters) {
            AuxPoWNetworkParameters auxParams;
            BigInteger target = this.getDifficultyTargetAsInteger();
            if (this.params instanceof AuxPoWNetworkParameters && (auxParams = (AuxPoWNetworkParameters)this.params).isAuxPoWBlockVersion(this.getRawVersion()) && null != this.auxpow) {
                return this.auxpow.checkProofOfWork(this.getHash(), target, throwException);
            }
            AltcoinNetworkParameters altParams = (AltcoinNetworkParameters)this.params;
            BigInteger h = altParams.getBlockDifficultyHash(this).toBigInteger();
            if (h.compareTo(target) > 0) {
                if (throwException) {
                    throw new VerificationException("Hash is higher than target: " + this.getHashAsString() + " vs " + target.toString(16));
                }
                return false;
            }
            return true;
        }
        return super.checkProofOfWork(throwException);
    }

    public void verifyHeader() throws VerificationException {
        super.verifyHeader();
    }

    public Sha256Hash getHash() {
        AltcoinNetworkParameters altParams;
        if (this.params instanceof AltcoinNetworkParameters && !(altParams = (AltcoinNetworkParameters)this.params).isBlockHashSHA256D()) {
            if (this.altcoinHash == null) {
                this.altcoinHash = altParams.calculateBlockHash(this.bitcoinSerialize(), 0, 80);
            }
            return this.altcoinHash;
        }
        return super.getHash();
    }

    public void resetAltcoinHash() {
        this.altcoinHash = null;
    }
}

