/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.AltcoinBlock;
import org.bitcoinj.core.ChildMessage;
import org.bitcoinj.core.MerkleBranch;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.MessageSerializer;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.libdohj.core.AuxPoWNetworkParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuxPoW
extends ChildMessage {
    public static final byte[] MERGED_MINING_HEADER = new byte[]{-6, -66, "m".getBytes()[0], "m".getBytes()[0]};
    protected static final int MAX_INDEX_PC_BACKWARDS_COMPATIBILITY = 20;
    private static final Logger log = LoggerFactory.getLogger(AuxPoW.class);
    private static final long serialVersionUID = -8567546957352643140L;
    private Transaction transaction;
    private Sha256Hash hashBlock;
    private MerkleBranch coinbaseBranch;
    private MerkleBranch chainMerkleBranch;
    private AltcoinBlock parentBlockHeader;
    private transient int optimalEncodingMessageSize;

    public AuxPoW(NetworkParameters params, @Nullable Message parent) {
        super(params);
        this.transaction = new Transaction(params);
        this.hashBlock = Sha256Hash.ZERO_HASH;
        this.coinbaseBranch = new MerkleBranch(params, this);
        this.chainMerkleBranch = new MerkleBranch(params, this);
        this.parentBlockHeader = null;
    }

    public AuxPoW(NetworkParameters params, byte[] payload, int offset, Message parent, MessageSerializer serializer) throws ProtocolException {
        super(params, payload, offset, parent, serializer, Integer.MIN_VALUE);
    }

    public AuxPoW(NetworkParameters params, byte[] payload, @Nullable Message parent, MessageSerializer serializer) throws ProtocolException {
        super(params, payload, 0, parent, serializer, Integer.MIN_VALUE);
    }

    protected static int calcLength(byte[] buf, int offset) {
        int cursor = offset + Transaction.calcLength((byte[])buf, (int)offset);
        cursor += 4;
        cursor += MerkleBranch.calcLength(buf, offset);
        cursor += MerkleBranch.calcLength(buf, offset);
        return (cursor += 80) - offset + 4;
    }

    protected void parse() throws ProtocolException {
        this.cursor = this.offset;
        this.transaction = new Transaction(this.params, this.payload, this.cursor, (Message)this, this.serializer, Integer.MIN_VALUE);
        this.cursor += this.transaction.getOptimalEncodingMessageSize();
        this.optimalEncodingMessageSize = this.transaction.getOptimalEncodingMessageSize();
        this.hashBlock = this.readHash();
        this.optimalEncodingMessageSize += 32;
        this.coinbaseBranch = new MerkleBranch(this.params, this, this.payload, this.cursor, this.serializer);
        this.cursor += this.coinbaseBranch.getOptimalEncodingMessageSize();
        this.optimalEncodingMessageSize += this.coinbaseBranch.getOptimalEncodingMessageSize();
        this.chainMerkleBranch = new MerkleBranch(this.params, this, this.payload, this.cursor, this.serializer);
        this.cursor += this.chainMerkleBranch.getOptimalEncodingMessageSize();
        this.optimalEncodingMessageSize += this.chainMerkleBranch.getOptimalEncodingMessageSize();
        byte[] blockBytes = Arrays.copyOfRange(this.payload, this.cursor, this.cursor + 80);
        this.cursor += 80;
        this.parentBlockHeader = new AltcoinBlock(this.params, blockBytes, 0, (Message)this, this.serializer, 80);
        this.length = this.cursor - this.offset;
    }

    public int getOptimalEncodingMessageSize() {
        if (this.optimalEncodingMessageSize != 0) {
            return this.optimalEncodingMessageSize;
        }
        this.optimalEncodingMessageSize = this.getMessageSize();
        return this.optimalEncodingMessageSize;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(@Nullable AbstractBlockChain chain) {
        return this.transaction.toString(chain);
    }

    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        this.transaction.bitcoinSerialize(stream);
        stream.write(Utils.reverseBytes((byte[])this.hashBlock.getBytes()));
        this.coinbaseBranch.bitcoinSerialize(stream);
        this.chainMerkleBranch.bitcoinSerialize(stream);
        this.parentBlockHeader.bitcoinSerializeToStream(stream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AuxPoW input = (AuxPoW)((Object)o);
        if (!this.transaction.equals((Object)input.transaction)) {
            return false;
        }
        if (!this.hashBlock.equals((Object)input.hashBlock)) {
            return false;
        }
        if (!this.coinbaseBranch.equals((Object)input.coinbaseBranch)) {
            return false;
        }
        if (!this.chainMerkleBranch.equals((Object)input.chainMerkleBranch)) {
            return false;
        }
        if (!this.parentBlockHeader.equals((Object)input.parentBlockHeader)) {
            return false;
        }
        return this.getHash().equals((Object)input.getHash());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.transaction.hashCode();
        result = 31 * result + this.hashBlock.hashCode();
        result = 31 * result + this.coinbaseBranch.hashCode();
        result = 31 * result + this.chainMerkleBranch.hashCode();
        result = 31 * result + this.parentBlockHeader.hashCode();
        return result;
    }

    public AltcoinBlock getParentBlockHeader() {
        return this.parentBlockHeader;
    }

    public Transaction getCoinbase() {
        return this.transaction;
    }

    public MerkleBranch getChainMerkleBranch() {
        return this.chainMerkleBranch;
    }

    public MerkleBranch getCoinbaseBranch() {
        return this.coinbaseBranch;
    }

    protected boolean checkProofOfWork(Sha256Hash hashAuxBlock, BigInteger target, boolean throwException) throws VerificationException {
        if (!(this.params instanceof AuxPoWNetworkParameters)) {
            if (throwException) {
                throw new VerificationException("Network parameters are not an instance of AuxPoWNetworkParameters, AuxPoW support is not available.");
            }
            return false;
        }
        AuxPoWNetworkParameters altcoinParams = (AuxPoWNetworkParameters)this.params;
        if (0L != this.getCoinbaseBranch().getIndex()) {
            if (throwException) {
                throw new VerificationException("AuxPow is not a generate");
            }
            return false;
        }
        if (!altcoinParams.isTestNet() && this.parentBlockHeader.getChainID() == (long)altcoinParams.getChainID()) {
            if (throwException) {
                throw new VerificationException("Aux POW parent has our chain ID");
            }
            return false;
        }
        if (this.getChainMerkleBranch().size() > 30) {
            if (throwException) {
                throw new VerificationException("Aux POW chain merkle branch too long");
            }
            return false;
        }
        Sha256Hash nRootHash = this.getChainMerkleBranch().calculateMerkleRoot(hashAuxBlock);
        byte[] vchRootHash = nRootHash.getBytes();
        if (!this.getCoinbaseBranch().calculateMerkleRoot(this.getCoinbase().getHash()).equals((Object)this.parentBlockHeader.getMerkleRoot())) {
            if (throwException) {
                throw new VerificationException("Aux POW merkle root incorrect");
            }
            return false;
        }
        if (this.getCoinbase().getInputs().isEmpty()) {
            throw new VerificationException("Coinbase transaction has no inputs");
        }
        byte[] script = this.getCoinbase().getInput(0L).getScriptBytes();
        int pcHead = -1;
        int pc = -1;
        for (int scriptIdx = 0; scriptIdx < script.length; ++scriptIdx) {
            if (AuxPoW.arrayMatch(script, scriptIdx, MERGED_MINING_HEADER)) {
                if (pcHead >= 0) {
                    if (throwException) {
                        throw new VerificationException("Multiple merged mining headers in coinbase");
                    }
                    return false;
                }
                pcHead = scriptIdx;
                continue;
            }
            if (!AuxPoW.arrayMatch(script, scriptIdx, vchRootHash)) continue;
            pc = scriptIdx;
        }
        if (pc == -1) {
            if (throwException) {
                throw new VerificationException("Aux POW missing chain merkle root in parent coinbase");
            }
            return false;
        }
        if (pcHead != -1) {
            if (pcHead + MERGED_MINING_HEADER.length != pc) {
                if (throwException) {
                    throw new VerificationException("Merged mining header is not just before chain merkle root");
                }
                return false;
            }
        } else if (pc > 20) {
            if (throwException) {
                throw new VerificationException("Aux POW chain merkle root must start in the first 20 bytes of the parent coinbase");
            }
            return false;
        }
        if (script.length - (pc += vchRootHash.length) < 8) {
            if (throwException) {
                throw new VerificationException("Aux POW missing chain merkle tree size and nonce in parent coinbase");
            }
            return false;
        }
        byte[] sizeBytes = Utils.reverseBytes((byte[])Arrays.copyOfRange(script, pc, pc + 4));
        int branchSize = ByteBuffer.wrap(sizeBytes).getInt();
        if (branchSize != 1 << this.getChainMerkleBranch().size()) {
            if (throwException) {
                throw new VerificationException("Aux POW merkle branch size does not match parent coinbase");
            }
            return false;
        }
        long nonce = AuxPoW.getNonceFromScript(script, pc);
        if (this.getChainMerkleBranch().getIndex() != (long)AuxPoW.getExpectedIndex(nonce, ((AuxPoWNetworkParameters)this.params).getChainID(), this.getChainMerkleBranch().size())) {
            if (throwException) {
                throw new VerificationException("Aux POW wrong index in chain merkle branch for chain ID " + ((AuxPoWNetworkParameters)this.params).getChainID() + ". Was " + this.getChainMerkleBranch().getIndex() + ", expected " + AuxPoW.getExpectedIndex(nonce, ((AuxPoWNetworkParameters)this.params).getChainID(), this.getChainMerkleBranch().size()));
            }
            return false;
        }
        Sha256Hash hash = altcoinParams.getBlockDifficultyHash(this.getParentBlockHeader());
        BigInteger hashVal = hash.toBigInteger();
        if (hashVal.compareTo(target) > 0) {
            if (throwException) {
                throw new VerificationException("Hash is higher than target: " + hash.toString() + " vs " + target.toString(16));
            }
            return false;
        }
        return true;
    }

    protected static long getNonceFromScript(byte[] script, int pc) {
        byte[] nonceBytes = Utils.reverseBytes((byte[])Arrays.copyOfRange(script, pc + 4, pc + 8));
        return (long)ByteBuffer.wrap(nonceBytes).getInt() & 0xFFFFFFFFL;
    }

    protected static int getExpectedIndex(long nonce, int chainId, int merkleHeight) {
        int rand = (int)nonce;
        rand = rand * 1103515245 + 12345;
        rand += chainId;
        rand = rand * 1103515245 + 12345;
        long longRand = (long)rand & 0xFFFFFFFFL;
        return (int)(longRand %= (long)(1 << merkleHeight));
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    static boolean arrayMatch(byte[] script, int offset, byte[] subArray) {
        int matchIdx;
        for (matchIdx = 0; matchIdx + offset < script.length && matchIdx < subArray.length; ++matchIdx) {
            if (script[offset + matchIdx] == subArray[matchIdx]) continue;
            return false;
        }
        return matchIdx == subArray.length;
    }

    public void setCoinbaseBranch(MerkleBranch merkleBranch) {
        this.coinbaseBranch = merkleBranch;
    }

    public void setParentBlockHeader(AltcoinBlock header) {
        this.parentBlockHeader = header;
    }
}

