/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.bitcoinj.core.ChildMessage;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.MessageSerializer;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VarInt;

public class MerkleBranch
extends ChildMessage {
    private static final long serialVersionUID = 2L;
    private transient int optimalEncodingMessageSize;
    private List<Sha256Hash> hashes;
    private long index;

    public MerkleBranch(NetworkParameters params, @Nullable ChildMessage parent) {
        super(params);
        this.setParent((Message)parent);
        this.hashes = new ArrayList<Sha256Hash>();
        this.index = 0L;
    }

    public MerkleBranch(NetworkParameters params, @Nullable ChildMessage parent, byte[] payload, int offset) throws ProtocolException {
        super(params, payload, offset);
        this.setParent((Message)parent);
    }

    public MerkleBranch(NetworkParameters params, ChildMessage parent, byte[] payload, int offset, MessageSerializer serializer) throws ProtocolException {
        super(params, payload, offset, (Message)parent, serializer, Integer.MIN_VALUE);
    }

    public MerkleBranch(NetworkParameters params, @Nullable ChildMessage parent, List<Sha256Hash> hashes, long branchSideMask) {
        super(params);
        this.setParent((Message)parent);
        this.hashes = hashes;
        this.index = branchSideMask;
    }

    public static int calcLength(byte[] buf, int offset) {
        VarInt varint = new VarInt(buf, offset);
        return (int)varint.value * 4 + 4;
    }

    protected void parse() throws ProtocolException {
        this.cursor = this.offset;
        int hashCount = (int)this.readVarInt();
        this.optimalEncodingMessageSize += VarInt.sizeOf((long)hashCount);
        this.hashes = new ArrayList<Sha256Hash>(hashCount);
        for (int hashIdx = 0; hashIdx < hashCount; ++hashIdx) {
            this.hashes.add(this.readHash());
        }
        this.optimalEncodingMessageSize += 32 * hashCount;
        this.setIndex(this.readUint32());
        this.optimalEncodingMessageSize += 4;
        this.length = this.cursor - this.offset;
    }

    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        stream.write(new VarInt((long)this.hashes.size()).encode());
        for (Sha256Hash hash : this.hashes) {
            stream.write(Utils.reverseBytes((byte[])hash.getBytes()));
        }
        Utils.uint32ToByteStreamLE((long)this.index, (OutputStream)stream);
    }

    public Sha256Hash calculateMerkleRoot(Sha256Hash leaf) {
        byte[] target = leaf.getReversedBytes();
        long mask = this.index;
        MessageDigest digest = Sha256Hash.newDigest();
        for (Sha256Hash hash : this.hashes) {
            digest.reset();
            if ((mask & 1L) == 0L) {
                digest.update(target);
                digest.update(hash.getReversedBytes());
            } else {
                digest.update(hash.getReversedBytes());
                digest.update(target);
            }
            target = digest.digest();
            digest.reset();
            target = digest.digest(target);
            mask >>= 1;
        }
        return Sha256Hash.wrapReversed((byte[])target);
    }

    public List<Sha256Hash> getHashes() {
        return Collections.unmodifiableList(this.hashes);
    }

    public long getIndex() {
        return this.index;
    }

    public void setHashes(List<Sha256Hash> hashes) {
        this.hashes = hashes;
    }

    public void setIndex(long newIndex) {
        assert (newIndex >= 0L);
        this.index = newIndex;
    }

    public int size() {
        return this.hashes.size();
    }

    public int getOptimalEncodingMessageSize() {
        if (this.optimalEncodingMessageSize != 0) {
            return this.optimalEncodingMessageSize;
        }
        if (this.optimalEncodingMessageSize != 0) {
            return this.optimalEncodingMessageSize;
        }
        this.optimalEncodingMessageSize = this.getMessageSize();
        return this.optimalEncodingMessageSize;
    }

    public String toString() {
        return "Merkle branch";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MerkleBranch input = (MerkleBranch)((Object)o);
        if (!this.hashes.equals(input.hashes)) {
            return false;
        }
        return this.index == input.index;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.hashes.hashCode();
        result = 31 * result + (int)this.index;
        return result;
    }
}

