/*
 * Decompiled with CFR 0.152.
 */
package org.libdohj.core;

import org.bitcoinj.core.AltcoinBlock;
import org.bitcoinj.core.AuxPoW;
import org.bitcoinj.core.BitcoinSerializer;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.FilteredBlock;
import org.bitcoinj.core.MessageSerializer;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PartialMerkleTree;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Utils;
import org.libdohj.core.AuxPoWNetworkParameters;

public class AltcoinSerializer
extends BitcoinSerializer {
    public AltcoinSerializer(NetworkParameters params, boolean parseRetain) {
        super(params, parseRetain);
    }

    public Block makeBlock(byte[] payloadBytes, int offset, int length) throws ProtocolException {
        return new AltcoinBlock(this.getParameters(), payloadBytes, offset, (MessageSerializer)this, length);
    }

    public FilteredBlock makeFilteredBlock(byte[] payloadBytes) throws ProtocolException {
        AuxPoWNetworkParameters auxPoWParams;
        long blockVersion = Utils.readUint32((byte[])payloadBytes, (int)0);
        int headerSize = 80;
        byte[] headerBytes = new byte[81];
        System.arraycopy(payloadBytes, 0, headerBytes, 0, headerSize);
        headerBytes[80] = 0;
        if (this.getParameters() instanceof AuxPoWNetworkParameters && (auxPoWParams = (AuxPoWNetworkParameters)this.getParameters()).isAuxPoWBlockVersion(blockVersion)) {
            AltcoinBlock header = (AltcoinBlock)this.makeBlock(headerBytes, 0, Integer.MIN_VALUE);
            AuxPoW auxpow = new AuxPoW(this.getParameters(), payloadBytes, 80, null, (MessageSerializer)this);
            header.setAuxPoW(auxpow);
            int pmtOffset = headerSize + auxpow.getMessageSize();
            int pmtLength = payloadBytes.length - pmtOffset;
            byte[] pmtBytes = new byte[pmtLength];
            System.arraycopy(payloadBytes, pmtOffset, pmtBytes, 0, pmtLength);
            PartialMerkleTree pmt = new PartialMerkleTree(this.getParameters(), pmtBytes, 0);
            return new FilteredBlock(this.getParameters(), (Block)header, pmt);
        }
        return super.makeFilteredBlock(payloadBytes);
    }
}

