/*
 * Decompiled with CFR 0.152.
 */
package org.libdohj.names;

import java.io.UnsupportedEncodingException;
import org.bitcoinj.core.ScriptException;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.script.Script;
import org.libdohj.script.NameScript;

public class NameTransactionUtils {
    public static TransactionOutput getNameAnyUpdateOutput(Transaction tx, String name) {
        for (TransactionOutput output : tx.getOutputs()) {
            try {
                Script scriptPubKey = output.getScriptPubKey();
                NameScript ns = new NameScript(scriptPubKey);
                if (!ns.isNameOp() || !ns.isAnyUpdate() || !new String(ns.getOpName().data, "ISO-8859-1").equals(name)) continue;
                return output;
            }
            catch (ScriptException e) {
            }
            catch (UnsupportedEncodingException e) {
            }
        }
        return null;
    }

    public static NameScript getNameAnyUpdateScript(Transaction tx, String name) {
        TransactionOutput output = NameTransactionUtils.getNameAnyUpdateOutput(tx, name);
        if (output == null) {
            return null;
        }
        Script scriptPubKey = output.getScriptPubKey();
        return new NameScript(scriptPubKey);
    }

    public static String getNameValueAsString(Transaction tx, String name) throws UnsupportedEncodingException {
        NameScript ns = NameTransactionUtils.getNameAnyUpdateScript(tx, name);
        if (ns == null) {
            return null;
        }
        return new String(ns.getOpValue().data, "ISO-8859-1");
    }
}

