/*
 * Decompiled with CFR 0.152.
 */
package org.libdohj.params;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bitcoinj.core.AltcoinBlock;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.script.Script;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.utils.MonetaryFormat;
import org.dashj.hash.X11;
import org.libdohj.core.AltcoinNetworkParameters;
import org.libdohj.core.AltcoinSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDashParams
extends NetworkParameters
implements AltcoinNetworkParameters {
    public static final MonetaryFormat DASH = MonetaryFormat.BTC.noCode().code(0, "DASH").code(3, "mDASH").code(7, "Duffs");
    public static final MonetaryFormat MDASH = DASH.shift(3).minDecimals(2).optionalDecimals(new int[]{2});
    public static final MonetaryFormat DUFF = DASH.shift(7).minDecimals(0).optionalDecimals(new int[]{2});
    public static final int DASH_TARGET_TIMESPAN = 86400;
    public static final int DASH_TARGET_SPACING = 150;
    public static final int DASH_INTERVAL = 576;
    public static final String CODE_DASH = "DASH";
    public static final String CODE_MDASH = "mDASH";
    public static final String CODE_DUFF = "Duffs";
    public static final String ID_DASH_MAINNET = "org.dash.production";
    public static final String ID_DASH_TESTNET = "org.dash.test";
    public static final String ID_DASH_REGTEST = "org.dash.regtest";
    protected final int newInterval;
    protected final int newTargetTimespan;
    protected final int diffChangeTarget;
    protected Logger log = LoggerFactory.getLogger(AbstractDashParams.class);
    public static final int DASHCOIN_PROTOCOL_VERSION_CURRENT = 70206;

    public AbstractDashParams(int setDiffChangeTarget) {
        this.genesisBlock = AbstractDashParams.createGenesis(this);
        this.interval = 576;
        this.newInterval = 576;
        this.targetTimespan = 86400;
        this.newTargetTimespan = 86400;
        this.maxTarget = Utils.decodeCompactBits((long)504365055L);
        this.diffChangeTarget = setDiffChangeTarget;
        this.packetMagic = -1089705027L;
        this.bip32HeaderPub = 76067358;
        this.bip32HeaderPriv = 76066276;
    }

    private static AltcoinBlock createGenesis(NetworkParameters params) {
        AltcoinBlock genesisBlock = new AltcoinBlock(params, 1L);
        Transaction t = new Transaction(params);
        try {
            byte[] bytes = Utils.HEX.decode((CharSequence)"04ffff001d01044c5957697265642030392f4a616e2f3230313420546865204772616e64204578706572696d656e7420476f6573204c6976653a204f76657273746f636b2e636f6d204973204e6f7720416363657074696e6720426974636f696e73");
            t.addInput(new TransactionInput(params, t, bytes));
            ByteArrayOutputStream scriptPubKeyBytes = new ByteArrayOutputStream();
            Script.writeBytes((OutputStream)scriptPubKeyBytes, (byte[])Utils.HEX.decode((CharSequence)"040184710fa689ad5023690c80f3a49c8f13f8d45b8c857fbcbc8bc4a8e4d3eb4b10f4d4604fa08dce601aaf0f470216fe1b51850b4acf21b179c45070ac7b03a9"));
            scriptPubKeyBytes.write(172);
            t.addOutput(new TransactionOutput(params, t, Coin.COIN.multiply(50L), scriptPubKeyBytes.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        genesisBlock.addTransaction(t);
        return genesisBlock;
    }

    @Override
    public Coin getBlockSubsidy(int height) {
        return Coin.valueOf((int)10000, (int)0);
    }

    public MonetaryFormat getMonetaryFormat() {
        return DASH;
    }

    public Coin getMaxMoney() {
        return MAX_MONEY;
    }

    public Coin getMinNonDustOutput() {
        return Coin.valueOf((long)30000L);
    }

    public String getUriScheme() {
        return "dash";
    }

    public boolean hasMaxMoney() {
        return true;
    }

    public void checkDifficultyTransitions(StoredBlock storedPrev, Block nextBlock, BlockStore blockStore) throws VerificationException, BlockStoreException {
        try {
            int height;
            long newTargetCompact = this.calculateNewDifficultyTarget(storedPrev, nextBlock, blockStore);
            long receivedTargetCompact = nextBlock.getDifficultyTarget();
            if (this.getId().compareTo(ID_DASH_MAINNET) == 0 && (height = storedPrev.getHeight() + 1) <= 68589) {
                double n2;
                long nBitsNext = nextBlock.getDifficultyTarget();
                long calcDiffBits = newTargetCompact;
                double n1 = AbstractDashParams.ConvertBitsToDouble(calcDiffBits);
                if (Math.abs(n1 - (n2 = AbstractDashParams.ConvertBitsToDouble(nBitsNext))) > n1 * 0.2) {
                    throw new VerificationException("Network provided difficulty bits do not match what was calculated: " + newTargetCompact + " vs " + receivedTargetCompact);
                }
                return;
            }
            if (newTargetCompact != receivedTargetCompact) {
                throw new VerificationException("Network provided difficulty bits do not match what was calculated: " + newTargetCompact + " vs " + receivedTargetCompact);
            }
        }
        catch (CheckpointEncounteredException checkpointEncounteredException) {
            // empty catch block
        }
    }

    public long calculateNewDifficultyTarget(StoredBlock storedPrev, Block nextBlock, BlockStore blockStore) throws BlockStoreException, VerificationException, CheckpointEncounteredException {
        int DiffMode = 1;
        if (this.getId().equals(ID_DASH_TESTNET)) {
            DiffMode = storedPrev.getHeight() + 1 >= 3000 ? 4 : 1;
        } else if (storedPrev.getHeight() + 1 >= 68589) {
            DiffMode = 4;
        } else if (storedPrev.getHeight() + 1 >= 34140) {
            DiffMode = 3;
        } else if (storedPrev.getHeight() + 1 >= 15200) {
            DiffMode = 2;
        }
        if (DiffMode == 1) {
            return this.calculateNewDifficultyTarget_V1(storedPrev, nextBlock, blockStore);
        }
        if (DiffMode == 2) {
            return this.calculateNewDifficultyTarget_V2(storedPrev, nextBlock, blockStore);
        }
        if (DiffMode == 3) {
            return this.DarkGravityWave(storedPrev, nextBlock, blockStore);
        }
        if (DiffMode == 4) {
            return this.DarkGravityWave3(storedPrev, nextBlock, blockStore);
        }
        return this.DarkGravityWave3(storedPrev, nextBlock, blockStore);
    }

    private long DarkGravityWave(StoredBlock storedPrev, Block nextBlock, BlockStore blockStore) throws BlockStoreException, CheckpointEncounteredException {
        StoredBlock BlockLastSolved = storedPrev;
        StoredBlock BlockReading = storedPrev;
        Block BlockCreating = nextBlock;
        long nBlockTimeAverage = 0L;
        long nBlockTimeAveragePrev = 0L;
        long nBlockTimeCount = 0L;
        long nBlockTimeSum2 = 0L;
        long nBlockTimeCount2 = 0L;
        long LastBlockTime = 0L;
        long PastBlocksMin = 14L;
        long PastBlocksMax = 140L;
        long CountBlocks = 0L;
        BigInteger PastDifficultyAverage = BigInteger.valueOf(0L);
        BigInteger PastDifficultyAveragePrev = BigInteger.valueOf(0L);
        if (BlockLastSolved == null || BlockLastSolved.getHeight() == 0 || (long)BlockLastSolved.getHeight() < PastBlocksMin) {
            return Utils.encodeCompactBits((BigInteger)this.getMaxTarget());
        }
        int i = 1;
        while (BlockReading != null && BlockReading.getHeight() > 0 && (PastBlocksMax <= 0L || (long)i <= PastBlocksMax)) {
            if (++CountBlocks <= PastBlocksMin) {
                PastDifficultyAverage = CountBlocks == 1L ? BlockReading.getHeader().getDifficultyTargetAsInteger() : BlockReading.getHeader().getDifficultyTargetAsInteger().subtract(PastDifficultyAveragePrev).divide(BigInteger.valueOf(CountBlocks)).add(PastDifficultyAveragePrev);
                PastDifficultyAveragePrev = PastDifficultyAverage;
            }
            if (LastBlockTime > 0L) {
                long Diff = LastBlockTime - BlockReading.getHeader().getTimeSeconds();
                if (nBlockTimeCount <= PastBlocksMin) {
                    nBlockTimeAverage = ++nBlockTimeCount == 1L ? Diff : (Diff - nBlockTimeAveragePrev) / nBlockTimeCount + nBlockTimeAveragePrev;
                    nBlockTimeAveragePrev = nBlockTimeAverage;
                }
                ++nBlockTimeCount2;
                nBlockTimeSum2 += Diff;
            }
            LastBlockTime = BlockReading.getHeader().getTimeSeconds();
            try {
                StoredBlock BlockReadingPrev = blockStore.get(BlockReading.getHeader().getPrevBlockHash());
                if (BlockReadingPrev == null) {
                    throw new CheckpointEncounteredException();
                }
                BlockReading = BlockReadingPrev;
            }
            catch (BlockStoreException x) {
                throw new CheckpointEncounteredException();
            }
            ++i;
        }
        BigInteger bnNew = PastDifficultyAverage;
        if (nBlockTimeCount != 0L && nBlockTimeCount2 != 0L) {
            double fTargetTimespan;
            double Shift;
            double fActualTimespan;
            double SmartAverage = (double)nBlockTimeAverage * 0.7 + (double)nBlockTimeSum2 / (double)nBlockTimeCount2 * 0.3;
            if (SmartAverage < 1.0) {
                SmartAverage = 1.0;
            }
            if ((fActualTimespan = (double)CountBlocks * 150.0 / (Shift = 150.0 / SmartAverage)) < (fTargetTimespan = (double)CountBlocks * 150.0) / 3.0) {
                fActualTimespan = fTargetTimespan / 3.0;
            }
            if (fActualTimespan > fTargetTimespan * 3.0) {
                fActualTimespan = fTargetTimespan * 3.0;
            }
            long nActualTimespan = (long)fActualTimespan;
            long nTargetTimespan = (long)fTargetTimespan;
            bnNew = bnNew.multiply(BigInteger.valueOf(nActualTimespan));
            bnNew = bnNew.divide(BigInteger.valueOf(nTargetTimespan));
        }
        if (bnNew.compareTo(this.getMaxTarget()) > 0) {
            this.log.info("Difficulty hit proof of work limit: {}", (Object)bnNew.toString(16));
            bnNew = this.getMaxTarget();
        }
        return Utils.encodeCompactBits((BigInteger)bnNew);
    }

    private long DarkGravityWave3(StoredBlock storedPrev, Block nextBlock, BlockStore blockStore) throws BlockStoreException, CheckpointEncounteredException {
        StoredBlock BlockLastSolved = storedPrev;
        StoredBlock BlockReading = storedPrev;
        Block BlockCreating = nextBlock;
        long nActualTimespan = 0L;
        long LastBlockTime = 0L;
        long PastBlocksMin = 24L;
        long PastBlocksMax = 24L;
        long CountBlocks = 0L;
        BigInteger PastDifficultyAverage = BigInteger.ZERO;
        BigInteger PastDifficultyAveragePrev = BigInteger.ZERO;
        if (BlockLastSolved == null || BlockLastSolved.getHeight() == 0 || (long)BlockLastSolved.getHeight() < PastBlocksMin) {
            return Utils.encodeCompactBits((BigInteger)this.getMaxTarget());
        }
        int i = 1;
        while (BlockReading != null && BlockReading.getHeight() > 0 && (PastBlocksMax <= 0L || (long)i <= PastBlocksMax)) {
            if (++CountBlocks <= PastBlocksMin) {
                PastDifficultyAverage = CountBlocks == 1L ? BlockReading.getHeader().getDifficultyTargetAsInteger() : PastDifficultyAveragePrev.multiply(BigInteger.valueOf(CountBlocks)).add(BlockReading.getHeader().getDifficultyTargetAsInteger()).divide(BigInteger.valueOf(CountBlocks + 1L));
                PastDifficultyAveragePrev = PastDifficultyAverage;
            }
            if (LastBlockTime > 0L) {
                long Diff = LastBlockTime - BlockReading.getHeader().getTimeSeconds();
                nActualTimespan += Diff;
            }
            LastBlockTime = BlockReading.getHeader().getTimeSeconds();
            try {
                StoredBlock BlockReadingPrev = blockStore.get(BlockReading.getHeader().getPrevBlockHash());
                if (BlockReadingPrev == null) {
                    throw new CheckpointEncounteredException();
                }
                BlockReading = BlockReadingPrev;
            }
            catch (BlockStoreException x) {
                throw new CheckpointEncounteredException();
            }
            ++i;
        }
        BigInteger bnNew = PastDifficultyAverage;
        long nTargetTimespan = CountBlocks * 150L;
        if (nActualTimespan < nTargetTimespan / 3L) {
            nActualTimespan = nTargetTimespan / 3L;
        }
        if (nActualTimespan > nTargetTimespan * 3L) {
            nActualTimespan = nTargetTimespan * 3L;
        }
        bnNew = bnNew.multiply(BigInteger.valueOf(nActualTimespan));
        if ((bnNew = bnNew.divide(BigInteger.valueOf(nTargetTimespan))).compareTo(this.getMaxTarget()) > 0) {
            this.log.info("Difficulty hit proof of work limit: {}", (Object)bnNew.toString(16));
            bnNew = this.getMaxTarget();
        }
        return Utils.encodeCompactBits((BigInteger)bnNew);
    }

    private long calculateNewDifficultyTarget_V1(StoredBlock storedPrev, Block nextBlock, BlockStore blockStore) throws BlockStoreException, VerificationException, CheckpointEncounteredException {
        int targetTimespan;
        Block prev = storedPrev.getHeader();
        if ((storedPrev.getHeight() + 1) % this.getInterval() != 0) {
            if (this.getId().equals(ID_DASH_TESTNET)) {
                return this.calculateTestnetDifficulty(storedPrev, prev, nextBlock, blockStore);
            }
            if (nextBlock.getDifficultyTarget() != prev.getDifficultyTarget()) {
                throw new VerificationException("Unexpected change in difficulty at height " + storedPrev.getHeight() + ": " + Long.toHexString(nextBlock.getDifficultyTarget()) + " vs " + Long.toHexString(prev.getDifficultyTarget()));
            }
            return nextBlock.getDifficultyTarget();
        }
        long now = System.currentTimeMillis();
        StoredBlock cursor = blockStore.get(prev.getHash());
        int blockstogoback = this.getInterval() - 1;
        if (storedPrev.getHeight() + 1 != this.getInterval()) {
            blockstogoback = this.getInterval();
        }
        for (int i = 0; i < blockstogoback; ++i) {
            if (cursor == null) {
                throw new VerificationException("Difficulty transition point but we did not find a way back to the genesis block.");
            }
            cursor = blockStore.get(cursor.getHeader().getPrevBlockHash());
        }
        long elapsed = System.currentTimeMillis() - now;
        if (elapsed > 50L) {
            this.log.info("Difficulty transition traversal took {}msec", (Object)elapsed);
        }
        Block blockIntervalAgo = cursor.getHeader();
        int timespan = (int)(prev.getTimeSeconds() - blockIntervalAgo.getTimeSeconds());
        if (timespan < (targetTimespan = this.getTargetTimespan()) / 4) {
            timespan = targetTimespan / 4;
        }
        if (timespan > targetTimespan * 4) {
            timespan = targetTimespan * 4;
        }
        BigInteger newTarget = Utils.decodeCompactBits((long)prev.getDifficultyTarget());
        newTarget = newTarget.multiply(BigInteger.valueOf(timespan));
        if ((newTarget = newTarget.divide(BigInteger.valueOf(targetTimespan))).compareTo(this.getMaxTarget()) > 0) {
            this.log.info("Difficulty hit proof of work limit: {}", (Object)newTarget.toString(16));
            newTarget = this.getMaxTarget();
        }
        int accuracyBytes = (int)(nextBlock.getDifficultyTarget() >>> 24) - 3;
        BigInteger mask = BigInteger.valueOf(0xFFFFFFL).shiftLeft(accuracyBytes * 8);
        newTarget = newTarget.and(mask);
        long newTargetCompact = Utils.encodeCompactBits((BigInteger)newTarget);
        return newTargetCompact;
    }

    private long calculateNewDifficultyTarget_V2(StoredBlock storedPrev, Block nextBlock, BlockStore blockStore) throws BlockStoreException, VerificationException, CheckpointEncounteredException {
        long BlocksTargetSpacing = 150L;
        int TimeDaySeconds = 86400;
        long PastSecondsMin = TimeDaySeconds / 40;
        long PastSecondsMax = TimeDaySeconds * 7;
        long PastBlocksMin = PastSecondsMin / 150L;
        long PastBlocksMax = PastSecondsMax / 150L;
        return this.KimotoGravityWell(storedPrev, nextBlock, 150L, PastBlocksMin, PastBlocksMax, blockStore);
    }

    private long KimotoGravityWell(StoredBlock storedPrev, Block nextBlock, long TargetBlocksSpacingSeconds, long PastBlocksMin, long PastBlocksMax, BlockStore blockStore) throws BlockStoreException, VerificationException, CheckpointEncounteredException {
        StoredBlock BlockLastSolved = storedPrev;
        StoredBlock BlockReading = storedPrev;
        Block BlockCreating = nextBlock;
        long PastBlocksMass = 0L;
        long PastRateActualSeconds = 0L;
        long PastRateTargetSeconds = 0L;
        double PastRateAdjustmentRatio = 1.0;
        BigInteger PastDifficultyAverage = BigInteger.valueOf(0L);
        BigInteger PastDifficultyAveragePrev = BigInteger.valueOf(0L);
        if (BlockLastSolved == null || BlockLastSolved.getHeight() == 0 || (long)BlockLastSolved.getHeight() < PastBlocksMin) {
            return Utils.encodeCompactBits((BigInteger)this.getMaxTarget());
        }
        int i = 0;
        long LatestBlockTime = BlockLastSolved.getHeader().getTimeSeconds();
        i = 1;
        while (BlockReading != null && BlockReading.getHeight() > 0 && (PastBlocksMax <= 0L || (long)i <= PastBlocksMax)) {
            double EventHorizonDeviation;
            ++PastBlocksMass;
            PastDifficultyAverage = i == 1 ? BlockReading.getHeader().getDifficultyTargetAsInteger() : BlockReading.getHeader().getDifficultyTargetAsInteger().subtract(PastDifficultyAveragePrev).divide(BigInteger.valueOf(i)).add(PastDifficultyAveragePrev);
            PastDifficultyAveragePrev = PastDifficultyAverage;
            if (BlockReading.getHeight() > 646120 && LatestBlockTime < BlockReading.getHeader().getTimeSeconds()) {
                LatestBlockTime = BlockReading.getHeader().getTimeSeconds();
            }
            PastRateActualSeconds = BlockLastSolved.getHeader().getTimeSeconds() - BlockReading.getHeader().getTimeSeconds();
            PastRateTargetSeconds = TargetBlocksSpacingSeconds * PastBlocksMass;
            PastRateAdjustmentRatio = 1.0;
            if (BlockReading.getHeight() > 646120) {
                if (PastRateActualSeconds < 5L) {
                    PastRateActualSeconds = 5L;
                }
            } else if (PastRateActualSeconds < 0L) {
                PastRateActualSeconds = 0L;
            }
            if (PastRateActualSeconds != 0L && PastRateTargetSeconds != 0L) {
                PastRateAdjustmentRatio = (double)PastRateTargetSeconds / (double)PastRateActualSeconds;
            }
            double EventHorizonDeviationFast = EventHorizonDeviation = 1.0 + 0.7084 * Math.pow(Double.valueOf(PastBlocksMass) / Double.valueOf(28.2), -1.228);
            double EventHorizonDeviationSlow = 1.0 / EventHorizonDeviation;
            if (PastBlocksMass >= PastBlocksMin && (PastRateAdjustmentRatio <= EventHorizonDeviationSlow || PastRateAdjustmentRatio >= EventHorizonDeviationFast)) break;
            StoredBlock BlockReadingPrev = blockStore.get(BlockReading.getHeader().getPrevBlockHash());
            if (BlockReadingPrev == null) {
                throw new CheckpointEncounteredException();
            }
            BlockReading = BlockReadingPrev;
            ++i;
        }
        BigInteger newDifficulty = PastDifficultyAverage;
        if (PastRateActualSeconds != 0L && PastRateTargetSeconds != 0L) {
            newDifficulty = newDifficulty.multiply(BigInteger.valueOf(PastRateActualSeconds));
            newDifficulty = newDifficulty.divide(BigInteger.valueOf(PastRateTargetSeconds));
        }
        if (newDifficulty.compareTo(this.getMaxTarget()) > 0) {
            this.log.info("Difficulty hit proof of work limit: {}", (Object)newDifficulty.toString(16));
            newDifficulty = this.getMaxTarget();
        }
        return Utils.encodeCompactBits((BigInteger)newDifficulty);
    }

    static double ConvertBitsToDouble(long nBits) {
        long nShift;
        double dDiff = 65535.0 / (double)(nBits & 0xFFFFFFL);
        for (nShift = nBits >> 24 & 0xFFL; nShift < 29L; ++nShift) {
            dDiff *= 256.0;
        }
        while (nShift > 29L) {
            dDiff /= 256.0;
            --nShift;
        }
        return dDiff;
    }

    private long calculateTestnetDifficulty(StoredBlock storedPrev, Block prev, Block next, BlockStore blockStore) throws VerificationException, BlockStoreException {
        BigInteger newTarget;
        long timeDelta = next.getTimeSeconds() - prev.getTimeSeconds();
        if (timeDelta >= 0L && timeDelta > 300L) {
            if (next.getDifficultyTargetAsInteger().equals(this.getMaxTarget())) {
                return next.getDifficultyTarget();
            }
            throw new VerificationException("Unexpected change in difficulty");
        }
        StoredBlock cursor = storedPrev;
        while (!cursor.getHeader().equals((Object)this.getGenesisBlock()) && cursor.getHeight() % this.getInterval() != 0 && cursor.getHeader().getDifficultyTargetAsInteger().equals(this.getMaxTarget())) {
            cursor = cursor.getPrev(blockStore);
        }
        BigInteger cursorTarget = cursor.getHeader().getDifficultyTargetAsInteger();
        if (!cursorTarget.equals(newTarget = next.getDifficultyTargetAsInteger())) {
            throw new VerificationException("Testnet block transition that is not allowed: " + Long.toHexString(cursor.getHeader().getDifficultyTarget()) + " vs " + Long.toHexString(next.getDifficultyTarget()));
        }
        return Utils.encodeCompactBits((BigInteger)newTarget);
    }

    public abstract boolean allowMinDifficultyBlocks();

    @Override
    public Sha256Hash getBlockDifficultyHash(Block block) {
        return block.getHash();
    }

    @Override
    public boolean isBlockHashSHA256D() {
        return false;
    }

    @Override
    public Sha256Hash calculateBlockHash(byte[] payload, int offset, int length) {
        return Sha256Hash.wrapReversed((byte[])X11.digest(payload, offset, length));
    }

    public boolean allowMoreInventoryTypes() {
        return true;
    }

    public boolean allowMoreMessages() {
        return true;
    }

    public AltcoinSerializer getSerializer(boolean parseRetain) {
        return new AltcoinSerializer(this, parseRetain);
    }

    public int getProtocolVersionNum(NetworkParameters.ProtocolVersion version) {
        switch (version) {
            case PONG: 
            case BLOOM_FILTER: {
                return 70206;
            }
            case CURRENT: {
                return 70206;
            }
        }
        return 70206;
    }

    private static class CheckpointEncounteredException
    extends Exception {
        private CheckpointEncounteredException() {
        }
    }
}

