/*
 * Decompiled with CFR 0.152.
 */
package org.libdohj.params;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bitcoinj.core.AltcoinBlock;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.script.Script;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.utils.MonetaryFormat;
import org.libdohj.core.AltcoinSerializer;
import org.libdohj.core.AuxPoWNetworkParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDogecoinParams
extends NetworkParameters
implements AuxPoWNetworkParameters {
    public static final MonetaryFormat DOGE = MonetaryFormat.BTC.noCode().code(0, "DOGE").code(3, "mDOGE").code(7, "Koinu");
    public static final MonetaryFormat MDOGE = DOGE.shift(3).minDecimals(2).optionalDecimals(new int[]{2});
    public static final MonetaryFormat KOINU = DOGE.shift(7).minDecimals(0).optionalDecimals(new int[]{2});
    public static final int DIGISHIELD_BLOCK_HEIGHT = 145000;
    public static final int AUXPOW_CHAIN_ID = 98;
    public static final int DOGE_TARGET_TIMESPAN = 14400;
    public static final int DOGE_TARGET_TIMESPAN_NEW = 60;
    public static final int DOGE_TARGET_SPACING = 60;
    public static final int DOGE_INTERVAL = 240;
    public static final int DOGE_INTERVAL_NEW = 1;
    public static final String CODE_DOGE = "DOGE";
    public static final String CODE_MDOGE = "mDOGE";
    public static final String CODE_KOINU = "Koinu";
    private static final int BLOCK_MIN_VERSION_AUXPOW = 0x620002;
    private static final int BLOCK_VERSION_FLAG_AUXPOW = 256;
    public static final String ID_DOGE_MAINNET = "org.dogecoin.production";
    public static final String ID_DOGE_TESTNET = "org.dogecoin.test";
    public static final String ID_DOGE_REGTEST = "org.dogecoin.regtest";
    protected final int newInterval;
    protected final int newTargetTimespan;
    protected final int diffChangeTarget;
    protected Logger log = LoggerFactory.getLogger(AbstractDogecoinParams.class);
    public static final int DOGECOIN_PROTOCOL_VERSION_AUXPOW = 70003;
    public static final int DOGECOIN_PROTOCOL_VERSION_CURRENT = 70004;
    private static final Coin BASE_SUBSIDY = Coin.COIN.multiply(500000L);
    private static final Coin STABLE_SUBSIDY = Coin.COIN.multiply(10000L);

    public AbstractDogecoinParams(int setDiffChangeTarget) {
        this.genesisBlock = AbstractDogecoinParams.createGenesis(this);
        this.interval = 240;
        this.newInterval = 1;
        this.targetTimespan = 14400;
        this.newTargetTimespan = 60;
        this.maxTarget = Utils.decodeCompactBits((long)504365055L);
        this.diffChangeTarget = setDiffChangeTarget;
        this.packetMagic = -1061109568L;
        this.bip32HeaderPub = 76071982;
        this.bip32HeaderPriv = 76079604;
    }

    private static AltcoinBlock createGenesis(NetworkParameters params) {
        AltcoinBlock genesisBlock = new AltcoinBlock(params, 1L);
        Transaction t = new Transaction(params);
        try {
            byte[] bytes = Utils.HEX.decode((CharSequence)"04ffff001d0104084e696e746f6e646f");
            t.addInput(new TransactionInput(params, t, bytes));
            ByteArrayOutputStream scriptPubKeyBytes = new ByteArrayOutputStream();
            Script.writeBytes((OutputStream)scriptPubKeyBytes, (byte[])Utils.HEX.decode((CharSequence)"040184710fa689ad5023690c80f3a49c8f13f8d45b8c857fbcbc8bc4a8e4d3eb4b10f4d4604fa08dce601aaf0f470216fe1b51850b4acf21b179c45070ac7b03a9"));
            scriptPubKeyBytes.write(172);
            t.addOutput(new TransactionOutput(params, t, Coin.COIN.multiply(88L), scriptPubKeyBytes.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        genesisBlock.addTransaction(t);
        return genesisBlock;
    }

    @Override
    public Coin getBlockSubsidy(int height) {
        if (height < 145000) {
            return BASE_SUBSIDY.shiftRight(height / this.getSubsidyDecreaseBlockCount()).multiply(2L);
        }
        if (height < 600000) {
            return BASE_SUBSIDY.shiftRight(height / this.getSubsidyDecreaseBlockCount());
        }
        return STABLE_SUBSIDY;
    }

    public int getNewInterval() {
        return this.newInterval;
    }

    public int getNewTargetTimespan() {
        return this.newTargetTimespan;
    }

    public MonetaryFormat getMonetaryFormat() {
        return DOGE;
    }

    public Coin getMaxMoney() {
        return MAX_MONEY;
    }

    public Coin getMinNonDustOutput() {
        return Coin.COIN;
    }

    public String getUriScheme() {
        return "dogecoin";
    }

    public boolean hasMaxMoney() {
        return false;
    }

    private boolean allowDigishieldMinDifficultyForBlock(StoredBlock pindexLast, Block pblock) {
        if (!this.allowMinDifficultyBlocks()) {
            return false;
        }
        if (pindexLast.getHeight() < 157500) {
            return false;
        }
        return pblock.getTimeSeconds() > pindexLast.getHeader().getTimeSeconds() + (long)(this.getTargetSpacing(pindexLast.getHeight() + 1) * 2);
    }

    public void checkDifficultyTransitions(StoredBlock storedPrev, Block nextBlock, BlockStore blockStore) throws VerificationException, BlockStoreException {
        try {
            long newTargetCompact = this.calculateNewDifficultyTarget(storedPrev, nextBlock, blockStore);
            long receivedTargetCompact = nextBlock.getDifficultyTarget();
            if (newTargetCompact != receivedTargetCompact) {
                throw new VerificationException("Network provided difficulty bits do not match what was calculated: " + newTargetCompact + " vs " + receivedTargetCompact);
            }
        }
        catch (CheckpointEncounteredException checkpointEncounteredException) {
            // empty catch block
        }
    }

    public long calculateNewDifficultyTarget(StoredBlock storedPrev, Block nextBlock, BlockStore blockStore) throws VerificationException, BlockStoreException, CheckpointEncounteredException {
        int retargetInterval;
        if (this.allowDigishieldMinDifficultyForBlock(storedPrev, nextBlock)) {
            return Utils.encodeCompactBits((BigInteger)this.getMaxTarget());
        }
        Block prev = storedPrev.getHeader();
        int previousHeight = storedPrev.getHeight();
        boolean digishieldAlgorithm = previousHeight + 1 >= this.getDigishieldBlockHeight();
        int n = retargetInterval = digishieldAlgorithm ? this.getNewInterval() : this.getInterval();
        if ((storedPrev.getHeight() + 1) % retargetInterval != 0) {
            if (this.allowMinDifficultyBlocks()) {
                StoredBlock prevCursor;
                if (nextBlock.getTimeSeconds() > prev.getTimeSeconds() + (long)(this.getTargetSpacing(previousHeight + 1) * 2)) {
                    return Utils.encodeCompactBits((BigInteger)this.maxTarget);
                }
                StoredBlock cursor = storedPrev;
                while (cursor.getHeight() % retargetInterval != 0 && cursor.getHeader().getDifficultyTarget() == Utils.encodeCompactBits((BigInteger)this.getMaxTarget()) && (prevCursor = cursor.getPrev(blockStore)) != null) {
                    cursor = prevCursor;
                }
                return cursor.getHeader().getDifficultyTarget();
            }
            return prev.getDifficultyTarget();
        }
        StoredBlock cursor = storedPrev;
        int goBack = retargetInterval - 1;
        if (cursor.getHeight() + 1 != retargetInterval) {
            goBack = retargetInterval;
        }
        for (int i = 0; i < goBack; ++i) {
            if (cursor == null) {
                throw new VerificationException("Difficulty transition point but we did not find a way back to the genesis block.");
            }
            cursor = blockStore.get(cursor.getHeader().getPrevBlockHash());
        }
        if (cursor == null) {
            this.log.debug("Difficulty transition: Hit checkpoint!");
            throw new CheckpointEncounteredException();
        }
        Block blockIntervalAgo = cursor.getHeader();
        return this.calculateNewDifficultyTargetInner(previousHeight, prev.getTimeSeconds(), prev.getDifficultyTarget(), blockIntervalAgo.getTimeSeconds(), nextBlock.getDifficultyTarget());
    }

    protected long calculateNewDifficultyTargetInner(int previousHeight, Block prev, Block nextBlock, Block blockIntervalAgo) {
        return this.calculateNewDifficultyTargetInner(previousHeight, prev.getTimeSeconds(), prev.getDifficultyTarget(), blockIntervalAgo.getTimeSeconds(), nextBlock.getDifficultyTarget());
    }

    protected long calculateNewDifficultyTargetInner(int previousHeight, long previousBlockTime, long lastDifficultyTarget, long lastRetargetTime, long nextDifficultyTarget) {
        int maxTimespan;
        int minTimespan;
        int height = previousHeight + 1;
        boolean digishieldAlgorithm = height >= this.getDigishieldBlockHeight();
        int retargetTimespan = digishieldAlgorithm ? this.getNewTargetTimespan() : this.getTargetTimespan();
        int actualTime = (int)(previousBlockTime - lastRetargetTime);
        if (digishieldAlgorithm) {
            actualTime = actualTime < retargetTimespan ? (int)Math.ceil((double)retargetTimespan + (double)(actualTime - retargetTimespan) / 8.0) : (int)Math.floor((double)retargetTimespan + (double)(actualTime - retargetTimespan) / 8.0);
            minTimespan = retargetTimespan - retargetTimespan / 4;
            maxTimespan = retargetTimespan + retargetTimespan / 2;
        } else if (height > 10000) {
            minTimespan = retargetTimespan / 4;
            maxTimespan = retargetTimespan * 4;
        } else if (height > 5000) {
            minTimespan = retargetTimespan / 8;
            maxTimespan = retargetTimespan * 4;
        } else {
            minTimespan = retargetTimespan / 16;
            maxTimespan = retargetTimespan * 4;
        }
        actualTime = Math.min(maxTimespan, Math.max(minTimespan, actualTime));
        BigInteger newTarget = Utils.decodeCompactBits((long)lastDifficultyTarget);
        newTarget = newTarget.multiply(BigInteger.valueOf(actualTime));
        newTarget = newTarget.divide(BigInteger.valueOf(retargetTimespan));
        if (newTarget.compareTo(this.getMaxTarget()) > 0) {
            this.log.info("Difficulty hit proof of work limit: {}", (Object)newTarget.toString(16));
            newTarget = this.getMaxTarget();
        }
        int accuracyBytes = (int)(nextDifficultyTarget >>> 24) - 3;
        BigInteger mask = BigInteger.valueOf(0xFFFFFFL).shiftLeft(accuracyBytes * 8);
        newTarget = newTarget.and(mask);
        return Utils.encodeCompactBits((BigInteger)newTarget);
    }

    public int getDigishieldBlockHeight() {
        return 145000;
    }

    @Override
    public int getChainID() {
        return 98;
    }

    public abstract boolean allowMinDifficultyBlocks();

    @Override
    public Sha256Hash getBlockDifficultyHash(Block block) {
        return ((AltcoinBlock)block).getScryptHash();
    }

    public AltcoinSerializer getSerializer(boolean parseRetain) {
        return new AltcoinSerializer(this, parseRetain);
    }

    public int getProtocolVersionNum(NetworkParameters.ProtocolVersion version) {
        switch (version) {
            case PONG: 
            case BLOOM_FILTER: {
                return version.getBitcoinProtocolVersion();
            }
            case CURRENT: {
                return 70004;
            }
        }
        return 70003;
    }

    @Override
    public boolean isAuxPoWBlockVersion(long version) {
        return version >= 0x620002L && (version & 0x100L) > 0L;
    }

    protected int getTargetSpacing(int height) {
        boolean digishieldAlgorithm = height >= this.getDigishieldBlockHeight();
        int retargetInterval = digishieldAlgorithm ? this.getNewInterval() : this.getInterval();
        int retargetTimespan = digishieldAlgorithm ? this.getNewTargetTimespan() : this.getTargetTimespan();
        return retargetTimespan / retargetInterval;
    }

    private static class CheckpointEncounteredException
    extends Exception {
        private CheckpointEncounteredException() {
        }
    }
}

