/*
 * Decompiled with CFR 0.152.
 */
package org.libdohj.params;

import java.math.BigInteger;
import org.bitcoinj.core.AltcoinBlock;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.utils.MonetaryFormat;
import org.libdohj.core.AltcoinNetworkParameters;
import org.libdohj.core.AltcoinSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLitecoinParams
extends NetworkParameters
implements AltcoinNetworkParameters {
    public static final MonetaryFormat LTC;
    public static final MonetaryFormat MLTC;
    public static final MonetaryFormat LITOSHI;
    public static final int LITE_TARGET_TIMESPAN = 302400;
    public static final int LITE_TARGET_SPACING = 150;
    public static final int LITE_INTERVAL = 2016;
    public static final long MAX_LITECOINS = 21000000L;
    public static final Coin MAX_LITECOIN_MONEY;
    public static final String CODE_LTC = "LTC";
    public static final String CODE_MLTC = "mLTC";
    public static final String CODE_LITOSHI = "Litoshi";
    public static final String ID_LITE_MAINNET = "org.litecoin.production";
    public static final String ID_LITE_TESTNET = "org.litecoin.test";
    public static final String ID_LITE_REGTEST = "regtest";
    public static final int LITECOIN_PROTOCOL_VERSION_MINIMUM = 70002;
    public static final int LITECOIN_PROTOCOL_VERSION_CURRENT = 70003;
    private static final Coin BASE_SUBSIDY;
    protected Logger log = LoggerFactory.getLogger(AbstractLitecoinParams.class);

    public AbstractLitecoinParams() {
        this.interval = 2016;
        this.targetTimespan = 302400;
        this.maxTarget = Utils.decodeCompactBits((long)504365055L);
        this.packetMagic = -71256357L;
        this.bip32HeaderPub = 76071982;
        this.bip32HeaderPriv = 76079604;
    }

    @Override
    public Coin getBlockSubsidy(int height) {
        return BASE_SUBSIDY.shiftRight(height / this.getSubsidyDecreaseBlockCount());
    }

    @Override
    public Sha256Hash getBlockDifficultyHash(Block block) {
        return ((AltcoinBlock)block).getScryptHash();
    }

    public MonetaryFormat getMonetaryFormat() {
        return LTC;
    }

    public Coin getMaxMoney() {
        return MAX_LITECOIN_MONEY;
    }

    public Coin getMinNonDustOutput() {
        return Coin.valueOf((long)100000L);
    }

    public String getUriScheme() {
        return "litecoin";
    }

    public boolean hasMaxMoney() {
        return true;
    }

    public void checkDifficultyTransitions(StoredBlock storedPrev, Block nextBlock, BlockStore blockStore) throws VerificationException, BlockStoreException {
        try {
            long newTargetCompact = this.calculateNewDifficultyTarget(storedPrev, nextBlock, blockStore);
            long receivedTargetCompact = nextBlock.getDifficultyTarget();
            if (newTargetCompact != receivedTargetCompact) {
                throw new VerificationException("Network provided difficulty bits do not match what was calculated: " + newTargetCompact + " vs " + receivedTargetCompact);
            }
        }
        catch (CheckpointEncounteredException checkpointEncounteredException) {
            // empty catch block
        }
    }

    public long calculateNewDifficultyTarget(StoredBlock storedPrev, Block nextBlock, BlockStore blockStore) throws VerificationException, BlockStoreException, CheckpointEncounteredException {
        Block prev = storedPrev.getHeader();
        int previousHeight = storedPrev.getHeight();
        int retargetInterval = this.getInterval();
        if ((storedPrev.getHeight() + 1) % retargetInterval != 0) {
            if (this.allowMinDifficultyBlocks()) {
                StoredBlock prevCursor;
                if (nextBlock.getTimeSeconds() > prev.getTimeSeconds() + (long)(this.getTargetSpacing() * 2)) {
                    return Utils.encodeCompactBits((BigInteger)this.maxTarget);
                }
                StoredBlock cursor = storedPrev;
                while (cursor.getHeight() % retargetInterval != 0 && cursor.getHeader().getDifficultyTarget() == Utils.encodeCompactBits((BigInteger)this.getMaxTarget()) && (prevCursor = cursor.getPrev(blockStore)) != null) {
                    cursor = prevCursor;
                }
                return cursor.getHeader().getDifficultyTarget();
            }
            return prev.getDifficultyTarget();
        }
        StoredBlock cursor = storedPrev;
        int goBack = retargetInterval - 1;
        if (cursor.getHeight() + 1 != retargetInterval) {
            goBack = retargetInterval;
        }
        for (int i = 0; i < goBack; ++i) {
            if (cursor == null) {
                throw new VerificationException("Difficulty transition point but we did not find a way back to the genesis block.");
            }
            cursor = blockStore.get(cursor.getHeader().getPrevBlockHash());
        }
        if (cursor == null) {
            this.log.debug("Difficulty transition: Hit checkpoint!");
            throw new CheckpointEncounteredException();
        }
        Block blockIntervalAgo = cursor.getHeader();
        return this.calculateNewDifficultyTargetInner(previousHeight, prev.getTimeSeconds(), prev.getDifficultyTarget(), blockIntervalAgo.getTimeSeconds(), nextBlock.getDifficultyTarget());
    }

    protected long calculateNewDifficultyTargetInner(int previousHeight, Block prev, Block nextBlock, Block blockIntervalAgo) {
        return this.calculateNewDifficultyTargetInner(previousHeight, prev.getTimeSeconds(), prev.getDifficultyTarget(), blockIntervalAgo.getTimeSeconds(), nextBlock.getDifficultyTarget());
    }

    protected long calculateNewDifficultyTargetInner(int previousHeight, long previousBlockTime, long lastDifficultyTarget, long lastRetargetTime, long nextDifficultyTarget) {
        int retargetTimespan = this.getTargetTimespan();
        int actualTime = (int)(previousBlockTime - lastRetargetTime);
        int minTimespan = retargetTimespan / 4;
        int maxTimespan = retargetTimespan * 4;
        actualTime = Math.min(maxTimespan, Math.max(minTimespan, actualTime));
        BigInteger newTarget = Utils.decodeCompactBits((long)lastDifficultyTarget);
        newTarget = newTarget.multiply(BigInteger.valueOf(actualTime));
        if ((newTarget = newTarget.divide(BigInteger.valueOf(retargetTimespan))).compareTo(this.getMaxTarget()) > 0) {
            this.log.info("Difficulty hit proof of work limit: {}", (Object)newTarget.toString(16));
            newTarget = this.getMaxTarget();
        }
        int accuracyBytes = (int)(nextDifficultyTarget >>> 24) - 3;
        BigInteger mask = BigInteger.valueOf(0xFFFFFFL).shiftLeft(accuracyBytes * 8);
        newTarget = newTarget.and(mask);
        return Utils.encodeCompactBits((BigInteger)newTarget);
    }

    public AltcoinSerializer getSerializer(boolean parseRetain) {
        return new AltcoinSerializer(this, parseRetain);
    }

    public int getProtocolVersionNum(NetworkParameters.ProtocolVersion version) {
        switch (version) {
            case PONG: 
            case BLOOM_FILTER: {
                return version.getBitcoinProtocolVersion();
            }
            case CURRENT: {
                return 70003;
            }
        }
        return 70002;
    }

    public boolean allowMinDifficultyBlocks() {
        return this.isTestNet();
    }

    public int getTargetSpacing() {
        return this.getTargetTimespan() / this.getInterval();
    }

    static {
        MAX_LITECOIN_MONEY = Coin.COIN.multiply(21000000L);
        LTC = MonetaryFormat.BTC.noCode().code(0, CODE_LTC).code(3, CODE_MLTC).code(7, CODE_LITOSHI);
        MLTC = LTC.shift(3).minDecimals(2).optionalDecimals(new int[]{2});
        LITOSHI = LTC.shift(7).minDecimals(0).optionalDecimals(new int[]{2});
        BASE_SUBSIDY = Coin.COIN.multiply(50L);
    }

    private static class CheckpointEncounteredException
    extends Exception {
        private CheckpointEncounteredException() {
        }
    }
}

