/*
 * Decompiled with CFR 0.152.
 */
package org.libdohj.params;

import com.google.common.base.Stopwatch;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.concurrent.TimeUnit;
import org.bitcoinj.core.AltcoinBlock;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.script.Script;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.utils.MonetaryFormat;
import org.libdohj.core.AltcoinSerializer;
import org.libdohj.core.AuxPoWNetworkParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNamecoinParams
extends NetworkParameters
implements AuxPoWNetworkParameters {
    public static final MonetaryFormat NMC = MonetaryFormat.BTC.noCode().code(0, "NMC").code(3, "mNMC").code(6, "\u00b5NMC");
    public static final MonetaryFormat MNMC = NMC.shift(3).minDecimals(2).optionalDecimals(new int[]{2});
    public static final MonetaryFormat UNMC = NMC.shift(6).minDecimals(0).optionalDecimals(new int[]{0});
    public static final int AUXPOW_CHAIN_ID = 1;
    public static final String CODE_NMC = "NMC";
    public static final String CODE_MNMC = "mNMC";
    public static final String CODE_UNMC = "\u00b5NMC";
    protected int auxpowStartHeight;
    private static final int BLOCK_VERSION_FLAG_AUXPOW = 256;
    public static final String ID_NMC_MAINNET = "org.namecoin.production";
    public static final String ID_NMC_TESTNET = "org.namecoin.test";
    protected Logger log = LoggerFactory.getLogger(AbstractNamecoinParams.class);
    public static final int NAMECOIN_PROTOCOL_VERSION_GETHEADERS = 38000;

    public AbstractNamecoinParams() {
        this.genesisBlock = AbstractNamecoinParams.createGenesis(this);
        this.interval = 2016;
        this.targetTimespan = 1209600;
        this.maxTarget = Utils.decodeCompactBits((long)504365055L);
        this.bip32HeaderPub = 76067358;
        this.bip32HeaderPriv = 76066276;
    }

    private static AltcoinBlock createGenesis(NetworkParameters params) {
        AltcoinBlock genesisBlock = new AltcoinBlock(params, 1L);
        Transaction t = new Transaction(params);
        try {
            byte[] bytes = Utils.HEX.decode((CharSequence)"04ff7f001c020a024b2e2e2e2063686f6f7365207768617420636f6d6573206e6578742e20204c69766573206f6620796f7572206f776e2c206f7220612072657475726e20746f20636861696e732e202d2d2056");
            t.addInput(new TransactionInput(params, t, bytes));
            ByteArrayOutputStream scriptPubKeyBytes = new ByteArrayOutputStream();
            Script.writeBytes((OutputStream)scriptPubKeyBytes, (byte[])Utils.HEX.decode((CharSequence)"04b620369050cd899ffbbc4e8ee51e8c4534a855bb463439d63d235d4779685d8b6f4870a238cf365ac94fa13ef9a2a22cd99d0d5ee86dcabcafce36c7acf43ce5"));
            scriptPubKeyBytes.write(172);
            t.addOutput(new TransactionOutput(params, t, Coin.COIN.multiply(50L), scriptPubKeyBytes.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        genesisBlock.addTransaction(t);
        return genesisBlock;
    }

    @Override
    public Coin getBlockSubsidy(int height) {
        return Coin.COIN.multiply(50L).shiftRight(height / this.getSubsidyDecreaseBlockCount());
    }

    public MonetaryFormat getMonetaryFormat() {
        return NMC;
    }

    public Coin getMaxMoney() {
        return MAX_MONEY;
    }

    public Coin getMinNonDustOutput() {
        return Transaction.MIN_NONDUST_OUTPUT;
    }

    public String getUriScheme() {
        return "namecoin";
    }

    public boolean hasMaxMoney() {
        return true;
    }

    protected boolean isDifficultyTransitionPoint(StoredBlock storedPrev) {
        return (storedPrev.getHeight() + 1) % this.getInterval() == 0;
    }

    public void checkDifficultyTransitions(StoredBlock storedPrev, Block nextBlock, BlockStore blockStore) throws VerificationException, BlockStoreException {
        int targetTimespan;
        Block prev = storedPrev.getHeader();
        if (!this.isDifficultyTransitionPoint(storedPrev)) {
            if (nextBlock.getDifficultyTarget() != prev.getDifficultyTarget()) {
                throw new VerificationException("Unexpected change in difficulty at height " + storedPrev.getHeight() + ": " + Long.toHexString(nextBlock.getDifficultyTarget()) + " vs " + Long.toHexString(prev.getDifficultyTarget()));
            }
            return;
        }
        Stopwatch watch = Stopwatch.createStarted();
        StoredBlock cursor = blockStore.get(prev.getHash());
        int blocksBack = this.getInterval() - 1;
        if (storedPrev.getHeight() >= this.getAuxpowStartHeight() && storedPrev.getHeight() + 1 > this.getInterval()) {
            blocksBack = this.getInterval();
        }
        for (int i = 0; i < blocksBack; ++i) {
            if (cursor == null) {
                throw new VerificationException("Difficulty transition point but we did not find a way back to the genesis block.");
            }
            cursor = blockStore.get(cursor.getHeader().getPrevBlockHash());
        }
        watch.stop();
        if (watch.elapsed(TimeUnit.MILLISECONDS) > 50L) {
            this.log.info("Difficulty transition traversal took {}", (Object)watch);
        }
        Block blockIntervalAgo = cursor.getHeader();
        int timespan = (int)(prev.getTimeSeconds() - blockIntervalAgo.getTimeSeconds());
        if (timespan < (targetTimespan = this.getTargetTimespan()) / 4) {
            timespan = targetTimespan / 4;
        }
        if (timespan > targetTimespan * 4) {
            timespan = targetTimespan * 4;
        }
        BigInteger newTarget = Utils.decodeCompactBits((long)prev.getDifficultyTarget());
        newTarget = newTarget.multiply(BigInteger.valueOf(timespan));
        if ((newTarget = newTarget.divide(BigInteger.valueOf(targetTimespan))).compareTo(this.getMaxTarget()) > 0) {
            this.log.info("Difficulty hit proof of work limit: {}", (Object)newTarget.toString(16));
            newTarget = this.getMaxTarget();
        }
        int accuracyBytes = (int)(nextBlock.getDifficultyTarget() >>> 24) - 3;
        long receivedTargetCompact = nextBlock.getDifficultyTarget();
        BigInteger mask = BigInteger.valueOf(0xFFFFFFL).shiftLeft(accuracyBytes * 8);
        long newTargetCompact = Utils.encodeCompactBits((BigInteger)(newTarget = newTarget.and(mask)));
        if (newTargetCompact != receivedTargetCompact) {
            throw new VerificationException("Network provided difficulty bits do not match what was calculated: " + Long.toHexString(newTargetCompact) + " vs " + Long.toHexString(receivedTargetCompact));
        }
    }

    @Override
    public int getChainID() {
        return 1;
    }

    @Override
    public Sha256Hash getBlockDifficultyHash(Block block) {
        return block.getHash();
    }

    public AltcoinSerializer getSerializer(boolean parseRetain) {
        return new AltcoinSerializer(this, parseRetain);
    }

    public int getProtocolVersionNum(NetworkParameters.ProtocolVersion version) {
        switch (version) {
            case MINIMUM: {
                return 38000;
            }
        }
        return version.getBitcoinProtocolVersion();
    }

    @Override
    public boolean isAuxPoWBlockVersion(long version) {
        return (version & 0x100L) > 0L;
    }

    public int getAuxpowStartHeight() {
        return this.auxpowStartHeight;
    }

    private static class CheckpointEncounteredException
    extends Exception {
        private CheckpointEncounteredException() {
        }
    }
}

