/*
 * Decompiled with CFR 0.152.
 */
package org.libdohj.params;

import com.google.common.base.Preconditions;
import org.bitcoinj.core.Sha256Hash;
import org.libdohj.params.AbstractDashParams;

public class DashMainNetParams
extends AbstractDashParams {
    public static final int MAINNET_MAJORITY_WINDOW = 1000;
    public static final int MAINNET_MAJORITY_REJECT_BLOCK_OUTDATED = 950;
    public static final int MAINNET_MAJORITY_ENFORCE_BLOCK_UPGRADE = 750;
    protected static final int DIFFICULTY_CHANGE_TARGET = 1;
    private static DashMainNetParams instance;

    public DashMainNetParams() {
        super(1);
        this.dumpedPrivateKeyHeader = 204;
        this.addressHeader = 76;
        this.p2shHeader = 16;
        this.acceptableAddressCodes = new int[]{this.addressHeader, this.p2shHeader};
        this.port = 9999;
        this.packetMagic = -1089705027L;
        this.bip32HeaderPub = 76067358;
        this.bip32HeaderPriv = 76066276;
        this.genesisBlock.setDifficultyTarget(504365040L);
        this.genesisBlock.setTime(1390095618L);
        this.genesisBlock.setNonce(28917698L);
        this.id = "org.dash.production";
        this.subsidyDecreaseBlockCount = 210240;
        this.spendableCoinbaseDepth = 100;
        String genesisHash = this.genesisBlock.getHashAsString();
        Preconditions.checkState((boolean)genesisHash.equals("00000ffd590b1485b3caadc19b22e6379c733355108f107a430458cdf3407ab6"), (Object)genesisHash);
        this.majorityEnforceBlockUpgrade = 750;
        this.majorityRejectBlockOutdated = 950;
        this.majorityWindow = 1000;
        this.checkpoints.put(1500, Sha256Hash.wrap((String)"000000aaf0300f59f49bc3e970bad15c11f961fe2347accffff19d96ec9778e3"));
        this.checkpoints.put(4991, Sha256Hash.wrap((String)"000000003b01809551952460744d5dbb8fcbd6cbae3c220267bf7fa43f837367"));
        this.checkpoints.put(9918, Sha256Hash.wrap((String)"00000000213e229f332c0ffbe34defdaa9e74de87f2d8d1f01af8d121c3c170b"));
        this.checkpoints.put(16912, Sha256Hash.wrap((String)"00000000075c0d10371d55a60634da70f197548dbbfa4123e12abfcbc5738af9"));
        this.checkpoints.put(23912, Sha256Hash.wrap((String)"0000000000335eac6703f3b1732ec8b2f89c3ba3a7889e5767b090556bb9a276"));
        this.checkpoints.put(35457, Sha256Hash.wrap((String)"0000000000b0ae211be59b048df14820475ad0dd53b9ff83b010f71a77342d9f"));
        this.checkpoints.put(45479, Sha256Hash.wrap((String)"000000000063d411655d590590e16960f15ceea4257122ac430c6fbe39fbf02d"));
        this.checkpoints.put(55895, Sha256Hash.wrap((String)"0000000000ae4c53a43639a4ca027282f69da9c67ba951768a20415b6439a2d7"));
        this.checkpoints.put(68899, Sha256Hash.wrap((String)"0000000000194ab4d3d9eeb1f2f792f21bb39ff767cb547fe977640f969d77b7"));
        this.checkpoints.put(74619, Sha256Hash.wrap((String)"000000000011d28f38f05d01650a502cc3f4d0e793fbc26e2a2ca71f07dc3842"));
        this.checkpoints.put(75095, Sha256Hash.wrap((String)"0000000000193d12f6ad352a9996ee58ef8bdc4946818a5fec5ce99c11b87f0d"));
        this.checkpoints.put(88805, Sha256Hash.wrap((String)"00000000001392f1652e9bf45cd8bc79dc60fe935277cd11538565b4a94fa85f"));
        this.checkpoints.put(107996, Sha256Hash.wrap((String)"00000000000a23840ac16115407488267aa3da2b9bc843e301185b7d17e4dc40"));
        this.checkpoints.put(137993, Sha256Hash.wrap((String)"00000000000cf69ce152b1bffdeddc59188d7a80879210d6e5c9503011929c3c"));
        this.checkpoints.put(167996, Sha256Hash.wrap((String)"000000000009486020a80f7f2cc065342b0c2fb59af5e090cd813dba68ab0fed"));
        this.checkpoints.put(207992, Sha256Hash.wrap((String)"00000000000d85c22be098f74576ef00b7aa00c05777e966aff68a270f1e01a5"));
        this.checkpoints.put(312645, Sha256Hash.wrap((String)"0000000000059dcb71ad35a9e40526c44e7aae6c99169a9e7017b7d84b1c2daf"));
        this.checkpoints.put(407452, Sha256Hash.wrap((String)"000000000003c6a87e73623b9d70af7cd908ae22fee466063e4ffc20be1d2dbc"));
        this.checkpoints.put(523412, Sha256Hash.wrap((String)"000000000000e54f036576a10597e0e42cc22a5159ce572f999c33975e121d4d"));
        this.checkpoints.put(523930, Sha256Hash.wrap((String)"0000000000000bccdb11c2b1cfb0ecab452abf267d89b7f46eaf2d54ce6e652c"));
        this.dnsSeeds = new String[]{"dnsseed.masternode.io", "dnsseed.dashpay.io", "dnsseed.dash.org", "dnsseed.dashdot.io"};
    }

    public static synchronized DashMainNetParams get() {
        if (instance == null) {
            instance = new DashMainNetParams();
        }
        return instance;
    }

    @Override
    public boolean allowMinDifficultyBlocks() {
        return false;
    }

    public String getPaymentProtocolId() {
        return "org.dash.production";
    }

    @Override
    public boolean isTestNet() {
        return false;
    }
}

