/*
 * Decompiled with CFR 0.152.
 */
package org.libdohj.params;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.bitcoinj.core.AltcoinBlock;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.libdohj.params.DashTestNet3Params;

public class DashRegTestParams
extends DashTestNet3Params {
    private static final BigInteger MAX_TARGET = new BigInteger("7fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff", 16);
    private static Block genesis;
    private static DashRegTestParams instance;

    public DashRegTestParams() {
        this.interval = Integer.MAX_VALUE;
        this.maxTarget = MAX_TARGET;
        this.subsidyDecreaseBlockCount = 150;
        this.port = 19444;
        this.id = "org.dash.regtest";
        this.packetMagic = -54413348L;
    }

    public boolean allowEmptyPeerChain() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block getGenesisBlock() {
        Class<DashRegTestParams> clazz = DashRegTestParams.class;
        synchronized (DashRegTestParams.class) {
            if (genesis == null) {
                genesis = super.getGenesisBlock();
                genesis.setNonce(1096447L);
                genesis.setDifficultyTarget(545259519L);
                genesis.setTime(1417713337L);
                ((AltcoinBlock)genesis).resetAltcoinHash();
                Preconditions.checkState((genesis.getVersion() == 1L ? 1 : 0) != 0);
                Preconditions.checkState((boolean)genesis.getMerkleRoot().toString().equals("e0028eb9648db56b1ac77cf090b99048a8007e2bb64b68f092c03c7f56a662c7"));
                Preconditions.checkState((boolean)genesis.getHashAsString().toLowerCase().equals("000008ca1832a4baf228eb1553c03d3a2c8e02399550dd6ea8d65cec3ef23d2e"));
                genesis.verifyHeader();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return genesis;
        }
    }

    public static synchronized DashRegTestParams get() {
        if (instance == null) {
            instance = new DashRegTestParams();
        }
        return instance;
    }

    @Override
    public String getPaymentProtocolId() {
        return "org.dash.regtest";
    }

    @Override
    public long calculateNewDifficultyTarget(StoredBlock storedPrev, Block nextBlock, BlockStore blockStore) throws VerificationException, BlockStoreException {
        Block prev = storedPrev.getHeader();
        return prev.getDifficultyTarget();
    }

    @Override
    public boolean allowMinDifficultyBlocks() {
        return false;
    }
}

