/*
 * Decompiled with CFR 0.152.
 */
package org.libdohj.params;

import com.google.common.base.Preconditions;
import org.bitcoinj.core.Utils;
import org.libdohj.params.AbstractDashParams;
import org.spongycastle.util.encoders.Hex;

public class DashTestNet3Params
extends AbstractDashParams {
    public static final int TESTNET_MAJORITY_WINDOW = 100;
    public static final int TESTNET_MAJORITY_REJECT_BLOCK_OUTDATED = 75;
    public static final int TESTNET_MAJORITY_ENFORCE_BLOCK_UPGRADE = 51;
    protected static final int DIFFICULTY_CHANGE_TARGET = 1;
    private static DashTestNet3Params instance;

    public DashTestNet3Params() {
        super(1);
        this.id = "org.dash.test";
        this.packetMagic = -823997697L;
        this.maxTarget = Utils.decodeCompactBits((long)504365055L);
        this.port = 19999;
        this.addressHeader = 140;
        this.p2shHeader = 19;
        this.acceptableAddressCodes = new int[]{this.addressHeader, this.p2shHeader};
        this.dumpedPrivateKeyHeader = 241;
        this.genesisBlock.setTime(1390666206L);
        this.genesisBlock.setDifficultyTarget(504365040L);
        this.genesisBlock.setNonce(3861367235L);
        this.spendableCoinbaseDepth = 30;
        this.subsidyDecreaseBlockCount = 100000;
        String genesisHash = this.genesisBlock.getHashAsString();
        Preconditions.checkState((boolean)genesisHash.equals("00000bafbc94add76cb75e2ec92894837288a481e5c005f6563d91623bf8bc2c"));
        this.alertSigningKey = Hex.decode((String)"04517d8a699cb43d3938d7b24faaff7cda448ca4ea267723ba614784de661949bf632d6304316b244646dea079735b9a6fc4af804efb4752075b9fe2245e14e412");
        this.majorityEnforceBlockUpgrade = 51;
        this.majorityRejectBlockOutdated = 75;
        this.majorityWindow = 100;
        this.dnsSeeds = new String[]{"testnet-seed.dashdot.io", "test.dnsseed.masternode.io"};
        this.bip32HeaderPub = 70617039;
        this.bip32HeaderPriv = 70615956;
    }

    public static synchronized DashTestNet3Params get() {
        if (instance == null) {
            instance = new DashTestNet3Params();
        }
        return instance;
    }

    @Override
    public boolean allowMinDifficultyBlocks() {
        return true;
    }

    public String getPaymentProtocolId() {
        return "org.dash.test";
    }

    @Override
    public boolean isTestNet() {
        return true;
    }
}

