/*
 * Decompiled with CFR 0.152.
 */
package org.libdohj.params;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.libdohj.params.DogecoinTestNet3Params;

public class DogecoinRegTestParams
extends DogecoinTestNet3Params {
    private static final BigInteger MAX_TARGET = new BigInteger("7fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff", 16);
    public static final int REGTEST_MAJORITY_REJECT_BLOCK_OUTDATED = 950;
    public static final int REGTEST_MAJORITY_ENFORCE_BLOCK_UPGRADE = 750;
    private static Block genesis;
    private static DogecoinRegTestParams instance;

    public DogecoinRegTestParams() {
        this.interval = Integer.MAX_VALUE;
        this.maxTarget = MAX_TARGET;
        this.subsidyDecreaseBlockCount = 150;
        this.port = 18444;
        this.id = "org.dogecoin.regtest";
        this.packetMagic = -88099366L;
        this.majorityEnforceBlockUpgrade = 750;
        this.majorityRejectBlockOutdated = 950;
        this.genesisBlock.setTime(1296688602L);
        this.genesisBlock.setDifficultyTarget(545259519L);
        this.genesisBlock.setNonce(2L);
        Preconditions.checkState((boolean)this.genesisBlock.getHashAsString().toLowerCase().equals("3d2160a3b5dc4a9d62e7e66a295f70313ac808440ef7400d6c0772171ce973a5"));
    }

    public boolean allowEmptyPeerChain() {
        return true;
    }

    public static synchronized DogecoinRegTestParams get() {
        if (instance == null) {
            instance = new DogecoinRegTestParams();
        }
        return instance;
    }

    @Override
    public String getPaymentProtocolId() {
        return "org.dogecoin.regtest";
    }

    @Override
    public long calculateNewDifficultyTarget(StoredBlock storedPrev, Block nextBlock, BlockStore blockStore) throws VerificationException, BlockStoreException {
        Block prev = storedPrev.getHeader();
        return prev.getDifficultyTarget();
    }

    @Override
    public boolean allowMinDifficultyBlocks() {
        return false;
    }

    @Override
    public boolean isTestNet() {
        return false;
    }
}

