/*
 * Decompiled with CFR 0.152.
 */
package org.libdohj.params;

import com.google.common.base.Preconditions;
import org.bitcoinj.core.Utils;
import org.libdohj.params.AbstractDogecoinParams;
import org.spongycastle.util.encoders.Hex;

public class DogecoinTestNet3Params
extends AbstractDogecoinParams {
    public static final int TESTNET_MAJORITY_WINDOW = 1000;
    public static final int TESTNET_MAJORITY_REJECT_BLOCK_OUTDATED = 750;
    public static final int TESTNET_MAJORITY_ENFORCE_BLOCK_UPGRADE = 501;
    protected static final int DIFFICULTY_CHANGE_TARGET = 145000;
    private static DogecoinTestNet3Params instance;

    public DogecoinTestNet3Params() {
        super(145000);
        this.id = "org.dogecoin.test";
        this.packetMagic = -54413348L;
        this.maxTarget = Utils.decodeCompactBits((long)504365055L);
        this.port = 44556;
        this.addressHeader = 113;
        this.p2shHeader = 196;
        this.acceptableAddressCodes = new int[]{this.addressHeader, this.p2shHeader};
        this.dumpedPrivateKeyHeader = 241;
        this.genesisBlock.setTime(1391503289L);
        this.genesisBlock.setDifficultyTarget(504365040L);
        this.genesisBlock.setNonce(997879L);
        this.spendableCoinbaseDepth = 30;
        this.subsidyDecreaseBlockCount = 100000;
        String genesisHash = this.genesisBlock.getHashAsString();
        Preconditions.checkState((boolean)genesisHash.equals("bb0a78264637406b6360aad926284d544d7049f45189db5664f3c4d07350559e"));
        this.alertSigningKey = Hex.decode((String)"042756726da3c7ef515d89212ee1705023d14be389e25fe15611585661b9a20021908b2b80a3c7200a0139dd2b26946606aab0eef9aa7689a6dc2c7eee237fa834");
        this.majorityEnforceBlockUpgrade = 501;
        this.majorityRejectBlockOutdated = 750;
        this.majorityWindow = 1000;
        this.dnsSeeds = new String[]{"testseed.jrn.me.uk"};
        this.bip32HeaderPub = 70617039;
        this.bip32HeaderPriv = 70615956;
    }

    public static synchronized DogecoinTestNet3Params get() {
        if (instance == null) {
            instance = new DogecoinTestNet3Params();
        }
        return instance;
    }

    @Override
    public boolean allowMinDifficultyBlocks() {
        return true;
    }

    public String getPaymentProtocolId() {
        return "test";
    }

    @Override
    public boolean isTestNet() {
        return true;
    }
}

