/*
 * Decompiled with CFR 0.152.
 */
package org.libdohj.params;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.bitcoinj.core.AltcoinBlock;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.Utils;
import org.bitcoinj.script.Script;
import org.libdohj.params.AbstractLitecoinParams;
import org.spongycastle.util.encoders.Hex;

public class LitecoinMainNetParams
extends AbstractLitecoinParams {
    public static final int MAINNET_MAJORITY_WINDOW = 1000;
    public static final int MAINNET_MAJORITY_REJECT_BLOCK_OUTDATED = 950;
    public static final int MAINNET_MAJORITY_ENFORCE_BLOCK_UPGRADE = 750;
    private static LitecoinMainNetParams instance;

    public LitecoinMainNetParams() {
        this.id = "org.litecoin.production";
        this.packetMagic = -71256357L;
        this.maxTarget = Utils.decodeCompactBits((long)504365055L);
        this.port = 9333;
        this.addressHeader = 48;
        this.p2shHeader = 5;
        this.acceptableAddressCodes = new int[]{this.addressHeader, this.p2shHeader};
        this.dumpedPrivateKeyHeader = 176;
        this.genesisBlock = LitecoinMainNetParams.createGenesis(this);
        this.spendableCoinbaseDepth = 100;
        this.subsidyDecreaseBlockCount = 840000;
        String genesisHash = this.genesisBlock.getHashAsString();
        Preconditions.checkState((boolean)genesisHash.equals("12a765e31ffd4059bada1e25190f6e98c99d9714d334efa41a195a7e7e04bfe2"));
        this.alertSigningKey = Hex.decode((String)"040184710fa689ad5023690c80f3a49c8f13f8d45b8c857fbcbc8bc4a8e4d3eb4b10f4d4604fa08dce601aaf0f470216fe1b51850b4acf21b179c45070ac7b03a9");
        this.majorityEnforceBlockUpgrade = 750;
        this.majorityRejectBlockOutdated = 950;
        this.majorityWindow = 1000;
        this.dnsSeeds = new String[]{"seed-a.litecoin.loshan.co.uk", "dnsseed.thrasher.io", "dnsseed.litecointools.com", "dnsseed.litecoinpool.org", "dnsseed.koin-project.com"};
        this.bip32HeaderPub = 76067358;
        this.bip32HeaderPriv = 76066276;
    }

    private static AltcoinBlock createGenesis(NetworkParameters params) {
        AltcoinBlock genesisBlock = new AltcoinBlock(params, 1L);
        Transaction t = new Transaction(params);
        try {
            byte[] bytes = Hex.decode((String)"04ffff001d0104404e592054696d65732030352f4f63742f32303131205374657665204a6f62732c204170706c65e280997320566973696f6e6172792c2044696573206174203536");
            t.addInput(new TransactionInput(params, t, bytes));
            ByteArrayOutputStream scriptPubKeyBytes = new ByteArrayOutputStream();
            Script.writeBytes((OutputStream)scriptPubKeyBytes, (byte[])Hex.decode((String)"040184710fa689ad5023690c80f3a49c8f13f8d45b8c857fbcbc8bc4a8e4d3eb4b10f4d4604fa08dce601aaf0f470216fe1b51850b4acf21b179c45070ac7b03a9"));
            scriptPubKeyBytes.write(172);
            t.addOutput(new TransactionOutput(params, t, Coin.COIN.multiply(50L), scriptPubKeyBytes.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        genesisBlock.addTransaction(t);
        genesisBlock.setTime(1317972665L);
        genesisBlock.setDifficultyTarget(504365040L);
        genesisBlock.setNonce(2084524493L);
        return genesisBlock;
    }

    public static synchronized LitecoinMainNetParams get() {
        if (instance == null) {
            instance = new LitecoinMainNetParams();
        }
        return instance;
    }

    public String getPaymentProtocolId() {
        return "org.litecoin.production";
    }

    @Override
    public boolean isTestNet() {
        return false;
    }
}

