/*
 * Decompiled with CFR 0.152.
 */
package org.libdohj.params;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.libdohj.params.LitecoinTestNet3Params;

public class LitecoinRegTestParams
extends LitecoinTestNet3Params {
    private static final BigInteger MAX_TARGET = new BigInteger("7fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff", 16);
    private static Block genesis;
    private static LitecoinRegTestParams instance;

    public LitecoinRegTestParams() {
        this.interval = Integer.MAX_VALUE;
        this.maxTarget = MAX_TARGET;
        this.subsidyDecreaseBlockCount = 150;
        this.port = 19444;
        this.id = "regtest";
        this.packetMagic = -88099366L;
    }

    public boolean allowEmptyPeerChain() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block getGenesisBlock() {
        Class<LitecoinRegTestParams> clazz = LitecoinRegTestParams.class;
        synchronized (LitecoinRegTestParams.class) {
            if (genesis == null) {
                genesis = super.getGenesisBlock();
                genesis.setNonce(0L);
                genesis.setDifficultyTarget(545259519L);
                genesis.setTime(1296688602L);
                Preconditions.checkState((genesis.getVersion() == 1L ? 1 : 0) != 0);
                Preconditions.checkState((boolean)genesis.getMerkleRoot().toString().equals("97ddfbbae6be97fd6cdf3e7ca13232a3afff2353e29badfab7f73011edd4ced9"));
                Preconditions.checkState((boolean)genesis.getHashAsString().toLowerCase().equals("530827f38f93b43ed12af0b3ad25a288dc02ed74d6d7857862df51fc56c416f9"));
                genesis.verifyHeader();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return genesis;
        }
    }

    public static synchronized LitecoinRegTestParams get() {
        if (instance == null) {
            instance = new LitecoinRegTestParams();
        }
        return instance;
    }

    @Override
    public String getPaymentProtocolId() {
        return "regtest";
    }

    @Override
    public long calculateNewDifficultyTarget(StoredBlock storedPrev, Block nextBlock, BlockStore blockStore) throws VerificationException, BlockStoreException {
        Block prev = storedPrev.getHeader();
        return prev.getDifficultyTarget();
    }
}

