/*
 * Decompiled with CFR 0.152.
 */
package org.libdohj.params;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.bitcoinj.core.AltcoinBlock;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.Utils;
import org.bitcoinj.script.Script;
import org.libdohj.params.AbstractLitecoinParams;
import org.spongycastle.util.encoders.Hex;

public class LitecoinTestNet3Params
extends AbstractLitecoinParams {
    public static final int TESTNET_MAJORITY_WINDOW = 100;
    public static final int TESTNET_MAJORITY_REJECT_BLOCK_OUTDATED = 75;
    public static final int TESTNET_MAJORITY_ENFORCE_BLOCK_UPGRADE = 51;
    private static LitecoinTestNet3Params instance;

    public LitecoinTestNet3Params() {
        this.id = "org.litecoin.test";
        this.packetMagic = -54413348L;
        this.maxTarget = Utils.decodeCompactBits((long)504365055L);
        this.port = 19333;
        this.addressHeader = 111;
        this.p2shHeader = 196;
        this.acceptableAddressCodes = new int[]{this.addressHeader, this.p2shHeader};
        this.dumpedPrivateKeyHeader = 239;
        this.genesisBlock = LitecoinTestNet3Params.createGenesis(this);
        this.spendableCoinbaseDepth = 30;
        this.subsidyDecreaseBlockCount = 100000;
        String genesisHash = this.genesisBlock.getHashAsString();
        Preconditions.checkState((boolean)genesisHash.equals("f5ae71e26c74beacc88382716aced69cddf3dffff24f384e1808905e0188f68f"));
        this.alertSigningKey = Hex.decode((String)"0449623fc74489a947c4b15d579115591add020e53b3490bf47297dfa3762250625f8ecc2fb4fc59f69bdce8f7080f3167808276ed2c79d297054367566038aa82");
        this.majorityEnforceBlockUpgrade = 51;
        this.majorityRejectBlockOutdated = 75;
        this.majorityWindow = 100;
        this.dnsSeeds = new String[]{"testnet-seed.litecointools.com", "seed-b.litecoin.loshan.co.uk", "dnsseed-testnet.thrasher.io"};
        this.bip32HeaderPub = 70617039;
        this.bip32HeaderPriv = 70615956;
    }

    private static AltcoinBlock createGenesis(NetworkParameters params) {
        AltcoinBlock genesisBlock = new AltcoinBlock(params, 1L);
        Transaction t = new Transaction(params);
        try {
            byte[] bytes = Hex.decode((String)"04ffff001d0104404e592054696d65732030352f4f63742f32303131205374657665204a6f62732c204170706c65e280997320566973696f6e6172792c2044696573206174203536");
            t.addInput(new TransactionInput(params, t, bytes));
            ByteArrayOutputStream scriptPubKeyBytes = new ByteArrayOutputStream();
            Script.writeBytes((OutputStream)scriptPubKeyBytes, (byte[])Hex.decode((String)"040184710fa689ad5023690c80f3a49c8f13f8d45b8c857fbcbc8bc4a8e4d3eb4b10f4d4604fa08dce601aaf0f470216fe1b51850b4acf21b179c45070ac7b03a9"));
            scriptPubKeyBytes.write(172);
            t.addOutput(new TransactionOutput(params, t, Coin.COIN.multiply(50L), scriptPubKeyBytes.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        genesisBlock.addTransaction(t);
        genesisBlock.setTime(1317798646L);
        genesisBlock.setDifficultyTarget(504365040L);
        genesisBlock.setNonce(385270584L);
        return genesisBlock;
    }

    public static synchronized LitecoinTestNet3Params get() {
        if (instance == null) {
            instance = new LitecoinTestNet3Params();
        }
        return instance;
    }

    public String getPaymentProtocolId() {
        return "org.litecoin.test";
    }

    @Override
    public boolean isTestNet() {
        return true;
    }
}

