/*
 * Decompiled with CFR 0.152.
 */
package org.libdohj.params;

import com.google.common.base.Preconditions;
import org.bitcoinj.core.Sha256Hash;
import org.libdohj.params.AbstractNamecoinParams;
import org.spongycastle.util.encoders.Hex;

public class NamecoinMainNetParams
extends AbstractNamecoinParams {
    public static final int MAINNET_MAJORITY_WINDOW = 1000;
    public static final int MAINNET_MAJORITY_REJECT_BLOCK_OUTDATED = 950;
    public static final int MAINNET_MAJORITY_ENFORCE_BLOCK_UPGRADE = 750;
    private static NamecoinMainNetParams instance;

    public NamecoinMainNetParams() {
        this.dumpedPrivateKeyHeader = 180;
        this.addressHeader = 52;
        this.p2shHeader = 13;
        this.acceptableAddressCodes = new int[]{this.addressHeader};
        this.port = 8334;
        this.packetMagic = -104942338L;
        this.genesisBlock.setDifficultyTarget(469794815L);
        this.genesisBlock.setTime(1303000001L);
        this.genesisBlock.setNonce(2719916434L);
        this.id = "org.namecoin.production";
        this.subsidyDecreaseBlockCount = 210000;
        this.spendableCoinbaseDepth = 100;
        this.auxpowStartHeight = 19200;
        String genesisHash = this.genesisBlock.getHashAsString();
        Preconditions.checkState((boolean)genesisHash.equals("000000000062b72c5e2ceb45fbc8587e807c155b0da735e6483dfba2f0a9c770"), (Object)genesisHash);
        this.alertSigningKey = Hex.decode((String)"04ba207043c1575208f08ea6ac27ed2aedd4f84e70b874db129acb08e6109a3bbb7c479ae22565973ebf0ac0391514511a22cb9345bdb772be20cfbd38be578b0c");
        this.majorityEnforceBlockUpgrade = 750;
        this.majorityRejectBlockOutdated = 950;
        this.majorityWindow = 1000;
        this.checkpoints.put(2016, Sha256Hash.wrap((String)"0000000000660bad0d9fbde55ba7ee14ddf766ed5f527e3fbca523ac11460b92"));
        this.checkpoints.put(4032, Sha256Hash.wrap((String)"0000000000493b5696ad482deb79da835fe2385304b841beef1938655ddbc411"));
        this.checkpoints.put(6048, Sha256Hash.wrap((String)"000000000027939a2e1d8bb63f36c47da858e56d570f143e67e85068943470c9"));
        this.checkpoints.put(8064, Sha256Hash.wrap((String)"000000000003a01f708da7396e54d081701ea406ed163e519589717d8b7c95a5"));
        this.checkpoints.put(10080, Sha256Hash.wrap((String)"00000000000fed3899f818b2228b4f01b9a0a7eeee907abd172852df71c64b06"));
        this.checkpoints.put(12096, Sha256Hash.wrap((String)"0000000000006c06988ff361f124314f9f4bb45b6997d90a7ee4cedf434c670f"));
        this.checkpoints.put(14112, Sha256Hash.wrap((String)"00000000000045d95e0588c47c17d593c7b5cb4fb1e56213d1b3843c1773df2b"));
        this.checkpoints.put(16128, Sha256Hash.wrap((String)"000000000001d9964f9483f9096cf9d6c6c2886ed1e5dec95ad2aeec3ce72fa9"));
        this.checkpoints.put(18940, Sha256Hash.wrap((String)"00000000000087f7fc0c8085217503ba86f796fa4984f7e5a08b6c4c12906c05"));
        this.checkpoints.put(30240, Sha256Hash.wrap((String)"e1c8c862ff342358384d4c22fa6ea5f669f3e1cdcf34111f8017371c3c0be1da"));
        this.checkpoints.put(57000, Sha256Hash.wrap((String)"aa3ec60168a0200799e362e2b572ee01f3c3852030d07d036e0aa884ec61f203"));
        this.checkpoints.put(112896, Sha256Hash.wrap((String)"73f880e78a04dd6a31efc8abf7ca5db4e262c4ae130d559730d6ccb8808095bf"));
        this.checkpoints.put(182000, Sha256Hash.wrap((String)"d47b4a8fd282f635d66ce34ebbeb26ffd64c35b41f286646598abfd813cba6d9"));
        this.checkpoints.put(193000, Sha256Hash.wrap((String)"3b85e70ba7f5433049cfbcf0ae35ed869496dbedcd1c0fafadb0284ec81d7b58"));
        this.dnsSeeds = new String[]{"namecoindnsseed.digi-masters.com", "namecoindnsseed.digi-masters.uk", "seed.namecoin.domob.eu", "nmc.seed.quisquis.de", "dnsseed.namecoin.webbtc.com"};
    }

    public static synchronized NamecoinMainNetParams get() {
        if (instance == null) {
            instance = new NamecoinMainNetParams();
        }
        return instance;
    }

    public String getPaymentProtocolId() {
        return "org.namecoin.production";
    }

    @Override
    public boolean isTestNet() {
        return false;
    }
}

