/*
 * Decompiled with CFR 0.152.
 */
package org.libdohj.script;

import java.util.ArrayList;
import java.util.List;
import org.bitcoinj.core.ScriptException;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.script.ScriptChunk;

public class NameScript {
    public static final int OP_NAME_NEW = 81;
    public static final int OP_NAME_FIRSTUPDATE = 82;
    public static final int OP_NAME_UPDATE = 83;
    protected int op = 97;
    protected ArrayList<ScriptChunk> args = new ArrayList();
    protected Script address;

    public NameScript(Script baseScript) {
        ScriptChunk nameOp;
        this.address = baseScript;
        int pc = 0;
        List chunks = baseScript.getChunks();
        try {
            nameOp = (ScriptChunk)chunks.get(pc);
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        ++pc;
        while (true) {
            ScriptChunk arg;
            try {
                arg = (ScriptChunk)chunks.get(pc);
            }
            catch (IndexOutOfBoundsException e) {
                return;
            }
            ++pc;
            if (arg.opcode == 117 || arg.opcode == 109 || arg.opcode == 97) break;
            if (arg.opcode < 0 || arg.opcode > 78) {
                return;
            }
            this.args.add(arg);
        }
        try {
            while (((ScriptChunk)chunks.get((int)pc)).opcode == 117 || ((ScriptChunk)chunks.get((int)pc)).opcode == 109 || ((ScriptChunk)chunks.get((int)pc)).opcode == 97) {
                ++pc;
            }
        }
        catch (IndexOutOfBoundsException arg) {
            // empty catch block
        }
        switch (nameOp.opcode) {
            case 81: {
                if (this.args.size() == 1) break;
                return;
            }
            case 82: {
                if (this.args.size() == 3) break;
                return;
            }
            case 83: {
                if (this.args.size() == 2) break;
                return;
            }
            default: {
                return;
            }
        }
        this.op = nameOp.opcode;
        ScriptBuilder addressBuilder = new ScriptBuilder();
        while (pc < chunks.size()) {
            addressBuilder.addChunk((ScriptChunk)chunks.get(pc));
            ++pc;
        }
        this.address = addressBuilder.build();
    }

    public boolean isNameOp() {
        switch (this.op) {
            case 81: 
            case 82: 
            case 83: {
                return true;
            }
            case 97: {
                return false;
            }
        }
        throw new ScriptException("Invalid name op");
    }

    public Script getAddress() {
        return this.address;
    }

    public boolean isAnyUpdate() {
        switch (this.op) {
            case 81: {
                return false;
            }
            case 82: 
            case 83: {
                return true;
            }
        }
        throw new ScriptException("Not a name op");
    }

    public ScriptChunk getOpName() {
        switch (this.op) {
            case 82: 
            case 83: {
                return this.args.get(0);
            }
        }
        throw new ScriptException("Not an AnyUpdate op");
    }

    public ScriptChunk getOpValue() {
        switch (this.op) {
            case 82: {
                return this.args.get(2);
            }
            case 83: {
                return this.args.get(1);
            }
        }
        throw new ScriptException("Not an AnyUpdate op");
    }
}

