/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#include <cstring>

#include "FB2Token.h"

using std::strlen;

namespace libebook
{
namespace
{

#include "FB2Token.inc"

}
}

namespace libebook
{

const EBOOKToken *getFB2Token(const char *const str, const unsigned length)
{
  return reinterpret_cast<const EBOOKToken *>(Perfect_Hash::in_word_set(str, length));
}

const EBOOKToken *getFB2Token(const char *const str)
{
  return getFB2Token(str, strlen(str));
}

const EBOOKToken *getFB2Token(const unsigned char *const str)
{
  return getFB2Token(reinterpret_cast<const char *>(str));
}

int getFB2TokenID(const EBOOKToken &token)
{
  return getFB2TokenID(&token);
}

int getFB2TokenID(const EBOOKToken *const token)
{
  return token ? token->id : INVALID_TOKEN;
}

int getFB2TokenID(const char *str, const unsigned length)
{
  return getFB2TokenID(getFB2Token(str, length));
}

int getFB2TokenID(const char *str)
{
  return getFB2TokenID(str, strlen(str));
}

int getFB2TokenID(const unsigned char *str)
{
  return getFB2TokenID(reinterpret_cast<const char *>(str));
}

const char *getFB2TokenName(const EBOOKToken &token)
{
  return getFB2TokenName(&token);
}

const char *getFB2TokenName(const EBOOKToken *const token)
{
  return token ? token->name : 0;
}

const char *getFB2TokenName(const char *str, const unsigned length)
{
  return getFB2TokenName(getFB2Token(str, length));
}

const char *getFB2TokenName(const char *str)
{
  return getFB2TokenName(str, strlen(str));
}

const char *getFB2TokenName(const unsigned char *str)
{
  return getFB2TokenName(reinterpret_cast<const char *>(str));
}

}

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
